/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwhisk.common;

import org.apache.openwhisk.common.LogMarkerToken;
import org.apache.openwhisk.common.LogMarkerToken$;
import org.apache.openwhisk.core.entity.ControllerInstanceId;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;

public final class LoggingMarkers$ {
    public static LoggingMarkers$ MODULE$;
    private final String start;
    private final String finish;
    private final String error;
    private final String count;
    private final String timeout;
    private final String controller;
    private final String invoker;
    private final String database;
    private final String activation;
    private final String kafka;
    private final String loadbalancer;
    private final String containerClient;
    private final LogMarkerToken CONTROLLER_ACTIVATION;
    private final LogMarkerToken CONTROLLER_ACTIVATION_BLOCKING;
    private final LogMarkerToken CONTROLLER_ACTIVATION_BLOCKING_DATABASE_RETRIEVAL;
    private final LogMarkerToken CONTROLLER_LOADBALANCER;
    private final LogMarkerToken CONTROLLER_KAFKA;
    private final LogMarkerToken SYSTEM_OVERLOAD;
    private final LogMarkerToken LOADBALANCER_ACTIVATION_START;
    private final LogMarkerToken INVOKER_ACTIVATION_RUN;
    private final LogMarkerToken INVOKER_ACTIVATION_INIT;
    private final LogMarkerToken INVOKER_COLLECT_LOGS;
    private final LogMarkerToken INVOKER_ACTIVATION;
    private final LogMarkerToken CONTAINER_CLIENT_RETRIES;
    private final LogMarkerToken DATABASE_CACHE_HIT;
    private final LogMarkerToken DATABASE_CACHE_MISS;
    private final LogMarkerToken DATABASE_SAVE;
    private final LogMarkerToken DATABASE_BULK_SAVE;
    private final LogMarkerToken DATABASE_DELETE;
    private final LogMarkerToken DATABASE_GET;
    private final LogMarkerToken DATABASE_QUERY;
    private final LogMarkerToken DATABASE_ATT_GET;
    private final LogMarkerToken DATABASE_ATT_SAVE;
    private final LogMarkerToken DATABASE_ATT_DELETE;
    private final LogMarkerToken DATABASE_ATTS_DELETE;
    private final LogMarkerToken DATABASE_BATCH_SIZE;

    static {
        new LoggingMarkers$();
    }

    public String start() {
        return this.start;
    }

    public String finish() {
        return this.finish;
    }

    public String error() {
        return this.error;
    }

    public String count() {
        return this.count;
    }

    public String timeout() {
        return this.timeout;
    }

    private String controller() {
        return this.controller;
    }

    private String invoker() {
        return this.invoker;
    }

    private String database() {
        return this.database;
    }

    private String activation() {
        return this.activation;
    }

    private String kafka() {
        return this.kafka;
    }

    private String loadbalancer() {
        return this.loadbalancer;
    }

    private String containerClient() {
        return this.containerClient;
    }

    public LogMarkerToken CONTROLLER_STARTUP(String id) {
        return new LogMarkerToken(this.controller(), new StringBuilder(7).append("startup").append(id).toString(), this.count(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
    }

    public LogMarkerToken CONTROLLER_ACTIVATION() {
        return this.CONTROLLER_ACTIVATION;
    }

    public LogMarkerToken CONTROLLER_ACTIVATION_BLOCKING() {
        return this.CONTROLLER_ACTIVATION_BLOCKING;
    }

    public LogMarkerToken CONTROLLER_ACTIVATION_BLOCKING_DATABASE_RETRIEVAL() {
        return this.CONTROLLER_ACTIVATION_BLOCKING_DATABASE_RETRIEVAL;
    }

    public LogMarkerToken CONTROLLER_LOADBALANCER() {
        return this.CONTROLLER_LOADBALANCER;
    }

    public LogMarkerToken CONTROLLER_KAFKA() {
        return this.CONTROLLER_KAFKA;
    }

    public LogMarkerToken SYSTEM_OVERLOAD() {
        return this.SYSTEM_OVERLOAD;
    }

    public LogMarkerToken INVOKER_STARTUP(int i) {
        return new LogMarkerToken(this.invoker(), new StringBuilder(7).append("startup").append(i).toString(), this.count(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
    }

    public LogMarkerToken LOADBALANCER_INVOKER_STATUS_CHANGE(String state) {
        return new LogMarkerToken(this.loadbalancer(), "invokerState", this.count(), (Option<String>)new Some((Object)state), LogMarkerToken$.MODULE$.apply$default$5());
    }

    public LogMarkerToken LOADBALANCER_ACTIVATION_START() {
        return this.LOADBALANCER_ACTIVATION_START;
    }

    public LogMarkerToken LOADBALANCER_ACTIVATIONS_INFLIGHT(ControllerInstanceId controllerInstance) {
        return new LogMarkerToken(new StringBuilder(0).append(this.loadbalancer()).append(controllerInstance.asString()).toString(), "activationsInflight", this.count(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
    }

    public LogMarkerToken LOADBALANCER_MEMORY_INFLIGHT(ControllerInstanceId controllerInstance) {
        return new LogMarkerToken(new StringBuilder(0).append(this.loadbalancer()).append(controllerInstance.asString()).toString(), "memoryInflight", this.count(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
    }

    public LogMarkerToken INVOKER_ACTIVATION_RUN() {
        return this.INVOKER_ACTIVATION_RUN;
    }

    public LogMarkerToken INVOKER_ACTIVATION_INIT() {
        return this.INVOKER_ACTIVATION_INIT;
    }

    public LogMarkerToken INVOKER_COLLECT_LOGS() {
        return this.INVOKER_COLLECT_LOGS;
    }

    public LogMarkerToken INVOKER_ACTIVATION() {
        return this.INVOKER_ACTIVATION;
    }

    public LogMarkerToken INVOKER_DOCKER_CMD(String cmd) {
        return new LogMarkerToken(this.invoker(), "docker", this.start(), (Option<String>)new Some((Object)cmd), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cmd"), (Object)cmd)}))));
    }

    public LogMarkerToken INVOKER_DOCKER_CMD_TIMEOUT(String cmd) {
        return new LogMarkerToken(this.invoker(), "docker", this.timeout(), (Option<String>)new Some((Object)cmd), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cmd"), (Object)cmd)}))));
    }

    public LogMarkerToken INVOKER_RUNC_CMD(String cmd) {
        return new LogMarkerToken(this.invoker(), "runc", this.start(), (Option<String>)new Some((Object)cmd), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cmd"), (Object)cmd)}))));
    }

    public LogMarkerToken INVOKER_KUBECTL_CMD(String cmd) {
        return new LogMarkerToken(this.invoker(), "kubectl", this.start(), (Option<String>)new Some((Object)cmd), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cmd"), (Object)cmd)}))));
    }

    public LogMarkerToken INVOKER_MESOS_CMD(String cmd) {
        return new LogMarkerToken(this.invoker(), "mesos", this.start(), (Option<String>)new Some((Object)cmd), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cmd"), (Object)cmd)}))));
    }

    public LogMarkerToken INVOKER_MESOS_CMD_TIMEOUT(String cmd) {
        return new LogMarkerToken(this.invoker(), "mesos", this.timeout(), (Option<String>)new Some((Object)cmd), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cmd"), (Object)cmd)}))));
    }

    public LogMarkerToken INVOKER_CONTAINER_START(String containerState) {
        return new LogMarkerToken(this.invoker(), "containerStart", this.count(), (Option<String>)new Some((Object)containerState), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"containerState"), (Object)containerState)}))));
    }

    public LogMarkerToken CONTAINER_CLIENT_RETRIES() {
        return this.CONTAINER_CLIENT_RETRIES;
    }

    public LogMarkerToken KAFKA_QUEUE(String topic) {
        return new LogMarkerToken(this.kafka(), topic, this.count(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
    }

    public LogMarkerToken KAFKA_MESSAGE_DELAY(String topic) {
        return new LogMarkerToken(this.kafka(), topic, this.start(), (Option<String>)new Some((Object)"delay"), LogMarkerToken$.MODULE$.apply$default$5());
    }

    public LogMarkerToken DATABASE_CACHE_HIT() {
        return this.DATABASE_CACHE_HIT;
    }

    public LogMarkerToken DATABASE_CACHE_MISS() {
        return this.DATABASE_CACHE_MISS;
    }

    public LogMarkerToken DATABASE_SAVE() {
        return this.DATABASE_SAVE;
    }

    public LogMarkerToken DATABASE_BULK_SAVE() {
        return this.DATABASE_BULK_SAVE;
    }

    public LogMarkerToken DATABASE_DELETE() {
        return this.DATABASE_DELETE;
    }

    public LogMarkerToken DATABASE_GET() {
        return this.DATABASE_GET;
    }

    public LogMarkerToken DATABASE_QUERY() {
        return this.DATABASE_QUERY;
    }

    public LogMarkerToken DATABASE_ATT_GET() {
        return this.DATABASE_ATT_GET;
    }

    public LogMarkerToken DATABASE_ATT_SAVE() {
        return this.DATABASE_ATT_SAVE;
    }

    public LogMarkerToken DATABASE_ATT_DELETE() {
        return this.DATABASE_ATT_DELETE;
    }

    public LogMarkerToken DATABASE_ATTS_DELETE() {
        return this.DATABASE_ATTS_DELETE;
    }

    public LogMarkerToken DATABASE_BATCH_SIZE() {
        return this.DATABASE_BATCH_SIZE;
    }

    private LoggingMarkers$() {
        MODULE$ = this;
        this.start = "start";
        this.finish = "finish";
        this.error = "error";
        this.count = "count";
        this.timeout = "timeout";
        this.controller = "controller";
        this.invoker = "invoker";
        this.database = "database";
        this.activation = "activation";
        this.kafka = "kafka";
        this.loadbalancer = "loadbalancer";
        this.containerClient = "containerClient";
        this.CONTROLLER_ACTIVATION = new LogMarkerToken(this.controller(), this.activation(), this.start(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.CONTROLLER_ACTIVATION_BLOCKING = new LogMarkerToken(this.controller(), "blockingActivation", this.start(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.CONTROLLER_ACTIVATION_BLOCKING_DATABASE_RETRIEVAL = new LogMarkerToken(this.controller(), "blockingActivationDatabaseRetrieval", this.count(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.CONTROLLER_LOADBALANCER = new LogMarkerToken(this.controller(), this.loadbalancer(), this.start(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.CONTROLLER_KAFKA = new LogMarkerToken(this.controller(), this.kafka(), this.start(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.SYSTEM_OVERLOAD = new LogMarkerToken(this.controller(), "systemOverload", this.count(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.LOADBALANCER_ACTIVATION_START = new LogMarkerToken(this.loadbalancer(), "activations", this.count(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.INVOKER_ACTIVATION_RUN = new LogMarkerToken(this.invoker(), "activationRun", this.start(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.INVOKER_ACTIVATION_INIT = new LogMarkerToken(this.invoker(), "activationInit", this.start(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.INVOKER_COLLECT_LOGS = new LogMarkerToken(this.invoker(), "collectLogs", this.start(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.INVOKER_ACTIVATION = new LogMarkerToken(this.invoker(), this.activation(), this.start(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.CONTAINER_CLIENT_RETRIES = new LogMarkerToken(this.containerClient(), "retries", this.count(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.DATABASE_CACHE_HIT = new LogMarkerToken(this.database(), "cacheHit", this.count(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.DATABASE_CACHE_MISS = new LogMarkerToken(this.database(), "cacheMiss", this.count(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.DATABASE_SAVE = new LogMarkerToken(this.database(), "saveDocument", this.start(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.DATABASE_BULK_SAVE = new LogMarkerToken(this.database(), "saveDocumentBulk", this.start(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.DATABASE_DELETE = new LogMarkerToken(this.database(), "deleteDocument", this.start(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.DATABASE_GET = new LogMarkerToken(this.database(), "getDocument", this.start(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.DATABASE_QUERY = new LogMarkerToken(this.database(), "queryView", this.start(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.DATABASE_ATT_GET = new LogMarkerToken(this.database(), "getDocumentAttachment", this.start(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.DATABASE_ATT_SAVE = new LogMarkerToken(this.database(), "saveDocumentAttachment", this.start(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.DATABASE_ATT_DELETE = new LogMarkerToken(this.database(), "deleteDocumentAttachment", this.start(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.DATABASE_ATTS_DELETE = new LogMarkerToken(this.database(), "deleteDocumentAttachments", this.start(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
        this.DATABASE_BATCH_SIZE = new LogMarkerToken(this.database(), "batchSize", this.count(), LogMarkerToken$.MODULE$.apply$default$4(), LogMarkerToken$.MODULE$.apply$default$5());
    }
}

