<x-app-layout>
    <div class="mx-auto my-16 max-w-7xl px-6 lg:px-8">
        <a
            href="{{ url()->previous() === request()->url() ? '/' : url()->previous() }}"
            class="-mt-10 mb-12 flex items-center dark:text-slate-400 text-slate-600 hover:underline z-50 relative"
            wire:navigate
        >
            <x-icons.chevron-left class="size-4" />
            <span>Back</span>
        </a>

        <div class="mt-6">
            <div class="prose prose-slate dark:prose-invert mx-auto max-w-4xl">
                <h1>Pinkary Brand</h1>
                <p><strong>Last Updated: 27 March 2024</strong></p>

                <h2>Pinkary logotype and icon</h2>
                <p>
                    Download vector and .png versions of our logotype and icon. Please respect our branding guidelines and do not alter the logo - we
                    like it the way it is.
                </p>

                <div class="mb-16 grid grid-cols-1 gap-4 sm:grid-cols-3 sm:gap-7">
                    <div class="relative flex items-center justify-center rounded-lg bg-slate-900 p-12">
                        <svg
                            class="h-24 sm:h-32"
                            xmlns="http://www.w3.org/2000/svg"
                            fill="none"
                            viewBox="0 0 643 212"
                        >
                            <path fill="#F8FAFC" d="M17.596 171.084c-4.24 0-8.268-1.131-12.084-3.392C1.83733 165.431 0 162.533 0 159c0-1.837.28267-3.816.848-5.936.70667-2.12 1.34267-4.099 1.908-5.936 4.38133-13.427 8.48-25.935 12.296-37.524 3.816-11.7307 7.632-22.9667 11.448-33.708 3.9573-10.8827 8.056-21.7653 12.296-32.648 4.3813-10.8827 9.2573-22.26 14.628-34.132-5.3707 1.1307-9.964 2.6147-13.78 4.452-3.816 1.696-6.9253 3.2507-9.328 4.664-2.4027 1.272-4.1693 1.908-5.3 1.908-.7067 0-1.7667-.4947-3.18-1.484-1.272-.9893-2.4027-2.12-3.392-3.392-.9893-1.272-1.484-2.4027-1.484-3.392 3.9573-1.696 8.5507-3.46267 13.78-5.3 5.3707-1.83733 11.1653-3.392 17.384-4.664C54.3427.636 60.5613 0 66.78 0c6.6427 0 13.4267.91867 20.352 2.756 6.9253 1.696 13.285 4.31066 19.08 7.844 5.936 3.392 10.671 7.7027 14.204 12.932 3.675 5.088 5.512 11.0947 5.512 18.02 0 7.4907-1.696 13.9213-5.088 19.292-3.392 5.3707-7.915 9.8933-13.568 13.568-5.512 3.6747-11.5187 6.6427-18.02 8.904-6.5013 2.2613-13.0027 3.9573-19.504 5.088-6.36 1.1307-12.084 1.908-17.172 2.332-5.088.424-8.904.636-11.448.636h-1.272c-3.9573 13.992-7.844 27.984-11.66 41.976-3.816 13.851-7.3493 26.429-10.6 37.736ZM41.764 84.8c7.9147-.5653 15.8293-1.908 23.744-4.028 7.9147-2.12 15.052-5.0173 21.412-8.692 6.5013-3.816 11.66-8.5507 15.476-14.204 3.957-5.6533 5.936-12.2253 5.936-19.716 0-7.0667-1.908-12.7907-5.724-17.172-3.6747-4.3813-8.48-7.7027-14.416-9.964-5.7947-2.26133-11.9427-3.46267-18.444-3.60401C64.66 17.3133 59.784 29.044 55.12 42.612 50.456 56.0387 46.004 70.1013 41.764 84.8Z" /><path fill="#F8FAFC" d="M123.412 159c-6.219 0-10.883-1.837-13.992-5.512-3.109-3.675-4.664-8.127-4.664-13.356 0-3.251.565-7.349 1.696-12.296 1.131-4.947 2.685-10.105 4.664-15.476 2.12-5.512 4.523-10.671 7.208-15.476 2.685-4.8053 5.583-8.692 8.692-11.66 3.109-3.1093 6.219-4.664 9.328-4.664 1.696 0 3.18.5653 4.452 1.696 1.272.9893 1.908 2.4733 1.908 4.452 0 1.8373-1.131 4.5933-3.392 8.268-2.12 3.6747-4.664 7.915-7.632 12.72-2.827 4.805-5.371 9.823-7.632 15.052-2.12 5.088-3.18 9.964-3.18 14.628 0 4.523.777 7.561 2.332 9.116 1.696 1.413 4.099 2.12 7.208 2.12 4.805 0 10.035-2.403 15.688-7.208 5.653-4.805 11.519-13.215 17.596-25.228l3.18 3.392c-4.947 12.437-11.236 22.119-18.868 29.044-7.632 6.925-15.829 10.388-24.592 10.388Zm25.016-95.612c-2.685 0-5.159-.636-7.42-1.908-2.12-1.4133-3.18-3.5333-3.18-6.36 0-3.392 1.837-6.2893 5.512-8.692 3.675-2.4027 7.491-3.604 11.448-3.604 2.544 0 4.664.5653 6.36 1.696 1.837 1.1307 2.756 3.18 2.756 6.148 0 2.968-1.625 5.8653-4.876 8.692-3.251 2.6853-6.784 4.028-10.6 4.028Z" /><path fill="#F8FAFC" d="M229.654 156.88c-5.512 0-9.752-1.413-12.72-4.24-2.827-2.685-4.24-6.148-4.24-10.388 0-2.827.495-5.795 1.484-8.904.989-3.251 1.979-6.501 2.968-9.752.989-3.251 1.484-6.36 1.484-9.328 0-3.109-.777-5.229-2.332-6.36-1.413-1.272-3.109-1.908-5.088-1.908-4.24 0-8.621 1.767-13.144 5.3-4.381 3.392-8.692 7.703-12.932 12.932-4.099 5.229-7.985 10.671-11.66 16.324-3.675 5.653-6.855 10.741-9.54 15.264-2.685 0-5.229-.495-7.632-1.484-2.403-.848-4.452-2.403-6.148-4.664.141-.707.989-2.827 2.544-6.36 1.413-3.675 3.039-7.985 4.876-12.932 1.837-5.088 3.463-10.388 4.876-15.9 1.413-5.512 2.12-10.529 2.12-15.052.989-1.1307 2.473-2.2613 4.452-3.392 2.12-1.1307 4.311-1.696 6.572-1.696 4.947 0 7.42 2.12 7.42 6.36 0 1.696-.353 4.24-1.06 7.632-.565 3.251-1.413 6.996-2.544 11.236 3.675-4.947 7.703-9.611 12.084-13.992 4.381-4.381 8.904-7.9147 13.568-10.6 4.805-2.8267 9.611-4.24 14.416-4.24 6.077 0 10.529 2.0493 13.356 6.148 2.968 4.099 4.452 8.621 4.452 13.568 0 4.24-.707 8.197-2.12 11.872-1.413 3.675-2.827 7.137-4.24 10.388-1.272 3.251-1.908 6.431-1.908 9.54 0 2.261.495 3.887 1.484 4.876 1.131.848 2.332 1.272 3.604 1.272 3.392 0 6.925-1.625 10.6-4.876 3.675-3.251 7.137-7.349 10.388-12.296 3.392-5.088 6.36-10.176 8.904-15.264l3.604 2.968c-2.968 6.925-6.36 13.285-10.176 19.08-3.675 5.653-7.844 10.247-12.508 13.78-4.523 3.392-9.611 5.088-15.264 5.088Z" /><path fill="#F8FAFC" d="M325.617 160.696c-4.381 0-8.197-1.413-11.448-4.24-3.251-2.827-5.865-6.36-7.844-10.6-1.979-4.24-3.463-8.551-4.452-12.932-.989-4.523-1.484-8.409-1.484-11.66 1.979-.424 4.452-1.06 7.42-1.908 2.968-.848 6.007-1.979 9.116-3.392 3.109-1.555 5.653-3.392 7.632-5.512 2.12-2.261 3.18-4.947 3.18-8.056 0-2.544-.848-4.5933-2.544-6.148-1.555-1.5547-3.816-2.332-6.784-2.332-3.957 0-7.703 1.3427-11.236 4.028-3.533 2.544-6.855 5.936-9.964 10.176-2.968 4.24-5.724 8.833-8.268 13.78-2.403 4.947-4.593 9.752-6.572 14.416-1.837 4.664-3.392 8.692-4.664 12.084-1.555 4.24-3.039 7.067-4.452 8.48-1.413 1.555-3.463 2.332-6.148 2.332-.989 0-2.191-.283-3.604-.848-1.272-.565-2.403-1.979-3.392-4.24-.848-2.261-1.272-5.865-1.272-10.812 0-8.621 1.201-18.091 3.604-28.408s5.583-20.776 9.54-31.376c4.099-10.7413 8.551-20.988 13.356-30.74 4.805-9.752 9.681-18.5147 14.628-26.288 4.947-7.7733 9.54-13.9213 13.78-18.444 4.381-4.52267 7.985-6.784 10.812-6.784 2.403 0 4.381 1.484 5.936 4.452 1.696 2.82667 2.544 6.5013 2.544 11.024 0 4.8053-1.06 10.176-3.18 16.112-2.12 5.7947-5.159 11.7307-9.116 17.808-3.816 5.936-8.409 11.5893-13.78 16.96-5.371 5.3707-11.307 9.964-17.808 13.78-3.957 9.1867-6.996 18.3027-9.116 27.348-2.12 8.904-3.463 16.819-4.028 23.744 2.544-5.795 5.441-11.731 8.692-17.808 3.251-6.077 6.855-11.731 10.812-16.96 3.957-5.3707 8.197-9.6813 12.72-12.932 4.664-3.2507 9.611-4.876 14.84-4.876 5.653 0 10.6 1.9787 14.84 5.936s6.36 8.904 6.36 14.84c0 4.24-1.131 7.915-3.392 11.024-2.261 3.109-5.088 5.724-8.48 7.844-3.251 1.979-6.572 3.463-9.964 4.452-3.392.989-6.289 1.555-8.692 1.696.424 1.837.989 4.169 1.696 6.996.848 2.827 1.908 5.583 3.18 8.268 1.272 2.685 2.897 4.947 4.876 6.784 1.979 1.837 4.311 2.756 6.996 2.756 3.533 0 7.137-1.625 10.812-4.876 3.816-3.251 7.491-7.561 11.024-12.932 3.675-5.371 6.925-11.307 9.752-17.808l2.968 3.604c-2.403 7.067-5.724 13.851-9.964 20.352-4.099 6.501-8.692 11.731-13.78 15.688-5.088 4.099-10.317 6.148-15.688 6.148Zm-30.316-93.704c3.816-3.392 7.844-7.5613 12.084-12.508 4.24-5.088 7.844-10.4587 10.812-16.112 3.109-5.7947 4.735-11.3067 4.876-16.536V21.2c-1.413.5653-3.675 3.0387-6.784 7.42-2.968 4.24-6.289 9.6813-9.964 16.324-3.675 6.6427-7.349 13.992-11.024 22.048Z" /><path fill="#F8FAFC" d="M368.211 162.604c-4.664 0-8.692-1.555-12.084-4.664-3.533-3.109-5.3-7.773-5.3-13.992 0-4.947 1.131-10.317 3.392-16.112 2.261-5.795 5.371-11.519 9.328-17.172 3.957-5.653 8.48-10.7413 13.568-15.264 5.088-4.664 10.529-8.4093 16.324-11.236 5.795-2.8267 11.589-4.24 17.384-4.24 6.077 0 11.236 1.5547 15.476 4.664 4.24 3.1093 6.36 7.208 6.36 12.296 0 3.816-1.343 6.572-4.028 8.268-2.685 1.696-5.865 2.191-9.54 1.484.283-1.272.495-2.544.636-3.816.283-1.272.424-2.615.424-4.028 0-2.8267-.565-5.3707-1.696-7.632-1.131-2.2613-3.533-3.392-7.208-3.392-3.957 0-7.985 1.3427-12.084 4.028-4.099 2.6853-8.056 6.2187-11.872 10.6-3.675 4.24-6.996 8.975-9.964 14.204-2.968 5.088-5.3 10.105-6.996 15.052-1.696 4.947-2.544 9.399-2.544 13.356 0 4.523 1.625 6.784 4.876 6.784 3.251 0 6.855-1.555 10.812-4.664 3.957-3.251 7.915-7.279 11.872-12.084 4.099-4.805 7.985-9.681 11.66-14.628 3.675-5.088 6.855-9.399 9.54-12.932.424-.707.989-1.06 1.696-1.06.565.141 1.625.495 3.18 1.06 1.696.424 3.251 1.131 4.664 2.12 1.413.989 2.12 2.261 2.12 3.816 0 1.413-.636 3.251-1.908 5.512-1.131 2.12-2.544 4.523-4.24 7.208-1.555 2.544-2.968 5.159-4.24 7.844-1.131 2.544-1.696 5.017-1.696 7.42 0 1.837.495 3.604 1.484 5.3.989 1.555 2.615 2.332 4.876 2.332 3.392 0 8.127-2.473 14.204-7.42 6.219-5.088 12.508-13.639 18.868-25.652l4.028 4.028c-3.392 7.632-7.491 14.416-12.296 20.352-4.664 5.795-9.611 10.317-14.84 13.568-5.229 3.392-10.529 5.088-15.9 5.088-5.795 0-10.105-1.837-12.932-5.512s-4.381-7.632-4.664-11.872v-1.06c-5.653 6.784-10.883 12.155-15.688 16.112-4.664 3.957-9.681 5.936-15.052 5.936Z" /><path fill="#F8FAFC" d="M489.758 158.152c-5.229 0-9.469-1.413-12.72-4.24-3.251-2.685-4.876-6.36-4.876-11.024 0-3.957.989-8.197 2.968-12.72 1.979-4.523 3.957-8.975 5.936-13.356 2.12-4.381 3.18-8.268 3.18-11.66 0-3.251-1.06-5.936-3.18-8.056-2.12-2.2613-4.593-4.0987-7.42-5.512-3.109 7.7733-6.643 15.335-10.6 22.684-3.816 7.208-6.925 12.861-9.328 16.96l-3.18-6.148c1.979-3.675 4.593-8.904 7.844-15.688 3.251-6.784 6.36-14.3453 9.328-22.684-1.413-1.4133-2.12-3.3213-2.12-5.724 0-3.6747 1.131-7.1373 3.392-10.388s4.452-4.876 6.572-4.876c1.696 0 2.897.9893 3.604 2.968.848 1.8373 1.272 3.1093 1.272 3.816 0 .7067-.353 1.9787-1.06 3.816-.565 1.8373-.989 3.18-1.272 4.028.141 1.5547 1.343 3.1093 3.604 4.664 2.403 1.4133 5.088 3.1093 8.056 5.088 2.968 1.9787 5.583 4.452 7.844 7.42s3.392 6.713 3.392 11.236c0 4.099-.919 8.268-2.756 12.508-1.837 4.24-3.675 8.197-5.512 11.872-1.837 3.675-2.756 6.855-2.756 9.54 0 1.979.495 3.321 1.484 4.028 1.131.565 2.403.848 3.816.848 3.392 0 6.925-.989 10.6-2.968 3.675-2.12 7.279-4.805 10.812-8.056 3.533-3.251 6.643-6.643 9.328-10.176 2.685-3.675 4.735-6.996 6.148-9.964l5.088 3.816c-2.685 6.077-6.572 12.084-11.66 18.02-5.088 5.795-10.741 10.6-16.96 14.416-6.219 3.675-12.508 5.512-18.868 5.512Z" /><path fill="#F8FAFC" d="M537.73 212c-3.534 0-6.855-1.131-9.964-3.392-2.968-2.12-4.452-5.583-4.452-10.388 0-4.523 1.342-8.621 4.028-12.296 2.685-3.533 6.148-6.855 10.388-9.964 4.24-2.968 8.762-5.724 13.568-8.268 4.946-2.403 9.681-4.664 14.204-6.784 1.554-4.099 3.25-9.257 5.088-15.476 1.978-6.36 3.674-12.225 5.088-17.596-4.382 6.077-9.046 11.448-13.992 16.112-4.947 4.664-10.459 6.996-16.536 6.996-2.544 0-5.23-.495-8.056-1.484-2.827-1.131-5.23-2.968-7.208-5.512-1.838-2.685-2.756-6.219-2.756-10.6 0-3.675.636-8.127 1.908-13.356 1.413-5.229 3.109-10.317 5.088-15.264 2.12-5.088 4.31-9.2573 6.572-12.508 2.261-3.392 4.24-5.088 5.936-5.088.848 0 2.049.3533 3.604 1.06 1.696.5653 3.321 1.4133 4.876 2.544 1.554.9893 2.544 2.12 2.968 3.392-1.272 1.696-2.686 4.1693-4.24 7.42-1.555 3.109-3.039 6.643-4.452 10.6-1.414 3.816-2.615 7.561-3.604 11.236-.848 3.675-1.272 6.855-1.272 9.54 0 2.12.424 3.957 1.272 5.512.848 1.555 2.473 2.332 4.876 2.332 3.109 0 6.289-1.272 9.54-3.816 3.392-2.544 6.642-5.795 9.752-9.752 3.25-3.957 6.148-7.985 8.692-12.084.282-.989.565-2.544.848-4.664.282-2.12.777-4.311 1.484-6.572.706-2.403 1.908-4.5933 3.604-6.572 1.837-1.9787 4.381-2.968 7.632-2.968 1.13 0 2.19.0707 3.18.212.989.1413 2.19.3533 3.604.636 0 2.12-.778 6.289-2.332 12.508-1.414 6.077-3.322 13.144-5.724 21.2-2.403 8.056-5.088 16.112-8.056 24.168 5.936-2.403 12.084-6.36 18.444-11.872 6.501-5.653 11.73-13.639 15.688-23.956l3.604 2.968c-2.12 7.067-5.371 13.215-9.752 18.444-4.24 5.229-9.046 9.681-14.416 13.356-5.371 3.675-10.812 6.713-16.324 9.116-3.816 9.187-7.986 17.667-12.508 25.44-4.382 7.773-9.046 13.921-13.992 18.444-4.947 4.664-10.247 6.996-15.9 6.996Zm-2.12-7.844c2.685 0 6.43-2.827 11.236-8.48 4.805-5.653 9.681-14.133 14.628-25.44-4.523 2.261-9.116 4.876-13.78 7.844-4.523 3.109-8.339 6.36-11.448 9.752-3.11 3.392-4.664 6.855-4.664 10.388 0 1.413.282 2.756.848 4.028.706 1.272 1.766 1.908 3.18 1.908Z" /><circle cx="631.146" cy="96.1079" r="11.7778" fill="#EC4899" />
                        </svg>

                        <a
                            href="{{ asset('/brand/pinkary-logo-white.zip') }}"
                            class="absolute -bottom-10 text-sm hover:no-underline"
                        >
                            Download Logo White (zip)
                        </a>
                    </div>

                    <div class="relative flex items-center justify-center rounded-lg bg-slate-200 p-12">
                        <svg
                            class="h-24 sm:h-32"
                            xmlns="http://www.w3.org/2000/svg"
                            fill="none"
                            viewBox="0 0 643 212"
                        >
                            <path fill="#0F172A" d="M17.596 171.084c-4.24 0-8.268-1.131-12.084-3.392C1.83733 165.431 0 162.533 0 159c0-1.837.28267-3.816.848-5.936.70667-2.12 1.34267-4.099 1.908-5.936 4.38133-13.427 8.48-25.935 12.296-37.524 3.816-11.7307 7.632-22.9667 11.448-33.708 3.9573-10.8827 8.056-21.7653 12.296-32.648 4.3813-10.8827 9.2573-22.26 14.628-34.132-5.3707 1.1307-9.964 2.6147-13.78 4.452-3.816 1.696-6.9253 3.2507-9.328 4.664-2.4027 1.272-4.1693 1.908-5.3 1.908-.7067 0-1.7667-.4947-3.18-1.484-1.272-.9893-2.4027-2.12-3.392-3.392-.9893-1.272-1.484-2.4027-1.484-3.392 3.9573-1.696 8.5507-3.46267 13.78-5.3 5.3707-1.83733 11.1653-3.392 17.384-4.664C54.3427.636 60.5613 0 66.78 0c6.6427 0 13.4267.91867 20.352 2.756 6.9253 1.696 13.285 4.31066 19.08 7.844 5.936 3.392 10.671 7.7027 14.204 12.932 3.675 5.088 5.512 11.0947 5.512 18.02 0 7.4907-1.696 13.9213-5.088 19.292-3.392 5.3707-7.915 9.8933-13.568 13.568-5.512 3.6747-11.5187 6.6427-18.02 8.904-6.5013 2.2613-13.0027 3.9573-19.504 5.088-6.36 1.1307-12.084 1.908-17.172 2.332-5.088.424-8.904.636-11.448.636h-1.272c-3.9573 13.992-7.844 27.984-11.66 41.976-3.816 13.851-7.3493 26.429-10.6 37.736ZM41.764 84.8c7.9147-.5653 15.8293-1.908 23.744-4.028 7.9147-2.12 15.052-5.0173 21.412-8.692 6.5013-3.816 11.66-8.5507 15.476-14.204 3.957-5.6533 5.936-12.2253 5.936-19.716 0-7.0667-1.908-12.7907-5.724-17.172-3.6747-4.3813-8.48-7.7027-14.416-9.964-5.7947-2.26133-11.9427-3.46267-18.444-3.60401C64.66 17.3133 59.784 29.044 55.12 42.612 50.456 56.0387 46.004 70.1013 41.764 84.8Z" /><path fill="#0F172A" d="M123.412 159c-6.219 0-10.883-1.837-13.992-5.512-3.109-3.675-4.664-8.127-4.664-13.356 0-3.251.565-7.349 1.696-12.296 1.131-4.947 2.685-10.105 4.664-15.476 2.12-5.512 4.523-10.671 7.208-15.476 2.685-4.8053 5.583-8.692 8.692-11.66 3.109-3.1093 6.219-4.664 9.328-4.664 1.696 0 3.18.5653 4.452 1.696 1.272.9893 1.908 2.4733 1.908 4.452 0 1.8373-1.131 4.5933-3.392 8.268-2.12 3.6747-4.664 7.915-7.632 12.72-2.827 4.805-5.371 9.823-7.632 15.052-2.12 5.088-3.18 9.964-3.18 14.628 0 4.523.777 7.561 2.332 9.116 1.696 1.413 4.099 2.12 7.208 2.12 4.805 0 10.035-2.403 15.688-7.208 5.653-4.805 11.519-13.215 17.596-25.228l3.18 3.392c-4.947 12.437-11.236 22.119-18.868 29.044-7.632 6.925-15.829 10.388-24.592 10.388Zm25.016-95.612c-2.685 0-5.159-.636-7.42-1.908-2.12-1.4133-3.18-3.5333-3.18-6.36 0-3.392 1.837-6.2893 5.512-8.692 3.675-2.4027 7.491-3.604 11.448-3.604 2.544 0 4.664.5653 6.36 1.696 1.837 1.1307 2.756 3.18 2.756 6.148 0 2.968-1.625 5.8653-4.876 8.692-3.251 2.6853-6.784 4.028-10.6 4.028Z" /><path fill="#0F172A" d="M229.654 156.88c-5.512 0-9.752-1.413-12.72-4.24-2.827-2.685-4.24-6.148-4.24-10.388 0-2.827.495-5.795 1.484-8.904.989-3.251 1.979-6.501 2.968-9.752.989-3.251 1.484-6.36 1.484-9.328 0-3.109-.777-5.229-2.332-6.36-1.413-1.272-3.109-1.908-5.088-1.908-4.24 0-8.621 1.767-13.144 5.3-4.381 3.392-8.692 7.703-12.932 12.932-4.099 5.229-7.985 10.671-11.66 16.324-3.675 5.653-6.855 10.741-9.54 15.264-2.685 0-5.229-.495-7.632-1.484-2.403-.848-4.452-2.403-6.148-4.664.141-.707.989-2.827 2.544-6.36 1.413-3.675 3.039-7.985 4.876-12.932 1.837-5.088 3.463-10.388 4.876-15.9 1.413-5.512 2.12-10.529 2.12-15.052.989-1.1307 2.473-2.2613 4.452-3.392 2.12-1.1307 4.311-1.696 6.572-1.696 4.947 0 7.42 2.12 7.42 6.36 0 1.696-.353 4.24-1.06 7.632-.565 3.251-1.413 6.996-2.544 11.236 3.675-4.947 7.703-9.611 12.084-13.992 4.381-4.381 8.904-7.9147 13.568-10.6 4.805-2.8267 9.611-4.24 14.416-4.24 6.077 0 10.529 2.0493 13.356 6.148 2.968 4.099 4.452 8.621 4.452 13.568 0 4.24-.707 8.197-2.12 11.872-1.413 3.675-2.827 7.137-4.24 10.388-1.272 3.251-1.908 6.431-1.908 9.54 0 2.261.495 3.887 1.484 4.876 1.131.848 2.332 1.272 3.604 1.272 3.392 0 6.925-1.625 10.6-4.876 3.675-3.251 7.137-7.349 10.388-12.296 3.392-5.088 6.36-10.176 8.904-15.264l3.604 2.968c-2.968 6.925-6.36 13.285-10.176 19.08-3.675 5.653-7.844 10.247-12.508 13.78-4.523 3.392-9.611 5.088-15.264 5.088Z" /><path fill="#0F172A" d="M325.617 160.696c-4.381 0-8.197-1.413-11.448-4.24-3.251-2.827-5.865-6.36-7.844-10.6-1.979-4.24-3.463-8.551-4.452-12.932-.989-4.523-1.484-8.409-1.484-11.66 1.979-.424 4.452-1.06 7.42-1.908 2.968-.848 6.007-1.979 9.116-3.392 3.109-1.555 5.653-3.392 7.632-5.512 2.12-2.261 3.18-4.947 3.18-8.056 0-2.544-.848-4.5933-2.544-6.148-1.555-1.5547-3.816-2.332-6.784-2.332-3.957 0-7.703 1.3427-11.236 4.028-3.533 2.544-6.855 5.936-9.964 10.176-2.968 4.24-5.724 8.833-8.268 13.78-2.403 4.947-4.593 9.752-6.572 14.416-1.837 4.664-3.392 8.692-4.664 12.084-1.555 4.24-3.039 7.067-4.452 8.48-1.413 1.555-3.463 2.332-6.148 2.332-.989 0-2.191-.283-3.604-.848-1.272-.565-2.403-1.979-3.392-4.24-.848-2.261-1.272-5.865-1.272-10.812 0-8.621 1.201-18.091 3.604-28.408s5.583-20.776 9.54-31.376c4.099-10.7413 8.551-20.988 13.356-30.74 4.805-9.752 9.681-18.5147 14.628-26.288 4.947-7.7733 9.54-13.9213 13.78-18.444 4.381-4.52267 7.985-6.784 10.812-6.784 2.403 0 4.381 1.484 5.936 4.452 1.696 2.82667 2.544 6.5013 2.544 11.024 0 4.8053-1.06 10.176-3.18 16.112-2.12 5.7947-5.159 11.7307-9.116 17.808-3.816 5.936-8.409 11.5893-13.78 16.96-5.371 5.3707-11.307 9.964-17.808 13.78-3.957 9.1867-6.996 18.3027-9.116 27.348-2.12 8.904-3.463 16.819-4.028 23.744 2.544-5.795 5.441-11.731 8.692-17.808 3.251-6.077 6.855-11.731 10.812-16.96 3.957-5.3707 8.197-9.6813 12.72-12.932 4.664-3.2507 9.611-4.876 14.84-4.876 5.653 0 10.6 1.9787 14.84 5.936s6.36 8.904 6.36 14.84c0 4.24-1.131 7.915-3.392 11.024-2.261 3.109-5.088 5.724-8.48 7.844-3.251 1.979-6.572 3.463-9.964 4.452-3.392.989-6.289 1.555-8.692 1.696.424 1.837.989 4.169 1.696 6.996.848 2.827 1.908 5.583 3.18 8.268 1.272 2.685 2.897 4.947 4.876 6.784 1.979 1.837 4.311 2.756 6.996 2.756 3.533 0 7.137-1.625 10.812-4.876 3.816-3.251 7.491-7.561 11.024-12.932 3.675-5.371 6.925-11.307 9.752-17.808l2.968 3.604c-2.403 7.067-5.724 13.851-9.964 20.352-4.099 6.501-8.692 11.731-13.78 15.688-5.088 4.099-10.317 6.148-15.688 6.148Zm-30.316-93.704c3.816-3.392 7.844-7.5613 12.084-12.508 4.24-5.088 7.844-10.4587 10.812-16.112 3.109-5.7947 4.735-11.3067 4.876-16.536V21.2c-1.413.5653-3.675 3.0387-6.784 7.42-2.968 4.24-6.289 9.6813-9.964 16.324-3.675 6.6427-7.349 13.992-11.024 22.048Z" /><path fill="#0F172A" d="M368.211 162.604c-4.664 0-8.692-1.555-12.084-4.664-3.533-3.109-5.3-7.773-5.3-13.992 0-4.947 1.131-10.317 3.392-16.112 2.261-5.795 5.371-11.519 9.328-17.172 3.957-5.653 8.48-10.7413 13.568-15.264 5.088-4.664 10.529-8.4093 16.324-11.236 5.795-2.8267 11.589-4.24 17.384-4.24 6.077 0 11.236 1.5547 15.476 4.664 4.24 3.1093 6.36 7.208 6.36 12.296 0 3.816-1.343 6.572-4.028 8.268-2.685 1.696-5.865 2.191-9.54 1.484.283-1.272.495-2.544.636-3.816.283-1.272.424-2.615.424-4.028 0-2.8267-.565-5.3707-1.696-7.632-1.131-2.2613-3.533-3.392-7.208-3.392-3.957 0-7.985 1.3427-12.084 4.028-4.099 2.6853-8.056 6.2187-11.872 10.6-3.675 4.24-6.996 8.975-9.964 14.204-2.968 5.088-5.3 10.105-6.996 15.052-1.696 4.947-2.544 9.399-2.544 13.356 0 4.523 1.625 6.784 4.876 6.784 3.251 0 6.855-1.555 10.812-4.664 3.957-3.251 7.915-7.279 11.872-12.084 4.099-4.805 7.985-9.681 11.66-14.628 3.675-5.088 6.855-9.399 9.54-12.932.424-.707.989-1.06 1.696-1.06.565.141 1.625.495 3.18 1.06 1.696.424 3.251 1.131 4.664 2.12 1.413.989 2.12 2.261 2.12 3.816 0 1.413-.636 3.251-1.908 5.512-1.131 2.12-2.544 4.523-4.24 7.208-1.555 2.544-2.968 5.159-4.24 7.844-1.131 2.544-1.696 5.017-1.696 7.42 0 1.837.495 3.604 1.484 5.3.989 1.555 2.615 2.332 4.876 2.332 3.392 0 8.127-2.473 14.204-7.42 6.219-5.088 12.508-13.639 18.868-25.652l4.028 4.028c-3.392 7.632-7.491 14.416-12.296 20.352-4.664 5.795-9.611 10.317-14.84 13.568-5.229 3.392-10.529 5.088-15.9 5.088-5.795 0-10.105-1.837-12.932-5.512s-4.381-7.632-4.664-11.872v-1.06c-5.653 6.784-10.883 12.155-15.688 16.112-4.664 3.957-9.681 5.936-15.052 5.936Z" /><path fill="#0F172A" d="M489.758 158.152c-5.229 0-9.469-1.413-12.72-4.24-3.251-2.685-4.876-6.36-4.876-11.024 0-3.957.989-8.197 2.968-12.72 1.979-4.523 3.957-8.975 5.936-13.356 2.12-4.381 3.18-8.268 3.18-11.66 0-3.251-1.06-5.936-3.18-8.056-2.12-2.2613-4.593-4.0987-7.42-5.512-3.109 7.7733-6.643 15.335-10.6 22.684-3.816 7.208-6.925 12.861-9.328 16.96l-3.18-6.148c1.979-3.675 4.593-8.904 7.844-15.688 3.251-6.784 6.36-14.3453 9.328-22.684-1.413-1.4133-2.12-3.3213-2.12-5.724 0-3.6747 1.131-7.1373 3.392-10.388s4.452-4.876 6.572-4.876c1.696 0 2.897.9893 3.604 2.968.848 1.8373 1.272 3.1093 1.272 3.816 0 .7067-.353 1.9787-1.06 3.816-.565 1.8373-.989 3.18-1.272 4.028.141 1.5547 1.343 3.1093 3.604 4.664 2.403 1.4133 5.088 3.1093 8.056 5.088 2.968 1.9787 5.583 4.452 7.844 7.42s3.392 6.713 3.392 11.236c0 4.099-.919 8.268-2.756 12.508-1.837 4.24-3.675 8.197-5.512 11.872-1.837 3.675-2.756 6.855-2.756 9.54 0 1.979.495 3.321 1.484 4.028 1.131.565 2.403.848 3.816.848 3.392 0 6.925-.989 10.6-2.968 3.675-2.12 7.279-4.805 10.812-8.056 3.533-3.251 6.643-6.643 9.328-10.176 2.685-3.675 4.735-6.996 6.148-9.964l5.088 3.816c-2.685 6.077-6.572 12.084-11.66 18.02-5.088 5.795-10.741 10.6-16.96 14.416-6.219 3.675-12.508 5.512-18.868 5.512Z" /><path fill="#0F172A" d="M537.73 212c-3.534 0-6.855-1.131-9.964-3.392-2.968-2.12-4.452-5.583-4.452-10.388 0-4.523 1.342-8.621 4.028-12.296 2.685-3.533 6.148-6.855 10.388-9.964 4.24-2.968 8.762-5.724 13.568-8.268 4.946-2.403 9.681-4.664 14.204-6.784 1.554-4.099 3.25-9.257 5.088-15.476 1.978-6.36 3.674-12.225 5.088-17.596-4.382 6.077-9.046 11.448-13.992 16.112-4.947 4.664-10.459 6.996-16.536 6.996-2.544 0-5.23-.495-8.056-1.484-2.827-1.131-5.23-2.968-7.208-5.512-1.838-2.685-2.756-6.219-2.756-10.6 0-3.675.636-8.127 1.908-13.356 1.413-5.229 3.109-10.317 5.088-15.264 2.12-5.088 4.31-9.2573 6.572-12.508 2.261-3.392 4.24-5.088 5.936-5.088.848 0 2.049.3533 3.604 1.06 1.696.5653 3.321 1.4133 4.876 2.544 1.554.9893 2.544 2.12 2.968 3.392-1.272 1.696-2.686 4.1693-4.24 7.42-1.555 3.109-3.039 6.643-4.452 10.6-1.414 3.816-2.615 7.561-3.604 11.236-.848 3.675-1.272 6.855-1.272 9.54 0 2.12.424 3.957 1.272 5.512.848 1.555 2.473 2.332 4.876 2.332 3.109 0 6.289-1.272 9.54-3.816 3.392-2.544 6.642-5.795 9.752-9.752 3.25-3.957 6.148-7.985 8.692-12.084.282-.989.565-2.544.848-4.664.282-2.12.777-4.311 1.484-6.572.706-2.403 1.908-4.5933 3.604-6.572 1.837-1.9787 4.381-2.968 7.632-2.968 1.13 0 2.19.0707 3.18.212.989.1413 2.19.3533 3.604.636 0 2.12-.778 6.289-2.332 12.508-1.414 6.077-3.322 13.144-5.724 21.2-2.403 8.056-5.088 16.112-8.056 24.168 5.936-2.403 12.084-6.36 18.444-11.872 6.501-5.653 11.73-13.639 15.688-23.956l3.604 2.968c-2.12 7.067-5.371 13.215-9.752 18.444-4.24 5.229-9.046 9.681-14.416 13.356-5.371 3.675-10.812 6.713-16.324 9.116-3.816 9.187-7.986 17.667-12.508 25.44-4.382 7.773-9.046 13.921-13.992 18.444-4.947 4.664-10.247 6.996-15.9 6.996Zm-2.12-7.844c2.685 0 6.43-2.827 11.236-8.48 4.805-5.653 9.681-14.133 14.628-25.44-4.523 2.261-9.116 4.876-13.78 7.844-4.523 3.109-8.339 6.36-11.448 9.752-3.11 3.392-4.664 6.855-4.664 10.388 0 1.413.282 2.756.848 4.028.706 1.272 1.766 1.908 3.18 1.908Z" /><circle cx="631.146" cy="96.1079" r="11.7778" fill="#EC4899" />
                        </svg>

                        <a
                            href="{{ asset('/brand/pinkary-logo-black.zip') }}"
                            class="absolute -bottom-10 text-sm hover:no-underline"
                        >
                            Download Logo Black (zip)
                        </a>
                    </div>

                    <div class="relative flex items-center justify-center rounded-lg bg-slate-600 p-12">
                        <svg
                            class="h-32 sm:h-36"
                            xmlns="http://www.w3.org/2000/svg"
                            fill="none"
                            viewBox="0 0 1024 1024"
                        >
                            <circle cx="512" cy="512" r="512" fill="#EC4899" /><path fill="#0F172A" fill-rule="evenodd" d="M375.022 782.938h10.563l2.919-10.151c9.696-33.725 20.23-71.23 31.603-112.51l.01-.035c10.434-38.258 21.046-76.516 31.835-114.774 7.487-.249 16.987-.865 28.389-1.815 15.669-1.306 33.143-3.686 52.389-7.107 20.132-3.502 40.219-8.747 60.257-15.717 20.408-7.098 39.342-16.44 56.761-28.044 18.391-11.967 33.313-26.841 44.545-44.625 11.752-18.608 17.317-40.46 17.317-64.932 0-23.171-6.18-43.941-18.939-61.689-11.772-17.361-27.425-31.528-46.66-42.551-18.462-11.233-38.646-19.509-60.477-24.869-21.658-5.735-43.023-8.64-64.066-8.64-19.479 0-38.937 1.992-58.359 5.965-19.035 3.894-36.872 8.673-53.491 14.358l-.055.019-.054.019c-15.787 5.547-29.767 10.919-41.906 16.122l-8.502 3.643v9.25c0 7.489 3.624 13.891 7.374 18.712 3.66 4.706 7.853 8.899 12.56 12.56l.279.217.289.202c2.489 1.743 5.061 3.333 7.635 4.534 2.37 1.106 5.857 2.42 9.877 2.42 4.023 0 7.937-1.066 11.222-2.249 3.46-1.246 7.195-2.983 11.122-5.062l.278-.147.271-.159c6.532-3.843 15.269-8.231 26.36-13.16l.195-.087.193-.092c3.075-1.481 6.377-2.892 9.912-4.228-11.315 25.702-21.827 50.61-31.535 74.723l-.029.073-.029.073c-12.663 32.502-24.904 65.004-36.724 97.509l-.018.048-.017.049c-11.405 32.103-22.805 65.671-34.2 100.7-11.365 34.514-23.57 71.761-36.615 111.739l-.037.113-.035.113c-1.647 5.352-3.507 11.139-5.582 17.364l-.135.407-.111.415c-1.939 7.27-2.998 14.389-2.998 21.289 0 16.522 9.061 29.195 23.087 37.827l.1.061.101.06c13.422 7.954 27.872 12.059 43.131 12.059Zm240.867-358.953c-10.064 14.908-23.79 27.609-41.514 38.019-17.749 10.249-37.827 18.426-60.323 24.452-15.943 4.27-31.862 7.436-47.761 9.505 10.793-36.359 22.03-71.35 33.71-104.974l.015-.043c12.469-36.274 25.384-67.881 38.715-94.892 14.546 1.119 28.325 4.246 41.392 9.346l.053.02.053.02c15.692 5.978 27.931 14.559 37.17 25.574l.084.1.086.099c8.682 9.968 13.594 23.498 13.594 41.917 0 19.684-5.149 36.389-15.139 50.66l-.069.098-.066.099Z" clip-rule="evenodd" /><path fill="#FDF2F8" d="M560.932 743.369c0 23.196-18.804 42-42 42s-42-18.804-42-42 18.804-42 42-42 42 18.804 42 42Z" />
                        </svg>

                        <a
                            href="{{ asset('/brand/pinkary-icon.zip') }}"
                            class="absolute -bottom-10 text-sm hover:no-underline"
                        >
                            Download Icon (zip)
                        </a>
                    </div>
                </div>

                <p>
                    If you have any questions or need help, please feel free to contact us at <a href="mailto:team@pinkary.com">team@pinkary.com</a> .
                </p>
            </div>
        </div>
    </div>
</x-app-layout>
