/* tslint:disable */
/* eslint-disable */
/**
 * Pinecone Inference API
 * Pinecone is a vector database that makes it easy to search and retrieve billions of high-dimensional vectors.
 *
 * The version of the OpenAPI document: 2024-10
 * Contact: support@pinecone.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  EmbedRequest,
  EmbeddingsList,
  ErrorResponse,
  RerankRequest,
  RerankResult,
} from '../models/index';
import {
    EmbedRequestFromJSON,
    EmbedRequestToJSON,
    EmbeddingsListFromJSON,
    EmbeddingsListToJSON,
    ErrorResponseFromJSON,
    ErrorResponseToJSON,
    RerankRequestFromJSON,
    RerankRequestToJSON,
    RerankResultFromJSON,
    RerankResultToJSON,
} from '../models/index';

export interface EmbedOperationRequest {
    embedRequest?: EmbedRequest;
}

export interface RerankOperationRequest {
    rerankRequest?: RerankRequest;
}

/**
 * 
 */
export class InferenceApi extends runtime.BaseAPI {

    /**
     * Generate embeddings for input data.  For guidance and examples, see [Generate embeddings](https://docs.pinecone.io/guides/inference/generate-embeddings).
     * Embed data
     */
    async embedRaw(requestParameters: EmbedOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<EmbeddingsList>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["Api-Key"] = this.configuration.apiKey("Api-Key"); // ApiKeyAuth authentication
        }

        const response = await this.request({
            path: `/embed`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: EmbedRequestToJSON(requestParameters.embedRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => EmbeddingsListFromJSON(jsonValue));
    }

    /**
     * Generate embeddings for input data.  For guidance and examples, see [Generate embeddings](https://docs.pinecone.io/guides/inference/generate-embeddings).
     * Embed data
     */
    async embed(requestParameters: EmbedOperationRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<EmbeddingsList> {
        const response = await this.embedRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Rerank documents according to their relevance to a query.  For guidance and examples, see [Rerank documents](https://docs.pinecone.io/guides/inference/rerank).
     * Rerank documents
     */
    async rerankRaw(requestParameters: RerankOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RerankResult>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["Api-Key"] = this.configuration.apiKey("Api-Key"); // ApiKeyAuth authentication
        }

        const response = await this.request({
            path: `/rerank`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: RerankRequestToJSON(requestParameters.rerankRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => RerankResultFromJSON(jsonValue));
    }

    /**
     * Rerank documents according to their relevance to a query.  For guidance and examples, see [Rerank documents](https://docs.pinecone.io/guides/inference/rerank).
     * Rerank documents
     */
    async rerank(requestParameters: RerankOperationRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RerankResult> {
        const response = await this.rerankRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
