/* tslint:disable */
/* eslint-disable */
/**
 * Pinecone Data Plane API
 * Pinecone is a vector database that makes it easy to search and retrieve billions of high-dimensional vectors.
 *
 * The version of the OpenAPI document: 2024-10
 * Contact: support@pinecone.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { exists, mapValues } from '../runtime';
import type { ImportErrorMode } from './ImportErrorMode';
import {
    ImportErrorModeFromJSON,
    ImportErrorModeFromJSONTyped,
    ImportErrorModeToJSON,
} from './ImportErrorMode';

/**
 * The request for the `start_import` operation.
 * @export
 * @interface StartImportRequest
 */
export interface StartImportRequest {
    /**
     * The id of the [storage integration](https://docs.pinecone.io/guides/operations/integrations/manage-storage-integrations) that should be used to access the data.
     * @type {string}
     * @memberof StartImportRequest
     */
    integrationId?: string;
    /**
     * The [URI prefix](https://docs.pinecone.io/guides/data/understanding-imports#directory-structure) under which the data to import is available. All data within this prefix will be listed then imported into the target index. Currently only `s3://` URIs are supported.
     * @type {string}
     * @memberof StartImportRequest
     */
    uri: string;
    /**
     * 
     * @type {ImportErrorMode}
     * @memberof StartImportRequest
     */
    errorMode?: ImportErrorMode;
}

/**
 * Check if a given object implements the StartImportRequest interface.
 */
export function instanceOfStartImportRequest(value: object): boolean {
    let isInstance = true;
    isInstance = isInstance && "uri" in value;

    return isInstance;
}

export function StartImportRequestFromJSON(json: any): StartImportRequest {
    return StartImportRequestFromJSONTyped(json, false);
}

export function StartImportRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): StartImportRequest {
    if ((json === undefined) || (json === null)) {
        return json;
    }
    return {
        
        'integrationId': !exists(json, 'integrationId') ? undefined : json['integrationId'],
        'uri': json['uri'],
        'errorMode': !exists(json, 'errorMode') ? undefined : ImportErrorModeFromJSON(json['errorMode']),
    };
}

export function StartImportRequestToJSON(value?: StartImportRequest | null): any {
    if (value === undefined) {
        return undefined;
    }
    if (value === null) {
        return null;
    }
    return {
        
        'integrationId': value.integrationId,
        'uri': value.uri,
        'errorMode': ImportErrorModeToJSON(value.errorMode),
    };
}

