/* tslint:disable */
/* eslint-disable */
/**
 * Pinecone Data Plane API
 * Pinecone is a vector database that makes it easy to search and retrieve billions of high-dimensional vectors.
 *
 * The version of the OpenAPI document: 2024-10
 * Contact: support@pinecone.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  DeleteRequest,
  DescribeIndexStatsRequest,
  FetchResponse,
  IndexDescription,
  ListResponse,
  QueryRequest,
  QueryResponse,
  RpcStatus,
  UpdateRequest,
  UpsertRequest,
  UpsertResponse,
} from '../models/index';
import {
    DeleteRequestFromJSON,
    DeleteRequestToJSON,
    DescribeIndexStatsRequestFromJSON,
    DescribeIndexStatsRequestToJSON,
    FetchResponseFromJSON,
    FetchResponseToJSON,
    IndexDescriptionFromJSON,
    IndexDescriptionToJSON,
    ListResponseFromJSON,
    ListResponseToJSON,
    QueryRequestFromJSON,
    QueryRequestToJSON,
    QueryResponseFromJSON,
    QueryResponseToJSON,
    RpcStatusFromJSON,
    RpcStatusToJSON,
    UpdateRequestFromJSON,
    UpdateRequestToJSON,
    UpsertRequestFromJSON,
    UpsertRequestToJSON,
    UpsertResponseFromJSON,
    UpsertResponseToJSON,
} from '../models/index';

export interface DeleteVectorsRequest {
    deleteRequest: DeleteRequest;
}

export interface DescribeIndexStatsOperationRequest {
    describeIndexStatsRequest: DescribeIndexStatsRequest;
}

export interface FetchVectorsRequest {
    ids: Array<string>;
    namespace?: string;
}

export interface ListVectorsRequest {
    prefix?: string;
    limit?: number;
    paginationToken?: string;
    namespace?: string;
}

export interface QueryVectorsRequest {
    queryRequest: QueryRequest;
}

export interface UpdateVectorRequest {
    updateRequest: UpdateRequest;
}

export interface UpsertVectorsRequest {
    upsertRequest: UpsertRequest;
}

/**
 * 
 */
export class VectorOperationsApi extends runtime.BaseAPI {

    /**
     * The `delete` operation deletes vectors, by id, from a single namespace.  For guidance and examples, see [Delete data](https://docs.pinecone.io/guides/data/delete-data).
     * Delete vectors
     */
    async deleteVectorsRaw(requestParameters: DeleteVectorsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<object>> {
        if (requestParameters.deleteRequest === null || requestParameters.deleteRequest === undefined) {
            throw new runtime.RequiredError('deleteRequest','Required parameter requestParameters.deleteRequest was null or undefined when calling deleteVectors.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["Api-Key"] = this.configuration.apiKey("Api-Key"); // ApiKeyAuth authentication
        }

        const response = await this.request({
            path: `/vectors/delete`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: DeleteRequestToJSON(requestParameters.deleteRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse<any>(response);
    }

    /**
     * The `delete` operation deletes vectors, by id, from a single namespace.  For guidance and examples, see [Delete data](https://docs.pinecone.io/guides/data/delete-data).
     * Delete vectors
     */
    async deleteVectors(requestParameters: DeleteVectorsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<object> {
        const response = await this.deleteVectorsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * The `describe_index_stats` operation returns statistics about the contents of an index, including the vector count per namespace, the number of dimensions, and the index fullness.  Serverless indexes scale automatically as needed, so index fullness is relevant only for pod-based indexes.
     * Get index stats
     */
    async describeIndexStatsRaw(requestParameters: DescribeIndexStatsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<IndexDescription>> {
        if (requestParameters.describeIndexStatsRequest === null || requestParameters.describeIndexStatsRequest === undefined) {
            throw new runtime.RequiredError('describeIndexStatsRequest','Required parameter requestParameters.describeIndexStatsRequest was null or undefined when calling describeIndexStats.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["Api-Key"] = this.configuration.apiKey("Api-Key"); // ApiKeyAuth authentication
        }

        const response = await this.request({
            path: `/describe_index_stats`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: DescribeIndexStatsRequestToJSON(requestParameters.describeIndexStatsRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => IndexDescriptionFromJSON(jsonValue));
    }

    /**
     * The `describe_index_stats` operation returns statistics about the contents of an index, including the vector count per namespace, the number of dimensions, and the index fullness.  Serverless indexes scale automatically as needed, so index fullness is relevant only for pod-based indexes.
     * Get index stats
     */
    async describeIndexStats(requestParameters: DescribeIndexStatsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<IndexDescription> {
        const response = await this.describeIndexStatsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * The `fetch` operation looks up and returns vectors, by ID, from a single namespace. The returned vectors include the vector data and/or metadata.  For guidance and examples, see [Fetch data](https://docs.pinecone.io/guides/data/fetch-data).
     * Fetch vectors
     */
    async fetchVectorsRaw(requestParameters: FetchVectorsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<FetchResponse>> {
        if (requestParameters.ids === null || requestParameters.ids === undefined) {
            throw new runtime.RequiredError('ids','Required parameter requestParameters.ids was null or undefined when calling fetchVectors.');
        }

        const queryParameters: any = {};

        if (requestParameters.ids) {
            queryParameters['ids'] = requestParameters.ids;
        }

        if (requestParameters.namespace !== undefined) {
            queryParameters['namespace'] = requestParameters.namespace;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["Api-Key"] = this.configuration.apiKey("Api-Key"); // ApiKeyAuth authentication
        }

        const response = await this.request({
            path: `/vectors/fetch`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => FetchResponseFromJSON(jsonValue));
    }

    /**
     * The `fetch` operation looks up and returns vectors, by ID, from a single namespace. The returned vectors include the vector data and/or metadata.  For guidance and examples, see [Fetch data](https://docs.pinecone.io/guides/data/fetch-data).
     * Fetch vectors
     */
    async fetchVectors(requestParameters: FetchVectorsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<FetchResponse> {
        const response = await this.fetchVectorsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * The `list` operation lists the IDs of vectors in a single namespace of a serverless index. An optional prefix can be passed to limit the results to IDs with a common prefix.  By default, `list` returns up to 100 IDs per page in sorted order (bitwise \"C\" collation). If the `limit` parameter is set, `list` returns up to that number of IDs instead. Whenever there are additional IDs to return, the response also includes a `pagination_token` that you can use to get the next batch of IDs. When the response does not include a `pagination_token`, there are no more IDs to return.  For guidance and examples, see [List record IDs](https://docs.pinecone.io/guides/data/list-record-ids).  **Note:** `list_vectors` is supported only for serverless indexes.
     * List vector IDs
     */
    async listVectorsRaw(requestParameters: ListVectorsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ListResponse>> {
        const queryParameters: any = {};

        if (requestParameters.prefix !== undefined) {
            queryParameters['prefix'] = requestParameters.prefix;
        }

        if (requestParameters.limit !== undefined) {
            queryParameters['limit'] = requestParameters.limit;
        }

        if (requestParameters.paginationToken !== undefined) {
            queryParameters['paginationToken'] = requestParameters.paginationToken;
        }

        if (requestParameters.namespace !== undefined) {
            queryParameters['namespace'] = requestParameters.namespace;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["Api-Key"] = this.configuration.apiKey("Api-Key"); // ApiKeyAuth authentication
        }

        const response = await this.request({
            path: `/vectors/list`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ListResponseFromJSON(jsonValue));
    }

    /**
     * The `list` operation lists the IDs of vectors in a single namespace of a serverless index. An optional prefix can be passed to limit the results to IDs with a common prefix.  By default, `list` returns up to 100 IDs per page in sorted order (bitwise \"C\" collation). If the `limit` parameter is set, `list` returns up to that number of IDs instead. Whenever there are additional IDs to return, the response also includes a `pagination_token` that you can use to get the next batch of IDs. When the response does not include a `pagination_token`, there are no more IDs to return.  For guidance and examples, see [List record IDs](https://docs.pinecone.io/guides/data/list-record-ids).  **Note:** `list_vectors` is supported only for serverless indexes.
     * List vector IDs
     */
    async listVectors(requestParameters: ListVectorsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ListResponse> {
        const response = await this.listVectorsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * The `query` operation searches a namespace, using a query vector. It retrieves the ids of the most similar items in a namespace, along with their similarity scores.  For guidance and examples, see [Query data](https://docs.pinecone.io/guides/data/query-data).
     * Query vectors
     */
    async queryVectorsRaw(requestParameters: QueryVectorsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<QueryResponse>> {
        if (requestParameters.queryRequest === null || requestParameters.queryRequest === undefined) {
            throw new runtime.RequiredError('queryRequest','Required parameter requestParameters.queryRequest was null or undefined when calling queryVectors.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["Api-Key"] = this.configuration.apiKey("Api-Key"); // ApiKeyAuth authentication
        }

        const response = await this.request({
            path: `/query`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: QueryRequestToJSON(requestParameters.queryRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => QueryResponseFromJSON(jsonValue));
    }

    /**
     * The `query` operation searches a namespace, using a query vector. It retrieves the ids of the most similar items in a namespace, along with their similarity scores.  For guidance and examples, see [Query data](https://docs.pinecone.io/guides/data/query-data).
     * Query vectors
     */
    async queryVectors(requestParameters: QueryVectorsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<QueryResponse> {
        const response = await this.queryVectorsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * The `update` operation updates a vector in a namespace. If a value is included, it will overwrite the previous value. If a `set_metadata` is included, the values of the fields specified in it will be added or overwrite the previous value.  For guidance and examples, see [Update data](https://docs.pinecone.io/guides/data/update-data).
     * Update a vector
     */
    async updateVectorRaw(requestParameters: UpdateVectorRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<object>> {
        if (requestParameters.updateRequest === null || requestParameters.updateRequest === undefined) {
            throw new runtime.RequiredError('updateRequest','Required parameter requestParameters.updateRequest was null or undefined when calling updateVector.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["Api-Key"] = this.configuration.apiKey("Api-Key"); // ApiKeyAuth authentication
        }

        const response = await this.request({
            path: `/vectors/update`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: UpdateRequestToJSON(requestParameters.updateRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse<any>(response);
    }

    /**
     * The `update` operation updates a vector in a namespace. If a value is included, it will overwrite the previous value. If a `set_metadata` is included, the values of the fields specified in it will be added or overwrite the previous value.  For guidance and examples, see [Update data](https://docs.pinecone.io/guides/data/update-data).
     * Update a vector
     */
    async updateVector(requestParameters: UpdateVectorRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<object> {
        const response = await this.updateVectorRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * The `upsert` operation writes vectors into a namespace. If a new value is upserted for an existing vector ID, it will overwrite the previous value.  For guidance and examples, see [Upsert data](https://docs.pinecone.io/guides/data/upsert-data).
     * Upsert vectors
     */
    async upsertVectorsRaw(requestParameters: UpsertVectorsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UpsertResponse>> {
        if (requestParameters.upsertRequest === null || requestParameters.upsertRequest === undefined) {
            throw new runtime.RequiredError('upsertRequest','Required parameter requestParameters.upsertRequest was null or undefined when calling upsertVectors.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["Api-Key"] = this.configuration.apiKey("Api-Key"); // ApiKeyAuth authentication
        }

        const response = await this.request({
            path: `/vectors/upsert`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: UpsertRequestToJSON(requestParameters.upsertRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => UpsertResponseFromJSON(jsonValue));
    }

    /**
     * The `upsert` operation writes vectors into a namespace. If a new value is upserted for an existing vector ID, it will overwrite the previous value.  For guidance and examples, see [Upsert data](https://docs.pinecone.io/guides/data/upsert-data).
     * Upsert vectors
     */
    async upsertVectors(requestParameters: UpsertVectorsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UpsertResponse> {
        const response = await this.upsertVectorsRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
