/* tslint:disable */
/* eslint-disable */
/**
 * Pinecone Data Plane API
 * Pinecone is a vector database that makes it easy to search and retrieve billions of high-dimensional vectors.
 *
 * The version of the OpenAPI document: 2024-10
 * Contact: support@pinecone.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  ImportModel,
  ListImportsResponse,
  RpcStatus,
  StartImportRequest,
  StartImportResponse,
} from '../models/index';
import {
    ImportModelFromJSON,
    ImportModelToJSON,
    ListImportsResponseFromJSON,
    ListImportsResponseToJSON,
    RpcStatusFromJSON,
    RpcStatusToJSON,
    StartImportRequestFromJSON,
    StartImportRequestToJSON,
    StartImportResponseFromJSON,
    StartImportResponseToJSON,
} from '../models/index';

export interface CancelBulkImportRequest {
    id: string;
}

export interface DescribeBulkImportRequest {
    id: string;
}

export interface ListBulkImportsRequest {
    limit?: number;
    paginationToken?: string;
}

export interface StartBulkImportRequest {
    startImportRequest: StartImportRequest;
}

/**
 * 
 */
export class BulkOperationsApi extends runtime.BaseAPI {

    /**
     * The `cancel_import` operation cancels an import operation if it is not yet finished. It has no effect if the operation is already finished.   For guidance and examples, see [Import data](https://docs.pinecone.io/guides/data/import-data).
     * Cancel an import
     */
    async cancelBulkImportRaw(requestParameters: CancelBulkImportRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<object>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling cancelBulkImport.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["Api-Key"] = this.configuration.apiKey("Api-Key"); // ApiKeyAuth authentication
        }

        const response = await this.request({
            path: `/bulk/imports/{id}`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse<any>(response);
    }

    /**
     * The `cancel_import` operation cancels an import operation if it is not yet finished. It has no effect if the operation is already finished.   For guidance and examples, see [Import data](https://docs.pinecone.io/guides/data/import-data).
     * Cancel an import
     */
    async cancelBulkImport(requestParameters: CancelBulkImportRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<object> {
        const response = await this.cancelBulkImportRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * The `describe_import` operation returns details of a specific import operation.   For guidance and examples, see [Import data](https://docs.pinecone.io/guides/data/import-data).
     * Describe an import
     */
    async describeBulkImportRaw(requestParameters: DescribeBulkImportRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ImportModel>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling describeBulkImport.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["Api-Key"] = this.configuration.apiKey("Api-Key"); // ApiKeyAuth authentication
        }

        const response = await this.request({
            path: `/bulk/imports/{id}`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ImportModelFromJSON(jsonValue));
    }

    /**
     * The `describe_import` operation returns details of a specific import operation.   For guidance and examples, see [Import data](https://docs.pinecone.io/guides/data/import-data).
     * Describe an import
     */
    async describeBulkImport(requestParameters: DescribeBulkImportRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ImportModel> {
        const response = await this.describeBulkImportRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * The `list_imports` operation lists all recent and ongoing import operations.   By default, `list_imports` returns up to 100 imports per page. If the `limit` parameter is set, `list` returns up to that number of imports instead. Whenever there are additional IDs to return, the response also includes a `pagination_token` that you can use to get the next batch of imports. When the response does not include a `pagination_token`, there are no more imports to return.  For guidance and examples, see [Import data](https://docs.pinecone.io/guides/data/import-data).
     * List imports
     */
    async listBulkImportsRaw(requestParameters: ListBulkImportsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ListImportsResponse>> {
        const queryParameters: any = {};

        if (requestParameters.limit !== undefined) {
            queryParameters['limit'] = requestParameters.limit;
        }

        if (requestParameters.paginationToken !== undefined) {
            queryParameters['paginationToken'] = requestParameters.paginationToken;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["Api-Key"] = this.configuration.apiKey("Api-Key"); // ApiKeyAuth authentication
        }

        const response = await this.request({
            path: `/bulk/imports`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ListImportsResponseFromJSON(jsonValue));
    }

    /**
     * The `list_imports` operation lists all recent and ongoing import operations.   By default, `list_imports` returns up to 100 imports per page. If the `limit` parameter is set, `list` returns up to that number of imports instead. Whenever there are additional IDs to return, the response also includes a `pagination_token` that you can use to get the next batch of imports. When the response does not include a `pagination_token`, there are no more imports to return.  For guidance and examples, see [Import data](https://docs.pinecone.io/guides/data/import-data).
     * List imports
     */
    async listBulkImports(requestParameters: ListBulkImportsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ListImportsResponse> {
        const response = await this.listBulkImportsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * The `start_import` operation starts an asynchronous import of vectors from object storage into an index.   For guidance and examples, see [Import data](https://docs.pinecone.io/guides/data/import-data).
     * Start import
     */
    async startBulkImportRaw(requestParameters: StartBulkImportRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StartImportResponse>> {
        if (requestParameters.startImportRequest === null || requestParameters.startImportRequest === undefined) {
            throw new runtime.RequiredError('startImportRequest','Required parameter requestParameters.startImportRequest was null or undefined when calling startBulkImport.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.apiKey) {
            headerParameters["Api-Key"] = this.configuration.apiKey("Api-Key"); // ApiKeyAuth authentication
        }

        const response = await this.request({
            path: `/bulk/imports`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: StartImportRequestToJSON(requestParameters.startImportRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => StartImportResponseFromJSON(jsonValue));
    }

    /**
     * The `start_import` operation starts an asynchronous import of vectors from object storage into an index.   For guidance and examples, see [Import data](https://docs.pinecone.io/guides/data/import-data).
     * Start import
     */
    async startBulkImport(requestParameters: StartBulkImportRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StartImportResponse> {
        const response = await this.startBulkImportRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
