from dash import Dash
from dash.dependencies import Input, Output
from dash.exceptions import PreventUpdate

from dash_generator_test_component_nested import MyNestedComponent
from dash_generator_test_component_standard import MyStandardComponent
from dash_test_components import StyledComponent
from dash_html_components import Button, Div

from selenium.webdriver.support.ui import WebDriverWait

from dash.testing.plugin import *
from . import BaseDashView


def test_gene001_simple_callback(dash_duo):
    app = Dash(__name__)

    app.layout = Div(
        [
            MyStandardComponent(id="standard", value="Standard"),
            MyNestedComponent(id="nested", value="Nested"),
        ]
    )

    class DashView(BaseDashView):
        dash = app

    dash_duo.start_server(DashView)

    assert dash_duo.wait_for_element("#standard").text == "Standard"
    assert dash_duo.wait_for_element("#nested").text == "Nested"

    dash_duo.percy_snapshot(name="gene001-simple-callback")


def test_gene002_arbitrary_resources(dash_duo):
    app = Dash(__name__)

    app.layout = Div([Button(id="btn"), Div(id="container")])

    @app.callback(Output("container", "children"), [Input("btn", "n_clicks")])
    def update_container(n_clicks):
        if n_clicks is None:
            raise PreventUpdate

        return StyledComponent(
            id="styled", value="Styled", style={"font-family": "godfather"}
        )

    class DashView(BaseDashView):
        dash = app

    dash_duo.start_server(DashView)

    assert (
        dash_duo.driver.execute_script("return document.fonts.check('1em godfather')")
        is False
    )

    dash_duo.wait_for_element("#btn").click()
    assert dash_duo.wait_for_element("#styled").text == "Styled"

    WebDriverWait(dash_duo.driver, 10).until(
        lambda _: dash_duo.driver.execute_script(
            "return document.fonts.check('1em godfather')"
        )
        is True,
    )

    dash_duo.percy_snapshot(name="gene002-arbitrary-resource")
