<?php
/**
 * Created by PhpStorm.
 * User: inhere
 * Date: 2017-03-30
 * Time: 13:01
 */

namespace Inhere\WebSocket\Server\deprecated;

use Inhere\Library\Traits\FixedEventTrait;
use Inhere\Library\Traits\OptionsTrait;

/**
 * Class BaseWebSocket
 * @package Inhere\WebSocket\Server\deprecated
 */
abstract class BaseWebSocket
{
    use OptionsTrait;
    use FixedEventTrait;

    /**
     * version
     */
    const VERSION = '0.5.1';

    /**
     * Websocket blob type.
     */
    const BINARY_TYPE_BLOB = "\x81";

    /**
     * Websocket array buffer type.
     */
    const BINARY_TYPE_ARRAY_BUFFER = "\x82";

    const SIGN_KEY = '258EAFA5-E914-47DA-95CA-C5AB0DC85B11';

    const DEFAULT_HOST = '0.0.0.0';
    const DEFAULT_PORT = 8080;

    // 事件的回调函数名
    const ON_CONNECT = 'connect';
    const ON_HANDSHAKE = 'handshake';
    const ON_OPEN = 'open';
    const ON_MESSAGE = 'message';
    const ON_CLOSE = 'close';
    const ON_ERROR = 'error';

    /**
     * @var string
     */
    protected $host;

    /**
     * @var int
     */
    protected $port;

    /**
     * @var array
     */
    protected $options = [
        'debug' => false,

        'open_log' => true,
        'log_file' => '',
    ];


    /**
     * WebSocket constructor.
     * @param string $host
     * @param int $port
     * @param array $options
     */
    public function __construct(string $host = '0.0.0.0', int $port = 8080, array $options = [])
    {
        $this->host = $host;
        $this->port = $port;

        $this->setOptions($options, true);
    }

    /////////////////////////////////////////////////////////////////////////////////////////
    /// helper method
    /////////////////////////////////////////////////////////////////////////////////////////

    /**
     * @param $s
     * @return string
     */
    public function frame($s)
    {
        $a = str_split($s, 125);
        $prefix = self::BINARY_TYPE_BLOB;

        if (count($a) === 1) {
            return $prefix . chr(strlen($a[0])) . $a[0];
        }

        $ns = '';

        foreach ($a as $o) {
            $ns .= $prefix . chr(strlen($o)) . $o;
        }

        return $ns;
    }

    /**
     * @param $buffer
     * @return string
     */
    public function decode($buffer)
    {
        /*$len = $masks = $data =*/
        $decoded = '';
        $len = ord($buffer[1]) & 127;

        if ($len === 126) {
            $masks = substr($buffer, 4, 4);
            $data = substr($buffer, 8);
        } else if ($len === 127) {
            $masks = substr($buffer, 10, 4);
            $data = substr($buffer, 14);
        } else {
            $masks = substr($buffer, 2, 4);
            $data = substr($buffer, 6);
        }

        $dataLen = strlen($data);
        for ($index = 0; $index < $dataLen; $index++) {
            $decoded .= $data[$index] ^ $masks[$index % 4];
        }

        return $decoded;
    }

    /**
     * Generate WebSocket sign.(for server)
     * @param string $key
     * @return string
     */
    public function genSign(string $key): string
    {
        return base64_encode(sha1(trim($key) . self::SIGN_KEY, true));
    }

    /**
     * @param string $message
     * @param string $type
     * @param array $data
     */
    public function log(string $message, string $type = 'info', array $data = [])
    {
        $date = date('Y-m-d H:i:s');
        $type = strtoupper(trim($type));

        $this->print("[$date] [$type] $message " . ($data ? json_encode($data) : ''));
    }

    /**
     * @param mixed $messages
     * @param bool $nl
     * @param null|int $exit
     */
    public function print($messages, $nl = true, $exit = null)
    {
        $text = is_array($messages) ? implode(($nl ? "\n" : ''), $messages) : $messages;

        fwrite(\STDOUT, $text . ($nl ? "\n" : ''));

        if ($exit !== null) {
            exit((int)$exit);
        }
    }

    /**
     * @return string
     */
    public function getHost(): string
    {
        if (!$this->host) {
            $this->host = self::DEFAULT_HOST;
        }

        return $this->host;
    }

    /**
     * @return int
     */
    public function getPort(): int
    {
        if (!$this->port || $this->port <= 0) {
            $this->port = self::DEFAULT_PORT;
        }

        return $this->port;
    }
}
