<?php
namespace PHPEMS;

require_once(PEPATH . '/lib/include/phpexcel/PHPExcel.php');

class excel
{
	public function __construct()
    {
    	
        $this->type = 'Excel2007';
    }

    public function getExcelContent($path,$sheet = 0)
    {
        require_once(PEPATH . '/lib/include/phpexcel/PHPExcel/IOFactory.php');
        $xlsReader = \PHPExcel_IOFactory::createReader($this->type);
        $xlsReader->setReadDataOnly(true);
        $xlsReader->setLoadSheetsOnly(true);
        $Sheets = $xlsReader->load($path);
        return $Sheets->getSheet($sheet)->toArray();
    }

    public function putExcelContent($path,$content,$title = false,$sheet = 0)
    {
        if(!$content)return false;
        require_once(PEPATH ."/lib/include/phpexcel/PHPExcel/Writer/Excel2007.php");
        $objPHPExcel = new \PHPExcel();
        $objPHPExcel->setActiveSheetIndex($sheet);
        if(!$title)$title = "sheet1";
        $objPHPExcel->getActiveSheet()->setTitle($title);
        $index = 1;
        foreach($content as $key => $tmp)
        {
            $row = 0;
            foreach($tmp as $p)
            {
                if($row >= 26)
                {
                    $rowindex = chr(64 + intval($row / 26)).chr(65 + $row % 26);
                }
                else
                {
                    $rowindex = chr(65 + $row);
                }
                $objPHPExcel->getActiveSheet()->setCellValueExplicit($rowindex.$index,$p,\PHPExcel_Cell_DataType::TYPE_STRING);
                $row++;
            }
            $index++;
        }
        $objWriter = new \PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save($path);
        return $path;
    }

    public function tounixtime($data)
    {
        return ($data - 25569)*24*3600 + 8* 3600;
    }
}



?>