<?php

return [
    'common_header' => 'PHP 8.3 ist ein Major-Update der Sprache PHP. Es beinhaltet viele neue Features und Verbesserungen.<br>Unter anderem die Typisierung von Klassen-Konstanten, tiefes Klonen von Readonly-Properties und Erweiterungen der Zufallsfunktionalität. Darüber hinaus sind wie üblich Performance-Optimierungen, Bug-Fixes und andere Aufräumarbeiten eingeflossen.',
    'documentation' => 'Doc',
    'main_title' => 'Released!',
    'main_subtitle' => 'PHP 8.3 ist ein Major-Update der Sprache PHP.<br class="display-none-md"> Es beinhaltet viele neue Features und Verbesserungen.<br>Unter anderem die Typisierung von Klassen-Konstanten, tiefes Klonen von Readonly-Properties und Erweiterungen der Zufallsfunktionalität. Darüber hinaus sind wie üblich Performance-Optimierungen, Bug-Fixes und andere Aufräumarbeiten eingeflossen.',
    'upgrade_now' => 'Wechsle jetzt zu PHP 8.3!',

    'readonly_title' => 'Klonen von Readonly-Properties',
    'readonly_description' => '<code>readonly</code>-Properties können nun innerhalb der magischen <code>__clone</code> Methode geändert werden.',
    'json_validate_title' => 'New <code>json_validate()</code> Funktion',
    'json_validate_description' => '<code>json_validate()</code> erlaubt es einen String auf syntaktisch korrektes JSON auf eine effizientere Art und Weise als <code>json_decode()</code> zu prüfen.',
    'typed_class_constants_title' => 'Typisierung von Klassen-Konstanten',
    'override_title' => 'Das neue <code>#[\Override]</code>-Attribut',
    'override_description' => 'Durch das Nutzen des <code>#[\Override]</code>-Attributs bei einer Methode, wird PHP nun sicherstellen, dass diese Methode in einer Elternklasse oder einem implementierten Interface vorhanden ist. Die Angabe des Attributs macht deutlich, dass das Überschreiben der Method absichtlich erfolgt ist und erleichtert ein Refactoring, da das Entfernen der überschriebenen Methode in der Elternklasse dazu führt, dass ein Fehler geworfen wird.',
    'randomizer_getbytesfromstring_title' => 'Neue Methode <code>Randomizer<span style="word-break: break-all;">::</span>getBytesFromString()</code>',
    'randomizer_getbytesfromstring_description' => 'Die <a href="/releases/8.2/en.php#random_extension">Random-Erweiterung</a>, die in PHP 8.2 hinzugefügt wurde, wurde um eine neue Methode erweitert, die es erlaubt einen String zu generieren, der ausschließlich aus bestimmten Zeichen besteht. Diese Methode erlaubt es auf einfache Weise zufällige Bezeichner, wie beispielsweise Domainnamen, und numerische Strings beliebiger Länge zu erzeugen.',
    'randomizer_getfloat_nextfloat_title' => 'Neue Methoden <code>Randomizer::getFloat()</code> und <code>Randomizer::nextFloat()</code>',
    'randomizer_getfloat_nextfloat_description' => '<p>Durch die limitierte Präzision und der impliziten Rundung von Gleitkommazahlen war das gleichverteilte Generieren von Gleitkommazahlen innerhalb eines vorgegebenen Bereichs nicht einfach. Gängige Userland-Lösungen führen zu einer ungleichmäßigen Verteilung und geben potentiell Zahlen außerhalb des gewünschten Bereichs zurück.</p><p>Der Randomizer wurde daher um zwei Methoden erweitert, um zufällige Gleitkommazahlen mit einer Gleichverteilung zu generieren. Die <code>Randomizer::getFloat()</code>-Methode nutzt den γ-section-Algorithmus, welcher in <a href="https://doi.org/10.1145/3503512" target="_blank" rel="noopener noreferrer">Drawing Random Floating-Point Numbers from an Interval. Frédéric Goualard, ACM Trans. Model. Comput. Simul., 32:3, 2022.</a> veröffentlicht wurde.</p>',
    'dynamic_class_constant_fetch_title' => 'Dynamisches Abrufen von Klassen-Konstanten',
    'command_line_linter_title' => 'Kommandozeilen-Linter unterstützt mehrere Dateien',
    'command_line_linter_description' => '<p>Der Kommandozeilen-Linter erlaubt nun die Prüfung mehrerer Dateien.</p>',

    'new_classes_title' => 'Neue Klassen, Interfaces, und Funktionen',
    'new_dom' => 'Neue <a href="/manual/en/domelement.getattributenames.php"><code>DOMElement::getAttributeNames()</code></a>, <a href="/manual/en/domelement.insertadjacentelement.php"><code>DOMElement::insertAdjacentElement()</code></a>, <a href="/manual/en/domelement.insertadjacenttext.php"><code>DOMElement::insertAdjacentText()</code></a>, <a href="/manual/en/domelement.toggleattribute.php"><code>DOMElement::toggleAttribute()</code></a>, <a href="/manual/en/domnode.contains.php"><code>DOMNode::contains()</code></a>, <a href="/manual/en/domnode.getrootnode.php"><code>DOMNode::getRootNode()</code></a>, <a href="/manual/en/domnode.isequalnode.php"><code>DOMNode::isEqualNode()</code></a>, <code>DOMNameSpaceNode::contains()</code>, und <a href="/manual/en/domparentnode.replacechildren.php"><code>DOMParentNode::replaceChildren()</code></a> Methoden.',
    'new_intl' => 'Neue <a href="/manual/en/intlcalendar.setdate.php"><code>IntlCalendar::setDate()</code></a>, <a href="/manual/en/intlcalendar.setdatetime.php"><code>IntlCalendar::setDateTime()</code></a>, <a href="/manual/en/intlgregoriancalendar.createfromdate.php"><code>IntlGregorianCalendar::createFromDate()</code></a>, und <a href="/manual/en/intlgregoriancalendar.createfromdatetime.php"><code>IntlGregorianCalendar::createFromDateTime()</code></a> Methoden.',
    'new_ldap' => 'Neue <code>ldap_connect_wallet()</code>, und <code>ldap_exop_sync()</code> Funktionen.',
    'new_mb_str_pad' => 'Neue <a href="/manual/en/function.mb-str-pad.php"><code>mb_str_pad()</code></a> Funktion.',
    'new_posix' => 'Neue <a href="/manual/en/function.posix-sysconf.php"><code>posix_sysconf()</code></a>, <a href="/manual/en/function.posix-pathconf.php"><code>posix_pathconf()</code></a>, <a href="/manual/en/function.posix-fpathconf.php"><code>posix_fpathconf()</code></a>, und <a href="/manual/en/function.posix-eaccess.php"><code>posix_eaccess()</code></a> Funktionen.',
    'new_reflection' => 'Neue <a href="/manual/en/reflectionmethod.createfrommethodname.php"><code>ReflectionMethod::createFromMethodName()</code></a> Methode.',
    'new_socket' => 'Neue <a href="/manual/en/function.socket-atmark.php"><code>socket_atmark()</code></a> Funktion.',
    'new_str' => 'Neue <a href="/manual/en/function.str-increment.php"><code>str_increment()</code></a>, <a href="/manual/en/function.str-decrement.php"><code>str_decrement()</code></a>, und <a href="/manual/en/function.stream-context-set-options.php"><code>stream_context_set_options()</code></a> Funktionen.',
    'new_ziparchive' => 'Neue <a href="/manual/en/ziparchive.getarchiveflag.php"><code>ZipArchive::getArchiveFlag()</code></a> Methode.',
    'new_openssl_ec' => 'Unterstützung der OpenSSL Erweiterung für das generieren von EC Schlüssel mit eigener Angabe von EC Parametern.',
    'new_ini' => 'Neue INI Einstellung <a href="/manual/en/migration83.other-changes.php#migration83.other-changes.ini"><code>zend.max_allowed_stack_size</code></a> zum Angeben der maximal erlaubten Stack größe.',
    'ini_fallback' => 'Die php.ini Unterstützt nun die Fallback/Default-Wert Syntax.',
    'anonymous_readonly' => 'Anonymous Klassen können nun auch als readonly markiert werden.',

    'bc_title' => 'Veraltete Funktionalität und inkompatible Änderungen zu vorherigen PHP Versionen',
    'bc_datetime' => '<a href="https://wiki.php.net/rfc/datetime-exceptions">Adäquatere Date/Time-Exceptions</a>.',
    'bc_arrays' => 'Die Zuweisung eines Negativen-Index <code>n</code> bei einem leeren Array sorgt nun dafür, dass der nächste Index <code>n + 1</code> statt <code>0</code> ist.',
    'bc_range' => 'Vänderungen an der <code>range()</code> Funktion.',
    'bc_traits' => 'Veränderungen an der erneuten Deklarierung von Properties durch Traits.',
    'bc_umultipledecimalseparators' => 'Die <code>U_MULTIPLE_DECIMAL_SEPERATORS</code> Konstante wurde als Veraltet markiert und wurde durch <code>U_MULTIPLE_DECIMAL_SEPARATORS</code> ersetzt.',
    'bc_mtrand' => 'Die <a href="/manual/en/random.constants.php#constant.mt-rand-php"><code>MT_RAND_PHP</code></a> Mt19937 Variante wurde als veraltet markiert.',
    'bc_reflection' => 'Der Rückgabewert von <a href="/manual/en/reflectionclass.getstaticproperties.php"><code>ReflectionClass::getStaticProperties()</code></a> wurde von <code>?array</code> zu <code>array</code> geändert.',
    'bc_ini' => 'Die INI Einstellungen <a href="/manual/en/info.configuration.php#ini.assert.active"><code>assert.active</code></a>, <a href="/manual/en/info.configuration.php#ini.assert.bail"><code>assert.bail</code></a>, <a href="/manual/en/info.configuration.php#ini.assert.callback"><code>assert.callback</code></a>, <a href="/manual/en/info.configuration.php#ini.assert.exception"><code>assert.exception</code></a>, and <a href="/manual/en/info.configuration.php#ini.assert.warning"><code>assert.warning</code></a> wurden als veraltet markiert.',
    'bc_standard' => 'Das Aufrufen der Funktionen <a href="/manual/en/function.get-class.php"><code>get_class()</code></a> und <a href="/manual/en/function.get-parent-class.php"><code>get_parent_class()</code></a> ohne die Angabe von Parametern ist veraltet.',
    'bc_sqlite3' => 'SQLite3: Wirft nun im default Exceptions.',

    'footer_title' => 'Bessere Performance, verbesserte Syntax und verbesserte Typensicherheit.',
    'footer_description' => '<p>For source downloads of PHP 8.3 please visit the <a href="/downloads">downloads</a> page. Windows binaries can be found on the <a href="https://windows.php.net/download">PHP for Windows</a> site. The list of changes is recorded in the <a href="/ChangeLog-8.php#PHP_8_3">ChangeLog</a>.</p>
        <p>The <a href="/manual/en/migration83.php">migration guide</a> is available in the PHP Manual. Please consult it for a detailed list of new features and backward-incompatible changes.</p>',
];
