<?php

$_SERVER['BASE_PAGE'] = 'archive/2014.php';
include_once __DIR__ . '/../include/prepend.inc';
include_once __DIR__ . '/../include/pregen-news.inc';
news_archive_sidebar();
site_header("News Archive - 2014", ["cache" => true]);
?>

<h1>News Archive - 2014</h1>

<p>
 Here are the most important news items we have published in 2014 on PHP.net.
</p>

<hr>

<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://2015.phpsouthcoast.co.uk/", "php-south-coast.png", "PHP South Coast 2015"); ?></div>
    <h2 class="newstitle"><a id="id2014-12-29-2" href="http://2015.phpsouthcoast.co.uk/" rel="bookmark" class="bookmark">PHP South Coast 2015</a></h2>
  </header>
  <time class="newsdate" datetime="2014-12-29T23:08:32+01:00">29 Dec 2014</time>
  <div class="newscontent">
    <div>
     <p> We’re pleased to announce our first conference, PHP South Coast 2015!</p>
     <p> Taking place on the south coast of England in Summer 2015, where community members from around the world will come together to learn and share information about the latest trends and technologies in professional PHP development.</p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://bulgariawebsummit.com/", "bulgaria-web-summit.png", "Bulgaria Web Summit 2015"); ?></div>
    <h2 class="newstitle"><a id="id2014-12-29-1" href="http://bulgariawebsummit.com/" rel="bookmark" class="bookmark">Bulgaria Web Summit 2015</a></h2>
  </header>
  <time class="newsdate" datetime="2014-12-29T23:03:02+01:00">29 Dec 2014</time>
  <div class="newscontent">
    <div>
     <p>Bulgaria Web Summit 2015 is an event about (almost) everything a modern web person should know: {Programming, IoT, UX, UI, Fun, Privacy}. This year we will have strong PHP presense to support the growth of Bulgarian PHP community.  The event will take place on the 18th of April  at the conference area of the Inter Expo Centre.</p>

     <p>The purpose of this meeting is to discuss the new tendencies in this direction and to popularize the internet technologies in the spheres of business, education, and services. The range of subjects includes technologies like PHP, JavaScript, CSS, Privacy and others.</p>

     <p>Join us and have fun while learning something new.</p>
     <p>Twitter: <a href="https://twitter.com/bgwebsummit">@bgwebsummit</a></p>

    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-12-18-3" href="http://php.net/archive/2014.php#id2014-12-18-3" rel="bookmark" class="bookmark">PHP 5.4.36 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-12-18T18:15:29-08:00">18 Dec 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP
     5.4.36. Two security-related bugs were fixed in this release, including the fix for CVE-2014-8142.

     All PHP 5.4 users are encouraged to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.4.36 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.36">ChangeLog</a>.
     </p>

    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-12-18-2" href="http://php.net/archive/2014.php#id2014-12-18-2" rel="bookmark" class="bookmark">PHP 5.6.4 is available</a></h2>
  </header>
  <time class="newsdate" datetime="2014-12-18T16:35:48-08:00">18 Dec 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP
     5.6.4. This release fixes several bugs and one CVE related to unserialization.

     All PHP 5.6 users are encouraged to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.6.4 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.6.4">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-12-18-1" href="http://php.net/archive/2014.php#id2014-12-18-1" rel="bookmark" class="bookmark">PHP 5.5.20 is available</a></h2>
  </header>
  <time class="newsdate" datetime="2014-12-18T16:10:55+00:00">18 Dec 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP
     5.5.20. This release fixes several bugs and one CVE related to unserialization.

     All PHP 5.5 users are encouraged to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.5.20 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.5.20">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-11-13-3" href="http://php.net/archive/2014.php#id2014-11-13-3" rel="bookmark" class="bookmark">PHP 5.4.35 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-11-13T22:11:34-08:00">13 Nov 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP
     5.4.35. 4 security-related bugs were fixed in this release, including the fix for CVE-2014-3710.

     All PHP 5.4 users are encouraged to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.4.35 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.35">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-11-13-2" href="http://php.net/archive/2014.php#id2014-11-13-2" rel="bookmark" class="bookmark">PHP 5.6.3 is available</a></h2>
  </header>
  <time class="newsdate" datetime="2014-11-13T15:15:58-08:00">13 Nov 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP 5.6.3.
     This release fixes several bugs and one CVE in the fileinfo extension.
     All PHP 5.6 users are encouraged to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.6.3 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.6.3">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-11-13-1" href="http://php.net/archive/2014.php#id2014-11-13-1" rel="bookmark" class="bookmark">PHP 5.5.19 is available</a></h2>
  </header>
  <time class="newsdate" datetime="2014-11-13T16:45:26+00:00">13 Nov 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP
     5.5.19. This release fixes several bugs and one CVE in the fileinfo extension.
     All PHP 5.5 users are encouraged to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.5.19 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.5.19">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("https://phpconference.com/2015se/en", "ipc2015.png", "International PHP Conference Spring 2015"); ?></div>
    <h2 class="newstitle"><a id="id2014-11-05-1" href="https://phpconference.com/2015se/en" rel="bookmark" class="bookmark">International PHP Conference Spring 2015</a></h2>
  </header>
  <time class="newsdate" datetime="2014-11-05T22:31:52+01:00">05 Nov 2014</time>
  <div class="newscontent">
    <div>
	<p>The International PHP Conference is an opportunity for all those involved in the PHP and the Web developer community to learn about the latest trends and technologies. The conference takes place in the center of Berlin which is often considered the "Silicon Valley of Europe". We have some of the best speakers in the world and a tremendous opportunity to get involved in a wonderful networking atmosphere to get in contact with your peers.</p>

        <p>The conference will provide the latest know how for building modern and innovative web applications and everything you need for digital success. The conference will explore key topics and core technologies for web developers and decision makers. We will show you how to scale your applications and explain the details of Continuous Integration or evaluate different approaches to NoSQL.</p>

        <p>Attendees will have the opportuntiy to meet World Class speakers, core developers and consultants. In addition to having the the chance to meet international known PHP and Web experts at this conference, you will also be given the chance to evaluate your code.</p>

        <p>This Conference has been around for ten years and it is definitely a must go event for the PHP Community!</p>
        <p>
        Basic facts: <br/><br/>

        Date: June 7th - 11th, 2015 <br/>
        Location: Maritim proArte, Berlin <br/>
        </p>

        <p>HIGHLIGHTS</p>
        <ul>
            <li><strong>90+</strong> best practice sessions</li>
            <li><strong>Cool PHP &amp; the Gang: 60+</strong> international top speakers</li>
            <li>Hands-on Power Workshop Days</li>
            <li><strong>Expo</strong> with exiting exhibitors</li>
            <li><strong>Conference Combo:</strong> Visit the webinale For Free</li>
            <li><strong>All inclusive:</strong> Changing buffets, snacks &amp; refreshing drinks Official certificate for attendees</li>
            <li><strong>Free Swag:</strong> Developer backpack, T-Shirt, magazines etc.</li>
            <li>Exclusive <strong>community events</strong></li>
        </ul>

        <p>Topics:</p>
        <ul>
            <li>Core PHP /PHPNG</li>
            <li>PHP Frameworks</li>
            <li>PHP Scaling &amp; Performance</li>
            <li>PHP Security</li>
            <li>PHP Testing &amp; Quality</li>
            <li>HHVM &amp; Hack</li>
            <li>Architecture</li>
            <li>JavaScript / ECMAScript 6</li>
            <li>JavaScript Frameworks</li>
            <li>JavaScript Performance &amp; Security</li>
            <li>Web APIs &amp; Services</li>
            <li>Agile</li>
            <li>Continuous Delivery</li>
            <li>DevOps</li>
            <li>Cloud</li>
            <li>Data Stores</li>
        </ul>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://www.phpuceu.org/phpuceu-2015/", "phpuceu-may-2015-thumb.png", "PHP Unconference Europe 2015"); ?></div>
    <h2 class="newstitle"><a id="id2014-10-27-1" href="http://www.phpuceu.org/phpuceu-2015/" rel="bookmark" class="bookmark">PHP Unconference Europe 2015</a></h2>
  </header>
  <time class="newsdate" datetime="2014-10-27T01:23:45+02:00">27 Oct 2014</time>
  <div class="newscontent">
    <div>
      <p>The 4th PHPucEU is taking place on May 9th and 10th on the wonderful island of Majorca, Spain.</p>
      <p>
        For the 3rd PHP Unconference Europe in 2014 about 100 attendees came to
        Spain and joined a bunch of different sessions. Our mission is to bring
        together an international group with knowledge of PHP. In order to address
        as wide an audience as possible, the language of all sessions, presentations
        and round table discussions will be English.
      </p>
      <p>
        One of the key aspects of an unconference, besides the sessions themselves,
        is the motivation for further discussions about topics while a coffee break
        (or depending on the time of the day, a beer). We are looking forward to
        organize an inspiring, comprehensive and successful weekend, talking about
        PHP and related Open Source and web technologies on the sunny island
        of Majorca again.
      </p>
      <p>
        Start your summer with a short trip to Majorca, enjoy good coffee and shiny
        weather while discussing PHP related topics with international attendees.
      </p>
      <p>
        <a href="http://www.phpuceu.org/phpuceu-2015/" title="PHP Unconference Europe 2015">PHP Unconference Europe 2015</a>
        <a href="https://twitter.com/hashtag/phpuceu" title="PHP Unconference Europe on Twitter">#phpuceu</a>
      </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://sunshinephp.com/", "sunshinephp-feb-2015-thumb.png", "SunshinePHP Developer Conference 2015"); ?></div>
    <h2 class="newstitle"><a id="id2014-10-18-1" href="http://sunshinephp.com/" rel="bookmark" class="bookmark">SunshinePHP Developer Conference 2015</a></h2>
  </header>
  <time class="newsdate" datetime="2014-10-18T03:42:05+02:00">18 Oct 2014</time>
  <div class="newscontent">
    <div>
     <p>
         The 3rd year of <a href="http://sunshinephp.com/" title="SunshinePHP">SunshinePHP</a> in Miami, Florida is shaping up to be awesome once again from February 5th - 7th, 2015.  We will have a full day of in-depth 3-hour tutorials on Thursday, followed by the 2 day conference on Friday an Saturday.  The conference has something for every level of PHP developer, as well as a hack-a-thon, unscheduled Uncon, fun activities, and of course sunshine.  February is the perfect time to be in sunny Miami, Florida but you'll want to hurry because tickets sold out last year.
     </p>
     <p>
         So when it is cold everywhere else, come down to Florida where it is sunny and warm to enjoy some PHP, learning, community, and fun!
     </p>
     <p>
         <a href="http://sunshinephp.com/" title="SunshinePHP">SunshinePHP</a>
         <a href="https://twitter.com/hashtag/ssp15" title="SunshinePHP on Twitter">#ssp15</a>
     </p>
     <p>
         NOTE: Yes, there will be elePHPants!
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-10-16-3" href="http://php.net/archive/2014.php#id2014-10-16-3" rel="bookmark" class="bookmark">PHP 5.6.2 is available</a></h2>
  </header>
  <time class="newsdate" datetime="2014-10-16T16:26:14-07:00">16 Oct 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP 5.6.2.
     Four security-related bugs were fixed in this release, including fixes for CVE-2014-3668, CVE-2014-3669 and CVE-2014-3670.
     All PHP 5.6 users are encouraged to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.6.2 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.6.2">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-10-16-2" href="http://php.net/archive/2014.php#id2014-10-16-2" rel="bookmark" class="bookmark">PHP 5.4.34 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-10-16T15:32:14-07:00">16 Oct 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP
     5.4.34. 6 security-related bugs were fixed in this release, including fixes for
     CVE-2014-3668, CVE-2014-3669 and CVE-2014-3670. Also, a fix for OpenSSL which
     produced regressions was reverted.

     All PHP 5.4 users are encouraged to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.4.34 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.34">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-10-16-1" href="http://php.net/archive/2014.php#id2014-10-16-1" rel="bookmark" class="bookmark">PHP 5.5.18 is available</a></h2>
  </header>
  <time class="newsdate" datetime="2014-10-16T13:32:40+00:00">16 Oct 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP
     5.5.18. Several bugs were fixed in this release. A regression in OpenSSL introduced in PHP 5.5.17 has
     also been addressed in this release.
     PHP 5.5.18 also fixes 4 CVEs in different components.

     All PHP 5.5 users are encouraged to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.5.18 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.5.18">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-10-02-1" href="http://php.net/archive/2014.php#id2014-10-02-1" rel="bookmark" class="bookmark">PHP 5.6.1 released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-10-02T16:44:05-07:00">02 Oct 2014</time>
  <div class="newscontent">
    <div>
      <p>The PHP development team announces the immediate availability of PHP
     5.6.1. Several bugs were fixed in this release.

     All PHP 5.6 users are encouraged to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.6.1 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.6.1">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://www.phpconference.com.au", "php-australia-march12.png", "PHP Australia Conference 2015"); ?></div>
    <h2 class="newstitle"><a id="id2014-09-26-1" href="http://www.phpconference.com.au" rel="bookmark" class="bookmark">PHP Australia Conference 2015</a></h2>
  </header>
  <time class="newsdate" datetime="2014-09-26T09:52:27+02:00">26 Sep 2014</time>
  <div class="newscontent">
    <div>
     <p>
         We are extremely pleased to be hosting Australia’s first ever PHP
         Conference on the 12th &amp; 13th March 2015 in Sydney. This conference
         has been a long time coming. We aim to inspire, educate and motivate
         our brilliant PHP Australia developers. We are delighted to be hosting
         this event where beginner, intermediate to skilled developers are
         welcome to participate. Please join us on this opportunity, share your
         ideas, get valuable knowledge, collaborate with your peers and enjoy
         this amazing adventure.
     </p>

     <p>
         With more than 200 delegates expected over two days, this will be the
         highlight of our 2015 calendar. We will be welcoming some amazing
         international and local speakers to share their knowledge.
     </p>

     <p>
         <a href="http://www.phpconference.com.au">http://www.phpconference.com.au</a>
         <a href="https://twitter.com/hashtag/PHPOZ15">#phpoz15</a>
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-09-18-2" href="http://php.net/archive/2014.php#id2014-09-18-2" rel="bookmark" class="bookmark">PHP 5.4.33 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-09-18T20:03:36-07:00">18 Sep 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP
     5.4.33. 10 bugs were fixed in this release.

     All PHP 5.4 users are encouraged to upgrade to this version.
     </p>

     <p>
     This release is the last planned release that contains regular bugfixes. All the consequent releases
     will contain only security-relevant fixes, for the term of one year.
     PHP 5.4 users that need further bugfixes are encouraged to upgrade to PHP 5.6 or PHP 5.5.
     </p>

     <p>For source downloads of PHP 5.4.33 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.33">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-09-18-1" href="http://php.net/archive/2014.php#id2014-09-18-1" rel="bookmark" class="bookmark">PHP 5.5.17 is available</a></h2>
  </header>
  <time class="newsdate" datetime="2014-09-18T11:55:24+00:00">18 Sep 2014</time>
  <div class="newscontent">
    <div>
      <p>The PHP development team announces the immediate availability of PHP
     5.5.17. Several bugs were fixed in this release.

     All PHP 5.5 users are encouraged to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.5.17 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.5.17">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-08-28-1" href="http://php.net/archive/2014.php#id2014-08-28-1" rel="bookmark" class="bookmark">PHP 5.6.0 released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-08-28T08:14:28+00:00">28 Aug 2014</time>
  <div class="newscontent">
    <div>
    <p>The PHP Development Team announces the immediate availability of PHP 5.6.0.
This new version comes with new features, some backward incompatible changes and many improvements.
</p>

        <p><b>The main features of PHP 5.6.0 include:</b></p>
        <ul>
         <li><a href="http://php.net/migration56.new-features#migration56.new-features.const-scalar-exprs">Constant scalar expressions</a>.</li>
         <li><a href="http://php.net/functions.arguments#functions.variable-arg-list">Variadic functions</a> and argument unpacking using the <code>...</code> operator.</li>
         <li><a href="http://php.net/language.operators.arithmetic">Exponentiation using the <code>**</code> operator</a>.</li>
         <li><a href="http://php.net/migration56.new-features#migration56.new-features.use">Function and constant importing</a> with the <a href="http://php.net/language.namespaces.importing">use keyword</a>.</li>
         <li><a href="http://phpdbg.com/docs">phpdbg</a> as an interactive integrated debugger SAPI.</li>
         <li><a href="http://php.net/wrappers#wrappers.php.input">php://input</a> is now reusable, and <code>$HTTP_RAW_POST_DATA</code> is deprecated.</li>
         <li><a href="http://php.net/book.gmp">GMP</a> objects now support operator overloading.</li>
         <li>File uploads larger than 2 gigabytes in size are now accepted.</li>
        </ul>

        <p>For a full list of new features, you may read <a href="http://php.net/migration56.new-features">the new features chapter of the migration guide</a>.</p>

        <p>
        <b>PHP 5.6.0 also introduces changes that affect compatibility:</b>
        </p>

        <ul>
         <li>Array keys won't be overwritten when defining an array as a property of a class via an array literal.</li>
         <li><a href="http://php.net/function.json-decode">json_decode()</a> is more strict in JSON syntax parsing.</li>
         <li>Stream wrappers now verify peer certificates and host names by default when using SSL/TLS.</li>
         <li><a href="http://php.net/book.gmp">GMP</a> resources are now objects.</li>
         <li><a href="http://php.net/book.mcrypt">Mcrypt</a> functions now require valid keys and IVs.</li>
        </ul>

        <p>
         For users upgrading from PHP 5.5, <a href="http://php.net/migration56">a full migration guide</a> is available, detailing the changes between 5.5 and 5.6.0.
        </p>

        <p>For source downloads of PHP 5.6.0, please visit our <a href="http://www.php.net/downloads.php">downloads page</a>.
        Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
        The full list of changes is available in the <a href="http://www.php.net/ChangeLog-5.php#5.6.0">ChangeLog</a>.
        </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://world.phparch.com/", "conference_php_world_11_10.png", "php[world] in Washington, D.C."); ?></div>
    <h2 class="newstitle"><a id="id2014-08-27-1" href="http://world.phparch.com/" rel="bookmark" class="bookmark">php[world] in Washington, D.C.</a></h2>
  </header>
  <time class="newsdate" datetime="2014-08-27T21:06:14+02:00">27 Aug 2014</time>
  <div class="newscontent">
    <div>
     <p>The team at <a href="http://www.phparch.com/" title="php[architect] : Magazine, Training, Books, Conferences">php[architect]</a> is excited to
         announce our new conference: <a href="http://world.phparch.com/" title="php[world] conference">php[world]</a>!  This conference, is being
         designed to bring together all of the various PHP communities into one
         place to share ideas together.
     </p>
     <p>Whether you are a core PHP developer, or use WordPress, Drupal,
         Magento, Joomla!, Symfony, Laravel, Zend Framework or another framework.
         This conference has a track specifically for you!  Check out our
         published <a href="http://world.phparch.com/schedule/">schedule</a> and
         <a href="http://world.phparch.com/speakers/">speaker list</a> to see all
         the sessions available.
     </p>
     <p>The conference takes place on November 10-14, 2014 in Washington, DC,
         USA.  It features a Training Day, Tutorial Day, and 3 days full of
         sessions &amp; keynotes.  Our Training day includes full day trainings on
         WordPress, Web Security, and an Introduction to PHP.
     </p>
     <p>We've recently announced our <a href="http://world.phparch.com/five-amazing-keynotes/">keynote
         lineup</a> as well, including:
     </p>
     <ul>
         <li><b>Angela Byron</b> - @webchick - Core Contributor to Drupal</li>
         <li><b>Andrew Nacin</b> - @nacin - Lead Developer on WordPress</li>
         <li><b>Jeffrey 'jam' McQuire</b> - @horncologne - Open Source
             Evangelist for Acquia
         </li>
         <li><b>Luke Stokes</b> - @lukestokes - Founder and CTO of FoxyCart</li>
         <li>Plus we will be ending the conference with the
             <b><i>biggest</i></b> panel around.  Featuring key notables from at
             least seven different of the most popular PHP applications and
             frameworks to discuss, debate, and answer your questions.
         </li>
     </ul>
     <p>For more information and to purchase your tickets, head over to
         <a href="http://world.phparch.com/">world.phparch.com</a> and we look
         forward to seeing you in D.C.!
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-08-22-1" href="http://php.net/archive/2014.php#id2014-08-22-1" rel="bookmark" class="bookmark">PHP 5.5.16 is released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-08-22T07:59:58+00:00">22 Aug 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP Development Team announces the immediate availability of PHP 5.5.16.
This release fixes several bugs against PHP 5.5.15 and resolves CVE-2014-3538, CVE-2014-3587,
CVE-2014-2497, CVE-2014-5120 and CVE-2014-3597.
</p>

<p>All PHP users are encouraged to upgrade to this new version.</p>

<p>For source downloads of PHP 5.5.16, please visit our <a href="http://www.php.net/downloads.php">downloads page</a>.
Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.5.16">ChangeLog</a>.
</p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-08-21-1" href="http://php.net/archive/2014.php#id2014-08-21-1" rel="bookmark" class="bookmark">PHP 5.4.32 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-08-21T17:27:58-07:00">21 Aug 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP
     5.4.32. 16 bugs were fixed in this release, including the following security-related issues:
     CVE-2014-2497, CVE-2014-3538, CVE-2014-3587, CVE-2014-3597, CVE-2014-4670, CVE-2014-4698, CVE-2014-5120.

     All PHP 5.4 users are encouraged to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.4.32 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.32">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-08-14-1" href="http://php.net/archive/2014.php#id2014-08-14-1" rel="bookmark" class="bookmark">Last 5.3 release ever available: PHP 5.3.29 - 5.3 now EOL</a></h2>
  </header>
  <time class="newsdate" datetime="2014-08-14T14:26:40+02:00">14 Aug 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of
     PHP 5.3.29. This release marks the <strong>end of life</strong> of the <strong>PHP 5.3 series</strong>.
     Future releases of this series are <strong>not planned</strong>. All PHP 5.3 users are
     encouraged to upgrade to the current stable version of PHP 5.5 or
     previous stable version of PHP 5.4, which are supported till at least
     2016 and 2015 respectively.</p>

     <p>PHP 5.3.29 contains about 25 potentially security related fixes
	     backported from PHP 5.4 and 5.5.</p>

     <p>For source downloads of PHP 5.3.29, please visit our <a href="http://www.php.net/downloads.php">downloads page</a>. Windows
     binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>. The list of changes is recorded in
     the <a href="http://www.php.net/ChangeLog-5.php#5.3.29">ChangeLog</a>.</p>

     <p>For helping your migration to newer versions please refer to our migration
     guides for updates from <a href="http://php.net/migration54">PHP 5.3 to
	     5.4</a> and from <a href="http://php.net/migration55">PHP 5.4 to 5.5</a>.</p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-08-14-2" href="http://php.net/archive/2014.php#id2014-08-14-2" rel="bookmark" class="bookmark">PHP 5.6.0RC4 is available</a></h2>
  </header>
  <time class="newsdate" datetime="2014-08-14T23:23:50-07:00">14 Aug 2014</time>
  <div class="newscontent">
    <div>
      <p>
        The PHP development team announces the immediate availability of the fourth and
        hopefully last release candidate of PHP 5.6.0. As we entered the feature freeze
        with beta1, this is a bugfix-only release. All users of PHP are encouraged to test
        this version carefully, and report any bugs in <a href="https://bugs.php.net">
        the bug tracking system</a>.
      </p>

      <p>
        <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>
      </p>

      <p>
        For more information about the new features you can check out the work-in-progress
        <a href="http://www.php.net/manual/en/migration56.new-features.php">documentation</a>
        or you can read the full list of changes in the
        <a href="https://github.com/php/php-src/blob/php-5.6.0RC4/NEWS">NEWS file</a>
        contained in the release archive.
      </p>

      <p>
        For source downloads of PHP 5.6.0RC4 please visit
        the <a href="http://qa.php.net/">download page</a>. Windows binaries
        can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
      </p>

      <p>
        The stable 5.6.0 release should show up on the 28th of August.
      </p>

      <p>
        Thank you for helping us make PHP better.
      </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://cakefest.org/", "cakefest-2014.png", "CakeFest 2014"); ?></div>
    <h2 class="newstitle"><a id="id2014-08-04-3" href="http://cakefest.org/" rel="bookmark" class="bookmark">CakeFest 2014 - The CakePHP Conference</a></h2>
  </header>
  <time class="newsdate" datetime="2014-08-04T21:11:08+01:00">04 Aug 2014</time>
  <div class="newscontent">
    <div>
      <p>
        <a href="http://cakefest.org/">CakeFest</a> is the annual conference
        dedicated to the CakePHP framework and related technologies, hosting
        live workshops, and inviting a variety of great speakers, to give the
        very best in presentations and talks on the latest from the community.
        This year the conference comes to Madrid, Spain, and takes place from
        August 21st until August 24th.
      </p>
      <p>
        The workshops are a great way to learn CakePHP, and get up-to-date with
        the latest version 3.0 and innovations directly from the core
        developers, while the conference days are packed with presentations,
        discussions and talks, and an ideal moment to learn more from
        the community.
      </p>
      <p>
        It's a great opportunity to network, meet friends old and new, and have
        some fun with the core members of the project. Plus, there's cake!
      </p>
      <p>
        Tickets are available <a href="http://cakefest.org/">here</a> and a list of conference
        speakers is available <a href="http://cakefest.org/schedule">here</a>.
      </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://www.madisonphpconference.com/", "madison-php-2013.png", "Madison PHP Conference 2014"); ?></div>
    <h2 class="newstitle"><a id="id2014-08-04-2" href="http://www.madisonphpconference.com/" rel="bookmark" class="bookmark">Madison PHP Conference 2014</a></h2>
  </header>
  <time class="newsdate" datetime="2014-08-04T20:57:13+01:00">04 Aug 2014</time>
  <div class="newscontent">
    <div>
      <p>
        One day, three tracks, more fun than a barrel of elePHPants!
      </p>
      <p>
        Join us for a one day, three-track conference that focuses on PHP and
        related web technologies. This event is organized by Madison PHP and is
        designed to offer something to attendees at all skill levels. It will
        be a day of networking, learning, sharing, and great fun!
      </p>
      <p>
        <strong>Three Tracks</strong>
      </p>
      <p>
        We've carefully crafted three distinct tracks but you're not locked
        into just one. Attend any talk from any track.
      </p>
      <p>
        <strong>PHP Foundations Track</strong>
      </p>
      <p>
        Learn the basics of PHP development. A carefully selected set of talks
        for those who have never programmed before or who are new to PHP and
        would like a refresher of the basics.
      </p>
      <p>
        <strong>PHP Professional Track (2x)</strong>
      </p>
      <p>
        Explore new technologies and techniques. Gather with other seasoned
        developers and increase your value with a series of talks that will
        both energize and get you excited about the future of PHP.
      </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("https://www.brnophp.cz/conference-2014", "brnophp-conference-2014.png", "BRNO PHP Conference 2014"); ?></div>
    <h2 class="newstitle"><a id="id2014-08-04-1" href="https://www.brnophp.cz/conference-2014" rel="bookmark" class="bookmark">Brno PHP Conference 2014</a></h2>
  </header>
  <time class="newsdate" datetime="2014-08-04T20:41:07+01:00">04 Aug 2014</time>
  <div class="newscontent">
    <div>
      <p>
        Brno PHP Conference 2014 - 20th of September 2014
      </p>
      <p>
        We are pleased to announce the first international PHP conference in Czech
        Republic. Over the years, the creative minds behind this conference,
        gathered experience and motivation to do something bigger and unique. Being
        the first of its kind, it brings together great technology content and
        great people. You will find a high-quality presentations by the brightest
        experts in the PHP world, coupled with a welcoming and friendly community
        of attendees and speakers.
      </p>
      <p>
        We have special events <a href="https://www.brnophp.cz/workshop-microsoft-azure">Microsoft Azure Workshop</a>
        and a smashing <a href="https://www.brnophp.cz/conference-2014-after-party">After Party</a>.
      </p>
      <p>
        See a schedule at <a href="https://www.brnophp.cz/conference-2014">https://www.brnophp.cz/conference-2014</a>
        and you certainly enjoy it!
      </p>
      <p>
        Looking forward to see you there :-)
      </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-07-31-1" href="http://php.net/archive/2014.php#id2014-07-31-1" rel="bookmark" class="bookmark">PHP 5.6.0RC3 is available</a></h2>
  </header>
  <time class="newsdate" datetime="2014-07-31T13:50:59-07:00">31 Jul 2014</time>
  <div class="newscontent">
    <div>
      <p>
        The PHP development team announces the immediate availability of the third release
        candidate of PHP 5.6. As we entered the feature freeze with beta1, this is a
        bugfix-only release. All users of PHP are encouraged to test this version carefully,
        and report any bugs in <a href="https://bugs.php.net">the bug tracking system</a>.
      </p>

      <p>
        <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>
      </p>

      <p>
        For more information about the new features you can check out the work-in-progress
        <a href="http://www.php.net/manual/en/migration56.new-features.php">documentation</a>
        or you can read the full list of changes in the
        <a href="https://github.com/php/php-src/blob/php-5.6.0RC3/NEWS">NEWS file</a>
        contained in the release archive.
      </p>

      <p>
        For source downloads of PHP 5.6.0RC3 please visit
        the <a href="http://qa.php.net/">download page</a>. Windows binaries
        can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
      </p>

      <p>
        Our next Release Candidate should show up on the 14th of August.
      </p>

      <p>
        Thank you for helping us make PHP better.
      </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-07-24-2" href="http://php.net/archive/2014.php#id2014-07-24-2" rel="bookmark" class="bookmark">PHP 5.4.31 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-07-24T21:30:09-07:00">24 Jul 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP
     5.4.31. Over 10 bugs were fixed in this release.

     All PHP 5.4 users are encouraged to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.4.31 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.31">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-07-24-1" href="http://php.net/archive/2014.php#id2014-07-24-1" rel="bookmark" class="bookmark">PHP 5.5.15 is released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-07-24T09:01:34+00:00">24 Jul 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP Development Team announces the immediate availability of PHP 5.5.15.
This release fixes several bugs against PHP 5.5.14.
</p>

<p>All PHP users are encouraged to upgrade to this new version.</p>

<p>For source downloads of PHP 5.5.15, please visit our <a href="http://www.php.net/downloads.php">downloads page</a>.
Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.5.15">ChangeLog</a>.
</p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://www.phpsouthafrica.com/", "capetown2014.png", "PHP Cape Town"); ?></div>
    <h2 class="newstitle"><a id="id2014-07-08-1" href="http://www.phpsouthafrica.com/" rel="bookmark" class="bookmark">PHP Cape Town Conference</a></h2>
  </header>
  <time class="newsdate" datetime="2014-07-08T17:03:44-07:00">08 Jul 2014</time>
  <div class="newscontent">
    <div>
     <p>
     Cape Town's 2nd Annual PHP Conference is here... 2nd – 4th October 2014
     </p>

     <p>
     We are excited to announce our 2nd Annual
     <a href="http://www.phpsouthafrica.com/">PHP Cape Town Conference</a>, 3 Days
     at The Cape Town Stadium overlooking the Atlantic Ocean - yip insane views.
     </p>

     <p>
     Keeping with our winning formula of international speakers combined with some
     great local talent to learn off. With over 300 delegates expected, you do not
     want to miss this one.
     </p>

     <p>
     PHP Cape Town 2013 SOLD OUT in less than 4 weeks and it will happen again.
     </p>

     <p>
     If you're PHP-Curious or Skilled Developer we would like you to share in the
     experience. Thank You to the PHP Cape Town Community for volunteering and
     helping out. Call for Papers will close 20th July 2014.
     </p>

     <ul>
       <li>12 Speakers</li>
       <li>6 Practical Workshop Sessions</li>
       <li>Great Sponsors</li>
       <li>Free Swag, T Shirt and Books</li>
       <li>Prize Draws</li>
     </ul>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-07-03-1" href="http://php.net/archive/2014.php#id2014-07-03-1" rel="bookmark" class="bookmark">PHP 5.6.0RC2 is available</a></h2>
  </header>
  <time class="newsdate" datetime="2014-07-03T14:16:36-07:00">03 Jul 2014</time>
  <div class="newscontent">
    <div>
      <p>
        The PHP development team announces the immediate availability of the second release
        candidate of PHP 5.6. As we entered the feature freeze with beta1, this is a
        bugfix-only release. All users of PHP are encouraged to test this version carefully,
        and report any bugs in <a href="https://bugs.php.net">the bug tracking system</a>.
      </p>

      <p>
        <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>
      </p>

      <p>
        For more information about the new features you can check out the work-in-progress
        <a href="http://www.php.net/manual/en/migration56.new-features.php">documentation</a>
        or you can read the full list of changes in the
        <a href="https://github.com/php/php-src/blob/php-5.6.0RC2/NEWS">NEWS file</a>
        contained in the release archive.
      </p>

      <p>
        For source downloads of PHP 5.6.0RC2 please visit
        the <a href="http://qa.php.net/">download page</a>. Windows binaries
        can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
      </p>

      <p>
        Our third Release Candidate should show up on the 17th of July.
      </p>

      <p>
        Thank you for helping us make PHP better.
      </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-06-27-1" href="http://php.net/archive/2014.php#id2014-06-27-1" rel="bookmark" class="bookmark">PHP 5.5.14 is released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-06-27T09:40:44+00:00">27 Jun 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP Development Team announces the immediate availability of PHP 5.5.14.
        This release fixes several bugs against PHP 5.5.13.
        Also, this release fixes a total of 8 CVEs, half of them concerning the FileInfo
        extension.</p>

        <p>All PHP users are encouraged to upgrade to this new version.</p>

        <p>Please, note that this release also fixes a backward compatibility issue that has been
        detected in the PHP 5.5.13 release. Still, the fix in PHP 5.5.14 may break some very rare
        situations. As this tiny compatibility break involves security, and as security is our primary
        concern, we had to fix it. This concerns
        <a href="https://bugs.php.net/bug.php?id=67072">bug 67072</a>. For more information about
        this bug and its actual resolution, please visit our
        <a href="https://github.com/php/php-src/raw/PHP-5.5/UPGRADING">upgrading guide</a>.
        We apologize for any inconvenience you may have experienced with this behavior.</p>

        <p>For source downloads of PHP 5.5.14, please visit our <a href="http://www.php.net/downloads.php">downloads page</a>.
        Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
        The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.5.14">ChangeLog</a>.
        </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-06-26-1" href="http://php.net/archive/2014.php#id2014-06-26-1" rel="bookmark" class="bookmark">PHP 5.4.30 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-06-26T15:31:05-07:00">26 Jun 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP
     5.4.30. Over 20 bugs were fixed in this release, including the following security issues:
     CVE-2014-3981, CVE-2014-0207, CVE-2014-3478, CVE-2014-3479, CVE-2014-3480, CVE-2014-3487,
     CVE-2014-4049, CVE-2014-3515.

     All PHP 5.4 users are encouraged to upgrade to this version.
     </p>

     <p>Please, note that this release also fixes a backward compatibility issue that has been
     detected in the PHP 5.4.29 release. Still, the fix in PHP 5.4.30 may break some very rare
     situations. As this tiny compatibility break involves security, and as security is our primary
     concern, we had to fix it. This concerns
     <a href="https://bugs.php.net/bug.php?id=67072">bug 67072</a>. For more information about
     this bug and its actual resolution, please refer to our
     <a href="https://github.com/php/php-src/raw/PHP-5.4/UPGRADING">upgrading guide</a>, section 4a.
     We apologize for any inconvenience you may have experienced with this behavior.</p>


     <p>For source downloads of PHP 5.4.30 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.30">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://phpconference.com/", "ipc2014-oct.png", "International PHP Conference 2014"); ?></div>
    <h2 class="newstitle"><a id="id2014-06-19-3" href="http://phpconference.com/" rel="bookmark" class="bookmark">International PHP Conference 2014</a></h2>
  </header>
  <time class="newsdate" datetime="2014-06-19T23:29:15+00:00">19 Jun 2014</time>
  <div class="newscontent">
    <div>
     <p>
       As the world's first conference for PHP professionals, movers and
       shakers, the International PHP Conference has established itself as
       one of the most important meeting places for developers and decision
       makers. This year's IPC presents 4 days packed with know-how about
       PHP and web technologies, from October 26 to 29 in Munich.
     </p>
     <p>
       Highlights 2014
     </p>
     <ul>
       <li><strong>90+ </strong>best practice sessions with <strong>60+</strong> international top speakers</li>
       <li>Hands on Power Workshop Day on Sunday (October 26, 2014) </li>
       <li><b>2-day expo</b> with exciting exhibitors</li>
       <li><strong>Conference Combo: </strong>Visit the <a href="http://www.webtechcon.de/" title="WebTech Conference 2014">WebTech Conference</a> for free</li>
       <li><strong>All inclusive:</strong> Changing buffets, snacks &amp; refreshing drinks</li>
       <li>Official <strong>conference certificate</strong> for all attendees</li>
       <li><strong>Free Swag:</strong> Developer backpack, T-Shirt, magazines etc.</li>
       <li>Networking at exclusive <strong>community events</strong></li>
       <li>And so much more... <a href="http://phpconference.com/">http://phpconference.com</a></li>
     </ul>
     <p>
       To get in touch, please follow us on <a href="http://twitter.com/phpconference">Twitter</a>,
       <a href="https://www.facebook.com/ipc.germany">Facebook</a> and
       <a href="https://plus.google.com/b/109347669400413843557/109347669400413843557/posts">Google+</a>
       and see you soon in Munich!
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://www.phpconference.co.nz/", "newzealand-2014.png", "New Zealand PHP Conference 2014"); ?></div>
    <h2 class="newstitle"><a id="id2014-06-19-2" href="http://www.phpconference.co.nz/" rel="bookmark" class="bookmark">New Zealand PHP Conference 2014</a></h2>
  </header>
  <time class="newsdate" datetime="2014-06-19T23:19:54+00:00">19 Jun 2014</time>
  <div class="newscontent">
    <div>
     <p>
     We're thrilled to announce the <a href="http://www.phpconference.co.nz/">2014
     New Zealand PHP Conference</a> held on 27th, 28th and 29th August at The
     Victoria Business School located in the coolest little capital in the world,
     Wellington - New Zealand.
     </p>


     <p>
     This conference promises to be one of the most important IT events connecting
     the Oceania PHP Community, with highly recognized speakers presenting two
     concurrent tracks including over 22 talks exploring PHP trends and other web
     technologies to both inspire and challenge you.
     </p>

     <p>
     A tutorial day on Wednesday 27th August provides an opportunity to spend some
     time with experts, going in-depth on particular topics. This is an opportunity
     to rub shoulders with national and international speakers, Web developers and
     leading IT companies from all over New Zealand, Australia and the global PHP
     community.
     </p>

     <p>
     Our main topics are: SilverStripe, Apigility, Zend Framework 2, Laravel,
     Symfony, Scaling PHP, Performance Testing, Web optimization, AngularJS, Apache
     Cassandra, Security, Cloud, Working remotely, Patterns, OOP, Raspberry Pi,
     Arduino and PHP and much more.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-06-19-1" href="http://php.net/archive/2014.php#id2014-06-19-1" rel="bookmark" class="bookmark">PHP 5.6.0RC1 is available</a></h2>
  </header>
  <time class="newsdate" datetime="2014-06-19T15:22:27-07:00">19 Jun 2014</time>
  <div class="newscontent">
    <div>
      <p>
        The PHP development team announces the immediate availability of the first release
        candidate of PHP 5.6. As we entered the feature freeze with beta1, this is a
        bugfix-only release. All users of PHP are encouraged to test this version carefully,
        and report any bugs in <a href="https://bugs.php.net">the bug tracking system</a>.
      </p>

      <p>
        <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>
      </p>

      <p>
        For more information about the new features you can check out the work-in-progress
        <a href="http://www.php.net/manual/en/migration56.new-features.php">documentation</a>
        or you can read the full list of changes in the
        <a href="https://github.com/php/php-src/blob/php-5.6.0RC1/NEWS">NEWS file</a>
        contained in the release archive.
      </p>

      <p>
        For source downloads of PHP 5.6.0RC1 please visit
        the <a href="http://qa.php.net/">download page</a>. Windows binaries
        can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
      </p>

      <p>
        Our second Release Candidate should show up on the 3rd of July.
      </p>

      <p>
        Thank you for helping us make PHP better.
      </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-06-05-1" href="http://php.net/archive/2014.php#id2014-06-05-1" rel="bookmark" class="bookmark">PHP 5.6.0beta4 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-06-05T13:20:11-07:00">05 Jun 2014</time>
  <div class="newscontent">
    <div>
      <p>
        The PHP development team announces the immediate availability of PHP 5.6.0beta4.
        As we entered the feature freeze with beta1, this is a bugfix-only release.
        All users of PHP are encouraged to test this version carefully, and report any
        bugs in <a href="https://bugs.php.net">the bug tracking system</a>.
      </p>

      <p>
        The beta phase is officially closed with this release. A couple of RCs are to be
        expected, until we are confident that the release is stable enough for the final
        release. For that, we really need your help in testing and reporting any problems
        that you encounter.
      </p>

      <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>

      <p>
        For more information about the new features you can check out the work-in-progress
        <a href="http://docs.php.net/manual/en/migration56.new-features.php">documentation</a>
        or you can read the full list of changes in the
        <a href="https://github.com/php/php-src/blob/php-5.6.0beta4/NEWS">NEWS file</a>
        contained in the release archive.
      </p>

      <p>
        For source downloads of PHP 5.6.0beta4 please visit
        the <a href="http://qa.php.net/">download page</a>. Windows binaries
        can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
      </p>

      <p>
        Our first Release Candidate should show up on the 19th of June.
      </p>

      <p>
        Thank you for helping us make PHP better.
      </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-05-29-5" href="http://php.net/archive/2014.php#id2014-05-29-5" rel="bookmark" class="bookmark">PHP 5.4.29 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-05-29T15:53:48-07:00">29 May 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP
     5.4.29. 16 bugs were fixed in this release, including two security issues in fileinfo extension.
     All PHP 5.4 users are encouraged to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.4.29 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.29">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-05-29-3" href="http://php.net/archive/2014.php#id2014-05-29-3" rel="bookmark" class="bookmark">PHP 5.5.13 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-05-29T09:18:44+00:00">29 May 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP Development Team announces the immediate availability of PHP 5.5.13.
        This release fixes several bugs in PHP 5.5.12, and addresses two
        CVEs in Fileinfo (CVE-2014-0238 and CVE-2014-0237).</p>

        <p>All PHP users are encouraged to upgrade to this new version.</p>

        <p>For source downloads of PHP 5.5.13, please visit our <a href="http://www.php.net/downloads.php">downloads page</a>.
        Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
        The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.5.13">ChangeLog</a>.
        </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://devconf.ru", "devconfru2012.png", "DevConf 2014"); ?></div>
    <h2 class="newstitle"><a id="id2014-05-29-3" href="http://devconf.ru" rel="bookmark" class="bookmark">DevConf 2014</a></h2>
  </header>
  <time class="newsdate" datetime="2014-05-29T16:57:52+00:00">29 May 2014</time>
  <div class="newscontent">
    <div>
     <p>
      DevConf 2014 in Moscow, Russia on Jun 14
     </p>
     <p>
      DevConf is the ultimate meeting place for russian-speaking web-developers,
      combining several language-specific conferences under one roof.
     </p>
     <p>
      This year DevConf will include the following sections:
     </p>
     <ul>
      <li>DevConf::PHP();</li>
      <li>DevConf::Ruby();</li>
      <li>DevConf::Python();</li>
      <li>DevConf::Javascript();</li>
      <li>DevConf::Mobi();</li>
      <li>DevConf::Storage();</li>
     </ul>
     <p>
      Each section will feature several talks from the active contributors/authors of the language.
	  Among the invited speakers are Dmitry Stogov (Zend), Shawn McCool (Laravel), Dmitry Vyukov (Google),
      Sveta Smirnova (Oracle), Andrey Aksyonov (Sphinx), Anatoly Panov (Badoo) and many others,
      see more details on <a href="http://devconf.ru">the official website</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://cfp.zendcon.com", "ZendCon2014.png", "ZendCon 2014"); ?></div>
    <h2 class="newstitle"><a id="id2014-05-29-2" href="http://cfp.zendcon.com" rel="bookmark" class="bookmark">ZendCon 2014 - 10th Annual Event</a></h2>
  </header>
  <time class="newsdate" datetime="2014-05-29T03:11:15+02:00">29 May 2014</time>
  <div class="newscontent">
    <p xmlns="http://www.w3.org/2005/Atom">We’re pleased to announce the 10th annual ZendCon which will be held October 27-30th, 2014 in Santa Clara, CA. ZendCon 2014 has a long history of being one of the “must attend” PHP conferences as community members from around the world have come together to learn and share information about the latest trends and technologies in professional PHP development. Our main topics this year are:</p>

     <ul xmlns="http://www.w3.org/2005/Atom">
        <li>PHP Best Practices and Tooling</li>
        <li>Continuous Delivery and DevOps</li>
        <li>Application Architecture - APIs, Mobile, Cloud Services</li>
    </ul>

    <p xmlns="http://www.w3.org/2005/Atom">
        We would welcome submission of any talk included in the wide variety of
        topics related to PHP and tools commonly used by PHP developers. We are
        looking for submissions for:
    </p>

    <ul xmlns="http://www.w3.org/2005/Atom">
        <li>Pre-conference tutorials on October 27 - 3 hour intensive session</li>
        <li>Breakout sessions on October 28, 29 and 30 - 1 hour sessions including Q&amp;A</li>
        <li>Keynote sessions on October 28-30 – 1 hour sessions with topics appealing to the entire audience</li>
    </ul>

    <p xmlns="http://www.w3.org/2005/Atom">
        For those interested in speaking, please head out to
        <a href="http://cfp.zendcon.com">http://cfp.zendcon.com</a> to
        submit on or before June 16th, 2014.
    </p>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://www.phpconchina.com/", "china2014conference.png", "China PHP Conference 2014"); ?></div>
    <h2 class="newstitle"><a id="id2014-05-29-1" href="http://www.phpconchina.com/" rel="bookmark" class="bookmark">China PHP Conference 2014</a></h2>
  </header>
  <time class="newsdate" datetime="2014-05-29T01:43:06+02:00">29 May 2014</time>
  <div class="newscontent">
    <div>
     <p>2nd Annual China PHP Conference – August 2 to 3, Shanghai!</p>

     <p>ThinkInLAMP will be hosting a 2-day event filled with high quality,
     technical sessions about PHP Core, PHP High Performance, PHP Engineering,
     and more PHP. During this conference, you will hear from Xinchen Hui, a PHP
     core developer.
     </p>

     <p>Don’t miss out on 2 great days of sessions, delicious food, fantastic shows,
     and countless networking opportunities to engage with speakers and
     delegates. For tickets and more information, see: <a href="http://www.phpconchina.com/">www.phpconchina.com</a></p>


    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-05-27-1" href="http://php.net/archive/2014.php#id2014-05-27-1" rel="bookmark" class="bookmark">PHP Next Generation</a></h2>
  </header>
  <time class="newsdate" datetime="2014-05-27T17:28:16+00:00">27 May 2014</time>
  <div class="newscontent">
    <div>
     <p>When we aren't looking for pictures of kittens on the internet, internals developers are nearly always looking for ways to improve PHP, a few developers have a focus on performance.</p>
     <p>Over the last year, some research into the possibility of introducing JIT compilation capabilities to PHP has been conducted.</p>
     <p>During this research, the realization was made that in order to achieve optimal performance from PHP, some internal API's should be changed.</p>
     <p>This necessitated the birth of the phpng branch, initially authored by Dmitry Stogov, Xinchen Hui, and Nikita Popov. This branch does not include JIT capabilities, but rather seeks to solve those problems that prohibit the current, and any future implementation of a JIT capable executor achieving optimal performance by improving memory usage and cleaning up some core API's.</p>
     <p>By making these improvements, the phpng branch gives us a considerable performance gain in real world applications, for example a 20% increase in throughput for Wordpress. The door may well now be open for a JIT capable compiler that can perform as we expect, but it's necessary to say that these changes stand strong on their own, without requiring a JIT capable compiler in the future to validate them.</p>
     <p>The name "Next Generation" was optimistically presumptuous; in reality phpng is an internal project that we are working on, it is not a production ready branch that anyone should deploy, or judge as they would a release of PHP.</p>
     <p>The work on phpng, the doors it opens, the conversations it has started, the collaboration it is inspiring, are all worth getting excited about. But, we need to stay grounded, honest, and open; and say that there is much work to do in order to make the "Next Generation" a reality, this is only the start.</p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-05-15-1" href="http://php.net/archive/2014.php#id2014-05-15-1" rel="bookmark" class="bookmark">PHP 5.6.0beta3 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-05-15T17:07:04+02:00">15 May 2014</time>
  <div class="newscontent">
    <div>
      <p>
        The PHP development team announces the immediate availability of PHP 5.6.0beta3.
        As we entered the feature freeze with beta1, this is a bugfix-only release.
        All users of PHP are encouraged to test this version carefully,
        and report any bugs in <a href="https://bugs.php.net">the bug tracking system</a>.
     </p>

     <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>

     <p>For more information about the new features you can check out the work-in-progress
      <a href="http://docs.php.net/manual/en/migration56.new-features.php">documentation</a>
      or you can read the full list of changes in the
      <a href="https://github.com/php/php-src/blob/php-5.6.0beta3/NEWS">NEWS file</a> contained
      in the release archive.
     </p>

     <p>
      For source downloads of PHP 5.6.0beta3 please visit
      the <a href="http://qa.php.net/">download page</a>. Windows binaries
      can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
     </p>

     <p>
      Our fourth and final beta should show up on the 29th of May.
     </p>

     <p>
        Thank you for helping us make PHP better.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-05-02-1" href="http://php.net/archive/2014.php#id2014-05-02-1" rel="bookmark" class="bookmark">PHP 5.6.0beta2 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-05-02T08:42:52+02:00">02 May 2014</time>
  <div class="newscontent">
    <div>
      <p>
        The PHP development team announces the immediate availability of PHP 5.6.0beta2.
        As we entered the feature freeze with beta1, this release is almost exclusively
        a bugfix-only release.
        All users of PHP are encouraged to test this version carefully,
        and report any bugs in <a href="https://bugs.php.net">the bug tracking system</a>.
     </p>

     <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>

     <p>
      PHP 5.6.0beta2 comes with a small number of new features, including:
     </p>
     <ul>
        <li>Watchpoint support for phpdbg</li>
        <li>A new fetching mode to mysqlnd which uses less memory but implies more memory copy</li>
     </ul>

     <p>For more information about the new features you can check out the work-in-progress
      <a href="http://docs.php.net/manual/en/migration56.new-features.php">documentation</a>
      or you can read the full list of changes in the
      <a href="https://github.com/php/php-src/blob/php-5.6.0beta2/NEWS">NEWS file</a> contained
      in the release archive.
     </p>

     <p>
      For source downloads of PHP 5.6.0beta2 please visit
      the <a href="http://qa.php.net/">download page</a>. Windows binaries
      can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
     </p>

     <p>
      Our third beta should show up on the 15th of May.
     </p>

     <p>
        Thank you for helping us make PHP better.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-05-01-1" href="http://php.net/archive/2014.php#id2014-05-01-1" rel="bookmark" class="bookmark">PHP 5.4.28 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-05-01T22:32:15-07:00">01 May 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP
     5.4.28. 19 bugs were fixed in this release, including CVE-2014-0185.
     All PHP 5.4 users are encouraged to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.4.28 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.28">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-04-30-1" href="http://php.net/archive/2014.php#id2014-04-30-1" rel="bookmark" class="bookmark">PHP 5.5.12 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-04-30T09:01:48+00:00">30 Apr 2014</time>
  <div class="newscontent">
    <div>
        <p>The PHP Development Team announces the immediate availability of PHP 5.5.12.
        This release fixes several bugs against PHP 5.5.11, as well as CVE-2014-0185 regarding PHP-FPM.</p>

        <p>All PHP users are encouraged to upgrade to this new version.</p>

        <p>For source downloads of PHP 5.5.12, please visit our <a href="http://www.php.net/downloads.php">downloads page</a>.
        Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
        The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.5.12">ChangeLog</a>.
        </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-04-11-1" href="http://php.net/archive/2014.php#id2014-04-11-1" rel="bookmark" class="bookmark">PHP 5.6.0beta1 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-04-11T13:57:47+02:00">11 Apr 2014</time>
  <div class="newscontent">
    <div>
      <p>
        The PHP development team announces the immediate availability of
        PHP 5.6.0beta1. This release adds new features and fixes bugs and marks
        the feature freeze for the PHP 5.6.0 release.
        All users of PHP are encouraged to test this version carefully,
        and report any bugs in <a href="https://bugs.php.net">the bug tracking system</a>.
     </p>

     <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>

     <p>
      PHP 5.6.0beta1 comes with a number of new features, including:
     </p>
     <ul>
        <li>A new method called fread() to the SplFileObject class</li>
        <li>A new static method called createFromMutable() to the DateTimeImmutable class</li>
        <li>A new function called hash_equals()</li>
        <li>Support for marks to the PCRE extension</li>
        <li>Support for asynchronous connections and queries to the Pgsql extension</li>
     </ul>

     <p>For more information about the new features you can check out the work-in-progress
      <a href="http://docs.php.net/manual/en/migration56.new-features.php">documentation</a>
      or you can read the full list of changes in the
      <a href="https://github.com/php/php-src/blob/php-5.6.0beta1/NEWS">NEWS file</a> contained
      in the release archive.
     </p>

     <p>
      For source downloads of PHP 5.6.0beta1 please visit
      the <a href="http://qa.php.net/">download page</a>. Windows binaries
      can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
     </p>

     <p>
      Our second beta should show up on the 24th of April.
     </p>

     <p>
        Thank you for helping us make PHP better.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-04-03-1" href="http://php.net/archive/2014.php#id2014-04-03-1" rel="bookmark" class="bookmark">PHP 5.4.27 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-04-03T15:54:41-07:00">03 Apr 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP
     5.4.27. 6 bugs were fixed in this release, including CVE-2013-7345.
     All PHP 5.4 users are encouraged to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.4.27 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.27">ChangeLog</a>.
     </p>

    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-04-02-1" href="http://php.net/archive/2014.php#id2014-04-02-1" rel="bookmark" class="bookmark">PHP 5.5.11 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-04-02T16:28:21+00:00">02 Apr 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP
     5.5.11. Several bugs were fixed in this release, some bundled libraries updated and a security issue
     has been fixed : CVE-2013-7345. We recommand all PHP 5.5 users to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.5.11 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.5.11">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://www.phpconference.com.ar/", "argentina-2014.png", "PHP Argentina"); ?></div>
    <h2 class="newstitle"><a id="id2014-03-26-1" href="http://www.phpconference.com.ar/" rel="bookmark" class="bookmark">PHP Conference Argentina</a></h2>
  </header>
  <time class="newsdate" datetime="2014-03-26T16:56:35-07:00">26 Mar 2014</time>
  <div class="newscontent">
    <div>
      <p>
        We are excited to invite you to the 2014 edition of
        <a href="http://www.phpconference.com.ar">PHP Conference Argentina</a>,
        to be held on November 7, 8 and 9 in Buenos Aires, Argentina.
      </p>
      <p>
        <a href="http://www.phpconference.com.ar">PHP Conference Argentina</a>,
        is the largest developer conference in Argentina and one of the most important
        events in the region, where programmers and decision makers from all over Latin
        America get together for a 3-days event filled with talks given by highly
        recognized speakers, and networking opportunities.
      </p>
      <p>
        Conference numbers
        <ul>
          <li>Expecting more than 700 attendees</li>
          <li>Full exclusivity of a highly recognized venue in Buenos Aires, giving us
            amazing opportunities for a wide variety of activities.</li>
          <li>A three day event spanned across two days of conference talks, and a full
            day at a farm (called the "Gaucho day") to improve networking opportunities.</li>
          <li>Organized social activities for both conference days.</li>
        </ul>
        More info: <a href="http://www.phpconference.com.ar">www.phpconference.com.ar</a>
      </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://www.phpconference.nl/", "dpc_2014-2.png", "DPC2014"); ?></div>
    <h2 class="newstitle"><a id="id2014-03-13-1" href="http://www.phpconference.nl/" rel="bookmark" class="bookmark">Dutch PHP Conference 2014</a></h2>
  </header>
  <time class="newsdate" datetime="2014-03-13T06:18:00-07:00">13 Mar 2014</time>
  <div class="newscontent">
    <div>

     <p>
     Ibuildings is proud to organise the eighth
     <a href="http://www.phpconference.nl/">Dutch PHP Conference</a> on June 27 and 28,
     plus a pre-conference tutorial day on June 26. Both programs will be completely in
     English so the only Dutch thing about it is the location.
     </p>

     <p>
     DPC brings together the best speakers and PHP talent from Europe and beyond
     for three days of high-level technical sessions. Our
     <a href="http://www.phpconference.nl/schedule">schedule</a> is already online and
     features talks on Redis, Git, HHVM, NGINX, Security, Mocking, PhpSpec 2, Zend
     Framework 2, Apache Cassandra, JavaScript testing, Docker and much more.
     </p>

     <p>
     The tutorial day on Thursday 26th June at the same venue gives an opportunity for a
     smaller number of attendees to spend some time with an expert, going in-depth on
     particular topics - topics like DDD, Zend Framework 2, Ansible, Apigility, JavaScript
     Testing, Laravel, Symfony and more are all on offer.
     </p>

     <p>
     So come along to our two main conference days on 27th and 28th June and our
     tutorial day on 26th June in Amsterdam!
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-03-07-1" href="http://php.net/archive/2014.php#id2014-03-07-1" rel="bookmark" class="bookmark">PHP 5.4.26 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-03-07T07:16:31+02:00">07 Mar 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP
     5.4.26. 5 bugs were fixed in this release, including CVE-2014-1943.
     All PHP 5.4 users are encouraged to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.4.26 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.26">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-03-06-2" href="http://php.net/archive/2014.php#id2014-03-06-2" rel="bookmark" class="bookmark">PHP 5.6.0alpha3 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-03-06T22:42:01+01:00">06 Mar 2014</time>
  <div class="newscontent">
    <div>
      <p>
        The PHP development team announces the immediate availability of
        PHP 5.6.0alpha3. This release adds new features and fixes bugs.
        All users of PHP are encouraged to test this version carefully,
        and report any bugs in <a href="https://bugs.php.net">the bug tracking system</a>.
     </p>

     <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>

     <p>
      PHP 5.6.0alpha3 comes with a number of new features, including:
     </p>
     <ul>
        <li>A new magic method called __debugInfo() for providing additional debug information for an object</li>
        <li>A new config option called clear_env for the FPM SAPI</li>
        <li>A new function called opcache_is_script_cached()</li>
        <li>Support for the Windows CA cert store for peer verification when no CA file is available</li>
        <li>Various other ssl related improvements in the curl and openssl extensions</li>
     </ul>

     <p>For more information about the new features you can check out the work-in-progress
      <a href="http://docs.php.net/manual/en/migration56.new-features.php">documentation</a>
      or you can read the full list of changes in the
      <a href="https://github.com/php/php-src/blob/php-5.6.0alpha3/NEWS">NEWS file</a> contained
      in the release archive.
     </p>

     <p>
      For source downloads of PHP 5.6.0alpha3 please visit
      the <a href="http://downloads.php.net/tyrael">download page</a>. Windows binaries
      can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
     </p>

     <p>
      Hopefully this was our last alpha for 5.6.0, and our first beta should show up on the
      20th of March, which will mark the start of the feature freeze for this version.
     </p>

     <p>
        Thank you for helping us make PHP better.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-03-06-1" href="http://php.net/archive/2014.php#id2014-03-06-1" rel="bookmark" class="bookmark">PHP 5.5.10 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-03-06T08:58:58+00:00">06 Mar 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP
     5.5.10. Several bugs were fixed in this release, including security issues related
     to CVEs. CVE-2014-1943, CVE-2014-2270 and CVE-2013-7327 have been addressed in this release.
     We recommand all PHP 5.5 users to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.5.10 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.5.10">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-02-13-1" href="http://php.net/archive/2014.php#id2014-02-13-1" rel="bookmark" class="bookmark">PHP 5.6.0alpha2 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-02-13T23:00:39+01:00">13 Feb 2014</time>
  <div class="newscontent">
    <div>
      <p>
        The PHP development team announces the immediate availability of
        PHP 5.6.0alpha2. This release adds new features and fixes bugs.
        All users of PHP are encouraged to test this version carefully,
        and report any bugs in <a href="https://bugs.php.net">the bug tracking system</a>.
     </p>

     <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>

     <p>
      PHP 5.6.0alpha2 comes with a number of new features, including:
     </p>
     <ul>
        <li>Peer certificates are now verified by default when connecting to SSL/TLS servers</li>
        <li>An exponentiation operator has been added: **</li>
        <li>Output encoding handling has been simplified by using default_charset as the default character encoding</li>
     </ul>

     <p>For more information about the new features you can check out the work-in-progress
      <a href="http://docs.php.net/manual/en/migration56.new-features.php">documentation</a>
      or you can read the full list of changes in the
      <a href="https://github.com/php/php-src/blob/php-5.6.0alpha2/NEWS">NEWS file</a> contained
      in the release archive.
     </p>

     <p>
      For source downloads of PHP 5.6.0alpha2 please visit
      the <a href="http://downloads.php.net/tyrael">download page</a>. Windows binaries
      can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
     </p>

     <p>
      Our third alpha should show up on the 27th of February.
     </p>

     <p>
        Thank you for helping us make PHP better.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-02-06-1" href="http://php.net/archive/2014.php#id2014-02-06-1" rel="bookmark" class="bookmark">PHP 5.4.25 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-02-06T21:14:31-08:00">06 Feb 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP
     5.4.25. 5 bugs were fixed in this release.
     All PHP 5.4 users are encouraged to upgrade to this version.
     </p>

     <p>For source downloads of PHP 5.4.25 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.25">ChangeLog</a>.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-02-05-4" href="http://php.net/archive/2014.php#id2014-02-05-1" rel="bookmark" class="bookmark">PHP 5.5.9 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-02-05T10:45:56+00:00">05 Feb 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP 5.5.9. This release fixes several bugs against
      PHP 5.5.8.</p>

    <p>
      For source downloads of PHP 5.5.9 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries are located on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes can be found in the <a href="http://www.php.net/ChangeLog-5.php#5.5.9">ChangeLog</a>.
   </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://www.midwestphp.org/", "midwest2014.jpg", "MidwestPHP 2014"); ?></div>
    <h2 class="newstitle"><a id="id2014-02-05-3" href="http://www.midwestphp.org/" rel="bookmark" class="bookmark">MidwestPHP 2014</a></h2>
  </header>
  <time class="newsdate" datetime="2014-02-05T13:09:54-08:00">05 Feb 2014</time>
  <div class="newscontent">
    <div>
     <p><a href="http://www.midwestphp.org/">MidwestPHP</a> is back in Minneapolis
     again for its second year, March 15th-16th, boasting 2 days filled with sessions about Zend
     Framework 2, PHPUnit, RabbitMQ, Vagrant, Application development, Security, and
     more.  And if you're new to PHP, there's something for you too- php|architect
     will be hosting a training day to cover the basics of PHP on the 14th.
     </p>

     <p>Don't miss out on 2 great days of sessions, fantastic Minnesota food, a
     great chance for networking, and of course the world famous Minnesota Niceness
     everyone is talking about.
     <a href="http://www.midwestphp.org/registration/">Register for your spot at MidwestPHP</a> today!
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://tek.phparch.com/", "tek14.fb.png", "php[tek] 2014 : Schedule Announced"); ?></div>
    <h2 class="newstitle"><a id="id2014-02-05-1" href="http://tek.phparch.com/" rel="bookmark" class="bookmark">php[tek] 2014 : Schedule Announced</a></h2>
  </header>
  <time class="newsdate" datetime="2014-02-05T12:52:31-08:00">05 Feb 2014</time>
  <div class="newscontent">
    <div>
     <p>The <a href="http://tek.phparch.com/schedule/">conference
     schedule</a> has now been posted for <a href="http://tek.phparch.com/">php[tek] 2014</a> – The premier
     professional PHP conference from the team at php[architect].</p>

     <p>Taking place from May 19-23rd in Chicago, IL, USA, the conference
     will consist of 4 parallel tracks of sessions, a tutorial day, an <a href="http://tek.phparch.com/speakers/#91919">introduction to PHP day of
     training</a>, and more.</p>

     <p>New to php[tek] this year is the <a href="http://tek.phparch.com/events/#open">Open Spaces</a> room, where
     we hope to encourage all sorts of great discussions to take place by our
     attendees, and larger breaks between sessions as well to make sure that
     the hallway-track is given as much importance as the sessions
     themselves.</p>

     <p>Our <a href="http://tek.phparch.com/pricing-and-registration/">Early
     Bird Sale</a> is still currently ongoing, but expires on February 15th.
      So make sure to <a href="http://tek.phparch.com/pricing-and-registration/">register
     soon</a> in order to save $200 off the total price!</p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-01-23-1" href="http://php.net/archive/2014.php#id2014-01-23-1" rel="bookmark" class="bookmark">PHP 5.6.0alpha1 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-01-23T23:24:10+01:00">23 Jan 2014</time>
  <div class="newscontent">
    <div>
      <p>
        The PHP development team announces the immediate availability of
        PHP 5.6.0alpha1. This release marks the beginning of the PHP 5.6.0 release cycle.
        All users of PHP are encouraged to test this version carefully,
        and report any bugs in <a href="https://bugs.php.net">the bug tracking system</a>.
     </p>

     <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>

     <p>
      PHP 5.6.0alpha1 comes with new features such as (incomplete list) :
     </p>
     <ul>
        <li>constant scalar expressions,</li>
        <li>variadic functions,</li>
        <li>argument unpacking,</li>
        <li>support for large(&gt;2GiB) file uploads,</li>
        <li>SSL/TLS improvements,</li>
        <li>a new command line debugger called phpdbg.</li>
     </ul>

     <p>For more information about the new features you can check out the work-in-progress
      <a href="http://docs.php.net/manual/en/migration56.new-features.php">documentation</a>
      or you can read the full list of changes in the
      <a href="https://github.com/php/php-src/blob/php-5.6.0alpha1/NEWS">NEWS file</a> contained
      in the release archive.
     </p>

     <p>
      For source downloads of PHP 5.6.0alpha1 please visit
      the <a href="http://downloads.php.net/tyrael">download page</a>, Windows binaries
      can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
     </p>

     <p>
      Our second alpha should show up on 6th of February.
     </p>

     <p>
        Thank you for helping us making PHP better.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://phpconference.com/2014se/en", "ipc2014.png", "IPC 2014"); ?></div>
    <h2 class="newstitle"><a id="id2014-01-22-2" href="http://phpconference.com/2014se/en" rel="bookmark" class="bookmark">International PHP Conference - Spring Edition - 2014</a></h2>
  </header>
  <time class="newsdate" datetime="2014-01-22T11:31:42-08:00">22 Jan 2014</time>
  <div class="newscontent">
    <div>
     <p>
     Since its inception in 2001, the
     <a href="http://phpconference.com/2014se/en">International PHP Conference</a>
     has evolved into one of the most significant PHP events worldwide. As a meeting point for
     PHP professionals, evangelists, movers and shakers, the tradition continues this year from
     June 1 to 4 in Berlin (Germany). Once again, the conference will explore key topics and
     core technologies for developers and decision makers.
     </p>

     <p>
     Highlights 2014
     </p>
     <ul>
     <li>Heavyset PHProgram: 60+ workshops, sessions &amp; keynotes</li>
     <li>Cool PHP &amp; the Gang: 50+ international speakers and trainers</li>
     <li>Hands-on Power Workshops on Sunday (June 1, 2014)</li>
     <li>2-day expo with leading IT companies (June 3-4, 2014)</li>
     <li>Full board during the conference: lunch, snacks &amp; drinks</li>
     <li>Free swag: certificate, t-shirt, backpack, magazines…</li>
     <li>Plenty of best practices and networking opportunities</li>
     </ul>

     <p>
     Join us on <a href="http://twitter.com/phpconference">Twitter</a>,
     <a href="https://www.facebook.com/ipc.germany">Facebook</a> and
     <a href="https://plus.google.com/b/109347669400413843557/109347669400413843557/posts">Google+</a>
     or visit our website at <a href="http://phpconference.com/">http://phpconference.com</a>
     We look forward to seeing you in Berlin!
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"><?php news_image("http://www.phpsouthafrica.com/", "phpsa2014.png", "PHP Cape Town"); ?></div>
    <h2 class="newstitle"><a id="id2014-01-22-1" href="http://www.phpsouthafrica.com/" rel="bookmark" class="bookmark">PHP Cape Town 2014</a></h2>
  </header>
  <time class="newsdate" datetime="2014-01-22T11:24:46-08:00">22 Jan 2014</time>
  <div class="newscontent">
    <div>
     <p>
     <a href="http://www.phpsouthafrica.com/">PHP Cape Town</a><br/>
     12th April2014
     </p>
     <p>
     This intimate One Day Advanced PHP Craft session is for the experienced developer, CTO and
     skilled developers looking to take the next step.
     </p>
     <p>During this session you will hear from
     Rasmus Lerdorf about his 7 year experience with Yahoo and an exclusive Q&amp;A with him. We
     will also hear Phil Sturgeon share some of his experiences and knowledge about API
     Pain-Points &amp; The FIG:PSR-4.
     </p>
     <p>You will have the opportunity to question, interact and solve
     some of your issues. At this Craft Session we will be welcoming some more international
     guests for this jammed packed full day session. This PHP Advanced Developers session in
     Cape Town will be the highlight of our calendar to Welcome some acclaimed developers to
     The Mother City.
     </p>
     <p>We have limited seat available for this event to encourage more
     interaction.
     </p>
    </div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-01-10-2" href="http://php.net/archive/2014.php#id2014-01-10-2" rel="bookmark" class="bookmark">PHP 5.4.24 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-01-10T09:22:38-08:00">10 Jan 2014</time>
  <div class="newscontent">
    <div>
          <p>The PHP development team announces the immediate availability of PHP
          5.4.24. About 14 bugs were fixed. All PHP 5.4 users are encouraged to upgrade to this version.
          </p>

          <p>For source downloads of PHP 5.4.24 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
          Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
          The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.24">ChangeLog</a>.
          </p>
	</div>

  </div>
</article>
<article class="newsItem">
  <header>
    <div class="newsImage"></div>
    <h2 class="newstitle"><a id="id2014-01-10-1" href="http://php.net/archive/2014.php#id2014-01-10-1" rel="bookmark" class="bookmark">PHP 5.5.8 Released</a></h2>
  </header>
  <time class="newsdate" datetime="2014-01-10T09:24:43+00:00">10 Jan 2014</time>
  <div class="newscontent">
    <div>
     <p>The PHP development team announces the immediate availability of PHP 5.5.8. This release fixes about 20 bugs against
      PHP 5.5.7 components.</p>

    <p>
      For source downloads of PHP 5.5.8 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries are located on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes can be found in the <a href="http://www.php.net/ChangeLog-5.php#5.5.8">ChangeLog</a>.
   </p>
    </div>

  </div>
</article>
<?php

/* %s/<a href="\(.*\)"><img src="\/images\/news\/\(.*\)" alt="\(.*\)" width.*><\/a>/<?php news_image("\1", "\2", "\3"); ?>/g */
site_footer(['elephpants' => true, 'sidebar' => $SIDEBAR_DATA]);
