<?php

$_SERVER['BASE_PAGE'] = 'archive/2013.php';
include_once __DIR__ . '/../include/prepend.inc';
include_once __DIR__ . '/../include/pregen-news.inc';
news_archive_sidebar();
site_header("News Archive - 2013", ["cache" => true]);
?>

<h1>News Archive - 2013</h1>

<p>
 Here are the most important news items we have published in 2013 on PHP.net.
</p>

<hr>

<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-12-12-3" href="http://php.net/archive/2013.php#id2013-12-12-3" rel="bookmark" class="bookmark">PHP 5.4.23 Released</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-12-12T15:39:33-08:00">12-Dec-2013</abbr>
    <div>
      <p>The PHP development team announces the immediate availability of PHP
      5.4.23. About 10 bugs were fixed, including a security issue in OpenSSL module (CVE-2013-6420).
      All PHP 5.4 users are encouraged to upgrade to this version.
      </p>

      <p>For source downloads of PHP 5.4.23 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
      Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
      The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.23">ChangeLog</a>.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-12-12-2" href="http://php.net/archive/2013.php#id2013-12-12-2" rel="bookmark" class="bookmark">PHP 5.3.28 Released</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-12-12T15:30:05-08:00">12-Dec-2013</abbr>
    <div>
      <p>The PHP development team announces the immediate availability of PHP 5.3.28. This release fixes two security issues in OpenSSL module in PHP 5.3 - CVE-2013-4073 and CVE-2013-6420. All PHP 5.3 users are encouraged to upgrade to PHP 5.3.28 or latest versions of PHP 5.4 or PHP 5.5.</p>

      <p>For source downloads of PHP 5.3.28 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
      Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
      The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.3.28">ChangeLog</a>.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-12-12-1" href="http://php.net/archive/2013.php#id2013-12-12-1" rel="bookmark" class="bookmark">PHP 5.5.7 </a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-12-12T17:07:20+00:00">12-Dec-2013</abbr>
    <div>
      <p>The PHP development team announces the immediate availability of PHP 5.5.7. This release fixes some bugs against
      PHP 5.5.6 and it also includes a fix for CVE-2013-6420 in OpenSSL extension. All users are strongly encouraged
      to upgrade.</p>

      <p>
      For source downloads of PHP 5.5.7 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
      Windows binaries are located on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
      The list of changes can be found in the <a href="http://www.php.net/ChangeLog-5.php#5.5.7">ChangeLog</a>.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-11-20-1" href="http://php.net/archive/2013.php#id2013-11-20-1" rel="bookmark" class="bookmark">Our modern web theme goes live!</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-11-20T04:00:00-08:00">20-Nov-2013</abbr>
    <div>
      <p>The PHP web team are delighted to announce the launch of the new web theme that has been
      in beta for many months. Lots of hard work has gone into this release and we will be continually
      improving things over time now that we have migrated away from the legacy theme.</p>

      <p>From an aesthetics point of view the general color scheme of the website has been lightened from the
      older dark purple. Lots of borders and links use a similar purple color to attain
      consistency. Fonts are smoother, and colors, contrast and highlighting have significantly improved; especially
      on function reference pages. Code examples should now be much more readable.</p>

      <p>The theme is marked up using HTML5 and is generally much more modern. We are using Google Fonts and
      Bootstrap for our theme base.</p>

      <p>To provide valuable feedback, you can use the 'Feedback' widget on the side of the page (not visible
      on smartphones) and to report bugs, you can make use of the <a href="http://bugs.php.net" title="PHP Bug Tracker">bugs.php.net</a>
      tracker. Despite our extensive multi-device/multi-browser testing, we may have missed something. So, if you
      spot any issues please do get in touch.</p>

      <p>Special thanks to the guys who helped make this happen, you know who you are!</p>

    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-11-14-3" href="http://php.net/archive/2013.php#id2013-11-14-3" rel="bookmark" class="bookmark">PHP 5.4.22 Released</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-11-14T22:39:47-08:00">14-Nov-2013</abbr>
    <div>
      <p>The PHP development team announces the immediate availability of PHP
      5.4.22. About 10 bugs were fixed. All PHP 5.4 users are encouraged to upgrade to this version.
      </p>

      <p>For source downloads of PHP 5.4.22 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
      Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
      The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.22">ChangeLog</a>.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-11-14-1" href="http://php.net/archive/2013.php#id2013-11-14-1" rel="bookmark" class="bookmark">PHP 5.5.6 is now available</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-11-14T08:58:23+00:00">14-Nov-2013</abbr>
    <div>
      <p>The PHP development team announces the immediate availability of PHP 5.5.6. This release fixes some bugs against
      PHP 5.5.5, and adds some performance improvements.</p>

      <p>For source downloads of PHP 5.5.6 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
      Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
      The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.5.6">ChangeLog</a>.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-10-24-2" href="http://php.net/archive/2013.php#id2013-10-24-2" rel="bookmark" class="bookmark">A further update on php.net</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-10-24T18:57:54-07:00">24-Oct-2013</abbr>
    <div>
      <p>We are continuing to work through the repercussions of the php.net malware issue described in a news post earlier today. As part of this, the php.net systems team have audited every server operated by php.net, and have found that two servers were compromised: the server which hosted the www.php.net, static.php.net and git.php.net domains, and was previously suspected based on the JavaScript malware, and the server hosting bugs.php.net. The method by which these servers were compromised is unknown at this time.</p>

      <p>All affected services have been migrated off those servers. We have verified that our Git repository was not compromised, and it remains in read only mode as services are brought back up in full.</p>

      <p>As it's possible that the attackers may have accessed the private key of the php.net SSL certificate, we have revoked it immediately. We are in the process of getting a new certificate, and expect to restore access to php.net sites that require SSL (including bugs.php.net and wiki.php.net) in the next few hours.</p>

      <p>To summarise, the situation right now is that:</p>

      <ul>
        <li>JavaScript malware was served to a small percentage of php.net users from the 22nd to the 24th of October 2013.</li>
        <li>Neither the source tarball downloads nor the Git repository were modified or compromised.</li>
        <li>Two php.net servers were compromised, and have been removed from service. All services have been migrated to new, secure servers.</li>
        <li>SSL access to php.net Web sites is temporarily unavailable until a new SSL certificate is issued and installed on the servers that need it.</li>
      </ul>

      <p>Over the next few days, we will be taking further action:</p>

      <ul>
        <li>php.net users will have their passwords reset. Note that users of PHP are unaffected by this: this is solely for people committing code to projects hosted on svn.php.net or git.php.net.</li>
      </ul>

      <p>We will provide a full post mortem in due course, most likely next week. You can also get updates from the official php.net Twitter: <a href="https://twitter.com/official_php">@official_php</a>.</p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-10-24-1" href="http://php.net/archive/2013.php#id2013-10-24-1" rel="bookmark" class="bookmark">A quick update on the status of php.net</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-10-24T20:55:17-05:00">24-Oct-2013</abbr>
    <div>
      <p>
      On 24 Oct 2013 06:15:39 +0000 Google started saying www.php.net was hosting
      malware. The Google Webmaster Tools were initially quite delayed in showing
      the reason why and when they did it looked a lot like a false positive
      because we had some minified/obfuscated javascript being dynamically
      injected into userprefs.js. This looked suspicious to us as well, but
      it was actually written to do exactly that so we were quite certain it
      was a false positive, but we kept digging.
      </p>

      <p>
      It turned out that by combing through the access logs for static.php.net
      it was periodically serving up userprefs.js with the wrong content length
      and then reverting back to the right size after a few minutes. This is due
      to an rsync cron job. So the file was being modified locally and reverted.
      Google's crawler caught one of these small windows where the wrong file
      was being served, but of course, when we looked at it manually it looked
      fine. So more confusion.
      </p>

      <p>
      We are still investigating how someone caused that file to be changed,
      but in the meantime we have migrated www/static to new clean servers.
      The highest priority is obviously the source code integrity and after
      a quick:
      </p>

      <blockquote>git fsck --no-reflog --full --strict</blockquote>

      <p>
      on all our repos plus manually checking the md5sums of the PHP distribution
      files we see no evidence that the PHP code has been compromised. We have
      a mirror of our git repos on github.com and we will manually check git
      commits as well and have a full post-mortem on the intrusion when we have
      a clearer picture of what happened.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-10-17-1" href="http://php.net/archive/2013.php#id2013-10-17-1" rel="bookmark" class="bookmark">PHP 5.4.21 Released</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-10-17T15:28:32-07:00">17-Oct-2013</abbr>
    <div>
      <p>The PHP development team announces the immediate availability of PHP
      5.4.21. About 10 bugs were fixed. All PHP 5.4 users are encouraged to upgrade to this version.
      </p>

      <p>For source downloads of PHP 5.4.21 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
      Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
      The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.21">ChangeLog</a>.
      </p>

    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-10-16-1" href="http://php.net/archive/2013.php#id2013-10-16-1" rel="bookmark" class="bookmark">PHP 5.5.5 has been released</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-10-16T14:54:24+00:00">16-Oct-2013</abbr>
    <div>
      <p>The PHP development team announces the immediate availability of PHP 5.5.5. This release fixes about twenty bugs against
      PHP 5.5.4, some of them regarding the build system. All PHP users are encouraged to upgrade to this new version.</p>

      <p>For source downloads of PHP 5.5.5 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
      Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
      The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.5.5">ChangeLog</a>.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry vevent">
  <div class="newsImage"><a href="https://www.skiphp.com"><img src="/images/news/ski-php.png" alt="Ski PHP 2014" width="350" height="130" style="float: right;"></a></div>
  <h2 class="summary entry-title"><a id="id2013-10-10-2" href="https://www.skiphp.com" rel="bookmark" class="bookmark">Ski PHP 2014</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-10-10T13:00:14-07:00">10-Oct-2013</abbr>
    <div>
      <p>
      <a href="https://www.skiphp.com/">Ski PHP 2014</a> has announced the
      <a href="https://www.skiphp.com/attend/schedule">schedule for their upcoming
        conference</a>, which will be on January 17-18, 2014 in Salt Lake City, Utah,
      USA.  Our schedule is anchored by keynotes from Jared Smith, Laura Thomson, and
      Chris Hartjes, and also includes talks from Julien Pauli, Ed Finkler, John
      Coggeshall, Elizabeth Naramore, and many more.
      </p>

      <p>
      Our Early Bird registration rate of just $129 is available until October 15th.
      Hotel group rate information is available at our site.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry vevent">
  <div class="newsImage"><a href="http://www.madisonphpconference.com/"><img src="/images/news/madison-php-2013.png" alt="Madison PHP Conference" width="180" height="180" style="float: right;"></a></div>
  <h2 class="summary entry-title"><a id="id2013-10-10-1" href="http://www.madisonphpconference.com/" rel="bookmark" class="bookmark">Madison PHP Conference</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-10-10T12:46:40-07:00">10-Oct-2013</abbr>
    <div>
      <p>
      November 16th, 2013 - 8:30am - 3:30pm<br>
      Warner Park Community Recreation Center <br>
      1625 Northport Dr, Madison, WI 53704<br>
      $40 (before October 16th), $60 (after October 16th), $100 at the door<br>
      </p>

      <p>
      <strong>Call for Papers</strong>: Now through October 8th, 2013
      </p>

      <p>
      Join us for a one day, two-track conference that focuses on PHP and related web technologies. This event is organized by Madison PHP and is designed to offer something to attendees at all skill levels.   It will be a day of networking, learning, sharing, and great fun!
      </p>

      <p>
      <strong>Two Tracks</strong>
      We've carefully crafted two distinct tracks but you're not locked into just one. Attend any talk from any track.
      </p>

      <p>
      <strong>PHP Foundations</strong>
      Track Learn the basics of PHP development. A carefully selected set of talks for those who have never programmed before or who are new to PHP and would like a refresher of the basics.
      </p>

      <p>
      <strong>PHP Professional Track</strong>
      Explore new technologies and techniques. Gather with other seasoned developers and increase your value with a series of talks that will both energize and get you excited about the future of PHP.
      </p>

      <p>
      For more information and to register, please visit: <a href="http://www.MadisonPHPConference.com">http://www.MadisonPHPConference.com</a>
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-09-19-2" href="http://php.net/archive/2013.php#id2013-09-19-2" rel="bookmark" class="bookmark">PHP 5.4.20 released</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-09-19T21:42:19-07:00">19-Sep-2013</abbr>
    <div>
      <p>The PHP development team announces the immediate availability of PHP
      5.4.20. About 30 bugs were fixed. All PHP 5.4 users are encouraged to upgrade to this version.
      </p>

      <p>For source downloads of PHP 5.4.20 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
      Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
      The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.20">ChangeLog</a>.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-09-19-1" href="http://php.net/archive/2013.php#id2013-09-19-1" rel="bookmark" class="bookmark">PHP 5.5.4 released</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-09-19T13:08:02+00:00">19-Sep-2013</abbr>
    <div>
      <p>The PHP development team announces the immediate availability of PHP 5.5.4. This release fixes several bugs against
      PHP 5.5.3. All PHP users are encouraged to upgrade to this new version.</p>

      <p>For source downloads of PHP 5.5.4 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
      Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
      The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.5.4">ChangeLog</a>.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-08-22-1" href="http://php.net/archive/2013.php#id2013-08-22-1" rel="bookmark" class="bookmark">PHP 5.4.19 and PHP 5.5.3 Released!</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-08-22T16:06:05-07:00">22-Aug-2013</abbr>
    <p xmlns="http://www.w3.org/2005/Atom">The PHP development team announces the immediate availability of PHP
    5.4.19 and PHP 5.5.3. These releases fix a bug in the patch for CVE-2013-4248 in OpenSSL module and
    compile failure with ZTS enabled in PHP 5.4. All PHP users are encouraged to upgrade to either PHP 5.5.3 or PHP 5.4.19.</p>

    <p xmlns="http://www.w3.org/2005/Atom">For source downloads of PHP 5.4.19 and PHP 5.5.3 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
    Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
    The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.19">ChangeLog</a>.
    </p>

  </div>
</div>
<div class="newsItem hentry vevent">
  <div class="newsImage"><a href="http://codeconnexx.com/"><img src="/images/news/codeconnexx_logo_2013.png" alt="CodeConnexx 2013" width="350" height="50" style="float: right;"></a></div>
  <h2 class="summary entry-title"><a id="id2013-08-19-2" href="http://codeconnexx.com/" rel="bookmark" class="bookmark">CodeConnexx 2013</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-08-19T12:57:55-07:00">19-Aug-2013</abbr>
    <div>
      <p>
      <a href="http://codeconnexx.com/">CodeConnexx</a> is a two-day, one track conference that aims to bring together everyone interested in talking about code.
      </p>
      <p>
      As we know, choosing a career as a coder comes with its own set of life
      challenges, and we want to talk about those too. In short, this conference is a
      different kind of conference, as it connects those two pieces of the puzzle
      together in one event.
      </p>

      <p>
      Every technical talk will be followed by a talk about life skills and work/life
      balance. There will also be plenty of social opportunities to get to know the
      other attendees. Not only do we want to help you bridge the gap between work
      and life, we want to help you connect with each other as well.
      </p>

      <p>
      CodeConnexx, hosted by <a href="http://phpwomen.org/">PHPWomen</a>, will
      take <a href="http://codeconnexx.com/location/">place</a> in Maastricht,
      Netherlands on November 8th &amp; 9th 2013. We sincerely hope you are able to
      join us!
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry vevent">
  <div class="newsImage"><a href="http://www.zendcon.com/"><img src="/images/news/ZendCon2013.png" alt="ZendCon" width="200" height="200" style="float: right;"></a></div>
  <h2 class="summary entry-title"><a id="id2013-08-19-1" href="http://php.net/archive/2013.php#id2013-08-19-1" rel="bookmark" class="bookmark">ZendCon 2013</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-08-19T12:53:59-07:00">19-Aug-2013</abbr>
    <div>
      <p>
      The 9th Annual <a href="http://www.zendcon.com/">ZendCon</a> will bring together developers, IT managers and PHP
      experts from around the world. With a focus on PHP, mobile and cloud
      development, attendees at this highly acclaimed conference will expand their
      skills and explore new technologies.
      </p>

      <p>
      ZendCon provides unique opportunities to learn from a wide variety of technical
      sessions, hear keynote presentations from thought leaders, and engage with
      prominent PHP speakers and vendors. You’ll learn about the latest innovations
      and network with peers to solve PHP challenges
      </p>
      <p>
      The conference is scheduled from October 7-10, 2013. For more information,
      visit <a href="http://www.zendcon.com/">http://www.zendcon.com/</a>.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-08-16-1" href="http://php.net/archive/2013.php#id2013-08-16-1" rel="bookmark" class="bookmark">PHP 5.5.2 Released!</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-08-16T11:39:27-07:00">16-Aug-2013</abbr>
    <div>
      <p>The PHP development team announces the immediate availability of PHP
      5.5.2. About 20 bugs were fixed, including security issue in OpenSSL module (CVE-2013-4248) and session fixation problem (CVE-2011-4718).
      All users of PHP are encouraged to upgrade to this release.</p>

      <p>For source downloads of PHP 5.5.2 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
      Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
      The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.5.2">ChangeLog</a>.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-08-15-1" href="http://php.net/archive/2013.php#id2013-08-15-1" rel="bookmark" class="bookmark">PHP 5.4.18 Released!</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-08-15T21:21:42-07:00">15-Aug-2013</abbr>
    <div>
      <p>The PHP development team announces the immediate availability of PHP
      5.4.18. About 30 bugs were fixed, including security issues CVE-2013-4113 and CVE-2013-4248.
      All users of PHP are encouraged to upgrade to this release.</p>

      <p>For source downloads of PHP 5.4.18 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
      Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
      The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.18">ChangeLog</a>.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry vevent">
  <div class="newsImage"><a href="http://webandphp.com/conference/webandphpcon2013"><img src="/images/news/WPCLogo-2013.jpg" alt="WPC 2013" width="350" height="350" style="float: right;"></a></div>
  <h2 class="summary entry-title"><a id="id2013-08-08-1" href="http://webandphp.com/conference/webandphpcon2013" rel="bookmark" class="bookmark">Web & PHP Conference</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-08-08T10:37:33-07:00">08-Aug-2013</abbr>
    <div>
      <p>
      <a href="http://webandphp.com/conference/webandphpcon2013">Web &amp; PHP Magazine invites you to its first ever conference.</a>
      This 3 day
      conference, taking place in San Jose, CA this September, will immerse you in a
      world of continuously evolving web technologies.
      </p>
      <p>
      Sticking with our ethos of
      open knowledge sharing and community support, all conference sessions, keynote
      presentations, hacks and Expo on September 17 &amp; 18 are FREE to attend!
      </p>
      <p>
      Whether
      your interests lay in core PHP, security, testing,architecture, frameworks,
      cloud, HTML5, CSS3, responsive design, UX, mobile web or web-based mobile apps,
      our final program of sessions, workshops and keynote presentations will have
      something for you....
      </p>
      <p>
      There will also be a pre-conference day with hands-on workshops and
      deep-dive tutorials, allowing you to work with and learn from some of
      the leading experts in their field. With this special discount code:
      <strong>WPC13PN</strong> you can access the Workshops Day for the
      special price of $159 instead of $199.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry vevent">
  <div class="newsImage"><a href="http://phpconference.com/2013/en"><img src="/images/news/ipc-2013.jpg" alt="IPC 2013" width="350" height="225" style="float: right;"></a></div>
  <h2 class="summary entry-title"><a id="id2013-08-07-1" href="http://phpconference.com/2013/en" rel="bookmark" class="bookmark">International PHP Conference 2013</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-08-07T16:54:24-07:00">07-Aug-2013</abbr>
    <div>
      <p>Once again, the <a href="http://phpconference.com/2013/en">International PHP Conference</a>
      will explore key topics and core technologies for PHP developers, webworkers,
      IT managers and everyone interested in web technology in more than
      <a href="http://phpconference.com/2013/sessions">75 sessions,
        workshops and keynotes</a>.
      </p>
      <p>
      We'll show you how to scale your applications, explain
      the details of Continuous Integration or evaluate different approaches to
      NoSQL. Attendees will have the opportunity to meet with speakers, core
      developers and consultants, and there are often opportunities to evaluate your
      code. Community and enterprise projects profit from our international
      reputation and impulses given from the developer community..
      </p>
      <p>
      <a href="http://phpconference.com">http://phpconference.com</a>.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry vevent">
  <div class="newsImage"><a href="http://www.northeastphp.org/"><img src="/images/news/NENA_logo_2013.png" alt="Northeast PHP Technical Conference" width="300" height="169" style="float: right;"></a></div>
  <h2 class="summary entry-title"><a id="id2013-07-19-1" href="http://www.northeastphp.org/" rel="bookmark" class="bookmark">Northeast PHP Technical Conference</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-07-19T11:53:40-07:00">19-Jul-2013</abbr>
    <div>
      <p>
      2nd Annual Northeast PHP Technical Conference - August 16 to 18!
      </p>
      <p>
      This year’s Northeast PHP Conference will once again be held in
      Boston, MA from August 16 to 18. This year we are adding a day to the
      front of the weekend for half-day workshops.
      </p>
      <p>We have 2 great Keynote speakers lined up as well:</p>
      <p>Eli White</p>
      <p>
      Eli is a strong advocate for PHP and used it in every project he's
      work on. He is currently a Founding Partner &amp; CTO of Musketeers.me,
      and the Managing Editor of php|architect magazine. He is also an avid
      writer (blogs, articles and books), and has spoken at numerous
      conferences.
      </p>
      <p>and Terry Chay</p>
      <p>
      Terry Chay is administrative overhead (Director of Features
      Engineering) at the Wikimedia Foundation, maintainers of Wikipedia.
      And when he isn’t doing that, he’s saying outrageous things on his
      blog.</p>
      <p>
      For tickets and more information:
      <a href="http://www.nephp.org/">http://www.nephp.org/</a>
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-07-18-1" href="http://php.net/archive/2013.php#id2013-07-18-1" rel="bookmark" class="bookmark">PHP 5.5.1 Released</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-07-18T15:53:15+00:00">18-Jul-2013</abbr>
    <div>
      <p>The PHP development team announces the immediate availability of PHP 5.5.1. About 20 bugs were fixed including a security fix in the XML parser (Bug #65236).</p>

      <p>For source downloads of PHP 5.5.1 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
      Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
      The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.5.1">ChangeLog</a>.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-07-11-1" href="http://php.net/archive/2013.php#id2013-07-11-1" rel="bookmark" class="bookmark">PHP 5.3.27 Released - PHP 5.3 Reaching End of Life</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-07-11T15:10:59+00:00">11-Jul-2013</abbr>
    <div>
      <p>The PHP development team announces the immediate availability of PHP 5.3.27. About 10 bugs were fixed, including a security fix in the XML parser (Bug #65236).</p>

      <p><b>Please Note:</b> This will be the last regular release of the PHP 5.3 series. All users of PHP are encouraged to upgrade to PHP 5.4 or PHP 5.5. The PHP 5.3 series will receive only security fixes for the next year.</p>

      <p>For source downloads of PHP 5.3.27 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
      Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
      The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.3.27">ChangeLog</a>.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-07-04-1" href="http://php.net/archive/2013.php#id2013-07-04-1" rel="bookmark" class="bookmark">PHP 5.4.17 released!</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-07-04T20:33:50-07:00">04-Jul-2013</abbr>
    <div>
      <p>The PHP development team announces the immediate availability of PHP
      5.4.17. About 20 bugs were fixed. All users of PHP are encouraged to upgrade to this release.</p>

      <p>For source downloads of PHP 5.4.17 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
      Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
      The list of changes is recorded in the <a href="http://www.php.net/ChangeLog-5.php#5.4.17">ChangeLog</a>.
      </p>

    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-06-20-1" href="http://php.net/archive/2013.php#id2013-06-20-1" rel="bookmark" class="bookmark">PHP 5.5.0 released.</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-06-20T16:20:26+00:00">20-Jun-2013</abbr>
    <div>
      <p>The PHP development team is proud to announce the immediate availability of PHP 5.5.0.
      This release includes a large number of new features and bug fixes.
      </p>

      <p>
      <b>The key features of PHP 5.5.0 include:</b>
      </p>
      <ul>
        <li>Added <a href="http://php.net/generators">generators</a> and coroutines.</li>
        <li>Added the <a href="http://php.net/exceptions">finally</a> keyword.</li>
        <li>Added a <a href="http://php.net/password">simplified password hashing API</a>.</li>
        <li>Added <a href="http://php.net/migration55.new-features#migration55.new-features.const-dereferencing">support for constant array/string dereferencing</a>.</li>
        <li>Added scalar class name resolution via <a href="http://php.net/oop5.basic#language.oop5.basic.class.class">::class</a>.</li>
        <li>Added <a href="http://php.net/migration55.new-features#migration55.new-features.empty">support for using empty() on the result of function calls and other expressions</a>.</li>
        <li>Added <a href="http://php.net/migration55.new-features#migration55.new-features.non-scalar-iterator-keys">support for non-scalar Iterator keys in foreach</a>.</li>
        <li>Added <a href="http://php.net/foreach#control-structures.foreach.list">support for list() constructs in foreach statements</a>.</li>
        <li>Added the <a href="http://php.net/opcache">Zend OPcache</a> extension for opcode caching.</li>
        <li>The GD library has been upgraded to version 2.1 adding new functions and improving existing functionality.</li>
        <li>A lot more improvements and fixes.</li>
      </ul>

      <p>
      <b>Changes that affect compatibility:</b>
      </p>

      <ul>
        <li><a href="http://php.net/php_logo_guid">PHP logo GUIDs</a> have been removed.</li>
        <li>Windows XP and 2003 support dropped.</li>
        <li>Case insensitivity is no longer locale specific. All case insensitive matching for function, class and constant names is now performed in a locale independent manner according to ASCII rules.</li>
      </ul>

      <p>
      For users upgrading from PHP 5.4,
      <a href="http://php.net/migration55">a migration guide is available</a>
      detailing the changes between 5.4 and 5.5.0.
      </p>

      <p>
      For a full list of changes in PHP 5.5.0, see the <a href="http://php.net/ChangeLog-5.php#5.5.0">ChangeLog</a>.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-06-06-2" href="http://php.net/archive/2013.php#id2013-06-06-2" rel="bookmark" class="bookmark">PHP 5.4.16 and PHP 5.3.26 released!</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-06-06T13:19:21-07:00">06-Jun-2013</abbr>
    <div>
      <p>The PHP development team announces the immediate availability of PHP 5.4.16 and PHP 5.3.26. These releases fix about 15 bugs, including CVE-2013-2110. All users of PHP are encouraged to upgrade to PHP 5.4.16.</p>

      <p>For source downloads of PHP 5.4.16 and PHP 5.3.26 please visit our <a href="/downloads.php">downloads page</a>, Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.</p>

      <p>The list of changes are recorded in the <a href="/ChangeLog-5.php">ChangeLog</a>.</p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-06-06-1" href="http://php.net/archive/2013.php#id2013-06-06-1" rel="bookmark" class="bookmark">PHP 5.5 RC3 is available</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-06-06T17:01:36+00:00">06-Jun-2013</abbr>
    <div>
      <p>
      The PHP development team announces the availability of PHP 5.5 RC3.
      This release fixes some bugs against RC2.
      </p>
      <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>
      <p>
      You can find an incomplete changelog of PHP 5.5.0RC3 here :
      </p>
      <ul>
        <li>Fixed bug causing segfault in gc_zval_possible_root)</li>
        <li>Fixed bug about a heap based buffer overflow in quoted_printable_encode</li>
        <li>hash_pbkdf2() truncates data when using default length and hex output</li>
      </ul>
      <p>
      To get the full changelog, please, check the <a href="https://github.com/php/php-src/blob/php-5.5.0RC3/NEWS">NEWS file</a> attached to the archive.
      For source downloads of PHP 5.5.0RC3 please visit <a href="http://downloads.php.net/dsp">the download page</a>,
      Windows binaries can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
      </p>
      <p>
      We were pleased if you could test this release candidate against your code base and report any problems that you encounter to the
      <a href="mailto:php-qa@lists.php.net">QA mailing list</a> and/or the <a href="https://bugs.php.net">PHP bug tracker</a>.
      </p>
      <p>
      Thanks you helping us making PHP better.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry vevent">
  <div class="newsImage"><a href="http://php.thinkinlamp.com/2013"><img src="/images/news/thinklamp2013.jpg" alt="Shanghai PHP conference 2013" width="631" height="154" style="float: right;"></a></div>
  <h2 class="summary entry-title"><a id="id2013-06-04-1" href="http://php.thinkinlamp.com/2013" rel="bookmark" class="bookmark">Shanghai PHP conference 2013</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-06-04T10:56:01-07:00">04-Jun-2013</abbr>
    <div>
      <p><a href="http://php.thinkinlamp.com/2013">ThinkInLAMP</a> is pleased to announce the first Shanghai PHP conference 2013.
      This event will be held on Sunday June 30th 2013 in Shanghai, China. A
      community oriented conference which is organized by an excellent line up
      and socials.</p>
      <p>This event will concentrate on PHP languages and web based technologies
      used today; extension, latest dynamics and new applications within the
      increased demand for developers and everyone who is interested in PHP
      language.</p>
      <p>There will be more than 500 developers owned over 3 year’s
      experiences andsenior technical persons come for learning and networking.
      Register soon as the Early Bird discount rate expires on May 30.</p>
      <p>Go to <a href="http://php.thinkinlamp.com/2013">http://php.thinkinlamp.com/2013</a> for more information, we are looking
      forward to seeing you in June!
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-05-23-1" href="http://php.net/archive/2013.php#id2013-05-23-1" rel="bookmark" class="bookmark">PHP 5.5.0RC2 is available</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-05-23T08:16:02+00:00">23-May-2013</abbr>
    <div>
      <p>
      The PHP development team announces the availability of the second release candidate of PHP 5.5.
      This release fixes some bugs against RC1 and improves overall stability.
      </p>
      <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>
      <p>
      You can find an incomplete changelog of PHP 5.5.0RC2 here :
      </p>
      <ul>
        <li>Fixed a bug related to segfault on memory exhaustion within function definition.</li>
        <li>Fixed bug in mbstring PHPTs which would crash on Windows x64.</li>
        <li>Fixed a bug where Custom Exceptions could crash when internal properties overridden.</li>
      </ul>
      <p>
      To get the full changelog, please, check the <a href="https://github.com/php/php-src/blob/php-5.5.0RC2/NEWS">NEWS file</a> attached to the archive.
      For source downloads of PHP 5.5.0RC2 please visit <a href="http://downloads.php.net/dsp">the download page</a>,
      Windows binaries can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
      </p>
      <p>
      Please help us to identify bugs in order to ensure that the release is solid and all things behave as expected.
      Please test this release candidate against your code base and report any problems that you encounter to the
      <a href="mailto:php-qa@lists.php.net">QA mailing list</a> and/or the <a href="https://bugs.php.net">PHP bug tracker</a>.
      </p>
      <p>
      Thanks to all people helping on the PHP project.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-05-09-3" href="http://php.net/archive/2013.php#id2013-05-09-3" rel="bookmark" class="bookmark">Seriously: PHP 5.4.15 and PHP 5.3.25 really were released!</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-05-09T13:14:43-05:00">09-May-2013</abbr>
    <div>

      <p>We weren't trying to pull an April Fool's Day joke in May.  A temporary glitch caused the latest distributions of PHP to not properly propagate to the mirror servers.  This has been fixed at the root level, and it's now being distributed to all of the mirrors.  We'll take some bacon to go with the egg on our faces, please!</p>

      <p>If you continue to experience issues with downloading these versions after 21:00 UTC on 9 May, 2013, please drop us a line at <a href="mailto:php-mirrors@lists.php.net">php-mirrors@lists.php.net</a>, telling us from which mirror you're trying to download, and we'll get it resolved.</p>

      <p>We apologize for the delays and confusion this may have caused, and thank you for using PHP.</p>

    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-05-09-2" href="http://php.net/archive/2013.php#id2013-05-09-2" rel="bookmark" class="bookmark">PHP 5.5.0RC1 is available</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-05-09T09:12:44+00:00">09-May-2013</abbr>
    <div>
      <p>
      The PHP development team announces the availability of the first release candidate of PHP 5.5.
      This release fixes some bugs as well as some possible leaks from our last beta.
      </p>
      <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>
      <p>
      You can find an incomplete changelog of PHP 5.5.0RC1 here :
      </p>
      <ul>
        <li>Ignore QUERY_STRING when sent in SCRIPT_FILENAME in FPM SAPI.</li>
        <li>Fix build with system libgd &gt;= 2.1 which is now the minimal
        version required (as build with previous version is broken).
        No change when bundled libgd is used.</li>
        <li> Fixed some bugs in SNMP</li>
        <li> Fixed bug where stream_select() fails with pipes returned by proc_open()
        on Windows x64).</li>
      </ul>
      <p>
      To get the full changelog, please, check the <a href="https://github.com/php/php-src/blob/php-5.5.0RC1/NEWS">NEWS file</a> attached to the archive.
      For source downloads of PHP 5.5.0RC1 please visit <a href="http://downloads.php.net/dsp">the download page</a>,
      Windows binaries can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
      </p>
      <p>
      Note that our release candidate cycle is only meant to bug fixes, no more features will be added to PHP 5.5 from now.
      </p>
      <p>
      Please help us to identify bugs in order to ensure that the release is solid and all things behave as expected.
      Please test this release candidate against your code base and report any problems that you encounter to the
      <a href="mailto:php-qa@lists.php.net">QA mailing list</a> and/or the <a href="https://bugs.php.net">PHP bug tracker</a>.
      </p>
      <p>
      We would like to thank all people helping us making PHP better by testing it and reporting problems, as well as all its
      contributors for their great work on this 5.5 version of PHP.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-05-09-1" href="http://php.net/archive/2013.php#id2013-05-09-1" rel="bookmark" class="bookmark">PHP 5.4.15 and PHP 5.3.25 released!</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-05-09T00:05:05-07:00">09-May-2013</abbr>
    <div>
      <p>The PHP development team announces the immediate availability of PHP 5.4.15 and PHP 5.3.25. These releases fix about 10 bugs aswell as upgrading the bundled libmagic library. All users of PHP are encouraged to upgrade to PHP 5.4.15.</p>

      <p>For source downloads of PHP 5.4.15 and PHP 5.3.25 please visit our <a href="/downloads.php">downloads page</a>, Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.</p>

      <p>The list of changes are recorded in the <a href="/ChangeLog-5.php">ChangeLog</a>.</p>
    </div>

  </div>
</div>
<div class="newsItem hentry vevent">
  <div class="newsImage"><a href="http://devconf.ru"><img src="/images/news/devconfru2012.png" alt="DevConf 2013" width="373" height="86" style="float: right;"></a></div>
  <h2 class="summary entry-title"><a id="id2013-05-07-1" href="http://devconf.ru" rel="bookmark" class="bookmark">DevConf 2013</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-05-07T05:20:52+00:00">07-May-2013</abbr>
    <div>
      <p>
      DevConf 2013 in Moscow, Russia on Jun 14
      </p>
      <p>
      DevConf is the ultimate meeting place for russian-speaking web-developers,
      combining several language-specific conferences under one roof.
      </p>
      <p>
      This year DevConf will include the following sections:
      </p>
      <ul>
        <li>DevConf::PHP();</li>
        <li>DevConf::Ruby();</li>
        <li>DevConf::Python();</li>
        <li>DevConf::Javascript();</li>
        <li>DevConf::Mobi();</li>
      </ul>
      <p>
      Each section will feature several talks from the active contributors/authors of the language.
      Among the invited speakers are Dmitry Stogov (maintainer of Zend Engine and Zend OpCache and many more),
      Chiu-Ki Chan (Google), Lennart Regebro, Andrey Aksyonov (author of Sphinx), Alexey Rybak (Badoo),
      Alexander Makarov (one of the main contributors to Yii), Sergey Petrunya (of MariaDB fame),
      and many others, see more details on <a href="http://devconf.ru">the official website</a>.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry vevent">
  <div class="newsImage"><a href="http://www.phpconference.com.ar/"><img src="/images/news/logo-php-argentina.png" alt="PHP Conference Argentina" width="244" height="247" style="float: right;"></a></div>
  <h2 class="summary entry-title"><a id="id2013-05-06-1" href="http://www.phpconference.com.ar/" rel="bookmark" class="bookmark">PHP Conference Argentina</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-05-06T18:39:48-07:00">06-May-2013</abbr>
    <div>
      <p>
      4-5 OCTOBER 2013, Buenos Aires, ARGENTINA
      </p>
      <p>
      This year we gathered the best of the programming world. With several
      talks that cover a wide range of topics related to web development,
      <a href="http://www.phpconference.com.ar/">PHP Conference
        Argentina</a> is a conference no programmer wishes to miss
      (whether or not they use PHP.)
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-04-25-1" href="http://php.net/archive/2013.php#id2013-04-25-1" rel="bookmark" class="bookmark">PHP 5.5 beta 4 is now available</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-04-25T08:18:09+00:00">25-Apr-2013</abbr>
    <div>
      <p>
      The PHP development team announces the release of the 4th beta of PHP 5.5.0.
      This release fixes some bugs against beta 3 and cleans up some features.
      </p>

      <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>

      <p>
      PHP 5.5.0beta4 is shipped with some bug fixes. Here is the list:
      </p>
      <ul>
        <li>Fixed bug #64677, execution operator `` stealing surrounding arguments.</li>
        <li>Fixed bug #64342, ZipArchive::addFile() has to check for file existence.</li>
        <li>Fixed Windows x64 version of stream_socket_pair() and improved error handling.</li>
        <li>Remove curl stream wrappers</li>
      </ul>

      <p>You can read the full list of changes in the
      <a href="https://github.com/php/php-src/blob/php-5.5.0beta4/NEWS">NEWS file</a> contained
      in the release archive.
      </p>

      <p>
      For source downloads of PHP 5.5.0beta4 please visit
      the <a href="http://downloads.php.net/dsp">download page</a>, Windows binaries
      can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
      </p>

      <p>
      Next step is Release Candidate. Our 1st RC is expected for May 9th.
      </p>

      <p>
      Thank you for supporting PHP.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry vevent">
  <div class="newsImage"><a href="http://www.phpconference.nl/"><img src="/images/news/dpc_2013.png" alt="Dutch PHP Conference 2013" width="300" height="248" style="float: right;"></a></div>
  <h2 class="summary entry-title"><a id="id2013-04-23-1" href="http://www.phpconference.nl/" rel="bookmark" class="bookmark">Dutch PHP Conference 2013</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-04-23T11:56:47-07:00">23-Apr-2013</abbr>
    <div>
      <p>
      Ibuildings is proud to organise the seventh Dutch PHP Conference on June 7 and
      8, plus a pre-conference tutorial day on June 6. Both programs will be
      completely in English so the only Dutch thing about it is the location.
      </p>

      <p>
      This year we have 30+ speakers gathering in Amsterdam. The 3-track main
      conference covers topics like PHP 5.5, software design, APIs, Zend Framework 2,
      Symfony 2, security, scalability and more. Our Tutorial Day has an additional
      16 in-depth sessions to choose from.
      </p>

      <p>
      Your DPC ticket also lets you into the Dutch Mobile Conference: an additional
      two tracks about cutting edge javascript and non-native application
      development. This year features several side events: a bigger and better
      unconference, a Zend sponsored hackathon, a social in downtown Amsterdam, and a
      Symfony2 certification exam.
      </p>

      <p>
      The Early Bird special ends April 28th, so book right away for a 15% discount.
      We look forward to seeing you in June!
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry vevent">
  <div class="newsImage"><a href="http://www.phpsouthafrica.com/"><img src="/images/news/phpsafrica.png" alt="PHP South Africa" width="200" height="198" style="float: right;"></a></div>
  <h2 class="summary entry-title"><a id="id2013-04-12-1" href="http://www.phpsouthafrica.com/" rel="bookmark" class="bookmark">PHP South Africa 2013</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-04-12T05:59:41-07:00">12-Apr-2013</abbr>
    <div>
      <p>
      <a href="http://www.phpsouthafrica.com/">PHPSouthAfrica</a> is a 2
      day conference (October 4th &amp; 5th) to be hosted in the most
      beautiful city in the world, Cape Town South Africa.  It is aimed
      at proficient developers, new developers and people who care about
      developers.
      </p>
      <p>
      PHP is one of the most popular web programming languages used today
      to power most websites. As the language continues to grow stronger,
      PHP has now been linked with mobile powered applications. We are
      noticing a migration from mobile language applications to web based
      technologies (JavaScript, HTML5,CSS).
      </p>
      <p>
      PHPSouthAfrica has been a long time coming. With the increased
      demand for PHP programmers, not only locally but also
      internationally, our vision is to marry the latest technologies
      with international speakers. We are creating a conference that
      will hone established developers, but also assist up and coming
      programmers develop and learn new skills.With the conference
      based in Cape Town, it gives us the opportunity to showcase
      “The Mother City,” voted one of the top 10 places to visit and
      home of Table Mountain- one of the New7Wonders of Nature.
      </p>
      <p>Come and experience our great wine, food, beaches and people.</p>
      <p>We would like to welcome you.</p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-04-11-2" href="http://php.net/archive/2013.php#id2013-04-11-2" rel="bookmark" class="bookmark">PHP 5.4.14 and PHP 5.3.24 released!</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-04-11T10:16:06+00:00">11-Apr-2013</abbr>
    <div>
      <p>The PHP development team announces the immediate availability of PHP 5.4.14 and PHP 5.3.24. These releases fix about 10 bugs aswell as upgrading the bundled PCRE library. All users of PHP are encouraged to upgrade to PHP 5.4.14.</p>

      <p>For source downloads of PHP 5.4.14 and PHP 5.3.24 please visit our <a href="/downloads.php">downloads page</a>, Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.</p>

      <p>The list of changes are recorded in the <a href="/ChangeLog-5.php">ChangeLog</a>.</p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-04-11-1" href="http://php.net/archive/2013.php#id2013-04-11-1" rel="bookmark" class="bookmark">PHP 5.5 beta3 is available</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-04-11T08:32:44+00:00">11-Apr-2013</abbr>
    <div>
      <p>
      The PHP development team announces the release of the 3rd beta of PHP 5.5.0.
      This release fixes some bugs against beta 2.
      </p>

      <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>

      <p>
      PHP 5.5.0beta3 is shipped with some bug fixes and improvements. Here is an incomplete list:
      </p>
      <ul>
        <li>Drop support for bison &lt; 2.4 when building PHP from GIT source.</li>
        <li>Fixed bug #54567 (DateTimeZone serialize/unserialize)</li>
        <li>Fixed bug #64555 (foreach no longer copies keys if they are interned)</li>
        <li>Fixed bug #64578 (debug_backtrace in set_error_handler corrupts zend heap)</li>
      </ul>

      <p>You can read the full list of changes in the
      <a href="https://github.com/php/php-src/blob/php-5.5.0beta3/NEWS">NEWS file</a> contained
      in the release archive.
      </p>

      <p>
      For source downloads of PHP 5.5.0beta3 please visit
      the <a href="http://downloads.php.net/dsp">download page</a>, Windows binaries
      can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
      </p>

      <p>
      Our next beta is expected for April 25th. RC should follow.
      </p>

      <p>
      Thank you for supporting PHP.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-03-28-1" href="http://php.net/archive/2013.php#id2013-03-28-1" rel="bookmark" class="bookmark">PHP 5.5 beta2 released</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-03-28T08:55:45+00:00">28-Mar-2013</abbr>
    <div>
      <p>
      The PHP development team announces the release of the second beta of PHP 5.5.0.
      This release fixes some bugs from beta one that could prevent the release from compiling.
      </p>

      <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>

      <p>
      PHP 5.5.0beta2 is shipped with some bug fixes. Here is an incomplete list:
      </p>
      <ul>
        <li>Fixed a memoryleak when using the same variablename 2times in
        function declaration.</li>
        <li>Fixed a compilation fail with error: conflicting types for 'zendparse'</li>
        <li>Fixed Debug backtrace changed behavior since 5.4.10 or 5.4.11</li>
      </ul>

      <p>You can read the full list of changes in the
      <a href="https://github.com/php/php-src/blob/php-5.5.0beta2/NEWS">NEWS file</a> contained
      in the release archive.
      </p>

      <p>
      For source downloads of PHP 5.5.0beta2 please visit
      the <a href="http://downloads.php.net/dsp">download page</a>, Windows binaries
      can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
      </p>

      <p>
      Our next beta is expected for April 11th.
      </p>

      <p>
      Thank you for supporting PHP.
      </p>

    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-03-21-1" href="http://php.net/archive/2013.php#id2013-03-21-1" rel="bookmark" class="bookmark">PHP 5.5.0 beta1 available</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-03-21T12:45:18+00:00">21-Mar-2013</abbr>
    <div>
      <p>
      The PHP development team announces the release of the first beta of PHP 5.5.0.
      This release is the first to include the <a href="https://wiki.php.net/rfc/optimizerplus">Zend OPCache</a>.
      Please help our efforts to provide a stable PHP version and test this version carefully
      against several different applications, with Zend OPCache enabled and report any bug in
      <a href="https://bugs.php.net">the bug tracking system</a>.
      </p>

      <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>

      <p>
      PHP 5.5.0beta1 is shipped with improvements. Here is an incomplete list:
      </p>
      <ul>
        <li>Added Zend Opcache extension (but disabled by ini setting),</li>
        <li>Added array_column function which returns a column in a multidimensional
        array,</li>
        <li>Added support for non-scalar Iterator keys in foreach,</li>
        <li>Added support for changing the process's title in CLI/CLI-Server SAPIs</li>
      </ul>

      <p>You can read the full list of changes in the
      <a href="https://github.com/php/php-src/blob/php-5.5.0beta1/NEWS">NEWS file</a> contained
      in the release archive.
      </p>

      <p>
      For source downloads of PHP 5.5.0beta1 please visit
      the <a href="http://downloads.php.net/dsp">download page</a>, Windows binaries
      can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
      </p>

      <p>
      This beta marks the beginning of the feature freeze. No new
      features will be added to PHP 5.5 after this point.  Please,
      test and help us to roll out a stable release. Our next beta is
      planned for April 4th.
      </p>

      <p>
      Thank you for supporting PHP.
      </p>

    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-03-14-1" href="http://php.net/archive/2013.php#id2013-03-14-1" rel="bookmark" class="bookmark">PHP 5.4.13 and PHP 5.3.23 released!</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-03-14T20:38:02+00:00">14-Mar-2013</abbr>
    <div>
      <div>
        <div>
          <p>The PHP development team announces the immediate availability of PHP 5.4.13 and PHP 5.3.23. These releases fix about 15 bugs, including fixes for CVE-2013-1643 and CVE-2013-1635. All users of PHP are encouraged to upgrade to PHP 5.4.13.</p>

          <p>For source downloads of PHP 5.4.13 and PHP 5.3.23 please visit our <a href="/downloads.php">downloads page</a>, Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.</p>
          <p>The list of changes are recorded in the <a href="/ChangeLog-5.php">ChangeLog</a>.</p>
        </div>
      </div>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-03-07-1" href="http://php.net/archive/2013.php#id2013-03-07-1" rel="bookmark" class="bookmark">PHP 5.5.0alpha6 released</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-03-07T13:26:26+00:00">07-Mar-2013</abbr>
    <div>
      <p>
      The PHP development team announces the release of PHP 5.5.0alpha6.
      This release fixes some bugs from alpha5. It also serves as a delay for our next release, beta1,
      integrating ZendOptimizer+ OPCode cache which is not ready yet to be merged.
      All users of PHP are encouraged to test this version carefully,
      and report any bugs in <a href="https://bugs.php.net">the bug tracking system</a>.
      </p>

      <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>

      <p>
      PHP 5.5.0alpha6 is shipped with improvements. Here is an incomplete list:
      </p>
      <ul>
        <li>Fixed a bug where uninitialized ++$foo-&gt;bar; does not cause a notice,</li>
        <li>Updated bundled PCRE 8.32,</li>
        <li>Fixed a bug in ext/sockets where sendmsg/recvmsg shutdown handler causes segfault</li>
      </ul>

      <p>You can read the full list of changes in the
      <a href="https://github.com/php/php-src/blob/php-5.5.0alpha6/NEWS">NEWS file</a> contained
      in the release archive.
      </p>

      <p>
      For source downloads of PHP 5.5.0alpha6 please visit
      the <a href="http://downloads.php.net/dsp">download page</a>, Windows binaries
      can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
      </p>

      <p>
      Our first beta should show up on 21st of March.
      </p>

      <p>
      Thank you for supporting PHP.
      </p>

    </div>

  </div>
</div>
<div class="newsItem hentry vevent">
  <div class="newsImage"><a href="http://www.phpconference.com/"><img src="/images/news/ipc2013.jpg" alt="IPC2013" width="239" height="149" style="float: right;"></a></div>
  <h2 class="summary entry-title"><a id="id2013-02-24-1" href="http://www.phpconference.com/" rel="bookmark" class="bookmark">International PHP Conference</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-02-24T15:16:20-08:00">24-Feb-2013</abbr>
    <div>
      <p><a href="http://www.phpconference.com/">International PHP Conference</a> – June 2-5, 2013, Maritim proArte
      </p>
      <p><a href="http://www.phpconference.com/">The International PHP Conference</a> is a globally recognized event for PHP developers, webworkers, IT managers and everyone interested in web-technology.</p>
      <p>Again, the conference will focus on main topics for developers and core-technologies for decision makers. We will show how to scale your applications, explain the details of Continuous Integration or evaluate different approaches to NoSQL. Attendees will have the opportunity to meet with speakers, core-developers and consultants, often there is a chance for an evaluation of your code. Community as well as enterprise projects profit from our international reputation and impulses given from the developer community.</p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-02-21-1" href="http://php.net/archive/2013.php#id2013-02-21-1" rel="bookmark" class="bookmark">PHP 5.4.12 and PHP 5.3.22 released!</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-02-21T20:38:02+00:00">21-Feb-2013</abbr>
    <div>
      <div>
        <div>
          <p>The PHP development team announces the immediate availability of PHP 5.4.12 and PHP 5.3.22. These releases fix about 10 bugs. All users of PHP are encouraged to upgrade to PHP 5.4.12.</p>

          <p>For source downloads of PHP 5.4.12 and PHP 5.3.22 please visit our <a href="/downloads.php">downloads page</a>, Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.</p>
          <p>The list of changes are recorded in the <a href="/ChangeLog-5.php">ChangeLog</a>.</p>
        </div>
      </div>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-02-21-2" href="http://php.net/archive/2013.php#id2013-02-21-2" rel="bookmark" class="bookmark">PHP 5.5.0alpha5 released</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-02-21T13:33:25+00:00">21-Feb-2013</abbr>
    <div>
      <p>
      The PHP development team announces the release of PHP 5.5.0alpha5.
      This release fixes some bugs from alpha4 and adds some new features.
      All users of PHP are encouraged to test this version carefully,
      and report any bugs in <a href="https://bugs.php.net">the bug tracking system</a>.
      </p>

      <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>

      <p>
      PHP 5.5.0alpha5 is shipped with new features and improvements. Here is an incomplete list:
      </p>
      <ul>
        <li>Added the ability to change the tmp dir PHP will use during runtime, using a new php.ini
        entry,
        </li>
        <li>Added mysqli_begin_transaction()/mysqli::begin_transaction(). Implemented all
        options, per MySQL 5.6, which can be used with START TRANSACTION, COMMIT
        and ROLLBACK through options to mysqli_commit()/mysqli_rollback() and their
        respective OO counterparts.
        These changes are reflected in the mysqlnd API as well,
        </li>
        <li>
        Added recvmsg() and sendmsg() wrappers for ext/sockets
        </li>
      </ul>

      <p>You can read the full list of changes in the
      <a href="https://github.com/php/php-src/blob/php-5.5.0alpha5/NEWS">NEWS file</a> contained
      in the release archive.
      </p>

      <p>
      For source downloads of PHP 5.5.0alpha5 please visit
      the <a href="http://downloads.php.net/dsp">download page</a>, Windows binaries
      can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
      </p>

      <p>
      Alpha5 is the last alpha for PHP 5.5. There has been a delay in alpha releases due to late coming new features.
      We are now beginning the betas, and the first beta
      is expected for March 7th. Betas won't add any new features, except the first one, but consolidate the source
      code and fix found bugs.
      </p>

      <p>
      Thank you for supporting PHP.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry vevent">
  <div class="newsImage"><a href="http://tek13.phparch.com/"><img src="/images/news/tek13_badge.png" alt="php[tek] 2013" width="300" height="140" style="float: right;"></a></div>
  <h2 class="summary entry-title"><a id="id2013-02-07-1" href="http://tek13.phparch.com/" rel="bookmark" class="bookmark">php[tek] 2013: Schedule Posted</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-02-07T17:45:52-08:00">07-Feb-2013</abbr>
    <div>
      <p>The <a href="http://tek13.phparch.com/schedule">conference
        schedule</a> &amp; speaker selection for <a href="http://tek13.phparch.com/">tek13</a> have now been posted online.
      tek13 is taking place from May 14th - 17th, 2013 in it's traditional
      Chicago, IL location.  This year we've decided to expand the conference,
      and it is now running 4 parallel tracks!  <a href="http://tek13.phparch.com/pricing-and-registration/">Register
        soon</a> as the Early Bird discount rate expires on February 28th.</p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-01-24-1" href="http://php.net/archive/2013.php#id2013-01-24-1" rel="bookmark" class="bookmark">PHP 5.5.0alpha4 released</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-01-24T10:28:02+00:00">24-Jan-2013</abbr>
    <div>
      <p>
      The PHP development team announces the release of PHP 5.5.0alpha4.
      This release fixes some bugs from alpha3 and adds some new features.
      All users of PHP are encouraged to test this version carefully,
      and report any bugs in <a href="https://bugs.php.net">the bug tracking system</a>.
      </p>

      <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>

      <p>
      PHP 5.5.0alpha4 is shipped with new features and improvements such as (incomplete list):
      </p>
      <ul>
        <li>Class Name Resolution as scalar via "class" keyword,
        </li>
        <li>Added DateTimeImmutable class, a variant of DateTime that only returns the
        modified state instead of changing itself
        </li>
      </ul>

      <p>You can read the full list of changes in the
      <a href="https://github.com/php/php-src/blob/php-5.5.0alpha4/NEWS">NEWS file</a> contained
      in the release archive.
      </p>

      <p>
      For source downloads of PHP 5.5.0alpha4 please visit
      the <a href="http://downloads.php.net/dsp">download page</a>, Windows binaries
      can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
      </p>

      <p>
      Alpha4 is the last alpha for PHP 5.5. We are now beginning the betas, and the first beta
      is expected for February 7th. Betas won't add any new features but consolidate the source
      code and fix found bugs.
      </p>

      <p>
      Thank you for supporting PHP.
      </p>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-01-17-1" href="http://php.net/archive/2013.php#id2013-01-17-1" rel="bookmark" class="bookmark">PHP 5.4.11 and PHP 5.3.21 released!</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-01-17T14:54:00+00:00">17-Jan-2013</abbr>
    <div>
      <div>
        <p>The PHP development team announces the immediate availability of PHP 5.4.11 and PHP 5.3.21. These releases fix about 10 bugs. All users of PHP are encouraged to upgrade to PHP 5.4.</p>
        <p>For source downloads of PHP 5.4.11 and PHP 5.3.21 please visit our <a href="/downloads.php">downloads page</a>, Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.</p>
        <p>The list of changes are recorded in the <a href="/ChangeLog-5.php">ChangeLog</a>.</p>
      </div>
    </div>

  </div>
</div>
<div class="newsItem hentry vevent">
  <div class="newsImage"><a href="http://confoo.ca"><img src="/images/news/confoo-2013-php.jpg" alt="ConFoo 2013" width="180" height="250" style="float: right;"></a></div>
  <h2 class="summary entry-title"><a id="id2013-01-11-1" href="http://confoo.ca" rel="bookmark" class="bookmark">ConFoo: Last Chance to Save $145</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-01-11T21:31:28+00:00">11-Jan-2013</abbr>
    <div>
      <p>Save $145 on ConFoo tickets by purchasing before January 20th. <a href="http://confoo.ca/en/register">Register online</a> without delay. ConFoo 2013 will be held on February 27th through March 1st in Montreal, Canada and is loaded with PHP content.</p>

      <p>We gathered 100 speakers from around the world to talk about all aspects of web programming. The conference is preceeded by two training days. Places are very limited. Choose from 4 training topics:</p>

      <ul>
        <li>Advanced PHP Training (Sebastian Bergmann, Arne Blankerts and Stefan Priebsch)</li>
        <li>PHP Web Security: From Exploitation to Correction (Jonathan Marcil)</li>
        <li>Practical Symfony2 (Hugo Hamon)</li>
        <li>JavaScript Training (Laurent Villeneuve)</li>
      </ul>
    </div>

  </div>
</div>
<div class="newsItem hentry">
  <div class="newsImage"></div>
  <h2 class="summary entry-title"><a id="id2013-01-10-1" href="http://php.net/archive/2013.php#id2013-01-10-1" rel="bookmark" class="bookmark">PHP 5.5.0 Alpha3 released</a></h2>
  <div class="entry-content description">
    <abbr class="published newsdate" title="2013-01-10T14:42:37+00:00">10-Jan-2013</abbr>
    <div>
      <p>
      The PHP development team announces the release of PHP 5.5.0alpha3.
      This release adds few features and fix some bugs from alpha2.
      All users of PHP are encouraged to test this version carefully,
      and report any bugs in <a href="https://bugs.php.net">the bug tracking system</a>.
      </p>

      <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>

      <p>
      PHP 5.5.0 Alpha 3 comes with new features and improvements such as (incomplete list) :
      </p>
      <ul>
        <li>Generator::throw() method,
        </li>
        <li>New cURL functions and options such as curl_escape(), curl_multi_setopt(), curl_multi_strerror(),
        curl_pause(), curl_reset()...
        </li>
        <li>Max-Age attribute support in setcookie(),
        </li>
        <li>Few bug fixes in mysqlnd and core
        </li>
      </ul>

      <p>You can read the full list of changes in the
      <a href="https://github.com/php/php-src/blob/php-5.5.0alpha3/NEWS">NEWS file</a> contained
      in the release archive.
      </p>

      <p>
      For source downloads of PHP 5.5.0 Alpha 3 please visit
      the <a href="http://downloads.php.net/dsp">download page</a>, Windows binaries
      can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
      </p>

      <p>
      Thank you for supporting PHP.
      </p>
    </div>

  </div>
</div>

<?php

site_footer(['elephpants' => true, 'sidebar' => $SIDEBAR_DATA]);
