<?php
$_SERVER['BASE_PAGE'] = 'archive/2012.php';
include_once __DIR__ . '/../include/prepend.inc';
news_archive_sidebar();
site_header("News Archive - 2012", ["cache" => true]);
?>

<h1>News Archive - 2012</h1>

<p>
 Here are the most important news items we have published in 2012 on PHP.net.
</p>

<hr>
<div class="newsItem hentry">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-12-21-1" href="http://php.net/archive/2012.php#id2012-12-21-1" rel="bookmark" class="bookmark">PHP 5.5.0 Alpha2 released</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-12-21T16:19:14+00:00">21-Dec-2012</abbr>
        <div>
    <p>
        The PHP development team announces the immediate availability of
        PHP 5.5.0alpha2. This release adds new features and fix some bugs from alpha1.
        All users of PHP are encouraged to test this version carefully,
        and report any bugs in <a href="https://bugs.php.net">the bug tracking system</a>.
     </p>

     <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>

     <p>
      PHP 5.5.0 Alpha 2 comes with new features and improvements such as (incomplete list) :
     </p>
     <ul>
        <li>Support for using empty() on the result of function calls and
            other expressions,
        </li>
        <li>Systemtap support by enabling systemtap compatible dtrace probes on
            linux,
        </li>
        <li>Optimized access to temporary and compiled VM variables.
            8% less memory reads.
        </li>
     </ul>
     <p>
      Please, note that this alpha version also introduces the ext/mysql depreciation.
     </p>

     <p>You can read the full list of changes in the
      <a href="https://github.com/php/php-src/blob/php-5.5.0alpha2/NEWS">NEWS file</a> contained
      in the release archive.
     </p>

     <p>
      For source downloads of PHP 5.5.0 Alpha 2 please visit
      the <a href="http://downloads.php.net/dsp">download page</a>, Windows binaries
      can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
     </p>

     <p>
        Thank you for helping us making PHP better.
     </p>
    </div>

    </div>
</div>
<div class="newsItem hentry vevent">
    <div class="newsImage"><a href="http://conference.phpbenelux.eu/2013/"><img src="/images/news/phpbenelux_conference_logo-01-e1344277762627.png" alt="PHPBenelux Conference 2013" width="450" height="118" style="float: right;"></a></div>
    <h2 class="summary entry-title"><a id="id2012-12-20-2" href="http://conference.phpbenelux.eu/2013/" rel="bookmark" class="bookmark">PHPBenelux Conference 2013</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-12-20T12:16:46-08:00">20-Dec-2012</abbr>
        <div>
     <p>
     After a very successful 2012 edition, we are proud to announce PHPBenelux
     Conference 2013. This event will take place on Friday January 25th and
     Saturday January 26th 2013 in Antwerp, Belgium. We organize a community
     oriented conference that is built around an excellent lineup and awesome
     socials. Our schedule has been announced and tickets are available. Go to
     <a href="http://conference.phpbenelux.eu/2013/">http://conference.phpbenelux.eu/2013/</a> for more information.
     </p>
    </div>

    </div>
</div>
<div class="newsItem hentry">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-12-20-1" href="http://php.net/archive/2012.php#id2012-12-20-1" rel="bookmark" class="bookmark">PHP 5.4.10 and PHP 5.3.20 released!</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-12-20T11:38:49+00:00">20-Dec-2012</abbr>
        <div>
     <div>
       <p>The PHP development team announces the immediate availability of PHP 5.4.10 and PHP 5.3.20. These releases fix about 15 bugs. Please note that the PHP 5.3 series will enter an end of life cycle and receive only critical fixes as of March 2013. All users of PHP are encouraged to upgrade to PHP 5.4.</p>
       <p>For source downloads of PHP 5.4.10 and PHP 5.3.20 please visit our <a href="/downloads.php">downloads page</a>, Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.</p>
       <p>The list of changes are recorded in the <a href="/ChangeLog-5.php">ChangeLog</a>.</p>
     </div>
    </div>

    </div>
</div>
<div class="newsItem hentry vevent">
    <div class="newsImage"><a href="http://tek13.phparch.com/"><img src="/images/news/tek13_badge.png" alt="php[tek] 2013" width="300" height="140" style="float: right;" ></a></div>
    <h2 class="summary entry-title"><a id="id2012-12-19-1" href="http://tek13.phparch.com/" rel="bookmark" class="bookmark">php[tek] 2013 Conference</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-12-19T14:57:57-08:00">19-Dec-2012</abbr>
        <div>
     <p>We are pleased to announce that <a href="http://tek13.phparch.com/">tek13</a> will be taking place this
     year again at it's traditional location in Chicago, IL.  This year's
     dates are from May 14th - 17th, 2013.  It will again be a 3-track
     conference with a focus on the community.</p>

     <p>The <a href="http://tek13.phparch.com/call-for-papers/">Call for
     Papers</a> has been announced and will be running until January 15th,
     2013.   Conference registration will open on January 1st.  We look
     forward to seeing many of you there this year!</p>
    </div>

    </div>
</div>
<div class="newsItem hentry">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-11-22-1" href="http://www.php.net/archive/2012.php#id2012-11-22-1" rel="bookmark" class="bookmark">PHP 5.4.9 and PHP 5.3.19 released!</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-11-22T17:54:29+01:00">22-Nov-2012</abbr>
        <div>
     <p>The PHP development team announces the immediate availability of PHP 5.4.9 and PHP 5.3.19. These releases fix over 15 bugs. All users of PHP are encouraged to upgrade to PHP 5.4.9, or at least 5.3.19.</p>
     <p>For source downloads of PHP 5.4.9 and PHP 5.3.19 please visit our <a href="/downloads.php">downloads page</a>, Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.</p>
     <p>The list of changes are recorded in the <a href="/ChangeLog-5.php">ChangeLog</a>.</p>
    </div>

    </div>
</div>
<div class="newsItem hentry">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-11-15-1" href="http://www.php.net/archive/2012.php#id2012-11-15-1" rel="bookmark" class="bookmark">PHP 5.5.0 Alpha1 released</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-11-15T14:10:06+00:00">15-Nov-2012</abbr>
        <div>
      <p>
        The PHP development team announces the immediate availability of
        PHP 5.5.0alpha1. This release marks the beginning of the PHP 5.5.0 release cycle.
        All users of PHP are encouraged to test this version carefully,
        and report any bugs in <a href="https://bugs.php.net">the bug tracking system</a>.
     </p>

     <strong>THIS IS A DEVELOPMENT PREVIEW - DO NOT USE IT IN PRODUCTION!</strong>

     <p>
      PHP 5.5.0 Alpha 1 comes with new features such as (incomplete list) :
     </p>
     <ul>
        <li>support for Generators,</li>
        <li>a new password hashing API,</li>
        <li>support for finally in try/catch blocks</li>
        <li>support for list() in foreach,</li>
        <li>constant array/string dereferencing,</li>
        <li>ext/intl improvement.</li>
     </ul>
     <p>We also dropped support for Windows XP and 2003.</p>

     <p>You can read the full list of changes in the
      <a href="https://github.com/php/php-src/blob/php-5.5.0alpha1/NEWS">NEWS file</a> contained
      in the release archive.
     </p>

     <p>
      For source downloads of PHP 5.5.0 Alpha 1 please visit
      the <a href="http://downloads.php.net/dsp">download page</a>, Windows binaries
      can be found on <a href="http://windows.php.net/qa/">windows.php.net/qa/</a>.
     </p>

     <p>
        Thank you for helping us making PHP better.
     </p>

    </div>

    </div>
</div>
<div class="newsItem hentry vevent">
    <div class="newsImage"><a href="http://sunshinephp.com/"><img src="/images/news/sunshine2013.png" alt="SunshinePHP Developer Conference" width="180" height="180" style="float: right;"></a></div>
    <h2 class="summary entry-title"><a id="id2012-11-03-1" href="http://sunshinephp.com/" rel="bookmark" class="bookmark">SunshinePHP Developer Conference</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-11-03T13:04:07-07:00">03-Nov-2012</abbr>
        <div>
     <p>
         <a href="http://soflophp.org/">SoFloPHP</a> is excited to present the inaugural <a href="http://sunshinephp.com/">SunshinePHP Developer Conference</a> in Miami, Florida
         from February 8th - 9th, 2013.  This 2 day event will feature 3 awesome tracks, with one track
         dedicated to Symfony.  We are also planning an Uncon, as well as a hack event, and many
         opportunities to socialize with the PHP community.  Please register soon to take advantage of
         our early bird discounted rate before it ends.
     </p>
     <p>
         In February when the rest of the world is cold and snowy, it is sunny and beautiful in
         Florida. Come join us for some sun and learning.
     </p>
     <p>
         Our call for papers runs until December 1st, 2012, so please get those talks in!  We will
         be announcing the sessions and speakers around mid-December after our board has a chance to
         consider each submission.
     </p>
    </div>

    </div>
</div>
<div class="newsItem hentry vevent">
    <div class="newsImage"><a href="http://phpconference.co.uk/"><img src="/images/news/phpuk2013.jpeg" alt="PHP UK 2013" width="161" height="107" style="float: right;"></a></div>
    <h2 class="summary entry-title"><a id="id2012-11-02-1" href="http://phpconference.co.uk/" rel="bookmark" class="bookmark">PHP UK Conference</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-11-02T09:39:14-07:00">02-Nov-2012</abbr>
        <div>
     <p>
         <a href="http://phplondon.org">PHP London</a> are pleased to announce the 8th Annual PHP UK conference;
         a 2-day event with 4 great tracks held at at The Brewery in the heart of the City of London on February 22nd- 23rd 2013.
     </p>
     <p>
         With over 600 delegates, speakers, and sponsors, PHP UK conference aims to deliver fantastic up to date content about
         PHP and related web technologies in a comfortable and professional setting. There are countless networking opportunities
         to engage with international speakers and delegates, which makes the event one you won't want to miss.
     </p>
     <p>
         Our call for papers is open until November the 22nd and we would love to hear from you!
     </p>
    </div>

    </div>
</div>
<div class="newsItem hentry">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-10-18-1" href="http://www.php.net/archive/2012.php#id2012-10-18-1" rel="bookmark" class="bookmark">PHP 5.4.8 and PHP 5.3.18 released!</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-10-18T17:35:45+00:00">18-Oct-2012</abbr>
        <div>
     <p>
      The PHP development team announces the immediate availability of
      PHP 5.4.8 and PHP 5.3.18. These releases fix over 20 bugs.
      All users of PHP are encouraged to upgrade to PHP 5.4.8,
      or at least 5.3.18.
     </p>

     <p>
      Key enhancements in these releases include:
     </p>

     <ul>
         <li>Fixed bug #63111 (is_callable() lies for abstract static method)</li>
       <li>Fixed bug #61442 (exception threw in __autoload can not be catched)</li>
     </ul>

     <p>
      For source downloads of PHP 5.4.8 and PHP 5.3.18 please visit
      our <a href="/downloads.php">downloads page</a>, Windows binaries
      can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     </p>

     <p>
      The list of changes are recorded in the <a href="/ChangeLog-5.php">ChangeLog</a>.
     </p>

    </div>

    </div>
</div>
<div class="newsItem hentry vevent">
    <div class="newsImage"><a href="http://truenorthphp.ca/"><img src="/images/news/truenorth2012.jpg" alt="True North 2012" width="363" height="173" style="float: right;"></a></div>
    <h2 class="summary entry-title"><a id="id2012-10-13-2" href="http://truenorthphp.ca/" rel="bookmark" class="bookmark">True North PHP</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-10-13T17:00:14-07:00">13-Oct-2012</abbr>
        <div>
     <p>
     <a href="http://truenorthphp.ca/">True North PHP</a> is a 2 day, multi-track, community-driven PHP conference.
     We believe that the PHP community is second to none, and also believe
     that Toronto has an awesome PHP community and deserves an equally
     awesome conference.
     </p>

     <p>
     Come out November 2-3, 2012 and hear both local talent and
     internationally known members of the PHP community share their thoughts
     and tools they use to build the web.
     </p>
    </div>

    </div>
</div>
<div class="newsItem hentry vevent">
    <div class="newsImage"><a href="http://www.web-developer-conference.de/"><img src="/images/news/Logo_WDC_2013.jpg" alt="WDC2013" width="400" height="97" style="float: right;"></a></div>
    <h2 class="summary entry-title"><a id="id2012-10-13-1" href="http://www.web-developer-conference.de/" rel="bookmark" class="bookmark">Web Developer Conference (WDC) 2013</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-10-13T16:17:20-07:00">13-Oct-2012</abbr>
        <div>
     <p>
     The Web Developer Conference (WDC) is the conference for web developers from the 24th – 27th
     June 2013 in Nuremberg (Germany). The conference is addressed to developers of web applications,
     content and online managers, agencies and webmasters. The WDC will be presented by the German
     trade magazine "web &amp; mobile developer". More information about the conference can be found on
     the website via <a href="http://www.web-developer-conference.de">www.web-developer-conference.de</a>.
     </p>
    </div>

    </div>
</div>
<div class="newsItem hentry vevent">
    <div class="newsImage"><a href="http://www.midwestphp.com/"><img src="/images/news/rsz_midwestphpconference_customlogodesign_rl3.jpg" alt="Midwest PHP Conference" width="180" height="180" style="float: right;"></a></div>
    <h2 class="summary entry-title"><a id="id2012-10-05-1" href="http://www.midwestphp.com/" rel="bookmark" class="bookmark">Midwest PHP Conference</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-10-05T15:43:04-07:00">05-Oct-2012</abbr>
        <div>
     <p>
         <a href="http://www.midwestphp.com/">MidwestPHP</a> (March 2 and 3rd, 2013 - St. Paul, MN, USA)
         is a two-day conference in the heart of Minnesota featuring 40+ sessions covering a
         wide range of topics ranging from PHP basics for newbies to advanced PHP concepts,
         frameworks, databases, third party tools and components, and web development.
     </p>
    </div>

    </div>
</div>
<div class="newsItem hentry">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-09-13-1" href="http://www.php.net/archive/2012.php#id2012-09-13-1" rel="bookmark" class="bookmark">PHP 5.4.7 and PHP 5.3.17 released!</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-09-13T15:29:37+00:00">13-Sep-2012</abbr>
        <div>
     <p>
      The PHP development team announces the immediate availability of
      PHP 5.4.7 and PHP 5.3.17. These releases fix over 20 bugs.
      All users of PHP are encouraged to upgrade to PHP 5.4.7,
      or at least 5.3.17.
     </p>

     <p>
      Key enhancements in these releases include:
     </p>

     <ul>
       <li>Fixed bug #62955 (Only one directive is loaded from "Per Directory Values" Windows registry).</li>
       <li>Fixed bug #62460 (php binaries installed as binary.dSYM).</li>
     </ul>

     <p>
      For source downloads of PHP 5.4.7 and PHP 5.3.17 please visit
      our <a href="/downloads.php">downloads page</a>, Windows binaries
      can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     </p>

     <p>
      The list of changes are recorded in the <a href="/ChangeLog-5.php">ChangeLog</a>.
     </p>
    </div>

    </div>
</div>
<div class="newsItem hentry vevent">
    <div class="newsImage"><a href="http://codeconnexx.com/"><img src="/images/news/codeconnexx.com-1.jpg" alt="CodeConnexx" width="472" height="144" style="float: right;"></a></div>
    <h2 class="summary entry-title"><a id="id2012-09-11-1" href="http://codeconnexx.com/" rel="bookmark" class="bookmark">CodeConnexx</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-09-11T12:33:16-05:00">11-Sep-2012</abbr>
        <div>
     <p>
     <a href="http://codeconnexx.com/" target="_blank">CodeConnexx</a> (8-9 November, 2012, Indianapolis, IN, USA)
     is a two-day, one track conference that aims to bring together men and women of all ages, races, backgrounds,
     and skillsets interested in talking about code. The first day is focused on technical talks, centered around
     PHP and related topics. The second day is dedicated to all the other things that we encounter as developers:
     mentoring, working together on a diverse team, getting started in open source, and other topics. Free onsite
     childcare will be available for those who need it. We hope you can join us!
     </p>
    </div>

    </div>
</div>
<div class="newsItem hentry vevent">
    <div class="newsImage"><a href="http://phpconference.com/"><img src="/images/news/icp2012.jpg" alt="IPC 2012" width="396" height="254" style="float: right;"></a></div>
    <h2 class="summary entry-title"><a id="id2012-09-05-1" href="http://phpconference.com/" rel="bookmark" class="bookmark">International PHP Conference 2012</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-09-05T18:41:44+01:00">05-Sep-2012</abbr>
        <div>
     <p>
     The <a href="http://phpconference.com/">International PHP Conference</a> (October 14-17th - Mainz, Germany)
     is a globally recognized event for PHP developers,
     web workers, IT managers and everyone interested in web technologies.
     </p>
     <p>
     Once again the conference will explore key topics and core technologies for developers and decision makers.
     It will be demonstrated how to scale your applications, explain the details of Continuous Integration or
     evaluate different approaches to NoSQL.
     </p>
     <p>
     Attendees will have the opportunity to meet with speakers, core developers and consultants, and there are often opportunities to evaluate your code.
     Community and enterprise projects profit from its international reputation and impulses given from the developer community.
     </p>
    </div>

    </div>
</div>
<div class="newsItem hentry vevent">
    <div class="newsImage"><a href="http://confoo.ca/en"><img src="/images/news/confoo-2013-php.jpg" alt="ConFoo Web Techno Conference. February 25 - March  1, 2013 | Montreal, Canada" width="180" height="250" style="float: right;"></a></div>
    <h2 class="summary entry-title"><a id="id2012-08-29-1" href="http://confoo.ca/en" rel="bookmark" class="bookmark">ConFoo 2013 - Call for Papers is Now Open!</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-08-29T14:50:10+00:00">29-Aug-2012</abbr>
        <div>
     <p>ConFoo is one of the most important developer-oriented conferences loaded with PHP content. ConFoo 2013 will be held on February 25 through March 1 in Montreal, Canada.</p>

     <p>The team just opened its call for papers. Candidates can submit proposals <b>until September 23</b>. Consult the <a href="http://confoo.ca/en/call-for-papers">call for papers</a> page for details and to start submitting. That page also explains what expenses ConFoo can cover for speakers. You can even get <a href="http://confoo.ca/en/call-for-papers/guidelines">advice</a> on how to write proposals.</p>

     <p>The call for papers is public, meaning that all proposals get published on the website for others to vote and comment on. This approach allows the organizers to pick subjects that have most interest in the community. The comments are only visible to speakers and organizers to avoid influencing the votes.</p>

     <p>To stay in touch via Twitter, follow <a href="http://twitter.com/confooca">@confooca</a> and use the <a href="http://twitter.com/#!/search/%23confoo">#confoo</a> tag. You can also help promote the event with these cool <a href="http://confoo.ca/en/propaganda">badges</a> for your site.</p>

    </div>

    </div>
</div>
<div class="newsItem hentry vevent">
    <div class="newsImage"><a href="http://conference.phpnw.org.uk/phpnw12"><img src="/images/news/phpnw12_details_200x1441.png" alt="PHPNW12" width="200" height="144" style="float: right;"></a></div>
    <h2 class="summary entry-title"><a id="id2012-08-21-1" href="http://conference.phpnw.org.uk/phpnw12" rel="bookmark" class="bookmark">PHPNW12 - PHP North West 2012</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-08-21T19:59:32+02:00">21-Aug-2012</abbr>
        <div>
     <p>
      Organised by developers for developers,
      <a href="http://conference.phpnw.org.uk/phpnw12">PHPNW12</a>
      is the perfect opportunity to learn, network and mix with peers and
      industry leaders, as well as discover the latest tricks, techniques
      and innovations in PHP and internet development.
     </p>
     <p>
      Come to Manchester and join in this year's fabulous
      <a href="http://conference.phpnw.org.uk/phpnw12">PHPNW conference</a>.
      Building on the success of previous years, we have a bigger schedule,
      more venues, more great content and hopefully more fun than ever!
      With speakers from across the PHP sphere and its allied technologies,
      there is something for everyone at this event, and always someone to
      talk tech to if you want to.
     </p>
     <p>
      Starting on the Friday with our
      <a href="http://conference.phpnw.org.uk/phpnw12/tutorial-day/">Tutorial Day</a>
      which is a fantastic opportunity for individuals and teams of PHP
      developers to come together for a full day of hands on teaching tailored
      just for you. Whether you want to know more about Building a Zend
      Framework 2 Application, Tools of the PHP Trade, Hands on debugging with
      Xdebug, Test your code like a pro – PHPUnit in practice, Create your own
      PHP Extension step by step or Scaling Your Team Using HubFlow – A Git
      Workflow For Git Hub, this will be the experience for which you have
      been waiting.
     </p>
    </div>

    </div>
</div>
<div class="newsItem hentry vevent">
    <div class="newsImage"><a href="http://www.zendcon.com/"><img src="/images/news/zendCon12.jpeg" alt="ZendCon 2012" width="247" height="104" style="float: right;"></a></div>
    <h2 class="summary entry-title"><a id="id2012-08-16-2" href="http://www.zendcon.com/" rel="bookmark" class="bookmark">ZendCon 2012</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-08-16T23:31:43+01:00">16-Aug-2012</abbr>
        <div>
     <p>
         <a href="http://www.zendcon.com">The PHP 2012 conference (ZendCon)</a> offers you the chance to learn from a huge variety of technical sessions and in-depth tutorials. International industry experts, renowned thought-leaders and experienced PHP practitioners are on-hand to discuss PHP best practices and explore future technological developments.
     </p>
     <p>
     This year promises to be the best ZendCon ever! We are planning a fun new exhibit hall, some great parties including a hackathon and, of course, oodles of excellent PHP content!
     </p>
     <p>
     <ul>
     <li>Learn PHP best practices for architecture, design and development</li>
     <li>Discover new advances in the PHP language and how to best harness them</li>
     <li>Learn how to effectively leverage Zend Framework and get hands on with coding in Zend Framework 2.0</li>
     <li>Gain insights from peers, PHP luminaries, community members and thought-leaders</li>
     <li>Discover how to deploy and scale large PHP applications</li>
     <li>Explore new technologies like NoSQL and Cloud Computing</li>
     </ul>
     </p>
     <p>
     <ul>
     <li>What: PHP 2012 (ZendCon)
     </li>
     <li>When: Mon Oct 22- Thurs Oct 25
     </li>
     <li>Where: Santa Clara, CA
     </li>
     <li>Tickets: Early reg discount until Sept 8
     </li>
     </ul>
     </p>
    </div>

    </div>
</div>
<div class="newsItem hentry">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-08-16-1" href="http://www.php.net/archive/2012.php#id2012-08-16-1" rel="bookmark" class="bookmark">PHP 5.4.6 and PHP 5.3.16 released!</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-08-16T19:30:09+00:00">16-Aug-2012</abbr>
        <div>
	    <p>The PHP development team announces the immediate availability of PHP 5.4.6 and PHP 5.3.16. These releases fix over 20 bugs. All users of PHP are encouraged to upgrade to PHP 5.4.6, or at least 5.3.16.</p>

     <p>For source downloads of PHP 5.4.6 and PHP 5.3.16 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
          Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
          The list of changes are recorded in the <a href="http://www.php.net/ChangeLog-5.php">ChangeLog</a>.</p>
    </div>

    </div>
</div>
<div class="newsItem hentry vevent">
    <div class="newsImage"><a href="http://london2012.live.symfony.com/"><img src="/images/news/sfl_london.png" alt="Sf Live London" width="212" height="214" style="float: right;"></a></div>
    <h2 class="summary entry-title"><a id="id2012-08-15-1" href="http://london2012.live.symfony.com/" rel="bookmark" class="bookmark">Symfony Live London</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-08-15T15:01:17+01:00">15-Aug-2012</abbr>
        <div>
     <p>This event, in the heart of London's vibrant technical scene, brings
     together the best minds from open source enterprise software development.
     The newly-formed Sensio Labs UK is delighted to serve up a UK edition of
     the wildly successful Symfony Live events, with two days (September 13th &amp; 14th)
     of excellent technical content for you to enjoy.</p>
 <p>Day one is <a href="http://london2012.live.symfony.com/training">workshop day</a>,
     we'll spend the day absorbing knowledge from
     industry leaders in a choice of two in-depth workshops. On workshop day
     we're also offering the opportunity to take the Symfony Certified Developer
     Exam - be sure to book your slot if you think you have what it takes!</p>
 <p>For the <a href="http://london2012.live.symfony.com/schedule">main conference day</a>
     on Friday we're pulling out all the stops to
     make this a festival of technology and inspiration that you'll remember.
     Whether you're new to Symfony, already using Symfony 1, or an experienced
     developer looking to find out more, this event will have something to make
     you glad you came along.</p>
    </div>

    </div>
</div>
<div class="newsItem hentry vevent">
    <div class="newsImage"><a href="http://www.web-developer-conference.de"><img src="/images/news/wdc-2012.jpg" alt="The Web Developer Conference" width="216" height="59" style="float: right;"></a></div>
    <h2 class="summary entry-title"><a id="id2012-07-27-1" href="http://www.web-developer-conference.de" rel="bookmark" class="bookmark">The Web Developer Conference</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-07-27T17:15:23+01:00">27-Jul-2012</abbr>
        <div>
     <p>
          <a href="http://www.web-developer-conference.de">The Web Developer Conference (WDC)</a>
          for web developers from the 17th - 18th of September, 2012 in Hamburg, Germany.
          The conference is geared towards developers of web applications,
          content and online managers, agencies and web-masters.
          </p>
          <p>
          The WDC will be represented by the German trade magazine web &amp; mobile developer.
          More information about the conference can be found on
          <a href="http://www.web-developer-conference.de">the conference website</a>.
          </p>
    </div>

    </div>
</div>
<div class="newsItem hentry">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-07-19-1" href="http://www.php.net/archive/2012.php#id2012-07-19-1" rel="bookmark" class="bookmark">PHP 5.4.5 and PHP 5.3.15 released!</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-07-19T23:50:47+02:00">19-Jul-2012</abbr>
        <div>
     <p>The PHP development team would like to announce the immediate
     availability of PHP 5.4.5 and PHP 5.3.15. This release fixes over 30
     bugs and includes a fix for a security related overflow issue in the
     stream implementation. All users of PHP are encouraged to upgrade to
     PHP 5.4.5 or PHP 5.3.15.</p>

     <p>For source downloads of PHP 5.4.5 and PHP 5.3.15 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes are recorded in the <a href="http://www.php.net/ChangeLog-5.php">ChangeLog</a>.</p>

    </div>

    </div>
</div>
<div class="newsItem hentry vevent">
    <div class="newsImage"><a href="http://www.northeastphp.org/"><img src="/images/news/NENA_logo.png" alt="Northeast PHP Conference" width="352" height="191" style="float: right;"></a></div>
    <h2 class="summary entry-title"><a id="id2012-06-27-1" href="http://www.northeastphp.org/" rel="bookmark" class="bookmark">Northeast PHP Conference</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-06-27T16:20:12+01:00">27-Jun-2012</abbr>
        <div>
     <p>
         The Northeast PHP conference is a two day event coordinated by three PHP user groups in the northeast region:
         Boston PHP, Atlantic Canada PHP, and Vermont PHP. The entire event is being organized organized by community
         volunteers and members just like you. We are completely non profit, and open source.
     </p>
     <p>
         There will be nothing quite like it. With two fun-filled days full of great topics from over 40 experts, it's like three years of Meetups jam packed into two days!
     </p>
     <p>
         Check out the <a href="http://www.northeastphp.org/">Northeast PHP website</a> for a listing of the talks and speakers lined up.
     </p>
     <p>
         <ul>
             <li><strong>What:</strong> Northeast PHP Conference</li>
             <li><strong>When:</strong> Sat-Sun August 11-12, 2012 8am-5pm</li>
             <li><strong>*Where:</strong> Microsoft NERD</li>
             <li><strong>*Tickets:</strong> Tickets go on sale June 28th!</li>
         </ul>
     </p>
    </div>

    </div>
</div>
<div class="newsItem hentry">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-06-14-1" href="http://www.php.net/archive/2012.php#id2012-06-14-1" rel="bookmark" class="bookmark">PHP 5.4.4 and PHP 5.3.14 released!</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-06-14T14:36:29+02:00">14-Jun-2012</abbr>
        <div>
     <p>The PHP development team would like to announce the immediate
      availability of PHP 5.4.4 and PHP 5.3.14. All users of PHP are
      encouraged to upgrade to PHP 5.4.4 or PHP 5.3.14.</p>

      <p>The release fixes multiple security issues: A weakness in the DES
      implementation of <a href="http://docs.php.net/crypt">crypt</a> and a
      heap overflow issue in the phar extension</p>

     <p>PHP 5.4.4 and PHP 5.3.14 fixes over 30 bugs. Please note that the
     use of <i>php://fd</i> streams is now restricted to the CLI SAPI</p>

      <p>For source downloads of PHP 5.4.4 and PHP 5.3.14 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
      Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
      The list of changes are recorded in the <a href="http://www.php.net/ChangeLog-5.php">ChangeLog</a>.</p>
    </div>

    </div>
</div>
<div class="newsItem hentry">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-05-08-1" href="http://www.php.net/archive/2012.php#id2012-05-08-1" rel="bookmark" class="bookmark">PHP 5.4.3 and PHP 5.3.13 Released!</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-05-08T19:44:07+02:00">08-May-2012</abbr>
        <div>
     <p>The PHP development team would like to announce the immediate
     availability of PHP 5.4.3 and PHP 5.3.13. All users are encouraged
     to upgrade to PHP 5.4.3 or PHP 5.3.13</p>

     <p>The releases complete a fix for a <a href="http://www.php.net/archive/2012.php#id2012-05-03-1">vulnerability</a>
     in CGI-based setups (CVE-2012-2311). <i>Note: mod_php and php-fpm are not vulnerable to this attack.</i></p>

     <p>PHP 5.4.3 fixes a buffer overflow vulnerability in the
     <a href="http://php.net/manual/function.apache-request-headers.php">apache_request_headers()</a> (CVE-2012-2329).
     The PHP 5.3 series is not vulnerable to this issue.</p>

     <p>For source downloads of PHP 5.4.3 and PHP 5.3.13 please visit our <a href="http://www.php.net/downloads.php">downloads page</a>,
     Windows binaries can be found on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.
     The list of changes are recorded in the <a href="http://www.php.net/ChangeLog-5.php">ChangeLog</a>.</p>
    </div>

    </div>
</div>
<div class="newsItem hentry">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-05-06-1" href="http://www.php.net/archive/2012.php#id2012-05-06-1" rel="bookmark" class="bookmark">PHP 5.3.12 and 5.4.2 and the CGI flaw (CVE-2012-1823)</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-05-06T23:00:36+02:00">06-May-2012</abbr>
        <div>
    <p>PHP 5.3.12/5.4.2 do not fix all variations of the CGI issues described
    in CVE-2012-1823. It has also come to our attention that some sites use
    an insecure cgiwrapper script to run PHP. These scripts will use <strong>$*</strong>
    instead of <strong>"$@"</strong> to pass parameters to php-cgi which causes a number of
    issues. Again, people using mod_php or php-fpm are not affected.</p>

    <p>
    One way to address these CGI issues is to reject the request if the query string
    contains a '-' and no '='. It can be done using Apache's mod_rewrite like this:

    <pre>
    RewriteCond %{QUERY_STRING} ^[^=]*$
    RewriteCond %{QUERY_STRING} %2d|\- [NC]
    RewriteRule .? - [F,L]
    </pre>

    Note that this will block otherwise safe requests like ?top-40 so if you
    have query parameters that look like that, adjust your regex accordingly.</p>

    <p>Another set of releases are planned for Tuesday, May, 8th. These
    releases will fix the CGI flaw and another CGI-related issue in
    apache_request_header (5.4 only).</p>

    <p>We apologize for the inconvenience created with these releases and the
    (lack of) communication around them.</p>
    </div>

    </div>
</div>
<div class="newsItem hentry">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-05-03-1" href="http://www.php.net/archive/2012.php#id2012-05-03-1" rel="bookmark" class="bookmark">PHP 5.3.12 and PHP 5.4.2 Released!</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-05-03T18:00:36+02:00">03-May-2012</abbr>
        <div>

     <p>There is a vulnerability in certain CGI-based setups <b>(Apache+mod_php and nginx+php-fpm are not affected)</b>
     that has gone unnoticed for at least 8 years. <a href="http://tools.ietf.org/html/draft-robinson-www-interface-00#section-7">Section
     7 of the CGI spec</a> states:</p>

     <cite>
        Some systems support a method for supplying a [sic] array of strings to the
        CGI script. This is only used in the case of an `indexed' query. This
        is identified by a "GET" or "HEAD" HTTP request with a URL search
        string not containing any unencoded "=" characters.
     </cite>

     <p>So, requests that do not have a "=" in the query string are treated
     differently from those who do in some CGI implementations. For PHP this
     means that a request containing ?-s may dump the PHP source code for the
     page, but a request that has ?-s&amp;=1 is fine.</p>

     <p>A large number of sites run PHP as either an Apache module through
     mod_php or using php-fpm under nginx. Neither of these setups are
     vulnerable to this. Straight shebang-style CGI also does not appear to
     be vulnerable.</p>

     <p>If you are using Apache mod_cgi to run PHP you may be vulnerable. To see
     if you are, just add ?-s to the end of any of your URLs. If you see your
     source code, you are vulnerable. If your site renders normally, you are not.</p>

     <p>To fix this, update to PHP 5.3.12 or PHP 5.4.2. </p>

     <p>We recognize that since CGI is a rather outdated way to run PHP, it may not be feasible to
     upgrade these sites to a modern version of PHP. An alternative is to
     configure your web server to not let these types of requests with query
     strings starting with a "-" and not containing a "=" through. Adding a
     rule like this should not break any sites. For Apache using mod_rewrite
     it would look like this:</p>

     <pre>
         RewriteCond %{QUERY_STRING} ^(%2d|-)[^=]+$ [NC]
         RewriteRule ^(.*) $1? [L]
     </pre>

     <p>If you are writing your own rule, be sure to take the urlencoded ?%2ds
     version into account.</p>

     <p>Making a bad week worse, we had a bug in our bug system that toggled the
     private flag of a bug report to public on a comment to the bug report
     causing this issue to go public before we had time to test solutions to
     the level we would like. Please report any issues via <a href="https://bugs.php.net/">bugs.php.net</a>.</p>

     <p>For source downloads of PHP 5.3.12 and PHP 5.4.2 please visit
     our <a href="/downloads.php">downloads page</a>, Windows binaries can be found
     on <a href="http://windows.php.net/download/">windows.php.net/download/</a>. A
     <a href="/ChangeLog-5.php#5.4.2">ChangeLog</a> exists.</p>


    </div>

    </div>
</div>
<div class="newsItem hentry vevent">
    <div class="newsImage"><a href="http://devconf.ru"><img src="/images/news/devconfru2012.png" alt="DevConf 2012" width="373" height="86" style="float: right;"></a></div>
    <h2 class="summary entry-title"><a id="id2012-04-27-1" href="http://devconf.ru" rel="bookmark" class="bookmark">DevConf 2012</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-04-27T05:20:52+00:00">27-Apr-2012</abbr>
        <div>
     <p>
      DevConf 2012 in Moscow, Russia on Jun 9 - Jun 10
     </p>
	 <p>
      DevConf is the ultimate meeting place for russian-speaking web-developers,
      combining several language-specific conferences under one roof.
     </p>
	 <p>
      This year DevConf will include the following sections:
     </p>
     <ul>
      <li>DevConf::PHP();</li>
      <li>DevConf::Perl();</li>
      <li>DevConf::RoR();</li>
      <li>DevConf::Python();</li>
      <li>DevConf::Javascript();</li>
     </ul>
     <p>
       Each section will feature several talks from the active contributors/authors of the language.
       Among the invited speakers are Derick Rethans (<a href="http://xdebug.org">XDebug</a> creator),
	   David Soria Parra (active PHP contributor), Andrey Aksyonov (author of <a href="http://sphinxsearch.com">Sphinx</a>),
	   Alexander Makarov (one of the main contributors to <a href="http://www.yiiframework.com">Yii</a>),
	   Sergey Petrunya (of <a href="http://mariadb.org">MariaDB</a> fame), Ilya Alekseev (<a href="http://openstack.org">OpenStack</a> Nova contributor)
	   and many others, see more details on <a href="http://devconf.ru">the official website</a>.
     </p>
    </div>

    </div>
</div>
<div class="newsItem hentry">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-04-26-1" href="http://www.php.net/archive/2012.php#id2012-04-26-1" rel="bookmark" class="bookmark">PHP 5.3.11 And PHP 5.4.1 Released!</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-04-26T10:50:38+00:00">26-Apr-2012</abbr>
        <div>
     <p>The PHP development team announces the immediate availability of PHP 5.3.11 and PHP 5.4.1. These releases focuses on improving the stability of the current PHP branches with over 60 bug fixes, some of which are security related.</p>

     <p>Security Enhancements for both PHP 5.3.11 and PHP 5.4.1:</p>

     <ul>
     <li>Fixed bug #54374 (Insufficient validating of upload name leading to corrupted $_FILES indices). (CVE-2012-1172).</li>
     <li>Add open_basedir checks to readline_write_history and readline_read_history.</li>
     </ul>

     <p>Security Enhancement affecting PHP 5.3.11 only:</p>

     <ul>
     <li>Fixed bug #61043 (Regression in magic_quotes_gpc fix for CVE-2012-0831).</li>
     </ul>

     <p>Key enhancements in these releases include:</p>

     <ul>
     <li>Added debug info handler to DOM objects.</li>
     <li>Fixed bug #61172 (Add Apache 2.4 support).</li>
     </ul>

     <p>For a full list of changes in PHP 5.3.11 and PHP 5.4.1, see the <a href="/ChangeLog-5.php">ChangeLog</a>. For source downloads please visit
     our <a href="/downloads.php">downloads page</a>, Windows binaries can be found
     on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.</p>

     <p>All users of PHP are strongly encouraged to upgrade to PHP 5.3.11 or PHP 5.4.1.</p>
    </div>

    </div>
</div>
<div class="newsItem hentry">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-04-13-1" href="http://www.php.net/archive/2012.php#id2012-04-13-1" rel="bookmark" class="bookmark">PHP 5.4.1RC2 Released for Testing</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-04-13T13:37:44+02:00">13-Apr-2012</abbr>
        <div>
      <p>
        The PHP development team would like to announce the 2nd
        <a href="http://qa.php.net">release candidate</a> of PHP 5.4.1.
         Windows binaries can be downloaded from the
        <a href="http://windows.php.net/qa/">Windows QA site</a>.
      </p>
      <p>
        <strong>
          THIS IS A RELEASE CANDIDATE - DO NOT USE IT IN PRODUCTION!
        </strong>
      </p>
      <p>
        This is the 2nd release candidate. The release candidate phase is
        intended as a period of bug fixing prior to the stable release.
        The release candidate fixes a critical issue when using the internal
        classes in multiple threads.
      </p>
      <p>
        A complete list of changes since the last release candidate can be
        found in the
        <a href="https://github.com/php/php-src/raw/fa1437b144683eae4d253473c35e375f7b743811/NEWS">NEWS</a>
        file.
      </p>
      <p>
        Please help us to identify
        bugs in order to ensure that the release is solid and all things behave
        as expected by taking the time to test this release candidate against
        your code base and reporting any problems that you encounter to
        the <a href="mailto:php-qa@lists.php.net">QA mailing list</a> and/or
        the <a href="https://bugs.php.net/">PHP bug tracker</a>.
      </p>
      <p>
        PHP 5.4.1 final will be released on April 26.
      </p>
    </div>

    </div>
</div>
<div class="newsItem hentry">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-03-20-1" href="http://www.php.net/archive/2012.php#id2012-03-20-1" rel="bookmark" class="bookmark">PHP migrates to Git</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-03-20T10:25:52+08:00">20-Mar-2012</abbr>
        <div>
    <p>
     The migration of the PHP source code from Subversion to Git is complete.
     You can clone or fork the source from our
     <a href="https://github.com/php/php-src">GitHub</a>, and we also
     now support pull requests made via GitHub, and full instructions
     on cloning the php-src tree can be found at
     <a href="http://php.net/git">php.net/git</a>.
    </p>

    <p>
     One immediate benefit is that future PHP release tags will be signed by
     the PHP development team. We will be releasing GPG keys for verification
     purposes in the next few days.
    </p>

    <p>
     More information on the migration and the new workflow can be found at the
     <a href="https://wiki.php.net/vcs/gitfaq">Moving to Git FAQ</a> on the PHP
     Wiki.
    </p>

    <p>
     Please note that the PHP manual, including translations, continues to be
     hosted in Subversion for the time being and will be migrated to Git at a
     later date.
    </p>

    <p>
     Many thanks to David Soria Parra for his hard work on making the conversion
     to Git a reality, and to Alexander Moskaliov, Florian Anderiasch and
     Johannes Schlüter for their work on the scripts required to support
     the conversion. Let the forking begin!
    </p>
   </div>

    </div>
</div>
<div class="newsItem hentry">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-03-01-1" href="http://www.php.net/archive/2012.php#id2012-03-01-1" rel="bookmark" class="bookmark">PHP 5.4.0 released!</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-03-01T19:40:35+01:00">01-Mar-2012</abbr>
        <div>
     <p>
      The PHP development team is proud to announce the immediate availability of PHP
      <a href="http://php.net/downloads.php#v5.4.0">5.4.0</a>.
      This release is a major leap forward in the 5.x series, which includes a
      large number of new features and bug fixes.
     </p>

     <p>
      Some of the key new features include:
      <a href="http://php.net/traits">traits</a>,
      <a href="http://docs.php.net/manual/en/language.types.array.php">a shortened array syntax</a>,
      <a href="http://php.net/manual/en/features.commandline.webserver.php">
      a built-in webserver for testing purposes</a>
      and more. PHP 5.4.0 significantly improves performance, memory footprint and fixes over
      100 bugs.
     </p>

     <p>
      For users upgrading from PHP 5.3 there is a
      <a href="http://php.net/migration54">migration guide</a>
      available here, detailing the changes between those
      releases and <a href="http://php.net/downloads.php#v5.4.0">PHP 5.4.0</a>.
     </p>

     <p>
      Further details about the
      <a href="http://php.net/downloads.php#v5.4.0">PHP 5.4.0</a> release
      can be found in the
      <a href="http://php.net/releases/5_4_0.php">release announcement</a>,
      and the full list of changes are available in the
      <a href="http://php.net/ChangeLog-5.php">ChangeLog</a>.
     </p>
     <p>
     Please note that it may take a while until the release is available
     on all mirrors.
     </p>
    </div>

    </div>
</div>
<div class="newsItem hentry">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-02-02-1" href="http://www.php.net/archive/2012.php#id2012-02-02-1" rel="bookmark" class="bookmark">PHP 5.3.10 Released!</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-02-02T20:32:47+01:00">02-Feb-2012</abbr>
        <div>
     <p>The PHP development team would like to announce the immediate
     availability of PHP 5.3.10. This release delivers a critical security
     fix.</p>

     <p>Security Fixes in PHP 5.3.10:</p>

     <ul>
       <li>Fixed arbitrary remote code execution vulnerability reported by Stefan
         Esser, CVE-2012-0830.</li>
     </ul>

     <p>All users are strongly encouraged to upgrade to PHP 5.3.10.</p>

     <p>For source downloads please visit
            our <a href="/downloads.php">downloads page</a>, Windows binaries can be found
            on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.</p>
    </div>

    </div>
</div>
<div class="newsItem hentry vevent">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-01-20-1" href="http://confoo.ca/" rel="bookmark" class="bookmark">ConFoo 2012</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-01-20T05:20:52+00:00">20-Jan-2012</abbr>
        <div>
     <p>
      ConFoo 2012 in Montreal, Canada on Feb 29 - Mar 02
     </p>
     <p>
      ConFoo is the unique web conference in Canada gathering different
      tech communities in one place.
     </p>
     <ul>
      <li>find working solutions for your day to day challenges;</li>
      <li>discover new tools that increase your productivity;</li>
      <li>network with people from some of the world’s biggest companies;</li>
      <li>160 presentations focusing on core competencies improvement;</li>
     </ul>
     <p>
      Don't miss this great opportunity and <a href="http://confoo.ca/en/register">register today</a>!
      Also check out our two <a href="http://confoo.ca/en/2012/training">training days</a>
      around PHP, HTML5, Symfony2 and security topics right before the
      conference.
     </p>
    </div>

    </div>
</div>
<div class="newsItem hentry">
    <div class="newsImage"></div>
    <h2 class="summary entry-title"><a id="id2012-01-10-1" href="http://www.php.net/archive/2012.php#id2012-01-11-1" rel="bookmark" class="bookmark">PHP 5.3.9 Released!</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-01-10T22:29:58+01:00">10-Jan-2012</abbr>
        <div>
     <p>The PHP development team would like to announce the immediate
     availability of PHP 5.3.9. This release focuses on improving the
     stability of the PHP 5.3.x branch with over 90 bug fixes, some of
     which are security related.</p>

     <p>Security Enhancements and Fixes in PHP 5.3.9:</p>

     <ul>
       <li>Added max_input_vars directive to prevent attacks based on hash collisions. (CVE-2011-4885)</li>
       <li>Fixed bug #60150 (Integer overflow during the parsing of invalid exif
         header). (CVE-2011-4566)</li>
     </ul>

     <p>Key enhancements in PHP 5.3.9 include:</p>

     <ul>
       <li>Fixed bug #55475 (is_a() triggers autoloader, new optional 3rd argument to
         is_a and is_subclass_of).</li>
       <li>Fixed bug #55609 (mysqlnd cannot be built shared)</li>
       <li>Many changes to the FPM SAPI module</li>
     </ul>

     <p>For a full list of changes in PHP 5.3.9, see the <a href="/ChangeLog-5.php#5.3.9">ChangeLog</a>. For source downloads please visit
       our <a href="/downloads.php">downloads page</a>, Windows binaries can be found
       on <a href="http://windows.php.net/download/">windows.php.net/download/</a>.</p>

     <p>All users are strongly encouraged to upgrade to PHP 5.3.9.</p>

    </div>

    </div>
</div>
<div class="newsItem hentry vevent">
    <div class="newsImage"><a href="http://conference.phpbenelux.eu/2012"><img src="/images/news/phpbnl2012.png" alt="PHPBenelux 2012" width="347" height="68" style="float: right;"></a></div>
    <h2 class="summary entry-title"><a id="id2012-01-07-1" href="http://conference.phpbenelux.eu/2012" rel="bookmark" class="bookmark">PHPBenelux 2012</a></h2>
    <div class="entry-content description">
        <abbr class="published newsdate" title="2012-01-07T14:47:25+01:00">07-Jan-2012</abbr>
        <div>
     <p>
     The PHPBenelux Conference is ready for its third edition and takes place
     January 27th &amp; 28th in Antwerp (Belgium).
     </p>
     <p>We're very proud to have a great
     lineup this year and some awesome social events. All information about the
     conference  can be found on our conference website
     <a href="http://conference.phpbenelux.eu/2012">http://conference.phpbenelux.eu/2012</a>.
     </p>
     <p>
     There are some tickets still available, get them at <a href="http://shop.phpbenelux.eu">http://shop.phpbenelux.eu</a>.
     </p>
    </div>

    </div>
</div>

<?php site_footer(['elephpants' => true, 'sidebar' => $SIDEBAR_DATA]);
