<?php
$_SERVER['BASE_PAGE'] = 'archive/2002.php';
include_once __DIR__ . '/../include/prepend.inc';
news_archive_sidebar();
site_header("News Archive - 2002", ["cache" => true]);
?>

<h1>News Archive - 2002</h1>

<p>
 Here are the most important news items we have published in 2002 on PHP.net.
</p>

<hr>

<h1>PHP Look Back 2002</h1>
<p>
 <span class="newsdate">[31-Dec-2002]</span>
 We are at the end of 2002, and it seemed appropriate to look back on the
 development issues of the past year. So starts the first PHP Look Back! You can
 find it in on the non-official personal website of one of the PHP Developers <a
 href="http://www.derickrethans.nl/20021230.php">here</a>.
</p>
<p>
 Happy New Year!
</p>

<hr>

<h1>PHP 4.3.0 Released!</h1>
<p>
 <span class="newsdate">[27-Dec-2002]</span>
 The PHP developers are pleased to announce the immediate availability of
 <a href="downloads.php">PHP 4.3.0</a>, the latest and greatest version of this
 extremely popular and widely used scripting language.
</p>

<p>
 This release contains a multitude of changes, bug fixes and improvements over
 the previous one, PHP 4.2.3. It further elevates PHP's standing as a serious
 contender in the general purpose scripting language arena. Please see
 the full <a href="release_4_3_0.php">release announcement</a>.
</p>

<hr>

<?php news_image("http://weblabor.hu/php-doc-chm", "chmhelp.gif", "CHM"); ?>

<h1>New Release of the PHP Manual CHM Edition - Please Help Us</h1>
<p>
 <span class="newsdate">[27-Dec-2002]</span>
 The 11th sample of the CHM edition is available for download from today. The
 sample hopefully fixed the missing page bugs forever, introduces a new
 integration method (see documentation inside) and contains actual manual
 text, mirrors list and user notes. <a href="http://weblabor.hu/php-doc-chm">See
 the edition's page for download</a>.
</p>

<p>
 We also would like to ask you to help out in testing our new on-the-fly
 syntax highlighter, which would make the CHM significantly smaller, and
 would give you more options in displaying the pages.
 <a href="http://weblabor.hu/php-doc-chm">See the edition's page for
 more information</a>.
</p>

<hr>

<?php news_image("http://www.mysql.com/events/uc2003/", "mysqluc2003.png", "MySQL Users Conference and Expo 2003"); ?>

<h1>MySQL Users Conference and Expo 2003 in San Jose</h1>
<p>
 <span class="newsdate">[16-Dec-2002]</span>
 MySQL AB is proud to host the world's First Annual MySQL User
 Conference, to be held in the heart of Silicon Valley, April 10-12,
 2003. This event promises to be the biggest gathering of MySQL database
 users ever in one location. Designed for both the MySQL developer and
 the corporate decision maker, this is the place to learn about the
 latest in MySQL technology, discover new business opportunities, take a
 pulse on industry direction and commune with like minds.
 More information on <a href="http://www.mysql.com/events/uc2003/">the
 event's website</a>.
</p>

<hr>

<h1>PHP news feed available</h1>
<p>
 <span class="newsdate">[01-Dec-2002]</span>
 The news of PHP.net is available now in RSS 1.0 format via our
 new news.rss file. You can
 add this file to any news reader or portal site to get the latest
 official PHP news. We strongly recommend you to cache the contents
 locally on your side, as the newsfeed is updated daily. The RSS
 file is available on every mirror site.
</p>

<hr>

<?php news_image("http://www.afup.org/", "afup-logo.gif", "AFUP"); ?>

<h1>Forum PHP 2002 in Paris, France</h1>
<p>
 <span class="newsdate">[21-Nov-2002]</span>
 The French PHP User Group AFUP invites you to the "Forum PHP 2002" in
 Paris, on December 9th and 10th. Designed to meet the needs of PHP aware
 companies and all the French PHP developper's community alike, this
 event will provided you with valuable and up-to-date information.
 For more information (in French) see the
 <a href="http://www.afup.org/article.php3?id_article=136">PHP Forum</a>
 website.
</p>

<hr>

<h1>PHP Magazine - International Edition</h1>
<p>
 <span class="newsdate">[17-Nov-2002]</span>
 Software &amp; Support Verlag GmbH is going to publish an International version
 of the <a href="http://www.phpmag.de/">PHP Magazin</a>. This magazine was
 initiated after growing interest for an English magazine after the German
 version has been around for a few months.
</p>
<p>
 PHP Magazine not only informs about the scripting language itself, but also about
 related technologies such as the Apache Web Server, database technologies, XML
 and other innovative internet technologies.  Different sections within the
 magazine are oriented towards the specific question areas with which a web
 developer is confronted in daily practice.
</p>
<p>
 The first issue will be published in December and the frequency of issues is
 two months. You will be able to subscribe on the <a
 href="http://www.php-mag.net/">website</a> which will open shortly.
</p>

<hr>

<h1>New Monthly PHP Magazine Launched</h1>
<p>
 <span class="newsdate">[15-Nov-2002]</span>
 php|architect, a new monthly magazine dedicated exclusively to PHP, has
 launched <a href="http://www.phparch.com/">its website</a>. php|a is published
 in PDF format and is available worldwide. It covers a variety of advanced
 topics ranging from day-to-day programming to the internals of PHP. A sample
 article on the creation of a web-based PDF converter is also
 available on the magazine website
</p>

<hr>

<h1>PHP Search Bars available for major browsers</h1>
<p>
 <span class="newsdate">[29-Oct-2002]</span>
 We added a new option to access our site's content quickly. In addition to
 <a href="/urlhowto.php">URL shortcuts</a>, keyboard shortcuts and
 browser specific magic you can now use our
 <a href="/sidebars.php">Search Bar</a> from the major browsers. Please help
 us to test this new service, and provide feedback via
 <a href="http://bugs.php.net/">the bug system</a> (categorize your bug
 as a PHP.net website bug please).
</p>

<hr>

<h1>PHP at the LinuxWorld Expo Oct. 29-31th in Frankfurt, Germany</h1>
<p>
 <span class="newsdate">[28-Oct-2002]</span>
 For the first time the Open Source projects comprising the popular LAMP
 platform (Linux, Apache, MySQL and PHP) will be present at the
 <a href="http://www.linuxworldexpo.de">LinuxWorld Expo</a>
 with its own booth.
</p>
<p>
 At the booth, which is organized by the <a href="http://www.php-ev.de">German
 PHP Association</a> and the <a href="http://www.phpug.de">PHP Usergroup
 Frankfurt</a>, fair visitors can experience and learn about Apache, MySQL, PHP
 and related projects.
</p>
<p>
 Visitors can take LAMP home, too, since there will be a CD with the necessary
 software available at the booth.
</p>

<hr>

<h1>New keyboard shortcuts</h1>
<p>
 <span class="newsdate">[17-Oct-2002]</span>
 We introduced new keyboard shortcuts on the site today to make our pages
 even more comfortable to use. You can hit Alt+S on Microsoft Windows
 or Ctrl+S on Macintosh now to go right to the search box and type your
 search keyword. A similar shortcut with the letter "L" is also introduced
 on the manual pages to access the lookup input field. Thanks to Tommy Ipsen
 for the suggestion. You can read more about keyboard shortcuts on web pages
 <a href="http://www.w3.org/TR/html401/interact/forms.html#access-keys">in
 the HTML standard</a>.
</p>

<hr>

<h1>PHP 4.2.3 Released</h1>
<p>
 <span class="newsdate">[06-Sept-2002]</span>
 <a href="downloads.php">PHP 4.2.3</a> has been released with a large number
 of bug fixes. It is a maintenance release, and is a recommended update for all
 users of PHP, and Windows users in particular. A complete list of changes can
 be found in the <a href="ChangeLog-4.php">ChangeLog</a>.
</p>

<hr>

<?php news_image("http://www.php-conference.de/2002/index_en.php", "phpconf2002.gif", "PHP Conference 2002"); ?>

<h1>International PHP Conference 2002 (Frankfurt, Nov 3-6)</h1>
<p>
 <span class="newsdate">[05-Sept-2002]</span>
 After the big success of last year's first International PHP Conference this
 year's show will be even bigger and better.
</p>
<p>
 <a href="http://www.php-conference.de/2002/index_en.php">Come to Frankfurt</a>
 and meet the most excellent speakers of the PHP community on four following days
 packed with <a href="http://www.php-conference.de/2002/pw_en.php">whole day
 tutorials</a> on November 3 and 4 and a great variety of sessions on November
 5 and 6.
</p>

<p>
 The topics are PHP Applications, PHP &amp; Business, Database Topics, PHP &amp; GTK,
 PHP Internals / Extensions, PHP &amp; XML, and others.
</p>

<p>
 <a href="https://www.entwickler.com/ssl/php2002/en/form_php2002.php">Early
 bird registration</a> will end on 7th of October. Students and private
 persons get special discounts.
</p>

<hr>

<?php news_image("http://www.php-con.com/", "phpcon2002.png", "PHPCon 2002"); ?>

<h1>PHPCon 2002 (California, Oct 24-25)</h1>
<p>
 <span class="newsdate">[05-Sept-2002]</span>
 <a href="http://www.php-con.com" title="PHPCon 2002">PHPCon 2002</a>, a
 2-day technical conference devoted entirely to PHP, announced today the
 launch of the PHPCon 2002 website, online registration, and a call for
 participation.
</p>

<p>
 <a href="http://www.php-con.com/2002/register.php">Early Bird
 registration</a> is now open for PHPCon 2002. Strong technical tracks on
 Enterprise PHP, Application Development, and XML combined with speakers
 from Rackspace, Yahoo!, Macromedia, and MySQL make this the conference a
 must attend for anyone interested in expanding their PHP knowledge.
</p>

<p>
 Join PHPCon in delivering the PHP message with Birds of a Feather (BoFs)
 and Works in Process (WiPs) sessions. Submit your BoF and WiP topics <a
 href="http://www.php-con.com/2002/bof_form.php" title=" BoF - WiP
 Submission ">online</a>.
</p>

<p>
 An idea who's time has come, don't miss this opportunity to attend the
 only conference in the US is placing PHP front and center as the language
 for solving web problems. PHPCon 2002, October 24 &amp; 25, 2002, Millbrae,
 California.
</p>

<hr>

<h1>Printer friendly manual pages with notes</h1>
<p>
 <span class="newsdate">[03-Aug-2002]</span>
 Starting from today, the manual pages are not only available in their
 printer friendly versions, but also in printer friendly versions with
 user notes included. Check the links at the <a href="/manual">top of
 the manual pages</a> to go to printer friendly manual pages, and
 change languages.
</p>

<hr>

<h1>ActiveState Awards</h1>
<p>
 <span class="newsdate">[31-Jul-2002]</span> ActiveState is pleased to announce
 the winners of the 2002 Active Awards, presented at the O'Reilly Open Source
 Conference in San Diego, CA. The Active Awards are held annually to honor
 members of the PHP, Python, Perl, Tcl, and XSLT  communities, who
 <em>actively</em> contribute to open languages and display excellence in
 their programming efforts. Activators' Choice Award winners were chosen by
 ActiveState's development team.  Programmers' Choice Award winners were
 nominated and chosen by the open source community, the nominees were:
 Greg Allan; Stig Bakken; Bogomil Shopov; Philippe Thomassigny; and
 Andrei Zmievski.
</p>
<p>
 The Activators' Choice winners are Derick Rethans and Jani Taskinen.
 Derick is heavily involved in developing processes for QA and Release
 Management, and Jani has been one of the largest contributors to QA and
 support of the Bug database.  The Programmers' Choice winner is Greg
 Allen, who was the lead developer and founding member of the PostNuke
 project. More details are available at
 <a href="http://www.ActiveState.com/ActiveAwards2002">http://www.ActiveState.com/ActiveAwards2002</a>
</p>

<hr>

<h1>PHP 4.2.2 released in response to vulnerability</h1>

<p>
 <span class="newsdate">[22-Jul-2002]</span> The PHP Group today announced
 the details of a serious <a href="release_4_2_2.php">vulnerability</a> in
 PHP versions 4.2.0 and 4.2.1. A security update, <a href="downloads.php">PHP
 4.2.2</a>, fixes the issue. Everyone running affected versions of PHP is
 encouraged to upgrade immediately. The new 4.2.2 release doesn't include
 other changes, so upgrading from 4.2.1 is safe and painless.
</p>

<hr>

<h1>New comp.lang.php newsgroup started</h1>

<p>
 <span class="newsdate">[09-Jul-2002]</span> comp.lang.php was created yesterday,
 after a two and a half month long process started in April by Ian Fette resulted in a
 <a href="http://groups.google.com/groups?q=comp.lang.php&amp;hl=en&amp;lr=&amp;ie=UTF-8&amp;selm=1025483879.39561&amp;40isc.org&amp;rnum=3">177-11
 vote</a> in favor of the group. The new group is already carried on most news servers,
 and should be carried on almost all news servers in the world within the next few days.
</p>

<p>
 The new group is important for a few reasons: Firstly, the old alt.* php
 groups suffered from poor propagation - i.e. not all servers carried them,
 and the community was split between multiple groups. This new group offers a
 chance to unite the PHP-Usenet community. Secondly, most servers have longer
 post-retention times for comp.* than alt.*. Finally, the creation of
 comp.lang.php represents PHP's coming to acceptance and maturity. Virtually
 all languages have a spot under the comp.lang.* hierarchy. Stop on by and
 become a part of the community - comp.lang.php is a great place to get help
 and to help others.
</p>

<hr>

<?php print_image("news/engine.gif", "Zend Engine 2", "right"); ?>

<h1>Alpha 2 of PHP w/ the Zend Engine 2 Now Available</h1>
<p>
 <span class="newsdate">[30-Jun-2002]</span>
 The second alpha release of PHP w/ Zend Engine 2 is <a href="/downloads.php">now
 available</a>. It is based on the current PHP 4 CVS (4.3.0-dev) and includes the new
 scripting engine which greatly improves the object model, adds exception
 handling and provides a much better infrastructure for the integration
 of external technologies like Java or .NET. For more details and
 examples you can check out the <a href="/zend-engine-2.php">file describing
 the changes</a>.
</p>

<p>
 <strong>Note:</strong> This is an alpha version. It should not be used in production
 or even semi-production web sites. There are known bugs in it, and in
 addition, some of the features may change (based on feedback). We
 encourage you to download and play with it (and report bugs if you find any!),
 but please don't expect it to replace your copy of PHP 4 at this stage.
</p>

<p>
 Windows binary version is also available.
</p>

<hr>

<h1>PHP for NetWare (Beta) Released</h1>
<p>
 <span class="newsdate">[27-May-2002]</span>
 A Beta version of PHP for NetWare is available on the
 <a href="http://developer.novell.com/ndk/leadedge.htm#le169">Novell
 Developer Kit site</a>. This version is based on the
 4.0.8 (development) version of the PHP source code.
</p>

<hr>

<?php news_image("http://www.linuxtag.org/2002/deutsch/showitem.php3?item=30&amp;lang=en", "linuxtag3.gif", "LinuxTag"); ?>

<h1>LinuxTag 2002: 6 - 9th June, Karlsruhe, Germany</h1>
<p>
 <span class="newsdate">[23-May-2002]</span> PHP will be attending
 <a href="http://www.linuxtag.org/2002/deutsch/showitem.php3?item=30&amp;lang=en">LinuxTag</a>
 again this year. The combined efforts of the PHP Verein, the Apache Software Foundation and
 MySQL AB,  will create a "(L)AMP" day, focusing on web development with  the 3 core
 technologies. During the day there will be many <a
 href="http://www.linuxtag.org/2002/deutsch/showitem.php3?item=293&amp;lang=en">interesting
 workshops</a>, which are free to enter. Make time to visit the (L)AMP booth also, which will
 be hosting several <a href="http://www.phpug.de/index_ka109.php">PHP related projects</a>
 (text in German).
</p>

<hr>

<h1>PHP Coding Contest</h1>
<p>
 <span class="newsdate">[16-May-2002]</span>
 CodeWalkers have started a new fortnightly PHP contest. Every two weeks, there
 is a new problem to solve, a new script to write. The winner will receive
 prizes provided by the sponsors, Zend Technologies and Sams Publishing.
 You can enter the challenge by visiting <a href="http://codewalkers.com/php-contest.php">their site</a>.
</p>

<hr>

<h1>PHP 4.2.1 released</h1>
<p>
 <span class="newsdate">[13-May-2002]</span>
 The PHP Group is happy to announce the <a href="/downloads.php">immediate
 availability</a> of PHP 4.2.1, the latest version of the widely-used,
 general-purpose scripting language that is especially well-suited for
 Web development.
</p>

<p>
 This latest release contains several bug fixes as found in PHP 4.2.0. These include
 fixes for the session, com and mbstring extensions, as well as a major upgrade of the DomXML
 extension. Also a few extra checks for safe_mode were added. For more information, see the
 <a href="/release_4_2_1.php">PHP 4.2.1 release announcement</a>.
</p>

<hr>

<?php news_image("http://www.php-award.net/", "phpaward_100.gif", "PHP Award"); ?>

<h1>PHP Award 2002</h1>
<p>
 <span class="newsdate">[27-Apr-2002]</span>
 The Association Fran?aise des Utilisateurs de PHP (AFUP) and
 the German PHP Association (PHP Verein) are organizing a PHP
 contest to give out the first PHP Award. The PHP Award will
 be given in three categories: Open Source, Freeware and
 Commercial Software, the submission deadline is July, 15th 2002.
 If you are interested go to
 <a href="http://www.php-award.net/">http://www.php-award.net/</a>.
</p>

<hr>

<h1>PHP.net: A Tourist's Guide</h1>
<p>
 <span class="newsdate">[26-Apr-2002]</span>
 Damien Seguy has written <a href="/sites.php">a tourist's guide</a> to the
 various sites that make up the PHP.net family of sites. Did you know you can
 browse a hyperlinked version of the PHP source code at <a
 href="http://lxr.php.net/">lxr.php.net</a>? View the archives of all of the
 mailing lists at <a href="http://news.php.net/">news.php.net</a>? See what else
 you've been missing.
</p>

<hr>

<h1>PHP 4.2.0 released</h1>
<p>
 <span class="newsdate">[22-Apr-2002]</span>
 The PHP Group is happy to announce the <a href="/downloads.php">immediate
 availability</a> of PHP 4.2.0, the latest version of the widely-used,
 general-purpose scripting language that is especially well-suited for Web development.
</p>

<p>
 This latest release contains over one hundred changes, bug fixes and improvements over
 the previous release, PHP 4.1.2. Among the highlights are experimental support for Apache 2,
 cleanups in variable handling and overhauls of various PHP components, including the
 domxml, posix, sockets and iconv extensions. For more information, see the
 <a href="/release_4_2_0.php">PHP 4.2.0 release announcement</a>.
</p>

<hr>

<?php news_image("http://weblabor.hu/php-doc-chm", "chmhelp.gif", "CHM"); ?>

<h1>Fifth sample of 'PHP Manual CHM Edition'</h1>

<p>
 <span class="newsdate">[20-Apr-2002]</span>
 We released the fifth sample of the new CHM Edition. New in
 this sample: user preferences application, a new optional
 design, custom context menu support, linked functions
 in examples, and of course updated content.
</p>

<p>
 <a href="http://weblabor.hu/php-doc-chm">Try out the new CHM Edition</a>,
 and send us your feedback to our
 <a href="mailto:php-doc-chm@lists.php.net">dedicated mailing list</a>.
</p>

<hr>

<?php news_image("http://www.phpmag.de/", "phpmag.gif", "PHP Magazin"); ?>

<h1>PHP Magazin out now!</h1>
<p>
 <span class="newsdate">[26-Mar-2002]</span>
 The Software &amp; Support Verlag, based in Frankfurt,
 Germany, has now published a magazine on PHP as a
 tribute to the steadily growing German PHP community.
 More information can be found at
 <a href="http://www.phpmag.de/">www.phpmag.de</a>.
</p>

<hr>

<h1>New PHP.net URL Howto</h1>
<p>
 <span class="newsdate">[23-Mar-2002]</span>
 Ever wondered what you can type in your browsers location
 field to access a php.net page? Many of you already know
 <a href="http://php.net/echo">http://php.net/echo</a>.
 We gathered some information about how the URLs are parsed,
 and what are your possibilities. Read it in our new
 <a href="urlhowto.php">URL Howto</a>.
</p>

<hr>

<?php news_image("http://www.php-ev.de/documents/phpdoc/protocol.html", "brain.gif", "PHPDoc Brain"); ?>

<h1>PHP Documentation Team Meeting</h1>
<p>
 <span class="newsdate">[13-Mar-2002]</span>
 The <a href="http://www.php-ev.de/documents/phpdoc/protocol.html">notes
 from the PHP Documentation Team Meeting</a> (Stuttgart, March
 8th-10th) are now available.
</p>

<hr>

<h1>PHP Security Update - Windows Version</h1>
<p>
 <span class="newsdate">[12-Mar-2002]</span>
 Following up from the previous annoucement, PHP 4.1.2 has been released for
 windows. The delayed release is due to the fix of a further security issue only
 relating to the PHP for Windows version. More information on this change can be
 found <a href="/release_4_1_2_win32.php">here</a>. All PHP - Windows users are
 encouraged to upgrade to the <a href="/downloads.php">latest version</a>.
</p>

<hr>

<h1>PHP Security Update</h1>
<p>
 <span class="newsdate">[27-Feb-2002]</span>
 Due to a security issue found in all versions of PHP (including 3.x and 4.x), a
 new version of PHP has been released.  Details about the security issue are <a
 href="http://security.e-matters.de/advisories/012002.html">available here</a>.
 All users of PHP are strongly encouraged to either upgrade to <a
 href="/downloads.php">PHP 4.1.2</a>, or install the patch (<a
 href="/downloads.php">available for PHP 3.0.18, 4.0.6 and 4.1.0/4.1.1)</a>.
</p>

<hr>

<h1>PHP-GTK 0.5.0 released</h1>

<p>
 <span class="newsdate">[24-Jan-2002]</span>
 <a href="http://gtk.php.net/">PHP-GTK</a> has reached version
 0.5.0, also known as <em>"monday starts on saturday"</em>. The version number
 was bumped from 0.1.1 to this one to indicate that PHP-GTK is now a fairly
 mature and stable extension and can be used for a variety of applications
 (just look on <a href="http://www.freshmeat.net/">Freshmeat</a>).
</p>

<p>
 Also taking this opportunity, we would like to ask if some of you would
 consider helping out with PHP-GTK documentation. It would be a great way to
 learn this exciting extension and also contribute to the project.
</p>

<hr>

<?php news_image("http://www.phpconference.de/2001/index_en.php", "international_conference.gif", "International PHP Conference 2001"); ?>

<h1>International PHP Conference slides available</h1>

<p>
 <span class="newsdate">[10-Jan-2002]</span>
 You can find an overview of all slides of the sessions from the
 International PHP Conference 2001 on the
 <a href="http://www.phpconference.de/2001/slides_en.php">conference slides page</a>.
 It is still not too late to check out some photos from the conference:
</p>

<ul>
 <li><a href="http://www.photoalbum.nohn.net/PHPConference2001">Sebastian Nohn</a></li>
 <li><a href="http://www.bttr.org/phpconf/">Ralf Geschke</a></li>
 <li><a href="http://www.phpconference.de/2001/images/PHP_Konferenz/">Conference photos</a></li>
</ul>

<?php site_footer(['elephpants' => true, 'sidebar' => $SIDEBAR_DATA]);
