# Generated by Django 3.0.3 on 2020-04-30 14:18

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Camera',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(blank=True, db_index=True)),
                ('updated_at', models.DateTimeField(blank=True)),
                ('make', models.CharField(max_length=128)),
                ('model', models.CharField(max_length=128)),
                ('earliest_photo', models.DateTimeField()),
                ('latest_photo', models.DateTimeField()),
            ],
            options={
                'ordering': ['make', 'model'],
            },
        ),
        migrations.CreateModel(
            name='Lens',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(blank=True, db_index=True)),
                ('updated_at', models.DateTimeField(blank=True)),
                ('name', models.CharField(max_length=128)),
                ('earliest_photo', models.DateTimeField()),
                ('latest_photo', models.DateTimeField()),
            ],
            options={
                'verbose_name_plural': 'lenses',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Library',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(blank=True, db_index=True)),
                ('updated_at', models.DateTimeField(blank=True)),
                ('name', models.CharField(help_text='Display name of the library', max_length=128)),
                ('classification_color_enabled', models.BooleanField(default=False, help_text='Run color analysis on photos?')),
                ('classification_location_enabled', models.BooleanField(default=False, help_text='Run location detection on photos?')),
                ('classification_style_enabled', models.BooleanField(default=False, help_text='Run style classification on photos?')),
                ('classification_object_enabled', models.BooleanField(default=False, help_text='Run object detection on photos?')),
                ('setup_stage_completed', models.CharField(blank=True, choices=[('St', 'Storage backend configured'), ('Im', 'Photo importing configured'), ('Th', 'Thumbnailing storage configured')], help_text='Where the user got to during onboarding setup', max_length=2, null=True)),
            ],
            options={
                'verbose_name_plural': 'Libraries',
            },
        ),
        migrations.CreateModel(
            name='Photo',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(blank=True, db_index=True)),
                ('updated_at', models.DateTimeField(blank=True)),
                ('visible', models.BooleanField(default=False)),
                ('taken_at', models.DateTimeField(null=True)),
                ('taken_by', models.CharField(blank=True, max_length=128, null=True)),
                ('aperture', models.DecimalField(decimal_places=1, max_digits=3, null=True)),
                ('exposure', models.CharField(blank=True, max_length=8, null=True)),
                ('iso_speed', models.PositiveIntegerField(null=True)),
                ('focal_length', models.DecimalField(decimal_places=1, max_digits=4, null=True)),
                ('flash', models.NullBooleanField()),
                ('metering_mode', models.CharField(max_length=32, null=True)),
                ('drive_mode', models.CharField(max_length=32, null=True)),
                ('shooting_mode', models.CharField(max_length=32, null=True)),
                ('latitude', models.DecimalField(decimal_places=6, max_digits=9, null=True)),
                ('longitude', models.DecimalField(decimal_places=6, max_digits=9, null=True)),
                ('altitude', models.DecimalField(decimal_places=1, max_digits=6, null=True)),
                ('camera', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='photos', to='photos.Camera')),
                ('lens', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='photos', to='photos.Lens')),
                ('library', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='photos', to='photos.Library')),
            ],
            options={
                'ordering': ['-taken_at'],
            },
        ),
        migrations.CreateModel(
            name='Task',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(blank=True, db_index=True)),
                ('updated_at', models.DateTimeField(blank=True)),
                ('type', models.CharField(db_index=True, max_length=128)),
                ('subject_id', models.UUIDField(db_index=True)),
                ('status', models.CharField(choices=[('L', 'Location'), ('O', 'Object'), ('F', 'Face'), ('C', 'Color'), ('S', 'Style')], db_index=True, default='P', max_length=1)),
                ('started_at', models.DateTimeField(null=True)),
                ('finished_at', models.DateTimeField(null=True)),
                ('complete_with_children', models.BooleanField(default=False)),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='photos.Task')),
            ],
            options={
                'ordering': ['created_at'],
            },
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(blank=True, db_index=True)),
                ('updated_at', models.DateTimeField(blank=True)),
                ('name', models.CharField(max_length=128)),
                ('type', models.CharField(choices=[('L', 'Location'), ('O', 'Object'), ('F', 'Face'), ('C', 'Color'), ('S', 'Style')], max_length=1, null=True)),
                ('source', models.CharField(choices=[('H', 'Human'), ('C', 'Computer')], max_length=1)),
                ('library', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tags', to='photos.Library')),
                ('parent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='+', to='photos.Tag')),
            ],
            options={
                'ordering': ['name'],
                'unique_together': {('library', 'name', 'type', 'source')},
            },
        ),
        migrations.CreateModel(
            name='PhotoTag',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(blank=True, db_index=True)),
                ('updated_at', models.DateTimeField(blank=True)),
                ('source', models.CharField(choices=[('H', 'Human'), ('C', 'Computer')], max_length=1)),
                ('model_version', models.PositiveIntegerField(null=True)),
                ('confidence', models.FloatField()),
                ('significance', models.FloatField(null=True)),
                ('verified', models.BooleanField(default=False)),
                ('hidden', models.BooleanField(default=False)),
                ('position_x', models.FloatField(null=True)),
                ('position_y', models.FloatField(null=True)),
                ('size_x', models.FloatField(null=True)),
                ('size_y', models.FloatField(null=True)),
                ('photo', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='photo_tags', to='photos.Photo')),
                ('tag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='photo_tags', to='photos.Tag')),
            ],
            options={
                'ordering': ['-significance'],
            },
        ),
        migrations.CreateModel(
            name='PhotoFile',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(blank=True, db_index=True)),
                ('updated_at', models.DateTimeField(blank=True)),
                ('path', models.CharField(max_length=512)),
                ('width', models.PositiveIntegerField(null=True)),
                ('height', models.PositiveIntegerField(null=True)),
                ('mimetype', models.CharField(blank=True, max_length=32, null=True)),
                ('file_modified_at', models.DateTimeField()),
                ('bytes', models.PositiveIntegerField()),
                ('preferred', models.BooleanField(default=False)),
                ('raw_processed', models.BooleanField(default=False)),
                ('raw_version', models.PositiveIntegerField(null=True)),
                ('raw_external_params', models.CharField(blank=True, max_length=16, null=True)),
                ('raw_external_version', models.CharField(blank=True, max_length=16, null=True)),
                ('photo', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='files', to='photos.Photo')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LibraryPath',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(blank=True, db_index=True)),
                ('updated_at', models.DateTimeField(blank=True)),
                ('type', models.CharField(choices=[('St', 'Store'), ('Im', 'Import only'), ('Th', 'Thumbnails')], help_text='What type of path this is', max_length=2)),
                ('backend_type', models.CharField(choices=[('Lo', 'Local filesystem'), ('S3', 'S3-compatible block storage')], help_text='What type of storage to use for imported photos', max_length=2)),
                ('path', models.CharField(help_text='Path for storing photos - local path or bucket name', max_length=128)),
                ('url', models.CharField(blank=True, help_text='If a public-facing URL is available to access block storage, client will use this to download photos', max_length=128, null=True)),
                ('delete_after_import', models.BooleanField(default=False, help_text='Remove the photo from import_path after import succeeded?')),
                ('watch_for_changes', models.BooleanField(default=False, help_text='Watch import_path for local filesystem changes?')),
                ('s3_access_key_id', models.CharField(blank=True, help_text='AWS S3 (or compatible) access key ID', max_length=20, null=True)),
                ('s3_secret_key', models.CharField(blank=True, help_text='AWS S3 (or compatible) secret key', max_length=40, null=True)),
                ('library', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='paths', to='photos.Library')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='lens',
            name='library',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='lenses', to='photos.Library'),
        ),
        migrations.AddField(
            model_name='camera',
            name='library',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='cameras', to='photos.Library'),
        ),
        migrations.CreateModel(
            name='LibraryUser',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(blank=True, db_index=True)),
                ('updated_at', models.DateTimeField(blank=True)),
                ('owner', models.BooleanField(default=False, help_text="This User is responsible for this Library's settings and maintenance")),
                ('library', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='users', to='photos.Library')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='libraries', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('library', 'user')},
            },
        ),
        migrations.AlterUniqueTogether(
            name='camera',
            unique_together={('library', 'make', 'model')},
        ),
    ]
