(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    353381,       7174]
NotebookOptionsPosition[    352795,       7150]
NotebookOutlinePosition[    353154,       7166]
CellTagsIndexPosition[    353111,       7163]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Basic analysis of dumps captured from Android battery",
  FontFamily->"Lucida Bright",
  FontSize->24,
  FontSlant->"Italic"],
 StyleBox["  ",
  FontSize->24],
 StyleBox["\[CloseCurlyDoubleQuote]uevent\[CloseCurlyDoubleQuote]",
  FontFamily->"Menlo",
  FontSize->24],
 StyleBox[" ",
  FontSize->24],
 StyleBox["fuel gauge interface",
  FontFamily->"Lucida Bright",
  FontSize->24,
  FontSlant->"Italic"],
 StyleBox["\n",
  FontSize->24],
 "\nPhillip Stanley-Marbell\nphillip.stanleymarbell@gmail.com / psm@mit.edu\n\
\nMarch 2016"
}], "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.663676786476686*^9, 3.66367689119592*^9}, {
  3.663676930964283*^9, 3.663676937421064*^9}, {3.663677011737933*^9, 
  3.663677029624679*^9}, {3.6683648069682407`*^9, 3.668364835831252*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"analyze", "[", 
     RowBox[{"deviceFamily_", ",", " ", "fileName_", ",", " ", "dateRange_"}],
      "]"}], " ", ":=", " ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "grepCurrentBeforeCount", ",", "grepVoltageBeforeCount", ",", " ", 
        "currentGroupSize", ",", " ", "voltageGroupSize", ",", "currentIndex",
         ",", "voltageIndex", ",", "\[IndentingNewLine]", "rawCurrents", ",", 
        "rawVoltages", ",", "rawCurrentsGrouped", ",", "rawVoltagesGrouped", 
        ",", "datesAndCurrentsMicroamps", ",", 
        "datesAndDischargeCurrentsMicroamps", ",", 
        "datesAndDischargeCurrentsAbsoluteMicroamps", ",", 
        "datesAndVoltageMicrovolts", ",", " ", "datesAndPowerMilliwatts", ",",
         " ", "averagePowerMilliwatts", ",", 
        "datesAndDischargeCurrentsAbsoluteMicroampsSubset", ",", 
        "datesAndVoltageMicrovoltsSubset", ",", "minPowerMilliwatts"}], "}"}],
       ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"grepCurrentBeforeCount", " ", "=", " ", 
        RowBox[{"Switch", "[", 
         RowBox[{
         "deviceFamily", ",", "\[IndentingNewLine]", "\"\<nexus6p\>\"", ",", 
          "15", ",", "\[IndentingNewLine]", "\"\<max17047_battery\>\"", ",", 
          " ", "11", ",", "\[IndentingNewLine]", "_", ",", "11"}], "]"}]}], 
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"grepVoltageBeforeCount", " ", "=", " ", 
        RowBox[{"Switch", "[", 
         RowBox[{
         "deviceFamily", " ", ",", "\[IndentingNewLine]", " ", 
          "\"\<nexus6p\>\"", ",", "17", ",", "\[IndentingNewLine]", 
          "\"\<max17047_battery\>\"", ",", "6", ",", "\[IndentingNewLine]", 
          "\t", "_", ",", "9"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"currentGroupSize", " ", "=", " ", 
        RowBox[{"grepCurrentBeforeCount", "+", "2"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"voltageGroupSize", " ", "=", 
        RowBox[{"grepVoltageBeforeCount", " ", "+", " ", "2"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"currentIndex", " ", "=", " ", 
        RowBox[{"Switch", "[", 
         RowBox[{
         "deviceFamily", " ", ",", "\[IndentingNewLine]", "\"\<nexus6p\>\"", 
          ",", "16", ",", "\[IndentingNewLine]", "\"\<max17047_battery\>\"", 
          ",", "12", ",", "\[IndentingNewLine]", "\t", "_", ",", "12"}], 
         "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"voltageIndex", " ", "=", " ", 
        RowBox[{"Switch", "[", 
         RowBox[{
         "deviceFamily", " ", ",", "\[IndentingNewLine]", " ", 
          "\"\<nexus6p\>\"", ",", "18", ",", "\[IndentingNewLine]", 
          "\"\<max17047_battery\>\"", ",", "7", ",", "\[IndentingNewLine]", 
          "_", ",", "10"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"rawCurrents", " ", "=", 
        RowBox[{"Import", "[", 
         RowBox[{
          RowBox[{"\"\<!grep -B \>\"", "<>", 
           RowBox[{"ToString", "[", "grepCurrentBeforeCount", "]"}], "<>", 
           "\"\< 'POWER_SUPPLY_CURRENT_NOW' \>\"", "<>", "fileName"}], ",", 
          " ", "\"\<List\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{"\"\<rawCurrents: \>\"", ",", " ", "rawCurrents"}], "]"}], 
         ";"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"rawCurrentsGrouped", " ", "=", " ", 
        RowBox[{"Partition", "[", 
         RowBox[{"rawCurrents", ",", " ", "currentGroupSize"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<rawCurrentsGrouped: \>\"", ",", " ", "rawCurrentsGrouped"}], 
          "]"}], ";"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
       
       RowBox[{"datesAndCurrentsMicroamps", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"DateObject", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", " ", 
            RowBox[{"ToExpression", "[", 
             RowBox[{
              RowBox[{"StringSplit", "[", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "currentIndex", "]"}], "]"}], ",", " ", 
                "\"\<=\>\""}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}], "&"}], "/@", 
         "rawCurrentsGrouped"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"datesAndDischargeCurrentsMicroamps", " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
            RowBox[{"Abs", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}], "&"}], "/@", 
         "datesAndCurrentsMicroamps"}]}], ";", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Select", "[", 
          RowBox[{"datesAndCurrentsMicroamps", ",", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "\[LessEqual]", " ", "0"}], 
            "&"}]}], "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"datesAndDischargeCurrentsAbsoluteMicroamps", " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
            FractionBox[
             RowBox[{"Abs", "[", 
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], 
             SuperscriptBox["10", "3"]]}], "}"}], "&"}], "/@", " ", 
         "datesAndDischargeCurrentsMicroamps"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<datesAndDischargeCurrentsAbsoluteMicroamps: \>\"", ",", " ", 
           "datesAndDischargeCurrentsAbsoluteMicroamps"}], "]"}], ";"}], 
        "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
       "datesAndDischargeCurrentsAbsoluteMicroampsSubset", " ", "=", " ", 
        RowBox[{"Select", "[", 
         RowBox[{"datesAndDischargeCurrentsAbsoluteMicroamps", ",", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"DateDifference", "[", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                RowBox[{"dateRange", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", " ", "\"\<Second\>\""}],
                "]"}], "<", " ", 
              RowBox[{"Quantity", "[", 
               RowBox[{"0", ",", " ", "\"\<Second\>\""}], "]"}]}], " ", "&&", 
             " ", 
             RowBox[{
              RowBox[{"DateDifference", "[", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                RowBox[{"dateRange", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], ",", " ", "\"\<Second\>\""}],
                "]"}], ">", " ", 
              RowBox[{"Quantity", "[", 
               RowBox[{"0", ",", " ", "\"\<Second\>\""}], "]"}]}]}], ")"}], 
           "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<datesAndDischargeCurrentsAbsoluteMicroampsSubset: \>\"", ",", 
           " ", "datesAndDischargeCurrentsAbsoluteMicroampsSubset"}], "]"}], 
         ";"}], "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"rawVoltages", " ", "=", 
        RowBox[{"Import", "[", 
         RowBox[{
          RowBox[{"\"\<!grep -B \>\"", "<>", 
           RowBox[{"ToString", "[", "grepVoltageBeforeCount", "]"}], "<>", 
           "\"\< 'POWER_SUPPLY_VOLTAGE_NOW' \>\"", "<>", "fileName"}], ",", 
          " ", "\"\<List\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"rawVoltagesGrouped", " ", "=", " ", 
        RowBox[{"Partition", "[", 
         RowBox[{"rawVoltages", ",", " ", "voltageGroupSize"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"datesAndVoltageMicrovolts", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"DateObject", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", " ", 
            FractionBox[
             RowBox[{"ToExpression", "[", 
              RowBox[{
               RowBox[{"StringSplit", "[", 
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "voltageIndex", "]"}], "]"}], ",", " ", 
                 "\"\<=\>\""}], "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], 
             SuperscriptBox["10", "6"]]}], "}"}], "&"}], "/@", 
         "rawVoltagesGrouped"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"datesAndVoltageMicrovoltsSubset", " ", "=", " ", 
        RowBox[{"Select", "[", 
         RowBox[{"datesAndVoltageMicrovolts", ",", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"DateDifference", "[", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                RowBox[{"dateRange", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", " ", "\"\<Second\>\""}],
                "]"}], "<", " ", 
              RowBox[{"Quantity", "[", 
               RowBox[{"0", ",", " ", "\"\<Second\>\""}], "]"}]}], " ", "&&", 
             " ", 
             RowBox[{
              RowBox[{"DateDifference", "[", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                RowBox[{"dateRange", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], ",", " ", "\"\<Second\>\""}],
                "]"}], ">", " ", 
              RowBox[{"Quantity", "[", 
               RowBox[{"0", ",", " ", "\"\<Second\>\""}], "]"}]}]}], ")"}], 
           "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<datesAndVoltageMicrovoltsSubset: \>\"", ",", " ", 
           "datesAndVoltageMicrovoltsSubset"}], "]"}], ";"}], "*)"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"datesAndPowerMilliwatts", " ", "=", " ", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
             "datesAndDischargeCurrentsAbsoluteMicroampsSubset", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
            RowBox[{
             RowBox[{
              RowBox[{"datesAndDischargeCurrentsAbsoluteMicroampsSubset", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], "*", 
             RowBox[{
              RowBox[{"datesAndVoltageMicrovoltsSubset", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"i", ",", " ", "1", ",", " ", 
            RowBox[{
            "Length", "[", "datesAndDischargeCurrentsAbsoluteMicroampsSubset",
              "]"}]}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"averagePowerMilliwatts", " ", "=", " ", 
        RowBox[{"NumberForm", "[", 
         RowBox[{
          RowBox[{"N", "[", 
           RowBox[{"Mean", "[", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                "datesAndDischargeCurrentsAbsoluteMicroampsSubset", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}], "*", 
               RowBox[{
                RowBox[{"datesAndVoltageMicrovoltsSubset", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"i", ",", " ", "1", ",", " ", 
                RowBox[{
                "Length", "[", 
                 "datesAndDischargeCurrentsAbsoluteMicroampsSubset", "]"}]}], 
               "}"}]}], "]"}], "]"}], "]"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"3", ",", "2"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"minPowerMilliwatts", " ", "=", " ", 
        RowBox[{"NumberForm", "[", 
         RowBox[{
          RowBox[{"N", "[", 
           RowBox[{"Min", "[", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                "datesAndDischargeCurrentsAbsoluteMicroampsSubset", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}], "*", 
               RowBox[{
                RowBox[{"datesAndVoltageMicrovoltsSubset", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"i", ",", " ", "1", ",", " ", 
                RowBox[{
                "Length", "[", 
                 "datesAndDischargeCurrentsAbsoluteMicroampsSubset", "]"}]}], 
               "}"}]}], "]"}], "]"}], "]"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"3", ",", "2"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Column", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"DateListPlot", "[", 
             RowBox[{
             "datesAndDischargeCurrentsAbsoluteMicroampsSubset", ",", 
              "\[IndentingNewLine]", 
              RowBox[{"AspectRatio", "\[Rule]", 
               RowBox[{"1", "/", "3"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"PlotRange", "\[Rule]", " ", 
               RowBox[{"{", 
                RowBox[{"dateRange", ",", " ", "Automatic"}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"PlotTheme", "\[Rule]", "\"\<Detailed\>\""}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"ImageSize", "\[Rule]", "800"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Frame", "\[Rule]", "True"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"InterpolationOrder", "\[Rule]", "0"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"GridLines", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"Automatic", ",", "None"}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"PlotStyle", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"FontSize", "\[Rule]", " ", "18"}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"FrameLabel", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                "\"\<Time\>\"", ",", " ", 
                 "\"\<Sampled Battery Current (mA)\>\""}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"FrameStyle", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    "Gray", ",", " ", 
                    RowBox[{"Thickness", "[", "0.001", "]"}]}], "]"}], ",", 
                   " ", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    "LightGray"}], "]"}]}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    "Black", ",", " ", "Thick"}], "]"}], ",", " ", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    RowBox[{"GrayLevel", "[", "0.45", "]"}], ",", " ", 
                    RowBox[{"Thickness", "[", "0.0035", "]"}]}], "]"}]}], 
                  "}"}]}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"DateListLogPlot", "[", 
             RowBox[{
             "datesAndDischargeCurrentsAbsoluteMicroampsSubset", ",", 
              "\[IndentingNewLine]", 
              RowBox[{"AspectRatio", "\[Rule]", 
               RowBox[{"1", "/", "3"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"PlotTheme", "\[Rule]", "\"\<Detailed\>\""}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"PlotRange", "\[Rule]", " ", 
               RowBox[{"{", 
                RowBox[{"dateRange", ",", " ", "Automatic"}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"ImageSize", "\[Rule]", "800"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Frame", "\[Rule]", "True"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"InterpolationOrder", "\[Rule]", "0"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"GridLines", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"Automatic", ",", "None"}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"PlotStyle", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"FontSize", "\[Rule]", " ", "18"}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"FrameLabel", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                "\"\<Time\>\"", ",", " ", 
                 "\"\<Sampled Battery Current (mA)\>\""}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"FrameStyle", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    "Gray", ",", " ", 
                    RowBox[{"Thickness", "[", "0.001", "]"}]}], "]"}], ",", 
                   " ", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    "LightGray"}], "]"}]}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    "Black", ",", " ", "Thick"}], "]"}], ",", " ", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    RowBox[{"GrayLevel", "[", "0.45", "]"}], ",", " ", 
                    RowBox[{"Thickness", "[", "0.0035", "]"}]}], "]"}]}], 
                  "}"}]}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"DateListPlot", "[", 
             RowBox[{
             "datesAndVoltageMicrovoltsSubset", ",", "\[IndentingNewLine]", 
              RowBox[{"AspectRatio", "\[Rule]", 
               RowBox[{"1", "/", "3"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"PlotRange", "\[Rule]", " ", 
               RowBox[{"{", 
                RowBox[{"dateRange", ",", " ", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", " ", "4.6"}], "}"}]}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"PlotTheme", "\[Rule]", "\"\<Detailed\>\""}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"ImageSize", "\[Rule]", "800"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Frame", "\[Rule]", "True"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"InterpolationOrder", "\[Rule]", "0"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"GridLines", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"Automatic", ",", "None"}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"PlotStyle", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"FontSize", "\[Rule]", " ", "18"}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"FrameLabel", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                "\"\<Time\>\"", ",", " ", 
                 "\"\<Sampled Battery Voltage (Volts)\>\""}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"FrameStyle", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    "Gray", ",", " ", 
                    RowBox[{"Thickness", "[", "0.001", "]"}]}], "]"}], ",", 
                   " ", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    "LightGray"}], "]"}]}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    "Black", ",", " ", "Thick"}], "]"}], ",", " ", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    RowBox[{"GrayLevel", "[", "0.45", "]"}], ",", " ", 
                    RowBox[{"Thickness", "[", "0.0035", "]"}]}], "]"}]}], 
                  "}"}]}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"DateListLogPlot", "[", 
             RowBox[{
             "datesAndVoltageMicrovoltsSubset", ",", "\[IndentingNewLine]", 
              RowBox[{"AspectRatio", "\[Rule]", 
               RowBox[{"1", "/", "3"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"PlotRange", "\[Rule]", " ", 
               RowBox[{"{", 
                RowBox[{"dateRange", ",", " ", 
                 RowBox[{"{", 
                  RowBox[{"0.1", ",", " ", "10"}], "}"}]}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"PlotTheme", "\[Rule]", "\"\<Detailed\>\""}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"ImageSize", "\[Rule]", "800"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Frame", "\[Rule]", "True"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"InterpolationOrder", "\[Rule]", "0"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"GridLines", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"Automatic", ",", "None"}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"PlotStyle", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"FontSize", "\[Rule]", " ", "18"}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"FrameLabel", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                "\"\<Time\>\"", ",", " ", 
                 "\"\<Sampled Battery Voltage (Volts)\>\""}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"FrameStyle", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    "Gray", ",", " ", 
                    RowBox[{"Thickness", "[", "0.001", "]"}]}], "]"}], ",", 
                   " ", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    "LightGray"}], "]"}]}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    "Black", ",", " ", "Thick"}], "]"}], ",", " ", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    RowBox[{"GrayLevel", "[", "0.45", "]"}], ",", " ", 
                    RowBox[{"Thickness", "[", "0.0035", "]"}]}], "]"}]}], 
                  "}"}]}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"DateListPlot", "[", 
             RowBox[{"datesAndPowerMilliwatts", ",", "\[IndentingNewLine]", 
              RowBox[{"AspectRatio", "\[Rule]", 
               RowBox[{"1", "/", "3"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"PlotTheme", "\[Rule]", "\"\<Detailed\>\""}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"PlotRange", "\[Rule]", " ", 
               RowBox[{"{", 
                RowBox[{"dateRange", ",", " ", "Automatic"}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"ImageSize", "\[Rule]", "800"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Frame", "\[Rule]", "True"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"InterpolationOrder", "\[Rule]", "0"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"GridLines", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"Automatic", ",", "None"}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"PlotStyle", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"FontSize", "\[Rule]", " ", "18"}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"FrameLabel", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                "\"\<Time\>\"", ",", " ", "\"\<Power Drain (mW)\>\""}], 
                "}"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"FrameStyle", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    "Gray", ",", " ", 
                    RowBox[{"Thickness", "[", "0.001", "]"}]}], "]"}], ",", 
                   " ", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    "LightGray"}], "]"}]}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    "Black", ",", " ", "Thick"}], "]"}], ",", " ", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    RowBox[{"GrayLevel", "[", "0.45", "]"}], ",", " ", 
                    RowBox[{"Thickness", "[", "0.0035", "]"}]}], "]"}]}], 
                  "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"Epilog", "\[Rule]", " ", 
               RowBox[{"Inset", "[", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{
                   RowBox[{"\"\<Average power drain = \>\"", "<>", 
                    RowBox[{"ToString", "[", "averagePowerMilliwatts", "]"}], 
                    "<>", "\"\< mW, \>\"", "<>", "\"\<Min power drain = \>\"",
                     "<>", 
                    RowBox[{"ToString", "[", "minPowerMilliwatts", "]"}], 
                    "<>", "\"\< mW,\\n\>\""}], ",", 
                   RowBox[{
                   "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                   ",", 
                   RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                   RowBox[{"Background", "\[Rule]", " ", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"LightBlue", ",", " ", 
                    RowBox[{"Opacity", "[", "0.5", "]"}]}], "]"}]}]}], "]"}], 
                 ",", " ", 
                 RowBox[{"Scaled", "[", 
                  RowBox[{"{", 
                   RowBox[{"0.5", ",", " ", "0.90"}], "}"}], "]"}]}], 
                "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"DateListLogPlot", "[", 
             RowBox[{"datesAndPowerMilliwatts", ",", "\[IndentingNewLine]", 
              RowBox[{"AspectRatio", "\[Rule]", 
               RowBox[{"1", "/", "3"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"PlotTheme", "\[Rule]", "\"\<Detailed\>\""}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"PlotRange", "\[Rule]", " ", 
               RowBox[{"{", 
                RowBox[{"dateRange", ",", " ", "Automatic"}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"ImageSize", "\[Rule]", "800"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Frame", "\[Rule]", "True"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"InterpolationOrder", "\[Rule]", "0"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"GridLines", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"Automatic", ",", "None"}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"PlotStyle", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"FontSize", "\[Rule]", " ", "18"}], "}"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"FrameLabel", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                "\"\<Time\>\"", ",", " ", "\"\<Power Drain (mW)\>\""}], 
                "}"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"FrameStyle", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    "Gray", ",", " ", 
                    RowBox[{"Thickness", "[", "0.001", "]"}]}], "]"}], ",", 
                   " ", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    "LightGray"}], "]"}]}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    "Black", ",", " ", "Thick"}], "]"}], ",", " ", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{
                    "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                    ",", 
                    RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                    RowBox[{"GrayLevel", "[", "0.45", "]"}], ",", " ", 
                    RowBox[{"Thickness", "[", "0.0035", "]"}]}], "]"}]}], 
                  "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"Epilog", "\[Rule]", " ", 
               RowBox[{"Inset", "[", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{
                   RowBox[{"\"\<Average power drain = \>\"", "<>", 
                    RowBox[{"ToString", "[", "averagePowerMilliwatts", "]"}], 
                    "<>", "\"\< mW,  \>\"", "<>", 
                    "\"\<Min power drain = \>\"", "<>", 
                    RowBox[{"ToString", "[", "minPowerMilliwatts", "]"}], 
                    "<>", "\"\< mW\>\""}], ",", 
                   RowBox[{
                   "FontFamily", "\[Rule]", " ", "\"\<Helvetica Neue\>\""}], 
                   ",", 
                   RowBox[{"FontSize", "\[Rule]", " ", "16"}], ",", " ", 
                   RowBox[{"Background", "\[Rule]", " ", 
                    RowBox[{"Directive", "[", 
                    RowBox[{"LightBlue", ",", " ", 
                    RowBox[{"Opacity", "[", "0.5", "]"}]}], "]"}]}]}], "]"}], 
                 ",", " ", 
                 RowBox[{"Scaled", "[", 
                  RowBox[{"{", 
                   RowBox[{"0.5", ",", " ", "0.90"}], "}"}], "]"}]}], 
                "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
           "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
               RowBox[{"N", "[", 
                RowBox[{"#", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}], "&"}], "/@", 
            " ", "datesAndPowerMilliwatts"}], ")"}], "//", "TableForm"}]}], 
        "}"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 InitializationCell->True,
 CellChangeTimes->{{3.663526992666184*^9, 3.663527012696981*^9}, {
   3.66352709024442*^9, 3.663527241101337*^9}, {3.663527501427985*^9, 
   3.663527533399872*^9}, {3.663527902490831*^9, 3.6635279087117147`*^9}, {
   3.663527953497016*^9, 3.6635281140251837`*^9}, {3.6635281840045757`*^9, 
   3.663528303927691*^9}, 3.663528376278902*^9, {3.663528418166809*^9, 
   3.66352842333326*^9}, {3.663528459490168*^9, 3.663528478208108*^9}, {
   3.663528575223402*^9, 3.663528630867667*^9}, {3.66352866695277*^9, 
   3.66352870894353*^9}, 3.663528802782076*^9, {3.6635289149052*^9, 
   3.663529046443657*^9}, {3.6636043728505507`*^9, 3.663604474332753*^9}, {
   3.663604510941206*^9, 3.6636045110184927`*^9}, 3.66360454842518*^9, {
   3.663605282048636*^9, 3.663605366421356*^9}, {3.663605685017639*^9, 
   3.663606058443336*^9}, {3.663606091843856*^9, 3.663606118888343*^9}, {
   3.663606181056369*^9, 3.663606204861279*^9}, {3.663606441085436*^9, 
   3.663606504791254*^9}, {3.6636067926412067`*^9, 3.6636068160414343`*^9}, {
   3.6636760920069933`*^9, 3.6636761308555326`*^9}, {3.663676267327963*^9, 
   3.663676280264062*^9}, {3.663676404440865*^9, 3.6636764104695387`*^9}, {
   3.6636765127985*^9, 3.663676520179028*^9}, 3.6636766544904623`*^9, {
   3.663676690334074*^9, 3.6636767106149673`*^9}, 3.6636768911962633`*^9, {
   3.663689681530652*^9, 3.663689740451878*^9}, {3.6636897756147346`*^9, 
   3.6636898606163187`*^9}, {3.663765960564437*^9, 3.6637660356321487`*^9}, {
   3.66376606719118*^9, 3.663766092262488*^9}, {3.663766213067904*^9, 
   3.663766249802641*^9}, {3.6637662798323307`*^9, 3.663766312216693*^9}, {
   3.663766394116948*^9, 3.6637665492562313`*^9}, {3.6637665816384363`*^9, 
   3.663766622534255*^9}, {3.663766708321992*^9, 3.663766715266468*^9}, {
   3.663766754592012*^9, 3.663766766496698*^9}, {3.663768757342599*^9, 
   3.6637688210428877`*^9}, {3.663768875250205*^9, 3.66376903361731*^9}, {
   3.663769078392508*^9, 3.663769078543687*^9}, {3.663769115127654*^9, 
   3.66376928133809*^9}, {3.6637693760051107`*^9, 3.663769386053502*^9}, {
   3.6637694906288137`*^9, 3.663769493777985*^9}, {3.663797625629249*^9, 
   3.663797630731179*^9}, {3.663797695816155*^9, 3.663797701926817*^9}, {
   3.665690903726293*^9, 3.665691021977396*^9}, {3.665691093017593*^9, 
   3.6656911580704813`*^9}, {3.665691226968733*^9, 3.665691259190714*^9}, {
   3.665691323951332*^9, 3.665691336600584*^9}, {3.66569144858902*^9, 
   3.6656914492929077`*^9}, {3.665691483331935*^9, 3.6656915022724037`*^9}, {
   3.665691717516693*^9, 3.6656917789042463`*^9}, {3.6656918722420607`*^9, 
   3.6656918862948437`*^9}, {3.6656919421895*^9, 3.6656920133173428`*^9}, 
   3.66569208772818*^9, {3.665692188614389*^9, 3.665692189326047*^9}, 
   3.665692234847549*^9, {3.665692288256723*^9, 3.6656922979011106`*^9}, {
   3.665861895982085*^9, 3.665861896333493*^9}, {3.665861937318563*^9, 
   3.665861957526465*^9}, {3.6658620117801647`*^9, 3.6658620446752653`*^9}, {
   3.666702783741962*^9, 3.666702796416398*^9}, 3.666703211888782*^9, {
   3.666736576537464*^9, 3.666736694533841*^9}, 3.666736789501912*^9, {
   3.666737847424654*^9, 3.6667379242882843`*^9}, {3.666738177110742*^9, 
   3.666738201300856*^9}, {3.666738241029385*^9, 3.666738314098209*^9}, {
   3.667671276023478*^9, 3.6676713037959633`*^9}, {3.667671368085332*^9, 
   3.667671376766055*^9}, {3.667671423171804*^9, 3.6676714752987127`*^9}, {
   3.667671779856063*^9, 3.6676718764104853`*^9}, {3.667671991124879*^9, 
   3.667672224653791*^9}, {3.667672660401204*^9, 3.667672677655418*^9}, 
   3.667672922916297*^9, {3.667674239432369*^9, 3.6676743326385813`*^9}, 
   3.667674516489307*^9, {3.667674708983738*^9, 3.667674714021562*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"analyze", "[", 
  RowBox[{
  "\"\<nexus6p\>\"", ",", " ", "\"\<../Logs/2016-02-03-14-15-47.txt\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2016", ",", "2", ",", "2", ",", " ", "18", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"2016", ",", "2", ",", "3", ",", " ", "14", ",", " ", "15"}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.663606121808909*^9, 3.663606158385565*^9}, {
   3.66360621414023*^9, 3.6636062142975283`*^9}, {3.663606844816647*^9, 
   3.66360684928249*^9}, {3.663676146661626*^9, 3.663676152431726*^9}, {
   3.6636762608476973`*^9, 3.6636762610600452`*^9}, {3.6636763048701878`*^9, 
   3.663676322416711*^9}, 3.6636770475818768`*^9, {3.6636896654703083`*^9, 
   3.663689671494219*^9}, {3.663689886908979*^9, 3.663689896659676*^9}, {
   3.663769335479479*^9, 3.663769340746397*^9}, {3.663769671740046*^9, 
   3.663769678149811*^9}, {3.663796432530007*^9, 3.663796436447877*^9}, 
   3.66379759761835*^9, 3.665861578202352*^9, {3.665861686858152*^9, 
   3.665861687973421*^9}, {3.668364863920877*^9, 3.668364962745513*^9}, {
   3.6683650605445232`*^9, 3.668365086266965*^9}}],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{
           TagBox[GridBox[{
              {
               GraphicsBox[{{}, {{}, {}, 
                  {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                   0.003666666666666667], AbsoluteThickness[1.6], 
                   StyleBox[{LineBox[CompressedData["
1:eJyl3XsQXVV1x/FFGhiblvCGYIFugTpYhQpCESlkJTAS3g8HpBTDSgSkQBMS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                    "]], LineBox[CompressedData["
1:eJyF202o10UUxvFDtbAQ29RCsRiVUAKVKLqaWKeFRlmJmi9ZyJCaoujVfI+S
iSjTtHBVLdIjLW6RkEgLK9MhwlxkiyCilJwWJeVbBVlpQf4Fdz+e72yGD5zF
c4ZZDXNGPNU/c/E1Zvb1tWa93ax8t2Xa6fsvbl52cO2CF/2qb5m/aNLJUWsu
O8AV3MD2vXYCOziDCzjAFdzAdlw7gR2cwQUc4ApuYDuhncAOzuACDnAFN7D/
oJ07fWHMk69/tmdJLy84wKVpB7iC7Uft+pN2A9vP2gns4Awu4Apu4DilnX7V
rme1G9jOaSdwPq/dfte2P7QTuP4J/lu7ge2fLn/7zqrJN/Q93rtPg16RzuAC
DnAFN7BdDx6snUZoOziDCzjAFdzAaaR2G6UdfdoV3MA2QTuBHZzBBRzgCm6d
3nBo97DxDy7u1U/WbmC7VzuBHZzBBRzgBrb7tBPYZmgnsJNnaVdwA9tj2gns
4Awu4ABXcAP7HO0MLuDo9Og7Bu0dPnJ2Ly+4gW2utvdrx/PaFdzAtlk7gR2c
wQUc5I+0K7iB7WPtBHZwBhdwgCvYPtEuh7UD3MD2hXYCe6d/GzgyrW/TQ73z
BBdwBTewHdX2X7Tr0K3Sfpd29GlXcAPbBG0HZ3ABB7iC3bXtAe0EzuAyXdvm
gRdqJ7CDM7iAA1yWd3nv8PmLJm2Z16sHV3ADx2rttFbbwRlcwAFO67Rtq3YC
OziD23Zt26Gd3tT2PdoZXMA+oJ3f1S7gCm5ge087gb3Ta5buPPvcqeW9fsAF
HOC6T9s+107gTP5Ku1zSDnAFN7D9qx3/afvN26RtqHYCOziDA1zBDWzDtBN5
tHaM0W63d/nMjAO3vvRXfy/PeG3v066ztdMT2g4u4AB71o6t2hXcwLZNO4Ed
nMH+vnYGF3Dap+0XwBe1M7iAA9zAdkk7gfMNr3b4ujlDxu6fMrOXFxzgcpN2
gCvYbtPOY7ULOMClTzst1HZwBhdwgCu4gW2RdgI7uIADnBZrO7iCG9ieBi/p
8pX/PHdO7eUFOziDCzjAFWxLtTO4gAPclmnbcu0EdnAGF3CAywva8TJ4p3Y9
pN3A6bC2g+0b7XK8yyen73hj5ZylvX7AFdzAdkI7gR3cTmvbGe0E9pHbpcvd
2rkPfI92maKdp2r7w9oZXMABruAGtke0fYV22qjtB7TbQW37VDt1+tiXl9f2
K++h4AIOcAXHMe16UTsG75Cu4Aa2MdoJ7OAYq13BDWzjtBPYwRnsj2pncCHP
1fa3wLu0M7iAK7iBbbd2Ajs4kz/QjhPa6Zx2G/KatN2oncAOzuACDnAF+3jt
mAheoV3BDWwrtRPYwQUc4ApuYOvv8q7zA0emzVrf6wfs4Awu4ABXcAPbKu0E
dnAGF3CAK7iBbbV2Ajs4gws4wBXcwPaMdgI7OIMLOMAV3Do9dv/b5wfGrej1
u0bbwRlcwAGu4Aa2tdoJ7OAMLuAAV3AD2zrtBHZwBhdwgCu4gW29dgI7OIML
OMC10/Mmfnh0/YIr815g26CdwA7O4AIOcAU3sG3UTmAHZ3ABB7iCG9g2aTs4
gws4wBXcwPasdgI7OIMLODp9dR76f0//FVo=
                    "]], 
                    LineBox[CompressedData["
1:eJyF223omFUZx/Gr9dcXtYakkGDRJUr5uNmTq1Z5mUjlXFovlqTZlWUuqTRd
hbO2E8vsafu7olaJdUh09cIHrExqLw629mr28DcwkNhlkwwinJUvTAf970Hv
bn7f+83hAzeH87vg4j6H+75Pvuq691+9wsy2LJhNo1nfunP9P87/79Zr926+
cnv8398+cWHjqps/s+wBLrBt03ZwgBPcwB08wAW2pu3gACe4gTt4gAuc27X9
y9oDXGC/RTtu1fZvagc4wQ08Zn3Smr+ceuyuy6a85B3atqjddmnHndp1j3b8
VruBO9gOazs4wAlu4A4e4AKPF7QLbEe060WL0rZC28G5oN3AHTzANevfPHva
FYtLl055jtF2cIB9pXaAGziP027gAa7jte0E7QAnuIHrJG17pbaD2ynaHTzA
7TTtfrr2ABfYztB2cIAT3Ga97uAlO3Z/96NTXnCeqd3AHTzABbaztB1c4Fyt
XWu07RxtB/e12gNc4HaedgcPcIEttB1sG7QdbJdpOzjACY7L5/z2lzx25/Vf
PPo8/bC2pXaAB7jA/hHtACe4gTv5Gu0BLnBep93AHTzABbbrtf3z2gHu27Sz
aTfwAPtXtQOc4AauxTn/8Ok9+9fvvnCq923aDu67tQe4wPkj7Qbu4AGOu7V9
j3aCG7ju1bb7tAPcH9Qe4ALbL7UDnOAGroe081fa/mvtmPUjB5avhU9O84Fj
n3aCG9gOaDs4wO2P2h08wAW2JW0HBzjB41HtAtuftP1x7QAn2A9pF9ie1A5w
ghu4g8es/7W04arjHnr3tJ5ntBPcwPactoMDXOB8Xrte0LYj2g7uC7dJD3CB
7RhtB+dK7Qbu4HiZ9lil7a/WDnCC6zXa9lptBwc4Z/34c1uv3fufD0z1XK09
wLZGO8/VbuAOHuAC21ptf4d2gBNs52m30O7gAc7ztRvY36kd4AR38AAX2C7Q
9vdoBzjBbdYn3PuuJ7as3DjlARe4X6TtF2v3Ddr5Xu0GHuAC2yXaTt6oHeAE
14e07UptB/ertQe4wPZxbQcHOMF+jXbfpD3ANeuNq85+4I77Lp7W8wntBu7g
Ac5PaTdwB+fntBu4g32rdoAT3MAdbNu0HVy3aNtXtB2ct2r3HdoDXGDbqR3g
BDdwn/Whu27f53H0feuidu7S9m9pJ7iBO7i+r20/0HZw3AG+SzvBDWz3aDs4
wOMB7QLbz7QdHOAEN/D4uXaB7RfaDg5wI+/V7uAC5z7tDh5gP6Ad4Abu4AEu
sD2i7eD8nXYDd/AAF9h/rx3gAtsftAOcS9odPMAFtkfnfHjP/vVrb7poqhc4
wP0x7QG2P2vnQe0GHuACW2k7OMAJ7k9oD3CB21+145B2gjt4gAtsT2oPcPxN
ezyl3f4+589OH6TfsHnKCy5wHNZu4E5+8S7pAbYF7XipdgN3sB2v7eAEN3AH
t1dod/AAF9hO1K6TtfMU7Qbu4ALbqdoODnDO+qnnf/rM0pGj59kz5vyqD35s
3cGnY7of3MAdPMAFtjPnfPfyduD+r18+1Qsc4AQ3cAcPsJ2l7eAAJ7iBO3iA
C2xnazs4wAlu4A4e4ALbam0Hx6xPv2Lx4WeXjv6PBm7gDh7gmvVPlrcbX3vf
pinvGm0HBzjBDdzBBbZztB0c4AQ3cAcPcIHtddoODnCCG7iDB7jA9nptn/X9
N2za9c+dN015wQlu4A4es/7ep1++few/2s9ge4O2gwPcwB08wAW2N2o7OMAJ
buAOHuAC25u0HRzgBDdwBw9wge3cOd+43C5fODj1i4MDnOAG7rP+8YUP/vvI
vhunvGBbq+3gACe4gTt4gAtsb9Z2cIAT3MAdPMAFtrdoOzjACW7gDh6zPvZL
37ngGw9vmfKC7a3aDk5wA/dZ7928fOBfcfOUB1xgW6ft4AAnuIE7eIALbG/T
dnCAU/p/xBRgYg==
                    "]]},
                    FontSize->18]}}, {}},
                AspectRatio->NCache[
                  Rational[1, 3], 0.3333333333333333],
                Axes->{False, False},
                AxesLabel->{None, None},
                AxesOrigin->{3.6634248*^9, 0},
                DisplayFunction->Identity,
                Frame->{{True, True}, {True, True}},
                FrameLabel->{{
                   FormBox[
                   "\"Sampled Battery Current (mA)\"", TraditionalForm], 
                   None}, {
                   FormBox["\"Time\"", TraditionalForm], None}},
                FrameStyle->{{
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0.5], 
                    Thickness[0.001]], 
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0.85]]}, {
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0], 
                    Thickness[Large]], 
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0.45], 
                    Thickness[0.0035]]}},
                
                FrameTicks->
                 FrontEndValueCache[{{Automatic, Automatic}, {
                   Charting`FindScaledTicks[
                    (Charting`getDateTicks[Automatic, {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    Automatic]& )[
                    SlotSequence[1]], {Identity, Identity}]& , 
                    Charting`ScaledFrameTicks[
                    (Charting`getDateTicks[
                    Charting`getDateTicks[Automatic, {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    Automatic]& , {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    None]& )[
                    SlotSequence[1]], {Identity, Identity}]& }}, {{
                   Automatic, Automatic}, {{{3.6634176*^9, 
                    FormBox["\"16:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox["\"20:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox["\"00:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox["\"04:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox["\"08:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox["\"12:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663504*^9, 
                    FormBox["\"16:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634176*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634212*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634248*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634284*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634356*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634392*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634428*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.66345*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634536*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634572*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634644*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663468*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634716*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634788*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634824*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663486*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634932*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634968*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}}, {{3.6634176*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663504*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634176*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634212*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634248*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634284*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634356*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634392*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634428*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.66345*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634536*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634572*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634644*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663468*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634716*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634788*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634824*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663486*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634932*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634968*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}}}}],
                GridLines->FrontEndValueCache[{Charting`ScaledTickValues[
                    ((Transpose[{#, 
                    Table[
                    Directive[
                    GrayLevel[0.4, 0.5], 
                    AbsoluteThickness[1], 
                    AbsoluteDashing[{1, 2}]], {
                    Length[#]}]}]& )[
                    Part[
                    Select[
                    (Charting`getDateTicks[Automatic, {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    Automatic]& )[
                    SlotSequence[1]], And[
                    FreeQ[#, 
                    Alternatives["", 
                    Spacer[{0, 0}]]], Head[#] === List, Length[#] > 0]& ], 
                    All, 1]]& )[
                    SlotSequence[1]], {Identity, Identity}]& , 
                   None}, {{{3.6634176*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.663432*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634464*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634608*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634752*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634896*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.663504*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}}, None}],
                GridLinesStyle->Directive[
                  GrayLevel[0.4, 0.5], 
                  AbsoluteThickness[1], 
                  AbsoluteDashing[{1, 2}]],
                ImagePadding->All,
                ImageSize->800,
                Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}},
                PlotRange->{{3.6634248*^9, 3.6634977*^9}, {0, 619.807}},
                PlotRangeClipping->True,
                PlotRangePadding->{{0, 0}, {
                   Scaled[0.02], 
                   Scaled[0.05]}},
                Ticks->{None, Automatic}]},
              {
               GraphicsBox[{{}, {{}, {}, 
                  {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                   0.003666666666666667], AbsoluteThickness[1.6], 
                   StyleBox[LineBox[CompressedData["
1:eJyl3Wn0nVWV5/EdSJAqScJoAgp1AEFkCKOEQckOFEjJZGODYDWwwxBQhDCE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                    "]],
                    FontSize->18]}}, {}},
                AspectRatio->NCache[
                  Rational[1, 3], 0.3333333333333333],
                Axes->{False, False},
                AxesLabel->{None, None},
                AxesOrigin->{3.6634248*^9, 3.249732858596076},
                DisplayFunction->Identity,
                Frame->{{True, True}, {True, True}},
                FrameLabel->{{
                   FormBox[
                   "\"Sampled Battery Current (mA)\"", TraditionalForm], 
                   None}, {
                   FormBox["\"Time\"", TraditionalForm], None}},
                FrameStyle->{{
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0.5], 
                    Thickness[0.001]], 
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0.85]]}, {
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0], 
                    Thickness[Large]], 
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0.45], 
                    Thickness[0.0035]]}},
                FrameTicks->FrontEndValueCache[{{{{3.912023005428146, 
                    FormBox["50", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.605170185988092, 
                    FormBox["100", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.214608098422191, 
                    FormBox["500", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.907755278982137, 
                    FormBox["1000", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {2.302585092994046, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {2.995732273553991, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.0943445622221, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.248495242049359, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.382026634673881, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.499809670330265, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {5.298317366548036, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {5.703782474656201, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {5.991464547107982, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.396929655216146, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.551080335043404, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.684611727667927, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.802394763324311, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {7.600902459542082, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.006367567650246, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.294049640102028, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.517193191416238, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.699514748210191, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.85366542803745, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.987196820661973, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {9.104979856318357, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {9.210340371976184, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}}, Automatic}, {
                   Charting`FindScaledTicks[
                    (Charting`getDateTicks[Automatic, {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    Automatic]& )[
                    SlotSequence[1]], {Identity, Identity}]& , 
                    Charting`ScaledFrameTicks[
                    (Charting`getDateTicks[
                    Charting`getDateTicks[Automatic, {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    Automatic]& , {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    None]& )[
                    SlotSequence[1]], {Identity, Identity}]& }}, {{{{
                    3.912023005428146, 
                    FormBox["50", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.605170185988092, 
                    FormBox["100", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.214608098422191, 
                    FormBox["500", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.907755278982137, 
                    FormBox["1000", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {2.302585092994046, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {2.995732273553991, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.0943445622221, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.248495242049359, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.382026634673881, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.499809670330265, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {5.298317366548036, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {5.703782474656201, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {5.991464547107982, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.396929655216146, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.551080335043404, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.684611727667927, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.802394763324311, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {7.600902459542082, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.006367567650246, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.294049640102028, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.517193191416238, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.699514748210191, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.85366542803745, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.987196820661973, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {9.104979856318357, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {9.210340371976184, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}}, Automatic}, {{{3.6634176*^9, 
                    FormBox["\"16:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox["\"20:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox["\"00:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox["\"04:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox["\"08:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox["\"12:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663504*^9, 
                    FormBox["\"16:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634176*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634212*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634248*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634284*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634356*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634392*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634428*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.66345*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634536*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634572*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634644*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663468*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634716*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634788*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634824*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663486*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634932*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634968*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}}, {{3.6634176*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663504*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634176*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634212*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634248*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634284*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634356*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634392*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634428*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.66345*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634536*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634572*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634644*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663468*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634716*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634788*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634824*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663486*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634932*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634968*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}}}}],
                GridLines->FrontEndValueCache[{Charting`ScaledTickValues[
                    ((Transpose[{#, 
                    Table[
                    Directive[
                    GrayLevel[0.4, 0.5], 
                    AbsoluteThickness[1], 
                    AbsoluteDashing[{1, 2}]], {
                    Length[#]}]}]& )[
                    Part[
                    Select[
                    (Charting`getDateTicks[Automatic, {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    Automatic]& )[
                    SlotSequence[1]], And[
                    FreeQ[#, 
                    Alternatives["", 
                    Spacer[{0, 0}]]], Head[#] === List, Length[#] > 0]& ], 
                    All, 1]]& )[
                    SlotSequence[1]], {Identity, Identity}]& , 
                   None}, {{{3.6634176*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.663432*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634464*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634608*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634752*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634896*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.663504*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}}, None}],
                GridLinesStyle->Directive[
                  GrayLevel[0.4, 0.5], 
                  AbsoluteThickness[1], 
                  AbsoluteDashing[{1, 2}]],
                ImagePadding->All,
                ImageSize->800,
                Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
                    Part[#, 1]], 
                    (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
                    Part[#, 1]], 
                    (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
                    Part[#, 2]]}& )}},
                
                PlotRange->{{3.6634248*^9, 3.6634977*^9}, {3.313749933874893, 
                 7.282808601161586}},
                PlotRangeClipping->True,
                PlotRangePadding->{{0, 0}, {
                   Scaled[0.02], 
                   Scaled[0.05]}},
                Ticks->{None, {{3.912023005428146, 
                    FormBox["50", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.605170185988092, 
                    FormBox["100", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.214608098422191, 
                    FormBox["500", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.907755278982137, 
                    FormBox["1000", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {2.302585092994046, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {2.995732273553991, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.0943445622221, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.248495242049359, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.382026634673881, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.499809670330265, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {5.298317366548036, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {5.703782474656201, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {5.991464547107982, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.396929655216146, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.551080335043404, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.684611727667927, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.802394763324311, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {7.600902459542082, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.006367567650246, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.294049640102028, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.517193191416238, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.699514748210191, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.85366542803745, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.987196820661973, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {9.104979856318357, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {9.210340371976184, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}}}]},
              {
               GraphicsBox[{{}, {{}, {}, 
                  {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                   0.003666666666666667], AbsoluteThickness[1.6], 
                   StyleBox[LineBox[CompressedData["
1:eJyl3GkQXkWVxvEDgjU4bGExRNRpRBBkE0TCnhPQkSWAy4Ar4QRkC/uSkIws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                    "]],
                    FontSize->18]}}, {}},
                AspectRatio->NCache[
                  Rational[1, 3], 0.3333333333333333],
                Axes->{False, False},
                AxesLabel->{None, None},
                AxesOrigin->{3.6634248*^9, 0},
                DisplayFunction->Identity,
                Frame->{{True, True}, {True, True}},
                FrameLabel->{{
                   FormBox[
                   "\"Sampled Battery Voltage (Volts)\"", TraditionalForm], 
                   None}, {
                   FormBox["\"Time\"", TraditionalForm], None}},
                FrameStyle->{{
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0.5], 
                    Thickness[0.001]], 
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0.85]]}, {
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0], 
                    Thickness[Large]], 
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0.45], 
                    Thickness[0.0035]]}},
                
                FrameTicks->
                 FrontEndValueCache[{{Automatic, Automatic}, {
                   Charting`FindScaledTicks[
                    (Charting`getDateTicks[Automatic, {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    Automatic]& )[
                    SlotSequence[1]], {Identity, Identity}]& , 
                    Charting`ScaledFrameTicks[
                    (Charting`getDateTicks[
                    Charting`getDateTicks[Automatic, {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    Automatic]& , {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    None]& )[
                    SlotSequence[1]], {Identity, Identity}]& }}, {{
                   Automatic, Automatic}, {{{3.6634176*^9, 
                    FormBox["\"16:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox["\"20:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox["\"00:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox["\"04:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox["\"08:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox["\"12:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663504*^9, 
                    FormBox["\"16:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634176*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634212*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634248*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634284*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634356*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634392*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634428*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.66345*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634536*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634572*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634644*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663468*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634716*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634788*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634824*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663486*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634932*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634968*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}}, {{3.6634176*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663504*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634176*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634212*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634248*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634284*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634356*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634392*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634428*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.66345*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634536*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634572*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634644*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663468*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634716*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634788*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634824*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663486*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634932*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634968*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}}}}],
                GridLines->FrontEndValueCache[{Charting`ScaledTickValues[
                    ((Transpose[{#, 
                    Table[
                    Directive[
                    GrayLevel[0.4, 0.5], 
                    AbsoluteThickness[1], 
                    AbsoluteDashing[{1, 2}]], {
                    Length[#]}]}]& )[
                    Part[
                    Select[
                    (Charting`getDateTicks[Automatic, {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    Automatic]& )[
                    SlotSequence[1]], And[
                    FreeQ[#, 
                    Alternatives["", 
                    Spacer[{0, 0}]]], Head[#] === List, Length[#] > 0]& ], 
                    All, 1]]& )[
                    SlotSequence[1]], {Identity, Identity}]& , 
                   None}, {{{3.6634176*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.663432*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634464*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634608*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634752*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634896*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.663504*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}}, None}],
                GridLinesStyle->Directive[
                  GrayLevel[0.4, 0.5], 
                  AbsoluteThickness[1], 
                  AbsoluteDashing[{1, 2}]],
                ImagePadding->All,
                ImageSize->800,
                Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}},
                PlotRange->{{3.6634248*^9, 3.6634977*^9}, {0, 4.6}},
                PlotRangeClipping->True,
                PlotRangePadding->{{0, 0}, {0, 0}},
                Ticks->{None, Automatic}]},
              {
               GraphicsBox[{{}, {{}, {}, 
                  {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                   0.003666666666666667], AbsoluteThickness[1.6], 
                   StyleBox[LineBox[CompressedData["
1:eJyl3HkUXVV1x/EdJArIPEiCYA+CEKYwiARNS3bAFgQCghWsA2yQQYkhYQwI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                    "]],
                    FontSize->18]}}, {}},
                AspectRatio->NCache[
                  Rational[1, 3], 0.3333333333333333],
                Axes->{False, False},
                AxesLabel->{None, None},
                AxesOrigin->{3.6634248*^9, -2.279559242064105},
                DisplayFunction->Identity,
                Frame->{{True, True}, {True, True}},
                FrameLabel->{{
                   FormBox[
                   "\"Sampled Battery Voltage (Volts)\"", TraditionalForm], 
                   None}, {
                   FormBox["\"Time\"", TraditionalForm], None}},
                FrameStyle->{{
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0.5], 
                    Thickness[0.001]], 
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0.85]]}, {
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0], 
                    Thickness[Large]], 
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0.45], 
                    Thickness[0.0035]]}},
                FrameTicks->FrontEndValueCache[{{{{-2.3025850929940455`, 
                    FormBox["0.1`", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {-0.6931471805599453, 
                    FormBox["\"0.5\"", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {0., 
                    FormBox["1", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
                    FormBox["5", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {2.302585092994046, 
                    FormBox["10", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {-2.995732273553991, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-2.8134107167600364`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-2.659260036932778, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-2.5257286443082556`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-2.4079456086518722`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-0.916290731874155, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {0.6931471805599453, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {1.791759469228055, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {2.995732273553991, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {3.912023005428146, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.0943445622221, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.248495242049359, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.382026634673881, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.499809670330265, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.605170185988092, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}}, Automatic}, {
                   Charting`FindScaledTicks[
                    (Charting`getDateTicks[Automatic, {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    Automatic]& )[
                    SlotSequence[1]], {Identity, Identity}]& , 
                    Charting`ScaledFrameTicks[
                    (Charting`getDateTicks[
                    Charting`getDateTicks[Automatic, {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    Automatic]& , {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    None]& )[
                    SlotSequence[1]], {
                    Identity, Identity}]& }}, {{{{-2.3025850929940455`, 
                    FormBox["0.1`", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {-0.6931471805599453, 
                    FormBox["\"0.5\"", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {0., 
                    FormBox["1", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
                    FormBox["5", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {2.302585092994046, 
                    FormBox["10", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {-2.995732273553991, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-2.8134107167600364`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-2.659260036932778, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-2.5257286443082556`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-2.4079456086518722`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-0.916290731874155, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {0.6931471805599453, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {1.791759469228055, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {2.995732273553991, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {3.912023005428146, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.0943445622221, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.248495242049359, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.382026634673881, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.499809670330265, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.605170185988092, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}}, Automatic}, {{{3.6634176*^9, 
                    FormBox["\"16:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox["\"20:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox["\"00:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox["\"04:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox["\"08:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox["\"12:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663504*^9, 
                    FormBox["\"16:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634176*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634212*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634248*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634284*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634356*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634392*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634428*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.66345*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634536*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634572*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634644*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663468*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634716*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634788*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634824*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663486*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634932*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634968*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}}, {{3.6634176*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663504*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634176*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634212*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634248*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634284*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634356*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634392*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634428*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.66345*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634536*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634572*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634644*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663468*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634716*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634788*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634824*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663486*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634932*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634968*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}}}}],
                GridLines->FrontEndValueCache[{Charting`ScaledTickValues[
                    ((Transpose[{#, 
                    Table[
                    Directive[
                    GrayLevel[0.4, 0.5], 
                    AbsoluteThickness[1], 
                    AbsoluteDashing[{1, 2}]], {
                    Length[#]}]}]& )[
                    Part[
                    Select[
                    (Charting`getDateTicks[Automatic, {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    Automatic]& )[
                    SlotSequence[1]], And[
                    FreeQ[#, 
                    Alternatives["", 
                    Spacer[{0, 0}]]], Head[#] === List, Length[#] > 0]& ], 
                    All, 1]]& )[
                    SlotSequence[1]], {Identity, Identity}]& , 
                   None}, {{{3.6634176*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.663432*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634464*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634608*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634752*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634896*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.663504*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}}, None}],
                GridLinesStyle->Directive[
                  GrayLevel[0.4, 0.5], 
                  AbsoluteThickness[1], 
                  AbsoluteDashing[{1, 2}]],
                ImagePadding->All,
                ImageSize->800,
                Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
                    Part[#, 1]], 
                    (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
                    Part[#, 1]], 
                    (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
                    Part[#, 2]]}& )}},
                
                PlotRange->
                 NCache[{{3.6634248*^9, 
                   3.6634977*^9}, {-2.3025850929940455`, 
                    Log[10]}}, {{3.6634248*^9, 
                  3.6634977*^9}, {-2.3025850929940455`, 2.302585092994046}}],
                PlotRangeClipping->True,
                PlotRangePadding->{{0, 0}, {0, 0}},
                Ticks->{None, {{-2.3025850929940455`, 
                    FormBox["0.1`", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {-0.6931471805599453, 
                    FormBox["\"0.5\"", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {0., 
                    FormBox["1", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
                    FormBox["5", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {2.302585092994046, 
                    FormBox["10", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {-2.995732273553991, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-2.8134107167600364`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-2.659260036932778, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-2.5257286443082556`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-2.4079456086518722`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-0.916290731874155, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {0.6931471805599453, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {1.791759469228055, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {2.995732273553991, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {3.912023005428146, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.0943445622221, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.248495242049359, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.382026634673881, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.499809670330265, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.605170185988092, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}}}]},
              {
               GraphicsBox[{{}, {{}, {}, 
                  {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                   0.003666666666666667], AbsoluteThickness[1.6], 
                   StyleBox[{LineBox[CompressedData["
1:eJyl3Hvw39Odx/F33AbbJOISQtnj0rq0lFCX2vKOrta6tMYMu91ZvMPGLW5J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                    "]], 
                    LineBox[CompressedData["
1:eJyF20uo10UYxvEXXVghFpULg2A0SpHMoOhYdHkLykU37KKSi4Y8ZmR2sk6a
SjoJlafUDKUbVm9lWYRUBJKVOoGRBLUIXJgi0yKjLKPAyEtUf8Hdj+e7Gj4w
i+eZmdXAO/aegdvmDDOz74ab9VazsufpGw9e+/Wvw5eu941+0ov639w5edL6
/x3gCm5g+147gR2cwQUc4ApuYNurncAOzuACDnAFN7Dt005gB2dwAQe4ghvY
92vnTv9z5fGDI46s7OUFB7g07QBXsP2gXX/UbmA7oJ3ADs7gAq7gBo6ftNMv
2vU37Qa2Q9oJnH/Xbn9o25/aCVwPg//WbmA70uUNK+5+cfnWJb33dMpK6Qwu
4ABXcAPbqeCR2mmstoMzuIADXMENnMZpt/O0o0+7ghvYpmgnsIMzuIADXMGt
02+NOjBi+4qnevuv0m5gu1o7gR2cwQUc4Aa2a7QT2KZpJ7CTb9eu4Aa2O7QT
2MEZXMABruAG9unaGVzA0elt/567/cv+hb284Aa2Gdo+oB2Pa1dwA9sy7QR2
cAYXcJC3aldwA9un2gns4Awu4ABXsH2mXXZoB7iB7SvtBPZOb3n7zw2zznqg
d57gAq7gBrZd2v6zdh0zJO2XakefdgU3sE3RdnAGF3CAK9hd26ZqJ3AGl1u1
bSZ4tnYCOziDCzjAZV6Xdx1e/s6mI4t7+8EV3MCxQDsNajs4gws4wOlRbRvS
TmAHZ3BbpW2rtdNL2v6GdgYXsG/Szu9qF3AFN7C9p53A3umlf5wxtHFwda8P
uIADXD/Utp3aCZzJ32qXY9oBruAGtuPa8Y+2j35G2sZoJ7CDMzjAFdzAdo52
Io/XjgnabWKXNw27+IWZe9f28kzW9j7teqd2mqXt4AIOsGftGNKu4Aa2Z7QT
2MEZ7O9rZ3ABpw+1/S/wUe0MLuAAN7Ad007gfNqzHV7x/sfP3TbjkV5ecIDL
2doBrmA7XztP0i7gAJc+7TRb28EZXMABruAGtn7tBHZwAQc4zdF2cAU3sN0L
ntvlPbvXTnx12dxeXrCDM7iAA1zBdp92BhdwgNv92jZPO4EdnMEFHODyhHY8
BX5eu27XbuC0Q9vBtlu77O3yPTftv+C6zUO9PuAKbmDbp53ADm4Hte1X7QT2
cauky2XauQ98hXa5XjvfoO03aWdwAQe4ghvYbtb2+drpMW3/RLt9rm3btFOn
x1+yf/rR0Sf+Q8EFHOAKjm+061HtGLlauoIb2CZoJ7CDY5J2BTewXaSdwA7O
YL9FO4MLeYa2vwx+TTuDC7iCW6dfefLCL2aeeeK+XtdOYAdn8gfasU87HdJu
o9ZI2+naCezgDC7gAFewT9aOy8HztSu4ge1B7QR2cAEHuIIb2Aa6vG7dtI/u
6n+x1wfs4Awu4ABXcAPbQ9oJ7OAMLuAAV3AD2wLtBHZwBhdwgCu4ge1h7QR2
cAYXcIAruHV688CWh/s3run1fUTbwRlcwAGu4Aa2Qe0EdnAGF3CAK7iB7VHt
BHZwBhdwgCu4gW2hdgI7OIMLOMC104M3zhg3fOqJeS+wLdJOYAdncAEHuIIb
2B7TTmAHZ3ABB7iCG9gWazs4gws4wBXcwLZEO4EdnMEFHJ0+OQ/9H+xlzaQ=

                    "]], LineBox[CompressedData["
1:eJyF23vo31Udx/F3OruwC5Zd7AKdubCac1PntsrI94z+MKdd/rAxKd+T3KXa
7AJJrtwbnNltmxsNaTU84bowsEC72Iw4kf0zLG0LLCp6e6lWKSzwjyTt8v1B
/314Pf86POBwOK83HM45HM7i62547/WnmdlN88xmrVm/ec8Vf1977MnTd3zZ
D/v/vfDRdY/cddX+/3mAC2w7tRvYwQFOcAcPcIEttRvYwQFOcAcPcIHjFu22
S3uAC9xu1fbbtNuXtB0c4ASPSft/Dv3tRfWpWV7ybm3bq537tP0u7bpb23+u
neAOtlPaDezgACe4gwe4wONZ7QLbc9r1vL3Sdpp2A8c87QR38ADXpN99zZ2X
P3X0Y7M8Z2g3sIPbAm0HJzjO1E7wANdZ2vZSbQcHOMH1am17jXYD5xLtDh7g
fIN2f6P2ABfYlmo3sIMDnJPecsXLl7744K5ZXnCcp53gDh7gAtsy7QYucCzX
rhXadoF2A/c12gNc4LxUu4MHuMDm2g1sV2o3sK3XbmAHB9ivmfILtpy6cM2x
uf30Wm0LbQcPcIHbRm0HBzjBnbxZe4ALHDdoJ7iDB7jA9lHtdqO2g/tO7Ujt
BA9w+5y2gwOc4No75XM/uOyybT/bNKv37doN3O/QHuACx53aCe7gAfZvardv
aQc4wfUdbfuutoP7D7QHuMD2Q20HBzjBdZ92HNVu92v7pL/+70X941t3z8YD
+wPaAU6wPajdwA7OX2l38AAX2I5rN7CDAzxOaBfYfq3dfqft4AC3x7ULbE9o
OzjACe7gMel9G95z9qIFH5rN5x/aAU6wPaPdwA4ucPxLu57Vtue0G7jPu116
gAtsZ2g3cCzQTnAH+0LtsUi7vVbbwQGuc7Xt9doN7OCY9LGF2w7NXz13Xl+u
PcC2QjtWaye4gwe4wLZGu71N28EBtku107U7eIBjrXaC22XaDg5wBw9wge3t
2u1ybQcHOCf92C0nN6y6+MZZHnCB+zu12zrtfqV2XKWd4AEusL1Lu5Gv1nZw
gOv92vYB7Qbu12sPcIFtk3YDOzjAbbN236I9wDXpl/322g1HV26fzWerdoI7
eIBjm3aCOzg+qZ3gDm43azs4wAnuYNup3cB1q7Z9VruB4zbtvlt7gAtse7Qd
HOAE90m/b2t7+L5Xzb237tWOfdptv3aAE9zB9RVtO6jdwH4I/A3tACfY7tZu
YAePe7QLbPdqN7CDA5zg8T3tAtv3tRvYwTnpe67edOSpV875x9odXOB4QLuD
B7g9qO3gBHfwABfYfqHdwPFL7QR38AAXuD2k7eAC28PaDo7j2h08wAW2E1Oe
v/2cVS/8/Ydn9QI7uD+iPcD2G+34o3aCB7jAVtoN7OAA90e1B7jA+Zi2P64d
4A4e4ALbE9oD7H/WHn/RzpNT3njk6e2XXHdglhdcYD+lneBOPn2f9ADbPG2f
r53gDraztBs4wAnu4HyFdgcPcIHtbO1arB1LtBPcwQW212k3sINj0kt/tPsz
e3bO3WeXTnnl4jvWrT6+cdYfnOAOHuAC23lT/smTO87/dn16Vi+wgwOc4A4e
YFum3cAODnCCO3iAC2znazewgwOc4A4e4ALbcu0G9kmf/MThv572p7n/aOAE
d/AA16R/euSmZw4d/fws7wrtBnZwgBPcwQW2C7Qb2MEBTnAHD3CB7ULtBnZw
gBPcwQNcYLtIu016184DH1m/+quzvOAAJ7iDx6RfsuMdZ26uufUMtpXaDezg
BHfwABfYLtZuYAcHOMEdPMAFtlXaDezgACe4gwe4wLZ6yv88ceD+5ftn66WB
HRzgBPdJHzl4+Jwlz5+7j4FtjXYDOzjACe7gAS6wvUm7gR0c4AR38AAX2N6s
3cAODnCCO3hM+g/3rl110Re/NssLtrdoN3CAE9wnvX/91i88/dDMA1xgu0S7
gR0c4AR38AAX2N6q3cAODun/AkIpgD4=
                    "]]},
                    FontSize->18]}}, {}},
                AspectRatio->NCache[
                  Rational[1, 3], 0.3333333333333333],
                Axes->{False, False},
                AxesLabel->{None, None},
                AxesOrigin->{3.6634248*^9, 0},
                DisplayFunction->Identity,
                Epilog->InsetBox[
                  BoxData[
                   FormBox[
                    StyleBox[
                    "\"Average power drain = 703.00 mW, Min power drain = \
143.00 mW,\\n\"", FontFamily -> "Helvetica Neue", FontSize -> 16, Background -> 
                    Directive[
                    RGBColor[0.87, 0.94, 1], 
                    Opacity[0.5]], StripOnInput -> False], TraditionalForm]], 
                  
                  Scaled[{0.5, 0.9}]],
                Frame->{{True, True}, {True, True}},
                FrameLabel->{{
                   FormBox["\"Power Drain (mW)\"", TraditionalForm], None}, {
                   FormBox["\"Time\"", TraditionalForm], None}},
                FrameStyle->{{
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0.5], 
                    Thickness[0.001]], 
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0.85]]}, {
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0], 
                    Thickness[Large]], 
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0.45], 
                    Thickness[0.0035]]}},
                
                FrameTicks->
                 FrontEndValueCache[{{Automatic, Automatic}, {
                   Charting`FindScaledTicks[
                    (Charting`getDateTicks[Automatic, {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    Automatic]& )[
                    SlotSequence[1]], {Identity, Identity}]& , 
                    Charting`ScaledFrameTicks[
                    (Charting`getDateTicks[
                    Charting`getDateTicks[Automatic, {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    Automatic]& , {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    None]& )[
                    SlotSequence[1]], {Identity, Identity}]& }}, {{
                   Automatic, Automatic}, {{{3.6634176*^9, 
                    FormBox["\"16:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox["\"20:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox["\"00:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox["\"04:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox["\"08:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox["\"12:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663504*^9, 
                    FormBox["\"16:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634176*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634212*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634248*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634284*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634356*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634392*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634428*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.66345*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634536*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634572*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634644*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663468*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634716*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634788*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634824*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663486*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634932*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634968*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}}, {{3.6634176*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663504*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634176*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634212*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634248*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634284*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634356*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634392*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634428*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.66345*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634536*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634572*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634644*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663468*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634716*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634788*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634824*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663486*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634932*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634968*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}}}}],
                GridLines->FrontEndValueCache[{Charting`ScaledTickValues[
                    ((Transpose[{#, 
                    Table[
                    Directive[
                    GrayLevel[0.4, 0.5], 
                    AbsoluteThickness[1], 
                    AbsoluteDashing[{1, 2}]], {
                    Length[#]}]}]& )[
                    Part[
                    Select[
                    (Charting`getDateTicks[Automatic, {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    Automatic]& )[
                    SlotSequence[1]], And[
                    FreeQ[#, 
                    Alternatives["", 
                    Spacer[{0, 0}]]], Head[#] === List, Length[#] > 0]& ], 
                    All, 1]]& )[
                    SlotSequence[1]], {Identity, Identity}]& , 
                   None}, {{{3.6634176*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.663432*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634464*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634608*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634752*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634896*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.663504*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}}, None}],
                GridLinesStyle->Directive[
                  GrayLevel[0.4, 0.5], 
                  AbsoluteThickness[1], 
                  AbsoluteDashing[{1, 2}]],
                ImagePadding->All,
                ImageSize->800,
                Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                    2][#]& )[
                    Part[#, 1]], 
                    (
                    Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                    2][#]& )[
                    Part[#, 2]]}& )}},
                
                PlotRange->{{3.6634248*^9, 3.6634977*^9}, {
                  0, 2592.2900010325}},
                PlotRangeClipping->True,
                PlotRangePadding->{{0, 0}, {
                   Scaled[0.02], 
                   Scaled[0.05]}},
                Ticks->{None, Automatic}]},
              {
               GraphicsBox[{{}, {{}, {}, 
                  {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                   0.003666666666666667], AbsoluteThickness[1.6], 
                   StyleBox[LineBox[CompressedData["
1:eJyl3Xn0XlV1//EdCB2QOUAIEDwYqEEZZNAwVLID7U9RIKCCWn/CBgzzTICA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                    "]],
                    FontSize->18]}}, {}},
                AspectRatio->NCache[
                  Rational[1, 3], 0.3333333333333333],
                Axes->{False, False},
                AxesLabel->{None, None},
                AxesOrigin->{3.6634248*^9, 4.68854331026179},
                DisplayFunction->Identity,
                Epilog->InsetBox[
                  BoxData[
                   FormBox[
                    StyleBox[
                    "\"Average power drain = 703.00 mW,  Min power drain = \
143.00 mW\"", FontFamily -> "Helvetica Neue", FontSize -> 16, Background -> 
                    Directive[
                    RGBColor[0.87, 0.94, 1], 
                    Opacity[0.5]], StripOnInput -> False], TraditionalForm]], 
                  
                  Scaled[{0.5, 0.9}]],
                Frame->{{True, True}, {True, True}},
                FrameLabel->{{
                   FormBox["\"Power Drain (mW)\"", TraditionalForm], None}, {
                   FormBox["\"Time\"", TraditionalForm], None}},
                FrameStyle->{{
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0.5], 
                    Thickness[0.001]], 
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0.85]]}, {
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0], 
                    Thickness[Large]], 
                   Directive[FontFamily -> "Helvetica Neue", FontSize -> 16, 
                    GrayLevel[0.45], 
                    Thickness[0.0035]]}},
                FrameTicks->FrontEndValueCache[{{{{5.298317366548036, 
                    FormBox["200", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.214608098422191, 
                    FormBox["500", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.907755278982137, 
                    FormBox["1000", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {7.600902459542082, 
                    FormBox["2000", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.517193191416238, 
                    FormBox["5000", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.605170185988092, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {5.0106352940962555`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {5.703782474656201, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {5.991464547107982, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.396929655216146, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.551080335043404, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.684611727667927, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.802394763324311, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {7.313220387090301, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.006367567650246, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.294049640102028, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.699514748210191, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.85366542803745, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.987196820661973, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {9.104979856318357, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {9.210340371976184, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}}, Automatic}, {
                   Charting`FindScaledTicks[
                    (Charting`getDateTicks[Automatic, {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    Automatic]& )[
                    SlotSequence[1]], {Identity, Identity}]& , 
                    Charting`ScaledFrameTicks[
                    (Charting`getDateTicks[
                    Charting`getDateTicks[Automatic, {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    Automatic]& , {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    None]& )[
                    SlotSequence[1]], {Identity, Identity}]& }}, {{{{
                    5.298317366548036, 
                    FormBox["200", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.214608098422191, 
                    FormBox["500", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.907755278982137, 
                    FormBox["1000", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {7.600902459542082, 
                    FormBox["2000", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.517193191416238, 
                    FormBox["5000", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.605170185988092, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {5.0106352940962555`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {5.703782474656201, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {5.991464547107982, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.396929655216146, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.551080335043404, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.684611727667927, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.802394763324311, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {7.313220387090301, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.006367567650246, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.294049640102028, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.699514748210191, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.85366542803745, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.987196820661973, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {9.104979856318357, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {9.210340371976184, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}}, Automatic}, {{{3.6634176*^9, 
                    FormBox["\"16:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox["\"20:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox["\"00:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox["\"04:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox["\"08:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox["\"12:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663504*^9, 
                    FormBox["\"16:00\"", TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634176*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634212*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634248*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634284*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634356*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634392*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634428*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.66345*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634536*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634572*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634644*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663468*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634716*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634788*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634824*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663486*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634932*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634968*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}}, {{3.6634176*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663504*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634176*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634212*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634248*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634284*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663432*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634356*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634392*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634428*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634464*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.66345*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634536*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634572*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634608*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634644*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663468*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634716*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634752*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634788*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634824*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.663486*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634896*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634932*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}, {3.6634968*^9, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0., 0.}]], TraditionalForm], {
                    0.008333333333333333, 0.}}}}}],
                GridLines->FrontEndValueCache[{Charting`ScaledTickValues[
                    ((Transpose[{#, 
                    Table[
                    Directive[
                    GrayLevel[0.4, 0.5], 
                    AbsoluteThickness[1], 
                    AbsoluteDashing[{1, 2}]], {
                    Length[#]}]}]& )[
                    Part[
                    Select[
                    (Charting`getDateTicks[Automatic, {Automatic}, 
                    (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                    Automatic]& )[
                    SlotSequence[1]], And[
                    FreeQ[#, 
                    Alternatives["", 
                    Spacer[{0, 0}]]], Head[#] === List, Length[#] > 0]& ], 
                    All, 1]]& )[
                    SlotSequence[1]], {Identity, Identity}]& , 
                   None}, {{{3.6634176*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.663432*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634464*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634608*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634752*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.6634896*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}, {3.663504*^9, 
                    Directive[
                    GrayLevel[0.4], 
                    Opacity[0.5], 
                    AbsoluteThickness[1.], 
                    AbsoluteDashing[{1., 2.}]]}}, None}],
                GridLinesStyle->Directive[
                  GrayLevel[0.4, 0.5], 
                  AbsoluteThickness[1], 
                  AbsoluteDashing[{1, 2}]],
                ImagePadding->All,
                ImageSize->800,
                Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                    (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
                    Part[#, 1]], 
                    (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                    (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
                    Part[#, 1]], 
                    (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
                    Part[#, 2]]}& )}},
                
                PlotRange->{{3.6634248*^9, 3.6634977*^9}, {4.752177754380559, 
                 8.69751328974428}},
                PlotRangeClipping->True,
                PlotRangePadding->{{0, 0}, {
                   Scaled[0.02], 
                   Scaled[0.05]}},
                Ticks->{None, {{5.298317366548036, 
                    FormBox["200", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.214608098422191, 
                    FormBox["500", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.907755278982137, 
                    FormBox["1000", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {7.600902459542082, 
                    FormBox["2000", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.517193191416238, 
                    FormBox["5000", TraditionalForm], {0.01, 0.}, {
                    AbsoluteThickness[0.1]}}, {4.605170185988092, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {5.0106352940962555`, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {5.703782474656201, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {5.991464547107982, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.396929655216146, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.551080335043404, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.684611727667927, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {6.802394763324311, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {7.313220387090301, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.006367567650246, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.294049640102028, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.699514748210191, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.85366542803745, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {8.987196820661973, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {9.104979856318357, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}, {9.210340371976184, 
                    FormBox[
                    InterpretationBox[
                    StyleBox[
                    
                    GraphicsBox[{}, ImageSize -> {0, 0}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                    Spacer[{0, 0}]], TraditionalForm], {0.005, 0.}, {
                    AbsoluteThickness[0.1]}}}}]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"], ",", 
           TagBox[
            TemplateBox[{"1"},
             "OutputSizeLimit`Skeleton",
             DisplayFunction->(FrameBox[
               
               RowBox[{
                "\" \[CenterEllipsis]\"", #, "\"\[CenterEllipsis] \""}], 
               Background -> GrayLevel[0.75], 
               BaseStyle -> {
                "Deploy", FontColor -> GrayLevel[1], FontSize -> Smaller, 
                 ShowStringCharacters -> False}, BaselinePosition -> Baseline,
                ContentPadding -> False, FrameMargins -> 1, FrameStyle -> 
               GrayLevel[0.75], RoundingRadius -> 7]& )],
            Function[BoxForm`e$, 
             TableForm[BoxForm`e$]]]}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          TagBox[
           TooltipBox[
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource[
                "FEStrings", "sizeBriefExplanation"], StandardForm],
               ImageSizeCache->{58., {2., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True], "SuggestionsBarCategory",
             StripOnInput->False],
            StyleBox[
             DynamicBox[
              ToBoxes[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
               StandardForm]], DynamicUpdating -> True, StripOnInput -> 
             False]],
           Annotation[#, 
            Style[
             Dynamic[
              FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
             DynamicUpdating -> True], "Tooltip"]& ], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{49., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True], "SuggestionsBarControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True], "SuggestionsBarControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, 25}],
           Appearance->None,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            Identity, 5, 16073013580903509368, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{54., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True], "SuggestionsBarControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True], "SuggestionsBarControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, 25}],
           Appearance->None,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            Identity, 5, 16073013580903509368, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{40., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True], "SuggestionsBarControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True], "SuggestionsBarControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, 25}],
           Appearance->None,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            Identity, 5, 16073013580903509368, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{72., {0., 8.}}],
              StripOnInput->False,
              DynamicUpdating->True], "SuggestionsBarControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True], "SuggestionsBarControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, 25}],
           Appearance->None,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Evaluation"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxDividers->{
      "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Background->RGBColor[0.9657, 0.9753, 0.9802],
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  Out[5]]], "Output",
 CellChangeTimes->{{3.66360614003274*^9, 3.6636061590089417`*^9}, {
   3.663606209018725*^9, 3.663606215087563*^9}, 3.663606253605259*^9, 
   3.663606511092807*^9, 3.663606671918131*^9, {3.663606803790187*^9, 
   3.663606819843483*^9}, 3.6636068503204727`*^9, {3.663676114514489*^9, 
   3.6636761535447617`*^9}, 3.6636762838562927`*^9, 3.663676329343245*^9, 
   3.6636765271056547`*^9, {3.663676673930872*^9, 3.663676696442473*^9}, {
   3.6636769055056047`*^9, 3.663676914809244*^9}, 3.663677051465884*^9, {
   3.663689668991865*^9, 3.6636896728536043`*^9}, {3.66368971946912*^9, 
   3.663689744883347*^9}, 3.663689790475026*^9, {3.663689864947348*^9, 
   3.6636898997263813`*^9}, 3.6637656137209587`*^9, 3.663766632324622*^9, 
   3.6637667274543324`*^9, 3.663766782759717*^9, 3.663768792840343*^9, 
   3.66376882996826*^9, 3.663768944683907*^9, 3.663769049186187*^9, 
   3.663769087062685*^9, {3.6637692617608843`*^9, 3.663769290850219*^9}, {
   3.663769394624487*^9, 3.6637694009493227`*^9}, 3.6637695001759567`*^9, {
   3.663769681445635*^9, 3.663769688716539*^9}, 3.6637964713434*^9, 
   3.6637976692234087`*^9, 3.6637977442944613`*^9, 3.6656912109311237`*^9, 
   3.665691297675972*^9, 3.665691397565627*^9, 3.665691545828093*^9, 
   3.6656918172493963`*^9, 3.665691925748026*^9, 3.665692054343275*^9, 
   3.665692191577286*^9, 3.665692276158354*^9, 3.665692337351604*^9, 
   3.665861601755662*^9, {3.6658616914431257`*^9, 3.665861738639428*^9}, {
   3.665861789570801*^9, 3.665861817333437*^9}, 3.6658619117827597`*^9, 
   3.665861973917478*^9, 3.665862059815319*^9, 3.66836488179589*^9, 
   3.668364996633565*^9, 3.668365110070573*^9}]
}, Open  ]]
},
WindowSize->{1612, 1155},
WindowMargins->{{Automatic, 52}, {Automatic, 0}},
FrontEndVersion->"10.4 for Mac OS X x86 (32-bit, 64-bit Kernel) (February 25, \
2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 871, 25, 155, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[1454, 49, 41800, 872, 2819, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[43291, 926, 1186, 22, 22, "Input"],
Cell[44480, 950, 308299, 6197, 1948, "Output"]
}, Open  ]]
}
]
*)

