package chromem

// testEmbeddings is a map of test embeddings generated using the following code:
//
//	 	e := NewEmbeddingFuncOllama("nomic-embed-text", os.Getenv("OLLAMA_HOST"))
//
//		ee := func(s string) []float32 {
//			v, err := e(context.Background(), s)
//			if err != nil {
//				panic(err)
//			}
//			return v
//		}
//
//		testEmbeddings := map[string][]float32{
//			"search_document: Village Builder Game": ee("search_document: Village Builder Game"),
//			"search_document: Town Craft Idle Game": ee("search_document: Town Craft Idle Game"),
//			"search_document: Some Idle Game":       ee("search_document: Some Idle Game"),
//			"search_query: town":                    ee("search_query: town"),
//			"search_query: idle":                    ee("search_query: idle"),
//		}
//
//		fmt.Printf("%#v\n", testEmbeddings)
var testEmbeddings = map[string][]float32{
	"search_document: Some Idle Game":       {-0.030154603, 0.030195612, -0.12823103, 0.030898588, 0.050629705, 0.012646387, -0.014282089, -0.06365065, 0.052573286, 0.051350065, -0.04757595, -0.049418602, 0.05074459, 0.026723435, -0.030359976, -0.05710062, -0.012207907, -0.032633048, -0.0020164147, 0.061639413, 0.002832647, -0.0013674701, -0.018252019, -0.029840985, -0.0256564, 0.03348028, -0.029109366, -0.036913063, -0.02780749, 0.011667834, -0.061122406, -0.011441236, 0.06917679, 0.0026889762, -0.021416632, -0.031190075, 0.06692096, -0.017994624, 0.045212973, -0.000561977, -0.018009407, 0.027140709, 0.030313617, 0.004503675, 0.07555065, -0.01580774, 0.10818457, 0.09766375, 0.004883599, -0.041021835, 0.0756117, -0.0036906446, -0.016220951, 0.0051204106, 0.0053927153, 0.014948957, 0.02876997, 0.01844221, 0.0410112, -0.05689992, 0.05362029, 0.038278148, -0.05209905, 0.0014984773, 0.021764431, -0.013090404, -0.0029681711, 0.024518974, 0.008435066, -0.046856012, 0.05753004, 0.0108039, 0.0001044795, 0.027657554, -0.020020869, 0.0020667133, 0.006552547, -0.053208508, 0.007802356, 0.042290088, -0.006635501, -0.0029867778, 0.058502585, -0.025332527, 0.06228107, -0.008927105, -0.035354167, -0.006825844, 0.012827875, 0.019803653, 0.054210044, 0.059875872, 0.056935117, 0.024361547, -0.08217618, 0.033005405, -0.07277288, -0.006809717, -0.041508693, -0.010979686, -0.037713487, 0.005156549, 0.046979018, -0.032246824, 0.072661236, -0.0066670952, -0.051820546, -0.026191458, -0.034292147, 0.014793393, -0.0072285323, 0.02770138, -0.023271495, -0.00022497393, 0.03458737, 0.019454844, 0.104497395, 0.0010962842, 0.05850324, 0.07458631, -0.046123933, 0.06617538, -0.047201034, 0.03645369, 0.03439897, 0.0018059863, -0.048746493, -0.0075947316, -0.0030790337, -0.030210812, 0.04849364, -0.012375484, 0.026944852, -0.033678707, -0.024433635, 0.05019666, -0.08552016, 0.010851229, 0.026589587, -0.020017875, 0.07052601, -0.060823083, -0.01982928, -0.0327663, -0.016004298, -0.010140277, 0.01035589, -0.025656076, -0.02140421, 0.0006850914, 0.048529115, -0.0044183508, 0.009728075, -0.024265477, 0.026225386, -0.026018135, -0.008632268, 0.048155192, 0.0071326536, -0.01890629, -0.012624594, 0.011425459, 0.02254408, 0.042119496, -0.033070445, -0.01321094, -0.0027786843, 0.036722362, 0.018643681, 0.01518625, -0.027761376, -0.06135186, 0.00032576948, 0.028463691, 0.058207083, 0.0033870973, 0.10104248, -0.01308774, 0.003295184, -0.0323643, -0.0015173398, -0.007341714, -0.0070282617, -0.019150397, -0.020003602, -0.047078453, 0.0808282, -0.02491708, -0.06310336, 0.018570257, -0.0239967, 0.043740258, -0.0059821936, -0.032152526, -0.012340436, -0.040689338, 0.05541477, 0.02228182, 0.03256402, -0.024288386, 0.016033655, -0.02100683, -0.035189327, -0.0038975957, -0.051503975, 0.07319589, -0.0068568066, 0.017561689, -0.030415233, -0.019628959, 0.066626, 0.005005764, -0.01914609, 0.045284517, -0.040027164, 0.0071253884, -0.04478423, 0.0017600333, -0.054342337, -0.002930127, 0.02861855, -0.040765718, -0.05011393, -0.0021230592, 0.025943592, 0.02977952, -0.018325472, 0.037446573, -0.00955656, 0.050462868, -0.07343357, -0.10271776, 0.03535897, -0.01705022, -0.01053073, -0.031382456, 0.024903562, 0.07624051, -0.012181765, 0.008203963, 0.023234537, -0.0064035817, 0.033346135, -0.002689279, -0.027488882, -0.005455607, 0.015597266, -0.037327684, 0.050537497, 0.019000154, 0.0051607704, 0.017059086, 0.036832787, 0.078980416, -0.012588388, -0.05778387, -0.0071665403, 0.030976487, 0.0378776, -0.007497358, 0.0010355219, -0.022235796, 0.040751223, 0.0032880718, 0.0066140187, -0.024090296, 0.017246542, -0.019378647, -0.023442697, -0.048387382, -0.06811305, 0.020932859, -0.044665698, 0.050676554, -0.008538648, -0.0026067677, 0.060425904, 0.012402312, -0.010422937, 0.021465076, 0.09279185, -0.04408491, -0.013567786, 0.05406919, -0.018072834, 0.020515487, 0.015063751, 0.025301434, 0.010841027, -0.02824234, -0.019680394, -0.031329148, 0.02743163, 0.05262418, -0.010296664, 0.0233829, 0.017972043, -0.047507435, -0.029173482, -0.03917908, -0.020006033, -0.019665318, 0.06491307, 0.036980543, 0.08733261, -0.047564592, 0.006183608, -0.034426555, 0.032860417, -0.0116071515, -0.04117477, -0.001353847, -0.0639456, 0.05090825, -0.078745015, 0.05977592, 0.009982638, 0.021126464, 0.05064296, -0.028570097, -0.025332058, -0.06296326, 0.024045348, -0.061128084, 0.04053844, 0.01916899, 0.074988104, -0.035467133, 0.0111645255, -0.053172037, 0.0029398727, 0.031247487, -0.048305314, -0.041886285, -0.015530706, 0.027307581, 0.018049944, 0.028279724, 0.0035687718, 0.016557762, 0.10167935, 0.019554175, -0.013109309, -0.043738853, -0.034655884, -0.06351678, 0.041276503, 0.009999499, 0.018068342, -0.041713793, -0.022732725, -0.03863146, -0.028177183, 0.0032319515, -0.030877471, -0.022580352, -0.019616727, -0.043272696, -0.005400302, 0.013578066, 0.057718903, -0.014296663, -0.006128255, -0.037806403, 0.025918486, -0.036248464, 0.013638012, 0.026955543, 0.0066868044, -0.040263187, 0.030127877, 0.031669635, 0.009632747, 0.061880067, 0.03993433, 0.020564128, -0.07354885, 0.016919218, -0.013004253, -0.021818895, 0.015605366, 0.020481743, 0.024804851, 0.018366762, 0.06720777, 0.005797526, 0.013512473, -0.00473763, -0.012625958, 0.0185854, 0.002493045, 0.022367207, -0.046193384, 0.013128169, -0.024109546, -0.016117666, 0.0071156165, 0.018045949, 0.04508955, 0.034263894, 0.0378441, -0.0189513, 0.018296938, 0.0156043535, 0.034159742, 0.08448487, -0.02149309, -0.08457276, -0.025986535, 0.019659646, -0.015393843, 0.02802826, -0.0048641944, 0.0033871075, -0.07613546, 0.05585835, 0.022264883, -0.044874474, -0.0364364, 0.056534965, 0.031797707, -0.003054437, -0.055993292, 0.042538505, -0.026770692, 0.026502028, 0.03735721, 0.053520985, -0.025223646, -0.04687008, -0.006063368, -0.0072266366, 0.021060353, -0.050130054, -0.017364811, -0.0243277, 0.03658787, 0.02707465, -0.02179494, -0.015005762, 0.006238601, -0.0030503504, 0.0022575832, -0.0073962095, -0.015083133, 0.085862964, 0.0077221002, 0.014902528, -0.0015059104, -0.02753026, 0.004047942, 0.028562058, -0.016845493, 0.013805198, 0.039028946, -0.024030754, -0.022273824, 0.010243438, -0.034527715, 0.029679991, 0.018008051, -0.008798528, 0.025780264, -0.022053063, -0.014451896, -0.039091393, 0.008149812, 0.0014862504, 0.009461612, 0.02678501, 0.006218473, 0.00082971505, 0.038281456, -0.021314304, -0.008417541, -0.03935901, -0.04787972, -0.010104341, 0.039223097, 0.010947359, -0.016757471, -0.06538577, -0.046271432, -0.0055255014, -0.0121626295, -0.05124009, 0.020830115, -0.018037582, 0.034400664, -0.030816015, 0.030854836, 0.04254804, 0.011991345, -0.006826725, -0.02863613, -0.040563114, -0.015598784, 0.049763042, 0.03337959, -0.039455768, 0.05829011, -0.007261786, -0.05519363, -0.03155281, 0.06900764, -0.045251578, -0.03116163, -0.06367534, -0.07992028, 0.025471628, -0.025711989, -0.005530079, -9.8817676e-05, 0.0265529, 0.01676765, 0.020656303, -0.015625043, -0.0368948, 0.0226108, -0.0177143, 0.05232805, 0.0014706784, -0.033632055, 0.021819659, -0.020551404, -0.028600698, -0.011389109, -0.008273288, 0.041249543, -0.029009173, 0.0063441186, -0.026170284, -0.050923496, 0.02851319, -0.0517965, -0.0061543584, -0.031133587, -0.018217817, 0.036865, 0.06445737, -0.0070230295, -0.009519725, 0.02859208, 0.017408943, -0.0023298885, -0.010133243, -0.025593692, 0.017884774, 0.025946131, -0.028491102, 0.0009805835, 0.0052531976, -0.0125175975, -0.048559796, -0.04082003, -0.04027376, 0.03428557, -0.019369284, -0.038173173, -0.032542273, -0.025082532, 0.023990223, 0.054953765, 0.012320858, -0.013020432, -0.0055862674, -0.022084516, 0.016842043, -0.01428209, 0.071285956, 0.002313891, -0.035587907, 0.014066745, 0.014433434, 0.044020314, -0.00062423974, 0.020445969, 0.0065047117, -0.049609926, 0.027213443, -0.025419636, -0.002912278, -0.023779124, 0.0013820962, -0.05237784, 0.08997243, -0.013085824, -0.01198904, 0.063360445, -0.04932236, 0.032435182, 0.021929769, -0.0039384314, -0.0005684949, 0.011613965, 0.030229673, -0.04370563, -0.00265056, -0.0020094053, -0.036210887, -0.002160752, -0.0026013781, 0.026952337, -0.052781366, 0.0027184896, 0.08785008, -0.00013569217, -0.007871463, 0.007818598, -0.056336407, -0.013965572, -0.0024930036, 0.02175222, -0.026812715, 0.004387716, -0.0366597, 0.00042916505, -0.024344739, -0.013389786, -0.026069716, -0.009184677, -0.050398212, 0.021363322, 0.0030059752, -0.014499812, 0.034113843, -0.11998729, -0.006709264, 0.06143105, -0.024371909, -0.012041226, 0.0013299867, -0.030669102, -0.04381771, -0.045938186, -0.015173891, -0.059362434, 0.03787684, -0.0070500174, 0.072143845, 0.036743473, -0.02245078, 0.0020957994, 0.015844414, 0.017887898, -0.014084667, 0.020896578, 0.054954324, 0.029189, -0.023767317, 0.061347887, 0.0589748, 0.0036561247, -0.040867962, -0.021249702, 0.054212112, 0.06528769, -0.08759768, -0.031467535, -0.01221302, 0.019283054, 0.021025216, -0.03555903, 0.09690508, -0.0133633325, 0.008239458, 0.021098455, -0.027727565, -0.094100684, -0.030349135, -0.013795178, 0.014171409, 0.0025101975, -0.020204782, 0.05721183, 0.015430371, 0.023352329, 0.0038415992, 0.0036115493, -0.039643094, -0.03475421, -0.027779054, 0.0634031, 0.005559416, -0.021519253, 0.0059780846, 0.011861707, -0.04706504, -0.01721216, -0.045666106, -0.06910662, -0.011309292, 0.020050842, -0.028090436, -0.041499287, 0.028093712, 0.0019265956, 0.015205728, -0.028259067, 0.018887352, -0.02004452, 0.016352529, 0.033935748, 0.01235759, -0.047194816, -0.017245721, 0.0046308427, -0.019899648, -0.0054703085, -0.000515077, 0.010681333, 0.007189812, 0.06526896, 0.022083392, -0.0036226986, 0.003770711, 0.017156541, -0.06176258, -0.04164345, 0.025303716, 0.02925995, 0.031340428, -0.04610391, -0.051078696, -0.0012506783, 0.015397997, 0.023262288, -0.047134485, 0.06468141, -0.021749275, -0.017273001, -0.0016663935, 0.013512976, 0.085765935, -0.0073835477, 0.0016883472, -0.03946862, -0.026233226, -0.035826515, -0.016183628, -0.003343937, 0.035177805, 0.058338437, 0.0062997057, 0.020054908, -0.042742394, 0.022190321, -0.04409155, 0.049273923, 0.038825553, -0.0322876, 0.025528017, -0.0025975266, 0.021754783, -0.073520124, -0.023005592, -0.017037068, 0.021312056, 0.014106891, 0.0018883465, -0.0021463796, 0.016163142, 0.017229982, 0.0064576534, -0.040032886, -0.009745224, -0.036809605, -0.025205394},
	"search_document: Town Craft Idle Game": {-0.08221178, 0.013711075, -0.16603628, 0.0031413732, 0.06521158, 0.020130044, -0.010523601, -0.08019578, 0.051290125, 0.016513709, -0.04816315, -0.03229022, 0.033440694, 0.012820052, -0.043775223, -0.07286668, -0.041014582, -0.04841479, -0.062390134, 0.033279113, 0.014979451, -0.0006653767, -0.005358742, -0.007385995, 0.009493428, 0.018579973, -0.02058751, 0.0061837905, -0.017811121, 0.028001908, -0.093906365, -0.027009796, 0.050302472, -0.012475321, -0.0033907292, -0.025975717, 0.041439153, -0.001688296, -0.0050732116, -0.020749785, -0.010140395, 0.03873643, 0.018395081, 0.00054546195, 0.08464173, -0.051343016, 0.06768904, 0.071056016, 0.014217889, -0.028558113, 0.055063244, -0.04552486, -0.011956733, 0.0014805732, -0.014802658, -0.009266932, 0.035844237, 0.002230387, 0.045943428, -0.041385703, -0.012051761, 0.08859178, -0.017104957, 0.049277045, 0.015839031, -0.015294277, -0.026744422, 0.06894337, 0.00070440193, -0.049994815, 0.05620514, -0.035435885, 0.03388826, 0.021877801, -0.030464448, 0.002540384, -0.016580457, -0.05936591, 0.06196792, -0.010712475, -0.009344829, 0.013217382, 0.047136653, -0.022913598, 0.027214078, -0.028457895, -0.023980996, 0.009149401, -0.006445396, 0.027442938, 0.024422027, 0.07107444, 0.030596731, 0.013329639, -0.059007302, 0.09408553, -0.036393113, -0.0066267857, -0.017476346, -0.013628112, -0.029087605, 0.0064471965, 0.062772825, -0.048634946, 0.062327903, 0.015600031, -0.049904022, -0.0070599136, -0.041083977, 0.035139065, 0.009092652, 0.034259398, -0.026033316, 0.0020532554, 0.009889318, 0.005895167, 0.11393547, 0.0069597205, 0.028776184, 0.06473982, -0.005321244, 0.023764607, -0.018583972, 0.029973568, 0.02612822, 0.023016246, -0.057554238, 0.005369849, -0.021755893, -0.04203724, 0.05245326, -0.025428578, 0.023580775, -0.019139517, -0.020656072, 0.051072612, -0.054574594, -0.018344846, 0.07141052, -0.017473938, 0.039982747, -0.06632828, -0.007561101, 0.0023047507, 0.010651617, -0.044556588, 0.02604049, -0.044372037, 0.007854193, 0.0072102966, 0.02621073, 0.0057675946, 0.004274856, 0.010995512, 0.04704843, -0.007752967, -0.023956636, 0.010279342, 0.019631391, -0.028320128, -0.010426674, -0.014727685, -0.01996797, 0.04167968, -0.026721902, -0.036768064, -0.0025211456, 0.04007303, -0.003669551, 0.018243194, -0.06873109, -0.05939209, 0.02552637, 0.047115777, 0.01389459, -0.010888809, 0.046053402, -0.0057662283, -0.008799256, -0.028645018, 0.029506711, -0.025249932, 0.033388793, 0.0060385023, -0.018129446, -0.029554104, 0.062252026, -0.023077887, -0.032631602, 0.022087699, -0.038545676, 0.050594367, -0.06510749, -0.07252533, -0.022941513, -0.056312997, 0.04436904, -0.0005418629, 0.014481463, -0.046701103, 0.016289465, -0.024254233, -0.015159931, 0.008652554, -0.054461867, 0.059669465, -0.0341536, 0.038974762, 0.009619097, -0.018305194, 0.08337864, -0.023645142, -0.035558015, 0.034795795, -0.057219952, -0.010584933, -0.061104983, -0.006959601, -0.06382588, -0.014011027, 0.04690233, -0.00841059, -0.057005268, -0.03805174, 0.014967966, -0.013867152, 0.018851832, 0.04514261, 0.006057179, 0.030091062, -0.05193046, -0.08306248, 0.0057449844, -0.02061122, 0.025694486, -0.008801346, 0.01177707, 0.072634555, 0.009069004, -0.01247274, 0.004630399, 0.047991667, 0.060419105, -0.004118102, -0.018899368, 0.016653795, 0.031334907, -0.0632201, 0.040228326, 0.004371195, -0.016366713, 0.019299299, 0.037358273, 0.034726076, -0.009876106, -0.02591556, -0.024331091, 0.04930914, 0.050856084, -0.023266954, 0.0013314117, -0.010180796, 0.050844815, 0.0024870634, 0.005544681, -0.0073681395, 0.010378298, 0.011534172, -0.012901754, -0.035986025, -0.03484104, 0.0029909648, -0.031300645, 0.01656727, -0.021772169, 0.008123298, 0.07690245, -0.0019482673, -0.019371966, 0.041669376, 0.035418008, -0.05810053, -0.004146582, 0.026023408, -0.037635095, 0.038874872, 0.01658907, 0.01408232, 0.0053755576, -0.008446202, -0.031031076, -0.02594646, 0.017439121, 0.055494986, -0.02622046, 0.045322366, 0.04769376, -0.054456968, -0.03440383, -0.015017259, -0.0073920395, -0.018988894, 0.09531209, 0.020768914, 0.055607393, -0.048544724, 0.04674156, -0.04466023, 0.037436318, 0.004854132, -0.066029154, -0.010117826, -0.06198789, 0.04433058, -0.0589958, 0.044158995, 0.026335662, 0.04280815, 0.019718653, -0.052024752, -0.01587497, -0.028101085, 0.035266973, -0.04074457, -0.016621308, 0.070119195, 0.062399052, -0.0128625035, -0.007997501, -0.050566513, 0.0091855675, 0.056975447, -0.0013978676, -0.04104137, 0.0097134495, 0.032309886, 0.029544925, 0.037118614, -0.0064950525, 0.01739384, 0.087193444, 0.027234182, 0.015237559, -0.028396111, -0.016947366, -0.06390283, -0.0024320579, 0.01414258, 0.008014547, -0.009451756, -0.049157817, -0.021027323, -0.0002312523, 0.0019651635, -0.017797196, -0.049493786, -0.03569541, -0.022327442, -0.0059683244, 0.015010484, 0.060793523, -0.042783987, -0.02640007, -0.04120622, 0.021194922, 0.002075773, 0.05186317, -0.012818319, 0.017916212, -0.054108612, 0.04029763, 0.029278893, -0.0029915387, 0.04013251, -0.0037811797, 0.023094758, -0.08317873, 0.030248195, -0.023036106, -0.027548177, 0.03722797, 0.0029047015, 0.017332468, 0.0136725465, 0.044130478, -0.04419598, -0.006159555, -0.009571718, -0.028191324, 0.0029057462, -0.0005150104, -0.0024044348, -0.039740704, 0.0020485302, -0.031731885, -0.048151836, 0.029802095, -0.013018741, 0.061980363, 0.02253544, 0.022726972, -0.042618543, 0.027334748, -0.010266213, 0.042385716, 0.060364954, -0.018887205, -0.07576836, 0.0021993977, 0.017752368, -0.008802775, 0.030660475, 0.00998929, -0.0079934, -0.05457834, 0.04409768, 0.06603662, -0.017226279, -0.032928087, 0.06434619, 0.027854836, 0.0072985706, -0.055016197, -0.0029216718, 0.006193608, 0.023449993, 0.032162108, 0.048428524, -0.020643294, -0.046674024, -0.030209549, 0.014621769, 0.004973117, -0.010417892, -0.0035226697, -0.042622697, 0.025745032, 0.0051144664, -0.0036082256, -0.022487544, -0.004007133, -0.027501643, -0.022270795, -0.016629213, -0.017985903, 0.07685321, 0.009403494, -0.000740091, -0.022390548, -0.018599333, 0.024301419, 0.04762997, 0.006453282, 0.054981582, 0.042218566, -0.020075314, -0.0148198875, -0.0008444825, -0.051178172, 0.011371164, 0.039725076, -0.010734458, -0.0018585456, -0.0271615, -0.014303163, -0.029687949, 0.0018881981, 0.011235353, 0.016897196, 0.03313501, 0.034044232, -0.018868744, 0.05469411, 0.02930615, -0.005584606, -0.019427408, -0.03775192, -0.0016742647, 0.06446533, 0.021962754, -0.010228813, -0.07979952, -0.068449564, -0.009207177, -0.046124723, -0.004117374, 0.039009564, 0.001347222, 0.041020412, -0.025031738, 0.02573547, 0.031303216, -0.012405116, 0.012263315, 0.00827744, -0.013124833, 0.011174668, 0.06869093, 0.004556629, -0.02265153, 0.032835867, -0.0041617174, -0.031561334, -0.0132947415, 0.06980857, -0.052343424, -0.04431588, -0.04876534, -0.064067245, 0.028919192, -0.019608544, -0.006741509, 0.032518025, 0.058229003, 0.043035626, 0.020370554, -0.02389532, -0.0457907, 0.007206269, 0.026257265, -0.0023287307, 0.011185927, -0.034069203, 0.012160358, -0.04420614, -0.0071722837, 0.0014287368, -0.021834232, 0.04818863, -0.017240863, 0.011597742, -0.020736722, -0.04738532, 0.043831825, -0.043202847, 0.0013369117, -0.07280612, -0.0017465476, 0.023520501, 0.03958023, -0.042663846, 0.0009830262, 0.015724316, -0.038818423, 0.017346112, -0.012874867, -0.029089728, 0.010329825, 0.019933986, -0.016736075, -0.0014950259, -0.017189479, 0.005060143, -0.097885765, -0.03873121, -0.0608528, 0.003024202, -0.01802449, -0.03532098, -0.05907766, -0.011670625, -0.006255797, 0.043775786, 0.025300143, 0.017773, -0.027360737, -0.0015081007, 0.014152613, 0.018615078, 0.058723785, 0.017496826, -0.047437157, 0.022989364, -0.012284, 0.03114525, -0.04397201, 0.028210366, 0.033441383, -0.037294105, 0.054953154, -0.011007953, -0.0020650048, -0.006684751, 0.009868164, -0.038653996, 0.057870097, 0.009046406, -0.0346497, 0.04988437, -0.044485886, -0.015007949, 0.021062534, 0.001120079, 0.005878968, 0.040645298, 0.06606878, -0.04731306, -0.024808094, 0.00754925, -0.036632165, -0.027839126, 0.018841533, -0.0029367334, -0.051468626, 0.0005720625, 0.09330539, -0.044009358, -0.0066009993, -0.01620037, -0.030386295, 0.002871882, 0.014473234, 0.043758325, -0.001590646, 0.00032827444, -0.001678374, 0.026477959, -0.016737113, -0.015778614, 0.01695769, 0.0057938984, -0.057782244, 0.021584991, 0.0073332353, 0.01428791, 0.013820988, -0.11106284, -0.015372253, 0.038591996, 0.049030505, -0.012162579, -0.005004551, -0.06625957, -0.05758143, -0.07757867, -0.014448379, -0.027451944, 0.03404355, -0.0180608, 0.053805027, 0.033894226, -0.0049463585, -0.009580315, 0.038703576, 0.06436689, -0.0005968403, 0.047838375, 0.06746952, 0.061139386, -0.02978099, 0.060045637, 0.08418128, 0.023045162, -0.02372869, 0.024401857, -0.0034399447, 0.038468592, -0.055903062, -0.060374215, 0.028734408, 0.04449562, 0.01787268, -0.02566525, 0.07366489, -0.010353494, 0.017070832, 0.013325927, -0.02290951, -0.07381586, -0.034496002, -0.0016867536, 0.0043494953, -0.015039587, -0.021324428, 0.053048283, 0.021838346, -0.03059385, 0.031305917, -0.01905112, -0.01881165, -0.032775924, -0.05448283, 0.0651594, 0.0048972648, 0.003867054, 0.016560074, 0.01714912, -0.058226984, 0.020605374, -0.047588546, -0.0179313, 0.012691798, -0.013554886, -0.034980703, -0.015470808, 0.0008560619, -0.0072641117, 0.008941878, -0.054591473, 0.010755579, -0.020056643, 0.034663852, 0.046797264, 0.021172581, -0.011598024, -0.008897855, 0.014890115, -0.02647986, -0.024989905, -0.012351741, 0.045711495, 0.008661212, 0.05145369, 0.00063495315, -0.017930808, 0.019366097, 0.01543367, -0.048664477, -0.016395772, 0.028898194, -0.0130926985, 0.008006767, -0.02284638, -0.06720912, -0.0073564323, -0.031250037, 0.010292608, -0.03299762, 0.05603527, -0.0069536893, -0.030741949, 0.004357384, 0.023598582, 0.06124061, -0.029299557, 0.015492626, -0.015170955, -0.041114118, -0.048179917, -0.02018515, 0.0025915748, 0.055117227, 0.069269165, 0.028611487, 0.020033741, -0.016575117, -0.0037579641, -0.0075374697, 0.052604765, 0.023472937, -0.02094099, 0.03625118, -0.004949966, -0.005271447, -0.06965622, 0.01303129, 0.004496516, 0.041412033, 0.032119736, -0.017789034, 0.012639504, 0.008782108, 0.01748084, 0.028890522, -0.028030688, -0.008372808, -0.0639308, -0.0030624904},
	"search_document: Village Builder Game": {-0.011795902, 0.0015122644, -0.11327332, 0.04299623, 0.026685124, 0.02418496, -0.051181618, -0.036304045, -0.009221343, 0.024336511, -0.037401825, -0.047852352, 0.065877765, 0.012628334, -0.041716866, -0.108850256, -0.07811421, -0.04226296, -0.009403902, 0.04079995, -0.022931034, -0.013311842, 0.039304867, 0.030882157, -0.0016801058, 0.01872543, 0.00077426096, 0.034087542, 0.018307243, -0.0064849844, -0.06405099, 0.025490629, 0.08251955, -0.05956977, 0.00491313, -0.02252783, -0.0008192528, -0.05209821, 0.016175786, -0.011276185, -0.06210509, 0.05120604, -0.045657326, -0.05225693, 0.0894914, 0.028268028, 0.13345546, 0.008001295, 0.01976544, -0.068658955, 0.018148268, -0.01763174, 0.012058565, -0.03125726, 0.004294161, 0.014189205, -0.03348558, 0.0007813454, 0.03509356, -0.029913213, 0.027405174, 0.088010676, -0.020509498, 0.0438946, -0.0015724011, -0.022015965, -0.010600875, 0.029943801, -0.018740172, -0.036371123, 0.03810554, -0.0044893925, 0.060967445, 0.035658598, -0.017889641, -0.04155874, -0.017653374, -0.038145065, 0.0024217304, 0.019580094, 0.020266872, -0.009646931, 0.04243236, 0.026226837, -6.569903e-05, -0.016299132, -0.039274983, 0.035395447, -0.060142376, 0.059978005, 0.014275249, 0.068151034, 0.039691195, 0.04160216, -0.13882153, 0.04230763, -0.059511267, -0.003167349, -0.00081454124, 0.010195602, -0.037019733, -0.021729333, 0.08272529, -0.014806303, 0.040559795, -0.0034244952, -0.055245757, 0.0017457445, -0.0064921593, -0.008111707, -0.001697896, 0.011755122, 0.0013201499, -0.036195293, 0.013563094, 0.010814507, 0.093582064, -0.0032594118, 0.024747854, 0.0018724005, -0.04177734, 0.008827836, -0.03682704, 0.06222094, -0.00899308, 0.044906855, -0.07239352, 0.013364548, 0.008760475, -0.023320388, 0.057686336, 0.023225004, 0.01196487, -0.02994865, -0.010418948, 0.087954804, -0.03785251, -0.0029030188, 0.074075945, 0.030553753, 0.07015798, -0.012188255, 0.003745392, -0.0035796158, 0.010637964, -0.013550266, 0.03533824, -0.014684414, -0.0061951275, -0.0068126144, 0.02457903, 0.0004554401, -0.012408631, -0.0046634106, 0.040615104, -0.010272162, -0.035897564, 0.06137449, 0.03810983, 0.03314062, 0.013563276, -0.02274725, 0.016563568, 0.04516349, -0.075272165, -0.029425409, -0.014273005, 0.031217271, 0.041725278, -0.021033896, -0.004347807, -0.054411065, 0.032422762, 0.04761515, 0.04720359, -0.03307693, 0.0077804094, -0.006008417, -0.013174526, -0.0076457546, 0.023631103, -0.00054911355, -0.01900774, 0.037585407, -0.021200918, -0.053821024, 0.060819846, -0.006805719, -0.029945502, -0.023058442, -0.08753254, 0.00036244644, -0.025926128, -0.040232833, 0.020298228, -0.039314758, 0.030562479, 0.03472449, 0.0063222223, -0.060820397, 0.004822298, 0.020083722, -0.018934138, -0.007826605, -0.026886499, 0.04079642, 0.01169575, 0.0009279647, -0.058159165, 0.008368726, 0.053401556, -0.047564145, -0.034619067, 0.008135751, 0.0029064084, -0.018748801, -0.060081776, -0.010785392, -0.060778774, -0.03833262, 0.030729996, 0.03499558, -0.073515534, -0.002161867, 0.047013734, 0.030997073, 0.01843075, 0.06489421, -0.0059764762, 0.024621025, -0.031861152, -0.121272795, -0.0034749906, -0.0042059636, -0.0016912948, 0.002074809, -0.011323896, 0.068401866, 0.016131446, -0.013479991, -0.013704861, 0.02280457, 0.051047564, -0.068847075, 0.017193569, -0.040311202, 0.026612623, -0.014886667, 0.035956547, 0.048250213, -0.019075185, 0.030888256, 0.034714546, 0.054056436, -0.009511885, -0.043893006, -0.037377417, -0.005876376, 0.037444193, -0.01582637, -0.010339755, 0.016113715, 0.058425754, -0.0016510473, 0.011963066, 0.02793446, 0.0136110755, -0.02309018, 0.0074232644, -0.020802628, -0.030603383, 0.039969034, -0.032828517, 0.027312335, -0.032358646, -0.050600424, 0.050636504, 0.0042172372, -0.016249986, 0.032587938, 0.060726825, -0.03574045, -0.026400995, 0.01030443, -0.0028744529, 0.03364059, -0.02355525, -0.012729509, 0.029879782, 0.035279825, -0.028109834, -0.020790359, 0.014011777, 0.018461814, 0.04600946, 0.06423593, 0.0017838081, -0.019278156, 0.0156169785, -0.033468306, -0.009442209, -0.01745776, 0.031513866, 0.019934572, 0.045346387, -0.015185955, 0.06231819, 0.0033955674, 0.043802973, -0.038549982, -0.06815678, 0.009157301, -0.051367205, -0.018995842, -0.08115339, 0.017014405, -0.0032484522, 0.06331745, -0.047584534, -0.027536077, -0.03526942, -0.003856633, 0.015004897, -0.06440919, -0.00039565182, 0.09566679, 0.032570545, 0.03438015, 0.022046821, -0.05293288, 0.014229009, 0.003244352, -0.037974242, -0.029494986, -0.022767456, 0.026109014, -0.025271146, 0.022562066, -0.0011645305, 0.04724137, 0.11973929, 0.01794927, -0.025842909, -0.03706194, -0.016295202, -0.021059824, 0.0065238615, 0.0027565327, 0.0014141891, -0.008723904, -0.019616807, -0.0058601024, -0.03261682, 0.017847074, -0.0048437663, 0.031682197, -0.03629719, 0.020077962, -0.0069928956, 0.016386282, 0.06489379, -0.03791757, -0.026339596, -0.018077517, -0.00023739849, -0.016409995, 0.035604063, 0.02179124, 0.03459157, -0.022392485, -0.004069147, 0.05731461, -0.0058976966, 0.09331884, 0.007169385, 0.02603857, -0.07189056, -0.0051908847, -0.009837258, -0.06490706, 0.064220764, 0.024220789, 0.03669637, 0.037741374, 0.00847554, -0.051166806, -0.024129894, 0.010281393, -0.0086824205, -0.05176164, -0.014810878, -0.024972277, -0.012798137, 0.01150963, -0.022422895, 0.021058498, 0.016759755, 0.018652502, 0.0438957, 0.018243585, -0.0146848885, -0.011500727, 0.03647528, -0.03271636, 0.046255555, 0.03571526, -0.02925335, -0.047904756, 0.016303688, 0.023409132, -0.017796861, 0.0804146, 0.032161158, -0.019863846, -0.043575432, 0.055513162, 0.029828606, -0.01756174, -0.04530735, 0.055082086, 0.020169325, 0.047059253, 0.0004204077, 0.009634815, 0.01878949, 0.0015860618, 0.019729108, 0.021004552, -0.015622159, -0.04381822, 0.014786569, 0.03550364, 0.03244945, -0.0032711062, -0.0072477595, -0.03926162, 0.0036432983, 0.027384963, 0.013102435, -0.008533226, -0.035167444, -0.025195695, 0.046428483, 0.0029997248, 0.02405353, 0.07208277, 0.003926896, 0.043164514, -0.029637238, 0.031279296, 0.034008987, 0.021603337, -0.014075552, -0.009750498, 0.019072006, 0.0027590338, -0.00061744853, -0.034242745, -0.020411406, 0.04376582, 0.025600905, -0.03497988, 0.02660987, -0.002908368, 0.001423843, -0.044166405, 0.039758172, -0.006798192, 0.042220306, 0.0074076103, -0.017779818, -0.017211784, 0.04617447, 0.053018987, -0.03231574, 0.018009108, -0.025325198, -0.028809618, 0.04886488, -0.05438523, -0.012331137, -0.062055234, -0.05509129, -0.04347179, -0.016846634, -0.0079454845, 0.021595238, -0.016237283, 0.022891367, -0.009939415, 0.037318908, 0.025597166, 0.008448253, 0.010392823, 0.007517561, -0.06859245, 0.007891427, 0.04871947, 0.053034756, -0.00024512754, 0.062216826, -0.029059416, -0.027487574, 0.025327535, 0.048399575, -0.044354875, 0.011974205, -0.024238216, -0.05254269, -0.0017347402, -0.019302884, 0.002735727, 0.019988643, -0.04306317, -0.00023340507, -0.0020591966, -0.0105948895, -0.030606287, -0.0024833118, 0.029387776, -0.0011626354, -0.012534435, -0.062106684, -0.008046949, -0.069291994, 0.021756275, 0.038455144, -0.061624683, 0.03599847, -0.04329853, 0.0046065757, -0.055978086, -0.011207698, 0.025906632, -0.03090631, 0.020176776, -0.035504673, -0.003965206, 0.035325885, 0.05083146, 0.0037519722, 0.0017067104, 0.029258242, -0.020265874, 0.028881297, -0.019626334, -0.028021792, -0.023987649, 0.013164258, 0.018508464, -0.012206851, 0.037541382, -0.01480085, -0.05658713, -0.0010803803, -0.060797196, 0.052733146, -0.015286501, -0.04534778, -0.044580694, 0.008223525, -0.034007266, 0.04558869, 0.010746387, 0.043651443, -0.034927163, -0.0399495, 0.01103228, -0.008217593, 0.03690584, 0.028268192, -0.03874009, 0.018584719, -0.02439686, 0.02243326, -0.02903582, 0.009648095, -0.018480487, -0.017323606, 0.073825836, -0.042624164, -0.028040713, -0.039574727, -0.02126485, -0.058649544, 0.045151547, -0.017099762, -0.04148583, -0.007253619, -0.0020392027, 0.0017629926, 0.05669342, -0.020850709, 0.018829677, 0.036518857, 0.021758523, -0.058556195, 0.008297656, 0.005559023, -0.034261927, -0.022037514, -0.0063427696, 0.0008890332, -0.030820997, -0.010839713, 0.06917083, -0.03783174, 0.05630486, -0.010312241, -0.060898423, -0.028832795, 0.052920315, 0.016014475, -0.046726637, 0.050411724, -0.026260013, 0.017813787, -0.022205079, 0.008420697, -0.03987712, 0.00081622525, -0.053565875, 0.01912345, -0.030481428, 0.043521427, 0.043935068, -0.09778194, -0.023773404, 0.04732399, 0.049096897, -0.039776895, -0.001381255, -0.0018920989, -0.06056998, -0.02847735, 0.014903962, -0.005403712, 0.050606396, 0.013597915, 0.058945, 0.027373914, -0.019463986, -0.014004842, 0.045733348, 0.08059248, -0.0004037868, -0.0060666665, -0.0018859202, -0.0004169904, -0.023048267, 0.054939564, 0.06708768, -0.016954402, -0.060821965, 0.007936912, 0.008969611, 0.03255382, -0.05578106, -0.017191311, 0.031162508, -0.00043828398, -0.04954302, -0.009738197, 0.04149539, 0.030139275, 0.025777863, 0.023162648, -0.024248442, -0.05227215, -0.05912876, 0.011144076, -0.0063733305, -0.048439324, 0.000717847, 0.05365679, 0.00030706724, -0.025395807, 0.039486047, 8.616784e-05, -0.02559674, -0.02057398, 0.0151732955, 0.016931813, -0.021176772, -0.028733086, 0.01051267, 0.011136879, -0.050006036, -0.004658769, -0.07251455, -0.026636047, -0.007895616, -0.0055513554, -0.060538184, -0.034533463, 0.023457455, 0.025008086, 0.0060435035, -0.025308495, 0.040073223, -0.017461862, 0.0068223295, 0.012629245, -0.002397842, -0.033527892, -0.029001776, -0.058925617, -0.034765106, -0.007301114, 0.0019297221, 0.043619614, 0.011421012, 0.06891985, 0.010476217, -0.051609, 0.027969727, -0.024506034, -0.06442927, -0.038310207, 0.015805874, 0.02999943, -0.0034120928, -0.021359963, -0.005803494, -0.030762663, -0.03459296, -0.0131239, -0.01664574, 0.06336453, -0.004629854, -0.0010004531, 0.033388384, -0.006764447, 0.047076315, -0.030923411, 0.03783327, -0.04006314, -0.012435112, -0.014175485, -0.016249655, 0.019931648, 0.07209866, 0.06027955, 0.03214192, -0.0004099548, -0.021656284, -0.04515469, -0.022763498, 0.029167809, 0.020834913, 0.0041377805, 0.0002320124, 0.0081730895, -0.01190515, -0.083704956, 0.016395405, -0.017894465, 0.045466863, 0.03244109, 0.024005758, 0.015937712, 0.0011129525, 0.036843654, 0.02314543, -0.028323201, -0.006969554, -0.072801016, -0.01902862},
	"search_query: idle":                    {-0.05485274, 0.048303213, -0.15870969, -0.01727909, 0.02204218, -0.026585577, 0.02488365, -0.023101956, 0.05220942, -0.0062007653, -0.006806396, 0.009586779, -0.031092405, 0.03422235, -0.012816562, 0.011738247, 0.010806439, -0.030268295, -0.046658456, 0.01929168, -0.0033956154, -0.012025436, 0.020126915, -0.02107534, 0.014546054, 0.028719706, -0.0073397555, -0.04273335, 0.008376701, 0.053669892, -0.022368306, -0.016012836, 0.031869207, 0.047413804, -0.03364853, -0.012760571, 0.083659135, 0.0008153498, 0.04238332, 6.112658e-05, -0.026062118, 6.544284e-05, 0.052479148, 0.04034013, 0.055061847, -0.024968622, 0.076086074, 0.07892021, -0.0067479373, -0.008754067, 0.021316472, 0.008501664, -0.03956676, 0.02958982, 0.06334076, 0.013850105, 0.05378269, 0.022977874, -0.01892463, -0.016205147, -0.018914333, -0.041482292, 0.012653901, 0.0553854, 0.044220448, -0.046934802, 0.012108219, 0.0042785397, 0.0128026, -0.049999513, 0.014039361, -0.022237666, 0.014503823, 0.021539455, -0.023539143, 0.057871282, 0.02030326, -0.04298601, 0.027171548, 0.012371623, 0.00517782, -0.0024928995, 0.0789687, -0.048221264, 0.031144405, -0.06956162, 0.01830079, -0.0074620564, -0.013008592, 0.017821237, 0.05205483, 0.0026095856, 0.033478267, 0.0024071883, 0.031339943, 0.03805118, -0.018747607, 0.013855691, -0.02328109, -0.020979173, -0.043442737, -0.02786705, 0.0012479522, -0.03284346, 0.055916596, -0.023786593, -0.07297429, 0.00027096545, -0.04955385, 0.021904573, 7.258958e-05, 0.0327809, -0.026283747, -0.0057326853, 0.057586413, -0.01450672, 0.09774403, 0.0057728966, 0.06439862, 0.016539732, -0.023903608, 0.012078497, -0.015667, -0.031435687, 0.063262835, 0.011070095, -0.0153285405, -0.050456434, -0.034164514, -0.03550744, 0.05877547, 0.012209024, -0.03712036, -0.027399387, 0.0011022816, -0.021232521, -0.035736, -0.05921348, -0.0013294148, 0.009508861, 0.019329231, -0.05284091, -0.004944139, -0.07210281, -0.03259032, -0.05860288, 0.06323055, -0.05214842, 0.0054531274, -0.029615508, 0.008434825, -0.015101546, -0.002049018, 0.0033364268, 0.027130514, -0.02765185, -0.032429587, 0.0058020116, 0.02868368, -0.008544621, -0.024280237, 0.020866271, 0.018041525, -0.004987599, 0.017589577, -0.03514576, -0.020354215, 0.036263652, 0.0097657535, -0.0110538, -0.058397986, -0.054988675, -0.005885807, -0.01521125, -0.012591495, 0.0040771095, 0.07848713, -0.023244178, -0.0034358285, -0.041823972, 0.024640163, -0.036791828, 0.050987843, -0.05715628, -0.016025878, -0.0049183555, 0.029018132, -0.010202122, -0.030434387, 0.038118023, 0.024840532, 0.042656157, -0.042087257, -0.040181167, -0.0010036782, -0.03394452, 0.06249457, -0.0008142238, -0.00043656075, -0.06404502, 0.019424696, -0.060490582, -0.021306187, 0.0055486155, -0.041632578, 0.041519903, -0.033941183, 0.044893395, 0.0064206673, -0.0402632, 0.13008368, 0.070558466, -0.018393623, 0.038306735, 0.013471811, -0.053691577, -0.027106889, -0.030490689, 0.00047219932, 0.010500146, 0.053602047, -0.037241675, -0.018295782, -0.02476373, 0.04926056, -0.03965382, -0.03748434, -0.013747244, -0.011040143, 0.043043006, -0.053964477, -0.10495711, 0.032153577, 0.052563377, -0.0061727893, -0.025000684, 0.024730802, 0.11933335, -0.0197645, -0.010459339, 0.033537306, 0.03449919, 0.015091422, 0.004103631, -0.018284434, 0.027802534, 0.010390245, -0.05532084, -0.011071515, -0.015250362, 0.0069046733, 0.01833439, 0.02058625, 0.034866303, 0.011567638, -0.040895976, -0.02826694, 0.0007671626, 0.04262942, -0.008167711, 0.013662254, -0.033900615, 0.026319714, 0.013045778, 0.020473417, -0.024846954, 0.0443266, -0.022026435, -0.023192137, -0.064776495, -0.02514201, 0.013490392, -0.006872679, 0.020894006, -0.02707439, 0.01753138, 0.06743259, -0.002603971, -0.053577192, 0.046802267, 0.023911705, -0.02251413, 0.031739615, 0.09979972, -0.03817435, 0.029529741, 0.045053065, -0.0001981939, 0.044544272, -0.046199363, 0.02202639, -0.0142875565, -0.03592033, 0.08626654, -0.0774512, -0.018600777, 0.053361394, -0.0402608, -0.010529132, -0.0754515, 0.013400737, 0.015259319, 0.08461849, 0.02997977, 0.036805972, -0.0645533, -0.014586065, -0.04208852, 0.012653307, -0.0034262496, -0.032094214, -0.0037387372, -0.08450896, 0.03662638, -0.05239079, 0.066748224, 0.0039074305, -0.063468054, 0.04860961, -0.033236954, 0.009198693, -0.06563092, 0.00073724997, 0.01094799, 0.014793084, -0.0026865492, 0.048671316, -0.05891399, -0.052761354, 0.017935004, 0.024127085, 0.04785253, -0.002977286, -0.024215404, -0.0012454885, 0.033014853, 0.020301206, 0.021886112, -0.010710626, 0.028501922, 0.0079588685, 0.040621195, 0.018229399, 0.0007772567, -0.044114675, -0.005250787, -0.02928078, -0.0059154136, 0.015263119, 0.0198703, -0.013111124, -0.015137984, 0.01537037, -0.005187548, -0.027159058, -0.019756667, -0.009047851, -0.034264192, 0.0008044173, 0.00696249, 0.039906763, -0.030897303, -0.0015832008, -0.07244838, 0.02893534, -0.0039934414, -0.008211175, -0.031597618, 0.013266993, -0.038057733, 0.015185627, -0.022604493, 0.0028162163, -0.00052201416, -0.006395029, 0.025642926, 0.0163034, -0.000950779, -0.021402178, 0.032591544, 0.007141421, -0.042479385, -0.011684697, 0.01655931, 0.072299436, 0.038444597, -0.00090406655, -0.025083024, 0.0012939515, 0.033811916, 0.011038112, 0.015514186, -0.020946804, 0.012818288, 0.013657979, -0.056089282, 0.014641998, -0.008559855, 0.003965464, 0.085839964, -0.0012935663, -0.036945213, -0.030727992, 0.0065748007, -0.00022002465, 0.026636116, -0.03260789, -0.06405133, 0.023345696, -0.0011249329, -0.0018881401, 0.0076306215, 0.021281565, -0.012981237, -0.023136953, 0.018018078, 0.053401146, -0.030807212, 0.03341478, 0.042854887, 0.027907485, 0.014727508, -0.06380277, 0.008001611, -0.049156234, 0.029653367, 0.037458766, 0.047287267, -0.022445293, -0.037419286, 0.01215866, 0.0132495025, 0.008382316, -0.00021430614, 0.00021231793, -0.05010844, 0.10353604, 0.015645439, -0.023418464, 0.034666438, 0.024020696, -0.017977325, -0.011493535, -0.016942233, 0.025914172, 0.04014282, 0.07544756, -0.035433337, -0.010256953, -0.036735218, 0.032564145, 0.033385836, -0.018055215, 0.06502402, 0.06203427, -0.046286963, -0.04473755, 0.012261086, -0.03573326, -0.0031265265, -0.038526185, -0.0006325177, -0.029264439, 0.013361144, -0.028266795, 0.023088692, 0.021318408, 0.013801645, -0.030896429, 0.07260062, 0.04008774, 0.019077297, 0.015496125, -0.039256275, -0.05074026, -0.03922955, -0.013691038, 0.042602353, 0.041070275, 0.086819716, -0.0063701184, -0.03269867, -0.0074118045, 0.013271905, 0.03972008, -0.03196555, 0.040587477, -0.03128911, 0.0051292847, -0.019421613, 0.012239594, 0.064469285, -0.03225388, 0.017992279, 0.002826381, 0.008678835, 0.0024938527, -0.0030310266, -0.040226698, -0.016654246, 0.021100095, 0.04867212, -0.011700447, -0.009329873, 0.04483318, -0.033180088, -0.006144154, -0.06334689, -0.06647646, 0.03888736, 0.017256195, -0.0024688877, -0.026636306, 0.08752831, 0.027939128, 0.007143004, 0.010952593, -0.05317306, 0.009222684, 0.029671269, 0.03361775, -0.032567978, -0.036144547, 0.014189695, -0.002368752, -0.0061836736, -0.026267447, 0.017785178, 0.07635495, -0.015393801, -0.010522437, -0.034545638, -0.04550828, -0.0012180192, -0.02252612, 0.019017778, -0.058240775, 0.018455865, 0.010091423, 0.03949685, -0.012873163, -0.01638756, -0.02206694, -0.020746805, -0.031677578, -0.0035064665, -0.04554861, 0.019529298, 0.0045493073, -0.046547674, 0.024859224, -0.026042322, 0.017597154, -0.061450277, -0.02340508, -0.030395325, 0.022105116, -0.01779878, -0.03811177, -0.021348441, -0.058706533, 0.02011604, 0.10055368, 0.050538808, -0.015370502, -0.036871992, 0.048438054, 0.03067543, -0.031780273, 0.02648936, 0.009421199, 0.0001490816, 0.044021577, 0.042022694, 0.04315632, -0.022386214, -0.011650321, 0.04522964, -0.08015112, 0.021519842, -0.044975583, -0.01803848, 0.05970829, 0.07470008, -0.024249822, 0.07216412, -0.01716787, -0.023350608, 0.0139646465, -0.04510321, -0.011338803, 0.012131692, -0.0070663714, -0.043631013, 0.039247364, 0.023626653, -0.04977863, -0.07876858, -0.010241464, -0.024455331, -0.041201454, 0.007079584, -0.018950239, -0.09376659, -0.00867128, 0.05076838, 0.0042416197, -0.04955642, -0.032362863, 0.007857514, -0.010096338, -0.020717913, 0.0725342, -0.023753492, -0.009431451, -0.004304705, 0.04189865, -0.019951262, -0.011602778, 0.07675994, -0.028212296, -0.015477315, 0.011035552, -0.018959276, -0.028342154, -0.030020483, -0.06421331, -0.042562645, 0.022104563, -0.010162739, -0.043313254, 0.007748606, -0.05517643, -0.0051312214, -0.04917804, -0.049315345, -0.0663556, 0.05054696, -0.00654479, 0.03717245, -0.0030289816, 0.010487645, -0.024252702, 0.029340334, 0.0044431044, -0.04770899, 0.058380604, 0.080912985, 0.077500544, -0.0169687, 0.051046293, 0.037462465, 0.030052638, -0.0085213175, 0.004813183, 0.043660365, 0.0062108296, -0.056903955, -0.044623945, -0.036009423, 0.048186548, 0.015618811, -0.0107604265, 0.053337153, -0.008608424, 0.0026117768, 0.010510008, 0.022953417, -0.037593886, -0.02000332, -0.023795428, -0.0068581277, -0.0013113408, -0.039511863, -0.0054353103, 0.048442446, -0.003515304, -0.014571488, 0.015997004, -0.018810544, 0.0046368083, -0.06422449, 0.05383265, 0.021331355, 0.011323866, 0.043946713, 0.0230135, -0.04467501, -0.036300812, -0.03385468, -0.04140132, 0.019596932, -0.036931414, -0.027069448, -0.058831967, 0.028331464, -5.012732e-05, -0.0076386244, -0.02930139, 0.010130394, -0.043858476, 0.005860953, 0.04376421, 0.032491956, -0.058442663, -0.004569089, 0.10842106, 0.014825701, -0.005286689, -0.025528828, 0.01627874, 0.016973408, 0.026232889, 0.00900286, 0.023408717, 0.034842044, 0.032003444, -0.026816322, -0.024530103, 0.08944392, 0.049115404, 0.004075527, -0.039532084, -0.037919417, 0.030594213, -0.0029820413, 0.02363422, 0.0019509519, 0.037761766, -0.026620748, -0.004082833, -0.008598264, 0.022881992, 0.026963618, 0.0034613365, 0.0092547545, 0.0314722, 0.008213602, -0.040225197, -0.021224573, -0.001942692, 0.022240378, 0.024005625, 0.015655898, -0.0023246286, -0.04702865, 0.0013105841, -0.045750394, -0.01583296, 0.006735376, 0.025138525, -0.019134713, -0.03244419, -0.034759752, -0.013690875, -0.026435765, 0.027135225, 0.036105156, 0.034930207, 0.02196556, -0.011868152, -0.015957227, -0.037999626, 0.013756468, -0.013544102, -0.05098671, -0.0013236853, -0.007398489},
	"search_query: town":                    {-0.07546274, -0.0033769303, -0.12613828, -0.009038829, 0.027405983, -0.011684983, -0.016917007, 0.01685167, 0.022609906, -0.02291727, -0.014133508, -0.028324915, 0.06656532, -0.032913566, -0.083562374, -0.09732427, 0.015721874, -0.0044610114, 0.014742268, 0.07627295, 0.05248064, 0.05147308, 0.03699674, 0.021220742, 0.036337174, 0.00065148826, 0.050164934, 0.021020206, 0.04367954, -0.015269213, -0.027936155, -0.0007900782, 0.0035478848, 0.0053581228, -0.006411488, -0.03806379, -0.042310614, 0.0006665187, -0.001028423, -0.033374876, 0.006528987, -0.03340723, -0.031740867, -0.03218306, 0.02366486, -0.04838308, -0.024583362, 0.04384207, -0.010286792, -0.03644608, -0.02493498, -0.042594906, -0.02597975, -0.0026901567, 0.019850811, -0.008235088, 0.07394819, 0.0010413012, 0.023854256, 0.018545033, 0.021422358, 0.09137913, 0.0031343517, 0.07454994, 0.030651279, -0.028506864, -0.012136896, 0.02323758, 0.033015437, -0.045552544, 0.03888889, -0.023560466, -0.009507116, 0.01795087, -0.008440198, 0.003830878, 0.0022241944, -0.017672583, 0.050454263, -0.05309472, 0.028172802, -0.04567113, 0.0110001005, 0.020040503, -0.047970854, -0.045826033, 0.008678374, 0.019554503, -0.012163797, 0.02420758, 0.009380367, 0.048029795, 0.017550826, 0.020817928, -0.025374915, 0.05821115, -0.041653786, 0.015427728, 0.0019563425, 0.024341919, -0.070048146, -0.006637607, 0.020254761, 0.029700391, 0.0687317, 0.00824851, -0.02411405, 0.0016233212, 0.017154075, -0.00367832, -0.008977091, -0.014277096, -0.021735167, -0.026358923, 0.010128086, -0.020368954, 0.09821831, -0.007879761, -0.0060611307, 0.06400145, 0.0033384918, 0.014929699, 0.035556864, 0.04563328, -0.0033323653, 0.0066113514, -0.05915381, -0.012741731, -0.018876903, 0.004226921, -0.053115726, -0.029675897, -0.025033835, 0.0027760998, -0.015671533, 0.08950337, 0.014711195, -0.01826545, 0.036585964, -0.03469281, 0.021630568, -0.0070748953, 0.04825354, 0.05236917, 0.0049637067, -0.048881836, 0.046253525, -0.07346171, 0.013667462, 0.0334444, 0.046061095, 0.020327717, 0.0058826017, 0.048770577, 0.049050584, -0.025963198, 0.042632643, 0.0344417, 0.0083730165, 0.001350872, 0.022297602, -0.004681657, -0.03646012, 0.0045517227, -0.009378569, -0.060424417, 0.012677689, 0.023179645, 0.009050965, -0.010970491, -0.09310712, -0.021870488, 0.043447, 0.035765335, -0.04998683, -0.09086048, -0.01627404, 0.01384697, -0.0047953655, 0.009694022, 0.115377866, -0.046560332, -0.0030585283, -0.033673033, -0.022503657, -0.026333105, 0.031917218, -0.07414978, -0.030196672, -0.01629758, -0.0708254, 0.019006955, -0.07235644, -0.04691187, -0.0033603848, -0.06239748, 0.032454003, 0.0208299, 0.018050918, 0.0064613065, -0.0044237715, -0.03590778, -0.025140813, 0.02689116, 0.0020134083, -0.004570849, -0.04667069, 0.03442872, -0.03042646, 0.009813611, 0.0076491158, -0.014014932, 0.00021977961, 0.059101585, 0.008811024, -0.022209128, 0.013497327, -0.035696007, -0.06452451, -0.032840967, 0.06308479, 0.050498843, -0.049552646, -0.0350805, 0.009524945, -0.029064657, 0.056354824, 0.03171222, 0.034848943, -0.041008003, -0.03900498, 0.02141472, -7.955665e-05, -0.014881879, 0.021567099, 0.06146474, -0.036341228, -0.03677803, 0.03545187, -0.024247691, -0.02033515, 0.02227725, 0.020785097, -0.10419201, 0.006642108, -0.023689605, 0.04412717, -0.057688966, 0.05653751, -0.024097005, -0.053457968, 0.023204356, 0.011899003, -0.003828608, 0.07811993, -0.005291204, -0.073229425, 0.07857385, -0.022192394, 0.0051375837, -0.027745452, -0.0407934, 0.046808332, -0.054095473, 0.036005933, 0.024042964, -0.00842125, 0.018553972, -0.007896965, -0.05463717, -0.017275898, 0.041752864, 0.0004391933, -0.0010419769, -0.035905194, 0.020173596, -0.00041927467, 0.009061003, -0.042458795, 0.013867603, -0.030697946, 0.0047876085, 0.019300882, -0.013553154, -0.050311495, 0.012590732, -0.0039169537, -0.018671673, -0.014144613, -0.00021464935, -0.007461135, 0.0415473, -0.025830476, 0.02966769, -0.018401463, 0.03179658, 0.026201304, 0.035583958, -0.010342264, -0.011610109, 0.0034805327, -0.042561773, 0.07362176, 0.0022193089, 0.04320002, 0.022233406, 0.0065876916, -0.020924687, -0.03913832, 0.02033908, -0.027355446, -0.0070531885, -0.037077885, -0.032287452, -0.04882372, 0.055332437, 0.0022710357, 0.05323722, 0.026280794, -0.028066736, 0.0045597428, -0.033130053, -0.017663365, -0.0026252577, -0.04783653, 0.026513495, 0.059932202, 0.03646257, 0.008484059, -0.03753155, 0.05706445, -0.026717087, -0.0046152663, -0.03040637, 0.010327006, 0.023974424, -0.013227647, 0.03156303, -0.0002774503, 0.064638756, 0.051833827, 0.044898365, -0.024854455, -0.028523328, 0.026404997, 0.005498055, -0.006117299, 0.014367374, 0.043418825, -0.039796554, -0.02512765, 0.0026839268, 0.018488016, 0.033463545, -0.03459118, 0.002276716, 0.03159293, -0.006274893, 0.015899662, -0.010689339, 0.044018768, -0.048010822, -0.003269837, 0.022660399, 0.010701392, 0.00603141, 0.09282029, 0.006113766, 0.03730205, -0.03856609, -0.0060633677, 0.0014654874, 0.018523797, 0.026234848, 0.048786044, -0.01824688, -0.07007422, 0.056664847, -0.038001634, 0.009526431, -0.018953547, 0.014557438, -0.038425025, 0.0014091688, 0.0034832673, -0.05812851, 0.030884415, -0.051744215, 0.011106806, -0.01894899, 0.0035699864, -0.011427583, 0.005626723, -0.05150667, -0.02544028, -0.04915617, 0.07661266, -0.03779201, -0.0066912496, -0.017140066, -0.03774014, 0.010929636, -0.025170103, 0.011065124, 0.029718656, -0.0072285724, -0.037952393, -0.034093548, 0.055156328, -0.0084050065, 0.017710118, 0.034948483, -0.0065101543, -0.041220643, -0.072144285, 0.047936548, 0.06497897, -0.023147892, -0.0045909057, 0.030809183, 0.07566728, 0.040941358, -0.036716364, -0.049722433, -0.028940389, 0.020805296, 0.019621726, 0.0062338095, -0.034261465, -0.03757604, -0.019996084, 0.04250759, 0.005552394, 0.010516166, -0.020365337, -0.017710019, 0.023509221, -0.007360573, 0.048761383, -0.020697268, 0.0056934524, -0.005216197, 0.0109891975, -0.023982177, -0.024959303, 0.0008826181, 0.058880083, -0.01769441, -0.053690992, 0.014909066, 0.0065132794, -0.008003804, 0.008387353, -0.0019505488, 0.016438255, 0.005485379, -4.2173266e-05, -0.04661501, 0.0035839912, -0.03628588, -0.00613076, -0.020875804, -0.013146508, -0.024315089, -0.026655493, -0.038989265, 0.013013506, 0.01919119, -0.0027662707, 0.021937767, 0.04439493, -0.023550658, 0.03867915, 0.01881437, 0.013913632, 0.024921944, 0.010637103, 0.0059254165, 0.0072600497, 0.03191947, 0.037185483, -0.037664104, -0.044192296, -0.05610635, -0.023040513, 0.00818894, 0.08787503, 0.0027700388, 0.015521082, -0.051280312, -0.008215518, -0.021070521, 0.0038188084, 0.0026327984, 0.04838154, -0.060094252, 0.01880663, 0.050920606, -0.06897046, -0.0139923785, -0.02289227, -0.01034361, 0.008158672, -0.01920664, 0.03725428, -0.0009330746, -0.012041084, -0.023233622, -0.054103058, -0.0010192646, -0.05756866, 0.014200193, 0.02345327, 0.02300079, 0.053966153, 0.026703035, -0.0037309339, 0.0016168134, -0.0075885104, 0.0514792, -0.052043244, 0.016194144, 0.017287325, -0.06198996, -0.06174642, 0.04216839, 2.7298724e-05, -0.03573357, 0.058679756, -0.034265418, -0.04523764, 0.011104517, 0.05245985, 0.069612645, -0.049255684, 0.037429094, -0.0393492, 0.048621956, 0.037893392, 0.029456904, -0.06802704, -0.052427284, -0.012780587, -0.042144142, 0.04364917, -0.0034175578, -0.062748656, 0.008026664, -0.009748928, 0.037835207, -0.0053512836, -0.06568922, -0.023412686, -0.087220095, -0.039714392, -0.06041386, -0.03629808, -0.0108059645, -0.039035227, -0.053936474, 0.05699145, 0.023638627, 0.039863102, 0.0915017, 0.030210773, -0.03331602, -0.012139514, 0.031237012, 0.04653211, -0.04925994, 0.017720895, -0.066211194, -0.004614984, -0.013582068, -0.005163211, -0.007486081, 0.007315264, 0.057538528, -0.03999963, 0.016148968, -0.012785363, -0.028635023, -0.03641817, -0.026388485, -0.03678458, 0.022613002, 0.010535872, -0.04874274, 0.03574819, 0.0064860345, -0.035558846, 0.011314301, -0.0021621815, -0.024358729, 0.0065486166, 0.023364874, 0.017933574, -0.030947147, -0.017880302, -0.004568606, -0.0705751, 0.03391417, 0.041263435, 0.021521848, 0.009281713, -0.009583896, 0.025823312, -0.053335074, 0.02316314, -0.024166277, 0.07003812, 0.028795421, -2.9521036e-05, 0.04382452, -0.06028383, 0.011898157, 0.04537682, 0.03728277, -0.008078017, -0.013824656, 0.060353953, -0.057766024, -0.0153330425, -0.003862276, 0.038629312, -0.052070078, -0.02868997, -0.023940675, -0.023509312, 0.08264395, 0.012894595, -0.045072876, -0.08874519, -0.03310178, -0.04828701, -0.0011250044, 0.0146891195, 0.019125136, 0.0076390617, 0.013533364, 0.032063413, -0.048961047, -0.047305096, 0.09881527, 0.03285907, -0.009185407, 6.627049e-05, 0.010381212, 0.076420024, -0.018738598, 0.0060674613, 0.081309676, 0.02343681, 0.007312163, 0.037525393, -0.039596424, -0.039924845, -0.00027980778, -0.008374003, -0.008327724, 0.021180084, 0.0160231, -0.009182013, 0.016438024, 0.015813299, -0.025480093, 0.065477245, 0.0064303973, -0.020953726, -0.0107253, 0.02000481, 0.028492995, 0.038114082, 0.006998611, 0.03748691, 0.032521024, -0.029587625, 0.10413111, -0.04877745, 0.021938587, 0.0020190056, -0.034438226, 0.09248559, 0.001547236, 0.021484055, -0.0008289635, -0.001724832, -0.06490163, 0.027256034, -0.03828974, 0.030431936, -0.01040924, -0.015940003, -0.05898395, -0.036465853, -0.008379886, -0.0026587707, -0.0004501739, -0.039217528, 0.024000777, -0.0022408855, 0.046162058, 0.0353421, 0.036393296, 0.024614085, -0.02755114, 0.061292373, -0.037264504, -0.020022415, 0.009518991, 0.0785015, 0.021687733, -0.0075326916, -0.01448385, -0.008670335, 0.012221529, 0.01051746, -0.0073513016, -0.0080168545, 0.033687808, -0.077068634, 0.03613318, 0.047251955, -0.07255613, 0.00026792864, -0.021755274, 0.02978364, -0.029327668, 0.034594223, -0.016204288, -0.006377477, -0.0009445009, 0.03541433, 0.010236642, -0.035102744, 0.045622718, 0.02431753, -0.059034828, -0.023754949, -0.012715241, 0.029924741, 0.052741367, 0.052775934, 0.0045254044, -0.044144277, -8.9903275e-05, 0.0019168311, 0.021748543, -0.008880222, -0.019283358, 0.020967375, 0.042748183, 0.0420733, -0.024140859, -0.080782175, 0.011787281, 0.02976435, 0.0011499561, 0.010307985, 0.012315883, 0.03206949, 0.028497986, 0.02170227, 0.044332255, 0.0069626095, -0.032779027, -0.037611462, -0.027913038}}
