function(cx_get_system_name output_var)
if(CMAKE_SYSTEM_NAME STREQUAL "Darwin")
  set(${output_var} "macos" PARENT_SCOPE)
elseif(CMAKE_SYSTEM_NAME STREQUAL "Linux")
  set(${output_var} "linux" PARENT_SCOPE)
elseif(CMAKE_SYSTEM_NAME STREQUAL "Windows")
  set(${output_var} "windows" PARENT_SCOPE)
else()
  set(${output_var} ${CMAKE_SYSTEM_NAME} PARENT_SCOPE)
endif()
endfunction()

function(cx_get_architecture output_var)
if(CMAKE_SYSTEM_NAME STREQUAL "Darwin")
  if(CMAKE_OSX_ARCHITECTURES)
    list(LENGTH CMAKE_OSX_ARCHITECTURES arch_count)
    if(arch_count GREATER 1)
        set(${output_var} "universal" PARENT_SCOPE)
    else()
        set(${output_var} ${CMAKE_OSX_ARCHITECTURES} PARENT_SCOPE)
    endif()
  else()
    # Fallback to CMAKE_SYSTEM_PROCESSOR if CMAKE_OSX_ARCHITECTURES is not set
    if(CMAKE_SYSTEM_PROCESSOR MATCHES "arm64|aarch64")
        set(${output_var} "arm64" PARENT_SCOPE)
    elseif(CMAKE_SYSTEM_PROCESSOR MATCHES "x86_64|AMD64")
        set(${output_var} "x86_64" PARENT_SCOPE)
    else()
          set(${output_var} ${CMAKE_SYSTEM_PROCESSOR} PARENT_SCOPE)
      endif()
  endif()
else()
  # For other systems, simplify common architectures
  if(CMAKE_SYSTEM_PROCESSOR MATCHES "arm64|aarch64")
      set(${output_var} "arm64" PARENT_SCOPE)
  elseif(CMAKE_SYSTEM_PROCESSOR MATCHES "x86_64|AMD64")
      set(${output_var} "x86_64" PARENT_SCOPE)
  elseif(CMAKE_SYSTEM_PROCESSOR MATCHES "i386|i686|x86")
      set(${output_var} "x86" PARENT_SCOPE)
  else()
      set(${output_var} ${CMAKE_SYSTEM_PROCESSOR} PARENT_SCOPE)
  endif()
endif()
endfunction()
