/*
 * This file is part of LuaScript
 * https://github.com/perbone/luascrip/
 *
 * Copyright 2017-2024 Paulo Perbone
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not  use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */

#include "parser.h"

#include "ast/antlr_tree_walker.h"

namespace parser {

Parser::Parser() :
		treeWalker{ std::make_unique<ast::AntlrTreeWalker>() } {
}

Parser::~Parser() {
}

ast::AST Parser::parse(const std::string_view chunk) const {
	return treeWalker->walk(chunk);
}

} // namespace parser
