/*
 * This file is part of LuaScript
 * https://github.com/perbone/luascrip/
 *
 * Copyright 2017-2024 Paulo Perbone
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not  use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */

#pragma once

#ifdef DEBUG_ENABLED

#include <string>

#include "core/string/ustring.h"

std::string get_notification_name(const int constant_value);
//void print_debug(const String fmt, ...);
#define print_debug(fmt, ...)  print_line(vformat(fmt, __VA_ARGS__))

#else

#define print_debug(fmt, ...)

#endif
