function PosixSend(ASocket: THandle; ABuf: Pointer;
  ALen: Integer): Integer;
var
  LBuf: PByte;
  LSent, LError: Integer;
  LFlags: Integer;
begin
  Result := 0;

  // һѾرյ׽ַʱϵͳֱ׳EPIPE쳣³˳
  // LINUX¿sendʱMSG_NOSIGNALܱķ
  // OSXпͨ׽ֵSO_NOSIGPIPEﵽͬĿ
  {$IF defined(LINUX) or defined(ANDROID)}
  LFlags := MSG_NOSIGNAL;
  {$ELSE}
  LFlags := 0;
  {$ENDIF}

  LBuf := ABuf;
  while (Result < ALen) do
  begin
    LSent := TSocketAPI.Send(ASocket, LBuf^, ALen - Result, LFlags);

    if (LSent < 0) then
    begin
      LError := GetLastError;

      // ϵͳźж, send
      if (LError = EINTR) then
        Continue
      // ͻѱ
      else if (LError = EAGAIN) or (LError = EWOULDBLOCK) then
        Break
      // ͳ
      else
        Exit(-1);
    end;

    Inc(Result, LSent);
    Inc(LBuf, LSent);
  end;
end;
