﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Pchp.Core;
using Pchp.Core.Utilities;

namespace Pchp.Library
{
    [PhpExtension(PhpExtensionAttribute.KnownExtensionNames.Standard)]
    public static class CLI
    {
        ///// <summary>
        ///// Set the process title.
        ///// </summary>
        ///// <param name="title">The title to use as the process title.</param>
        //public static void setproctitle(string title)
        //{
        //    cli_set_process_title(title);
        //}

        /// <summary>
        /// Sets the process title.
        /// </summary>
        /// <param name="title">The new title.</param>
        /// <returns>True if the function succeeded.</returns>
        public static bool cli_set_process_title(string title)
        {
            try
            {
                Console.Title = title;

                return true;
            }
            catch (Exception ex)
            {
                PhpException.Throw(PhpError.Warning, ex.Message);
                return false;
            }
        }

        /// <summary>
        /// Returns the current process title as supported by the operating system.
        /// </summary>
        /// <returns>The process title or <c>null</c> in case of error.</returns>
        public static string cli_get_process_title()
        {

            try
            {
                // Process.GetCurrentProcess().MainWindowTitle ?

#pragma warning disable CA1416 // Validate platform compatibility // We want the runtime exception, we don't want the compile-time warning
                return Console.Title;
#pragma warning restore CA1416
            }
            catch (Exception ex)
            {
                PhpException.Throw(PhpError.Warning, ex.Message);
                return null;
            }
        }
    }
}
