/* Version V1.0.8
  PS2KeyCode.h - PS2KeyAdvanced library Internal actual PS2 key code sequences
  Copyright (c) 2007 Free Software Foundation.  All right reserved.
  Written by Paul Carpenter, PC Services <sales@pcserviceselectronics.co.uk>
  Created September 2014
  Updated January 2016 - Paul Carpenter - add tested on Due and tidy ups for V1.5 Library Management
  Updated December 2019 - Paul Carpenter - Fix typo in code for Multimedia STOP

  PRIVATE to library

  Test History
    September 2014 Uno and Mega 2560 September 2014 using Arduino V1.6.0
    January 2016   Uno, Mega 2560 and Due using Arduino 1.6.7 and Due Board 
                    Manager V1.6.6

  This is for a LATIN style keyboard. Will support most keyboards even ones
  with multimedia keys or even 24 function keys.

  Definitions used for key codes from a PS2 keyboard, do not use in your
  code these are to be handled INTERNALLY by the library.
  (may disappear in updates do not rely on this file or definitions)

  See PS2KeyAdvanced.h for codes returned from library and flag settings

  Defines are in three groups

     Special codes definition of communications bytes

     Single Byte codes returned as key codes

     Two byte Codes preceded by E0 code returned as keycodes

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef PS2KeyCode_h
#define PS2KeyCode_h

/* Ignore code for key code translation */
#define PS2_KEY_IGNORE  0xBB

//  buffer sizes keyboard RX and TX, then key reading buffer
// Minimum size 8 can be larger
#define _RX_BUFFER_SIZE  8
// Minimum size 6 can be larger
#define _TX_BUFFER_SIZE  6
// Output Buffer of unsigned int values. Minimum size 4 can be larger
#define _KEY_BUFF_SIZE   4

/* private defines for library files not global */
/* _ps2mode status flags */
#define _PS2_BUSY        0x80
#define _TX_MODE         0x40
#define _BREAK_KEY       0x20
#define _WAIT_RESPONSE   0x10
#define _E0_MODE         0x08
#define _E1_MODE         0x04
#define _LAST_VALID      0x02

/* _tx_ready flags */
#define _HANDSHAKE       0x80
#define _COMMAND         0x01

/* Key Repeat defines */
#define _NO_BREAKS       0x08
#define _NO_REPEATS      0x80

/* PS2_keystatus byte masks (from 16 bit int masks) */
#define _BREAK    ( PS2_BREAK >> 8 )
#define _SHIFT    ( PS2_SHIFT >> 8 )
#define _CTRL     ( PS2_CTRL >> 8 )
#define _CAPS     ( PS2_CAPS >> 8 )
#define _ALT      ( PS2_ALT >> 8 )
#define _ALT_GR   ( PS2_ALT_GR >> 8 )
#define _GUI      ( PS2_GUI >> 8 )
#define _FUNCTION ( PS2_FUNCTION >> 8 )

/* General defines of comms codes */
/* Command or response */
#define PS2_KC_RESEND   0xFE
#define PS2_KC_ACK      0xFA
#define PS2_KC_ECHO     0xEE
/* Responses */
#define PS2_KC_BAT      0xAA
// Actually buffer overrun
#define PS2_KC_OVERRUN  0xFF
// Below is general error code
#define PS2_KC_ERROR    0xFC
#define PS2_KC_KEYBREAK 0xF0
#define PS2_KC_EXTEND1  0xE1
#define PS2_KC_EXTEND   0xE0
/* Commands */
#define PS2_KC_RESET    0xFF
#define PS2_KC_DEFAULTS 0xF6
#define PS2_KC_DISABLE  0xF5
#define PS2_KC_ENABLE   0xF4
#define PS2_KC_RATE     0xF3
#define PS2_KC_READID   0xF2
#define PS2_KC_SCANCODE 0xF0
#define PS2_KC_LOCK     0xED

/* Single Byte Key Codes */
#define PS2_KC_NUM      0x77
#define PS2_KC_SCROLL   0x7E
#define PS2_KC_CAPS     0x58
#define PS2_KC_L_SHIFT  0x12
#define PS2_KC_R_SHIFT  0x59
/* This is Left CTRL and ALT but Right version is in E0 with same code */
#define PS2_KC_CTRL     0X14
#define PS2_KC_ALT      0x11
/* Generated by some keyboards by ALT and PRTSCR */
#define PS2_KC_SYSRQ    0x84
#define PS2_KC_ESC      0x76
#define PS2_KC_BS       0x66
#define PS2_KC_TAB      0x0D
#define PS2_KC_ENTER    0x5A
#define PS2_KC_SPACE    0x29
#define PS2_KC_KP0      0x70
#define PS2_KC_KP1      0x69
#define PS2_KC_KP2      0x72
#define PS2_KC_KP3      0x7A
#define PS2_KC_KP4      0x6B
#define PS2_KC_KP5      0x73
#define PS2_KC_KP6      0x74
#define PS2_KC_KP7      0x6C
#define PS2_KC_KP8      0x75
#define PS2_KC_KP9      0x7D
#define PS2_KC_KP_DOT   0x71
#define PS2_KC_KP_PLUS  0x79
#define PS2_KC_KP_MINUS 0x7B
#define PS2_KC_KP_TIMES 0x7C
/* Some keyboards have an '=' on right keypad */
#define PS2_KC_KP_EQUAL 0x0F
#define PS2_KC_0        0X45
#define PS2_KC_1        0X16
#define PS2_KC_2        0X1E
#define PS2_KC_3        0X26
#define PS2_KC_4        0X25
#define PS2_KC_5        0X2E
#define PS2_KC_6        0X36
#define PS2_KC_7        0X3D
#define PS2_KC_8        0X3E
#define PS2_KC_9        0X46
#define PS2_KC_APOS     0X52
#define PS2_KC_COMMA    0X41
#define PS2_KC_MINUS    0X4E
#define PS2_KC_DOT      0X49
#define PS2_KC_DIV      0X4A
/* Single quote or back apostrophe */
#define PS2_KC_BTICK    0X0E
#define PS2_KC_A        0X1C
#define PS2_KC_B        0X32
#define PS2_KC_C        0X21
#define PS2_KC_D        0X23
#define PS2_KC_E        0X24
#define PS2_KC_F        0X2B
#define PS2_KC_G        0X34
#define PS2_KC_H        0X33
#define PS2_KC_I        0X43
#define PS2_KC_J        0X3B
#define PS2_KC_K        0X42
#define PS2_KC_L        0X4B
#define PS2_KC_M        0X3A
#define PS2_KC_N        0X31
#define PS2_KC_O        0X44
#define PS2_KC_P        0X4D
#define PS2_KC_Q        0X15
#define PS2_KC_R        0X2D
#define PS2_KC_S        0X1B
#define PS2_KC_T        0X2C
#define PS2_KC_U        0X3C
#define PS2_KC_V        0X2A
#define PS2_KC_W        0X1D
#define PS2_KC_X        0X22
#define PS2_KC_Y        0X35
#define PS2_KC_Z        0X1A
#define PS2_KC_SEMI     0X4C
#define PS2_KC_BACK     0X5D
// Extra key left of Z on 102 keyboards
#define PS2_KC_EUROPE2  0x61
#define PS2_KC_OPEN_SQ  0X54
#define PS2_KC_CLOSE_SQ 0X5B
#define PS2_KC_EQUAL    0X55
#define PS2_KC_F1       0X05
#define PS2_KC_F2       0X06
#define PS2_KC_F3       0X04
#define PS2_KC_F4       0X0C
#define PS2_KC_F5       0X03
#define PS2_KC_F6       0X0B
#define PS2_KC_F7       0X83
#define PS2_KC_F8       0X0A
#define PS2_KC_F9       0X01
#define PS2_KC_F10      0X09
#define PS2_KC_F11      0X78
#define PS2_KC_F12      0X07
#define PS2_KC_F13      0X08
#define PS2_KC_F14      0X10
#define PS2_KC_F15      0X18
#define PS2_KC_F16      0X20
#define PS2_KC_F17      0X28
#define PS2_KC_F18      0X30
#define PS2_KC_F19      0X38
#define PS2_KC_F20      0X40
#define PS2_KC_F21      0X48
#define PS2_KC_F22      0X50
#define PS2_KC_F23      0X57
#define PS2_KC_F24      0X5F
#define PS2_KC_KP_COMMA 0X6D
#define PS2_KC_INTL1    0X51
#define PS2_KC_INTL2    0X13
#define PS2_KC_INTL3    0X6A
#define PS2_KC_INTL4    0X64
#define PS2_KC_INTL5    0X67
#define PS2_KC_LANG1    0XF2
#define PS2_KC_LANG2    0XF1
#define PS2_KC_LANG3    0X63
#define PS2_KC_LANG4    0X62
#define PS2_KC_LANG5    0X5F

/* Extended key codes E0 table for two byte codes */
/* PS2_CTRL and PS2_ALT Need using in any table for the right keys */
/* first is special case for PRTSCR not always used so ignored by decoding */
#define PS2_KC_IGNORE   0x12
#define PS2_KC_PRTSCR   0x7C
/* Sometimes called windows key */
#define PS2_KC_L_GUI    0x1F
#define PS2_KC_R_GUI    0x27
#define PS2_KC_MENU     0x2F
/* Break is CTRL + PAUSE generated inside keyboard */
#define PS2_KC_BREAK    0x7E
#define PS2_KC_HOME     0x6C
#define PS2_KC_END      0x69
#define PS2_KC_PGUP     0x7D
#define PS2_KC_PGDN     0x7A
#define PS2_KC_L_ARROW  0x6B
#define PS2_KC_R_ARROW  0x74
#define PS2_KC_UP_ARROW 0x75
#define PS2_KC_DN_ARROW 0x72
#define PS2_KC_INSERT   0x70
#define PS2_KC_DELETE   0x71
#define PS2_KC_KP_ENTER 0x5A
#define PS2_KC_KP_DIV   0x4A
#define PS2_KC_NEXT_TR  0X4D
#define PS2_KC_PREV_TR  0X15
#define PS2_KC_STOP     0X3B
#define PS2_KC_PLAY     0X34
#define PS2_KC_MUTE     0X23
#define PS2_KC_VOL_UP   0X32
#define PS2_KC_VOL_DN   0X21
#define PS2_KC_MEDIA    0X50
#define PS2_KC_EMAIL    0X48
#define PS2_KC_CALC     0X2B
#define PS2_KC_COMPUTER 0X40
#define PS2_KC_WEB_SEARCH  0X10
#define PS2_KC_WEB_HOME    0X3A
#define PS2_KC_WEB_BACK    0X38
#define PS2_KC_WEB_FORWARD 0X30
#define PS2_KC_WEB_STOP    0X28
#define PS2_KC_WEB_REFRESH 0X20
#define PS2_KC_WEB_FAVOR   0X18
#define PS2_KC_POWER    0X37
#define PS2_KC_SLEEP    0X3F
#define PS2_KC_WAKE     0X5E
#endif
