/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
**
** This version of "lempar.c" is modified, slightly, for use by SQLite.
** The only modifications are the addition of a couple of NEVER()
** macros to disable tests that are needed in the case of a general
** LALR(1) grammar but which are always false in the
** specific grammar used by SQLite.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>

#include "token.h"
#include "parsercontext.h"
#include "parser_helper_stubs.h"
#include "common/utils_sql.h"
#include "common/global.h"
#include "common/unused.h"
#include "parser/ast/sqlitealtertable.h"
#include "parser/ast/sqliteanalyze.h"
#include "parser/ast/sqliteattach.h"
#include "parser/ast/sqlitebegintrans.h"
#include "parser/ast/sqlitecommittrans.h"
#include "parser/ast/sqlitecreateindex.h"
#include "parser/ast/sqlitecreatetable.h"
#include "parser/ast/sqlitecreatetrigger.h"
#include "parser/ast/sqlitecreateview.h"
#include "parser/ast/sqlitecreatevirtualtable.h"
#include "parser/ast/sqlitedelete.h"
#include "parser/ast/sqlitedetach.h"
#include "parser/ast/sqlitedropindex.h"
#include "parser/ast/sqlitedroptable.h"
#include "parser/ast/sqlitedroptrigger.h"
#include "parser/ast/sqlitedropview.h"
#include "parser/ast/sqliteemptyquery.h"
#include "parser/ast/sqliteinsert.h"
#include "parser/ast/sqlitepragma.h"
#include "parser/ast/sqlitereindex.h"
#include "parser/ast/sqliterelease.h"
#include "parser/ast/sqliterollback.h"
#include "parser/ast/sqlitesavepoint.h"
#include "parser/ast/sqliteselect.h"
#include "parser/ast/sqliteupdate.h"
#include "parser/ast/sqlitevacuum.h"
#include "parser/ast/sqliteexpr.h"
#include "parser/ast/sqlitecolumntype.h"
#include "parser/ast/sqliteconflictalgo.h"
#include "parser/ast/sqlitesortorder.h"
#include "parser/ast/sqliteindexedcolumn.h"
#include "parser/ast/sqliteforeignkey.h"
#include "parser/ast/sqlitewith.h"
#include "parser/ast/sqliteupsert.h"
#include "parser/ast/sqlitewindowdefinition.h"
#include "parser/ast/sqlitefilterover.h"
#include "parser/ast/sqlitenulls.h"
#include <QObject>
#include <QDebug>
#include <limits.h>

#define assert(X) Q_ASSERT(X)
#define UNUSED_PARAMETER(X) (void)(X)
#define DONT_INHERIT_TOKENS(X) noTokenInheritanceFields << X

/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/*
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands.
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3_parseTOKENTYPE     is the data type used for minor tokens given
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3_parseTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3_parseARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3_parseARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3_parseARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3_parseARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned short int
#define YYNOCODE 328
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 80
#define sqlite3_parseTOKENTYPE Token*
typedef union {
  int yyinit;
  sqlite3_parseTOKENTYPE yy0;
  SqliteCreateTable::Column* yy3;
  SqliteFilterOver::Over* yy11;
  SqliteWith::CommonTableExpression::AsMode* yy21;
  ParserResultColumnList* yy27;
  SqliteSortOrder* yy35;
  SqliteFilterOver::Filter* yy39;
  SqliteQuery* yy41;
  ParserDeferSubClause* yy53;
  SqliteForeignKey::Condition::Reaction* yy106;
  ParserOtherSourceList* yy107;
  SqliteIndexedColumn* yy110;
  ParserCreateTableConstraintList* yy115;
  SqliteCreateTrigger::Time* yy120;
  int* yy130;
  SqliteConflictAlgo* yy136;
  SqliteSelect::CompoundOperator* yy142;
  SqliteWindowDefinition::Window::Frame::RangeOrRows* yy143;
  SqliteWith::CommonTableExpression* yy146;
  SqliteWindowDefinition::Window::Frame* yy149;
  ParserFkConditionList* yy156;
  SqliteWith* yy161;
  SqliteWindowDefinition::Window* yy162;
  ParserCteList* yy164;
  QStringList* yy173;
  SqliteFilterOver* yy181;
  SqliteExpr* yy186;
  SqliteForeignKey::Condition* yy205;
  SqliteSelect::Core::JoinConstraint* yy215;
  bool* yy225;
  ParserOrderByList* yy226;
  SqliteWindowDefinition::Window::Frame::Exclude* yy237;
  ParserQueryList* yy240;
  SqliteCreateTrigger::Event* yy259;
  SqliteColumnType* yy267;
  SqliteExpr::LikeOp* yy274;
  SqliteWindowDefinition::Window::Frame::Bound* yy285;
  SqliteSelect* yy297;
  ParserIndexedBy* yy300;
  ParserStubInsertOrReplace* yy308;
  SqliteNulls* yy315;
  QString* yy319;
  ParserCreateTableColumnConstraintList* yy323;
  SqliteUpsert* yy332;
  SqliteLimit* yy360;
  SqliteSelect::Core* yy378;
  ParserTermOrLiteral* yy380;
  ParserCreateTableColumnList* yy390;
  QVariant* yy393;
  ParserFullName* yy396;
  SqliteCreateTable::Constraint* yy400;
  SqliteCreateTable::Column::Constraint* yy448;
  SqliteSelect::Core::JoinOp* yy449;
  ParserCreateTableOptionList* yy455;
  SqliteCreateTrigger::Scope* yy456;
  ParserStubExplain* yy499;
  ParserStubTransDetails* yy512;
  ParserExprNestedList* yy522;
  ParserWindowDefList* yy525;
  SqliteSelect::Core::JoinSource* yy553;
  SqliteWindowDefinition* yy562;
  SqliteSelect::Core::SingleSource* yy595;
  SqliteInitially* yy612;
  ParserExprList* yy615;
  ParserSetValueList* yy621;
  ParserIndexedColumnList* yy627;
  ParserStubAlias* yy628;
  ParserStubCreateTableOption* yy629;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3_parseARG_SDECL ParserContext* parserContext;
#define sqlite3_parseARG_PDECL ,ParserContext* parserContext
#define sqlite3_parseARG_FETCH ParserContext* parserContext = yypParser->parserContext
#define sqlite3_parseARG_STORE yypParser->parserContext = parserContext
#define YYNSTATE 870
#define YYNRULE 487
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

#define GET_CONTEXT yyParser* yypParser = pParser; sqlite3_parseARG_FETCH

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
#define YY_ACTTAB_COUNT (2866)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   530,  162,  431,  771,  456,  453,  452,   27,   67,   68,
 /*    10 */   529,  282,  521,  770,  818,  818,   65,   65,   66,   66,
 /*    20 */    66,   66,  451,   64,   64,   64,   64,   63,   63,   62,
 /*    30 */    62,   62,   61,   59,  263,  464, 1230,  807,   67,   68,
 /*    40 */   529,  282,   58,  116,  818,  818,   65,   65,   66,   66,
 /*    50 */    66,   66,  526,   64,   64,   64,   64,   63,   63,   62,
 /*    60 */    62,   62,   61,   59,  263,  681, 1280,   62,   62,   62,
 /*    70 */    61,   59,  263,  808,  432,   66,   66,   66,   66,   56,
 /*    80 */    64,   64,   64,   64,   63,   63,   62,   62,   62,   61,
 /*    90 */    59,  263,  834,  862,   14,  835,   53,   54,  715,  704,
 /*   100 */   704,  353,  828,  619,   55, 1042,  508,  633,  295,  781,
 /*   110 */   530,  299,    2, 1042,  343,  861,  861,  816, 1042,  354,
 /*   120 */   867,  518,  521,  830,  859,  829,  230,  672,  673,  833,
 /*   130 */  1108,  821,  324,  861,  528,  327,  816,  832,  831,  830,
 /*   140 */   406, 1042,   39,  143,  608,   80,  862,  128,  515,  291,
 /*   150 */   472,  265,  709,  708, 1042,  301, 1042, 1042,  828,  585,
 /*   160 */  1042,  290,  526,  366,  368, 1042, 1042, 1042, 1042, 1042,
 /*   170 */  1042,  816,  861,  609,  816,  611,  806,   12,  610,  364,
 /*   180 */   560,  829,  230,  808,  510,  506,  163,  351, 1042,   56,
 /*   190 */   528,  782,  132,   82,  861,  371,  587,  365,   21,  428,
 /*   200 */   561,  562,  367,  183,  805,   72,   53,   54,  109,   89,
 /*   210 */   723,   81,  497,  127,   55, 1108,  860,  859,  483,  468,
 /*   220 */   530,  560,    2, 1108,  862,  297,  448,  816, 1108,  724,
 /*   230 */   791,  518,  521,  830,  859,  861,  107,  809,  498,  833,
 /*   240 */   381,  561,  414,    8,  723,  172,  816,  832,  831,  830,
 /*   250 */   369, 1108,  181,  745,  821, 1059, 1059,  141,   72,   52,
 /*   260 */   758,   50,  809,  723, 1108,  502, 1108, 1108,  688,  860,
 /*   270 */   859,  861,  526,  563,  798, 1108, 1108, 1108, 1108,  861,
 /*   280 */  1108,  816,  724,   78,  816,  194,  806,   12,  386,  862,
 /*   290 */   734,  382,  687,  808,  334,   79,  809,  723, 1108,   56,
 /*   300 */    64,   64,   64,   64,   63,   63,   62,   62,   62,   61,
 /*   310 */    59,  263,  751,  858,  415,  798,   53,   54,  790,  614,
 /*   320 */   856,  722,  828,  116,   55, 1093,  742,  167,  413,  857,
 /*   330 */   469,  173,    2, 1093,  751,   42,  861,  816, 1093,  809,
 /*   340 */   751,  518,  821,  830,  859,  829,  230,  860,  859,  833,
 /*   350 */  1358,  190,  535,    3,  528,  487,  816,  832,  831,  830,
 /*   360 */   815, 1093,  711,  759,  809,  721,  717,   58,  122,  505,
 /*   370 */   522,  500,  746,    4, 1093,  817, 1093, 1093,  767,  828,
 /*   380 */  1197, 1197,  483,  470,  600, 1093,  828, 1093, 1093,  601,
 /*   390 */  1093,  816,   91,  861,  816,  815,  806,   12,  809,   44,
 /*   400 */   861,  113,  829,  215,  381,  307,  442,  317, 1093,  829,
 /*   410 */   123,  528,  860,  859, 1200,  284,  473,  423,  528,   67,
 /*   420 */    68,  529,  282, 1197, 1197,  818,  818,   65,   65,   66,
 /*   430 */    66,   66,   66,   74,   64,   64,   64,   64,   63,   63,
 /*   440 */    62,   62,   62,   61,   59,  263,   63,   63,   62,   62,
 /*   450 */    62,   61,   59,  263,  800,  799,  172,  332,  504,   73,
 /*   460 */   626,  775,  116, 1197, 1197,  821,  389,  247,  775,   67,
 /*   470 */    68,  529,  282,   69,  264,  818,  818,   65,   65,   66,
 /*   480 */    66,   66,   66,  412,   64,   64,   64,   64,   63,   63,
 /*   490 */    62,   62,   62,   61,   59,  263,  496,   58,  142,  753,
 /*   500 */   588,  734,   67,   68,  529,  282, 1197, 1197,  818,  818,
 /*   510 */    65,   65,   66,   66,   66,   66,  862,   64,   64,   64,
 /*   520 */    64,   63,   63,   62,   62,   62,   61,   59,  263,  788,
 /*   530 */   449,  703,  828,  830,  340,  116,  372, 1307,  177,  833,
 /*   540 */   657,  787, 1307,   45,  505,  363,  861,  832,  831,  830,
 /*   550 */   643,   92,  339,  254,  861,  829,  230,  407,  803,  802,
 /*   560 */   285, 1197, 1197,  380,  528,  342,  699,  795,  658,  261,
 /*   570 */  1200,   81, 1200,   66,   66,   66,   66,   40,   64,   64,
 /*   580 */    64,   64,   63,   63,   62,   62,   62,   61,   59,  263,
 /*   590 */   693,  862,  483,  484,  281,  280,  862, 1201,  286,  836,
 /*   600 */    67,   68,  529,  282, 1197, 1197,  818,  818,   65,   65,
 /*   610 */    66,   66,   66,   66,  381,   64,   64,   64,   64,   63,
 /*   620 */    63,   62,   62,   62,   61,   59,  263,  862,    1,  751,
 /*   630 */   430,  141,  798,  827,  812,  800,  799,  788,  647,  860,
 /*   640 */   859,  677,  328, 1197, 1197,  861,  409,  492,  648,  787,
 /*   650 */    87,  751,   67,   68,  529,  282,  861,  751,  818,  818,
 /*   660 */    65,   65,   66,   66,   66,   66,  862,   64,   64,   64,
 /*   670 */    64,   63,   63,   62,   62,   62,   61,   59,  263,  251,
 /*   680 */   250,  249,   67,   68,  529,  282, 1197, 1197,  818,  818,
 /*   690 */    65,   65,   66,   66,   66,   66,  176,   64,   64,   64,
 /*   700 */    64,   63,   63,   62,   62,   62,   61,   59,  263,  764,
 /*   710 */   502,  135,  777,  656,  860,  859,  657, 1266,  162,  860,
 /*   720 */   859,  456,  453,  452,  861,  811,  840,   92,  843,  357,
 /*   730 */   861,  350,  764,  255,  707,  531,  471,  841,  163,  451,
 /*   740 */   839,  684,  861,  584,  584,  467,  746,    4,  665,  459,
 /*   750 */   860,  859,  271, 1201,  644, 1201,  862,  683,   67,   68,
 /*   760 */   529,  282,   23,  491,  818,  818,   65,   65,   66,   66,
 /*   770 */    66,   66,  486,   64,   64,   64,   64,   63,   63,   62,
 /*   780 */    62,   62,   61,   59,  263,   67,   68,  529,  282,  860,
 /*   790 */   859,  818,  818,   65,   65,   66,   66,   66,   66,  751,
 /*   800 */    64,   64,   64,   64,   63,   63,   62,   62,   62,   61,
 /*   810 */    59,  263,  530, 1266,  866,  862,  636,  485,  344,  534,
 /*   820 */   457,  751,  503,  768,  521,  344,  180,  751,  597,  466,
 /*   830 */   633,  697,  861,  482,  419,   67,   68,  529,  282,  861,
 /*   840 */   386,  818,  818,   65,   65,   66,   66,   66,   66,  810,
 /*   850 */    64,   64,   64,   64,   63,   63,   62,   62,   62,   61,
 /*   860 */    59,  263,  821,  828,  526,  342,  699,  570,   80,  401,
 /*   870 */   353,  122,  119,   61,   59,  263,  842,  861,  585,  860,
 /*   880 */   859,   81,  744,  376,  861,  808,  829,  223,  692,  481,
 /*   890 */   376,   56,  135,  259,  804,  528,  569,  592,  568,  325,
 /*   900 */   283,  567,  633,  326,  965,  520,  803,  802,   53,   54,
 /*   910 */    22,  246,  245,  861,  371,  586,   55,  179,  126,  341,
 /*   920 */   462,  336,  461,  164,    2, 1207,  537,   71,   57,  816,
 /*   930 */   602,  603,  425,  518,   79,  830,  859,  334,  830,  608,
 /*   940 */    80,  833,  588,  165,  833,  775,  793, 1215,  816,  832,
 /*   950 */   831,  830,  832,  831,  830,  795,  519,  261,  197,  862,
 /*   960 */   789,  438, 1202,  354, 1315, 1315,  173,  690,  609,  689,
 /*   970 */   611,  255,  707,  610,  471,  613,  172,  861,  372, 1306,
 /*   980 */   798,  293,  821,  816, 1306,  821,  816,  792,  806,   12,
 /*   990 */    67,   68,  529,  282,  429,  861,  818,  818,   65,   65,
 /*  1000 */    66,   66,   66,   66,  435,   64,   64,   64,   64,   63,
 /*  1010 */    63,   62,   62,   62,   61,   59,  263,   67,   68,  529,
 /*  1020 */   282,  734,   81,  818,  818,   65,   65,   66,   66,   66,
 /*  1030 */    66,  780,   64,   64,   64,   64,   63,   63,   62,   62,
 /*  1040 */    62,   61,   59,  263,   67,   68,  529,  282,  662,  661,
 /*  1050 */   818,  818,   65,   65,   66,   66,   66,   66, 1251,   64,
 /*  1060 */    64,   64,   64,   63,   63,   62,   62,   62,   61,   59,
 /*  1070 */   263,  779,  512,  566,  778,  639,  639,  870,   67,   68,
 /*  1080 */   529,  282,  860,  859,  818,  818,   65,   65,   66,   66,
 /*  1090 */    66,   66,   51,   64,   64,   64,   64,   63,   63,   62,
 /*  1100 */    62,   62,   61,   59,  263,  821,  411,  794,  862,   67,
 /*  1110 */    68,  529,  282,  118,  698,  818,  818,   65,   65,   66,
 /*  1120 */    66,   66,   66,  437,   64,   64,   64,   64,   63,   63,
 /*  1130 */    62,   62,   62,   61,   59,  263,  834,  861,  862,  835,
 /*  1140 */   196,   67,   68,  529,  282,  696,   48,  818,  818,   65,
 /*  1150 */    65,   66,   66,   66,   66,  776,   64,   64,   64,   64,
 /*  1160 */    63,   63,   62,   62,   62,   61,   59,  263, 1204,  869,
 /*  1170 */     3,  436,   67,   68,  529,  282,  173,  679,  818,  818,
 /*  1180 */    65,   65,   66,   66,   66,   66,  868,   64,   64,   64,
 /*  1190 */    64,   63,   63,   62,   62,   62,   61,   59,  263,  774,
 /*  1200 */   267,  862,  622,   67,   68,  529,  282,  173,  195,  818,
 /*  1210 */   818,   65,   65,   66,   66,   66,   66,  735,   64,   64,
 /*  1220 */    64,   64,   63,   63,   62,   62,   62,   61,   59,  263,
 /*  1230 */   507,  860,  859,  309,   67,   68,  529,  282,   44,  331,
 /*  1240 */   818,  818,   65,   65,   66,   66,   66,   66,  862,   64,
 /*  1250 */    64,   64,   64,   63,   63,   62,   62,   62,   61,   59,
 /*  1260 */   263,  860,  859,  671,  729,  862,   67,   68,  529,  282,
 /*  1270 */   720,   28,  818,  818,   65,   65,   66,   66,   66,   66,
 /*  1280 */   735,   64,   64,   64,   64,   63,   63,   62,   62,   62,
 /*  1290 */    61,   59,  263,  460, 1281,   67,   68,  529,  282,  862,
 /*  1300 */   719,  818,  818,   65,   65,   66,   66,   66,   66,  670,
 /*  1310 */    64,   64,   64,   64,   63,   63,   62,   62,   62,   61,
 /*  1320 */    59,  263,  530, 1279,  860,  859,  304,  726,  320,  354,
 /*  1330 */   735,   44,  269,   81,  521,  837,   47,  494,   67,   68,
 /*  1340 */   529,  282,  861,  861,  818,  818,   65,   65,   66,   66,
 /*  1350 */    66,   66,  862,   64,   64,   64,   64,   63,   63,   62,
 /*  1360 */    62,   62,   61,   59,  263,  598,   46,  828,  530,  606,
 /*  1370 */   828,  860,  859,  590,  526,  509,   20,  716,  373,  517,
 /*  1380 */   521,  861,  554,  494,  861,  821,  862,  493,  860,  859,
 /*  1390 */   829,  230,  828,  829,  230,  808,  843,  256,  399,  528,
 /*  1400 */   501,   56,  528,    6,  862,  846,  861,  437,   44,  986,
 /*  1410 */   861,  112,  117,  122,  645,  829,  215,  122,   53,   54,
 /*  1420 */   526,  861,  860,  859,  528,   77,   55,  408,  417,  862,
 /*  1430 */   483,  474,  598,  493,    2,  751,  862,  766,  516,  816,
 /*  1440 */   778,  808,  861,  518,  513,  830,  859,   56,  554,  381,
 /*  1450 */   530,  833,  381,  499,  539,  828,  441,  751,  816,  832,
 /*  1460 */   831,  830,  521,  751,   53,   54,   22,  862,  861,  861,
 /*  1470 */   625,  629,   55,  689,  775,  860,  859,  862,  829,  215,
 /*  1480 */     2,  864,  122,   19,  266,  816,  739,  528,  551,  518,
 /*  1490 */   761,  830,  859,  816,  862,  861,  816,  833,  806,   12,
 /*  1500 */   861,  828,  526,  548,  816,  832,  831,  830,  821,  860,
 /*  1510 */   859,  345,  756,  642,  755,  861,  551,  828,  637,   81,
 /*  1520 */   820,  549,  548,  808,  829,  230,    5,  860,  859,   56,
 /*  1530 */   311,  861,  760,  528,  862,  765,    4,  775,  862,  816,
 /*  1540 */   829,  230,  816,  863,  806,   12,   53,   54,  754,  528,
 /*  1550 */   548,  122,  860,  859,   55,  752,  122,  403,   18,  860,
 /*  1560 */   859,  277,    2,  281,  280,  728,  821,  816,  122,  490,
 /*  1570 */   862,  518,  346,  830,  859,  753,  735,  276,  316,  833,
 /*  1580 */   727,  387,  268,  381,  750,    4,  816,  832,  831,  830,
 /*  1590 */   860,  859,  861,   17,  630,  557,   16,  256,  344,  381,
 /*  1600 */   860,  859, 1315, 1315,  800,  799,  821,  530,  559,  862,
 /*  1610 */   558,  593,  861,  630,  749,    4,  553,  860,  859,  521,
 /*  1620 */   411,  816,  494,  725,  816,   11,  806,   12,   67,   38,
 /*  1630 */   529,  282,  284,  473,  818,  818,   65,   65,   66,   66,
 /*  1640 */    66,   66,  821,   64,   64,   64,   64,   63,   63,   62,
 /*  1650 */    62,   62,   61,   59,  263,  828,  115,  860,  859,  526,
 /*  1660 */   348,  860,  859,  275,  747,    4,  862,  828,  422,  861,
 /*  1670 */   825,  353,  495,  735,  547,   58,  593,  851,  829,  123,
 /*  1680 */   808,  861,  828,  852,  828,  861,   56,  528,  171,  821,
 /*  1690 */   829,  123,  862,  860,  859,  353,  861,  861,  861,  528,
 /*  1700 */   868,  784,  547,   53,   54,  829,  230,  829,  123,  861,
 /*  1710 */   270,   55,  748,    4,  528,  730,  528,  256,   90,    2,
 /*  1720 */   274,  170,  347,  169,  816,  168,  635,  175,  518,  821,
 /*  1730 */   830,  859,  860,  859,  398,  862,  833,  775,  718,  174,
 /*  1740 */   129,  657,  402,  816,  832,  831,  830,  477,  828,  775,
 /*  1750 */   862,  541,   92,  313,  862,  861,  392,  312,  713,  635,
 /*  1760 */   850,  782,  861,  475,  381,  821,  775,  861,  739,  710,
 /*  1770 */     7,  829,  123,  849,  861,  712,  862,  663,  816,  256,
 /*  1780 */   528,  816,  861,  806,   12,  782,   68,  529,  282,  860,
 /*  1790 */   859,  818,  818,   65,   65,   66,   66,   66,   66,  847,
 /*  1800 */    64,   64,   64,   64,   63,   63,   62,   62,   62,   61,
 /*  1810 */    59,  263,  530,   15,  465,  860,  859,  706,  705,   81,
 /*  1820 */   390,  862,  121,  701,  521,  120,  273,  529,  282,  862,
 /*  1830 */   775,  818,  818,   65,   65,   66,   66,   66,   66,  396,
 /*  1840 */    64,   64,   64,   64,   63,   63,   62,   62,   62,   61,
 /*  1850 */    59,  263,  828,  138,  862,  848,  828,  862,  860,  859,
 /*  1860 */    37,   25,   72, 1052,  526,  669,  861,  723,  741,  861,
 /*  1870 */   861,  545,  862,  860,  859,  829,  230,  860,  859,  829,
 /*  1880 */   201,  845,  861,  353,  528,  808,  724,  458,  528,  862,
 /*  1890 */   545,   56,  660,  571,   36,  861,  862,  861,  455,  860,
 /*  1900 */   859,  723, 1315, 1315,   86,  739,  862,  333,   53,   54,
 /*  1910 */   524,   85,  488,   24,  530,  450,   55,  323,  545,  861,
 /*  1920 */    84,  862,  397,  828,    2,  678,  521,  714,  300,  816,
 /*  1930 */   161,  861,  583,  518,  381,  830,  859,  861,  775,  446,
 /*  1940 */   828,  833,  861,  739,  860,  859,  829,  211,  816,  832,
 /*  1950 */   831,  830,  860,  859,  861,  528,  339,  861,  638,  193,
 /*  1960 */   157,  571,   10,  829,  233,  815,  526,  105,  838,  745,
 /*  1970 */   862,  624,  528,  782,  574,  862,  395,  860,  859,   35,
 /*  1980 */   860,  859,  861,  816,  103,  828,  816,  808,  806,   12,
 /*  1990 */   624,  844,  814,   56,   34,  860,  859,   33,  862,  861,
 /*  2000 */   815,  828,   32,  102,  391,  775,  577,  393,  829,  231,
 /*  2010 */    53,   54,  860,  859,  394,  861,  530,  528,   55,  860,
 /*  2020 */   859,  574,  775,  616,  829,  241,    2,  330,  521,  860,
 /*  2030 */   859,  816,  828,  528,  828,  518,  101,  830,  859,  862,
 /*  2040 */   577,  618,  616,  833,  860,  859,  861,  828,  861,  828,
 /*  2050 */   816,  832,  831,  830,  862,  829,  240,  829,  242,  862,
 /*  2060 */   731,  861,  862,  861,  528,  308,  528,  775,  526,  612,
 /*  2070 */   829,  243,  829,  262,  607,  605,  862,  426,  828,  528,
 /*  2080 */   736,  528,  298,  775,  110,  816,  579,  581,  816,  808,
 /*  2090 */   806,   12,  861,  860,  859,   56,  861,  826,  860,  859,
 /*  2100 */   173,  829,  356,  296,  599,  306,  581,  575,  152,  739,
 /*  2110 */   528,  861,   53,   54,  775,  538,  775,  861,  530,   13,
 /*  2120 */    55,  860,  859,  861,  303,  862,  187,  828,    2,  775,
 /*  2130 */   521,  775,  580,  816,  538,  439,  198,  518,  556,  830,
 /*  2140 */   859,  861,  828,   96,  828,  833,  740,  555,  410,  861,
 /*  2150 */   829,  239,  816,  832,  831,  830,  861,  862,  861,  528,
 /*  2160 */   775,  862,  860,  859,  862,  829,  355,  829,  210,  144,
 /*  2170 */   526,  536,   94,  256,  528,  666,  528,  860,  859,  862,
 /*  2180 */   424,  248,  860,  859,  862,  860,  859,  816,   76,  828,
 /*  2190 */   816,  808,  806,   12, 1205,  604,  813,   56,  252,  860,
 /*  2200 */   859,  272,  862,  861,  828,  862,  114,  675,  385,  775,
 /*  2210 */   861,  185,  829,  228,   53,   54,  384,  865,  861,  294,
 /*  2220 */   530,  528,   55,  572,  775,  855,  775,  829,  232,  828,
 /*  2230 */     2, 1207,  521,  861,  854,  816,  528,  853,  634,  518,
 /*  2240 */   533,  830,  859,  861,  862,  184,  287,  833,  860,  859,
 /*  2250 */   383,  828,  829,  379,  816,  832,  831,  830,  862,  653,
 /*  2260 */   861,  528,  862,  523,  862,  861,  862,  182,  108,  447,
 /*  2270 */   532,  775,  526,  641,  829,  378,  737,  861,   75,  359,
 /*  2280 */   860,  859,  828,  528,  860,  859,  775,  860,  859,  816,
 /*  2290 */   861,  862,  816,  808,  806,   12,  861,  646,  178,   56,
 /*  2300 */   632,  824,  860,  859,  284,  829,  377,  860,  859,  358,
 /*  2310 */   823,  775,  862,  732,  528,  628,   53,   54,   23,  489,
 /*  2320 */   623,  591,  530,  192,   55,  860,  859,  861,  860,  859,
 /*  2330 */    43,  828,    2,  775,  521,  822,   70,  816,  166,  305,
 /*  2340 */   263,  518,  352,  830,  859,  861,  828,   88,  862,  833,
 /*  2350 */   862,  279,  861,  861,  829,  227,  816,  832,  831,  830,
 /*  2360 */   861,  480,  862,  528,  775,  700,  260,  860,  859,  829,
 /*  2370 */   213,  405,  278,  349,  526,  861,   49,  505,  528,  861,
 /*  2380 */  1209,  860,  859,  514,  596,  860,  859,  860,  859,  860,
 /*  2390 */   859,  816,  335,  828,  816,  808,  806,   12,  828,  773,
 /*  2400 */   594,   56, 1209,  772,  253,  404,  861,  861, 1209,  578,
 /*  2410 */   769,  763,  861,  775,  860,  859,  829,  226,   53,   54,
 /*  2420 */   862,  829,  225,  862,  676,  528,   55,  582,  775,  573,
 /*  2430 */   528,  139,  862,  828,    2,  860,  859,  757,  861,  816,
 /*  2440 */   140,  476,  473,  518,  702,  860,  859,  861,  165,  564,
 /*  2450 */   862,  833,  691,  686, 1209,  654,  829,  212,  816,  832,
 /*  2460 */   831,  830, 1209,  400,  463,  528,  542, 1209,  329,  861,
 /*  2470 */   685,  860,  859,  860,  859,  775,  576,  322,  828,  337,
 /*  2480 */   775,  420,  861,  681,  544,  860,  859,  682,  659,  680,
 /*  2490 */  1209,  861,  861,  816,  543,  861,  816,  828,  806,   12,
 /*  2500 */   375,  829,  238, 1209,  362, 1209, 1209,  652,  861,  828,
 /*  2510 */   528,  861,  651,  374, 1209,  775, 1209, 1209,  861, 1209,
 /*  2520 */   829,  237,  160,  861,  650,  527,  828,  649,  302,  528,
 /*  2530 */   106,  445,  829,  209,   30,  640,  777, 1209,  828,  861,
 /*  2540 */   861,  528,  861,  860,  859,  828,  860,  859,  159,  829,
 /*  2550 */   124,  158,  861,  292,  137,  860,  859,  288,  528,  861,
 /*  2560 */   775,  829,  208,  427,  828,  258,  289,  861,  829,  206,
 /*  2570 */   528,  861,  656,  860,  859,   31,  321,  528,  861,  775,
 /*  2580 */   861,  443,  156,  318,  199,  631,  104,  829,  234,  136,
 /*  2590 */   155,  775,  627,  314,  783,  154,  528,  191,  828,  111,
 /*  2600 */   828,  310,  828,  738,  434,  828,  621,  617,  775,  433,
 /*  2610 */   615,  134,  861,  153,  861,  421,  861,  828,  133,  861,
 /*  2620 */   775,  829,  236,  829,  229,  829,  235,  775,  829,  224,
 /*  2630 */   528,  861,  528,  595,  528,  151,  418,  528,  828,  100,
 /*  2640 */   829,  221,  416,  828,  150,   99,  775,  149,   98,  528,
 /*  2650 */   148,   97,  861,  147,   30,  565,  388,  861,  146,   29,
 /*  2660 */   552,  829,  205,  550,  131,  828,  829,  204,  546,  828,
 /*  2670 */   528,  828,   26,  130,  145,  528,   83,  540,  186,  861,
 /*  2680 */   775,  200,  775,  861,  775,  861,  360,  775,  829,  203,
 /*  2690 */   786,  801,  829,  202,  829,  214,  511,  528,  189,  775,
 /*  2700 */   828,  528,  188,  528,   60,  828,  797,  828,  743,  733,
 /*  2710 */   338,  677,  244,  315,  861,  454,  319,  440,  370,  861,
 /*  2720 */   775,  861,  620,  829,  219,  775,  819,    9,  829,  218,
 /*  2730 */   829,  125,  528,  796,  785,   41,  828,  528,  664,  528,
 /*  2740 */   444,  828,  361,  257,  525,  762,  674,  775,  668,   95,
 /*  2750 */   861,  775,  695,  775,  655,  861,  828,  667,  694,  829,
 /*  2760 */   217,  589,  828,   81,  829,  216,  862, 1359,  528, 1359,
 /*  2770 */   861, 1359, 1359,  528, 1359, 1359,  861, 1359, 1359,  829,
 /*  2780 */   222,  828,  775,  828, 1359,  829,  220,  775,  528,  775,
 /*  2790 */  1359, 1359, 1359, 1359,  528,  861, 1359,  861, 1359, 1359,
 /*  2800 */  1359, 1359, 1359, 1359,  829,  207,  829,   93, 1359, 1359,
 /*  2810 */  1359, 1359, 1359,  528, 1359,  479, 1359, 1359,  775, 1359,
 /*  2820 */  1359, 1359, 1359,  775, 1359, 1359, 1359, 1359, 1359, 1359,
 /*  2830 */  1359, 1359, 1359, 1359, 1359, 1359, 1359, 1359,  775, 1359,
 /*  2840 */  1359, 1359, 1359, 1359,  775, 1359, 1359, 1359, 1359, 1359,
 /*  2850 */  1359, 1359, 1359, 1359, 1359, 1359, 1359, 1359, 1359, 1359,
 /*  2860 */  1359, 1359, 1359,  775, 1359,  775,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     4,  131,   24,   31,  134,  135,  136,   50,   81,   82,
 /*    10 */    83,   84,   16,   41,   87,   88,   89,   90,   91,   92,
 /*    20 */    93,   94,  152,   96,   97,   98,   99,  100,  101,  102,
 /*    30 */   103,  104,  105,  106,  107,  102,  109,  117,   81,   82,
 /*    40 */    83,   84,  122,  122,   87,   88,   89,   90,   91,   92,
 /*    50 */    93,   94,   56,   96,   97,   98,   99,  100,  101,  102,
 /*    60 */   103,  104,  105,  106,  107,  144,  109,  102,  103,  104,
 /*    70 */   105,  106,  107,   77,  148,   91,   92,   93,   94,   83,
 /*    80 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*    90 */   106,  107,  159,    4,  116,  162,  100,  101,  102,   42,
 /*   100 */    43,  203,  203,  177,  108,  109,   83,  211,   68,   44,
 /*   110 */     4,   71,  116,  117,  122,  217,  217,  121,  122,  203,
 /*   120 */   109,  125,   16,  127,  128,  226,  227,  132,  133,  133,
 /*   130 */    24,    4,   68,  217,  235,   71,  140,  141,  142,  143,
 /*   140 */   242,  145,   85,   86,  248,  249,    4,    9,   83,   11,
 /*   150 */   158,   13,  160,  161,  158,  115,  160,  161,  203,   80,
 /*   160 */   164,   23,   56,  113,   26,  169,  170,  171,  172,  173,
 /*   170 */   174,  175,  217,  277,  178,  279,  180,  181,  282,  115,
 /*   180 */   203,  226,  227,   77,  285,  162,   43,  288,  192,   83,
 /*   190 */   235,  293,   54,  117,  217,  116,  117,   59,  302,  303,
 /*   200 */   223,  224,   64,   65,  117,  116,  100,  101,   70,  122,
 /*   210 */   121,   73,   19,   75,  108,  109,  127,  128,  263,  264,
 /*   220 */     4,  203,  116,  117,    4,  185,   83,  121,  122,  140,
 /*   230 */   314,  125,   16,  127,  128,  217,  122,    5,   45,  133,
 /*   240 */   285,  223,  224,  116,  155,  118,  140,  141,  142,  143,
 /*   250 */   112,  145,  114,  122,  127,  166,  167,  203,  116,  182,
 /*   260 */    67,  184,   30,  121,  158,  203,  160,  161,   36,  127,
 /*   270 */   128,  217,   56,  296,  297,  169,  170,  171,  172,  217,
 /*   280 */   174,  175,  140,  116,  178,  118,  180,  181,  145,    4,
 /*   290 */   163,  153,   60,   77,  151,  164,   64,  155,  192,   83,
 /*   300 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*   310 */   106,  107,   35,   21,  296,  297,  100,  101,  117,   60,
 /*   320 */    28,  122,  203,  122,  108,  109,  117,  128,  190,   37,
 /*   330 */   211,  122,  116,  117,   57,  145,  217,  121,  122,    5,
 /*   340 */    63,  125,    4,  127,  128,  226,  227,  127,  128,  133,
 /*   350 */   196,  197,  198,  199,  235,  165,  140,  141,  142,  143,
 /*   360 */   140,  145,  117,  170,   30,  166,  167,  122,  249,  169,
 /*   370 */    36,  317,  318,  319,  158,  133,  160,  161,  316,  203,
 /*   380 */    42,   43,  263,  264,    7,  169,  203,  171,  172,   12,
 /*   390 */   174,  175,  192,  217,  178,  175,  180,  181,   64,  122,
 /*   400 */   217,  116,  226,  227,  285,  146,  147,  148,  192,  226,
 /*   410 */   227,  235,  127,  128,   26,  156,  157,   40,  235,   81,
 /*   420 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   430 */    92,   93,   94,   90,   96,   97,   98,   99,  100,  101,
 /*   440 */   102,  103,  104,  105,  106,  107,  100,  101,  102,  103,
 /*   450 */   104,  105,  106,  107,  141,  142,  118,  117,  275,  116,
 /*   460 */   175,  285,  122,   42,   43,  127,  308,  309,  285,   81,
 /*   470 */    82,   83,   84,   52,  116,   87,   88,   89,   90,   91,
 /*   480 */    92,   93,   94,   76,   96,   97,   98,   99,  100,  101,
 /*   490 */   102,  103,  104,  105,  106,  107,  320,  122,  119,  323,
 /*   500 */    80,  163,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   510 */    89,   90,   91,   92,   93,   94,    4,   96,   97,   98,
 /*   520 */    99,  100,  101,  102,  103,  104,  105,  106,  107,   10,
 /*   530 */   117,  291,  203,  127,  133,  122,  116,  117,  119,  133,
 /*   540 */   203,   22,  122,  122,  169,  208,  217,  141,  142,  143,
 /*   550 */   213,  214,  151,  116,  217,  226,  227,  222,  223,  224,
 /*   560 */   153,   42,   43,  215,  235,  325,  326,  219,  220,  221,
 /*   570 */   182,   73,  184,   91,   92,   93,   94,   95,   96,   97,
 /*   580 */    98,   99,  100,  101,  102,  103,  104,  105,  106,  107,
 /*   590 */   217,    4,  263,  264,  100,  101,    4,   26,  191,  226,
 /*   600 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   610 */    91,   92,   93,   94,  285,   96,   97,   98,   99,  100,
 /*   620 */   101,  102,  103,  104,  105,  106,  107,    4,  116,   35,
 /*   630 */   132,  203,  297,  121,  117,  141,  142,   10,  233,  127,
 /*   640 */   128,  236,  203,   42,   43,  217,  207,   53,  243,   22,
 /*   650 */    58,   57,   81,   82,   83,   84,  217,   63,   87,   88,
 /*   660 */    89,   90,   91,   92,   93,   94,    4,   96,   97,   98,
 /*   670 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  146,
 /*   680 */   147,  148,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   690 */    89,   90,   91,   92,   93,   94,  122,   96,   97,   98,
 /*   700 */    99,  100,  101,  102,  103,  104,  105,  106,  107,   32,
 /*   710 */   203,  122,  120,  126,  127,  128,  203,   13,  131,  127,
 /*   720 */   128,  134,  135,  136,  217,  117,  213,  214,  203,  260,
 /*   730 */   217,  262,   55,  250,  251,  210,  253,  212,   43,  152,
 /*   740 */   225,   21,  217,  120,  121,  317,  318,  319,  233,  234,
 /*   750 */   127,  128,  239,  182,  241,  184,    4,   37,   81,   82,
 /*   760 */    83,   84,  173,  169,   87,   88,   89,   90,   91,   92,
 /*   770 */    93,   94,   38,   96,   97,   98,   99,  100,  101,  102,
 /*   780 */   103,  104,  105,  106,  107,   81,   82,   83,   84,  127,
 /*   790 */   128,   87,   88,   89,   90,   91,   92,   93,   94,   35,
 /*   800 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*   810 */   106,  107,    4,  109,  195,    4,  154,   83,  203,  200,
 /*   820 */    34,   57,  315,  316,   16,  203,   74,   63,   66,   79,
 /*   830 */   211,  291,  217,  211,   72,   81,   82,   83,   84,  217,
 /*   840 */   145,   87,   88,   89,   90,   91,   92,   93,   94,  117,
 /*   850 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*   860 */   106,  107,    4,  203,   56,  325,  326,  248,  249,   83,
 /*   870 */   203,  249,  118,  105,  106,  107,  124,  217,   80,  127,
 /*   880 */   128,   73,  267,  268,  217,   77,  226,  227,   77,  267,
 /*   890 */   268,   83,  122,  107,  117,  235,  277,  135,  279,  203,
 /*   900 */   255,  282,  211,  207,  118,  222,  223,  224,  100,  101,
 /*   910 */   265,  100,  101,  217,  116,  117,  108,  131,  132,  133,
 /*   920 */   134,  135,  136,  137,  116,  117,  307,  116,  116,  121,
 /*   930 */   146,  147,  148,  125,  164,  127,  128,  151,  127,  248,
 /*   940 */   249,  133,   80,  193,  133,  285,  117,  185,  140,  141,
 /*   950 */   142,  143,  141,  142,  143,  219,  220,  221,  116,    4,
 /*   960 */   293,  117,   26,  203,  156,  157,  122,  244,  277,  246,
 /*   970 */   279,  250,  251,  282,  253,   26,  118,  217,  116,  117,
 /*   980 */   297,  203,    4,  175,  122,  127,  178,  117,  180,  181,
 /*   990 */    81,   82,   83,   84,  303,  217,   87,   88,   89,   90,
 /*  1000 */    91,   92,   93,   94,  283,   96,   97,   98,   99,  100,
 /*  1010 */   101,  102,  103,  104,  105,  106,  107,   81,   82,   83,
 /*  1020 */    84,  163,   73,   87,   88,   89,   90,   91,   92,   93,
 /*  1030 */    94,   44,   96,   97,   98,   99,  100,  101,  102,  103,
 /*  1040 */   104,  105,  106,  107,   81,   82,   83,   84,  217,  218,
 /*  1050 */    87,   88,   89,   90,   91,   92,   93,   94,  109,   96,
 /*  1060 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*  1070 */   107,  117,  312,  295,  314,  120,  121,    0,   81,   82,
 /*  1080 */    83,   84,  127,  128,   87,   88,   89,   90,   91,   92,
 /*  1090 */    93,   94,  183,   96,   97,   98,   99,  100,  101,  102,
 /*  1100 */   103,  104,  105,  106,  107,  127,   29,  129,    4,   81,
 /*  1110 */    82,   83,   84,  122,  117,   87,   88,   89,   90,   91,
 /*  1120 */    92,   93,   94,  203,   96,   97,   98,   99,  100,  101,
 /*  1130 */   102,  103,  104,  105,  106,  107,  159,  217,    4,  162,
 /*  1140 */   116,   81,   82,   83,   84,  117,  183,   87,   88,   89,
 /*  1150 */    90,   91,   92,   93,   94,   26,   96,   97,   98,   99,
 /*  1160 */   100,  101,  102,  103,  104,  105,  106,  107,  182,  198,
 /*  1170 */   199,  117,   81,   82,   83,   84,  122,  117,   87,   88,
 /*  1180 */    89,   90,   91,   92,   93,   94,  109,   96,   97,   98,
 /*  1190 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  117,
 /*  1200 */   280,    4,  117,   81,   82,   83,   84,  122,  117,   87,
 /*  1210 */    88,   89,   90,   91,   92,   93,   94,  219,   96,   97,
 /*  1220 */    98,   99,  100,  101,  102,  103,  104,  105,  106,  107,
 /*  1230 */   162,  127,  128,  117,   81,   82,   83,   84,  122,  117,
 /*  1240 */    87,   88,   89,   90,   91,   92,   93,   94,    4,   96,
 /*  1250 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*  1260 */   107,  127,  128,   15,  266,    4,   81,   82,   83,   84,
 /*  1270 */   166,  118,   87,   88,   89,   90,   91,   92,   93,   94,
 /*  1280 */   219,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*  1290 */   105,  106,  107,   45,  109,   81,   82,   83,   84,    4,
 /*  1300 */   166,   87,   88,   89,   90,   91,   92,   93,   94,   61,
 /*  1310 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*  1320 */   106,  107,    4,  109,  127,  128,  117,  266,  203,  203,
 /*  1330 */   219,  122,  207,   73,   16,  138,  164,   19,   81,   82,
 /*  1340 */    83,   84,  217,  217,   87,   88,   89,   90,   91,   92,
 /*  1350 */    93,   94,    4,   96,   97,   98,   99,  100,  101,  102,
 /*  1360 */   103,  104,  105,  106,  107,  121,  164,  203,    4,  109,
 /*  1370 */   203,  127,  128,  117,   56,  211,   14,  266,  122,  211,
 /*  1380 */    16,  217,  121,   19,  217,    4,    4,   69,  127,  128,
 /*  1390 */   226,  227,  203,  226,  227,   77,  203,  286,  150,  235,
 /*  1400 */   118,   83,  235,   85,    4,  212,  217,  203,  122,  117,
 /*  1410 */   217,  116,  122,  249,  122,  226,  227,  249,  100,  101,
 /*  1420 */    56,  217,  127,  128,  235,  116,  108,  263,  203,    4,
 /*  1430 */   263,  264,  188,   69,  116,   35,    4,  117,  312,  121,
 /*  1440 */   314,   77,  217,  125,  211,  127,  128,   83,  187,  285,
 /*  1450 */     4,  133,  285,   53,  203,  203,  255,   57,  140,  141,
 /*  1460 */   142,  143,   16,   63,  100,  101,  265,    4,  217,  217,
 /*  1470 */   175,  244,  108,  246,  285,  127,  128,    4,  226,  227,
 /*  1480 */   116,  203,  249,   14,  280,  121,  203,  235,  140,  125,
 /*  1490 */    47,  127,  128,  175,    4,  217,  178,  133,  180,  181,
 /*  1500 */   217,  203,   56,  121,  140,  141,  142,  143,  127,  127,
 /*  1510 */   128,  322,  323,  211,   32,  217,  168,  203,  211,   73,
 /*  1520 */   139,  139,  140,   77,  226,  227,   82,  127,  128,   83,
 /*  1530 */   211,  217,   62,  235,    4,  318,  319,  285,    4,  175,
 /*  1540 */   226,  227,  178,  111,  180,  181,  100,  101,   62,  235,
 /*  1550 */   168,  249,  127,  128,  108,   55,  249,  274,   14,  127,
 /*  1560 */   128,  263,  116,  100,  101,  140,    4,  121,  249,  169,
 /*  1570 */     4,  125,  320,  127,  128,  323,  219,  263,  203,  133,
 /*  1580 */   155,  205,  207,  285,  318,  319,  140,  141,  142,  143,
 /*  1590 */   127,  128,  217,   14,  121,  132,   14,  286,  203,  285,
 /*  1600 */   127,  128,  156,  157,  141,  142,    4,    4,  145,    4,
 /*  1610 */   147,  121,  217,  140,  318,  319,  305,  127,  128,   16,
 /*  1620 */    29,  175,   19,  266,  178,   14,  180,  181,   81,   82,
 /*  1630 */    83,   84,  156,  157,   87,   88,   89,   90,   91,   92,
 /*  1640 */    93,   94,    4,   96,   97,   98,   99,  100,  101,  102,
 /*  1650 */   103,  104,  105,  106,  107,  203,  116,  127,  128,   56,
 /*  1660 */   229,  127,  128,  268,  318,  319,    4,  203,  292,  217,
 /*  1670 */   140,  203,   69,  219,  140,  122,  186,  111,  226,  227,
 /*  1680 */    77,  217,  203,  203,  203,  217,   83,  235,   14,  127,
 /*  1690 */   226,  227,    4,  127,  128,  203,  217,  217,  217,  235,
 /*  1700 */   109,  139,  168,  100,  101,  226,  227,  226,  227,  217,
 /*  1710 */   242,  108,  318,  319,  235,   38,  235,  286,  116,  116,
 /*  1720 */   266,  117,  229,  117,  121,  117,  121,  275,  125,  127,
 /*  1730 */   127,  128,  127,  128,  242,    4,  133,  285,  166,  275,
 /*  1740 */   119,  203,  263,  140,  141,  142,  143,  119,  203,  285,
 /*  1750 */     4,  213,  214,  203,    4,  217,  275,  207,  102,  154,
 /*  1760 */   203,  293,  217,  122,  285,  127,  285,  217,  203,  159,
 /*  1770 */   116,  226,  227,  111,  217,  117,    4,  139,  175,  286,
 /*  1780 */   235,  178,  217,  180,  181,  293,   82,   83,   84,  127,
 /*  1790 */   128,   87,   88,   89,   90,   91,   92,   93,   94,  111,
 /*  1800 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*  1810 */   106,  107,    4,  116,  116,  127,  128,  117,  117,   73,
 /*  1820 */   275,    4,  117,  117,   16,  117,   50,   83,   84,    4,
 /*  1830 */   285,   87,   88,   89,   90,   91,   92,   93,   94,  274,
 /*  1840 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*  1850 */   106,  107,  203,   18,    4,  203,  203,    4,  127,  128,
 /*  1860 */   173,  116,  116,  117,   56,    6,  217,  121,  203,  217,
 /*  1870 */   217,  121,    4,  127,  128,  226,  227,  127,  128,  226,
 /*  1880 */   227,  203,  217,  203,  235,   77,  140,  118,  235,    4,
 /*  1890 */   140,   83,    8,  121,  116,  217,    4,  217,   50,  127,
 /*  1900 */   128,  155,  156,  157,  116,  203,    4,  117,  100,  101,
 /*  1910 */   179,  116,  263,  116,    4,   50,  108,  203,  168,  217,
 /*  1920 */   116,    4,  242,  203,  116,  117,   16,  102,  203,  121,
 /*  1930 */   137,  217,  207,  125,  285,  127,  128,  217,  285,   83,
 /*  1940 */   203,  133,  217,  203,  127,  128,  226,  227,  140,  141,
 /*  1950 */   142,  143,  127,  128,  217,  235,  151,  217,  125,  118,
 /*  1960 */   145,  189,   13,  226,  227,  140,   56,  164,  203,  122,
 /*  1970 */     4,  121,  235,  293,  121,    4,  274,  127,  128,   90,
 /*  1980 */   127,  128,  217,  175,  150,  203,  178,   77,  180,  181,
 /*  1990 */   140,  123,  175,   83,   90,  127,  128,   90,    4,  217,
 /*  2000 */   175,  203,   90,  176,   24,  285,  121,   18,  226,  227,
 /*  2010 */   100,  101,  127,  128,  274,  217,    4,  235,  108,  127,
 /*  2020 */   128,  168,  285,  121,  226,  227,  116,  117,   16,  127,
 /*  2030 */   128,  121,  203,  235,  203,  125,  150,  127,  128,    4,
 /*  2040 */   155,  177,  140,  133,  127,  128,  217,  203,  217,  203,
 /*  2050 */   140,  141,  142,  143,    4,  226,  227,  226,  227,    4,
 /*  2060 */   168,  217,    4,  217,  235,  157,  235,  285,   56,  109,
 /*  2070 */   226,  227,  226,  227,  109,   62,    4,   25,  203,  235,
 /*  2080 */   163,  235,  203,  285,   51,  175,  207,  121,  178,   77,
 /*  2090 */   180,  181,  217,  127,  128,   83,  217,  203,  127,  128,
 /*  2100 */   122,  226,  227,  203,   51,  185,  140,  207,  145,  203,
 /*  2110 */   235,  217,  100,  101,  285,  121,  285,  217,    4,  116,
 /*  2120 */   108,  127,  128,  217,  115,    4,  165,  203,  116,  285,
 /*  2130 */    16,  285,  125,  121,  140,  203,  116,  125,  117,  127,
 /*  2140 */   128,  217,  203,  115,  203,  133,  175,  117,   49,  217,
 /*  2150 */   226,  227,  140,  141,  142,  143,  217,    4,  217,  235,
 /*  2160 */   285,    4,  127,  128,    4,  226,  227,  226,  227,  113,
 /*  2170 */    56,   48,  216,  286,  235,  140,  235,  127,  128,    4,
 /*  2180 */   274,  309,  127,  128,    4,  127,  128,  175,  116,  203,
 /*  2190 */   178,   77,  180,  181,  182,  140,  203,   83,  269,  127,
 /*  2200 */   128,  232,    4,  217,  203,    4,  232,  149,  311,  285,
 /*  2210 */   217,  110,  226,  227,  100,  101,  311,  202,  217,  203,
 /*  2220 */     4,  235,  108,  207,  285,  202,  285,  226,  227,  203,
 /*  2230 */   116,  117,   16,  217,  202,  121,  235,   65,  188,  125,
 /*  2240 */   202,  127,  128,  217,    4,  204,  203,  133,  127,  128,
 /*  2250 */   207,  203,  226,  227,  140,  141,  142,  143,    4,  138,
 /*  2260 */   217,  235,    4,  203,    4,  217,    4,  204,  206,   78,
 /*  2270 */   209,  285,   56,  120,  226,  227,  203,  217,  122,  257,
 /*  2280 */   127,  128,  203,  235,  127,  128,  285,  127,  128,  175,
 /*  2290 */   217,    4,  178,   77,  180,  181,  217,  140,  119,   83,
 /*  2300 */   140,  272,  127,  128,  156,  226,  227,  127,  128,  258,
 /*  2310 */   251,  285,    4,  203,  235,  140,  100,  101,  173,  170,
 /*  2320 */   140,  120,    4,  259,  108,  127,  128,  217,  127,  128,
 /*  2330 */   171,  203,  116,  285,   16,  261,  172,  121,  203,  203,
 /*  2340 */   107,  125,  231,  127,  128,  217,  203,  116,    4,  133,
 /*  2350 */     4,  294,  217,  217,  226,  227,  140,  141,  142,  143,
 /*  2360 */   217,  203,    4,  235,  285,  203,  107,  127,  128,  226,
 /*  2370 */   227,  118,  289,  260,   56,  217,  182,  169,  235,  217,
 /*  2380 */    35,  127,  128,  313,  186,  127,  128,  127,  128,  127,
 /*  2390 */   128,  175,  203,  203,  178,   77,  180,  181,  203,  261,
 /*  2400 */   140,   83,   57,  276,   27,   46,  217,  217,   63,  155,
 /*  2410 */   276,  321,  217,  285,  127,  128,  226,  227,  100,  101,
 /*  2420 */     4,  226,  227,    4,  203,  235,  108,  140,  285,  189,
 /*  2430 */   235,  119,    4,  203,  116,  127,  128,  321,  217,  121,
 /*  2440 */   272,  253,  157,  125,  326,  127,  128,  217,  193,  187,
 /*  2450 */     4,  133,  228,  228,  109,  203,  226,  227,  140,  141,
 /*  2460 */   142,  143,  117,   39,  145,  235,  120,  122,  203,  217,
 /*  2470 */   238,  127,  128,  127,  128,  285,  168,  203,  203,  228,
 /*  2480 */   285,  203,  217,  144,  140,  127,  128,  230,  238,  228,
 /*  2490 */   145,  217,  217,  175,  203,  217,  178,  203,  180,  181,
 /*  2500 */   231,  226,  227,  158,  203,  160,  161,  228,  217,  203,
 /*  2510 */   235,  217,  228,  231,  169,  285,  171,  172,  217,  174,
 /*  2520 */   226,  227,  119,  217,  228,  203,  203,  228,  203,  235,
 /*  2530 */   206,  231,  226,  227,  176,  272,  120,  192,  203,  217,
 /*  2540 */   217,  235,  217,  127,  128,  203,  127,  128,  119,  226,
 /*  2550 */   227,  119,  217,  203,  206,  127,  128,  203,  235,  217,
 /*  2560 */   285,  226,  227,   33,  203,  272,  203,  217,  226,  227,
 /*  2570 */   235,  217,  126,  127,  128,  182,  300,  235,  217,  285,
 /*  2580 */   217,  301,  119,  257,  174,  278,  245,  226,  227,   81,
 /*  2590 */   119,  285,  278,  257,  175,  119,  235,  281,  203,  116,
 /*  2600 */   203,  284,  203,  175,  145,  203,  278,  278,  285,  257,
 /*  2610 */   245,  206,  217,  119,  217,  272,  217,  203,  206,  217,
 /*  2620 */   285,  226,  227,  226,  227,  226,  227,  285,  226,  227,
 /*  2630 */   235,  217,  235,  257,  235,  119,  272,  235,  203,  247,
 /*  2640 */   226,  227,   78,  203,  119,  247,  285,  119,  247,  235,
 /*  2650 */   119,  247,  217,  119,  176,  295,  272,  217,  119,  304,
 /*  2660 */    20,  226,  227,  272,  119,  203,  226,  227,  272,  203,
 /*  2670 */   235,  203,  304,  119,  119,  235,  306,   17,  306,  217,
 /*  2680 */   285,  254,  285,  217,  285,  217,  256,  285,  226,  227,
 /*  2690 */   229,  297,  226,  227,  226,  227,  290,  235,  260,  285,
 /*  2700 */   203,  235,  260,  235,  286,  203,  297,  203,  271,  273,
 /*  2710 */   229,  236,  240,  256,  217,  230,  273,  273,  201,  217,
 /*  2720 */   285,  217,  257,  226,  227,  285,  219,  254,  226,  227,
 /*  2730 */   226,  227,  235,  219,  219,  287,  203,  235,  219,  235,
 /*  2740 */   299,  203,  252,  298,  246,  324,  237,  285,  237,  270,
 /*  2750 */   217,  285,  226,  285,  241,  217,  203,  237,  226,  226,
 /*  2760 */   227,  310,  203,   73,  226,  227,    4,  327,  235,  327,
 /*  2770 */   217,  327,  327,  235,  327,  327,  217,  327,  327,  226,
 /*  2780 */   227,  203,  285,  203,  327,  226,  227,  285,  235,  285,
 /*  2790 */   327,  327,  327,  327,  235,  217,  327,  217,  327,  327,
 /*  2800 */   327,  327,  327,  327,  226,  227,  226,  227,  327,  327,
 /*  2810 */   327,  327,  327,  235,  327,  235,  327,  327,  285,  327,
 /*  2820 */   327,  327,  327,  285,  327,  327,  327,  327,  327,  327,
 /*  2830 */   327,  327,  327,  327,  327,  327,  327,  327,  285,  327,
 /*  2840 */   327,  327,  327,  327,  285,  327,  327,  327,  327,  327,
 /*  2850 */   327,  327,  327,  327,  327,  327,  327,  327,  327,  327,
 /*  2860 */   327,  327,  327,  285,  327,  285,
};
#define YY_SHIFT_USE_DFLT (-131)
#define YY_SHIFT_COUNT (534)
#define YY_SHIFT_MIN   (-130)
#define YY_SHIFT_MAX   (2762)
static const short yy_shift_ofst[] = {
 /*     0 */  1591,  808, 1446,  138, 1318, 1603, 1364, 2114, 2114, 2114,
 /*    10 */  1260,  216, 2012, 2216, 2318, 2216, 2216, 2216, 2216, 2216,
 /*    20 */  2216,  949,   -4,  106, 1910, 1808, 2216, 2216, 2216, 2216,
 /*    30 */  2216, 2216, 2216, 2216, 2216, 2216, 2216, 2216, 2318, 2216,
 /*    40 */  2216, 2216, 2216, 2216, 2216, 2216, 2216, 2216, 2216, 2216,
 /*    50 */  2216, 2216, 2216, 2216, 2216, 2216, 2216, 2216, 2216, 2216,
 /*    60 */  2216, 2216, 2216, 2216, 2216, 2216, 2216, 2216, 2216, 2216,
 /*    70 */  2216, 2216, 1746, 1463, 1463,  587, 1400, 1400, 2446,   89,
 /*    80 */   259,  592,  752, 2446, 2419, 2419, 2419, 2416, 2419,  494,
 /*    90 */   494, 2258,  978,  338,  786,  142, 1994, 1772, 1853, 1885,
 /*   100 */  1966, 1295, 1902, 1295, 1850, 1473, 1605,  752,  955, 2358,
 /*   110 */  2428, 2428, 2428, 2428,  143, 2428, 2419, 2258, 2258,  978,
 /*   120 */   750,  750, 1476,  519,  519,  -43,  811, 1382, 1750, 1825,
 /*   130 */  1534, 1348, 1261,  623, 1490,  285,  232, 1244,  232, 1425,
 /*   140 */   127,  594,  220,  512, 2346, 2344, 2262, 2240, 2308, 2254,
 /*   150 */  2287, 2201, 2260, 2198, 2180, 2175, 2160, 2055, 2050,  662,
 /*   160 */  2153, 2157, 2121, 2058, 2035, 2072, 1134, 1104,  858,  858,
 /*   170 */   858, 1892, 1917, 1971,  277,  277, 1731, 1817, 1530, 1197,
 /*   180 */  1868,  762, 1688, 1662, 1566, 1432, 2258, 2258,  764,  764,
 /*   190 */  1077,  498,  200, 2690, 2690, 2762, 2690, 2690, -131, -131,
 /*   200 */  -131,  421,  601,  601,  601,  601,  601,  601,  601,  601,
 /*   210 */   601,  601,  571,  388,  704,  677, 1214, 1185, 1153,  -73,
 /*   220 */  1122, 1091, 1060, 1028,  997,  963,  936,  909,  754, 1547,
 /*   230 */  1257, 1704, 1744, 1744,  482,  -16,  -16,  -16,  -16,  -16,
 /*   240 */   -16,  204,  346,  -35, -130,  406,  406,  862,  420, 1248,
 /*   250 */  1248, 1248,  199,  193,  334,   -8,   57,  784,  377, 1638,
 /*   260 */  1562, 1602,  768, 1381,  -67,  292,  589,  770,  734,  734,
 /*   270 */   -79, 1292,  695,  627,  734,  190,  375,  375,   77,  627,
 /*   280 */   313,  313,   23,  131,  977, 2660, 2660, 2555, 2554, 2545,
 /*   290 */  2640, 2640, 2539, 2478, 2534, 2564, 2531, 2564, 2528, 2564,
 /*   300 */  2525, 2564, 2516, 2191, 2145, 2494, 2191, 2508, 2410, 2145,
 /*   310 */  2410, 2459, 2483, 2476, 2410, 2145, 2471, 2508, 2410, 2145,
 /*   320 */  2463, 2393, 2530, 2432, 2191, 2429, 2231, 2191, 2403, 2231,
 /*   330 */  2319, 2319, 2319, 2319, 2424, 2231, 2319, 2339, 2319, 2424,
 /*   340 */  2319, 2319, 2255, 2285, 2312, 2377, 2377, 2359, 2359, 2164,
 /*   350 */  2208, 2194, 2253, 2259, 2231, 2233, 2233, 2164, 2159, 2149,
 /*   360 */  2145, 2148, 2179, 2156, 2191, 2172, 2172, 2101, 2101, 2101,
 /*   370 */  2101, -131, -131, -131, -131, -131, -131, -131, -131, -131,
 /*   380 */  -131, 2345,   40,  407,  798,   79,  533,   64,  343, 1256,
 /*   390 */  1209,  -74, 1116,  -22, 1085, 1054,  844,  413,  340,   -5,
 /*   400 */   720,  401,  245,  209,  -28,   65,  201,   87,  -80,  167,
 /*   410 */  2123, 2099, 2056, 2028, 2030, 2021, 2007, 2020, 1961, 2009,
 /*   420 */  2003, 1963, 1920, 2053, 1978, 2033, 2013, 2052, 1965, 1960,
 /*   430 */  1908, 1864, 1886, 1980, 1989, 1827, 1912, 1907, 1904, 1889,
 /*   440 */  1834, 1847, 1803, 1949, 1815, 1841, 1833, 1856, 1805, 1793,
 /*   450 */  1804, 1865, 1797, 1795, 1790, 1788, 1848, 1884, 1778, 1769,
 /*   460 */  1859, 1745, 1776, 1835, 1708, 1687, 1698, 1706, 1705, 1701,
 /*   470 */  1700, 1641, 1610, 1697, 1658, 1654, 1641, 1656, 1628, 1621,
 /*   480 */  1572, 1608, 1606, 1553, 1604, 1677, 1674, 1540, 1553, 1611,
 /*   490 */  1582, 1579, 1544, 1500, 1486, 1482, 1444, 1470, 1443, 1469,
 /*   500 */  1320, 1309, 1282, 1290, 1286, 1362, 1202, 1172, 1068, 1082,
 /*   510 */   986, 1129,  991,  954, 1024,  987,  991,  870,  842,  829,
 /*   520 */   777,  812,  732,  608,  517,  574,  437,  419,  379,  242,
 /*   530 */   358,  114,   76,   50,   11,
};
#define YY_REDUCE_USE_DFLT (-105)
#define YY_REDUCE_COUNT (380)
#define YY_REDUCE_MIN   (-104)
#define YY_REDUCE_MAX   (2580)
static const short yy_reduce_ofst[] = {
 /*     0 */   154,  119, 1164,  619, 1252, 1189,  176, 1167,  329,  -45,
 /*    10 */  -104, 1649, -101, 1545, 1481, 1479, 1464, 1452, 1314, 1298,
 /*    20 */   183,  691, 2580, 2578, 2559, 2553, 2538, 2533, 2504, 2502,
 /*    30 */  2497, 2468, 2466, 2462, 2440, 2435, 2414, 2402, 2399, 2397,
 /*    40 */  2395, 2361, 2342, 2335, 2323, 2306, 2294, 2275, 2230, 2195,
 /*    50 */  2190, 2143, 2128, 2079, 2048, 2026, 2001, 1986, 1941, 1939,
 /*    60 */  1924, 1875, 1846, 1844, 1831, 1829, 1798, 1782, 1737, 1720,
 /*    70 */  1653,  660,  622,   18,  -23,  513,  428,   54,  337,  615,
 /*    80 */   721, 1126,  525, 1538, 1680, 1492, 1468,  760, -102,  683,
 /*    90 */   335,  507,  348, 1111,  515, 1395, 2043, 2016, 1900, 1879,
 /*   100 */  1725, 1204, 1550,  920, 1375, 1125,  696, 1193,  439,  778,
 /*   110 */  1906, 1740, 1702, 1565,  405, 1283,  667,   62,  -84,  736,
 /*   120 */   540,  240,  483, 1493, 1431, 1311,  373, 2363, 2354, 2322,
 /*   130 */  1894, 1894, 2350, 2325, 2136, 1932, 1227, 1714,  723, 1894,
 /*   140 */  1454, 1394, 2322, 2301, 2291, 1894, 1894, 1894, 1894, 1894,
 /*   150 */  1894, 1894, 2278, 1894, 1894, 1894, 1894, 2274, 1894, 1894,
 /*   160 */  1894, 2265, 2252, 2221, 2189, 2162, 2158, 2135, 1357, 1061,
 /*   170 */   998, 2110, 2073, 1665, 1346, 1296, 2060, 1993, 1894, 1765,
 /*   180 */  1678, 1376, 1652, 1557, 1480, 1278, 1251, 1225, 1266, 1217,
 /*   190 */   971, 1319,  469, 1307, 1302,  831, 1233, 1168,  158, 1201,
 /*   200 */   645, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
 /*   210 */  1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
 /*   220 */  1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
 /*   230 */  1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887, 1887,
 /*   240 */  1887, 1887, 1887, 1887, 2513, 2532, 2526, 2451, 2451, 2520,
 /*   250 */  2511, 2509, 2479, 2421, 2498, 2490, 2448, 2441, 2445, 2519,
 /*   260 */  2515, 2514, 1887, 2507, 2473, 2517, 2465, 2457, 2444, 2443,
 /*   270 */  2485, 2472, 2475, 2481, 2436, 2437, 2442, 2438, 2406, 2461,
 /*   280 */  2409, 2394, 2418, 2430, 2427, 2372, 2370, 2263, 2396, 2391,
 /*   290 */  2368, 2355, 2384, 2360, 2263, 2404, 2263, 2401, 2263, 2398,
 /*   300 */  2263, 2392, 2364, 2412, 2376, 2343, 2405, 2365, 2329, 2352,
 /*   310 */  2328, 2317, 2316, 2263, 2314, 2336, 2263, 2341, 2307, 2326,
 /*   320 */  2263, 2280, 2276, 2293, 2348, 2263, 2300, 2324, 2263, 2282,
 /*   330 */  2299, 2296, 2284, 2279, 2250, 2269, 2261, 2257, 2251, 2232,
 /*   340 */  2225, 2224, 2118, 2188, 2168, 2116, 2090, 2134, 2127, 2138,
 /*   350 */  2113, 2083, 2070, 2057, 2111, 1887, 1887, 2074, 2064, 2051,
 /*   360 */  2022, 2059, 2029, 2061, 2062, 2063, 2041, 2038, 2032, 2023,
 /*   370 */  2015, 1905, 1897, 1872, 1974, 1969, 1929, 1887, 1887, 1887,
 /*   380 */  1956,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   875, 1195, 1195, 1315, 1195, 1195, 1195, 1195, 1195, 1195,
 /*    10 */  1315, 1195, 1195, 1195, 1195, 1195, 1195, 1195, 1195, 1195,
 /*    20 */  1195, 1315, 1195, 1195, 1195, 1195, 1195, 1195, 1195, 1195,
 /*    30 */  1195, 1195, 1195, 1195, 1195, 1195, 1195, 1195, 1195, 1195,
 /*    40 */  1195, 1195, 1195, 1195, 1195, 1195, 1195, 1195, 1195, 1195,
 /*    50 */  1195, 1195, 1195, 1195, 1195, 1195, 1195, 1195, 1195, 1195,
 /*    60 */  1195, 1195, 1195, 1195, 1195, 1195, 1195, 1195, 1195, 1195,
 /*    70 */  1195, 1195, 1059, 1357, 1357, 1357, 1334, 1334, 1357, 1052,
 /*    80 */  1357, 1357,  903, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*    90 */  1357, 1357,  926, 1048,  916, 1059, 1357, 1357, 1357, 1357,
 /*   100 */  1357, 1121, 1135, 1121, 1113, 1102, 1357, 1357, 1357, 1231,
 /*   110 */  1129, 1129, 1129, 1129,  999, 1129, 1357, 1357, 1357, 1357,
 /*   120 */  1163, 1162, 1357, 1087, 1087, 1197, 1357, 1284, 1289, 1156,
 /*   130 */  1357, 1357, 1357, 1357, 1357, 1122, 1357, 1357, 1357, 1060,
 /*   140 */  1048, 1334, 1156, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   150 */  1357, 1357, 1357, 1357, 1136, 1114, 1103, 1357, 1357, 1357,
 /*   160 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1048, 1048,
 /*   170 */  1048, 1357, 1357, 1357, 1334, 1334, 1357, 1158, 1357, 1357,
 /*   180 */  1357,  913, 1357, 1357, 1357,  881, 1357, 1357, 1334, 1334,
 /*   190 */   875, 1315, 1081, 1315, 1315,  921, 1315, 1315, 1308, 1038,
 /*   200 */  1038, 1097, 1120, 1119, 1118, 1117, 1065, 1107, 1095, 1099,
 /*   210 */  1208, 1098, 1197, 1197, 1197, 1197, 1197, 1197, 1197, 1197,
 /*   220 */  1197, 1197, 1197, 1197, 1197, 1197, 1197, 1197, 1197, 1197,
 /*   230 */  1197, 1165, 1179, 1164, 1172, 1184, 1173, 1178, 1177, 1176,
 /*   240 */  1167, 1166, 1168, 1169, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   250 */  1357, 1357, 1051, 1357, 1357, 1021, 1357, 1357, 1258, 1357,
 /*   260 */  1357,  928, 1170, 1357, 1036,  884, 1106, 1049, 1077, 1077,
 /*   270 */   966,  990,  950, 1087, 1077, 1067, 1081, 1081, 1203, 1087,
 /*   280 */  1357, 1357, 1197, 1049, 1036, 1299, 1299, 1068, 1068, 1068,
 /*   290 */  1283, 1283, 1068, 1231, 1068, 1012, 1068, 1012, 1068, 1012,
 /*   300 */  1068, 1012, 1068,  910, 1106, 1068,  910, 1003, 1109, 1106,
 /*   310 */  1109, 1141, 1125, 1068, 1109, 1106, 1068, 1003, 1109, 1106,
 /*   320 */  1068, 1265, 1263, 1068,  910, 1068, 1216,  910, 1068, 1216,
 /*   330 */  1001, 1001, 1001, 1001,  982, 1216, 1001,  966, 1001,  982,
 /*   340 */  1001, 1001, 1353, 1357, 1068, 1344, 1344, 1090, 1090, 1096,
 /*   350 */  1081, 1357, 1357, 1222, 1216, 1183, 1171, 1096, 1094, 1091,
 /*   360 */  1106, 1357, 1068,  985,  910,  892,  892,  880,  880,  880,
 /*   370 */   880, 1312, 1312, 1308,  968,  968, 1054, 1182, 1181, 1180,
 /*   380 */   937, 1196, 1357, 1357, 1357, 1357, 1357, 1357, 1232, 1357,
 /*   390 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   400 */  1357, 1357, 1357, 1357, 1357, 1318, 1357, 1357, 1357, 1357,
 /*   410 */  1357,  876, 1357, 1357, 1357, 1357, 1357, 1302, 1357, 1357,
 /*   420 */  1357, 1357, 1357, 1357, 1262, 1261, 1357, 1357, 1357, 1357,
 /*   430 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   440 */  1357, 1110, 1357, 1250, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   450 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   460 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   470 */  1357, 1024, 1030, 1357, 1357, 1357, 1025, 1357, 1357, 1154,
 /*   480 */  1357, 1357, 1357, 1206, 1357, 1357, 1357, 1357, 1092, 1357,
 /*   490 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   500 */  1357, 1357, 1357, 1350, 1082, 1357, 1357, 1357, 1198, 1357,
 /*   510 */  1196, 1357, 1317, 1357, 1357, 1357, 1316, 1357, 1357, 1357,
 /*   520 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1155, 1154, 1198,
 /*   530 */   919,  899, 1357,  890, 1357,  872,  877, 1301, 1298, 1295,
 /*   540 */  1300, 1294, 1296, 1293, 1297, 1292, 1290, 1291, 1288, 1286,
 /*   550 */  1285, 1287, 1282, 1278, 1238, 1236, 1234, 1243, 1242, 1241,
 /*   560 */  1240, 1239, 1235, 1233, 1237, 1229, 1228, 1132, 1111, 1100,
 /*   570 */  1019, 1277, 1275, 1276, 1227, 1225, 1226, 1018, 1017, 1016,
 /*   580 */  1011, 1010, 1009, 1008, 1305, 1314, 1313, 1311, 1310, 1309,
 /*   590 */  1303, 1304, 1214, 1213, 1211, 1210, 1212,  912, 1254, 1257,
 /*   600 */  1256, 1255, 1260, 1259, 1252, 1264, 1269, 1268, 1273, 1272,
 /*   610 */  1271, 1270, 1267, 1249, 1140, 1139, 1137, 1134, 1144, 1143,
 /*   620 */  1142, 1133, 1126, 1138, 1116, 1124, 1123, 1112, 1115, 1004,
 /*   630 */  1105, 1101, 1104, 1020, 1253, 1015, 1014, 1013,  911,  902,
 /*   640 */  1070,  901,  900,  915,  988,  989,  997, 1000,  995,  998,
 /*   650 */   994,  993,  992,  996,  991,  987,  918,  917,  927,  981,
 /*   660 */   964,  953,  920,  955,  952,  951,  956,  973,  972,  979,
 /*   670 */   978,  977,  976,  975,  971,  974,  970,  969,  957,  949,
 /*   680 */   948,  967,  947,  984,  983,  980,  946, 1007, 1006, 1005,
 /*   690 */  1002,  945,  944,  943,  942,  941,  940, 1194, 1356, 1352,
 /*   700 */  1355, 1354, 1351, 1193, 1199, 1187, 1185, 1022, 1033, 1032,
 /*   710 */  1031, 1028, 1029, 1043, 1041, 1040, 1039, 1076, 1075, 1074,
 /*   720 */  1073, 1072, 1071, 1064, 1062, 1057, 1056, 1063, 1061, 1058,
 /*   730 */  1079, 1080, 1078, 1055, 1047, 1045, 1046, 1044, 1131, 1128,
 /*   740 */  1130, 1127, 1066, 1053, 1050, 1037, 1332, 1330, 1333, 1331,
 /*   750 */  1329, 1337, 1339, 1338, 1343, 1341, 1340, 1336, 1349, 1348,
 /*   760 */  1347, 1346, 1345, 1335, 1342, 1328, 1327, 1326, 1325, 1084,
 /*   770 */  1089, 1088, 1083, 1027, 1186, 1196, 1190, 1323, 1321, 1324,
 /*   780 */  1320, 1319, 1219, 1221, 1224, 1223, 1220, 1086, 1085, 1218,
 /*   790 */  1217, 1322, 1189, 1161,  933,  931,  932, 1246, 1245, 1248,
 /*   800 */  1247, 1244,  935,  934,  930,  929, 1159, 1153, 1152, 1274,
 /*   810 */  1191, 1192, 1151, 1157, 1149, 1148, 1147, 1175, 1174, 1160,
 /*   820 */  1150,  922, 1026, 1023, 1188, 1146, 1069, 1145,  963,  962,
 /*   830 */   961,  960,  959,  958, 1035, 1034,  939,  954,  938,  936,
 /*   840 */   914,  904,  909,  907,  908,  906,  905,  897,  894,  896,
 /*   850 */   893,  898,  895,  891,  889,  888,  887,  886,  885,  925,
 /*   860 */   924,  923,  919,  883,  882,  879,  878,  874,  873,  871,
};

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
**
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*      SPACE => nothing */
    0,  /*         ID => nothing */
    4,  /*      ABORT => ID */
    4,  /*     ACTION => ID */
    4,  /*      AFTER => ID */
    4,  /*     ALWAYS => ID */
    4,  /*    ANALYZE => ID */
    4,  /*        ASC => ID */
    4,  /*     ATTACH => ID */
    4,  /*     BEFORE => ID */
    4,  /*      BEGIN => ID */
    4,  /*         BY => ID */
    4,  /*    CASCADE => ID */
    4,  /*       CAST => ID */
    4,  /*   COLUMNKW => ID */
    4,  /*   CONFLICT => ID */
    4,  /*    CURRENT => ID */
    4,  /*   DATABASE => ID */
    4,  /*   DEFERRED => ID */
    4,  /*       DESC => ID */
    4,  /*     DETACH => ID */
    4,  /*         DO => ID */
    4,  /*       EACH => ID */
    4,  /*        END => ID */
    4,  /*    EXCLUDE => ID */
    4,  /*  EXCLUSIVE => ID */
    4,  /*    EXPLAIN => ID */
    4,  /*       FAIL => ID */
    4,  /*      FIRST => ID */
    4,  /*  FOLLOWING => ID */
    4,  /*        FOR => ID */
    4,  /*  GENERATED => ID */
    4,  /*     GROUPS => ID */
    4,  /*     IGNORE => ID */
    4,  /*  IMMEDIATE => ID */
    4,  /*    INDEXED => ID */
    4,  /*  INITIALLY => ID */
    4,  /*    INSTEAD => ID */
    4,  /*       LAST => ID */
    4,  /*    LIKE_KW => ID */
    4,  /*      MATCH => ID */
    4,  /* MATERIALIZED => ID */
    4,  /*         NO => ID */
    4,  /*      NULLS => ID */
    4,  /*     OTHERS => ID */
    4,  /*       PLAN => ID */
    4,  /*      QUERY => ID */
    4,  /*        KEY => ID */
    4,  /*         OF => ID */
    4,  /*     OFFSET => ID */
    4,  /*  PARTITION => ID */
    4,  /*     PRAGMA => ID */
    4,  /*  PRECEDING => ID */
    4,  /*      RAISE => ID */
    4,  /*      RANGE => ID */
    4,  /*  RECURSIVE => ID */
    4,  /*    RELEASE => ID */
    4,  /*    REPLACE => ID */
    4,  /*   RESTRICT => ID */
    4,  /*        ROW => ID */
    4,  /*       ROWS => ID */
    4,  /*   ROLLBACK => ID */
    4,  /*  SAVEPOINT => ID */
    4,  /*       TEMP => ID */
    4,  /*       TIES => ID */
    4,  /*    TRIGGER => ID */
    4,  /*  UNBOUNDED => ID */
    4,  /*     VACUUM => ID */
    4,  /*       VIEW => ID */
    4,  /*    VIRTUAL => ID */
    4,  /*       WITH => ID */
    4,  /*    WITHOUT => ID */
    4,  /*    REINDEX => ID */
    4,  /*     RENAME => ID */
    4,  /*   CTIME_KW => ID */
    4,  /*         IF => ID */
    4,  /*     FILTER => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
  QList<Token*>* tokens = nullptr;
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3_parseARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

void *sqlite3_parseCopyParserState(void* other)
{
  yyParser *pParser;
  yyParser *otherParser = (yyParser*)other;

  // Copy parser
  pParser = (yyParser*)malloc((size_t)sizeof(yyParser));
  memcpy(pParser, other, (size_t)sizeof(yyParser));

#if YYSTACKDEPTH<=0
  // Copy stack
  int stackSize = sizeof(yyStackEntry) * pParser->yystksz;
  pParser->yystack = malloc((size_t)stackSize);
  memcpy(pParser->yystack, ((yyParser*)other)->yystack, (size_t)stackSize);
#endif

  for (int i = 0; i <= pParser->yyidx; i++)
  {
      pParser->yystack[i].tokens = new QList<Token*>();
      *(pParser->yystack[i].tokens) = *(otherParser->yystack[i].tokens);
  }

  return pParser;
}

void sqlite3_parseAddToken(void* other, Token* token)
{
    yyParser *otherParser = (yyParser*)other;
    if (otherParser->yyidx < 0)
        return; // Nothing on stack yet. Might happen when parsing just whitespaces, nothing else.

    otherParser->yystack[otherParser->yyidx].tokens->append(token);
}

void sqlite3_parseRestoreParserState(void* saved, void* target)
{
  yyParser *pParser = (yyParser*)target;
  yyParser *savedParser = (yyParser*)saved;

  for (int i = 0; i <= pParser->yyidx; i++)
      delete pParser->yystack[i].tokens;

  memcpy(pParser, saved, (size_t)sizeof(yyParser));

  for (int i = 0; i <= savedParser->yyidx; i++)
  {
      pParser->yystack[i].tokens = new QList<Token*>();
      *(pParser->yystack[i].tokens) = *(savedParser->yystack[i].tokens);
  }

#if YYSTACKDEPTH<=0
  // Copy stack
  int stackSize = sizeof(yyStackEntry) * pParser->yystksz;
  pParser->yystack = relloc(pParser->yystack, (size_t)stackSize);
  memcpy(pParser->yystack, ((yyParser*)saved)->yystack, (size_t)stackSize);
#endif
}

void sqlite3_parseFreeSavedState(void* other)
{
    yyParser *pParser = (yyParser*)other;
    for (int i = 0; i <= pParser->yyidx; i++)
        delete pParser->yystack[i].tokens;

#if YYSTACKDEPTH<=0
    free(pParser->yystack);
#endif
    free(other);
}

#ifndef NDEBUG
/*
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3_parseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = {
  "$",             "ILLEGAL",       "COMMENT",       "SPACE",       
  "ID",            "ABORT",         "ACTION",        "AFTER",       
  "ALWAYS",        "ANALYZE",       "ASC",           "ATTACH",      
  "BEFORE",        "BEGIN",         "BY",            "CASCADE",     
  "CAST",          "COLUMNKW",      "CONFLICT",      "CURRENT",     
  "DATABASE",      "DEFERRED",      "DESC",          "DETACH",      
  "DO",            "EACH",          "END",           "EXCLUDE",     
  "EXCLUSIVE",     "EXPLAIN",       "FAIL",          "FIRST",       
  "FOLLOWING",     "FOR",           "GENERATED",     "GROUPS",      
  "IGNORE",        "IMMEDIATE",     "INDEXED",       "INITIALLY",   
  "INSTEAD",       "LAST",          "LIKE_KW",       "MATCH",       
  "MATERIALIZED",  "NO",            "NULLS",         "OTHERS",      
  "PLAN",          "QUERY",         "KEY",           "OF",          
  "OFFSET",        "PARTITION",     "PRAGMA",        "PRECEDING",   
  "RAISE",         "RANGE",         "RECURSIVE",     "RELEASE",     
  "REPLACE",       "RESTRICT",      "ROW",           "ROWS",        
  "ROLLBACK",      "SAVEPOINT",     "TEMP",          "TIES",        
  "TRIGGER",       "UNBOUNDED",     "VACUUM",        "VIEW",        
  "VIRTUAL",       "WITH",          "WITHOUT",       "REINDEX",     
  "RENAME",        "CTIME_KW",      "IF",            "FILTER",      
  "ANY",           "OR",            "AND",           "NOT",         
  "IS",            "BETWEEN",       "IN",            "ISNULL",      
  "NOTNULL",       "NE",            "EQ",            "GT",          
  "LE",            "LT",            "GE",            "ESCAPE",      
  "BITAND",        "BITOR",         "LSHIFT",        "RSHIFT",      
  "PLUS",          "MINUS",         "STAR",          "SLASH",       
  "REM",           "CONCAT",        "PTR",           "COLLATE",     
  "BITNOT",        "SEMI",          "TRANSACTION",   "ID_TRANS",    
  "COMMIT",        "TO",            "CREATE",        "TABLE",       
  "LP",            "RP",            "AS",            "DOT",         
  "ID_TAB_NEW",    "ID_DB",         "COMMA",         "CTX_ROWID_KW",
  "CTX_STRICT_KW",  "EXISTS",        "ID_COL_NEW",    "STRING",      
  "JOIN_KW",       "ID_COL_TYPE",   "RIGHT_ASSOC",   "CONSTRAINT",  
  "DEFAULT",       "NULL",          "PRIMARY",       "UNIQUE",      
  "CHECK",         "REFERENCES",    "ID_CONSTR",     "ID_COLLATE",  
  "ID_TAB",        "INTEGER",       "FLOAT",         "BLOB",        
  "AUTOINCR",      "ON",            "INSERT",        "DELETE",      
  "UPDATE",        "ID_FK_MATCH",   "SET",           "DEFERRABLE",  
  "FOREIGN",       "DROP",          "ID_VIEW_NEW",   "ID_VIEW",     
  "SELECT",        "VALUES",        "UNION",         "ALL",         
  "EXCEPT",        "INTERSECT",     "DISTINCT",      "ID_ALIAS",    
  "FROM",          "USING",         "JOIN",          "ID_JOIN_OPTS",
  "ID_IDX",        "ORDER",         "GROUP",         "HAVING",      
  "LIMIT",         "WHERE",         "RETURNING",     "ID_COL",      
  "INTO",          "NOTHING",       "ID_FN",         "ID_ERR_MSG",  
  "VARIABLE",      "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "ID_IDX_NEW",    "ID_PRAGMA",   
  "ID_TRIG_NEW",   "ID_TRIG",       "ALTER",         "ADD",         
  "WINDOW",        "OVER",          "error",         "cmd",         
  "input",         "cmdlist",       "ecmd",          "explain",     
  "cmdx",          "transtype",     "trans_opt",     "nm",          
  "savepoint_opt",  "temp",          "ifnotexists",   "fullname",    
  "columnlist",    "conslist_opt",  "table_options",  "select",      
  "table_option",  "column",        "columnid",      "type",        
  "carglist",      "id",            "id_opt",        "ids",         
  "typetoken",     "typename",      "signed",        "plus_num",    
  "minus_num",     "ccons",         "term",          "expr",        
  "onconf",        "sortorder",     "autoinc",       "idxlist_opt", 
  "refargs",       "defer_subclause",  "gen_always",    "tnm",         
  "refarg",        "refact",        "init_deferred_pred_opt",  "conslist",    
  "tconscomma",    "tcons",         "idxlist",       "defer_subclause_opt",
  "resolvetype",   "orconf",        "raisetype",     "ifexists",    
  "select_stmt",   "with",          "selectnowith",  "oneselect",   
  "multiselect_op",  "values",        "distinct",      "selcollist",  
  "from",          "where_opt",     "groupby_opt",   "having_opt",  
  "orderby_opt",   "limit_opt",     "window_clause",  "nexprlist",   
  "exprlist",      "sclp",          "as",            "joinsrc",     
  "singlesrc",     "seltablist",    "joinop",        "joinconstr_opt",
  "dbnm",          "indexed_opt",   "idlist",        "sortlist",    
  "nulls",         "delete_stmt",   "returning",     "update_stmt", 
  "setlist",       "idlist_opt",    "insert_stmt",   "insert_cmd",  
  "upsert",        "exprx",         "not_opt",       "likeop",      
  "case_operand",  "case_exprlist",  "case_else",     "filter_over", 
  "uniqueflag",    "idxlist_single",  "collate",       "vinto",       
  "nmnum",         "number",        "trigger_time",  "trigger_event",
  "foreach_clause",  "when_clause",   "trigger_cmd_list",  "trigger_cmd", 
  "database_kw_opt",  "key_opt",       "kwcolumn_opt",  "create_vtab", 
  "vtabarglist",   "vtabarg",       "vtabargtoken",  "anylist",     
  "wqlist",        "wqas",          "wqcte",         "windowdefn_list",
  "windowdefn",    "window",        "frame_opt",     "range_or_rows",
  "frame_bound_s",  "frame_exclude_opt",  "frame_bound_e",  "frame_bound", 
  "frame_exclude",  "filter_clause",  "over_clause", 
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= SEMI",
 /*   4 */ "ecmd ::= explain cmdx SEMI",
 /*   5 */ "explain ::=",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   8 */ "cmdx ::= cmd",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "trans_opt ::= TRANSACTION ID_TRANS",
 /*  14 */ "transtype ::=",
 /*  15 */ "transtype ::= DEFERRED",
 /*  16 */ "transtype ::= IMMEDIATE",
 /*  17 */ "transtype ::= EXCLUSIVE",
 /*  18 */ "cmd ::= COMMIT trans_opt",
 /*  19 */ "cmd ::= END trans_opt",
 /*  20 */ "cmd ::= ROLLBACK trans_opt",
 /*  21 */ "savepoint_opt ::= SAVEPOINT",
 /*  22 */ "savepoint_opt ::=",
 /*  23 */ "cmd ::= SAVEPOINT nm",
 /*  24 */ "cmd ::= RELEASE savepoint_opt nm",
 /*  25 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt nm",
 /*  26 */ "cmd ::= SAVEPOINT ID_TRANS",
 /*  27 */ "cmd ::= RELEASE savepoint_opt ID_TRANS",
 /*  28 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt ID_TRANS",
 /*  29 */ "cmd ::= CREATE temp TABLE ifnotexists fullname LP columnlist conslist_opt RP table_options",
 /*  30 */ "cmd ::= CREATE temp TABLE ifnotexists fullname AS select",
 /*  31 */ "cmd ::= CREATE temp TABLE ifnotexists nm DOT ID_TAB_NEW",
 /*  32 */ "cmd ::= CREATE temp TABLE ifnotexists ID_DB|ID_TAB_NEW",
 /*  33 */ "table_options ::=",
 /*  34 */ "table_options ::= table_option",
 /*  35 */ "table_options ::= table_options COMMA table_option",
 /*  36 */ "table_option ::= WITHOUT nm",
 /*  37 */ "table_option ::= nm",
 /*  38 */ "table_option ::= WITHOUT CTX_ROWID_KW",
 /*  39 */ "table_option ::= CTX_STRICT_KW",
 /*  40 */ "ifnotexists ::=",
 /*  41 */ "ifnotexists ::= IF NOT EXISTS",
 /*  42 */ "temp ::= TEMP",
 /*  43 */ "temp ::=",
 /*  44 */ "columnlist ::= columnlist COMMA column",
 /*  45 */ "columnlist ::= column",
 /*  46 */ "column ::= columnid type carglist",
 /*  47 */ "columnid ::= nm",
 /*  48 */ "columnid ::= ID_COL_NEW",
 /*  49 */ "id ::= ID",
 /*  50 */ "id_opt ::= id",
 /*  51 */ "id_opt ::=",
 /*  52 */ "ids ::= ID|STRING",
 /*  53 */ "nm ::= id",
 /*  54 */ "nm ::= STRING",
 /*  55 */ "nm ::= JOIN_KW",
 /*  56 */ "type ::=",
 /*  57 */ "type ::= typetoken",
 /*  58 */ "typetoken ::= typename",
 /*  59 */ "typetoken ::= typename LP signed RP",
 /*  60 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  61 */ "typename ::= ids",
 /*  62 */ "typename ::= typename ids",
 /*  63 */ "typename ::= ID_COL_TYPE",
 /*  64 */ "signed ::= plus_num",
 /*  65 */ "signed ::= minus_num",
 /*  66 */ "carglist ::= carglist ccons",
 /*  67 */ "carglist ::=",
 /*  68 */ "ccons ::= CONSTRAINT nm",
 /*  69 */ "ccons ::= DEFAULT term",
 /*  70 */ "ccons ::= DEFAULT LP expr RP",
 /*  71 */ "ccons ::= DEFAULT PLUS term",
 /*  72 */ "ccons ::= DEFAULT MINUS term",
 /*  73 */ "ccons ::= DEFAULT id",
 /*  74 */ "ccons ::= DEFAULT CTIME_KW",
 /*  75 */ "ccons ::= NULL onconf",
 /*  76 */ "ccons ::= NOT NULL onconf",
 /*  77 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  78 */ "ccons ::= UNIQUE onconf",
 /*  79 */ "ccons ::= CHECK LP expr RP",
 /*  80 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  81 */ "ccons ::= defer_subclause",
 /*  82 */ "ccons ::= COLLATE ids",
 /*  83 */ "ccons ::= gen_always AS LP expr RP id_opt",
 /*  84 */ "ccons ::= CONSTRAINT ID_CONSTR",
 /*  85 */ "ccons ::= COLLATE ID_COLLATE",
 /*  86 */ "ccons ::= REFERENCES ID_TAB",
 /*  87 */ "ccons ::= CHECK LP RP",
 /*  88 */ "term ::= NULL",
 /*  89 */ "term ::= INTEGER",
 /*  90 */ "term ::= FLOAT",
 /*  91 */ "term ::= STRING|BLOB",
 /*  92 */ "tnm ::= term",
 /*  93 */ "tnm ::= nm",
 /*  94 */ "gen_always ::= GENERATED ALWAYS",
 /*  95 */ "gen_always ::=",
 /*  96 */ "autoinc ::=",
 /*  97 */ "autoinc ::= AUTOINCR",
 /*  98 */ "refargs ::=",
 /*  99 */ "refargs ::= refargs refarg",
 /* 100 */ "refarg ::= MATCH nm",
 /* 101 */ "refarg ::= ON INSERT refact",
 /* 102 */ "refarg ::= ON DELETE refact",
 /* 103 */ "refarg ::= ON UPDATE refact",
 /* 104 */ "refarg ::= MATCH ID_FK_MATCH",
 /* 105 */ "refact ::= SET NULL",
 /* 106 */ "refact ::= SET DEFAULT",
 /* 107 */ "refact ::= CASCADE",
 /* 108 */ "refact ::= RESTRICT",
 /* 109 */ "refact ::= NO ACTION",
 /* 110 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /* 111 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /* 112 */ "init_deferred_pred_opt ::=",
 /* 113 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /* 114 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /* 115 */ "conslist_opt ::=",
 /* 116 */ "conslist_opt ::= COMMA conslist",
 /* 117 */ "conslist ::= conslist tconscomma tcons",
 /* 118 */ "conslist ::= tcons",
 /* 119 */ "tconscomma ::= COMMA",
 /* 120 */ "tconscomma ::=",
 /* 121 */ "tcons ::= CONSTRAINT nm",
 /* 122 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /* 123 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /* 124 */ "tcons ::= CHECK LP expr RP onconf",
 /* 125 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /* 126 */ "tcons ::= CONSTRAINT ID_CONSTR",
 /* 127 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES ID_TAB",
 /* 128 */ "tcons ::= CHECK LP RP onconf",
 /* 129 */ "defer_subclause_opt ::=",
 /* 130 */ "defer_subclause_opt ::= defer_subclause",
 /* 131 */ "onconf ::=",
 /* 132 */ "onconf ::= ON CONFLICT resolvetype",
 /* 133 */ "orconf ::=",
 /* 134 */ "orconf ::= OR resolvetype",
 /* 135 */ "resolvetype ::= raisetype",
 /* 136 */ "resolvetype ::= IGNORE",
 /* 137 */ "resolvetype ::= REPLACE",
 /* 138 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 139 */ "cmd ::= DROP TABLE ifexists nm DOT ID_TAB",
 /* 140 */ "cmd ::= DROP TABLE ifexists ID_DB|ID_TAB",
 /* 141 */ "ifexists ::= IF EXISTS",
 /* 142 */ "ifexists ::=",
 /* 143 */ "cmd ::= CREATE temp VIEW ifnotexists fullname idxlist_opt AS select",
 /* 144 */ "cmd ::= CREATE temp VIEW ifnotexists nm DOT ID_VIEW_NEW",
 /* 145 */ "cmd ::= CREATE temp VIEW ifnotexists ID_DB|ID_VIEW_NEW",
 /* 146 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 147 */ "cmd ::= DROP VIEW ifexists nm DOT ID_VIEW",
 /* 148 */ "cmd ::= DROP VIEW ifexists ID_DB|ID_VIEW",
 /* 149 */ "cmd ::= select_stmt",
 /* 150 */ "select_stmt ::= select",
 /* 151 */ "select ::= with selectnowith",
 /* 152 */ "selectnowith ::= oneselect",
 /* 153 */ "selectnowith ::= selectnowith multiselect_op oneselect",
 /* 154 */ "selectnowith ::= values",
 /* 155 */ "selectnowith ::= selectnowith COMMA values",
 /* 156 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 157 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt window_clause orderby_opt limit_opt",
 /* 158 */ "values ::= VALUES LP nexprlist RP",
 /* 159 */ "values ::= values COMMA LP exprlist RP",
 /* 160 */ "multiselect_op ::= UNION",
 /* 161 */ "multiselect_op ::= UNION ALL",
 /* 162 */ "multiselect_op ::= EXCEPT",
 /* 163 */ "multiselect_op ::= INTERSECT",
 /* 164 */ "distinct ::= DISTINCT",
 /* 165 */ "distinct ::= ALL",
 /* 166 */ "distinct ::=",
 /* 167 */ "sclp ::= selcollist COMMA",
 /* 168 */ "sclp ::=",
 /* 169 */ "selcollist ::= sclp expr as",
 /* 170 */ "selcollist ::= sclp STAR",
 /* 171 */ "selcollist ::= sclp tnm DOT STAR",
 /* 172 */ "selcollist ::= sclp",
 /* 173 */ "selcollist ::= sclp ID_TAB DOT STAR",
 /* 174 */ "as ::= AS nm",
 /* 175 */ "as ::= ids",
 /* 176 */ "as ::= AS ID_ALIAS",
 /* 177 */ "as ::= ID_ALIAS",
 /* 178 */ "as ::=",
 /* 179 */ "from ::=",
 /* 180 */ "from ::= FROM joinsrc",
 /* 181 */ "joinsrc ::= singlesrc seltablist",
 /* 182 */ "joinsrc ::=",
 /* 183 */ "seltablist ::= seltablist joinop singlesrc joinconstr_opt",
 /* 184 */ "seltablist ::=",
 /* 185 */ "singlesrc ::= nm dbnm as indexed_opt",
 /* 186 */ "singlesrc ::= LP select RP as",
 /* 187 */ "singlesrc ::= LP joinsrc RP as",
 /* 188 */ "singlesrc ::= nm dbnm LP exprlist RP as",
 /* 189 */ "singlesrc ::=",
 /* 190 */ "singlesrc ::= nm DOT",
 /* 191 */ "singlesrc ::= nm DOT ID_TAB",
 /* 192 */ "singlesrc ::= ID_DB|ID_TAB",
 /* 193 */ "singlesrc ::= nm DOT ID_VIEW",
 /* 194 */ "singlesrc ::= ID_DB|ID_VIEW",
 /* 195 */ "joinconstr_opt ::= ON expr",
 /* 196 */ "joinconstr_opt ::= USING LP idlist RP",
 /* 197 */ "joinconstr_opt ::=",
 /* 198 */ "dbnm ::=",
 /* 199 */ "dbnm ::= DOT nm",
 /* 200 */ "fullname ::= nm dbnm",
 /* 201 */ "joinop ::= COMMA",
 /* 202 */ "joinop ::= JOIN",
 /* 203 */ "joinop ::= JOIN_KW JOIN",
 /* 204 */ "joinop ::= JOIN_KW nm JOIN",
 /* 205 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 206 */ "joinop ::= ID_JOIN_OPTS",
 /* 207 */ "indexed_opt ::=",
 /* 208 */ "indexed_opt ::= INDEXED BY nm",
 /* 209 */ "indexed_opt ::= NOT INDEXED",
 /* 210 */ "indexed_opt ::= INDEXED BY ID_IDX",
 /* 211 */ "orderby_opt ::=",
 /* 212 */ "orderby_opt ::= ORDER BY sortlist",
 /* 213 */ "sortlist ::= sortlist COMMA expr sortorder nulls",
 /* 214 */ "sortlist ::= expr sortorder nulls",
 /* 215 */ "sortorder ::= ASC",
 /* 216 */ "sortorder ::= DESC",
 /* 217 */ "sortorder ::=",
 /* 218 */ "nulls ::= NULLS FIRST",
 /* 219 */ "nulls ::= NULLS LAST",
 /* 220 */ "nulls ::=",
 /* 221 */ "groupby_opt ::=",
 /* 222 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 223 */ "groupby_opt ::= GROUP BY",
 /* 224 */ "having_opt ::=",
 /* 225 */ "having_opt ::= HAVING expr",
 /* 226 */ "limit_opt ::=",
 /* 227 */ "limit_opt ::= LIMIT expr",
 /* 228 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 229 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 230 */ "cmd ::= delete_stmt",
 /* 231 */ "delete_stmt ::= with DELETE FROM fullname indexed_opt where_opt returning",
 /* 232 */ "delete_stmt ::= with DELETE FROM",
 /* 233 */ "delete_stmt ::= with DELETE FROM nm DOT",
 /* 234 */ "delete_stmt ::= with DELETE FROM nm DOT ID_TAB",
 /* 235 */ "delete_stmt ::= with DELETE FROM ID_DB|ID_TAB",
 /* 236 */ "where_opt ::=",
 /* 237 */ "where_opt ::= WHERE expr",
 /* 238 */ "where_opt ::= WHERE",
 /* 239 */ "returning ::=",
 /* 240 */ "returning ::= RETURNING selcollist",
 /* 241 */ "cmd ::= update_stmt",
 /* 242 */ "update_stmt ::= with UPDATE orconf fullname indexed_opt SET setlist from where_opt returning",
 /* 243 */ "update_stmt ::= with UPDATE orconf",
 /* 244 */ "update_stmt ::= with UPDATE orconf nm DOT",
 /* 245 */ "update_stmt ::= with UPDATE orconf nm DOT ID_TAB",
 /* 246 */ "update_stmt ::= with UPDATE orconf ID_DB|ID_TAB",
 /* 247 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 248 */ "setlist ::= setlist COMMA LP idlist RP EQ expr",
 /* 249 */ "setlist ::= nm EQ expr",
 /* 250 */ "setlist ::= LP idlist RP EQ expr",
 /* 251 */ "setlist ::=",
 /* 252 */ "setlist ::= setlist COMMA",
 /* 253 */ "setlist ::= setlist COMMA ID_COL",
 /* 254 */ "setlist ::= ID_COL",
 /* 255 */ "idlist_opt ::=",
 /* 256 */ "idlist_opt ::= LP idlist RP",
 /* 257 */ "idlist ::= idlist COMMA nm",
 /* 258 */ "idlist ::= nm",
 /* 259 */ "idlist ::=",
 /* 260 */ "idlist ::= idlist COMMA ID_COL",
 /* 261 */ "idlist ::= ID_COL",
 /* 262 */ "cmd ::= insert_stmt",
 /* 263 */ "insert_stmt ::= with insert_cmd INTO fullname idlist_opt select upsert returning",
 /* 264 */ "insert_stmt ::= with insert_cmd INTO fullname idlist_opt DEFAULT VALUES returning",
 /* 265 */ "insert_stmt ::= with insert_cmd INTO",
 /* 266 */ "insert_stmt ::= with insert_cmd INTO nm DOT",
 /* 267 */ "insert_stmt ::= with insert_cmd INTO ID_DB|ID_TAB",
 /* 268 */ "insert_stmt ::= with insert_cmd INTO nm DOT ID_TAB",
 /* 269 */ "insert_cmd ::= INSERT orconf",
 /* 270 */ "insert_cmd ::= REPLACE",
 /* 271 */ "upsert ::=",
 /* 272 */ "upsert ::= ON CONFLICT LP sortlist RP where_opt DO UPDATE SET setlist where_opt",
 /* 273 */ "upsert ::= ON CONFLICT LP sortlist RP where_opt DO NOTHING",
 /* 274 */ "upsert ::= ON CONFLICT DO NOTHING",
 /* 275 */ "exprx ::= expr not_opt IN ID_DB",
 /* 276 */ "exprx ::= expr not_opt IN nm DOT ID_TAB",
 /* 277 */ "exprx ::= ID_DB|ID_TAB|ID_COL|ID_FN",
 /* 278 */ "exprx ::= tnm DOT ID_TAB|ID_COL",
 /* 279 */ "exprx ::= tnm DOT nm DOT ID_COL",
 /* 280 */ "exprx ::= expr COLLATE ID_COLLATE",
 /* 281 */ "exprx ::= RAISE LP raisetype COMMA ID_ERR_MSG RP",
 /* 282 */ "exprx ::= CTIME_KW",
 /* 283 */ "exprx ::= LP nexprlist RP",
 /* 284 */ "exprx ::= tnm",
 /* 285 */ "exprx ::= tnm DOT nm",
 /* 286 */ "exprx ::= tnm DOT",
 /* 287 */ "exprx ::= tnm DOT nm DOT nm",
 /* 288 */ "exprx ::= tnm DOT nm DOT",
 /* 289 */ "exprx ::= VARIABLE",
 /* 290 */ "exprx ::= expr COLLATE ids",
 /* 291 */ "exprx ::= CAST LP expr AS typetoken RP",
 /* 292 */ "exprx ::= ID LP distinct exprlist RP",
 /* 293 */ "exprx ::= ID LP STAR RP",
 /* 294 */ "exprx ::= expr AND expr",
 /* 295 */ "exprx ::= expr OR expr",
 /* 296 */ "exprx ::= expr LT|GT|GE|LE expr",
 /* 297 */ "exprx ::= expr EQ|NE expr",
 /* 298 */ "exprx ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 299 */ "exprx ::= expr PLUS|MINUS expr",
 /* 300 */ "exprx ::= expr STAR|SLASH|REM expr",
 /* 301 */ "exprx ::= expr CONCAT expr",
 /* 302 */ "exprx ::= expr not_opt likeop expr",
 /* 303 */ "exprx ::= expr not_opt likeop expr ESCAPE expr",
 /* 304 */ "exprx ::= expr ISNULL|NOTNULL",
 /* 305 */ "exprx ::= expr NOT NULL",
 /* 306 */ "exprx ::= expr IS not_opt expr",
 /* 307 */ "exprx ::= expr IS NOT DISTINCT FROM expr",
 /* 308 */ "exprx ::= expr IS DISTINCT FROM expr",
 /* 309 */ "exprx ::= NOT expr",
 /* 310 */ "exprx ::= BITNOT expr",
 /* 311 */ "exprx ::= MINUS expr",
 /* 312 */ "exprx ::= PLUS expr",
 /* 313 */ "exprx ::= expr PTR expr",
 /* 314 */ "exprx ::= expr not_opt BETWEEN expr AND expr",
 /* 315 */ "exprx ::= expr not_opt IN LP exprlist RP",
 /* 316 */ "exprx ::= LP select RP",
 /* 317 */ "exprx ::= expr not_opt IN LP select RP",
 /* 318 */ "exprx ::= expr not_opt IN nm dbnm",
 /* 319 */ "exprx ::= EXISTS LP select RP",
 /* 320 */ "exprx ::= CASE case_operand case_exprlist case_else END",
 /* 321 */ "exprx ::= RAISE LP IGNORE RP",
 /* 322 */ "exprx ::= RAISE LP raisetype COMMA nm RP",
 /* 323 */ "exprx ::= ID LP distinct exprlist RP filter_over",
 /* 324 */ "exprx ::= ID LP STAR RP filter_over",
 /* 325 */ "expr ::=",
 /* 326 */ "expr ::= exprx",
 /* 327 */ "not_opt ::=",
 /* 328 */ "not_opt ::= NOT",
 /* 329 */ "likeop ::= LIKE_KW|MATCH",
 /* 330 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 331 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 332 */ "case_else ::= ELSE expr",
 /* 333 */ "case_else ::=",
 /* 334 */ "case_operand ::= exprx",
 /* 335 */ "case_operand ::=",
 /* 336 */ "exprlist ::= nexprlist",
 /* 337 */ "exprlist ::=",
 /* 338 */ "nexprlist ::= nexprlist COMMA expr",
 /* 339 */ "nexprlist ::= exprx",
 /* 340 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP sortlist RP where_opt",
 /* 341 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON ID_TAB",
 /* 342 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm DOT ID_IDX_NEW",
 /* 343 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists ID_DB|ID_IDX_NEW",
 /* 344 */ "uniqueflag ::= UNIQUE",
 /* 345 */ "uniqueflag ::=",
 /* 346 */ "idxlist_opt ::=",
 /* 347 */ "idxlist_opt ::= LP idxlist RP",
 /* 348 */ "idxlist ::= idxlist COMMA idxlist_single",
 /* 349 */ "idxlist ::= idxlist_single",
 /* 350 */ "idxlist_single ::= nm collate sortorder",
 /* 351 */ "idxlist_single ::= ID_COL",
 /* 352 */ "collate ::=",
 /* 353 */ "collate ::= COLLATE ids",
 /* 354 */ "collate ::= COLLATE ID_COLLATE",
 /* 355 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 356 */ "cmd ::= DROP INDEX ifexists nm DOT ID_IDX",
 /* 357 */ "cmd ::= DROP INDEX ifexists ID_DB|ID_IDX",
 /* 358 */ "cmd ::= VACUUM vinto",
 /* 359 */ "cmd ::= VACUUM nm vinto",
 /* 360 */ "vinto ::= INTO expr",
 /* 361 */ "vinto ::=",
 /* 362 */ "cmd ::= PRAGMA nm dbnm",
 /* 363 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 364 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 365 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 366 */ "cmd ::= PRAGMA nm dbnm LP minus_num RP",
 /* 367 */ "cmd ::= PRAGMA nm DOT ID_PRAGMA",
 /* 368 */ "cmd ::= PRAGMA ID_DB|ID_PRAGMA",
 /* 369 */ "nmnum ::= plus_num",
 /* 370 */ "nmnum ::= nm",
 /* 371 */ "nmnum ::= ON",
 /* 372 */ "nmnum ::= DELETE",
 /* 373 */ "nmnum ::= DEFAULT",
 /* 374 */ "plus_num ::= PLUS number",
 /* 375 */ "plus_num ::= number",
 /* 376 */ "minus_num ::= MINUS number",
 /* 377 */ "number ::= INTEGER",
 /* 378 */ "number ::= FLOAT",
 /* 379 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list END",
 /* 380 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause",
 /* 381 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list",
 /* 382 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON ID_TAB",
 /* 383 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm DOT ID_TRIG_NEW",
 /* 384 */ "cmd ::= CREATE temp TRIGGER ifnotexists ID_DB|ID_TRIG_NEW",
 /* 385 */ "trigger_time ::= BEFORE",
 /* 386 */ "trigger_time ::= AFTER",
 /* 387 */ "trigger_time ::= INSTEAD OF",
 /* 388 */ "trigger_time ::=",
 /* 389 */ "trigger_event ::= DELETE",
 /* 390 */ "trigger_event ::= INSERT",
 /* 391 */ "trigger_event ::= UPDATE",
 /* 392 */ "trigger_event ::= UPDATE OF idlist",
 /* 393 */ "foreach_clause ::=",
 /* 394 */ "foreach_clause ::= FOR EACH ROW",
 /* 395 */ "when_clause ::=",
 /* 396 */ "when_clause ::= WHEN expr",
 /* 397 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 398 */ "trigger_cmd_list ::= trigger_cmd SEMI",
 /* 399 */ "trigger_cmd_list ::= SEMI",
 /* 400 */ "trigger_cmd ::= update_stmt",
 /* 401 */ "trigger_cmd ::= insert_stmt",
 /* 402 */ "trigger_cmd ::= delete_stmt",
 /* 403 */ "trigger_cmd ::= select_stmt",
 /* 404 */ "raisetype ::= ROLLBACK|ABORT|FAIL",
 /* 405 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 406 */ "cmd ::= DROP TRIGGER ifexists nm DOT ID_TRIG",
 /* 407 */ "cmd ::= DROP TRIGGER ifexists ID_DB|ID_TRIG",
 /* 408 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 409 */ "cmd ::= DETACH database_kw_opt expr",
 /* 410 */ "key_opt ::=",
 /* 411 */ "key_opt ::= KEY expr",
 /* 412 */ "database_kw_opt ::= DATABASE",
 /* 413 */ "database_kw_opt ::=",
 /* 414 */ "cmd ::= REINDEX",
 /* 415 */ "cmd ::= REINDEX nm dbnm",
 /* 416 */ "cmd ::= REINDEX ID_COLLATE",
 /* 417 */ "cmd ::= REINDEX nm DOT ID_TAB|ID_IDX",
 /* 418 */ "cmd ::= REINDEX ID_DB|ID_IDX|ID_TAB",
 /* 419 */ "cmd ::= ANALYZE",
 /* 420 */ "cmd ::= ANALYZE nm dbnm",
 /* 421 */ "cmd ::= ANALYZE nm DOT ID_TAB|ID_IDX",
 /* 422 */ "cmd ::= ANALYZE ID_DB|ID_IDX|ID_TAB",
 /* 423 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 424 */ "cmd ::= ALTER TABLE fullname ADD kwcolumn_opt column",
 /* 425 */ "cmd ::= ALTER TABLE fullname DROP kwcolumn_opt nm",
 /* 426 */ "cmd ::= ALTER TABLE fullname RENAME TO ID_TAB_NEW",
 /* 427 */ "cmd ::= ALTER TABLE nm DOT ID_TAB",
 /* 428 */ "cmd ::= ALTER TABLE ID_DB|ID_TAB",
 /* 429 */ "kwcolumn_opt ::=",
 /* 430 */ "kwcolumn_opt ::= COLUMNKW",
 /* 431 */ "cmd ::= create_vtab",
 /* 432 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm",
 /* 433 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm LP vtabarglist RP",
 /* 434 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm DOT ID_TAB_NEW",
 /* 435 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists ID_DB|ID_TAB_NEW",
 /* 436 */ "vtabarglist ::= vtabarg",
 /* 437 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 438 */ "vtabarg ::=",
 /* 439 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 440 */ "vtabargtoken ::= ANY",
 /* 441 */ "vtabargtoken ::= LP anylist RP",
 /* 442 */ "anylist ::=",
 /* 443 */ "anylist ::= anylist LP anylist RP",
 /* 444 */ "anylist ::= anylist ANY",
 /* 445 */ "with ::=",
 /* 446 */ "with ::= WITH wqlist",
 /* 447 */ "with ::= WITH RECURSIVE wqlist",
 /* 448 */ "wqas ::= AS",
 /* 449 */ "wqas ::= AS MATERIALIZED",
 /* 450 */ "wqas ::= AS NOT MATERIALIZED",
 /* 451 */ "wqlist ::= wqcte",
 /* 452 */ "wqlist ::= wqlist COMMA wqcte",
 /* 453 */ "wqlist ::= ID_TAB_NEW",
 /* 454 */ "wqcte ::= nm idxlist_opt wqas LP select RP",
 /* 455 */ "windowdefn_list ::= windowdefn",
 /* 456 */ "windowdefn_list ::= windowdefn_list COMMA windowdefn",
 /* 457 */ "windowdefn ::= nm AS LP window RP",
 /* 458 */ "window ::= PARTITION BY nexprlist orderby_opt frame_opt",
 /* 459 */ "window ::= nm PARTITION BY nexprlist orderby_opt frame_opt",
 /* 460 */ "window ::= ORDER BY sortlist frame_opt",
 /* 461 */ "window ::= nm ORDER BY sortlist frame_opt",
 /* 462 */ "window ::= frame_opt",
 /* 463 */ "window ::= nm frame_opt",
 /* 464 */ "frame_opt ::=",
 /* 465 */ "frame_opt ::= range_or_rows frame_bound_s frame_exclude_opt",
 /* 466 */ "frame_opt ::= range_or_rows BETWEEN frame_bound_s AND frame_bound_e frame_exclude_opt",
 /* 467 */ "range_or_rows ::= RANGE|ROWS|GROUPS",
 /* 468 */ "frame_bound_s ::= frame_bound",
 /* 469 */ "frame_bound_s ::= UNBOUNDED PRECEDING",
 /* 470 */ "frame_bound_e ::= frame_bound",
 /* 471 */ "frame_bound_e ::= UNBOUNDED FOLLOWING",
 /* 472 */ "frame_bound ::= expr PRECEDING|FOLLOWING",
 /* 473 */ "frame_bound ::= CURRENT ROW",
 /* 474 */ "frame_exclude_opt ::=",
 /* 475 */ "frame_exclude_opt ::= EXCLUDE frame_exclude",
 /* 476 */ "frame_exclude ::= NO OTHERS",
 /* 477 */ "frame_exclude ::= CURRENT ROW",
 /* 478 */ "frame_exclude ::= GROUP",
 /* 479 */ "frame_exclude ::= TIES",
 /* 480 */ "window_clause ::= WINDOW windowdefn_list",
 /* 481 */ "filter_over ::= filter_clause over_clause",
 /* 482 */ "filter_over ::= over_clause",
 /* 483 */ "filter_over ::= filter_clause",
 /* 484 */ "over_clause ::= OVER LP window RP",
 /* 485 */ "over_clause ::= OVER nm",
 /* 486 */ "filter_clause ::= FILTER LP WHERE expr RP",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/*
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3_parse and sqlite3_parseFree.
*/
void *sqlite3_parseAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  sqlite3_parseARG_FETCH;
  if (parserContext->executeRules)
  {
      switch( yymajor ){
        /* Here is inserted the actions which take place when a
        ** terminal or non-terminal is destroyed.  This can happen
        ** when the symbol is popped from the stack during a
        ** reduce or during error processing or when a parser is
        ** being destroyed before it is finished parsing.
        **
        ** Note: during a reduce, the only symbols destroyed are those
        ** which appear on the RHS of the rule, but which are not used
        ** inside the C code.
        */
    case 195: /* cmd */
    case 198: /* ecmd */
    case 200: /* cmdx */
    case 248: /* select_stmt */
    case 277: /* delete_stmt */
    case 279: /* update_stmt */
    case 282: /* insert_stmt */
    case 303: /* trigger_cmd */
    case 307: /* create_vtab */
{
parser_safe_delete((yypminor->yy41));
}
      break;
    case 199: /* explain */
{
parser_safe_delete((yypminor->yy499));
}
      break;
    case 201: /* transtype */
    case 202: /* trans_opt */
{
parser_safe_delete((yypminor->yy512));
}
      break;
    case 203: /* nm */
    case 214: /* columnid */
    case 217: /* id */
    case 218: /* id_opt */
    case 219: /* ids */
    case 221: /* typename */
    case 272: /* dbnm */
    case 294: /* collate */
    case 309: /* vtabarg */
    case 310: /* vtabargtoken */
    case 311: /* anylist */
{
parser_safe_delete((yypminor->yy319));
}
      break;
    case 204: /* savepoint_opt */
    case 206: /* ifnotexists */
    case 230: /* autoinc */
    case 234: /* gen_always */
    case 240: /* tconscomma */
    case 247: /* ifexists */
    case 286: /* not_opt */
    case 292: /* uniqueflag */
    case 304: /* database_kw_opt */
    case 306: /* kwcolumn_opt */
{
parser_safe_delete((yypminor->yy225));
}
      break;
    case 205: /* temp */
    case 254: /* distinct */
{
parser_safe_delete((yypminor->yy130));
}
      break;
    case 207: /* fullname */
{
parser_safe_delete((yypminor->yy396));
}
      break;
    case 208: /* columnlist */
{
parser_safe_delete((yypminor->yy390));
}
      break;
    case 209: /* conslist_opt */
    case 239: /* conslist */
{
parser_safe_delete((yypminor->yy115));
}
      break;
    case 210: /* table_options */
{
parser_safe_delete((yypminor->yy455));
}
      break;
    case 211: /* select */
    case 250: /* selectnowith */
{
parser_safe_delete((yypminor->yy297));
}
      break;
    case 212: /* table_option */
{
parser_safe_delete((yypminor->yy629));
}
      break;
    case 213: /* column */
{
parser_safe_delete((yypminor->yy3));
}
      break;
    case 215: /* type */
    case 220: /* typetoken */
{
parser_safe_delete((yypminor->yy267));
}
      break;
    case 216: /* carglist */
{
parser_safe_delete((yypminor->yy323));
}
      break;
    case 222: /* signed */
    case 223: /* plus_num */
    case 224: /* minus_num */
    case 226: /* term */
    case 296: /* nmnum */
    case 297: /* number */
{
parser_safe_delete((yypminor->yy393));
}
      break;
    case 225: /* ccons */
{
parser_safe_delete((yypminor->yy448));
}
      break;
    case 227: /* expr */
    case 257: /* where_opt */
    case 259: /* having_opt */
    case 285: /* exprx */
    case 288: /* case_operand */
    case 290: /* case_else */
    case 295: /* vinto */
    case 301: /* when_clause */
    case 305: /* key_opt */
{
parser_safe_delete((yypminor->yy186));
}
      break;
    case 228: /* onconf */
    case 244: /* resolvetype */
    case 245: /* orconf */
{
parser_safe_delete((yypminor->yy136));
}
      break;
    case 229: /* sortorder */
{
parser_safe_delete((yypminor->yy35));
}
      break;
    case 231: /* idxlist_opt */
    case 242: /* idxlist */
{
parser_safe_delete((yypminor->yy627));
}
      break;
    case 232: /* refargs */
{
parser_safe_delete((yypminor->yy156));
}
      break;
    case 233: /* defer_subclause */
    case 243: /* defer_subclause_opt */
{
parser_safe_delete((yypminor->yy53));
}
      break;
    case 235: /* tnm */
{
parser_safe_delete((yypminor->yy380));
}
      break;
    case 236: /* refarg */
{
parser_safe_delete((yypminor->yy205));
}
      break;
    case 237: /* refact */
{
parser_safe_delete((yypminor->yy106));
}
      break;
    case 238: /* init_deferred_pred_opt */
{
parser_safe_delete((yypminor->yy612));
}
      break;
    case 241: /* tcons */
{
parser_safe_delete((yypminor->yy400));
}
      break;
    case 249: /* with */
{
parser_safe_delete((yypminor->yy161));
}
      break;
    case 251: /* oneselect */
{
parser_safe_delete((yypminor->yy378));
}
      break;
    case 252: /* multiselect_op */
{
parser_safe_delete((yypminor->yy142));
}
      break;
    case 253: /* values */
{
parser_safe_delete((yypminor->yy522));
}
      break;
    case 255: /* selcollist */
    case 265: /* sclp */
    case 278: /* returning */
{
parser_safe_delete((yypminor->yy27));
}
      break;
    case 256: /* from */
    case 267: /* joinsrc */
{
parser_safe_delete((yypminor->yy553));
}
      break;
    case 258: /* groupby_opt */
    case 263: /* nexprlist */
    case 264: /* exprlist */
    case 289: /* case_exprlist */
{
parser_safe_delete((yypminor->yy615));
}
      break;
    case 260: /* orderby_opt */
    case 275: /* sortlist */
{
parser_safe_delete((yypminor->yy226));
}
      break;
    case 261: /* limit_opt */
{
parser_safe_delete((yypminor->yy360));
}
      break;
    case 262: /* window_clause */
    case 315: /* windowdefn_list */
{
parser_safe_delete((yypminor->yy525));
}
      break;
    case 266: /* as */
{
parser_safe_delete((yypminor->yy628));
}
      break;
    case 268: /* singlesrc */
{
parser_safe_delete((yypminor->yy595));
}
      break;
    case 269: /* seltablist */
{
parser_safe_delete((yypminor->yy107));
}
      break;
    case 270: /* joinop */
{
parser_safe_delete((yypminor->yy449));
}
      break;
    case 271: /* joinconstr_opt */
{
parser_safe_delete((yypminor->yy215));
}
      break;
    case 273: /* indexed_opt */
{
parser_safe_delete((yypminor->yy300));
}
      break;
    case 274: /* idlist */
    case 281: /* idlist_opt */
    case 308: /* vtabarglist */
{
parser_safe_delete((yypminor->yy173));
}
      break;
    case 276: /* nulls */
{
parser_safe_delete((yypminor->yy315));
}
      break;
    case 280: /* setlist */
{
parser_safe_delete((yypminor->yy621));
}
      break;
    case 283: /* insert_cmd */
{
parser_safe_delete((yypminor->yy308));
}
      break;
    case 284: /* upsert */
{
parser_safe_delete((yypminor->yy332));
}
      break;
    case 287: /* likeop */
{
parser_safe_delete((yypminor->yy274));
}
      break;
    case 291: /* filter_over */
{
parser_safe_delete((yypminor->yy181));
}
      break;
    case 293: /* idxlist_single */
{
parser_safe_delete((yypminor->yy110));
}
      break;
    case 298: /* trigger_time */
{
parser_safe_delete((yypminor->yy120));
}
      break;
    case 299: /* trigger_event */
{
parser_safe_delete((yypminor->yy259));
}
      break;
    case 300: /* foreach_clause */
{
parser_safe_delete((yypminor->yy456));
}
      break;
    case 302: /* trigger_cmd_list */
{
parser_safe_delete((yypminor->yy240));
}
      break;
    case 312: /* wqlist */
{
parser_safe_delete((yypminor->yy164));
}
      break;
    case 313: /* wqas */
{
parser_safe_delete((yypminor->yy21));
}
      break;
    case 314: /* wqcte */
{
parser_safe_delete((yypminor->yy146));
}
      break;
    case 316: /* windowdefn */
{
parser_safe_delete((yypminor->yy562));
}
      break;
    case 317: /* window */
{
parser_safe_delete((yypminor->yy162));
}
      break;
    case 318: /* frame_opt */
{
parser_safe_delete((yypminor->yy149));
}
      break;
    case 319: /* range_or_rows */
{
parser_safe_delete((yypminor->yy143));
}
      break;
    case 320: /* frame_bound_s */
    case 322: /* frame_bound_e */
{
parser_safe_delete((yypminor->yy285));
}
      break;
    case 323: /* frame_bound */
{
parser_safe_delete((yypminor->yy285));parser_safe_delete((yypminor->yy285));parser_safe_delete((yypminor->yy285));
}
      break;
    case 325: /* filter_clause */
{
parser_safe_delete((yypminor->yy39));
}
      break;
    case 326: /* over_clause */
{
parser_safe_delete((yypminor->yy11));
}
      break;
        default:  break;   /* If no destructor action specified: do nothing */
      }
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  /* There is no mechanism by which the parser stack can be popped below
  ** empty in SQLite.  */
  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  delete yytos->tokens;
  yytos->tokens = nullptr;
  pParser->yyidx--;
  return yymajor;
}

/*
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3_parseAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3_parseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  /* In SQLite, we never try to destroy a parser that was not successfully
  ** created in the first place. */
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int sqlite3_parseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
  GET_CONTEXT;

  if( stateno>YY_SHIFT_COUNT
   || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0
             && parserContext->doFallbacks ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if(
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   UNUSED(yypMinor);
   sqlite3_parseARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */

    parserContext->error(QObject::tr("Parser stack overflow"));
   sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
  yytos->tokens = new QList<Token*>();
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 196, 1 },
  { 197, 2 },
  { 197, 1 },
  { 198, 1 },
  { 198, 3 },
  { 199, 0 },
  { 199, 1 },
  { 199, 3 },
  { 200, 1 },
  { 195, 3 },
  { 202, 0 },
  { 202, 1 },
  { 202, 2 },
  { 202, 2 },
  { 201, 0 },
  { 201, 1 },
  { 201, 1 },
  { 201, 1 },
  { 195, 2 },
  { 195, 2 },
  { 195, 2 },
  { 204, 1 },
  { 204, 0 },
  { 195, 2 },
  { 195, 3 },
  { 195, 5 },
  { 195, 2 },
  { 195, 3 },
  { 195, 5 },
  { 195, 10 },
  { 195, 7 },
  { 195, 7 },
  { 195, 5 },
  { 210, 0 },
  { 210, 1 },
  { 210, 3 },
  { 212, 2 },
  { 212, 1 },
  { 212, 2 },
  { 212, 1 },
  { 206, 0 },
  { 206, 3 },
  { 205, 1 },
  { 205, 0 },
  { 208, 3 },
  { 208, 1 },
  { 213, 3 },
  { 214, 1 },
  { 214, 1 },
  { 217, 1 },
  { 218, 1 },
  { 218, 0 },
  { 219, 1 },
  { 203, 1 },
  { 203, 1 },
  { 203, 1 },
  { 215, 0 },
  { 215, 1 },
  { 220, 1 },
  { 220, 4 },
  { 220, 6 },
  { 221, 1 },
  { 221, 2 },
  { 221, 1 },
  { 222, 1 },
  { 222, 1 },
  { 216, 2 },
  { 216, 0 },
  { 225, 2 },
  { 225, 2 },
  { 225, 4 },
  { 225, 3 },
  { 225, 3 },
  { 225, 2 },
  { 225, 2 },
  { 225, 2 },
  { 225, 3 },
  { 225, 5 },
  { 225, 2 },
  { 225, 4 },
  { 225, 4 },
  { 225, 1 },
  { 225, 2 },
  { 225, 6 },
  { 225, 2 },
  { 225, 2 },
  { 225, 2 },
  { 225, 3 },
  { 226, 1 },
  { 226, 1 },
  { 226, 1 },
  { 226, 1 },
  { 235, 1 },
  { 235, 1 },
  { 234, 2 },
  { 234, 0 },
  { 230, 0 },
  { 230, 1 },
  { 232, 0 },
  { 232, 2 },
  { 236, 2 },
  { 236, 3 },
  { 236, 3 },
  { 236, 3 },
  { 236, 2 },
  { 237, 2 },
  { 237, 2 },
  { 237, 1 },
  { 237, 1 },
  { 237, 2 },
  { 233, 3 },
  { 233, 2 },
  { 238, 0 },
  { 238, 2 },
  { 238, 2 },
  { 209, 0 },
  { 209, 2 },
  { 239, 3 },
  { 239, 1 },
  { 240, 1 },
  { 240, 0 },
  { 241, 2 },
  { 241, 7 },
  { 241, 5 },
  { 241, 5 },
  { 241, 10 },
  { 241, 2 },
  { 241, 7 },
  { 241, 4 },
  { 243, 0 },
  { 243, 1 },
  { 228, 0 },
  { 228, 3 },
  { 245, 0 },
  { 245, 2 },
  { 244, 1 },
  { 244, 1 },
  { 244, 1 },
  { 195, 4 },
  { 195, 6 },
  { 195, 4 },
  { 247, 2 },
  { 247, 0 },
  { 195, 8 },
  { 195, 7 },
  { 195, 5 },
  { 195, 4 },
  { 195, 6 },
  { 195, 4 },
  { 195, 1 },
  { 248, 1 },
  { 211, 2 },
  { 250, 1 },
  { 250, 3 },
  { 250, 1 },
  { 250, 3 },
  { 251, 9 },
  { 251, 10 },
  { 253, 4 },
  { 253, 5 },
  { 252, 1 },
  { 252, 2 },
  { 252, 1 },
  { 252, 1 },
  { 254, 1 },
  { 254, 1 },
  { 254, 0 },
  { 265, 2 },
  { 265, 0 },
  { 255, 3 },
  { 255, 2 },
  { 255, 4 },
  { 255, 1 },
  { 255, 4 },
  { 266, 2 },
  { 266, 1 },
  { 266, 2 },
  { 266, 1 },
  { 266, 0 },
  { 256, 0 },
  { 256, 2 },
  { 267, 2 },
  { 267, 0 },
  { 269, 4 },
  { 269, 0 },
  { 268, 4 },
  { 268, 4 },
  { 268, 4 },
  { 268, 6 },
  { 268, 0 },
  { 268, 2 },
  { 268, 3 },
  { 268, 1 },
  { 268, 3 },
  { 268, 1 },
  { 271, 2 },
  { 271, 4 },
  { 271, 0 },
  { 272, 0 },
  { 272, 2 },
  { 207, 2 },
  { 270, 1 },
  { 270, 1 },
  { 270, 2 },
  { 270, 3 },
  { 270, 4 },
  { 270, 1 },
  { 273, 0 },
  { 273, 3 },
  { 273, 2 },
  { 273, 3 },
  { 260, 0 },
  { 260, 3 },
  { 275, 5 },
  { 275, 3 },
  { 229, 1 },
  { 229, 1 },
  { 229, 0 },
  { 276, 2 },
  { 276, 2 },
  { 276, 0 },
  { 258, 0 },
  { 258, 3 },
  { 258, 2 },
  { 259, 0 },
  { 259, 2 },
  { 261, 0 },
  { 261, 2 },
  { 261, 4 },
  { 261, 4 },
  { 195, 1 },
  { 277, 7 },
  { 277, 3 },
  { 277, 5 },
  { 277, 6 },
  { 277, 4 },
  { 257, 0 },
  { 257, 2 },
  { 257, 1 },
  { 278, 0 },
  { 278, 2 },
  { 195, 1 },
  { 279, 10 },
  { 279, 3 },
  { 279, 5 },
  { 279, 6 },
  { 279, 4 },
  { 280, 5 },
  { 280, 7 },
  { 280, 3 },
  { 280, 5 },
  { 280, 0 },
  { 280, 2 },
  { 280, 3 },
  { 280, 1 },
  { 281, 0 },
  { 281, 3 },
  { 274, 3 },
  { 274, 1 },
  { 274, 0 },
  { 274, 3 },
  { 274, 1 },
  { 195, 1 },
  { 282, 8 },
  { 282, 8 },
  { 282, 3 },
  { 282, 5 },
  { 282, 4 },
  { 282, 6 },
  { 283, 2 },
  { 283, 1 },
  { 284, 0 },
  { 284, 11 },
  { 284, 8 },
  { 284, 4 },
  { 285, 4 },
  { 285, 6 },
  { 285, 1 },
  { 285, 3 },
  { 285, 5 },
  { 285, 3 },
  { 285, 6 },
  { 285, 1 },
  { 285, 3 },
  { 285, 1 },
  { 285, 3 },
  { 285, 2 },
  { 285, 5 },
  { 285, 4 },
  { 285, 1 },
  { 285, 3 },
  { 285, 6 },
  { 285, 5 },
  { 285, 4 },
  { 285, 3 },
  { 285, 3 },
  { 285, 3 },
  { 285, 3 },
  { 285, 3 },
  { 285, 3 },
  { 285, 3 },
  { 285, 3 },
  { 285, 4 },
  { 285, 6 },
  { 285, 2 },
  { 285, 3 },
  { 285, 4 },
  { 285, 6 },
  { 285, 5 },
  { 285, 2 },
  { 285, 2 },
  { 285, 2 },
  { 285, 2 },
  { 285, 3 },
  { 285, 6 },
  { 285, 6 },
  { 285, 3 },
  { 285, 6 },
  { 285, 5 },
  { 285, 4 },
  { 285, 5 },
  { 285, 4 },
  { 285, 6 },
  { 285, 6 },
  { 285, 5 },
  { 227, 0 },
  { 227, 1 },
  { 286, 0 },
  { 286, 1 },
  { 287, 1 },
  { 289, 5 },
  { 289, 4 },
  { 290, 2 },
  { 290, 0 },
  { 288, 1 },
  { 288, 0 },
  { 264, 1 },
  { 264, 0 },
  { 263, 3 },
  { 263, 1 },
  { 195, 12 },
  { 195, 8 },
  { 195, 7 },
  { 195, 5 },
  { 292, 1 },
  { 292, 0 },
  { 231, 0 },
  { 231, 3 },
  { 242, 3 },
  { 242, 1 },
  { 293, 3 },
  { 293, 1 },
  { 294, 0 },
  { 294, 2 },
  { 294, 2 },
  { 195, 4 },
  { 195, 6 },
  { 195, 4 },
  { 195, 2 },
  { 195, 3 },
  { 295, 2 },
  { 295, 0 },
  { 195, 3 },
  { 195, 5 },
  { 195, 6 },
  { 195, 5 },
  { 195, 6 },
  { 195, 4 },
  { 195, 2 },
  { 296, 1 },
  { 296, 1 },
  { 296, 1 },
  { 296, 1 },
  { 296, 1 },
  { 223, 2 },
  { 223, 1 },
  { 224, 2 },
  { 297, 1 },
  { 297, 1 },
  { 195, 15 },
  { 195, 12 },
  { 195, 14 },
  { 195, 10 },
  { 195, 7 },
  { 195, 5 },
  { 298, 1 },
  { 298, 1 },
  { 298, 2 },
  { 298, 0 },
  { 299, 1 },
  { 299, 1 },
  { 299, 1 },
  { 299, 3 },
  { 300, 0 },
  { 300, 3 },
  { 301, 0 },
  { 301, 2 },
  { 302, 3 },
  { 302, 2 },
  { 302, 1 },
  { 303, 1 },
  { 303, 1 },
  { 303, 1 },
  { 303, 1 },
  { 246, 1 },
  { 195, 4 },
  { 195, 6 },
  { 195, 4 },
  { 195, 6 },
  { 195, 3 },
  { 305, 0 },
  { 305, 2 },
  { 304, 1 },
  { 304, 0 },
  { 195, 1 },
  { 195, 3 },
  { 195, 2 },
  { 195, 4 },
  { 195, 2 },
  { 195, 1 },
  { 195, 3 },
  { 195, 4 },
  { 195, 2 },
  { 195, 6 },
  { 195, 6 },
  { 195, 6 },
  { 195, 6 },
  { 195, 5 },
  { 195, 3 },
  { 306, 0 },
  { 306, 1 },
  { 195, 1 },
  { 307, 8 },
  { 307, 11 },
  { 307, 7 },
  { 307, 5 },
  { 308, 1 },
  { 308, 3 },
  { 309, 0 },
  { 309, 2 },
  { 310, 1 },
  { 310, 3 },
  { 311, 0 },
  { 311, 4 },
  { 311, 2 },
  { 249, 0 },
  { 249, 2 },
  { 249, 3 },
  { 313, 1 },
  { 313, 2 },
  { 313, 3 },
  { 312, 1 },
  { 312, 3 },
  { 312, 1 },
  { 314, 6 },
  { 315, 1 },
  { 315, 3 },
  { 316, 5 },
  { 317, 5 },
  { 317, 6 },
  { 317, 4 },
  { 317, 5 },
  { 317, 1 },
  { 317, 2 },
  { 318, 0 },
  { 318, 3 },
  { 318, 6 },
  { 319, 1 },
  { 320, 1 },
  { 320, 2 },
  { 322, 1 },
  { 322, 2 },
  { 323, 2 },
  { 323, 2 },
  { 321, 0 },
  { 321, 2 },
  { 324, 2 },
  { 324, 2 },
  { 324, 1 },
  { 324, 1 },
  { 262, 2 },
  { 291, 2 },
  { 291, 1 },
  { 291, 1 },
  { 326, 4 },
  { 326, 2 },
  { 325, 5 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3_parseARG_FETCH;
  SqliteStatement* objectForTokens = 0;
  QStringList noTokenInheritanceFields;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  if (parserContext->executeRules)
  {
      switch( yyruleno ){
      /* Beginning here are the reduction cases.  A typical example
      ** follows:
      **   case 0:
      **  #line <lineno> <grammarfile>
      **     { ... }           // User supplied code
      **  #line <lineno> <thisfile>
      **     break;
      */
      case 1: /* cmdlist ::= cmdlist ecmd */
{parserContext->addQuery(yymsp[0].minor.yy41); DONT_INHERIT_TOKENS("cmdlist");}
        break;
      case 2: /* cmdlist ::= ecmd */
{parserContext->addQuery(yymsp[0].minor.yy41);}
        break;
      case 3: /* ecmd ::= SEMI */
{yygotominor.yy41 = new SqliteEmptyQuery();}
        break;
      case 4: /* ecmd ::= explain cmdx SEMI */
{
                                                yygotominor.yy41 = yymsp[-1].minor.yy41;
                                                yygotominor.yy41->explain = yymsp[-2].minor.yy499->explain;
                                                yygotominor.yy41->queryPlan = yymsp[-2].minor.yy499->queryPlan;
                                                delete yymsp[-2].minor.yy499;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 5: /* explain ::= */
{yygotominor.yy499 = new ParserStubExplain(false, false);}
        break;
      case 6: /* explain ::= EXPLAIN */
{yygotominor.yy499 = new ParserStubExplain(true, false);}
        break;
      case 7: /* explain ::= EXPLAIN QUERY PLAN */
{yygotominor.yy499 = new ParserStubExplain(true, true);}
        break;
      case 8: /* cmdx ::= cmd */
      case 400: /* trigger_cmd ::= update_stmt */ yytestcase(yyruleno==400);
      case 401: /* trigger_cmd ::= insert_stmt */ yytestcase(yyruleno==401);
      case 402: /* trigger_cmd ::= delete_stmt */ yytestcase(yyruleno==402);
      case 403: /* trigger_cmd ::= select_stmt */ yytestcase(yyruleno==403);
      case 431: /* cmd ::= create_vtab */ yytestcase(yyruleno==431);
{yygotominor.yy41 = yymsp[0].minor.yy41;}
        break;
      case 9: /* cmd ::= BEGIN transtype trans_opt */
{
                                                yygotominor.yy41 = new SqliteBeginTrans(
                                                        yymsp[-1].minor.yy512->type,
                                                        yymsp[0].minor.yy512->transactionKw,
                                                        yymsp[0].minor.yy512->name
                                                    );
                                                delete yymsp[0].minor.yy512;
                                                delete yymsp[-1].minor.yy512;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 10: /* trans_opt ::= */
      case 14: /* transtype ::= */ yytestcase(yyruleno==14);
{yygotominor.yy512 = new ParserStubTransDetails();}
        break;
      case 11: /* trans_opt ::= TRANSACTION */
{
                                                yygotominor.yy512 = new ParserStubTransDetails();
                                                yygotominor.yy512->transactionKw = true;
                                            }
        break;
      case 12: /* trans_opt ::= TRANSACTION nm */
      case 13: /* trans_opt ::= TRANSACTION ID_TRANS */ yytestcase(yyruleno==13);
{
                                                yygotominor.yy512 = new ParserStubTransDetails();
                                                yygotominor.yy512->transactionKw = true;
                                                yygotominor.yy512->name = *(yymsp[0].minor.yy319);
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 15: /* transtype ::= DEFERRED */
{
                                                yygotominor.yy512 = new ParserStubTransDetails();
                                                yygotominor.yy512->type = SqliteBeginTrans::Type::DEFERRED;
                                            }
        break;
      case 16: /* transtype ::= IMMEDIATE */
{
                                                yygotominor.yy512 = new ParserStubTransDetails();
                                                yygotominor.yy512->type = SqliteBeginTrans::Type::IMMEDIATE;
                                            }
        break;
      case 17: /* transtype ::= EXCLUSIVE */
{
                                                yygotominor.yy512 = new ParserStubTransDetails();
                                                yygotominor.yy512->type = SqliteBeginTrans::Type::EXCLUSIVE;
                                            }
        break;
      case 18: /* cmd ::= COMMIT trans_opt */
{
                                                yygotominor.yy41 = new SqliteCommitTrans(
                                                        yymsp[0].minor.yy512->transactionKw,
                                                        yymsp[0].minor.yy512->name,
                                                        false
                                                    );
                                                delete yymsp[0].minor.yy512;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 19: /* cmd ::= END trans_opt */
{
                                                yygotominor.yy41 = new SqliteCommitTrans(
                                                        yymsp[0].minor.yy512->transactionKw,
                                                        yymsp[0].minor.yy512->name,
                                                        true
                                                    );
                                                delete yymsp[0].minor.yy512;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 20: /* cmd ::= ROLLBACK trans_opt */
{
                                                yygotominor.yy41 = new SqliteRollback(
                                                        yymsp[0].minor.yy512->transactionKw,
                                                        yymsp[0].minor.yy512->name
                                                    );
                                                delete yymsp[0].minor.yy512;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 21: /* savepoint_opt ::= SAVEPOINT */
      case 41: /* ifnotexists ::= IF NOT EXISTS */ yytestcase(yyruleno==41);
      case 94: /* gen_always ::= GENERATED ALWAYS */ yytestcase(yyruleno==94);
      case 97: /* autoinc ::= AUTOINCR */ yytestcase(yyruleno==97);
      case 119: /* tconscomma ::= COMMA */ yytestcase(yyruleno==119);
      case 141: /* ifexists ::= IF EXISTS */ yytestcase(yyruleno==141);
      case 328: /* not_opt ::= NOT */ yytestcase(yyruleno==328);
      case 344: /* uniqueflag ::= UNIQUE */ yytestcase(yyruleno==344);
      case 412: /* database_kw_opt ::= DATABASE */ yytestcase(yyruleno==412);
      case 429: /* kwcolumn_opt ::= */ yytestcase(yyruleno==429);
{yygotominor.yy225 = new bool(true);}
        break;
      case 22: /* savepoint_opt ::= */
      case 40: /* ifnotexists ::= */ yytestcase(yyruleno==40);
      case 95: /* gen_always ::= */ yytestcase(yyruleno==95);
      case 96: /* autoinc ::= */ yytestcase(yyruleno==96);
      case 120: /* tconscomma ::= */ yytestcase(yyruleno==120);
      case 142: /* ifexists ::= */ yytestcase(yyruleno==142);
      case 327: /* not_opt ::= */ yytestcase(yyruleno==327);
      case 345: /* uniqueflag ::= */ yytestcase(yyruleno==345);
      case 413: /* database_kw_opt ::= */ yytestcase(yyruleno==413);
      case 430: /* kwcolumn_opt ::= COLUMNKW */ yytestcase(yyruleno==430);
{yygotominor.yy225 = new bool(false);}
        break;
      case 23: /* cmd ::= SAVEPOINT nm */
{
                                                yygotominor.yy41 = new SqliteSavepoint(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 24: /* cmd ::= RELEASE savepoint_opt nm */
{
                                                yygotominor.yy41 = new SqliteRelease(*(yymsp[-1].minor.yy225), *(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 25: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt nm */
      case 26: /* cmd ::= SAVEPOINT ID_TRANS */ yytestcase(yyruleno==26);
{
                                                yygotominor.yy41 = new SqliteRollback(
                                                        yymsp[-3].minor.yy512->transactionKw,
                                                        *(yymsp[-1].minor.yy225),
                                                        *(yymsp[0].minor.yy319)
                                                    );
                                                delete yymsp[-1].minor.yy225;
                                                delete yymsp[-3].minor.yy512;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 27: /* cmd ::= RELEASE savepoint_opt ID_TRANS */
      case 28: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt ID_TRANS */ yytestcase(yyruleno==28);
{  yy_destructor(yypParser,204,&yymsp[-1].minor);
}
        break;
      case 29: /* cmd ::= CREATE temp TABLE ifnotexists fullname LP columnlist conslist_opt RP table_options */
{
                                                yygotominor.yy41 = new SqliteCreateTable(
                                                        *(yymsp[-6].minor.yy225),
                                                        *(yymsp[-8].minor.yy130),
                                                        yymsp[-5].minor.yy396->name1,
                                                        yymsp[-5].minor.yy396->name2,
                                                        *(yymsp[-3].minor.yy390),
                                                        *(yymsp[-2].minor.yy115),
                                                        *(yymsp[0].minor.yy455)
                                                    );
                                                delete yymsp[-6].minor.yy225;
                                                delete yymsp[-8].minor.yy130;
                                                delete yymsp[-3].minor.yy390;
                                                delete yymsp[-2].minor.yy115;
                                                delete yymsp[-5].minor.yy396;
                                                delete yymsp[0].minor.yy455;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 30: /* cmd ::= CREATE temp TABLE ifnotexists fullname AS select */
{
                                                yygotominor.yy41 = new SqliteCreateTable(
                                                        *(yymsp[-3].minor.yy225),
                                                        *(yymsp[-5].minor.yy130),
                                                        yymsp[-2].minor.yy396->name1,
                                                        yymsp[-2].minor.yy396->name2,
                                                        yymsp[0].minor.yy297
                                                    );
                                                delete yymsp[-3].minor.yy225;
                                                delete yymsp[-5].minor.yy130;
                                                delete yymsp[-2].minor.yy396;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 31: /* cmd ::= CREATE temp TABLE ifnotexists nm DOT ID_TAB_NEW */
      case 144: /* cmd ::= CREATE temp VIEW ifnotexists nm DOT ID_VIEW_NEW */ yytestcase(yyruleno==144);
      case 383: /* cmd ::= CREATE temp TRIGGER ifnotexists nm DOT ID_TRIG_NEW */ yytestcase(yyruleno==383);
{  yy_destructor(yypParser,205,&yymsp[-5].minor);
  yy_destructor(yypParser,203,&yymsp[-2].minor);
}
        break;
      case 32: /* cmd ::= CREATE temp TABLE ifnotexists ID_DB|ID_TAB_NEW */
      case 145: /* cmd ::= CREATE temp VIEW ifnotexists ID_DB|ID_VIEW_NEW */ yytestcase(yyruleno==145);
      case 384: /* cmd ::= CREATE temp TRIGGER ifnotexists ID_DB|ID_TRIG_NEW */ yytestcase(yyruleno==384);
{  yy_destructor(yypParser,205,&yymsp[-3].minor);
}
        break;
      case 33: /* table_options ::= */
{yygotominor.yy455 = new ParserCreateTableOptionList();}
        break;
      case 34: /* table_options ::= table_option */
{
                                                yygotominor.yy455 = new ParserCreateTableOptionList();
                                                yygotominor.yy455->append(yymsp[0].minor.yy629);
                                            }
        break;
      case 35: /* table_options ::= table_options COMMA table_option */
{
                                                yymsp[-2].minor.yy455->append(yymsp[0].minor.yy629);
                                                yygotominor.yy455 = yymsp[-2].minor.yy455;
                                                DONT_INHERIT_TOKENS("table_options");
                                            }
        break;
      case 36: /* table_option ::= WITHOUT nm */
{
                                                if (yymsp[0].minor.yy319->toLower() != "rowid")
                                                    parserContext->errorAtToken(QString("Invalid table option: %1").arg(*(yymsp[0].minor.yy319)));

                                                yygotominor.yy629 = new ParserStubCreateTableOption(ParserStubCreateTableOption::WITHOUT_ROWID);
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 37: /* table_option ::= nm */
      case 38: /* table_option ::= WITHOUT CTX_ROWID_KW */ yytestcase(yyruleno==38);
      case 39: /* table_option ::= CTX_STRICT_KW */ yytestcase(yyruleno==39);
{
                                                if (yymsp[0].minor.yy319->toLower() != "strict")
                                                    parserContext->errorAtToken(QString("Invalid table option: %1").arg(*(yymsp[0].minor.yy319)));

                                                yygotominor.yy629 = new ParserStubCreateTableOption(ParserStubCreateTableOption::STRICT);
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 42: /* temp ::= TEMP */
{yygotominor.yy130 = new int( (yymsp[0].minor.yy0->value.length() > 4) ? 2 : 1 );}
        break;
      case 43: /* temp ::= */
      case 166: /* distinct ::= */ yytestcase(yyruleno==166);
{yygotominor.yy130 = new int(0);}
        break;
      case 44: /* columnlist ::= columnlist COMMA column */
{
                                                yymsp[-2].minor.yy390->append(yymsp[0].minor.yy3);
                                                yygotominor.yy390 = yymsp[-2].minor.yy390;
                                                DONT_INHERIT_TOKENS("columnlist");
                                            }
        break;
      case 45: /* columnlist ::= column */
{
                                                yygotominor.yy390 = new ParserCreateTableColumnList();
                                                yygotominor.yy390->append(yymsp[0].minor.yy3);
                                            }
        break;
      case 46: /* column ::= columnid type carglist */
{
                                                yygotominor.yy3 = new SqliteCreateTable::Column(*(yymsp[-2].minor.yy319), yymsp[-1].minor.yy267, *(yymsp[0].minor.yy323));
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[0].minor.yy323;
                                                objectForTokens = yygotominor.yy3;
                                            }
        break;
      case 47: /* columnid ::= nm */
      case 48: /* columnid ::= ID_COL_NEW */ yytestcase(yyruleno==48);
      case 53: /* nm ::= id */ yytestcase(yyruleno==53);
      case 61: /* typename ::= ids */ yytestcase(yyruleno==61);
      case 199: /* dbnm ::= DOT nm */ yytestcase(yyruleno==199);
      case 353: /* collate ::= COLLATE ids */ yytestcase(yyruleno==353);
      case 354: /* collate ::= COLLATE ID_COLLATE */ yytestcase(yyruleno==354);
{yygotominor.yy319 = yymsp[0].minor.yy319;}
        break;
      case 49: /* id ::= ID */
{
                                                yygotominor.yy319 = new QString(
                                                    stripObjName(
                                                        yymsp[0].minor.yy0->value
                                                    )
                                                );
                                            }
        break;
      case 50: /* id_opt ::= id */
{
                                                yygotominor.yy319 = yymsp[0].minor.yy319;
                                            }
        break;
      case 51: /* id_opt ::= */
{
                                                yygotominor.yy319 = new QString();
                                            }
        break;
      case 52: /* ids ::= ID|STRING */
      case 55: /* nm ::= JOIN_KW */ yytestcase(yyruleno==55);
{yygotominor.yy319 = new QString(yymsp[0].minor.yy0->value);}
        break;
      case 54: /* nm ::= STRING */
{yygotominor.yy319 = new QString(stripString(yymsp[0].minor.yy0->value));}
        break;
      case 56: /* type ::= */
{yygotominor.yy267 = nullptr;}
        break;
      case 57: /* type ::= typetoken */
{yygotominor.yy267 = yymsp[0].minor.yy267;}
        break;
      case 58: /* typetoken ::= typename */
{
                                                yygotominor.yy267 = new SqliteColumnType(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy267;
                                            }
        break;
      case 59: /* typetoken ::= typename LP signed RP */
{
                                                yygotominor.yy267 = new SqliteColumnType(*(yymsp[-3].minor.yy319), *(yymsp[-1].minor.yy393));
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-1].minor.yy393;
                                                objectForTokens = yygotominor.yy267;
                                            }
        break;
      case 60: /* typetoken ::= typename LP signed COMMA signed RP */
{
                                                yygotominor.yy267 = new SqliteColumnType(*(yymsp[-5].minor.yy319), *(yymsp[-3].minor.yy393), *(yymsp[-1].minor.yy393));
                                                delete yymsp[-5].minor.yy319;
                                                delete yymsp[-3].minor.yy393;
                                                delete yymsp[-1].minor.yy393;
                                                objectForTokens = yygotominor.yy267;
                                            }
        break;
      case 62: /* typename ::= typename ids */
      case 63: /* typename ::= ID_COL_TYPE */ yytestcase(yyruleno==63);
{
                                                yymsp[-1].minor.yy319->append(" " + *(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                yygotominor.yy319 = yymsp[-1].minor.yy319;
                                            }
        break;
      case 64: /* signed ::= plus_num */
      case 65: /* signed ::= minus_num */ yytestcase(yyruleno==65);
      case 369: /* nmnum ::= plus_num */ yytestcase(yyruleno==369);
      case 374: /* plus_num ::= PLUS number */ yytestcase(yyruleno==374);
      case 375: /* plus_num ::= number */ yytestcase(yyruleno==375);
{yygotominor.yy393 = yymsp[0].minor.yy393;}
        break;
      case 66: /* carglist ::= carglist ccons */
{
                                                yymsp[-1].minor.yy323->append(yymsp[0].minor.yy448);
                                                yygotominor.yy323 = yymsp[-1].minor.yy323;
                                                DONT_INHERIT_TOKENS("carglist");
                                            }
        break;
      case 67: /* carglist ::= */
{yygotominor.yy323 = new ParserCreateTableColumnConstraintList();}
        break;
      case 68: /* ccons ::= CONSTRAINT nm */
{
                                                yygotominor.yy448 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy448->initDefNameOnly(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy448;
                                            }
        break;
      case 69: /* ccons ::= DEFAULT term */
{
                                                yygotominor.yy448 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy448->initDefTerm(*(yymsp[0].minor.yy393));
                                                delete yymsp[0].minor.yy393;
                                                objectForTokens = yygotominor.yy448;
                                            }
        break;
      case 70: /* ccons ::= DEFAULT LP expr RP */
{
                                                yygotominor.yy448 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy448->initDefExpr(yymsp[-1].minor.yy186);
                                                objectForTokens = yygotominor.yy448;
                                            }
        break;
      case 71: /* ccons ::= DEFAULT PLUS term */
{
                                                yygotominor.yy448 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy448->initDefTerm(*(yymsp[0].minor.yy393), false);
                                                delete yymsp[0].minor.yy393;
                                                objectForTokens = yygotominor.yy448;
                                            }
        break;
      case 72: /* ccons ::= DEFAULT MINUS term */
{
                                                yygotominor.yy448 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy448->initDefTerm(*(yymsp[0].minor.yy393), true);
                                                delete yymsp[0].minor.yy393;
                                                objectForTokens = yygotominor.yy448;
                                            }
        break;
      case 73: /* ccons ::= DEFAULT id */
{
                                                yygotominor.yy448 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy448->initDefId(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy448;
                                            }
        break;
      case 74: /* ccons ::= DEFAULT CTIME_KW */
{
                                                yygotominor.yy448 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy448->initDefCTime(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy448;
                                            }
        break;
      case 75: /* ccons ::= NULL onconf */
{
                                                yygotominor.yy448 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy448->initNull(*(yymsp[0].minor.yy136));
                                                delete yymsp[0].minor.yy136;
                                                objectForTokens = yygotominor.yy448;
                                            }
        break;
      case 76: /* ccons ::= NOT NULL onconf */
{
                                                yygotominor.yy448 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy448->initNotNull(*(yymsp[0].minor.yy136));
                                                delete yymsp[0].minor.yy136;
                                                objectForTokens = yygotominor.yy448;
                                            }
        break;
      case 77: /* ccons ::= PRIMARY KEY sortorder onconf autoinc */
{
                                                yygotominor.yy448 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy448->initPk(*(yymsp[-2].minor.yy35), *(yymsp[-1].minor.yy136), *(yymsp[0].minor.yy225));
                                                delete yymsp[-2].minor.yy35;
                                                delete yymsp[0].minor.yy225;
                                                delete yymsp[-1].minor.yy136;
                                                objectForTokens = yygotominor.yy448;
                                            }
        break;
      case 78: /* ccons ::= UNIQUE onconf */
{
                                                yygotominor.yy448 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy448->initUnique(*(yymsp[0].minor.yy136));
                                                delete yymsp[0].minor.yy136;
                                                objectForTokens = yygotominor.yy448;
                                            }
        break;
      case 79: /* ccons ::= CHECK LP expr RP */
{
                                                yygotominor.yy448 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy448->initCheck(yymsp[-1].minor.yy186);
                                                objectForTokens = yygotominor.yy448;
                                            }
        break;
      case 80: /* ccons ::= REFERENCES nm idxlist_opt refargs */
{
                                                yygotominor.yy448 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy448->initFk(*(yymsp[-2].minor.yy319), *(yymsp[-1].minor.yy627), *(yymsp[0].minor.yy156));
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[0].minor.yy156;
                                                delete yymsp[-1].minor.yy627;
                                                objectForTokens = yygotominor.yy448;
                                            }
        break;
      case 81: /* ccons ::= defer_subclause */
{
                                                yygotominor.yy448 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy448->initDefer(yymsp[0].minor.yy53->initially, yymsp[0].minor.yy53->deferrable);
                                                delete yymsp[0].minor.yy53;
                                                objectForTokens = yygotominor.yy448;
                                            }
        break;
      case 82: /* ccons ::= COLLATE ids */
{
                                                yygotominor.yy448 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy448->initColl(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy448;
                                            }
        break;
      case 83: /* ccons ::= gen_always AS LP expr RP id_opt */
      case 84: /* ccons ::= CONSTRAINT ID_CONSTR */ yytestcase(yyruleno==84);
      case 85: /* ccons ::= COLLATE ID_COLLATE */ yytestcase(yyruleno==85);
      case 86: /* ccons ::= REFERENCES ID_TAB */ yytestcase(yyruleno==86);
{
                                                if (!yymsp[0].minor.yy319->isNull() && yymsp[0].minor.yy319->toLower() != "stored" && yymsp[0].minor.yy319->toLower() != "virtual")
                                                    parserContext->errorAtToken(QString("Invalid generated column type: %1").arg(*(yymsp[0].minor.yy319)));

                                                yygotominor.yy448 = new SqliteCreateTable::Column::Constraint();
												yygotominor.yy448->initGeneratedAs(yymsp[-2].minor.yy186, *(yymsp[-5].minor.yy225), *(yymsp[0].minor.yy319));
												delete yymsp[-5].minor.yy225;
												delete yymsp[0].minor.yy319;
												objectForTokens = yygotominor.yy448;
											}
        break;
      case 87: /* ccons ::= CHECK LP RP */
{
                                                yygotominor.yy448 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy448->initCheck();
                                                objectForTokens = yygotominor.yy448;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 88: /* term ::= NULL */
{yygotominor.yy393 = new QVariant();}
        break;
      case 89: /* term ::= INTEGER */
      case 377: /* number ::= INTEGER */ yytestcase(yyruleno==377);
{yygotominor.yy393 = parserContext->handleNumberToken(yymsp[0].minor.yy0->value);}
        break;
      case 90: /* term ::= FLOAT */
      case 378: /* number ::= FLOAT */ yytestcase(yyruleno==378);
{yygotominor.yy393 = new QVariant(QVariant(yymsp[0].minor.yy0->value).toDouble());}
        break;
      case 91: /* term ::= STRING|BLOB */
{
                                                if (yymsp[0].minor.yy0->value.length() >= 3 && yymsp[0].minor.yy0->value.startsWith("x'", Qt::CaseInsensitive))
                                                    yygotominor.yy393 = new QVariant(blobFromLiteral(yymsp[0].minor.yy0->value));
                                                else
                                                    yygotominor.yy393 = new QVariant(stripString(yymsp[0].minor.yy0->value));
                                            }
        break;
      case 92: /* tnm ::= term */
{
												yygotominor.yy380 = new ParserTermOrLiteral(*(yymsp[0].minor.yy393));
												delete yymsp[0].minor.yy393;
											}
        break;
      case 93: /* tnm ::= nm */
{
												yygotominor.yy380 = new ParserTermOrLiteral(*(yymsp[0].minor.yy319));
												delete yymsp[0].minor.yy319;
											}
        break;
      case 98: /* refargs ::= */
{yygotominor.yy156 = new ParserFkConditionList();}
        break;
      case 99: /* refargs ::= refargs refarg */
{
                                                yymsp[-1].minor.yy156->append(yymsp[0].minor.yy205);
                                                yygotominor.yy156 = yymsp[-1].minor.yy156;
                                                DONT_INHERIT_TOKENS("refargs");
                                            }
        break;
      case 100: /* refarg ::= MATCH nm */
{
                                                yygotominor.yy205 = new SqliteForeignKey::Condition(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 101: /* refarg ::= ON INSERT refact */
{yygotominor.yy205 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::INSERT, *(yymsp[0].minor.yy106)); delete yymsp[0].minor.yy106;}
        break;
      case 102: /* refarg ::= ON DELETE refact */
{yygotominor.yy205 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::DELETE, *(yymsp[0].minor.yy106)); delete yymsp[0].minor.yy106;}
        break;
      case 103: /* refarg ::= ON UPDATE refact */
      case 104: /* refarg ::= MATCH ID_FK_MATCH */ yytestcase(yyruleno==104);
{yygotominor.yy205 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::UPDATE, *(yymsp[0].minor.yy106)); delete yymsp[0].minor.yy106;}
        break;
      case 105: /* refact ::= SET NULL */
{yygotominor.yy106 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::SET_NULL);}
        break;
      case 106: /* refact ::= SET DEFAULT */
{yygotominor.yy106 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::SET_DEFAULT);}
        break;
      case 107: /* refact ::= CASCADE */
{yygotominor.yy106 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::CASCADE);}
        break;
      case 108: /* refact ::= RESTRICT */
{yygotominor.yy106 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::RESTRICT);}
        break;
      case 109: /* refact ::= NO ACTION */
{yygotominor.yy106 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::NO_ACTION);}
        break;
      case 110: /* defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt */
{
                                                yygotominor.yy53 = new ParserDeferSubClause(SqliteDeferrable::NOT_DEFERRABLE, *(yymsp[0].minor.yy612));
                                                delete yymsp[0].minor.yy612;
                                            }
        break;
      case 111: /* defer_subclause ::= DEFERRABLE init_deferred_pred_opt */
{
                                                yygotominor.yy53 = new ParserDeferSubClause(SqliteDeferrable::DEFERRABLE, *(yymsp[0].minor.yy612));
                                                delete yymsp[0].minor.yy612;
                                            }
        break;
      case 112: /* init_deferred_pred_opt ::= */
{yygotominor.yy612 = new SqliteInitially(SqliteInitially::null);}
        break;
      case 113: /* init_deferred_pred_opt ::= INITIALLY DEFERRED */
{yygotominor.yy612 = new SqliteInitially(SqliteInitially::DEFERRED);}
        break;
      case 114: /* init_deferred_pred_opt ::= INITIALLY IMMEDIATE */
{yygotominor.yy612 = new SqliteInitially(SqliteInitially::IMMEDIATE);}
        break;
      case 115: /* conslist_opt ::= */
{yygotominor.yy115 = new ParserCreateTableConstraintList();}
        break;
      case 116: /* conslist_opt ::= COMMA conslist */
{yygotominor.yy115 = yymsp[0].minor.yy115;}
        break;
      case 117: /* conslist ::= conslist tconscomma tcons */
{
                                                yymsp[0].minor.yy400->afterComma = *(yymsp[-1].minor.yy225);
                                                yymsp[-2].minor.yy115->append(yymsp[0].minor.yy400);
                                                yygotominor.yy115 = yymsp[-2].minor.yy115;
                                                delete yymsp[-1].minor.yy225;
                                                DONT_INHERIT_TOKENS("conslist");
                                            }
        break;
      case 118: /* conslist ::= tcons */
{
                                                yygotominor.yy115 = new ParserCreateTableConstraintList();
                                                yygotominor.yy115->append(yymsp[0].minor.yy400);
                                            }
        break;
      case 121: /* tcons ::= CONSTRAINT nm */
{
                                                yygotominor.yy400 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy400->initNameOnly(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy400;
                                            }
        break;
      case 122: /* tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf */
{
                                                yygotominor.yy400 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy400->initPk(*(yymsp[-3].minor.yy627), *(yymsp[-2].minor.yy225), *(yymsp[0].minor.yy136));
                                                delete yymsp[-2].minor.yy225;
                                                delete yymsp[0].minor.yy136;
                                                delete yymsp[-3].minor.yy627;
                                                objectForTokens = yygotominor.yy400;
                                            }
        break;
      case 123: /* tcons ::= UNIQUE LP idxlist RP onconf */
{
                                                yygotominor.yy400 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy400->initUnique(*(yymsp[-2].minor.yy627), *(yymsp[0].minor.yy136));
                                                delete yymsp[0].minor.yy136;
                                                delete yymsp[-2].minor.yy627;
                                                objectForTokens = yygotominor.yy400;
                                            }
        break;
      case 124: /* tcons ::= CHECK LP expr RP onconf */
{
                                                yygotominor.yy400 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy400->initCheck(yymsp[-2].minor.yy186, *(yymsp[0].minor.yy136));
                                                objectForTokens = yygotominor.yy400;
                                            }
        break;
      case 125: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt */
      case 126: /* tcons ::= CONSTRAINT ID_CONSTR */ yytestcase(yyruleno==126);
      case 127: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES ID_TAB */ yytestcase(yyruleno==127);
{
                                                yygotominor.yy400 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy400->initFk(
                                                    *(yymsp[-6].minor.yy627),
                                                    *(yymsp[-3].minor.yy319),
                                                    *(yymsp[-2].minor.yy627),
                                                    *(yymsp[-1].minor.yy156),
                                                    yymsp[0].minor.yy53->initially,
                                                    yymsp[0].minor.yy53->deferrable
                                                );
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-1].minor.yy156;
                                                delete yymsp[0].minor.yy53;
                                                delete yymsp[-2].minor.yy627;
                                                delete yymsp[-6].minor.yy627;
                                                objectForTokens = yygotominor.yy400;
                                            }
        break;
      case 128: /* tcons ::= CHECK LP RP onconf */
{
                                                yygotominor.yy400 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy400->initCheck();
                                                objectForTokens = yygotominor.yy400;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                              yy_destructor(yypParser,228,&yymsp[0].minor);
}
        break;
      case 129: /* defer_subclause_opt ::= */
{yygotominor.yy53 = new ParserDeferSubClause(SqliteDeferrable::null, SqliteInitially::null);}
        break;
      case 130: /* defer_subclause_opt ::= defer_subclause */
{yygotominor.yy53 = yymsp[0].minor.yy53;}
        break;
      case 131: /* onconf ::= */
      case 133: /* orconf ::= */ yytestcase(yyruleno==133);
{yygotominor.yy136 = new SqliteConflictAlgo(SqliteConflictAlgo::null);}
        break;
      case 132: /* onconf ::= ON CONFLICT resolvetype */
      case 134: /* orconf ::= OR resolvetype */ yytestcase(yyruleno==134);
{yygotominor.yy136 = yymsp[0].minor.yy136;}
        break;
      case 135: /* resolvetype ::= raisetype */
      case 136: /* resolvetype ::= IGNORE */ yytestcase(yyruleno==136);
      case 137: /* resolvetype ::= REPLACE */ yytestcase(yyruleno==137);
{yygotominor.yy136 = new SqliteConflictAlgo(sqliteConflictAlgo(yymsp[0].minor.yy0->value));}
        break;
      case 138: /* cmd ::= DROP TABLE ifexists fullname */
{
                                                yygotominor.yy41 = new SqliteDropTable(*(yymsp[-1].minor.yy225), yymsp[0].minor.yy396->name1, yymsp[0].minor.yy396->name2);
                                                delete yymsp[-1].minor.yy225;
                                                delete yymsp[0].minor.yy396;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 139: /* cmd ::= DROP TABLE ifexists nm DOT ID_TAB */
      case 140: /* cmd ::= DROP TABLE ifexists ID_DB|ID_TAB */ yytestcase(yyruleno==140);
      case 147: /* cmd ::= DROP VIEW ifexists nm DOT ID_VIEW */ yytestcase(yyruleno==147);
      case 148: /* cmd ::= DROP VIEW ifexists ID_DB|ID_VIEW */ yytestcase(yyruleno==148);
      case 191: /* singlesrc ::= nm DOT ID_TAB */ yytestcase(yyruleno==191);
      case 192: /* singlesrc ::= ID_DB|ID_TAB */ yytestcase(yyruleno==192);
      case 193: /* singlesrc ::= nm DOT ID_VIEW */ yytestcase(yyruleno==193);
      case 194: /* singlesrc ::= ID_DB|ID_VIEW */ yytestcase(yyruleno==194);
      case 342: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm DOT ID_IDX_NEW */ yytestcase(yyruleno==342);
      case 343: /* cmd ::= CREATE uniqueflag INDEX ifnotexists ID_DB|ID_IDX_NEW */ yytestcase(yyruleno==343);
      case 356: /* cmd ::= DROP INDEX ifexists nm DOT ID_IDX */ yytestcase(yyruleno==356);
      case 357: /* cmd ::= DROP INDEX ifexists ID_DB|ID_IDX */ yytestcase(yyruleno==357);
      case 367: /* cmd ::= PRAGMA nm DOT ID_PRAGMA */ yytestcase(yyruleno==367);
      case 368: /* cmd ::= PRAGMA ID_DB|ID_PRAGMA */ yytestcase(yyruleno==368);
      case 406: /* cmd ::= DROP TRIGGER ifexists nm DOT ID_TRIG */ yytestcase(yyruleno==406);
      case 407: /* cmd ::= DROP TRIGGER ifexists ID_DB|ID_TRIG */ yytestcase(yyruleno==407);
      case 417: /* cmd ::= REINDEX nm DOT ID_TAB|ID_IDX */ yytestcase(yyruleno==417);
      case 418: /* cmd ::= REINDEX ID_DB|ID_IDX|ID_TAB */ yytestcase(yyruleno==418);
      case 421: /* cmd ::= ANALYZE nm DOT ID_TAB|ID_IDX */ yytestcase(yyruleno==421);
      case 422: /* cmd ::= ANALYZE ID_DB|ID_IDX|ID_TAB */ yytestcase(yyruleno==422);
      case 427: /* cmd ::= ALTER TABLE nm DOT ID_TAB */ yytestcase(yyruleno==427);
      case 428: /* cmd ::= ALTER TABLE ID_DB|ID_TAB */ yytestcase(yyruleno==428);
      case 434: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm DOT ID_TAB_NEW */ yytestcase(yyruleno==434);
      case 435: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists ID_DB|ID_TAB_NEW */ yytestcase(yyruleno==435);
{  yy_destructor(yypParser,203,&yymsp[-2].minor);
}
        break;
      case 143: /* cmd ::= CREATE temp VIEW ifnotexists fullname idxlist_opt AS select */
{
                                                yygotominor.yy41 = new SqliteCreateView(*(yymsp[-6].minor.yy130), *(yymsp[-4].minor.yy225), yymsp[-3].minor.yy396->name1, yymsp[-3].minor.yy396->name2, yymsp[0].minor.yy297, *(yymsp[-2].minor.yy627));
                                                delete yymsp[-6].minor.yy130;
                                                delete yymsp[-4].minor.yy225;
                                                delete yymsp[-3].minor.yy396;
                                                delete yymsp[-2].minor.yy627;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 146: /* cmd ::= DROP VIEW ifexists fullname */
{
                                                yygotominor.yy41 = new SqliteDropView(*(yymsp[-1].minor.yy225), yymsp[0].minor.yy396->name1, yymsp[0].minor.yy396->name2);
                                                delete yymsp[-1].minor.yy225;
                                                delete yymsp[0].minor.yy396;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 149: /* cmd ::= select_stmt */
      case 230: /* cmd ::= delete_stmt */ yytestcase(yyruleno==230);
      case 241: /* cmd ::= update_stmt */ yytestcase(yyruleno==241);
      case 262: /* cmd ::= insert_stmt */ yytestcase(yyruleno==262);
{
                                                yygotominor.yy41 = yymsp[0].minor.yy41;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 150: /* select_stmt ::= select */
{
                                                yygotominor.yy41 = yymsp[0].minor.yy297;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 151: /* select ::= with selectnowith */
{
                                                yygotominor.yy297 = yymsp[0].minor.yy297;
                                                yymsp[0].minor.yy297->setWith(yymsp[-1].minor.yy161);
                                                objectForTokens = yygotominor.yy297;
                                            }
        break;
      case 152: /* selectnowith ::= oneselect */
{
                                                yygotominor.yy297 = SqliteSelect::append(yymsp[0].minor.yy378);
                                                objectForTokens = yygotominor.yy297;
                                            }
        break;
      case 153: /* selectnowith ::= selectnowith multiselect_op oneselect */
{
                                                yygotominor.yy297 = SqliteSelect::append(yymsp[-2].minor.yy297, *(yymsp[-1].minor.yy142), yymsp[0].minor.yy378);
                                                delete yymsp[-1].minor.yy142;
                                                objectForTokens = yygotominor.yy297;
                                            }
        break;
      case 154: /* selectnowith ::= values */
{
                                                yygotominor.yy297 = SqliteSelect::append(*(yymsp[0].minor.yy522));
                                                delete yymsp[0].minor.yy522;
                                                objectForTokens = yygotominor.yy297;
                                            }
        break;
      case 155: /* selectnowith ::= selectnowith COMMA values */
{
                                                yygotominor.yy297 = SqliteSelect::append(yymsp[-2].minor.yy297, SqliteSelect::CompoundOperator::UNION_ALL, *(yymsp[0].minor.yy522));
                                                delete yymsp[0].minor.yy522;
                                                objectForTokens = yygotominor.yy297;
                                            }
        break;
      case 156: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
{
                                                yygotominor.yy378 = new SqliteSelect::Core(
                                                        *(yymsp[-7].minor.yy130),
                                                        *(yymsp[-6].minor.yy27),
                                                        yymsp[-5].minor.yy553,
                                                        yymsp[-4].minor.yy186,
                                                        *(yymsp[-3].minor.yy615),
                                                        yymsp[-2].minor.yy186,
                                                        *(yymsp[-1].minor.yy226),
                                                        yymsp[0].minor.yy360
                                                    );
                                                delete yymsp[-6].minor.yy27;
                                                delete yymsp[-7].minor.yy130;
                                                delete yymsp[-3].minor.yy615;
                                                delete yymsp[-1].minor.yy226;
                                                objectForTokens = yygotominor.yy378;
                                            }
        break;
      case 157: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt window_clause orderby_opt limit_opt */
{
                                                yygotominor.yy378 = new SqliteSelect::Core(
                                                        *(yymsp[-8].minor.yy130),
                                                        *(yymsp[-7].minor.yy27),
                                                        yymsp[-6].minor.yy553,
                                                        yymsp[-5].minor.yy186,
                                                        *(yymsp[-4].minor.yy615),
                                                        yymsp[-3].minor.yy186,
														*(yymsp[-2].minor.yy525),
                                                        *(yymsp[-1].minor.yy226),
                                                        yymsp[0].minor.yy360
                                                    );
                                                delete yymsp[-7].minor.yy27;
                                                delete yymsp[-8].minor.yy130;
                                                delete yymsp[-4].minor.yy615;
                                                delete yymsp[-1].minor.yy226;
												delete yymsp[-2].minor.yy525;
                                                objectForTokens = yygotominor.yy378;
											}
        break;
      case 158: /* values ::= VALUES LP nexprlist RP */
{
                                                yygotominor.yy522 = new ParserExprNestedList();
                                                yygotominor.yy522->append(*(yymsp[-1].minor.yy615));
                                                delete yymsp[-1].minor.yy615;
                                            }
        break;
      case 159: /* values ::= values COMMA LP exprlist RP */
{
                                                yymsp[-4].minor.yy522->append(*(yymsp[-1].minor.yy615));
                                                yygotominor.yy522 = yymsp[-4].minor.yy522;
                                                delete yymsp[-1].minor.yy615;
                                                DONT_INHERIT_TOKENS("values");
                                            }
        break;
      case 160: /* multiselect_op ::= UNION */
{yygotominor.yy142 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::UNION);}
        break;
      case 161: /* multiselect_op ::= UNION ALL */
{yygotominor.yy142 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::UNION_ALL);}
        break;
      case 162: /* multiselect_op ::= EXCEPT */
{yygotominor.yy142 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::EXCEPT);}
        break;
      case 163: /* multiselect_op ::= INTERSECT */
{yygotominor.yy142 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::INTERSECT);}
        break;
      case 164: /* distinct ::= DISTINCT */
{yygotominor.yy130 = new int(1);}
        break;
      case 165: /* distinct ::= ALL */
{yygotominor.yy130 = new int(2);}
        break;
      case 167: /* sclp ::= selcollist COMMA */
{yygotominor.yy27 = yymsp[-1].minor.yy27;}
        break;
      case 168: /* sclp ::= */
      case 239: /* returning ::= */ yytestcase(yyruleno==239);
{yygotominor.yy27 = new ParserResultColumnList();}
        break;
      case 169: /* selcollist ::= sclp expr as */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(
                                                        yymsp[-1].minor.yy186,
                                                        yymsp[0].minor.yy628 ? yymsp[0].minor.yy628->asKw : false,
                                                        yymsp[0].minor.yy628 ? yymsp[0].minor.yy628->name : QString()
                                                    );

                                                yymsp[-2].minor.yy27->append(obj);
                                                yygotominor.yy27 = yymsp[-2].minor.yy27;
                                                delete yymsp[0].minor.yy628;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 170: /* selcollist ::= sclp STAR */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(true);

                                                yymsp[-1].minor.yy27->append(obj);
                                                yygotominor.yy27 = yymsp[-1].minor.yy27;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 171: /* selcollist ::= sclp tnm DOT STAR */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(
                                                        true,
                                                        yymsp[-2].minor.yy380->toName()
                                                    );
													
												if (!yymsp[-2].minor.yy380->isName())
													parserContext->errorAtToken("Syntax error <expected name, not literal value>", -3);
													
                                                yymsp[-3].minor.yy27->append(obj);
                                                yygotominor.yy27 = yymsp[-3].minor.yy27;
                                                delete yymsp[-2].minor.yy380;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 172: /* selcollist ::= sclp */
      case 173: /* selcollist ::= sclp ID_TAB DOT STAR */ yytestcase(yyruleno==173);
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy27 = yymsp[0].minor.yy27;
                                            }
        break;
      case 174: /* as ::= AS nm */
{
                                                yygotominor.yy628 = new ParserStubAlias(*(yymsp[0].minor.yy319), true);
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 175: /* as ::= ids */
      case 176: /* as ::= AS ID_ALIAS */ yytestcase(yyruleno==176);
      case 177: /* as ::= ID_ALIAS */ yytestcase(yyruleno==177);
{
                                                yygotominor.yy628 = new ParserStubAlias(*(yymsp[0].minor.yy319), false);
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 178: /* as ::= */
{yygotominor.yy628 = nullptr;}
        break;
      case 179: /* from ::= */
{yygotominor.yy553 = nullptr;}
        break;
      case 180: /* from ::= FROM joinsrc */
{yygotominor.yy553 = yymsp[0].minor.yy553;}
        break;
      case 181: /* joinsrc ::= singlesrc seltablist */
{
                                                yygotominor.yy553 = new SqliteSelect::Core::JoinSource(
                                                        yymsp[-1].minor.yy595,
                                                        *(yymsp[0].minor.yy107)
                                                    );
                                                delete yymsp[0].minor.yy107;
                                                objectForTokens = yygotominor.yy553;
                                            }
        break;
      case 182: /* joinsrc ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy553 = new SqliteSelect::Core::JoinSource();
                                                objectForTokens = yygotominor.yy553;
                                            }
        break;
      case 183: /* seltablist ::= seltablist joinop singlesrc joinconstr_opt */
{
                                                SqliteSelect::Core::JoinSourceOther* src =
                                                    new SqliteSelect::Core::JoinSourceOther(yymsp[-2].minor.yy449, yymsp[-1].minor.yy595, yymsp[0].minor.yy215);

                                                yymsp[-3].minor.yy107->append(src);
                                                yygotominor.yy107 = yymsp[-3].minor.yy107;
                                                objectForTokens = src;
                                                DONT_INHERIT_TOKENS("seltablist");
                                            }
        break;
      case 184: /* seltablist ::= */
{
                                                yygotominor.yy107 = new ParserOtherSourceList();
                                            }
        break;
      case 185: /* singlesrc ::= nm dbnm as indexed_opt */
{
                                                yygotominor.yy595 = new SqliteSelect::Core::SingleSource(
                                                        *(yymsp[-3].minor.yy319),
                                                        *(yymsp[-2].minor.yy319),
                                                        yymsp[-1].minor.yy628 ? yymsp[-1].minor.yy628->asKw : false,
                                                        yymsp[-1].minor.yy628 ? yymsp[-1].minor.yy628->name : QString(),
                                                        yymsp[0].minor.yy300 ? yymsp[0].minor.yy300->notIndexedKw : false,
                                                        yymsp[0].minor.yy300 ? yymsp[0].minor.yy300->indexedBy : QString()
                                                    );
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[-1].minor.yy628;
                                                if (yymsp[0].minor.yy300)
                                                    delete yymsp[0].minor.yy300;
                                                objectForTokens = yygotominor.yy595;
                                            }
        break;
      case 186: /* singlesrc ::= LP select RP as */
{
                                                yygotominor.yy595 = new SqliteSelect::Core::SingleSource(
                                                        yymsp[-2].minor.yy297,
                                                        yymsp[0].minor.yy628 ? yymsp[0].minor.yy628->asKw : false,
                                                        yymsp[0].minor.yy628 ? yymsp[0].minor.yy628->name : QString()
                                                    );
                                                delete yymsp[0].minor.yy628;
                                                objectForTokens = yygotominor.yy595;
                                            }
        break;
      case 187: /* singlesrc ::= LP joinsrc RP as */
{
                                                yygotominor.yy595 = new SqliteSelect::Core::SingleSource(
                                                        yymsp[-2].minor.yy553,
                                                        yymsp[0].minor.yy628 ? yymsp[0].minor.yy628->asKw : false,
                                                        yymsp[0].minor.yy628 ? yymsp[0].minor.yy628->name : QString()
                                                    );
                                                delete yymsp[0].minor.yy628;
                                                objectForTokens = yygotominor.yy595;
                                            }
        break;
      case 188: /* singlesrc ::= nm dbnm LP exprlist RP as */
{
                                                yygotominor.yy595 = new SqliteSelect::Core::SingleSource(
                                                        *(yymsp[-5].minor.yy319),
                                                        *(yymsp[-4].minor.yy319),
                                                        yymsp[0].minor.yy628 ? yymsp[0].minor.yy628->asKw : false,
                                                        yymsp[0].minor.yy628 ? yymsp[0].minor.yy628->name : QString(),
                                                        *(yymsp[-2].minor.yy615)
                                                    );
                                                delete yymsp[-5].minor.yy319;
                                                delete yymsp[-4].minor.yy319;
                                                delete yymsp[0].minor.yy628;
                                                if (yymsp[-2].minor.yy615)
                                                    delete yymsp[-2].minor.yy615;

                                                objectForTokens = yygotominor.yy595;
                                            }
        break;
      case 189: /* singlesrc ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy595 = new SqliteSelect::Core::SingleSource();
                                                objectForTokens = yygotominor.yy595;
                                            }
        break;
      case 190: /* singlesrc ::= nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy595 = new SqliteSelect::Core::SingleSource();
                                                yygotominor.yy595->database = *(yymsp[-1].minor.yy319);
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy595;
                                            }
        break;
      case 195: /* joinconstr_opt ::= ON expr */
{
                                                yygotominor.yy215 = new SqliteSelect::Core::JoinConstraint(yymsp[0].minor.yy186);
                                                objectForTokens = yygotominor.yy215;
                                            }
        break;
      case 196: /* joinconstr_opt ::= USING LP idlist RP */
{
                                                yygotominor.yy215 = new SqliteSelect::Core::JoinConstraint(*(yymsp[-1].minor.yy173));
                                                delete yymsp[-1].minor.yy173;
                                                objectForTokens = yygotominor.yy215;
                                            }
        break;
      case 197: /* joinconstr_opt ::= */
{yygotominor.yy215 = nullptr;}
        break;
      case 198: /* dbnm ::= */
      case 352: /* collate ::= */ yytestcase(yyruleno==352);
      case 438: /* vtabarg ::= */ yytestcase(yyruleno==438);
      case 442: /* anylist ::= */ yytestcase(yyruleno==442);
{yygotominor.yy319 = new QString();}
        break;
      case 200: /* fullname ::= nm dbnm */
{
                                                yygotominor.yy396 = new ParserFullName();
                                                yygotominor.yy396->name1 = *(yymsp[-1].minor.yy319);
                                                yygotominor.yy396->name2 = *(yymsp[0].minor.yy319);
                                                delete yymsp[-1].minor.yy319;
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 201: /* joinop ::= COMMA */
{
                                                yygotominor.yy449 = new SqliteSelect::Core::JoinOp(true);
                                                objectForTokens = yygotominor.yy449;
                                            }
        break;
      case 202: /* joinop ::= JOIN */
{
                                                yygotominor.yy449 = new SqliteSelect::Core::JoinOp(false);
                                                objectForTokens = yygotominor.yy449;
                                            }
        break;
      case 203: /* joinop ::= JOIN_KW JOIN */
{
                                                yygotominor.yy449 = new SqliteSelect::Core::JoinOp(yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy449;
                                            }
        break;
      case 204: /* joinop ::= JOIN_KW nm JOIN */
{
                                                yygotominor.yy449 = new SqliteSelect::Core::JoinOp(yymsp[-2].minor.yy0->value, *(yymsp[-1].minor.yy319));
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy449;
                                            }
        break;
      case 205: /* joinop ::= JOIN_KW nm nm JOIN */
      case 206: /* joinop ::= ID_JOIN_OPTS */ yytestcase(yyruleno==206);
{
                                                yygotominor.yy449 = new SqliteSelect::Core::JoinOp(yymsp[-3].minor.yy0->value, *(yymsp[-2].minor.yy319), *(yymsp[-1].minor.yy319));
                                                delete yymsp[-2].minor.yy319;
                                                objectForTokens = yygotominor.yy449;
                                            }
        break;
      case 207: /* indexed_opt ::= */
{yygotominor.yy300 = nullptr;}
        break;
      case 208: /* indexed_opt ::= INDEXED BY nm */
{
                                                yygotominor.yy300 = new ParserIndexedBy(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 209: /* indexed_opt ::= NOT INDEXED */
      case 210: /* indexed_opt ::= INDEXED BY ID_IDX */ yytestcase(yyruleno==210);
{yygotominor.yy300 = new ParserIndexedBy(true);}
        break;
      case 211: /* orderby_opt ::= */
{yygotominor.yy226 = new ParserOrderByList();}
        break;
      case 212: /* orderby_opt ::= ORDER BY sortlist */
{yygotominor.yy226 = yymsp[0].minor.yy226;}
        break;
      case 213: /* sortlist ::= sortlist COMMA expr sortorder nulls */
{
                                                SqliteOrderBy* obj = new SqliteOrderBy(yymsp[-2].minor.yy186, *(yymsp[-1].minor.yy35), *(yymsp[0].minor.yy315));
                                                yymsp[-4].minor.yy226->append(obj);
                                                yygotominor.yy226 = yymsp[-4].minor.yy226;
                                                delete yymsp[-1].minor.yy35;
												delete yymsp[0].minor.yy315;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sortlist");
                                            }
        break;
      case 214: /* sortlist ::= expr sortorder nulls */
{
                                                SqliteOrderBy* obj = new SqliteOrderBy(yymsp[-2].minor.yy186, *(yymsp[-1].minor.yy35), *(yymsp[0].minor.yy315));
                                                yygotominor.yy226 = new ParserOrderByList();
                                                yygotominor.yy226->append(obj);
                                                delete yymsp[-1].minor.yy35;
												delete yymsp[0].minor.yy315;
                                                objectForTokens = obj;
                                            }
        break;
      case 215: /* sortorder ::= ASC */
{yygotominor.yy35 = new SqliteSortOrder(SqliteSortOrder::ASC);}
        break;
      case 216: /* sortorder ::= DESC */
{yygotominor.yy35 = new SqliteSortOrder(SqliteSortOrder::DESC);}
        break;
      case 217: /* sortorder ::= */
{yygotominor.yy35 = new SqliteSortOrder(SqliteSortOrder::null);}
        break;
      case 218: /* nulls ::= NULLS FIRST */
{yygotominor.yy315 = new SqliteNulls(SqliteNulls::FIRST);}
        break;
      case 219: /* nulls ::= NULLS LAST */
{yygotominor.yy315 = new SqliteNulls(SqliteNulls::LAST);}
        break;
      case 220: /* nulls ::= */
{yygotominor.yy315 = new SqliteNulls(SqliteNulls::null);}
        break;
      case 221: /* groupby_opt ::= */
      case 337: /* exprlist ::= */ yytestcase(yyruleno==337);
{yygotominor.yy615 = new ParserExprList();}
        break;
      case 222: /* groupby_opt ::= GROUP BY nexprlist */
      case 336: /* exprlist ::= nexprlist */ yytestcase(yyruleno==336);
{yygotominor.yy615 = yymsp[0].minor.yy615;}
        break;
      case 223: /* groupby_opt ::= GROUP BY */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy615 = new ParserExprList();
                                            }
        break;
      case 224: /* having_opt ::= */
      case 236: /* where_opt ::= */ yytestcase(yyruleno==236);
      case 333: /* case_else ::= */ yytestcase(yyruleno==333);
      case 335: /* case_operand ::= */ yytestcase(yyruleno==335);
      case 361: /* vinto ::= */ yytestcase(yyruleno==361);
      case 395: /* when_clause ::= */ yytestcase(yyruleno==395);
      case 410: /* key_opt ::= */ yytestcase(yyruleno==410);
{yygotominor.yy186 = nullptr;}
        break;
      case 225: /* having_opt ::= HAVING expr */
      case 237: /* where_opt ::= WHERE expr */ yytestcase(yyruleno==237);
      case 326: /* expr ::= exprx */ yytestcase(yyruleno==326);
      case 332: /* case_else ::= ELSE expr */ yytestcase(yyruleno==332);
      case 334: /* case_operand ::= exprx */ yytestcase(yyruleno==334);
      case 360: /* vinto ::= INTO expr */ yytestcase(yyruleno==360);
      case 396: /* when_clause ::= WHEN expr */ yytestcase(yyruleno==396);
      case 411: /* key_opt ::= KEY expr */ yytestcase(yyruleno==411);
{yygotominor.yy186 = yymsp[0].minor.yy186;}
        break;
      case 226: /* limit_opt ::= */
{yygotominor.yy360 = nullptr;}
        break;
      case 227: /* limit_opt ::= LIMIT expr */
{
                                                yygotominor.yy360 = new SqliteLimit(yymsp[0].minor.yy186);
                                                objectForTokens = yygotominor.yy360;
                                            }
        break;
      case 228: /* limit_opt ::= LIMIT expr OFFSET expr */
{
                                                yygotominor.yy360 = new SqliteLimit(yymsp[-2].minor.yy186, yymsp[0].minor.yy186, true);
                                                objectForTokens = yygotominor.yy360;
                                            }
        break;
      case 229: /* limit_opt ::= LIMIT expr COMMA expr */
{
                                                yygotominor.yy360 = new SqliteLimit(yymsp[-2].minor.yy186, yymsp[0].minor.yy186, false);
                                                objectForTokens = yygotominor.yy360;
                                            }
        break;
      case 231: /* delete_stmt ::= with DELETE FROM fullname indexed_opt where_opt returning */
{
                                                if (yymsp[-2].minor.yy300)
                                                {
                                                    if (!yymsp[-2].minor.yy300->indexedBy.isNull())
                                                    {
                                                        yygotominor.yy41 = new SqliteDelete(
                                                                yymsp[-3].minor.yy396->name1,
                                                                yymsp[-3].minor.yy396->name2,
                                                                yymsp[-2].minor.yy300->indexedBy,
                                                                yymsp[-1].minor.yy186,
                                                                yymsp[-6].minor.yy161,
                                                                *(yymsp[0].minor.yy27)
                                                            );
                                                    }
                                                    else
                                                    {
                                                        yygotominor.yy41 = new SqliteDelete(
                                                                yymsp[-3].minor.yy396->name1,
                                                                yymsp[-3].minor.yy396->name2,
                                                                yymsp[-2].minor.yy300->notIndexedKw,
                                                                yymsp[-1].minor.yy186,
                                                                yymsp[-6].minor.yy161,
                                                                *(yymsp[0].minor.yy27)
                                                            );
                                                    }
                                                    delete yymsp[-2].minor.yy300;
                                                }
                                                else
                                                {
                                                    yygotominor.yy41 = new SqliteDelete(
                                                            yymsp[-3].minor.yy396->name1,
                                                            yymsp[-3].minor.yy396->name2,
                                                            false,
                                                            yymsp[-1].minor.yy186,
                                                            yymsp[-6].minor.yy161,
                                                            *(yymsp[0].minor.yy27)
                                                        );
                                                }
                                                delete yymsp[-3].minor.yy396;
                                                delete yymsp[0].minor.yy27;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 232: /* delete_stmt ::= with DELETE FROM */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteDelete* q = new SqliteDelete();
                                                q->with = yymsp[-2].minor.yy161;
                                                yygotominor.yy41 = q;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 233: /* delete_stmt ::= with DELETE FROM nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteDelete* q = new SqliteDelete();
                                                q->with = yymsp[-4].minor.yy161;
                                                q->database = *(yymsp[-1].minor.yy319);
                                                yygotominor.yy41 = q;
                                                objectForTokens = yygotominor.yy41;
                                                delete yymsp[-1].minor.yy319;
                                            }
        break;
      case 234: /* delete_stmt ::= with DELETE FROM nm DOT ID_TAB */
      case 245: /* update_stmt ::= with UPDATE orconf nm DOT ID_TAB */ yytestcase(yyruleno==245);
{  yy_destructor(yypParser,249,&yymsp[-5].minor);
  yy_destructor(yypParser,203,&yymsp[-2].minor);
}
        break;
      case 235: /* delete_stmt ::= with DELETE FROM ID_DB|ID_TAB */
      case 246: /* update_stmt ::= with UPDATE orconf ID_DB|ID_TAB */ yytestcase(yyruleno==246);
{  yy_destructor(yypParser,249,&yymsp[-3].minor);
}
        break;
      case 238: /* where_opt ::= WHERE */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy186 = new SqliteExpr();
                                            }
        break;
      case 240: /* returning ::= RETURNING selcollist */
{yygotominor.yy27 = yymsp[0].minor.yy27;}
        break;
      case 242: /* update_stmt ::= with UPDATE orconf fullname indexed_opt SET setlist from where_opt returning */
{
                                                yygotominor.yy41 = new SqliteUpdate(
                                                        *(yymsp[-7].minor.yy136),
                                                        yymsp[-6].minor.yy396->name1,
                                                        yymsp[-6].minor.yy396->name2,
                                                        yymsp[-5].minor.yy300 ? yymsp[-5].minor.yy300->notIndexedKw : false,
                                                        yymsp[-5].minor.yy300 ? yymsp[-5].minor.yy300->indexedBy : QString(),
                                                        *(yymsp[-3].minor.yy621),
														yymsp[-2].minor.yy553,
                                                        yymsp[-1].minor.yy186,
                                                        yymsp[-9].minor.yy161,
                                                        *(yymsp[0].minor.yy27)
                                                    );
                                                delete yymsp[-7].minor.yy136;
                                                delete yymsp[-6].minor.yy396;
                                                delete yymsp[-3].minor.yy621;
                                                delete yymsp[0].minor.yy27;
                                                if (yymsp[-5].minor.yy300)
                                                    delete yymsp[-5].minor.yy300;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 243: /* update_stmt ::= with UPDATE orconf */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteUpdate* q = new SqliteUpdate();
                                                q->with = yymsp[-2].minor.yy161;
                                                yygotominor.yy41 = q;
                                                objectForTokens = yygotominor.yy41;
                                                delete yymsp[0].minor.yy136;
                                            }
        break;
      case 244: /* update_stmt ::= with UPDATE orconf nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteUpdate* q = new SqliteUpdate();
                                                q->with = yymsp[-4].minor.yy161;
                                                q->database = *(yymsp[-1].minor.yy319);
                                                yygotominor.yy41 = q;
                                                objectForTokens = yygotominor.yy41;
                                                delete yymsp[-2].minor.yy136;
                                                delete yymsp[-1].minor.yy319;
                                            }
        break;
      case 247: /* setlist ::= setlist COMMA nm EQ expr */
{
                                                yymsp[-4].minor.yy621->append(ParserSetValue(*(yymsp[-2].minor.yy319), yymsp[0].minor.yy186));
                                                yygotominor.yy621 = yymsp[-4].minor.yy621;
                                                delete yymsp[-2].minor.yy319;
                                            }
        break;
      case 248: /* setlist ::= setlist COMMA LP idlist RP EQ expr */
{
                                                yymsp[-6].minor.yy621->append(ParserSetValue(*(yymsp[-3].minor.yy173), yymsp[0].minor.yy186));
                                                yygotominor.yy621 = yymsp[-6].minor.yy621;
                                                delete yymsp[-3].minor.yy173;
                                            }
        break;
      case 249: /* setlist ::= nm EQ expr */
{
                                                yygotominor.yy621 = new ParserSetValueList();
                                                yygotominor.yy621->append(ParserSetValue(*(yymsp[-2].minor.yy319), yymsp[0].minor.yy186));
                                                delete yymsp[-2].minor.yy319;
                                            }
        break;
      case 250: /* setlist ::= LP idlist RP EQ expr */
{
                                                yygotominor.yy621 = new ParserSetValueList();
                                                yygotominor.yy621->append(ParserSetValue(*(yymsp[-3].minor.yy173), yymsp[0].minor.yy186));
                                                delete yymsp[-3].minor.yy173;
                                            }
        break;
      case 251: /* setlist ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy621 = new ParserSetValueList();
                                            }
        break;
      case 252: /* setlist ::= setlist COMMA */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy621 = yymsp[-1].minor.yy621;
                                            }
        break;
      case 253: /* setlist ::= setlist COMMA ID_COL */
      case 254: /* setlist ::= ID_COL */ yytestcase(yyruleno==254);
{  yy_destructor(yypParser,280,&yymsp[-2].minor);
}
        break;
      case 255: /* idlist_opt ::= */
{yygotominor.yy173 = new QStringList();}
        break;
      case 256: /* idlist_opt ::= LP idlist RP */
{yygotominor.yy173 = yymsp[-1].minor.yy173;}
        break;
      case 257: /* idlist ::= idlist COMMA nm */
{
                                                yygotominor.yy173 = yymsp[-2].minor.yy173;
                                                *(yygotominor.yy173) << *(yymsp[0].minor.yy319);
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 258: /* idlist ::= nm */
{
                                                yygotominor.yy173 = new QStringList();
                                                *(yygotominor.yy173) << *(yymsp[0].minor.yy319);
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 259: /* idlist ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy173 = new QStringList();
                                            }
        break;
      case 260: /* idlist ::= idlist COMMA ID_COL */
      case 261: /* idlist ::= ID_COL */ yytestcase(yyruleno==261);
{  yy_destructor(yypParser,274,&yymsp[-2].minor);
}
        break;
      case 263: /* insert_stmt ::= with insert_cmd INTO fullname idlist_opt select upsert returning */
{
                                                yygotominor.yy41 = new SqliteInsert(
                                                        yymsp[-6].minor.yy308->replace,
                                                        yymsp[-6].minor.yy308->orConflict,
                                                        yymsp[-4].minor.yy396->name1,
                                                        yymsp[-4].minor.yy396->name2,
                                                        *(yymsp[-3].minor.yy173),
                                                        yymsp[-2].minor.yy297,
                                                        yymsp[-7].minor.yy161,
                                                        yymsp[-1].minor.yy332,
                                                        *(yymsp[0].minor.yy27)
                                                    );
                                                delete yymsp[-4].minor.yy396;
                                                delete yymsp[-6].minor.yy308;
                                                delete yymsp[-3].minor.yy173;
                                                delete yymsp[0].minor.yy27;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 264: /* insert_stmt ::= with insert_cmd INTO fullname idlist_opt DEFAULT VALUES returning */
{
                                                yygotominor.yy41 = new SqliteInsert(
                                                        yymsp[-6].minor.yy308->replace,
                                                        yymsp[-6].minor.yy308->orConflict,
                                                        yymsp[-4].minor.yy396->name1,
                                                        yymsp[-4].minor.yy396->name2,
                                                        *(yymsp[-3].minor.yy173),
                                                        yymsp[-7].minor.yy161,
                                                        *(yymsp[0].minor.yy27)
                                                    );
                                                delete yymsp[-4].minor.yy396;
                                                delete yymsp[-6].minor.yy308;
                                                delete yymsp[-3].minor.yy173;
                                                delete yymsp[0].minor.yy27;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 265: /* insert_stmt ::= with insert_cmd INTO */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteInsert* q = new SqliteInsert();
                                                q->replaceKw = yymsp[-1].minor.yy308->replace;
                                                q->onConflict = yymsp[-1].minor.yy308->orConflict;
                                                q->with = yymsp[-2].minor.yy161;
                                                yygotominor.yy41 = q;
                                                objectForTokens = yygotominor.yy41;
                                                delete yymsp[-1].minor.yy308;
                                            }
        break;
      case 266: /* insert_stmt ::= with insert_cmd INTO nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteInsert* q = new SqliteInsert();
                                                q->replaceKw = yymsp[-3].minor.yy308->replace;
                                                q->onConflict = yymsp[-3].minor.yy308->orConflict;
                                                q->with = yymsp[-4].minor.yy161;
                                                q->database = *(yymsp[-1].minor.yy319);
                                                yygotominor.yy41 = q;
                                                objectForTokens = yygotominor.yy41;
                                                delete yymsp[-3].minor.yy308;
                                                delete yymsp[-1].minor.yy319;
                                            }
        break;
      case 267: /* insert_stmt ::= with insert_cmd INTO ID_DB|ID_TAB */
{  yy_destructor(yypParser,249,&yymsp[-3].minor);
  yy_destructor(yypParser,283,&yymsp[-2].minor);
}
        break;
      case 268: /* insert_stmt ::= with insert_cmd INTO nm DOT ID_TAB */
{  yy_destructor(yypParser,249,&yymsp[-5].minor);
  yy_destructor(yypParser,283,&yymsp[-4].minor);
  yy_destructor(yypParser,203,&yymsp[-2].minor);
}
        break;
      case 269: /* insert_cmd ::= INSERT orconf */
{
                                                yygotominor.yy308 = new ParserStubInsertOrReplace(false, *(yymsp[0].minor.yy136));
                                                delete yymsp[0].minor.yy136;
                                            }
        break;
      case 270: /* insert_cmd ::= REPLACE */
{yygotominor.yy308 = new ParserStubInsertOrReplace(true);}
        break;
      case 271: /* upsert ::= */
{
                                                yygotominor.yy332 = nullptr;
                                            }
        break;
      case 272: /* upsert ::= ON CONFLICT LP sortlist RP where_opt DO UPDATE SET setlist where_opt */
{
                                                yygotominor.yy332 = new SqliteUpsert(*(yymsp[-7].minor.yy226), yymsp[-5].minor.yy186, *(yymsp[-1].minor.yy621), yymsp[0].minor.yy186);
                                                delete yymsp[-7].minor.yy226;
                                                delete yymsp[-1].minor.yy621;
                                                objectForTokens = yygotominor.yy332;
                                            }
        break;
      case 273: /* upsert ::= ON CONFLICT LP sortlist RP where_opt DO NOTHING */
{
                                                yygotominor.yy332 = new SqliteUpsert(*(yymsp[-4].minor.yy226), yymsp[-2].minor.yy186);
                                                delete yymsp[-4].minor.yy226;
                                                objectForTokens = yygotominor.yy332;
                                            }
        break;
      case 274: /* upsert ::= ON CONFLICT DO NOTHING */
{
                                                yygotominor.yy332 = new SqliteUpsert();
                                                objectForTokens = yygotominor.yy332;
                                            }
        break;
      case 275: /* exprx ::= expr not_opt IN ID_DB */
{  yy_destructor(yypParser,227,&yymsp[-3].minor);
}
        break;
      case 276: /* exprx ::= expr not_opt IN nm DOT ID_TAB */
      case 277: /* exprx ::= ID_DB|ID_TAB|ID_COL|ID_FN */ yytestcase(yyruleno==277);
{  yy_destructor(yypParser,227,&yymsp[-5].minor);
  yy_destructor(yypParser,203,&yymsp[-2].minor);
}
        break;
      case 278: /* exprx ::= tnm DOT ID_TAB|ID_COL */
{  yy_destructor(yypParser,235,&yymsp[-2].minor);
}
        break;
      case 279: /* exprx ::= tnm DOT nm DOT ID_COL */
{  yy_destructor(yypParser,235,&yymsp[-4].minor);
  yy_destructor(yypParser,203,&yymsp[-2].minor);
}
        break;
      case 280: /* exprx ::= expr COLLATE ID_COLLATE */
      case 281: /* exprx ::= RAISE LP raisetype COMMA ID_ERR_MSG RP */ yytestcase(yyruleno==281);
{  yy_destructor(yypParser,227,&yymsp[-2].minor);
}
        break;
      case 282: /* exprx ::= CTIME_KW */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initCTime(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 283: /* exprx ::= LP nexprlist RP */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initRowValue(*(yymsp[-1].minor.yy615));
                                                delete yymsp[-1].minor.yy615;
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 284: /* exprx ::= tnm */
{
                                                yygotominor.yy186 = new SqliteExpr();
												if (yymsp[0].minor.yy380->isLiteral())
													yygotominor.yy186->initLiteral(yymsp[0].minor.yy380->toLiteral());
												else
													yygotominor.yy186->initId(yymsp[0].minor.yy380->toName());
													//parserContext->errorBeforeLastToken("Syntax error <expected literal value>");

                                                delete yymsp[0].minor.yy380;
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 285: /* exprx ::= tnm DOT nm */
{
                                                yygotominor.yy186 = new SqliteExpr();
												if (yymsp[-2].minor.yy380->isName())
													yygotominor.yy186->initId(yymsp[-2].minor.yy380->toName(), *(yymsp[0].minor.yy319));
												else
													parserContext->errorAtToken("Syntax error <expected name>", -3);

                                                delete yymsp[-2].minor.yy380;
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 286: /* exprx ::= tnm DOT */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy186;
                                                if (yymsp[-1].minor.yy380->isName())
                                                {
                                                    yygotominor.yy186->initId(yymsp[-1].minor.yy380->toName(), QString());
                                                    parserContext->minorErrorAfterLastToken("Syntax error <expr>");
                                                }
                                                else
                                                    parserContext->errorAtToken("Syntax error <expected name>", -3);

                                                delete yymsp[-1].minor.yy380;
                                            }
        break;
      case 287: /* exprx ::= tnm DOT nm DOT nm */
{
                                                yygotominor.yy186 = new SqliteExpr();
												if (yymsp[-4].minor.yy380->isName())
													yygotominor.yy186->initId(yymsp[-4].minor.yy380->toName(), *(yymsp[-2].minor.yy319), *(yymsp[0].minor.yy319));
												else
													parserContext->errorAtToken("Syntax error <expected name>", -5);

                                                delete yymsp[-4].minor.yy380;
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 288: /* exprx ::= tnm DOT nm DOT */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy186;
                                                if (yymsp[-3].minor.yy380->isName())
                                                {
                                                    yygotominor.yy186->initId(yymsp[-3].minor.yy380->toName(), *(yymsp[-1].minor.yy319), QString());
                                                    parserContext->minorErrorAfterLastToken("Syntax error <expr>");
                                                }
                                                else
                                                    parserContext->errorAtToken("Syntax error <expected name>", -5);

                                                delete yymsp[-3].minor.yy380;
                                                delete yymsp[-1].minor.yy319;
                                            }
        break;
      case 289: /* exprx ::= VARIABLE */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initBindParam(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 290: /* exprx ::= expr COLLATE ids */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initCollate(yymsp[-2].minor.yy186, *(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 291: /* exprx ::= CAST LP expr AS typetoken RP */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initCast(yymsp[-3].minor.yy186, yymsp[-1].minor.yy267);
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 292: /* exprx ::= ID LP distinct exprlist RP */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initFunction(stripObjName(yymsp[-4].minor.yy0->value), *(yymsp[-2].minor.yy130), *(yymsp[-1].minor.yy615));
                                                delete yymsp[-2].minor.yy130;
                                                delete yymsp[-1].minor.yy615;
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 293: /* exprx ::= ID LP STAR RP */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initFunction(stripObjName(yymsp[-3].minor.yy0->value), true);
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 294: /* exprx ::= expr AND expr */
      case 295: /* exprx ::= expr OR expr */ yytestcase(yyruleno==295);
      case 296: /* exprx ::= expr LT|GT|GE|LE expr */ yytestcase(yyruleno==296);
      case 297: /* exprx ::= expr EQ|NE expr */ yytestcase(yyruleno==297);
      case 298: /* exprx ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */ yytestcase(yyruleno==298);
      case 299: /* exprx ::= expr PLUS|MINUS expr */ yytestcase(yyruleno==299);
      case 300: /* exprx ::= expr STAR|SLASH|REM expr */ yytestcase(yyruleno==300);
      case 301: /* exprx ::= expr CONCAT expr */ yytestcase(yyruleno==301);
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initBinOp(yymsp[-2].minor.yy186, yymsp[-1].minor.yy0->value, yymsp[0].minor.yy186);
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 302: /* exprx ::= expr not_opt likeop expr */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initLike(yymsp[-3].minor.yy186, *(yymsp[-2].minor.yy225), *(yymsp[-1].minor.yy274), yymsp[0].minor.yy186);
                                                delete yymsp[-2].minor.yy225;
                                                delete yymsp[-1].minor.yy274;
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 303: /* exprx ::= expr not_opt likeop expr ESCAPE expr */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initLike(yymsp[-5].minor.yy186, *(yymsp[-4].minor.yy225), *(yymsp[-3].minor.yy274), yymsp[-2].minor.yy186, yymsp[0].minor.yy186);
                                                delete yymsp[-4].minor.yy225;
                                                delete yymsp[-3].minor.yy274;
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 304: /* exprx ::= expr ISNULL|NOTNULL */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initNull(yymsp[-1].minor.yy186, yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 305: /* exprx ::= expr NOT NULL */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initNull(yymsp[-2].minor.yy186, "NOT NULL");
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 306: /* exprx ::= expr IS not_opt expr */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initIs(yymsp[-3].minor.yy186, *(yymsp[-1].minor.yy225), yymsp[0].minor.yy186);
                                                delete yymsp[-1].minor.yy225;
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 307: /* exprx ::= expr IS NOT DISTINCT FROM expr */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initDistinct(yymsp[-5].minor.yy186, true, yymsp[0].minor.yy186);
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 308: /* exprx ::= expr IS DISTINCT FROM expr */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initDistinct(yymsp[-4].minor.yy186, false, yymsp[0].minor.yy186);
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 309: /* exprx ::= NOT expr */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initUnaryOp(yymsp[0].minor.yy186, yymsp[-1].minor.yy0->value);
                                            }
        break;
      case 310: /* exprx ::= BITNOT expr */
      case 312: /* exprx ::= PLUS expr */ yytestcase(yyruleno==312);
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initUnaryOp(yymsp[0].minor.yy186, yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 311: /* exprx ::= MINUS expr */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                if (yymsp[0].minor.yy186->mode == SqliteExpr::Mode::LITERAL_VALUE &&
                                                    parserContext->isCandidateForMaxNegativeNumber() &&
                                                    yymsp[0].minor.yy186->literalValue == static_cast<qint64>(0L))
                                                {
                                                    yygotominor.yy186->initLiteral(std::numeric_limits<qint64>::min());
                                                    delete yymsp[0].minor.yy186;
                                                }
                                                else
                                                {
                                                    yygotominor.yy186->initUnaryOp(yymsp[0].minor.yy186, yymsp[-1].minor.yy0->value);
                                                }
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 313: /* exprx ::= expr PTR expr */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initPtrOp(yymsp[-2].minor.yy186, yymsp[-1].minor.yy0->value, yymsp[0].minor.yy186);
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 314: /* exprx ::= expr not_opt BETWEEN expr AND expr */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initBetween(yymsp[-5].minor.yy186, *(yymsp[-4].minor.yy225), yymsp[-2].minor.yy186, yymsp[0].minor.yy186);
                                                delete yymsp[-4].minor.yy225;
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 315: /* exprx ::= expr not_opt IN LP exprlist RP */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initIn(yymsp[-5].minor.yy186, *(yymsp[-4].minor.yy225), *(yymsp[-1].minor.yy615));
                                                delete yymsp[-4].minor.yy225;
                                                delete yymsp[-1].minor.yy615;
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 316: /* exprx ::= LP select RP */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initSubSelect(yymsp[-1].minor.yy297);
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 317: /* exprx ::= expr not_opt IN LP select RP */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initIn(yymsp[-5].minor.yy186, *(yymsp[-4].minor.yy225), yymsp[-1].minor.yy297);
                                                delete yymsp[-4].minor.yy225;
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 318: /* exprx ::= expr not_opt IN nm dbnm */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initIn(yymsp[-4].minor.yy186, *(yymsp[-3].minor.yy225), *(yymsp[-1].minor.yy319), *(yymsp[0].minor.yy319));
                                                delete yymsp[-3].minor.yy225;
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 319: /* exprx ::= EXISTS LP select RP */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initExists(yymsp[-1].minor.yy297);
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 320: /* exprx ::= CASE case_operand case_exprlist case_else END */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initCase(yymsp[-3].minor.yy186, *(yymsp[-2].minor.yy615), yymsp[-1].minor.yy186);
                                                delete yymsp[-2].minor.yy615;
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 321: /* exprx ::= RAISE LP IGNORE RP */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initRaise(yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 322: /* exprx ::= RAISE LP raisetype COMMA nm RP */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initRaise(yymsp[-3].minor.yy0->value, *(yymsp[-1].minor.yy319));
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy186;
                                            }
        break;
      case 323: /* exprx ::= ID LP distinct exprlist RP filter_over */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initWindowFunction(stripObjName(yymsp[-5].minor.yy0->value), *(yymsp[-3].minor.yy130), *(yymsp[-2].minor.yy615), yymsp[0].minor.yy181);
                                                delete yymsp[-3].minor.yy130;
                                                delete yymsp[-2].minor.yy615;
                                                objectForTokens = yygotominor.yy186;
											}
        break;
      case 324: /* exprx ::= ID LP STAR RP filter_over */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                yygotominor.yy186->initWindowFunction(stripObjName(yymsp[-4].minor.yy0->value), yymsp[0].minor.yy181);
                                                objectForTokens = yygotominor.yy186;
											}
        break;
      case 325: /* expr ::= */
{
                                                yygotominor.yy186 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy186;
                                                parserContext->minorErrorAfterLastToken("Syntax error <expr>");
                                            }
        break;
      case 329: /* likeop ::= LIKE_KW|MATCH */
{yygotominor.yy274 = new SqliteExpr::LikeOp(SqliteExpr::likeOp(yymsp[0].minor.yy0->value));}
        break;
      case 330: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
{
                                                yymsp[-4].minor.yy615->append(yymsp[-2].minor.yy186);
                                                yymsp[-4].minor.yy615->append(yymsp[0].minor.yy186);
                                                yygotominor.yy615 = yymsp[-4].minor.yy615;
                                            }
        break;
      case 331: /* case_exprlist ::= WHEN expr THEN expr */
{
                                                yygotominor.yy615 = new ParserExprList();
                                                yygotominor.yy615->append(yymsp[-2].minor.yy186);
                                                yygotominor.yy615->append(yymsp[0].minor.yy186);
                                            }
        break;
      case 338: /* nexprlist ::= nexprlist COMMA expr */
{
                                                yymsp[-2].minor.yy615->append(yymsp[0].minor.yy186);
                                                yygotominor.yy615 = yymsp[-2].minor.yy615;
                                                DONT_INHERIT_TOKENS("nexprlist");
                                            }
        break;
      case 339: /* nexprlist ::= exprx */
{
                                                yygotominor.yy615 = new ParserExprList();
                                                yygotominor.yy615->append(yymsp[0].minor.yy186);
                                            }
        break;
      case 340: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP sortlist RP where_opt */
{
                                                yygotominor.yy41 = new SqliteCreateIndex(
                                                        *(yymsp[-10].minor.yy225),
                                                        *(yymsp[-8].minor.yy225),
                                                        *(yymsp[-7].minor.yy319),
                                                        *(yymsp[-6].minor.yy319),
                                                        *(yymsp[-4].minor.yy319),
                                                        *(yymsp[-2].minor.yy226),
                                                        yymsp[0].minor.yy186
                                                    );
                                                delete yymsp[-8].minor.yy225;
                                                delete yymsp[-10].minor.yy225;
                                                delete yymsp[-7].minor.yy319;
                                                delete yymsp[-6].minor.yy319;
                                                delete yymsp[-4].minor.yy319;
                                                delete yymsp[-2].minor.yy226;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 341: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON ID_TAB */
{  yy_destructor(yypParser,203,&yymsp[-3].minor);
}
        break;
      case 346: /* idxlist_opt ::= */
{yygotominor.yy627 = new ParserIndexedColumnList();}
        break;
      case 347: /* idxlist_opt ::= LP idxlist RP */
{yygotominor.yy627 = yymsp[-1].minor.yy627;}
        break;
      case 348: /* idxlist ::= idxlist COMMA idxlist_single */
{
                                                yymsp[-2].minor.yy627->append(yymsp[0].minor.yy110);
                                                yygotominor.yy627 = yymsp[-2].minor.yy627;
                                                DONT_INHERIT_TOKENS("idxlist");
                                            }
        break;
      case 349: /* idxlist ::= idxlist_single */
{
                                                yygotominor.yy627 = new ParserIndexedColumnList();
                                                yygotominor.yy627->append(yymsp[0].minor.yy110);
                                            }
        break;
      case 350: /* idxlist_single ::= nm collate sortorder */
      case 351: /* idxlist_single ::= ID_COL */ yytestcase(yyruleno==351);
{
                                                SqliteIndexedColumn* obj =
                                                    new SqliteIndexedColumn(
                                                        *(yymsp[-2].minor.yy319),
                                                        *(yymsp[-1].minor.yy319),
                                                        *(yymsp[0].minor.yy35)
                                                    );
                                                yygotominor.yy110 = obj;
                                                delete yymsp[0].minor.yy35;
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy110;
                                            }
        break;
      case 355: /* cmd ::= DROP INDEX ifexists fullname */
{
                                                yygotominor.yy41 = new SqliteDropIndex(*(yymsp[-1].minor.yy225), yymsp[0].minor.yy396->name1, yymsp[0].minor.yy396->name2);
                                                delete yymsp[-1].minor.yy225;
                                                delete yymsp[0].minor.yy396;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 358: /* cmd ::= VACUUM vinto */
{
                                                yygotominor.yy41 = new SqliteVacuum(yymsp[0].minor.yy186);
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 359: /* cmd ::= VACUUM nm vinto */
{
                                                yygotominor.yy41 = new SqliteVacuum(*(yymsp[-1].minor.yy319), yymsp[0].minor.yy186);
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 362: /* cmd ::= PRAGMA nm dbnm */
{
                                                yygotominor.yy41 = new SqlitePragma(*(yymsp[-1].minor.yy319), *(yymsp[0].minor.yy319));
                                                delete yymsp[-1].minor.yy319;
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 363: /* cmd ::= PRAGMA nm dbnm EQ nmnum */
      case 365: /* cmd ::= PRAGMA nm dbnm EQ minus_num */ yytestcase(yyruleno==365);
{
                                                yygotominor.yy41 = new SqlitePragma(*(yymsp[-3].minor.yy319), *(yymsp[-2].minor.yy319), *(yymsp[0].minor.yy393), true);
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[0].minor.yy393;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 364: /* cmd ::= PRAGMA nm dbnm LP nmnum RP */
      case 366: /* cmd ::= PRAGMA nm dbnm LP minus_num RP */ yytestcase(yyruleno==366);
{
                                                yygotominor.yy41 = new SqlitePragma(*(yymsp[-4].minor.yy319), *(yymsp[-3].minor.yy319), *(yymsp[-1].minor.yy393), false);
                                                delete yymsp[-4].minor.yy319;
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-1].minor.yy393;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 370: /* nmnum ::= nm */
{
                                                yygotominor.yy393 = new QVariant(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 371: /* nmnum ::= ON */
      case 372: /* nmnum ::= DELETE */ yytestcase(yyruleno==372);
      case 373: /* nmnum ::= DEFAULT */ yytestcase(yyruleno==373);
{yygotominor.yy393 = new QVariant(yymsp[0].minor.yy0->value);}
        break;
      case 376: /* minus_num ::= MINUS number */
{
                                                if (yymsp[0].minor.yy393->userType() == QMetaType::Double)
                                                    *(yymsp[0].minor.yy393) = -(yymsp[0].minor.yy393->toDouble());
                                                else if (yymsp[0].minor.yy393->userType() == QMetaType::LongLong)
                                                {
                                                    if (parserContext->isCandidateForMaxNegativeNumber())
                                                        *(yymsp[0].minor.yy393) = std::numeric_limits<qint64>::min();
                                                    else
                                                        *(yymsp[0].minor.yy393) = -(yymsp[0].minor.yy393->toLongLong());
                                                }
                                                else
                                                    Q_ASSERT_X(true, "producing minus number", "QVariant is neither of Double or LongLong.");

                                                yygotominor.yy393 = yymsp[0].minor.yy393;
                                            }
        break;
      case 379: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list END */
{
                                                yygotominor.yy41 = new SqliteCreateTrigger(
                                                        *(yymsp[-13].minor.yy130),
                                                        *(yymsp[-11].minor.yy225),
                                                        *(yymsp[-10].minor.yy319),
                                                        *(yymsp[-9].minor.yy319),
                                                        *(yymsp[-5].minor.yy319),
                                                        *(yymsp[-8].minor.yy120),
                                                        yymsp[-7].minor.yy259,
                                                        *(yymsp[-4].minor.yy456),
                                                        yymsp[-3].minor.yy186,
                                                        *(yymsp[-1].minor.yy240),
                                                        3
                                                    );
                                                delete yymsp[-11].minor.yy225;
                                                delete yymsp[-13].minor.yy130;
                                                delete yymsp[-8].minor.yy120;
                                                delete yymsp[-4].minor.yy456;
                                                delete yymsp[-10].minor.yy319;
                                                delete yymsp[-5].minor.yy319;
                                                delete yymsp[-9].minor.yy319;
                                                delete yymsp[-1].minor.yy240;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 380: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause */
{
                                                QList<SqliteQuery *> CL;

                                                yygotominor.yy41 = new SqliteCreateTrigger(
                                                        *(yymsp[-10].minor.yy130),
                                                        *(yymsp[-8].minor.yy225),
                                                        *(yymsp[-7].minor.yy319),
                                                        *(yymsp[-6].minor.yy319),
                                                        *(yymsp[-2].minor.yy319),
                                                        *(yymsp[-5].minor.yy120),
                                                        yymsp[-4].minor.yy259,
                                                        *(yymsp[-1].minor.yy456),
                                                        yymsp[0].minor.yy186,
                                                        CL,
                                                        3
                                                    );
                                                delete yymsp[-8].minor.yy225;
                                                delete yymsp[-10].minor.yy130;
                                                delete yymsp[-5].minor.yy120;
                                                delete yymsp[-1].minor.yy456;
                                                delete yymsp[-7].minor.yy319;
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[-6].minor.yy319;
                                                objectForTokens = yygotominor.yy41;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 381: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list */
{
                                                yygotominor.yy41 = new SqliteCreateTrigger(
													*(yymsp[-12].minor.yy130),
													*(yymsp[-10].minor.yy225),
													*(yymsp[-9].minor.yy319),
													*(yymsp[-8].minor.yy319),
													*(yymsp[-4].minor.yy319),
													*(yymsp[-7].minor.yy120),
													yymsp[-6].minor.yy259,
													*(yymsp[-3].minor.yy456),
													yymsp[-2].minor.yy186,
													*(yymsp[0].minor.yy240),
													3
                                                );
                                                delete yymsp[-10].minor.yy225;
                                                delete yymsp[-12].minor.yy130;
                                                delete yymsp[-7].minor.yy120;
                                                delete yymsp[-3].minor.yy456;
                                                delete yymsp[-9].minor.yy319;
                                                delete yymsp[-4].minor.yy319;
                                                delete yymsp[-8].minor.yy319;
                                                delete yymsp[0].minor.yy240;
                                                objectForTokens = yygotominor.yy41;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 382: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON ID_TAB */
{  yy_destructor(yypParser,205,&yymsp[-8].minor);
  yy_destructor(yypParser,203,&yymsp[-5].minor);
  yy_destructor(yypParser,298,&yymsp[-3].minor);
  yy_destructor(yypParser,299,&yymsp[-2].minor);
}
        break;
      case 385: /* trigger_time ::= BEFORE */
{yygotominor.yy120 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::BEFORE);}
        break;
      case 386: /* trigger_time ::= AFTER */
{yygotominor.yy120 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::AFTER);}
        break;
      case 387: /* trigger_time ::= INSTEAD OF */
{yygotominor.yy120 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::INSTEAD_OF);}
        break;
      case 388: /* trigger_time ::= */
{yygotominor.yy120 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::null);}
        break;
      case 389: /* trigger_event ::= DELETE */
{
                                                yygotominor.yy259 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::DELETE);
                                                objectForTokens = yygotominor.yy259;
                                            }
        break;
      case 390: /* trigger_event ::= INSERT */
{
                                                yygotominor.yy259 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::INSERT);
                                                objectForTokens = yygotominor.yy259;
                                            }
        break;
      case 391: /* trigger_event ::= UPDATE */
{
                                                yygotominor.yy259 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::UPDATE);
                                                objectForTokens = yygotominor.yy259;
                                            }
        break;
      case 392: /* trigger_event ::= UPDATE OF idlist */
{
                                                yygotominor.yy259 = new SqliteCreateTrigger::Event(*(yymsp[0].minor.yy173));
                                                delete yymsp[0].minor.yy173;
                                                objectForTokens = yygotominor.yy259;
                                            }
        break;
      case 393: /* foreach_clause ::= */
{yygotominor.yy456 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::null);}
        break;
      case 394: /* foreach_clause ::= FOR EACH ROW */
{yygotominor.yy456 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::FOR_EACH_ROW);}
        break;
      case 397: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
{
                                                yymsp[-2].minor.yy240->append(yymsp[-1].minor.yy41);
                                                yygotominor.yy240 = yymsp[-2].minor.yy240;
                                                DONT_INHERIT_TOKENS("trigger_cmd_list");
                                            }
        break;
      case 398: /* trigger_cmd_list ::= trigger_cmd SEMI */
{
                                                yygotominor.yy240 = new ParserQueryList();
                                                yygotominor.yy240->append(yymsp[-1].minor.yy41);
                                            }
        break;
      case 399: /* trigger_cmd_list ::= SEMI */
{
                                                yygotominor.yy240 = new ParserQueryList();
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 404: /* raisetype ::= ROLLBACK|ABORT|FAIL */
{yygotominor.yy0 = yymsp[0].minor.yy0;}
        break;
      case 405: /* cmd ::= DROP TRIGGER ifexists fullname */
{
                                                yygotominor.yy41 = new SqliteDropTrigger(*(yymsp[-1].minor.yy225), yymsp[0].minor.yy396->name1, yymsp[0].minor.yy396->name2);
                                                delete yymsp[-1].minor.yy225;
                                                delete yymsp[0].minor.yy396;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 408: /* cmd ::= ATTACH database_kw_opt expr AS expr key_opt */
{
                                                yygotominor.yy41 = new SqliteAttach(*(yymsp[-4].minor.yy225), yymsp[-3].minor.yy186, yymsp[-1].minor.yy186, yymsp[0].minor.yy186);
                                                delete yymsp[-4].minor.yy225;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 409: /* cmd ::= DETACH database_kw_opt expr */
{
                                                yygotominor.yy41 = new SqliteDetach(*(yymsp[-1].minor.yy225), yymsp[0].minor.yy186);
                                                delete yymsp[-1].minor.yy225;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 414: /* cmd ::= REINDEX */
{yygotominor.yy41 = new SqliteReindex();}
        break;
      case 415: /* cmd ::= REINDEX nm dbnm */
      case 416: /* cmd ::= REINDEX ID_COLLATE */ yytestcase(yyruleno==416);
{
                                                yygotominor.yy41 = new SqliteReindex(*(yymsp[-1].minor.yy319), *(yymsp[0].minor.yy319));
                                                delete yymsp[-1].minor.yy319;
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 419: /* cmd ::= ANALYZE */
{
                                                yygotominor.yy41 = new SqliteAnalyze();
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 420: /* cmd ::= ANALYZE nm dbnm */
{
                                                yygotominor.yy41 = new SqliteAnalyze(*(yymsp[-1].minor.yy319), *(yymsp[0].minor.yy319));
                                                delete yymsp[-1].minor.yy319;
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 423: /* cmd ::= ALTER TABLE fullname RENAME TO nm */
{
                                                yygotominor.yy41 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy396->name1,
                                                        yymsp[-3].minor.yy396->name2,
                                                        *(yymsp[0].minor.yy319)
                                                    );
                                                delete yymsp[0].minor.yy319;
                                                delete yymsp[-3].minor.yy396;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 424: /* cmd ::= ALTER TABLE fullname ADD kwcolumn_opt column */
{
                                                yygotominor.yy41 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy396->name1,
                                                        yymsp[-3].minor.yy396->name2,
                                                        *(yymsp[-1].minor.yy225),
                                                        yymsp[0].minor.yy3
                                                    );
                                                delete yymsp[-1].minor.yy225;
                                                delete yymsp[-3].minor.yy396;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 425: /* cmd ::= ALTER TABLE fullname DROP kwcolumn_opt nm */
{
                                                yygotominor.yy41 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy396->name1,
                                                        yymsp[-3].minor.yy396->name2,
                                                        *(yymsp[-1].minor.yy225),
                                                        *(yymsp[0].minor.yy319)
                                                    );
                                                delete yymsp[-1].minor.yy225;
                                                delete yymsp[-3].minor.yy396;
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 426: /* cmd ::= ALTER TABLE fullname RENAME TO ID_TAB_NEW */
{  yy_destructor(yypParser,207,&yymsp[-3].minor);
}
        break;
      case 432: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm */
{
                                                yygotominor.yy41 = new SqliteCreateVirtualTable(
                                                        *(yymsp[-4].minor.yy225),
                                                        *(yymsp[-3].minor.yy319),
                                                        *(yymsp[-2].minor.yy319),
                                                        *(yymsp[0].minor.yy319)
                                                    );
                                                delete yymsp[-4].minor.yy225;
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 433: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm LP vtabarglist RP */
{
                                                yygotominor.yy41 = new SqliteCreateVirtualTable(
                                                        *(yymsp[-7].minor.yy225),
                                                        *(yymsp[-6].minor.yy319),
                                                        *(yymsp[-5].minor.yy319),
                                                        *(yymsp[-3].minor.yy319),
                                                        *(yymsp[-1].minor.yy173)
                                                    );
                                                delete yymsp[-6].minor.yy319;
                                                delete yymsp[-5].minor.yy319;
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-7].minor.yy225;
                                                delete yymsp[-1].minor.yy173;
                                                objectForTokens = yygotominor.yy41;
                                            }
        break;
      case 436: /* vtabarglist ::= vtabarg */
{
                                                yygotominor.yy173 = new QStringList();
                                                yygotominor.yy173->append((yymsp[0].minor.yy319)->mid(1)); // mid(1) to skip the first whitespace added in vtabarg
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 437: /* vtabarglist ::= vtabarglist COMMA vtabarg */
{
                                                yymsp[-2].minor.yy173->append((yymsp[0].minor.yy319)->mid(1)); // mid(1) to skip the first whitespace added in vtabarg
                                                yygotominor.yy173 = yymsp[-2].minor.yy173;
                                                delete yymsp[0].minor.yy319;
                                                DONT_INHERIT_TOKENS("vtabarglist");
                                            }
        break;
      case 439: /* vtabarg ::= vtabarg vtabargtoken */
{
                                                yymsp[-1].minor.yy319->append(" "+ *(yymsp[0].minor.yy319));
                                                yygotominor.yy319 = yymsp[-1].minor.yy319;
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 440: /* vtabargtoken ::= ANY */
{
                                                yygotominor.yy319 = new QString(yymsp[0].minor.yy0->value);
                                            }
        break;
      case 441: /* vtabargtoken ::= LP anylist RP */
{
                                                yygotominor.yy319 = new QString("(");
                                                yygotominor.yy319->append(*(yymsp[-1].minor.yy319));
                                                yygotominor.yy319->append(")");
                                                delete yymsp[-1].minor.yy319;
                                            }
        break;
      case 443: /* anylist ::= anylist LP anylist RP */
{
                                                yygotominor.yy319 = yymsp[-3].minor.yy319;
                                                yygotominor.yy319->append("(");
                                                yygotominor.yy319->append(*(yymsp[-1].minor.yy319));
                                                yygotominor.yy319->append(")");
                                                delete yymsp[-1].minor.yy319;
                                                DONT_INHERIT_TOKENS("anylist");
                                            }
        break;
      case 444: /* anylist ::= anylist ANY */
{
                                                yygotominor.yy319 = yymsp[-1].minor.yy319;
                                                yygotominor.yy319->append(yymsp[0].minor.yy0->value);
                                                DONT_INHERIT_TOKENS("anylist");
                                            }
        break;
      case 445: /* with ::= */
{yygotominor.yy161 = nullptr;}
        break;
      case 446: /* with ::= WITH wqlist */
{
                                                yygotominor.yy161 = new SqliteWith();
												yygotominor.yy161->cteList = *(yymsp[0].minor.yy164);
												delete yymsp[0].minor.yy164;
                                                objectForTokens = yygotominor.yy161;
                                            }
        break;
      case 447: /* with ::= WITH RECURSIVE wqlist */
{
                                                yygotominor.yy161 = new SqliteWith();
												yygotominor.yy161->cteList = *(yymsp[0].minor.yy164);
                                                yygotominor.yy161->recursive = true;
												delete yymsp[0].minor.yy164;
                                                objectForTokens = yygotominor.yy161;
                                            }
        break;
      case 448: /* wqas ::= AS */
{yygotominor.yy21 = new SqliteWith::CommonTableExpression::AsMode(SqliteWith::CommonTableExpression::ANY);}
        break;
      case 449: /* wqas ::= AS MATERIALIZED */
{yygotominor.yy21 = new SqliteWith::CommonTableExpression::AsMode(SqliteWith::CommonTableExpression::MATERIALIZED);}
        break;
      case 450: /* wqas ::= AS NOT MATERIALIZED */
{yygotominor.yy21 = new SqliteWith::CommonTableExpression::AsMode(SqliteWith::CommonTableExpression::NOT_MATERIALIZED);}
        break;
      case 451: /* wqlist ::= wqcte */
{
												yygotominor.yy164 = new ParserCteList();
                                                yygotominor.yy164->append(yymsp[0].minor.yy146);
                                            }
        break;
      case 452: /* wqlist ::= wqlist COMMA wqcte */
{
                                                yygotominor.yy164 = yymsp[-2].minor.yy164;
                                                yygotominor.yy164->append(yymsp[0].minor.yy146);
                                                DONT_INHERIT_TOKENS("wqlist");
                                            }
        break;
      case 453: /* wqlist ::= ID_TAB_NEW */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                            }
        break;
      case 454: /* wqcte ::= nm idxlist_opt wqas LP select RP */
{
                                                yygotominor.yy146 = new SqliteWith::CommonTableExpression(*(yymsp[-5].minor.yy319), *(yymsp[-4].minor.yy627), yymsp[-1].minor.yy297, *(yymsp[-3].minor.yy21));
                                                delete yymsp[-5].minor.yy319;
                                                delete yymsp[-4].minor.yy627;
                                                delete yymsp[-3].minor.yy21;
												objectForTokens = yygotominor.yy146;
											}
        break;
      case 455: /* windowdefn_list ::= windowdefn */
{
												yygotominor.yy525 = new ParserWindowDefList();
												yygotominor.yy525->append(yymsp[0].minor.yy562);
											}
        break;
      case 456: /* windowdefn_list ::= windowdefn_list COMMA windowdefn */
{
												yymsp[-2].minor.yy525->append(yymsp[0].minor.yy562);
												yygotominor.yy525 = yymsp[-2].minor.yy525;
												DONT_INHERIT_TOKENS("windowdefn_list");
											}
        break;
      case 457: /* windowdefn ::= nm AS LP window RP */
{
												yygotominor.yy562 = new SqliteWindowDefinition(*(yymsp[-4].minor.yy319), yymsp[-1].minor.yy162);
												delete yymsp[-4].minor.yy319;
												objectForTokens = yygotominor.yy562;
											}
        break;
      case 458: /* window ::= PARTITION BY nexprlist orderby_opt frame_opt */
{
												yygotominor.yy162 = new SqliteWindowDefinition::Window();
												yygotominor.yy162->initPartitionBy(QString(), *(yymsp[-2].minor.yy615), *(yymsp[-1].minor.yy226), yymsp[0].minor.yy149);
												delete yymsp[-2].minor.yy615;
												delete yymsp[-1].minor.yy226;
												objectForTokens = yygotominor.yy162;
											}
        break;
      case 459: /* window ::= nm PARTITION BY nexprlist orderby_opt frame_opt */
{
												yygotominor.yy162 = new SqliteWindowDefinition::Window();
												yygotominor.yy162->initPartitionBy(*(yymsp[-5].minor.yy319), *(yymsp[-2].minor.yy615), *(yymsp[-1].minor.yy226), yymsp[0].minor.yy149);
												delete yymsp[-2].minor.yy615;
												delete yymsp[-5].minor.yy319;
												delete yymsp[-1].minor.yy226;
												objectForTokens = yygotominor.yy162;
											}
        break;
      case 460: /* window ::= ORDER BY sortlist frame_opt */
{
												yygotominor.yy162 = new SqliteWindowDefinition::Window();
												yygotominor.yy162->initOrderBy(QString(), *(yymsp[-1].minor.yy226), yymsp[0].minor.yy149);
												delete yymsp[-1].minor.yy226;
												objectForTokens = yygotominor.yy162;
											}
        break;
      case 461: /* window ::= nm ORDER BY sortlist frame_opt */
{
												yygotominor.yy162 = new SqliteWindowDefinition::Window();
												yygotominor.yy162->initOrderBy(*(yymsp[-4].minor.yy319), *(yymsp[-1].minor.yy226), yymsp[0].minor.yy149);
												delete yymsp[-1].minor.yy226;
												delete yymsp[-4].minor.yy319;
												objectForTokens = yygotominor.yy162;
											}
        break;
      case 462: /* window ::= frame_opt */
{
												yygotominor.yy162 = new SqliteWindowDefinition::Window();
												yygotominor.yy162->init(QString(), yymsp[0].minor.yy149);
												objectForTokens = yygotominor.yy162;
											}
        break;
      case 463: /* window ::= nm frame_opt */
{
												yygotominor.yy162 = new SqliteWindowDefinition::Window();
												yygotominor.yy162->init(QString(), yymsp[0].minor.yy149);
												delete yymsp[-1].minor.yy319;
												objectForTokens = yygotominor.yy162;
											}
        break;
      case 464: /* frame_opt ::= */
{yygotominor.yy149 = nullptr;}
        break;
      case 465: /* frame_opt ::= range_or_rows frame_bound_s frame_exclude_opt */
{
												yygotominor.yy149 = new SqliteWindowDefinition::Window::Frame(*(yymsp[-2].minor.yy143), yymsp[-1].minor.yy285, nullptr, *(yymsp[0].minor.yy237));
												delete yymsp[-2].minor.yy143;
												delete yymsp[0].minor.yy237;
												objectForTokens = yygotominor.yy149;
											}
        break;
      case 466: /* frame_opt ::= range_or_rows BETWEEN frame_bound_s AND frame_bound_e frame_exclude_opt */
{
												yygotominor.yy149 = new SqliteWindowDefinition::Window::Frame(*(yymsp[-5].minor.yy143), yymsp[-3].minor.yy285, yymsp[-1].minor.yy285, *(yymsp[0].minor.yy237));
												delete yymsp[-5].minor.yy143;
												delete yymsp[0].minor.yy237;
												objectForTokens = yygotominor.yy149;
											}
        break;
      case 467: /* range_or_rows ::= RANGE|ROWS|GROUPS */
{
												yygotominor.yy143 = new SqliteWindowDefinition::Window::Frame::RangeOrRows(
													SqliteWindowDefinition::Window::Frame::toRangeOrRows(yymsp[0].minor.yy0->value)
													);
											}
        break;
      case 468: /* frame_bound_s ::= frame_bound */
      case 470: /* frame_bound_e ::= frame_bound */ yytestcase(yyruleno==470);
{
												yygotominor.yy285 = yymsp[0].minor.yy285;
												objectForTokens = yygotominor.yy285;
											}
        break;
      case 469: /* frame_bound_s ::= UNBOUNDED PRECEDING */
      case 471: /* frame_bound_e ::= UNBOUNDED FOLLOWING */ yytestcase(yyruleno==471);
      case 473: /* frame_bound ::= CURRENT ROW */ yytestcase(yyruleno==473);
{
												yygotominor.yy285 = new SqliteWindowDefinition::Window::Frame::Bound(nullptr, yymsp[-1].minor.yy0->value + " " + yymsp[0].minor.yy0->value);
												objectForTokens = yygotominor.yy285;
											}
        break;
      case 472: /* frame_bound ::= expr PRECEDING|FOLLOWING */
{
												yygotominor.yy285 = new SqliteWindowDefinition::Window::Frame::Bound(yymsp[-1].minor.yy186, yymsp[0].minor.yy0->value);
												objectForTokens = yygotominor.yy285;
											}
        break;
      case 474: /* frame_exclude_opt ::= */
{
												yygotominor.yy237 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::null
													);
											}
        break;
      case 475: /* frame_exclude_opt ::= EXCLUDE frame_exclude */
{
												yygotominor.yy237 = yymsp[0].minor.yy237;
											}
        break;
      case 476: /* frame_exclude ::= NO OTHERS */
{
												yygotominor.yy237 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::NO_OTHERS
													);
											}
        break;
      case 477: /* frame_exclude ::= CURRENT ROW */
{
												yygotominor.yy237 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::CURRENT_ROW
													);
											}
        break;
      case 478: /* frame_exclude ::= GROUP */
{
												yygotominor.yy237 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::GROUP
													);
											}
        break;
      case 479: /* frame_exclude ::= TIES */
{
												yygotominor.yy237 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::TIES
													);
											}
        break;
      case 480: /* window_clause ::= WINDOW windowdefn_list */
{
												yygotominor.yy525 = yymsp[0].minor.yy525;
											}
        break;
      case 481: /* filter_over ::= filter_clause over_clause */
{
												yygotominor.yy181 = new SqliteFilterOver(yymsp[-1].minor.yy39, yymsp[0].minor.yy11);
												objectForTokens = yygotominor.yy181;
											}
        break;
      case 482: /* filter_over ::= over_clause */
{
												yygotominor.yy181 = new SqliteFilterOver(nullptr, yymsp[0].minor.yy11);
												objectForTokens = yygotominor.yy181;
											}
        break;
      case 483: /* filter_over ::= filter_clause */
{
												yygotominor.yy181 = new SqliteFilterOver(yymsp[0].minor.yy39, nullptr);
												objectForTokens = yygotominor.yy181;
											}
        break;
      case 484: /* over_clause ::= OVER LP window RP */
{
												yygotominor.yy11 = new SqliteFilterOver::Over(yymsp[-1].minor.yy162);
												objectForTokens = yygotominor.yy11;
											}
        break;
      case 485: /* over_clause ::= OVER nm */
{
												yygotominor.yy11 = new SqliteFilterOver::Over(*(yymsp[0].minor.yy319));
												delete yymsp[0].minor.yy319;
												objectForTokens = yygotominor.yy11;
											}
        break;
      case 486: /* filter_clause ::= FILTER LP WHERE expr RP */
{
												yygotominor.yy39 = new SqliteFilterOver::Filter(yymsp[-1].minor.yy186);
												objectForTokens = yygotominor.yy39;
                                            }
        break;
      default:
      /* (0) input ::= cmdlist */ yytestcase(yyruleno==0);
        break;
      };
  }
  assert( yyruleno>=0 && yyruleno<(int)(sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0])) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;

  // Store tokens for the rule in parser context
  QList<Token*> allTokens;
  QList<Token*> allTokensWithAllInherited;
  QString keyForTokensMap;
  int tokensMapKeyCnt;
  if (parserContext->setupTokens)
  {
      if (objectForTokens)
      {
          // In case this is a list with recurrent references we need
          // to clear tokens before adding the new and extended list.
          objectForTokens->tokens.clear();
      }

      QList<Token*> tokens;
      for (int i = yypParser->yyidx - yysize + 1; i <= yypParser->yyidx; i++)
      {
          tokens.clear();
          const char* fieldName = yyTokenName[yypParser->yystack[i].major];

          // Adding token being subject of this reduction. It's usually not includes in the inherited tokens,
          // although if inheriting from simple statements, like "FAIL" or "ROLLBACK", this tends to be redundant with the inherited tokens.
          // That's why we're checking if it's not contained in the inherited tokens and add it only then.
          if (parserContext->isManagedToken(yypParser->yystack[i].minor.yy0) && !yypParser->yystack[i].tokens->contains(yypParser->yystack[i].minor.yy0))
              tokens += yypParser->yystack[i].minor.yy0;

          tokens += *(yypParser->yystack[i].tokens);

          if (!noTokenInheritanceFields.contains(fieldName))
          {
              if (objectForTokens)
              {
                  keyForTokensMap = fieldName;
                  tokensMapKeyCnt = 2;
                  while (objectForTokens->tokensMap.contains(keyForTokensMap))
                      keyForTokensMap = fieldName + QString::number(tokensMapKeyCnt++);

                  objectForTokens->tokensMap[keyForTokensMap] = parserContext->getTokenPtrList(tokens);
              }

              allTokens += tokens;
          }
          else
          {
              // If field is mentioned only once, then only one occurance of it will be ignored.
              // Second one should be inherited. See "anylist" definition for explanation why.
              noTokenInheritanceFields.removeOne(fieldName);
          }
          allTokensWithAllInherited += tokens;
      }
      if (objectForTokens)
      {
          objectForTokens->tokens += parserContext->getTokenPtrList(allTokens);
      }
  }

  // Clear token lists
  for (int i = yypParser->yyidx - yysize + 1; i <= yypParser->yyidx; i++)
  {
      delete yypParser->yystack[i].tokens;
      yypParser->yystack[i].tokens = nullptr;
  }

  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
      if (parserContext->setupTokens)
          *(yypParser->yystack[yypParser->yyidx].tokens) = allTokens;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
      if (parserContext->setupTokens && yypParser->yyidx >= 0)
      {
          QList<Token*>* tokensPtr = yypParser->yystack[yypParser->yyidx].tokens;
          *tokensPtr = allTokensWithAllInherited + *tokensPtr;
      }
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3_parseARG_FETCH;
#define TOKEN (yyminor.yy0)

    UNUSED_PARAMETER(yymajor);
    parserContext->error(TOKEN, QObject::tr("Syntax error"));
    //qDebug() << "near " << TOKEN->toString() << ": syntax error";
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3_parseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3_parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3_parseTOKENTYPE yyminor       /* The value for the token */
  sqlite3_parseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
    yypParser->yystack[0].tokens = new QList<Token*>();
  }
  yyminorunion.yy0 = yyminor;
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif
  sqlite3_parseARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s [%s] (lemon type: %s)\n",
            yyTracePrompt,
            yyminor->value.toLatin1().data(),
            yyminor->typeString().toLatin1().data(),
            yyTokenName[yymajor]);  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 1; // not 3 valid tokens, but 1
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;

#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 1; // not 3 valid tokens, but 1
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}

int sqlite3ParserFallback(int iToken) {
    return yyFallback[iToken];
}
