---
layout: default
---

## About Project

**[The Practical Linux Hardening Guide](https://github.com/trimstray/the-practical-linux-hardening-guide/wiki)** provides a high-level overview of hardening GNU/Linux systems. It is not an official standard or handbook but it _touches_ and _uses_ industry standards.

This guide also provides you with _practical step-by-step instructions_ for building your own hardened systems and services. One of the main goals is to create a single document covering _internal_ and _external_ threats.

The Practical Linux Hardening Guide use following [OpenSCAP](https://www.open-scap.org/) configurations:

- [U.S. Government Commercial Cloud Services (C2S) baseline inspired by CIS v2.1.1](https://static.open-scap.org/ssg-guides/ssg-rhel7-guide-C2S.html)

  > C2S for Red Hat Enterprise Linux 7 v0.1.43.

- [Red Hat Enterprise Linux 7 Security Technical Implementation Guide (STIG)](https://www.stigviewer.com/stig/red_hat_enterprise_linux_7/)

  > The requirements are derived from the (NIST) 800-53 and related documents.

## About Me

I'm a System and (tiny) Network Administrator. Also Security Enthusiast.

For the most part, I manage environments based on GNU/Linux and BSD systems.

The postings on this domain are my own and don't necessarily represent my employer’s positions, strategies or opinions.

## Contact

If you wish to contact me:

- hit me on [Twitter](https://twitter.com/trimstray), [Keybase](https://keybase.io/trimstray) or [Github](https://github.com/trimstray)
- via e-mail (base64): `dHJpbXN0cmF5QGdtYWlsLmNvbQo=`
