---
title: "Как верстальщику получить код ревью"
excerpt: "7 рекомендаций верстальщикам, которые хотят найти ревьювера для оценки своего кода"
description: "7 рекомендаций верстальщикам, которые хотят найти ревьювера для оценки своего кода"
created_at: 2016-02-13
kind: article
publish: true
disqusid: code_review
tags: [faq, code review]
og_image: '/i/og/og-paulradzkov-2016-code_review.png'
---

**По мотивам вопроса на тостере «[Где найти того, кто оценит твой код?](https://toster.ru/q/289819)»**

Упростите жизнь ревьюверам. Постарайтесь, чтобы оценка кода занимала у них как можно меньше времени, а отправлять комментарии и исправления было легко. Чем меньше усилий потребуется со стороны ревьювера, тем выше шанс получить код ревью.

<!-- cut -->

## Код — на Гитхабе

Отправлять почтой zip-архив и просить посмотреть — неудобно для ревьювера. Некоторые откажутся сразу. Кто-то согласится, но не сделает. У оставшихся возникнет проблема, в каком виде отправить вам комментарии и замечания назад.

Для маленьких и простых вещей делайте демку на [http://codepen.io](http://codepen.io) и похожих  сервисах. Открыть ссылку, посмотреть код и результат, форкнуть, исправить или оставить пару комментариев там не займет много времени. И даже не придется открывать текстовый редактор или IDE.

Сайты, одностраничники, свёрстанные макеты заливайте на [GitHub Pages](https://pages.github.com/). Для этого вам придется разобраться с git, но git вам точно понадобится. Код на GitHub удобно просматривать и оставлять комментарии к конкретным строкам, ссылаться на другие файлы и строки внутри них. Ревьювер может исправить ваш код, отправить исправления через pull request и прокомментировать, почему он так сделал. А вы увидите на одном экране старую версию кода, исправленную и комментарии к исправлениям.

К тому же, не покупая домен и хостинг, вы соберете себе портфолио на GitHub.

## Только готовые работы

Выставляйте на ревью готовые работы: когда вы сами уже исправили всё, что заметили, и улучшили всё, что могли. Иначе ревьювер найдёт несколько самых очевидных косяков и перестанет искать дальше. Решит, что «для начала достаточно», или выдаст резюме, что «тут совсем всё плохо» и «надо полностью переверстать». Вы потратите время другого человека и не получите пользы.

Если вас интересует мнение по поводу части какой-либо незаконченной работы, просите посмотреть конкретный файл с указанием номеров строк. А лучше сделайте изолированный пример на codepen.io, чтобы «сырой» код не отвлекал ревьювера. Чем меньше кода покажешь ревьюверу, тем внимательнее он его посмотрит.

## На ревью — по одному

Если у вас готово несколько работ, то на ревью их выставляйте по одной. Не просите посмотреть всё сразу. Вероятно, вы совершаете систематические ошибки, которые присутствуют во всех работах. Когда вам указали на ошибки в первой работе, исправляйте эти ошибки в остальных и только потом показывайте следующую работу ревьюверам. Так вы научитесь большему, написав меньше кода ~~и задолбав меньше ревьюверов~~.

А ещё уговорить кого-то посмотреть маленький кусочек кода проще, чем просить оценить сразу все ваши проекты.

## Сопроводительная информация

Ревьювер захочет узнать, как выглядит исходник дизайна, который вы сверстали, какие требования к вёрстке поставлены в техническом задании, поддержка браузеров и размеров экранов. Но ревьювер не захочет качать 100Мб исходников и рыться в длинном документе в поисках технических требований.

Кратко опишите требования, что и зачем вы делали, оставьте ссылку на скриншот дизайна.

## Задавайте конкретные вопросы

Помогите ревьюверу помочь вам. Укажите, в каких местах у вас возникли проблемы. Спрашивайте, если сомневаетесь в своих решениях. Отвечать на конкретные вопросы проще, чем на общие типа «всё ли в порядке с моей вёрсткой». Поверните обсуждение в нужное вам русло.

## Запаситесь скриншотами

Ревьювер посмотрит вёрстку в своём любимом браузере и вряд ли посмотрит в другом. Если у вас проблемы в каком-либо конкретном браузере, прикрепите скриншот проблемы или [сделайте гифку](http://paulradzkov.com/2014/capture_screen_to_gif/). Лучше один раз увидеть, чем пять раз перечитать описание.

## Где искать ревьюверов

Когда вам будет что показать, отправляйте ссылки на код знакомым и незнакомым профессионалам, оставляйте сообщения в профильных сообществах и на форумах. Например, на [http://htmlforum.ru](http://htmlforum.ru/) или [https://toster.ru](https://toster.ru).

## Итоги

Следование этим рекомендациям избавит ревьювера от лишней работы, упростит и ускорит процесс оценки кода. А вы получите конструктивные советы и замечания.

Покажите человеку, что вы цените его время, и тогда он захочет помочь вам.
