## Workshop 4

## Workshop Name: Resilient Automated Configuration Management 

## Description 

Use an existing static analysis tool to find security misconfigurations in Kubernetes configuration files 

## Targeted Courses 

Software Quality Assurance 

## Activities 

### Pre-lab Content Dissemination 

In our lecture we learned that now tools exist to mange configurations automatically. Once such tool is [Kubernetes](https://kubernetes.io/). With Kubernetes lot of clusters can be managed by automatically. Kubernetes uses configuration files called manifests that are executed using a tool called `kubectl`. These manifests are developed using a language called the Yet Another Markup Language, i.e., [YAML](https://yaml.org/). 

In this workshop we will use a tool called [SLI-KUBE](https://hub.docker.com/repository/docker/akondrahman/sli-kube) to find security misconfigurations. According to U.S. National Institute of Standards and Technology, (NIST)[https://www.nist.gov/], a security misconfiguration is `a setting within a computer program that violates a configuration policy or that permits unintended behavior that impacts the security posture of a system`. The goal of this workshop to understand how can we use a tool to identify security misconfigurations in Kubernetes manifests.  



### In-class Hands-on Experience 

- Install Docker on your computer 
- Run the following instructions one at a time to run the tool: 
  - docker rm $(docker ps -a -f status=exited -f status=created -q) [If you have Docker container instances needed for another course, please skip this command]
  - docker rmi -f $(docker images -a -q) [If you have Docker images needed for another course, please skip this command]
  - docker pull akondrahman/sli-kube 
  - docker images -a 
  - docker run --rm -it akondrahman/sli-kube bash 
  - cd SLI-KUBE-WORK/KubeSec-master/ 
  - `python3 main.py` or `python main.py`  
- Locate the output file generated by the tool in the `/SLI-KUBE-WORK` directory 
- The output file is a CSV file that has multiple columns. The first two columns correspond to the directory and the path of a Kubernetes configuration file. The rest corresponds to the count of instances for a specific category. We will use this count to determine the most three frequent ones. The `Total` column corresponds to the total instances of misconfigurations for a configuration file.  
- Recording of this hands-on experience is available on CANVAS 

### Post Lab Experience
- Run the tool for all Kubernetes manifests zipped in `w4.zip` 
  - First, copy the zip file to the container with `docker cp` 
  - Second, extract the zip file with [unzip](https://linuxize.com/post/how-to-unzip-files-in-linux/) or [unzip on Windows](https://gnuwin32.sourceforge.net/packages/unzip.htm)
  - Third, change `main.py` so that the extracted folder gets scanned with `SLI-KUBE`. 
  - Fourth, run `python3 main.py` or `python main.py`  
  - Fifth, copy the generated output file to your `own` computer/machine using `[docker cp](https://docs.docker.com/engine/reference/commandline/cp/)`.  
- Report the three most frequent security misconfigurations as determined by SLI-KUBE. Your report should include a 1-sentence description. Use `Section-2.3` from `paper.pdf`. 
    - If you get `NO_NETWORK_POLICY` then you can use the following text: `The misconfiguration category that is related with not specifying network policies. Without specifying network policies Kubernetes installations are susceptible to unauthorized accesses.`
    - If you get `NO_ROLLING_UPDATE` then you can use the following text: `The misconfiguration category that is related with not explicitly specifying RollingUpdate in the configuration file. A lack of rolling updates makes a Kubernetes installation susceptible to supply chain related attacks.`     
- Upload your report on `Workshop - SLIKUBE Usage for Configuration Scanning` @ CANVAS 
- Complete the [survey](https://auburn.qualtrics.com/jfe/form/SV_ekBpwjd4TkT1tpc)
- Due: Sep 27, 2024

#### Rubric 

- Report : 25%
- Definitions of security misconfigurations: 40%
- Names of security misconfigurations: 25% 
- Survey: 10%

#### Note About Windows Machines

It is possible to get the UnicodeDecode error for `parser.py` on a Windows machine.  
Replace the attached parser.py file in the `KubeSec-master` folder with the following code:
```
def loadMultiYAML( script_ ):
    dicts2ret = []
    with open(script_, constants.FILE_READ_FLAG  ) as yml_content :
        try:
            for d_ in yaml.safe_load_all(yml_content) :
                # print(d_)
                # print('='*25)
                dicts2ret.append( d_ )
        except yaml.YAMLError as exc:
            print( constants.YAML_SKIPPING_TEXT  )   
        except UnicodeDecodeError as err_:
            print( constants.YAML_SKIPPING_TEXT  )   
    return dicts2ret  
```

and 

```
def readYAMLAsStr( path_script ):
    yaml_as_str = constants.YAML_SKIPPING_TEXT
    with open( path_script , constants.FILE_READ_FLAG) as file_:
        try:
           yaml_as_str = file_.read() 
        except UnicodeDecodeError as err_:
            print( constants.YAML_SKIPPING_TEXT  )  
    return yaml_as_str
```