## Workshop 2

## Workshop Name: Requirements Validation with Test-driven Development 

## Description 

We will discuss and implement software requirements for a simple calculator app. 

## Targeted Courses 

Software Quality Assurance 

## Activities 

### Pre-lab Content Dissemination 

Requirements engineering is the process of discovering, analyzing, documenting and validating the requirements of the system. Each software development process goes through the phase of requirements engineering. Engineered requirements are often translated to software features through different software development methodologies, such as test driven development.    


#### Test-driven Development (TDD)

The steps for TDD is:

1. Your test fails 
2. Write code to fix your test 
3. Your test passes 
4. Refactor your test code 


### In-class Hands-on Experience 

- Navigate to `https://github.com/paser-group/continuous-secsoft/blob/master/fall2024/workshops/w2-req/`
- Apply test-driven development (TDD) to implement a subtraction operation for our simple calculator. We will use `unittest`. 
- Demo will be recorded and shared on CANVAS. 



### Assignment After Class (Post Lab Experience) 

- For this part of the workshop you will develop two Python program files to demonstrate that you have practiced test-driven development (TDD). 
- Your code should satisfy the following requirements:
  - The calculator must be able to multiply and divide
  - All methods related to division operations should handle division by zero exceptions
- Submit your Python program files and  your TEXT file on CANVAS @ `Workshop2` . The TEXT file should contain results of your tests that are passing and also the tests that are failing. 
- Complete survey: https://auburn.qualtrics.com/jfe/form/SV_556t0yGLahw3vVA
- Due: Sep 20, 2024, 11:59 PM CST 

### Rubric 

- Python source code [20%]
- Python test code [20%]
- Examples of test case failures [20%]
- Examples of test case successes [20%]
- Survey [20%]