"use strict";
(() => {
  var __create = Object.create;
  var __defProp = Object.defineProperty;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __getProtoOf = Object.getPrototypeOf;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __require = /* @__PURE__ */ ((x) => typeof require !== "undefined" ? require : typeof Proxy !== "undefined" ? new Proxy(x, {
    get: (a, b) => (typeof require !== "undefined" ? require : a)[b]
  }) : x)(function(x) {
    if (typeof require !== "undefined")
      return require.apply(this, arguments);
    throw new Error('Dynamic require of "' + x + '" is not supported');
  });
  var __esm = (fn, res) => function __init() {
    return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
  };
  var __commonJS = (cb, mod) => function __require2() {
    return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __export = (target, all) => {
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };
  var __copyProps = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames(from))
        if (!__hasOwnProp.call(to, key) && key !== except)
          __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
    // If the importer is in node compatibility mode or this is not an ESM
    // file that has been converted to a CommonJS file using a Babel-
    // compatible transform (i.e. "__esModule" has not been set), then set
    // "default" to the CommonJS "module.exports" for node compatibility.
    isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
    mod
  ));
  var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

  // node_modules/zotero-plugin-toolkit/dist/utils/debugBridge.js
  var require_debugBridge = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/utils/debugBridge.js"(exports) {
      "use strict";
      var __importDefault2 = exports && exports.__importDefault || function(mod) {
        return mod && mod.__esModule ? mod : { "default": mod };
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.DebugBridge = void 0;
      var basic_1 = require_basic();
      var toolkitGlobal_1 = __importDefault2(require_toolkitGlobal());
      var DebugBridge = class {
        get version() {
          return DebugBridge.version;
        }
        get disableDebugBridgePassword() {
          return this._disableDebugBridgePassword;
        }
        set disableDebugBridgePassword(value) {
          this._disableDebugBridgePassword = value;
        }
        get password() {
          return basic_1.BasicTool.getZotero().Prefs.get(DebugBridge.passwordPref, true);
        }
        set password(v) {
          basic_1.BasicTool.getZotero().Prefs.set(DebugBridge.passwordPref, v, true);
        }
        constructor() {
          this._disableDebugBridgePassword = false;
          this.initializeDebugBridge();
        }
        static setModule(instance) {
          var _a;
          if (!((_a = instance.debugBridge) === null || _a === void 0 ? void 0 : _a.version) || instance.debugBridge.version < DebugBridge.version) {
            instance.debugBridge = new DebugBridge();
          }
        }
        initializeDebugBridge() {
          const debugBridgeExtension = {
            noContent: true,
            doAction: async (uri) => {
              var _a;
              const Zotero2 = basic_1.BasicTool.getZotero();
              const uriString = uri.spec.split("//").pop();
              if (!uriString) {
                return;
              }
              const params = {};
              (_a = uriString.split("?").pop()) === null || _a === void 0 ? void 0 : _a.split("&").forEach((p) => {
                params[p.split("=")[0]] = p.split("=")[1];
              });
              if (toolkitGlobal_1.default.getInstance().debugBridge.disableDebugBridgePassword || params.password === this.password) {
                if (params.run) {
                  try {
                    const AsyncFunction = Object.getPrototypeOf(async function() {
                    }).constructor;
                    const f = new AsyncFunction("Zotero,window", decodeURIComponent(params.run));
                    await f(Zotero2, Zotero2.getMainWindow());
                  } catch (e) {
                    Zotero2.debug(e);
                    Zotero2.getMainWindow().console.log(e);
                  }
                }
                if (params.file) {
                  try {
                    Services.scriptloader.loadSubScript(decodeURIComponent(params.file), { Zotero: Zotero2, window: Zotero2.getMainWindow() });
                  } catch (e) {
                    Zotero2.debug(e);
                    Zotero2.getMainWindow().console.log(e);
                  }
                }
              }
            },
            newChannel: function(uri) {
              this.doAction(uri);
            }
          };
          Services.io.getProtocolHandler("zotero").wrappedJSObject._extensions["zotero://ztoolkit-debug"] = debugBridgeExtension;
        }
      };
      exports.DebugBridge = DebugBridge;
      DebugBridge.version = 1;
      DebugBridge.passwordPref = "extensions.zotero.debug-bridge.password";
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/managers/toolkitGlobal.js
  var require_toolkitGlobal = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/managers/toolkitGlobal.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ToolkitGlobal = void 0;
      var basic_1 = require_basic();
      var debugBridge_1 = require_debugBridge();
      var ToolkitGlobal = class {
        constructor() {
          initializeModules(this);
        }
        /**
         * Get the global unique instance of `class ToolkitGlobal`.
         * @returns An instance of `ToolkitGlobal`.
         */
        static getInstance() {
          const Zotero2 = basic_1.BasicTool.getZotero();
          if (!("_toolkitGlobal" in Zotero2)) {
            Zotero2._toolkitGlobal = new ToolkitGlobal();
          } else {
            initializeModules(Zotero2._toolkitGlobal);
          }
          return Zotero2._toolkitGlobal;
        }
      };
      exports.ToolkitGlobal = ToolkitGlobal;
      function initializeModules(instance) {
        setModule(instance, "fieldHooks", {
          _ready: false,
          getFieldHooks: {},
          setFieldHooks: {},
          isFieldOfBaseHooks: {}
        });
        setModule(instance, "itemTree", {
          _ready: false,
          columns: [],
          renderCellHooks: {}
        });
        setModule(instance, "itemBox", {
          _ready: false,
          fieldOptions: {}
        });
        setModule(instance, "shortcut", {
          _ready: false,
          eventKeys: []
        });
        setModule(instance, "prompt", {
          _ready: false,
          instance: void 0
        });
        setModule(instance, "readerInstance", {
          _ready: false,
          initializedHooks: {}
        });
        debugBridge_1.DebugBridge.setModule(instance);
      }
      function setModule(instance, key, module2) {
        var _a;
        var _b;
        if (!module2) {
          return;
        }
        if (!instance[key]) {
          instance[key] = module2;
        }
        for (const moduleKey in module2) {
          (_a = (_b = instance[key])[moduleKey]) !== null && _a !== void 0 ? _a : _b[moduleKey] = module2[moduleKey];
        }
      }
      exports.default = ToolkitGlobal;
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/basic.js
  var require_basic = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/basic.js"(exports) {
      "use strict";
      var __importDefault2 = exports && exports.__importDefault || function(mod) {
        return mod && mod.__esModule ? mod : { "default": mod };
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.unregister = exports.ManagerTool = exports.BasicTool = void 0;
      var toolkitGlobal_1 = __importDefault2(require_toolkitGlobal());
      var BasicTool2 = class {
        get basicOptions() {
          return this._basicOptions;
        }
        /**
         *
         * @param basicTool Pass an BasicTool instance to copy its options.
         */
        constructor(data) {
          this.patchSign = "zotero-plugin-toolkit@2.3.1";
          this._basicOptions = {
            log: {
              _type: "toolkitlog",
              disableConsole: false,
              disableZLog: false,
              prefix: ""
            },
            debug: toolkitGlobal_1.default.getInstance().debugBridge
          };
          this.updateOptions(data);
          return;
        }
        getGlobal(k) {
          const _Zotero = typeof Zotero !== "undefined" ? Zotero : Components.classes["@zotero.org/Zotero;1"].getService(Components.interfaces.nsISupports).wrappedJSObject;
          const window2 = _Zotero.getMainWindow();
          switch (k) {
            case "Zotero":
            case "zotero":
              return _Zotero;
            case "window":
              return window2;
            case "document":
              return window2.document;
            case "ZoteroPane":
            case "ZoteroPane_Local":
              return _Zotero.getActiveZoteroPane();
            default:
              return window2[k];
          }
        }
        /**
         * Check if it's running on Zotero 7 (Firefox 102)
         */
        isZotero7() {
          return Zotero.platformMajorVersion >= 102;
        }
        /**
         * Get DOMParser.
         *
         * For Zotero 6: mainWindow.DOMParser or nsIDOMParser
         *
         * For Zotero 7: Firefox 102 support DOMParser natively
         */
        getDOMParser() {
          if (this.isZotero7()) {
            return new (this.getGlobal("DOMParser"))();
          }
          try {
            return new (this.getGlobal("DOMParser"))();
          } catch (e) {
            return Components.classes["@mozilla.org/xmlextras/domparser;1"].createInstance(Components.interfaces.nsIDOMParser);
          }
        }
        /**
         * If it's an XUL element
         * @param elem
         */
        isXULElement(elem) {
          return elem.namespaceURI === "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
        }
        /**
         * Create an XUL element
         *
         * For Zotero 6, use `createElementNS`;
         *
         * For Zotero 7+, use `createXULElement`.
         * @param doc
         * @param type
         * @example
         * Create a `<menuitem>`:
         * ```ts
         * const compat = new ZoteroCompat();
         * const doc = compat.getWindow().document;
         * const elem = compat.createXULElement(doc, "menuitem");
         * ```
         */
        createXULElement(doc, type) {
          if (this.isZotero7()) {
            return doc.createXULElement(type);
          } else {
            return doc.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", type);
          }
        }
        /**
         * Output to both Zotero.debug and console.log
         * @param data e.g. string, number, object, ...
         */
        log(...data) {
          var _a;
          if (data.length === 0) {
            return;
          }
          const Zotero2 = this.getGlobal("Zotero");
          const console2 = this.getGlobal("console");
          let options;
          if (((_a = data[data.length - 1]) === null || _a === void 0 ? void 0 : _a._type) === "toolkitlog") {
            options = data.pop();
          } else {
            options = this._basicOptions.log;
          }
          try {
            if (options.prefix) {
              data.splice(0, 0, options.prefix);
            }
            if (!options.disableConsole) {
              console2.groupCollapsed(...data);
              console2.trace();
              console2.groupEnd();
            }
            if (!options.disableZLog) {
              Zotero2.debug(data.map((d) => {
                try {
                  return typeof d === "object" ? JSON.stringify(d) : String(d);
                } catch (e) {
                  Zotero2.debug(d);
                  return "";
                }
              }).join("\n"));
            }
          } catch (e) {
            console2.error(e);
            Zotero2.logError(e);
          }
        }
        /**
         * Patch a function
         * @param object The owner of the function
         * @param funcSign The signature of the function(function name)
         * @param ownerSign The signature of patch owner to avoid patching again
         * @param patcher The new wrapper of the patched funcion
         */
        patch(object, funcSign, ownerSign, patcher) {
          if (object[funcSign][ownerSign]) {
            throw new Error(`${String(funcSign)} re-patched`);
          }
          this.log("patching", funcSign, `by ${ownerSign}`);
          object[funcSign] = patcher(object[funcSign]);
          object[funcSign][ownerSign] = true;
        }
        updateOptions(source) {
          if (!source) {
            return;
          }
          if (source instanceof BasicTool2) {
            this._basicOptions = source._basicOptions;
          } else {
            this._basicOptions = source;
          }
        }
        static getZotero() {
          return typeof Zotero !== "undefined" ? Zotero : Components.classes["@zotero.org/Zotero;1"].getService(Components.interfaces.nsISupports).wrappedJSObject;
        }
      };
      exports.BasicTool = BasicTool2;
      var ManagerTool = class extends BasicTool2 {
      };
      exports.ManagerTool = ManagerTool;
      function unregister(tools) {
        Object.values(tools).forEach((tool) => {
          if (tool instanceof ManagerTool || typeof tool.unregisterAll === "function") {
            tool.unregisterAll();
          }
        });
      }
      exports.unregister = unregister;
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/tools/ui.js
  var require_ui = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/tools/ui.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.UITool = void 0;
      var basic_1 = require_basic();
      var UITool = class extends basic_1.BasicTool {
        get basicOptions() {
          return this._basicOptions;
        }
        constructor(base) {
          super(base);
          this.elementCache = [];
          if (!this._basicOptions.ui) {
            this._basicOptions.ui = {
              enableElementRecord: true,
              enableElementJSONLog: false,
              enableElementDOMLog: true
            };
          }
        }
        /**
         * Remove all elements created by `createElement`.
         *
         * @remarks
         * > What is this for?
         *
         * In bootstrap plugins, elements must be manually maintained and removed on exiting.
         *
         * This API does this for you.
         */
        unregisterAll() {
          this.elementCache.forEach((e) => {
            try {
              e === null || e === void 0 ? void 0 : e.remove();
            } catch (e2) {
              this.log(e2);
            }
          });
        }
        createElement(...args) {
          var _a, _b, _c;
          const doc = args[0];
          const tagName = args[1].toLowerCase();
          let props = args[2] || {};
          if (!tagName) {
            return;
          }
          if (typeof args[2] === "string") {
            props = {
              namespace: args[2],
              enableElementRecord: args[3]
            };
          }
          if (typeof props.enableElementJSONLog !== "undefined" && props.enableElementJSONLog || this.basicOptions.ui.enableElementJSONLog) {
            this.log(props);
          }
          props.properties = props.properties || props.directAttributes;
          props.children = props.children || props.subElementOptions;
          let elem;
          if (tagName === "fragment") {
            const fragElem = doc.createDocumentFragment();
            elem = fragElem;
          } else {
            let realElem = props.id && (props.checkExistenceParent ? props.checkExistenceParent : doc).querySelector(`#${props.id}`);
            if (realElem && props.ignoreIfExists) {
              return realElem;
            }
            if (realElem && props.removeIfExists) {
              realElem.remove();
              realElem = void 0;
            }
            if (props.customCheck && !props.customCheck(doc, props)) {
              return void 0;
            }
            if (!realElem || !props.skipIfExists) {
              let namespace = props.namespace;
              if (!namespace) {
                const mightHTML = HTMLElementTagNames.includes(tagName);
                const mightXUL = XULElementTagNames.includes(tagName);
                const mightSVG = SVGElementTagNames.includes(tagName);
                if (Number(mightHTML) + Number(mightXUL) + Number(mightSVG) > 1) {
                  this.log(`[Warning] Creating element ${tagName} with no namespace specified. Found multiply namespace matches.`);
                }
                if (mightHTML) {
                  namespace = "html";
                } else if (mightXUL) {
                  namespace = "xul";
                } else if (mightSVG) {
                  namespace = "svg";
                } else {
                  namespace = "html";
                }
              }
              if (namespace === "xul") {
                realElem = this.createXULElement(doc, tagName);
              } else {
                realElem = doc.createElementNS({
                  html: "http://www.w3.org/1999/xhtml",
                  svg: "http://www.w3.org/2000/svg"
                }[namespace], tagName);
              }
              this.elementCache.push(realElem);
            }
            if (props.id) {
              realElem.id = props.id;
            }
            if (props.styles && Object.keys(props.styles).length) {
              Object.keys(props.styles).forEach((k) => {
                const v = props.styles[k];
                typeof v !== "undefined" && (realElem.style[k] = v);
              });
            }
            if (props.properties && Object.keys(props.properties).length) {
              Object.keys(props.properties).forEach((k) => {
                const v = props.properties[k];
                typeof v !== "undefined" && (realElem[k] = v);
              });
            }
            if (props.attributes && Object.keys(props.attributes).length) {
              Object.keys(props.attributes).forEach((k) => {
                const v = props.attributes[k];
                typeof v !== "undefined" && realElem.setAttribute(k, String(v));
              });
            }
            if ((_a = props.classList) === null || _a === void 0 ? void 0 : _a.length) {
              realElem.classList.add(...props.classList);
            }
            if ((_b = props.listeners) === null || _b === void 0 ? void 0 : _b.length) {
              props.listeners.forEach(({ type, listener, options }) => {
                listener && realElem.addEventListener(type, listener, options);
              });
            }
            elem = realElem;
          }
          if ((_c = props.children) === null || _c === void 0 ? void 0 : _c.length) {
            const subElements = props.children.map((childProps) => {
              childProps.namespace = childProps.namespace || props.namespace;
              return this.createElement(doc, childProps.tag, childProps);
            }).filter((e) => e);
            elem.append(...subElements);
          }
          if (typeof props.enableElementDOMLog !== "undefined" && props.enableElementDOMLog || this.basicOptions.ui.enableElementDOMLog) {
            this.log(elem);
          }
          return elem;
        }
        /**
         * Append element(s) to a node.
         * @param properties See {@link ElementProps}
         * @param container The parent node to append to.
         * @returns A Node that is the appended child (aChild),
         *          except when aChild is a DocumentFragment,
         *          in which case the empty DocumentFragment is returned.
         */
        appendElement(properties, container) {
          return container.appendChild(this.createElement(container.ownerDocument, properties.tag, properties));
        }
        /**
         * Inserts a node before a reference node as a child of its parent node.
         * @param properties See {@link ElementProps}
         * @param referenceNode The node before which newNode is inserted.
         * @returns
         */
        insertElementBefore(properties, referenceNode) {
          if (referenceNode.parentNode)
            return referenceNode.parentNode.insertBefore(this.createElement(referenceNode.ownerDocument, properties.tag, properties), referenceNode);
          else
            this.log(referenceNode.tagName + " has no parent, cannot insert " + properties.tag);
        }
        /**
         * Replace oldNode with a new one.
         * @param properties See {@link ElementProps}
         * @param oldNode The child to be replaced.
         * @returns The replaced Node. This is the same node as oldChild.
         */
        replaceElement(properties, oldNode) {
          if (oldNode.parentNode)
            return oldNode.parentNode.replaceChild(this.createElement(oldNode.ownerDocument, properties.tag, properties), oldNode);
          else
            this.log(oldNode.tagName + " has no parent, cannot replace it with " + properties.tag);
        }
        /**
         * Parse XHTML to XUL fragment. For Zotero 6.
         *
         * To load preferences from a Zotero 7's `.xhtml`, use this method to parse it.
         * @param str xhtml raw text
         * @param entities dtd file list ("chrome://xxx.dtd")
         * @param defaultXUL true for default XUL namespace
         */
        parseXHTMLToFragment(str, entities = [], defaultXUL = true) {
          let parser = this.getDOMParser();
          const xulns = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
          const htmlns = "http://www.w3.org/1999/xhtml";
          const wrappedStr = `${entities.length ? `<!DOCTYPE bindings [ ${entities.reduce((preamble, url, index) => {
            return preamble + `<!ENTITY % _dtd-${index} SYSTEM "${url}"> %_dtd-${index}; `;
          }, "")}]>` : ""}
      <html:div xmlns="${defaultXUL ? xulns : htmlns}"
          xmlns:xul="${xulns}" xmlns:html="${htmlns}">
      ${str}
      </html:div>`;
          this.log(wrappedStr, parser);
          let doc = parser.parseFromString(wrappedStr, "text/xml");
          this.log(doc);
          if (doc.documentElement.localName === "parsererror") {
            throw new Error("not well-formed XHTML");
          }
          let range = doc.createRange();
          range.selectNodeContents(doc.querySelector("div"));
          return range.extractContents();
        }
      };
      exports.UITool = UITool;
      var HTMLElementTagNames = [
        "a",
        "abbr",
        "address",
        "area",
        "article",
        "aside",
        "audio",
        "b",
        "base",
        "bdi",
        "bdo",
        "blockquote",
        "body",
        "br",
        "button",
        "canvas",
        "caption",
        "cite",
        "code",
        "col",
        "colgroup",
        "data",
        "datalist",
        "dd",
        "del",
        "details",
        "dfn",
        "dialog",
        "div",
        "dl",
        "dt",
        "em",
        "embed",
        "fieldset",
        "figcaption",
        "figure",
        "footer",
        "form",
        "h1",
        "h2",
        "h3",
        "h4",
        "h5",
        "h6",
        "head",
        "header",
        "hgroup",
        "hr",
        "html",
        "i",
        "iframe",
        "img",
        "input",
        "ins",
        "kbd",
        "label",
        "legend",
        "li",
        "link",
        "main",
        "map",
        "mark",
        "menu",
        "meta",
        "meter",
        "nav",
        "noscript",
        "object",
        "ol",
        "optgroup",
        "option",
        "output",
        "p",
        "picture",
        "pre",
        "progress",
        "q",
        "rp",
        "rt",
        "ruby",
        "s",
        "samp",
        "script",
        "section",
        "select",
        "slot",
        "small",
        "source",
        "span",
        "strong",
        "style",
        "sub",
        "summary",
        "sup",
        "table",
        "tbody",
        "td",
        "template",
        "textarea",
        "tfoot",
        "th",
        "thead",
        "time",
        "title",
        "tr",
        "track",
        "u",
        "ul",
        "var",
        "video",
        "wbr"
      ];
      var XULElementTagNames = [
        "action",
        "arrowscrollbox",
        "bbox",
        "binding",
        "bindings",
        "box",
        "broadcaster",
        "broadcasterset",
        "button",
        "browser",
        "checkbox",
        "caption",
        "colorpicker",
        "column",
        "columns",
        "commandset",
        "command",
        "conditions",
        "content",
        "deck",
        "description",
        "dialog",
        "dialogheader",
        "editor",
        "grid",
        "grippy",
        "groupbox",
        "hbox",
        "iframe",
        "image",
        "key",
        "keyset",
        "label",
        "listbox",
        "listcell",
        "listcol",
        "listcols",
        "listhead",
        "listheader",
        "listitem",
        "member",
        "menu",
        "menubar",
        "menuitem",
        "menulist",
        "menupopup",
        "menuseparator",
        "observes",
        "overlay",
        "page",
        "popup",
        "popupset",
        "preference",
        "preferences",
        "prefpane",
        "prefwindow",
        "progressmeter",
        "radio",
        "radiogroup",
        "resizer",
        "richlistbox",
        "richlistitem",
        "row",
        "rows",
        "rule",
        "script",
        "scrollbar",
        "scrollbox",
        "scrollcorner",
        "separator",
        "spacer",
        "splitter",
        "stack",
        "statusbar",
        "statusbarpanel",
        "stringbundle",
        "stringbundleset",
        "tab",
        "tabbrowser",
        "tabbox",
        "tabpanel",
        "tabpanels",
        "tabs",
        "template",
        "textnode",
        "textbox",
        "titlebar",
        "toolbar",
        "toolbarbutton",
        "toolbargrippy",
        "toolbaritem",
        "toolbarpalette",
        "toolbarseparator",
        "toolbarset",
        "toolbarspacer",
        "toolbarspring",
        "toolbox",
        "tooltip",
        "tree",
        "treecell",
        "treechildren",
        "treecol",
        "treecols",
        "treeitem",
        "treerow",
        "treeseparator",
        "triple",
        "vbox",
        "window",
        "wizard",
        "wizardpage"
      ];
      var SVGElementTagNames = [
        "a",
        "animate",
        "animateMotion",
        "animateTransform",
        "circle",
        "clipPath",
        "defs",
        "desc",
        "ellipse",
        "feBlend",
        "feColorMatrix",
        "feComponentTransfer",
        "feComposite",
        "feConvolveMatrix",
        "feDiffuseLighting",
        "feDisplacementMap",
        "feDistantLight",
        "feDropShadow",
        "feFlood",
        "feFuncA",
        "feFuncB",
        "feFuncG",
        "feFuncR",
        "feGaussianBlur",
        "feImage",
        "feMerge",
        "feMergeNode",
        "feMorphology",
        "feOffset",
        "fePointLight",
        "feSpecularLighting",
        "feSpotLight",
        "feTile",
        "feTurbulence",
        "filter",
        "foreignObject",
        "g",
        "image",
        "line",
        "linearGradient",
        "marker",
        "mask",
        "metadata",
        "mpath",
        "path",
        "pattern",
        "polygon",
        "polyline",
        "radialGradient",
        "rect",
        "script",
        "set",
        "stop",
        "style",
        "svg",
        "switch",
        "symbol",
        "text",
        "textPath",
        "title",
        "tspan",
        "use",
        "view"
      ];
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/tools/reader.js
  var require_reader = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/tools/reader.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ReaderTool = void 0;
      var basic_1 = require_basic();
      var ReaderTool = class extends basic_1.BasicTool {
        /**
         * Get the selected tab reader.
         * @param waitTime Wait for n MS until the reader is ready
         */
        async getReader(waitTime = 5e3) {
          const Zotero_Tabs2 = this.getGlobal("Zotero_Tabs");
          if (Zotero_Tabs2.selectedType !== "reader") {
            return void 0;
          }
          let reader = Zotero.Reader.getByTabID(Zotero_Tabs2.selectedID);
          let delayCount = 0;
          const checkPeriod = 50;
          while (!reader && delayCount * checkPeriod < waitTime) {
            await Zotero.Promise.delay(checkPeriod);
            reader = Zotero.Reader.getByTabID(Zotero_Tabs2.selectedID);
            delayCount++;
          }
          await (reader === null || reader === void 0 ? void 0 : reader._initPromise);
          return reader;
        }
        /**
         * Get all window readers.
         */
        getWindowReader() {
          const Zotero_Tabs2 = this.getGlobal("Zotero_Tabs");
          let windowReaders = [];
          let tabs = Zotero_Tabs2._tabs.map((e) => e.id);
          for (let i = 0; i < Zotero.Reader._readers.length; i++) {
            let flag = false;
            for (let j = 0; j < tabs.length; j++) {
              if (Zotero.Reader._readers[i].tabID == tabs[j]) {
                flag = true;
                break;
              }
            }
            if (!flag) {
              windowReaders.push(Zotero.Reader._readers[i]);
            }
          }
          return windowReaders;
        }
        /**
         * Get Reader tabpanel deck element.
         * @alpha
         */
        getReaderTabPanelDeck() {
          var _a;
          const deck = (_a = this.getGlobal("window").document.querySelector(".notes-pane-deck")) === null || _a === void 0 ? void 0 : _a.previousElementSibling;
          return deck;
        }
        /**
         * Add a reader tabpanel deck selection change observer.
         * @alpha
         * @param callback
         */
        addReaderTabPanelDeckObserver(callback) {
          const deck = this.getReaderTabPanelDeck();
          const observer = new (this.getGlobal("MutationObserver"))(async (mutations) => {
            mutations.forEach(async (mutation) => {
              const target = mutation.target;
              if (target.classList.contains("zotero-view-tabbox") || target.tagName === "deck") {
                callback();
              }
            });
          });
          observer.observe(deck, {
            attributes: true,
            attributeFilter: ["selectedIndex"],
            subtree: true
          });
          return observer;
        }
        /**
         * Get the text selection of reader.
         * @param currentReader Target reader
         */
        getSelectedText(currentReader) {
          var _a;
          if (!currentReader) {
            return "";
          }
          let textArea = (_a = currentReader._iframeWindow) === null || _a === void 0 ? void 0 : _a.document.querySelectorAll("textarea");
          if (!textArea) {
            return "";
          }
          for (let i = 0; i < textArea.length; i++) {
            if (textArea[i].style.zIndex === "-1" && textArea[i].style["width"] === "0px") {
              return textArea[i].value.replace(/(^\s*)|(\s*$)/g, "");
            }
          }
          return "";
        }
      };
      exports.ReaderTool = ReaderTool;
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/tools/extraField.js
  var require_extraField = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/tools/extraField.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ExtraFieldTool = void 0;
      var basic_1 = require_basic();
      var ExtraFieldTool = class extends basic_1.BasicTool {
        /**
         * Get all extra fields
         * @param item
         */
        getExtraFields(item, backend = "custom") {
          const extraFiledRaw = item.getField("extra");
          if (backend === "default") {
            return this.getGlobal("Zotero").Utilities.Internal.extractExtraFields(extraFiledRaw).fields;
          } else {
            const map = /* @__PURE__ */ new Map();
            extraFiledRaw.split("\n").forEach((line) => {
              const split = line.split(": ");
              if (split.length >= 2 && split[0]) {
                map.set(split[0], split.slice(1).join(": "));
              }
            });
            return map;
          }
        }
        /**
         * Get extra field value by key. If it does not exists, return undefined.
         * @param item
         * @param key
         */
        getExtraField(item, key) {
          const fields = this.getExtraFields(item);
          return fields.get(key);
        }
        /**
         * Replace extra field of an item.
         * @param item
         * @param fields
         */
        async replaceExtraFields(item, fields) {
          let kvs = [];
          fields.forEach((v, k) => {
            kvs.push(`${k}: ${v}`);
          });
          item.setField("extra", kvs.join("\n"));
          await item.saveTx();
        }
        /**
         * Set an key-value pair to the item's extra field
         * @param item
         * @param key
         * @param value
         */
        async setExtraField(item, key, value) {
          const fields = this.getExtraFields(item);
          fields.set(key, value);
          await this.replaceExtraFields(item, fields);
        }
      };
      exports.ExtraFieldTool = ExtraFieldTool;
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/managers/fieldHook.js
  var require_fieldHook = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/managers/fieldHook.js"(exports) {
      "use strict";
      var __importDefault2 = exports && exports.__importDefault || function(mod) {
        return mod && mod.__esModule ? mod : { "default": mod };
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FieldHookManager = void 0;
      var basic_1 = require_basic();
      var toolkitGlobal_1 = __importDefault2(require_toolkitGlobal());
      var FieldHookManager = class extends basic_1.ManagerTool {
        constructor(base) {
          super(base);
          this.localCache = [];
          this.initializeGlobal();
        }
        register(type, field, hook) {
          let hooks = this.getHooksFactory(type);
          if (!hooks) {
            return;
          }
          if (field in hooks) {
            this.log(`[WARNING] ${type}.${field} overwrites an existing hook.`);
          }
          hooks[field] = hook;
          this.localCache.push({ type, field });
        }
        unregister(type, field) {
          let hooks = this.getHooksFactory(type);
          if (hooks) {
            delete hooks[field];
          }
          const idx = this.localCache.findIndex(({ type: cacheType }) => cacheType === type);
          if (idx > -1) {
            this.localCache.splice(idx, 1);
          }
        }
        unregisterAll() {
          [...this.localCache].forEach((cache) => {
            this.unregister(cache.type, cache.field);
          });
        }
        getHooksFactory(type) {
          switch (type) {
            case "getField":
              const globalItemTree = toolkitGlobal_1.default.getInstance().itemTree;
              const deprecatedHooks = globalItemTree.fieldHooks;
              if (deprecatedHooks && deprecatedHooks !== this.globalCache.getFieldHooks) {
                Object.assign(this.globalCache.getFieldHooks, deprecatedHooks);
                globalItemTree.fieldHooks = this.globalCache.getFieldHooks;
              }
              return this.globalCache.getFieldHooks;
              break;
            case "setField":
              return this.globalCache.setFieldHooks;
              break;
            case "isFieldOfBase":
              return this.globalCache.isFieldOfBaseHooks;
              break;
            default:
              break;
          }
        }
        initializeGlobal() {
          const Zotero2 = this.getGlobal("Zotero");
          const globalCache = this.globalCache = toolkitGlobal_1.default.getInstance().fieldHooks;
          if (!this.globalCache._ready) {
            this.globalCache._ready = true;
            this.patch(Zotero2.Item.prototype, "getField", this.patchSign, (original) => function(field, unformatted, includeBaseMapped) {
              const originalThis = this;
              if (Object.keys(globalCache.getFieldHooks).includes(field)) {
                try {
                  const hook = globalCache.getFieldHooks[field];
                  return hook(field, unformatted, includeBaseMapped, originalThis, original.bind(originalThis));
                } catch (e) {
                  return field + String(e);
                }
              }
              return original.apply(originalThis, arguments);
            });
            this.patch(Zotero2.Item.prototype, "setField", this.patchSign, (original) => function(field, value, loadIn) {
              const originalThis = this;
              if (Object.keys(globalCache.setFieldHooks).includes(field)) {
                try {
                  const hook = globalCache.setFieldHooks[field];
                  return hook(field, value, loadIn, originalThis, original.bind(originalThis));
                } catch (e) {
                  return field + String(e);
                }
              }
              return original.apply(originalThis, arguments);
            });
            this.patch(Zotero2.ItemFields, "isFieldOfBase", this.patchSign, (original) => function(field, baseField) {
              const originalThis = this;
              if (Object.keys(globalCache.isFieldOfBaseHooks).includes(field)) {
                try {
                  const hook = globalCache.isFieldOfBaseHooks[field];
                  return hook(field, baseField, original.bind(originalThis));
                } catch (e) {
                  return false;
                }
              }
              return original.apply(originalThis, arguments);
            });
          }
        }
      };
      exports.FieldHookManager = FieldHookManager;
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/managers/itemTree.js
  var require_itemTree = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/managers/itemTree.js"(exports) {
      "use strict";
      var __importDefault2 = exports && exports.__importDefault || function(mod) {
        return mod && mod.__esModule ? mod : { "default": mod };
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ItemTreeManager = void 0;
      var basic_1 = require_basic();
      var fieldHook_1 = require_fieldHook();
      var toolkitGlobal_1 = __importDefault2(require_toolkitGlobal());
      var ItemTreeManager = class extends basic_1.ManagerTool {
        /**
         * Initialize Zotero._ItemTreeExtraColumnsGlobal if it doesn't exist.
         *
         * New columns and hooks are stored there.
         *
         * Then patch `require("zotero/itemTree").getColumns` and `Zotero.Item.getField`
         */
        constructor(base) {
          super(base);
          this.localColumnCache = [];
          this.localRenderCellCache = [];
          this.fieldHooks = new fieldHook_1.FieldHookManager(base);
          this.initializationLock = this.getGlobal("Zotero").Promise.defer();
          this.initializeGlobal();
        }
        unregisterAll() {
          [...this.localColumnCache].forEach((key) => this.unregister(key, { skipGetField: true }));
          [...this.localRenderCellCache].forEach(this.removeRenderCellHook.bind(this));
          this.fieldHooks.unregisterAll();
        }
        /**
         * Register a new column. Don't forget to call `unregister` on plugin exit.
         * @param key Column dataKey
         * @param label Column display label
         * @param getFieldHook Called when loading cell content.
         * If you registered the getField hook somewhere else (in ItemBox or FieldHooks), leave it undefined.
         * @param options See zotero source code:chrome/content/zotero/itemTreeColumns.jsx
         * @param options.renderCellHook Called when rendering cell. This will override
         *
         * @example
         * ```ts
         * const itemTree = new ItemTreeTool();
         * await itemTree.register(
         *   "test",
         *   "new column",
         *   (
         *     field: string,
         *     unformatted: boolean,
         *     includeBaseMapped: boolean,
         *     item: Zotero.Item
         *   ) => {
         *     return field + String(item.id);
         *   },
         *   {
         *     iconPath: "chrome://zotero/skin/cross.png",
         *   }
         * );
         * ```
         */
        async register(key, label, getFieldHook, options = {}) {
          await this.initializationLock.promise;
          if (this.globalCache.columns.map((_c) => _c.dataKey).includes(key)) {
            this.log(`ItemTreeTool: ${key} is already registered.`);
            return;
          }
          const column = {
            dataKey: key,
            label,
            iconLabel: options.iconPath ? this.createIconLabel({
              iconPath: options.iconPath,
              name: label
            }) : void 0,
            zoteroPersist: options.zoteroPersist || /* @__PURE__ */ new Set(["width", "ordinal", "hidden", "sortActive", "sortDirection"]),
            defaultIn: options.defaultIn,
            disabledIn: options.disabledIn,
            defaultSort: options.defaultSort,
            flex: typeof options.flex === "undefined" ? 1 : options.flex,
            width: options.width,
            fixedWidth: options.fixedWidth,
            staticWidth: options.staticWidth,
            minWidth: options.minWidth,
            ignoreInColumnPicker: options.ignoreInColumnPicker,
            submenu: options.submenu
          };
          if (getFieldHook) {
            this.fieldHooks.register("getField", key, getFieldHook);
          }
          if (options.renderCellHook) {
            await this.addRenderCellHook(key, options.renderCellHook);
          }
          this.globalCache.columns.push(column);
          this.localColumnCache.push(column.dataKey);
          await this.refresh();
        }
        /**
         * Unregister an extra column. Call it on plugin exit.
         * @param key Column dataKey, should be same as the one used in `register`
         * @param options.skipGetField skip unregister of getField hook.
         * This is useful when the hook is not initialized by this instance
         */
        async unregister(key, options = {}) {
          const Zotero2 = this.getGlobal("Zotero");
          await this.initializationLock.promise;
          let persisted = Zotero2.Prefs.get("pane.persist");
          const persistedJSON = JSON.parse(persisted);
          delete persistedJSON[key];
          Zotero2.Prefs.set("pane.persist", JSON.stringify(persistedJSON));
          const idx = this.globalCache.columns.map((_c) => _c.dataKey).indexOf(key);
          if (idx >= 0) {
            this.globalCache.columns.splice(idx, 1);
          }
          if (!options.skipGetField) {
            this.fieldHooks.unregister("getField", key);
          }
          this.removeRenderCellHook(key);
          await this.refresh();
          const localKeyIdx = this.localColumnCache.indexOf(key);
          if (localKeyIdx >= 0) {
            this.localColumnCache.splice(localKeyIdx, 1);
          }
        }
        /**
         * Add a patch hook for `_renderCell`, which is called when cell is rendered.
         *
         * This also works for Zotero's built-in cells.
         * @remarks
         * Don't call it manually unless you understand what you are doing.
         * @param dataKey Cell `dataKey`, e.g. 'title'
         * @param renderCellHook patch hook
         */
        async addRenderCellHook(dataKey, renderCellHook) {
          await this.initializationLock.promise;
          if (dataKey in this.globalCache.renderCellHooks) {
            this.log("[WARNING] ItemTreeTool.addRenderCellHook overwrites an existing hook:", dataKey);
          }
          this.globalCache.renderCellHooks[dataKey] = renderCellHook;
          this.localRenderCellCache.push(dataKey);
        }
        /**
         * Remove a patch hook by `dataKey`.
         */
        async removeRenderCellHook(dataKey) {
          delete this.globalCache.renderCellHooks[dataKey];
          const idx = this.localRenderCellCache.indexOf(dataKey);
          if (idx >= 0) {
            this.localRenderCellCache.splice(idx, 1);
          }
          await this.refresh();
        }
        /**
         * Do initializations. Called in constructor to be async
         */
        async initializeGlobal() {
          const Zotero2 = this.getGlobal("Zotero");
          await Zotero2.uiReadyPromise;
          const window2 = this.getGlobal("window");
          const globalCache = this.globalCache = toolkitGlobal_1.default.getInstance().itemTree;
          if (!globalCache._ready) {
            globalCache._ready = true;
            const itemTree = window2.require("zotero/itemTree");
            this.patch(itemTree.prototype, "getColumns", this.patchSign, (original) => function() {
              const columns = original.apply(this, arguments);
              const insertAfter = columns.findIndex((column) => column.dataKey === "title");
              columns.splice(insertAfter + 1, 0, ...globalCache.columns);
              return columns;
            });
            this.patch(itemTree.prototype, "_renderCell", this.patchSign, (original) => function(index, data, column) {
              if (!(column.dataKey in globalCache.renderCellHooks)) {
                return original.apply(this, arguments);
              }
              const hook = globalCache.renderCellHooks[column.dataKey];
              const elem = hook(index, data, column, original.bind(this));
              if (elem.classList.contains("cell")) {
                return elem;
              }
              const span = window2.document.createElementNS("http://www.w3.org/1999/xhtml", "span");
              span.classList.add("cell", column.dataKey, `${column.dataKey}-item-tree-main-default`);
              if (column.fixedWidth) {
                span.classList.add("fixed-width");
              }
              span.appendChild(elem);
              return span;
            });
          }
          this.initializationLock.resolve();
        }
        /**
         * Create a React Icon element
         * @param props
         */
        createIconLabel(props) {
          const _React = window.require("react");
          return _React.createElement("span", null, _React.createElement("img", {
            src: props.iconPath,
            height: "10px",
            width: "9px",
            style: {
              "margin-left": "6px"
            }
          }), " ", props.name);
        }
        /**
         * Refresh itemView. You don't need to call it manually.
         */
        async refresh() {
          var _a, _b;
          await this.initializationLock.promise;
          const ZoteroPane2 = this.getGlobal("ZoteroPane");
          ZoteroPane2.itemsView._columnsId = null;
          const virtualizedTable = (_a = ZoteroPane2.itemsView.tree) === null || _a === void 0 ? void 0 : _a._columns;
          if (!virtualizedTable) {
            this.log("ItemTree is still loading. Refresh skipped.");
            return;
          }
          (_b = document.querySelector(`.${virtualizedTable._styleKey}`)) === null || _b === void 0 ? void 0 : _b.remove();
          await ZoteroPane2.itemsView.refreshAndMaintainSelection();
          ZoteroPane2.itemsView.tree._columns = new virtualizedTable.__proto__.constructor(ZoteroPane2.itemsView.tree);
          await ZoteroPane2.itemsView.refreshAndMaintainSelection();
        }
      };
      exports.ItemTreeManager = ItemTreeManager;
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/managers/prompt.js
  var require_prompt = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/managers/prompt.js"(exports) {
      "use strict";
      var __importDefault2 = exports && exports.__importDefault || function(mod) {
        return mod && mod.__esModule ? mod : { "default": mod };
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.PromptManager = exports.Prompt = void 0;
      var basic_1 = require_basic();
      var basic_2 = require_basic();
      var ui_1 = require_ui();
      var toolkitGlobal_1 = __importDefault2(require_toolkitGlobal());
      var Prompt = class {
        /**
         * Initialize `Prompt` but do not create UI.
         */
        constructor() {
          this.lastInputText = "";
          this.defaultText = {
            placeholder: "Select a command...",
            empty: "No commands found."
          };
          this.maxLineNum = 12;
          this.maxSuggestionNum = 100;
          this.commands = [];
          this.base = new basic_1.BasicTool();
          this.ui = new ui_1.UITool();
          this.document = this.base.getGlobal("document");
          this.initializeUI();
        }
        /**
         * Initialize `Prompt` UI and then bind events on it.
         */
        initializeUI() {
          this.addStyle();
          this.createHTML();
          this.initInputEvents();
          this.registerShortcut();
        }
        createHTML() {
          this.promptNode = this.ui.createElement(this.document, "div", {
            styles: {
              display: "none"
            },
            children: [
              {
                tag: "div",
                styles: {
                  position: "fixed",
                  left: "0",
                  top: "0",
                  backgroundColor: "rgba(220, 220, 220, 0.4)",
                  width: "100%",
                  height: "100%",
                  opacity: "0.5"
                },
                listeners: [
                  {
                    type: "click",
                    listener: () => {
                      this.promptNode.style.display = "none";
                    }
                  }
                ]
              }
            ]
          });
          this.promptNode.appendChild(this.ui.createElement(this.document, "div", {
            id: `zotero-plugin-toolkit-prompt`,
            classList: ["prompt-container"],
            children: [
              {
                tag: "div",
                classList: ["input-container"],
                children: [
                  {
                    tag: "input",
                    classList: ["prompt-input"],
                    attributes: {
                      type: "text",
                      placeholder: this.defaultText.placeholder
                    }
                  },
                  {
                    tag: "div",
                    classList: ["cta"]
                  }
                ]
              },
              {
                tag: "div",
                classList: ["commands-containers"]
              },
              {
                tag: "div",
                classList: ["instructions"],
                children: [
                  {
                    tag: "div",
                    classList: ["instruction"],
                    children: [
                      {
                        tag: "span",
                        classList: ["key"],
                        properties: {
                          innerText: "\u2191\u2193"
                        }
                      },
                      {
                        tag: "span",
                        properties: {
                          innerText: "to navigate"
                        }
                      }
                    ]
                  },
                  {
                    tag: "div",
                    classList: ["instruction"],
                    children: [
                      {
                        tag: "span",
                        classList: ["key"],
                        properties: {
                          innerText: "enter"
                        }
                      },
                      {
                        tag: "span",
                        properties: {
                          innerText: "to trigger"
                        }
                      }
                    ]
                  },
                  {
                    tag: "div",
                    classList: ["instruction"],
                    children: [
                      {
                        tag: "span",
                        classList: ["key"],
                        properties: {
                          innerText: "esc"
                        }
                      },
                      {
                        tag: "span",
                        properties: {
                          innerText: "to exit"
                        }
                      }
                    ]
                  }
                ]
              }
            ]
          }));
          this.inputNode = this.promptNode.querySelector("input");
          this.document.documentElement.appendChild(this.promptNode);
        }
        /**
         * Show commands in a new `commandsContainer`
         * All other `commandsContainer` is hidden
         * @param commands Command[]
         * @param clear remove all `commandsContainer` if true
         */
        showCommands(commands, clear = false) {
          if (clear) {
            this.promptNode.querySelectorAll(".commands-container").forEach((e) => e.remove());
          }
          this.inputNode.placeholder = this.defaultText.placeholder;
          const commandsContainer = this.createCommandsContainer();
          for (let command of commands) {
            if (!command.name || command.when && !command.when()) {
              continue;
            }
            commandsContainer.appendChild(this.createCommandNode(command));
          }
        }
        /**
         * Create a `commandsContainer` div element, append to `commandsContainer` and hide others.
         * @returns commandsNode
         */
        createCommandsContainer() {
          const commandsContainer = this.ui.createElement(this.document, "div", {
            classList: ["commands-container"]
          });
          this.promptNode.querySelectorAll(".commands-container").forEach((e) => {
            e.style.display = "none";
          });
          this.promptNode.querySelector(".commands-containers").appendChild(commandsContainer);
          return commandsContainer;
        }
        /**
         * Return current displayed `commandsContainer`
         * @returns
         */
        getCommandsContainer() {
          return [...this.promptNode.querySelectorAll(".commands-container")].find((e) => {
            return e.style.display != "none";
          });
        }
        /**
         * Create a command item for `Prompt` UI.
         * @param command
         * @returns
         */
        createCommandNode(command) {
          const commandNode = this.ui.createElement(this.document, "div", {
            classList: ["command"],
            children: [
              {
                tag: "div",
                classList: ["content"],
                children: [
                  {
                    tag: "div",
                    classList: ["name"],
                    children: [
                      {
                        tag: "span",
                        properties: {
                          innerText: command.name
                        }
                      }
                    ]
                  },
                  {
                    tag: "div",
                    classList: ["aux"],
                    children: command.label ? [
                      {
                        tag: "span",
                        classList: ["label"],
                        properties: {
                          innerText: command.label
                        }
                      }
                    ] : []
                  }
                ]
              }
            ],
            listeners: [
              {
                type: "mousemove",
                listener: () => {
                  this.selectItem(commandNode);
                }
              },
              {
                type: "click",
                listener: async () => {
                  await this.execCallback(command.callback);
                }
              }
            ]
          });
          commandNode.command = command;
          return commandNode;
        }
        /**
         * Called when `enter` key is pressed.
         */
        trigger() {
          [...this.promptNode.querySelectorAll(".commands-container")].find((e) => e.style.display != "none").querySelector(".selected").click();
        }
        /**
         * Called when `escape` key is pressed.
         */
        exit() {
          this.inputNode.placeholder = this.defaultText.placeholder;
          if (this.promptNode.querySelectorAll(".commands-containers .commands-container").length >= 2) {
            this.promptNode.querySelector(".commands-container:last-child").remove();
            const commandsContainer = this.promptNode.querySelector(".commands-container:last-child");
            commandsContainer.style.display = "";
            commandsContainer.querySelectorAll(".commands").forEach((e) => e.style.display = "flex");
            this.inputNode.focus();
          } else {
            this.promptNode.style.display = "none";
          }
        }
        async execCallback(callback) {
          if (Array.isArray(callback)) {
            this.showCommands(callback);
          } else {
            await callback(this);
          }
        }
        /**
         * Match suggestions for user's entered text.
         */
        async showSuggestions(inputText) {
          var _w = /[\u2000-\u206F\u2E00-\u2E7F\\'!"#$%&()*+,\-.\/:;<=>?@\[\]^_`{|}~]/, jw = /\s/, Ww = /[\u0F00-\u0FFF\u3040-\u30ff\u3400-\u4dbf\u4e00-\u9fff\uf900-\ufaff\uff66-\uff9f]/;
          function Yw(e2, t, n, i) {
            if (0 === e2.length)
              return 0;
            var r = 0;
            r -= Math.max(0, e2.length - 1), r -= i / 10;
            var o = e2[0][0];
            return r -= (e2[e2.length - 1][1] - o + 1 - t) / 100, r -= o / 1e3, r -= n / 1e4;
          }
          function $w(e2, t, n, i) {
            if (0 === e2.length)
              return null;
            for (var r = n.toLowerCase(), o = 0, a = 0, s = [], l = 0; l < e2.length; l++) {
              var c = e2[l], u = r.indexOf(c, a);
              if (-1 === u)
                return null;
              var h = n.charAt(u);
              if (u > 0 && !_w.test(h) && !Ww.test(h)) {
                var p = n.charAt(u - 1);
                if (h.toLowerCase() !== h && p.toLowerCase() !== p || h.toUpperCase() !== h && !_w.test(p) && !jw.test(p) && !Ww.test(p))
                  if (i) {
                    if (u !== a) {
                      a += c.length, l--;
                      continue;
                    }
                  } else
                    o += 1;
              }
              if (0 === s.length)
                s.push([u, u + c.length]);
              else {
                var d = s[s.length - 1];
                d[1] < u ? s.push([u, u + c.length]) : d[1] = u + c.length;
              }
              a = u + c.length;
            }
            return {
              matches: s,
              score: Yw(s, t.length, r.length, o)
            };
          }
          function Gw(e2) {
            for (var t = e2.toLowerCase(), n = [], i = 0, r = 0; r < t.length; r++) {
              var o = t.charAt(r);
              jw.test(o) ? (i !== r && n.push(t.substring(i, r)), i = r + 1) : (_w.test(o) || Ww.test(o)) && (i !== r && n.push(t.substring(i, r)), n.push(o), i = r + 1);
            }
            return i !== t.length && n.push(t.substring(i, t.length)), {
              query: e2,
              tokens: n,
              fuzzy: t.split("")
            };
          }
          function Xw(e2, t) {
            if ("" === e2.query)
              return {
                score: 0,
                matches: []
              };
            var n = $w(e2.tokens, e2.query, t, false);
            return n || $w(e2.fuzzy, e2.query, t, true);
          }
          var e = Gw(inputText);
          let container = this.getCommandsContainer();
          if (container.classList.contains("suggestions")) {
            this.exit();
          }
          if (inputText.trim() == "") {
            return true;
          }
          let suggestions = [];
          this.getCommandsContainer().querySelectorAll(".command").forEach((commandNode) => {
            let spanNode = commandNode.querySelector(".name span");
            let spanText = spanNode.innerText;
            let res = Xw(e, spanText);
            if (res) {
              commandNode = this.createCommandNode(commandNode.command);
              let spanHTML = "";
              let i = 0;
              for (let j = 0; j < res.matches.length; j++) {
                let [start, end] = res.matches[j];
                if (start > i) {
                  spanHTML += spanText.slice(i, start);
                }
                spanHTML += `<span class="highlight">${spanText.slice(start, end)}</span>`;
                i = end;
              }
              if (i < spanText.length) {
                spanHTML += spanText.slice(i, spanText.length);
              }
              commandNode.querySelector(".name span").innerHTML = spanHTML;
              suggestions.push({ score: res.score, commandNode });
            }
          });
          if (suggestions.length > 0) {
            suggestions.sort((a, b) => b.score - a.score).slice(this.maxSuggestionNum);
            container = this.createCommandsContainer();
            container.classList.add("suggestions");
            suggestions.forEach((suggestion) => {
              container.appendChild(suggestion.commandNode);
            });
            return true;
          } else {
            const anonymousCommand = this.commands.find((c) => !c.name && (!c.when || c.when()));
            if (anonymousCommand) {
              await this.execCallback(anonymousCommand.callback);
            } else {
              this.showTip(this.defaultText.empty);
            }
            return false;
          }
        }
        /**
         * Bind events of pressing `keydown` and `keyup` key.
         */
        initInputEvents() {
          this.promptNode.addEventListener("keydown", (event) => {
            if (["ArrowUp", "ArrowDown"].indexOf(event.key) != -1) {
              event.preventDefault();
              let selectedIndex;
              let allItems = [
                ...this.getCommandsContainer().querySelectorAll(".command")
              ].filter((e) => e.style.display != "none");
              selectedIndex = allItems.findIndex((e) => e.classList.contains("selected"));
              if (selectedIndex != -1) {
                allItems[selectedIndex].classList.remove("selected");
                selectedIndex += event.key == "ArrowUp" ? -1 : 1;
              } else {
                if (event.key == "ArrowUp") {
                  selectedIndex = allItems.length - 1;
                } else {
                  selectedIndex = 0;
                }
              }
              if (selectedIndex == -1) {
                selectedIndex = allItems.length - 1;
              } else if (selectedIndex == allItems.length) {
                selectedIndex = 0;
              }
              allItems[selectedIndex].classList.add("selected");
              let commandsContainer = this.getCommandsContainer();
              commandsContainer.scrollTo(0, commandsContainer.querySelector(".selected").offsetTop - commandsContainer.offsetHeight + 7.5);
              allItems[selectedIndex].classList.add("selected");
            }
          });
          this.promptNode.addEventListener("keyup", async (event) => {
            if (event.key == "Enter") {
              this.trigger();
            } else if (event.key == "Escape") {
              if (this.inputNode.value.length > 0) {
                this.inputNode.value = "";
              } else {
                this.exit();
              }
            } else if (["ArrowUp", "ArrowDown"].indexOf(event.key) != -1) {
              return;
            }
            const currentInputText = this.inputNode.value;
            if (currentInputText == this.lastInputText) {
              return;
            }
            this.lastInputText = currentInputText;
            window.setTimeout(async () => {
              await this.showSuggestions(currentInputText);
            });
          });
        }
        /**
         * Create a commandsContainer and display a text
         */
        showTip(text) {
          const tipNode = this.ui.createElement(this.document, "div", {
            classList: ["tip"],
            properties: {
              innerText: text
            }
          });
          let container = this.createCommandsContainer();
          container.classList.add("suggestions");
          container.appendChild(tipNode);
          return tipNode;
        }
        /**
         * Mark the selected item with class `selected`.
         * @param item HTMLDivElement
         */
        selectItem(item) {
          this.getCommandsContainer().querySelectorAll(".command").forEach((e) => e.classList.remove("selected"));
          item.classList.add("selected");
        }
        addStyle() {
          const style = this.ui.createElement(this.document, "style", {
            namespace: "html",
            id: "prompt-style"
          });
          style.innerText = `
      .prompt-container * {
        box-sizing: border-box;
      }
      .prompt-container {
        ---radius---: 10px;
        position: fixed;
        left: 25%;
        top: 10%;
        width: 50%;
        border-radius: var(---radius---);
        border: 1px solid #bdbdbd;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        background-color: white;
        font-size: 18px;
        box-shadow: 0px 1.8px 7.3px rgba(0, 0, 0, 0.071),
                    0px 6.3px 24.7px rgba(0, 0, 0, 0.112),
                    0px 30px 90px rgba(0, 0, 0, 0.2);
        font-family: ui-sans-serif, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Inter", "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Microsoft YaHei Light", sans-serif;
      }
      
      /* input */
      .prompt-container .input-container  {
        width: 100%;
      }
      
      .input-container input {
        width: 100%;
        height: 40px;
        padding: 24px;
        border-radius: 50%;
        border: none;
        outline: none;
        font-size: 18px;
      }
      
      .input-container .cta {
        border-bottom: 1px solid #f6f6f6;  
        margin: 5px auto;
      }
      
      /* results */
      .commands-containers {
        width: 100%;
        height: 100%;
      }
      .commands-container {
        max-height: calc(${this.maxLineNum} * 35.5px);
        width: calc(100% - 12px);
        margin-left: 12px;
        margin-right: 0%;
        overflow-y: auto;
        overflow-x: hidden;
      }
      
      .commands-container .command {
        display: flex;
        align-content: baseline;
        justify-content: space-between;
        border-radius: 5px;
        padding: 6px 12px;
        margin-right: 12px;
        margin-top: 2px;
        margin-bottom: 2px;
      }
      .commands-container .command .content {
        display: flex;
        width: 100%;
        justify-content: space-between;
        flex-direction: row;
        overflow: hidden;
      }
      .commands-container .command .content .name {
        white-space: nowrap; 
        text-overflow: ellipsis;
        overflow: hidden;
      }
      .commands-container .command .content .aux {
        display: flex;
        align-items: center;
        align-self: center;
        flex-shrink: 0;
      }
      
      .commands-container .command .content .aux .label {
        font-size: 15px;
        color: #5a5a5a;
        padding: 2px 6px;
        background-color: #fafafa;
        border-radius: 5px;
      }
      
      .commands-container .selected {
          background-color: rgba(0, 0, 0, 0.075);
      }

      .commands-container .highlight {
        font-weight: bold;
      }

      .tip {
        color: #5a5a5a;
        text-align: center;
        padding: 12px 12px;
        font-size: 18px;
      }
      
      .current-value {
        background-color: #a7b8c1;
        color: white;
        border-radius: 5px;
        padding: 0 5px;
        margin-left: 10px;
        font-size: 14px;
        vertical-align: middle;
        letter-spacing: 0.05em;
      }

      /* instructions */
      .instructions {
        display: flex;
        align-content: center;
        justify-content: center;
        font-size: 15px;
        color: rgba(0, 0, 0, 0.4);
        height: 2.5em;
        width: 100%;
        border-top: 1px solid #f6f6f6;
        margin-top: 5px;
      }
      
      .instructions .instruction {
        margin: auto .5em;  
      }
      
      .instructions .key {
        margin-right: .2em;
        font-weight: 600;
      }
    `;
          this.document.documentElement.appendChild(style);
        }
        registerShortcut() {
          this.document.addEventListener("keydown", (event) => {
            if (event.shiftKey && event.key.toLowerCase() == "p") {
              if (event.originalTarget.isContentEditable || "value" in event.originalTarget || this.commands.length == 0) {
                return;
              }
              event.preventDefault();
              event.stopPropagation();
              if (this.promptNode.style.display == "none") {
                this.promptNode.style.display = "flex";
                if (this.promptNode.querySelectorAll(".commands-container").length == 1) {
                  this.showCommands(this.commands, true);
                }
                this.promptNode.focus();
                this.inputNode.focus();
              } else {
                this.promptNode.style.display = "none";
              }
            }
          }, true);
        }
      };
      exports.Prompt = Prompt;
      var PromptManager = class extends basic_2.ManagerTool {
        constructor(base) {
          super(base);
          this.commands = [];
          const globalCache = toolkitGlobal_1.default.getInstance().prompt;
          if (!globalCache._ready) {
            globalCache._ready = true;
            globalCache.instance = new Prompt();
          }
          this.prompt = globalCache.instance;
        }
        /**
         * Register commands. Don't forget to call `unregister` on plugin exit.
         * @param commands Command[]
         * @example
         * ```ts
         * let getReader = () => {
         *   return BasicTool.getZotero().Reader.getByTabID(
         *     (Zotero.getMainWindow().Zotero_Tabs).selectedID
         *   )
         * }
         *
         * register([
         *   {
         *     name: "Split Horizontally",
         *     label: "Zotero",
         *     when: () => getReader() as boolean,
         *     callback: (prompt: Prompt) => getReader().menuCmd("splitHorizontally")
         *   },
         *   {
         *     name: "Split Vertically",
         *     label: "Zotero",
         *     when: () => getReader() as boolean,
         *     callback: (prompt: Prompt) => getReader().menuCmd("splitVertically")
         *   }
         * ])
         * ```
         */
        register(commands) {
          commands.forEach((c) => {
            var _a;
            return (_a = c.id) !== null && _a !== void 0 ? _a : c.id = c.name;
          });
          this.prompt.commands = [...this.prompt.commands, ...commands];
          this.commands = [...this.commands, ...commands];
          this.prompt.showCommands(this.commands, true);
        }
        /**
         * You can delete a command registed before by its name.
         * @remarks
         * There is a premise here that the names of all commands registered by a single plugin are not duplicated.
         * @param id Command.name
         */
        unregister(id) {
          const command = this.commands.find((c) => c.id == id);
          this.prompt.commands = this.prompt.commands.filter((c) => {
            return JSON.stringify(command) != JSON.stringify(c);
          });
          this.commands = this.commands.filter((c) => c.id != id);
        }
        /**
         * Call `unregisterAll` on plugin exit.
         */
        unregisterAll() {
          this.prompt.commands = this.prompt.commands.filter((c) => {
            return this.commands.find((_c) => {
              JSON.stringify(_c) != JSON.stringify(c);
            });
          });
          this.commands = [];
        }
      };
      exports.PromptManager = PromptManager;
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/managers/libraryTabPanel.js
  var require_libraryTabPanel = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/managers/libraryTabPanel.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.LibraryTabPanelManager = void 0;
      var ui_1 = require_ui();
      var basic_1 = require_basic();
      var LibraryTabPanelManager = class extends basic_1.ManagerTool {
        constructor(base) {
          super(base);
          this.ui = new ui_1.UITool(this);
          this.libraryTabCache = {
            optionsList: []
          };
        }
        /**
         * Register a tabpanel in library.
         * @remarks
         * If you don't want to remove the tab & panel in runtime, `unregisterLibraryTabPanel` is not a must.
         *
         * The elements wiil be removed by `removeAddonElements`.
         * @param tabLabel Label of panel tab.
         * @param renderPanelHook Called when panel is ready. Add elements to the panel.
         * @param options Other optional parameters.
         * @param options.tabId ID of panel tab. Also used as unregister query. If not set, generate a random one.
         * @param options.panelId ID of panel container (XUL.TabPanel). If not set, generate a random one.
         * @param options.targetIndex Index of the inserted tab. Default the end of tabs.
         * @param options.selectPanel If the panel should be selected immediately.
         * @returns tabId. Use it for unregister.
         * @example
         * Register an extra library tabpanel into index 1.
         * ```ts
         * const libPaneManager = new LibraryTabPanelManager();
         * const libTabId = libPaneManager.registerLibraryTabPanel(
         *   "test",
         *   (panel: XUL.Element, win: Window) => {
         *     const elem = ui.creatElementsFromJSON(
         *       win.document,
         *       {
         *         tag: "vbox",
         *         namespace: "xul",
         *         subElementOptions: [
         *           {
         *             tag: "h2",
         *             directAttributes: {
         *               innerText: "Hello World!",
         *             },
         *           },
         *           {
         *             tag: "label",
         *             namespace: "xul",
         *             directAttributes: {
         *               value: "This is a library tab.",
         *             },
         *           },
         *           {
         *             tag: "button",
         *             directAttributes: {
         *               innerText: "Unregister",
         *             },
         *             listeners: [
         *               {
         *                 type: "click",
         *                 listener: () => {
         *                   ui.unregisterLibraryTabPanel(
         *                     libTabId
         *                   );
         *                 },
         *               },
         *             ],
         *           },
         *         ],
         *       }
         *     );
         *     panel.append(elem);
         *   },
         *   {
         *     targetIndex: 1,
         *   }
         * );
         * ```
         */
        register(tabLabel, renderPanelHook, options) {
          options = options || {
            tabId: void 0,
            panelId: void 0,
            targetIndex: -1,
            selectPanel: false
          };
          const window2 = this.getGlobal("window");
          const tabbox = window2.document.querySelector("#zotero-view-tabbox");
          const randomId = `${Zotero.Utilities.randomString()}-${(/* @__PURE__ */ new Date()).getTime()}`;
          const tabId = options.tabId || `toolkit-readertab-${randomId}`;
          const panelId = options.panelId || `toolkit-readertabpanel-${randomId}`;
          const tab = this.ui.createElement(window2.document, "tab", {
            id: tabId,
            classList: [`toolkit-ui-tabs-${tabId}`],
            attributes: {
              label: tabLabel
            },
            ignoreIfExists: true
          });
          const tabpanel = this.ui.createElement(window2.document, "tabpanel", {
            id: panelId,
            classList: [`toolkit-ui-tabs-${tabId}`],
            ignoreIfExists: true
          });
          const tabs = tabbox.querySelector("tabs");
          const tabpanels = tabbox.querySelector("tabpanels");
          const targetIndex = typeof options.targetIndex === "number" ? options.targetIndex : -1;
          if (targetIndex >= 0) {
            tabs.querySelectorAll("tab")[targetIndex].before(tab);
            tabpanels.querySelectorAll("tabpanel")[targetIndex].before(tabpanel);
          } else {
            tabs.appendChild(tab);
            tabpanels.appendChild(tabpanel);
          }
          if (options.selectPanel) {
            tabbox.selectedTab = tab;
          }
          this.libraryTabCache.optionsList.push({
            tabId,
            tabLabel,
            panelId,
            renderPanelHook,
            targetIndex,
            selectPanel: options.selectPanel
          });
          renderPanelHook(tabpanel, window2);
          return tabId;
        }
        /**
         * Unregister the library tabpanel.
         * @param tabId tab id
         */
        unregister(tabId) {
          const idx = this.libraryTabCache.optionsList.findIndex((v) => v.tabId === tabId);
          if (idx >= 0) {
            this.libraryTabCache.optionsList.splice(idx, 1);
          }
          this.removeTabPanel(tabId);
        }
        /**
         * Unregister all library tabpanel.
         */
        unregisterAll() {
          const tabIds = this.libraryTabCache.optionsList.map((options) => options.tabId);
          tabIds.forEach(this.unregister.bind(this));
        }
        removeTabPanel(tabId) {
          const doc = this.getGlobal("document");
          Array.prototype.forEach.call(doc.querySelectorAll(`.toolkit-ui-tabs-${tabId}`), (e) => {
            e.remove();
          });
        }
      };
      exports.LibraryTabPanelManager = LibraryTabPanelManager;
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/managers/readerTabPanel.js
  var require_readerTabPanel = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/managers/readerTabPanel.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ReaderTabPanelManager = void 0;
      var ui_1 = require_ui();
      var reader_1 = require_reader();
      var basic_1 = require_basic();
      var ReaderTabPanelManager = class extends basic_1.ManagerTool {
        constructor(base) {
          super(base);
          this.ui = new ui_1.UITool(this);
          this.readerTool = new reader_1.ReaderTool(this);
          this.readerTabCache = {
            optionsList: [],
            observer: void 0,
            initializeLock: void 0
          };
        }
        /**
         * Register a tabpanel for every reader.
         * @remarks
         * Don't forget to call `unregisterReaderTabPanel` on exit.
         * @remarks
         * Every time a tab reader is selected/opened, the hook will be called.
         * @param tabLabel Label of panel tab.
         * @param renderPanelHook Called when panel is ready. Add elements to the panel.
         *
         * The panel might be `undefined` when opening a PDF without parent item.
         *
         * The owner deck is the top container of right-side bar.
         *
         * The readerInstance is the reader of current tabpanel.
         * @param options Other optional parameters.
         * @param options.tabId ID of panel tab. Also used as unregister query. If not set, generate a random one.
         * @param options.panelId ID of panel container (XUL.TabPanel). If not set, generate a random one.
         * @param options.targetIndex Index of the inserted tab. Default the end of tabs.
         * @param options.selectPanel If the panel should be selected immediately.
         * @returns tabId. Use it for unregister.
         * @example
         * Register an extra reader tabpanel into index 1.
         * ```ts
         * const readerTabId = `${config.addonRef}-extra-reader-tab`;
         * this._Addon.toolkit.UI.registerReaderTabPanel(
         *   "test",
         *   (
         *     panel: XUL.Element,
         *     deck: XUL.Deck,
         *     win: Window,
         *     reader: _ZoteroReaderInstance
         *   ) => {
         *     if (!panel) {
         *       this._Addon.toolkit.Tool.log(
         *         "This reader do not have right-side bar. Adding reader tab skipped."
         *       );
         *       return;
         *     }
         *     this._Addon.toolkit.Tool.log(reader);
         *     const elem = this._Addon.toolkit.UI.creatElementsFromJSON(
         *       win.document,
         *       {
         *         tag: "vbox",
         *         id: `${config.addonRef}-${reader._instanceID}-extra-reader-tab-div`,
         *         namespace: "xul",
         *         // This is important! Don't create content for multiple times
         *         ignoreIfExists: true,
         *         subElementOptions: [
         *           {
         *             tag: "h2",
         *             directAttributes: {
         *               innerText: "Hello World!",
         *             },
         *           },
         *           {
         *             tag: "label",
         *             namespace: "xul",
         *             directAttributes: {
         *               value: "This is a reader tab.",
         *             },
         *           },
         *           {
         *             tag: "label",
         *             namespace: "xul",
         *             directAttributes: {
         *               value: `Reader: ${reader._title.slice(0, 20)}`,
         *             },
         *           },
         *           {
         *             tag: "label",
         *             namespace: "xul",
         *             directAttributes: {
         *               value: `itemID: ${reader.itemID}.`,
         *             },
         *           },
         *           {
         *             tag: "button",
         *             directAttributes: {
         *               innerText: "Unregister",
         *             },
         *             listeners: [
         *               {
         *                 type: "click",
         *                 listener: () => {
         *                   this._Addon.toolkit.UI.unregisterReaderTabPanel(
         *                     readerTabId
         *                   );
         *                 },
         *               },
         *             ],
         *           },
         *         ],
         *       }
         *     );
         *     panel.append(elem);
         *   },
         *   {
         *     tabId: readerTabId,
         *   }
         * );
         * ```
         */
        async register(tabLabel, renderPanelHook, options) {
          var _a;
          options = options || {
            tabId: void 0,
            panelId: void 0,
            targetIndex: -1,
            selectPanel: false
          };
          if (typeof this.readerTabCache.initializeLock === "undefined") {
            await this.initializeReaderTabObserver();
          }
          await ((_a = this.readerTabCache.initializeLock) === null || _a === void 0 ? void 0 : _a.promise);
          const randomId = `${Zotero.Utilities.randomString()}-${(/* @__PURE__ */ new Date()).getTime()}`;
          const tabId = options.tabId || `toolkit-readertab-${randomId}`;
          const panelId = options.panelId || `toolkit-readertabpanel-${randomId}`;
          const targetIndex = typeof options.targetIndex === "number" ? options.targetIndex : -1;
          this.readerTabCache.optionsList.push({
            tabId,
            tabLabel,
            panelId,
            renderPanelHook,
            targetIndex,
            selectPanel: options.selectPanel
          });
          await this.addReaderTabPanel();
          return tabId;
        }
        /**
         * Unregister the reader tabpanel.
         * @param tabId tab id
         */
        unregister(tabId) {
          var _a;
          const idx = this.readerTabCache.optionsList.findIndex((v) => v.tabId === tabId);
          if (idx >= 0) {
            this.readerTabCache.optionsList.splice(idx, 1);
          }
          if (this.readerTabCache.optionsList.length === 0) {
            (_a = this.readerTabCache.observer) === null || _a === void 0 ? void 0 : _a.disconnect();
            this.readerTabCache = {
              optionsList: [],
              observer: void 0,
              initializeLock: void 0
            };
          }
          this.removeTabPanel(tabId);
        }
        /**
         * Unregister all library tabpanel.
         */
        unregisterAll() {
          const tabIds = this.readerTabCache.optionsList.map((options) => options.tabId);
          tabIds.forEach(this.unregister.bind(this));
        }
        changeTabPanel(tabId, options) {
          const idx = this.readerTabCache.optionsList.findIndex((v) => v.tabId === tabId);
          if (idx >= 0) {
            Object.assign(this.readerTabCache.optionsList[idx], options);
          }
        }
        removeTabPanel(tabId) {
          const doc = this.getGlobal("document");
          Array.prototype.forEach.call(doc.querySelectorAll(`.toolkit-ui-tabs-${tabId}`), (e) => {
            e.remove();
          });
        }
        async initializeReaderTabObserver() {
          this.readerTabCache.initializeLock = this.getGlobal("Zotero").Promise.defer();
          await Promise.all([
            Zotero.initializationPromise,
            Zotero.unlockPromise,
            Zotero.uiReadyPromise
          ]);
          const observer = this.readerTool.addReaderTabPanelDeckObserver(() => {
            this.addReaderTabPanel();
          });
          this.readerTabCache.observer = observer;
          this.readerTabCache.initializeLock.resolve();
        }
        async addReaderTabPanel() {
          var _a, _b;
          const window2 = this.getGlobal("window");
          const deck = this.readerTool.getReaderTabPanelDeck();
          const reader = await this.readerTool.getReader();
          if (!reader) {
            return;
          }
          if (((_a = deck.selectedPanel) === null || _a === void 0 ? void 0 : _a.children[0].tagName) === "vbox") {
            const container = deck.selectedPanel;
            container.innerHTML = "";
            this.ui.appendElement({
              tag: "tabbox",
              classList: ["zotero-view-tabbox"],
              attributes: {
                flex: "1"
              },
              enableElementRecord: false,
              children: [
                {
                  tag: "tabs",
                  classList: ["zotero-editpane-tabs"],
                  attributes: {
                    orient: "horizontal"
                  },
                  enableElementRecord: false
                },
                {
                  tag: "tabpanels",
                  classList: ["zotero-view-item"],
                  attributes: {
                    flex: "1"
                  },
                  enableElementRecord: false
                }
              ]
            }, container);
          }
          let tabbox = (_b = deck.selectedPanel) === null || _b === void 0 ? void 0 : _b.querySelector("tabbox");
          if (!tabbox) {
            return;
          }
          this.readerTabCache.optionsList.forEach((options) => {
            const tabId = `${options.tabId}-${reader._instanceID}`;
            if (window2.document.querySelector(`#${tabId}`)) {
              return;
            }
            const tab = this.ui.createElement(window2.document, "tab", {
              id: tabId,
              classList: [`toolkit-ui-tabs-${options.tabId}`],
              attributes: {
                label: options.tabLabel
              },
              ignoreIfExists: true
            });
            const tabpanel = this.ui.createElement(window2.document, "tabpanel", {
              id: `${options.panelId}-${reader._instanceID}`,
              classList: [`toolkit-ui-tabs-${options.tabId}`],
              ignoreIfExists: true
            });
            const tabs = tabbox.querySelector("tabs");
            const tabpanels = tabbox.querySelector("tabpanels");
            if (options.targetIndex >= 0) {
              tabs === null || tabs === void 0 ? void 0 : tabs.querySelectorAll("tab")[options.targetIndex].before(tab);
              tabpanels === null || tabpanels === void 0 ? void 0 : tabpanels.querySelectorAll("tabpanel")[options.targetIndex].before(tabpanel);
              if (tabbox.getAttribute("toolkit-select-fixed") !== "true") {
                tabbox.tabpanels.addEventListener("select", () => {
                  this.getGlobal("setTimeout")(() => {
                    tabbox.tabpanels.selectedPanel = tabbox.tabs.getRelatedElement(tabbox === null || tabbox === void 0 ? void 0 : tabbox.tabs.selectedItem);
                  }, 0);
                });
                tabbox.setAttribute("toolkit-select-fixed", "true");
              }
            } else {
              tabs === null || tabs === void 0 ? void 0 : tabs.appendChild(tab);
              tabpanels === null || tabpanels === void 0 ? void 0 : tabpanels.appendChild(tabpanel);
            }
            if (options.selectPanel) {
              tabbox.selectedTab = tab;
            }
            options.renderPanelHook(tabpanel, deck, window2, reader);
          });
        }
      };
      exports.ReaderTabPanelManager = ReaderTabPanelManager;
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/managers/menu.js
  var require_menu = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/managers/menu.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.MenuManager = void 0;
      var ui_1 = require_ui();
      var basic_1 = require_basic();
      var MenuManager = class extends basic_1.ManagerTool {
        constructor(base) {
          super(base);
          this.ui = new ui_1.UITool(this);
        }
        /**
         * Insert an menu item/menu(with popup)/menuseprator into a menupopup
         * @remarks
         * options:
         * ```ts
         * export interface MenuitemOptions {
         *   tag: "menuitem" | "menu" | "menuseparator";
         *   id?: string;
         *   label?: string;
         *   // data url (chrome://xxx.png) or base64 url (data:image/png;base64,xxx)
         *   icon?: string;
         *   class?: string;
         *   styles?: { [key: string]: string };
         *   hidden?: boolean;
         *   disabled?: boolean;
         *   oncommand?: string;
         *   commandListener?: EventListenerOrEventListenerObject;
         *   // Attributes below are used when type === "menu"
         *   popupId?: string;
         *   onpopupshowing?: string;
         *   subElementOptions?: Array<MenuitemOptions>;
         * }
         * ```
         * @param menuPopup
         * @param options
         * @param insertPosition
         * @param anchorElement The menuitem will be put before/after `anchorElement`. If not set, put at start/end of the menupopup.
         * @example
         * Insert menuitem with icon into item menupopup
         * ```ts
         * const ui = new ZoteroUI();
         * // base64 or chrome:// url
         * const menuIcon = "chrome://addontemplate/content/icons/favicon@0.5x.png";
         * ui.insertMenuItem("item", {
         *   tag: "menuitem",
         *   id: "zotero-itemmenu-addontemplate-test",
         *   label: "Addon Template: Menuitem",
         *   oncommand: "alert('Hello World! Default Menuitem.')",
         *   icon: menuIcon,
         * });
         * ```
         * @example
         * Insert menu into file menupopup
         * ```ts
         * const ui = new ZoteroUI();
         * ui.insertMenuItem(
         *   "menuFile",
         *   {
         *     tag: "menu",
         *     label: "Addon Template: Menupopup",
         *     subElementOptions: [
         *       {
         *         tag: "menuitem",
         *         label: "Addon Template",
         *         oncommand: "alert('Hello World! Sub Menuitem.')",
         *       },
         *     ],
         *   },
         *   "before",
         *   Zotero.getMainWindow().document.querySelector(
         *     "#zotero-itemmenu-addontemplate-test"
         *   )
         * );
         * ```
         */
        register(menuPopup, options, insertPosition = "after", anchorElement) {
          let popup;
          if (typeof menuPopup === "string") {
            popup = this.getGlobal("document").querySelector(MenuSelector[menuPopup]);
          } else {
            popup = menuPopup;
          }
          if (!popup) {
            return false;
          }
          const doc = popup.ownerDocument;
          const generateElementOptions = (menuitemOption) => {
            var _a;
            const elementOption = {
              tag: menuitemOption.tag,
              id: menuitemOption.id,
              namespace: "xul",
              attributes: {
                label: menuitemOption.label || "",
                hidden: Boolean(menuitemOption.hidden),
                disaled: Boolean(menuitemOption.disabled),
                class: menuitemOption.class || "",
                oncommand: menuitemOption.oncommand || ""
              },
              classList: menuitemOption.classList,
              styles: menuitemOption.styles || {},
              listeners: [],
              children: []
            };
            if (menuitemOption.icon) {
              elementOption.attributes["class"] += " menuitem-iconic";
              elementOption.styles["list-style-image"] = `url(${menuitemOption.icon})`;
            }
            if (menuitemOption.tag === "menu") {
              elementOption.children.push({
                tag: "menupopup",
                id: menuitemOption.popupId,
                attributes: { onpopupshowing: menuitemOption.onpopupshowing || "" },
                children: (menuitemOption.children || menuitemOption.subElementOptions || []).map(generateElementOptions)
              });
            }
            if (menuitemOption.commandListener) {
              (_a = elementOption.listeners) === null || _a === void 0 ? void 0 : _a.push({
                type: "command",
                listener: menuitemOption.commandListener
              });
            }
            return elementOption;
          };
          const props = generateElementOptions(options);
          const menuItem = this.ui.createElement(doc, options.tag, props);
          if (!anchorElement) {
            anchorElement = insertPosition === "after" ? popup.lastElementChild : popup.firstElementChild;
          }
          anchorElement[insertPosition](menuItem);
        }
        unregister(menuId) {
          var _a;
          (_a = this.getGlobal("document").querySelector(`#${menuId}`)) === null || _a === void 0 ? void 0 : _a.remove();
        }
        unregisterAll() {
          this.ui.unregisterAll();
        }
      };
      exports.MenuManager = MenuManager;
      var MenuSelector;
      (function(MenuSelector2) {
        MenuSelector2["menuFile"] = "#menu_FilePopup";
        MenuSelector2["menuEdit"] = "#menu_EditPopup";
        MenuSelector2["menuView"] = "#menu_viewPopup";
        MenuSelector2["menuGo"] = "#menu_goPopup";
        MenuSelector2["menuTools"] = "#menu_ToolsPopup";
        MenuSelector2["menuHelp"] = "#menu_HelpPopup";
        MenuSelector2["collection"] = "#zotero-collectionmenu";
        MenuSelector2["item"] = "#zotero-itemmenu";
      })(MenuSelector || (MenuSelector = {}));
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/managers/preferencePane.js
  var require_preferencePane = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/managers/preferencePane.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.PreferencePaneManager = void 0;
      var ui_1 = require_ui();
      var basic_1 = require_basic();
      var PreferencePaneManager = class extends basic_1.ManagerTool {
        constructor(base) {
          super(base);
          this.alive = true;
          this.ui = new ui_1.UITool(this);
          this.prefPaneCache = { win: void 0, listeners: {} };
        }
        /**
         * Register a preference pane from an xhtml, for Zotero 6 & 7.
         * @remarks
         * Don't forget to call `unregisterPrefPane` on exit.
         * @remarks
         * options:
         * ```ts
         * export interface PrefPaneOptions {
         *   pluginID: string;
         *   src: string;
         *   id?: string;
         *   parent?: string;
         *   label?: string;
         *   image?: string;
         *   extraDTD?: string[];
         *   scripts?: string[];
         *   defaultXUL?: boolean;
         *   // Only for Zotero 6
         *   onload?: (win: Window) => any;
         * }
         * ```
         *
         * @param options See {@link https://github.com/windingwind/zotero-plugin-toolkit/blob/main/src/options.ts | source code:options.ts}
         * @example
         * ```ts
         * const prefsManager = new PreferencePaneManager();
         * function initPrefs() {
         *   const prefOptions = {
         *     pluginID: addonID,
         *     src: rootURI + "chrome/content/preferences.xhtml",
         *     label: "Template",
         *     image: `chrome://${addonRef}/content/icons/favicon.ico`,
         *     extraDTD: [`chrome://${addonRef}/locale/overlay.dtd`],
         *     defaultXUL: true
         *   };
         *   prefsManager.register(prefOptions);
         * };
         *
         * function unInitPrefs() {
         *   prefsManager.unregisterAll();
         * };
         * ```
         * // bootstrap.js:startup
         * initPrefs();
         *
         * // bootstrap.js:shutdown
         * unInitPrefs();
         */
        register(options) {
          if (this.isZotero7()) {
            this.getGlobal("Zotero").PreferencePanes.register(options);
            return;
          }
          const _initImportedNodesPostInsert = (container) => {
            var _a;
            const _observerSymbols = /* @__PURE__ */ new Map();
            const Zotero2 = this.getGlobal("Zotero");
            const window2 = container.ownerGlobal;
            let useChecked = (elem) => elem instanceof window2.HTMLInputElement && elem.type == "checkbox" || elem.tagName == "checkbox";
            let syncFromPref = (elem, preference) => {
              let value = Zotero2.Prefs.get(preference, true);
              if (useChecked(elem)) {
                elem.checked = value;
              } else {
                elem.value = value;
              }
              elem.dispatchEvent(new window2.Event("syncfrompreference"));
            };
            let syncToPrefOnModify = (event) => {
              const targetNode = event.currentTarget;
              if (targetNode === null || targetNode === void 0 ? void 0 : targetNode.getAttribute("preference")) {
                let value = useChecked(targetNode) ? targetNode.checked : targetNode.value;
                Zotero2.Prefs.set(targetNode.getAttribute("preference") || "", value, true);
                targetNode.dispatchEvent(new window2.Event("synctopreference"));
              }
            };
            let attachToPreference = (elem, preference) => {
              Zotero2.debug(`Attaching <${elem.tagName}> element to ${preference}`);
              let symbol = Zotero2.Prefs.registerObserver(preference, () => syncFromPref(elem, preference), true);
              _observerSymbols.set(elem, symbol);
            };
            let detachFromPreference = (elem) => {
              if (_observerSymbols.has(elem)) {
                Zotero2.debug(`Detaching <${elem.tagName}> element from preference`);
                Zotero2.Prefs.unregisterObserver(this._observerSymbols.get(elem));
                _observerSymbols.delete(elem);
              }
            };
            for (let elem of container.querySelectorAll("[preference]")) {
              let preference = elem.getAttribute("preference");
              if (container.querySelector("preferences > preference#" + preference)) {
                this.log("<preference> is deprecated -- `preference` attribute values should be full preference keys, not <preference> IDs");
                preference = (_a = container.querySelector("preferences > preference#" + preference)) === null || _a === void 0 ? void 0 : _a.getAttribute("name");
              }
              attachToPreference(elem, preference);
              elem.addEventListener(this.isXULElement(elem) ? "command" : "input", syncToPrefOnModify);
              window2.setTimeout(() => {
                syncFromPref(elem, preference);
              });
            }
            new window2.MutationObserver((mutations) => {
              for (let mutation of mutations) {
                if (mutation.type == "attributes") {
                  let target = mutation.target;
                  detachFromPreference(target);
                  if (target.hasAttribute("preference")) {
                    attachToPreference(target, target.getAttribute("preference") || "");
                    target.addEventListener(this.isXULElement(target) ? "command" : "input", syncToPrefOnModify);
                  }
                } else if (mutation.type == "childList") {
                  for (let node of mutation.removedNodes) {
                    detachFromPreference(node);
                  }
                  for (let node of mutation.addedNodes) {
                    if (node.nodeType == window2.Node.ELEMENT_NODE && node.hasAttribute("preference")) {
                      attachToPreference(node, node.getAttribute("preference") || "");
                      node.addEventListener(this.isXULElement(node) ? "command" : "input", syncToPrefOnModify);
                    }
                  }
                }
              }
            }).observe(container, {
              childList: true,
              subtree: true,
              attributeFilter: ["preference"]
            });
            for (let elem of container.querySelectorAll("[oncommand]")) {
              elem.oncommand = elem.getAttribute("oncommand");
            }
            for (let child of container.children) {
              child.dispatchEvent(new window2.Event("load"));
            }
          };
          const windowListener = {
            onOpenWindow: (xulWindow) => {
              if (!this.alive) {
                return;
              }
              const win = xulWindow.QueryInterface(Components.interfaces.nsIInterfaceRequestor).getInterface(Components.interfaces.nsIDOMWindow);
              win.addEventListener("load", async () => {
                var _a;
                if (win.location.href === "chrome://zotero/content/preferences/preferences.xul") {
                  this.log("registerPrefPane:detected", options);
                  const Zotero2 = this.getGlobal("Zotero");
                  options.id || (options.id = `plugin-${Zotero2.Utilities.randomString()}-${(/* @__PURE__ */ new Date()).getTime()}`);
                  const contentOrXHR = await Zotero2.File.getContentsAsync(options.src);
                  const content = typeof contentOrXHR === "string" ? contentOrXHR : contentOrXHR.response;
                  const src = `<prefpane xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul" id="${options.id}" insertafter="zotero-prefpane-advanced" label="${options.label || options.pluginID}" image="${options.image || ""}">
                ${content}
                </prefpane>`;
                  const frag = this.ui.parseXHTMLToFragment(src, options.extraDTD, options.defaultXUL);
                  this.log(frag);
                  const prefWindow = win.document.querySelector("prefwindow");
                  prefWindow.appendChild(frag);
                  const prefPane = win.document.querySelector(`#${options.id}`);
                  prefWindow.addPane(prefPane);
                  const contentBox = win.document.getAnonymousNodes(win.document.querySelector(`#${options.id}`))[0];
                  contentBox.style.overflowY = "scroll";
                  contentBox.style.height = "440px";
                  win.sizeToContent();
                  if (contentBox.scrollHeight === contentBox.clientHeight) {
                    contentBox.style.overflowY = "hidden";
                  }
                  this.prefPaneCache.win = win;
                  this.prefPaneCache.listeners[options.id] = windowListener;
                  _initImportedNodesPostInsert(prefPane);
                  if ((_a = options.scripts) === null || _a === void 0 ? void 0 : _a.length) {
                    options.scripts.forEach((script) => Services.scriptloader.loadSubScript(script, win));
                  }
                  if (options.onload) {
                    options.onload(win);
                  }
                }
              }, false);
            }
          };
          Services.wm.addListener(windowListener);
        }
        unregister(id) {
          var _a;
          const idx = Object.keys(this.prefPaneCache.listeners).indexOf(id);
          if (idx < 0) {
            return false;
          }
          const listener = this.prefPaneCache.listeners[id];
          Services.wm.removeListener(listener);
          listener.onOpenWindow = void 0;
          const win = this.prefPaneCache.win;
          if (win && !win.closed) {
            (_a = win.document.querySelector(`#${id}`)) === null || _a === void 0 ? void 0 : _a.remove();
          }
          delete this.prefPaneCache.listeners[id];
          return true;
        }
        /**
         * Unregister all preference panes added with this instance
         *
         * Called on exiting
         */
        unregisterAll() {
          this.alive = false;
          for (const id in this.prefPaneCache.listeners) {
            this.unregister(id);
          }
        }
      };
      exports.PreferencePaneManager = PreferencePaneManager;
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/managers/shortcut.js
  var require_shortcut = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/managers/shortcut.js"(exports) {
      "use strict";
      var __importDefault2 = exports && exports.__importDefault || function(mod) {
        return mod && mod.__esModule ? mod : { "default": mod };
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ShortcutManager = void 0;
      var basic_1 = require_basic();
      var ui_1 = require_ui();
      var basic_2 = require_basic();
      var toolkitGlobal_1 = __importDefault2(require_toolkitGlobal());
      var ShortcutManager = class extends basic_2.ManagerTool {
        constructor(base) {
          super(base);
          this.ui = new ui_1.UITool(this);
          this.creatorId = `${Zotero.Utilities.randomString()}-${(/* @__PURE__ */ new Date()).getTime()}`;
          this.initializeGlobal();
        }
        register(type, keyOptions) {
          const _keyOptions = keyOptions;
          _keyOptions.type = type;
          switch (_keyOptions.type) {
            case "event":
              this.registerEventKey(_keyOptions);
              return true;
            case "element":
              this.registerElementKey(_keyOptions);
              return true;
            case "prefs":
              this.getGlobal("Zotero").Prefs.set(_keyOptions.id, _keyOptions.key || "");
              return true;
            default:
              try {
                if (_keyOptions.register) {
                  return _keyOptions.register(_keyOptions);
                } else {
                  return false;
                }
              } catch (e) {
                this.log(e);
                return false;
              }
          }
        }
        /**
         * Get all shortcuts(element, event, prefs, builtin)
         */
        getAll() {
          return Array.prototype.concat(this.getMainWindowElementKeys(), this.getEventKeys(), this.getPrefsKeys(), this.getBuiltinKeys());
        }
        /**
         * Check key conflicting of `inputKeyOptions`.
         * @param inputKeyOptions
         * @param options
         * @returns conflicting keys array
         */
        checkKeyConflicting(inputKeyOptions, options = { includeEmpty: false, customKeys: [] }) {
          var _a;
          inputKeyOptions.modifiers = new KeyModifier(inputKeyOptions.modifiers || "").getRaw();
          let allKeys = this.getAll();
          if ((_a = options.customKeys) === null || _a === void 0 ? void 0 : _a.length) {
            allKeys = allKeys.concat(options.customKeys);
          }
          if (!options.includeEmpty) {
            allKeys = allKeys.filter((_keyOptions) => _keyOptions.key);
          }
          return allKeys.filter((_keyOptions) => {
            var _a2, _b;
            return _keyOptions.id !== inputKeyOptions.id && ((_a2 = _keyOptions.key) === null || _a2 === void 0 ? void 0 : _a2.toLowerCase()) === ((_b = inputKeyOptions.key) === null || _b === void 0 ? void 0 : _b.toLowerCase()) && _keyOptions.modifiers === inputKeyOptions.modifiers;
          });
        }
        /**
         * Find all key conflicting.
         * @param options
         * @returns An array of conflicting keys arrays. Same conflicting keys are put together.
         */
        checkAllKeyConflicting(options = { includeEmpty: false, customKeys: [] }) {
          var _a;
          let allKeys = this.getAll();
          if ((_a = options.customKeys) === null || _a === void 0 ? void 0 : _a.length) {
            allKeys = allKeys.concat(options.customKeys);
          }
          if (!options.includeEmpty) {
            allKeys = allKeys.filter((_keyOptions) => _keyOptions.key);
          }
          const conflicting = [];
          while (allKeys.length > 0) {
            const checkKey = allKeys.pop();
            const conflictKeys = allKeys.filter((_keyOptions) => {
              var _a2, _b;
              return ((_a2 = _keyOptions.key) === null || _a2 === void 0 ? void 0 : _a2.toLowerCase()) === ((_b = checkKey.key) === null || _b === void 0 ? void 0 : _b.toLowerCase()) && _keyOptions.modifiers === checkKey.modifiers;
            });
            if (conflictKeys.length) {
              conflictKeys.push(checkKey);
              conflicting.push(conflictKeys);
              const conflictingKeyIds = conflictKeys.map((key) => key.id);
              const toRemoveIds = [];
              allKeys.forEach((key, i) => conflictingKeyIds.includes(key.id) && toRemoveIds.push(i));
              toRemoveIds.sort((a, b) => b - a).forEach((id) => allKeys.splice(id, 1));
            }
          }
          return conflicting;
        }
        /**
         * Unregister a key.
         * @remarks
         * `builtin` keys cannot be unregistered.
         * @param keyOptions
         * @returns `true` for success and `false` for failure.
         */
        async unregister(keyOptions) {
          var _a;
          switch (keyOptions.type) {
            case "element":
              (_a = (keyOptions.xulData.document || this.getGlobal("document")).querySelector(`#${keyOptions.id}`)) === null || _a === void 0 ? void 0 : _a.remove();
              return true;
            case "prefs":
              this.getGlobal("Zotero").Prefs.set(keyOptions.id, "");
              return true;
            case "builtin":
              return false;
            case "event":
              let idx = this.globalCache.eventKeys.findIndex((currentKey) => currentKey.id === keyOptions.id);
              while (idx >= 0) {
                this.globalCache.eventKeys.splice(idx, 1);
                idx = this.globalCache.eventKeys.findIndex((currentKey) => currentKey.id === keyOptions.id);
              }
              return true;
            default:
              try {
                if (keyOptions.unregister) {
                  return await keyOptions.unregister(keyOptions);
                } else {
                  return false;
                }
              } catch (e) {
                this.log(e);
                return false;
              }
          }
        }
        /**
         * Unregister all keys created by this instance.
         */
        unregisterAll() {
          this.ui.unregisterAll();
          this.globalCache.eventKeys.filter((keyOptions) => keyOptions.creatorId === this.creatorId).forEach((keyOptions) => this.unregister(keyOptions));
        }
        initializeGlobal() {
          const Zotero2 = this.getGlobal("Zotero");
          const window2 = this.getGlobal("window");
          this.globalCache = toolkitGlobal_1.default.getInstance().shortcut;
          if (!this.globalCache._ready) {
            this.globalCache._ready = true;
            window2.addEventListener("keypress", (event) => {
              let eventMods = [];
              let eventModsWithAccel = [];
              if (event.altKey) {
                eventMods.push("alt");
                eventModsWithAccel.push("alt");
              }
              if (event.shiftKey) {
                eventMods.push("shift");
                eventModsWithAccel.push("shift");
              }
              if (event.metaKey) {
                eventMods.push("meta");
                Zotero2.isMac && eventModsWithAccel.push("accel");
              }
              if (event.ctrlKey) {
                eventMods.push("control");
                !Zotero2.isMac && eventModsWithAccel.push("accel");
              }
              const eventModStr = new KeyModifier(eventMods.join(",")).getRaw();
              const eventModStrWithAccel = new KeyModifier(eventMods.join(",")).getRaw();
              this.globalCache.eventKeys.forEach((keyOptions) => {
                var _a;
                if (keyOptions.disabled) {
                  return;
                }
                const modStr = new KeyModifier(keyOptions.modifiers || "").getRaw();
                if ((modStr === eventModStr || modStr === eventModStrWithAccel) && ((_a = keyOptions.key) === null || _a === void 0 ? void 0 : _a.toLowerCase()) === event.key.toLowerCase()) {
                  keyOptions.callback();
                }
              });
            });
          }
        }
        registerEventKey(keyOptions) {
          keyOptions.creatorId = this.creatorId;
          this.globalCache.eventKeys.push(keyOptions);
        }
        /**
         * Register Element \<commandset\>. In general, use `registerElementKey` or `registerKey`.
         * @param commandSetOptions
         */
        registerElementCommandset(commandSetOptions) {
          var _a;
          (_a = commandSetOptions.document.querySelector("window")) === null || _a === void 0 ? void 0 : _a.appendChild(this.ui.createElement(commandSetOptions.document, "commandset", {
            id: commandSetOptions.id,
            skipIfExists: true,
            children: commandSetOptions.commands.map((cmd) => ({
              tag: "command",
              id: cmd.id,
              attributes: {
                oncommand: cmd.oncommand,
                disabled: cmd.disabled,
                label: cmd.label
              }
            }))
          }));
        }
        /**
         * Register Element \<command\>. In general, use `registerElementKey` or `registerKey`.
         * @param commandOptions
         */
        registerElementCommand(commandOptions) {
          var _a;
          if (commandOptions._parentId) {
            this.registerElementCommandset({
              id: commandOptions._parentId,
              document: commandOptions.document,
              commands: []
            });
          }
          (_a = commandOptions.document.querySelector(`commandset#${commandOptions._parentId}`)) === null || _a === void 0 ? void 0 : _a.appendChild(this.ui.createElement(commandOptions.document, "command", {
            id: commandOptions.id,
            skipIfExists: true,
            attributes: {
              oncommand: commandOptions.oncommand,
              disabled: commandOptions.disabled,
              label: commandOptions.label
            }
          }));
        }
        /**
         * Register Element \<keyset\>. In general, use `registerElementKey` or `registerKey`.
         * @param keySetOptions
         */
        registerElementKeyset(keySetOptions) {
          var _a;
          (_a = keySetOptions.document.querySelector("window")) === null || _a === void 0 ? void 0 : _a.appendChild(this.ui.createElement(keySetOptions.document, "keyset", {
            id: keySetOptions.id,
            skipIfExists: true,
            children: keySetOptions.keys.map((keyOptions) => ({
              tag: "key",
              id: keyOptions.id,
              attributes: {
                oncommand: keyOptions.xulData.oncommand || "//",
                command: keyOptions.xulData.command,
                modifiers: keyOptions.modifiers,
                key: this.getXULKey(keyOptions.key),
                keycode: this.getXULKeyCode(keyOptions.key),
                disabled: keyOptions.disabled
              }
            }))
          }));
        }
        /**
         * Register a shortcut key element \<key\>.
         * @remarks
         * Provide `_parentId` to register a \<keyset\>;
         *
         * Provide `_commandOptions` to register a \<command\>;
         *
         * Provide `_parentId` in `_commandOptions` to register a \<commandset\>.
         *
         * See examples for more details.
         * @param keyOptions
         * @example
         */
        registerElementKey(keyOptions) {
          var _a;
          const doc = keyOptions.xulData.document || this.getGlobal("document");
          if (keyOptions.xulData._parentId) {
            this.registerElementKeyset({
              id: keyOptions.xulData._parentId,
              document: doc,
              keys: []
            });
          }
          (_a = doc.querySelector(`keyset#${keyOptions.xulData._parentId}`)) === null || _a === void 0 ? void 0 : _a.appendChild(this.ui.createElement(doc, "key", {
            id: keyOptions.id,
            skipIfExists: true,
            attributes: {
              oncommand: keyOptions.xulData.oncommand || "//",
              command: keyOptions.xulData.command,
              modifiers: keyOptions.modifiers,
              key: this.getXULKey(keyOptions.key),
              keycode: this.getXULKeyCode(keyOptions.key),
              disabled: keyOptions.disabled
            }
          }));
          if (keyOptions.xulData._commandOptions) {
            this.registerElementCommand(keyOptions.xulData._commandOptions);
          }
        }
        getXULKey(standardKey) {
          if (standardKey.length === 1) {
            return standardKey;
          }
          return void 0;
        }
        getXULKeyCode(standardKey) {
          const idx = Object.values(XUL_KEYCODE_MAPS).findIndex((value) => value === standardKey);
          if (idx >= 0) {
            return Object.values(XUL_KEYCODE_MAPS)[idx];
          }
          return void 0;
        }
        getStandardKey(XULKey, XULKeyCode) {
          if (XULKeyCode && Object.keys(XUL_KEYCODE_MAPS).includes(XULKeyCode)) {
            return XUL_KEYCODE_MAPS[XULKeyCode];
          } else {
            return XULKey;
          }
        }
        /**
         * Get all \<commandset\> details.
         * @param doc
         */
        getElementCommandSets(doc) {
          return Array.from((doc || this.getGlobal("document")).querySelectorAll("commandset")).map((cmdSet) => ({
            id: cmdSet.id,
            commands: Array.from(cmdSet.querySelectorAll("command")).map((cmd) => ({
              id: cmd.id,
              oncommand: cmd.getAttribute("oncommand"),
              disabled: cmd.getAttribute("disabled") === "true",
              label: cmd.getAttribute("label"),
              _parentId: cmdSet.id
            }))
          }));
        }
        /**
         * Get all \<command\> details.
         * @param doc
         */
        getElementCommands(doc) {
          return Array.prototype.concat(...this.getElementCommandSets(doc).map((cmdSet) => cmdSet.commands));
        }
        /**
         * Get all \<keyset\> details.
         * @param doc
         * @param options
         */
        getElementKeySets(doc) {
          let allCommends = this.getElementCommands(doc);
          return Array.from((doc || this.getGlobal("document")).querySelectorAll("keyset")).map((keysetElem) => ({
            id: keysetElem.id,
            document: doc,
            keys: Array.from(keysetElem.querySelectorAll("key")).map((keyElem) => {
              const oncommand = keyElem.getAttribute("oncommand") || "";
              const commandId = keyElem.getAttribute("command") || "";
              const commandOptions = allCommends.find((cmd) => cmd.id === commandId);
              const key = {
                type: "element",
                id: keyElem.id,
                key: this.getStandardKey(keyElem.getAttribute("key") || "", keyElem.getAttribute("keycode") || ""),
                modifiers: new KeyModifier(keyElem.getAttribute("modifiers") || "").getRaw(),
                disabled: keyElem.getAttribute("disabled") === "true",
                xulData: {
                  document: doc,
                  oncommand,
                  command: commandId,
                  _parentId: keysetElem.id,
                  _commandOptions: commandOptions
                },
                callback: () => {
                  const win = doc.ownerGlobal;
                  const _eval = win.eval;
                  _eval(oncommand);
                  _eval((commandOptions === null || commandOptions === void 0 ? void 0 : commandOptions.oncommand) || "");
                }
              };
              return key;
            })
          }));
        }
        /**
         * Get all \<key\> details.
         * @param doc
         * @param options
         */
        getElementKeys(doc) {
          return Array.prototype.concat(...this.getElementKeySets(doc).map((keyset) => keyset.keys)).filter((elemKey) => !ELEM_KEY_IGNORE.includes(elemKey.id));
        }
        /**
         * Get \<key\> details in main window.
         * @param options
         */
        getMainWindowElementKeys() {
          return this.getElementKeys(this.getGlobal("document"));
        }
        getEventKeys() {
          return this.globalCache.eventKeys;
        }
        /**
         * Get Zotero builtin keys defined in preferences.
         */
        getPrefsKeys() {
          const Zotero2 = this.getGlobal("Zotero");
          return PREF_KEYS.map((pref) => ({
            id: pref.id,
            modifiers: pref.modifiers,
            key: Zotero2.Prefs.get(pref.id),
            callback: pref.callback,
            type: "prefs"
          }));
        }
        /**
         * Get Zotero builtin keys not defined in preferences.
         */
        getBuiltinKeys() {
          return BUILTIN_KEYS.map((builtin) => ({
            id: builtin.id,
            modifiers: builtin.modifiers,
            key: builtin.key,
            callback: builtin.callback,
            type: "builtin"
          }));
        }
      };
      exports.ShortcutManager = ShortcutManager;
      var KeyModifier = class {
        constructor(raw) {
          raw = raw || "";
          this.accel = raw.includes("accel");
          this.shift = raw.includes("shift");
          this.control = raw.includes("control");
          this.meta = raw.includes("meta");
          this.alt = raw.includes("alt");
        }
        equals(newMod) {
          this.accel === newMod.accel;
          this.shift === newMod.shift;
          this.control === newMod.control;
          this.meta === newMod.meta;
          this.alt === newMod.alt;
        }
        getRaw() {
          const enabled = [];
          this.accel && enabled.push("accel");
          this.shift && enabled.push("shift");
          this.control && enabled.push("control");
          this.meta && enabled.push("meta");
          this.alt && enabled.push("alt");
          return enabled.join(",");
        }
      };
      var XUL_KEYCODE_MAPS;
      (function(XUL_KEYCODE_MAPS2) {
        XUL_KEYCODE_MAPS2["VK_CANCEL"] = "Unidentified";
        XUL_KEYCODE_MAPS2["VK_BACK"] = "Backspace";
        XUL_KEYCODE_MAPS2["VK_TAB"] = "Tab";
        XUL_KEYCODE_MAPS2["VK_CLEAR"] = "Clear";
        XUL_KEYCODE_MAPS2["VK_RETURN"] = "Enter";
        XUL_KEYCODE_MAPS2["VK_ENTER"] = "Enter";
        XUL_KEYCODE_MAPS2["VK_SHIFT"] = "Shift";
        XUL_KEYCODE_MAPS2["VK_CONTROL"] = "Control";
        XUL_KEYCODE_MAPS2["VK_ALT"] = "Alt";
        XUL_KEYCODE_MAPS2["VK_PAUSE"] = "Pause";
        XUL_KEYCODE_MAPS2["VK_CAPS_LOCK"] = "CapsLock";
        XUL_KEYCODE_MAPS2["VK_ESCAPE"] = "Escape";
        XUL_KEYCODE_MAPS2["VK_SPACE"] = " ";
        XUL_KEYCODE_MAPS2["VK_PAGE_UP"] = "PageUp";
        XUL_KEYCODE_MAPS2["VK_PAGE_DOWN"] = "PageDown";
        XUL_KEYCODE_MAPS2["VK_END"] = "End";
        XUL_KEYCODE_MAPS2["VK_HOME"] = "Home";
        XUL_KEYCODE_MAPS2["VK_LEFT"] = "ArrowLeft";
        XUL_KEYCODE_MAPS2["VK_UP"] = "ArrowUp";
        XUL_KEYCODE_MAPS2["VK_RIGHT"] = "ArrowRight";
        XUL_KEYCODE_MAPS2["VK_DOWN"] = "ArrowDown";
        XUL_KEYCODE_MAPS2["VK_PRINTSCREEN"] = "PrintScreen";
        XUL_KEYCODE_MAPS2["VK_INSERT"] = "Insert";
        XUL_KEYCODE_MAPS2["VK_DELETE"] = "Backspace";
        XUL_KEYCODE_MAPS2["VK_0"] = "0";
        XUL_KEYCODE_MAPS2["VK_1"] = "1";
        XUL_KEYCODE_MAPS2["VK_2"] = "2";
        XUL_KEYCODE_MAPS2["VK_3"] = "3";
        XUL_KEYCODE_MAPS2["VK_4"] = "4";
        XUL_KEYCODE_MAPS2["VK_5"] = "5";
        XUL_KEYCODE_MAPS2["VK_6"] = "6";
        XUL_KEYCODE_MAPS2["VK_7"] = "7";
        XUL_KEYCODE_MAPS2["VK_8"] = "8";
        XUL_KEYCODE_MAPS2["VK_9"] = "9";
        XUL_KEYCODE_MAPS2["VK_A"] = "A";
        XUL_KEYCODE_MAPS2["VK_B"] = "B";
        XUL_KEYCODE_MAPS2["VK_C"] = "C";
        XUL_KEYCODE_MAPS2["VK_D"] = "D";
        XUL_KEYCODE_MAPS2["VK_E"] = "E";
        XUL_KEYCODE_MAPS2["VK_F"] = "F";
        XUL_KEYCODE_MAPS2["VK_G"] = "G";
        XUL_KEYCODE_MAPS2["VK_H"] = "H";
        XUL_KEYCODE_MAPS2["VK_I"] = "I";
        XUL_KEYCODE_MAPS2["VK_J"] = "J";
        XUL_KEYCODE_MAPS2["VK_K"] = "K";
        XUL_KEYCODE_MAPS2["VK_L"] = "L";
        XUL_KEYCODE_MAPS2["VK_M"] = "M";
        XUL_KEYCODE_MAPS2["VK_N"] = "N";
        XUL_KEYCODE_MAPS2["VK_O"] = "O";
        XUL_KEYCODE_MAPS2["VK_P"] = "P";
        XUL_KEYCODE_MAPS2["VK_Q"] = "Q";
        XUL_KEYCODE_MAPS2["VK_R"] = "R";
        XUL_KEYCODE_MAPS2["VK_S"] = "S";
        XUL_KEYCODE_MAPS2["VK_T"] = "T";
        XUL_KEYCODE_MAPS2["VK_U"] = "U";
        XUL_KEYCODE_MAPS2["VK_V"] = "V";
        XUL_KEYCODE_MAPS2["VK_W"] = "W";
        XUL_KEYCODE_MAPS2["VK_X"] = "X";
        XUL_KEYCODE_MAPS2["VK_Y"] = "Y";
        XUL_KEYCODE_MAPS2["VK_Z"] = "Z";
        XUL_KEYCODE_MAPS2["VK_SEMICOLON"] = "Unidentified";
        XUL_KEYCODE_MAPS2["VK_EQUALS"] = "Unidentified";
        XUL_KEYCODE_MAPS2["VK_NUMPAD0"] = "0";
        XUL_KEYCODE_MAPS2["VK_NUMPAD1"] = "1";
        XUL_KEYCODE_MAPS2["VK_NUMPAD2"] = "2";
        XUL_KEYCODE_MAPS2["VK_NUMPAD3"] = "3";
        XUL_KEYCODE_MAPS2["VK_NUMPAD4"] = "4";
        XUL_KEYCODE_MAPS2["VK_NUMPAD5"] = "5";
        XUL_KEYCODE_MAPS2["VK_NUMPAD6"] = "6";
        XUL_KEYCODE_MAPS2["VK_NUMPAD7"] = "7";
        XUL_KEYCODE_MAPS2["VK_NUMPAD8"] = "8";
        XUL_KEYCODE_MAPS2["VK_NUMPAD9"] = "9";
        XUL_KEYCODE_MAPS2["VK_MULTIPLY"] = "Multiply";
        XUL_KEYCODE_MAPS2["VK_ADD"] = "Add";
        XUL_KEYCODE_MAPS2["VK_SEPARATOR"] = "Separator";
        XUL_KEYCODE_MAPS2["VK_SUBTRACT"] = "Subtract";
        XUL_KEYCODE_MAPS2["VK_DECIMAL"] = "Decimal";
        XUL_KEYCODE_MAPS2["VK_DIVIDE"] = "Divide";
        XUL_KEYCODE_MAPS2["VK_F1"] = "F1";
        XUL_KEYCODE_MAPS2["VK_F2"] = "F2";
        XUL_KEYCODE_MAPS2["VK_F3"] = "F3";
        XUL_KEYCODE_MAPS2["VK_F4"] = "F4";
        XUL_KEYCODE_MAPS2["VK_F5"] = "F5";
        XUL_KEYCODE_MAPS2["VK_F6"] = "F6";
        XUL_KEYCODE_MAPS2["VK_F7"] = "F7";
        XUL_KEYCODE_MAPS2["VK_F8"] = "F8";
        XUL_KEYCODE_MAPS2["VK_F9"] = "F9";
        XUL_KEYCODE_MAPS2["VK_F10"] = "F10";
        XUL_KEYCODE_MAPS2["VK_F11"] = "F11";
        XUL_KEYCODE_MAPS2["VK_F12"] = "F12";
        XUL_KEYCODE_MAPS2["VK_F13"] = "F13";
        XUL_KEYCODE_MAPS2["VK_F14"] = "F14";
        XUL_KEYCODE_MAPS2["VK_F15"] = "F15";
        XUL_KEYCODE_MAPS2["VK_F16"] = "F16";
        XUL_KEYCODE_MAPS2["VK_F17"] = "F17";
        XUL_KEYCODE_MAPS2["VK_F18"] = "F18";
        XUL_KEYCODE_MAPS2["VK_F19"] = "F19";
        XUL_KEYCODE_MAPS2["VK_F20"] = "F20";
        XUL_KEYCODE_MAPS2["VK_F21"] = "Soft1";
        XUL_KEYCODE_MAPS2["VK_F22"] = "Soft2";
        XUL_KEYCODE_MAPS2["VK_F23"] = "Soft3";
        XUL_KEYCODE_MAPS2["VK_F24"] = "Soft4";
        XUL_KEYCODE_MAPS2["VK_NUM_LOCK"] = "NumLock";
        XUL_KEYCODE_MAPS2["VK_SCROLL_LOCK"] = "ScrollLock";
        XUL_KEYCODE_MAPS2["VK_COMMA"] = ",";
        XUL_KEYCODE_MAPS2["VK_PERIOD"] = ".";
        XUL_KEYCODE_MAPS2["VK_SLASH"] = "Divide";
        XUL_KEYCODE_MAPS2["VK_BACK_QUOTE"] = "`";
        XUL_KEYCODE_MAPS2["VK_OPEN_BRACKET"] = "[";
        XUL_KEYCODE_MAPS2["VK_CLOSE_BRACKET"] = "]";
        XUL_KEYCODE_MAPS2["VK_QUOTE"] = "\\";
        XUL_KEYCODE_MAPS2["VK_HELP"] = "Help";
      })(XUL_KEYCODE_MAPS || (XUL_KEYCODE_MAPS = {}));
      function getElementKeyCallback(keyId) {
        return function() {
          var _a;
          const win = basic_1.BasicTool.getZotero().getMainWindow();
          const keyElem = win.document.querySelector(`#${keyId}`);
          if (!keyElem) {
            return function() {
            };
          }
          const _eval = win.eval;
          _eval(keyElem.getAttribute("oncommand") || "//");
          const cmdId = keyElem.getAttribute("command");
          if (!cmdId) {
            return;
          }
          _eval(((_a = win.document.querySelector(`#${cmdId}`)) === null || _a === void 0 ? void 0 : _a.getAttribute("oncommand")) || "//");
        };
      }
      function getBuiltinEventKeyCallback(eventId) {
        return function() {
          const Zotero2 = basic_1.BasicTool.getZotero();
          const ZoteroPane2 = Zotero2.getActiveZoteroPane();
          ZoteroPane2.handleKeyPress({
            metaKey: true,
            ctrlKey: true,
            shiftKey: true,
            originalTarget: { id: "" },
            preventDefault: () => {
            },
            key: Zotero2.Prefs.get(`extensions.zotero.keys.${eventId}`, true)
          });
        };
      }
      var ELEM_KEY_IGNORE = ["key_copyCitation", "key_copyBibliography"];
      var PREF_KEYS = [
        {
          id: "extensions.zotero.keys.copySelectedItemCitationsToClipboard",
          modifiers: "accel,shift",
          elemId: "key_copyCitation",
          callback: getElementKeyCallback("key_copyCitation")
        },
        {
          id: "extensions.zotero.keys.copySelectedItemsToClipboard",
          modifiers: "accel,shift",
          elemId: "key_copyBibliography",
          callback: getElementKeyCallback("key_copyBibliography")
        },
        {
          id: "extensions.zotero.keys.library",
          modifiers: "accel,shift",
          callback: getBuiltinEventKeyCallback("library")
        },
        {
          id: "extensions.zotero.keys.newItem",
          modifiers: "accel,shift",
          callback: getBuiltinEventKeyCallback("newItem")
        },
        {
          id: "extensions.zotero.keys.newNote",
          modifiers: "accel,shift",
          callback: getBuiltinEventKeyCallback("newNote")
        },
        {
          id: "extensions.zotero.keys.quicksearch",
          modifiers: "accel,shift",
          callback: getBuiltinEventKeyCallback("quicksearch")
        },
        {
          id: "extensions.zotero.keys.saveToZotero",
          modifiers: "accel,shift",
          callback: getBuiltinEventKeyCallback("saveToZotero")
        },
        {
          id: "extensions.zotero.keys.sync",
          modifiers: "accel,shift",
          callback: getBuiltinEventKeyCallback("sync")
        },
        {
          id: "extensions.zotero.keys.toggleAllRead",
          modifiers: "accel,shift",
          callback: getBuiltinEventKeyCallback("toggleAllRead")
        },
        {
          id: "extensions.zotero.keys.toggleRead",
          modifiers: "accel,shift",
          callback: getBuiltinEventKeyCallback("toggleRead")
        }
      ];
      var BUILTIN_KEYS = [
        {
          id: "showItemCollection",
          modifiers: "",
          key: "Ctrl",
          callback: () => {
            const Zotero2 = basic_1.BasicTool.getZotero();
            const ZoteroPane2 = Zotero2.getActiveZoteroPane();
            ZoteroPane2.handleKeyUp({
              originalTarget: { id: ZoteroPane2.itemsView.id },
              keyCode: Zotero2.isWin ? 17 : 18
            });
          }
        },
        {
          id: "closeSelectedTab",
          modifiers: "accel",
          key: "W",
          callback: () => {
            const ztabs = basic_1.BasicTool.getZotero().getMainWindow().Zotero_Tabs;
            if (ztabs.selectedIndex > 0) {
              ztabs.close("");
            }
          }
        },
        {
          id: "undoCloseTab",
          modifiers: "accel,shift",
          key: "T",
          callback: () => {
            const ztabs = basic_1.BasicTool.getZotero().getMainWindow().Zotero_Tabs;
            ztabs.undoClose();
          }
        },
        {
          id: "selectNextTab",
          modifiers: "control",
          key: "Tab",
          callback: () => {
            const ztabs = basic_1.BasicTool.getZotero().getMainWindow().Zotero_Tabs;
            ztabs.selectPrev();
          }
        },
        {
          id: "selectPreviousTab",
          modifiers: "control,shift",
          key: "Tab",
          callback: () => {
            const ztabs = basic_1.BasicTool.getZotero().getMainWindow().Zotero_Tabs;
            ztabs.selectNext();
          }
        },
        {
          id: "selectTab1",
          modifiers: "accel",
          key: "1",
          callback: () => {
            const ztabs = basic_1.BasicTool.getZotero().getMainWindow().Zotero_Tabs;
            ztabs.jump(0);
          }
        },
        {
          id: "selectTab2",
          modifiers: "accel",
          key: "2",
          callback: () => {
            const ztabs = basic_1.BasicTool.getZotero().getMainWindow().Zotero_Tabs;
            ztabs.jump(1);
          }
        },
        {
          id: "selectTab3",
          modifiers: "accel",
          key: "3",
          callback: () => {
            const ztabs = basic_1.BasicTool.getZotero().getMainWindow().Zotero_Tabs;
            ztabs.jump(2);
          }
        },
        {
          id: "selectTab4",
          modifiers: "accel",
          key: "4",
          callback: () => {
            const ztabs = basic_1.BasicTool.getZotero().getMainWindow().Zotero_Tabs;
            ztabs.jump(3);
          }
        },
        {
          id: "selectTab5",
          modifiers: "accel",
          key: "5",
          callback: () => {
            const ztabs = basic_1.BasicTool.getZotero().getMainWindow().Zotero_Tabs;
            ztabs.jump(4);
          }
        },
        {
          id: "selectTab6",
          modifiers: "accel",
          key: "6",
          callback: () => {
            const ztabs = basic_1.BasicTool.getZotero().getMainWindow().Zotero_Tabs;
            ztabs.jump(5);
          }
        },
        {
          id: "selectTab7",
          modifiers: "accel",
          key: "7",
          callback: () => {
            const ztabs = basic_1.BasicTool.getZotero().getMainWindow().Zotero_Tabs;
            ztabs.jump(6);
          }
        },
        {
          id: "selectTab8",
          modifiers: "accel",
          key: "8",
          callback: () => {
            const ztabs = basic_1.BasicTool.getZotero().getMainWindow().Zotero_Tabs;
            ztabs.jump(7);
          }
        },
        {
          id: "selectTabLast",
          modifiers: "accel",
          key: "9",
          callback: () => {
            const ztabs = basic_1.BasicTool.getZotero().getMainWindow().Zotero_Tabs;
            ztabs.selectLast();
          }
        }
      ];
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/helpers/clipboard.js
  var require_clipboard = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/helpers/clipboard.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ClipboardHelper = void 0;
      var basic_1 = require_basic();
      var ClipboardHelper = class {
        constructor() {
          this.transferable = Components.classes["@mozilla.org/widget/transferable;1"].createInstance(Components.interfaces.nsITransferable);
          this.clipboardService = Components.classes["@mozilla.org/widget/clipboard;1"].getService(Components.interfaces.nsIClipboard);
          this.transferable.init(null);
        }
        addText(source, type) {
          const str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
          str.data = source;
          this.transferable.addDataFlavor(type);
          this.transferable.setTransferData(type, str, source.length * 2);
          return this;
        }
        addImage(source) {
          let parts = source.split(",");
          if (!parts[0].includes("base64")) {
            return this;
          }
          const basicTool2 = new basic_1.BasicTool();
          let mime = parts[0].match(/:(.*?);/)[1];
          let bstr = basicTool2.getGlobal("window").atob(parts[1]);
          let n = bstr.length;
          let u8arr = new Uint8Array(n);
          while (n--) {
            u8arr[n] = bstr.charCodeAt(n);
          }
          let imgTools = Components.classes["@mozilla.org/image/tools;1"].getService(Components.interfaces.imgITools);
          let mimeType;
          let img;
          if (basicTool2.getGlobal("Zotero").platformMajorVersion >= 102) {
            img = imgTools.decodeImageFromArrayBuffer(u8arr.buffer, mime);
            mimeType = "application/x-moz-nativeimage";
          } else {
            mimeType = `image/png`;
            img = Components.classes["@mozilla.org/supports-interface-pointer;1"].createInstance(Components.interfaces.nsISupportsInterfacePointer);
            img.data = imgTools.decodeImageFromArrayBuffer(u8arr.buffer, mimeType);
          }
          this.transferable.addDataFlavor(mimeType);
          this.transferable.setTransferData(mimeType, img, 0);
          return this;
        }
        copy() {
          this.clipboardService.setData(this.transferable, null, Components.interfaces.nsIClipboard.kGlobalClipboard);
          return this;
        }
      };
      exports.ClipboardHelper = ClipboardHelper;
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/helpers/filePicker.js
  var require_filePicker = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/helpers/filePicker.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FilePickerHelper = void 0;
      var basic_1 = require_basic();
      var FilePickerHelper = class {
        constructor(title, mode, filters, suggestion, window2, filterMask) {
          this.title = title;
          this.mode = mode;
          this.filters = filters;
          this.suggestion = suggestion;
          this.window = window2;
          this.filterMask = filterMask;
        }
        async open() {
          const basicTool2 = new basic_1.BasicTool();
          const backend = basicTool2.getGlobal("require")("zotero/modules/filePicker").default;
          const fp = new backend();
          fp.init(this.window || basicTool2.getGlobal("window"), this.title, this.getMode(fp));
          for (const [label, ext] of this.filters || []) {
            fp.appendFilter(label, ext);
          }
          if (this.filterMask)
            fp.appendFilters(this.getFilterMask(fp));
          if (this.suggestion)
            fp.defaultString = this.suggestion;
          const userChoice = await fp.show();
          switch (userChoice) {
            case fp.returnOK:
            case fp.returnReplace:
              return fp.file;
            default:
              return false;
          }
        }
        getMode(fp) {
          switch (this.mode) {
            case "open":
              return fp.modeOpen;
            case "save":
              return fp.modeSave;
            case "folder":
              return fp.modeGetFolder;
            case "multiple":
              return fp.modeOpenMultiple;
            default:
              return 0;
          }
        }
        getFilterMask(fp) {
          switch (this.filterMask) {
            case "all":
              return fp.filterAll;
            case "html":
              return fp.filterHTML;
            case "text":
              return fp.filterText;
            case "images":
              return fp.filterImages;
            case "xml":
              return fp.filterXML;
            case "apps":
              return fp.filterApps;
            case "urls":
              return fp.filterAllowURLs;
            case "audio":
              return fp.filterAudio;
            case "video":
              return fp.filterVideo;
            default:
              return 1;
          }
        }
      };
      exports.FilePickerHelper = FilePickerHelper;
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/helpers/progressWindow.js
  var require_progressWindow = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/helpers/progressWindow.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ProgressWindowHelper = void 0;
      var basic_1 = require_basic();
      var ProgressWindowHelper = class extends Zotero.ProgressWindow {
        /**
         *
         * @param header window header
         * @param options
         */
        constructor(header, options = {
          closeOnClick: true,
          closeTime: 5e3
        }) {
          super(options);
          this.lines = [];
          this.closeTime = options.closeTime || 5e3;
          this.changeHeadline(header);
          this.originalShow = this.show;
          this.show = this.showWithTimer;
          if (options.closeOtherProgressWindows) {
            basic_1.BasicTool.getZotero().ProgressWindowSet.closeAll();
          }
        }
        /**
         * Create a new line
         * @param options
         */
        createLine(options) {
          const icon = this.getIcon(options.type, options.icon);
          const line = new this.ItemProgress(icon || "", options.text || "");
          if (typeof options.progress === "number") {
            line.setProgress(options.progress);
          }
          this.lines.push(line);
          return this;
        }
        /**
         * Change the line content
         * @param options
         */
        changeLine(options) {
          var _a;
          if (((_a = this.lines) === null || _a === void 0 ? void 0 : _a.length) === 0) {
            return this;
          }
          const idx = typeof options.idx !== "undefined" && options.idx >= 0 && options.idx < this.lines.length ? options.idx : 0;
          const icon = this.getIcon(options.type, options.icon);
          options.text && this.lines[idx].setText(options.text);
          icon && this.lines[idx].setIcon(icon);
          typeof options.progress === "number" && this.lines[idx].setProgress(options.progress);
          return this;
        }
        showWithTimer(closeTime = void 0) {
          this.originalShow();
          typeof closeTime !== "undefined" && (this.closeTime = closeTime);
          if (this.closeTime && this.closeTime > 0) {
            this.startCloseTimer(this.closeTime);
          }
          return this;
        }
        /**
         * Set custom icon uri for progress window
         * @param key
         * @param uri
         */
        static setIconURI(key, uri) {
          icons[key] = uri;
        }
        getIcon(type, defaultIcon) {
          return type && type in icons ? icons[type] : defaultIcon;
        }
      };
      exports.ProgressWindowHelper = ProgressWindowHelper;
      var icons = {
        success: "chrome://zotero/skin/tick.png",
        fail: "chrome://zotero/skin/cross.png"
      };
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/helpers/virtualizedTable.js
  var require_virtualizedTable = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/helpers/virtualizedTable.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.VirtualizedTableHelper = void 0;
      var basic_1 = require_basic();
      var VirtualizedTableHelper = class {
        constructor(win) {
          this.window = win;
          this.basicTool = new basic_1.BasicTool();
          const Zotero2 = this.basicTool.getGlobal("Zotero");
          const _require = win.require;
          this.React = _require("react");
          this.ReactDOM = _require("react-dom");
          this.VirtualizedTable = _require("components/virtualized-table");
          this.IntlProvider = _require("react-intl").IntlProvider;
          this.props = {
            id: `${Zotero2.Utilities.randomString()}-${(/* @__PURE__ */ new Date()).getTime()}`,
            getRowCount: () => 0
          };
          this.localeStrings = Zotero2.Intl.strings;
        }
        setProp(...args) {
          if (args.length === 1) {
            Object.assign(this.props, args[0]);
          } else if (args.length === 2) {
            this.props[args[0]] = args[1];
          }
          return this;
        }
        /**
         * Set locale strings, which replaces the table header's label if matches. Default it's `Zotero.Intl.strings`
         * @param localeStrings
         */
        setLocale(localeStrings) {
          Object.assign(this.localeStrings, localeStrings);
          return this;
        }
        /**
         * Set container element id that the table will be rendered on.
         * @param id element id
         */
        setContainerId(id) {
          this.containerId = id;
          return this;
        }
        /**
         * Render the table.
         * @param selectId Which row to select after rendering
         * @param onfulfilled callback after successfully rendered
         * @param onrejected callback after rendering with error
         */
        render(selectId, onfulfilled, onrejected) {
          const refreshSelection = () => {
            this.treeInstance.invalidate();
            if (typeof selectId !== "undefined" && selectId >= 0) {
              this.treeInstance.selection.select(selectId);
            } else {
              this.treeInstance.selection.clearSelection();
            }
          };
          if (!this.treeInstance) {
            const vtableProps = Object.assign({}, this.props, {
              ref: (ref) => this.treeInstance = ref
            });
            if (vtableProps.getRowData && !vtableProps.renderItem) {
              Object.assign(vtableProps, {
                renderItem: this.VirtualizedTable.makeRowRenderer(vtableProps.getRowData)
              });
            }
            const elem = this.React.createElement(this.IntlProvider, { locale: Zotero.locale, messages: Zotero.Intl.strings }, this.React.createElement(this.VirtualizedTable, vtableProps));
            const container = this.window.document.getElementById(this.containerId);
            new Promise((resolve) => this.ReactDOM.render(elem, container, resolve)).then(() => {
              this.basicTool.getGlobal("setTimeout")(() => {
                refreshSelection();
              });
            }).then(onfulfilled, onrejected);
          } else {
            refreshSelection();
          }
          return this;
        }
      };
      exports.VirtualizedTableHelper = VirtualizedTableHelper;
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/helpers/dialog.js
  var require_dialog = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/helpers/dialog.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.DialogHelper = void 0;
      var ui_1 = require_ui();
      var DialogHelper = class {
        /**
         * Create a dialog helper with row \* column grids.
         * @param row
         * @param column
         */
        constructor(row, column) {
          if (row <= 0 || column <= 0) {
            throw Error(`row and column must be positive integers.`);
          }
          this.elementProps = {
            tag: "vbox",
            attributes: { flex: 1 },
            styles: {
              width: "100%",
              height: "100%"
            },
            children: []
          };
          for (let i = 0; i < Math.max(row, 1); i++) {
            this.elementProps.children.push({
              tag: "hbox",
              attributes: { flex: 1 },
              children: []
            });
            for (let j = 0; j < Math.max(column, 1); j++) {
              this.elementProps.children[i].children.push({
                tag: "vbox",
                attributes: { flex: 1 },
                children: []
              });
            }
          }
          this.elementProps.children.push({
            tag: "hbox",
            attributes: { flex: 0, pack: "end" },
            children: []
          });
          this.dialogData = {};
        }
        /**
         * Add a cell at (row, column). Index starts from 0.
         * @param row
         * @param column
         * @param elementProps Cell element props. See {@link ElementProps}
         * @param cellFlex If the cell is flex. Default true.
         */
        addCell(row, column, elementProps, cellFlex = true) {
          if (row >= this.elementProps.children.length || column >= this.elementProps.children[row].children.length) {
            throw Error(`Cell index (${row}, ${column}) is invalid, maximum (${this.elementProps.children.length}, ${this.elementProps.children[0].children.length})`);
          }
          this.elementProps.children[row].children[column].children = [
            elementProps
          ];
          this.elementProps.children[row].children[column].attributes.flex = cellFlex ? 1 : 0;
          return this;
        }
        /**
         * Add a control button to the bottom of the dialog.
         * @param label Button label
         * @param id Button id.
         * The corresponding id of the last button user clicks before window exit will be set to `dialogData._lastButtonId`.
         * @param options.noClose Don't close window when clicking this button.
         * @param options.callback Callback of button click event.
         */
        addButton(label, id, options = {}) {
          id = id || `${Zotero.Utilities.randomString()}-${(/* @__PURE__ */ new Date()).getTime()}`;
          this.elementProps.children[this.elementProps.children.length - 1].children.push({
            tag: "vbox",
            styles: {
              margin: "10px"
            },
            children: [
              {
                tag: "button",
                namespace: "html",
                id,
                attributes: {
                  type: "button"
                },
                listeners: [
                  {
                    type: "click",
                    listener: (e) => {
                      this.dialogData._lastButtonId = id;
                      if (options.callback) {
                        options.callback(e);
                      }
                      if (!options.noClose) {
                        this.window.close();
                      }
                    }
                  }
                ],
                children: [
                  {
                    tag: "div",
                    styles: {
                      padding: "2.5px 15px"
                    },
                    properties: {
                      innerHTML: label
                    }
                  }
                ]
              }
            ]
          });
          return this;
        }
        /**
         * Dialog data.
         * @remarks
         * This object is passed to the dialog window.
         *
         * The control button id is in `dialogData._lastButtonId`;
         *
         * The data-binding values are in `dialogData`.
         * ```ts
         * interface DialogData {
         *   [key: string | number | symbol]: any;
         *   loadLock?: _ZoteroTypes.PromiseObject; // resolve after window load (auto-generated)
         *   loadCallback?: Function; // called after window load
         *   unloadLock?: _ZoteroTypes.PromiseObject; // resolve after window unload (auto-generated)
         *   unloadCallback?: Function; // called after window unload
         *   beforeUnloadCallback?: Function; // called before window unload when elements are accessable.
         * }
         * ```
         * @param dialogData
         */
        setDialogData(dialogData) {
          this.dialogData = dialogData;
          return this;
        }
        /**
         * Open the dialog
         * @param title Window title
         * @param windowFeatures.width Ignored if fitContent is `true`.
         * @param windowFeatures.height Ignored if fitContent is `true`.
         * @param windowFeatures.left
         * @param windowFeatures.top
         * @param windowFeatures.centerscreen Open window at the center of screen.
         * @param windowFeatures.resizable If window is resizable.
         * @param windowFeatures.fitContent Resize the window to content size after elements are loaded.
         * @param windowFeatures.noDialogMode Dialog mode window only has a close button. Set `true` to make maximize and minimize button visible.
         */
        open(title, windowFeatures = {
          centerscreen: true,
          resizable: true,
          fitContent: true
        }) {
          this.window = openDialog(`${Zotero.Utilities.randomString()}-${(/* @__PURE__ */ new Date()).getTime()}`, title, this.elementProps, this.dialogData, windowFeatures);
          return this;
        }
      };
      exports.DialogHelper = DialogHelper;
      function openDialog(targetId, title, elementProps, dialogData, windowFeatures = {
        centerscreen: true,
        resizable: true,
        fitContent: true
      }) {
        var _a, _b;
        const uiTool = new ui_1.UITool();
        uiTool.basicOptions.ui.enableElementJSONLog = false;
        uiTool.basicOptions.ui.enableElementRecord = false;
        const Zotero2 = uiTool.getGlobal("Zotero");
        dialogData = dialogData || {};
        if (!dialogData.loadLock) {
          dialogData.loadLock = Zotero2.Promise.defer();
        }
        if (!dialogData.unloadLock) {
          dialogData.unloadLock = Zotero2.Promise.defer();
        }
        let featureString = `resizable=${windowFeatures.resizable ? "yes" : "no"},`;
        if (windowFeatures.width || windowFeatures.height) {
          featureString += `width=${windowFeatures.width || 100},height=${windowFeatures.height || 100},`;
        }
        if (windowFeatures.left) {
          featureString += `left=${windowFeatures.left},`;
        }
        if (windowFeatures.top) {
          featureString += `left=${windowFeatures.top},`;
        }
        if (windowFeatures.centerscreen) {
          featureString += "centerscreen,";
        }
        if (windowFeatures.noDialogMode) {
          featureString += "dialog=no,";
        }
        const win = uiTool.getGlobal("openDialog")("about:blank", targetId || "_blank", featureString, dialogData);
        dialogData.loadLock.promise.then(() => {
          win.document.head.appendChild(uiTool.createElement(win.document, "title", {
            properties: { innerText: title }
          }));
          win.document.head.appendChild(uiTool.createElement(win.document, "style", {
            properties: {
              innerHTML: style
            }
          }));
          replaceElement(elementProps, uiTool);
          win.document.body.appendChild(uiTool.createElement(win.document, "fragment", {
            children: [elementProps]
          }));
          Array.from(win.document.querySelectorAll("*[data-bind]")).forEach((elem) => {
            const bindKey = elem.getAttribute("data-bind");
            const bindAttr = elem.getAttribute("data-attr");
            const bindProp = elem.getAttribute("data-prop");
            if (bindKey && dialogData && dialogData[bindKey]) {
              if (bindProp) {
                elem[bindProp] = dialogData[bindKey];
              } else {
                elem.setAttribute(bindAttr || "value", dialogData[bindKey]);
              }
            }
          });
          if (windowFeatures.fitContent) {
            win.sizeToContent();
          }
          win.focus();
        }).then(() => {
          (dialogData === null || dialogData === void 0 ? void 0 : dialogData.loadCallback) && dialogData.loadCallback();
        });
        dialogData.unloadLock.promise.then(() => {
          (dialogData === null || dialogData === void 0 ? void 0 : dialogData.unloadCallback) && dialogData.unloadCallback();
        });
        win.addEventListener("DOMContentLoaded", function onWindowLoad(ev) {
          var _a2, _b2;
          (_b2 = (_a2 = win.arguments[0]) === null || _a2 === void 0 ? void 0 : _a2.loadLock) === null || _b2 === void 0 ? void 0 : _b2.resolve();
          win.removeEventListener("DOMContentLoaded", onWindowLoad, false);
        }, false);
        win.addEventListener("beforeunload", function onWindowBeforeUnload(ev) {
          Array.from(win.document.querySelectorAll("*[data-bind]")).forEach((elem) => {
            const dialogData2 = this.window.arguments[0];
            const bindKey = elem.getAttribute("data-bind");
            const bindAttr = elem.getAttribute("data-attr");
            const bindProp = elem.getAttribute("data-prop");
            if (bindKey && dialogData2) {
              if (bindProp) {
                dialogData2[bindKey] = elem[bindProp];
              } else {
                dialogData2[bindKey] = elem.getAttribute(bindAttr || "value");
              }
            }
          });
          this.window.removeEventListener("beforeunload", onWindowBeforeUnload, false);
          (dialogData === null || dialogData === void 0 ? void 0 : dialogData.beforeUnloadCallback) && dialogData.beforeUnloadCallback();
        });
        win.addEventListener("unload", function onWindowUnload(ev) {
          var _a2, _b2, _c;
          if ((_a2 = this.window.arguments[0]) === null || _a2 === void 0 ? void 0 : _a2.loadLock.promise.isPending()) {
            return;
          }
          (_c = (_b2 = this.window.arguments[0]) === null || _b2 === void 0 ? void 0 : _b2.unloadLock) === null || _c === void 0 ? void 0 : _c.resolve();
          this.window.removeEventListener("unload", onWindowUnload, false);
        });
        if (win.document.readyState === "complete") {
          (_b = (_a = win.arguments[0]) === null || _a === void 0 ? void 0 : _a.loadLock) === null || _b === void 0 ? void 0 : _b.resolve();
        }
        return win;
      }
      function replaceElement(elementProps, uiTool) {
        var _a, _b, _c, _d, _e, _f, _g;
        let checkChildren = true;
        if (elementProps.tag === "select" && uiTool.isZotero7()) {
          checkChildren = false;
          const customSelectProps = {
            tag: "div",
            classList: ["dropdown"],
            listeners: [
              {
                type: "mouseleave",
                listener: (ev) => {
                  const select = ev.target.querySelector("select");
                  select === null || select === void 0 ? void 0 : select.blur();
                }
              }
            ],
            children: [
              Object.assign({}, elementProps, {
                tag: "select",
                listeners: [
                  {
                    type: "focus",
                    listener: (ev) => {
                      var _a2;
                      const select = ev.target;
                      const dropdown = (_a2 = select.parentElement) === null || _a2 === void 0 ? void 0 : _a2.querySelector(".dropdown-content");
                      dropdown && (dropdown.style.display = "block");
                      select.setAttribute("focus", "true");
                    }
                  },
                  {
                    type: "blur",
                    listener: (ev) => {
                      var _a2;
                      const select = ev.target;
                      const dropdown = (_a2 = select.parentElement) === null || _a2 === void 0 ? void 0 : _a2.querySelector(".dropdown-content");
                      dropdown && (dropdown.style.display = "none");
                      select.removeAttribute("focus");
                    }
                  }
                ]
              }),
              {
                tag: "div",
                classList: ["dropdown-content"],
                children: (_a = elementProps.children) === null || _a === void 0 ? void 0 : _a.map((option) => {
                  var _a2, _b2, _c2;
                  return {
                    tag: "p",
                    attributes: {
                      value: (_a2 = option.properties) === null || _a2 === void 0 ? void 0 : _a2.value
                    },
                    properties: {
                      innerHTML: ((_b2 = option.properties) === null || _b2 === void 0 ? void 0 : _b2.innerHTML) || ((_c2 = option.properties) === null || _c2 === void 0 ? void 0 : _c2.innerText)
                    },
                    classList: ["dropdown-item"],
                    listeners: [
                      {
                        type: "click",
                        listener: (ev) => {
                          var _a3;
                          const select = (_a3 = ev.target.parentElement) === null || _a3 === void 0 ? void 0 : _a3.previousElementSibling;
                          select && (select.value = ev.target.getAttribute("value") || "");
                          select === null || select === void 0 ? void 0 : select.blur();
                        }
                      }
                    ]
                  };
                })
              }
            ]
          };
          for (const key in elementProps) {
            delete elementProps[key];
          }
          Object.assign(elementProps, customSelectProps);
        } else if (elementProps.tag === "a") {
          const href = ((_b = elementProps === null || elementProps === void 0 ? void 0 : elementProps.properties) === null || _b === void 0 ? void 0 : _b.href) || "";
          (_c = elementProps.properties) !== null && _c !== void 0 ? _c : elementProps.properties = {};
          elementProps.properties.href = "javascript:void(0);";
          (_d = elementProps.attributes) !== null && _d !== void 0 ? _d : elementProps.attributes = {};
          elementProps.attributes["zotero-href"] = href;
          (_e = elementProps.listeners) !== null && _e !== void 0 ? _e : elementProps.listeners = [];
          elementProps.listeners.push({
            type: "click",
            listener: (ev) => {
              var _a2;
              const href2 = (_a2 = ev.target) === null || _a2 === void 0 ? void 0 : _a2.getAttribute("zotero-href");
              href2 && uiTool.getGlobal("Zotero").launchURL(href2);
            }
          });
          (_f = elementProps.classList) !== null && _f !== void 0 ? _f : elementProps.classList = [];
          elementProps.classList.push("zotero-text-link");
        }
        if (checkChildren) {
          (_g = elementProps.children) === null || _g === void 0 ? void 0 : _g.forEach((child) => replaceElement(child, uiTool));
        }
      }
      var style = `
html,
body {
  font-size: calc(12px * 1);
}
.zotero-text-link {
  -moz-user-focus: normal;
  color: -moz-nativehyperlinktext;
  text-decoration: underline;
  border: 1px solid transparent;
  cursor: pointer;
}
.dropdown {
  position: relative;
  display: inline-block;
}
.dropdown-content {
  display: none;
  position: absolute;
  background-color: #f9f9fb;
  min-width: 160px;
  box-shadow: 0px 0px 5px 0px rgba(0, 0, 0, 0.5);
  border-radius: 5px;
  padding: 5px 0 5px 0;
  z-index: 999;
}
.dropdown-item {
  margin: 0px;
  padding: 5px 10px 5px 10px;
}
.dropdown-item:hover {
  background-color: #efeff3;
}
`;
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/managers/readerInstance.js
  var require_readerInstance = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/managers/readerInstance.js"(exports) {
      "use strict";
      var __importDefault2 = exports && exports.__importDefault || function(mod) {
        return mod && mod.__esModule ? mod : { "default": mod };
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ReaderInstanceManager = void 0;
      var basic_1 = require_basic();
      var toolkitGlobal_1 = __importDefault2(require_toolkitGlobal());
      var ReaderInstanceManager = class extends basic_1.ManagerTool {
        constructor(base) {
          super(base);
          this.cachedHookIds = [];
          this.initializeGlobal();
        }
        /**
         * Register a reader instance hook
         * @remarks
         * initialized: called when reader instance is ready
         * @param type hook type
         * @param id hook id
         * @param hook
         */
        register(type, id, hook) {
          const Zotero2 = this.getGlobal("Zotero");
          switch (type) {
            case "initialized":
              {
                this.globalCache.initializedHooks[id] = hook;
                Zotero2.Reader._readers.forEach(hook);
              }
              break;
            default:
              break;
          }
          this.cachedHookIds.push(id);
        }
        /**
         * Unregister hook by id
         * @param id
         */
        unregister(id) {
          delete this.globalCache.initializedHooks[id];
        }
        /**
         * Unregister all hooks
         */
        unregisterAll() {
          this.cachedHookIds.forEach((id) => this.unregister(id));
        }
        initializeGlobal() {
          this.globalCache = toolkitGlobal_1.default.getInstance().readerInstance;
          if (!this.globalCache._ready) {
            this.globalCache._ready = true;
            const Zotero2 = this.getGlobal("Zotero");
            const _this = this;
            Zotero2.Reader._readers = new (this.getGlobal("Proxy"))(Zotero2.Reader._readers, {
              set(target, p, newValue, receiver) {
                target[p] = newValue;
                if (!isNaN(Number(p))) {
                  Object.values(_this.globalCache.initializedHooks).forEach((hook) => {
                    try {
                      hook(newValue);
                    } catch (e) {
                      _this.log(e);
                    }
                  });
                }
                return true;
              }
            });
          }
        }
      };
      exports.ReaderInstanceManager = ReaderInstanceManager;
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/managers/itemBox.js
  var require_itemBox = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/managers/itemBox.js"(exports) {
      "use strict";
      var __importDefault2 = exports && exports.__importDefault || function(mod) {
        return mod && mod.__esModule ? mod : { "default": mod };
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ItemBoxManager = void 0;
      var basic_1 = require_basic();
      var fieldHook_1 = require_fieldHook();
      var toolkitGlobal_1 = __importDefault2(require_toolkitGlobal());
      var ItemBoxManager = class extends basic_1.ManagerTool {
        constructor(base) {
          super(base);
          this.initializationLock = this.getGlobal("Zotero").Promise.defer();
          this.localCache = [];
          this.fieldHooks = new fieldHook_1.FieldHookManager();
          this.initializeGlobal();
        }
        /**
         * Register a custom row
         * @param field Field name. Used in `getField` and `setField`.
         * @param displayName The row header display text.
         * @param getFieldHook Called when loading row content.
         * If you registered the getField hook somewhere else (in ItemBox or FieldHooks), leave it undefined.
         * @param options
         * @param options.editable If the row is editable.
         * To edit a row, either the `options.setFieldHook` or a custom hook for `setField` created by FieldHookManager is required.
         * @param options.setFieldHook The `setField` hook.
         * @param options.index Target index. By default it's placed at the end of rows.
         * @param options.multiline If the row content is multiline.
         * @param options.collapsible If the row content is collapsible (like abstract field).
         */
        async register(field, displayName, getFieldHook, options = {}) {
          this.fieldHooks.register("isFieldOfBase", field, () => false);
          if (getFieldHook) {
            this.fieldHooks.register("getField", field, getFieldHook);
          }
          if (options.editable && options.setFieldHook) {
            this.fieldHooks.register("setField", field, options.setFieldHook);
          }
          this.globalCache.fieldOptions[field] = {
            field,
            displayName,
            editable: options.editable || false,
            index: options.index || -1,
            multiline: options.multiline || false,
            collapsible: options.collapsible || false
          };
          this.localCache.push(field);
          await this.initializationLock.promise;
          this.refresh();
        }
        /**
         * Unregister a row of specific field.
         * @param field
         * @param options Skip unregister of certain hooks.
         * This is useful when the hook is not initialized by this instance
         * @param options.skipRefresh Skip refresh after unregister.
         */
        unregister(field, options = {}) {
          delete this.globalCache.fieldOptions[field];
          if (!options.skipIsFieldOfBase) {
            this.fieldHooks.unregister("isFieldOfBase", field);
          }
          if (!options.skipGetField) {
            this.fieldHooks.unregister("getField", field);
          }
          if (!options.skipSetField) {
            this.fieldHooks.unregister("setField", field);
          }
          const idx = this.localCache.indexOf(field);
          if (idx > -1) {
            this.localCache.splice(idx, 1);
          }
          if (!options.skipRefresh) {
            this.refresh();
          }
        }
        unregisterAll() {
          [...this.localCache].forEach((field) => this.unregister(field, {
            skipGetField: true,
            skipSetField: true,
            skipIsFieldOfBase: true,
            skipRefresh: true
          }));
          this.fieldHooks.unregisterAll();
          this.refresh();
        }
        /**
         * Refresh all item boxes.
         */
        refresh() {
          try {
            Array.from(this.getGlobal("document").querySelectorAll(this.isZotero7() ? "item-box" : "zoteroitembox")).forEach((elem) => elem.refresh());
          } catch (e) {
            this.log(e);
          }
        }
        async initializeGlobal() {
          const Zotero2 = this.getGlobal("Zotero");
          await Zotero2.uiReadyPromise;
          const window2 = this.getGlobal("window");
          const globalCache = this.globalCache = toolkitGlobal_1.default.getInstance().itemBox;
          const inZotero7 = this.isZotero7();
          if (!globalCache._ready) {
            globalCache._ready = true;
            let itemBoxInstance;
            if (inZotero7) {
              itemBoxInstance = new (this.getGlobal("customElements").get("item-box"))();
            } else {
              itemBoxInstance = window2.document.querySelector("#zotero-editpane-item-box");
              const wait = 5e3;
              let t = 0;
              while (!itemBoxInstance && t < wait) {
                itemBoxInstance = window2.document.querySelector("#zotero-editpane-item-box");
                await Zotero2.Promise.delay(10);
                t += 10;
              }
              if (!itemBoxInstance) {
                globalCache._ready = false;
                this.log("ItemBox initialization failed");
                return;
              }
            }
            this.patch(itemBoxInstance.__proto__, "refresh", this.patchSign, (original) => function() {
              const originalThis = this;
              original.apply(originalThis, arguments);
              for (const extraField of Object.values(globalCache.fieldOptions)) {
                const fieldHeader = document.createElement(inZotero7 ? "th" : "label");
                fieldHeader.setAttribute("fieldname", extraField.field);
                const prefKey = `extensions.zotero.pluginToolkit.fieldCollapsed.${extraField.field}`;
                const collapsed = extraField.multiline && extraField.collapsible && Zotero2.Prefs.get(prefKey, true);
                let headerContent = extraField.displayName;
                if (collapsed) {
                  headerContent = `(...)${headerContent}`;
                }
                if (inZotero7) {
                  let label = document.createElement("label");
                  label.className = "key";
                  label.textContent = headerContent;
                  fieldHeader.appendChild(label);
                } else {
                  fieldHeader.setAttribute("value", headerContent);
                }
                const _clickable = originalThis.clickable;
                originalThis.clickable = extraField.editable;
                const fieldValue = originalThis.createValueElement(originalThis.item.getField(extraField.field), extraField.field, 1099);
                originalThis.clickable = _clickable;
                if (extraField.multiline && !Zotero2.Prefs.get(prefKey, true)) {
                  fieldValue.classList.add("multiline");
                } else if (!inZotero7) {
                  fieldValue.setAttribute("crop", "end");
                  fieldValue.setAttribute("value", fieldValue.innerHTML);
                  fieldValue.innerHTML = "";
                }
                if (extraField.collapsible) {
                  fieldHeader.addEventListener("click", function(ev) {
                    Zotero2.Prefs.set(prefKey, !(Zotero2.Prefs.get(prefKey, true) || false), true);
                    originalThis.refresh();
                  });
                }
                fieldHeader.addEventListener("click", inZotero7 ? function(ev) {
                  var _a;
                  const inputField = (_a = ev.currentTarget.nextElementSibling) === null || _a === void 0 ? void 0 : _a.querySelector("input, textarea");
                  if (inputField) {
                    inputField.blur();
                  }
                } : function(ev) {
                  var _a;
                  const inputField = (_a = ev.currentTarget.nextElementSibling) === null || _a === void 0 ? void 0 : _a.inputField;
                  if (inputField) {
                    inputField.blur();
                  }
                });
                const table = inZotero7 ? originalThis._infoTable : originalThis._dynamicFields;
                let fieldIndex = extraField.index;
                if (fieldIndex === 0) {
                  fieldIndex = 1;
                }
                if (fieldIndex && fieldIndex >= 0 && fieldIndex < table.children.length) {
                  originalThis._beforeRow = table.children[fieldIndex];
                  originalThis.addDynamicRow(fieldHeader, fieldValue, true);
                } else {
                  originalThis.addDynamicRow(fieldHeader, fieldValue);
                }
              }
            });
          }
          this.initializationLock.resolve();
        }
      };
      exports.ItemBoxManager = ItemBoxManager;
    }
  });

  // node_modules/zotero-plugin-toolkit/dist/index.js
  var require_dist = __commonJS({
    "node_modules/zotero-plugin-toolkit/dist/index.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ZoteroToolkit = void 0;
      var basic_1 = require_basic();
      var ui_1 = require_ui();
      var reader_1 = require_reader();
      var extraField_1 = require_extraField();
      var itemTree_1 = require_itemTree();
      var prompt_1 = require_prompt();
      var libraryTabPanel_1 = require_libraryTabPanel();
      var readerTabPanel_1 = require_readerTabPanel();
      var menu_1 = require_menu();
      var preferencePane_1 = require_preferencePane();
      var shortcut_1 = require_shortcut();
      var clipboard_1 = require_clipboard();
      var filePicker_1 = require_filePicker();
      var progressWindow_1 = require_progressWindow();
      var virtualizedTable_1 = require_virtualizedTable();
      var dialog_1 = require_dialog();
      var readerInstance_1 = require_readerInstance();
      var fieldHook_1 = require_fieldHook();
      var itemBox_1 = require_itemBox();
      var ZoteroToolkit2 = class extends basic_1.BasicTool {
        constructor() {
          super();
          this.UI = new ui_1.UITool(this);
          this.Reader = new reader_1.ReaderTool(this);
          this.ExtraField = new extraField_1.ExtraFieldTool(this);
          this.FieldHooks = new fieldHook_1.FieldHookManager(this);
          this.ItemTree = new itemTree_1.ItemTreeManager(this);
          this.ItemBox = new itemBox_1.ItemBoxManager(this);
          this.Prompt = new prompt_1.PromptManager(this);
          this.LibraryTabPanel = new libraryTabPanel_1.LibraryTabPanelManager(this);
          this.ReaderTabPanel = new readerTabPanel_1.ReaderTabPanelManager(this);
          this.ReaderInstance = new readerInstance_1.ReaderInstanceManager(this);
          this.Menu = new menu_1.MenuManager(this);
          this.PreferencePane = new preferencePane_1.PreferencePaneManager(this);
          this.Shortcut = new shortcut_1.ShortcutManager(this);
          this.Clipboard = clipboard_1.ClipboardHelper;
          this.FilePicker = filePicker_1.FilePickerHelper;
          this.ProgressWindow = progressWindow_1.ProgressWindowHelper;
          this.VirtualizedTable = virtualizedTable_1.VirtualizedTableHelper;
          this.Dialog = dialog_1.DialogHelper;
        }
        /**
         * Unregister everything created by managers.
         */
        unregisterAll() {
          (0, basic_1.unregister)(this);
        }
      };
      exports.ZoteroToolkit = ZoteroToolkit2;
      exports.default = ZoteroToolkit2;
    }
  });

  // (disabled):crypto
  var require_crypto = __commonJS({
    "(disabled):crypto"() {
    }
  });

  // node_modules/crypto-js/core.js
  var require_core = __commonJS({
    "node_modules/crypto-js/core.js"(exports, module) {
      (function(root, factory) {
        if (typeof exports === "object") {
          module.exports = exports = factory();
        } else if (typeof define === "function" && define.amd) {
          define([], factory);
        } else {
          root.CryptoJS = factory();
        }
      })(exports, function() {
        var CryptoJS = CryptoJS || function(Math2, undefined2) {
          var crypto;
          if (typeof window !== "undefined" && window.crypto) {
            crypto = window.crypto;
          }
          if (typeof self !== "undefined" && self.crypto) {
            crypto = self.crypto;
          }
          if (typeof globalThis !== "undefined" && globalThis.crypto) {
            crypto = globalThis.crypto;
          }
          if (!crypto && typeof window !== "undefined" && window.msCrypto) {
            crypto = window.msCrypto;
          }
          if (!crypto && typeof global !== "undefined" && global.crypto) {
            crypto = global.crypto;
          }
          if (!crypto && typeof __require === "function") {
            try {
              crypto = require_crypto();
            } catch (err) {
            }
          }
          var cryptoSecureRandomInt = function() {
            if (crypto) {
              if (typeof crypto.getRandomValues === "function") {
                try {
                  return crypto.getRandomValues(new Uint32Array(1))[0];
                } catch (err) {
                }
              }
              if (typeof crypto.randomBytes === "function") {
                try {
                  return crypto.randomBytes(4).readInt32LE();
                } catch (err) {
                }
              }
            }
            throw new Error("Native crypto module could not be used to get secure random number.");
          };
          var create = Object.create || function() {
            function F() {
            }
            return function(obj) {
              var subtype;
              F.prototype = obj;
              subtype = new F();
              F.prototype = null;
              return subtype;
            };
          }();
          var C = {};
          var C_lib = C.lib = {};
          var Base = C_lib.Base = function() {
            return {
              /**
               * Creates a new object that inherits from this object.
               *
               * @param {Object} overrides Properties to copy into the new object.
               *
               * @return {Object} The new object.
               *
               * @static
               *
               * @example
               *
               *     var MyType = CryptoJS.lib.Base.extend({
               *         field: 'value',
               *
               *         method: function () {
               *         }
               *     });
               */
              extend: function(overrides) {
                var subtype = create(this);
                if (overrides) {
                  subtype.mixIn(overrides);
                }
                if (!subtype.hasOwnProperty("init") || this.init === subtype.init) {
                  subtype.init = function() {
                    subtype.$super.init.apply(this, arguments);
                  };
                }
                subtype.init.prototype = subtype;
                subtype.$super = this;
                return subtype;
              },
              /**
               * Extends this object and runs the init method.
               * Arguments to create() will be passed to init().
               *
               * @return {Object} The new object.
               *
               * @static
               *
               * @example
               *
               *     var instance = MyType.create();
               */
              create: function() {
                var instance = this.extend();
                instance.init.apply(instance, arguments);
                return instance;
              },
              /**
               * Initializes a newly created object.
               * Override this method to add some logic when your objects are created.
               *
               * @example
               *
               *     var MyType = CryptoJS.lib.Base.extend({
               *         init: function () {
               *             // ...
               *         }
               *     });
               */
              init: function() {
              },
              /**
               * Copies properties into this object.
               *
               * @param {Object} properties The properties to mix in.
               *
               * @example
               *
               *     MyType.mixIn({
               *         field: 'value'
               *     });
               */
              mixIn: function(properties) {
                for (var propertyName in properties) {
                  if (properties.hasOwnProperty(propertyName)) {
                    this[propertyName] = properties[propertyName];
                  }
                }
                if (properties.hasOwnProperty("toString")) {
                  this.toString = properties.toString;
                }
              },
              /**
               * Creates a copy of this object.
               *
               * @return {Object} The clone.
               *
               * @example
               *
               *     var clone = instance.clone();
               */
              clone: function() {
                return this.init.prototype.extend(this);
              }
            };
          }();
          var WordArray = C_lib.WordArray = Base.extend({
            /**
             * Initializes a newly created word array.
             *
             * @param {Array} words (Optional) An array of 32-bit words.
             * @param {number} sigBytes (Optional) The number of significant bytes in the words.
             *
             * @example
             *
             *     var wordArray = CryptoJS.lib.WordArray.create();
             *     var wordArray = CryptoJS.lib.WordArray.create([0x00010203, 0x04050607]);
             *     var wordArray = CryptoJS.lib.WordArray.create([0x00010203, 0x04050607], 6);
             */
            init: function(words, sigBytes) {
              words = this.words = words || [];
              if (sigBytes != undefined2) {
                this.sigBytes = sigBytes;
              } else {
                this.sigBytes = words.length * 4;
              }
            },
            /**
             * Converts this word array to a string.
             *
             * @param {Encoder} encoder (Optional) The encoding strategy to use. Default: CryptoJS.enc.Hex
             *
             * @return {string} The stringified word array.
             *
             * @example
             *
             *     var string = wordArray + '';
             *     var string = wordArray.toString();
             *     var string = wordArray.toString(CryptoJS.enc.Utf8);
             */
            toString: function(encoder) {
              return (encoder || Hex).stringify(this);
            },
            /**
             * Concatenates a word array to this word array.
             *
             * @param {WordArray} wordArray The word array to append.
             *
             * @return {WordArray} This word array.
             *
             * @example
             *
             *     wordArray1.concat(wordArray2);
             */
            concat: function(wordArray) {
              var thisWords = this.words;
              var thatWords = wordArray.words;
              var thisSigBytes = this.sigBytes;
              var thatSigBytes = wordArray.sigBytes;
              this.clamp();
              if (thisSigBytes % 4) {
                for (var i = 0; i < thatSigBytes; i++) {
                  var thatByte = thatWords[i >>> 2] >>> 24 - i % 4 * 8 & 255;
                  thisWords[thisSigBytes + i >>> 2] |= thatByte << 24 - (thisSigBytes + i) % 4 * 8;
                }
              } else {
                for (var j = 0; j < thatSigBytes; j += 4) {
                  thisWords[thisSigBytes + j >>> 2] = thatWords[j >>> 2];
                }
              }
              this.sigBytes += thatSigBytes;
              return this;
            },
            /**
             * Removes insignificant bits.
             *
             * @example
             *
             *     wordArray.clamp();
             */
            clamp: function() {
              var words = this.words;
              var sigBytes = this.sigBytes;
              words[sigBytes >>> 2] &= 4294967295 << 32 - sigBytes % 4 * 8;
              words.length = Math2.ceil(sigBytes / 4);
            },
            /**
             * Creates a copy of this word array.
             *
             * @return {WordArray} The clone.
             *
             * @example
             *
             *     var clone = wordArray.clone();
             */
            clone: function() {
              var clone = Base.clone.call(this);
              clone.words = this.words.slice(0);
              return clone;
            },
            /**
             * Creates a word array filled with random bytes.
             *
             * @param {number} nBytes The number of random bytes to generate.
             *
             * @return {WordArray} The random word array.
             *
             * @static
             *
             * @example
             *
             *     var wordArray = CryptoJS.lib.WordArray.random(16);
             */
            random: function(nBytes) {
              var words = [];
              for (var i = 0; i < nBytes; i += 4) {
                words.push(cryptoSecureRandomInt());
              }
              return new WordArray.init(words, nBytes);
            }
          });
          var C_enc = C.enc = {};
          var Hex = C_enc.Hex = {
            /**
             * Converts a word array to a hex string.
             *
             * @param {WordArray} wordArray The word array.
             *
             * @return {string} The hex string.
             *
             * @static
             *
             * @example
             *
             *     var hexString = CryptoJS.enc.Hex.stringify(wordArray);
             */
            stringify: function(wordArray) {
              var words = wordArray.words;
              var sigBytes = wordArray.sigBytes;
              var hexChars = [];
              for (var i = 0; i < sigBytes; i++) {
                var bite = words[i >>> 2] >>> 24 - i % 4 * 8 & 255;
                hexChars.push((bite >>> 4).toString(16));
                hexChars.push((bite & 15).toString(16));
              }
              return hexChars.join("");
            },
            /**
             * Converts a hex string to a word array.
             *
             * @param {string} hexStr The hex string.
             *
             * @return {WordArray} The word array.
             *
             * @static
             *
             * @example
             *
             *     var wordArray = CryptoJS.enc.Hex.parse(hexString);
             */
            parse: function(hexStr) {
              var hexStrLength = hexStr.length;
              var words = [];
              for (var i = 0; i < hexStrLength; i += 2) {
                words[i >>> 3] |= parseInt(hexStr.substr(i, 2), 16) << 24 - i % 8 * 4;
              }
              return new WordArray.init(words, hexStrLength / 2);
            }
          };
          var Latin1 = C_enc.Latin1 = {
            /**
             * Converts a word array to a Latin1 string.
             *
             * @param {WordArray} wordArray The word array.
             *
             * @return {string} The Latin1 string.
             *
             * @static
             *
             * @example
             *
             *     var latin1String = CryptoJS.enc.Latin1.stringify(wordArray);
             */
            stringify: function(wordArray) {
              var words = wordArray.words;
              var sigBytes = wordArray.sigBytes;
              var latin1Chars = [];
              for (var i = 0; i < sigBytes; i++) {
                var bite = words[i >>> 2] >>> 24 - i % 4 * 8 & 255;
                latin1Chars.push(String.fromCharCode(bite));
              }
              return latin1Chars.join("");
            },
            /**
             * Converts a Latin1 string to a word array.
             *
             * @param {string} latin1Str The Latin1 string.
             *
             * @return {WordArray} The word array.
             *
             * @static
             *
             * @example
             *
             *     var wordArray = CryptoJS.enc.Latin1.parse(latin1String);
             */
            parse: function(latin1Str) {
              var latin1StrLength = latin1Str.length;
              var words = [];
              for (var i = 0; i < latin1StrLength; i++) {
                words[i >>> 2] |= (latin1Str.charCodeAt(i) & 255) << 24 - i % 4 * 8;
              }
              return new WordArray.init(words, latin1StrLength);
            }
          };
          var Utf8 = C_enc.Utf8 = {
            /**
             * Converts a word array to a UTF-8 string.
             *
             * @param {WordArray} wordArray The word array.
             *
             * @return {string} The UTF-8 string.
             *
             * @static
             *
             * @example
             *
             *     var utf8String = CryptoJS.enc.Utf8.stringify(wordArray);
             */
            stringify: function(wordArray) {
              try {
                return decodeURIComponent(escape(Latin1.stringify(wordArray)));
              } catch (e) {
                throw new Error("Malformed UTF-8 data");
              }
            },
            /**
             * Converts a UTF-8 string to a word array.
             *
             * @param {string} utf8Str The UTF-8 string.
             *
             * @return {WordArray} The word array.
             *
             * @static
             *
             * @example
             *
             *     var wordArray = CryptoJS.enc.Utf8.parse(utf8String);
             */
            parse: function(utf8Str) {
              return Latin1.parse(unescape(encodeURIComponent(utf8Str)));
            }
          };
          var BufferedBlockAlgorithm = C_lib.BufferedBlockAlgorithm = Base.extend({
            /**
             * Resets this block algorithm's data buffer to its initial state.
             *
             * @example
             *
             *     bufferedBlockAlgorithm.reset();
             */
            reset: function() {
              this._data = new WordArray.init();
              this._nDataBytes = 0;
            },
            /**
             * Adds new data to this block algorithm's buffer.
             *
             * @param {WordArray|string} data The data to append. Strings are converted to a WordArray using UTF-8.
             *
             * @example
             *
             *     bufferedBlockAlgorithm._append('data');
             *     bufferedBlockAlgorithm._append(wordArray);
             */
            _append: function(data) {
              if (typeof data == "string") {
                data = Utf8.parse(data);
              }
              this._data.concat(data);
              this._nDataBytes += data.sigBytes;
            },
            /**
             * Processes available data blocks.
             *
             * This method invokes _doProcessBlock(offset), which must be implemented by a concrete subtype.
             *
             * @param {boolean} doFlush Whether all blocks and partial blocks should be processed.
             *
             * @return {WordArray} The processed data.
             *
             * @example
             *
             *     var processedData = bufferedBlockAlgorithm._process();
             *     var processedData = bufferedBlockAlgorithm._process(!!'flush');
             */
            _process: function(doFlush) {
              var processedWords;
              var data = this._data;
              var dataWords = data.words;
              var dataSigBytes = data.sigBytes;
              var blockSize = this.blockSize;
              var blockSizeBytes = blockSize * 4;
              var nBlocksReady = dataSigBytes / blockSizeBytes;
              if (doFlush) {
                nBlocksReady = Math2.ceil(nBlocksReady);
              } else {
                nBlocksReady = Math2.max((nBlocksReady | 0) - this._minBufferSize, 0);
              }
              var nWordsReady = nBlocksReady * blockSize;
              var nBytesReady = Math2.min(nWordsReady * 4, dataSigBytes);
              if (nWordsReady) {
                for (var offset = 0; offset < nWordsReady; offset += blockSize) {
                  this._doProcessBlock(dataWords, offset);
                }
                processedWords = dataWords.splice(0, nWordsReady);
                data.sigBytes -= nBytesReady;
              }
              return new WordArray.init(processedWords, nBytesReady);
            },
            /**
             * Creates a copy of this object.
             *
             * @return {Object} The clone.
             *
             * @example
             *
             *     var clone = bufferedBlockAlgorithm.clone();
             */
            clone: function() {
              var clone = Base.clone.call(this);
              clone._data = this._data.clone();
              return clone;
            },
            _minBufferSize: 0
          });
          var Hasher = C_lib.Hasher = BufferedBlockAlgorithm.extend({
            /**
             * Configuration options.
             */
            cfg: Base.extend(),
            /**
             * Initializes a newly created hasher.
             *
             * @param {Object} cfg (Optional) The configuration options to use for this hash computation.
             *
             * @example
             *
             *     var hasher = CryptoJS.algo.SHA256.create();
             */
            init: function(cfg) {
              this.cfg = this.cfg.extend(cfg);
              this.reset();
            },
            /**
             * Resets this hasher to its initial state.
             *
             * @example
             *
             *     hasher.reset();
             */
            reset: function() {
              BufferedBlockAlgorithm.reset.call(this);
              this._doReset();
            },
            /**
             * Updates this hasher with a message.
             *
             * @param {WordArray|string} messageUpdate The message to append.
             *
             * @return {Hasher} This hasher.
             *
             * @example
             *
             *     hasher.update('message');
             *     hasher.update(wordArray);
             */
            update: function(messageUpdate) {
              this._append(messageUpdate);
              this._process();
              return this;
            },
            /**
             * Finalizes the hash computation.
             * Note that the finalize operation is effectively a destructive, read-once operation.
             *
             * @param {WordArray|string} messageUpdate (Optional) A final message update.
             *
             * @return {WordArray} The hash.
             *
             * @example
             *
             *     var hash = hasher.finalize();
             *     var hash = hasher.finalize('message');
             *     var hash = hasher.finalize(wordArray);
             */
            finalize: function(messageUpdate) {
              if (messageUpdate) {
                this._append(messageUpdate);
              }
              var hash = this._doFinalize();
              return hash;
            },
            blockSize: 512 / 32,
            /**
             * Creates a shortcut function to a hasher's object interface.
             *
             * @param {Hasher} hasher The hasher to create a helper for.
             *
             * @return {Function} The shortcut function.
             *
             * @static
             *
             * @example
             *
             *     var SHA256 = CryptoJS.lib.Hasher._createHelper(CryptoJS.algo.SHA256);
             */
            _createHelper: function(hasher) {
              return function(message, cfg) {
                return new hasher.init(cfg).finalize(message);
              };
            },
            /**
             * Creates a shortcut function to the HMAC's object interface.
             *
             * @param {Hasher} hasher The hasher to use in this HMAC helper.
             *
             * @return {Function} The shortcut function.
             *
             * @static
             *
             * @example
             *
             *     var HmacSHA256 = CryptoJS.lib.Hasher._createHmacHelper(CryptoJS.algo.SHA256);
             */
            _createHmacHelper: function(hasher) {
              return function(message, key) {
                return new C_algo.HMAC.init(hasher, key).finalize(message);
              };
            }
          });
          var C_algo = C.algo = {};
          return C;
        }(Math);
        return CryptoJS;
      });
    }
  });

  // node_modules/crypto-js/x64-core.js
  var require_x64_core = __commonJS({
    "node_modules/crypto-js/x64-core.js"(exports, module) {
      (function(root, factory) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function(undefined2) {
          var C = CryptoJS;
          var C_lib = C.lib;
          var Base = C_lib.Base;
          var X32WordArray = C_lib.WordArray;
          var C_x64 = C.x64 = {};
          var X64Word = C_x64.Word = Base.extend({
            /**
             * Initializes a newly created 64-bit word.
             *
             * @param {number} high The high 32 bits.
             * @param {number} low The low 32 bits.
             *
             * @example
             *
             *     var x64Word = CryptoJS.x64.Word.create(0x00010203, 0x04050607);
             */
            init: function(high, low) {
              this.high = high;
              this.low = low;
            }
            /**
             * Bitwise NOTs this word.
             *
             * @return {X64Word} A new x64-Word object after negating.
             *
             * @example
             *
             *     var negated = x64Word.not();
             */
            // not: function () {
            // var high = ~this.high;
            // var low = ~this.low;
            // return X64Word.create(high, low);
            // },
            /**
             * Bitwise ANDs this word with the passed word.
             *
             * @param {X64Word} word The x64-Word to AND with this word.
             *
             * @return {X64Word} A new x64-Word object after ANDing.
             *
             * @example
             *
             *     var anded = x64Word.and(anotherX64Word);
             */
            // and: function (word) {
            // var high = this.high & word.high;
            // var low = this.low & word.low;
            // return X64Word.create(high, low);
            // },
            /**
             * Bitwise ORs this word with the passed word.
             *
             * @param {X64Word} word The x64-Word to OR with this word.
             *
             * @return {X64Word} A new x64-Word object after ORing.
             *
             * @example
             *
             *     var ored = x64Word.or(anotherX64Word);
             */
            // or: function (word) {
            // var high = this.high | word.high;
            // var low = this.low | word.low;
            // return X64Word.create(high, low);
            // },
            /**
             * Bitwise XORs this word with the passed word.
             *
             * @param {X64Word} word The x64-Word to XOR with this word.
             *
             * @return {X64Word} A new x64-Word object after XORing.
             *
             * @example
             *
             *     var xored = x64Word.xor(anotherX64Word);
             */
            // xor: function (word) {
            // var high = this.high ^ word.high;
            // var low = this.low ^ word.low;
            // return X64Word.create(high, low);
            // },
            /**
             * Shifts this word n bits to the left.
             *
             * @param {number} n The number of bits to shift.
             *
             * @return {X64Word} A new x64-Word object after shifting.
             *
             * @example
             *
             *     var shifted = x64Word.shiftL(25);
             */
            // shiftL: function (n) {
            // if (n < 32) {
            // var high = (this.high << n) | (this.low >>> (32 - n));
            // var low = this.low << n;
            // } else {
            // var high = this.low << (n - 32);
            // var low = 0;
            // }
            // return X64Word.create(high, low);
            // },
            /**
             * Shifts this word n bits to the right.
             *
             * @param {number} n The number of bits to shift.
             *
             * @return {X64Word} A new x64-Word object after shifting.
             *
             * @example
             *
             *     var shifted = x64Word.shiftR(7);
             */
            // shiftR: function (n) {
            // if (n < 32) {
            // var low = (this.low >>> n) | (this.high << (32 - n));
            // var high = this.high >>> n;
            // } else {
            // var low = this.high >>> (n - 32);
            // var high = 0;
            // }
            // return X64Word.create(high, low);
            // },
            /**
             * Rotates this word n bits to the left.
             *
             * @param {number} n The number of bits to rotate.
             *
             * @return {X64Word} A new x64-Word object after rotating.
             *
             * @example
             *
             *     var rotated = x64Word.rotL(25);
             */
            // rotL: function (n) {
            // return this.shiftL(n).or(this.shiftR(64 - n));
            // },
            /**
             * Rotates this word n bits to the right.
             *
             * @param {number} n The number of bits to rotate.
             *
             * @return {X64Word} A new x64-Word object after rotating.
             *
             * @example
             *
             *     var rotated = x64Word.rotR(7);
             */
            // rotR: function (n) {
            // return this.shiftR(n).or(this.shiftL(64 - n));
            // },
            /**
             * Adds this word with the passed word.
             *
             * @param {X64Word} word The x64-Word to add with this word.
             *
             * @return {X64Word} A new x64-Word object after adding.
             *
             * @example
             *
             *     var added = x64Word.add(anotherX64Word);
             */
            // add: function (word) {
            // var low = (this.low + word.low) | 0;
            // var carry = (low >>> 0) < (this.low >>> 0) ? 1 : 0;
            // var high = (this.high + word.high + carry) | 0;
            // return X64Word.create(high, low);
            // }
          });
          var X64WordArray = C_x64.WordArray = Base.extend({
            /**
             * Initializes a newly created word array.
             *
             * @param {Array} words (Optional) An array of CryptoJS.x64.Word objects.
             * @param {number} sigBytes (Optional) The number of significant bytes in the words.
             *
             * @example
             *
             *     var wordArray = CryptoJS.x64.WordArray.create();
             *
             *     var wordArray = CryptoJS.x64.WordArray.create([
             *         CryptoJS.x64.Word.create(0x00010203, 0x04050607),
             *         CryptoJS.x64.Word.create(0x18191a1b, 0x1c1d1e1f)
             *     ]);
             *
             *     var wordArray = CryptoJS.x64.WordArray.create([
             *         CryptoJS.x64.Word.create(0x00010203, 0x04050607),
             *         CryptoJS.x64.Word.create(0x18191a1b, 0x1c1d1e1f)
             *     ], 10);
             */
            init: function(words, sigBytes) {
              words = this.words = words || [];
              if (sigBytes != undefined2) {
                this.sigBytes = sigBytes;
              } else {
                this.sigBytes = words.length * 8;
              }
            },
            /**
             * Converts this 64-bit word array to a 32-bit word array.
             *
             * @return {CryptoJS.lib.WordArray} This word array's data as a 32-bit word array.
             *
             * @example
             *
             *     var x32WordArray = x64WordArray.toX32();
             */
            toX32: function() {
              var x64Words = this.words;
              var x64WordsLength = x64Words.length;
              var x32Words = [];
              for (var i = 0; i < x64WordsLength; i++) {
                var x64Word = x64Words[i];
                x32Words.push(x64Word.high);
                x32Words.push(x64Word.low);
              }
              return X32WordArray.create(x32Words, this.sigBytes);
            },
            /**
             * Creates a copy of this word array.
             *
             * @return {X64WordArray} The clone.
             *
             * @example
             *
             *     var clone = x64WordArray.clone();
             */
            clone: function() {
              var clone = Base.clone.call(this);
              var words = clone.words = this.words.slice(0);
              var wordsLength = words.length;
              for (var i = 0; i < wordsLength; i++) {
                words[i] = words[i].clone();
              }
              return clone;
            }
          });
        })();
        return CryptoJS;
      });
    }
  });

  // node_modules/crypto-js/lib-typedarrays.js
  var require_lib_typedarrays = __commonJS({
    "node_modules/crypto-js/lib-typedarrays.js"(exports, module) {
      (function(root, factory) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function() {
          if (typeof ArrayBuffer != "function") {
            return;
          }
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var superInit = WordArray.init;
          var subInit = WordArray.init = function(typedArray) {
            if (typedArray instanceof ArrayBuffer) {
              typedArray = new Uint8Array(typedArray);
            }
            if (typedArray instanceof Int8Array || typeof Uint8ClampedArray !== "undefined" && typedArray instanceof Uint8ClampedArray || typedArray instanceof Int16Array || typedArray instanceof Uint16Array || typedArray instanceof Int32Array || typedArray instanceof Uint32Array || typedArray instanceof Float32Array || typedArray instanceof Float64Array) {
              typedArray = new Uint8Array(typedArray.buffer, typedArray.byteOffset, typedArray.byteLength);
            }
            if (typedArray instanceof Uint8Array) {
              var typedArrayByteLength = typedArray.byteLength;
              var words = [];
              for (var i = 0; i < typedArrayByteLength; i++) {
                words[i >>> 2] |= typedArray[i] << 24 - i % 4 * 8;
              }
              superInit.call(this, words, typedArrayByteLength);
            } else {
              superInit.apply(this, arguments);
            }
          };
          subInit.prototype = WordArray;
        })();
        return CryptoJS.lib.WordArray;
      });
    }
  });

  // node_modules/crypto-js/enc-utf16.js
  var require_enc_utf16 = __commonJS({
    "node_modules/crypto-js/enc-utf16.js"(exports, module) {
      (function(root, factory) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var C_enc = C.enc;
          var Utf16BE = C_enc.Utf16 = C_enc.Utf16BE = {
            /**
             * Converts a word array to a UTF-16 BE string.
             *
             * @param {WordArray} wordArray The word array.
             *
             * @return {string} The UTF-16 BE string.
             *
             * @static
             *
             * @example
             *
             *     var utf16String = CryptoJS.enc.Utf16.stringify(wordArray);
             */
            stringify: function(wordArray) {
              var words = wordArray.words;
              var sigBytes = wordArray.sigBytes;
              var utf16Chars = [];
              for (var i = 0; i < sigBytes; i += 2) {
                var codePoint = words[i >>> 2] >>> 16 - i % 4 * 8 & 65535;
                utf16Chars.push(String.fromCharCode(codePoint));
              }
              return utf16Chars.join("");
            },
            /**
             * Converts a UTF-16 BE string to a word array.
             *
             * @param {string} utf16Str The UTF-16 BE string.
             *
             * @return {WordArray} The word array.
             *
             * @static
             *
             * @example
             *
             *     var wordArray = CryptoJS.enc.Utf16.parse(utf16String);
             */
            parse: function(utf16Str) {
              var utf16StrLength = utf16Str.length;
              var words = [];
              for (var i = 0; i < utf16StrLength; i++) {
                words[i >>> 1] |= utf16Str.charCodeAt(i) << 16 - i % 2 * 16;
              }
              return WordArray.create(words, utf16StrLength * 2);
            }
          };
          C_enc.Utf16LE = {
            /**
             * Converts a word array to a UTF-16 LE string.
             *
             * @param {WordArray} wordArray The word array.
             *
             * @return {string} The UTF-16 LE string.
             *
             * @static
             *
             * @example
             *
             *     var utf16Str = CryptoJS.enc.Utf16LE.stringify(wordArray);
             */
            stringify: function(wordArray) {
              var words = wordArray.words;
              var sigBytes = wordArray.sigBytes;
              var utf16Chars = [];
              for (var i = 0; i < sigBytes; i += 2) {
                var codePoint = swapEndian(words[i >>> 2] >>> 16 - i % 4 * 8 & 65535);
                utf16Chars.push(String.fromCharCode(codePoint));
              }
              return utf16Chars.join("");
            },
            /**
             * Converts a UTF-16 LE string to a word array.
             *
             * @param {string} utf16Str The UTF-16 LE string.
             *
             * @return {WordArray} The word array.
             *
             * @static
             *
             * @example
             *
             *     var wordArray = CryptoJS.enc.Utf16LE.parse(utf16Str);
             */
            parse: function(utf16Str) {
              var utf16StrLength = utf16Str.length;
              var words = [];
              for (var i = 0; i < utf16StrLength; i++) {
                words[i >>> 1] |= swapEndian(utf16Str.charCodeAt(i) << 16 - i % 2 * 16);
              }
              return WordArray.create(words, utf16StrLength * 2);
            }
          };
          function swapEndian(word) {
            return word << 8 & 4278255360 | word >>> 8 & 16711935;
          }
        })();
        return CryptoJS.enc.Utf16;
      });
    }
  });

  // node_modules/crypto-js/enc-base64.js
  var require_enc_base64 = __commonJS({
    "node_modules/crypto-js/enc-base64.js"(exports, module) {
      (function(root, factory) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var C_enc = C.enc;
          var Base64 = C_enc.Base64 = {
            /**
             * Converts a word array to a Base64 string.
             *
             * @param {WordArray} wordArray The word array.
             *
             * @return {string} The Base64 string.
             *
             * @static
             *
             * @example
             *
             *     var base64String = CryptoJS.enc.Base64.stringify(wordArray);
             */
            stringify: function(wordArray) {
              var words = wordArray.words;
              var sigBytes = wordArray.sigBytes;
              var map = this._map;
              wordArray.clamp();
              var base64Chars = [];
              for (var i = 0; i < sigBytes; i += 3) {
                var byte1 = words[i >>> 2] >>> 24 - i % 4 * 8 & 255;
                var byte2 = words[i + 1 >>> 2] >>> 24 - (i + 1) % 4 * 8 & 255;
                var byte3 = words[i + 2 >>> 2] >>> 24 - (i + 2) % 4 * 8 & 255;
                var triplet = byte1 << 16 | byte2 << 8 | byte3;
                for (var j = 0; j < 4 && i + j * 0.75 < sigBytes; j++) {
                  base64Chars.push(map.charAt(triplet >>> 6 * (3 - j) & 63));
                }
              }
              var paddingChar = map.charAt(64);
              if (paddingChar) {
                while (base64Chars.length % 4) {
                  base64Chars.push(paddingChar);
                }
              }
              return base64Chars.join("");
            },
            /**
             * Converts a Base64 string to a word array.
             *
             * @param {string} base64Str The Base64 string.
             *
             * @return {WordArray} The word array.
             *
             * @static
             *
             * @example
             *
             *     var wordArray = CryptoJS.enc.Base64.parse(base64String);
             */
            parse: function(base64Str) {
              var base64StrLength = base64Str.length;
              var map = this._map;
              var reverseMap = this._reverseMap;
              if (!reverseMap) {
                reverseMap = this._reverseMap = [];
                for (var j = 0; j < map.length; j++) {
                  reverseMap[map.charCodeAt(j)] = j;
                }
              }
              var paddingChar = map.charAt(64);
              if (paddingChar) {
                var paddingIndex = base64Str.indexOf(paddingChar);
                if (paddingIndex !== -1) {
                  base64StrLength = paddingIndex;
                }
              }
              return parseLoop(base64Str, base64StrLength, reverseMap);
            },
            _map: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/="
          };
          function parseLoop(base64Str, base64StrLength, reverseMap) {
            var words = [];
            var nBytes = 0;
            for (var i = 0; i < base64StrLength; i++) {
              if (i % 4) {
                var bits1 = reverseMap[base64Str.charCodeAt(i - 1)] << i % 4 * 2;
                var bits2 = reverseMap[base64Str.charCodeAt(i)] >>> 6 - i % 4 * 2;
                var bitsCombined = bits1 | bits2;
                words[nBytes >>> 2] |= bitsCombined << 24 - nBytes % 4 * 8;
                nBytes++;
              }
            }
            return WordArray.create(words, nBytes);
          }
        })();
        return CryptoJS.enc.Base64;
      });
    }
  });

  // node_modules/crypto-js/enc-base64url.js
  var require_enc_base64url = __commonJS({
    "node_modules/crypto-js/enc-base64url.js"(exports, module) {
      (function(root, factory) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var C_enc = C.enc;
          var Base64url = C_enc.Base64url = {
            /**
             * Converts a word array to a Base64url string.
             *
             * @param {WordArray} wordArray The word array.
             *
             * @param {boolean} urlSafe Whether to use url safe
             *
             * @return {string} The Base64url string.
             *
             * @static
             *
             * @example
             *
             *     var base64String = CryptoJS.enc.Base64url.stringify(wordArray);
             */
            stringify: function(wordArray, urlSafe = true) {
              var words = wordArray.words;
              var sigBytes = wordArray.sigBytes;
              var map = urlSafe ? this._safe_map : this._map;
              wordArray.clamp();
              var base64Chars = [];
              for (var i = 0; i < sigBytes; i += 3) {
                var byte1 = words[i >>> 2] >>> 24 - i % 4 * 8 & 255;
                var byte2 = words[i + 1 >>> 2] >>> 24 - (i + 1) % 4 * 8 & 255;
                var byte3 = words[i + 2 >>> 2] >>> 24 - (i + 2) % 4 * 8 & 255;
                var triplet = byte1 << 16 | byte2 << 8 | byte3;
                for (var j = 0; j < 4 && i + j * 0.75 < sigBytes; j++) {
                  base64Chars.push(map.charAt(triplet >>> 6 * (3 - j) & 63));
                }
              }
              var paddingChar = map.charAt(64);
              if (paddingChar) {
                while (base64Chars.length % 4) {
                  base64Chars.push(paddingChar);
                }
              }
              return base64Chars.join("");
            },
            /**
             * Converts a Base64url string to a word array.
             *
             * @param {string} base64Str The Base64url string.
             *
             * @param {boolean} urlSafe Whether to use url safe
             *
             * @return {WordArray} The word array.
             *
             * @static
             *
             * @example
             *
             *     var wordArray = CryptoJS.enc.Base64url.parse(base64String);
             */
            parse: function(base64Str, urlSafe = true) {
              var base64StrLength = base64Str.length;
              var map = urlSafe ? this._safe_map : this._map;
              var reverseMap = this._reverseMap;
              if (!reverseMap) {
                reverseMap = this._reverseMap = [];
                for (var j = 0; j < map.length; j++) {
                  reverseMap[map.charCodeAt(j)] = j;
                }
              }
              var paddingChar = map.charAt(64);
              if (paddingChar) {
                var paddingIndex = base64Str.indexOf(paddingChar);
                if (paddingIndex !== -1) {
                  base64StrLength = paddingIndex;
                }
              }
              return parseLoop(base64Str, base64StrLength, reverseMap);
            },
            _map: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
            _safe_map: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"
          };
          function parseLoop(base64Str, base64StrLength, reverseMap) {
            var words = [];
            var nBytes = 0;
            for (var i = 0; i < base64StrLength; i++) {
              if (i % 4) {
                var bits1 = reverseMap[base64Str.charCodeAt(i - 1)] << i % 4 * 2;
                var bits2 = reverseMap[base64Str.charCodeAt(i)] >>> 6 - i % 4 * 2;
                var bitsCombined = bits1 | bits2;
                words[nBytes >>> 2] |= bitsCombined << 24 - nBytes % 4 * 8;
                nBytes++;
              }
            }
            return WordArray.create(words, nBytes);
          }
        })();
        return CryptoJS.enc.Base64url;
      });
    }
  });

  // node_modules/crypto-js/md5.js
  var require_md5 = __commonJS({
    "node_modules/crypto-js/md5.js"(exports, module) {
      (function(root, factory) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function(Math2) {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var Hasher = C_lib.Hasher;
          var C_algo = C.algo;
          var T = [];
          (function() {
            for (var i = 0; i < 64; i++) {
              T[i] = Math2.abs(Math2.sin(i + 1)) * 4294967296 | 0;
            }
          })();
          var MD53 = C_algo.MD5 = Hasher.extend({
            _doReset: function() {
              this._hash = new WordArray.init([
                1732584193,
                4023233417,
                2562383102,
                271733878
              ]);
            },
            _doProcessBlock: function(M, offset) {
              for (var i = 0; i < 16; i++) {
                var offset_i = offset + i;
                var M_offset_i = M[offset_i];
                M[offset_i] = (M_offset_i << 8 | M_offset_i >>> 24) & 16711935 | (M_offset_i << 24 | M_offset_i >>> 8) & 4278255360;
              }
              var H = this._hash.words;
              var M_offset_0 = M[offset + 0];
              var M_offset_1 = M[offset + 1];
              var M_offset_2 = M[offset + 2];
              var M_offset_3 = M[offset + 3];
              var M_offset_4 = M[offset + 4];
              var M_offset_5 = M[offset + 5];
              var M_offset_6 = M[offset + 6];
              var M_offset_7 = M[offset + 7];
              var M_offset_8 = M[offset + 8];
              var M_offset_9 = M[offset + 9];
              var M_offset_10 = M[offset + 10];
              var M_offset_11 = M[offset + 11];
              var M_offset_12 = M[offset + 12];
              var M_offset_13 = M[offset + 13];
              var M_offset_14 = M[offset + 14];
              var M_offset_15 = M[offset + 15];
              var a = H[0];
              var b = H[1];
              var c = H[2];
              var d = H[3];
              a = FF(a, b, c, d, M_offset_0, 7, T[0]);
              d = FF(d, a, b, c, M_offset_1, 12, T[1]);
              c = FF(c, d, a, b, M_offset_2, 17, T[2]);
              b = FF(b, c, d, a, M_offset_3, 22, T[3]);
              a = FF(a, b, c, d, M_offset_4, 7, T[4]);
              d = FF(d, a, b, c, M_offset_5, 12, T[5]);
              c = FF(c, d, a, b, M_offset_6, 17, T[6]);
              b = FF(b, c, d, a, M_offset_7, 22, T[7]);
              a = FF(a, b, c, d, M_offset_8, 7, T[8]);
              d = FF(d, a, b, c, M_offset_9, 12, T[9]);
              c = FF(c, d, a, b, M_offset_10, 17, T[10]);
              b = FF(b, c, d, a, M_offset_11, 22, T[11]);
              a = FF(a, b, c, d, M_offset_12, 7, T[12]);
              d = FF(d, a, b, c, M_offset_13, 12, T[13]);
              c = FF(c, d, a, b, M_offset_14, 17, T[14]);
              b = FF(b, c, d, a, M_offset_15, 22, T[15]);
              a = GG(a, b, c, d, M_offset_1, 5, T[16]);
              d = GG(d, a, b, c, M_offset_6, 9, T[17]);
              c = GG(c, d, a, b, M_offset_11, 14, T[18]);
              b = GG(b, c, d, a, M_offset_0, 20, T[19]);
              a = GG(a, b, c, d, M_offset_5, 5, T[20]);
              d = GG(d, a, b, c, M_offset_10, 9, T[21]);
              c = GG(c, d, a, b, M_offset_15, 14, T[22]);
              b = GG(b, c, d, a, M_offset_4, 20, T[23]);
              a = GG(a, b, c, d, M_offset_9, 5, T[24]);
              d = GG(d, a, b, c, M_offset_14, 9, T[25]);
              c = GG(c, d, a, b, M_offset_3, 14, T[26]);
              b = GG(b, c, d, a, M_offset_8, 20, T[27]);
              a = GG(a, b, c, d, M_offset_13, 5, T[28]);
              d = GG(d, a, b, c, M_offset_2, 9, T[29]);
              c = GG(c, d, a, b, M_offset_7, 14, T[30]);
              b = GG(b, c, d, a, M_offset_12, 20, T[31]);
              a = HH(a, b, c, d, M_offset_5, 4, T[32]);
              d = HH(d, a, b, c, M_offset_8, 11, T[33]);
              c = HH(c, d, a, b, M_offset_11, 16, T[34]);
              b = HH(b, c, d, a, M_offset_14, 23, T[35]);
              a = HH(a, b, c, d, M_offset_1, 4, T[36]);
              d = HH(d, a, b, c, M_offset_4, 11, T[37]);
              c = HH(c, d, a, b, M_offset_7, 16, T[38]);
              b = HH(b, c, d, a, M_offset_10, 23, T[39]);
              a = HH(a, b, c, d, M_offset_13, 4, T[40]);
              d = HH(d, a, b, c, M_offset_0, 11, T[41]);
              c = HH(c, d, a, b, M_offset_3, 16, T[42]);
              b = HH(b, c, d, a, M_offset_6, 23, T[43]);
              a = HH(a, b, c, d, M_offset_9, 4, T[44]);
              d = HH(d, a, b, c, M_offset_12, 11, T[45]);
              c = HH(c, d, a, b, M_offset_15, 16, T[46]);
              b = HH(b, c, d, a, M_offset_2, 23, T[47]);
              a = II(a, b, c, d, M_offset_0, 6, T[48]);
              d = II(d, a, b, c, M_offset_7, 10, T[49]);
              c = II(c, d, a, b, M_offset_14, 15, T[50]);
              b = II(b, c, d, a, M_offset_5, 21, T[51]);
              a = II(a, b, c, d, M_offset_12, 6, T[52]);
              d = II(d, a, b, c, M_offset_3, 10, T[53]);
              c = II(c, d, a, b, M_offset_10, 15, T[54]);
              b = II(b, c, d, a, M_offset_1, 21, T[55]);
              a = II(a, b, c, d, M_offset_8, 6, T[56]);
              d = II(d, a, b, c, M_offset_15, 10, T[57]);
              c = II(c, d, a, b, M_offset_6, 15, T[58]);
              b = II(b, c, d, a, M_offset_13, 21, T[59]);
              a = II(a, b, c, d, M_offset_4, 6, T[60]);
              d = II(d, a, b, c, M_offset_11, 10, T[61]);
              c = II(c, d, a, b, M_offset_2, 15, T[62]);
              b = II(b, c, d, a, M_offset_9, 21, T[63]);
              H[0] = H[0] + a | 0;
              H[1] = H[1] + b | 0;
              H[2] = H[2] + c | 0;
              H[3] = H[3] + d | 0;
            },
            _doFinalize: function() {
              var data = this._data;
              var dataWords = data.words;
              var nBitsTotal = this._nDataBytes * 8;
              var nBitsLeft = data.sigBytes * 8;
              dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32;
              var nBitsTotalH = Math2.floor(nBitsTotal / 4294967296);
              var nBitsTotalL = nBitsTotal;
              dataWords[(nBitsLeft + 64 >>> 9 << 4) + 15] = (nBitsTotalH << 8 | nBitsTotalH >>> 24) & 16711935 | (nBitsTotalH << 24 | nBitsTotalH >>> 8) & 4278255360;
              dataWords[(nBitsLeft + 64 >>> 9 << 4) + 14] = (nBitsTotalL << 8 | nBitsTotalL >>> 24) & 16711935 | (nBitsTotalL << 24 | nBitsTotalL >>> 8) & 4278255360;
              data.sigBytes = (dataWords.length + 1) * 4;
              this._process();
              var hash = this._hash;
              var H = hash.words;
              for (var i = 0; i < 4; i++) {
                var H_i = H[i];
                H[i] = (H_i << 8 | H_i >>> 24) & 16711935 | (H_i << 24 | H_i >>> 8) & 4278255360;
              }
              return hash;
            },
            clone: function() {
              var clone = Hasher.clone.call(this);
              clone._hash = this._hash.clone();
              return clone;
            }
          });
          function FF(a, b, c, d, x, s, t) {
            var n = a + (b & c | ~b & d) + x + t;
            return (n << s | n >>> 32 - s) + b;
          }
          function GG(a, b, c, d, x, s, t) {
            var n = a + (b & d | c & ~d) + x + t;
            return (n << s | n >>> 32 - s) + b;
          }
          function HH(a, b, c, d, x, s, t) {
            var n = a + (b ^ c ^ d) + x + t;
            return (n << s | n >>> 32 - s) + b;
          }
          function II(a, b, c, d, x, s, t) {
            var n = a + (c ^ (b | ~d)) + x + t;
            return (n << s | n >>> 32 - s) + b;
          }
          C.MD5 = Hasher._createHelper(MD53);
          C.HmacMD5 = Hasher._createHmacHelper(MD53);
        })(Math);
        return CryptoJS.MD5;
      });
    }
  });

  // node_modules/crypto-js/sha1.js
  var require_sha1 = __commonJS({
    "node_modules/crypto-js/sha1.js"(exports, module) {
      (function(root, factory) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var Hasher = C_lib.Hasher;
          var C_algo = C.algo;
          var W = [];
          var SHA1 = C_algo.SHA1 = Hasher.extend({
            _doReset: function() {
              this._hash = new WordArray.init([
                1732584193,
                4023233417,
                2562383102,
                271733878,
                3285377520
              ]);
            },
            _doProcessBlock: function(M, offset) {
              var H = this._hash.words;
              var a = H[0];
              var b = H[1];
              var c = H[2];
              var d = H[3];
              var e = H[4];
              for (var i = 0; i < 80; i++) {
                if (i < 16) {
                  W[i] = M[offset + i] | 0;
                } else {
                  var n = W[i - 3] ^ W[i - 8] ^ W[i - 14] ^ W[i - 16];
                  W[i] = n << 1 | n >>> 31;
                }
                var t = (a << 5 | a >>> 27) + e + W[i];
                if (i < 20) {
                  t += (b & c | ~b & d) + 1518500249;
                } else if (i < 40) {
                  t += (b ^ c ^ d) + 1859775393;
                } else if (i < 60) {
                  t += (b & c | b & d | c & d) - 1894007588;
                } else {
                  t += (b ^ c ^ d) - 899497514;
                }
                e = d;
                d = c;
                c = b << 30 | b >>> 2;
                b = a;
                a = t;
              }
              H[0] = H[0] + a | 0;
              H[1] = H[1] + b | 0;
              H[2] = H[2] + c | 0;
              H[3] = H[3] + d | 0;
              H[4] = H[4] + e | 0;
            },
            _doFinalize: function() {
              var data = this._data;
              var dataWords = data.words;
              var nBitsTotal = this._nDataBytes * 8;
              var nBitsLeft = data.sigBytes * 8;
              dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32;
              dataWords[(nBitsLeft + 64 >>> 9 << 4) + 14] = Math.floor(nBitsTotal / 4294967296);
              dataWords[(nBitsLeft + 64 >>> 9 << 4) + 15] = nBitsTotal;
              data.sigBytes = dataWords.length * 4;
              this._process();
              return this._hash;
            },
            clone: function() {
              var clone = Hasher.clone.call(this);
              clone._hash = this._hash.clone();
              return clone;
            }
          });
          C.SHA1 = Hasher._createHelper(SHA1);
          C.HmacSHA1 = Hasher._createHmacHelper(SHA1);
        })();
        return CryptoJS.SHA1;
      });
    }
  });

  // node_modules/crypto-js/sha256.js
  var require_sha256 = __commonJS({
    "node_modules/crypto-js/sha256.js"(exports, module) {
      (function(root, factory) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function(Math2) {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var Hasher = C_lib.Hasher;
          var C_algo = C.algo;
          var H = [];
          var K = [];
          (function() {
            function isPrime(n2) {
              var sqrtN = Math2.sqrt(n2);
              for (var factor = 2; factor <= sqrtN; factor++) {
                if (!(n2 % factor)) {
                  return false;
                }
              }
              return true;
            }
            function getFractionalBits(n2) {
              return (n2 - (n2 | 0)) * 4294967296 | 0;
            }
            var n = 2;
            var nPrime = 0;
            while (nPrime < 64) {
              if (isPrime(n)) {
                if (nPrime < 8) {
                  H[nPrime] = getFractionalBits(Math2.pow(n, 1 / 2));
                }
                K[nPrime] = getFractionalBits(Math2.pow(n, 1 / 3));
                nPrime++;
              }
              n++;
            }
          })();
          var W = [];
          var SHA256 = C_algo.SHA256 = Hasher.extend({
            _doReset: function() {
              this._hash = new WordArray.init(H.slice(0));
            },
            _doProcessBlock: function(M, offset) {
              var H2 = this._hash.words;
              var a = H2[0];
              var b = H2[1];
              var c = H2[2];
              var d = H2[3];
              var e = H2[4];
              var f = H2[5];
              var g = H2[6];
              var h = H2[7];
              for (var i = 0; i < 64; i++) {
                if (i < 16) {
                  W[i] = M[offset + i] | 0;
                } else {
                  var gamma0x = W[i - 15];
                  var gamma0 = (gamma0x << 25 | gamma0x >>> 7) ^ (gamma0x << 14 | gamma0x >>> 18) ^ gamma0x >>> 3;
                  var gamma1x = W[i - 2];
                  var gamma1 = (gamma1x << 15 | gamma1x >>> 17) ^ (gamma1x << 13 | gamma1x >>> 19) ^ gamma1x >>> 10;
                  W[i] = gamma0 + W[i - 7] + gamma1 + W[i - 16];
                }
                var ch = e & f ^ ~e & g;
                var maj = a & b ^ a & c ^ b & c;
                var sigma0 = (a << 30 | a >>> 2) ^ (a << 19 | a >>> 13) ^ (a << 10 | a >>> 22);
                var sigma1 = (e << 26 | e >>> 6) ^ (e << 21 | e >>> 11) ^ (e << 7 | e >>> 25);
                var t1 = h + sigma1 + ch + K[i] + W[i];
                var t2 = sigma0 + maj;
                h = g;
                g = f;
                f = e;
                e = d + t1 | 0;
                d = c;
                c = b;
                b = a;
                a = t1 + t2 | 0;
              }
              H2[0] = H2[0] + a | 0;
              H2[1] = H2[1] + b | 0;
              H2[2] = H2[2] + c | 0;
              H2[3] = H2[3] + d | 0;
              H2[4] = H2[4] + e | 0;
              H2[5] = H2[5] + f | 0;
              H2[6] = H2[6] + g | 0;
              H2[7] = H2[7] + h | 0;
            },
            _doFinalize: function() {
              var data = this._data;
              var dataWords = data.words;
              var nBitsTotal = this._nDataBytes * 8;
              var nBitsLeft = data.sigBytes * 8;
              dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32;
              dataWords[(nBitsLeft + 64 >>> 9 << 4) + 14] = Math2.floor(nBitsTotal / 4294967296);
              dataWords[(nBitsLeft + 64 >>> 9 << 4) + 15] = nBitsTotal;
              data.sigBytes = dataWords.length * 4;
              this._process();
              return this._hash;
            },
            clone: function() {
              var clone = Hasher.clone.call(this);
              clone._hash = this._hash.clone();
              return clone;
            }
          });
          C.SHA256 = Hasher._createHelper(SHA256);
          C.HmacSHA256 = Hasher._createHmacHelper(SHA256);
        })(Math);
        return CryptoJS.SHA256;
      });
    }
  });

  // node_modules/crypto-js/sha224.js
  var require_sha224 = __commonJS({
    "node_modules/crypto-js/sha224.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_sha256());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./sha256"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var C_algo = C.algo;
          var SHA256 = C_algo.SHA256;
          var SHA224 = C_algo.SHA224 = SHA256.extend({
            _doReset: function() {
              this._hash = new WordArray.init([
                3238371032,
                914150663,
                812702999,
                4144912697,
                4290775857,
                1750603025,
                1694076839,
                3204075428
              ]);
            },
            _doFinalize: function() {
              var hash = SHA256._doFinalize.call(this);
              hash.sigBytes -= 4;
              return hash;
            }
          });
          C.SHA224 = SHA256._createHelper(SHA224);
          C.HmacSHA224 = SHA256._createHmacHelper(SHA224);
        })();
        return CryptoJS.SHA224;
      });
    }
  });

  // node_modules/crypto-js/sha512.js
  var require_sha512 = __commonJS({
    "node_modules/crypto-js/sha512.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_x64_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./x64-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var Hasher = C_lib.Hasher;
          var C_x64 = C.x64;
          var X64Word = C_x64.Word;
          var X64WordArray = C_x64.WordArray;
          var C_algo = C.algo;
          function X64Word_create() {
            return X64Word.create.apply(X64Word, arguments);
          }
          var K = [
            X64Word_create(1116352408, 3609767458),
            X64Word_create(1899447441, 602891725),
            X64Word_create(3049323471, 3964484399),
            X64Word_create(3921009573, 2173295548),
            X64Word_create(961987163, 4081628472),
            X64Word_create(1508970993, 3053834265),
            X64Word_create(2453635748, 2937671579),
            X64Word_create(2870763221, 3664609560),
            X64Word_create(3624381080, 2734883394),
            X64Word_create(310598401, 1164996542),
            X64Word_create(607225278, 1323610764),
            X64Word_create(1426881987, 3590304994),
            X64Word_create(1925078388, 4068182383),
            X64Word_create(2162078206, 991336113),
            X64Word_create(2614888103, 633803317),
            X64Word_create(3248222580, 3479774868),
            X64Word_create(3835390401, 2666613458),
            X64Word_create(4022224774, 944711139),
            X64Word_create(264347078, 2341262773),
            X64Word_create(604807628, 2007800933),
            X64Word_create(770255983, 1495990901),
            X64Word_create(1249150122, 1856431235),
            X64Word_create(1555081692, 3175218132),
            X64Word_create(1996064986, 2198950837),
            X64Word_create(2554220882, 3999719339),
            X64Word_create(2821834349, 766784016),
            X64Word_create(2952996808, 2566594879),
            X64Word_create(3210313671, 3203337956),
            X64Word_create(3336571891, 1034457026),
            X64Word_create(3584528711, 2466948901),
            X64Word_create(113926993, 3758326383),
            X64Word_create(338241895, 168717936),
            X64Word_create(666307205, 1188179964),
            X64Word_create(773529912, 1546045734),
            X64Word_create(1294757372, 1522805485),
            X64Word_create(1396182291, 2643833823),
            X64Word_create(1695183700, 2343527390),
            X64Word_create(1986661051, 1014477480),
            X64Word_create(2177026350, 1206759142),
            X64Word_create(2456956037, 344077627),
            X64Word_create(2730485921, 1290863460),
            X64Word_create(2820302411, 3158454273),
            X64Word_create(3259730800, 3505952657),
            X64Word_create(3345764771, 106217008),
            X64Word_create(3516065817, 3606008344),
            X64Word_create(3600352804, 1432725776),
            X64Word_create(4094571909, 1467031594),
            X64Word_create(275423344, 851169720),
            X64Word_create(430227734, 3100823752),
            X64Word_create(506948616, 1363258195),
            X64Word_create(659060556, 3750685593),
            X64Word_create(883997877, 3785050280),
            X64Word_create(958139571, 3318307427),
            X64Word_create(1322822218, 3812723403),
            X64Word_create(1537002063, 2003034995),
            X64Word_create(1747873779, 3602036899),
            X64Word_create(1955562222, 1575990012),
            X64Word_create(2024104815, 1125592928),
            X64Word_create(2227730452, 2716904306),
            X64Word_create(2361852424, 442776044),
            X64Word_create(2428436474, 593698344),
            X64Word_create(2756734187, 3733110249),
            X64Word_create(3204031479, 2999351573),
            X64Word_create(3329325298, 3815920427),
            X64Word_create(3391569614, 3928383900),
            X64Word_create(3515267271, 566280711),
            X64Word_create(3940187606, 3454069534),
            X64Word_create(4118630271, 4000239992),
            X64Word_create(116418474, 1914138554),
            X64Word_create(174292421, 2731055270),
            X64Word_create(289380356, 3203993006),
            X64Word_create(460393269, 320620315),
            X64Word_create(685471733, 587496836),
            X64Word_create(852142971, 1086792851),
            X64Word_create(1017036298, 365543100),
            X64Word_create(1126000580, 2618297676),
            X64Word_create(1288033470, 3409855158),
            X64Word_create(1501505948, 4234509866),
            X64Word_create(1607167915, 987167468),
            X64Word_create(1816402316, 1246189591)
          ];
          var W = [];
          (function() {
            for (var i = 0; i < 80; i++) {
              W[i] = X64Word_create();
            }
          })();
          var SHA512 = C_algo.SHA512 = Hasher.extend({
            _doReset: function() {
              this._hash = new X64WordArray.init([
                new X64Word.init(1779033703, 4089235720),
                new X64Word.init(3144134277, 2227873595),
                new X64Word.init(1013904242, 4271175723),
                new X64Word.init(2773480762, 1595750129),
                new X64Word.init(1359893119, 2917565137),
                new X64Word.init(2600822924, 725511199),
                new X64Word.init(528734635, 4215389547),
                new X64Word.init(1541459225, 327033209)
              ]);
            },
            _doProcessBlock: function(M, offset) {
              var H = this._hash.words;
              var H0 = H[0];
              var H1 = H[1];
              var H2 = H[2];
              var H3 = H[3];
              var H4 = H[4];
              var H5 = H[5];
              var H6 = H[6];
              var H7 = H[7];
              var H0h = H0.high;
              var H0l = H0.low;
              var H1h = H1.high;
              var H1l = H1.low;
              var H2h = H2.high;
              var H2l = H2.low;
              var H3h = H3.high;
              var H3l = H3.low;
              var H4h = H4.high;
              var H4l = H4.low;
              var H5h = H5.high;
              var H5l = H5.low;
              var H6h = H6.high;
              var H6l = H6.low;
              var H7h = H7.high;
              var H7l = H7.low;
              var ah = H0h;
              var al = H0l;
              var bh = H1h;
              var bl = H1l;
              var ch = H2h;
              var cl = H2l;
              var dh = H3h;
              var dl = H3l;
              var eh = H4h;
              var el = H4l;
              var fh = H5h;
              var fl = H5l;
              var gh = H6h;
              var gl = H6l;
              var hh = H7h;
              var hl = H7l;
              for (var i = 0; i < 80; i++) {
                var Wil;
                var Wih;
                var Wi = W[i];
                if (i < 16) {
                  Wih = Wi.high = M[offset + i * 2] | 0;
                  Wil = Wi.low = M[offset + i * 2 + 1] | 0;
                } else {
                  var gamma0x = W[i - 15];
                  var gamma0xh = gamma0x.high;
                  var gamma0xl = gamma0x.low;
                  var gamma0h = (gamma0xh >>> 1 | gamma0xl << 31) ^ (gamma0xh >>> 8 | gamma0xl << 24) ^ gamma0xh >>> 7;
                  var gamma0l = (gamma0xl >>> 1 | gamma0xh << 31) ^ (gamma0xl >>> 8 | gamma0xh << 24) ^ (gamma0xl >>> 7 | gamma0xh << 25);
                  var gamma1x = W[i - 2];
                  var gamma1xh = gamma1x.high;
                  var gamma1xl = gamma1x.low;
                  var gamma1h = (gamma1xh >>> 19 | gamma1xl << 13) ^ (gamma1xh << 3 | gamma1xl >>> 29) ^ gamma1xh >>> 6;
                  var gamma1l = (gamma1xl >>> 19 | gamma1xh << 13) ^ (gamma1xl << 3 | gamma1xh >>> 29) ^ (gamma1xl >>> 6 | gamma1xh << 26);
                  var Wi7 = W[i - 7];
                  var Wi7h = Wi7.high;
                  var Wi7l = Wi7.low;
                  var Wi16 = W[i - 16];
                  var Wi16h = Wi16.high;
                  var Wi16l = Wi16.low;
                  Wil = gamma0l + Wi7l;
                  Wih = gamma0h + Wi7h + (Wil >>> 0 < gamma0l >>> 0 ? 1 : 0);
                  Wil = Wil + gamma1l;
                  Wih = Wih + gamma1h + (Wil >>> 0 < gamma1l >>> 0 ? 1 : 0);
                  Wil = Wil + Wi16l;
                  Wih = Wih + Wi16h + (Wil >>> 0 < Wi16l >>> 0 ? 1 : 0);
                  Wi.high = Wih;
                  Wi.low = Wil;
                }
                var chh = eh & fh ^ ~eh & gh;
                var chl = el & fl ^ ~el & gl;
                var majh = ah & bh ^ ah & ch ^ bh & ch;
                var majl = al & bl ^ al & cl ^ bl & cl;
                var sigma0h = (ah >>> 28 | al << 4) ^ (ah << 30 | al >>> 2) ^ (ah << 25 | al >>> 7);
                var sigma0l = (al >>> 28 | ah << 4) ^ (al << 30 | ah >>> 2) ^ (al << 25 | ah >>> 7);
                var sigma1h = (eh >>> 14 | el << 18) ^ (eh >>> 18 | el << 14) ^ (eh << 23 | el >>> 9);
                var sigma1l = (el >>> 14 | eh << 18) ^ (el >>> 18 | eh << 14) ^ (el << 23 | eh >>> 9);
                var Ki = K[i];
                var Kih = Ki.high;
                var Kil = Ki.low;
                var t1l = hl + sigma1l;
                var t1h = hh + sigma1h + (t1l >>> 0 < hl >>> 0 ? 1 : 0);
                var t1l = t1l + chl;
                var t1h = t1h + chh + (t1l >>> 0 < chl >>> 0 ? 1 : 0);
                var t1l = t1l + Kil;
                var t1h = t1h + Kih + (t1l >>> 0 < Kil >>> 0 ? 1 : 0);
                var t1l = t1l + Wil;
                var t1h = t1h + Wih + (t1l >>> 0 < Wil >>> 0 ? 1 : 0);
                var t2l = sigma0l + majl;
                var t2h = sigma0h + majh + (t2l >>> 0 < sigma0l >>> 0 ? 1 : 0);
                hh = gh;
                hl = gl;
                gh = fh;
                gl = fl;
                fh = eh;
                fl = el;
                el = dl + t1l | 0;
                eh = dh + t1h + (el >>> 0 < dl >>> 0 ? 1 : 0) | 0;
                dh = ch;
                dl = cl;
                ch = bh;
                cl = bl;
                bh = ah;
                bl = al;
                al = t1l + t2l | 0;
                ah = t1h + t2h + (al >>> 0 < t1l >>> 0 ? 1 : 0) | 0;
              }
              H0l = H0.low = H0l + al;
              H0.high = H0h + ah + (H0l >>> 0 < al >>> 0 ? 1 : 0);
              H1l = H1.low = H1l + bl;
              H1.high = H1h + bh + (H1l >>> 0 < bl >>> 0 ? 1 : 0);
              H2l = H2.low = H2l + cl;
              H2.high = H2h + ch + (H2l >>> 0 < cl >>> 0 ? 1 : 0);
              H3l = H3.low = H3l + dl;
              H3.high = H3h + dh + (H3l >>> 0 < dl >>> 0 ? 1 : 0);
              H4l = H4.low = H4l + el;
              H4.high = H4h + eh + (H4l >>> 0 < el >>> 0 ? 1 : 0);
              H5l = H5.low = H5l + fl;
              H5.high = H5h + fh + (H5l >>> 0 < fl >>> 0 ? 1 : 0);
              H6l = H6.low = H6l + gl;
              H6.high = H6h + gh + (H6l >>> 0 < gl >>> 0 ? 1 : 0);
              H7l = H7.low = H7l + hl;
              H7.high = H7h + hh + (H7l >>> 0 < hl >>> 0 ? 1 : 0);
            },
            _doFinalize: function() {
              var data = this._data;
              var dataWords = data.words;
              var nBitsTotal = this._nDataBytes * 8;
              var nBitsLeft = data.sigBytes * 8;
              dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32;
              dataWords[(nBitsLeft + 128 >>> 10 << 5) + 30] = Math.floor(nBitsTotal / 4294967296);
              dataWords[(nBitsLeft + 128 >>> 10 << 5) + 31] = nBitsTotal;
              data.sigBytes = dataWords.length * 4;
              this._process();
              var hash = this._hash.toX32();
              return hash;
            },
            clone: function() {
              var clone = Hasher.clone.call(this);
              clone._hash = this._hash.clone();
              return clone;
            },
            blockSize: 1024 / 32
          });
          C.SHA512 = Hasher._createHelper(SHA512);
          C.HmacSHA512 = Hasher._createHmacHelper(SHA512);
        })();
        return CryptoJS.SHA512;
      });
    }
  });

  // node_modules/crypto-js/sha384.js
  var require_sha384 = __commonJS({
    "node_modules/crypto-js/sha384.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_x64_core(), require_sha512());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./x64-core", "./sha512"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_x64 = C.x64;
          var X64Word = C_x64.Word;
          var X64WordArray = C_x64.WordArray;
          var C_algo = C.algo;
          var SHA512 = C_algo.SHA512;
          var SHA384 = C_algo.SHA384 = SHA512.extend({
            _doReset: function() {
              this._hash = new X64WordArray.init([
                new X64Word.init(3418070365, 3238371032),
                new X64Word.init(1654270250, 914150663),
                new X64Word.init(2438529370, 812702999),
                new X64Word.init(355462360, 4144912697),
                new X64Word.init(1731405415, 4290775857),
                new X64Word.init(2394180231, 1750603025),
                new X64Word.init(3675008525, 1694076839),
                new X64Word.init(1203062813, 3204075428)
              ]);
            },
            _doFinalize: function() {
              var hash = SHA512._doFinalize.call(this);
              hash.sigBytes -= 16;
              return hash;
            }
          });
          C.SHA384 = SHA512._createHelper(SHA384);
          C.HmacSHA384 = SHA512._createHmacHelper(SHA384);
        })();
        return CryptoJS.SHA384;
      });
    }
  });

  // node_modules/crypto-js/sha3.js
  var require_sha3 = __commonJS({
    "node_modules/crypto-js/sha3.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_x64_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./x64-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function(Math2) {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var Hasher = C_lib.Hasher;
          var C_x64 = C.x64;
          var X64Word = C_x64.Word;
          var C_algo = C.algo;
          var RHO_OFFSETS = [];
          var PI_INDEXES = [];
          var ROUND_CONSTANTS = [];
          (function() {
            var x = 1, y = 0;
            for (var t = 0; t < 24; t++) {
              RHO_OFFSETS[x + 5 * y] = (t + 1) * (t + 2) / 2 % 64;
              var newX = y % 5;
              var newY = (2 * x + 3 * y) % 5;
              x = newX;
              y = newY;
            }
            for (var x = 0; x < 5; x++) {
              for (var y = 0; y < 5; y++) {
                PI_INDEXES[x + 5 * y] = y + (2 * x + 3 * y) % 5 * 5;
              }
            }
            var LFSR = 1;
            for (var i = 0; i < 24; i++) {
              var roundConstantMsw = 0;
              var roundConstantLsw = 0;
              for (var j = 0; j < 7; j++) {
                if (LFSR & 1) {
                  var bitPosition = (1 << j) - 1;
                  if (bitPosition < 32) {
                    roundConstantLsw ^= 1 << bitPosition;
                  } else {
                    roundConstantMsw ^= 1 << bitPosition - 32;
                  }
                }
                if (LFSR & 128) {
                  LFSR = LFSR << 1 ^ 113;
                } else {
                  LFSR <<= 1;
                }
              }
              ROUND_CONSTANTS[i] = X64Word.create(roundConstantMsw, roundConstantLsw);
            }
          })();
          var T = [];
          (function() {
            for (var i = 0; i < 25; i++) {
              T[i] = X64Word.create();
            }
          })();
          var SHA3 = C_algo.SHA3 = Hasher.extend({
            /**
             * Configuration options.
             *
             * @property {number} outputLength
             *   The desired number of bits in the output hash.
             *   Only values permitted are: 224, 256, 384, 512.
             *   Default: 512
             */
            cfg: Hasher.cfg.extend({
              outputLength: 512
            }),
            _doReset: function() {
              var state = this._state = [];
              for (var i = 0; i < 25; i++) {
                state[i] = new X64Word.init();
              }
              this.blockSize = (1600 - 2 * this.cfg.outputLength) / 32;
            },
            _doProcessBlock: function(M, offset) {
              var state = this._state;
              var nBlockSizeLanes = this.blockSize / 2;
              for (var i = 0; i < nBlockSizeLanes; i++) {
                var M2i = M[offset + 2 * i];
                var M2i1 = M[offset + 2 * i + 1];
                M2i = (M2i << 8 | M2i >>> 24) & 16711935 | (M2i << 24 | M2i >>> 8) & 4278255360;
                M2i1 = (M2i1 << 8 | M2i1 >>> 24) & 16711935 | (M2i1 << 24 | M2i1 >>> 8) & 4278255360;
                var lane = state[i];
                lane.high ^= M2i1;
                lane.low ^= M2i;
              }
              for (var round = 0; round < 24; round++) {
                for (var x = 0; x < 5; x++) {
                  var tMsw = 0, tLsw = 0;
                  for (var y = 0; y < 5; y++) {
                    var lane = state[x + 5 * y];
                    tMsw ^= lane.high;
                    tLsw ^= lane.low;
                  }
                  var Tx = T[x];
                  Tx.high = tMsw;
                  Tx.low = tLsw;
                }
                for (var x = 0; x < 5; x++) {
                  var Tx4 = T[(x + 4) % 5];
                  var Tx1 = T[(x + 1) % 5];
                  var Tx1Msw = Tx1.high;
                  var Tx1Lsw = Tx1.low;
                  var tMsw = Tx4.high ^ (Tx1Msw << 1 | Tx1Lsw >>> 31);
                  var tLsw = Tx4.low ^ (Tx1Lsw << 1 | Tx1Msw >>> 31);
                  for (var y = 0; y < 5; y++) {
                    var lane = state[x + 5 * y];
                    lane.high ^= tMsw;
                    lane.low ^= tLsw;
                  }
                }
                for (var laneIndex = 1; laneIndex < 25; laneIndex++) {
                  var tMsw;
                  var tLsw;
                  var lane = state[laneIndex];
                  var laneMsw = lane.high;
                  var laneLsw = lane.low;
                  var rhoOffset = RHO_OFFSETS[laneIndex];
                  if (rhoOffset < 32) {
                    tMsw = laneMsw << rhoOffset | laneLsw >>> 32 - rhoOffset;
                    tLsw = laneLsw << rhoOffset | laneMsw >>> 32 - rhoOffset;
                  } else {
                    tMsw = laneLsw << rhoOffset - 32 | laneMsw >>> 64 - rhoOffset;
                    tLsw = laneMsw << rhoOffset - 32 | laneLsw >>> 64 - rhoOffset;
                  }
                  var TPiLane = T[PI_INDEXES[laneIndex]];
                  TPiLane.high = tMsw;
                  TPiLane.low = tLsw;
                }
                var T0 = T[0];
                var state0 = state[0];
                T0.high = state0.high;
                T0.low = state0.low;
                for (var x = 0; x < 5; x++) {
                  for (var y = 0; y < 5; y++) {
                    var laneIndex = x + 5 * y;
                    var lane = state[laneIndex];
                    var TLane = T[laneIndex];
                    var Tx1Lane = T[(x + 1) % 5 + 5 * y];
                    var Tx2Lane = T[(x + 2) % 5 + 5 * y];
                    lane.high = TLane.high ^ ~Tx1Lane.high & Tx2Lane.high;
                    lane.low = TLane.low ^ ~Tx1Lane.low & Tx2Lane.low;
                  }
                }
                var lane = state[0];
                var roundConstant = ROUND_CONSTANTS[round];
                lane.high ^= roundConstant.high;
                lane.low ^= roundConstant.low;
              }
            },
            _doFinalize: function() {
              var data = this._data;
              var dataWords = data.words;
              var nBitsTotal = this._nDataBytes * 8;
              var nBitsLeft = data.sigBytes * 8;
              var blockSizeBits = this.blockSize * 32;
              dataWords[nBitsLeft >>> 5] |= 1 << 24 - nBitsLeft % 32;
              dataWords[(Math2.ceil((nBitsLeft + 1) / blockSizeBits) * blockSizeBits >>> 5) - 1] |= 128;
              data.sigBytes = dataWords.length * 4;
              this._process();
              var state = this._state;
              var outputLengthBytes = this.cfg.outputLength / 8;
              var outputLengthLanes = outputLengthBytes / 8;
              var hashWords = [];
              for (var i = 0; i < outputLengthLanes; i++) {
                var lane = state[i];
                var laneMsw = lane.high;
                var laneLsw = lane.low;
                laneMsw = (laneMsw << 8 | laneMsw >>> 24) & 16711935 | (laneMsw << 24 | laneMsw >>> 8) & 4278255360;
                laneLsw = (laneLsw << 8 | laneLsw >>> 24) & 16711935 | (laneLsw << 24 | laneLsw >>> 8) & 4278255360;
                hashWords.push(laneLsw);
                hashWords.push(laneMsw);
              }
              return new WordArray.init(hashWords, outputLengthBytes);
            },
            clone: function() {
              var clone = Hasher.clone.call(this);
              var state = clone._state = this._state.slice(0);
              for (var i = 0; i < 25; i++) {
                state[i] = state[i].clone();
              }
              return clone;
            }
          });
          C.SHA3 = Hasher._createHelper(SHA3);
          C.HmacSHA3 = Hasher._createHmacHelper(SHA3);
        })(Math);
        return CryptoJS.SHA3;
      });
    }
  });

  // node_modules/crypto-js/ripemd160.js
  var require_ripemd160 = __commonJS({
    "node_modules/crypto-js/ripemd160.js"(exports, module) {
      (function(root, factory) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function(Math2) {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var Hasher = C_lib.Hasher;
          var C_algo = C.algo;
          var _zl = WordArray.create([
            0,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            9,
            10,
            11,
            12,
            13,
            14,
            15,
            7,
            4,
            13,
            1,
            10,
            6,
            15,
            3,
            12,
            0,
            9,
            5,
            2,
            14,
            11,
            8,
            3,
            10,
            14,
            4,
            9,
            15,
            8,
            1,
            2,
            7,
            0,
            6,
            13,
            11,
            5,
            12,
            1,
            9,
            11,
            10,
            0,
            8,
            12,
            4,
            13,
            3,
            7,
            15,
            14,
            5,
            6,
            2,
            4,
            0,
            5,
            9,
            7,
            12,
            2,
            10,
            14,
            1,
            3,
            8,
            11,
            6,
            15,
            13
          ]);
          var _zr = WordArray.create([
            5,
            14,
            7,
            0,
            9,
            2,
            11,
            4,
            13,
            6,
            15,
            8,
            1,
            10,
            3,
            12,
            6,
            11,
            3,
            7,
            0,
            13,
            5,
            10,
            14,
            15,
            8,
            12,
            4,
            9,
            1,
            2,
            15,
            5,
            1,
            3,
            7,
            14,
            6,
            9,
            11,
            8,
            12,
            2,
            10,
            0,
            4,
            13,
            8,
            6,
            4,
            1,
            3,
            11,
            15,
            0,
            5,
            12,
            2,
            13,
            9,
            7,
            10,
            14,
            12,
            15,
            10,
            4,
            1,
            5,
            8,
            7,
            6,
            2,
            13,
            14,
            0,
            3,
            9,
            11
          ]);
          var _sl = WordArray.create([
            11,
            14,
            15,
            12,
            5,
            8,
            7,
            9,
            11,
            13,
            14,
            15,
            6,
            7,
            9,
            8,
            7,
            6,
            8,
            13,
            11,
            9,
            7,
            15,
            7,
            12,
            15,
            9,
            11,
            7,
            13,
            12,
            11,
            13,
            6,
            7,
            14,
            9,
            13,
            15,
            14,
            8,
            13,
            6,
            5,
            12,
            7,
            5,
            11,
            12,
            14,
            15,
            14,
            15,
            9,
            8,
            9,
            14,
            5,
            6,
            8,
            6,
            5,
            12,
            9,
            15,
            5,
            11,
            6,
            8,
            13,
            12,
            5,
            12,
            13,
            14,
            11,
            8,
            5,
            6
          ]);
          var _sr = WordArray.create([
            8,
            9,
            9,
            11,
            13,
            15,
            15,
            5,
            7,
            7,
            8,
            11,
            14,
            14,
            12,
            6,
            9,
            13,
            15,
            7,
            12,
            8,
            9,
            11,
            7,
            7,
            12,
            7,
            6,
            15,
            13,
            11,
            9,
            7,
            15,
            11,
            8,
            6,
            6,
            14,
            12,
            13,
            5,
            14,
            13,
            13,
            7,
            5,
            15,
            5,
            8,
            11,
            14,
            14,
            6,
            14,
            6,
            9,
            12,
            9,
            12,
            5,
            15,
            8,
            8,
            5,
            12,
            9,
            12,
            5,
            14,
            6,
            8,
            13,
            6,
            5,
            15,
            13,
            11,
            11
          ]);
          var _hl = WordArray.create([0, 1518500249, 1859775393, 2400959708, 2840853838]);
          var _hr = WordArray.create([1352829926, 1548603684, 1836072691, 2053994217, 0]);
          var RIPEMD160 = C_algo.RIPEMD160 = Hasher.extend({
            _doReset: function() {
              this._hash = WordArray.create([1732584193, 4023233417, 2562383102, 271733878, 3285377520]);
            },
            _doProcessBlock: function(M, offset) {
              for (var i = 0; i < 16; i++) {
                var offset_i = offset + i;
                var M_offset_i = M[offset_i];
                M[offset_i] = (M_offset_i << 8 | M_offset_i >>> 24) & 16711935 | (M_offset_i << 24 | M_offset_i >>> 8) & 4278255360;
              }
              var H = this._hash.words;
              var hl = _hl.words;
              var hr = _hr.words;
              var zl = _zl.words;
              var zr = _zr.words;
              var sl = _sl.words;
              var sr = _sr.words;
              var al, bl, cl, dl, el;
              var ar, br, cr, dr, er;
              ar = al = H[0];
              br = bl = H[1];
              cr = cl = H[2];
              dr = dl = H[3];
              er = el = H[4];
              var t;
              for (var i = 0; i < 80; i += 1) {
                t = al + M[offset + zl[i]] | 0;
                if (i < 16) {
                  t += f1(bl, cl, dl) + hl[0];
                } else if (i < 32) {
                  t += f2(bl, cl, dl) + hl[1];
                } else if (i < 48) {
                  t += f3(bl, cl, dl) + hl[2];
                } else if (i < 64) {
                  t += f4(bl, cl, dl) + hl[3];
                } else {
                  t += f5(bl, cl, dl) + hl[4];
                }
                t = t | 0;
                t = rotl(t, sl[i]);
                t = t + el | 0;
                al = el;
                el = dl;
                dl = rotl(cl, 10);
                cl = bl;
                bl = t;
                t = ar + M[offset + zr[i]] | 0;
                if (i < 16) {
                  t += f5(br, cr, dr) + hr[0];
                } else if (i < 32) {
                  t += f4(br, cr, dr) + hr[1];
                } else if (i < 48) {
                  t += f3(br, cr, dr) + hr[2];
                } else if (i < 64) {
                  t += f2(br, cr, dr) + hr[3];
                } else {
                  t += f1(br, cr, dr) + hr[4];
                }
                t = t | 0;
                t = rotl(t, sr[i]);
                t = t + er | 0;
                ar = er;
                er = dr;
                dr = rotl(cr, 10);
                cr = br;
                br = t;
              }
              t = H[1] + cl + dr | 0;
              H[1] = H[2] + dl + er | 0;
              H[2] = H[3] + el + ar | 0;
              H[3] = H[4] + al + br | 0;
              H[4] = H[0] + bl + cr | 0;
              H[0] = t;
            },
            _doFinalize: function() {
              var data = this._data;
              var dataWords = data.words;
              var nBitsTotal = this._nDataBytes * 8;
              var nBitsLeft = data.sigBytes * 8;
              dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32;
              dataWords[(nBitsLeft + 64 >>> 9 << 4) + 14] = (nBitsTotal << 8 | nBitsTotal >>> 24) & 16711935 | (nBitsTotal << 24 | nBitsTotal >>> 8) & 4278255360;
              data.sigBytes = (dataWords.length + 1) * 4;
              this._process();
              var hash = this._hash;
              var H = hash.words;
              for (var i = 0; i < 5; i++) {
                var H_i = H[i];
                H[i] = (H_i << 8 | H_i >>> 24) & 16711935 | (H_i << 24 | H_i >>> 8) & 4278255360;
              }
              return hash;
            },
            clone: function() {
              var clone = Hasher.clone.call(this);
              clone._hash = this._hash.clone();
              return clone;
            }
          });
          function f1(x, y, z) {
            return x ^ y ^ z;
          }
          function f2(x, y, z) {
            return x & y | ~x & z;
          }
          function f3(x, y, z) {
            return (x | ~y) ^ z;
          }
          function f4(x, y, z) {
            return x & z | y & ~z;
          }
          function f5(x, y, z) {
            return x ^ (y | ~z);
          }
          function rotl(x, n) {
            return x << n | x >>> 32 - n;
          }
          C.RIPEMD160 = Hasher._createHelper(RIPEMD160);
          C.HmacRIPEMD160 = Hasher._createHmacHelper(RIPEMD160);
        })(Math);
        return CryptoJS.RIPEMD160;
      });
    }
  });

  // node_modules/crypto-js/hmac.js
  var require_hmac = __commonJS({
    "node_modules/crypto-js/hmac.js"(exports, module) {
      (function(root, factory) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var Base = C_lib.Base;
          var C_enc = C.enc;
          var Utf8 = C_enc.Utf8;
          var C_algo = C.algo;
          var HMAC = C_algo.HMAC = Base.extend({
            /**
             * Initializes a newly created HMAC.
             *
             * @param {Hasher} hasher The hash algorithm to use.
             * @param {WordArray|string} key The secret key.
             *
             * @example
             *
             *     var hmacHasher = CryptoJS.algo.HMAC.create(CryptoJS.algo.SHA256, key);
             */
            init: function(hasher, key) {
              hasher = this._hasher = new hasher.init();
              if (typeof key == "string") {
                key = Utf8.parse(key);
              }
              var hasherBlockSize = hasher.blockSize;
              var hasherBlockSizeBytes = hasherBlockSize * 4;
              if (key.sigBytes > hasherBlockSizeBytes) {
                key = hasher.finalize(key);
              }
              key.clamp();
              var oKey = this._oKey = key.clone();
              var iKey = this._iKey = key.clone();
              var oKeyWords = oKey.words;
              var iKeyWords = iKey.words;
              for (var i = 0; i < hasherBlockSize; i++) {
                oKeyWords[i] ^= 1549556828;
                iKeyWords[i] ^= 909522486;
              }
              oKey.sigBytes = iKey.sigBytes = hasherBlockSizeBytes;
              this.reset();
            },
            /**
             * Resets this HMAC to its initial state.
             *
             * @example
             *
             *     hmacHasher.reset();
             */
            reset: function() {
              var hasher = this._hasher;
              hasher.reset();
              hasher.update(this._iKey);
            },
            /**
             * Updates this HMAC with a message.
             *
             * @param {WordArray|string} messageUpdate The message to append.
             *
             * @return {HMAC} This HMAC instance.
             *
             * @example
             *
             *     hmacHasher.update('message');
             *     hmacHasher.update(wordArray);
             */
            update: function(messageUpdate) {
              this._hasher.update(messageUpdate);
              return this;
            },
            /**
             * Finalizes the HMAC computation.
             * Note that the finalize operation is effectively a destructive, read-once operation.
             *
             * @param {WordArray|string} messageUpdate (Optional) A final message update.
             *
             * @return {WordArray} The HMAC.
             *
             * @example
             *
             *     var hmac = hmacHasher.finalize();
             *     var hmac = hmacHasher.finalize('message');
             *     var hmac = hmacHasher.finalize(wordArray);
             */
            finalize: function(messageUpdate) {
              var hasher = this._hasher;
              var innerHash = hasher.finalize(messageUpdate);
              hasher.reset();
              var hmac = hasher.finalize(this._oKey.clone().concat(innerHash));
              return hmac;
            }
          });
        })();
      });
    }
  });

  // node_modules/crypto-js/pbkdf2.js
  var require_pbkdf2 = __commonJS({
    "node_modules/crypto-js/pbkdf2.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_sha1(), require_hmac());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./sha1", "./hmac"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var Base = C_lib.Base;
          var WordArray = C_lib.WordArray;
          var C_algo = C.algo;
          var SHA1 = C_algo.SHA1;
          var HMAC = C_algo.HMAC;
          var PBKDF2 = C_algo.PBKDF2 = Base.extend({
            /**
             * Configuration options.
             *
             * @property {number} keySize The key size in words to generate. Default: 4 (128 bits)
             * @property {Hasher} hasher The hasher to use. Default: SHA1
             * @property {number} iterations The number of iterations to perform. Default: 1
             */
            cfg: Base.extend({
              keySize: 128 / 32,
              hasher: SHA1,
              iterations: 1
            }),
            /**
             * Initializes a newly created key derivation function.
             *
             * @param {Object} cfg (Optional) The configuration options to use for the derivation.
             *
             * @example
             *
             *     var kdf = CryptoJS.algo.PBKDF2.create();
             *     var kdf = CryptoJS.algo.PBKDF2.create({ keySize: 8 });
             *     var kdf = CryptoJS.algo.PBKDF2.create({ keySize: 8, iterations: 1000 });
             */
            init: function(cfg) {
              this.cfg = this.cfg.extend(cfg);
            },
            /**
             * Computes the Password-Based Key Derivation Function 2.
             *
             * @param {WordArray|string} password The password.
             * @param {WordArray|string} salt A salt.
             *
             * @return {WordArray} The derived key.
             *
             * @example
             *
             *     var key = kdf.compute(password, salt);
             */
            compute: function(password, salt) {
              var cfg = this.cfg;
              var hmac = HMAC.create(cfg.hasher, password);
              var derivedKey = WordArray.create();
              var blockIndex = WordArray.create([1]);
              var derivedKeyWords = derivedKey.words;
              var blockIndexWords = blockIndex.words;
              var keySize = cfg.keySize;
              var iterations = cfg.iterations;
              while (derivedKeyWords.length < keySize) {
                var block = hmac.update(salt).finalize(blockIndex);
                hmac.reset();
                var blockWords = block.words;
                var blockWordsLength = blockWords.length;
                var intermediate = block;
                for (var i = 1; i < iterations; i++) {
                  intermediate = hmac.finalize(intermediate);
                  hmac.reset();
                  var intermediateWords = intermediate.words;
                  for (var j = 0; j < blockWordsLength; j++) {
                    blockWords[j] ^= intermediateWords[j];
                  }
                }
                derivedKey.concat(block);
                blockIndexWords[0]++;
              }
              derivedKey.sigBytes = keySize * 4;
              return derivedKey;
            }
          });
          C.PBKDF2 = function(password, salt, cfg) {
            return PBKDF2.create(cfg).compute(password, salt);
          };
        })();
        return CryptoJS.PBKDF2;
      });
    }
  });

  // node_modules/crypto-js/evpkdf.js
  var require_evpkdf = __commonJS({
    "node_modules/crypto-js/evpkdf.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_sha1(), require_hmac());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./sha1", "./hmac"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var Base = C_lib.Base;
          var WordArray = C_lib.WordArray;
          var C_algo = C.algo;
          var MD53 = C_algo.MD5;
          var EvpKDF = C_algo.EvpKDF = Base.extend({
            /**
             * Configuration options.
             *
             * @property {number} keySize The key size in words to generate. Default: 4 (128 bits)
             * @property {Hasher} hasher The hash algorithm to use. Default: MD5
             * @property {number} iterations The number of iterations to perform. Default: 1
             */
            cfg: Base.extend({
              keySize: 128 / 32,
              hasher: MD53,
              iterations: 1
            }),
            /**
             * Initializes a newly created key derivation function.
             *
             * @param {Object} cfg (Optional) The configuration options to use for the derivation.
             *
             * @example
             *
             *     var kdf = CryptoJS.algo.EvpKDF.create();
             *     var kdf = CryptoJS.algo.EvpKDF.create({ keySize: 8 });
             *     var kdf = CryptoJS.algo.EvpKDF.create({ keySize: 8, iterations: 1000 });
             */
            init: function(cfg) {
              this.cfg = this.cfg.extend(cfg);
            },
            /**
             * Derives a key from a password.
             *
             * @param {WordArray|string} password The password.
             * @param {WordArray|string} salt A salt.
             *
             * @return {WordArray} The derived key.
             *
             * @example
             *
             *     var key = kdf.compute(password, salt);
             */
            compute: function(password, salt) {
              var block;
              var cfg = this.cfg;
              var hasher = cfg.hasher.create();
              var derivedKey = WordArray.create();
              var derivedKeyWords = derivedKey.words;
              var keySize = cfg.keySize;
              var iterations = cfg.iterations;
              while (derivedKeyWords.length < keySize) {
                if (block) {
                  hasher.update(block);
                }
                block = hasher.update(password).finalize(salt);
                hasher.reset();
                for (var i = 1; i < iterations; i++) {
                  block = hasher.finalize(block);
                  hasher.reset();
                }
                derivedKey.concat(block);
              }
              derivedKey.sigBytes = keySize * 4;
              return derivedKey;
            }
          });
          C.EvpKDF = function(password, salt, cfg) {
            return EvpKDF.create(cfg).compute(password, salt);
          };
        })();
        return CryptoJS.EvpKDF;
      });
    }
  });

  // node_modules/crypto-js/cipher-core.js
  var require_cipher_core = __commonJS({
    "node_modules/crypto-js/cipher-core.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_evpkdf());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./evpkdf"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        CryptoJS.lib.Cipher || function(undefined2) {
          var C = CryptoJS;
          var C_lib = C.lib;
          var Base = C_lib.Base;
          var WordArray = C_lib.WordArray;
          var BufferedBlockAlgorithm = C_lib.BufferedBlockAlgorithm;
          var C_enc = C.enc;
          var Utf8 = C_enc.Utf8;
          var Base64 = C_enc.Base64;
          var C_algo = C.algo;
          var EvpKDF = C_algo.EvpKDF;
          var Cipher = C_lib.Cipher = BufferedBlockAlgorithm.extend({
            /**
             * Configuration options.
             *
             * @property {WordArray} iv The IV to use for this operation.
             */
            cfg: Base.extend(),
            /**
             * Creates this cipher in encryption mode.
             *
             * @param {WordArray} key The key.
             * @param {Object} cfg (Optional) The configuration options to use for this operation.
             *
             * @return {Cipher} A cipher instance.
             *
             * @static
             *
             * @example
             *
             *     var cipher = CryptoJS.algo.AES.createEncryptor(keyWordArray, { iv: ivWordArray });
             */
            createEncryptor: function(key, cfg) {
              return this.create(this._ENC_XFORM_MODE, key, cfg);
            },
            /**
             * Creates this cipher in decryption mode.
             *
             * @param {WordArray} key The key.
             * @param {Object} cfg (Optional) The configuration options to use for this operation.
             *
             * @return {Cipher} A cipher instance.
             *
             * @static
             *
             * @example
             *
             *     var cipher = CryptoJS.algo.AES.createDecryptor(keyWordArray, { iv: ivWordArray });
             */
            createDecryptor: function(key, cfg) {
              return this.create(this._DEC_XFORM_MODE, key, cfg);
            },
            /**
             * Initializes a newly created cipher.
             *
             * @param {number} xformMode Either the encryption or decryption transormation mode constant.
             * @param {WordArray} key The key.
             * @param {Object} cfg (Optional) The configuration options to use for this operation.
             *
             * @example
             *
             *     var cipher = CryptoJS.algo.AES.create(CryptoJS.algo.AES._ENC_XFORM_MODE, keyWordArray, { iv: ivWordArray });
             */
            init: function(xformMode, key, cfg) {
              this.cfg = this.cfg.extend(cfg);
              this._xformMode = xformMode;
              this._key = key;
              this.reset();
            },
            /**
             * Resets this cipher to its initial state.
             *
             * @example
             *
             *     cipher.reset();
             */
            reset: function() {
              BufferedBlockAlgorithm.reset.call(this);
              this._doReset();
            },
            /**
             * Adds data to be encrypted or decrypted.
             *
             * @param {WordArray|string} dataUpdate The data to encrypt or decrypt.
             *
             * @return {WordArray} The data after processing.
             *
             * @example
             *
             *     var encrypted = cipher.process('data');
             *     var encrypted = cipher.process(wordArray);
             */
            process: function(dataUpdate) {
              this._append(dataUpdate);
              return this._process();
            },
            /**
             * Finalizes the encryption or decryption process.
             * Note that the finalize operation is effectively a destructive, read-once operation.
             *
             * @param {WordArray|string} dataUpdate The final data to encrypt or decrypt.
             *
             * @return {WordArray} The data after final processing.
             *
             * @example
             *
             *     var encrypted = cipher.finalize();
             *     var encrypted = cipher.finalize('data');
             *     var encrypted = cipher.finalize(wordArray);
             */
            finalize: function(dataUpdate) {
              if (dataUpdate) {
                this._append(dataUpdate);
              }
              var finalProcessedData = this._doFinalize();
              return finalProcessedData;
            },
            keySize: 128 / 32,
            ivSize: 128 / 32,
            _ENC_XFORM_MODE: 1,
            _DEC_XFORM_MODE: 2,
            /**
             * Creates shortcut functions to a cipher's object interface.
             *
             * @param {Cipher} cipher The cipher to create a helper for.
             *
             * @return {Object} An object with encrypt and decrypt shortcut functions.
             *
             * @static
             *
             * @example
             *
             *     var AES = CryptoJS.lib.Cipher._createHelper(CryptoJS.algo.AES);
             */
            _createHelper: function() {
              function selectCipherStrategy(key) {
                if (typeof key == "string") {
                  return PasswordBasedCipher;
                } else {
                  return SerializableCipher;
                }
              }
              return function(cipher) {
                return {
                  encrypt: function(message, key, cfg) {
                    return selectCipherStrategy(key).encrypt(cipher, message, key, cfg);
                  },
                  decrypt: function(ciphertext, key, cfg) {
                    return selectCipherStrategy(key).decrypt(cipher, ciphertext, key, cfg);
                  }
                };
              };
            }()
          });
          var StreamCipher = C_lib.StreamCipher = Cipher.extend({
            _doFinalize: function() {
              var finalProcessedBlocks = this._process(true);
              return finalProcessedBlocks;
            },
            blockSize: 1
          });
          var C_mode = C.mode = {};
          var BlockCipherMode = C_lib.BlockCipherMode = Base.extend({
            /**
             * Creates this mode for encryption.
             *
             * @param {Cipher} cipher A block cipher instance.
             * @param {Array} iv The IV words.
             *
             * @static
             *
             * @example
             *
             *     var mode = CryptoJS.mode.CBC.createEncryptor(cipher, iv.words);
             */
            createEncryptor: function(cipher, iv) {
              return this.Encryptor.create(cipher, iv);
            },
            /**
             * Creates this mode for decryption.
             *
             * @param {Cipher} cipher A block cipher instance.
             * @param {Array} iv The IV words.
             *
             * @static
             *
             * @example
             *
             *     var mode = CryptoJS.mode.CBC.createDecryptor(cipher, iv.words);
             */
            createDecryptor: function(cipher, iv) {
              return this.Decryptor.create(cipher, iv);
            },
            /**
             * Initializes a newly created mode.
             *
             * @param {Cipher} cipher A block cipher instance.
             * @param {Array} iv The IV words.
             *
             * @example
             *
             *     var mode = CryptoJS.mode.CBC.Encryptor.create(cipher, iv.words);
             */
            init: function(cipher, iv) {
              this._cipher = cipher;
              this._iv = iv;
            }
          });
          var CBC = C_mode.CBC = function() {
            var CBC2 = BlockCipherMode.extend();
            CBC2.Encryptor = CBC2.extend({
              /**
               * Processes the data block at offset.
               *
               * @param {Array} words The data words to operate on.
               * @param {number} offset The offset where the block starts.
               *
               * @example
               *
               *     mode.processBlock(data.words, offset);
               */
              processBlock: function(words, offset) {
                var cipher = this._cipher;
                var blockSize = cipher.blockSize;
                xorBlock.call(this, words, offset, blockSize);
                cipher.encryptBlock(words, offset);
                this._prevBlock = words.slice(offset, offset + blockSize);
              }
            });
            CBC2.Decryptor = CBC2.extend({
              /**
               * Processes the data block at offset.
               *
               * @param {Array} words The data words to operate on.
               * @param {number} offset The offset where the block starts.
               *
               * @example
               *
               *     mode.processBlock(data.words, offset);
               */
              processBlock: function(words, offset) {
                var cipher = this._cipher;
                var blockSize = cipher.blockSize;
                var thisBlock = words.slice(offset, offset + blockSize);
                cipher.decryptBlock(words, offset);
                xorBlock.call(this, words, offset, blockSize);
                this._prevBlock = thisBlock;
              }
            });
            function xorBlock(words, offset, blockSize) {
              var block;
              var iv = this._iv;
              if (iv) {
                block = iv;
                this._iv = undefined2;
              } else {
                block = this._prevBlock;
              }
              for (var i = 0; i < blockSize; i++) {
                words[offset + i] ^= block[i];
              }
            }
            return CBC2;
          }();
          var C_pad = C.pad = {};
          var Pkcs7 = C_pad.Pkcs7 = {
            /**
             * Pads data using the algorithm defined in PKCS #5/7.
             *
             * @param {WordArray} data The data to pad.
             * @param {number} blockSize The multiple that the data should be padded to.
             *
             * @static
             *
             * @example
             *
             *     CryptoJS.pad.Pkcs7.pad(wordArray, 4);
             */
            pad: function(data, blockSize) {
              var blockSizeBytes = blockSize * 4;
              var nPaddingBytes = blockSizeBytes - data.sigBytes % blockSizeBytes;
              var paddingWord = nPaddingBytes << 24 | nPaddingBytes << 16 | nPaddingBytes << 8 | nPaddingBytes;
              var paddingWords = [];
              for (var i = 0; i < nPaddingBytes; i += 4) {
                paddingWords.push(paddingWord);
              }
              var padding = WordArray.create(paddingWords, nPaddingBytes);
              data.concat(padding);
            },
            /**
             * Unpads data that had been padded using the algorithm defined in PKCS #5/7.
             *
             * @param {WordArray} data The data to unpad.
             *
             * @static
             *
             * @example
             *
             *     CryptoJS.pad.Pkcs7.unpad(wordArray);
             */
            unpad: function(data) {
              var nPaddingBytes = data.words[data.sigBytes - 1 >>> 2] & 255;
              data.sigBytes -= nPaddingBytes;
            }
          };
          var BlockCipher = C_lib.BlockCipher = Cipher.extend({
            /**
             * Configuration options.
             *
             * @property {Mode} mode The block mode to use. Default: CBC
             * @property {Padding} padding The padding strategy to use. Default: Pkcs7
             */
            cfg: Cipher.cfg.extend({
              mode: CBC,
              padding: Pkcs7
            }),
            reset: function() {
              var modeCreator;
              Cipher.reset.call(this);
              var cfg = this.cfg;
              var iv = cfg.iv;
              var mode = cfg.mode;
              if (this._xformMode == this._ENC_XFORM_MODE) {
                modeCreator = mode.createEncryptor;
              } else {
                modeCreator = mode.createDecryptor;
                this._minBufferSize = 1;
              }
              if (this._mode && this._mode.__creator == modeCreator) {
                this._mode.init(this, iv && iv.words);
              } else {
                this._mode = modeCreator.call(mode, this, iv && iv.words);
                this._mode.__creator = modeCreator;
              }
            },
            _doProcessBlock: function(words, offset) {
              this._mode.processBlock(words, offset);
            },
            _doFinalize: function() {
              var finalProcessedBlocks;
              var padding = this.cfg.padding;
              if (this._xformMode == this._ENC_XFORM_MODE) {
                padding.pad(this._data, this.blockSize);
                finalProcessedBlocks = this._process(true);
              } else {
                finalProcessedBlocks = this._process(true);
                padding.unpad(finalProcessedBlocks);
              }
              return finalProcessedBlocks;
            },
            blockSize: 128 / 32
          });
          var CipherParams = C_lib.CipherParams = Base.extend({
            /**
             * Initializes a newly created cipher params object.
             *
             * @param {Object} cipherParams An object with any of the possible cipher parameters.
             *
             * @example
             *
             *     var cipherParams = CryptoJS.lib.CipherParams.create({
             *         ciphertext: ciphertextWordArray,
             *         key: keyWordArray,
             *         iv: ivWordArray,
             *         salt: saltWordArray,
             *         algorithm: CryptoJS.algo.AES,
             *         mode: CryptoJS.mode.CBC,
             *         padding: CryptoJS.pad.PKCS7,
             *         blockSize: 4,
             *         formatter: CryptoJS.format.OpenSSL
             *     });
             */
            init: function(cipherParams) {
              this.mixIn(cipherParams);
            },
            /**
             * Converts this cipher params object to a string.
             *
             * @param {Format} formatter (Optional) The formatting strategy to use.
             *
             * @return {string} The stringified cipher params.
             *
             * @throws Error If neither the formatter nor the default formatter is set.
             *
             * @example
             *
             *     var string = cipherParams + '';
             *     var string = cipherParams.toString();
             *     var string = cipherParams.toString(CryptoJS.format.OpenSSL);
             */
            toString: function(formatter) {
              return (formatter || this.formatter).stringify(this);
            }
          });
          var C_format = C.format = {};
          var OpenSSLFormatter = C_format.OpenSSL = {
            /**
             * Converts a cipher params object to an OpenSSL-compatible string.
             *
             * @param {CipherParams} cipherParams The cipher params object.
             *
             * @return {string} The OpenSSL-compatible string.
             *
             * @static
             *
             * @example
             *
             *     var openSSLString = CryptoJS.format.OpenSSL.stringify(cipherParams);
             */
            stringify: function(cipherParams) {
              var wordArray;
              var ciphertext = cipherParams.ciphertext;
              var salt = cipherParams.salt;
              if (salt) {
                wordArray = WordArray.create([1398893684, 1701076831]).concat(salt).concat(ciphertext);
              } else {
                wordArray = ciphertext;
              }
              return wordArray.toString(Base64);
            },
            /**
             * Converts an OpenSSL-compatible string to a cipher params object.
             *
             * @param {string} openSSLStr The OpenSSL-compatible string.
             *
             * @return {CipherParams} The cipher params object.
             *
             * @static
             *
             * @example
             *
             *     var cipherParams = CryptoJS.format.OpenSSL.parse(openSSLString);
             */
            parse: function(openSSLStr) {
              var salt;
              var ciphertext = Base64.parse(openSSLStr);
              var ciphertextWords = ciphertext.words;
              if (ciphertextWords[0] == 1398893684 && ciphertextWords[1] == 1701076831) {
                salt = WordArray.create(ciphertextWords.slice(2, 4));
                ciphertextWords.splice(0, 4);
                ciphertext.sigBytes -= 16;
              }
              return CipherParams.create({ ciphertext, salt });
            }
          };
          var SerializableCipher = C_lib.SerializableCipher = Base.extend({
            /**
             * Configuration options.
             *
             * @property {Formatter} format The formatting strategy to convert cipher param objects to and from a string. Default: OpenSSL
             */
            cfg: Base.extend({
              format: OpenSSLFormatter
            }),
            /**
             * Encrypts a message.
             *
             * @param {Cipher} cipher The cipher algorithm to use.
             * @param {WordArray|string} message The message to encrypt.
             * @param {WordArray} key The key.
             * @param {Object} cfg (Optional) The configuration options to use for this operation.
             *
             * @return {CipherParams} A cipher params object.
             *
             * @static
             *
             * @example
             *
             *     var ciphertextParams = CryptoJS.lib.SerializableCipher.encrypt(CryptoJS.algo.AES, message, key);
             *     var ciphertextParams = CryptoJS.lib.SerializableCipher.encrypt(CryptoJS.algo.AES, message, key, { iv: iv });
             *     var ciphertextParams = CryptoJS.lib.SerializableCipher.encrypt(CryptoJS.algo.AES, message, key, { iv: iv, format: CryptoJS.format.OpenSSL });
             */
            encrypt: function(cipher, message, key, cfg) {
              cfg = this.cfg.extend(cfg);
              var encryptor = cipher.createEncryptor(key, cfg);
              var ciphertext = encryptor.finalize(message);
              var cipherCfg = encryptor.cfg;
              return CipherParams.create({
                ciphertext,
                key,
                iv: cipherCfg.iv,
                algorithm: cipher,
                mode: cipherCfg.mode,
                padding: cipherCfg.padding,
                blockSize: cipher.blockSize,
                formatter: cfg.format
              });
            },
            /**
             * Decrypts serialized ciphertext.
             *
             * @param {Cipher} cipher The cipher algorithm to use.
             * @param {CipherParams|string} ciphertext The ciphertext to decrypt.
             * @param {WordArray} key The key.
             * @param {Object} cfg (Optional) The configuration options to use for this operation.
             *
             * @return {WordArray} The plaintext.
             *
             * @static
             *
             * @example
             *
             *     var plaintext = CryptoJS.lib.SerializableCipher.decrypt(CryptoJS.algo.AES, formattedCiphertext, key, { iv: iv, format: CryptoJS.format.OpenSSL });
             *     var plaintext = CryptoJS.lib.SerializableCipher.decrypt(CryptoJS.algo.AES, ciphertextParams, key, { iv: iv, format: CryptoJS.format.OpenSSL });
             */
            decrypt: function(cipher, ciphertext, key, cfg) {
              cfg = this.cfg.extend(cfg);
              ciphertext = this._parse(ciphertext, cfg.format);
              var plaintext = cipher.createDecryptor(key, cfg).finalize(ciphertext.ciphertext);
              return plaintext;
            },
            /**
             * Converts serialized ciphertext to CipherParams,
             * else assumed CipherParams already and returns ciphertext unchanged.
             *
             * @param {CipherParams|string} ciphertext The ciphertext.
             * @param {Formatter} format The formatting strategy to use to parse serialized ciphertext.
             *
             * @return {CipherParams} The unserialized ciphertext.
             *
             * @static
             *
             * @example
             *
             *     var ciphertextParams = CryptoJS.lib.SerializableCipher._parse(ciphertextStringOrParams, format);
             */
            _parse: function(ciphertext, format) {
              if (typeof ciphertext == "string") {
                return format.parse(ciphertext, this);
              } else {
                return ciphertext;
              }
            }
          });
          var C_kdf = C.kdf = {};
          var OpenSSLKdf = C_kdf.OpenSSL = {
            /**
             * Derives a key and IV from a password.
             *
             * @param {string} password The password to derive from.
             * @param {number} keySize The size in words of the key to generate.
             * @param {number} ivSize The size in words of the IV to generate.
             * @param {WordArray|string} salt (Optional) A 64-bit salt to use. If omitted, a salt will be generated randomly.
             *
             * @return {CipherParams} A cipher params object with the key, IV, and salt.
             *
             * @static
             *
             * @example
             *
             *     var derivedParams = CryptoJS.kdf.OpenSSL.execute('Password', 256/32, 128/32);
             *     var derivedParams = CryptoJS.kdf.OpenSSL.execute('Password', 256/32, 128/32, 'saltsalt');
             */
            execute: function(password, keySize, ivSize, salt) {
              if (!salt) {
                salt = WordArray.random(64 / 8);
              }
              var key = EvpKDF.create({ keySize: keySize + ivSize }).compute(password, salt);
              var iv = WordArray.create(key.words.slice(keySize), ivSize * 4);
              key.sigBytes = keySize * 4;
              return CipherParams.create({ key, iv, salt });
            }
          };
          var PasswordBasedCipher = C_lib.PasswordBasedCipher = SerializableCipher.extend({
            /**
             * Configuration options.
             *
             * @property {KDF} kdf The key derivation function to use to generate a key and IV from a password. Default: OpenSSL
             */
            cfg: SerializableCipher.cfg.extend({
              kdf: OpenSSLKdf
            }),
            /**
             * Encrypts a message using a password.
             *
             * @param {Cipher} cipher The cipher algorithm to use.
             * @param {WordArray|string} message The message to encrypt.
             * @param {string} password The password.
             * @param {Object} cfg (Optional) The configuration options to use for this operation.
             *
             * @return {CipherParams} A cipher params object.
             *
             * @static
             *
             * @example
             *
             *     var ciphertextParams = CryptoJS.lib.PasswordBasedCipher.encrypt(CryptoJS.algo.AES, message, 'password');
             *     var ciphertextParams = CryptoJS.lib.PasswordBasedCipher.encrypt(CryptoJS.algo.AES, message, 'password', { format: CryptoJS.format.OpenSSL });
             */
            encrypt: function(cipher, message, password, cfg) {
              cfg = this.cfg.extend(cfg);
              var derivedParams = cfg.kdf.execute(password, cipher.keySize, cipher.ivSize);
              cfg.iv = derivedParams.iv;
              var ciphertext = SerializableCipher.encrypt.call(this, cipher, message, derivedParams.key, cfg);
              ciphertext.mixIn(derivedParams);
              return ciphertext;
            },
            /**
             * Decrypts serialized ciphertext using a password.
             *
             * @param {Cipher} cipher The cipher algorithm to use.
             * @param {CipherParams|string} ciphertext The ciphertext to decrypt.
             * @param {string} password The password.
             * @param {Object} cfg (Optional) The configuration options to use for this operation.
             *
             * @return {WordArray} The plaintext.
             *
             * @static
             *
             * @example
             *
             *     var plaintext = CryptoJS.lib.PasswordBasedCipher.decrypt(CryptoJS.algo.AES, formattedCiphertext, 'password', { format: CryptoJS.format.OpenSSL });
             *     var plaintext = CryptoJS.lib.PasswordBasedCipher.decrypt(CryptoJS.algo.AES, ciphertextParams, 'password', { format: CryptoJS.format.OpenSSL });
             */
            decrypt: function(cipher, ciphertext, password, cfg) {
              cfg = this.cfg.extend(cfg);
              ciphertext = this._parse(ciphertext, cfg.format);
              var derivedParams = cfg.kdf.execute(password, cipher.keySize, cipher.ivSize, ciphertext.salt);
              cfg.iv = derivedParams.iv;
              var plaintext = SerializableCipher.decrypt.call(this, cipher, ciphertext, derivedParams.key, cfg);
              return plaintext;
            }
          });
        }();
      });
    }
  });

  // node_modules/crypto-js/mode-cfb.js
  var require_mode_cfb = __commonJS({
    "node_modules/crypto-js/mode-cfb.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_cipher_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        CryptoJS.mode.CFB = function() {
          var CFB = CryptoJS.lib.BlockCipherMode.extend();
          CFB.Encryptor = CFB.extend({
            processBlock: function(words, offset) {
              var cipher = this._cipher;
              var blockSize = cipher.blockSize;
              generateKeystreamAndEncrypt.call(this, words, offset, blockSize, cipher);
              this._prevBlock = words.slice(offset, offset + blockSize);
            }
          });
          CFB.Decryptor = CFB.extend({
            processBlock: function(words, offset) {
              var cipher = this._cipher;
              var blockSize = cipher.blockSize;
              var thisBlock = words.slice(offset, offset + blockSize);
              generateKeystreamAndEncrypt.call(this, words, offset, blockSize, cipher);
              this._prevBlock = thisBlock;
            }
          });
          function generateKeystreamAndEncrypt(words, offset, blockSize, cipher) {
            var keystream;
            var iv = this._iv;
            if (iv) {
              keystream = iv.slice(0);
              this._iv = void 0;
            } else {
              keystream = this._prevBlock;
            }
            cipher.encryptBlock(keystream, 0);
            for (var i = 0; i < blockSize; i++) {
              words[offset + i] ^= keystream[i];
            }
          }
          return CFB;
        }();
        return CryptoJS.mode.CFB;
      });
    }
  });

  // node_modules/crypto-js/mode-ctr.js
  var require_mode_ctr = __commonJS({
    "node_modules/crypto-js/mode-ctr.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_cipher_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        CryptoJS.mode.CTR = function() {
          var CTR = CryptoJS.lib.BlockCipherMode.extend();
          var Encryptor = CTR.Encryptor = CTR.extend({
            processBlock: function(words, offset) {
              var cipher = this._cipher;
              var blockSize = cipher.blockSize;
              var iv = this._iv;
              var counter = this._counter;
              if (iv) {
                counter = this._counter = iv.slice(0);
                this._iv = void 0;
              }
              var keystream = counter.slice(0);
              cipher.encryptBlock(keystream, 0);
              counter[blockSize - 1] = counter[blockSize - 1] + 1 | 0;
              for (var i = 0; i < blockSize; i++) {
                words[offset + i] ^= keystream[i];
              }
            }
          });
          CTR.Decryptor = Encryptor;
          return CTR;
        }();
        return CryptoJS.mode.CTR;
      });
    }
  });

  // node_modules/crypto-js/mode-ctr-gladman.js
  var require_mode_ctr_gladman = __commonJS({
    "node_modules/crypto-js/mode-ctr-gladman.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_cipher_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        CryptoJS.mode.CTRGladman = function() {
          var CTRGladman = CryptoJS.lib.BlockCipherMode.extend();
          function incWord(word) {
            if ((word >> 24 & 255) === 255) {
              var b1 = word >> 16 & 255;
              var b2 = word >> 8 & 255;
              var b3 = word & 255;
              if (b1 === 255) {
                b1 = 0;
                if (b2 === 255) {
                  b2 = 0;
                  if (b3 === 255) {
                    b3 = 0;
                  } else {
                    ++b3;
                  }
                } else {
                  ++b2;
                }
              } else {
                ++b1;
              }
              word = 0;
              word += b1 << 16;
              word += b2 << 8;
              word += b3;
            } else {
              word += 1 << 24;
            }
            return word;
          }
          function incCounter(counter) {
            if ((counter[0] = incWord(counter[0])) === 0) {
              counter[1] = incWord(counter[1]);
            }
            return counter;
          }
          var Encryptor = CTRGladman.Encryptor = CTRGladman.extend({
            processBlock: function(words, offset) {
              var cipher = this._cipher;
              var blockSize = cipher.blockSize;
              var iv = this._iv;
              var counter = this._counter;
              if (iv) {
                counter = this._counter = iv.slice(0);
                this._iv = void 0;
              }
              incCounter(counter);
              var keystream = counter.slice(0);
              cipher.encryptBlock(keystream, 0);
              for (var i = 0; i < blockSize; i++) {
                words[offset + i] ^= keystream[i];
              }
            }
          });
          CTRGladman.Decryptor = Encryptor;
          return CTRGladman;
        }();
        return CryptoJS.mode.CTRGladman;
      });
    }
  });

  // node_modules/crypto-js/mode-ofb.js
  var require_mode_ofb = __commonJS({
    "node_modules/crypto-js/mode-ofb.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_cipher_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        CryptoJS.mode.OFB = function() {
          var OFB = CryptoJS.lib.BlockCipherMode.extend();
          var Encryptor = OFB.Encryptor = OFB.extend({
            processBlock: function(words, offset) {
              var cipher = this._cipher;
              var blockSize = cipher.blockSize;
              var iv = this._iv;
              var keystream = this._keystream;
              if (iv) {
                keystream = this._keystream = iv.slice(0);
                this._iv = void 0;
              }
              cipher.encryptBlock(keystream, 0);
              for (var i = 0; i < blockSize; i++) {
                words[offset + i] ^= keystream[i];
              }
            }
          });
          OFB.Decryptor = Encryptor;
          return OFB;
        }();
        return CryptoJS.mode.OFB;
      });
    }
  });

  // node_modules/crypto-js/mode-ecb.js
  var require_mode_ecb = __commonJS({
    "node_modules/crypto-js/mode-ecb.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_cipher_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        CryptoJS.mode.ECB = function() {
          var ECB = CryptoJS.lib.BlockCipherMode.extend();
          ECB.Encryptor = ECB.extend({
            processBlock: function(words, offset) {
              this._cipher.encryptBlock(words, offset);
            }
          });
          ECB.Decryptor = ECB.extend({
            processBlock: function(words, offset) {
              this._cipher.decryptBlock(words, offset);
            }
          });
          return ECB;
        }();
        return CryptoJS.mode.ECB;
      });
    }
  });

  // node_modules/crypto-js/pad-ansix923.js
  var require_pad_ansix923 = __commonJS({
    "node_modules/crypto-js/pad-ansix923.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_cipher_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        CryptoJS.pad.AnsiX923 = {
          pad: function(data, blockSize) {
            var dataSigBytes = data.sigBytes;
            var blockSizeBytes = blockSize * 4;
            var nPaddingBytes = blockSizeBytes - dataSigBytes % blockSizeBytes;
            var lastBytePos = dataSigBytes + nPaddingBytes - 1;
            data.clamp();
            data.words[lastBytePos >>> 2] |= nPaddingBytes << 24 - lastBytePos % 4 * 8;
            data.sigBytes += nPaddingBytes;
          },
          unpad: function(data) {
            var nPaddingBytes = data.words[data.sigBytes - 1 >>> 2] & 255;
            data.sigBytes -= nPaddingBytes;
          }
        };
        return CryptoJS.pad.Ansix923;
      });
    }
  });

  // node_modules/crypto-js/pad-iso10126.js
  var require_pad_iso10126 = __commonJS({
    "node_modules/crypto-js/pad-iso10126.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_cipher_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        CryptoJS.pad.Iso10126 = {
          pad: function(data, blockSize) {
            var blockSizeBytes = blockSize * 4;
            var nPaddingBytes = blockSizeBytes - data.sigBytes % blockSizeBytes;
            data.concat(CryptoJS.lib.WordArray.random(nPaddingBytes - 1)).concat(CryptoJS.lib.WordArray.create([nPaddingBytes << 24], 1));
          },
          unpad: function(data) {
            var nPaddingBytes = data.words[data.sigBytes - 1 >>> 2] & 255;
            data.sigBytes -= nPaddingBytes;
          }
        };
        return CryptoJS.pad.Iso10126;
      });
    }
  });

  // node_modules/crypto-js/pad-iso97971.js
  var require_pad_iso97971 = __commonJS({
    "node_modules/crypto-js/pad-iso97971.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_cipher_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        CryptoJS.pad.Iso97971 = {
          pad: function(data, blockSize) {
            data.concat(CryptoJS.lib.WordArray.create([2147483648], 1));
            CryptoJS.pad.ZeroPadding.pad(data, blockSize);
          },
          unpad: function(data) {
            CryptoJS.pad.ZeroPadding.unpad(data);
            data.sigBytes--;
          }
        };
        return CryptoJS.pad.Iso97971;
      });
    }
  });

  // node_modules/crypto-js/pad-zeropadding.js
  var require_pad_zeropadding = __commonJS({
    "node_modules/crypto-js/pad-zeropadding.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_cipher_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        CryptoJS.pad.ZeroPadding = {
          pad: function(data, blockSize) {
            var blockSizeBytes = blockSize * 4;
            data.clamp();
            data.sigBytes += blockSizeBytes - (data.sigBytes % blockSizeBytes || blockSizeBytes);
          },
          unpad: function(data) {
            var dataWords = data.words;
            var i = data.sigBytes - 1;
            for (var i = data.sigBytes - 1; i >= 0; i--) {
              if (dataWords[i >>> 2] >>> 24 - i % 4 * 8 & 255) {
                data.sigBytes = i + 1;
                break;
              }
            }
          }
        };
        return CryptoJS.pad.ZeroPadding;
      });
    }
  });

  // node_modules/crypto-js/pad-nopadding.js
  var require_pad_nopadding = __commonJS({
    "node_modules/crypto-js/pad-nopadding.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_cipher_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        CryptoJS.pad.NoPadding = {
          pad: function() {
          },
          unpad: function() {
          }
        };
        return CryptoJS.pad.NoPadding;
      });
    }
  });

  // node_modules/crypto-js/format-hex.js
  var require_format_hex = __commonJS({
    "node_modules/crypto-js/format-hex.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_cipher_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function(undefined2) {
          var C = CryptoJS;
          var C_lib = C.lib;
          var CipherParams = C_lib.CipherParams;
          var C_enc = C.enc;
          var Hex = C_enc.Hex;
          var C_format = C.format;
          var HexFormatter = C_format.Hex = {
            /**
             * Converts the ciphertext of a cipher params object to a hexadecimally encoded string.
             *
             * @param {CipherParams} cipherParams The cipher params object.
             *
             * @return {string} The hexadecimally encoded string.
             *
             * @static
             *
             * @example
             *
             *     var hexString = CryptoJS.format.Hex.stringify(cipherParams);
             */
            stringify: function(cipherParams) {
              return cipherParams.ciphertext.toString(Hex);
            },
            /**
             * Converts a hexadecimally encoded ciphertext string to a cipher params object.
             *
             * @param {string} input The hexadecimally encoded string.
             *
             * @return {CipherParams} The cipher params object.
             *
             * @static
             *
             * @example
             *
             *     var cipherParams = CryptoJS.format.Hex.parse(hexString);
             */
            parse: function(input) {
              var ciphertext = Hex.parse(input);
              return CipherParams.create({ ciphertext });
            }
          };
        })();
        return CryptoJS.format.Hex;
      });
    }
  });

  // node_modules/crypto-js/aes.js
  var require_aes = __commonJS({
    "node_modules/crypto-js/aes.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_enc_base64(), require_md5(), require_evpkdf(), require_cipher_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./enc-base64", "./md5", "./evpkdf", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var BlockCipher = C_lib.BlockCipher;
          var C_algo = C.algo;
          var SBOX = [];
          var INV_SBOX = [];
          var SUB_MIX_0 = [];
          var SUB_MIX_1 = [];
          var SUB_MIX_2 = [];
          var SUB_MIX_3 = [];
          var INV_SUB_MIX_0 = [];
          var INV_SUB_MIX_1 = [];
          var INV_SUB_MIX_2 = [];
          var INV_SUB_MIX_3 = [];
          (function() {
            var d = [];
            for (var i = 0; i < 256; i++) {
              if (i < 128) {
                d[i] = i << 1;
              } else {
                d[i] = i << 1 ^ 283;
              }
            }
            var x = 0;
            var xi = 0;
            for (var i = 0; i < 256; i++) {
              var sx = xi ^ xi << 1 ^ xi << 2 ^ xi << 3 ^ xi << 4;
              sx = sx >>> 8 ^ sx & 255 ^ 99;
              SBOX[x] = sx;
              INV_SBOX[sx] = x;
              var x2 = d[x];
              var x4 = d[x2];
              var x8 = d[x4];
              var t = d[sx] * 257 ^ sx * 16843008;
              SUB_MIX_0[x] = t << 24 | t >>> 8;
              SUB_MIX_1[x] = t << 16 | t >>> 16;
              SUB_MIX_2[x] = t << 8 | t >>> 24;
              SUB_MIX_3[x] = t;
              var t = x8 * 16843009 ^ x4 * 65537 ^ x2 * 257 ^ x * 16843008;
              INV_SUB_MIX_0[sx] = t << 24 | t >>> 8;
              INV_SUB_MIX_1[sx] = t << 16 | t >>> 16;
              INV_SUB_MIX_2[sx] = t << 8 | t >>> 24;
              INV_SUB_MIX_3[sx] = t;
              if (!x) {
                x = xi = 1;
              } else {
                x = x2 ^ d[d[d[x8 ^ x2]]];
                xi ^= d[d[xi]];
              }
            }
          })();
          var RCON = [0, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54];
          var AES = C_algo.AES = BlockCipher.extend({
            _doReset: function() {
              var t;
              if (this._nRounds && this._keyPriorReset === this._key) {
                return;
              }
              var key = this._keyPriorReset = this._key;
              var keyWords = key.words;
              var keySize = key.sigBytes / 4;
              var nRounds = this._nRounds = keySize + 6;
              var ksRows = (nRounds + 1) * 4;
              var keySchedule = this._keySchedule = [];
              for (var ksRow = 0; ksRow < ksRows; ksRow++) {
                if (ksRow < keySize) {
                  keySchedule[ksRow] = keyWords[ksRow];
                } else {
                  t = keySchedule[ksRow - 1];
                  if (!(ksRow % keySize)) {
                    t = t << 8 | t >>> 24;
                    t = SBOX[t >>> 24] << 24 | SBOX[t >>> 16 & 255] << 16 | SBOX[t >>> 8 & 255] << 8 | SBOX[t & 255];
                    t ^= RCON[ksRow / keySize | 0] << 24;
                  } else if (keySize > 6 && ksRow % keySize == 4) {
                    t = SBOX[t >>> 24] << 24 | SBOX[t >>> 16 & 255] << 16 | SBOX[t >>> 8 & 255] << 8 | SBOX[t & 255];
                  }
                  keySchedule[ksRow] = keySchedule[ksRow - keySize] ^ t;
                }
              }
              var invKeySchedule = this._invKeySchedule = [];
              for (var invKsRow = 0; invKsRow < ksRows; invKsRow++) {
                var ksRow = ksRows - invKsRow;
                if (invKsRow % 4) {
                  var t = keySchedule[ksRow];
                } else {
                  var t = keySchedule[ksRow - 4];
                }
                if (invKsRow < 4 || ksRow <= 4) {
                  invKeySchedule[invKsRow] = t;
                } else {
                  invKeySchedule[invKsRow] = INV_SUB_MIX_0[SBOX[t >>> 24]] ^ INV_SUB_MIX_1[SBOX[t >>> 16 & 255]] ^ INV_SUB_MIX_2[SBOX[t >>> 8 & 255]] ^ INV_SUB_MIX_3[SBOX[t & 255]];
                }
              }
            },
            encryptBlock: function(M, offset) {
              this._doCryptBlock(M, offset, this._keySchedule, SUB_MIX_0, SUB_MIX_1, SUB_MIX_2, SUB_MIX_3, SBOX);
            },
            decryptBlock: function(M, offset) {
              var t = M[offset + 1];
              M[offset + 1] = M[offset + 3];
              M[offset + 3] = t;
              this._doCryptBlock(M, offset, this._invKeySchedule, INV_SUB_MIX_0, INV_SUB_MIX_1, INV_SUB_MIX_2, INV_SUB_MIX_3, INV_SBOX);
              var t = M[offset + 1];
              M[offset + 1] = M[offset + 3];
              M[offset + 3] = t;
            },
            _doCryptBlock: function(M, offset, keySchedule, SUB_MIX_02, SUB_MIX_12, SUB_MIX_22, SUB_MIX_32, SBOX2) {
              var nRounds = this._nRounds;
              var s0 = M[offset] ^ keySchedule[0];
              var s1 = M[offset + 1] ^ keySchedule[1];
              var s2 = M[offset + 2] ^ keySchedule[2];
              var s3 = M[offset + 3] ^ keySchedule[3];
              var ksRow = 4;
              for (var round = 1; round < nRounds; round++) {
                var t0 = SUB_MIX_02[s0 >>> 24] ^ SUB_MIX_12[s1 >>> 16 & 255] ^ SUB_MIX_22[s2 >>> 8 & 255] ^ SUB_MIX_32[s3 & 255] ^ keySchedule[ksRow++];
                var t1 = SUB_MIX_02[s1 >>> 24] ^ SUB_MIX_12[s2 >>> 16 & 255] ^ SUB_MIX_22[s3 >>> 8 & 255] ^ SUB_MIX_32[s0 & 255] ^ keySchedule[ksRow++];
                var t2 = SUB_MIX_02[s2 >>> 24] ^ SUB_MIX_12[s3 >>> 16 & 255] ^ SUB_MIX_22[s0 >>> 8 & 255] ^ SUB_MIX_32[s1 & 255] ^ keySchedule[ksRow++];
                var t3 = SUB_MIX_02[s3 >>> 24] ^ SUB_MIX_12[s0 >>> 16 & 255] ^ SUB_MIX_22[s1 >>> 8 & 255] ^ SUB_MIX_32[s2 & 255] ^ keySchedule[ksRow++];
                s0 = t0;
                s1 = t1;
                s2 = t2;
                s3 = t3;
              }
              var t0 = (SBOX2[s0 >>> 24] << 24 | SBOX2[s1 >>> 16 & 255] << 16 | SBOX2[s2 >>> 8 & 255] << 8 | SBOX2[s3 & 255]) ^ keySchedule[ksRow++];
              var t1 = (SBOX2[s1 >>> 24] << 24 | SBOX2[s2 >>> 16 & 255] << 16 | SBOX2[s3 >>> 8 & 255] << 8 | SBOX2[s0 & 255]) ^ keySchedule[ksRow++];
              var t2 = (SBOX2[s2 >>> 24] << 24 | SBOX2[s3 >>> 16 & 255] << 16 | SBOX2[s0 >>> 8 & 255] << 8 | SBOX2[s1 & 255]) ^ keySchedule[ksRow++];
              var t3 = (SBOX2[s3 >>> 24] << 24 | SBOX2[s0 >>> 16 & 255] << 16 | SBOX2[s1 >>> 8 & 255] << 8 | SBOX2[s2 & 255]) ^ keySchedule[ksRow++];
              M[offset] = t0;
              M[offset + 1] = t1;
              M[offset + 2] = t2;
              M[offset + 3] = t3;
            },
            keySize: 256 / 32
          });
          C.AES = BlockCipher._createHelper(AES);
        })();
        return CryptoJS.AES;
      });
    }
  });

  // node_modules/crypto-js/tripledes.js
  var require_tripledes = __commonJS({
    "node_modules/crypto-js/tripledes.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_enc_base64(), require_md5(), require_evpkdf(), require_cipher_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./enc-base64", "./md5", "./evpkdf", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var WordArray = C_lib.WordArray;
          var BlockCipher = C_lib.BlockCipher;
          var C_algo = C.algo;
          var PC1 = [
            57,
            49,
            41,
            33,
            25,
            17,
            9,
            1,
            58,
            50,
            42,
            34,
            26,
            18,
            10,
            2,
            59,
            51,
            43,
            35,
            27,
            19,
            11,
            3,
            60,
            52,
            44,
            36,
            63,
            55,
            47,
            39,
            31,
            23,
            15,
            7,
            62,
            54,
            46,
            38,
            30,
            22,
            14,
            6,
            61,
            53,
            45,
            37,
            29,
            21,
            13,
            5,
            28,
            20,
            12,
            4
          ];
          var PC2 = [
            14,
            17,
            11,
            24,
            1,
            5,
            3,
            28,
            15,
            6,
            21,
            10,
            23,
            19,
            12,
            4,
            26,
            8,
            16,
            7,
            27,
            20,
            13,
            2,
            41,
            52,
            31,
            37,
            47,
            55,
            30,
            40,
            51,
            45,
            33,
            48,
            44,
            49,
            39,
            56,
            34,
            53,
            46,
            42,
            50,
            36,
            29,
            32
          ];
          var BIT_SHIFTS = [1, 2, 4, 6, 8, 10, 12, 14, 15, 17, 19, 21, 23, 25, 27, 28];
          var SBOX_P = [
            {
              0: 8421888,
              268435456: 32768,
              536870912: 8421378,
              805306368: 2,
              1073741824: 512,
              1342177280: 8421890,
              1610612736: 8389122,
              1879048192: 8388608,
              2147483648: 514,
              2415919104: 8389120,
              2684354560: 33280,
              2952790016: 8421376,
              3221225472: 32770,
              3489660928: 8388610,
              3758096384: 0,
              4026531840: 33282,
              134217728: 0,
              402653184: 8421890,
              671088640: 33282,
              939524096: 32768,
              1207959552: 8421888,
              1476395008: 512,
              1744830464: 8421378,
              2013265920: 2,
              2281701376: 8389120,
              2550136832: 33280,
              2818572288: 8421376,
              3087007744: 8389122,
              3355443200: 8388610,
              3623878656: 32770,
              3892314112: 514,
              4160749568: 8388608,
              1: 32768,
              268435457: 2,
              536870913: 8421888,
              805306369: 8388608,
              1073741825: 8421378,
              1342177281: 33280,
              1610612737: 512,
              1879048193: 8389122,
              2147483649: 8421890,
              2415919105: 8421376,
              2684354561: 8388610,
              2952790017: 33282,
              3221225473: 514,
              3489660929: 8389120,
              3758096385: 32770,
              4026531841: 0,
              134217729: 8421890,
              402653185: 8421376,
              671088641: 8388608,
              939524097: 512,
              1207959553: 32768,
              1476395009: 8388610,
              1744830465: 2,
              2013265921: 33282,
              2281701377: 32770,
              2550136833: 8389122,
              2818572289: 514,
              3087007745: 8421888,
              3355443201: 8389120,
              3623878657: 0,
              3892314113: 33280,
              4160749569: 8421378
            },
            {
              0: 1074282512,
              16777216: 16384,
              33554432: 524288,
              50331648: 1074266128,
              67108864: 1073741840,
              83886080: 1074282496,
              100663296: 1073758208,
              117440512: 16,
              134217728: 540672,
              150994944: 1073758224,
              167772160: 1073741824,
              184549376: 540688,
              201326592: 524304,
              218103808: 0,
              234881024: 16400,
              251658240: 1074266112,
              8388608: 1073758208,
              25165824: 540688,
              41943040: 16,
              58720256: 1073758224,
              75497472: 1074282512,
              92274688: 1073741824,
              109051904: 524288,
              125829120: 1074266128,
              142606336: 524304,
              159383552: 0,
              176160768: 16384,
              192937984: 1074266112,
              209715200: 1073741840,
              226492416: 540672,
              243269632: 1074282496,
              260046848: 16400,
              268435456: 0,
              285212672: 1074266128,
              301989888: 1073758224,
              318767104: 1074282496,
              335544320: 1074266112,
              352321536: 16,
              369098752: 540688,
              385875968: 16384,
              402653184: 16400,
              419430400: 524288,
              436207616: 524304,
              452984832: 1073741840,
              469762048: 540672,
              486539264: 1073758208,
              503316480: 1073741824,
              520093696: 1074282512,
              276824064: 540688,
              293601280: 524288,
              310378496: 1074266112,
              327155712: 16384,
              343932928: 1073758208,
              360710144: 1074282512,
              377487360: 16,
              394264576: 1073741824,
              411041792: 1074282496,
              427819008: 1073741840,
              444596224: 1073758224,
              461373440: 524304,
              478150656: 0,
              494927872: 16400,
              511705088: 1074266128,
              528482304: 540672
            },
            {
              0: 260,
              1048576: 0,
              2097152: 67109120,
              3145728: 65796,
              4194304: 65540,
              5242880: 67108868,
              6291456: 67174660,
              7340032: 67174400,
              8388608: 67108864,
              9437184: 67174656,
              10485760: 65792,
              11534336: 67174404,
              12582912: 67109124,
              13631488: 65536,
              14680064: 4,
              15728640: 256,
              524288: 67174656,
              1572864: 67174404,
              2621440: 0,
              3670016: 67109120,
              4718592: 67108868,
              5767168: 65536,
              6815744: 65540,
              7864320: 260,
              8912896: 4,
              9961472: 256,
              11010048: 67174400,
              12058624: 65796,
              13107200: 65792,
              14155776: 67109124,
              15204352: 67174660,
              16252928: 67108864,
              16777216: 67174656,
              17825792: 65540,
              18874368: 65536,
              19922944: 67109120,
              20971520: 256,
              22020096: 67174660,
              23068672: 67108868,
              24117248: 0,
              25165824: 67109124,
              26214400: 67108864,
              27262976: 4,
              28311552: 65792,
              29360128: 67174400,
              30408704: 260,
              31457280: 65796,
              32505856: 67174404,
              17301504: 67108864,
              18350080: 260,
              19398656: 67174656,
              20447232: 0,
              21495808: 65540,
              22544384: 67109120,
              23592960: 256,
              24641536: 67174404,
              25690112: 65536,
              26738688: 67174660,
              27787264: 65796,
              28835840: 67108868,
              29884416: 67109124,
              30932992: 67174400,
              31981568: 4,
              33030144: 65792
            },
            {
              0: 2151682048,
              65536: 2147487808,
              131072: 4198464,
              196608: 2151677952,
              262144: 0,
              327680: 4198400,
              393216: 2147483712,
              458752: 4194368,
              524288: 2147483648,
              589824: 4194304,
              655360: 64,
              720896: 2147487744,
              786432: 2151678016,
              851968: 4160,
              917504: 4096,
              983040: 2151682112,
              32768: 2147487808,
              98304: 64,
              163840: 2151678016,
              229376: 2147487744,
              294912: 4198400,
              360448: 2151682112,
              425984: 0,
              491520: 2151677952,
              557056: 4096,
              622592: 2151682048,
              688128: 4194304,
              753664: 4160,
              819200: 2147483648,
              884736: 4194368,
              950272: 4198464,
              1015808: 2147483712,
              1048576: 4194368,
              1114112: 4198400,
              1179648: 2147483712,
              1245184: 0,
              1310720: 4160,
              1376256: 2151678016,
              1441792: 2151682048,
              1507328: 2147487808,
              1572864: 2151682112,
              1638400: 2147483648,
              1703936: 2151677952,
              1769472: 4198464,
              1835008: 2147487744,
              1900544: 4194304,
              1966080: 64,
              2031616: 4096,
              1081344: 2151677952,
              1146880: 2151682112,
              1212416: 0,
              1277952: 4198400,
              1343488: 4194368,
              1409024: 2147483648,
              1474560: 2147487808,
              1540096: 64,
              1605632: 2147483712,
              1671168: 4096,
              1736704: 2147487744,
              1802240: 2151678016,
              1867776: 4160,
              1933312: 2151682048,
              1998848: 4194304,
              2064384: 4198464
            },
            {
              0: 128,
              4096: 17039360,
              8192: 262144,
              12288: 536870912,
              16384: 537133184,
              20480: 16777344,
              24576: 553648256,
              28672: 262272,
              32768: 16777216,
              36864: 537133056,
              40960: 536871040,
              45056: 553910400,
              49152: 553910272,
              53248: 0,
              57344: 17039488,
              61440: 553648128,
              2048: 17039488,
              6144: 553648256,
              10240: 128,
              14336: 17039360,
              18432: 262144,
              22528: 537133184,
              26624: 553910272,
              30720: 536870912,
              34816: 537133056,
              38912: 0,
              43008: 553910400,
              47104: 16777344,
              51200: 536871040,
              55296: 553648128,
              59392: 16777216,
              63488: 262272,
              65536: 262144,
              69632: 128,
              73728: 536870912,
              77824: 553648256,
              81920: 16777344,
              86016: 553910272,
              90112: 537133184,
              94208: 16777216,
              98304: 553910400,
              102400: 553648128,
              106496: 17039360,
              110592: 537133056,
              114688: 262272,
              118784: 536871040,
              122880: 0,
              126976: 17039488,
              67584: 553648256,
              71680: 16777216,
              75776: 17039360,
              79872: 537133184,
              83968: 536870912,
              88064: 17039488,
              92160: 128,
              96256: 553910272,
              100352: 262272,
              104448: 553910400,
              108544: 0,
              112640: 553648128,
              116736: 16777344,
              120832: 262144,
              124928: 537133056,
              129024: 536871040
            },
            {
              0: 268435464,
              256: 8192,
              512: 270532608,
              768: 270540808,
              1024: 268443648,
              1280: 2097152,
              1536: 2097160,
              1792: 268435456,
              2048: 0,
              2304: 268443656,
              2560: 2105344,
              2816: 8,
              3072: 270532616,
              3328: 2105352,
              3584: 8200,
              3840: 270540800,
              128: 270532608,
              384: 270540808,
              640: 8,
              896: 2097152,
              1152: 2105352,
              1408: 268435464,
              1664: 268443648,
              1920: 8200,
              2176: 2097160,
              2432: 8192,
              2688: 268443656,
              2944: 270532616,
              3200: 0,
              3456: 270540800,
              3712: 2105344,
              3968: 268435456,
              4096: 268443648,
              4352: 270532616,
              4608: 270540808,
              4864: 8200,
              5120: 2097152,
              5376: 268435456,
              5632: 268435464,
              5888: 2105344,
              6144: 2105352,
              6400: 0,
              6656: 8,
              6912: 270532608,
              7168: 8192,
              7424: 268443656,
              7680: 270540800,
              7936: 2097160,
              4224: 8,
              4480: 2105344,
              4736: 2097152,
              4992: 268435464,
              5248: 268443648,
              5504: 8200,
              5760: 270540808,
              6016: 270532608,
              6272: 270540800,
              6528: 270532616,
              6784: 8192,
              7040: 2105352,
              7296: 2097160,
              7552: 0,
              7808: 268435456,
              8064: 268443656
            },
            {
              0: 1048576,
              16: 33555457,
              32: 1024,
              48: 1049601,
              64: 34604033,
              80: 0,
              96: 1,
              112: 34603009,
              128: 33555456,
              144: 1048577,
              160: 33554433,
              176: 34604032,
              192: 34603008,
              208: 1025,
              224: 1049600,
              240: 33554432,
              8: 34603009,
              24: 0,
              40: 33555457,
              56: 34604032,
              72: 1048576,
              88: 33554433,
              104: 33554432,
              120: 1025,
              136: 1049601,
              152: 33555456,
              168: 34603008,
              184: 1048577,
              200: 1024,
              216: 34604033,
              232: 1,
              248: 1049600,
              256: 33554432,
              272: 1048576,
              288: 33555457,
              304: 34603009,
              320: 1048577,
              336: 33555456,
              352: 34604032,
              368: 1049601,
              384: 1025,
              400: 34604033,
              416: 1049600,
              432: 1,
              448: 0,
              464: 34603008,
              480: 33554433,
              496: 1024,
              264: 1049600,
              280: 33555457,
              296: 34603009,
              312: 1,
              328: 33554432,
              344: 1048576,
              360: 1025,
              376: 34604032,
              392: 33554433,
              408: 34603008,
              424: 0,
              440: 34604033,
              456: 1049601,
              472: 1024,
              488: 33555456,
              504: 1048577
            },
            {
              0: 134219808,
              1: 131072,
              2: 134217728,
              3: 32,
              4: 131104,
              5: 134350880,
              6: 134350848,
              7: 2048,
              8: 134348800,
              9: 134219776,
              10: 133120,
              11: 134348832,
              12: 2080,
              13: 0,
              14: 134217760,
              15: 133152,
              2147483648: 2048,
              2147483649: 134350880,
              2147483650: 134219808,
              2147483651: 134217728,
              2147483652: 134348800,
              2147483653: 133120,
              2147483654: 133152,
              2147483655: 32,
              2147483656: 134217760,
              2147483657: 2080,
              2147483658: 131104,
              2147483659: 134350848,
              2147483660: 0,
              2147483661: 134348832,
              2147483662: 134219776,
              2147483663: 131072,
              16: 133152,
              17: 134350848,
              18: 32,
              19: 2048,
              20: 134219776,
              21: 134217760,
              22: 134348832,
              23: 131072,
              24: 0,
              25: 131104,
              26: 134348800,
              27: 134219808,
              28: 134350880,
              29: 133120,
              30: 2080,
              31: 134217728,
              2147483664: 131072,
              2147483665: 2048,
              2147483666: 134348832,
              2147483667: 133152,
              2147483668: 32,
              2147483669: 134348800,
              2147483670: 134217728,
              2147483671: 134219808,
              2147483672: 134350880,
              2147483673: 134217760,
              2147483674: 134219776,
              2147483675: 0,
              2147483676: 133120,
              2147483677: 2080,
              2147483678: 131104,
              2147483679: 134350848
            }
          ];
          var SBOX_MASK = [
            4160749569,
            528482304,
            33030144,
            2064384,
            129024,
            8064,
            504,
            2147483679
          ];
          var DES = C_algo.DES = BlockCipher.extend({
            _doReset: function() {
              var key = this._key;
              var keyWords = key.words;
              var keyBits = [];
              for (var i = 0; i < 56; i++) {
                var keyBitPos = PC1[i] - 1;
                keyBits[i] = keyWords[keyBitPos >>> 5] >>> 31 - keyBitPos % 32 & 1;
              }
              var subKeys = this._subKeys = [];
              for (var nSubKey = 0; nSubKey < 16; nSubKey++) {
                var subKey = subKeys[nSubKey] = [];
                var bitShift = BIT_SHIFTS[nSubKey];
                for (var i = 0; i < 24; i++) {
                  subKey[i / 6 | 0] |= keyBits[(PC2[i] - 1 + bitShift) % 28] << 31 - i % 6;
                  subKey[4 + (i / 6 | 0)] |= keyBits[28 + (PC2[i + 24] - 1 + bitShift) % 28] << 31 - i % 6;
                }
                subKey[0] = subKey[0] << 1 | subKey[0] >>> 31;
                for (var i = 1; i < 7; i++) {
                  subKey[i] = subKey[i] >>> (i - 1) * 4 + 3;
                }
                subKey[7] = subKey[7] << 5 | subKey[7] >>> 27;
              }
              var invSubKeys = this._invSubKeys = [];
              for (var i = 0; i < 16; i++) {
                invSubKeys[i] = subKeys[15 - i];
              }
            },
            encryptBlock: function(M, offset) {
              this._doCryptBlock(M, offset, this._subKeys);
            },
            decryptBlock: function(M, offset) {
              this._doCryptBlock(M, offset, this._invSubKeys);
            },
            _doCryptBlock: function(M, offset, subKeys) {
              this._lBlock = M[offset];
              this._rBlock = M[offset + 1];
              exchangeLR.call(this, 4, 252645135);
              exchangeLR.call(this, 16, 65535);
              exchangeRL.call(this, 2, 858993459);
              exchangeRL.call(this, 8, 16711935);
              exchangeLR.call(this, 1, 1431655765);
              for (var round = 0; round < 16; round++) {
                var subKey = subKeys[round];
                var lBlock = this._lBlock;
                var rBlock = this._rBlock;
                var f = 0;
                for (var i = 0; i < 8; i++) {
                  f |= SBOX_P[i][((rBlock ^ subKey[i]) & SBOX_MASK[i]) >>> 0];
                }
                this._lBlock = rBlock;
                this._rBlock = lBlock ^ f;
              }
              var t = this._lBlock;
              this._lBlock = this._rBlock;
              this._rBlock = t;
              exchangeLR.call(this, 1, 1431655765);
              exchangeRL.call(this, 8, 16711935);
              exchangeRL.call(this, 2, 858993459);
              exchangeLR.call(this, 16, 65535);
              exchangeLR.call(this, 4, 252645135);
              M[offset] = this._lBlock;
              M[offset + 1] = this._rBlock;
            },
            keySize: 64 / 32,
            ivSize: 64 / 32,
            blockSize: 64 / 32
          });
          function exchangeLR(offset, mask) {
            var t = (this._lBlock >>> offset ^ this._rBlock) & mask;
            this._rBlock ^= t;
            this._lBlock ^= t << offset;
          }
          function exchangeRL(offset, mask) {
            var t = (this._rBlock >>> offset ^ this._lBlock) & mask;
            this._lBlock ^= t;
            this._rBlock ^= t << offset;
          }
          C.DES = BlockCipher._createHelper(DES);
          var TripleDES = C_algo.TripleDES = BlockCipher.extend({
            _doReset: function() {
              var key = this._key;
              var keyWords = key.words;
              if (keyWords.length !== 2 && keyWords.length !== 4 && keyWords.length < 6) {
                throw new Error("Invalid key length - 3DES requires the key length to be 64, 128, 192 or >192.");
              }
              var key1 = keyWords.slice(0, 2);
              var key2 = keyWords.length < 4 ? keyWords.slice(0, 2) : keyWords.slice(2, 4);
              var key3 = keyWords.length < 6 ? keyWords.slice(0, 2) : keyWords.slice(4, 6);
              this._des1 = DES.createEncryptor(WordArray.create(key1));
              this._des2 = DES.createEncryptor(WordArray.create(key2));
              this._des3 = DES.createEncryptor(WordArray.create(key3));
            },
            encryptBlock: function(M, offset) {
              this._des1.encryptBlock(M, offset);
              this._des2.decryptBlock(M, offset);
              this._des3.encryptBlock(M, offset);
            },
            decryptBlock: function(M, offset) {
              this._des3.decryptBlock(M, offset);
              this._des2.encryptBlock(M, offset);
              this._des1.decryptBlock(M, offset);
            },
            keySize: 192 / 32,
            ivSize: 64 / 32,
            blockSize: 64 / 32
          });
          C.TripleDES = BlockCipher._createHelper(TripleDES);
        })();
        return CryptoJS.TripleDES;
      });
    }
  });

  // node_modules/crypto-js/rc4.js
  var require_rc4 = __commonJS({
    "node_modules/crypto-js/rc4.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_enc_base64(), require_md5(), require_evpkdf(), require_cipher_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./enc-base64", "./md5", "./evpkdf", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var StreamCipher = C_lib.StreamCipher;
          var C_algo = C.algo;
          var RC4 = C_algo.RC4 = StreamCipher.extend({
            _doReset: function() {
              var key = this._key;
              var keyWords = key.words;
              var keySigBytes = key.sigBytes;
              var S = this._S = [];
              for (var i = 0; i < 256; i++) {
                S[i] = i;
              }
              for (var i = 0, j = 0; i < 256; i++) {
                var keyByteIndex = i % keySigBytes;
                var keyByte = keyWords[keyByteIndex >>> 2] >>> 24 - keyByteIndex % 4 * 8 & 255;
                j = (j + S[i] + keyByte) % 256;
                var t = S[i];
                S[i] = S[j];
                S[j] = t;
              }
              this._i = this._j = 0;
            },
            _doProcessBlock: function(M, offset) {
              M[offset] ^= generateKeystreamWord.call(this);
            },
            keySize: 256 / 32,
            ivSize: 0
          });
          function generateKeystreamWord() {
            var S = this._S;
            var i = this._i;
            var j = this._j;
            var keystreamWord = 0;
            for (var n = 0; n < 4; n++) {
              i = (i + 1) % 256;
              j = (j + S[i]) % 256;
              var t = S[i];
              S[i] = S[j];
              S[j] = t;
              keystreamWord |= S[(S[i] + S[j]) % 256] << 24 - n * 8;
            }
            this._i = i;
            this._j = j;
            return keystreamWord;
          }
          C.RC4 = StreamCipher._createHelper(RC4);
          var RC4Drop = C_algo.RC4Drop = RC4.extend({
            /**
             * Configuration options.
             *
             * @property {number} drop The number of keystream words to drop. Default 192
             */
            cfg: RC4.cfg.extend({
              drop: 192
            }),
            _doReset: function() {
              RC4._doReset.call(this);
              for (var i = this.cfg.drop; i > 0; i--) {
                generateKeystreamWord.call(this);
              }
            }
          });
          C.RC4Drop = StreamCipher._createHelper(RC4Drop);
        })();
        return CryptoJS.RC4;
      });
    }
  });

  // node_modules/crypto-js/rabbit.js
  var require_rabbit = __commonJS({
    "node_modules/crypto-js/rabbit.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_enc_base64(), require_md5(), require_evpkdf(), require_cipher_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./enc-base64", "./md5", "./evpkdf", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var StreamCipher = C_lib.StreamCipher;
          var C_algo = C.algo;
          var S = [];
          var C_ = [];
          var G = [];
          var Rabbit = C_algo.Rabbit = StreamCipher.extend({
            _doReset: function() {
              var K = this._key.words;
              var iv = this.cfg.iv;
              for (var i = 0; i < 4; i++) {
                K[i] = (K[i] << 8 | K[i] >>> 24) & 16711935 | (K[i] << 24 | K[i] >>> 8) & 4278255360;
              }
              var X = this._X = [
                K[0],
                K[3] << 16 | K[2] >>> 16,
                K[1],
                K[0] << 16 | K[3] >>> 16,
                K[2],
                K[1] << 16 | K[0] >>> 16,
                K[3],
                K[2] << 16 | K[1] >>> 16
              ];
              var C2 = this._C = [
                K[2] << 16 | K[2] >>> 16,
                K[0] & 4294901760 | K[1] & 65535,
                K[3] << 16 | K[3] >>> 16,
                K[1] & 4294901760 | K[2] & 65535,
                K[0] << 16 | K[0] >>> 16,
                K[2] & 4294901760 | K[3] & 65535,
                K[1] << 16 | K[1] >>> 16,
                K[3] & 4294901760 | K[0] & 65535
              ];
              this._b = 0;
              for (var i = 0; i < 4; i++) {
                nextState.call(this);
              }
              for (var i = 0; i < 8; i++) {
                C2[i] ^= X[i + 4 & 7];
              }
              if (iv) {
                var IV = iv.words;
                var IV_0 = IV[0];
                var IV_1 = IV[1];
                var i0 = (IV_0 << 8 | IV_0 >>> 24) & 16711935 | (IV_0 << 24 | IV_0 >>> 8) & 4278255360;
                var i2 = (IV_1 << 8 | IV_1 >>> 24) & 16711935 | (IV_1 << 24 | IV_1 >>> 8) & 4278255360;
                var i1 = i0 >>> 16 | i2 & 4294901760;
                var i3 = i2 << 16 | i0 & 65535;
                C2[0] ^= i0;
                C2[1] ^= i1;
                C2[2] ^= i2;
                C2[3] ^= i3;
                C2[4] ^= i0;
                C2[5] ^= i1;
                C2[6] ^= i2;
                C2[7] ^= i3;
                for (var i = 0; i < 4; i++) {
                  nextState.call(this);
                }
              }
            },
            _doProcessBlock: function(M, offset) {
              var X = this._X;
              nextState.call(this);
              S[0] = X[0] ^ X[5] >>> 16 ^ X[3] << 16;
              S[1] = X[2] ^ X[7] >>> 16 ^ X[5] << 16;
              S[2] = X[4] ^ X[1] >>> 16 ^ X[7] << 16;
              S[3] = X[6] ^ X[3] >>> 16 ^ X[1] << 16;
              for (var i = 0; i < 4; i++) {
                S[i] = (S[i] << 8 | S[i] >>> 24) & 16711935 | (S[i] << 24 | S[i] >>> 8) & 4278255360;
                M[offset + i] ^= S[i];
              }
            },
            blockSize: 128 / 32,
            ivSize: 64 / 32
          });
          function nextState() {
            var X = this._X;
            var C2 = this._C;
            for (var i = 0; i < 8; i++) {
              C_[i] = C2[i];
            }
            C2[0] = C2[0] + 1295307597 + this._b | 0;
            C2[1] = C2[1] + 3545052371 + (C2[0] >>> 0 < C_[0] >>> 0 ? 1 : 0) | 0;
            C2[2] = C2[2] + 886263092 + (C2[1] >>> 0 < C_[1] >>> 0 ? 1 : 0) | 0;
            C2[3] = C2[3] + 1295307597 + (C2[2] >>> 0 < C_[2] >>> 0 ? 1 : 0) | 0;
            C2[4] = C2[4] + 3545052371 + (C2[3] >>> 0 < C_[3] >>> 0 ? 1 : 0) | 0;
            C2[5] = C2[5] + 886263092 + (C2[4] >>> 0 < C_[4] >>> 0 ? 1 : 0) | 0;
            C2[6] = C2[6] + 1295307597 + (C2[5] >>> 0 < C_[5] >>> 0 ? 1 : 0) | 0;
            C2[7] = C2[7] + 3545052371 + (C2[6] >>> 0 < C_[6] >>> 0 ? 1 : 0) | 0;
            this._b = C2[7] >>> 0 < C_[7] >>> 0 ? 1 : 0;
            for (var i = 0; i < 8; i++) {
              var gx = X[i] + C2[i];
              var ga = gx & 65535;
              var gb = gx >>> 16;
              var gh = ((ga * ga >>> 17) + ga * gb >>> 15) + gb * gb;
              var gl = ((gx & 4294901760) * gx | 0) + ((gx & 65535) * gx | 0);
              G[i] = gh ^ gl;
            }
            X[0] = G[0] + (G[7] << 16 | G[7] >>> 16) + (G[6] << 16 | G[6] >>> 16) | 0;
            X[1] = G[1] + (G[0] << 8 | G[0] >>> 24) + G[7] | 0;
            X[2] = G[2] + (G[1] << 16 | G[1] >>> 16) + (G[0] << 16 | G[0] >>> 16) | 0;
            X[3] = G[3] + (G[2] << 8 | G[2] >>> 24) + G[1] | 0;
            X[4] = G[4] + (G[3] << 16 | G[3] >>> 16) + (G[2] << 16 | G[2] >>> 16) | 0;
            X[5] = G[5] + (G[4] << 8 | G[4] >>> 24) + G[3] | 0;
            X[6] = G[6] + (G[5] << 16 | G[5] >>> 16) + (G[4] << 16 | G[4] >>> 16) | 0;
            X[7] = G[7] + (G[6] << 8 | G[6] >>> 24) + G[5] | 0;
          }
          C.Rabbit = StreamCipher._createHelper(Rabbit);
        })();
        return CryptoJS.Rabbit;
      });
    }
  });

  // node_modules/crypto-js/rabbit-legacy.js
  var require_rabbit_legacy = __commonJS({
    "node_modules/crypto-js/rabbit-legacy.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_enc_base64(), require_md5(), require_evpkdf(), require_cipher_core());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./enc-base64", "./md5", "./evpkdf", "./cipher-core"], factory);
        } else {
          factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        (function() {
          var C = CryptoJS;
          var C_lib = C.lib;
          var StreamCipher = C_lib.StreamCipher;
          var C_algo = C.algo;
          var S = [];
          var C_ = [];
          var G = [];
          var RabbitLegacy = C_algo.RabbitLegacy = StreamCipher.extend({
            _doReset: function() {
              var K = this._key.words;
              var iv = this.cfg.iv;
              var X = this._X = [
                K[0],
                K[3] << 16 | K[2] >>> 16,
                K[1],
                K[0] << 16 | K[3] >>> 16,
                K[2],
                K[1] << 16 | K[0] >>> 16,
                K[3],
                K[2] << 16 | K[1] >>> 16
              ];
              var C2 = this._C = [
                K[2] << 16 | K[2] >>> 16,
                K[0] & 4294901760 | K[1] & 65535,
                K[3] << 16 | K[3] >>> 16,
                K[1] & 4294901760 | K[2] & 65535,
                K[0] << 16 | K[0] >>> 16,
                K[2] & 4294901760 | K[3] & 65535,
                K[1] << 16 | K[1] >>> 16,
                K[3] & 4294901760 | K[0] & 65535
              ];
              this._b = 0;
              for (var i = 0; i < 4; i++) {
                nextState.call(this);
              }
              for (var i = 0; i < 8; i++) {
                C2[i] ^= X[i + 4 & 7];
              }
              if (iv) {
                var IV = iv.words;
                var IV_0 = IV[0];
                var IV_1 = IV[1];
                var i0 = (IV_0 << 8 | IV_0 >>> 24) & 16711935 | (IV_0 << 24 | IV_0 >>> 8) & 4278255360;
                var i2 = (IV_1 << 8 | IV_1 >>> 24) & 16711935 | (IV_1 << 24 | IV_1 >>> 8) & 4278255360;
                var i1 = i0 >>> 16 | i2 & 4294901760;
                var i3 = i2 << 16 | i0 & 65535;
                C2[0] ^= i0;
                C2[1] ^= i1;
                C2[2] ^= i2;
                C2[3] ^= i3;
                C2[4] ^= i0;
                C2[5] ^= i1;
                C2[6] ^= i2;
                C2[7] ^= i3;
                for (var i = 0; i < 4; i++) {
                  nextState.call(this);
                }
              }
            },
            _doProcessBlock: function(M, offset) {
              var X = this._X;
              nextState.call(this);
              S[0] = X[0] ^ X[5] >>> 16 ^ X[3] << 16;
              S[1] = X[2] ^ X[7] >>> 16 ^ X[5] << 16;
              S[2] = X[4] ^ X[1] >>> 16 ^ X[7] << 16;
              S[3] = X[6] ^ X[3] >>> 16 ^ X[1] << 16;
              for (var i = 0; i < 4; i++) {
                S[i] = (S[i] << 8 | S[i] >>> 24) & 16711935 | (S[i] << 24 | S[i] >>> 8) & 4278255360;
                M[offset + i] ^= S[i];
              }
            },
            blockSize: 128 / 32,
            ivSize: 64 / 32
          });
          function nextState() {
            var X = this._X;
            var C2 = this._C;
            for (var i = 0; i < 8; i++) {
              C_[i] = C2[i];
            }
            C2[0] = C2[0] + 1295307597 + this._b | 0;
            C2[1] = C2[1] + 3545052371 + (C2[0] >>> 0 < C_[0] >>> 0 ? 1 : 0) | 0;
            C2[2] = C2[2] + 886263092 + (C2[1] >>> 0 < C_[1] >>> 0 ? 1 : 0) | 0;
            C2[3] = C2[3] + 1295307597 + (C2[2] >>> 0 < C_[2] >>> 0 ? 1 : 0) | 0;
            C2[4] = C2[4] + 3545052371 + (C2[3] >>> 0 < C_[3] >>> 0 ? 1 : 0) | 0;
            C2[5] = C2[5] + 886263092 + (C2[4] >>> 0 < C_[4] >>> 0 ? 1 : 0) | 0;
            C2[6] = C2[6] + 1295307597 + (C2[5] >>> 0 < C_[5] >>> 0 ? 1 : 0) | 0;
            C2[7] = C2[7] + 3545052371 + (C2[6] >>> 0 < C_[6] >>> 0 ? 1 : 0) | 0;
            this._b = C2[7] >>> 0 < C_[7] >>> 0 ? 1 : 0;
            for (var i = 0; i < 8; i++) {
              var gx = X[i] + C2[i];
              var ga = gx & 65535;
              var gb = gx >>> 16;
              var gh = ((ga * ga >>> 17) + ga * gb >>> 15) + gb * gb;
              var gl = ((gx & 4294901760) * gx | 0) + ((gx & 65535) * gx | 0);
              G[i] = gh ^ gl;
            }
            X[0] = G[0] + (G[7] << 16 | G[7] >>> 16) + (G[6] << 16 | G[6] >>> 16) | 0;
            X[1] = G[1] + (G[0] << 8 | G[0] >>> 24) + G[7] | 0;
            X[2] = G[2] + (G[1] << 16 | G[1] >>> 16) + (G[0] << 16 | G[0] >>> 16) | 0;
            X[3] = G[3] + (G[2] << 8 | G[2] >>> 24) + G[1] | 0;
            X[4] = G[4] + (G[3] << 16 | G[3] >>> 16) + (G[2] << 16 | G[2] >>> 16) | 0;
            X[5] = G[5] + (G[4] << 8 | G[4] >>> 24) + G[3] | 0;
            X[6] = G[6] + (G[5] << 16 | G[5] >>> 16) + (G[4] << 16 | G[4] >>> 16) | 0;
            X[7] = G[7] + (G[6] << 8 | G[6] >>> 24) + G[5] | 0;
          }
          C.RabbitLegacy = StreamCipher._createHelper(RabbitLegacy);
        })();
        return CryptoJS.RabbitLegacy;
      });
    }
  });

  // node_modules/crypto-js/index.js
  var require_crypto_js = __commonJS({
    "node_modules/crypto-js/index.js"(exports, module) {
      (function(root, factory, undef) {
        if (typeof exports === "object") {
          module.exports = exports = factory(require_core(), require_x64_core(), require_lib_typedarrays(), require_enc_utf16(), require_enc_base64(), require_enc_base64url(), require_md5(), require_sha1(), require_sha256(), require_sha224(), require_sha512(), require_sha384(), require_sha3(), require_ripemd160(), require_hmac(), require_pbkdf2(), require_evpkdf(), require_cipher_core(), require_mode_cfb(), require_mode_ctr(), require_mode_ctr_gladman(), require_mode_ofb(), require_mode_ecb(), require_pad_ansix923(), require_pad_iso10126(), require_pad_iso97971(), require_pad_zeropadding(), require_pad_nopadding(), require_format_hex(), require_aes(), require_tripledes(), require_rc4(), require_rabbit(), require_rabbit_legacy());
        } else if (typeof define === "function" && define.amd) {
          define(["./core", "./x64-core", "./lib-typedarrays", "./enc-utf16", "./enc-base64", "./enc-base64url", "./md5", "./sha1", "./sha256", "./sha224", "./sha512", "./sha384", "./sha3", "./ripemd160", "./hmac", "./pbkdf2", "./evpkdf", "./cipher-core", "./mode-cfb", "./mode-ctr", "./mode-ctr-gladman", "./mode-ofb", "./mode-ecb", "./pad-ansix923", "./pad-iso10126", "./pad-iso97971", "./pad-zeropadding", "./pad-nopadding", "./format-hex", "./aes", "./tripledes", "./rc4", "./rabbit", "./rabbit-legacy"], factory);
        } else {
          root.CryptoJS = factory(root.CryptoJS);
        }
      })(exports, function(CryptoJS) {
        return CryptoJS;
      });
    }
  });

  // node_modules/validate.io-array/lib/index.js
  var require_lib = __commonJS({
    "node_modules/validate.io-array/lib/index.js"(exports, module) {
      "use strict";
      function isArray(value) {
        return Object.prototype.toString.call(value) === "[object Array]";
      }
      module.exports = Array.isArray || isArray;
    }
  });

  // node_modules/validate.io-function/lib/index.js
  var require_lib2 = __commonJS({
    "node_modules/validate.io-function/lib/index.js"(exports, module) {
      "use strict";
      function isFunction(value) {
        return typeof value === "function";
      }
      module.exports = isFunction;
    }
  });

  // node_modules/compute-dot/lib/index.js
  var require_lib3 = __commonJS({
    "node_modules/compute-dot/lib/index.js"(exports, module) {
      "use strict";
      var isArray = require_lib();
      var isFunction = require_lib2();
      function dot(x, y, clbk) {
        if (!isArray(x)) {
          throw new TypeError("dot()::invalid input argument. First argument must be an array. Value: `" + x + "`.");
        }
        if (!isArray(y)) {
          throw new TypeError("dot()::invalid input argument. Second argument must be an array. Value: `" + y + "`.");
        }
        if (arguments.length > 2) {
          if (!isFunction(clbk)) {
            throw new TypeError("dot()::invalid input argument. Accessor must be a function. Value: `" + clbk + "`.");
          }
        }
        var len = x.length, sum = 0, i;
        if (len !== y.length) {
          throw new Error("dot()::invalid input argument. Arrays must be of equal length.");
        }
        if (!len) {
          return null;
        }
        if (clbk) {
          for (i = 0; i < len; i++) {
            sum += clbk(x[i], i, 0) * clbk(y[i], i, 1);
          }
        } else {
          for (i = 0; i < len; i++) {
            sum += x[i] * y[i];
          }
        }
        return sum;
      }
      module.exports = dot;
    }
  });

  // node_modules/compute-l2norm/lib/index.js
  var require_lib4 = __commonJS({
    "node_modules/compute-l2norm/lib/index.js"(exports, module) {
      "use strict";
      var isArray = require_lib();
      var isFunction = require_lib2();
      function l2norm(arr, clbk) {
        if (!isArray(arr)) {
          throw new TypeError("l2norm()::invalid input argument. Must provide an array.  Value: `" + arr + "`.");
        }
        if (arguments.length > 1) {
          if (!isFunction(clbk)) {
            throw new TypeError("l2norm()::invalid input argument. Accessor must be a function. Value: `" + clbk + "`.");
          }
        }
        var len = arr.length, t = 0, s = 1, r, val, abs, i;
        if (!len) {
          return null;
        }
        if (clbk) {
          for (i = 0; i < len; i++) {
            val = clbk(arr[i], i);
            abs = val < 0 ? -val : val;
            if (abs > 0) {
              if (abs > t) {
                r = t / val;
                s = 1 + s * r * r;
                t = abs;
              } else {
                r = val / t;
                s = s + r * r;
              }
            }
          }
        } else {
          for (i = 0; i < len; i++) {
            val = arr[i];
            abs = val < 0 ? -val : val;
            if (abs > 0) {
              if (abs > t) {
                r = t / val;
                s = 1 + s * r * r;
                t = abs;
              } else {
                r = val / t;
                s = s + r * r;
              }
            }
          }
        }
        return t * Math.sqrt(s);
      }
      module.exports = l2norm;
    }
  });

  // node_modules/compute-cosine-similarity/lib/index.js
  var require_lib5 = __commonJS({
    "node_modules/compute-cosine-similarity/lib/index.js"(exports, module) {
      "use strict";
      var dot = require_lib3();
      var l2norm = require_lib4();
      var isArray = require_lib();
      var isFunction = require_lib2();
      function partial(fn, j) {
        return function accessor(d, i) {
          return fn(d, i, j);
        };
      }
      function similarity2(x, y, clbk) {
        var a, b, c;
        if (!isArray(x)) {
          throw new TypeError("cosine-similarity()::invalid input argument. First argument must be an array. Value: `" + x + "`.");
        }
        if (!isArray(y)) {
          throw new TypeError("cosine-similarity()::invalid input argument. Second argument must be an array. Value: `" + y + "`.");
        }
        if (arguments.length > 2) {
          if (!isFunction(clbk)) {
            throw new TypeError("cosine-similarity()::invalid input argument. Accessor must be a function. Value: `" + clbk + "`.");
          }
        }
        if (x.length !== y.length) {
          throw new Error("cosine-similarity()::invalid input argument. Input arrays must have the same length.");
        }
        if (!x.length) {
          return null;
        }
        if (clbk) {
          a = dot(x, y, clbk);
          b = l2norm(x, partial(clbk, 0));
          c = l2norm(y, partial(clbk, 1));
        } else {
          a = dot(x, y);
          b = l2norm(x);
          c = l2norm(y);
        }
        return a / (b * c);
      }
      module.exports = similarity2;
    }
  });

  // node_modules/entities/lib/maps/entities.json
  var require_entities = __commonJS({
    "node_modules/entities/lib/maps/entities.json"(exports, module) {
      module.exports = { Aacute: "\xC1", aacute: "\xE1", Abreve: "\u0102", abreve: "\u0103", ac: "\u223E", acd: "\u223F", acE: "\u223E\u0333", Acirc: "\xC2", acirc: "\xE2", acute: "\xB4", Acy: "\u0410", acy: "\u0430", AElig: "\xC6", aelig: "\xE6", af: "\u2061", Afr: "\u{1D504}", afr: "\u{1D51E}", Agrave: "\xC0", agrave: "\xE0", alefsym: "\u2135", aleph: "\u2135", Alpha: "\u0391", alpha: "\u03B1", Amacr: "\u0100", amacr: "\u0101", amalg: "\u2A3F", amp: "&", AMP: "&", andand: "\u2A55", And: "\u2A53", and: "\u2227", andd: "\u2A5C", andslope: "\u2A58", andv: "\u2A5A", ang: "\u2220", ange: "\u29A4", angle: "\u2220", angmsdaa: "\u29A8", angmsdab: "\u29A9", angmsdac: "\u29AA", angmsdad: "\u29AB", angmsdae: "\u29AC", angmsdaf: "\u29AD", angmsdag: "\u29AE", angmsdah: "\u29AF", angmsd: "\u2221", angrt: "\u221F", angrtvb: "\u22BE", angrtvbd: "\u299D", angsph: "\u2222", angst: "\xC5", angzarr: "\u237C", Aogon: "\u0104", aogon: "\u0105", Aopf: "\u{1D538}", aopf: "\u{1D552}", apacir: "\u2A6F", ap: "\u2248", apE: "\u2A70", ape: "\u224A", apid: "\u224B", apos: "'", ApplyFunction: "\u2061", approx: "\u2248", approxeq: "\u224A", Aring: "\xC5", aring: "\xE5", Ascr: "\u{1D49C}", ascr: "\u{1D4B6}", Assign: "\u2254", ast: "*", asymp: "\u2248", asympeq: "\u224D", Atilde: "\xC3", atilde: "\xE3", Auml: "\xC4", auml: "\xE4", awconint: "\u2233", awint: "\u2A11", backcong: "\u224C", backepsilon: "\u03F6", backprime: "\u2035", backsim: "\u223D", backsimeq: "\u22CD", Backslash: "\u2216", Barv: "\u2AE7", barvee: "\u22BD", barwed: "\u2305", Barwed: "\u2306", barwedge: "\u2305", bbrk: "\u23B5", bbrktbrk: "\u23B6", bcong: "\u224C", Bcy: "\u0411", bcy: "\u0431", bdquo: "\u201E", becaus: "\u2235", because: "\u2235", Because: "\u2235", bemptyv: "\u29B0", bepsi: "\u03F6", bernou: "\u212C", Bernoullis: "\u212C", Beta: "\u0392", beta: "\u03B2", beth: "\u2136", between: "\u226C", Bfr: "\u{1D505}", bfr: "\u{1D51F}", bigcap: "\u22C2", bigcirc: "\u25EF", bigcup: "\u22C3", bigodot: "\u2A00", bigoplus: "\u2A01", bigotimes: "\u2A02", bigsqcup: "\u2A06", bigstar: "\u2605", bigtriangledown: "\u25BD", bigtriangleup: "\u25B3", biguplus: "\u2A04", bigvee: "\u22C1", bigwedge: "\u22C0", bkarow: "\u290D", blacklozenge: "\u29EB", blacksquare: "\u25AA", blacktriangle: "\u25B4", blacktriangledown: "\u25BE", blacktriangleleft: "\u25C2", blacktriangleright: "\u25B8", blank: "\u2423", blk12: "\u2592", blk14: "\u2591", blk34: "\u2593", block: "\u2588", bne: "=\u20E5", bnequiv: "\u2261\u20E5", bNot: "\u2AED", bnot: "\u2310", Bopf: "\u{1D539}", bopf: "\u{1D553}", bot: "\u22A5", bottom: "\u22A5", bowtie: "\u22C8", boxbox: "\u29C9", boxdl: "\u2510", boxdL: "\u2555", boxDl: "\u2556", boxDL: "\u2557", boxdr: "\u250C", boxdR: "\u2552", boxDr: "\u2553", boxDR: "\u2554", boxh: "\u2500", boxH: "\u2550", boxhd: "\u252C", boxHd: "\u2564", boxhD: "\u2565", boxHD: "\u2566", boxhu: "\u2534", boxHu: "\u2567", boxhU: "\u2568", boxHU: "\u2569", boxminus: "\u229F", boxplus: "\u229E", boxtimes: "\u22A0", boxul: "\u2518", boxuL: "\u255B", boxUl: "\u255C", boxUL: "\u255D", boxur: "\u2514", boxuR: "\u2558", boxUr: "\u2559", boxUR: "\u255A", boxv: "\u2502", boxV: "\u2551", boxvh: "\u253C", boxvH: "\u256A", boxVh: "\u256B", boxVH: "\u256C", boxvl: "\u2524", boxvL: "\u2561", boxVl: "\u2562", boxVL: "\u2563", boxvr: "\u251C", boxvR: "\u255E", boxVr: "\u255F", boxVR: "\u2560", bprime: "\u2035", breve: "\u02D8", Breve: "\u02D8", brvbar: "\xA6", bscr: "\u{1D4B7}", Bscr: "\u212C", bsemi: "\u204F", bsim: "\u223D", bsime: "\u22CD", bsolb: "\u29C5", bsol: "\\", bsolhsub: "\u27C8", bull: "\u2022", bullet: "\u2022", bump: "\u224E", bumpE: "\u2AAE", bumpe: "\u224F", Bumpeq: "\u224E", bumpeq: "\u224F", Cacute: "\u0106", cacute: "\u0107", capand: "\u2A44", capbrcup: "\u2A49", capcap: "\u2A4B", cap: "\u2229", Cap: "\u22D2", capcup: "\u2A47", capdot: "\u2A40", CapitalDifferentialD: "\u2145", caps: "\u2229\uFE00", caret: "\u2041", caron: "\u02C7", Cayleys: "\u212D", ccaps: "\u2A4D", Ccaron: "\u010C", ccaron: "\u010D", Ccedil: "\xC7", ccedil: "\xE7", Ccirc: "\u0108", ccirc: "\u0109", Cconint: "\u2230", ccups: "\u2A4C", ccupssm: "\u2A50", Cdot: "\u010A", cdot: "\u010B", cedil: "\xB8", Cedilla: "\xB8", cemptyv: "\u29B2", cent: "\xA2", centerdot: "\xB7", CenterDot: "\xB7", cfr: "\u{1D520}", Cfr: "\u212D", CHcy: "\u0427", chcy: "\u0447", check: "\u2713", checkmark: "\u2713", Chi: "\u03A7", chi: "\u03C7", circ: "\u02C6", circeq: "\u2257", circlearrowleft: "\u21BA", circlearrowright: "\u21BB", circledast: "\u229B", circledcirc: "\u229A", circleddash: "\u229D", CircleDot: "\u2299", circledR: "\xAE", circledS: "\u24C8", CircleMinus: "\u2296", CirclePlus: "\u2295", CircleTimes: "\u2297", cir: "\u25CB", cirE: "\u29C3", cire: "\u2257", cirfnint: "\u2A10", cirmid: "\u2AEF", cirscir: "\u29C2", ClockwiseContourIntegral: "\u2232", CloseCurlyDoubleQuote: "\u201D", CloseCurlyQuote: "\u2019", clubs: "\u2663", clubsuit: "\u2663", colon: ":", Colon: "\u2237", Colone: "\u2A74", colone: "\u2254", coloneq: "\u2254", comma: ",", commat: "@", comp: "\u2201", compfn: "\u2218", complement: "\u2201", complexes: "\u2102", cong: "\u2245", congdot: "\u2A6D", Congruent: "\u2261", conint: "\u222E", Conint: "\u222F", ContourIntegral: "\u222E", copf: "\u{1D554}", Copf: "\u2102", coprod: "\u2210", Coproduct: "\u2210", copy: "\xA9", COPY: "\xA9", copysr: "\u2117", CounterClockwiseContourIntegral: "\u2233", crarr: "\u21B5", cross: "\u2717", Cross: "\u2A2F", Cscr: "\u{1D49E}", cscr: "\u{1D4B8}", csub: "\u2ACF", csube: "\u2AD1", csup: "\u2AD0", csupe: "\u2AD2", ctdot: "\u22EF", cudarrl: "\u2938", cudarrr: "\u2935", cuepr: "\u22DE", cuesc: "\u22DF", cularr: "\u21B6", cularrp: "\u293D", cupbrcap: "\u2A48", cupcap: "\u2A46", CupCap: "\u224D", cup: "\u222A", Cup: "\u22D3", cupcup: "\u2A4A", cupdot: "\u228D", cupor: "\u2A45", cups: "\u222A\uFE00", curarr: "\u21B7", curarrm: "\u293C", curlyeqprec: "\u22DE", curlyeqsucc: "\u22DF", curlyvee: "\u22CE", curlywedge: "\u22CF", curren: "\xA4", curvearrowleft: "\u21B6", curvearrowright: "\u21B7", cuvee: "\u22CE", cuwed: "\u22CF", cwconint: "\u2232", cwint: "\u2231", cylcty: "\u232D", dagger: "\u2020", Dagger: "\u2021", daleth: "\u2138", darr: "\u2193", Darr: "\u21A1", dArr: "\u21D3", dash: "\u2010", Dashv: "\u2AE4", dashv: "\u22A3", dbkarow: "\u290F", dblac: "\u02DD", Dcaron: "\u010E", dcaron: "\u010F", Dcy: "\u0414", dcy: "\u0434", ddagger: "\u2021", ddarr: "\u21CA", DD: "\u2145", dd: "\u2146", DDotrahd: "\u2911", ddotseq: "\u2A77", deg: "\xB0", Del: "\u2207", Delta: "\u0394", delta: "\u03B4", demptyv: "\u29B1", dfisht: "\u297F", Dfr: "\u{1D507}", dfr: "\u{1D521}", dHar: "\u2965", dharl: "\u21C3", dharr: "\u21C2", DiacriticalAcute: "\xB4", DiacriticalDot: "\u02D9", DiacriticalDoubleAcute: "\u02DD", DiacriticalGrave: "`", DiacriticalTilde: "\u02DC", diam: "\u22C4", diamond: "\u22C4", Diamond: "\u22C4", diamondsuit: "\u2666", diams: "\u2666", die: "\xA8", DifferentialD: "\u2146", digamma: "\u03DD", disin: "\u22F2", div: "\xF7", divide: "\xF7", divideontimes: "\u22C7", divonx: "\u22C7", DJcy: "\u0402", djcy: "\u0452", dlcorn: "\u231E", dlcrop: "\u230D", dollar: "$", Dopf: "\u{1D53B}", dopf: "\u{1D555}", Dot: "\xA8", dot: "\u02D9", DotDot: "\u20DC", doteq: "\u2250", doteqdot: "\u2251", DotEqual: "\u2250", dotminus: "\u2238", dotplus: "\u2214", dotsquare: "\u22A1", doublebarwedge: "\u2306", DoubleContourIntegral: "\u222F", DoubleDot: "\xA8", DoubleDownArrow: "\u21D3", DoubleLeftArrow: "\u21D0", DoubleLeftRightArrow: "\u21D4", DoubleLeftTee: "\u2AE4", DoubleLongLeftArrow: "\u27F8", DoubleLongLeftRightArrow: "\u27FA", DoubleLongRightArrow: "\u27F9", DoubleRightArrow: "\u21D2", DoubleRightTee: "\u22A8", DoubleUpArrow: "\u21D1", DoubleUpDownArrow: "\u21D5", DoubleVerticalBar: "\u2225", DownArrowBar: "\u2913", downarrow: "\u2193", DownArrow: "\u2193", Downarrow: "\u21D3", DownArrowUpArrow: "\u21F5", DownBreve: "\u0311", downdownarrows: "\u21CA", downharpoonleft: "\u21C3", downharpoonright: "\u21C2", DownLeftRightVector: "\u2950", DownLeftTeeVector: "\u295E", DownLeftVectorBar: "\u2956", DownLeftVector: "\u21BD", DownRightTeeVector: "\u295F", DownRightVectorBar: "\u2957", DownRightVector: "\u21C1", DownTeeArrow: "\u21A7", DownTee: "\u22A4", drbkarow: "\u2910", drcorn: "\u231F", drcrop: "\u230C", Dscr: "\u{1D49F}", dscr: "\u{1D4B9}", DScy: "\u0405", dscy: "\u0455", dsol: "\u29F6", Dstrok: "\u0110", dstrok: "\u0111", dtdot: "\u22F1", dtri: "\u25BF", dtrif: "\u25BE", duarr: "\u21F5", duhar: "\u296F", dwangle: "\u29A6", DZcy: "\u040F", dzcy: "\u045F", dzigrarr: "\u27FF", Eacute: "\xC9", eacute: "\xE9", easter: "\u2A6E", Ecaron: "\u011A", ecaron: "\u011B", Ecirc: "\xCA", ecirc: "\xEA", ecir: "\u2256", ecolon: "\u2255", Ecy: "\u042D", ecy: "\u044D", eDDot: "\u2A77", Edot: "\u0116", edot: "\u0117", eDot: "\u2251", ee: "\u2147", efDot: "\u2252", Efr: "\u{1D508}", efr: "\u{1D522}", eg: "\u2A9A", Egrave: "\xC8", egrave: "\xE8", egs: "\u2A96", egsdot: "\u2A98", el: "\u2A99", Element: "\u2208", elinters: "\u23E7", ell: "\u2113", els: "\u2A95", elsdot: "\u2A97", Emacr: "\u0112", emacr: "\u0113", empty: "\u2205", emptyset: "\u2205", EmptySmallSquare: "\u25FB", emptyv: "\u2205", EmptyVerySmallSquare: "\u25AB", emsp13: "\u2004", emsp14: "\u2005", emsp: "\u2003", ENG: "\u014A", eng: "\u014B", ensp: "\u2002", Eogon: "\u0118", eogon: "\u0119", Eopf: "\u{1D53C}", eopf: "\u{1D556}", epar: "\u22D5", eparsl: "\u29E3", eplus: "\u2A71", epsi: "\u03B5", Epsilon: "\u0395", epsilon: "\u03B5", epsiv: "\u03F5", eqcirc: "\u2256", eqcolon: "\u2255", eqsim: "\u2242", eqslantgtr: "\u2A96", eqslantless: "\u2A95", Equal: "\u2A75", equals: "=", EqualTilde: "\u2242", equest: "\u225F", Equilibrium: "\u21CC", equiv: "\u2261", equivDD: "\u2A78", eqvparsl: "\u29E5", erarr: "\u2971", erDot: "\u2253", escr: "\u212F", Escr: "\u2130", esdot: "\u2250", Esim: "\u2A73", esim: "\u2242", Eta: "\u0397", eta: "\u03B7", ETH: "\xD0", eth: "\xF0", Euml: "\xCB", euml: "\xEB", euro: "\u20AC", excl: "!", exist: "\u2203", Exists: "\u2203", expectation: "\u2130", exponentiale: "\u2147", ExponentialE: "\u2147", fallingdotseq: "\u2252", Fcy: "\u0424", fcy: "\u0444", female: "\u2640", ffilig: "\uFB03", fflig: "\uFB00", ffllig: "\uFB04", Ffr: "\u{1D509}", ffr: "\u{1D523}", filig: "\uFB01", FilledSmallSquare: "\u25FC", FilledVerySmallSquare: "\u25AA", fjlig: "fj", flat: "\u266D", fllig: "\uFB02", fltns: "\u25B1", fnof: "\u0192", Fopf: "\u{1D53D}", fopf: "\u{1D557}", forall: "\u2200", ForAll: "\u2200", fork: "\u22D4", forkv: "\u2AD9", Fouriertrf: "\u2131", fpartint: "\u2A0D", frac12: "\xBD", frac13: "\u2153", frac14: "\xBC", frac15: "\u2155", frac16: "\u2159", frac18: "\u215B", frac23: "\u2154", frac25: "\u2156", frac34: "\xBE", frac35: "\u2157", frac38: "\u215C", frac45: "\u2158", frac56: "\u215A", frac58: "\u215D", frac78: "\u215E", frasl: "\u2044", frown: "\u2322", fscr: "\u{1D4BB}", Fscr: "\u2131", gacute: "\u01F5", Gamma: "\u0393", gamma: "\u03B3", Gammad: "\u03DC", gammad: "\u03DD", gap: "\u2A86", Gbreve: "\u011E", gbreve: "\u011F", Gcedil: "\u0122", Gcirc: "\u011C", gcirc: "\u011D", Gcy: "\u0413", gcy: "\u0433", Gdot: "\u0120", gdot: "\u0121", ge: "\u2265", gE: "\u2267", gEl: "\u2A8C", gel: "\u22DB", geq: "\u2265", geqq: "\u2267", geqslant: "\u2A7E", gescc: "\u2AA9", ges: "\u2A7E", gesdot: "\u2A80", gesdoto: "\u2A82", gesdotol: "\u2A84", gesl: "\u22DB\uFE00", gesles: "\u2A94", Gfr: "\u{1D50A}", gfr: "\u{1D524}", gg: "\u226B", Gg: "\u22D9", ggg: "\u22D9", gimel: "\u2137", GJcy: "\u0403", gjcy: "\u0453", gla: "\u2AA5", gl: "\u2277", glE: "\u2A92", glj: "\u2AA4", gnap: "\u2A8A", gnapprox: "\u2A8A", gne: "\u2A88", gnE: "\u2269", gneq: "\u2A88", gneqq: "\u2269", gnsim: "\u22E7", Gopf: "\u{1D53E}", gopf: "\u{1D558}", grave: "`", GreaterEqual: "\u2265", GreaterEqualLess: "\u22DB", GreaterFullEqual: "\u2267", GreaterGreater: "\u2AA2", GreaterLess: "\u2277", GreaterSlantEqual: "\u2A7E", GreaterTilde: "\u2273", Gscr: "\u{1D4A2}", gscr: "\u210A", gsim: "\u2273", gsime: "\u2A8E", gsiml: "\u2A90", gtcc: "\u2AA7", gtcir: "\u2A7A", gt: ">", GT: ">", Gt: "\u226B", gtdot: "\u22D7", gtlPar: "\u2995", gtquest: "\u2A7C", gtrapprox: "\u2A86", gtrarr: "\u2978", gtrdot: "\u22D7", gtreqless: "\u22DB", gtreqqless: "\u2A8C", gtrless: "\u2277", gtrsim: "\u2273", gvertneqq: "\u2269\uFE00", gvnE: "\u2269\uFE00", Hacek: "\u02C7", hairsp: "\u200A", half: "\xBD", hamilt: "\u210B", HARDcy: "\u042A", hardcy: "\u044A", harrcir: "\u2948", harr: "\u2194", hArr: "\u21D4", harrw: "\u21AD", Hat: "^", hbar: "\u210F", Hcirc: "\u0124", hcirc: "\u0125", hearts: "\u2665", heartsuit: "\u2665", hellip: "\u2026", hercon: "\u22B9", hfr: "\u{1D525}", Hfr: "\u210C", HilbertSpace: "\u210B", hksearow: "\u2925", hkswarow: "\u2926", hoarr: "\u21FF", homtht: "\u223B", hookleftarrow: "\u21A9", hookrightarrow: "\u21AA", hopf: "\u{1D559}", Hopf: "\u210D", horbar: "\u2015", HorizontalLine: "\u2500", hscr: "\u{1D4BD}", Hscr: "\u210B", hslash: "\u210F", Hstrok: "\u0126", hstrok: "\u0127", HumpDownHump: "\u224E", HumpEqual: "\u224F", hybull: "\u2043", hyphen: "\u2010", Iacute: "\xCD", iacute: "\xED", ic: "\u2063", Icirc: "\xCE", icirc: "\xEE", Icy: "\u0418", icy: "\u0438", Idot: "\u0130", IEcy: "\u0415", iecy: "\u0435", iexcl: "\xA1", iff: "\u21D4", ifr: "\u{1D526}", Ifr: "\u2111", Igrave: "\xCC", igrave: "\xEC", ii: "\u2148", iiiint: "\u2A0C", iiint: "\u222D", iinfin: "\u29DC", iiota: "\u2129", IJlig: "\u0132", ijlig: "\u0133", Imacr: "\u012A", imacr: "\u012B", image: "\u2111", ImaginaryI: "\u2148", imagline: "\u2110", imagpart: "\u2111", imath: "\u0131", Im: "\u2111", imof: "\u22B7", imped: "\u01B5", Implies: "\u21D2", incare: "\u2105", in: "\u2208", infin: "\u221E", infintie: "\u29DD", inodot: "\u0131", intcal: "\u22BA", int: "\u222B", Int: "\u222C", integers: "\u2124", Integral: "\u222B", intercal: "\u22BA", Intersection: "\u22C2", intlarhk: "\u2A17", intprod: "\u2A3C", InvisibleComma: "\u2063", InvisibleTimes: "\u2062", IOcy: "\u0401", iocy: "\u0451", Iogon: "\u012E", iogon: "\u012F", Iopf: "\u{1D540}", iopf: "\u{1D55A}", Iota: "\u0399", iota: "\u03B9", iprod: "\u2A3C", iquest: "\xBF", iscr: "\u{1D4BE}", Iscr: "\u2110", isin: "\u2208", isindot: "\u22F5", isinE: "\u22F9", isins: "\u22F4", isinsv: "\u22F3", isinv: "\u2208", it: "\u2062", Itilde: "\u0128", itilde: "\u0129", Iukcy: "\u0406", iukcy: "\u0456", Iuml: "\xCF", iuml: "\xEF", Jcirc: "\u0134", jcirc: "\u0135", Jcy: "\u0419", jcy: "\u0439", Jfr: "\u{1D50D}", jfr: "\u{1D527}", jmath: "\u0237", Jopf: "\u{1D541}", jopf: "\u{1D55B}", Jscr: "\u{1D4A5}", jscr: "\u{1D4BF}", Jsercy: "\u0408", jsercy: "\u0458", Jukcy: "\u0404", jukcy: "\u0454", Kappa: "\u039A", kappa: "\u03BA", kappav: "\u03F0", Kcedil: "\u0136", kcedil: "\u0137", Kcy: "\u041A", kcy: "\u043A", Kfr: "\u{1D50E}", kfr: "\u{1D528}", kgreen: "\u0138", KHcy: "\u0425", khcy: "\u0445", KJcy: "\u040C", kjcy: "\u045C", Kopf: "\u{1D542}", kopf: "\u{1D55C}", Kscr: "\u{1D4A6}", kscr: "\u{1D4C0}", lAarr: "\u21DA", Lacute: "\u0139", lacute: "\u013A", laemptyv: "\u29B4", lagran: "\u2112", Lambda: "\u039B", lambda: "\u03BB", lang: "\u27E8", Lang: "\u27EA", langd: "\u2991", langle: "\u27E8", lap: "\u2A85", Laplacetrf: "\u2112", laquo: "\xAB", larrb: "\u21E4", larrbfs: "\u291F", larr: "\u2190", Larr: "\u219E", lArr: "\u21D0", larrfs: "\u291D", larrhk: "\u21A9", larrlp: "\u21AB", larrpl: "\u2939", larrsim: "\u2973", larrtl: "\u21A2", latail: "\u2919", lAtail: "\u291B", lat: "\u2AAB", late: "\u2AAD", lates: "\u2AAD\uFE00", lbarr: "\u290C", lBarr: "\u290E", lbbrk: "\u2772", lbrace: "{", lbrack: "[", lbrke: "\u298B", lbrksld: "\u298F", lbrkslu: "\u298D", Lcaron: "\u013D", lcaron: "\u013E", Lcedil: "\u013B", lcedil: "\u013C", lceil: "\u2308", lcub: "{", Lcy: "\u041B", lcy: "\u043B", ldca: "\u2936", ldquo: "\u201C", ldquor: "\u201E", ldrdhar: "\u2967", ldrushar: "\u294B", ldsh: "\u21B2", le: "\u2264", lE: "\u2266", LeftAngleBracket: "\u27E8", LeftArrowBar: "\u21E4", leftarrow: "\u2190", LeftArrow: "\u2190", Leftarrow: "\u21D0", LeftArrowRightArrow: "\u21C6", leftarrowtail: "\u21A2", LeftCeiling: "\u2308", LeftDoubleBracket: "\u27E6", LeftDownTeeVector: "\u2961", LeftDownVectorBar: "\u2959", LeftDownVector: "\u21C3", LeftFloor: "\u230A", leftharpoondown: "\u21BD", leftharpoonup: "\u21BC", leftleftarrows: "\u21C7", leftrightarrow: "\u2194", LeftRightArrow: "\u2194", Leftrightarrow: "\u21D4", leftrightarrows: "\u21C6", leftrightharpoons: "\u21CB", leftrightsquigarrow: "\u21AD", LeftRightVector: "\u294E", LeftTeeArrow: "\u21A4", LeftTee: "\u22A3", LeftTeeVector: "\u295A", leftthreetimes: "\u22CB", LeftTriangleBar: "\u29CF", LeftTriangle: "\u22B2", LeftTriangleEqual: "\u22B4", LeftUpDownVector: "\u2951", LeftUpTeeVector: "\u2960", LeftUpVectorBar: "\u2958", LeftUpVector: "\u21BF", LeftVectorBar: "\u2952", LeftVector: "\u21BC", lEg: "\u2A8B", leg: "\u22DA", leq: "\u2264", leqq: "\u2266", leqslant: "\u2A7D", lescc: "\u2AA8", les: "\u2A7D", lesdot: "\u2A7F", lesdoto: "\u2A81", lesdotor: "\u2A83", lesg: "\u22DA\uFE00", lesges: "\u2A93", lessapprox: "\u2A85", lessdot: "\u22D6", lesseqgtr: "\u22DA", lesseqqgtr: "\u2A8B", LessEqualGreater: "\u22DA", LessFullEqual: "\u2266", LessGreater: "\u2276", lessgtr: "\u2276", LessLess: "\u2AA1", lesssim: "\u2272", LessSlantEqual: "\u2A7D", LessTilde: "\u2272", lfisht: "\u297C", lfloor: "\u230A", Lfr: "\u{1D50F}", lfr: "\u{1D529}", lg: "\u2276", lgE: "\u2A91", lHar: "\u2962", lhard: "\u21BD", lharu: "\u21BC", lharul: "\u296A", lhblk: "\u2584", LJcy: "\u0409", ljcy: "\u0459", llarr: "\u21C7", ll: "\u226A", Ll: "\u22D8", llcorner: "\u231E", Lleftarrow: "\u21DA", llhard: "\u296B", lltri: "\u25FA", Lmidot: "\u013F", lmidot: "\u0140", lmoustache: "\u23B0", lmoust: "\u23B0", lnap: "\u2A89", lnapprox: "\u2A89", lne: "\u2A87", lnE: "\u2268", lneq: "\u2A87", lneqq: "\u2268", lnsim: "\u22E6", loang: "\u27EC", loarr: "\u21FD", lobrk: "\u27E6", longleftarrow: "\u27F5", LongLeftArrow: "\u27F5", Longleftarrow: "\u27F8", longleftrightarrow: "\u27F7", LongLeftRightArrow: "\u27F7", Longleftrightarrow: "\u27FA", longmapsto: "\u27FC", longrightarrow: "\u27F6", LongRightArrow: "\u27F6", Longrightarrow: "\u27F9", looparrowleft: "\u21AB", looparrowright: "\u21AC", lopar: "\u2985", Lopf: "\u{1D543}", lopf: "\u{1D55D}", loplus: "\u2A2D", lotimes: "\u2A34", lowast: "\u2217", lowbar: "_", LowerLeftArrow: "\u2199", LowerRightArrow: "\u2198", loz: "\u25CA", lozenge: "\u25CA", lozf: "\u29EB", lpar: "(", lparlt: "\u2993", lrarr: "\u21C6", lrcorner: "\u231F", lrhar: "\u21CB", lrhard: "\u296D", lrm: "\u200E", lrtri: "\u22BF", lsaquo: "\u2039", lscr: "\u{1D4C1}", Lscr: "\u2112", lsh: "\u21B0", Lsh: "\u21B0", lsim: "\u2272", lsime: "\u2A8D", lsimg: "\u2A8F", lsqb: "[", lsquo: "\u2018", lsquor: "\u201A", Lstrok: "\u0141", lstrok: "\u0142", ltcc: "\u2AA6", ltcir: "\u2A79", lt: "<", LT: "<", Lt: "\u226A", ltdot: "\u22D6", lthree: "\u22CB", ltimes: "\u22C9", ltlarr: "\u2976", ltquest: "\u2A7B", ltri: "\u25C3", ltrie: "\u22B4", ltrif: "\u25C2", ltrPar: "\u2996", lurdshar: "\u294A", luruhar: "\u2966", lvertneqq: "\u2268\uFE00", lvnE: "\u2268\uFE00", macr: "\xAF", male: "\u2642", malt: "\u2720", maltese: "\u2720", Map: "\u2905", map: "\u21A6", mapsto: "\u21A6", mapstodown: "\u21A7", mapstoleft: "\u21A4", mapstoup: "\u21A5", marker: "\u25AE", mcomma: "\u2A29", Mcy: "\u041C", mcy: "\u043C", mdash: "\u2014", mDDot: "\u223A", measuredangle: "\u2221", MediumSpace: "\u205F", Mellintrf: "\u2133", Mfr: "\u{1D510}", mfr: "\u{1D52A}", mho: "\u2127", micro: "\xB5", midast: "*", midcir: "\u2AF0", mid: "\u2223", middot: "\xB7", minusb: "\u229F", minus: "\u2212", minusd: "\u2238", minusdu: "\u2A2A", MinusPlus: "\u2213", mlcp: "\u2ADB", mldr: "\u2026", mnplus: "\u2213", models: "\u22A7", Mopf: "\u{1D544}", mopf: "\u{1D55E}", mp: "\u2213", mscr: "\u{1D4C2}", Mscr: "\u2133", mstpos: "\u223E", Mu: "\u039C", mu: "\u03BC", multimap: "\u22B8", mumap: "\u22B8", nabla: "\u2207", Nacute: "\u0143", nacute: "\u0144", nang: "\u2220\u20D2", nap: "\u2249", napE: "\u2A70\u0338", napid: "\u224B\u0338", napos: "\u0149", napprox: "\u2249", natural: "\u266E", naturals: "\u2115", natur: "\u266E", nbsp: "\xA0", nbump: "\u224E\u0338", nbumpe: "\u224F\u0338", ncap: "\u2A43", Ncaron: "\u0147", ncaron: "\u0148", Ncedil: "\u0145", ncedil: "\u0146", ncong: "\u2247", ncongdot: "\u2A6D\u0338", ncup: "\u2A42", Ncy: "\u041D", ncy: "\u043D", ndash: "\u2013", nearhk: "\u2924", nearr: "\u2197", neArr: "\u21D7", nearrow: "\u2197", ne: "\u2260", nedot: "\u2250\u0338", NegativeMediumSpace: "\u200B", NegativeThickSpace: "\u200B", NegativeThinSpace: "\u200B", NegativeVeryThinSpace: "\u200B", nequiv: "\u2262", nesear: "\u2928", nesim: "\u2242\u0338", NestedGreaterGreater: "\u226B", NestedLessLess: "\u226A", NewLine: "\n", nexist: "\u2204", nexists: "\u2204", Nfr: "\u{1D511}", nfr: "\u{1D52B}", ngE: "\u2267\u0338", nge: "\u2271", ngeq: "\u2271", ngeqq: "\u2267\u0338", ngeqslant: "\u2A7E\u0338", nges: "\u2A7E\u0338", nGg: "\u22D9\u0338", ngsim: "\u2275", nGt: "\u226B\u20D2", ngt: "\u226F", ngtr: "\u226F", nGtv: "\u226B\u0338", nharr: "\u21AE", nhArr: "\u21CE", nhpar: "\u2AF2", ni: "\u220B", nis: "\u22FC", nisd: "\u22FA", niv: "\u220B", NJcy: "\u040A", njcy: "\u045A", nlarr: "\u219A", nlArr: "\u21CD", nldr: "\u2025", nlE: "\u2266\u0338", nle: "\u2270", nleftarrow: "\u219A", nLeftarrow: "\u21CD", nleftrightarrow: "\u21AE", nLeftrightarrow: "\u21CE", nleq: "\u2270", nleqq: "\u2266\u0338", nleqslant: "\u2A7D\u0338", nles: "\u2A7D\u0338", nless: "\u226E", nLl: "\u22D8\u0338", nlsim: "\u2274", nLt: "\u226A\u20D2", nlt: "\u226E", nltri: "\u22EA", nltrie: "\u22EC", nLtv: "\u226A\u0338", nmid: "\u2224", NoBreak: "\u2060", NonBreakingSpace: "\xA0", nopf: "\u{1D55F}", Nopf: "\u2115", Not: "\u2AEC", not: "\xAC", NotCongruent: "\u2262", NotCupCap: "\u226D", NotDoubleVerticalBar: "\u2226", NotElement: "\u2209", NotEqual: "\u2260", NotEqualTilde: "\u2242\u0338", NotExists: "\u2204", NotGreater: "\u226F", NotGreaterEqual: "\u2271", NotGreaterFullEqual: "\u2267\u0338", NotGreaterGreater: "\u226B\u0338", NotGreaterLess: "\u2279", NotGreaterSlantEqual: "\u2A7E\u0338", NotGreaterTilde: "\u2275", NotHumpDownHump: "\u224E\u0338", NotHumpEqual: "\u224F\u0338", notin: "\u2209", notindot: "\u22F5\u0338", notinE: "\u22F9\u0338", notinva: "\u2209", notinvb: "\u22F7", notinvc: "\u22F6", NotLeftTriangleBar: "\u29CF\u0338", NotLeftTriangle: "\u22EA", NotLeftTriangleEqual: "\u22EC", NotLess: "\u226E", NotLessEqual: "\u2270", NotLessGreater: "\u2278", NotLessLess: "\u226A\u0338", NotLessSlantEqual: "\u2A7D\u0338", NotLessTilde: "\u2274", NotNestedGreaterGreater: "\u2AA2\u0338", NotNestedLessLess: "\u2AA1\u0338", notni: "\u220C", notniva: "\u220C", notnivb: "\u22FE", notnivc: "\u22FD", NotPrecedes: "\u2280", NotPrecedesEqual: "\u2AAF\u0338", NotPrecedesSlantEqual: "\u22E0", NotReverseElement: "\u220C", NotRightTriangleBar: "\u29D0\u0338", NotRightTriangle: "\u22EB", NotRightTriangleEqual: "\u22ED", NotSquareSubset: "\u228F\u0338", NotSquareSubsetEqual: "\u22E2", NotSquareSuperset: "\u2290\u0338", NotSquareSupersetEqual: "\u22E3", NotSubset: "\u2282\u20D2", NotSubsetEqual: "\u2288", NotSucceeds: "\u2281", NotSucceedsEqual: "\u2AB0\u0338", NotSucceedsSlantEqual: "\u22E1", NotSucceedsTilde: "\u227F\u0338", NotSuperset: "\u2283\u20D2", NotSupersetEqual: "\u2289", NotTilde: "\u2241", NotTildeEqual: "\u2244", NotTildeFullEqual: "\u2247", NotTildeTilde: "\u2249", NotVerticalBar: "\u2224", nparallel: "\u2226", npar: "\u2226", nparsl: "\u2AFD\u20E5", npart: "\u2202\u0338", npolint: "\u2A14", npr: "\u2280", nprcue: "\u22E0", nprec: "\u2280", npreceq: "\u2AAF\u0338", npre: "\u2AAF\u0338", nrarrc: "\u2933\u0338", nrarr: "\u219B", nrArr: "\u21CF", nrarrw: "\u219D\u0338", nrightarrow: "\u219B", nRightarrow: "\u21CF", nrtri: "\u22EB", nrtrie: "\u22ED", nsc: "\u2281", nsccue: "\u22E1", nsce: "\u2AB0\u0338", Nscr: "\u{1D4A9}", nscr: "\u{1D4C3}", nshortmid: "\u2224", nshortparallel: "\u2226", nsim: "\u2241", nsime: "\u2244", nsimeq: "\u2244", nsmid: "\u2224", nspar: "\u2226", nsqsube: "\u22E2", nsqsupe: "\u22E3", nsub: "\u2284", nsubE: "\u2AC5\u0338", nsube: "\u2288", nsubset: "\u2282\u20D2", nsubseteq: "\u2288", nsubseteqq: "\u2AC5\u0338", nsucc: "\u2281", nsucceq: "\u2AB0\u0338", nsup: "\u2285", nsupE: "\u2AC6\u0338", nsupe: "\u2289", nsupset: "\u2283\u20D2", nsupseteq: "\u2289", nsupseteqq: "\u2AC6\u0338", ntgl: "\u2279", Ntilde: "\xD1", ntilde: "\xF1", ntlg: "\u2278", ntriangleleft: "\u22EA", ntrianglelefteq: "\u22EC", ntriangleright: "\u22EB", ntrianglerighteq: "\u22ED", Nu: "\u039D", nu: "\u03BD", num: "#", numero: "\u2116", numsp: "\u2007", nvap: "\u224D\u20D2", nvdash: "\u22AC", nvDash: "\u22AD", nVdash: "\u22AE", nVDash: "\u22AF", nvge: "\u2265\u20D2", nvgt: ">\u20D2", nvHarr: "\u2904", nvinfin: "\u29DE", nvlArr: "\u2902", nvle: "\u2264\u20D2", nvlt: "<\u20D2", nvltrie: "\u22B4\u20D2", nvrArr: "\u2903", nvrtrie: "\u22B5\u20D2", nvsim: "\u223C\u20D2", nwarhk: "\u2923", nwarr: "\u2196", nwArr: "\u21D6", nwarrow: "\u2196", nwnear: "\u2927", Oacute: "\xD3", oacute: "\xF3", oast: "\u229B", Ocirc: "\xD4", ocirc: "\xF4", ocir: "\u229A", Ocy: "\u041E", ocy: "\u043E", odash: "\u229D", Odblac: "\u0150", odblac: "\u0151", odiv: "\u2A38", odot: "\u2299", odsold: "\u29BC", OElig: "\u0152", oelig: "\u0153", ofcir: "\u29BF", Ofr: "\u{1D512}", ofr: "\u{1D52C}", ogon: "\u02DB", Ograve: "\xD2", ograve: "\xF2", ogt: "\u29C1", ohbar: "\u29B5", ohm: "\u03A9", oint: "\u222E", olarr: "\u21BA", olcir: "\u29BE", olcross: "\u29BB", oline: "\u203E", olt: "\u29C0", Omacr: "\u014C", omacr: "\u014D", Omega: "\u03A9", omega: "\u03C9", Omicron: "\u039F", omicron: "\u03BF", omid: "\u29B6", ominus: "\u2296", Oopf: "\u{1D546}", oopf: "\u{1D560}", opar: "\u29B7", OpenCurlyDoubleQuote: "\u201C", OpenCurlyQuote: "\u2018", operp: "\u29B9", oplus: "\u2295", orarr: "\u21BB", Or: "\u2A54", or: "\u2228", ord: "\u2A5D", order: "\u2134", orderof: "\u2134", ordf: "\xAA", ordm: "\xBA", origof: "\u22B6", oror: "\u2A56", orslope: "\u2A57", orv: "\u2A5B", oS: "\u24C8", Oscr: "\u{1D4AA}", oscr: "\u2134", Oslash: "\xD8", oslash: "\xF8", osol: "\u2298", Otilde: "\xD5", otilde: "\xF5", otimesas: "\u2A36", Otimes: "\u2A37", otimes: "\u2297", Ouml: "\xD6", ouml: "\xF6", ovbar: "\u233D", OverBar: "\u203E", OverBrace: "\u23DE", OverBracket: "\u23B4", OverParenthesis: "\u23DC", para: "\xB6", parallel: "\u2225", par: "\u2225", parsim: "\u2AF3", parsl: "\u2AFD", part: "\u2202", PartialD: "\u2202", Pcy: "\u041F", pcy: "\u043F", percnt: "%", period: ".", permil: "\u2030", perp: "\u22A5", pertenk: "\u2031", Pfr: "\u{1D513}", pfr: "\u{1D52D}", Phi: "\u03A6", phi: "\u03C6", phiv: "\u03D5", phmmat: "\u2133", phone: "\u260E", Pi: "\u03A0", pi: "\u03C0", pitchfork: "\u22D4", piv: "\u03D6", planck: "\u210F", planckh: "\u210E", plankv: "\u210F", plusacir: "\u2A23", plusb: "\u229E", pluscir: "\u2A22", plus: "+", plusdo: "\u2214", plusdu: "\u2A25", pluse: "\u2A72", PlusMinus: "\xB1", plusmn: "\xB1", plussim: "\u2A26", plustwo: "\u2A27", pm: "\xB1", Poincareplane: "\u210C", pointint: "\u2A15", popf: "\u{1D561}", Popf: "\u2119", pound: "\xA3", prap: "\u2AB7", Pr: "\u2ABB", pr: "\u227A", prcue: "\u227C", precapprox: "\u2AB7", prec: "\u227A", preccurlyeq: "\u227C", Precedes: "\u227A", PrecedesEqual: "\u2AAF", PrecedesSlantEqual: "\u227C", PrecedesTilde: "\u227E", preceq: "\u2AAF", precnapprox: "\u2AB9", precneqq: "\u2AB5", precnsim: "\u22E8", pre: "\u2AAF", prE: "\u2AB3", precsim: "\u227E", prime: "\u2032", Prime: "\u2033", primes: "\u2119", prnap: "\u2AB9", prnE: "\u2AB5", prnsim: "\u22E8", prod: "\u220F", Product: "\u220F", profalar: "\u232E", profline: "\u2312", profsurf: "\u2313", prop: "\u221D", Proportional: "\u221D", Proportion: "\u2237", propto: "\u221D", prsim: "\u227E", prurel: "\u22B0", Pscr: "\u{1D4AB}", pscr: "\u{1D4C5}", Psi: "\u03A8", psi: "\u03C8", puncsp: "\u2008", Qfr: "\u{1D514}", qfr: "\u{1D52E}", qint: "\u2A0C", qopf: "\u{1D562}", Qopf: "\u211A", qprime: "\u2057", Qscr: "\u{1D4AC}", qscr: "\u{1D4C6}", quaternions: "\u210D", quatint: "\u2A16", quest: "?", questeq: "\u225F", quot: '"', QUOT: '"', rAarr: "\u21DB", race: "\u223D\u0331", Racute: "\u0154", racute: "\u0155", radic: "\u221A", raemptyv: "\u29B3", rang: "\u27E9", Rang: "\u27EB", rangd: "\u2992", range: "\u29A5", rangle: "\u27E9", raquo: "\xBB", rarrap: "\u2975", rarrb: "\u21E5", rarrbfs: "\u2920", rarrc: "\u2933", rarr: "\u2192", Rarr: "\u21A0", rArr: "\u21D2", rarrfs: "\u291E", rarrhk: "\u21AA", rarrlp: "\u21AC", rarrpl: "\u2945", rarrsim: "\u2974", Rarrtl: "\u2916", rarrtl: "\u21A3", rarrw: "\u219D", ratail: "\u291A", rAtail: "\u291C", ratio: "\u2236", rationals: "\u211A", rbarr: "\u290D", rBarr: "\u290F", RBarr: "\u2910", rbbrk: "\u2773", rbrace: "}", rbrack: "]", rbrke: "\u298C", rbrksld: "\u298E", rbrkslu: "\u2990", Rcaron: "\u0158", rcaron: "\u0159", Rcedil: "\u0156", rcedil: "\u0157", rceil: "\u2309", rcub: "}", Rcy: "\u0420", rcy: "\u0440", rdca: "\u2937", rdldhar: "\u2969", rdquo: "\u201D", rdquor: "\u201D", rdsh: "\u21B3", real: "\u211C", realine: "\u211B", realpart: "\u211C", reals: "\u211D", Re: "\u211C", rect: "\u25AD", reg: "\xAE", REG: "\xAE", ReverseElement: "\u220B", ReverseEquilibrium: "\u21CB", ReverseUpEquilibrium: "\u296F", rfisht: "\u297D", rfloor: "\u230B", rfr: "\u{1D52F}", Rfr: "\u211C", rHar: "\u2964", rhard: "\u21C1", rharu: "\u21C0", rharul: "\u296C", Rho: "\u03A1", rho: "\u03C1", rhov: "\u03F1", RightAngleBracket: "\u27E9", RightArrowBar: "\u21E5", rightarrow: "\u2192", RightArrow: "\u2192", Rightarrow: "\u21D2", RightArrowLeftArrow: "\u21C4", rightarrowtail: "\u21A3", RightCeiling: "\u2309", RightDoubleBracket: "\u27E7", RightDownTeeVector: "\u295D", RightDownVectorBar: "\u2955", RightDownVector: "\u21C2", RightFloor: "\u230B", rightharpoondown: "\u21C1", rightharpoonup: "\u21C0", rightleftarrows: "\u21C4", rightleftharpoons: "\u21CC", rightrightarrows: "\u21C9", rightsquigarrow: "\u219D", RightTeeArrow: "\u21A6", RightTee: "\u22A2", RightTeeVector: "\u295B", rightthreetimes: "\u22CC", RightTriangleBar: "\u29D0", RightTriangle: "\u22B3", RightTriangleEqual: "\u22B5", RightUpDownVector: "\u294F", RightUpTeeVector: "\u295C", RightUpVectorBar: "\u2954", RightUpVector: "\u21BE", RightVectorBar: "\u2953", RightVector: "\u21C0", ring: "\u02DA", risingdotseq: "\u2253", rlarr: "\u21C4", rlhar: "\u21CC", rlm: "\u200F", rmoustache: "\u23B1", rmoust: "\u23B1", rnmid: "\u2AEE", roang: "\u27ED", roarr: "\u21FE", robrk: "\u27E7", ropar: "\u2986", ropf: "\u{1D563}", Ropf: "\u211D", roplus: "\u2A2E", rotimes: "\u2A35", RoundImplies: "\u2970", rpar: ")", rpargt: "\u2994", rppolint: "\u2A12", rrarr: "\u21C9", Rrightarrow: "\u21DB", rsaquo: "\u203A", rscr: "\u{1D4C7}", Rscr: "\u211B", rsh: "\u21B1", Rsh: "\u21B1", rsqb: "]", rsquo: "\u2019", rsquor: "\u2019", rthree: "\u22CC", rtimes: "\u22CA", rtri: "\u25B9", rtrie: "\u22B5", rtrif: "\u25B8", rtriltri: "\u29CE", RuleDelayed: "\u29F4", ruluhar: "\u2968", rx: "\u211E", Sacute: "\u015A", sacute: "\u015B", sbquo: "\u201A", scap: "\u2AB8", Scaron: "\u0160", scaron: "\u0161", Sc: "\u2ABC", sc: "\u227B", sccue: "\u227D", sce: "\u2AB0", scE: "\u2AB4", Scedil: "\u015E", scedil: "\u015F", Scirc: "\u015C", scirc: "\u015D", scnap: "\u2ABA", scnE: "\u2AB6", scnsim: "\u22E9", scpolint: "\u2A13", scsim: "\u227F", Scy: "\u0421", scy: "\u0441", sdotb: "\u22A1", sdot: "\u22C5", sdote: "\u2A66", searhk: "\u2925", searr: "\u2198", seArr: "\u21D8", searrow: "\u2198", sect: "\xA7", semi: ";", seswar: "\u2929", setminus: "\u2216", setmn: "\u2216", sext: "\u2736", Sfr: "\u{1D516}", sfr: "\u{1D530}", sfrown: "\u2322", sharp: "\u266F", SHCHcy: "\u0429", shchcy: "\u0449", SHcy: "\u0428", shcy: "\u0448", ShortDownArrow: "\u2193", ShortLeftArrow: "\u2190", shortmid: "\u2223", shortparallel: "\u2225", ShortRightArrow: "\u2192", ShortUpArrow: "\u2191", shy: "\xAD", Sigma: "\u03A3", sigma: "\u03C3", sigmaf: "\u03C2", sigmav: "\u03C2", sim: "\u223C", simdot: "\u2A6A", sime: "\u2243", simeq: "\u2243", simg: "\u2A9E", simgE: "\u2AA0", siml: "\u2A9D", simlE: "\u2A9F", simne: "\u2246", simplus: "\u2A24", simrarr: "\u2972", slarr: "\u2190", SmallCircle: "\u2218", smallsetminus: "\u2216", smashp: "\u2A33", smeparsl: "\u29E4", smid: "\u2223", smile: "\u2323", smt: "\u2AAA", smte: "\u2AAC", smtes: "\u2AAC\uFE00", SOFTcy: "\u042C", softcy: "\u044C", solbar: "\u233F", solb: "\u29C4", sol: "/", Sopf: "\u{1D54A}", sopf: "\u{1D564}", spades: "\u2660", spadesuit: "\u2660", spar: "\u2225", sqcap: "\u2293", sqcaps: "\u2293\uFE00", sqcup: "\u2294", sqcups: "\u2294\uFE00", Sqrt: "\u221A", sqsub: "\u228F", sqsube: "\u2291", sqsubset: "\u228F", sqsubseteq: "\u2291", sqsup: "\u2290", sqsupe: "\u2292", sqsupset: "\u2290", sqsupseteq: "\u2292", square: "\u25A1", Square: "\u25A1", SquareIntersection: "\u2293", SquareSubset: "\u228F", SquareSubsetEqual: "\u2291", SquareSuperset: "\u2290", SquareSupersetEqual: "\u2292", SquareUnion: "\u2294", squarf: "\u25AA", squ: "\u25A1", squf: "\u25AA", srarr: "\u2192", Sscr: "\u{1D4AE}", sscr: "\u{1D4C8}", ssetmn: "\u2216", ssmile: "\u2323", sstarf: "\u22C6", Star: "\u22C6", star: "\u2606", starf: "\u2605", straightepsilon: "\u03F5", straightphi: "\u03D5", strns: "\xAF", sub: "\u2282", Sub: "\u22D0", subdot: "\u2ABD", subE: "\u2AC5", sube: "\u2286", subedot: "\u2AC3", submult: "\u2AC1", subnE: "\u2ACB", subne: "\u228A", subplus: "\u2ABF", subrarr: "\u2979", subset: "\u2282", Subset: "\u22D0", subseteq: "\u2286", subseteqq: "\u2AC5", SubsetEqual: "\u2286", subsetneq: "\u228A", subsetneqq: "\u2ACB", subsim: "\u2AC7", subsub: "\u2AD5", subsup: "\u2AD3", succapprox: "\u2AB8", succ: "\u227B", succcurlyeq: "\u227D", Succeeds: "\u227B", SucceedsEqual: "\u2AB0", SucceedsSlantEqual: "\u227D", SucceedsTilde: "\u227F", succeq: "\u2AB0", succnapprox: "\u2ABA", succneqq: "\u2AB6", succnsim: "\u22E9", succsim: "\u227F", SuchThat: "\u220B", sum: "\u2211", Sum: "\u2211", sung: "\u266A", sup1: "\xB9", sup2: "\xB2", sup3: "\xB3", sup: "\u2283", Sup: "\u22D1", supdot: "\u2ABE", supdsub: "\u2AD8", supE: "\u2AC6", supe: "\u2287", supedot: "\u2AC4", Superset: "\u2283", SupersetEqual: "\u2287", suphsol: "\u27C9", suphsub: "\u2AD7", suplarr: "\u297B", supmult: "\u2AC2", supnE: "\u2ACC", supne: "\u228B", supplus: "\u2AC0", supset: "\u2283", Supset: "\u22D1", supseteq: "\u2287", supseteqq: "\u2AC6", supsetneq: "\u228B", supsetneqq: "\u2ACC", supsim: "\u2AC8", supsub: "\u2AD4", supsup: "\u2AD6", swarhk: "\u2926", swarr: "\u2199", swArr: "\u21D9", swarrow: "\u2199", swnwar: "\u292A", szlig: "\xDF", Tab: "	", target: "\u2316", Tau: "\u03A4", tau: "\u03C4", tbrk: "\u23B4", Tcaron: "\u0164", tcaron: "\u0165", Tcedil: "\u0162", tcedil: "\u0163", Tcy: "\u0422", tcy: "\u0442", tdot: "\u20DB", telrec: "\u2315", Tfr: "\u{1D517}", tfr: "\u{1D531}", there4: "\u2234", therefore: "\u2234", Therefore: "\u2234", Theta: "\u0398", theta: "\u03B8", thetasym: "\u03D1", thetav: "\u03D1", thickapprox: "\u2248", thicksim: "\u223C", ThickSpace: "\u205F\u200A", ThinSpace: "\u2009", thinsp: "\u2009", thkap: "\u2248", thksim: "\u223C", THORN: "\xDE", thorn: "\xFE", tilde: "\u02DC", Tilde: "\u223C", TildeEqual: "\u2243", TildeFullEqual: "\u2245", TildeTilde: "\u2248", timesbar: "\u2A31", timesb: "\u22A0", times: "\xD7", timesd: "\u2A30", tint: "\u222D", toea: "\u2928", topbot: "\u2336", topcir: "\u2AF1", top: "\u22A4", Topf: "\u{1D54B}", topf: "\u{1D565}", topfork: "\u2ADA", tosa: "\u2929", tprime: "\u2034", trade: "\u2122", TRADE: "\u2122", triangle: "\u25B5", triangledown: "\u25BF", triangleleft: "\u25C3", trianglelefteq: "\u22B4", triangleq: "\u225C", triangleright: "\u25B9", trianglerighteq: "\u22B5", tridot: "\u25EC", trie: "\u225C", triminus: "\u2A3A", TripleDot: "\u20DB", triplus: "\u2A39", trisb: "\u29CD", tritime: "\u2A3B", trpezium: "\u23E2", Tscr: "\u{1D4AF}", tscr: "\u{1D4C9}", TScy: "\u0426", tscy: "\u0446", TSHcy: "\u040B", tshcy: "\u045B", Tstrok: "\u0166", tstrok: "\u0167", twixt: "\u226C", twoheadleftarrow: "\u219E", twoheadrightarrow: "\u21A0", Uacute: "\xDA", uacute: "\xFA", uarr: "\u2191", Uarr: "\u219F", uArr: "\u21D1", Uarrocir: "\u2949", Ubrcy: "\u040E", ubrcy: "\u045E", Ubreve: "\u016C", ubreve: "\u016D", Ucirc: "\xDB", ucirc: "\xFB", Ucy: "\u0423", ucy: "\u0443", udarr: "\u21C5", Udblac: "\u0170", udblac: "\u0171", udhar: "\u296E", ufisht: "\u297E", Ufr: "\u{1D518}", ufr: "\u{1D532}", Ugrave: "\xD9", ugrave: "\xF9", uHar: "\u2963", uharl: "\u21BF", uharr: "\u21BE", uhblk: "\u2580", ulcorn: "\u231C", ulcorner: "\u231C", ulcrop: "\u230F", ultri: "\u25F8", Umacr: "\u016A", umacr: "\u016B", uml: "\xA8", UnderBar: "_", UnderBrace: "\u23DF", UnderBracket: "\u23B5", UnderParenthesis: "\u23DD", Union: "\u22C3", UnionPlus: "\u228E", Uogon: "\u0172", uogon: "\u0173", Uopf: "\u{1D54C}", uopf: "\u{1D566}", UpArrowBar: "\u2912", uparrow: "\u2191", UpArrow: "\u2191", Uparrow: "\u21D1", UpArrowDownArrow: "\u21C5", updownarrow: "\u2195", UpDownArrow: "\u2195", Updownarrow: "\u21D5", UpEquilibrium: "\u296E", upharpoonleft: "\u21BF", upharpoonright: "\u21BE", uplus: "\u228E", UpperLeftArrow: "\u2196", UpperRightArrow: "\u2197", upsi: "\u03C5", Upsi: "\u03D2", upsih: "\u03D2", Upsilon: "\u03A5", upsilon: "\u03C5", UpTeeArrow: "\u21A5", UpTee: "\u22A5", upuparrows: "\u21C8", urcorn: "\u231D", urcorner: "\u231D", urcrop: "\u230E", Uring: "\u016E", uring: "\u016F", urtri: "\u25F9", Uscr: "\u{1D4B0}", uscr: "\u{1D4CA}", utdot: "\u22F0", Utilde: "\u0168", utilde: "\u0169", utri: "\u25B5", utrif: "\u25B4", uuarr: "\u21C8", Uuml: "\xDC", uuml: "\xFC", uwangle: "\u29A7", vangrt: "\u299C", varepsilon: "\u03F5", varkappa: "\u03F0", varnothing: "\u2205", varphi: "\u03D5", varpi: "\u03D6", varpropto: "\u221D", varr: "\u2195", vArr: "\u21D5", varrho: "\u03F1", varsigma: "\u03C2", varsubsetneq: "\u228A\uFE00", varsubsetneqq: "\u2ACB\uFE00", varsupsetneq: "\u228B\uFE00", varsupsetneqq: "\u2ACC\uFE00", vartheta: "\u03D1", vartriangleleft: "\u22B2", vartriangleright: "\u22B3", vBar: "\u2AE8", Vbar: "\u2AEB", vBarv: "\u2AE9", Vcy: "\u0412", vcy: "\u0432", vdash: "\u22A2", vDash: "\u22A8", Vdash: "\u22A9", VDash: "\u22AB", Vdashl: "\u2AE6", veebar: "\u22BB", vee: "\u2228", Vee: "\u22C1", veeeq: "\u225A", vellip: "\u22EE", verbar: "|", Verbar: "\u2016", vert: "|", Vert: "\u2016", VerticalBar: "\u2223", VerticalLine: "|", VerticalSeparator: "\u2758", VerticalTilde: "\u2240", VeryThinSpace: "\u200A", Vfr: "\u{1D519}", vfr: "\u{1D533}", vltri: "\u22B2", vnsub: "\u2282\u20D2", vnsup: "\u2283\u20D2", Vopf: "\u{1D54D}", vopf: "\u{1D567}", vprop: "\u221D", vrtri: "\u22B3", Vscr: "\u{1D4B1}", vscr: "\u{1D4CB}", vsubnE: "\u2ACB\uFE00", vsubne: "\u228A\uFE00", vsupnE: "\u2ACC\uFE00", vsupne: "\u228B\uFE00", Vvdash: "\u22AA", vzigzag: "\u299A", Wcirc: "\u0174", wcirc: "\u0175", wedbar: "\u2A5F", wedge: "\u2227", Wedge: "\u22C0", wedgeq: "\u2259", weierp: "\u2118", Wfr: "\u{1D51A}", wfr: "\u{1D534}", Wopf: "\u{1D54E}", wopf: "\u{1D568}", wp: "\u2118", wr: "\u2240", wreath: "\u2240", Wscr: "\u{1D4B2}", wscr: "\u{1D4CC}", xcap: "\u22C2", xcirc: "\u25EF", xcup: "\u22C3", xdtri: "\u25BD", Xfr: "\u{1D51B}", xfr: "\u{1D535}", xharr: "\u27F7", xhArr: "\u27FA", Xi: "\u039E", xi: "\u03BE", xlarr: "\u27F5", xlArr: "\u27F8", xmap: "\u27FC", xnis: "\u22FB", xodot: "\u2A00", Xopf: "\u{1D54F}", xopf: "\u{1D569}", xoplus: "\u2A01", xotime: "\u2A02", xrarr: "\u27F6", xrArr: "\u27F9", Xscr: "\u{1D4B3}", xscr: "\u{1D4CD}", xsqcup: "\u2A06", xuplus: "\u2A04", xutri: "\u25B3", xvee: "\u22C1", xwedge: "\u22C0", Yacute: "\xDD", yacute: "\xFD", YAcy: "\u042F", yacy: "\u044F", Ycirc: "\u0176", ycirc: "\u0177", Ycy: "\u042B", ycy: "\u044B", yen: "\xA5", Yfr: "\u{1D51C}", yfr: "\u{1D536}", YIcy: "\u0407", yicy: "\u0457", Yopf: "\u{1D550}", yopf: "\u{1D56A}", Yscr: "\u{1D4B4}", yscr: "\u{1D4CE}", YUcy: "\u042E", yucy: "\u044E", yuml: "\xFF", Yuml: "\u0178", Zacute: "\u0179", zacute: "\u017A", Zcaron: "\u017D", zcaron: "\u017E", Zcy: "\u0417", zcy: "\u0437", Zdot: "\u017B", zdot: "\u017C", zeetrf: "\u2128", ZeroWidthSpace: "\u200B", Zeta: "\u0396", zeta: "\u03B6", zfr: "\u{1D537}", Zfr: "\u2128", ZHcy: "\u0416", zhcy: "\u0436", zigrarr: "\u21DD", zopf: "\u{1D56B}", Zopf: "\u2124", Zscr: "\u{1D4B5}", zscr: "\u{1D4CF}", zwj: "\u200D", zwnj: "\u200C" };
    }
  });

  // node_modules/markdown-it/lib/common/entities.js
  var require_entities2 = __commonJS({
    "node_modules/markdown-it/lib/common/entities.js"(exports, module) {
      "use strict";
      module.exports = require_entities();
    }
  });

  // node_modules/uc.micro/categories/P/regex.js
  var require_regex = __commonJS({
    "node_modules/uc.micro/categories/P/regex.js"(exports, module) {
      module.exports = /[!-#%-\*,-\/:;\?@\[-\]_\{\}\xA1\xA7\xAB\xB6\xB7\xBB\xBF\u037E\u0387\u055A-\u055F\u0589\u058A\u05BE\u05C0\u05C3\u05C6\u05F3\u05F4\u0609\u060A\u060C\u060D\u061B\u061E\u061F\u066A-\u066D\u06D4\u0700-\u070D\u07F7-\u07F9\u0830-\u083E\u085E\u0964\u0965\u0970\u09FD\u0A76\u0AF0\u0C84\u0DF4\u0E4F\u0E5A\u0E5B\u0F04-\u0F12\u0F14\u0F3A-\u0F3D\u0F85\u0FD0-\u0FD4\u0FD9\u0FDA\u104A-\u104F\u10FB\u1360-\u1368\u1400\u166D\u166E\u169B\u169C\u16EB-\u16ED\u1735\u1736\u17D4-\u17D6\u17D8-\u17DA\u1800-\u180A\u1944\u1945\u1A1E\u1A1F\u1AA0-\u1AA6\u1AA8-\u1AAD\u1B5A-\u1B60\u1BFC-\u1BFF\u1C3B-\u1C3F\u1C7E\u1C7F\u1CC0-\u1CC7\u1CD3\u2010-\u2027\u2030-\u2043\u2045-\u2051\u2053-\u205E\u207D\u207E\u208D\u208E\u2308-\u230B\u2329\u232A\u2768-\u2775\u27C5\u27C6\u27E6-\u27EF\u2983-\u2998\u29D8-\u29DB\u29FC\u29FD\u2CF9-\u2CFC\u2CFE\u2CFF\u2D70\u2E00-\u2E2E\u2E30-\u2E4E\u3001-\u3003\u3008-\u3011\u3014-\u301F\u3030\u303D\u30A0\u30FB\uA4FE\uA4FF\uA60D-\uA60F\uA673\uA67E\uA6F2-\uA6F7\uA874-\uA877\uA8CE\uA8CF\uA8F8-\uA8FA\uA8FC\uA92E\uA92F\uA95F\uA9C1-\uA9CD\uA9DE\uA9DF\uAA5C-\uAA5F\uAADE\uAADF\uAAF0\uAAF1\uABEB\uFD3E\uFD3F\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE61\uFE63\uFE68\uFE6A\uFE6B\uFF01-\uFF03\uFF05-\uFF0A\uFF0C-\uFF0F\uFF1A\uFF1B\uFF1F\uFF20\uFF3B-\uFF3D\uFF3F\uFF5B\uFF5D\uFF5F-\uFF65]|\uD800[\uDD00-\uDD02\uDF9F\uDFD0]|\uD801\uDD6F|\uD802[\uDC57\uDD1F\uDD3F\uDE50-\uDE58\uDE7F\uDEF0-\uDEF6\uDF39-\uDF3F\uDF99-\uDF9C]|\uD803[\uDF55-\uDF59]|\uD804[\uDC47-\uDC4D\uDCBB\uDCBC\uDCBE-\uDCC1\uDD40-\uDD43\uDD74\uDD75\uDDC5-\uDDC8\uDDCD\uDDDB\uDDDD-\uDDDF\uDE38-\uDE3D\uDEA9]|\uD805[\uDC4B-\uDC4F\uDC5B\uDC5D\uDCC6\uDDC1-\uDDD7\uDE41-\uDE43\uDE60-\uDE6C\uDF3C-\uDF3E]|\uD806[\uDC3B\uDE3F-\uDE46\uDE9A-\uDE9C\uDE9E-\uDEA2]|\uD807[\uDC41-\uDC45\uDC70\uDC71\uDEF7\uDEF8]|\uD809[\uDC70-\uDC74]|\uD81A[\uDE6E\uDE6F\uDEF5\uDF37-\uDF3B\uDF44]|\uD81B[\uDE97-\uDE9A]|\uD82F\uDC9F|\uD836[\uDE87-\uDE8B]|\uD83A[\uDD5E\uDD5F]/;
    }
  });

  // node_modules/mdurl/encode.js
  var require_encode = __commonJS({
    "node_modules/mdurl/encode.js"(exports, module) {
      "use strict";
      var encodeCache = {};
      function getEncodeCache(exclude) {
        var i, ch, cache = encodeCache[exclude];
        if (cache) {
          return cache;
        }
        cache = encodeCache[exclude] = [];
        for (i = 0; i < 128; i++) {
          ch = String.fromCharCode(i);
          if (/^[0-9a-z]$/i.test(ch)) {
            cache.push(ch);
          } else {
            cache.push("%" + ("0" + i.toString(16).toUpperCase()).slice(-2));
          }
        }
        for (i = 0; i < exclude.length; i++) {
          cache[exclude.charCodeAt(i)] = exclude[i];
        }
        return cache;
      }
      function encode(string, exclude, keepEscaped) {
        var i, l, code, nextCode, cache, result = "";
        if (typeof exclude !== "string") {
          keepEscaped = exclude;
          exclude = encode.defaultChars;
        }
        if (typeof keepEscaped === "undefined") {
          keepEscaped = true;
        }
        cache = getEncodeCache(exclude);
        for (i = 0, l = string.length; i < l; i++) {
          code = string.charCodeAt(i);
          if (keepEscaped && code === 37 && i + 2 < l) {
            if (/^[0-9a-f]{2}$/i.test(string.slice(i + 1, i + 3))) {
              result += string.slice(i, i + 3);
              i += 2;
              continue;
            }
          }
          if (code < 128) {
            result += cache[code];
            continue;
          }
          if (code >= 55296 && code <= 57343) {
            if (code >= 55296 && code <= 56319 && i + 1 < l) {
              nextCode = string.charCodeAt(i + 1);
              if (nextCode >= 56320 && nextCode <= 57343) {
                result += encodeURIComponent(string[i] + string[i + 1]);
                i++;
                continue;
              }
            }
            result += "%EF%BF%BD";
            continue;
          }
          result += encodeURIComponent(string[i]);
        }
        return result;
      }
      encode.defaultChars = ";/?:@&=+$,-_.!~*'()#";
      encode.componentChars = "-_.!~*'()";
      module.exports = encode;
    }
  });

  // node_modules/mdurl/decode.js
  var require_decode = __commonJS({
    "node_modules/mdurl/decode.js"(exports, module) {
      "use strict";
      var decodeCache = {};
      function getDecodeCache(exclude) {
        var i, ch, cache = decodeCache[exclude];
        if (cache) {
          return cache;
        }
        cache = decodeCache[exclude] = [];
        for (i = 0; i < 128; i++) {
          ch = String.fromCharCode(i);
          cache.push(ch);
        }
        for (i = 0; i < exclude.length; i++) {
          ch = exclude.charCodeAt(i);
          cache[ch] = "%" + ("0" + ch.toString(16).toUpperCase()).slice(-2);
        }
        return cache;
      }
      function decode(string, exclude) {
        var cache;
        if (typeof exclude !== "string") {
          exclude = decode.defaultChars;
        }
        cache = getDecodeCache(exclude);
        return string.replace(/(%[a-f0-9]{2})+/gi, function(seq) {
          var i, l, b1, b2, b3, b4, chr, result = "";
          for (i = 0, l = seq.length; i < l; i += 3) {
            b1 = parseInt(seq.slice(i + 1, i + 3), 16);
            if (b1 < 128) {
              result += cache[b1];
              continue;
            }
            if ((b1 & 224) === 192 && i + 3 < l) {
              b2 = parseInt(seq.slice(i + 4, i + 6), 16);
              if ((b2 & 192) === 128) {
                chr = b1 << 6 & 1984 | b2 & 63;
                if (chr < 128) {
                  result += "\uFFFD\uFFFD";
                } else {
                  result += String.fromCharCode(chr);
                }
                i += 3;
                continue;
              }
            }
            if ((b1 & 240) === 224 && i + 6 < l) {
              b2 = parseInt(seq.slice(i + 4, i + 6), 16);
              b3 = parseInt(seq.slice(i + 7, i + 9), 16);
              if ((b2 & 192) === 128 && (b3 & 192) === 128) {
                chr = b1 << 12 & 61440 | b2 << 6 & 4032 | b3 & 63;
                if (chr < 2048 || chr >= 55296 && chr <= 57343) {
                  result += "\uFFFD\uFFFD\uFFFD";
                } else {
                  result += String.fromCharCode(chr);
                }
                i += 6;
                continue;
              }
            }
            if ((b1 & 248) === 240 && i + 9 < l) {
              b2 = parseInt(seq.slice(i + 4, i + 6), 16);
              b3 = parseInt(seq.slice(i + 7, i + 9), 16);
              b4 = parseInt(seq.slice(i + 10, i + 12), 16);
              if ((b2 & 192) === 128 && (b3 & 192) === 128 && (b4 & 192) === 128) {
                chr = b1 << 18 & 1835008 | b2 << 12 & 258048 | b3 << 6 & 4032 | b4 & 63;
                if (chr < 65536 || chr > 1114111) {
                  result += "\uFFFD\uFFFD\uFFFD\uFFFD";
                } else {
                  chr -= 65536;
                  result += String.fromCharCode(55296 + (chr >> 10), 56320 + (chr & 1023));
                }
                i += 9;
                continue;
              }
            }
            result += "\uFFFD";
          }
          return result;
        });
      }
      decode.defaultChars = ";/?:@&=+$,#";
      decode.componentChars = "";
      module.exports = decode;
    }
  });

  // node_modules/mdurl/format.js
  var require_format = __commonJS({
    "node_modules/mdurl/format.js"(exports, module) {
      "use strict";
      module.exports = function format(url) {
        var result = "";
        result += url.protocol || "";
        result += url.slashes ? "//" : "";
        result += url.auth ? url.auth + "@" : "";
        if (url.hostname && url.hostname.indexOf(":") !== -1) {
          result += "[" + url.hostname + "]";
        } else {
          result += url.hostname || "";
        }
        result += url.port ? ":" + url.port : "";
        result += url.pathname || "";
        result += url.search || "";
        result += url.hash || "";
        return result;
      };
    }
  });

  // node_modules/mdurl/parse.js
  var require_parse = __commonJS({
    "node_modules/mdurl/parse.js"(exports, module) {
      "use strict";
      function Url() {
        this.protocol = null;
        this.slashes = null;
        this.auth = null;
        this.port = null;
        this.hostname = null;
        this.hash = null;
        this.search = null;
        this.pathname = null;
      }
      var protocolPattern = /^([a-z0-9.+-]+:)/i;
      var portPattern = /:[0-9]*$/;
      var simplePathPattern = /^(\/\/?(?!\/)[^\?\s]*)(\?[^\s]*)?$/;
      var delims = ["<", ">", '"', "`", " ", "\r", "\n", "	"];
      var unwise = ["{", "}", "|", "\\", "^", "`"].concat(delims);
      var autoEscape = ["'"].concat(unwise);
      var nonHostChars = ["%", "/", "?", ";", "#"].concat(autoEscape);
      var hostEndingChars = ["/", "?", "#"];
      var hostnameMaxLen = 255;
      var hostnamePartPattern = /^[+a-z0-9A-Z_-]{0,63}$/;
      var hostnamePartStart = /^([+a-z0-9A-Z_-]{0,63})(.*)$/;
      var hostlessProtocol = {
        "javascript": true,
        "javascript:": true
      };
      var slashedProtocol = {
        "http": true,
        "https": true,
        "ftp": true,
        "gopher": true,
        "file": true,
        "http:": true,
        "https:": true,
        "ftp:": true,
        "gopher:": true,
        "file:": true
      };
      function urlParse(url, slashesDenoteHost) {
        if (url && url instanceof Url) {
          return url;
        }
        var u = new Url();
        u.parse(url, slashesDenoteHost);
        return u;
      }
      Url.prototype.parse = function(url, slashesDenoteHost) {
        var i, l, lowerProto, hec, slashes, rest = url;
        rest = rest.trim();
        if (!slashesDenoteHost && url.split("#").length === 1) {
          var simplePath = simplePathPattern.exec(rest);
          if (simplePath) {
            this.pathname = simplePath[1];
            if (simplePath[2]) {
              this.search = simplePath[2];
            }
            return this;
          }
        }
        var proto = protocolPattern.exec(rest);
        if (proto) {
          proto = proto[0];
          lowerProto = proto.toLowerCase();
          this.protocol = proto;
          rest = rest.substr(proto.length);
        }
        if (slashesDenoteHost || proto || rest.match(/^\/\/[^@\/]+@[^@\/]+/)) {
          slashes = rest.substr(0, 2) === "//";
          if (slashes && !(proto && hostlessProtocol[proto])) {
            rest = rest.substr(2);
            this.slashes = true;
          }
        }
        if (!hostlessProtocol[proto] && (slashes || proto && !slashedProtocol[proto])) {
          var hostEnd = -1;
          for (i = 0; i < hostEndingChars.length; i++) {
            hec = rest.indexOf(hostEndingChars[i]);
            if (hec !== -1 && (hostEnd === -1 || hec < hostEnd)) {
              hostEnd = hec;
            }
          }
          var auth, atSign;
          if (hostEnd === -1) {
            atSign = rest.lastIndexOf("@");
          } else {
            atSign = rest.lastIndexOf("@", hostEnd);
          }
          if (atSign !== -1) {
            auth = rest.slice(0, atSign);
            rest = rest.slice(atSign + 1);
            this.auth = auth;
          }
          hostEnd = -1;
          for (i = 0; i < nonHostChars.length; i++) {
            hec = rest.indexOf(nonHostChars[i]);
            if (hec !== -1 && (hostEnd === -1 || hec < hostEnd)) {
              hostEnd = hec;
            }
          }
          if (hostEnd === -1) {
            hostEnd = rest.length;
          }
          if (rest[hostEnd - 1] === ":") {
            hostEnd--;
          }
          var host = rest.slice(0, hostEnd);
          rest = rest.slice(hostEnd);
          this.parseHost(host);
          this.hostname = this.hostname || "";
          var ipv6Hostname = this.hostname[0] === "[" && this.hostname[this.hostname.length - 1] === "]";
          if (!ipv6Hostname) {
            var hostparts = this.hostname.split(/\./);
            for (i = 0, l = hostparts.length; i < l; i++) {
              var part = hostparts[i];
              if (!part) {
                continue;
              }
              if (!part.match(hostnamePartPattern)) {
                var newpart = "";
                for (var j = 0, k = part.length; j < k; j++) {
                  if (part.charCodeAt(j) > 127) {
                    newpart += "x";
                  } else {
                    newpart += part[j];
                  }
                }
                if (!newpart.match(hostnamePartPattern)) {
                  var validParts = hostparts.slice(0, i);
                  var notHost = hostparts.slice(i + 1);
                  var bit = part.match(hostnamePartStart);
                  if (bit) {
                    validParts.push(bit[1]);
                    notHost.unshift(bit[2]);
                  }
                  if (notHost.length) {
                    rest = notHost.join(".") + rest;
                  }
                  this.hostname = validParts.join(".");
                  break;
                }
              }
            }
          }
          if (this.hostname.length > hostnameMaxLen) {
            this.hostname = "";
          }
          if (ipv6Hostname) {
            this.hostname = this.hostname.substr(1, this.hostname.length - 2);
          }
        }
        var hash = rest.indexOf("#");
        if (hash !== -1) {
          this.hash = rest.substr(hash);
          rest = rest.slice(0, hash);
        }
        var qm = rest.indexOf("?");
        if (qm !== -1) {
          this.search = rest.substr(qm);
          rest = rest.slice(0, qm);
        }
        if (rest) {
          this.pathname = rest;
        }
        if (slashedProtocol[lowerProto] && this.hostname && !this.pathname) {
          this.pathname = "";
        }
        return this;
      };
      Url.prototype.parseHost = function(host) {
        var port = portPattern.exec(host);
        if (port) {
          port = port[0];
          if (port !== ":") {
            this.port = port.substr(1);
          }
          host = host.substr(0, host.length - port.length);
        }
        if (host) {
          this.hostname = host;
        }
      };
      module.exports = urlParse;
    }
  });

  // node_modules/mdurl/index.js
  var require_mdurl = __commonJS({
    "node_modules/mdurl/index.js"(exports, module) {
      "use strict";
      module.exports.encode = require_encode();
      module.exports.decode = require_decode();
      module.exports.format = require_format();
      module.exports.parse = require_parse();
    }
  });

  // node_modules/uc.micro/properties/Any/regex.js
  var require_regex2 = __commonJS({
    "node_modules/uc.micro/properties/Any/regex.js"(exports, module) {
      module.exports = /[\0-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/;
    }
  });

  // node_modules/uc.micro/categories/Cc/regex.js
  var require_regex3 = __commonJS({
    "node_modules/uc.micro/categories/Cc/regex.js"(exports, module) {
      module.exports = /[\0-\x1F\x7F-\x9F]/;
    }
  });

  // node_modules/uc.micro/categories/Cf/regex.js
  var require_regex4 = __commonJS({
    "node_modules/uc.micro/categories/Cf/regex.js"(exports, module) {
      module.exports = /[\xAD\u0600-\u0605\u061C\u06DD\u070F\u08E2\u180E\u200B-\u200F\u202A-\u202E\u2060-\u2064\u2066-\u206F\uFEFF\uFFF9-\uFFFB]|\uD804[\uDCBD\uDCCD]|\uD82F[\uDCA0-\uDCA3]|\uD834[\uDD73-\uDD7A]|\uDB40[\uDC01\uDC20-\uDC7F]/;
    }
  });

  // node_modules/uc.micro/categories/Z/regex.js
  var require_regex5 = __commonJS({
    "node_modules/uc.micro/categories/Z/regex.js"(exports, module) {
      module.exports = /[ \xA0\u1680\u2000-\u200A\u2028\u2029\u202F\u205F\u3000]/;
    }
  });

  // node_modules/uc.micro/index.js
  var require_uc = __commonJS({
    "node_modules/uc.micro/index.js"(exports) {
      "use strict";
      exports.Any = require_regex2();
      exports.Cc = require_regex3();
      exports.Cf = require_regex4();
      exports.P = require_regex();
      exports.Z = require_regex5();
    }
  });

  // node_modules/markdown-it/lib/common/utils.js
  var require_utils = __commonJS({
    "node_modules/markdown-it/lib/common/utils.js"(exports) {
      "use strict";
      function _class(obj) {
        return Object.prototype.toString.call(obj);
      }
      function isString(obj) {
        return _class(obj) === "[object String]";
      }
      var _hasOwnProperty = Object.prototype.hasOwnProperty;
      function has(object, key) {
        return _hasOwnProperty.call(object, key);
      }
      function assign(obj) {
        var sources = Array.prototype.slice.call(arguments, 1);
        sources.forEach(function(source) {
          if (!source) {
            return;
          }
          if (typeof source !== "object") {
            throw new TypeError(source + "must be object");
          }
          Object.keys(source).forEach(function(key) {
            obj[key] = source[key];
          });
        });
        return obj;
      }
      function arrayReplaceAt(src, pos, newElements) {
        return [].concat(src.slice(0, pos), newElements, src.slice(pos + 1));
      }
      function isValidEntityCode(c) {
        if (c >= 55296 && c <= 57343) {
          return false;
        }
        if (c >= 64976 && c <= 65007) {
          return false;
        }
        if ((c & 65535) === 65535 || (c & 65535) === 65534) {
          return false;
        }
        if (c >= 0 && c <= 8) {
          return false;
        }
        if (c === 11) {
          return false;
        }
        if (c >= 14 && c <= 31) {
          return false;
        }
        if (c >= 127 && c <= 159) {
          return false;
        }
        if (c > 1114111) {
          return false;
        }
        return true;
      }
      function fromCodePoint(c) {
        if (c > 65535) {
          c -= 65536;
          var surrogate1 = 55296 + (c >> 10), surrogate2 = 56320 + (c & 1023);
          return String.fromCharCode(surrogate1, surrogate2);
        }
        return String.fromCharCode(c);
      }
      var UNESCAPE_MD_RE = /\\([!"#$%&'()*+,\-.\/:;<=>?@[\\\]^_`{|}~])/g;
      var ENTITY_RE = /&([a-z#][a-z0-9]{1,31});/gi;
      var UNESCAPE_ALL_RE = new RegExp(UNESCAPE_MD_RE.source + "|" + ENTITY_RE.source, "gi");
      var DIGITAL_ENTITY_TEST_RE = /^#((?:x[a-f0-9]{1,8}|[0-9]{1,8}))/i;
      var entities = require_entities2();
      function replaceEntityPattern(match, name) {
        var code = 0;
        if (has(entities, name)) {
          return entities[name];
        }
        if (name.charCodeAt(0) === 35 && DIGITAL_ENTITY_TEST_RE.test(name)) {
          code = name[1].toLowerCase() === "x" ? parseInt(name.slice(2), 16) : parseInt(name.slice(1), 10);
          if (isValidEntityCode(code)) {
            return fromCodePoint(code);
          }
        }
        return match;
      }
      function unescapeMd(str) {
        if (str.indexOf("\\") < 0) {
          return str;
        }
        return str.replace(UNESCAPE_MD_RE, "$1");
      }
      function unescapeAll(str) {
        if (str.indexOf("\\") < 0 && str.indexOf("&") < 0) {
          return str;
        }
        return str.replace(UNESCAPE_ALL_RE, function(match, escaped, entity) {
          if (escaped) {
            return escaped;
          }
          return replaceEntityPattern(match, entity);
        });
      }
      var HTML_ESCAPE_TEST_RE = /[&<>"]/;
      var HTML_ESCAPE_REPLACE_RE = /[&<>"]/g;
      var HTML_REPLACEMENTS = {
        "&": "&amp;",
        "<": "&lt;",
        ">": "&gt;",
        '"': "&quot;"
      };
      function replaceUnsafeChar(ch) {
        return HTML_REPLACEMENTS[ch];
      }
      function escapeHtml(str) {
        if (HTML_ESCAPE_TEST_RE.test(str)) {
          return str.replace(HTML_ESCAPE_REPLACE_RE, replaceUnsafeChar);
        }
        return str;
      }
      var REGEXP_ESCAPE_RE = /[.?*+^$[\]\\(){}|-]/g;
      function escapeRE(str) {
        return str.replace(REGEXP_ESCAPE_RE, "\\$&");
      }
      function isSpace(code) {
        switch (code) {
          case 9:
          case 32:
            return true;
        }
        return false;
      }
      function isWhiteSpace(code) {
        if (code >= 8192 && code <= 8202) {
          return true;
        }
        switch (code) {
          case 9:
          case 10:
          case 11:
          case 12:
          case 13:
          case 32:
          case 160:
          case 5760:
          case 8239:
          case 8287:
          case 12288:
            return true;
        }
        return false;
      }
      var UNICODE_PUNCT_RE = require_regex();
      function isPunctChar(ch) {
        return UNICODE_PUNCT_RE.test(ch);
      }
      function isMdAsciiPunct(ch) {
        switch (ch) {
          case 33:
          case 34:
          case 35:
          case 36:
          case 37:
          case 38:
          case 39:
          case 40:
          case 41:
          case 42:
          case 43:
          case 44:
          case 45:
          case 46:
          case 47:
          case 58:
          case 59:
          case 60:
          case 61:
          case 62:
          case 63:
          case 64:
          case 91:
          case 92:
          case 93:
          case 94:
          case 95:
          case 96:
          case 123:
          case 124:
          case 125:
          case 126:
            return true;
          default:
            return false;
        }
      }
      function normalizeReference(str) {
        str = str.trim().replace(/\s+/g, " ");
        if ("\u1E9E".toLowerCase() === "\u1E7E") {
          str = str.replace(/ẞ/g, "\xDF");
        }
        return str.toLowerCase().toUpperCase();
      }
      exports.lib = {};
      exports.lib.mdurl = require_mdurl();
      exports.lib.ucmicro = require_uc();
      exports.assign = assign;
      exports.isString = isString;
      exports.has = has;
      exports.unescapeMd = unescapeMd;
      exports.unescapeAll = unescapeAll;
      exports.isValidEntityCode = isValidEntityCode;
      exports.fromCodePoint = fromCodePoint;
      exports.escapeHtml = escapeHtml;
      exports.arrayReplaceAt = arrayReplaceAt;
      exports.isSpace = isSpace;
      exports.isWhiteSpace = isWhiteSpace;
      exports.isMdAsciiPunct = isMdAsciiPunct;
      exports.isPunctChar = isPunctChar;
      exports.escapeRE = escapeRE;
      exports.normalizeReference = normalizeReference;
    }
  });

  // node_modules/markdown-it/lib/helpers/parse_link_label.js
  var require_parse_link_label = __commonJS({
    "node_modules/markdown-it/lib/helpers/parse_link_label.js"(exports, module) {
      "use strict";
      module.exports = function parseLinkLabel(state, start, disableNested) {
        var level, found, marker, prevPos, labelEnd = -1, max = state.posMax, oldPos = state.pos;
        state.pos = start + 1;
        level = 1;
        while (state.pos < max) {
          marker = state.src.charCodeAt(state.pos);
          if (marker === 93) {
            level--;
            if (level === 0) {
              found = true;
              break;
            }
          }
          prevPos = state.pos;
          state.md.inline.skipToken(state);
          if (marker === 91) {
            if (prevPos === state.pos - 1) {
              level++;
            } else if (disableNested) {
              state.pos = oldPos;
              return -1;
            }
          }
        }
        if (found) {
          labelEnd = state.pos;
        }
        state.pos = oldPos;
        return labelEnd;
      };
    }
  });

  // node_modules/markdown-it/lib/helpers/parse_link_destination.js
  var require_parse_link_destination = __commonJS({
    "node_modules/markdown-it/lib/helpers/parse_link_destination.js"(exports, module) {
      "use strict";
      var unescapeAll = require_utils().unescapeAll;
      module.exports = function parseLinkDestination(str, pos, max) {
        var code, level, lines = 0, start = pos, result = {
          ok: false,
          pos: 0,
          lines: 0,
          str: ""
        };
        if (str.charCodeAt(pos) === 60) {
          pos++;
          while (pos < max) {
            code = str.charCodeAt(pos);
            if (code === 10) {
              return result;
            }
            if (code === 60) {
              return result;
            }
            if (code === 62) {
              result.pos = pos + 1;
              result.str = unescapeAll(str.slice(start + 1, pos));
              result.ok = true;
              return result;
            }
            if (code === 92 && pos + 1 < max) {
              pos += 2;
              continue;
            }
            pos++;
          }
          return result;
        }
        level = 0;
        while (pos < max) {
          code = str.charCodeAt(pos);
          if (code === 32) {
            break;
          }
          if (code < 32 || code === 127) {
            break;
          }
          if (code === 92 && pos + 1 < max) {
            if (str.charCodeAt(pos + 1) === 32) {
              break;
            }
            pos += 2;
            continue;
          }
          if (code === 40) {
            level++;
            if (level > 32) {
              return result;
            }
          }
          if (code === 41) {
            if (level === 0) {
              break;
            }
            level--;
          }
          pos++;
        }
        if (start === pos) {
          return result;
        }
        if (level !== 0) {
          return result;
        }
        result.str = unescapeAll(str.slice(start, pos));
        result.lines = lines;
        result.pos = pos;
        result.ok = true;
        return result;
      };
    }
  });

  // node_modules/markdown-it/lib/helpers/parse_link_title.js
  var require_parse_link_title = __commonJS({
    "node_modules/markdown-it/lib/helpers/parse_link_title.js"(exports, module) {
      "use strict";
      var unescapeAll = require_utils().unescapeAll;
      module.exports = function parseLinkTitle(str, pos, max) {
        var code, marker, lines = 0, start = pos, result = {
          ok: false,
          pos: 0,
          lines: 0,
          str: ""
        };
        if (pos >= max) {
          return result;
        }
        marker = str.charCodeAt(pos);
        if (marker !== 34 && marker !== 39 && marker !== 40) {
          return result;
        }
        pos++;
        if (marker === 40) {
          marker = 41;
        }
        while (pos < max) {
          code = str.charCodeAt(pos);
          if (code === marker) {
            result.pos = pos + 1;
            result.lines = lines;
            result.str = unescapeAll(str.slice(start + 1, pos));
            result.ok = true;
            return result;
          } else if (code === 40 && marker === 41) {
            return result;
          } else if (code === 10) {
            lines++;
          } else if (code === 92 && pos + 1 < max) {
            pos++;
            if (str.charCodeAt(pos) === 10) {
              lines++;
            }
          }
          pos++;
        }
        return result;
      };
    }
  });

  // node_modules/markdown-it/lib/helpers/index.js
  var require_helpers = __commonJS({
    "node_modules/markdown-it/lib/helpers/index.js"(exports) {
      "use strict";
      exports.parseLinkLabel = require_parse_link_label();
      exports.parseLinkDestination = require_parse_link_destination();
      exports.parseLinkTitle = require_parse_link_title();
    }
  });

  // node_modules/markdown-it/lib/renderer.js
  var require_renderer = __commonJS({
    "node_modules/markdown-it/lib/renderer.js"(exports, module) {
      "use strict";
      var assign = require_utils().assign;
      var unescapeAll = require_utils().unescapeAll;
      var escapeHtml = require_utils().escapeHtml;
      var default_rules = {};
      default_rules.code_inline = function(tokens, idx, options, env, slf) {
        var token = tokens[idx];
        return "<code" + slf.renderAttrs(token) + ">" + escapeHtml(tokens[idx].content) + "</code>";
      };
      default_rules.code_block = function(tokens, idx, options, env, slf) {
        var token = tokens[idx];
        return "<pre" + slf.renderAttrs(token) + "><code>" + escapeHtml(tokens[idx].content) + "</code></pre>\n";
      };
      default_rules.fence = function(tokens, idx, options, env, slf) {
        var token = tokens[idx], info = token.info ? unescapeAll(token.info).trim() : "", langName = "", langAttrs = "", highlighted, i, arr, tmpAttrs, tmpToken;
        if (info) {
          arr = info.split(/(\s+)/g);
          langName = arr[0];
          langAttrs = arr.slice(2).join("");
        }
        if (options.highlight) {
          highlighted = options.highlight(token.content, langName, langAttrs) || escapeHtml(token.content);
        } else {
          highlighted = escapeHtml(token.content);
        }
        if (highlighted.indexOf("<pre") === 0) {
          return highlighted + "\n";
        }
        if (info) {
          i = token.attrIndex("class");
          tmpAttrs = token.attrs ? token.attrs.slice() : [];
          if (i < 0) {
            tmpAttrs.push(["class", options.langPrefix + langName]);
          } else {
            tmpAttrs[i] = tmpAttrs[i].slice();
            tmpAttrs[i][1] += " " + options.langPrefix + langName;
          }
          tmpToken = {
            attrs: tmpAttrs
          };
          return "<pre><code" + slf.renderAttrs(tmpToken) + ">" + highlighted + "</code></pre>\n";
        }
        return "<pre><code" + slf.renderAttrs(token) + ">" + highlighted + "</code></pre>\n";
      };
      default_rules.image = function(tokens, idx, options, env, slf) {
        var token = tokens[idx];
        token.attrs[token.attrIndex("alt")][1] = slf.renderInlineAsText(token.children, options, env);
        return slf.renderToken(tokens, idx, options);
      };
      default_rules.hardbreak = function(tokens, idx, options) {
        return options.xhtmlOut ? "<br />\n" : "<br>\n";
      };
      default_rules.softbreak = function(tokens, idx, options) {
        return options.breaks ? options.xhtmlOut ? "<br />\n" : "<br>\n" : "\n";
      };
      default_rules.text = function(tokens, idx) {
        return escapeHtml(tokens[idx].content);
      };
      default_rules.html_block = function(tokens, idx) {
        return tokens[idx].content;
      };
      default_rules.html_inline = function(tokens, idx) {
        return tokens[idx].content;
      };
      function Renderer() {
        this.rules = assign({}, default_rules);
      }
      Renderer.prototype.renderAttrs = function renderAttrs(token) {
        var i, l, result;
        if (!token.attrs) {
          return "";
        }
        result = "";
        for (i = 0, l = token.attrs.length; i < l; i++) {
          result += " " + escapeHtml(token.attrs[i][0]) + '="' + escapeHtml(token.attrs[i][1]) + '"';
        }
        return result;
      };
      Renderer.prototype.renderToken = function renderToken(tokens, idx, options) {
        var nextToken, result = "", needLf = false, token = tokens[idx];
        if (token.hidden) {
          return "";
        }
        if (token.block && token.nesting !== -1 && idx && tokens[idx - 1].hidden) {
          result += "\n";
        }
        result += (token.nesting === -1 ? "</" : "<") + token.tag;
        result += this.renderAttrs(token);
        if (token.nesting === 0 && options.xhtmlOut) {
          result += " /";
        }
        if (token.block) {
          needLf = true;
          if (token.nesting === 1) {
            if (idx + 1 < tokens.length) {
              nextToken = tokens[idx + 1];
              if (nextToken.type === "inline" || nextToken.hidden) {
                needLf = false;
              } else if (nextToken.nesting === -1 && nextToken.tag === token.tag) {
                needLf = false;
              }
            }
          }
        }
        result += needLf ? ">\n" : ">";
        return result;
      };
      Renderer.prototype.renderInline = function(tokens, options, env) {
        var type, result = "", rules = this.rules;
        for (var i = 0, len = tokens.length; i < len; i++) {
          type = tokens[i].type;
          if (typeof rules[type] !== "undefined") {
            result += rules[type](tokens, i, options, env, this);
          } else {
            result += this.renderToken(tokens, i, options);
          }
        }
        return result;
      };
      Renderer.prototype.renderInlineAsText = function(tokens, options, env) {
        var result = "";
        for (var i = 0, len = tokens.length; i < len; i++) {
          if (tokens[i].type === "text") {
            result += tokens[i].content;
          } else if (tokens[i].type === "image") {
            result += this.renderInlineAsText(tokens[i].children, options, env);
          } else if (tokens[i].type === "softbreak") {
            result += "\n";
          }
        }
        return result;
      };
      Renderer.prototype.render = function(tokens, options, env) {
        var i, len, type, result = "", rules = this.rules;
        for (i = 0, len = tokens.length; i < len; i++) {
          type = tokens[i].type;
          if (type === "inline") {
            result += this.renderInline(tokens[i].children, options, env);
          } else if (typeof rules[type] !== "undefined") {
            result += rules[tokens[i].type](tokens, i, options, env, this);
          } else {
            result += this.renderToken(tokens, i, options, env);
          }
        }
        return result;
      };
      module.exports = Renderer;
    }
  });

  // node_modules/markdown-it/lib/ruler.js
  var require_ruler = __commonJS({
    "node_modules/markdown-it/lib/ruler.js"(exports, module) {
      "use strict";
      function Ruler() {
        this.__rules__ = [];
        this.__cache__ = null;
      }
      Ruler.prototype.__find__ = function(name) {
        for (var i = 0; i < this.__rules__.length; i++) {
          if (this.__rules__[i].name === name) {
            return i;
          }
        }
        return -1;
      };
      Ruler.prototype.__compile__ = function() {
        var self2 = this;
        var chains = [""];
        self2.__rules__.forEach(function(rule) {
          if (!rule.enabled) {
            return;
          }
          rule.alt.forEach(function(altName) {
            if (chains.indexOf(altName) < 0) {
              chains.push(altName);
            }
          });
        });
        self2.__cache__ = {};
        chains.forEach(function(chain) {
          self2.__cache__[chain] = [];
          self2.__rules__.forEach(function(rule) {
            if (!rule.enabled) {
              return;
            }
            if (chain && rule.alt.indexOf(chain) < 0) {
              return;
            }
            self2.__cache__[chain].push(rule.fn);
          });
        });
      };
      Ruler.prototype.at = function(name, fn, options) {
        var index = this.__find__(name);
        var opt = options || {};
        if (index === -1) {
          throw new Error("Parser rule not found: " + name);
        }
        this.__rules__[index].fn = fn;
        this.__rules__[index].alt = opt.alt || [];
        this.__cache__ = null;
      };
      Ruler.prototype.before = function(beforeName, ruleName, fn, options) {
        var index = this.__find__(beforeName);
        var opt = options || {};
        if (index === -1) {
          throw new Error("Parser rule not found: " + beforeName);
        }
        this.__rules__.splice(index, 0, {
          name: ruleName,
          enabled: true,
          fn,
          alt: opt.alt || []
        });
        this.__cache__ = null;
      };
      Ruler.prototype.after = function(afterName, ruleName, fn, options) {
        var index = this.__find__(afterName);
        var opt = options || {};
        if (index === -1) {
          throw new Error("Parser rule not found: " + afterName);
        }
        this.__rules__.splice(index + 1, 0, {
          name: ruleName,
          enabled: true,
          fn,
          alt: opt.alt || []
        });
        this.__cache__ = null;
      };
      Ruler.prototype.push = function(ruleName, fn, options) {
        var opt = options || {};
        this.__rules__.push({
          name: ruleName,
          enabled: true,
          fn,
          alt: opt.alt || []
        });
        this.__cache__ = null;
      };
      Ruler.prototype.enable = function(list, ignoreInvalid) {
        if (!Array.isArray(list)) {
          list = [list];
        }
        var result = [];
        list.forEach(function(name) {
          var idx = this.__find__(name);
          if (idx < 0) {
            if (ignoreInvalid) {
              return;
            }
            throw new Error("Rules manager: invalid rule name " + name);
          }
          this.__rules__[idx].enabled = true;
          result.push(name);
        }, this);
        this.__cache__ = null;
        return result;
      };
      Ruler.prototype.enableOnly = function(list, ignoreInvalid) {
        if (!Array.isArray(list)) {
          list = [list];
        }
        this.__rules__.forEach(function(rule) {
          rule.enabled = false;
        });
        this.enable(list, ignoreInvalid);
      };
      Ruler.prototype.disable = function(list, ignoreInvalid) {
        if (!Array.isArray(list)) {
          list = [list];
        }
        var result = [];
        list.forEach(function(name) {
          var idx = this.__find__(name);
          if (idx < 0) {
            if (ignoreInvalid) {
              return;
            }
            throw new Error("Rules manager: invalid rule name " + name);
          }
          this.__rules__[idx].enabled = false;
          result.push(name);
        }, this);
        this.__cache__ = null;
        return result;
      };
      Ruler.prototype.getRules = function(chainName) {
        if (this.__cache__ === null) {
          this.__compile__();
        }
        return this.__cache__[chainName] || [];
      };
      module.exports = Ruler;
    }
  });

  // node_modules/markdown-it/lib/rules_core/normalize.js
  var require_normalize = __commonJS({
    "node_modules/markdown-it/lib/rules_core/normalize.js"(exports, module) {
      "use strict";
      var NEWLINES_RE = /\r\n?|\n/g;
      var NULL_RE = /\0/g;
      module.exports = function normalize(state) {
        var str;
        str = state.src.replace(NEWLINES_RE, "\n");
        str = str.replace(NULL_RE, "\uFFFD");
        state.src = str;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_core/block.js
  var require_block = __commonJS({
    "node_modules/markdown-it/lib/rules_core/block.js"(exports, module) {
      "use strict";
      module.exports = function block(state) {
        var token;
        if (state.inlineMode) {
          token = new state.Token("inline", "", 0);
          token.content = state.src;
          token.map = [0, 1];
          token.children = [];
          state.tokens.push(token);
        } else {
          state.md.block.parse(state.src, state.md, state.env, state.tokens);
        }
      };
    }
  });

  // node_modules/markdown-it/lib/rules_core/inline.js
  var require_inline = __commonJS({
    "node_modules/markdown-it/lib/rules_core/inline.js"(exports, module) {
      "use strict";
      module.exports = function inline(state) {
        var tokens = state.tokens, tok, i, l;
        for (i = 0, l = tokens.length; i < l; i++) {
          tok = tokens[i];
          if (tok.type === "inline") {
            state.md.inline.parse(tok.content, state.md, state.env, tok.children);
          }
        }
      };
    }
  });

  // node_modules/markdown-it/lib/rules_core/linkify.js
  var require_linkify = __commonJS({
    "node_modules/markdown-it/lib/rules_core/linkify.js"(exports, module) {
      "use strict";
      var arrayReplaceAt = require_utils().arrayReplaceAt;
      function isLinkOpen(str) {
        return /^<a[>\s]/i.test(str);
      }
      function isLinkClose(str) {
        return /^<\/a\s*>/i.test(str);
      }
      module.exports = function linkify(state) {
        var i, j, l, tokens, token, currentToken, nodes, ln, text, pos, lastPos, level, htmlLinkLevel, url, fullUrl, urlText, blockTokens = state.tokens, links;
        if (!state.md.options.linkify) {
          return;
        }
        for (j = 0, l = blockTokens.length; j < l; j++) {
          if (blockTokens[j].type !== "inline" || !state.md.linkify.pretest(blockTokens[j].content)) {
            continue;
          }
          tokens = blockTokens[j].children;
          htmlLinkLevel = 0;
          for (i = tokens.length - 1; i >= 0; i--) {
            currentToken = tokens[i];
            if (currentToken.type === "link_close") {
              i--;
              while (tokens[i].level !== currentToken.level && tokens[i].type !== "link_open") {
                i--;
              }
              continue;
            }
            if (currentToken.type === "html_inline") {
              if (isLinkOpen(currentToken.content) && htmlLinkLevel > 0) {
                htmlLinkLevel--;
              }
              if (isLinkClose(currentToken.content)) {
                htmlLinkLevel++;
              }
            }
            if (htmlLinkLevel > 0) {
              continue;
            }
            if (currentToken.type === "text" && state.md.linkify.test(currentToken.content)) {
              text = currentToken.content;
              links = state.md.linkify.match(text);
              nodes = [];
              level = currentToken.level;
              lastPos = 0;
              if (links.length > 0 && links[0].index === 0 && i > 0 && tokens[i - 1].type === "text_special") {
                links = links.slice(1);
              }
              for (ln = 0; ln < links.length; ln++) {
                url = links[ln].url;
                fullUrl = state.md.normalizeLink(url);
                if (!state.md.validateLink(fullUrl)) {
                  continue;
                }
                urlText = links[ln].text;
                if (!links[ln].schema) {
                  urlText = state.md.normalizeLinkText("http://" + urlText).replace(/^http:\/\//, "");
                } else if (links[ln].schema === "mailto:" && !/^mailto:/i.test(urlText)) {
                  urlText = state.md.normalizeLinkText("mailto:" + urlText).replace(/^mailto:/, "");
                } else {
                  urlText = state.md.normalizeLinkText(urlText);
                }
                pos = links[ln].index;
                if (pos > lastPos) {
                  token = new state.Token("text", "", 0);
                  token.content = text.slice(lastPos, pos);
                  token.level = level;
                  nodes.push(token);
                }
                token = new state.Token("link_open", "a", 1);
                token.attrs = [["href", fullUrl]];
                token.level = level++;
                token.markup = "linkify";
                token.info = "auto";
                nodes.push(token);
                token = new state.Token("text", "", 0);
                token.content = urlText;
                token.level = level;
                nodes.push(token);
                token = new state.Token("link_close", "a", -1);
                token.level = --level;
                token.markup = "linkify";
                token.info = "auto";
                nodes.push(token);
                lastPos = links[ln].lastIndex;
              }
              if (lastPos < text.length) {
                token = new state.Token("text", "", 0);
                token.content = text.slice(lastPos);
                token.level = level;
                nodes.push(token);
              }
              blockTokens[j].children = tokens = arrayReplaceAt(tokens, i, nodes);
            }
          }
        }
      };
    }
  });

  // node_modules/markdown-it/lib/rules_core/replacements.js
  var require_replacements = __commonJS({
    "node_modules/markdown-it/lib/rules_core/replacements.js"(exports, module) {
      "use strict";
      var RARE_RE = /\+-|\.\.|\?\?\?\?|!!!!|,,|--/;
      var SCOPED_ABBR_TEST_RE = /\((c|tm|r)\)/i;
      var SCOPED_ABBR_RE = /\((c|tm|r)\)/ig;
      var SCOPED_ABBR = {
        c: "\xA9",
        r: "\xAE",
        tm: "\u2122"
      };
      function replaceFn(match, name) {
        return SCOPED_ABBR[name.toLowerCase()];
      }
      function replace_scoped(inlineTokens) {
        var i, token, inside_autolink = 0;
        for (i = inlineTokens.length - 1; i >= 0; i--) {
          token = inlineTokens[i];
          if (token.type === "text" && !inside_autolink) {
            token.content = token.content.replace(SCOPED_ABBR_RE, replaceFn);
          }
          if (token.type === "link_open" && token.info === "auto") {
            inside_autolink--;
          }
          if (token.type === "link_close" && token.info === "auto") {
            inside_autolink++;
          }
        }
      }
      function replace_rare(inlineTokens) {
        var i, token, inside_autolink = 0;
        for (i = inlineTokens.length - 1; i >= 0; i--) {
          token = inlineTokens[i];
          if (token.type === "text" && !inside_autolink) {
            if (RARE_RE.test(token.content)) {
              token.content = token.content.replace(/\+-/g, "\xB1").replace(/\.{2,}/g, "\u2026").replace(/([?!])…/g, "$1..").replace(/([?!]){4,}/g, "$1$1$1").replace(/,{2,}/g, ",").replace(/(^|[^-])---(?=[^-]|$)/mg, "$1\u2014").replace(/(^|\s)--(?=\s|$)/mg, "$1\u2013").replace(/(^|[^-\s])--(?=[^-\s]|$)/mg, "$1\u2013");
            }
          }
          if (token.type === "link_open" && token.info === "auto") {
            inside_autolink--;
          }
          if (token.type === "link_close" && token.info === "auto") {
            inside_autolink++;
          }
        }
      }
      module.exports = function replace(state) {
        var blkIdx;
        if (!state.md.options.typographer) {
          return;
        }
        for (blkIdx = state.tokens.length - 1; blkIdx >= 0; blkIdx--) {
          if (state.tokens[blkIdx].type !== "inline") {
            continue;
          }
          if (SCOPED_ABBR_TEST_RE.test(state.tokens[blkIdx].content)) {
            replace_scoped(state.tokens[blkIdx].children);
          }
          if (RARE_RE.test(state.tokens[blkIdx].content)) {
            replace_rare(state.tokens[blkIdx].children);
          }
        }
      };
    }
  });

  // node_modules/markdown-it/lib/rules_core/smartquotes.js
  var require_smartquotes = __commonJS({
    "node_modules/markdown-it/lib/rules_core/smartquotes.js"(exports, module) {
      "use strict";
      var isWhiteSpace = require_utils().isWhiteSpace;
      var isPunctChar = require_utils().isPunctChar;
      var isMdAsciiPunct = require_utils().isMdAsciiPunct;
      var QUOTE_TEST_RE = /['"]/;
      var QUOTE_RE = /['"]/g;
      var APOSTROPHE = "\u2019";
      function replaceAt(str, index, ch) {
        return str.slice(0, index) + ch + str.slice(index + 1);
      }
      function process_inlines(tokens, state) {
        var i, token, text, t, pos, max, thisLevel, item, lastChar, nextChar, isLastPunctChar, isNextPunctChar, isLastWhiteSpace, isNextWhiteSpace, canOpen, canClose, j, isSingle, stack, openQuote, closeQuote;
        stack = [];
        for (i = 0; i < tokens.length; i++) {
          token = tokens[i];
          thisLevel = tokens[i].level;
          for (j = stack.length - 1; j >= 0; j--) {
            if (stack[j].level <= thisLevel) {
              break;
            }
          }
          stack.length = j + 1;
          if (token.type !== "text") {
            continue;
          }
          text = token.content;
          pos = 0;
          max = text.length;
          OUTER:
            while (pos < max) {
              QUOTE_RE.lastIndex = pos;
              t = QUOTE_RE.exec(text);
              if (!t) {
                break;
              }
              canOpen = canClose = true;
              pos = t.index + 1;
              isSingle = t[0] === "'";
              lastChar = 32;
              if (t.index - 1 >= 0) {
                lastChar = text.charCodeAt(t.index - 1);
              } else {
                for (j = i - 1; j >= 0; j--) {
                  if (tokens[j].type === "softbreak" || tokens[j].type === "hardbreak")
                    break;
                  if (!tokens[j].content)
                    continue;
                  lastChar = tokens[j].content.charCodeAt(tokens[j].content.length - 1);
                  break;
                }
              }
              nextChar = 32;
              if (pos < max) {
                nextChar = text.charCodeAt(pos);
              } else {
                for (j = i + 1; j < tokens.length; j++) {
                  if (tokens[j].type === "softbreak" || tokens[j].type === "hardbreak")
                    break;
                  if (!tokens[j].content)
                    continue;
                  nextChar = tokens[j].content.charCodeAt(0);
                  break;
                }
              }
              isLastPunctChar = isMdAsciiPunct(lastChar) || isPunctChar(String.fromCharCode(lastChar));
              isNextPunctChar = isMdAsciiPunct(nextChar) || isPunctChar(String.fromCharCode(nextChar));
              isLastWhiteSpace = isWhiteSpace(lastChar);
              isNextWhiteSpace = isWhiteSpace(nextChar);
              if (isNextWhiteSpace) {
                canOpen = false;
              } else if (isNextPunctChar) {
                if (!(isLastWhiteSpace || isLastPunctChar)) {
                  canOpen = false;
                }
              }
              if (isLastWhiteSpace) {
                canClose = false;
              } else if (isLastPunctChar) {
                if (!(isNextWhiteSpace || isNextPunctChar)) {
                  canClose = false;
                }
              }
              if (nextChar === 34 && t[0] === '"') {
                if (lastChar >= 48 && lastChar <= 57) {
                  canClose = canOpen = false;
                }
              }
              if (canOpen && canClose) {
                canOpen = isLastPunctChar;
                canClose = isNextPunctChar;
              }
              if (!canOpen && !canClose) {
                if (isSingle) {
                  token.content = replaceAt(token.content, t.index, APOSTROPHE);
                }
                continue;
              }
              if (canClose) {
                for (j = stack.length - 1; j >= 0; j--) {
                  item = stack[j];
                  if (stack[j].level < thisLevel) {
                    break;
                  }
                  if (item.single === isSingle && stack[j].level === thisLevel) {
                    item = stack[j];
                    if (isSingle) {
                      openQuote = state.md.options.quotes[2];
                      closeQuote = state.md.options.quotes[3];
                    } else {
                      openQuote = state.md.options.quotes[0];
                      closeQuote = state.md.options.quotes[1];
                    }
                    token.content = replaceAt(token.content, t.index, closeQuote);
                    tokens[item.token].content = replaceAt(
                      tokens[item.token].content,
                      item.pos,
                      openQuote
                    );
                    pos += closeQuote.length - 1;
                    if (item.token === i) {
                      pos += openQuote.length - 1;
                    }
                    text = token.content;
                    max = text.length;
                    stack.length = j;
                    continue OUTER;
                  }
                }
              }
              if (canOpen) {
                stack.push({
                  token: i,
                  pos: t.index,
                  single: isSingle,
                  level: thisLevel
                });
              } else if (canClose && isSingle) {
                token.content = replaceAt(token.content, t.index, APOSTROPHE);
              }
            }
        }
      }
      module.exports = function smartquotes(state) {
        var blkIdx;
        if (!state.md.options.typographer) {
          return;
        }
        for (blkIdx = state.tokens.length - 1; blkIdx >= 0; blkIdx--) {
          if (state.tokens[blkIdx].type !== "inline" || !QUOTE_TEST_RE.test(state.tokens[blkIdx].content)) {
            continue;
          }
          process_inlines(state.tokens[blkIdx].children, state);
        }
      };
    }
  });

  // node_modules/markdown-it/lib/rules_core/text_join.js
  var require_text_join = __commonJS({
    "node_modules/markdown-it/lib/rules_core/text_join.js"(exports, module) {
      "use strict";
      module.exports = function text_join(state) {
        var j, l, tokens, curr, max, last, blockTokens = state.tokens;
        for (j = 0, l = blockTokens.length; j < l; j++) {
          if (blockTokens[j].type !== "inline")
            continue;
          tokens = blockTokens[j].children;
          max = tokens.length;
          for (curr = 0; curr < max; curr++) {
            if (tokens[curr].type === "text_special") {
              tokens[curr].type = "text";
            }
          }
          for (curr = last = 0; curr < max; curr++) {
            if (tokens[curr].type === "text" && curr + 1 < max && tokens[curr + 1].type === "text") {
              tokens[curr + 1].content = tokens[curr].content + tokens[curr + 1].content;
            } else {
              if (curr !== last) {
                tokens[last] = tokens[curr];
              }
              last++;
            }
          }
          if (curr !== last) {
            tokens.length = last;
          }
        }
      };
    }
  });

  // node_modules/markdown-it/lib/token.js
  var require_token = __commonJS({
    "node_modules/markdown-it/lib/token.js"(exports, module) {
      "use strict";
      function Token(type, tag, nesting) {
        this.type = type;
        this.tag = tag;
        this.attrs = null;
        this.map = null;
        this.nesting = nesting;
        this.level = 0;
        this.children = null;
        this.content = "";
        this.markup = "";
        this.info = "";
        this.meta = null;
        this.block = false;
        this.hidden = false;
      }
      Token.prototype.attrIndex = function attrIndex(name) {
        var attrs, i, len;
        if (!this.attrs) {
          return -1;
        }
        attrs = this.attrs;
        for (i = 0, len = attrs.length; i < len; i++) {
          if (attrs[i][0] === name) {
            return i;
          }
        }
        return -1;
      };
      Token.prototype.attrPush = function attrPush(attrData) {
        if (this.attrs) {
          this.attrs.push(attrData);
        } else {
          this.attrs = [attrData];
        }
      };
      Token.prototype.attrSet = function attrSet(name, value) {
        var idx = this.attrIndex(name), attrData = [name, value];
        if (idx < 0) {
          this.attrPush(attrData);
        } else {
          this.attrs[idx] = attrData;
        }
      };
      Token.prototype.attrGet = function attrGet(name) {
        var idx = this.attrIndex(name), value = null;
        if (idx >= 0) {
          value = this.attrs[idx][1];
        }
        return value;
      };
      Token.prototype.attrJoin = function attrJoin(name, value) {
        var idx = this.attrIndex(name);
        if (idx < 0) {
          this.attrPush([name, value]);
        } else {
          this.attrs[idx][1] = this.attrs[idx][1] + " " + value;
        }
      };
      module.exports = Token;
    }
  });

  // node_modules/markdown-it/lib/rules_core/state_core.js
  var require_state_core = __commonJS({
    "node_modules/markdown-it/lib/rules_core/state_core.js"(exports, module) {
      "use strict";
      var Token = require_token();
      function StateCore(src, md, env) {
        this.src = src;
        this.env = env;
        this.tokens = [];
        this.inlineMode = false;
        this.md = md;
      }
      StateCore.prototype.Token = Token;
      module.exports = StateCore;
    }
  });

  // node_modules/markdown-it/lib/parser_core.js
  var require_parser_core = __commonJS({
    "node_modules/markdown-it/lib/parser_core.js"(exports, module) {
      "use strict";
      var Ruler = require_ruler();
      var _rules = [
        ["normalize", require_normalize()],
        ["block", require_block()],
        ["inline", require_inline()],
        ["linkify", require_linkify()],
        ["replacements", require_replacements()],
        ["smartquotes", require_smartquotes()],
        // `text_join` finds `text_special` tokens (for escape sequences)
        // and joins them with the rest of the text
        ["text_join", require_text_join()]
      ];
      function Core() {
        this.ruler = new Ruler();
        for (var i = 0; i < _rules.length; i++) {
          this.ruler.push(_rules[i][0], _rules[i][1]);
        }
      }
      Core.prototype.process = function(state) {
        var i, l, rules;
        rules = this.ruler.getRules("");
        for (i = 0, l = rules.length; i < l; i++) {
          rules[i](state);
        }
      };
      Core.prototype.State = require_state_core();
      module.exports = Core;
    }
  });

  // node_modules/markdown-it/lib/rules_block/table.js
  var require_table = __commonJS({
    "node_modules/markdown-it/lib/rules_block/table.js"(exports, module) {
      "use strict";
      var isSpace = require_utils().isSpace;
      function getLine(state, line) {
        var pos = state.bMarks[line] + state.tShift[line], max = state.eMarks[line];
        return state.src.slice(pos, max);
      }
      function escapedSplit(str) {
        var result = [], pos = 0, max = str.length, ch, isEscaped = false, lastPos = 0, current = "";
        ch = str.charCodeAt(pos);
        while (pos < max) {
          if (ch === 124) {
            if (!isEscaped) {
              result.push(current + str.substring(lastPos, pos));
              current = "";
              lastPos = pos + 1;
            } else {
              current += str.substring(lastPos, pos - 1);
              lastPos = pos;
            }
          }
          isEscaped = ch === 92;
          pos++;
          ch = str.charCodeAt(pos);
        }
        result.push(current + str.substring(lastPos));
        return result;
      }
      module.exports = function table(state, startLine, endLine, silent) {
        var ch, lineText, pos, i, l, nextLine, columns, columnCount, token, aligns, t, tableLines, tbodyLines, oldParentType, terminate, terminatorRules, firstCh, secondCh;
        if (startLine + 2 > endLine) {
          return false;
        }
        nextLine = startLine + 1;
        if (state.sCount[nextLine] < state.blkIndent) {
          return false;
        }
        if (state.sCount[nextLine] - state.blkIndent >= 4) {
          return false;
        }
        pos = state.bMarks[nextLine] + state.tShift[nextLine];
        if (pos >= state.eMarks[nextLine]) {
          return false;
        }
        firstCh = state.src.charCodeAt(pos++);
        if (firstCh !== 124 && firstCh !== 45 && firstCh !== 58) {
          return false;
        }
        if (pos >= state.eMarks[nextLine]) {
          return false;
        }
        secondCh = state.src.charCodeAt(pos++);
        if (secondCh !== 124 && secondCh !== 45 && secondCh !== 58 && !isSpace(secondCh)) {
          return false;
        }
        if (firstCh === 45 && isSpace(secondCh)) {
          return false;
        }
        while (pos < state.eMarks[nextLine]) {
          ch = state.src.charCodeAt(pos);
          if (ch !== 124 && ch !== 45 && ch !== 58 && !isSpace(ch)) {
            return false;
          }
          pos++;
        }
        lineText = getLine(state, startLine + 1);
        columns = lineText.split("|");
        aligns = [];
        for (i = 0; i < columns.length; i++) {
          t = columns[i].trim();
          if (!t) {
            if (i === 0 || i === columns.length - 1) {
              continue;
            } else {
              return false;
            }
          }
          if (!/^:?-+:?$/.test(t)) {
            return false;
          }
          if (t.charCodeAt(t.length - 1) === 58) {
            aligns.push(t.charCodeAt(0) === 58 ? "center" : "right");
          } else if (t.charCodeAt(0) === 58) {
            aligns.push("left");
          } else {
            aligns.push("");
          }
        }
        lineText = getLine(state, startLine).trim();
        if (lineText.indexOf("|") === -1) {
          return false;
        }
        if (state.sCount[startLine] - state.blkIndent >= 4) {
          return false;
        }
        columns = escapedSplit(lineText);
        if (columns.length && columns[0] === "")
          columns.shift();
        if (columns.length && columns[columns.length - 1] === "")
          columns.pop();
        columnCount = columns.length;
        if (columnCount === 0 || columnCount !== aligns.length) {
          return false;
        }
        if (silent) {
          return true;
        }
        oldParentType = state.parentType;
        state.parentType = "table";
        terminatorRules = state.md.block.ruler.getRules("blockquote");
        token = state.push("table_open", "table", 1);
        token.map = tableLines = [startLine, 0];
        token = state.push("thead_open", "thead", 1);
        token.map = [startLine, startLine + 1];
        token = state.push("tr_open", "tr", 1);
        token.map = [startLine, startLine + 1];
        for (i = 0; i < columns.length; i++) {
          token = state.push("th_open", "th", 1);
          if (aligns[i]) {
            token.attrs = [["style", "text-align:" + aligns[i]]];
          }
          token = state.push("inline", "", 0);
          token.content = columns[i].trim();
          token.children = [];
          token = state.push("th_close", "th", -1);
        }
        token = state.push("tr_close", "tr", -1);
        token = state.push("thead_close", "thead", -1);
        for (nextLine = startLine + 2; nextLine < endLine; nextLine++) {
          if (state.sCount[nextLine] < state.blkIndent) {
            break;
          }
          terminate = false;
          for (i = 0, l = terminatorRules.length; i < l; i++) {
            if (terminatorRules[i](state, nextLine, endLine, true)) {
              terminate = true;
              break;
            }
          }
          if (terminate) {
            break;
          }
          lineText = getLine(state, nextLine).trim();
          if (!lineText) {
            break;
          }
          if (state.sCount[nextLine] - state.blkIndent >= 4) {
            break;
          }
          columns = escapedSplit(lineText);
          if (columns.length && columns[0] === "")
            columns.shift();
          if (columns.length && columns[columns.length - 1] === "")
            columns.pop();
          if (nextLine === startLine + 2) {
            token = state.push("tbody_open", "tbody", 1);
            token.map = tbodyLines = [startLine + 2, 0];
          }
          token = state.push("tr_open", "tr", 1);
          token.map = [nextLine, nextLine + 1];
          for (i = 0; i < columnCount; i++) {
            token = state.push("td_open", "td", 1);
            if (aligns[i]) {
              token.attrs = [["style", "text-align:" + aligns[i]]];
            }
            token = state.push("inline", "", 0);
            token.content = columns[i] ? columns[i].trim() : "";
            token.children = [];
            token = state.push("td_close", "td", -1);
          }
          token = state.push("tr_close", "tr", -1);
        }
        if (tbodyLines) {
          token = state.push("tbody_close", "tbody", -1);
          tbodyLines[1] = nextLine;
        }
        token = state.push("table_close", "table", -1);
        tableLines[1] = nextLine;
        state.parentType = oldParentType;
        state.line = nextLine;
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_block/code.js
  var require_code = __commonJS({
    "node_modules/markdown-it/lib/rules_block/code.js"(exports, module) {
      "use strict";
      module.exports = function code(state, startLine, endLine) {
        var nextLine, last, token;
        if (state.sCount[startLine] - state.blkIndent < 4) {
          return false;
        }
        last = nextLine = startLine + 1;
        while (nextLine < endLine) {
          if (state.isEmpty(nextLine)) {
            nextLine++;
            continue;
          }
          if (state.sCount[nextLine] - state.blkIndent >= 4) {
            nextLine++;
            last = nextLine;
            continue;
          }
          break;
        }
        state.line = last;
        token = state.push("code_block", "code", 0);
        token.content = state.getLines(startLine, last, 4 + state.blkIndent, false) + "\n";
        token.map = [startLine, state.line];
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_block/fence.js
  var require_fence = __commonJS({
    "node_modules/markdown-it/lib/rules_block/fence.js"(exports, module) {
      "use strict";
      module.exports = function fence(state, startLine, endLine, silent) {
        var marker, len, params, nextLine, mem, token, markup, haveEndMarker = false, pos = state.bMarks[startLine] + state.tShift[startLine], max = state.eMarks[startLine];
        if (state.sCount[startLine] - state.blkIndent >= 4) {
          return false;
        }
        if (pos + 3 > max) {
          return false;
        }
        marker = state.src.charCodeAt(pos);
        if (marker !== 126 && marker !== 96) {
          return false;
        }
        mem = pos;
        pos = state.skipChars(pos, marker);
        len = pos - mem;
        if (len < 3) {
          return false;
        }
        markup = state.src.slice(mem, pos);
        params = state.src.slice(pos, max);
        if (marker === 96) {
          if (params.indexOf(String.fromCharCode(marker)) >= 0) {
            return false;
          }
        }
        if (silent) {
          return true;
        }
        nextLine = startLine;
        for (; ; ) {
          nextLine++;
          if (nextLine >= endLine) {
            break;
          }
          pos = mem = state.bMarks[nextLine] + state.tShift[nextLine];
          max = state.eMarks[nextLine];
          if (pos < max && state.sCount[nextLine] < state.blkIndent) {
            break;
          }
          if (state.src.charCodeAt(pos) !== marker) {
            continue;
          }
          if (state.sCount[nextLine] - state.blkIndent >= 4) {
            continue;
          }
          pos = state.skipChars(pos, marker);
          if (pos - mem < len) {
            continue;
          }
          pos = state.skipSpaces(pos);
          if (pos < max) {
            continue;
          }
          haveEndMarker = true;
          break;
        }
        len = state.sCount[startLine];
        state.line = nextLine + (haveEndMarker ? 1 : 0);
        token = state.push("fence", "code", 0);
        token.info = params;
        token.content = state.getLines(startLine + 1, nextLine, len, true);
        token.markup = markup;
        token.map = [startLine, state.line];
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_block/blockquote.js
  var require_blockquote = __commonJS({
    "node_modules/markdown-it/lib/rules_block/blockquote.js"(exports, module) {
      "use strict";
      var isSpace = require_utils().isSpace;
      module.exports = function blockquote(state, startLine, endLine, silent) {
        var adjustTab, ch, i, initial, l, lastLineEmpty, lines, nextLine, offset, oldBMarks, oldBSCount, oldIndent, oldParentType, oldSCount, oldTShift, spaceAfterMarker, terminate, terminatorRules, token, isOutdented, oldLineMax = state.lineMax, pos = state.bMarks[startLine] + state.tShift[startLine], max = state.eMarks[startLine];
        if (state.sCount[startLine] - state.blkIndent >= 4) {
          return false;
        }
        if (state.src.charCodeAt(pos++) !== 62) {
          return false;
        }
        if (silent) {
          return true;
        }
        initial = offset = state.sCount[startLine] + 1;
        if (state.src.charCodeAt(pos) === 32) {
          pos++;
          initial++;
          offset++;
          adjustTab = false;
          spaceAfterMarker = true;
        } else if (state.src.charCodeAt(pos) === 9) {
          spaceAfterMarker = true;
          if ((state.bsCount[startLine] + offset) % 4 === 3) {
            pos++;
            initial++;
            offset++;
            adjustTab = false;
          } else {
            adjustTab = true;
          }
        } else {
          spaceAfterMarker = false;
        }
        oldBMarks = [state.bMarks[startLine]];
        state.bMarks[startLine] = pos;
        while (pos < max) {
          ch = state.src.charCodeAt(pos);
          if (isSpace(ch)) {
            if (ch === 9) {
              offset += 4 - (offset + state.bsCount[startLine] + (adjustTab ? 1 : 0)) % 4;
            } else {
              offset++;
            }
          } else {
            break;
          }
          pos++;
        }
        oldBSCount = [state.bsCount[startLine]];
        state.bsCount[startLine] = state.sCount[startLine] + 1 + (spaceAfterMarker ? 1 : 0);
        lastLineEmpty = pos >= max;
        oldSCount = [state.sCount[startLine]];
        state.sCount[startLine] = offset - initial;
        oldTShift = [state.tShift[startLine]];
        state.tShift[startLine] = pos - state.bMarks[startLine];
        terminatorRules = state.md.block.ruler.getRules("blockquote");
        oldParentType = state.parentType;
        state.parentType = "blockquote";
        for (nextLine = startLine + 1; nextLine < endLine; nextLine++) {
          isOutdented = state.sCount[nextLine] < state.blkIndent;
          pos = state.bMarks[nextLine] + state.tShift[nextLine];
          max = state.eMarks[nextLine];
          if (pos >= max) {
            break;
          }
          if (state.src.charCodeAt(pos++) === 62 && !isOutdented) {
            initial = offset = state.sCount[nextLine] + 1;
            if (state.src.charCodeAt(pos) === 32) {
              pos++;
              initial++;
              offset++;
              adjustTab = false;
              spaceAfterMarker = true;
            } else if (state.src.charCodeAt(pos) === 9) {
              spaceAfterMarker = true;
              if ((state.bsCount[nextLine] + offset) % 4 === 3) {
                pos++;
                initial++;
                offset++;
                adjustTab = false;
              } else {
                adjustTab = true;
              }
            } else {
              spaceAfterMarker = false;
            }
            oldBMarks.push(state.bMarks[nextLine]);
            state.bMarks[nextLine] = pos;
            while (pos < max) {
              ch = state.src.charCodeAt(pos);
              if (isSpace(ch)) {
                if (ch === 9) {
                  offset += 4 - (offset + state.bsCount[nextLine] + (adjustTab ? 1 : 0)) % 4;
                } else {
                  offset++;
                }
              } else {
                break;
              }
              pos++;
            }
            lastLineEmpty = pos >= max;
            oldBSCount.push(state.bsCount[nextLine]);
            state.bsCount[nextLine] = state.sCount[nextLine] + 1 + (spaceAfterMarker ? 1 : 0);
            oldSCount.push(state.sCount[nextLine]);
            state.sCount[nextLine] = offset - initial;
            oldTShift.push(state.tShift[nextLine]);
            state.tShift[nextLine] = pos - state.bMarks[nextLine];
            continue;
          }
          if (lastLineEmpty) {
            break;
          }
          terminate = false;
          for (i = 0, l = terminatorRules.length; i < l; i++) {
            if (terminatorRules[i](state, nextLine, endLine, true)) {
              terminate = true;
              break;
            }
          }
          if (terminate) {
            state.lineMax = nextLine;
            if (state.blkIndent !== 0) {
              oldBMarks.push(state.bMarks[nextLine]);
              oldBSCount.push(state.bsCount[nextLine]);
              oldTShift.push(state.tShift[nextLine]);
              oldSCount.push(state.sCount[nextLine]);
              state.sCount[nextLine] -= state.blkIndent;
            }
            break;
          }
          oldBMarks.push(state.bMarks[nextLine]);
          oldBSCount.push(state.bsCount[nextLine]);
          oldTShift.push(state.tShift[nextLine]);
          oldSCount.push(state.sCount[nextLine]);
          state.sCount[nextLine] = -1;
        }
        oldIndent = state.blkIndent;
        state.blkIndent = 0;
        token = state.push("blockquote_open", "blockquote", 1);
        token.markup = ">";
        token.map = lines = [startLine, 0];
        state.md.block.tokenize(state, startLine, nextLine);
        token = state.push("blockquote_close", "blockquote", -1);
        token.markup = ">";
        state.lineMax = oldLineMax;
        state.parentType = oldParentType;
        lines[1] = state.line;
        for (i = 0; i < oldTShift.length; i++) {
          state.bMarks[i + startLine] = oldBMarks[i];
          state.tShift[i + startLine] = oldTShift[i];
          state.sCount[i + startLine] = oldSCount[i];
          state.bsCount[i + startLine] = oldBSCount[i];
        }
        state.blkIndent = oldIndent;
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_block/hr.js
  var require_hr = __commonJS({
    "node_modules/markdown-it/lib/rules_block/hr.js"(exports, module) {
      "use strict";
      var isSpace = require_utils().isSpace;
      module.exports = function hr(state, startLine, endLine, silent) {
        var marker, cnt, ch, token, pos = state.bMarks[startLine] + state.tShift[startLine], max = state.eMarks[startLine];
        if (state.sCount[startLine] - state.blkIndent >= 4) {
          return false;
        }
        marker = state.src.charCodeAt(pos++);
        if (marker !== 42 && marker !== 45 && marker !== 95) {
          return false;
        }
        cnt = 1;
        while (pos < max) {
          ch = state.src.charCodeAt(pos++);
          if (ch !== marker && !isSpace(ch)) {
            return false;
          }
          if (ch === marker) {
            cnt++;
          }
        }
        if (cnt < 3) {
          return false;
        }
        if (silent) {
          return true;
        }
        state.line = startLine + 1;
        token = state.push("hr", "hr", 0);
        token.map = [startLine, state.line];
        token.markup = Array(cnt + 1).join(String.fromCharCode(marker));
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_block/list.js
  var require_list = __commonJS({
    "node_modules/markdown-it/lib/rules_block/list.js"(exports, module) {
      "use strict";
      var isSpace = require_utils().isSpace;
      function skipBulletListMarker(state, startLine) {
        var marker, pos, max, ch;
        pos = state.bMarks[startLine] + state.tShift[startLine];
        max = state.eMarks[startLine];
        marker = state.src.charCodeAt(pos++);
        if (marker !== 42 && marker !== 45 && marker !== 43) {
          return -1;
        }
        if (pos < max) {
          ch = state.src.charCodeAt(pos);
          if (!isSpace(ch)) {
            return -1;
          }
        }
        return pos;
      }
      function skipOrderedListMarker(state, startLine) {
        var ch, start = state.bMarks[startLine] + state.tShift[startLine], pos = start, max = state.eMarks[startLine];
        if (pos + 1 >= max) {
          return -1;
        }
        ch = state.src.charCodeAt(pos++);
        if (ch < 48 || ch > 57) {
          return -1;
        }
        for (; ; ) {
          if (pos >= max) {
            return -1;
          }
          ch = state.src.charCodeAt(pos++);
          if (ch >= 48 && ch <= 57) {
            if (pos - start >= 10) {
              return -1;
            }
            continue;
          }
          if (ch === 41 || ch === 46) {
            break;
          }
          return -1;
        }
        if (pos < max) {
          ch = state.src.charCodeAt(pos);
          if (!isSpace(ch)) {
            return -1;
          }
        }
        return pos;
      }
      function markTightParagraphs(state, idx) {
        var i, l, level = state.level + 2;
        for (i = idx + 2, l = state.tokens.length - 2; i < l; i++) {
          if (state.tokens[i].level === level && state.tokens[i].type === "paragraph_open") {
            state.tokens[i + 2].hidden = true;
            state.tokens[i].hidden = true;
            i += 2;
          }
        }
      }
      module.exports = function list(state, startLine, endLine, silent) {
        var ch, contentStart, i, indent, indentAfterMarker, initial, isOrdered, itemLines, l, listLines, listTokIdx, markerCharCode, markerValue, max, nextLine, offset, oldListIndent, oldParentType, oldSCount, oldTShift, oldTight, pos, posAfterMarker, prevEmptyEnd, start, terminate, terminatorRules, token, isTerminatingParagraph = false, tight = true;
        if (state.sCount[startLine] - state.blkIndent >= 4) {
          return false;
        }
        if (state.listIndent >= 0 && state.sCount[startLine] - state.listIndent >= 4 && state.sCount[startLine] < state.blkIndent) {
          return false;
        }
        if (silent && state.parentType === "paragraph") {
          if (state.sCount[startLine] >= state.blkIndent) {
            isTerminatingParagraph = true;
          }
        }
        if ((posAfterMarker = skipOrderedListMarker(state, startLine)) >= 0) {
          isOrdered = true;
          start = state.bMarks[startLine] + state.tShift[startLine];
          markerValue = Number(state.src.slice(start, posAfterMarker - 1));
          if (isTerminatingParagraph && markerValue !== 1)
            return false;
        } else if ((posAfterMarker = skipBulletListMarker(state, startLine)) >= 0) {
          isOrdered = false;
        } else {
          return false;
        }
        if (isTerminatingParagraph) {
          if (state.skipSpaces(posAfterMarker) >= state.eMarks[startLine])
            return false;
        }
        markerCharCode = state.src.charCodeAt(posAfterMarker - 1);
        if (silent) {
          return true;
        }
        listTokIdx = state.tokens.length;
        if (isOrdered) {
          token = state.push("ordered_list_open", "ol", 1);
          if (markerValue !== 1) {
            token.attrs = [["start", markerValue]];
          }
        } else {
          token = state.push("bullet_list_open", "ul", 1);
        }
        token.map = listLines = [startLine, 0];
        token.markup = String.fromCharCode(markerCharCode);
        nextLine = startLine;
        prevEmptyEnd = false;
        terminatorRules = state.md.block.ruler.getRules("list");
        oldParentType = state.parentType;
        state.parentType = "list";
        while (nextLine < endLine) {
          pos = posAfterMarker;
          max = state.eMarks[nextLine];
          initial = offset = state.sCount[nextLine] + posAfterMarker - (state.bMarks[startLine] + state.tShift[startLine]);
          while (pos < max) {
            ch = state.src.charCodeAt(pos);
            if (ch === 9) {
              offset += 4 - (offset + state.bsCount[nextLine]) % 4;
            } else if (ch === 32) {
              offset++;
            } else {
              break;
            }
            pos++;
          }
          contentStart = pos;
          if (contentStart >= max) {
            indentAfterMarker = 1;
          } else {
            indentAfterMarker = offset - initial;
          }
          if (indentAfterMarker > 4) {
            indentAfterMarker = 1;
          }
          indent = initial + indentAfterMarker;
          token = state.push("list_item_open", "li", 1);
          token.markup = String.fromCharCode(markerCharCode);
          token.map = itemLines = [startLine, 0];
          if (isOrdered) {
            token.info = state.src.slice(start, posAfterMarker - 1);
          }
          oldTight = state.tight;
          oldTShift = state.tShift[startLine];
          oldSCount = state.sCount[startLine];
          oldListIndent = state.listIndent;
          state.listIndent = state.blkIndent;
          state.blkIndent = indent;
          state.tight = true;
          state.tShift[startLine] = contentStart - state.bMarks[startLine];
          state.sCount[startLine] = offset;
          if (contentStart >= max && state.isEmpty(startLine + 1)) {
            state.line = Math.min(state.line + 2, endLine);
          } else {
            state.md.block.tokenize(state, startLine, endLine, true);
          }
          if (!state.tight || prevEmptyEnd) {
            tight = false;
          }
          prevEmptyEnd = state.line - startLine > 1 && state.isEmpty(state.line - 1);
          state.blkIndent = state.listIndent;
          state.listIndent = oldListIndent;
          state.tShift[startLine] = oldTShift;
          state.sCount[startLine] = oldSCount;
          state.tight = oldTight;
          token = state.push("list_item_close", "li", -1);
          token.markup = String.fromCharCode(markerCharCode);
          nextLine = startLine = state.line;
          itemLines[1] = nextLine;
          contentStart = state.bMarks[startLine];
          if (nextLine >= endLine) {
            break;
          }
          if (state.sCount[nextLine] < state.blkIndent) {
            break;
          }
          if (state.sCount[startLine] - state.blkIndent >= 4) {
            break;
          }
          terminate = false;
          for (i = 0, l = terminatorRules.length; i < l; i++) {
            if (terminatorRules[i](state, nextLine, endLine, true)) {
              terminate = true;
              break;
            }
          }
          if (terminate) {
            break;
          }
          if (isOrdered) {
            posAfterMarker = skipOrderedListMarker(state, nextLine);
            if (posAfterMarker < 0) {
              break;
            }
            start = state.bMarks[nextLine] + state.tShift[nextLine];
          } else {
            posAfterMarker = skipBulletListMarker(state, nextLine);
            if (posAfterMarker < 0) {
              break;
            }
          }
          if (markerCharCode !== state.src.charCodeAt(posAfterMarker - 1)) {
            break;
          }
        }
        if (isOrdered) {
          token = state.push("ordered_list_close", "ol", -1);
        } else {
          token = state.push("bullet_list_close", "ul", -1);
        }
        token.markup = String.fromCharCode(markerCharCode);
        listLines[1] = nextLine;
        state.line = nextLine;
        state.parentType = oldParentType;
        if (tight) {
          markTightParagraphs(state, listTokIdx);
        }
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_block/reference.js
  var require_reference = __commonJS({
    "node_modules/markdown-it/lib/rules_block/reference.js"(exports, module) {
      "use strict";
      var normalizeReference = require_utils().normalizeReference;
      var isSpace = require_utils().isSpace;
      module.exports = function reference(state, startLine, _endLine, silent) {
        var ch, destEndPos, destEndLineNo, endLine, href, i, l, label, labelEnd, oldParentType, res, start, str, terminate, terminatorRules, title, lines = 0, pos = state.bMarks[startLine] + state.tShift[startLine], max = state.eMarks[startLine], nextLine = startLine + 1;
        if (state.sCount[startLine] - state.blkIndent >= 4) {
          return false;
        }
        if (state.src.charCodeAt(pos) !== 91) {
          return false;
        }
        while (++pos < max) {
          if (state.src.charCodeAt(pos) === 93 && state.src.charCodeAt(pos - 1) !== 92) {
            if (pos + 1 === max) {
              return false;
            }
            if (state.src.charCodeAt(pos + 1) !== 58) {
              return false;
            }
            break;
          }
        }
        endLine = state.lineMax;
        terminatorRules = state.md.block.ruler.getRules("reference");
        oldParentType = state.parentType;
        state.parentType = "reference";
        for (; nextLine < endLine && !state.isEmpty(nextLine); nextLine++) {
          if (state.sCount[nextLine] - state.blkIndent > 3) {
            continue;
          }
          if (state.sCount[nextLine] < 0) {
            continue;
          }
          terminate = false;
          for (i = 0, l = terminatorRules.length; i < l; i++) {
            if (terminatorRules[i](state, nextLine, endLine, true)) {
              terminate = true;
              break;
            }
          }
          if (terminate) {
            break;
          }
        }
        str = state.getLines(startLine, nextLine, state.blkIndent, false).trim();
        max = str.length;
        for (pos = 1; pos < max; pos++) {
          ch = str.charCodeAt(pos);
          if (ch === 91) {
            return false;
          } else if (ch === 93) {
            labelEnd = pos;
            break;
          } else if (ch === 10) {
            lines++;
          } else if (ch === 92) {
            pos++;
            if (pos < max && str.charCodeAt(pos) === 10) {
              lines++;
            }
          }
        }
        if (labelEnd < 0 || str.charCodeAt(labelEnd + 1) !== 58) {
          return false;
        }
        for (pos = labelEnd + 2; pos < max; pos++) {
          ch = str.charCodeAt(pos);
          if (ch === 10) {
            lines++;
          } else if (isSpace(ch)) {
          } else {
            break;
          }
        }
        res = state.md.helpers.parseLinkDestination(str, pos, max);
        if (!res.ok) {
          return false;
        }
        href = state.md.normalizeLink(res.str);
        if (!state.md.validateLink(href)) {
          return false;
        }
        pos = res.pos;
        lines += res.lines;
        destEndPos = pos;
        destEndLineNo = lines;
        start = pos;
        for (; pos < max; pos++) {
          ch = str.charCodeAt(pos);
          if (ch === 10) {
            lines++;
          } else if (isSpace(ch)) {
          } else {
            break;
          }
        }
        res = state.md.helpers.parseLinkTitle(str, pos, max);
        if (pos < max && start !== pos && res.ok) {
          title = res.str;
          pos = res.pos;
          lines += res.lines;
        } else {
          title = "";
          pos = destEndPos;
          lines = destEndLineNo;
        }
        while (pos < max) {
          ch = str.charCodeAt(pos);
          if (!isSpace(ch)) {
            break;
          }
          pos++;
        }
        if (pos < max && str.charCodeAt(pos) !== 10) {
          if (title) {
            title = "";
            pos = destEndPos;
            lines = destEndLineNo;
            while (pos < max) {
              ch = str.charCodeAt(pos);
              if (!isSpace(ch)) {
                break;
              }
              pos++;
            }
          }
        }
        if (pos < max && str.charCodeAt(pos) !== 10) {
          return false;
        }
        label = normalizeReference(str.slice(1, labelEnd));
        if (!label) {
          return false;
        }
        if (silent) {
          return true;
        }
        if (typeof state.env.references === "undefined") {
          state.env.references = {};
        }
        if (typeof state.env.references[label] === "undefined") {
          state.env.references[label] = { title, href };
        }
        state.parentType = oldParentType;
        state.line = startLine + lines + 1;
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/common/html_blocks.js
  var require_html_blocks = __commonJS({
    "node_modules/markdown-it/lib/common/html_blocks.js"(exports, module) {
      "use strict";
      module.exports = [
        "address",
        "article",
        "aside",
        "base",
        "basefont",
        "blockquote",
        "body",
        "caption",
        "center",
        "col",
        "colgroup",
        "dd",
        "details",
        "dialog",
        "dir",
        "div",
        "dl",
        "dt",
        "fieldset",
        "figcaption",
        "figure",
        "footer",
        "form",
        "frame",
        "frameset",
        "h1",
        "h2",
        "h3",
        "h4",
        "h5",
        "h6",
        "head",
        "header",
        "hr",
        "html",
        "iframe",
        "legend",
        "li",
        "link",
        "main",
        "menu",
        "menuitem",
        "nav",
        "noframes",
        "ol",
        "optgroup",
        "option",
        "p",
        "param",
        "section",
        "source",
        "summary",
        "table",
        "tbody",
        "td",
        "tfoot",
        "th",
        "thead",
        "title",
        "tr",
        "track",
        "ul"
      ];
    }
  });

  // node_modules/markdown-it/lib/common/html_re.js
  var require_html_re = __commonJS({
    "node_modules/markdown-it/lib/common/html_re.js"(exports, module) {
      "use strict";
      var attr_name = "[a-zA-Z_:][a-zA-Z0-9:._-]*";
      var unquoted = "[^\"'=<>`\\x00-\\x20]+";
      var single_quoted = "'[^']*'";
      var double_quoted = '"[^"]*"';
      var attr_value = "(?:" + unquoted + "|" + single_quoted + "|" + double_quoted + ")";
      var attribute = "(?:\\s+" + attr_name + "(?:\\s*=\\s*" + attr_value + ")?)";
      var open_tag = "<[A-Za-z][A-Za-z0-9\\-]*" + attribute + "*\\s*\\/?>";
      var close_tag = "<\\/[A-Za-z][A-Za-z0-9\\-]*\\s*>";
      var comment = "<!---->|<!--(?:-?[^>-])(?:-?[^-])*-->";
      var processing = "<[?][\\s\\S]*?[?]>";
      var declaration = "<![A-Z]+\\s+[^>]*>";
      var cdata = "<!\\[CDATA\\[[\\s\\S]*?\\]\\]>";
      var HTML_TAG_RE = new RegExp("^(?:" + open_tag + "|" + close_tag + "|" + comment + "|" + processing + "|" + declaration + "|" + cdata + ")");
      var HTML_OPEN_CLOSE_TAG_RE = new RegExp("^(?:" + open_tag + "|" + close_tag + ")");
      module.exports.HTML_TAG_RE = HTML_TAG_RE;
      module.exports.HTML_OPEN_CLOSE_TAG_RE = HTML_OPEN_CLOSE_TAG_RE;
    }
  });

  // node_modules/markdown-it/lib/rules_block/html_block.js
  var require_html_block = __commonJS({
    "node_modules/markdown-it/lib/rules_block/html_block.js"(exports, module) {
      "use strict";
      var block_names = require_html_blocks();
      var HTML_OPEN_CLOSE_TAG_RE = require_html_re().HTML_OPEN_CLOSE_TAG_RE;
      var HTML_SEQUENCES = [
        [/^<(script|pre|style|textarea)(?=(\s|>|$))/i, /<\/(script|pre|style|textarea)>/i, true],
        [/^<!--/, /-->/, true],
        [/^<\?/, /\?>/, true],
        [/^<![A-Z]/, />/, true],
        [/^<!\[CDATA\[/, /\]\]>/, true],
        [new RegExp("^</?(" + block_names.join("|") + ")(?=(\\s|/?>|$))", "i"), /^$/, true],
        [new RegExp(HTML_OPEN_CLOSE_TAG_RE.source + "\\s*$"), /^$/, false]
      ];
      module.exports = function html_block(state, startLine, endLine, silent) {
        var i, nextLine, token, lineText, pos = state.bMarks[startLine] + state.tShift[startLine], max = state.eMarks[startLine];
        if (state.sCount[startLine] - state.blkIndent >= 4) {
          return false;
        }
        if (!state.md.options.html) {
          return false;
        }
        if (state.src.charCodeAt(pos) !== 60) {
          return false;
        }
        lineText = state.src.slice(pos, max);
        for (i = 0; i < HTML_SEQUENCES.length; i++) {
          if (HTML_SEQUENCES[i][0].test(lineText)) {
            break;
          }
        }
        if (i === HTML_SEQUENCES.length) {
          return false;
        }
        if (silent) {
          return HTML_SEQUENCES[i][2];
        }
        nextLine = startLine + 1;
        if (!HTML_SEQUENCES[i][1].test(lineText)) {
          for (; nextLine < endLine; nextLine++) {
            if (state.sCount[nextLine] < state.blkIndent) {
              break;
            }
            pos = state.bMarks[nextLine] + state.tShift[nextLine];
            max = state.eMarks[nextLine];
            lineText = state.src.slice(pos, max);
            if (HTML_SEQUENCES[i][1].test(lineText)) {
              if (lineText.length !== 0) {
                nextLine++;
              }
              break;
            }
          }
        }
        state.line = nextLine;
        token = state.push("html_block", "", 0);
        token.map = [startLine, nextLine];
        token.content = state.getLines(startLine, nextLine, state.blkIndent, true);
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_block/heading.js
  var require_heading = __commonJS({
    "node_modules/markdown-it/lib/rules_block/heading.js"(exports, module) {
      "use strict";
      var isSpace = require_utils().isSpace;
      module.exports = function heading(state, startLine, endLine, silent) {
        var ch, level, tmp, token, pos = state.bMarks[startLine] + state.tShift[startLine], max = state.eMarks[startLine];
        if (state.sCount[startLine] - state.blkIndent >= 4) {
          return false;
        }
        ch = state.src.charCodeAt(pos);
        if (ch !== 35 || pos >= max) {
          return false;
        }
        level = 1;
        ch = state.src.charCodeAt(++pos);
        while (ch === 35 && pos < max && level <= 6) {
          level++;
          ch = state.src.charCodeAt(++pos);
        }
        if (level > 6 || pos < max && !isSpace(ch)) {
          return false;
        }
        if (silent) {
          return true;
        }
        max = state.skipSpacesBack(max, pos);
        tmp = state.skipCharsBack(max, 35, pos);
        if (tmp > pos && isSpace(state.src.charCodeAt(tmp - 1))) {
          max = tmp;
        }
        state.line = startLine + 1;
        token = state.push("heading_open", "h" + String(level), 1);
        token.markup = "########".slice(0, level);
        token.map = [startLine, state.line];
        token = state.push("inline", "", 0);
        token.content = state.src.slice(pos, max).trim();
        token.map = [startLine, state.line];
        token.children = [];
        token = state.push("heading_close", "h" + String(level), -1);
        token.markup = "########".slice(0, level);
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_block/lheading.js
  var require_lheading = __commonJS({
    "node_modules/markdown-it/lib/rules_block/lheading.js"(exports, module) {
      "use strict";
      module.exports = function lheading(state, startLine, endLine) {
        var content, terminate, i, l, token, pos, max, level, marker, nextLine = startLine + 1, oldParentType, terminatorRules = state.md.block.ruler.getRules("paragraph");
        if (state.sCount[startLine] - state.blkIndent >= 4) {
          return false;
        }
        oldParentType = state.parentType;
        state.parentType = "paragraph";
        for (; nextLine < endLine && !state.isEmpty(nextLine); nextLine++) {
          if (state.sCount[nextLine] - state.blkIndent > 3) {
            continue;
          }
          if (state.sCount[nextLine] >= state.blkIndent) {
            pos = state.bMarks[nextLine] + state.tShift[nextLine];
            max = state.eMarks[nextLine];
            if (pos < max) {
              marker = state.src.charCodeAt(pos);
              if (marker === 45 || marker === 61) {
                pos = state.skipChars(pos, marker);
                pos = state.skipSpaces(pos);
                if (pos >= max) {
                  level = marker === 61 ? 1 : 2;
                  break;
                }
              }
            }
          }
          if (state.sCount[nextLine] < 0) {
            continue;
          }
          terminate = false;
          for (i = 0, l = terminatorRules.length; i < l; i++) {
            if (terminatorRules[i](state, nextLine, endLine, true)) {
              terminate = true;
              break;
            }
          }
          if (terminate) {
            break;
          }
        }
        if (!level) {
          return false;
        }
        content = state.getLines(startLine, nextLine, state.blkIndent, false).trim();
        state.line = nextLine + 1;
        token = state.push("heading_open", "h" + String(level), 1);
        token.markup = String.fromCharCode(marker);
        token.map = [startLine, state.line];
        token = state.push("inline", "", 0);
        token.content = content;
        token.map = [startLine, state.line - 1];
        token.children = [];
        token = state.push("heading_close", "h" + String(level), -1);
        token.markup = String.fromCharCode(marker);
        state.parentType = oldParentType;
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_block/paragraph.js
  var require_paragraph = __commonJS({
    "node_modules/markdown-it/lib/rules_block/paragraph.js"(exports, module) {
      "use strict";
      module.exports = function paragraph(state, startLine) {
        var content, terminate, i, l, token, oldParentType, nextLine = startLine + 1, terminatorRules = state.md.block.ruler.getRules("paragraph"), endLine = state.lineMax;
        oldParentType = state.parentType;
        state.parentType = "paragraph";
        for (; nextLine < endLine && !state.isEmpty(nextLine); nextLine++) {
          if (state.sCount[nextLine] - state.blkIndent > 3) {
            continue;
          }
          if (state.sCount[nextLine] < 0) {
            continue;
          }
          terminate = false;
          for (i = 0, l = terminatorRules.length; i < l; i++) {
            if (terminatorRules[i](state, nextLine, endLine, true)) {
              terminate = true;
              break;
            }
          }
          if (terminate) {
            break;
          }
        }
        content = state.getLines(startLine, nextLine, state.blkIndent, false).trim();
        state.line = nextLine;
        token = state.push("paragraph_open", "p", 1);
        token.map = [startLine, state.line];
        token = state.push("inline", "", 0);
        token.content = content;
        token.map = [startLine, state.line];
        token.children = [];
        token = state.push("paragraph_close", "p", -1);
        state.parentType = oldParentType;
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_block/state_block.js
  var require_state_block = __commonJS({
    "node_modules/markdown-it/lib/rules_block/state_block.js"(exports, module) {
      "use strict";
      var Token = require_token();
      var isSpace = require_utils().isSpace;
      function StateBlock(src, md, env, tokens) {
        var ch, s, start, pos, len, indent, offset, indent_found;
        this.src = src;
        this.md = md;
        this.env = env;
        this.tokens = tokens;
        this.bMarks = [];
        this.eMarks = [];
        this.tShift = [];
        this.sCount = [];
        this.bsCount = [];
        this.blkIndent = 0;
        this.line = 0;
        this.lineMax = 0;
        this.tight = false;
        this.ddIndent = -1;
        this.listIndent = -1;
        this.parentType = "root";
        this.level = 0;
        this.result = "";
        s = this.src;
        indent_found = false;
        for (start = pos = indent = offset = 0, len = s.length; pos < len; pos++) {
          ch = s.charCodeAt(pos);
          if (!indent_found) {
            if (isSpace(ch)) {
              indent++;
              if (ch === 9) {
                offset += 4 - offset % 4;
              } else {
                offset++;
              }
              continue;
            } else {
              indent_found = true;
            }
          }
          if (ch === 10 || pos === len - 1) {
            if (ch !== 10) {
              pos++;
            }
            this.bMarks.push(start);
            this.eMarks.push(pos);
            this.tShift.push(indent);
            this.sCount.push(offset);
            this.bsCount.push(0);
            indent_found = false;
            indent = 0;
            offset = 0;
            start = pos + 1;
          }
        }
        this.bMarks.push(s.length);
        this.eMarks.push(s.length);
        this.tShift.push(0);
        this.sCount.push(0);
        this.bsCount.push(0);
        this.lineMax = this.bMarks.length - 1;
      }
      StateBlock.prototype.push = function(type, tag, nesting) {
        var token = new Token(type, tag, nesting);
        token.block = true;
        if (nesting < 0)
          this.level--;
        token.level = this.level;
        if (nesting > 0)
          this.level++;
        this.tokens.push(token);
        return token;
      };
      StateBlock.prototype.isEmpty = function isEmpty(line) {
        return this.bMarks[line] + this.tShift[line] >= this.eMarks[line];
      };
      StateBlock.prototype.skipEmptyLines = function skipEmptyLines(from) {
        for (var max = this.lineMax; from < max; from++) {
          if (this.bMarks[from] + this.tShift[from] < this.eMarks[from]) {
            break;
          }
        }
        return from;
      };
      StateBlock.prototype.skipSpaces = function skipSpaces(pos) {
        var ch;
        for (var max = this.src.length; pos < max; pos++) {
          ch = this.src.charCodeAt(pos);
          if (!isSpace(ch)) {
            break;
          }
        }
        return pos;
      };
      StateBlock.prototype.skipSpacesBack = function skipSpacesBack(pos, min) {
        if (pos <= min) {
          return pos;
        }
        while (pos > min) {
          if (!isSpace(this.src.charCodeAt(--pos))) {
            return pos + 1;
          }
        }
        return pos;
      };
      StateBlock.prototype.skipChars = function skipChars(pos, code) {
        for (var max = this.src.length; pos < max; pos++) {
          if (this.src.charCodeAt(pos) !== code) {
            break;
          }
        }
        return pos;
      };
      StateBlock.prototype.skipCharsBack = function skipCharsBack(pos, code, min) {
        if (pos <= min) {
          return pos;
        }
        while (pos > min) {
          if (code !== this.src.charCodeAt(--pos)) {
            return pos + 1;
          }
        }
        return pos;
      };
      StateBlock.prototype.getLines = function getLines(begin, end, indent, keepLastLF) {
        var i, lineIndent, ch, first, last, queue, lineStart, line = begin;
        if (begin >= end) {
          return "";
        }
        queue = new Array(end - begin);
        for (i = 0; line < end; line++, i++) {
          lineIndent = 0;
          lineStart = first = this.bMarks[line];
          if (line + 1 < end || keepLastLF) {
            last = this.eMarks[line] + 1;
          } else {
            last = this.eMarks[line];
          }
          while (first < last && lineIndent < indent) {
            ch = this.src.charCodeAt(first);
            if (isSpace(ch)) {
              if (ch === 9) {
                lineIndent += 4 - (lineIndent + this.bsCount[line]) % 4;
              } else {
                lineIndent++;
              }
            } else if (first - lineStart < this.tShift[line]) {
              lineIndent++;
            } else {
              break;
            }
            first++;
          }
          if (lineIndent > indent) {
            queue[i] = new Array(lineIndent - indent + 1).join(" ") + this.src.slice(first, last);
          } else {
            queue[i] = this.src.slice(first, last);
          }
        }
        return queue.join("");
      };
      StateBlock.prototype.Token = Token;
      module.exports = StateBlock;
    }
  });

  // node_modules/markdown-it/lib/parser_block.js
  var require_parser_block = __commonJS({
    "node_modules/markdown-it/lib/parser_block.js"(exports, module) {
      "use strict";
      var Ruler = require_ruler();
      var _rules = [
        // First 2 params - rule name & source. Secondary array - list of rules,
        // which can be terminated by this one.
        ["table", require_table(), ["paragraph", "reference"]],
        ["code", require_code()],
        ["fence", require_fence(), ["paragraph", "reference", "blockquote", "list"]],
        ["blockquote", require_blockquote(), ["paragraph", "reference", "blockquote", "list"]],
        ["hr", require_hr(), ["paragraph", "reference", "blockquote", "list"]],
        ["list", require_list(), ["paragraph", "reference", "blockquote"]],
        ["reference", require_reference()],
        ["html_block", require_html_block(), ["paragraph", "reference", "blockquote"]],
        ["heading", require_heading(), ["paragraph", "reference", "blockquote"]],
        ["lheading", require_lheading()],
        ["paragraph", require_paragraph()]
      ];
      function ParserBlock() {
        this.ruler = new Ruler();
        for (var i = 0; i < _rules.length; i++) {
          this.ruler.push(_rules[i][0], _rules[i][1], { alt: (_rules[i][2] || []).slice() });
        }
      }
      ParserBlock.prototype.tokenize = function(state, startLine, endLine) {
        var ok, i, rules = this.ruler.getRules(""), len = rules.length, line = startLine, hasEmptyLines = false, maxNesting = state.md.options.maxNesting;
        while (line < endLine) {
          state.line = line = state.skipEmptyLines(line);
          if (line >= endLine) {
            break;
          }
          if (state.sCount[line] < state.blkIndent) {
            break;
          }
          if (state.level >= maxNesting) {
            state.line = endLine;
            break;
          }
          for (i = 0; i < len; i++) {
            ok = rules[i](state, line, endLine, false);
            if (ok) {
              break;
            }
          }
          state.tight = !hasEmptyLines;
          if (state.isEmpty(state.line - 1)) {
            hasEmptyLines = true;
          }
          line = state.line;
          if (line < endLine && state.isEmpty(line)) {
            hasEmptyLines = true;
            line++;
            state.line = line;
          }
        }
      };
      ParserBlock.prototype.parse = function(src, md, env, outTokens) {
        var state;
        if (!src) {
          return;
        }
        state = new this.State(src, md, env, outTokens);
        this.tokenize(state, state.line, state.lineMax);
      };
      ParserBlock.prototype.State = require_state_block();
      module.exports = ParserBlock;
    }
  });

  // node_modules/markdown-it/lib/rules_inline/text.js
  var require_text = __commonJS({
    "node_modules/markdown-it/lib/rules_inline/text.js"(exports, module) {
      "use strict";
      function isTerminatorChar(ch) {
        switch (ch) {
          case 10:
          case 33:
          case 35:
          case 36:
          case 37:
          case 38:
          case 42:
          case 43:
          case 45:
          case 58:
          case 60:
          case 61:
          case 62:
          case 64:
          case 91:
          case 92:
          case 93:
          case 94:
          case 95:
          case 96:
          case 123:
          case 125:
          case 126:
            return true;
          default:
            return false;
        }
      }
      module.exports = function text(state, silent) {
        var pos = state.pos;
        while (pos < state.posMax && !isTerminatorChar(state.src.charCodeAt(pos))) {
          pos++;
        }
        if (pos === state.pos) {
          return false;
        }
        if (!silent) {
          state.pending += state.src.slice(state.pos, pos);
        }
        state.pos = pos;
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_inline/linkify.js
  var require_linkify2 = __commonJS({
    "node_modules/markdown-it/lib/rules_inline/linkify.js"(exports, module) {
      "use strict";
      var SCHEME_RE = /(?:^|[^a-z0-9.+-])([a-z][a-z0-9.+-]*)$/i;
      module.exports = function linkify(state, silent) {
        var pos, max, match, proto, link, url, fullUrl, token;
        if (!state.md.options.linkify)
          return false;
        if (state.linkLevel > 0)
          return false;
        pos = state.pos;
        max = state.posMax;
        if (pos + 3 > max)
          return false;
        if (state.src.charCodeAt(pos) !== 58)
          return false;
        if (state.src.charCodeAt(pos + 1) !== 47)
          return false;
        if (state.src.charCodeAt(pos + 2) !== 47)
          return false;
        match = state.pending.match(SCHEME_RE);
        if (!match)
          return false;
        proto = match[1];
        link = state.md.linkify.matchAtStart(state.src.slice(pos - proto.length));
        if (!link)
          return false;
        url = link.url;
        url = url.replace(/\*+$/, "");
        fullUrl = state.md.normalizeLink(url);
        if (!state.md.validateLink(fullUrl))
          return false;
        if (!silent) {
          state.pending = state.pending.slice(0, -proto.length);
          token = state.push("link_open", "a", 1);
          token.attrs = [["href", fullUrl]];
          token.markup = "linkify";
          token.info = "auto";
          token = state.push("text", "", 0);
          token.content = state.md.normalizeLinkText(url);
          token = state.push("link_close", "a", -1);
          token.markup = "linkify";
          token.info = "auto";
        }
        state.pos += url.length - proto.length;
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_inline/newline.js
  var require_newline = __commonJS({
    "node_modules/markdown-it/lib/rules_inline/newline.js"(exports, module) {
      "use strict";
      var isSpace = require_utils().isSpace;
      module.exports = function newline(state, silent) {
        var pmax, max, ws, pos = state.pos;
        if (state.src.charCodeAt(pos) !== 10) {
          return false;
        }
        pmax = state.pending.length - 1;
        max = state.posMax;
        if (!silent) {
          if (pmax >= 0 && state.pending.charCodeAt(pmax) === 32) {
            if (pmax >= 1 && state.pending.charCodeAt(pmax - 1) === 32) {
              ws = pmax - 1;
              while (ws >= 1 && state.pending.charCodeAt(ws - 1) === 32)
                ws--;
              state.pending = state.pending.slice(0, ws);
              state.push("hardbreak", "br", 0);
            } else {
              state.pending = state.pending.slice(0, -1);
              state.push("softbreak", "br", 0);
            }
          } else {
            state.push("softbreak", "br", 0);
          }
        }
        pos++;
        while (pos < max && isSpace(state.src.charCodeAt(pos))) {
          pos++;
        }
        state.pos = pos;
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_inline/escape.js
  var require_escape = __commonJS({
    "node_modules/markdown-it/lib/rules_inline/escape.js"(exports, module) {
      "use strict";
      var isSpace = require_utils().isSpace;
      var ESCAPED = [];
      for (i = 0; i < 256; i++) {
        ESCAPED.push(0);
      }
      var i;
      "\\!\"#$%&'()*+,./:;<=>?@[]^_`{|}~-".split("").forEach(function(ch) {
        ESCAPED[ch.charCodeAt(0)] = 1;
      });
      module.exports = function escape2(state, silent) {
        var ch1, ch2, origStr, escapedStr, token, pos = state.pos, max = state.posMax;
        if (state.src.charCodeAt(pos) !== 92)
          return false;
        pos++;
        if (pos >= max)
          return false;
        ch1 = state.src.charCodeAt(pos);
        if (ch1 === 10) {
          if (!silent) {
            state.push("hardbreak", "br", 0);
          }
          pos++;
          while (pos < max) {
            ch1 = state.src.charCodeAt(pos);
            if (!isSpace(ch1))
              break;
            pos++;
          }
          state.pos = pos;
          return true;
        }
        escapedStr = state.src[pos];
        if (ch1 >= 55296 && ch1 <= 56319 && pos + 1 < max) {
          ch2 = state.src.charCodeAt(pos + 1);
          if (ch2 >= 56320 && ch2 <= 57343) {
            escapedStr += state.src[pos + 1];
            pos++;
          }
        }
        origStr = "\\" + escapedStr;
        if (!silent) {
          token = state.push("text_special", "", 0);
          if (ch1 < 256 && ESCAPED[ch1] !== 0) {
            token.content = escapedStr;
          } else {
            token.content = origStr;
          }
          token.markup = origStr;
          token.info = "escape";
        }
        state.pos = pos + 1;
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_inline/backticks.js
  var require_backticks = __commonJS({
    "node_modules/markdown-it/lib/rules_inline/backticks.js"(exports, module) {
      "use strict";
      module.exports = function backtick(state, silent) {
        var start, max, marker, token, matchStart, matchEnd, openerLength, closerLength, pos = state.pos, ch = state.src.charCodeAt(pos);
        if (ch !== 96) {
          return false;
        }
        start = pos;
        pos++;
        max = state.posMax;
        while (pos < max && state.src.charCodeAt(pos) === 96) {
          pos++;
        }
        marker = state.src.slice(start, pos);
        openerLength = marker.length;
        if (state.backticksScanned && (state.backticks[openerLength] || 0) <= start) {
          if (!silent)
            state.pending += marker;
          state.pos += openerLength;
          return true;
        }
        matchStart = matchEnd = pos;
        while ((matchStart = state.src.indexOf("`", matchEnd)) !== -1) {
          matchEnd = matchStart + 1;
          while (matchEnd < max && state.src.charCodeAt(matchEnd) === 96) {
            matchEnd++;
          }
          closerLength = matchEnd - matchStart;
          if (closerLength === openerLength) {
            if (!silent) {
              token = state.push("code_inline", "code", 0);
              token.markup = marker;
              token.content = state.src.slice(pos, matchStart).replace(/\n/g, " ").replace(/^ (.+) $/, "$1");
            }
            state.pos = matchEnd;
            return true;
          }
          state.backticks[closerLength] = matchStart;
        }
        state.backticksScanned = true;
        if (!silent)
          state.pending += marker;
        state.pos += openerLength;
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_inline/strikethrough.js
  var require_strikethrough = __commonJS({
    "node_modules/markdown-it/lib/rules_inline/strikethrough.js"(exports, module) {
      "use strict";
      module.exports.tokenize = function strikethrough(state, silent) {
        var i, scanned, token, len, ch, start = state.pos, marker = state.src.charCodeAt(start);
        if (silent) {
          return false;
        }
        if (marker !== 126) {
          return false;
        }
        scanned = state.scanDelims(state.pos, true);
        len = scanned.length;
        ch = String.fromCharCode(marker);
        if (len < 2) {
          return false;
        }
        if (len % 2) {
          token = state.push("text", "", 0);
          token.content = ch;
          len--;
        }
        for (i = 0; i < len; i += 2) {
          token = state.push("text", "", 0);
          token.content = ch + ch;
          state.delimiters.push({
            marker,
            length: 0,
            // disable "rule of 3" length checks meant for emphasis
            token: state.tokens.length - 1,
            end: -1,
            open: scanned.can_open,
            close: scanned.can_close
          });
        }
        state.pos += scanned.length;
        return true;
      };
      function postProcess(state, delimiters) {
        var i, j, startDelim, endDelim, token, loneMarkers = [], max = delimiters.length;
        for (i = 0; i < max; i++) {
          startDelim = delimiters[i];
          if (startDelim.marker !== 126) {
            continue;
          }
          if (startDelim.end === -1) {
            continue;
          }
          endDelim = delimiters[startDelim.end];
          token = state.tokens[startDelim.token];
          token.type = "s_open";
          token.tag = "s";
          token.nesting = 1;
          token.markup = "~~";
          token.content = "";
          token = state.tokens[endDelim.token];
          token.type = "s_close";
          token.tag = "s";
          token.nesting = -1;
          token.markup = "~~";
          token.content = "";
          if (state.tokens[endDelim.token - 1].type === "text" && state.tokens[endDelim.token - 1].content === "~") {
            loneMarkers.push(endDelim.token - 1);
          }
        }
        while (loneMarkers.length) {
          i = loneMarkers.pop();
          j = i + 1;
          while (j < state.tokens.length && state.tokens[j].type === "s_close") {
            j++;
          }
          j--;
          if (i !== j) {
            token = state.tokens[j];
            state.tokens[j] = state.tokens[i];
            state.tokens[i] = token;
          }
        }
      }
      module.exports.postProcess = function strikethrough(state) {
        var curr, tokens_meta = state.tokens_meta, max = state.tokens_meta.length;
        postProcess(state, state.delimiters);
        for (curr = 0; curr < max; curr++) {
          if (tokens_meta[curr] && tokens_meta[curr].delimiters) {
            postProcess(state, tokens_meta[curr].delimiters);
          }
        }
      };
    }
  });

  // node_modules/markdown-it/lib/rules_inline/emphasis.js
  var require_emphasis = __commonJS({
    "node_modules/markdown-it/lib/rules_inline/emphasis.js"(exports, module) {
      "use strict";
      module.exports.tokenize = function emphasis(state, silent) {
        var i, scanned, token, start = state.pos, marker = state.src.charCodeAt(start);
        if (silent) {
          return false;
        }
        if (marker !== 95 && marker !== 42) {
          return false;
        }
        scanned = state.scanDelims(state.pos, marker === 42);
        for (i = 0; i < scanned.length; i++) {
          token = state.push("text", "", 0);
          token.content = String.fromCharCode(marker);
          state.delimiters.push({
            // Char code of the starting marker (number).
            //
            marker,
            // Total length of these series of delimiters.
            //
            length: scanned.length,
            // A position of the token this delimiter corresponds to.
            //
            token: state.tokens.length - 1,
            // If this delimiter is matched as a valid opener, `end` will be
            // equal to its position, otherwise it's `-1`.
            //
            end: -1,
            // Boolean flags that determine if this delimiter could open or close
            // an emphasis.
            //
            open: scanned.can_open,
            close: scanned.can_close
          });
        }
        state.pos += scanned.length;
        return true;
      };
      function postProcess(state, delimiters) {
        var i, startDelim, endDelim, token, ch, isStrong, max = delimiters.length;
        for (i = max - 1; i >= 0; i--) {
          startDelim = delimiters[i];
          if (startDelim.marker !== 95 && startDelim.marker !== 42) {
            continue;
          }
          if (startDelim.end === -1) {
            continue;
          }
          endDelim = delimiters[startDelim.end];
          isStrong = i > 0 && delimiters[i - 1].end === startDelim.end + 1 && // check that first two markers match and adjacent
          delimiters[i - 1].marker === startDelim.marker && delimiters[i - 1].token === startDelim.token - 1 && // check that last two markers are adjacent (we can safely assume they match)
          delimiters[startDelim.end + 1].token === endDelim.token + 1;
          ch = String.fromCharCode(startDelim.marker);
          token = state.tokens[startDelim.token];
          token.type = isStrong ? "strong_open" : "em_open";
          token.tag = isStrong ? "strong" : "em";
          token.nesting = 1;
          token.markup = isStrong ? ch + ch : ch;
          token.content = "";
          token = state.tokens[endDelim.token];
          token.type = isStrong ? "strong_close" : "em_close";
          token.tag = isStrong ? "strong" : "em";
          token.nesting = -1;
          token.markup = isStrong ? ch + ch : ch;
          token.content = "";
          if (isStrong) {
            state.tokens[delimiters[i - 1].token].content = "";
            state.tokens[delimiters[startDelim.end + 1].token].content = "";
            i--;
          }
        }
      }
      module.exports.postProcess = function emphasis(state) {
        var curr, tokens_meta = state.tokens_meta, max = state.tokens_meta.length;
        postProcess(state, state.delimiters);
        for (curr = 0; curr < max; curr++) {
          if (tokens_meta[curr] && tokens_meta[curr].delimiters) {
            postProcess(state, tokens_meta[curr].delimiters);
          }
        }
      };
    }
  });

  // node_modules/markdown-it/lib/rules_inline/link.js
  var require_link = __commonJS({
    "node_modules/markdown-it/lib/rules_inline/link.js"(exports, module) {
      "use strict";
      var normalizeReference = require_utils().normalizeReference;
      var isSpace = require_utils().isSpace;
      module.exports = function link(state, silent) {
        var attrs, code, label, labelEnd, labelStart, pos, res, ref, token, href = "", title = "", oldPos = state.pos, max = state.posMax, start = state.pos, parseReference = true;
        if (state.src.charCodeAt(state.pos) !== 91) {
          return false;
        }
        labelStart = state.pos + 1;
        labelEnd = state.md.helpers.parseLinkLabel(state, state.pos, true);
        if (labelEnd < 0) {
          return false;
        }
        pos = labelEnd + 1;
        if (pos < max && state.src.charCodeAt(pos) === 40) {
          parseReference = false;
          pos++;
          for (; pos < max; pos++) {
            code = state.src.charCodeAt(pos);
            if (!isSpace(code) && code !== 10) {
              break;
            }
          }
          if (pos >= max) {
            return false;
          }
          start = pos;
          res = state.md.helpers.parseLinkDestination(state.src, pos, state.posMax);
          if (res.ok) {
            href = state.md.normalizeLink(res.str);
            if (state.md.validateLink(href)) {
              pos = res.pos;
            } else {
              href = "";
            }
            start = pos;
            for (; pos < max; pos++) {
              code = state.src.charCodeAt(pos);
              if (!isSpace(code) && code !== 10) {
                break;
              }
            }
            res = state.md.helpers.parseLinkTitle(state.src, pos, state.posMax);
            if (pos < max && start !== pos && res.ok) {
              title = res.str;
              pos = res.pos;
              for (; pos < max; pos++) {
                code = state.src.charCodeAt(pos);
                if (!isSpace(code) && code !== 10) {
                  break;
                }
              }
            }
          }
          if (pos >= max || state.src.charCodeAt(pos) !== 41) {
            parseReference = true;
          }
          pos++;
        }
        if (parseReference) {
          if (typeof state.env.references === "undefined") {
            return false;
          }
          if (pos < max && state.src.charCodeAt(pos) === 91) {
            start = pos + 1;
            pos = state.md.helpers.parseLinkLabel(state, pos);
            if (pos >= 0) {
              label = state.src.slice(start, pos++);
            } else {
              pos = labelEnd + 1;
            }
          } else {
            pos = labelEnd + 1;
          }
          if (!label) {
            label = state.src.slice(labelStart, labelEnd);
          }
          ref = state.env.references[normalizeReference(label)];
          if (!ref) {
            state.pos = oldPos;
            return false;
          }
          href = ref.href;
          title = ref.title;
        }
        if (!silent) {
          state.pos = labelStart;
          state.posMax = labelEnd;
          token = state.push("link_open", "a", 1);
          token.attrs = attrs = [["href", href]];
          if (title) {
            attrs.push(["title", title]);
          }
          state.linkLevel++;
          state.md.inline.tokenize(state);
          state.linkLevel--;
          token = state.push("link_close", "a", -1);
        }
        state.pos = pos;
        state.posMax = max;
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_inline/image.js
  var require_image = __commonJS({
    "node_modules/markdown-it/lib/rules_inline/image.js"(exports, module) {
      "use strict";
      var normalizeReference = require_utils().normalizeReference;
      var isSpace = require_utils().isSpace;
      module.exports = function image(state, silent) {
        var attrs, code, content, label, labelEnd, labelStart, pos, ref, res, title, token, tokens, start, href = "", oldPos = state.pos, max = state.posMax;
        if (state.src.charCodeAt(state.pos) !== 33) {
          return false;
        }
        if (state.src.charCodeAt(state.pos + 1) !== 91) {
          return false;
        }
        labelStart = state.pos + 2;
        labelEnd = state.md.helpers.parseLinkLabel(state, state.pos + 1, false);
        if (labelEnd < 0) {
          return false;
        }
        pos = labelEnd + 1;
        if (pos < max && state.src.charCodeAt(pos) === 40) {
          pos++;
          for (; pos < max; pos++) {
            code = state.src.charCodeAt(pos);
            if (!isSpace(code) && code !== 10) {
              break;
            }
          }
          if (pos >= max) {
            return false;
          }
          start = pos;
          res = state.md.helpers.parseLinkDestination(state.src, pos, state.posMax);
          if (res.ok) {
            href = state.md.normalizeLink(res.str);
            if (state.md.validateLink(href)) {
              pos = res.pos;
            } else {
              href = "";
            }
          }
          start = pos;
          for (; pos < max; pos++) {
            code = state.src.charCodeAt(pos);
            if (!isSpace(code) && code !== 10) {
              break;
            }
          }
          res = state.md.helpers.parseLinkTitle(state.src, pos, state.posMax);
          if (pos < max && start !== pos && res.ok) {
            title = res.str;
            pos = res.pos;
            for (; pos < max; pos++) {
              code = state.src.charCodeAt(pos);
              if (!isSpace(code) && code !== 10) {
                break;
              }
            }
          } else {
            title = "";
          }
          if (pos >= max || state.src.charCodeAt(pos) !== 41) {
            state.pos = oldPos;
            return false;
          }
          pos++;
        } else {
          if (typeof state.env.references === "undefined") {
            return false;
          }
          if (pos < max && state.src.charCodeAt(pos) === 91) {
            start = pos + 1;
            pos = state.md.helpers.parseLinkLabel(state, pos);
            if (pos >= 0) {
              label = state.src.slice(start, pos++);
            } else {
              pos = labelEnd + 1;
            }
          } else {
            pos = labelEnd + 1;
          }
          if (!label) {
            label = state.src.slice(labelStart, labelEnd);
          }
          ref = state.env.references[normalizeReference(label)];
          if (!ref) {
            state.pos = oldPos;
            return false;
          }
          href = ref.href;
          title = ref.title;
        }
        if (!silent) {
          content = state.src.slice(labelStart, labelEnd);
          state.md.inline.parse(
            content,
            state.md,
            state.env,
            tokens = []
          );
          token = state.push("image", "img", 0);
          token.attrs = attrs = [["src", href], ["alt", ""]];
          token.children = tokens;
          token.content = content;
          if (title) {
            attrs.push(["title", title]);
          }
        }
        state.pos = pos;
        state.posMax = max;
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_inline/autolink.js
  var require_autolink = __commonJS({
    "node_modules/markdown-it/lib/rules_inline/autolink.js"(exports, module) {
      "use strict";
      var EMAIL_RE = /^([a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*)$/;
      var AUTOLINK_RE = /^([a-zA-Z][a-zA-Z0-9+.\-]{1,31}):([^<>\x00-\x20]*)$/;
      module.exports = function autolink(state, silent) {
        var url, fullUrl, token, ch, start, max, pos = state.pos;
        if (state.src.charCodeAt(pos) !== 60) {
          return false;
        }
        start = state.pos;
        max = state.posMax;
        for (; ; ) {
          if (++pos >= max)
            return false;
          ch = state.src.charCodeAt(pos);
          if (ch === 60)
            return false;
          if (ch === 62)
            break;
        }
        url = state.src.slice(start + 1, pos);
        if (AUTOLINK_RE.test(url)) {
          fullUrl = state.md.normalizeLink(url);
          if (!state.md.validateLink(fullUrl)) {
            return false;
          }
          if (!silent) {
            token = state.push("link_open", "a", 1);
            token.attrs = [["href", fullUrl]];
            token.markup = "autolink";
            token.info = "auto";
            token = state.push("text", "", 0);
            token.content = state.md.normalizeLinkText(url);
            token = state.push("link_close", "a", -1);
            token.markup = "autolink";
            token.info = "auto";
          }
          state.pos += url.length + 2;
          return true;
        }
        if (EMAIL_RE.test(url)) {
          fullUrl = state.md.normalizeLink("mailto:" + url);
          if (!state.md.validateLink(fullUrl)) {
            return false;
          }
          if (!silent) {
            token = state.push("link_open", "a", 1);
            token.attrs = [["href", fullUrl]];
            token.markup = "autolink";
            token.info = "auto";
            token = state.push("text", "", 0);
            token.content = state.md.normalizeLinkText(url);
            token = state.push("link_close", "a", -1);
            token.markup = "autolink";
            token.info = "auto";
          }
          state.pos += url.length + 2;
          return true;
        }
        return false;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_inline/html_inline.js
  var require_html_inline = __commonJS({
    "node_modules/markdown-it/lib/rules_inline/html_inline.js"(exports, module) {
      "use strict";
      var HTML_TAG_RE = require_html_re().HTML_TAG_RE;
      function isLinkOpen(str) {
        return /^<a[>\s]/i.test(str);
      }
      function isLinkClose(str) {
        return /^<\/a\s*>/i.test(str);
      }
      function isLetter(ch) {
        var lc = ch | 32;
        return lc >= 97 && lc <= 122;
      }
      module.exports = function html_inline(state, silent) {
        var ch, match, max, token, pos = state.pos;
        if (!state.md.options.html) {
          return false;
        }
        max = state.posMax;
        if (state.src.charCodeAt(pos) !== 60 || pos + 2 >= max) {
          return false;
        }
        ch = state.src.charCodeAt(pos + 1);
        if (ch !== 33 && ch !== 63 && ch !== 47 && !isLetter(ch)) {
          return false;
        }
        match = state.src.slice(pos).match(HTML_TAG_RE);
        if (!match) {
          return false;
        }
        if (!silent) {
          token = state.push("html_inline", "", 0);
          token.content = state.src.slice(pos, pos + match[0].length);
          if (isLinkOpen(token.content))
            state.linkLevel++;
          if (isLinkClose(token.content))
            state.linkLevel--;
        }
        state.pos += match[0].length;
        return true;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_inline/entity.js
  var require_entity = __commonJS({
    "node_modules/markdown-it/lib/rules_inline/entity.js"(exports, module) {
      "use strict";
      var entities = require_entities2();
      var has = require_utils().has;
      var isValidEntityCode = require_utils().isValidEntityCode;
      var fromCodePoint = require_utils().fromCodePoint;
      var DIGITAL_RE = /^&#((?:x[a-f0-9]{1,6}|[0-9]{1,7}));/i;
      var NAMED_RE = /^&([a-z][a-z0-9]{1,31});/i;
      module.exports = function entity(state, silent) {
        var ch, code, match, token, pos = state.pos, max = state.posMax;
        if (state.src.charCodeAt(pos) !== 38)
          return false;
        if (pos + 1 >= max)
          return false;
        ch = state.src.charCodeAt(pos + 1);
        if (ch === 35) {
          match = state.src.slice(pos).match(DIGITAL_RE);
          if (match) {
            if (!silent) {
              code = match[1][0].toLowerCase() === "x" ? parseInt(match[1].slice(1), 16) : parseInt(match[1], 10);
              token = state.push("text_special", "", 0);
              token.content = isValidEntityCode(code) ? fromCodePoint(code) : fromCodePoint(65533);
              token.markup = match[0];
              token.info = "entity";
            }
            state.pos += match[0].length;
            return true;
          }
        } else {
          match = state.src.slice(pos).match(NAMED_RE);
          if (match) {
            if (has(entities, match[1])) {
              if (!silent) {
                token = state.push("text_special", "", 0);
                token.content = entities[match[1]];
                token.markup = match[0];
                token.info = "entity";
              }
              state.pos += match[0].length;
              return true;
            }
          }
        }
        return false;
      };
    }
  });

  // node_modules/markdown-it/lib/rules_inline/balance_pairs.js
  var require_balance_pairs = __commonJS({
    "node_modules/markdown-it/lib/rules_inline/balance_pairs.js"(exports, module) {
      "use strict";
      function processDelimiters(state, delimiters) {
        var closerIdx, openerIdx, closer, opener, minOpenerIdx, newMinOpenerIdx, isOddMatch, lastJump, openersBottom = {}, max = delimiters.length;
        if (!max)
          return;
        var headerIdx = 0;
        var lastTokenIdx = -2;
        var jumps = [];
        for (closerIdx = 0; closerIdx < max; closerIdx++) {
          closer = delimiters[closerIdx];
          jumps.push(0);
          if (delimiters[headerIdx].marker !== closer.marker || lastTokenIdx !== closer.token - 1) {
            headerIdx = closerIdx;
          }
          lastTokenIdx = closer.token;
          closer.length = closer.length || 0;
          if (!closer.close)
            continue;
          if (!openersBottom.hasOwnProperty(closer.marker)) {
            openersBottom[closer.marker] = [-1, -1, -1, -1, -1, -1];
          }
          minOpenerIdx = openersBottom[closer.marker][(closer.open ? 3 : 0) + closer.length % 3];
          openerIdx = headerIdx - jumps[headerIdx] - 1;
          newMinOpenerIdx = openerIdx;
          for (; openerIdx > minOpenerIdx; openerIdx -= jumps[openerIdx] + 1) {
            opener = delimiters[openerIdx];
            if (opener.marker !== closer.marker)
              continue;
            if (opener.open && opener.end < 0) {
              isOddMatch = false;
              if (opener.close || closer.open) {
                if ((opener.length + closer.length) % 3 === 0) {
                  if (opener.length % 3 !== 0 || closer.length % 3 !== 0) {
                    isOddMatch = true;
                  }
                }
              }
              if (!isOddMatch) {
                lastJump = openerIdx > 0 && !delimiters[openerIdx - 1].open ? jumps[openerIdx - 1] + 1 : 0;
                jumps[closerIdx] = closerIdx - openerIdx + lastJump;
                jumps[openerIdx] = lastJump;
                closer.open = false;
                opener.end = closerIdx;
                opener.close = false;
                newMinOpenerIdx = -1;
                lastTokenIdx = -2;
                break;
              }
            }
          }
          if (newMinOpenerIdx !== -1) {
            openersBottom[closer.marker][(closer.open ? 3 : 0) + (closer.length || 0) % 3] = newMinOpenerIdx;
          }
        }
      }
      module.exports = function link_pairs(state) {
        var curr, tokens_meta = state.tokens_meta, max = state.tokens_meta.length;
        processDelimiters(state, state.delimiters);
        for (curr = 0; curr < max; curr++) {
          if (tokens_meta[curr] && tokens_meta[curr].delimiters) {
            processDelimiters(state, tokens_meta[curr].delimiters);
          }
        }
      };
    }
  });

  // node_modules/markdown-it/lib/rules_inline/fragments_join.js
  var require_fragments_join = __commonJS({
    "node_modules/markdown-it/lib/rules_inline/fragments_join.js"(exports, module) {
      "use strict";
      module.exports = function fragments_join(state) {
        var curr, last, level = 0, tokens = state.tokens, max = state.tokens.length;
        for (curr = last = 0; curr < max; curr++) {
          if (tokens[curr].nesting < 0)
            level--;
          tokens[curr].level = level;
          if (tokens[curr].nesting > 0)
            level++;
          if (tokens[curr].type === "text" && curr + 1 < max && tokens[curr + 1].type === "text") {
            tokens[curr + 1].content = tokens[curr].content + tokens[curr + 1].content;
          } else {
            if (curr !== last) {
              tokens[last] = tokens[curr];
            }
            last++;
          }
        }
        if (curr !== last) {
          tokens.length = last;
        }
      };
    }
  });

  // node_modules/markdown-it/lib/rules_inline/state_inline.js
  var require_state_inline = __commonJS({
    "node_modules/markdown-it/lib/rules_inline/state_inline.js"(exports, module) {
      "use strict";
      var Token = require_token();
      var isWhiteSpace = require_utils().isWhiteSpace;
      var isPunctChar = require_utils().isPunctChar;
      var isMdAsciiPunct = require_utils().isMdAsciiPunct;
      function StateInline(src, md, env, outTokens) {
        this.src = src;
        this.env = env;
        this.md = md;
        this.tokens = outTokens;
        this.tokens_meta = Array(outTokens.length);
        this.pos = 0;
        this.posMax = this.src.length;
        this.level = 0;
        this.pending = "";
        this.pendingLevel = 0;
        this.cache = {};
        this.delimiters = [];
        this._prev_delimiters = [];
        this.backticks = {};
        this.backticksScanned = false;
        this.linkLevel = 0;
      }
      StateInline.prototype.pushPending = function() {
        var token = new Token("text", "", 0);
        token.content = this.pending;
        token.level = this.pendingLevel;
        this.tokens.push(token);
        this.pending = "";
        return token;
      };
      StateInline.prototype.push = function(type, tag, nesting) {
        if (this.pending) {
          this.pushPending();
        }
        var token = new Token(type, tag, nesting);
        var token_meta = null;
        if (nesting < 0) {
          this.level--;
          this.delimiters = this._prev_delimiters.pop();
        }
        token.level = this.level;
        if (nesting > 0) {
          this.level++;
          this._prev_delimiters.push(this.delimiters);
          this.delimiters = [];
          token_meta = { delimiters: this.delimiters };
        }
        this.pendingLevel = this.level;
        this.tokens.push(token);
        this.tokens_meta.push(token_meta);
        return token;
      };
      StateInline.prototype.scanDelims = function(start, canSplitWord) {
        var pos = start, lastChar, nextChar, count, can_open, can_close, isLastWhiteSpace, isLastPunctChar, isNextWhiteSpace, isNextPunctChar, left_flanking = true, right_flanking = true, max = this.posMax, marker = this.src.charCodeAt(start);
        lastChar = start > 0 ? this.src.charCodeAt(start - 1) : 32;
        while (pos < max && this.src.charCodeAt(pos) === marker) {
          pos++;
        }
        count = pos - start;
        nextChar = pos < max ? this.src.charCodeAt(pos) : 32;
        isLastPunctChar = isMdAsciiPunct(lastChar) || isPunctChar(String.fromCharCode(lastChar));
        isNextPunctChar = isMdAsciiPunct(nextChar) || isPunctChar(String.fromCharCode(nextChar));
        isLastWhiteSpace = isWhiteSpace(lastChar);
        isNextWhiteSpace = isWhiteSpace(nextChar);
        if (isNextWhiteSpace) {
          left_flanking = false;
        } else if (isNextPunctChar) {
          if (!(isLastWhiteSpace || isLastPunctChar)) {
            left_flanking = false;
          }
        }
        if (isLastWhiteSpace) {
          right_flanking = false;
        } else if (isLastPunctChar) {
          if (!(isNextWhiteSpace || isNextPunctChar)) {
            right_flanking = false;
          }
        }
        if (!canSplitWord) {
          can_open = left_flanking && (!right_flanking || isLastPunctChar);
          can_close = right_flanking && (!left_flanking || isNextPunctChar);
        } else {
          can_open = left_flanking;
          can_close = right_flanking;
        }
        return {
          can_open,
          can_close,
          length: count
        };
      };
      StateInline.prototype.Token = Token;
      module.exports = StateInline;
    }
  });

  // node_modules/markdown-it/lib/parser_inline.js
  var require_parser_inline = __commonJS({
    "node_modules/markdown-it/lib/parser_inline.js"(exports, module) {
      "use strict";
      var Ruler = require_ruler();
      var _rules = [
        ["text", require_text()],
        ["linkify", require_linkify2()],
        ["newline", require_newline()],
        ["escape", require_escape()],
        ["backticks", require_backticks()],
        ["strikethrough", require_strikethrough().tokenize],
        ["emphasis", require_emphasis().tokenize],
        ["link", require_link()],
        ["image", require_image()],
        ["autolink", require_autolink()],
        ["html_inline", require_html_inline()],
        ["entity", require_entity()]
      ];
      var _rules2 = [
        ["balance_pairs", require_balance_pairs()],
        ["strikethrough", require_strikethrough().postProcess],
        ["emphasis", require_emphasis().postProcess],
        // rules for pairs separate '**' into its own text tokens, which may be left unused,
        // rule below merges unused segments back with the rest of the text
        ["fragments_join", require_fragments_join()]
      ];
      function ParserInline() {
        var i;
        this.ruler = new Ruler();
        for (i = 0; i < _rules.length; i++) {
          this.ruler.push(_rules[i][0], _rules[i][1]);
        }
        this.ruler2 = new Ruler();
        for (i = 0; i < _rules2.length; i++) {
          this.ruler2.push(_rules2[i][0], _rules2[i][1]);
        }
      }
      ParserInline.prototype.skipToken = function(state) {
        var ok, i, pos = state.pos, rules = this.ruler.getRules(""), len = rules.length, maxNesting = state.md.options.maxNesting, cache = state.cache;
        if (typeof cache[pos] !== "undefined") {
          state.pos = cache[pos];
          return;
        }
        if (state.level < maxNesting) {
          for (i = 0; i < len; i++) {
            state.level++;
            ok = rules[i](state, true);
            state.level--;
            if (ok) {
              break;
            }
          }
        } else {
          state.pos = state.posMax;
        }
        if (!ok) {
          state.pos++;
        }
        cache[pos] = state.pos;
      };
      ParserInline.prototype.tokenize = function(state) {
        var ok, i, rules = this.ruler.getRules(""), len = rules.length, end = state.posMax, maxNesting = state.md.options.maxNesting;
        while (state.pos < end) {
          if (state.level < maxNesting) {
            for (i = 0; i < len; i++) {
              ok = rules[i](state, false);
              if (ok) {
                break;
              }
            }
          }
          if (ok) {
            if (state.pos >= end) {
              break;
            }
            continue;
          }
          state.pending += state.src[state.pos++];
        }
        if (state.pending) {
          state.pushPending();
        }
      };
      ParserInline.prototype.parse = function(str, md, env, outTokens) {
        var i, rules, len;
        var state = new this.State(str, md, env, outTokens);
        this.tokenize(state);
        rules = this.ruler2.getRules("");
        len = rules.length;
        for (i = 0; i < len; i++) {
          rules[i](state);
        }
      };
      ParserInline.prototype.State = require_state_inline();
      module.exports = ParserInline;
    }
  });

  // node_modules/linkify-it/lib/re.js
  var require_re = __commonJS({
    "node_modules/linkify-it/lib/re.js"(exports, module) {
      "use strict";
      module.exports = function(opts) {
        var re = {};
        opts = opts || {};
        re.src_Any = require_regex2().source;
        re.src_Cc = require_regex3().source;
        re.src_Z = require_regex5().source;
        re.src_P = require_regex().source;
        re.src_ZPCc = [re.src_Z, re.src_P, re.src_Cc].join("|");
        re.src_ZCc = [re.src_Z, re.src_Cc].join("|");
        var text_separators = "[><\uFF5C]";
        re.src_pseudo_letter = "(?:(?!" + text_separators + "|" + re.src_ZPCc + ")" + re.src_Any + ")";
        re.src_ip4 = "(?:(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
        re.src_auth = "(?:(?:(?!" + re.src_ZCc + "|[@/\\[\\]()]).)+@)?";
        re.src_port = "(?::(?:6(?:[0-4]\\d{3}|5(?:[0-4]\\d{2}|5(?:[0-2]\\d|3[0-5])))|[1-5]?\\d{1,4}))?";
        re.src_host_terminator = "(?=$|" + text_separators + "|" + re.src_ZPCc + ")(?!" + (opts["---"] ? "-(?!--)|" : "-|") + "_|:\\d|\\.-|\\.(?!$|" + re.src_ZPCc + "))";
        re.src_path = "(?:[/?#](?:(?!" + re.src_ZCc + "|" + text_separators + `|[()[\\]{}.,"'?!\\-;]).|\\[(?:(?!` + re.src_ZCc + "|\\]).)*\\]|\\((?:(?!" + re.src_ZCc + "|[)]).)*\\)|\\{(?:(?!" + re.src_ZCc + '|[}]).)*\\}|\\"(?:(?!' + re.src_ZCc + `|["]).)+\\"|\\'(?:(?!` + re.src_ZCc + "|[']).)+\\'|\\'(?=" + re.src_pseudo_letter + "|[-])|\\.{2,}[a-zA-Z0-9%/&]|\\.(?!" + re.src_ZCc + "|[.]|$)|" + (opts["---"] ? "\\-(?!--(?:[^-]|$))(?:-*)|" : "\\-+|") + ",(?!" + re.src_ZCc + "|$)|;(?!" + re.src_ZCc + "|$)|\\!+(?!" + re.src_ZCc + "|[!]|$)|\\?(?!" + re.src_ZCc + "|[?]|$))+|\\/)?";
        re.src_email_name = '[\\-;:&=\\+\\$,\\.a-zA-Z0-9_][\\-;:&=\\+\\$,\\"\\.a-zA-Z0-9_]*';
        re.src_xn = "xn--[a-z0-9\\-]{1,59}";
        re.src_domain_root = // Allow letters & digits (http://test1)
        "(?:" + re.src_xn + "|" + re.src_pseudo_letter + "{1,63})";
        re.src_domain = "(?:" + re.src_xn + "|(?:" + re.src_pseudo_letter + ")|(?:" + re.src_pseudo_letter + "(?:-|" + re.src_pseudo_letter + "){0,61}" + re.src_pseudo_letter + "))";
        re.src_host = "(?:(?:(?:(?:" + re.src_domain + ")\\.)*" + re.src_domain + "))";
        re.tpl_host_fuzzy = "(?:" + re.src_ip4 + "|(?:(?:(?:" + re.src_domain + ")\\.)+(?:%TLDS%)))";
        re.tpl_host_no_ip_fuzzy = "(?:(?:(?:" + re.src_domain + ")\\.)+(?:%TLDS%))";
        re.src_host_strict = re.src_host + re.src_host_terminator;
        re.tpl_host_fuzzy_strict = re.tpl_host_fuzzy + re.src_host_terminator;
        re.src_host_port_strict = re.src_host + re.src_port + re.src_host_terminator;
        re.tpl_host_port_fuzzy_strict = re.tpl_host_fuzzy + re.src_port + re.src_host_terminator;
        re.tpl_host_port_no_ip_fuzzy_strict = re.tpl_host_no_ip_fuzzy + re.src_port + re.src_host_terminator;
        re.tpl_host_fuzzy_test = "localhost|www\\.|\\.\\d{1,3}\\.|(?:\\.(?:%TLDS%)(?:" + re.src_ZPCc + "|>|$))";
        re.tpl_email_fuzzy = "(^|" + text_separators + '|"|\\(|' + re.src_ZCc + ")(" + re.src_email_name + "@" + re.tpl_host_fuzzy_strict + ")";
        re.tpl_link_fuzzy = // Fuzzy link can't be prepended with .:/\- and non punctuation.
        // but can start with > (markdown blockquote)
        "(^|(?![.:/\\-_@])(?:[$+<=>^`|\uFF5C]|" + re.src_ZPCc + "))((?![$+<=>^`|\uFF5C])" + re.tpl_host_port_fuzzy_strict + re.src_path + ")";
        re.tpl_link_no_ip_fuzzy = // Fuzzy link can't be prepended with .:/\- and non punctuation.
        // but can start with > (markdown blockquote)
        "(^|(?![.:/\\-_@])(?:[$+<=>^`|\uFF5C]|" + re.src_ZPCc + "))((?![$+<=>^`|\uFF5C])" + re.tpl_host_port_no_ip_fuzzy_strict + re.src_path + ")";
        return re;
      };
    }
  });

  // node_modules/linkify-it/index.js
  var require_linkify_it = __commonJS({
    "node_modules/linkify-it/index.js"(exports, module) {
      "use strict";
      function assign(obj) {
        var sources = Array.prototype.slice.call(arguments, 1);
        sources.forEach(function(source) {
          if (!source) {
            return;
          }
          Object.keys(source).forEach(function(key) {
            obj[key] = source[key];
          });
        });
        return obj;
      }
      function _class(obj) {
        return Object.prototype.toString.call(obj);
      }
      function isString(obj) {
        return _class(obj) === "[object String]";
      }
      function isObject(obj) {
        return _class(obj) === "[object Object]";
      }
      function isRegExp(obj) {
        return _class(obj) === "[object RegExp]";
      }
      function isFunction(obj) {
        return _class(obj) === "[object Function]";
      }
      function escapeRE(str) {
        return str.replace(/[.?*+^$[\]\\(){}|-]/g, "\\$&");
      }
      var defaultOptions = {
        fuzzyLink: true,
        fuzzyEmail: true,
        fuzzyIP: false
      };
      function isOptionsObj(obj) {
        return Object.keys(obj || {}).reduce(function(acc, k) {
          return acc || defaultOptions.hasOwnProperty(k);
        }, false);
      }
      var defaultSchemas = {
        "http:": {
          validate: function(text, pos, self2) {
            var tail = text.slice(pos);
            if (!self2.re.http) {
              self2.re.http = new RegExp(
                "^\\/\\/" + self2.re.src_auth + self2.re.src_host_port_strict + self2.re.src_path,
                "i"
              );
            }
            if (self2.re.http.test(tail)) {
              return tail.match(self2.re.http)[0].length;
            }
            return 0;
          }
        },
        "https:": "http:",
        "ftp:": "http:",
        "//": {
          validate: function(text, pos, self2) {
            var tail = text.slice(pos);
            if (!self2.re.no_http) {
              self2.re.no_http = new RegExp(
                "^" + self2.re.src_auth + // Don't allow single-level domains, because of false positives like '//test'
                // with code comments
                "(?:localhost|(?:(?:" + self2.re.src_domain + ")\\.)+" + self2.re.src_domain_root + ")" + self2.re.src_port + self2.re.src_host_terminator + self2.re.src_path,
                "i"
              );
            }
            if (self2.re.no_http.test(tail)) {
              if (pos >= 3 && text[pos - 3] === ":") {
                return 0;
              }
              if (pos >= 3 && text[pos - 3] === "/") {
                return 0;
              }
              return tail.match(self2.re.no_http)[0].length;
            }
            return 0;
          }
        },
        "mailto:": {
          validate: function(text, pos, self2) {
            var tail = text.slice(pos);
            if (!self2.re.mailto) {
              self2.re.mailto = new RegExp(
                "^" + self2.re.src_email_name + "@" + self2.re.src_host_strict,
                "i"
              );
            }
            if (self2.re.mailto.test(tail)) {
              return tail.match(self2.re.mailto)[0].length;
            }
            return 0;
          }
        }
      };
      var tlds_2ch_src_re = "a[cdefgilmnoqrstuwxz]|b[abdefghijmnorstvwyz]|c[acdfghiklmnoruvwxyz]|d[ejkmoz]|e[cegrstu]|f[ijkmor]|g[abdefghilmnpqrstuwy]|h[kmnrtu]|i[delmnoqrst]|j[emop]|k[eghimnprwyz]|l[abcikrstuvy]|m[acdeghklmnopqrstuvwxyz]|n[acefgilopruz]|om|p[aefghklmnrstwy]|qa|r[eosuw]|s[abcdeghijklmnortuvxyz]|t[cdfghjklmnortvwz]|u[agksyz]|v[aceginu]|w[fs]|y[et]|z[amw]";
      var tlds_default = "biz|com|edu|gov|net|org|pro|web|xxx|aero|asia|coop|info|museum|name|shop|\u0440\u0444".split("|");
      function resetScanCache(self2) {
        self2.__index__ = -1;
        self2.__text_cache__ = "";
      }
      function createValidator(re) {
        return function(text, pos) {
          var tail = text.slice(pos);
          if (re.test(tail)) {
            return tail.match(re)[0].length;
          }
          return 0;
        };
      }
      function createNormalizer() {
        return function(match, self2) {
          self2.normalize(match);
        };
      }
      function compile(self2) {
        var re = self2.re = require_re()(self2.__opts__);
        var tlds = self2.__tlds__.slice();
        self2.onCompile();
        if (!self2.__tlds_replaced__) {
          tlds.push(tlds_2ch_src_re);
        }
        tlds.push(re.src_xn);
        re.src_tlds = tlds.join("|");
        function untpl(tpl) {
          return tpl.replace("%TLDS%", re.src_tlds);
        }
        re.email_fuzzy = RegExp(untpl(re.tpl_email_fuzzy), "i");
        re.link_fuzzy = RegExp(untpl(re.tpl_link_fuzzy), "i");
        re.link_no_ip_fuzzy = RegExp(untpl(re.tpl_link_no_ip_fuzzy), "i");
        re.host_fuzzy_test = RegExp(untpl(re.tpl_host_fuzzy_test), "i");
        var aliases = [];
        self2.__compiled__ = {};
        function schemaError(name, val) {
          throw new Error('(LinkifyIt) Invalid schema "' + name + '": ' + val);
        }
        Object.keys(self2.__schemas__).forEach(function(name) {
          var val = self2.__schemas__[name];
          if (val === null) {
            return;
          }
          var compiled = { validate: null, link: null };
          self2.__compiled__[name] = compiled;
          if (isObject(val)) {
            if (isRegExp(val.validate)) {
              compiled.validate = createValidator(val.validate);
            } else if (isFunction(val.validate)) {
              compiled.validate = val.validate;
            } else {
              schemaError(name, val);
            }
            if (isFunction(val.normalize)) {
              compiled.normalize = val.normalize;
            } else if (!val.normalize) {
              compiled.normalize = createNormalizer();
            } else {
              schemaError(name, val);
            }
            return;
          }
          if (isString(val)) {
            aliases.push(name);
            return;
          }
          schemaError(name, val);
        });
        aliases.forEach(function(alias) {
          if (!self2.__compiled__[self2.__schemas__[alias]]) {
            return;
          }
          self2.__compiled__[alias].validate = self2.__compiled__[self2.__schemas__[alias]].validate;
          self2.__compiled__[alias].normalize = self2.__compiled__[self2.__schemas__[alias]].normalize;
        });
        self2.__compiled__[""] = { validate: null, normalize: createNormalizer() };
        var slist = Object.keys(self2.__compiled__).filter(function(name) {
          return name.length > 0 && self2.__compiled__[name];
        }).map(escapeRE).join("|");
        self2.re.schema_test = RegExp("(^|(?!_)(?:[><\uFF5C]|" + re.src_ZPCc + "))(" + slist + ")", "i");
        self2.re.schema_search = RegExp("(^|(?!_)(?:[><\uFF5C]|" + re.src_ZPCc + "))(" + slist + ")", "ig");
        self2.re.schema_at_start = RegExp("^" + self2.re.schema_search.source, "i");
        self2.re.pretest = RegExp(
          "(" + self2.re.schema_test.source + ")|(" + self2.re.host_fuzzy_test.source + ")|@",
          "i"
        );
        resetScanCache(self2);
      }
      function Match(self2, shift) {
        var start = self2.__index__, end = self2.__last_index__, text = self2.__text_cache__.slice(start, end);
        this.schema = self2.__schema__.toLowerCase();
        this.index = start + shift;
        this.lastIndex = end + shift;
        this.raw = text;
        this.text = text;
        this.url = text;
      }
      function createMatch(self2, shift) {
        var match = new Match(self2, shift);
        self2.__compiled__[match.schema].normalize(match, self2);
        return match;
      }
      function LinkifyIt(schemas, options) {
        if (!(this instanceof LinkifyIt)) {
          return new LinkifyIt(schemas, options);
        }
        if (!options) {
          if (isOptionsObj(schemas)) {
            options = schemas;
            schemas = {};
          }
        }
        this.__opts__ = assign({}, defaultOptions, options);
        this.__index__ = -1;
        this.__last_index__ = -1;
        this.__schema__ = "";
        this.__text_cache__ = "";
        this.__schemas__ = assign({}, defaultSchemas, schemas);
        this.__compiled__ = {};
        this.__tlds__ = tlds_default;
        this.__tlds_replaced__ = false;
        this.re = {};
        compile(this);
      }
      LinkifyIt.prototype.add = function add(schema, definition) {
        this.__schemas__[schema] = definition;
        compile(this);
        return this;
      };
      LinkifyIt.prototype.set = function set(options) {
        this.__opts__ = assign(this.__opts__, options);
        return this;
      };
      LinkifyIt.prototype.test = function test(text) {
        this.__text_cache__ = text;
        this.__index__ = -1;
        if (!text.length) {
          return false;
        }
        var m, ml, me, len, shift, next, re, tld_pos, at_pos;
        if (this.re.schema_test.test(text)) {
          re = this.re.schema_search;
          re.lastIndex = 0;
          while ((m = re.exec(text)) !== null) {
            len = this.testSchemaAt(text, m[2], re.lastIndex);
            if (len) {
              this.__schema__ = m[2];
              this.__index__ = m.index + m[1].length;
              this.__last_index__ = m.index + m[0].length + len;
              break;
            }
          }
        }
        if (this.__opts__.fuzzyLink && this.__compiled__["http:"]) {
          tld_pos = text.search(this.re.host_fuzzy_test);
          if (tld_pos >= 0) {
            if (this.__index__ < 0 || tld_pos < this.__index__) {
              if ((ml = text.match(this.__opts__.fuzzyIP ? this.re.link_fuzzy : this.re.link_no_ip_fuzzy)) !== null) {
                shift = ml.index + ml[1].length;
                if (this.__index__ < 0 || shift < this.__index__) {
                  this.__schema__ = "";
                  this.__index__ = shift;
                  this.__last_index__ = ml.index + ml[0].length;
                }
              }
            }
          }
        }
        if (this.__opts__.fuzzyEmail && this.__compiled__["mailto:"]) {
          at_pos = text.indexOf("@");
          if (at_pos >= 0) {
            if ((me = text.match(this.re.email_fuzzy)) !== null) {
              shift = me.index + me[1].length;
              next = me.index + me[0].length;
              if (this.__index__ < 0 || shift < this.__index__ || shift === this.__index__ && next > this.__last_index__) {
                this.__schema__ = "mailto:";
                this.__index__ = shift;
                this.__last_index__ = next;
              }
            }
          }
        }
        return this.__index__ >= 0;
      };
      LinkifyIt.prototype.pretest = function pretest(text) {
        return this.re.pretest.test(text);
      };
      LinkifyIt.prototype.testSchemaAt = function testSchemaAt(text, schema, pos) {
        if (!this.__compiled__[schema.toLowerCase()]) {
          return 0;
        }
        return this.__compiled__[schema.toLowerCase()].validate(text, pos, this);
      };
      LinkifyIt.prototype.match = function match(text) {
        var shift = 0, result = [];
        if (this.__index__ >= 0 && this.__text_cache__ === text) {
          result.push(createMatch(this, shift));
          shift = this.__last_index__;
        }
        var tail = shift ? text.slice(shift) : text;
        while (this.test(tail)) {
          result.push(createMatch(this, shift));
          tail = tail.slice(this.__last_index__);
          shift += this.__last_index__;
        }
        if (result.length) {
          return result;
        }
        return null;
      };
      LinkifyIt.prototype.matchAtStart = function matchAtStart(text) {
        this.__text_cache__ = text;
        this.__index__ = -1;
        if (!text.length)
          return null;
        var m = this.re.schema_at_start.exec(text);
        if (!m)
          return null;
        var len = this.testSchemaAt(text, m[2], m[0].length);
        if (!len)
          return null;
        this.__schema__ = m[2];
        this.__index__ = m.index + m[1].length;
        this.__last_index__ = m.index + m[0].length + len;
        return createMatch(this, 0);
      };
      LinkifyIt.prototype.tlds = function tlds(list, keepOld) {
        list = Array.isArray(list) ? list : [list];
        if (!keepOld) {
          this.__tlds__ = list.slice();
          this.__tlds_replaced__ = true;
          compile(this);
          return this;
        }
        this.__tlds__ = this.__tlds__.concat(list).sort().filter(function(el, idx, arr) {
          return el !== arr[idx - 1];
        }).reverse();
        compile(this);
        return this;
      };
      LinkifyIt.prototype.normalize = function normalize(match) {
        if (!match.schema) {
          match.url = "http://" + match.url;
        }
        if (match.schema === "mailto:" && !/^mailto:/i.test(match.url)) {
          match.url = "mailto:" + match.url;
        }
      };
      LinkifyIt.prototype.onCompile = function onCompile() {
      };
      module.exports = LinkifyIt;
    }
  });

  // node_modules/punycode/punycode.js
  var require_punycode = __commonJS({
    "node_modules/punycode/punycode.js"(exports, module) {
      "use strict";
      var maxInt = 2147483647;
      var base = 36;
      var tMin = 1;
      var tMax = 26;
      var skew = 38;
      var damp = 700;
      var initialBias = 72;
      var initialN = 128;
      var delimiter = "-";
      var regexPunycode = /^xn--/;
      var regexNonASCII = /[^\0-\x7F]/;
      var regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g;
      var errors = {
        "overflow": "Overflow: input needs wider integers to process",
        "not-basic": "Illegal input >= 0x80 (not a basic code point)",
        "invalid-input": "Invalid input"
      };
      var baseMinusTMin = base - tMin;
      var floor = Math.floor;
      var stringFromCharCode = String.fromCharCode;
      function error(type) {
        throw new RangeError(errors[type]);
      }
      function map(array, callback) {
        const result = [];
        let length = array.length;
        while (length--) {
          result[length] = callback(array[length]);
        }
        return result;
      }
      function mapDomain(domain, callback) {
        const parts = domain.split("@");
        let result = "";
        if (parts.length > 1) {
          result = parts[0] + "@";
          domain = parts[1];
        }
        domain = domain.replace(regexSeparators, ".");
        const labels = domain.split(".");
        const encoded = map(labels, callback).join(".");
        return result + encoded;
      }
      function ucs2decode(string) {
        const output = [];
        let counter = 0;
        const length = string.length;
        while (counter < length) {
          const value = string.charCodeAt(counter++);
          if (value >= 55296 && value <= 56319 && counter < length) {
            const extra = string.charCodeAt(counter++);
            if ((extra & 64512) == 56320) {
              output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
            } else {
              output.push(value);
              counter--;
            }
          } else {
            output.push(value);
          }
        }
        return output;
      }
      var ucs2encode = (codePoints) => String.fromCodePoint(...codePoints);
      var basicToDigit = function(codePoint) {
        if (codePoint >= 48 && codePoint < 58) {
          return 26 + (codePoint - 48);
        }
        if (codePoint >= 65 && codePoint < 91) {
          return codePoint - 65;
        }
        if (codePoint >= 97 && codePoint < 123) {
          return codePoint - 97;
        }
        return base;
      };
      var digitToBasic = function(digit, flag) {
        return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
      };
      var adapt = function(delta, numPoints, firstTime) {
        let k = 0;
        delta = firstTime ? floor(delta / damp) : delta >> 1;
        delta += floor(delta / numPoints);
        for (; delta > baseMinusTMin * tMax >> 1; k += base) {
          delta = floor(delta / baseMinusTMin);
        }
        return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
      };
      var decode = function(input) {
        const output = [];
        const inputLength = input.length;
        let i = 0;
        let n = initialN;
        let bias = initialBias;
        let basic = input.lastIndexOf(delimiter);
        if (basic < 0) {
          basic = 0;
        }
        for (let j = 0; j < basic; ++j) {
          if (input.charCodeAt(j) >= 128) {
            error("not-basic");
          }
          output.push(input.charCodeAt(j));
        }
        for (let index = basic > 0 ? basic + 1 : 0; index < inputLength; ) {
          const oldi = i;
          for (let w = 1, k = base; ; k += base) {
            if (index >= inputLength) {
              error("invalid-input");
            }
            const digit = basicToDigit(input.charCodeAt(index++));
            if (digit >= base) {
              error("invalid-input");
            }
            if (digit > floor((maxInt - i) / w)) {
              error("overflow");
            }
            i += digit * w;
            const t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
            if (digit < t) {
              break;
            }
            const baseMinusT = base - t;
            if (w > floor(maxInt / baseMinusT)) {
              error("overflow");
            }
            w *= baseMinusT;
          }
          const out = output.length + 1;
          bias = adapt(i - oldi, out, oldi == 0);
          if (floor(i / out) > maxInt - n) {
            error("overflow");
          }
          n += floor(i / out);
          i %= out;
          output.splice(i++, 0, n);
        }
        return String.fromCodePoint(...output);
      };
      var encode = function(input) {
        const output = [];
        input = ucs2decode(input);
        const inputLength = input.length;
        let n = initialN;
        let delta = 0;
        let bias = initialBias;
        for (const currentValue of input) {
          if (currentValue < 128) {
            output.push(stringFromCharCode(currentValue));
          }
        }
        const basicLength = output.length;
        let handledCPCount = basicLength;
        if (basicLength) {
          output.push(delimiter);
        }
        while (handledCPCount < inputLength) {
          let m = maxInt;
          for (const currentValue of input) {
            if (currentValue >= n && currentValue < m) {
              m = currentValue;
            }
          }
          const handledCPCountPlusOne = handledCPCount + 1;
          if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
            error("overflow");
          }
          delta += (m - n) * handledCPCountPlusOne;
          n = m;
          for (const currentValue of input) {
            if (currentValue < n && ++delta > maxInt) {
              error("overflow");
            }
            if (currentValue === n) {
              let q = delta;
              for (let k = base; ; k += base) {
                const t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
                if (q < t) {
                  break;
                }
                const qMinusT = q - t;
                const baseMinusT = base - t;
                output.push(
                  stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
                );
                q = floor(qMinusT / baseMinusT);
              }
              output.push(stringFromCharCode(digitToBasic(q, 0)));
              bias = adapt(delta, handledCPCountPlusOne, handledCPCount === basicLength);
              delta = 0;
              ++handledCPCount;
            }
          }
          ++delta;
          ++n;
        }
        return output.join("");
      };
      var toUnicode = function(input) {
        return mapDomain(input, function(string) {
          return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
        });
      };
      var toASCII = function(input) {
        return mapDomain(input, function(string) {
          return regexNonASCII.test(string) ? "xn--" + encode(string) : string;
        });
      };
      var punycode = {
        /**
         * A string representing the current Punycode.js version number.
         * @memberOf punycode
         * @type String
         */
        "version": "2.1.0",
        /**
         * An object of methods to convert from JavaScript's internal character
         * representation (UCS-2) to Unicode code points, and back.
         * @see <https://mathiasbynens.be/notes/javascript-encoding>
         * @memberOf punycode
         * @type Object
         */
        "ucs2": {
          "decode": ucs2decode,
          "encode": ucs2encode
        },
        "decode": decode,
        "encode": encode,
        "toASCII": toASCII,
        "toUnicode": toUnicode
      };
      module.exports = punycode;
    }
  });

  // node_modules/markdown-it/lib/presets/default.js
  var require_default = __commonJS({
    "node_modules/markdown-it/lib/presets/default.js"(exports, module) {
      "use strict";
      module.exports = {
        options: {
          html: false,
          // Enable HTML tags in source
          xhtmlOut: false,
          // Use '/' to close single tags (<br />)
          breaks: false,
          // Convert '\n' in paragraphs into <br>
          langPrefix: "language-",
          // CSS language prefix for fenced blocks
          linkify: false,
          // autoconvert URL-like texts to links
          // Enable some language-neutral replacements + quotes beautification
          typographer: false,
          // Double + single quotes replacement pairs, when typographer enabled,
          // and smartquotes on. Could be either a String or an Array.
          //
          // For example, you can use '«»„“' for Russian, '„“‚‘' for German,
          // and ['«\xA0', '\xA0»', '‹\xA0', '\xA0›'] for French (including nbsp).
          quotes: "\u201C\u201D\u2018\u2019",
          /* “”‘’ */
          // Highlighter function. Should return escaped HTML,
          // or '' if the source string is not changed and should be escaped externaly.
          // If result starts with <pre... internal wrapper is skipped.
          //
          // function (/*str, lang*/) { return ''; }
          //
          highlight: null,
          maxNesting: 100
          // Internal protection, recursion limit
        },
        components: {
          core: {},
          block: {},
          inline: {}
        }
      };
    }
  });

  // node_modules/markdown-it/lib/presets/zero.js
  var require_zero = __commonJS({
    "node_modules/markdown-it/lib/presets/zero.js"(exports, module) {
      "use strict";
      module.exports = {
        options: {
          html: false,
          // Enable HTML tags in source
          xhtmlOut: false,
          // Use '/' to close single tags (<br />)
          breaks: false,
          // Convert '\n' in paragraphs into <br>
          langPrefix: "language-",
          // CSS language prefix for fenced blocks
          linkify: false,
          // autoconvert URL-like texts to links
          // Enable some language-neutral replacements + quotes beautification
          typographer: false,
          // Double + single quotes replacement pairs, when typographer enabled,
          // and smartquotes on. Could be either a String or an Array.
          //
          // For example, you can use '«»„“' for Russian, '„“‚‘' for German,
          // and ['«\xA0', '\xA0»', '‹\xA0', '\xA0›'] for French (including nbsp).
          quotes: "\u201C\u201D\u2018\u2019",
          /* “”‘’ */
          // Highlighter function. Should return escaped HTML,
          // or '' if the source string is not changed and should be escaped externaly.
          // If result starts with <pre... internal wrapper is skipped.
          //
          // function (/*str, lang*/) { return ''; }
          //
          highlight: null,
          maxNesting: 20
          // Internal protection, recursion limit
        },
        components: {
          core: {
            rules: [
              "normalize",
              "block",
              "inline",
              "text_join"
            ]
          },
          block: {
            rules: [
              "paragraph"
            ]
          },
          inline: {
            rules: [
              "text"
            ],
            rules2: [
              "balance_pairs",
              "fragments_join"
            ]
          }
        }
      };
    }
  });

  // node_modules/markdown-it/lib/presets/commonmark.js
  var require_commonmark = __commonJS({
    "node_modules/markdown-it/lib/presets/commonmark.js"(exports, module) {
      "use strict";
      module.exports = {
        options: {
          html: true,
          // Enable HTML tags in source
          xhtmlOut: true,
          // Use '/' to close single tags (<br />)
          breaks: false,
          // Convert '\n' in paragraphs into <br>
          langPrefix: "language-",
          // CSS language prefix for fenced blocks
          linkify: false,
          // autoconvert URL-like texts to links
          // Enable some language-neutral replacements + quotes beautification
          typographer: false,
          // Double + single quotes replacement pairs, when typographer enabled,
          // and smartquotes on. Could be either a String or an Array.
          //
          // For example, you can use '«»„“' for Russian, '„“‚‘' for German,
          // and ['«\xA0', '\xA0»', '‹\xA0', '\xA0›'] for French (including nbsp).
          quotes: "\u201C\u201D\u2018\u2019",
          /* “”‘’ */
          // Highlighter function. Should return escaped HTML,
          // or '' if the source string is not changed and should be escaped externaly.
          // If result starts with <pre... internal wrapper is skipped.
          //
          // function (/*str, lang*/) { return ''; }
          //
          highlight: null,
          maxNesting: 20
          // Internal protection, recursion limit
        },
        components: {
          core: {
            rules: [
              "normalize",
              "block",
              "inline",
              "text_join"
            ]
          },
          block: {
            rules: [
              "blockquote",
              "code",
              "fence",
              "heading",
              "hr",
              "html_block",
              "lheading",
              "list",
              "reference",
              "paragraph"
            ]
          },
          inline: {
            rules: [
              "autolink",
              "backticks",
              "emphasis",
              "entity",
              "escape",
              "html_inline",
              "image",
              "link",
              "newline",
              "text"
            ],
            rules2: [
              "balance_pairs",
              "emphasis",
              "fragments_join"
            ]
          }
        }
      };
    }
  });

  // node_modules/markdown-it/lib/index.js
  var require_lib6 = __commonJS({
    "node_modules/markdown-it/lib/index.js"(exports, module) {
      "use strict";
      var utils = require_utils();
      var helpers = require_helpers();
      var Renderer = require_renderer();
      var ParserCore = require_parser_core();
      var ParserBlock = require_parser_block();
      var ParserInline = require_parser_inline();
      var LinkifyIt = require_linkify_it();
      var mdurl = require_mdurl();
      var punycode = require_punycode();
      var config2 = {
        default: require_default(),
        zero: require_zero(),
        commonmark: require_commonmark()
      };
      var BAD_PROTO_RE = /^(vbscript|javascript|file|data):/;
      var GOOD_DATA_RE = /^data:image\/(gif|png|jpeg|webp);/;
      function validateLink(url) {
        var str = url.trim().toLowerCase();
        return BAD_PROTO_RE.test(str) ? GOOD_DATA_RE.test(str) ? true : false : true;
      }
      var RECODE_HOSTNAME_FOR = ["http:", "https:", "mailto:"];
      function normalizeLink(url) {
        var parsed = mdurl.parse(url, true);
        if (parsed.hostname) {
          if (!parsed.protocol || RECODE_HOSTNAME_FOR.indexOf(parsed.protocol) >= 0) {
            try {
              parsed.hostname = punycode.toASCII(parsed.hostname);
            } catch (er) {
            }
          }
        }
        return mdurl.encode(mdurl.format(parsed));
      }
      function normalizeLinkText(url) {
        var parsed = mdurl.parse(url, true);
        if (parsed.hostname) {
          if (!parsed.protocol || RECODE_HOSTNAME_FOR.indexOf(parsed.protocol) >= 0) {
            try {
              parsed.hostname = punycode.toUnicode(parsed.hostname);
            } catch (er) {
            }
          }
        }
        return mdurl.decode(mdurl.format(parsed), mdurl.decode.defaultChars + "%");
      }
      function MarkdownIt(presetName, options) {
        if (!(this instanceof MarkdownIt)) {
          return new MarkdownIt(presetName, options);
        }
        if (!options) {
          if (!utils.isString(presetName)) {
            options = presetName || {};
            presetName = "default";
          }
        }
        this.inline = new ParserInline();
        this.block = new ParserBlock();
        this.core = new ParserCore();
        this.renderer = new Renderer();
        this.linkify = new LinkifyIt();
        this.validateLink = validateLink;
        this.normalizeLink = normalizeLink;
        this.normalizeLinkText = normalizeLinkText;
        this.utils = utils;
        this.helpers = utils.assign({}, helpers);
        this.options = {};
        this.configure(presetName);
        if (options) {
          this.set(options);
        }
      }
      MarkdownIt.prototype.set = function(options) {
        utils.assign(this.options, options);
        return this;
      };
      MarkdownIt.prototype.configure = function(presets) {
        var self2 = this, presetName;
        if (utils.isString(presets)) {
          presetName = presets;
          presets = config2[presetName];
          if (!presets) {
            throw new Error('Wrong `markdown-it` preset "' + presetName + '", check name');
          }
        }
        if (!presets) {
          throw new Error("Wrong `markdown-it` preset, can't be empty");
        }
        if (presets.options) {
          self2.set(presets.options);
        }
        if (presets.components) {
          Object.keys(presets.components).forEach(function(name) {
            if (presets.components[name].rules) {
              self2[name].ruler.enableOnly(presets.components[name].rules);
            }
            if (presets.components[name].rules2) {
              self2[name].ruler2.enableOnly(presets.components[name].rules2);
            }
          });
        }
        return this;
      };
      MarkdownIt.prototype.enable = function(list, ignoreInvalid) {
        var result = [];
        if (!Array.isArray(list)) {
          list = [list];
        }
        ["core", "block", "inline"].forEach(function(chain) {
          result = result.concat(this[chain].ruler.enable(list, true));
        }, this);
        result = result.concat(this.inline.ruler2.enable(list, true));
        var missed = list.filter(function(name) {
          return result.indexOf(name) < 0;
        });
        if (missed.length && !ignoreInvalid) {
          throw new Error("MarkdownIt. Failed to enable unknown rule(s): " + missed);
        }
        return this;
      };
      MarkdownIt.prototype.disable = function(list, ignoreInvalid) {
        var result = [];
        if (!Array.isArray(list)) {
          list = [list];
        }
        ["core", "block", "inline"].forEach(function(chain) {
          result = result.concat(this[chain].ruler.disable(list, true));
        }, this);
        result = result.concat(this.inline.ruler2.disable(list, true));
        var missed = list.filter(function(name) {
          return result.indexOf(name) < 0;
        });
        if (missed.length && !ignoreInvalid) {
          throw new Error("MarkdownIt. Failed to disable unknown rule(s): " + missed);
        }
        return this;
      };
      MarkdownIt.prototype.use = function(plugin) {
        var args = [this].concat(Array.prototype.slice.call(arguments, 1));
        plugin.apply(plugin, args);
        return this;
      };
      MarkdownIt.prototype.parse = function(src, env) {
        if (typeof src !== "string") {
          throw new Error("Input data should be a String");
        }
        var state = new this.core.State(src, this, env);
        this.core.process(state);
        return state.tokens;
      };
      MarkdownIt.prototype.render = function(src, env) {
        env = env || {};
        return this.renderer.render(this.parse(src, env), this.options, env);
      };
      MarkdownIt.prototype.parseInline = function(src, env) {
        var state = new this.core.State(src, this, env);
        state.inlineMode = true;
        this.core.process(state);
        return state.tokens;
      };
      MarkdownIt.prototype.renderInline = function(src, env) {
        env = env || {};
        return this.renderer.render(this.parseInline(src, env), this.options, env);
      };
      module.exports = MarkdownIt;
    }
  });

  // node_modules/markdown-it/index.js
  var require_markdown_it = __commonJS({
    "node_modules/markdown-it/index.js"(exports, module) {
      "use strict";
      module.exports = require_lib6();
    }
  });

  // node_modules/mathjax-full/js/components/version.js
  var require_version = __commonJS({
    "node_modules/mathjax-full/js/components/version.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.VERSION = void 0;
      exports.VERSION = "3.2.2";
    }
  });

  // node_modules/mathjax-full/js/util/PrioritizedList.js
  var require_PrioritizedList = __commonJS({
    "node_modules/mathjax-full/js/util/PrioritizedList.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.PrioritizedList = void 0;
      var PrioritizedList = function() {
        function PrioritizedList2() {
          this.items = [];
          this.items = [];
        }
        PrioritizedList2.prototype[Symbol.iterator] = function() {
          var i = 0;
          var items = this.items;
          return {
            next: function() {
              return { value: items[i++], done: i > items.length };
            }
          };
        };
        PrioritizedList2.prototype.add = function(item, priority) {
          if (priority === void 0) {
            priority = PrioritizedList2.DEFAULTPRIORITY;
          }
          var i = this.items.length;
          do {
            i--;
          } while (i >= 0 && priority < this.items[i].priority);
          this.items.splice(i + 1, 0, { item, priority });
          return item;
        };
        PrioritizedList2.prototype.remove = function(item) {
          var i = this.items.length;
          do {
            i--;
          } while (i >= 0 && this.items[i].item !== item);
          if (i >= 0) {
            this.items.splice(i, 1);
          }
        };
        PrioritizedList2.DEFAULTPRIORITY = 5;
        return PrioritizedList2;
      }();
      exports.PrioritizedList = PrioritizedList;
    }
  });

  // node_modules/mathjax-full/js/core/HandlerList.js
  var require_HandlerList = __commonJS({
    "node_modules/mathjax-full/js/core/HandlerList.js"(exports) {
      "use strict";
      var __extends2 = exports && exports.__extends || function() {
        var extendStatics2 = function(d, b) {
          extendStatics2 = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
            d2.__proto__ = b2;
          } || function(d2, b2) {
            for (var p in b2)
              if (Object.prototype.hasOwnProperty.call(b2, p))
                d2[p] = b2[p];
          };
          return extendStatics2(d, b);
        };
        return function(d, b) {
          if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
          extendStatics2(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.HandlerList = void 0;
      var PrioritizedList_js_1 = require_PrioritizedList();
      var HandlerList = function(_super) {
        __extends2(HandlerList2, _super);
        function HandlerList2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        HandlerList2.prototype.register = function(handler) {
          return this.add(handler, handler.priority);
        };
        HandlerList2.prototype.unregister = function(handler) {
          this.remove(handler);
        };
        HandlerList2.prototype.handlesDocument = function(document2) {
          var e_1, _a;
          try {
            for (var _b = __values2(this), _c = _b.next(); !_c.done; _c = _b.next()) {
              var item = _c.value;
              var handler = item.item;
              if (handler.handlesDocument(document2)) {
                return handler;
              }
            }
          } catch (e_1_1) {
            e_1 = { error: e_1_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_1)
                throw e_1.error;
            }
          }
          throw new Error("Can't find handler for document");
        };
        HandlerList2.prototype.document = function(document2, options) {
          if (options === void 0) {
            options = null;
          }
          return this.handlesDocument(document2).create(document2, options);
        };
        return HandlerList2;
      }(PrioritizedList_js_1.PrioritizedList);
      exports.HandlerList = HandlerList;
    }
  });

  // node_modules/mathjax-full/js/util/Retries.js
  var require_Retries = __commonJS({
    "node_modules/mathjax-full/js/util/Retries.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.retryAfter = exports.handleRetriesFor = void 0;
      function handleRetriesFor(code) {
        return new Promise(function run(ok, fail) {
          try {
            ok(code());
          } catch (err) {
            if (err.retry && err.retry instanceof Promise) {
              err.retry.then(function() {
                return run(ok, fail);
              }).catch(function(perr) {
                return fail(perr);
              });
            } else if (err.restart && err.restart.isCallback) {
              MathJax.Callback.After(function() {
                return run(ok, fail);
              }, err.restart);
            } else {
              fail(err);
            }
          }
        });
      }
      exports.handleRetriesFor = handleRetriesFor;
      function retryAfter(promise) {
        var err = new Error("MathJax retry");
        err.retry = promise;
        throw err;
      }
      exports.retryAfter = retryAfter;
    }
  });

  // node_modules/mathjax-full/js/mathjax.js
  var require_mathjax = __commonJS({
    "node_modules/mathjax-full/js/mathjax.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.mathjax = void 0;
      var version_js_1 = require_version();
      var HandlerList_js_1 = require_HandlerList();
      var Retries_js_1 = require_Retries();
      exports.mathjax = {
        version: version_js_1.VERSION,
        handlers: new HandlerList_js_1.HandlerList(),
        document: function(document2, options) {
          return exports.mathjax.handlers.document(document2, options);
        },
        handleRetriesFor: Retries_js_1.handleRetriesFor,
        retryAfter: Retries_js_1.retryAfter,
        asyncLoad: null
      };
    }
  });

  // node_modules/mathjax-full/js/util/Options.js
  var require_Options = __commonJS({
    "node_modules/mathjax-full/js/util/Options.js"(exports) {
      "use strict";
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      var __spreadArray2 = exports && exports.__spreadArray || function(to, from, pack) {
        if (pack || arguments.length === 2)
          for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
              if (!ar)
                ar = Array.prototype.slice.call(from, 0, i);
              ar[i] = from[i];
            }
          }
        return to.concat(ar || Array.prototype.slice.call(from));
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.lookup = exports.separateOptions = exports.selectOptionsFromKeys = exports.selectOptions = exports.userOptions = exports.defaultOptions = exports.insert = exports.copy = exports.keys = exports.makeArray = exports.expandable = exports.Expandable = exports.OPTIONS = exports.REMOVE = exports.APPEND = exports.isObject = void 0;
      var OBJECT = {}.constructor;
      function isObject(obj) {
        return typeof obj === "object" && obj !== null && (obj.constructor === OBJECT || obj.constructor === Expandable);
      }
      exports.isObject = isObject;
      exports.APPEND = "[+]";
      exports.REMOVE = "[-]";
      exports.OPTIONS = {
        invalidOption: "warn",
        optionError: function(message, _key) {
          if (exports.OPTIONS.invalidOption === "fatal") {
            throw new Error(message);
          }
          console.warn("MathJax: " + message);
        }
      };
      var Expandable = function() {
        function Expandable2() {
        }
        return Expandable2;
      }();
      exports.Expandable = Expandable;
      function expandable(def) {
        return Object.assign(Object.create(Expandable.prototype), def);
      }
      exports.expandable = expandable;
      function makeArray(x) {
        return Array.isArray(x) ? x : [x];
      }
      exports.makeArray = makeArray;
      function keys(def) {
        if (!def) {
          return [];
        }
        return Object.keys(def).concat(Object.getOwnPropertySymbols(def));
      }
      exports.keys = keys;
      function copy(def) {
        var e_1, _a;
        var props = {};
        try {
          for (var _b = __values2(keys(def)), _c = _b.next(); !_c.done; _c = _b.next()) {
            var key = _c.value;
            var prop = Object.getOwnPropertyDescriptor(def, key);
            var value = prop.value;
            if (Array.isArray(value)) {
              prop.value = insert([], value, false);
            } else if (isObject(value)) {
              prop.value = copy(value);
            }
            if (prop.enumerable) {
              props[key] = prop;
            }
          }
        } catch (e_1_1) {
          e_1 = { error: e_1_1 };
        } finally {
          try {
            if (_c && !_c.done && (_a = _b.return))
              _a.call(_b);
          } finally {
            if (e_1)
              throw e_1.error;
          }
        }
        return Object.defineProperties(def.constructor === Expandable ? expandable({}) : {}, props);
      }
      exports.copy = copy;
      function insert(dst, src, warn) {
        var e_2, _a;
        if (warn === void 0) {
          warn = true;
        }
        var _loop_1 = function(key2) {
          if (warn && dst[key2] === void 0 && dst.constructor !== Expandable) {
            if (typeof key2 === "symbol") {
              key2 = key2.toString();
            }
            exports.OPTIONS.optionError('Invalid option "'.concat(key2, '" (no default value).'), key2);
            return "continue";
          }
          var sval = src[key2], dval = dst[key2];
          if (isObject(sval) && dval !== null && (typeof dval === "object" || typeof dval === "function")) {
            var ids = keys(sval);
            if (Array.isArray(dval) && (ids.length === 1 && (ids[0] === exports.APPEND || ids[0] === exports.REMOVE) && Array.isArray(sval[ids[0]]) || ids.length === 2 && ids.sort().join(",") === exports.APPEND + "," + exports.REMOVE && Array.isArray(sval[exports.APPEND]) && Array.isArray(sval[exports.REMOVE]))) {
              if (sval[exports.REMOVE]) {
                dval = dst[key2] = dval.filter(function(x) {
                  return sval[exports.REMOVE].indexOf(x) < 0;
                });
              }
              if (sval[exports.APPEND]) {
                dst[key2] = __spreadArray2(__spreadArray2([], __read2(dval), false), __read2(sval[exports.APPEND]), false);
              }
            } else {
              insert(dval, sval, warn);
            }
          } else if (Array.isArray(sval)) {
            dst[key2] = [];
            insert(dst[key2], sval, false);
          } else if (isObject(sval)) {
            dst[key2] = copy(sval);
          } else {
            dst[key2] = sval;
          }
        };
        try {
          for (var _b = __values2(keys(src)), _c = _b.next(); !_c.done; _c = _b.next()) {
            var key = _c.value;
            _loop_1(key);
          }
        } catch (e_2_1) {
          e_2 = { error: e_2_1 };
        } finally {
          try {
            if (_c && !_c.done && (_a = _b.return))
              _a.call(_b);
          } finally {
            if (e_2)
              throw e_2.error;
          }
        }
        return dst;
      }
      exports.insert = insert;
      function defaultOptions(options) {
        var defs = [];
        for (var _i = 1; _i < arguments.length; _i++) {
          defs[_i - 1] = arguments[_i];
        }
        defs.forEach(function(def) {
          return insert(options, def, false);
        });
        return options;
      }
      exports.defaultOptions = defaultOptions;
      function userOptions(options) {
        var defs = [];
        for (var _i = 1; _i < arguments.length; _i++) {
          defs[_i - 1] = arguments[_i];
        }
        defs.forEach(function(def) {
          return insert(options, def, true);
        });
        return options;
      }
      exports.userOptions = userOptions;
      function selectOptions(options) {
        var e_3, _a;
        var keys2 = [];
        for (var _i = 1; _i < arguments.length; _i++) {
          keys2[_i - 1] = arguments[_i];
        }
        var subset = {};
        try {
          for (var keys_1 = __values2(keys2), keys_1_1 = keys_1.next(); !keys_1_1.done; keys_1_1 = keys_1.next()) {
            var key = keys_1_1.value;
            if (options.hasOwnProperty(key)) {
              subset[key] = options[key];
            }
          }
        } catch (e_3_1) {
          e_3 = { error: e_3_1 };
        } finally {
          try {
            if (keys_1_1 && !keys_1_1.done && (_a = keys_1.return))
              _a.call(keys_1);
          } finally {
            if (e_3)
              throw e_3.error;
          }
        }
        return subset;
      }
      exports.selectOptions = selectOptions;
      function selectOptionsFromKeys(options, object) {
        return selectOptions.apply(void 0, __spreadArray2([options], __read2(Object.keys(object)), false));
      }
      exports.selectOptionsFromKeys = selectOptionsFromKeys;
      function separateOptions(options) {
        var e_4, _a, e_5, _b;
        var objects = [];
        for (var _i = 1; _i < arguments.length; _i++) {
          objects[_i - 1] = arguments[_i];
        }
        var results = [];
        try {
          for (var objects_1 = __values2(objects), objects_1_1 = objects_1.next(); !objects_1_1.done; objects_1_1 = objects_1.next()) {
            var object = objects_1_1.value;
            var exists = {}, missing = {};
            try {
              for (var _c = (e_5 = void 0, __values2(Object.keys(options || {}))), _d = _c.next(); !_d.done; _d = _c.next()) {
                var key = _d.value;
                (object[key] === void 0 ? missing : exists)[key] = options[key];
              }
            } catch (e_5_1) {
              e_5 = { error: e_5_1 };
            } finally {
              try {
                if (_d && !_d.done && (_b = _c.return))
                  _b.call(_c);
              } finally {
                if (e_5)
                  throw e_5.error;
              }
            }
            results.push(exists);
            options = missing;
          }
        } catch (e_4_1) {
          e_4 = { error: e_4_1 };
        } finally {
          try {
            if (objects_1_1 && !objects_1_1.done && (_a = objects_1.return))
              _a.call(objects_1);
          } finally {
            if (e_4)
              throw e_4.error;
          }
        }
        results.unshift(options);
        return results;
      }
      exports.separateOptions = separateOptions;
      function lookup(name, lookup2, def) {
        if (def === void 0) {
          def = null;
        }
        return lookup2.hasOwnProperty(name) ? lookup2[name] : def;
      }
      exports.lookup = lookup;
    }
  });

  // node_modules/mathjax-full/js/util/FunctionList.js
  var require_FunctionList = __commonJS({
    "node_modules/mathjax-full/js/util/FunctionList.js"(exports) {
      "use strict";
      var __extends2 = exports && exports.__extends || function() {
        var extendStatics2 = function(d, b) {
          extendStatics2 = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
            d2.__proto__ = b2;
          } || function(d2, b2) {
            for (var p in b2)
              if (Object.prototype.hasOwnProperty.call(b2, p))
                d2[p] = b2[p];
          };
          return extendStatics2(d, b);
        };
        return function(d, b) {
          if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
          extendStatics2(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      var __spreadArray2 = exports && exports.__spreadArray || function(to, from, pack) {
        if (pack || arguments.length === 2)
          for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
              if (!ar)
                ar = Array.prototype.slice.call(from, 0, i);
              ar[i] = from[i];
            }
          }
        return to.concat(ar || Array.prototype.slice.call(from));
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FunctionList = void 0;
      var PrioritizedList_js_1 = require_PrioritizedList();
      var FunctionList = function(_super) {
        __extends2(FunctionList2, _super);
        function FunctionList2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        FunctionList2.prototype.execute = function() {
          var e_1, _a;
          var data = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            data[_i] = arguments[_i];
          }
          try {
            for (var _b = __values2(this), _c = _b.next(); !_c.done; _c = _b.next()) {
              var item = _c.value;
              var result = item.item.apply(item, __spreadArray2([], __read2(data), false));
              if (result === false) {
                return false;
              }
            }
          } catch (e_1_1) {
            e_1 = { error: e_1_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_1)
                throw e_1.error;
            }
          }
          return true;
        };
        FunctionList2.prototype.asyncExecute = function() {
          var data = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            data[_i] = arguments[_i];
          }
          var i = -1;
          var items = this.items;
          return new Promise(function(ok, fail) {
            (function execute() {
              var _a;
              while (++i < items.length) {
                var result = (_a = items[i]).item.apply(_a, __spreadArray2([], __read2(data), false));
                if (result instanceof Promise) {
                  result.then(execute).catch(function(err) {
                    return fail(err);
                  });
                  return;
                }
                if (result === false) {
                  ok(false);
                  return;
                }
              }
              ok(true);
            })();
          });
        };
        return FunctionList2;
      }(PrioritizedList_js_1.PrioritizedList);
      exports.FunctionList = FunctionList;
    }
  });

  // node_modules/mathjax-full/js/core/InputJax.js
  var require_InputJax = __commonJS({
    "node_modules/mathjax-full/js/core/InputJax.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AbstractInputJax = void 0;
      var Options_js_1 = require_Options();
      var FunctionList_js_1 = require_FunctionList();
      var AbstractInputJax = function() {
        function AbstractInputJax2(options) {
          if (options === void 0) {
            options = {};
          }
          this.adaptor = null;
          this.mmlFactory = null;
          var CLASS = this.constructor;
          this.options = (0, Options_js_1.userOptions)((0, Options_js_1.defaultOptions)({}, CLASS.OPTIONS), options);
          this.preFilters = new FunctionList_js_1.FunctionList();
          this.postFilters = new FunctionList_js_1.FunctionList();
        }
        Object.defineProperty(AbstractInputJax2.prototype, "name", {
          get: function() {
            return this.constructor.NAME;
          },
          enumerable: false,
          configurable: true
        });
        AbstractInputJax2.prototype.setAdaptor = function(adaptor) {
          this.adaptor = adaptor;
        };
        AbstractInputJax2.prototype.setMmlFactory = function(mmlFactory) {
          this.mmlFactory = mmlFactory;
        };
        AbstractInputJax2.prototype.initialize = function() {
        };
        AbstractInputJax2.prototype.reset = function() {
          var _args = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            _args[_i] = arguments[_i];
          }
        };
        Object.defineProperty(AbstractInputJax2.prototype, "processStrings", {
          get: function() {
            return true;
          },
          enumerable: false,
          configurable: true
        });
        AbstractInputJax2.prototype.findMath = function(_node, _options) {
          return [];
        };
        AbstractInputJax2.prototype.executeFilters = function(filters, math, document2, data) {
          var args = { math, document: document2, data };
          filters.execute(args);
          return args.data;
        };
        AbstractInputJax2.NAME = "generic";
        AbstractInputJax2.OPTIONS = {};
        return AbstractInputJax2;
      }();
      exports.AbstractInputJax = AbstractInputJax;
    }
  });

  // node_modules/mathjax-full/js/core/FindMath.js
  var require_FindMath = __commonJS({
    "node_modules/mathjax-full/js/core/FindMath.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AbstractFindMath = void 0;
      var Options_js_1 = require_Options();
      var AbstractFindMath = function() {
        function AbstractFindMath2(options) {
          var CLASS = this.constructor;
          this.options = (0, Options_js_1.userOptions)((0, Options_js_1.defaultOptions)({}, CLASS.OPTIONS), options);
        }
        AbstractFindMath2.OPTIONS = {};
        return AbstractFindMath2;
      }();
      exports.AbstractFindMath = AbstractFindMath;
    }
  });

  // node_modules/mathjax-full/js/util/string.js
  var require_string = __commonJS({
    "node_modules/mathjax-full/js/util/string.js"(exports) {
      "use strict";
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      var __spreadArray2 = exports && exports.__spreadArray || function(to, from, pack) {
        if (pack || arguments.length === 2)
          for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
              if (!ar)
                ar = Array.prototype.slice.call(from, 0, i);
              ar[i] = from[i];
            }
          }
        return to.concat(ar || Array.prototype.slice.call(from));
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.split = exports.isPercent = exports.unicodeString = exports.unicodeChars = exports.quotePattern = exports.sortLength = void 0;
      function sortLength(a, b) {
        return a.length !== b.length ? b.length - a.length : a === b ? 0 : a < b ? -1 : 1;
      }
      exports.sortLength = sortLength;
      function quotePattern(text) {
        return text.replace(/([\^$(){}+*?\-|\[\]\:\\])/g, "\\$1");
      }
      exports.quotePattern = quotePattern;
      function unicodeChars(text) {
        return Array.from(text).map(function(c) {
          return c.codePointAt(0);
        });
      }
      exports.unicodeChars = unicodeChars;
      function unicodeString(data) {
        return String.fromCodePoint.apply(String, __spreadArray2([], __read2(data), false));
      }
      exports.unicodeString = unicodeString;
      function isPercent(x) {
        return !!x.match(/%\s*$/);
      }
      exports.isPercent = isPercent;
      function split(x) {
        return x.trim().split(/\s+/);
      }
      exports.split = split;
    }
  });

  // node_modules/mathjax-full/js/core/MathItem.js
  var require_MathItem = __commonJS({
    "node_modules/mathjax-full/js/core/MathItem.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.newState = exports.STATE = exports.AbstractMathItem = exports.protoItem = void 0;
      function protoItem(open, math, close, n, start, end, display) {
        if (display === void 0) {
          display = null;
        }
        var item = {
          open,
          math,
          close,
          n,
          start: { n: start },
          end: { n: end },
          display
        };
        return item;
      }
      exports.protoItem = protoItem;
      var AbstractMathItem = function() {
        function AbstractMathItem2(math, jax, display, start, end) {
          if (display === void 0) {
            display = true;
          }
          if (start === void 0) {
            start = { i: 0, n: 0, delim: "" };
          }
          if (end === void 0) {
            end = { i: 0, n: 0, delim: "" };
          }
          this.root = null;
          this.typesetRoot = null;
          this.metrics = {};
          this.inputData = {};
          this.outputData = {};
          this._state = exports.STATE.UNPROCESSED;
          this.math = math;
          this.inputJax = jax;
          this.display = display;
          this.start = start;
          this.end = end;
          this.root = null;
          this.typesetRoot = null;
          this.metrics = {};
          this.inputData = {};
          this.outputData = {};
        }
        Object.defineProperty(AbstractMathItem2.prototype, "isEscaped", {
          get: function() {
            return this.display === null;
          },
          enumerable: false,
          configurable: true
        });
        AbstractMathItem2.prototype.render = function(document2) {
          document2.renderActions.renderMath(this, document2);
        };
        AbstractMathItem2.prototype.rerender = function(document2, start) {
          if (start === void 0) {
            start = exports.STATE.RERENDER;
          }
          if (this.state() >= start) {
            this.state(start - 1);
          }
          document2.renderActions.renderMath(this, document2, start);
        };
        AbstractMathItem2.prototype.convert = function(document2, end) {
          if (end === void 0) {
            end = exports.STATE.LAST;
          }
          document2.renderActions.renderConvert(this, document2, end);
        };
        AbstractMathItem2.prototype.compile = function(document2) {
          if (this.state() < exports.STATE.COMPILED) {
            this.root = this.inputJax.compile(this, document2);
            this.state(exports.STATE.COMPILED);
          }
        };
        AbstractMathItem2.prototype.typeset = function(document2) {
          if (this.state() < exports.STATE.TYPESET) {
            this.typesetRoot = document2.outputJax[this.isEscaped ? "escaped" : "typeset"](this, document2);
            this.state(exports.STATE.TYPESET);
          }
        };
        AbstractMathItem2.prototype.updateDocument = function(_document) {
        };
        AbstractMathItem2.prototype.removeFromDocument = function(_restore) {
          if (_restore === void 0) {
            _restore = false;
          }
        };
        AbstractMathItem2.prototype.setMetrics = function(em, ex, cwidth, lwidth, scale) {
          this.metrics = {
            em,
            ex,
            containerWidth: cwidth,
            lineWidth: lwidth,
            scale
          };
        };
        AbstractMathItem2.prototype.state = function(state, restore) {
          if (state === void 0) {
            state = null;
          }
          if (restore === void 0) {
            restore = false;
          }
          if (state != null) {
            if (state < exports.STATE.INSERTED && this._state >= exports.STATE.INSERTED) {
              this.removeFromDocument(restore);
            }
            if (state < exports.STATE.TYPESET && this._state >= exports.STATE.TYPESET) {
              this.outputData = {};
            }
            if (state < exports.STATE.COMPILED && this._state >= exports.STATE.COMPILED) {
              this.inputData = {};
            }
            this._state = state;
          }
          return this._state;
        };
        AbstractMathItem2.prototype.reset = function(restore) {
          if (restore === void 0) {
            restore = false;
          }
          this.state(exports.STATE.UNPROCESSED, restore);
        };
        return AbstractMathItem2;
      }();
      exports.AbstractMathItem = AbstractMathItem;
      exports.STATE = {
        UNPROCESSED: 0,
        FINDMATH: 10,
        COMPILED: 20,
        CONVERT: 100,
        METRICS: 110,
        RERENDER: 125,
        TYPESET: 150,
        INSERTED: 200,
        LAST: 1e4
      };
      function newState(name, state) {
        if (name in exports.STATE) {
          throw Error("State " + name + " already exists");
        }
        exports.STATE[name] = state;
      }
      exports.newState = newState;
    }
  });

  // node_modules/mathjax-full/js/input/tex/FindTeX.js
  var require_FindTeX = __commonJS({
    "node_modules/mathjax-full/js/input/tex/FindTeX.js"(exports) {
      "use strict";
      var __extends2 = exports && exports.__extends || function() {
        var extendStatics2 = function(d, b) {
          extendStatics2 = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
            d2.__proto__ = b2;
          } || function(d2, b2) {
            for (var p in b2)
              if (Object.prototype.hasOwnProperty.call(b2, p))
                d2[p] = b2[p];
          };
          return extendStatics2(d, b);
        };
        return function(d, b) {
          if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
          extendStatics2(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.FindTeX = void 0;
      var FindMath_js_1 = require_FindMath();
      var string_js_1 = require_string();
      var MathItem_js_1 = require_MathItem();
      var FindTeX = function(_super) {
        __extends2(FindTeX2, _super);
        function FindTeX2(options) {
          var _this = _super.call(this, options) || this;
          _this.getPatterns();
          return _this;
        }
        FindTeX2.prototype.getPatterns = function() {
          var _this = this;
          var options = this.options;
          var starts = [], parts = [], subparts = [];
          this.end = {};
          this.env = this.sub = 0;
          var i = 1;
          options["inlineMath"].forEach(function(delims) {
            return _this.addPattern(starts, delims, false);
          });
          options["displayMath"].forEach(function(delims) {
            return _this.addPattern(starts, delims, true);
          });
          if (starts.length) {
            parts.push(starts.sort(string_js_1.sortLength).join("|"));
          }
          if (options["processEnvironments"]) {
            parts.push("\\\\begin\\s*\\{([^}]*)\\}");
            this.env = i;
            i++;
          }
          if (options["processEscapes"]) {
            subparts.push("\\\\([\\\\$])");
          }
          if (options["processRefs"]) {
            subparts.push("(\\\\(?:eq)?ref\\s*\\{[^}]*\\})");
          }
          if (subparts.length) {
            parts.push("(" + subparts.join("|") + ")");
            this.sub = i;
          }
          this.start = new RegExp(parts.join("|"), "g");
          this.hasPatterns = parts.length > 0;
        };
        FindTeX2.prototype.addPattern = function(starts, delims, display) {
          var _a = __read2(delims, 2), open = _a[0], close = _a[1];
          starts.push((0, string_js_1.quotePattern)(open));
          this.end[open] = [close, display, this.endPattern(close)];
        };
        FindTeX2.prototype.endPattern = function(end, endp) {
          return new RegExp((endp || (0, string_js_1.quotePattern)(end)) + "|\\\\(?:[a-zA-Z]|.)|[{}]", "g");
        };
        FindTeX2.prototype.findEnd = function(text, n, start, end) {
          var _a = __read2(end, 3), close = _a[0], display = _a[1], pattern = _a[2];
          var i = pattern.lastIndex = start.index + start[0].length;
          var match, braces = 0;
          while (match = pattern.exec(text)) {
            if ((match[1] || match[0]) === close && braces === 0) {
              return (0, MathItem_js_1.protoItem)(start[0], text.substr(i, match.index - i), match[0], n, start.index, match.index + match[0].length, display);
            } else if (match[0] === "{") {
              braces++;
            } else if (match[0] === "}" && braces) {
              braces--;
            }
          }
          return null;
        };
        FindTeX2.prototype.findMathInString = function(math, n, text) {
          var start, match;
          this.start.lastIndex = 0;
          while (start = this.start.exec(text)) {
            if (start[this.env] !== void 0 && this.env) {
              var end = "\\\\end\\s*(\\{" + (0, string_js_1.quotePattern)(start[this.env]) + "\\})";
              match = this.findEnd(text, n, start, ["{" + start[this.env] + "}", true, this.endPattern(null, end)]);
              if (match) {
                match.math = match.open + match.math + match.close;
                match.open = match.close = "";
              }
            } else if (start[this.sub] !== void 0 && this.sub) {
              var math_1 = start[this.sub];
              var end = start.index + start[this.sub].length;
              if (math_1.length === 2) {
                match = (0, MathItem_js_1.protoItem)("", math_1.substr(1), "", n, start.index, end);
              } else {
                match = (0, MathItem_js_1.protoItem)("", math_1, "", n, start.index, end, false);
              }
            } else {
              match = this.findEnd(text, n, start, this.end[start[0]]);
            }
            if (match) {
              math.push(match);
              this.start.lastIndex = match.end.n;
            }
          }
        };
        FindTeX2.prototype.findMath = function(strings) {
          var math = [];
          if (this.hasPatterns) {
            for (var i = 0, m = strings.length; i < m; i++) {
              this.findMathInString(math, i, strings[i]);
            }
          }
          return math;
        };
        FindTeX2.OPTIONS = {
          inlineMath: [
            ["\\(", "\\)"]
          ],
          displayMath: [
            ["$$", "$$"],
            ["\\[", "\\]"]
          ],
          processEscapes: true,
          processEnvironments: true,
          processRefs: true
        };
        return FindTeX2;
      }(FindMath_js_1.AbstractFindMath);
      exports.FindTeX = FindTeX;
    }
  });

  // node_modules/mathjax-full/js/core/MmlTree/Attributes.js
  var require_Attributes = __commonJS({
    "node_modules/mathjax-full/js/core/MmlTree/Attributes.js"(exports) {
      "use strict";
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Attributes = exports.INHERIT = void 0;
      exports.INHERIT = "_inherit_";
      var Attributes = function() {
        function Attributes2(defaults, global2) {
          this.global = global2;
          this.defaults = Object.create(global2);
          this.inherited = Object.create(this.defaults);
          this.attributes = Object.create(this.inherited);
          Object.assign(this.defaults, defaults);
        }
        Attributes2.prototype.set = function(name, value) {
          this.attributes[name] = value;
        };
        Attributes2.prototype.setList = function(list) {
          Object.assign(this.attributes, list);
        };
        Attributes2.prototype.get = function(name) {
          var value = this.attributes[name];
          if (value === exports.INHERIT) {
            value = this.global[name];
          }
          return value;
        };
        Attributes2.prototype.getExplicit = function(name) {
          if (!this.attributes.hasOwnProperty(name)) {
            return void 0;
          }
          return this.attributes[name];
        };
        Attributes2.prototype.getList = function() {
          var e_1, _a;
          var names = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            names[_i] = arguments[_i];
          }
          var values = {};
          try {
            for (var names_1 = __values2(names), names_1_1 = names_1.next(); !names_1_1.done; names_1_1 = names_1.next()) {
              var name_1 = names_1_1.value;
              values[name_1] = this.get(name_1);
            }
          } catch (e_1_1) {
            e_1 = { error: e_1_1 };
          } finally {
            try {
              if (names_1_1 && !names_1_1.done && (_a = names_1.return))
                _a.call(names_1);
            } finally {
              if (e_1)
                throw e_1.error;
            }
          }
          return values;
        };
        Attributes2.prototype.setInherited = function(name, value) {
          this.inherited[name] = value;
        };
        Attributes2.prototype.getInherited = function(name) {
          return this.inherited[name];
        };
        Attributes2.prototype.getDefault = function(name) {
          return this.defaults[name];
        };
        Attributes2.prototype.isSet = function(name) {
          return this.attributes.hasOwnProperty(name) || this.inherited.hasOwnProperty(name);
        };
        Attributes2.prototype.hasDefault = function(name) {
          return name in this.defaults;
        };
        Attributes2.prototype.getExplicitNames = function() {
          return Object.keys(this.attributes);
        };
        Attributes2.prototype.getInheritedNames = function() {
          return Object.keys(this.inherited);
        };
        Attributes2.prototype.getDefaultNames = function() {
          return Object.keys(this.defaults);
        };
        Attributes2.prototype.getGlobalNames = function() {
          return Object.keys(this.global);
        };
        Attributes2.prototype.getAllAttributes = function() {
          return this.attributes;
        };
        Attributes2.prototype.getAllInherited = function() {
          return this.inherited;
        };
        Attributes2.prototype.getAllDefaults = function() {
          return this.defaults;
        };
        Attributes2.prototype.getAllGlobals = function() {
          return this.global;
        };
        return Attributes2;
      }();
      exports.Attributes = Attributes;
    }
  });

  // node_modules/mathjax-full/js/core/Tree/Node.js
  var require_Node = __commonJS({
    "node_modules/mathjax-full/js/core/Tree/Node.js"(exports) {
      "use strict";
      var __extends2 = exports && exports.__extends || function() {
        var extendStatics2 = function(d, b) {
          extendStatics2 = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
            d2.__proto__ = b2;
          } || function(d2, b2) {
            for (var p in b2)
              if (Object.prototype.hasOwnProperty.call(b2, p))
                d2[p] = b2[p];
          };
          return extendStatics2(d, b);
        };
        return function(d, b) {
          if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
          extendStatics2(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var __assign2 = exports && exports.__assign || function() {
        __assign2 = Object.assign || function(t) {
          for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s)
              if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
          }
          return t;
        };
        return __assign2.apply(this, arguments);
      };
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AbstractEmptyNode = exports.AbstractNode = void 0;
      var AbstractNode = function() {
        function AbstractNode2(factory, properties, children) {
          var e_1, _a;
          if (properties === void 0) {
            properties = {};
          }
          if (children === void 0) {
            children = [];
          }
          this.factory = factory;
          this.parent = null;
          this.properties = {};
          this.childNodes = [];
          try {
            for (var _b = __values2(Object.keys(properties)), _c = _b.next(); !_c.done; _c = _b.next()) {
              var name_1 = _c.value;
              this.setProperty(name_1, properties[name_1]);
            }
          } catch (e_1_1) {
            e_1 = { error: e_1_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_1)
                throw e_1.error;
            }
          }
          if (children.length) {
            this.setChildren(children);
          }
        }
        Object.defineProperty(AbstractNode2.prototype, "kind", {
          get: function() {
            return "unknown";
          },
          enumerable: false,
          configurable: true
        });
        AbstractNode2.prototype.setProperty = function(name, value) {
          this.properties[name] = value;
        };
        AbstractNode2.prototype.getProperty = function(name) {
          return this.properties[name];
        };
        AbstractNode2.prototype.getPropertyNames = function() {
          return Object.keys(this.properties);
        };
        AbstractNode2.prototype.getAllProperties = function() {
          return this.properties;
        };
        AbstractNode2.prototype.removeProperty = function() {
          var e_2, _a;
          var names = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            names[_i] = arguments[_i];
          }
          try {
            for (var names_1 = __values2(names), names_1_1 = names_1.next(); !names_1_1.done; names_1_1 = names_1.next()) {
              var name_2 = names_1_1.value;
              delete this.properties[name_2];
            }
          } catch (e_2_1) {
            e_2 = { error: e_2_1 };
          } finally {
            try {
              if (names_1_1 && !names_1_1.done && (_a = names_1.return))
                _a.call(names_1);
            } finally {
              if (e_2)
                throw e_2.error;
            }
          }
        };
        AbstractNode2.prototype.isKind = function(kind) {
          return this.factory.nodeIsKind(this, kind);
        };
        AbstractNode2.prototype.setChildren = function(children) {
          var e_3, _a;
          this.childNodes = [];
          try {
            for (var children_1 = __values2(children), children_1_1 = children_1.next(); !children_1_1.done; children_1_1 = children_1.next()) {
              var child = children_1_1.value;
              this.appendChild(child);
            }
          } catch (e_3_1) {
            e_3 = { error: e_3_1 };
          } finally {
            try {
              if (children_1_1 && !children_1_1.done && (_a = children_1.return))
                _a.call(children_1);
            } finally {
              if (e_3)
                throw e_3.error;
            }
          }
        };
        AbstractNode2.prototype.appendChild = function(child) {
          this.childNodes.push(child);
          child.parent = this;
          return child;
        };
        AbstractNode2.prototype.replaceChild = function(newChild, oldChild) {
          var i = this.childIndex(oldChild);
          if (i !== null) {
            this.childNodes[i] = newChild;
            newChild.parent = this;
            oldChild.parent = null;
          }
          return newChild;
        };
        AbstractNode2.prototype.removeChild = function(child) {
          var i = this.childIndex(child);
          if (i !== null) {
            this.childNodes.splice(i, 1);
            child.parent = null;
          }
          return child;
        };
        AbstractNode2.prototype.childIndex = function(node) {
          var i = this.childNodes.indexOf(node);
          return i === -1 ? null : i;
        };
        AbstractNode2.prototype.copy = function() {
          var e_4, _a;
          var node = this.factory.create(this.kind);
          node.properties = __assign2({}, this.properties);
          try {
            for (var _b = __values2(this.childNodes || []), _c = _b.next(); !_c.done; _c = _b.next()) {
              var child = _c.value;
              if (child) {
                node.appendChild(child.copy());
              }
            }
          } catch (e_4_1) {
            e_4 = { error: e_4_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_4)
                throw e_4.error;
            }
          }
          return node;
        };
        AbstractNode2.prototype.findNodes = function(kind) {
          var nodes = [];
          this.walkTree(function(node) {
            if (node.isKind(kind)) {
              nodes.push(node);
            }
          });
          return nodes;
        };
        AbstractNode2.prototype.walkTree = function(func, data) {
          var e_5, _a;
          func(this, data);
          try {
            for (var _b = __values2(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
              var child = _c.value;
              if (child) {
                child.walkTree(func, data);
              }
            }
          } catch (e_5_1) {
            e_5 = { error: e_5_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_5)
                throw e_5.error;
            }
          }
          return data;
        };
        AbstractNode2.prototype.toString = function() {
          return this.kind + "(" + this.childNodes.join(",") + ")";
        };
        return AbstractNode2;
      }();
      exports.AbstractNode = AbstractNode;
      var AbstractEmptyNode = function(_super) {
        __extends2(AbstractEmptyNode2, _super);
        function AbstractEmptyNode2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        AbstractEmptyNode2.prototype.setChildren = function(_children) {
        };
        AbstractEmptyNode2.prototype.appendChild = function(child) {
          return child;
        };
        AbstractEmptyNode2.prototype.replaceChild = function(_newChild, oldChild) {
          return oldChild;
        };
        AbstractEmptyNode2.prototype.childIndex = function(_node) {
          return null;
        };
        AbstractEmptyNode2.prototype.walkTree = function(func, data) {
          func(this, data);
          return data;
        };
        AbstractEmptyNode2.prototype.toString = function() {
          return this.kind;
        };
        return AbstractEmptyNode2;
      }(AbstractNode);
      exports.AbstractEmptyNode = AbstractEmptyNode;
    }
  });

  // node_modules/mathjax-full/js/core/MmlTree/MmlNode.js
  var require_MmlNode = __commonJS({
    "node_modules/mathjax-full/js/core/MmlTree/MmlNode.js"(exports) {
      "use strict";
      var __extends2 = exports && exports.__extends || function() {
        var extendStatics2 = function(d, b) {
          extendStatics2 = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
            d2.__proto__ = b2;
          } || function(d2, b2) {
            for (var p in b2)
              if (Object.prototype.hasOwnProperty.call(b2, p))
                d2[p] = b2[p];
          };
          return extendStatics2(d, b);
        };
        return function(d, b) {
          if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
          extendStatics2(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var __assign2 = exports && exports.__assign || function() {
        __assign2 = Object.assign || function(t) {
          for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s)
              if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
          }
          return t;
        };
        return __assign2.apply(this, arguments);
      };
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.XMLNode = exports.TextNode = exports.AbstractMmlEmptyNode = exports.AbstractMmlBaseNode = exports.AbstractMmlLayoutNode = exports.AbstractMmlTokenNode = exports.AbstractMmlNode = exports.indentAttributes = exports.TEXCLASSNAMES = exports.TEXCLASS = void 0;
      var Attributes_js_1 = require_Attributes();
      var Node_js_1 = require_Node();
      exports.TEXCLASS = {
        ORD: 0,
        OP: 1,
        BIN: 2,
        REL: 3,
        OPEN: 4,
        CLOSE: 5,
        PUNCT: 6,
        INNER: 7,
        VCENTER: 8,
        NONE: -1
      };
      exports.TEXCLASSNAMES = ["ORD", "OP", "BIN", "REL", "OPEN", "CLOSE", "PUNCT", "INNER", "VCENTER"];
      var TEXSPACELENGTH = ["", "thinmathspace", "mediummathspace", "thickmathspace"];
      var TEXSPACE = [
        [0, -1, 2, 3, 0, 0, 0, 1],
        [-1, -1, 0, 3, 0, 0, 0, 1],
        [2, 2, 0, 0, 2, 0, 0, 2],
        [3, 3, 0, 0, 3, 0, 0, 3],
        [0, 0, 0, 0, 0, 0, 0, 0],
        [0, -1, 2, 3, 0, 0, 0, 1],
        [1, 1, 0, 1, 1, 1, 1, 1],
        [1, -1, 2, 3, 1, 0, 1, 1]
      ];
      exports.indentAttributes = [
        "indentalign",
        "indentalignfirst",
        "indentshift",
        "indentshiftfirst"
      ];
      var AbstractMmlNode = function(_super) {
        __extends2(AbstractMmlNode2, _super);
        function AbstractMmlNode2(factory, attributes, children) {
          if (attributes === void 0) {
            attributes = {};
          }
          if (children === void 0) {
            children = [];
          }
          var _this = _super.call(this, factory) || this;
          _this.prevClass = null;
          _this.prevLevel = null;
          _this.texclass = null;
          if (_this.arity < 0) {
            _this.childNodes = [factory.create("inferredMrow")];
            _this.childNodes[0].parent = _this;
          }
          _this.setChildren(children);
          _this.attributes = new Attributes_js_1.Attributes(factory.getNodeClass(_this.kind).defaults, factory.getNodeClass("math").defaults);
          _this.attributes.setList(attributes);
          return _this;
        }
        AbstractMmlNode2.prototype.copy = function(keepIds) {
          var e_1, _a, e_2, _b;
          if (keepIds === void 0) {
            keepIds = false;
          }
          var node = this.factory.create(this.kind);
          node.properties = __assign2({}, this.properties);
          if (this.attributes) {
            var attributes = this.attributes.getAllAttributes();
            try {
              for (var _c = __values2(Object.keys(attributes)), _d = _c.next(); !_d.done; _d = _c.next()) {
                var name_1 = _d.value;
                if (name_1 !== "id" || keepIds) {
                  node.attributes.set(name_1, attributes[name_1]);
                }
              }
            } catch (e_1_1) {
              e_1 = { error: e_1_1 };
            } finally {
              try {
                if (_d && !_d.done && (_a = _c.return))
                  _a.call(_c);
              } finally {
                if (e_1)
                  throw e_1.error;
              }
            }
          }
          if (this.childNodes && this.childNodes.length) {
            var children = this.childNodes;
            if (children.length === 1 && children[0].isInferred) {
              children = children[0].childNodes;
            }
            try {
              for (var children_1 = __values2(children), children_1_1 = children_1.next(); !children_1_1.done; children_1_1 = children_1.next()) {
                var child = children_1_1.value;
                if (child) {
                  node.appendChild(child.copy());
                } else {
                  node.childNodes.push(null);
                }
              }
            } catch (e_2_1) {
              e_2 = { error: e_2_1 };
            } finally {
              try {
                if (children_1_1 && !children_1_1.done && (_b = children_1.return))
                  _b.call(children_1);
              } finally {
                if (e_2)
                  throw e_2.error;
              }
            }
          }
          return node;
        };
        Object.defineProperty(AbstractMmlNode2.prototype, "texClass", {
          get: function() {
            return this.texclass;
          },
          set: function(texClass) {
            this.texclass = texClass;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlNode2.prototype, "isToken", {
          get: function() {
            return false;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlNode2.prototype, "isEmbellished", {
          get: function() {
            return false;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlNode2.prototype, "isSpacelike", {
          get: function() {
            return false;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlNode2.prototype, "linebreakContainer", {
          get: function() {
            return false;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlNode2.prototype, "hasNewLine", {
          get: function() {
            return false;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlNode2.prototype, "arity", {
          get: function() {
            return Infinity;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlNode2.prototype, "isInferred", {
          get: function() {
            return false;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlNode2.prototype, "Parent", {
          get: function() {
            var parent = this.parent;
            while (parent && parent.notParent) {
              parent = parent.Parent;
            }
            return parent;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlNode2.prototype, "notParent", {
          get: function() {
            return false;
          },
          enumerable: false,
          configurable: true
        });
        AbstractMmlNode2.prototype.setChildren = function(children) {
          if (this.arity < 0) {
            return this.childNodes[0].setChildren(children);
          }
          return _super.prototype.setChildren.call(this, children);
        };
        AbstractMmlNode2.prototype.appendChild = function(child) {
          var e_3, _a;
          var _this = this;
          if (this.arity < 0) {
            this.childNodes[0].appendChild(child);
            return child;
          }
          if (child.isInferred) {
            if (this.arity === Infinity) {
              child.childNodes.forEach(function(node) {
                return _super.prototype.appendChild.call(_this, node);
              });
              return child;
            }
            var original = child;
            child = this.factory.create("mrow");
            child.setChildren(original.childNodes);
            child.attributes = original.attributes;
            try {
              for (var _b = __values2(original.getPropertyNames()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var name_2 = _c.value;
                child.setProperty(name_2, original.getProperty(name_2));
              }
            } catch (e_3_1) {
              e_3 = { error: e_3_1 };
            } finally {
              try {
                if (_c && !_c.done && (_a = _b.return))
                  _a.call(_b);
              } finally {
                if (e_3)
                  throw e_3.error;
              }
            }
          }
          return _super.prototype.appendChild.call(this, child);
        };
        AbstractMmlNode2.prototype.replaceChild = function(newChild, oldChild) {
          if (this.arity < 0) {
            this.childNodes[0].replaceChild(newChild, oldChild);
            return newChild;
          }
          return _super.prototype.replaceChild.call(this, newChild, oldChild);
        };
        AbstractMmlNode2.prototype.core = function() {
          return this;
        };
        AbstractMmlNode2.prototype.coreMO = function() {
          return this;
        };
        AbstractMmlNode2.prototype.coreIndex = function() {
          return 0;
        };
        AbstractMmlNode2.prototype.childPosition = function() {
          var e_4, _a;
          var child = this;
          var parent = child.parent;
          while (parent && parent.notParent) {
            child = parent;
            parent = parent.parent;
          }
          if (parent) {
            var i = 0;
            try {
              for (var _b = __values2(parent.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                var node = _c.value;
                if (node === child) {
                  return i;
                }
                i++;
              }
            } catch (e_4_1) {
              e_4 = { error: e_4_1 };
            } finally {
              try {
                if (_c && !_c.done && (_a = _b.return))
                  _a.call(_b);
              } finally {
                if (e_4)
                  throw e_4.error;
              }
            }
          }
          return null;
        };
        AbstractMmlNode2.prototype.setTeXclass = function(prev) {
          this.getPrevClass(prev);
          return this.texClass != null ? this : prev;
        };
        AbstractMmlNode2.prototype.updateTeXclass = function(core) {
          if (core) {
            this.prevClass = core.prevClass;
            this.prevLevel = core.prevLevel;
            core.prevClass = core.prevLevel = null;
            this.texClass = core.texClass;
          }
        };
        AbstractMmlNode2.prototype.getPrevClass = function(prev) {
          if (prev) {
            this.prevClass = prev.texClass;
            this.prevLevel = prev.attributes.get("scriptlevel");
          }
        };
        AbstractMmlNode2.prototype.texSpacing = function() {
          var prevClass = this.prevClass != null ? this.prevClass : exports.TEXCLASS.NONE;
          var texClass = this.texClass || exports.TEXCLASS.ORD;
          if (prevClass === exports.TEXCLASS.NONE || texClass === exports.TEXCLASS.NONE) {
            return "";
          }
          if (prevClass === exports.TEXCLASS.VCENTER) {
            prevClass = exports.TEXCLASS.ORD;
          }
          if (texClass === exports.TEXCLASS.VCENTER) {
            texClass = exports.TEXCLASS.ORD;
          }
          var space = TEXSPACE[prevClass][texClass];
          if ((this.prevLevel > 0 || this.attributes.get("scriptlevel") > 0) && space >= 0) {
            return "";
          }
          return TEXSPACELENGTH[Math.abs(space)];
        };
        AbstractMmlNode2.prototype.hasSpacingAttributes = function() {
          return this.isEmbellished && this.coreMO().hasSpacingAttributes();
        };
        AbstractMmlNode2.prototype.setInheritedAttributes = function(attributes, display, level, prime) {
          var e_5, _a;
          if (attributes === void 0) {
            attributes = {};
          }
          if (display === void 0) {
            display = false;
          }
          if (level === void 0) {
            level = 0;
          }
          if (prime === void 0) {
            prime = false;
          }
          var defaults = this.attributes.getAllDefaults();
          try {
            for (var _b = __values2(Object.keys(attributes)), _c = _b.next(); !_c.done; _c = _b.next()) {
              var key = _c.value;
              if (defaults.hasOwnProperty(key) || AbstractMmlNode2.alwaysInherit.hasOwnProperty(key)) {
                var _d = __read2(attributes[key], 2), node = _d[0], value = _d[1];
                var noinherit = (AbstractMmlNode2.noInherit[node] || {})[this.kind] || {};
                if (!noinherit[key]) {
                  this.attributes.setInherited(key, value);
                }
              }
            }
          } catch (e_5_1) {
            e_5 = { error: e_5_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_5)
                throw e_5.error;
            }
          }
          var displaystyle = this.attributes.getExplicit("displaystyle");
          if (displaystyle === void 0) {
            this.attributes.setInherited("displaystyle", display);
          }
          var scriptlevel = this.attributes.getExplicit("scriptlevel");
          if (scriptlevel === void 0) {
            this.attributes.setInherited("scriptlevel", level);
          }
          if (prime) {
            this.setProperty("texprimestyle", prime);
          }
          var arity = this.arity;
          if (arity >= 0 && arity !== Infinity && (arity === 1 && this.childNodes.length === 0 || arity !== 1 && this.childNodes.length !== arity)) {
            if (arity < this.childNodes.length) {
              this.childNodes = this.childNodes.slice(0, arity);
            } else {
              while (this.childNodes.length < arity) {
                this.appendChild(this.factory.create("mrow"));
              }
            }
          }
          this.setChildInheritedAttributes(attributes, display, level, prime);
        };
        AbstractMmlNode2.prototype.setChildInheritedAttributes = function(attributes, display, level, prime) {
          var e_6, _a;
          try {
            for (var _b = __values2(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
              var child = _c.value;
              child.setInheritedAttributes(attributes, display, level, prime);
            }
          } catch (e_6_1) {
            e_6 = { error: e_6_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_6)
                throw e_6.error;
            }
          }
        };
        AbstractMmlNode2.prototype.addInheritedAttributes = function(current, attributes) {
          var e_7, _a;
          var updated = __assign2({}, current);
          try {
            for (var _b = __values2(Object.keys(attributes)), _c = _b.next(); !_c.done; _c = _b.next()) {
              var name_3 = _c.value;
              if (name_3 !== "displaystyle" && name_3 !== "scriptlevel" && name_3 !== "style") {
                updated[name_3] = [this.kind, attributes[name_3]];
              }
            }
          } catch (e_7_1) {
            e_7 = { error: e_7_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_7)
                throw e_7.error;
            }
          }
          return updated;
        };
        AbstractMmlNode2.prototype.inheritAttributesFrom = function(node) {
          var attributes = node.attributes;
          var display = attributes.get("displaystyle");
          var scriptlevel = attributes.get("scriptlevel");
          var defaults = !attributes.isSet("mathsize") ? {} : {
            mathsize: ["math", attributes.get("mathsize")]
          };
          var prime = node.getProperty("texprimestyle") || false;
          this.setInheritedAttributes(defaults, display, scriptlevel, prime);
        };
        AbstractMmlNode2.prototype.verifyTree = function(options) {
          if (options === void 0) {
            options = null;
          }
          if (options === null) {
            return;
          }
          this.verifyAttributes(options);
          var arity = this.arity;
          if (options["checkArity"]) {
            if (arity >= 0 && arity !== Infinity && (arity === 1 && this.childNodes.length === 0 || arity !== 1 && this.childNodes.length !== arity)) {
              this.mError('Wrong number of children for "' + this.kind + '" node', options, true);
            }
          }
          this.verifyChildren(options);
        };
        AbstractMmlNode2.prototype.verifyAttributes = function(options) {
          var e_8, _a;
          if (options["checkAttributes"]) {
            var attributes = this.attributes;
            var bad = [];
            try {
              for (var _b = __values2(attributes.getExplicitNames()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var name_4 = _c.value;
                if (name_4.substr(0, 5) !== "data-" && attributes.getDefault(name_4) === void 0 && !name_4.match(/^(?:class|style|id|(?:xlink:)?href)$/)) {
                  bad.push(name_4);
                }
              }
            } catch (e_8_1) {
              e_8 = { error: e_8_1 };
            } finally {
              try {
                if (_c && !_c.done && (_a = _b.return))
                  _a.call(_b);
              } finally {
                if (e_8)
                  throw e_8.error;
              }
            }
            if (bad.length) {
              this.mError("Unknown attributes for " + this.kind + " node: " + bad.join(", "), options);
            }
          }
        };
        AbstractMmlNode2.prototype.verifyChildren = function(options) {
          var e_9, _a;
          try {
            for (var _b = __values2(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
              var child = _c.value;
              child.verifyTree(options);
            }
          } catch (e_9_1) {
            e_9 = { error: e_9_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_9)
                throw e_9.error;
            }
          }
        };
        AbstractMmlNode2.prototype.mError = function(message, options, short) {
          if (short === void 0) {
            short = false;
          }
          if (this.parent && this.parent.isKind("merror")) {
            return null;
          }
          var merror = this.factory.create("merror");
          merror.attributes.set("data-mjx-message", message);
          if (options["fullErrors"] || short) {
            var mtext = this.factory.create("mtext");
            var text = this.factory.create("text");
            text.setText(options["fullErrors"] ? message : this.kind);
            mtext.appendChild(text);
            merror.appendChild(mtext);
            this.parent.replaceChild(merror, this);
          } else {
            this.parent.replaceChild(merror, this);
            merror.appendChild(this);
          }
          return merror;
        };
        AbstractMmlNode2.defaults = {
          mathbackground: Attributes_js_1.INHERIT,
          mathcolor: Attributes_js_1.INHERIT,
          mathsize: Attributes_js_1.INHERIT,
          dir: Attributes_js_1.INHERIT
        };
        AbstractMmlNode2.noInherit = {
          mstyle: {
            mpadded: { width: true, height: true, depth: true, lspace: true, voffset: true },
            mtable: { width: true, height: true, depth: true, align: true }
          },
          maligngroup: {
            mrow: { groupalign: true },
            mtable: { groupalign: true }
          }
        };
        AbstractMmlNode2.alwaysInherit = {
          scriptminsize: true,
          scriptsizemultiplier: true
        };
        AbstractMmlNode2.verifyDefaults = {
          checkArity: true,
          checkAttributes: false,
          fullErrors: false,
          fixMmultiscripts: true,
          fixMtables: true
        };
        return AbstractMmlNode2;
      }(Node_js_1.AbstractNode);
      exports.AbstractMmlNode = AbstractMmlNode;
      var AbstractMmlTokenNode = function(_super) {
        __extends2(AbstractMmlTokenNode2, _super);
        function AbstractMmlTokenNode2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(AbstractMmlTokenNode2.prototype, "isToken", {
          get: function() {
            return true;
          },
          enumerable: false,
          configurable: true
        });
        AbstractMmlTokenNode2.prototype.getText = function() {
          var e_10, _a;
          var text = "";
          try {
            for (var _b = __values2(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
              var child = _c.value;
              if (child instanceof TextNode) {
                text += child.getText();
              }
            }
          } catch (e_10_1) {
            e_10 = { error: e_10_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_10)
                throw e_10.error;
            }
          }
          return text;
        };
        AbstractMmlTokenNode2.prototype.setChildInheritedAttributes = function(attributes, display, level, prime) {
          var e_11, _a;
          try {
            for (var _b = __values2(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
              var child = _c.value;
              if (child instanceof AbstractMmlNode) {
                child.setInheritedAttributes(attributes, display, level, prime);
              }
            }
          } catch (e_11_1) {
            e_11 = { error: e_11_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_11)
                throw e_11.error;
            }
          }
        };
        AbstractMmlTokenNode2.prototype.walkTree = function(func, data) {
          var e_12, _a;
          func(this, data);
          try {
            for (var _b = __values2(this.childNodes), _c = _b.next(); !_c.done; _c = _b.next()) {
              var child = _c.value;
              if (child instanceof AbstractMmlNode) {
                child.walkTree(func, data);
              }
            }
          } catch (e_12_1) {
            e_12 = { error: e_12_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_12)
                throw e_12.error;
            }
          }
          return data;
        };
        AbstractMmlTokenNode2.defaults = __assign2(__assign2({}, AbstractMmlNode.defaults), { mathvariant: "normal", mathsize: Attributes_js_1.INHERIT });
        return AbstractMmlTokenNode2;
      }(AbstractMmlNode);
      exports.AbstractMmlTokenNode = AbstractMmlTokenNode;
      var AbstractMmlLayoutNode = function(_super) {
        __extends2(AbstractMmlLayoutNode2, _super);
        function AbstractMmlLayoutNode2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(AbstractMmlLayoutNode2.prototype, "isSpacelike", {
          get: function() {
            return this.childNodes[0].isSpacelike;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlLayoutNode2.prototype, "isEmbellished", {
          get: function() {
            return this.childNodes[0].isEmbellished;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlLayoutNode2.prototype, "arity", {
          get: function() {
            return -1;
          },
          enumerable: false,
          configurable: true
        });
        AbstractMmlLayoutNode2.prototype.core = function() {
          return this.childNodes[0];
        };
        AbstractMmlLayoutNode2.prototype.coreMO = function() {
          return this.childNodes[0].coreMO();
        };
        AbstractMmlLayoutNode2.prototype.setTeXclass = function(prev) {
          prev = this.childNodes[0].setTeXclass(prev);
          this.updateTeXclass(this.childNodes[0]);
          return prev;
        };
        AbstractMmlLayoutNode2.defaults = AbstractMmlNode.defaults;
        return AbstractMmlLayoutNode2;
      }(AbstractMmlNode);
      exports.AbstractMmlLayoutNode = AbstractMmlLayoutNode;
      var AbstractMmlBaseNode = function(_super) {
        __extends2(AbstractMmlBaseNode2, _super);
        function AbstractMmlBaseNode2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(AbstractMmlBaseNode2.prototype, "isEmbellished", {
          get: function() {
            return this.childNodes[0].isEmbellished;
          },
          enumerable: false,
          configurable: true
        });
        AbstractMmlBaseNode2.prototype.core = function() {
          return this.childNodes[0];
        };
        AbstractMmlBaseNode2.prototype.coreMO = function() {
          return this.childNodes[0].coreMO();
        };
        AbstractMmlBaseNode2.prototype.setTeXclass = function(prev) {
          var e_13, _a;
          this.getPrevClass(prev);
          this.texClass = exports.TEXCLASS.ORD;
          var base = this.childNodes[0];
          if (base) {
            if (this.isEmbellished || base.isKind("mi")) {
              prev = base.setTeXclass(prev);
              this.updateTeXclass(this.core());
            } else {
              base.setTeXclass(null);
              prev = this;
            }
          } else {
            prev = this;
          }
          try {
            for (var _b = __values2(this.childNodes.slice(1)), _c = _b.next(); !_c.done; _c = _b.next()) {
              var child = _c.value;
              if (child) {
                child.setTeXclass(null);
              }
            }
          } catch (e_13_1) {
            e_13 = { error: e_13_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_13)
                throw e_13.error;
            }
          }
          return prev;
        };
        AbstractMmlBaseNode2.defaults = AbstractMmlNode.defaults;
        return AbstractMmlBaseNode2;
      }(AbstractMmlNode);
      exports.AbstractMmlBaseNode = AbstractMmlBaseNode;
      var AbstractMmlEmptyNode = function(_super) {
        __extends2(AbstractMmlEmptyNode2, _super);
        function AbstractMmlEmptyNode2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(AbstractMmlEmptyNode2.prototype, "isToken", {
          get: function() {
            return false;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode2.prototype, "isEmbellished", {
          get: function() {
            return false;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode2.prototype, "isSpacelike", {
          get: function() {
            return false;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode2.prototype, "linebreakContainer", {
          get: function() {
            return false;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode2.prototype, "hasNewLine", {
          get: function() {
            return false;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode2.prototype, "arity", {
          get: function() {
            return 0;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode2.prototype, "isInferred", {
          get: function() {
            return false;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode2.prototype, "notParent", {
          get: function() {
            return false;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode2.prototype, "Parent", {
          get: function() {
            return this.parent;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode2.prototype, "texClass", {
          get: function() {
            return exports.TEXCLASS.NONE;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode2.prototype, "prevClass", {
          get: function() {
            return exports.TEXCLASS.NONE;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractMmlEmptyNode2.prototype, "prevLevel", {
          get: function() {
            return 0;
          },
          enumerable: false,
          configurable: true
        });
        AbstractMmlEmptyNode2.prototype.hasSpacingAttributes = function() {
          return false;
        };
        Object.defineProperty(AbstractMmlEmptyNode2.prototype, "attributes", {
          get: function() {
            return null;
          },
          enumerable: false,
          configurable: true
        });
        AbstractMmlEmptyNode2.prototype.core = function() {
          return this;
        };
        AbstractMmlEmptyNode2.prototype.coreMO = function() {
          return this;
        };
        AbstractMmlEmptyNode2.prototype.coreIndex = function() {
          return 0;
        };
        AbstractMmlEmptyNode2.prototype.childPosition = function() {
          return 0;
        };
        AbstractMmlEmptyNode2.prototype.setTeXclass = function(prev) {
          return prev;
        };
        AbstractMmlEmptyNode2.prototype.texSpacing = function() {
          return "";
        };
        AbstractMmlEmptyNode2.prototype.setInheritedAttributes = function(_attributes, _display, _level, _prime) {
        };
        AbstractMmlEmptyNode2.prototype.inheritAttributesFrom = function(_node) {
        };
        AbstractMmlEmptyNode2.prototype.verifyTree = function(_options) {
        };
        AbstractMmlEmptyNode2.prototype.mError = function(_message, _options, _short) {
          if (_short === void 0) {
            _short = false;
          }
          return null;
        };
        return AbstractMmlEmptyNode2;
      }(Node_js_1.AbstractEmptyNode);
      exports.AbstractMmlEmptyNode = AbstractMmlEmptyNode;
      var TextNode = function(_super) {
        __extends2(TextNode2, _super);
        function TextNode2() {
          var _this = _super !== null && _super.apply(this, arguments) || this;
          _this.text = "";
          return _this;
        }
        Object.defineProperty(TextNode2.prototype, "kind", {
          get: function() {
            return "text";
          },
          enumerable: false,
          configurable: true
        });
        TextNode2.prototype.getText = function() {
          return this.text;
        };
        TextNode2.prototype.setText = function(text) {
          this.text = text;
          return this;
        };
        TextNode2.prototype.copy = function() {
          return this.factory.create(this.kind).setText(this.getText());
        };
        TextNode2.prototype.toString = function() {
          return this.text;
        };
        return TextNode2;
      }(AbstractMmlEmptyNode);
      exports.TextNode = TextNode;
      var XMLNode = function(_super) {
        __extends2(XMLNode2, _super);
        function XMLNode2() {
          var _this = _super !== null && _super.apply(this, arguments) || this;
          _this.xml = null;
          _this.adaptor = null;
          return _this;
        }
        Object.defineProperty(XMLNode2.prototype, "kind", {
          get: function() {
            return "XML";
          },
          enumerable: false,
          configurable: true
        });
        XMLNode2.prototype.getXML = function() {
          return this.xml;
        };
        XMLNode2.prototype.setXML = function(xml, adaptor) {
          if (adaptor === void 0) {
            adaptor = null;
          }
          this.xml = xml;
          this.adaptor = adaptor;
          return this;
        };
        XMLNode2.prototype.getSerializedXML = function() {
          return this.adaptor.serializeXML(this.xml);
        };
        XMLNode2.prototype.copy = function() {
          return this.factory.create(this.kind).setXML(this.adaptor.clone(this.xml));
        };
        XMLNode2.prototype.toString = function() {
          return "XML data";
        };
        return XMLNode2;
      }(AbstractMmlEmptyNode);
      exports.XMLNode = XMLNode;
    }
  });

  // node_modules/mathjax-full/js/core/MmlTree/OperatorDictionary.js
  var require_OperatorDictionary = __commonJS({
    "node_modules/mathjax-full/js/core/MmlTree/OperatorDictionary.js"(exports) {
      "use strict";
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.OPTABLE = exports.MMLSPACING = exports.getRange = exports.RANGES = exports.MO = exports.OPDEF = void 0;
      var MmlNode_js_1 = require_MmlNode();
      function OPDEF(lspace, rspace, texClass, properties) {
        if (texClass === void 0) {
          texClass = MmlNode_js_1.TEXCLASS.BIN;
        }
        if (properties === void 0) {
          properties = null;
        }
        return [lspace, rspace, texClass, properties];
      }
      exports.OPDEF = OPDEF;
      exports.MO = {
        ORD: OPDEF(0, 0, MmlNode_js_1.TEXCLASS.ORD),
        ORD11: OPDEF(1, 1, MmlNode_js_1.TEXCLASS.ORD),
        ORD21: OPDEF(2, 1, MmlNode_js_1.TEXCLASS.ORD),
        ORD02: OPDEF(0, 2, MmlNode_js_1.TEXCLASS.ORD),
        ORD55: OPDEF(5, 5, MmlNode_js_1.TEXCLASS.ORD),
        NONE: OPDEF(0, 0, MmlNode_js_1.TEXCLASS.NONE),
        OP: OPDEF(1, 2, MmlNode_js_1.TEXCLASS.OP, { largeop: true, movablelimits: true, symmetric: true }),
        OPFIXED: OPDEF(1, 2, MmlNode_js_1.TEXCLASS.OP, { largeop: true, movablelimits: true }),
        INTEGRAL: OPDEF(0, 1, MmlNode_js_1.TEXCLASS.OP, { largeop: true, symmetric: true }),
        INTEGRAL2: OPDEF(1, 2, MmlNode_js_1.TEXCLASS.OP, { largeop: true, symmetric: true }),
        BIN3: OPDEF(3, 3, MmlNode_js_1.TEXCLASS.BIN),
        BIN4: OPDEF(4, 4, MmlNode_js_1.TEXCLASS.BIN),
        BIN01: OPDEF(0, 1, MmlNode_js_1.TEXCLASS.BIN),
        BIN5: OPDEF(5, 5, MmlNode_js_1.TEXCLASS.BIN),
        TALLBIN: OPDEF(4, 4, MmlNode_js_1.TEXCLASS.BIN, { stretchy: true }),
        BINOP: OPDEF(4, 4, MmlNode_js_1.TEXCLASS.BIN, { largeop: true, movablelimits: true }),
        REL: OPDEF(5, 5, MmlNode_js_1.TEXCLASS.REL),
        REL1: OPDEF(1, 1, MmlNode_js_1.TEXCLASS.REL, { stretchy: true }),
        REL4: OPDEF(4, 4, MmlNode_js_1.TEXCLASS.REL),
        RELSTRETCH: OPDEF(5, 5, MmlNode_js_1.TEXCLASS.REL, { stretchy: true }),
        RELACCENT: OPDEF(5, 5, MmlNode_js_1.TEXCLASS.REL, { accent: true }),
        WIDEREL: OPDEF(5, 5, MmlNode_js_1.TEXCLASS.REL, { accent: true, stretchy: true }),
        OPEN: OPDEF(0, 0, MmlNode_js_1.TEXCLASS.OPEN, { fence: true, stretchy: true, symmetric: true }),
        CLOSE: OPDEF(0, 0, MmlNode_js_1.TEXCLASS.CLOSE, { fence: true, stretchy: true, symmetric: true }),
        INNER: OPDEF(0, 0, MmlNode_js_1.TEXCLASS.INNER),
        PUNCT: OPDEF(0, 3, MmlNode_js_1.TEXCLASS.PUNCT),
        ACCENT: OPDEF(0, 0, MmlNode_js_1.TEXCLASS.ORD, { accent: true }),
        WIDEACCENT: OPDEF(0, 0, MmlNode_js_1.TEXCLASS.ORD, { accent: true, stretchy: true })
      };
      exports.RANGES = [
        [32, 127, MmlNode_js_1.TEXCLASS.REL, "mo"],
        [160, 191, MmlNode_js_1.TEXCLASS.ORD, "mo"],
        [192, 591, MmlNode_js_1.TEXCLASS.ORD, "mi"],
        [688, 879, MmlNode_js_1.TEXCLASS.ORD, "mo"],
        [880, 6688, MmlNode_js_1.TEXCLASS.ORD, "mi"],
        [6832, 6911, MmlNode_js_1.TEXCLASS.ORD, "mo"],
        [6912, 7615, MmlNode_js_1.TEXCLASS.ORD, "mi"],
        [7616, 7679, MmlNode_js_1.TEXCLASS.ORD, "mo"],
        [7680, 8191, MmlNode_js_1.TEXCLASS.ORD, "mi"],
        [8192, 8303, MmlNode_js_1.TEXCLASS.ORD, "mo"],
        [8304, 8351, MmlNode_js_1.TEXCLASS.ORD, "mo"],
        [8448, 8527, MmlNode_js_1.TEXCLASS.ORD, "mi"],
        [8528, 8591, MmlNode_js_1.TEXCLASS.ORD, "mn"],
        [8592, 8703, MmlNode_js_1.TEXCLASS.REL, "mo"],
        [8704, 8959, MmlNode_js_1.TEXCLASS.BIN, "mo"],
        [8960, 9215, MmlNode_js_1.TEXCLASS.ORD, "mo"],
        [9312, 9471, MmlNode_js_1.TEXCLASS.ORD, "mn"],
        [9472, 10223, MmlNode_js_1.TEXCLASS.ORD, "mo"],
        [10224, 10239, MmlNode_js_1.TEXCLASS.REL, "mo"],
        [10240, 10495, MmlNode_js_1.TEXCLASS.ORD, "mtext"],
        [10496, 10623, MmlNode_js_1.TEXCLASS.REL, "mo"],
        [10624, 10751, MmlNode_js_1.TEXCLASS.ORD, "mo"],
        [10752, 11007, MmlNode_js_1.TEXCLASS.BIN, "mo"],
        [11008, 11055, MmlNode_js_1.TEXCLASS.ORD, "mo"],
        [11056, 11087, MmlNode_js_1.TEXCLASS.REL, "mo"],
        [11088, 11263, MmlNode_js_1.TEXCLASS.ORD, "mo"],
        [11264, 11744, MmlNode_js_1.TEXCLASS.ORD, "mi"],
        [11776, 11903, MmlNode_js_1.TEXCLASS.ORD, "mo"],
        [11904, 12255, MmlNode_js_1.TEXCLASS.ORD, "mi", "normal"],
        [12272, 12351, MmlNode_js_1.TEXCLASS.ORD, "mo"],
        [12352, 42143, MmlNode_js_1.TEXCLASS.ORD, "mi", "normal"],
        [42192, 43055, MmlNode_js_1.TEXCLASS.ORD, "mi"],
        [43056, 43071, MmlNode_js_1.TEXCLASS.ORD, "mn"],
        [43072, 55295, MmlNode_js_1.TEXCLASS.ORD, "mi"],
        [63744, 64255, MmlNode_js_1.TEXCLASS.ORD, "mi", "normal"],
        [64256, 65023, MmlNode_js_1.TEXCLASS.ORD, "mi"],
        [65024, 65135, MmlNode_js_1.TEXCLASS.ORD, "mo"],
        [65136, 65791, MmlNode_js_1.TEXCLASS.ORD, "mi"],
        [65792, 65935, MmlNode_js_1.TEXCLASS.ORD, "mn"],
        [65936, 74751, MmlNode_js_1.TEXCLASS.ORD, "mi", "normal"],
        [74752, 74879, MmlNode_js_1.TEXCLASS.ORD, "mn"],
        [74880, 113823, MmlNode_js_1.TEXCLASS.ORD, "mi", "normal"],
        [113824, 119391, MmlNode_js_1.TEXCLASS.ORD, "mo"],
        [119648, 119679, MmlNode_js_1.TEXCLASS.ORD, "mn"],
        [119808, 120781, MmlNode_js_1.TEXCLASS.ORD, "mi"],
        [120782, 120831, MmlNode_js_1.TEXCLASS.ORD, "mn"],
        [122624, 129023, MmlNode_js_1.TEXCLASS.ORD, "mo"],
        [129024, 129279, MmlNode_js_1.TEXCLASS.REL, "mo"],
        [129280, 129535, MmlNode_js_1.TEXCLASS.ORD, "mo"],
        [131072, 195103, MmlNode_js_1.TEXCLASS.ORD, "mi", "normnal"]
      ];
      function getRange(text) {
        var e_1, _a;
        var n = text.codePointAt(0);
        try {
          for (var RANGES_1 = __values2(exports.RANGES), RANGES_1_1 = RANGES_1.next(); !RANGES_1_1.done; RANGES_1_1 = RANGES_1.next()) {
            var range = RANGES_1_1.value;
            if (n <= range[1]) {
              if (n >= range[0]) {
                return range;
              }
              break;
            }
          }
        } catch (e_1_1) {
          e_1 = { error: e_1_1 };
        } finally {
          try {
            if (RANGES_1_1 && !RANGES_1_1.done && (_a = RANGES_1.return))
              _a.call(RANGES_1);
          } finally {
            if (e_1)
              throw e_1.error;
          }
        }
        return null;
      }
      exports.getRange = getRange;
      exports.MMLSPACING = [
        [0, 0],
        [1, 2],
        [3, 3],
        [4, 4],
        [0, 0],
        [0, 0],
        [0, 3]
      ];
      exports.OPTABLE = {
        prefix: {
          "(": exports.MO.OPEN,
          "+": exports.MO.BIN01,
          "-": exports.MO.BIN01,
          "[": exports.MO.OPEN,
          "{": exports.MO.OPEN,
          "|": exports.MO.OPEN,
          "||": [0, 0, MmlNode_js_1.TEXCLASS.BIN, { fence: true, stretchy: true, symmetric: true }],
          "|||": [0, 0, MmlNode_js_1.TEXCLASS.ORD, { fence: true, stretchy: true, symmetric: true }],
          "\xAC": exports.MO.ORD21,
          "\xB1": exports.MO.BIN01,
          "\u2016": [0, 0, MmlNode_js_1.TEXCLASS.ORD, { fence: true, stretchy: true }],
          "\u2018": [0, 0, MmlNode_js_1.TEXCLASS.OPEN, { fence: true }],
          "\u201C": [0, 0, MmlNode_js_1.TEXCLASS.OPEN, { fence: true }],
          "\u2145": exports.MO.ORD21,
          "\u2146": OPDEF(2, 0, MmlNode_js_1.TEXCLASS.ORD),
          "\u2200": exports.MO.ORD21,
          "\u2202": exports.MO.ORD21,
          "\u2203": exports.MO.ORD21,
          "\u2204": exports.MO.ORD21,
          "\u2207": exports.MO.ORD21,
          "\u220F": exports.MO.OP,
          "\u2210": exports.MO.OP,
          "\u2211": exports.MO.OP,
          "\u2212": exports.MO.BIN01,
          "\u2213": exports.MO.BIN01,
          "\u221A": [1, 1, MmlNode_js_1.TEXCLASS.ORD, { stretchy: true }],
          "\u221B": exports.MO.ORD11,
          "\u221C": exports.MO.ORD11,
          "\u2220": exports.MO.ORD,
          "\u2221": exports.MO.ORD,
          "\u2222": exports.MO.ORD,
          "\u222B": exports.MO.INTEGRAL,
          "\u222C": exports.MO.INTEGRAL,
          "\u222D": exports.MO.INTEGRAL,
          "\u222E": exports.MO.INTEGRAL,
          "\u222F": exports.MO.INTEGRAL,
          "\u2230": exports.MO.INTEGRAL,
          "\u2231": exports.MO.INTEGRAL,
          "\u2232": exports.MO.INTEGRAL,
          "\u2233": exports.MO.INTEGRAL,
          "\u22C0": exports.MO.OP,
          "\u22C1": exports.MO.OP,
          "\u22C2": exports.MO.OP,
          "\u22C3": exports.MO.OP,
          "\u2308": exports.MO.OPEN,
          "\u230A": exports.MO.OPEN,
          "\u2329": exports.MO.OPEN,
          "\u2772": exports.MO.OPEN,
          "\u27E6": exports.MO.OPEN,
          "\u27E8": exports.MO.OPEN,
          "\u27EA": exports.MO.OPEN,
          "\u27EC": exports.MO.OPEN,
          "\u27EE": exports.MO.OPEN,
          "\u2980": [0, 0, MmlNode_js_1.TEXCLASS.ORD, { fence: true, stretchy: true }],
          "\u2983": exports.MO.OPEN,
          "\u2985": exports.MO.OPEN,
          "\u2987": exports.MO.OPEN,
          "\u2989": exports.MO.OPEN,
          "\u298B": exports.MO.OPEN,
          "\u298D": exports.MO.OPEN,
          "\u298F": exports.MO.OPEN,
          "\u2991": exports.MO.OPEN,
          "\u2993": exports.MO.OPEN,
          "\u2995": exports.MO.OPEN,
          "\u2997": exports.MO.OPEN,
          "\u29FC": exports.MO.OPEN,
          "\u2A00": exports.MO.OP,
          "\u2A01": exports.MO.OP,
          "\u2A02": exports.MO.OP,
          "\u2A03": exports.MO.OP,
          "\u2A04": exports.MO.OP,
          "\u2A05": exports.MO.OP,
          "\u2A06": exports.MO.OP,
          "\u2A07": exports.MO.OP,
          "\u2A08": exports.MO.OP,
          "\u2A09": exports.MO.OP,
          "\u2A0A": exports.MO.OP,
          "\u2A0B": exports.MO.INTEGRAL2,
          "\u2A0C": exports.MO.INTEGRAL,
          "\u2A0D": exports.MO.INTEGRAL2,
          "\u2A0E": exports.MO.INTEGRAL2,
          "\u2A0F": exports.MO.INTEGRAL2,
          "\u2A10": exports.MO.OP,
          "\u2A11": exports.MO.OP,
          "\u2A12": exports.MO.OP,
          "\u2A13": exports.MO.OP,
          "\u2A14": exports.MO.OP,
          "\u2A15": exports.MO.INTEGRAL2,
          "\u2A16": exports.MO.INTEGRAL2,
          "\u2A17": exports.MO.INTEGRAL2,
          "\u2A18": exports.MO.INTEGRAL2,
          "\u2A19": exports.MO.INTEGRAL2,
          "\u2A1A": exports.MO.INTEGRAL2,
          "\u2A1B": exports.MO.INTEGRAL2,
          "\u2A1C": exports.MO.INTEGRAL2,
          "\u2AFC": exports.MO.OP,
          "\u2AFF": exports.MO.OP
        },
        postfix: {
          "!!": OPDEF(1, 0),
          "!": [1, 0, MmlNode_js_1.TEXCLASS.CLOSE, null],
          '"': exports.MO.ACCENT,
          "&": exports.MO.ORD,
          ")": exports.MO.CLOSE,
          "++": OPDEF(0, 0),
          "--": OPDEF(0, 0),
          "..": OPDEF(0, 0),
          "...": exports.MO.ORD,
          "'": exports.MO.ACCENT,
          "]": exports.MO.CLOSE,
          "^": exports.MO.WIDEACCENT,
          "_": exports.MO.WIDEACCENT,
          "`": exports.MO.ACCENT,
          "|": exports.MO.CLOSE,
          "}": exports.MO.CLOSE,
          "~": exports.MO.WIDEACCENT,
          "||": [0, 0, MmlNode_js_1.TEXCLASS.BIN, { fence: true, stretchy: true, symmetric: true }],
          "|||": [0, 0, MmlNode_js_1.TEXCLASS.ORD, { fence: true, stretchy: true, symmetric: true }],
          "\xA8": exports.MO.ACCENT,
          "\xAA": exports.MO.ACCENT,
          "\xAF": exports.MO.WIDEACCENT,
          "\xB0": exports.MO.ORD,
          "\xB2": exports.MO.ACCENT,
          "\xB3": exports.MO.ACCENT,
          "\xB4": exports.MO.ACCENT,
          "\xB8": exports.MO.ACCENT,
          "\xB9": exports.MO.ACCENT,
          "\xBA": exports.MO.ACCENT,
          "\u02C6": exports.MO.WIDEACCENT,
          "\u02C7": exports.MO.WIDEACCENT,
          "\u02C9": exports.MO.WIDEACCENT,
          "\u02CA": exports.MO.ACCENT,
          "\u02CB": exports.MO.ACCENT,
          "\u02CD": exports.MO.WIDEACCENT,
          "\u02D8": exports.MO.ACCENT,
          "\u02D9": exports.MO.ACCENT,
          "\u02DA": exports.MO.ACCENT,
          "\u02DC": exports.MO.WIDEACCENT,
          "\u02DD": exports.MO.ACCENT,
          "\u02F7": exports.MO.WIDEACCENT,
          "\u0302": exports.MO.WIDEACCENT,
          "\u0311": exports.MO.ACCENT,
          "\u03F6": exports.MO.REL,
          "\u2016": [0, 0, MmlNode_js_1.TEXCLASS.ORD, { fence: true, stretchy: true }],
          "\u2019": [0, 0, MmlNode_js_1.TEXCLASS.CLOSE, { fence: true }],
          "\u201A": exports.MO.ACCENT,
          "\u201B": exports.MO.ACCENT,
          "\u201D": [0, 0, MmlNode_js_1.TEXCLASS.CLOSE, { fence: true }],
          "\u201E": exports.MO.ACCENT,
          "\u201F": exports.MO.ACCENT,
          "\u2032": exports.MO.ORD,
          "\u2033": exports.MO.ACCENT,
          "\u2034": exports.MO.ACCENT,
          "\u2035": exports.MO.ACCENT,
          "\u2036": exports.MO.ACCENT,
          "\u2037": exports.MO.ACCENT,
          "\u203E": exports.MO.WIDEACCENT,
          "\u2057": exports.MO.ACCENT,
          "\u20DB": exports.MO.ACCENT,
          "\u20DC": exports.MO.ACCENT,
          "\u2309": exports.MO.CLOSE,
          "\u230B": exports.MO.CLOSE,
          "\u232A": exports.MO.CLOSE,
          "\u23B4": exports.MO.WIDEACCENT,
          "\u23B5": exports.MO.WIDEACCENT,
          "\u23DC": exports.MO.WIDEACCENT,
          "\u23DD": exports.MO.WIDEACCENT,
          "\u23DE": exports.MO.WIDEACCENT,
          "\u23DF": exports.MO.WIDEACCENT,
          "\u23E0": exports.MO.WIDEACCENT,
          "\u23E1": exports.MO.WIDEACCENT,
          "\u25A0": exports.MO.BIN3,
          "\u25A1": exports.MO.BIN3,
          "\u25AA": exports.MO.BIN3,
          "\u25AB": exports.MO.BIN3,
          "\u25AD": exports.MO.BIN3,
          "\u25AE": exports.MO.BIN3,
          "\u25AF": exports.MO.BIN3,
          "\u25B0": exports.MO.BIN3,
          "\u25B1": exports.MO.BIN3,
          "\u25B2": exports.MO.BIN4,
          "\u25B4": exports.MO.BIN4,
          "\u25B6": exports.MO.BIN4,
          "\u25B7": exports.MO.BIN4,
          "\u25B8": exports.MO.BIN4,
          "\u25BC": exports.MO.BIN4,
          "\u25BE": exports.MO.BIN4,
          "\u25C0": exports.MO.BIN4,
          "\u25C1": exports.MO.BIN4,
          "\u25C2": exports.MO.BIN4,
          "\u25C4": exports.MO.BIN4,
          "\u25C5": exports.MO.BIN4,
          "\u25C6": exports.MO.BIN4,
          "\u25C7": exports.MO.BIN4,
          "\u25C8": exports.MO.BIN4,
          "\u25C9": exports.MO.BIN4,
          "\u25CC": exports.MO.BIN4,
          "\u25CD": exports.MO.BIN4,
          "\u25CE": exports.MO.BIN4,
          "\u25CF": exports.MO.BIN4,
          "\u25D6": exports.MO.BIN4,
          "\u25D7": exports.MO.BIN4,
          "\u25E6": exports.MO.BIN4,
          "\u266D": exports.MO.ORD02,
          "\u266E": exports.MO.ORD02,
          "\u266F": exports.MO.ORD02,
          "\u2773": exports.MO.CLOSE,
          "\u27E7": exports.MO.CLOSE,
          "\u27E9": exports.MO.CLOSE,
          "\u27EB": exports.MO.CLOSE,
          "\u27ED": exports.MO.CLOSE,
          "\u27EF": exports.MO.CLOSE,
          "\u2980": [0, 0, MmlNode_js_1.TEXCLASS.ORD, { fence: true, stretchy: true }],
          "\u2984": exports.MO.CLOSE,
          "\u2986": exports.MO.CLOSE,
          "\u2988": exports.MO.CLOSE,
          "\u298A": exports.MO.CLOSE,
          "\u298C": exports.MO.CLOSE,
          "\u298E": exports.MO.CLOSE,
          "\u2990": exports.MO.CLOSE,
          "\u2992": exports.MO.CLOSE,
          "\u2994": exports.MO.CLOSE,
          "\u2996": exports.MO.CLOSE,
          "\u2998": exports.MO.CLOSE,
          "\u29FD": exports.MO.CLOSE
        },
        infix: {
          "!=": exports.MO.BIN4,
          "#": exports.MO.ORD,
          "$": exports.MO.ORD,
          "%": [3, 3, MmlNode_js_1.TEXCLASS.ORD, null],
          "&&": exports.MO.BIN4,
          "": exports.MO.ORD,
          "*": exports.MO.BIN3,
          "**": OPDEF(1, 1),
          "*=": exports.MO.BIN4,
          "+": exports.MO.BIN4,
          "+=": exports.MO.BIN4,
          ",": [0, 3, MmlNode_js_1.TEXCLASS.PUNCT, { linebreakstyle: "after", separator: true }],
          "-": exports.MO.BIN4,
          "-=": exports.MO.BIN4,
          "->": exports.MO.BIN5,
          ".": [0, 3, MmlNode_js_1.TEXCLASS.PUNCT, { separator: true }],
          "/": exports.MO.ORD11,
          "//": OPDEF(1, 1),
          "/=": exports.MO.BIN4,
          ":": [1, 2, MmlNode_js_1.TEXCLASS.REL, null],
          ":=": exports.MO.BIN4,
          ";": [0, 3, MmlNode_js_1.TEXCLASS.PUNCT, { linebreakstyle: "after", separator: true }],
          "<": exports.MO.REL,
          "<=": exports.MO.BIN5,
          "<>": OPDEF(1, 1),
          "=": exports.MO.REL,
          "==": exports.MO.BIN4,
          ">": exports.MO.REL,
          ">=": exports.MO.BIN5,
          "?": [1, 1, MmlNode_js_1.TEXCLASS.CLOSE, null],
          "@": exports.MO.ORD11,
          "\\": exports.MO.ORD,
          "^": exports.MO.ORD11,
          "_": exports.MO.ORD11,
          "|": [2, 2, MmlNode_js_1.TEXCLASS.ORD, { fence: true, stretchy: true, symmetric: true }],
          "||": [2, 2, MmlNode_js_1.TEXCLASS.BIN, { fence: true, stretchy: true, symmetric: true }],
          "|||": [2, 2, MmlNode_js_1.TEXCLASS.ORD, { fence: true, stretchy: true, symmetric: true }],
          "\xB1": exports.MO.BIN4,
          "\xB7": exports.MO.BIN4,
          "\xD7": exports.MO.BIN4,
          "\xF7": exports.MO.BIN4,
          "\u02B9": exports.MO.ORD,
          "\u0300": exports.MO.ACCENT,
          "\u0301": exports.MO.ACCENT,
          "\u0303": exports.MO.WIDEACCENT,
          "\u0304": exports.MO.ACCENT,
          "\u0306": exports.MO.ACCENT,
          "\u0307": exports.MO.ACCENT,
          "\u0308": exports.MO.ACCENT,
          "\u030C": exports.MO.ACCENT,
          "\u0332": exports.MO.WIDEACCENT,
          "\u0338": exports.MO.REL4,
          "\u2015": [0, 0, MmlNode_js_1.TEXCLASS.ORD, { stretchy: true }],
          "\u2017": [0, 0, MmlNode_js_1.TEXCLASS.ORD, { stretchy: true }],
          "\u2020": exports.MO.BIN3,
          "\u2021": exports.MO.BIN3,
          "\u2022": exports.MO.BIN4,
          "\u2026": exports.MO.INNER,
          "\u2043": exports.MO.BIN4,
          "\u2044": exports.MO.TALLBIN,
          "\u2061": exports.MO.NONE,
          "\u2062": exports.MO.NONE,
          "\u2063": [0, 0, MmlNode_js_1.TEXCLASS.NONE, { linebreakstyle: "after", separator: true }],
          "\u2064": exports.MO.NONE,
          "\u20D7": exports.MO.ACCENT,
          "\u2111": exports.MO.ORD,
          "\u2113": exports.MO.ORD,
          "\u2118": exports.MO.ORD,
          "\u211C": exports.MO.ORD,
          "\u2190": exports.MO.WIDEREL,
          "\u2191": exports.MO.RELSTRETCH,
          "\u2192": exports.MO.WIDEREL,
          "\u2193": exports.MO.RELSTRETCH,
          "\u2194": exports.MO.WIDEREL,
          "\u2195": exports.MO.RELSTRETCH,
          "\u2196": exports.MO.RELSTRETCH,
          "\u2197": exports.MO.RELSTRETCH,
          "\u2198": exports.MO.RELSTRETCH,
          "\u2199": exports.MO.RELSTRETCH,
          "\u219A": exports.MO.RELACCENT,
          "\u219B": exports.MO.RELACCENT,
          "\u219C": exports.MO.WIDEREL,
          "\u219D": exports.MO.WIDEREL,
          "\u219E": exports.MO.WIDEREL,
          "\u219F": exports.MO.WIDEREL,
          "\u21A0": exports.MO.WIDEREL,
          "\u21A1": exports.MO.RELSTRETCH,
          "\u21A2": exports.MO.WIDEREL,
          "\u21A3": exports.MO.WIDEREL,
          "\u21A4": exports.MO.WIDEREL,
          "\u21A5": exports.MO.RELSTRETCH,
          "\u21A6": exports.MO.WIDEREL,
          "\u21A7": exports.MO.RELSTRETCH,
          "\u21A8": exports.MO.RELSTRETCH,
          "\u21A9": exports.MO.WIDEREL,
          "\u21AA": exports.MO.WIDEREL,
          "\u21AB": exports.MO.WIDEREL,
          "\u21AC": exports.MO.WIDEREL,
          "\u21AD": exports.MO.WIDEREL,
          "\u21AE": exports.MO.RELACCENT,
          "\u21AF": exports.MO.RELSTRETCH,
          "\u21B0": exports.MO.RELSTRETCH,
          "\u21B1": exports.MO.RELSTRETCH,
          "\u21B2": exports.MO.RELSTRETCH,
          "\u21B3": exports.MO.RELSTRETCH,
          "\u21B4": exports.MO.RELSTRETCH,
          "\u21B5": exports.MO.RELSTRETCH,
          "\u21B6": exports.MO.RELACCENT,
          "\u21B7": exports.MO.RELACCENT,
          "\u21B8": exports.MO.REL,
          "\u21B9": exports.MO.WIDEREL,
          "\u21BA": exports.MO.REL,
          "\u21BB": exports.MO.REL,
          "\u21BC": exports.MO.WIDEREL,
          "\u21BD": exports.MO.WIDEREL,
          "\u21BE": exports.MO.RELSTRETCH,
          "\u21BF": exports.MO.RELSTRETCH,
          "\u21C0": exports.MO.WIDEREL,
          "\u21C1": exports.MO.WIDEREL,
          "\u21C2": exports.MO.RELSTRETCH,
          "\u21C3": exports.MO.RELSTRETCH,
          "\u21C4": exports.MO.WIDEREL,
          "\u21C5": exports.MO.RELSTRETCH,
          "\u21C6": exports.MO.WIDEREL,
          "\u21C7": exports.MO.WIDEREL,
          "\u21C8": exports.MO.RELSTRETCH,
          "\u21C9": exports.MO.WIDEREL,
          "\u21CA": exports.MO.RELSTRETCH,
          "\u21CB": exports.MO.WIDEREL,
          "\u21CC": exports.MO.WIDEREL,
          "\u21CD": exports.MO.RELACCENT,
          "\u21CE": exports.MO.RELACCENT,
          "\u21CF": exports.MO.RELACCENT,
          "\u21D0": exports.MO.WIDEREL,
          "\u21D1": exports.MO.RELSTRETCH,
          "\u21D2": exports.MO.WIDEREL,
          "\u21D3": exports.MO.RELSTRETCH,
          "\u21D4": exports.MO.WIDEREL,
          "\u21D5": exports.MO.RELSTRETCH,
          "\u21D6": exports.MO.RELSTRETCH,
          "\u21D7": exports.MO.RELSTRETCH,
          "\u21D8": exports.MO.RELSTRETCH,
          "\u21D9": exports.MO.RELSTRETCH,
          "\u21DA": exports.MO.WIDEREL,
          "\u21DB": exports.MO.WIDEREL,
          "\u21DC": exports.MO.WIDEREL,
          "\u21DD": exports.MO.WIDEREL,
          "\u21DE": exports.MO.REL,
          "\u21DF": exports.MO.REL,
          "\u21E0": exports.MO.WIDEREL,
          "\u21E1": exports.MO.RELSTRETCH,
          "\u21E2": exports.MO.WIDEREL,
          "\u21E3": exports.MO.RELSTRETCH,
          "\u21E4": exports.MO.WIDEREL,
          "\u21E5": exports.MO.WIDEREL,
          "\u21E6": exports.MO.WIDEREL,
          "\u21E7": exports.MO.RELSTRETCH,
          "\u21E8": exports.MO.WIDEREL,
          "\u21E9": exports.MO.RELSTRETCH,
          "\u21EA": exports.MO.RELSTRETCH,
          "\u21EB": exports.MO.RELSTRETCH,
          "\u21EC": exports.MO.RELSTRETCH,
          "\u21ED": exports.MO.RELSTRETCH,
          "\u21EE": exports.MO.RELSTRETCH,
          "\u21EF": exports.MO.RELSTRETCH,
          "\u21F0": exports.MO.WIDEREL,
          "\u21F1": exports.MO.REL,
          "\u21F2": exports.MO.REL,
          "\u21F3": exports.MO.RELSTRETCH,
          "\u21F4": exports.MO.RELACCENT,
          "\u21F5": exports.MO.RELSTRETCH,
          "\u21F6": exports.MO.WIDEREL,
          "\u21F7": exports.MO.RELACCENT,
          "\u21F8": exports.MO.RELACCENT,
          "\u21F9": exports.MO.RELACCENT,
          "\u21FA": exports.MO.RELACCENT,
          "\u21FB": exports.MO.RELACCENT,
          "\u21FC": exports.MO.RELACCENT,
          "\u21FD": exports.MO.WIDEREL,
          "\u21FE": exports.MO.WIDEREL,
          "\u21FF": exports.MO.WIDEREL,
          "\u2201": OPDEF(1, 2, MmlNode_js_1.TEXCLASS.ORD),
          "\u2205": exports.MO.ORD,
          "\u2206": exports.MO.BIN3,
          "\u2208": exports.MO.REL,
          "\u2209": exports.MO.REL,
          "\u220A": exports.MO.REL,
          "\u220B": exports.MO.REL,
          "\u220C": exports.MO.REL,
          "\u220D": exports.MO.REL,
          "\u220E": exports.MO.BIN3,
          "\u2212": exports.MO.BIN4,
          "\u2213": exports.MO.BIN4,
          "\u2214": exports.MO.BIN4,
          "\u2215": exports.MO.TALLBIN,
          "\u2216": exports.MO.BIN4,
          "\u2217": exports.MO.BIN4,
          "\u2218": exports.MO.BIN4,
          "\u2219": exports.MO.BIN4,
          "\u221D": exports.MO.REL,
          "\u221E": exports.MO.ORD,
          "\u221F": exports.MO.REL,
          "\u2223": exports.MO.REL,
          "\u2224": exports.MO.REL,
          "\u2225": exports.MO.REL,
          "\u2226": exports.MO.REL,
          "\u2227": exports.MO.BIN4,
          "\u2228": exports.MO.BIN4,
          "\u2229": exports.MO.BIN4,
          "\u222A": exports.MO.BIN4,
          "\u2234": exports.MO.REL,
          "\u2235": exports.MO.REL,
          "\u2236": exports.MO.REL,
          "\u2237": exports.MO.REL,
          "\u2238": exports.MO.BIN4,
          "\u2239": exports.MO.REL,
          "\u223A": exports.MO.BIN4,
          "\u223B": exports.MO.REL,
          "\u223C": exports.MO.REL,
          "\u223D": exports.MO.REL,
          "\u223D\u0331": exports.MO.BIN3,
          "\u223E": exports.MO.REL,
          "\u223F": exports.MO.BIN3,
          "\u2240": exports.MO.BIN4,
          "\u2241": exports.MO.REL,
          "\u2242": exports.MO.REL,
          "\u2242\u0338": exports.MO.REL,
          "\u2243": exports.MO.REL,
          "\u2244": exports.MO.REL,
          "\u2245": exports.MO.REL,
          "\u2246": exports.MO.REL,
          "\u2247": exports.MO.REL,
          "\u2248": exports.MO.REL,
          "\u2249": exports.MO.REL,
          "\u224A": exports.MO.REL,
          "\u224B": exports.MO.REL,
          "\u224C": exports.MO.REL,
          "\u224D": exports.MO.REL,
          "\u224E": exports.MO.REL,
          "\u224E\u0338": exports.MO.REL,
          "\u224F": exports.MO.REL,
          "\u224F\u0338": exports.MO.REL,
          "\u2250": exports.MO.REL,
          "\u2251": exports.MO.REL,
          "\u2252": exports.MO.REL,
          "\u2253": exports.MO.REL,
          "\u2254": exports.MO.REL,
          "\u2255": exports.MO.REL,
          "\u2256": exports.MO.REL,
          "\u2257": exports.MO.REL,
          "\u2258": exports.MO.REL,
          "\u2259": exports.MO.REL,
          "\u225A": exports.MO.REL,
          "\u225B": exports.MO.REL,
          "\u225C": exports.MO.REL,
          "\u225D": exports.MO.REL,
          "\u225E": exports.MO.REL,
          "\u225F": exports.MO.REL,
          "\u2260": exports.MO.REL,
          "\u2261": exports.MO.REL,
          "\u2262": exports.MO.REL,
          "\u2263": exports.MO.REL,
          "\u2264": exports.MO.REL,
          "\u2265": exports.MO.REL,
          "\u2266": exports.MO.REL,
          "\u2266\u0338": exports.MO.REL,
          "\u2267": exports.MO.REL,
          "\u2268": exports.MO.REL,
          "\u2269": exports.MO.REL,
          "\u226A": exports.MO.REL,
          "\u226A\u0338": exports.MO.REL,
          "\u226B": exports.MO.REL,
          "\u226B\u0338": exports.MO.REL,
          "\u226C": exports.MO.REL,
          "\u226D": exports.MO.REL,
          "\u226E": exports.MO.REL,
          "\u226F": exports.MO.REL,
          "\u2270": exports.MO.REL,
          "\u2271": exports.MO.REL,
          "\u2272": exports.MO.REL,
          "\u2273": exports.MO.REL,
          "\u2274": exports.MO.REL,
          "\u2275": exports.MO.REL,
          "\u2276": exports.MO.REL,
          "\u2277": exports.MO.REL,
          "\u2278": exports.MO.REL,
          "\u2279": exports.MO.REL,
          "\u227A": exports.MO.REL,
          "\u227B": exports.MO.REL,
          "\u227C": exports.MO.REL,
          "\u227D": exports.MO.REL,
          "\u227E": exports.MO.REL,
          "\u227F": exports.MO.REL,
          "\u227F\u0338": exports.MO.REL,
          "\u2280": exports.MO.REL,
          "\u2281": exports.MO.REL,
          "\u2282": exports.MO.REL,
          "\u2282\u20D2": exports.MO.REL,
          "\u2283": exports.MO.REL,
          "\u2283\u20D2": exports.MO.REL,
          "\u2284": exports.MO.REL,
          "\u2285": exports.MO.REL,
          "\u2286": exports.MO.REL,
          "\u2287": exports.MO.REL,
          "\u2288": exports.MO.REL,
          "\u2289": exports.MO.REL,
          "\u228A": exports.MO.REL,
          "\u228B": exports.MO.REL,
          "\u228C": exports.MO.BIN4,
          "\u228D": exports.MO.BIN4,
          "\u228E": exports.MO.BIN4,
          "\u228F": exports.MO.REL,
          "\u228F\u0338": exports.MO.REL,
          "\u2290": exports.MO.REL,
          "\u2290\u0338": exports.MO.REL,
          "\u2291": exports.MO.REL,
          "\u2292": exports.MO.REL,
          "\u2293": exports.MO.BIN4,
          "\u2294": exports.MO.BIN4,
          "\u2295": exports.MO.BIN4,
          "\u2296": exports.MO.BIN4,
          "\u2297": exports.MO.BIN4,
          "\u2298": exports.MO.BIN4,
          "\u2299": exports.MO.BIN4,
          "\u229A": exports.MO.BIN4,
          "\u229B": exports.MO.BIN4,
          "\u229C": exports.MO.BIN4,
          "\u229D": exports.MO.BIN4,
          "\u229E": exports.MO.BIN4,
          "\u229F": exports.MO.BIN4,
          "\u22A0": exports.MO.BIN4,
          "\u22A1": exports.MO.BIN4,
          "\u22A2": exports.MO.REL,
          "\u22A3": exports.MO.REL,
          "\u22A4": exports.MO.ORD55,
          "\u22A5": exports.MO.REL,
          "\u22A6": exports.MO.REL,
          "\u22A7": exports.MO.REL,
          "\u22A8": exports.MO.REL,
          "\u22A9": exports.MO.REL,
          "\u22AA": exports.MO.REL,
          "\u22AB": exports.MO.REL,
          "\u22AC": exports.MO.REL,
          "\u22AD": exports.MO.REL,
          "\u22AE": exports.MO.REL,
          "\u22AF": exports.MO.REL,
          "\u22B0": exports.MO.REL,
          "\u22B1": exports.MO.REL,
          "\u22B2": exports.MO.REL,
          "\u22B3": exports.MO.REL,
          "\u22B4": exports.MO.REL,
          "\u22B5": exports.MO.REL,
          "\u22B6": exports.MO.REL,
          "\u22B7": exports.MO.REL,
          "\u22B8": exports.MO.REL,
          "\u22B9": exports.MO.REL,
          "\u22BA": exports.MO.BIN4,
          "\u22BB": exports.MO.BIN4,
          "\u22BC": exports.MO.BIN4,
          "\u22BD": exports.MO.BIN4,
          "\u22BE": exports.MO.BIN3,
          "\u22BF": exports.MO.BIN3,
          "\u22C4": exports.MO.BIN4,
          "\u22C5": exports.MO.BIN4,
          "\u22C6": exports.MO.BIN4,
          "\u22C7": exports.MO.BIN4,
          "\u22C8": exports.MO.REL,
          "\u22C9": exports.MO.BIN4,
          "\u22CA": exports.MO.BIN4,
          "\u22CB": exports.MO.BIN4,
          "\u22CC": exports.MO.BIN4,
          "\u22CD": exports.MO.REL,
          "\u22CE": exports.MO.BIN4,
          "\u22CF": exports.MO.BIN4,
          "\u22D0": exports.MO.REL,
          "\u22D1": exports.MO.REL,
          "\u22D2": exports.MO.BIN4,
          "\u22D3": exports.MO.BIN4,
          "\u22D4": exports.MO.REL,
          "\u22D5": exports.MO.REL,
          "\u22D6": exports.MO.REL,
          "\u22D7": exports.MO.REL,
          "\u22D8": exports.MO.REL,
          "\u22D9": exports.MO.REL,
          "\u22DA": exports.MO.REL,
          "\u22DB": exports.MO.REL,
          "\u22DC": exports.MO.REL,
          "\u22DD": exports.MO.REL,
          "\u22DE": exports.MO.REL,
          "\u22DF": exports.MO.REL,
          "\u22E0": exports.MO.REL,
          "\u22E1": exports.MO.REL,
          "\u22E2": exports.MO.REL,
          "\u22E3": exports.MO.REL,
          "\u22E4": exports.MO.REL,
          "\u22E5": exports.MO.REL,
          "\u22E6": exports.MO.REL,
          "\u22E7": exports.MO.REL,
          "\u22E8": exports.MO.REL,
          "\u22E9": exports.MO.REL,
          "\u22EA": exports.MO.REL,
          "\u22EB": exports.MO.REL,
          "\u22EC": exports.MO.REL,
          "\u22ED": exports.MO.REL,
          "\u22EE": exports.MO.ORD55,
          "\u22EF": exports.MO.INNER,
          "\u22F0": exports.MO.REL,
          "\u22F1": [5, 5, MmlNode_js_1.TEXCLASS.INNER, null],
          "\u22F2": exports.MO.REL,
          "\u22F3": exports.MO.REL,
          "\u22F4": exports.MO.REL,
          "\u22F5": exports.MO.REL,
          "\u22F6": exports.MO.REL,
          "\u22F7": exports.MO.REL,
          "\u22F8": exports.MO.REL,
          "\u22F9": exports.MO.REL,
          "\u22FA": exports.MO.REL,
          "\u22FB": exports.MO.REL,
          "\u22FC": exports.MO.REL,
          "\u22FD": exports.MO.REL,
          "\u22FE": exports.MO.REL,
          "\u22FF": exports.MO.REL,
          "\u2305": exports.MO.BIN3,
          "\u2306": exports.MO.BIN3,
          "\u2322": exports.MO.REL4,
          "\u2323": exports.MO.REL4,
          "\u2329": exports.MO.OPEN,
          "\u232A": exports.MO.CLOSE,
          "\u23AA": exports.MO.ORD,
          "\u23AF": [0, 0, MmlNode_js_1.TEXCLASS.ORD, { stretchy: true }],
          "\u23B0": exports.MO.OPEN,
          "\u23B1": exports.MO.CLOSE,
          "\u2500": exports.MO.ORD,
          "\u25B3": exports.MO.BIN4,
          "\u25B5": exports.MO.BIN4,
          "\u25B9": exports.MO.BIN4,
          "\u25BD": exports.MO.BIN4,
          "\u25BF": exports.MO.BIN4,
          "\u25C3": exports.MO.BIN4,
          "\u25EF": exports.MO.BIN3,
          "\u2660": exports.MO.ORD,
          "\u2661": exports.MO.ORD,
          "\u2662": exports.MO.ORD,
          "\u2663": exports.MO.ORD,
          "\u2758": exports.MO.REL,
          "\u27F0": exports.MO.RELSTRETCH,
          "\u27F1": exports.MO.RELSTRETCH,
          "\u27F5": exports.MO.WIDEREL,
          "\u27F6": exports.MO.WIDEREL,
          "\u27F7": exports.MO.WIDEREL,
          "\u27F8": exports.MO.WIDEREL,
          "\u27F9": exports.MO.WIDEREL,
          "\u27FA": exports.MO.WIDEREL,
          "\u27FB": exports.MO.WIDEREL,
          "\u27FC": exports.MO.WIDEREL,
          "\u27FD": exports.MO.WIDEREL,
          "\u27FE": exports.MO.WIDEREL,
          "\u27FF": exports.MO.WIDEREL,
          "\u2900": exports.MO.RELACCENT,
          "\u2901": exports.MO.RELACCENT,
          "\u2902": exports.MO.RELACCENT,
          "\u2903": exports.MO.RELACCENT,
          "\u2904": exports.MO.RELACCENT,
          "\u2905": exports.MO.RELACCENT,
          "\u2906": exports.MO.RELACCENT,
          "\u2907": exports.MO.RELACCENT,
          "\u2908": exports.MO.REL,
          "\u2909": exports.MO.REL,
          "\u290A": exports.MO.RELSTRETCH,
          "\u290B": exports.MO.RELSTRETCH,
          "\u290C": exports.MO.WIDEREL,
          "\u290D": exports.MO.WIDEREL,
          "\u290E": exports.MO.WIDEREL,
          "\u290F": exports.MO.WIDEREL,
          "\u2910": exports.MO.WIDEREL,
          "\u2911": exports.MO.RELACCENT,
          "\u2912": exports.MO.RELSTRETCH,
          "\u2913": exports.MO.RELSTRETCH,
          "\u2914": exports.MO.RELACCENT,
          "\u2915": exports.MO.RELACCENT,
          "\u2916": exports.MO.RELACCENT,
          "\u2917": exports.MO.RELACCENT,
          "\u2918": exports.MO.RELACCENT,
          "\u2919": exports.MO.RELACCENT,
          "\u291A": exports.MO.RELACCENT,
          "\u291B": exports.MO.RELACCENT,
          "\u291C": exports.MO.RELACCENT,
          "\u291D": exports.MO.RELACCENT,
          "\u291E": exports.MO.RELACCENT,
          "\u291F": exports.MO.RELACCENT,
          "\u2920": exports.MO.RELACCENT,
          "\u2921": exports.MO.RELSTRETCH,
          "\u2922": exports.MO.RELSTRETCH,
          "\u2923": exports.MO.REL,
          "\u2924": exports.MO.REL,
          "\u2925": exports.MO.REL,
          "\u2926": exports.MO.REL,
          "\u2927": exports.MO.REL,
          "\u2928": exports.MO.REL,
          "\u2929": exports.MO.REL,
          "\u292A": exports.MO.REL,
          "\u292B": exports.MO.REL,
          "\u292C": exports.MO.REL,
          "\u292D": exports.MO.REL,
          "\u292E": exports.MO.REL,
          "\u292F": exports.MO.REL,
          "\u2930": exports.MO.REL,
          "\u2931": exports.MO.REL,
          "\u2932": exports.MO.REL,
          "\u2933": exports.MO.RELACCENT,
          "\u2934": exports.MO.REL,
          "\u2935": exports.MO.REL,
          "\u2936": exports.MO.REL,
          "\u2937": exports.MO.REL,
          "\u2938": exports.MO.REL,
          "\u2939": exports.MO.REL,
          "\u293A": exports.MO.RELACCENT,
          "\u293B": exports.MO.RELACCENT,
          "\u293C": exports.MO.RELACCENT,
          "\u293D": exports.MO.RELACCENT,
          "\u293E": exports.MO.REL,
          "\u293F": exports.MO.REL,
          "\u2940": exports.MO.REL,
          "\u2941": exports.MO.REL,
          "\u2942": exports.MO.RELACCENT,
          "\u2943": exports.MO.RELACCENT,
          "\u2944": exports.MO.RELACCENT,
          "\u2945": exports.MO.RELACCENT,
          "\u2946": exports.MO.RELACCENT,
          "\u2947": exports.MO.RELACCENT,
          "\u2948": exports.MO.RELACCENT,
          "\u2949": exports.MO.REL,
          "\u294A": exports.MO.RELACCENT,
          "\u294B": exports.MO.RELACCENT,
          "\u294C": exports.MO.REL,
          "\u294D": exports.MO.REL,
          "\u294E": exports.MO.WIDEREL,
          "\u294F": exports.MO.RELSTRETCH,
          "\u2950": exports.MO.WIDEREL,
          "\u2951": exports.MO.RELSTRETCH,
          "\u2952": exports.MO.WIDEREL,
          "\u2953": exports.MO.WIDEREL,
          "\u2954": exports.MO.RELSTRETCH,
          "\u2955": exports.MO.RELSTRETCH,
          "\u2956": exports.MO.RELSTRETCH,
          "\u2957": exports.MO.RELSTRETCH,
          "\u2958": exports.MO.RELSTRETCH,
          "\u2959": exports.MO.RELSTRETCH,
          "\u295A": exports.MO.WIDEREL,
          "\u295B": exports.MO.WIDEREL,
          "\u295C": exports.MO.RELSTRETCH,
          "\u295D": exports.MO.RELSTRETCH,
          "\u295E": exports.MO.WIDEREL,
          "\u295F": exports.MO.WIDEREL,
          "\u2960": exports.MO.RELSTRETCH,
          "\u2961": exports.MO.RELSTRETCH,
          "\u2962": exports.MO.RELACCENT,
          "\u2963": exports.MO.REL,
          "\u2964": exports.MO.RELACCENT,
          "\u2965": exports.MO.REL,
          "\u2966": exports.MO.RELACCENT,
          "\u2967": exports.MO.RELACCENT,
          "\u2968": exports.MO.RELACCENT,
          "\u2969": exports.MO.RELACCENT,
          "\u296A": exports.MO.RELACCENT,
          "\u296B": exports.MO.RELACCENT,
          "\u296C": exports.MO.RELACCENT,
          "\u296D": exports.MO.RELACCENT,
          "\u296E": exports.MO.RELSTRETCH,
          "\u296F": exports.MO.RELSTRETCH,
          "\u2970": exports.MO.RELACCENT,
          "\u2971": exports.MO.RELACCENT,
          "\u2972": exports.MO.RELACCENT,
          "\u2973": exports.MO.RELACCENT,
          "\u2974": exports.MO.RELACCENT,
          "\u2975": exports.MO.RELACCENT,
          "\u2976": exports.MO.RELACCENT,
          "\u2977": exports.MO.RELACCENT,
          "\u2978": exports.MO.RELACCENT,
          "\u2979": exports.MO.RELACCENT,
          "\u297A": exports.MO.RELACCENT,
          "\u297B": exports.MO.RELACCENT,
          "\u297C": exports.MO.RELACCENT,
          "\u297D": exports.MO.RELACCENT,
          "\u297E": exports.MO.REL,
          "\u297F": exports.MO.REL,
          "\u2981": exports.MO.BIN3,
          "\u2982": exports.MO.BIN3,
          "\u2999": exports.MO.BIN3,
          "\u299A": exports.MO.BIN3,
          "\u299B": exports.MO.BIN3,
          "\u299C": exports.MO.BIN3,
          "\u299D": exports.MO.BIN3,
          "\u299E": exports.MO.BIN3,
          "\u299F": exports.MO.BIN3,
          "\u29A0": exports.MO.BIN3,
          "\u29A1": exports.MO.BIN3,
          "\u29A2": exports.MO.BIN3,
          "\u29A3": exports.MO.BIN3,
          "\u29A4": exports.MO.BIN3,
          "\u29A5": exports.MO.BIN3,
          "\u29A6": exports.MO.BIN3,
          "\u29A7": exports.MO.BIN3,
          "\u29A8": exports.MO.BIN3,
          "\u29A9": exports.MO.BIN3,
          "\u29AA": exports.MO.BIN3,
          "\u29AB": exports.MO.BIN3,
          "\u29AC": exports.MO.BIN3,
          "\u29AD": exports.MO.BIN3,
          "\u29AE": exports.MO.BIN3,
          "\u29AF": exports.MO.BIN3,
          "\u29B0": exports.MO.BIN3,
          "\u29B1": exports.MO.BIN3,
          "\u29B2": exports.MO.BIN3,
          "\u29B3": exports.MO.BIN3,
          "\u29B4": exports.MO.BIN3,
          "\u29B5": exports.MO.BIN3,
          "\u29B6": exports.MO.BIN4,
          "\u29B7": exports.MO.BIN4,
          "\u29B8": exports.MO.BIN4,
          "\u29B9": exports.MO.BIN4,
          "\u29BA": exports.MO.BIN4,
          "\u29BB": exports.MO.BIN4,
          "\u29BC": exports.MO.BIN4,
          "\u29BD": exports.MO.BIN4,
          "\u29BE": exports.MO.BIN4,
          "\u29BF": exports.MO.BIN4,
          "\u29C0": exports.MO.REL,
          "\u29C1": exports.MO.REL,
          "\u29C2": exports.MO.BIN3,
          "\u29C3": exports.MO.BIN3,
          "\u29C4": exports.MO.BIN4,
          "\u29C5": exports.MO.BIN4,
          "\u29C6": exports.MO.BIN4,
          "\u29C7": exports.MO.BIN4,
          "\u29C8": exports.MO.BIN4,
          "\u29C9": exports.MO.BIN3,
          "\u29CA": exports.MO.BIN3,
          "\u29CB": exports.MO.BIN3,
          "\u29CC": exports.MO.BIN3,
          "\u29CD": exports.MO.BIN3,
          "\u29CE": exports.MO.REL,
          "\u29CF": exports.MO.REL,
          "\u29CF\u0338": exports.MO.REL,
          "\u29D0": exports.MO.REL,
          "\u29D0\u0338": exports.MO.REL,
          "\u29D1": exports.MO.REL,
          "\u29D2": exports.MO.REL,
          "\u29D3": exports.MO.REL,
          "\u29D4": exports.MO.REL,
          "\u29D5": exports.MO.REL,
          "\u29D6": exports.MO.BIN4,
          "\u29D7": exports.MO.BIN4,
          "\u29D8": exports.MO.BIN3,
          "\u29D9": exports.MO.BIN3,
          "\u29DB": exports.MO.BIN3,
          "\u29DC": exports.MO.BIN3,
          "\u29DD": exports.MO.BIN3,
          "\u29DE": exports.MO.REL,
          "\u29DF": exports.MO.BIN3,
          "\u29E0": exports.MO.BIN3,
          "\u29E1": exports.MO.REL,
          "\u29E2": exports.MO.BIN4,
          "\u29E3": exports.MO.REL,
          "\u29E4": exports.MO.REL,
          "\u29E5": exports.MO.REL,
          "\u29E6": exports.MO.REL,
          "\u29E7": exports.MO.BIN3,
          "\u29E8": exports.MO.BIN3,
          "\u29E9": exports.MO.BIN3,
          "\u29EA": exports.MO.BIN3,
          "\u29EB": exports.MO.BIN3,
          "\u29EC": exports.MO.BIN3,
          "\u29ED": exports.MO.BIN3,
          "\u29EE": exports.MO.BIN3,
          "\u29EF": exports.MO.BIN3,
          "\u29F0": exports.MO.BIN3,
          "\u29F1": exports.MO.BIN3,
          "\u29F2": exports.MO.BIN3,
          "\u29F3": exports.MO.BIN3,
          "\u29F4": exports.MO.REL,
          "\u29F5": exports.MO.BIN4,
          "\u29F6": exports.MO.BIN4,
          "\u29F7": exports.MO.BIN4,
          "\u29F8": exports.MO.BIN3,
          "\u29F9": exports.MO.BIN3,
          "\u29FA": exports.MO.BIN3,
          "\u29FB": exports.MO.BIN3,
          "\u29FE": exports.MO.BIN4,
          "\u29FF": exports.MO.BIN4,
          "\u2A1D": exports.MO.BIN3,
          "\u2A1E": exports.MO.BIN3,
          "\u2A1F": exports.MO.BIN3,
          "\u2A20": exports.MO.BIN3,
          "\u2A21": exports.MO.BIN3,
          "\u2A22": exports.MO.BIN4,
          "\u2A23": exports.MO.BIN4,
          "\u2A24": exports.MO.BIN4,
          "\u2A25": exports.MO.BIN4,
          "\u2A26": exports.MO.BIN4,
          "\u2A27": exports.MO.BIN4,
          "\u2A28": exports.MO.BIN4,
          "\u2A29": exports.MO.BIN4,
          "\u2A2A": exports.MO.BIN4,
          "\u2A2B": exports.MO.BIN4,
          "\u2A2C": exports.MO.BIN4,
          "\u2A2D": exports.MO.BIN4,
          "\u2A2E": exports.MO.BIN4,
          "\u2A2F": exports.MO.BIN4,
          "\u2A30": exports.MO.BIN4,
          "\u2A31": exports.MO.BIN4,
          "\u2A32": exports.MO.BIN4,
          "\u2A33": exports.MO.BIN4,
          "\u2A34": exports.MO.BIN4,
          "\u2A35": exports.MO.BIN4,
          "\u2A36": exports.MO.BIN4,
          "\u2A37": exports.MO.BIN4,
          "\u2A38": exports.MO.BIN4,
          "\u2A39": exports.MO.BIN4,
          "\u2A3A": exports.MO.BIN4,
          "\u2A3B": exports.MO.BIN4,
          "\u2A3C": exports.MO.BIN4,
          "\u2A3D": exports.MO.BIN4,
          "\u2A3E": exports.MO.BIN4,
          "\u2A3F": exports.MO.BIN4,
          "\u2A40": exports.MO.BIN4,
          "\u2A41": exports.MO.BIN4,
          "\u2A42": exports.MO.BIN4,
          "\u2A43": exports.MO.BIN4,
          "\u2A44": exports.MO.BIN4,
          "\u2A45": exports.MO.BIN4,
          "\u2A46": exports.MO.BIN4,
          "\u2A47": exports.MO.BIN4,
          "\u2A48": exports.MO.BIN4,
          "\u2A49": exports.MO.BIN4,
          "\u2A4A": exports.MO.BIN4,
          "\u2A4B": exports.MO.BIN4,
          "\u2A4C": exports.MO.BIN4,
          "\u2A4D": exports.MO.BIN4,
          "\u2A4E": exports.MO.BIN4,
          "\u2A4F": exports.MO.BIN4,
          "\u2A50": exports.MO.BIN4,
          "\u2A51": exports.MO.BIN4,
          "\u2A52": exports.MO.BIN4,
          "\u2A53": exports.MO.BIN4,
          "\u2A54": exports.MO.BIN4,
          "\u2A55": exports.MO.BIN4,
          "\u2A56": exports.MO.BIN4,
          "\u2A57": exports.MO.BIN4,
          "\u2A58": exports.MO.BIN4,
          "\u2A59": exports.MO.REL,
          "\u2A5A": exports.MO.BIN4,
          "\u2A5B": exports.MO.BIN4,
          "\u2A5C": exports.MO.BIN4,
          "\u2A5D": exports.MO.BIN4,
          "\u2A5E": exports.MO.BIN4,
          "\u2A5F": exports.MO.BIN4,
          "\u2A60": exports.MO.BIN4,
          "\u2A61": exports.MO.BIN4,
          "\u2A62": exports.MO.BIN4,
          "\u2A63": exports.MO.BIN4,
          "\u2A64": exports.MO.BIN4,
          "\u2A65": exports.MO.BIN4,
          "\u2A66": exports.MO.REL,
          "\u2A67": exports.MO.REL,
          "\u2A68": exports.MO.REL,
          "\u2A69": exports.MO.REL,
          "\u2A6A": exports.MO.REL,
          "\u2A6B": exports.MO.REL,
          "\u2A6C": exports.MO.REL,
          "\u2A6D": exports.MO.REL,
          "\u2A6E": exports.MO.REL,
          "\u2A6F": exports.MO.REL,
          "\u2A70": exports.MO.REL,
          "\u2A71": exports.MO.BIN4,
          "\u2A72": exports.MO.BIN4,
          "\u2A73": exports.MO.REL,
          "\u2A74": exports.MO.REL,
          "\u2A75": exports.MO.REL,
          "\u2A76": exports.MO.REL,
          "\u2A77": exports.MO.REL,
          "\u2A78": exports.MO.REL,
          "\u2A79": exports.MO.REL,
          "\u2A7A": exports.MO.REL,
          "\u2A7B": exports.MO.REL,
          "\u2A7C": exports.MO.REL,
          "\u2A7D": exports.MO.REL,
          "\u2A7D\u0338": exports.MO.REL,
          "\u2A7E": exports.MO.REL,
          "\u2A7E\u0338": exports.MO.REL,
          "\u2A7F": exports.MO.REL,
          "\u2A80": exports.MO.REL,
          "\u2A81": exports.MO.REL,
          "\u2A82": exports.MO.REL,
          "\u2A83": exports.MO.REL,
          "\u2A84": exports.MO.REL,
          "\u2A85": exports.MO.REL,
          "\u2A86": exports.MO.REL,
          "\u2A87": exports.MO.REL,
          "\u2A88": exports.MO.REL,
          "\u2A89": exports.MO.REL,
          "\u2A8A": exports.MO.REL,
          "\u2A8B": exports.MO.REL,
          "\u2A8C": exports.MO.REL,
          "\u2A8D": exports.MO.REL,
          "\u2A8E": exports.MO.REL,
          "\u2A8F": exports.MO.REL,
          "\u2A90": exports.MO.REL,
          "\u2A91": exports.MO.REL,
          "\u2A92": exports.MO.REL,
          "\u2A93": exports.MO.REL,
          "\u2A94": exports.MO.REL,
          "\u2A95": exports.MO.REL,
          "\u2A96": exports.MO.REL,
          "\u2A97": exports.MO.REL,
          "\u2A98": exports.MO.REL,
          "\u2A99": exports.MO.REL,
          "\u2A9A": exports.MO.REL,
          "\u2A9B": exports.MO.REL,
          "\u2A9C": exports.MO.REL,
          "\u2A9D": exports.MO.REL,
          "\u2A9E": exports.MO.REL,
          "\u2A9F": exports.MO.REL,
          "\u2AA0": exports.MO.REL,
          "\u2AA1": exports.MO.REL,
          "\u2AA1\u0338": exports.MO.REL,
          "\u2AA2": exports.MO.REL,
          "\u2AA2\u0338": exports.MO.REL,
          "\u2AA3": exports.MO.REL,
          "\u2AA4": exports.MO.REL,
          "\u2AA5": exports.MO.REL,
          "\u2AA6": exports.MO.REL,
          "\u2AA7": exports.MO.REL,
          "\u2AA8": exports.MO.REL,
          "\u2AA9": exports.MO.REL,
          "\u2AAA": exports.MO.REL,
          "\u2AAB": exports.MO.REL,
          "\u2AAC": exports.MO.REL,
          "\u2AAD": exports.MO.REL,
          "\u2AAE": exports.MO.REL,
          "\u2AAF": exports.MO.REL,
          "\u2AAF\u0338": exports.MO.REL,
          "\u2AB0": exports.MO.REL,
          "\u2AB0\u0338": exports.MO.REL,
          "\u2AB1": exports.MO.REL,
          "\u2AB2": exports.MO.REL,
          "\u2AB3": exports.MO.REL,
          "\u2AB4": exports.MO.REL,
          "\u2AB5": exports.MO.REL,
          "\u2AB6": exports.MO.REL,
          "\u2AB7": exports.MO.REL,
          "\u2AB8": exports.MO.REL,
          "\u2AB9": exports.MO.REL,
          "\u2ABA": exports.MO.REL,
          "\u2ABB": exports.MO.REL,
          "\u2ABC": exports.MO.REL,
          "\u2ABD": exports.MO.REL,
          "\u2ABE": exports.MO.REL,
          "\u2ABF": exports.MO.REL,
          "\u2AC0": exports.MO.REL,
          "\u2AC1": exports.MO.REL,
          "\u2AC2": exports.MO.REL,
          "\u2AC3": exports.MO.REL,
          "\u2AC4": exports.MO.REL,
          "\u2AC5": exports.MO.REL,
          "\u2AC6": exports.MO.REL,
          "\u2AC7": exports.MO.REL,
          "\u2AC8": exports.MO.REL,
          "\u2AC9": exports.MO.REL,
          "\u2ACA": exports.MO.REL,
          "\u2ACB": exports.MO.REL,
          "\u2ACC": exports.MO.REL,
          "\u2ACD": exports.MO.REL,
          "\u2ACE": exports.MO.REL,
          "\u2ACF": exports.MO.REL,
          "\u2AD0": exports.MO.REL,
          "\u2AD1": exports.MO.REL,
          "\u2AD2": exports.MO.REL,
          "\u2AD3": exports.MO.REL,
          "\u2AD4": exports.MO.REL,
          "\u2AD5": exports.MO.REL,
          "\u2AD6": exports.MO.REL,
          "\u2AD7": exports.MO.REL,
          "\u2AD8": exports.MO.REL,
          "\u2AD9": exports.MO.REL,
          "\u2ADA": exports.MO.REL,
          "\u2ADB": exports.MO.REL,
          "\u2ADD": exports.MO.REL,
          "\u2ADD\u0338": exports.MO.REL,
          "\u2ADE": exports.MO.REL,
          "\u2ADF": exports.MO.REL,
          "\u2AE0": exports.MO.REL,
          "\u2AE1": exports.MO.REL,
          "\u2AE2": exports.MO.REL,
          "\u2AE3": exports.MO.REL,
          "\u2AE4": exports.MO.REL,
          "\u2AE5": exports.MO.REL,
          "\u2AE6": exports.MO.REL,
          "\u2AE7": exports.MO.REL,
          "\u2AE8": exports.MO.REL,
          "\u2AE9": exports.MO.REL,
          "\u2AEA": exports.MO.REL,
          "\u2AEB": exports.MO.REL,
          "\u2AEC": exports.MO.REL,
          "\u2AED": exports.MO.REL,
          "\u2AEE": exports.MO.REL,
          "\u2AEF": exports.MO.REL,
          "\u2AF0": exports.MO.REL,
          "\u2AF1": exports.MO.REL,
          "\u2AF2": exports.MO.REL,
          "\u2AF3": exports.MO.REL,
          "\u2AF4": exports.MO.BIN4,
          "\u2AF5": exports.MO.BIN4,
          "\u2AF6": exports.MO.BIN4,
          "\u2AF7": exports.MO.REL,
          "\u2AF8": exports.MO.REL,
          "\u2AF9": exports.MO.REL,
          "\u2AFA": exports.MO.REL,
          "\u2AFB": exports.MO.BIN4,
          "\u2AFD": exports.MO.BIN4,
          "\u2AFE": exports.MO.BIN3,
          "\u2B45": exports.MO.RELSTRETCH,
          "\u2B46": exports.MO.RELSTRETCH,
          "\u3008": exports.MO.OPEN,
          "\u3009": exports.MO.CLOSE,
          "\uFE37": exports.MO.WIDEACCENT,
          "\uFE38": exports.MO.WIDEACCENT
        }
      };
      exports.OPTABLE.infix["^"] = exports.MO.WIDEREL;
      exports.OPTABLE.infix["_"] = exports.MO.WIDEREL;
      exports.OPTABLE.infix["\u2ADC"] = exports.MO.REL;
    }
  });

  // node_modules/mathjax-full/js/core/MmlTree/MmlNodes/mo.js
  var require_mo = __commonJS({
    "node_modules/mathjax-full/js/core/MmlTree/MmlNodes/mo.js"(exports) {
      "use strict";
      var __extends2 = exports && exports.__extends || function() {
        var extendStatics2 = function(d, b) {
          extendStatics2 = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
            d2.__proto__ = b2;
          } || function(d2, b2) {
            for (var p in b2)
              if (Object.prototype.hasOwnProperty.call(b2, p))
                d2[p] = b2[p];
          };
          return extendStatics2(d, b);
        };
        return function(d, b) {
          if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
          extendStatics2(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var __assign2 = exports && exports.__assign || function() {
        __assign2 = Object.assign || function(t) {
          for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s)
              if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
          }
          return t;
        };
        return __assign2.apply(this, arguments);
      };
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.MmlMo = void 0;
      var MmlNode_js_1 = require_MmlNode();
      var OperatorDictionary_js_1 = require_OperatorDictionary();
      var string_js_1 = require_string();
      var MmlMo = function(_super) {
        __extends2(MmlMo2, _super);
        function MmlMo2() {
          var _this = _super !== null && _super.apply(this, arguments) || this;
          _this._texClass = null;
          _this.lspace = 5 / 18;
          _this.rspace = 5 / 18;
          return _this;
        }
        Object.defineProperty(MmlMo2.prototype, "texClass", {
          get: function() {
            if (this._texClass === null) {
              var mo = this.getText();
              var _a = __read2(this.handleExplicitForm(this.getForms()), 3), form1 = _a[0], form2 = _a[1], form3 = _a[2];
              var OPTABLE_1 = this.constructor.OPTABLE;
              var def = OPTABLE_1[form1][mo] || OPTABLE_1[form2][mo] || OPTABLE_1[form3][mo];
              return def ? def[2] : MmlNode_js_1.TEXCLASS.REL;
            }
            return this._texClass;
          },
          set: function(value) {
            this._texClass = value;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(MmlMo2.prototype, "kind", {
          get: function() {
            return "mo";
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(MmlMo2.prototype, "isEmbellished", {
          get: function() {
            return true;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(MmlMo2.prototype, "hasNewLine", {
          get: function() {
            return this.attributes.get("linebreak") === "newline";
          },
          enumerable: false,
          configurable: true
        });
        MmlMo2.prototype.coreParent = function() {
          var embellished = this;
          var parent = this;
          var math = this.factory.getNodeClass("math");
          while (parent && parent.isEmbellished && parent.coreMO() === this && !(parent instanceof math)) {
            embellished = parent;
            parent = parent.parent;
          }
          return embellished;
        };
        MmlMo2.prototype.coreText = function(parent) {
          if (!parent) {
            return "";
          }
          if (parent.isEmbellished) {
            return parent.coreMO().getText();
          }
          while (((parent.isKind("mrow") || parent.isKind("TeXAtom") && parent.texClass !== MmlNode_js_1.TEXCLASS.VCENTER || parent.isKind("mstyle") || parent.isKind("mphantom")) && parent.childNodes.length === 1 || parent.isKind("munderover")) && parent.childNodes[0]) {
            parent = parent.childNodes[0];
          }
          return parent.isToken ? parent.getText() : "";
        };
        MmlMo2.prototype.hasSpacingAttributes = function() {
          return this.attributes.isSet("lspace") || this.attributes.isSet("rspace");
        };
        Object.defineProperty(MmlMo2.prototype, "isAccent", {
          get: function() {
            var accent = false;
            var node = this.coreParent().parent;
            if (node) {
              var key = node.isKind("mover") ? node.childNodes[node.over].coreMO() ? "accent" : "" : node.isKind("munder") ? node.childNodes[node.under].coreMO() ? "accentunder" : "" : node.isKind("munderover") ? this === node.childNodes[node.over].coreMO() ? "accent" : this === node.childNodes[node.under].coreMO() ? "accentunder" : "" : "";
              if (key) {
                var value = node.attributes.getExplicit(key);
                accent = value !== void 0 ? accent : this.attributes.get("accent");
              }
            }
            return accent;
          },
          enumerable: false,
          configurable: true
        });
        MmlMo2.prototype.setTeXclass = function(prev) {
          var _a = this.attributes.getList("form", "fence"), form = _a.form, fence = _a.fence;
          if (this.getProperty("texClass") === void 0 && (this.attributes.isSet("lspace") || this.attributes.isSet("rspace"))) {
            return null;
          }
          if (fence && this.texClass === MmlNode_js_1.TEXCLASS.REL) {
            if (form === "prefix") {
              this.texClass = MmlNode_js_1.TEXCLASS.OPEN;
            }
            if (form === "postfix") {
              this.texClass = MmlNode_js_1.TEXCLASS.CLOSE;
            }
          }
          return this.adjustTeXclass(prev);
        };
        MmlMo2.prototype.adjustTeXclass = function(prev) {
          var texClass = this.texClass;
          var prevClass = this.prevClass;
          if (texClass === MmlNode_js_1.TEXCLASS.NONE) {
            return prev;
          }
          if (prev) {
            if (prev.getProperty("autoOP") && (texClass === MmlNode_js_1.TEXCLASS.BIN || texClass === MmlNode_js_1.TEXCLASS.REL)) {
              prevClass = prev.texClass = MmlNode_js_1.TEXCLASS.ORD;
            }
            prevClass = this.prevClass = prev.texClass || MmlNode_js_1.TEXCLASS.ORD;
            this.prevLevel = this.attributes.getInherited("scriptlevel");
          } else {
            prevClass = this.prevClass = MmlNode_js_1.TEXCLASS.NONE;
          }
          if (texClass === MmlNode_js_1.TEXCLASS.BIN && (prevClass === MmlNode_js_1.TEXCLASS.NONE || prevClass === MmlNode_js_1.TEXCLASS.BIN || prevClass === MmlNode_js_1.TEXCLASS.OP || prevClass === MmlNode_js_1.TEXCLASS.REL || prevClass === MmlNode_js_1.TEXCLASS.OPEN || prevClass === MmlNode_js_1.TEXCLASS.PUNCT)) {
            this.texClass = MmlNode_js_1.TEXCLASS.ORD;
          } else if (prevClass === MmlNode_js_1.TEXCLASS.BIN && (texClass === MmlNode_js_1.TEXCLASS.REL || texClass === MmlNode_js_1.TEXCLASS.CLOSE || texClass === MmlNode_js_1.TEXCLASS.PUNCT)) {
            prev.texClass = this.prevClass = MmlNode_js_1.TEXCLASS.ORD;
          } else if (texClass === MmlNode_js_1.TEXCLASS.BIN) {
            var child = this;
            var parent_1 = this.parent;
            while (parent_1 && parent_1.parent && parent_1.isEmbellished && (parent_1.childNodes.length === 1 || !parent_1.isKind("mrow") && parent_1.core() === child)) {
              child = parent_1;
              parent_1 = parent_1.parent;
            }
            if (parent_1.childNodes[parent_1.childNodes.length - 1] === child) {
              this.texClass = MmlNode_js_1.TEXCLASS.ORD;
            }
          }
          return this;
        };
        MmlMo2.prototype.setInheritedAttributes = function(attributes, display, level, prime) {
          if (attributes === void 0) {
            attributes = {};
          }
          if (display === void 0) {
            display = false;
          }
          if (level === void 0) {
            level = 0;
          }
          if (prime === void 0) {
            prime = false;
          }
          _super.prototype.setInheritedAttributes.call(this, attributes, display, level, prime);
          var mo = this.getText();
          this.checkOperatorTable(mo);
          this.checkPseudoScripts(mo);
          this.checkPrimes(mo);
          this.checkMathAccent(mo);
        };
        MmlMo2.prototype.checkOperatorTable = function(mo) {
          var e_1, _a;
          var _b = __read2(this.handleExplicitForm(this.getForms()), 3), form1 = _b[0], form2 = _b[1], form3 = _b[2];
          this.attributes.setInherited("form", form1);
          var OPTABLE = this.constructor.OPTABLE;
          var def = OPTABLE[form1][mo] || OPTABLE[form2][mo] || OPTABLE[form3][mo];
          if (def) {
            if (this.getProperty("texClass") === void 0) {
              this.texClass = def[2];
            }
            try {
              for (var _c = __values2(Object.keys(def[3] || {})), _d = _c.next(); !_d.done; _d = _c.next()) {
                var name_1 = _d.value;
                this.attributes.setInherited(name_1, def[3][name_1]);
              }
            } catch (e_1_1) {
              e_1 = { error: e_1_1 };
            } finally {
              try {
                if (_d && !_d.done && (_a = _c.return))
                  _a.call(_c);
              } finally {
                if (e_1)
                  throw e_1.error;
              }
            }
            this.lspace = (def[0] + 1) / 18;
            this.rspace = (def[1] + 1) / 18;
          } else {
            var range = (0, OperatorDictionary_js_1.getRange)(mo);
            if (range) {
              if (this.getProperty("texClass") === void 0) {
                this.texClass = range[2];
              }
              var spacing = this.constructor.MMLSPACING[range[2]];
              this.lspace = (spacing[0] + 1) / 18;
              this.rspace = (spacing[1] + 1) / 18;
            }
          }
        };
        MmlMo2.prototype.getForms = function() {
          var core = this;
          var parent = this.parent;
          var Parent = this.Parent;
          while (Parent && Parent.isEmbellished) {
            core = parent;
            parent = Parent.parent;
            Parent = Parent.Parent;
          }
          if (parent && parent.isKind("mrow") && parent.nonSpaceLength() !== 1) {
            if (parent.firstNonSpace() === core) {
              return ["prefix", "infix", "postfix"];
            }
            if (parent.lastNonSpace() === core) {
              return ["postfix", "infix", "prefix"];
            }
          }
          return ["infix", "prefix", "postfix"];
        };
        MmlMo2.prototype.handleExplicitForm = function(forms) {
          if (this.attributes.isSet("form")) {
            var form_1 = this.attributes.get("form");
            forms = [form_1].concat(forms.filter(function(name) {
              return name !== form_1;
            }));
          }
          return forms;
        };
        MmlMo2.prototype.checkPseudoScripts = function(mo) {
          var PSEUDOSCRIPTS = this.constructor.pseudoScripts;
          if (!mo.match(PSEUDOSCRIPTS))
            return;
          var parent = this.coreParent().Parent;
          var isPseudo = !parent || !(parent.isKind("msubsup") && !parent.isKind("msub"));
          this.setProperty("pseudoscript", isPseudo);
          if (isPseudo) {
            this.attributes.setInherited("lspace", 0);
            this.attributes.setInherited("rspace", 0);
          }
        };
        MmlMo2.prototype.checkPrimes = function(mo) {
          var PRIMES = this.constructor.primes;
          if (!mo.match(PRIMES))
            return;
          var REMAP = this.constructor.remapPrimes;
          var primes = (0, string_js_1.unicodeString)((0, string_js_1.unicodeChars)(mo).map(function(c) {
            return REMAP[c];
          }));
          this.setProperty("primes", primes);
        };
        MmlMo2.prototype.checkMathAccent = function(mo) {
          var parent = this.Parent;
          if (this.getProperty("mathaccent") !== void 0 || !parent || !parent.isKind("munderover"))
            return;
          var base = parent.childNodes[0];
          if (base.isEmbellished && base.coreMO() === this)
            return;
          var MATHACCENT = this.constructor.mathaccents;
          if (mo.match(MATHACCENT)) {
            this.setProperty("mathaccent", true);
          }
        };
        MmlMo2.defaults = __assign2(__assign2({}, MmlNode_js_1.AbstractMmlTokenNode.defaults), { form: "infix", fence: false, separator: false, lspace: "thickmathspace", rspace: "thickmathspace", stretchy: false, symmetric: false, maxsize: "infinity", minsize: "0em", largeop: false, movablelimits: false, accent: false, linebreak: "auto", lineleading: "1ex", linebreakstyle: "before", indentalign: "auto", indentshift: "0", indenttarget: "", indentalignfirst: "indentalign", indentshiftfirst: "indentshift", indentalignlast: "indentalign", indentshiftlast: "indentshift" });
        MmlMo2.MMLSPACING = OperatorDictionary_js_1.MMLSPACING;
        MmlMo2.OPTABLE = OperatorDictionary_js_1.OPTABLE;
        MmlMo2.pseudoScripts = new RegExp([
          "^[\"'*`",
          "\xAA",
          "\xB0",
          "\xB2-\xB4",
          "\xB9",
          "\xBA",
          "\u2018-\u201F",
          "\u2032-\u2037\u2057",
          "\u2070\u2071",
          "\u2074-\u207F",
          "\u2080-\u208E",
          "]+$"
        ].join(""));
        MmlMo2.primes = new RegExp([
          "^[\"'`",
          "\u2018-\u201F",
          "]+$"
        ].join(""));
        MmlMo2.remapPrimes = {
          34: 8243,
          39: 8242,
          96: 8245,
          8216: 8245,
          8217: 8242,
          8218: 8242,
          8219: 8245,
          8220: 8246,
          8221: 8243,
          8222: 8243,
          8223: 8246
        };
        MmlMo2.mathaccents = new RegExp([
          "^[",
          "\xB4\u0301\u02CA",
          "`\u0300\u02CB",
          "\xA8\u0308",
          "~\u0303\u02DC",
          "\xAF\u0304\u02C9",
          "\u02D8\u0306",
          "\u02C7\u030C",
          "^\u0302\u02C6",
          "\u2192\u20D7",
          "\u02D9\u0307",
          "\u02DA\u030A",
          "\u20DB",
          "\u20DC",
          "]$"
        ].join(""));
        return MmlMo2;
      }(MmlNode_js_1.AbstractMmlTokenNode);
      exports.MmlMo = MmlMo;
    }
  });

  // node_modules/mathjax-full/js/input/tex/NodeUtil.js
  var require_NodeUtil = __commonJS({
    "node_modules/mathjax-full/js/input/tex/NodeUtil.js"(exports) {
      "use strict";
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      var __spreadArray2 = exports && exports.__spreadArray || function(to, from, pack) {
        if (pack || arguments.length === 2)
          for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
              if (!ar)
                ar = Array.prototype.slice.call(from, 0, i);
              ar[i] = from[i];
            }
          }
        return to.concat(ar || Array.prototype.slice.call(from));
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      var MmlNode_js_1 = require_MmlNode();
      var mo_js_1 = require_mo();
      var NodeUtil;
      (function(NodeUtil2) {
        var attrs = /* @__PURE__ */ new Map([
          ["autoOP", true],
          ["fnOP", true],
          ["movesupsub", true],
          ["subsupOK", true],
          ["texprimestyle", true],
          ["useHeight", true],
          ["variantForm", true],
          ["withDelims", true],
          ["mathaccent", true],
          ["open", true],
          ["close", true]
        ]);
        function createEntity(code) {
          return String.fromCodePoint(parseInt(code, 16));
        }
        NodeUtil2.createEntity = createEntity;
        function getChildren(node) {
          return node.childNodes;
        }
        NodeUtil2.getChildren = getChildren;
        function getText(node) {
          return node.getText();
        }
        NodeUtil2.getText = getText;
        function appendChildren(node, children) {
          var e_1, _a;
          try {
            for (var children_1 = __values2(children), children_1_1 = children_1.next(); !children_1_1.done; children_1_1 = children_1.next()) {
              var child = children_1_1.value;
              node.appendChild(child);
            }
          } catch (e_1_1) {
            e_1 = { error: e_1_1 };
          } finally {
            try {
              if (children_1_1 && !children_1_1.done && (_a = children_1.return))
                _a.call(children_1);
            } finally {
              if (e_1)
                throw e_1.error;
            }
          }
        }
        NodeUtil2.appendChildren = appendChildren;
        function setAttribute(node, attribute, value) {
          node.attributes.set(attribute, value);
        }
        NodeUtil2.setAttribute = setAttribute;
        function setProperty(node, property, value) {
          node.setProperty(property, value);
        }
        NodeUtil2.setProperty = setProperty;
        function setProperties(node, properties) {
          var e_2, _a;
          try {
            for (var _b = __values2(Object.keys(properties)), _c = _b.next(); !_c.done; _c = _b.next()) {
              var name_1 = _c.value;
              var value = properties[name_1];
              if (name_1 === "texClass") {
                node.texClass = value;
                node.setProperty(name_1, value);
              } else if (name_1 === "movablelimits") {
                node.setProperty("movablelimits", value);
                if (node.isKind("mo") || node.isKind("mstyle")) {
                  node.attributes.set("movablelimits", value);
                }
              } else if (name_1 === "inferred") {
              } else if (attrs.has(name_1)) {
                node.setProperty(name_1, value);
              } else {
                node.attributes.set(name_1, value);
              }
            }
          } catch (e_2_1) {
            e_2 = { error: e_2_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_2)
                throw e_2.error;
            }
          }
        }
        NodeUtil2.setProperties = setProperties;
        function getProperty(node, property) {
          return node.getProperty(property);
        }
        NodeUtil2.getProperty = getProperty;
        function getAttribute(node, attr) {
          return node.attributes.get(attr);
        }
        NodeUtil2.getAttribute = getAttribute;
        function removeProperties(node) {
          var properties = [];
          for (var _i = 1; _i < arguments.length; _i++) {
            properties[_i - 1] = arguments[_i];
          }
          node.removeProperty.apply(node, __spreadArray2([], __read2(properties), false));
        }
        NodeUtil2.removeProperties = removeProperties;
        function getChildAt(node, position) {
          return node.childNodes[position];
        }
        NodeUtil2.getChildAt = getChildAt;
        function setChild(node, position, child) {
          var children = node.childNodes;
          children[position] = child;
          if (child) {
            child.parent = node;
          }
        }
        NodeUtil2.setChild = setChild;
        function copyChildren(oldNode, newNode) {
          var children = oldNode.childNodes;
          for (var i = 0; i < children.length; i++) {
            setChild(newNode, i, children[i]);
          }
        }
        NodeUtil2.copyChildren = copyChildren;
        function copyAttributes(oldNode, newNode) {
          newNode.attributes = oldNode.attributes;
          setProperties(newNode, oldNode.getAllProperties());
        }
        NodeUtil2.copyAttributes = copyAttributes;
        function isType(node, kind) {
          return node.isKind(kind);
        }
        NodeUtil2.isType = isType;
        function isEmbellished(node) {
          return node.isEmbellished;
        }
        NodeUtil2.isEmbellished = isEmbellished;
        function getTexClass(node) {
          return node.texClass;
        }
        NodeUtil2.getTexClass = getTexClass;
        function getCoreMO(node) {
          return node.coreMO();
        }
        NodeUtil2.getCoreMO = getCoreMO;
        function isNode(item) {
          return item instanceof MmlNode_js_1.AbstractMmlNode || item instanceof MmlNode_js_1.AbstractMmlEmptyNode;
        }
        NodeUtil2.isNode = isNode;
        function isInferred(node) {
          return node.isInferred;
        }
        NodeUtil2.isInferred = isInferred;
        function getForm(node) {
          var e_3, _a;
          if (!isType(node, "mo")) {
            return null;
          }
          var mo = node;
          var forms = mo.getForms();
          try {
            for (var forms_1 = __values2(forms), forms_1_1 = forms_1.next(); !forms_1_1.done; forms_1_1 = forms_1.next()) {
              var form = forms_1_1.value;
              var symbol = mo_js_1.MmlMo.OPTABLE[form][mo.getText()];
              if (symbol) {
                return symbol;
              }
            }
          } catch (e_3_1) {
            e_3 = { error: e_3_1 };
          } finally {
            try {
              if (forms_1_1 && !forms_1_1.done && (_a = forms_1.return))
                _a.call(forms_1);
            } finally {
              if (e_3)
                throw e_3.error;
            }
          }
          return null;
        }
        NodeUtil2.getForm = getForm;
      })(NodeUtil || (NodeUtil = {}));
      exports.default = NodeUtil;
    }
  });

  // node_modules/mathjax-full/js/input/tex/FilterUtil.js
  var require_FilterUtil = __commonJS({
    "node_modules/mathjax-full/js/input/tex/FilterUtil.js"(exports) {
      "use strict";
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      var __importDefault2 = exports && exports.__importDefault || function(mod) {
        return mod && mod.__esModule ? mod : { "default": mod };
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      var MmlNode_js_1 = require_MmlNode();
      var NodeUtil_js_1 = __importDefault2(require_NodeUtil());
      var FilterUtil;
      (function(FilterUtil2) {
        FilterUtil2.cleanStretchy = function(arg) {
          var e_1, _a;
          var options = arg.data;
          try {
            for (var _b = __values2(options.getList("fixStretchy")), _c = _b.next(); !_c.done; _c = _b.next()) {
              var mo = _c.value;
              if (NodeUtil_js_1.default.getProperty(mo, "fixStretchy")) {
                var symbol = NodeUtil_js_1.default.getForm(mo);
                if (symbol && symbol[3] && symbol[3]["stretchy"]) {
                  NodeUtil_js_1.default.setAttribute(mo, "stretchy", false);
                }
                var parent_1 = mo.parent;
                if (!NodeUtil_js_1.default.getTexClass(mo) && (!symbol || !symbol[2])) {
                  var texAtom = options.nodeFactory.create("node", "TeXAtom", [mo]);
                  parent_1.replaceChild(texAtom, mo);
                  texAtom.inheritAttributesFrom(mo);
                }
                NodeUtil_js_1.default.removeProperties(mo, "fixStretchy");
              }
            }
          } catch (e_1_1) {
            e_1 = { error: e_1_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_1)
                throw e_1.error;
            }
          }
        };
        FilterUtil2.cleanAttributes = function(arg) {
          var node = arg.data.root;
          node.walkTree(function(mml, _d) {
            var e_2, _a;
            var attribs = mml.attributes;
            if (!attribs) {
              return;
            }
            var keep = new Set((attribs.get("mjx-keep-attrs") || "").split(/ /));
            delete attribs.getAllAttributes()["mjx-keep-attrs"];
            try {
              for (var _b = __values2(attribs.getExplicitNames()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var key = _c.value;
                if (!keep.has(key) && attribs.attributes[key] === mml.attributes.getInherited(key)) {
                  delete attribs.attributes[key];
                }
              }
            } catch (e_2_1) {
              e_2 = { error: e_2_1 };
            } finally {
              try {
                if (_c && !_c.done && (_a = _b.return))
                  _a.call(_b);
              } finally {
                if (e_2)
                  throw e_2.error;
              }
            }
          }, {});
        };
        FilterUtil2.combineRelations = function(arg) {
          var e_3, _a, e_4, _b;
          var remove = [];
          try {
            for (var _c = __values2(arg.data.getList("mo")), _e = _c.next(); !_e.done; _e = _c.next()) {
              var mo = _e.value;
              if (mo.getProperty("relationsCombined") || !mo.parent || mo.parent && !NodeUtil_js_1.default.isType(mo.parent, "mrow") || NodeUtil_js_1.default.getTexClass(mo) !== MmlNode_js_1.TEXCLASS.REL) {
                continue;
              }
              var mml = mo.parent;
              var m2 = void 0;
              var children = mml.childNodes;
              var next = children.indexOf(mo) + 1;
              var variantForm = NodeUtil_js_1.default.getProperty(mo, "variantForm");
              while (next < children.length && (m2 = children[next]) && NodeUtil_js_1.default.isType(m2, "mo") && NodeUtil_js_1.default.getTexClass(m2) === MmlNode_js_1.TEXCLASS.REL) {
                if (variantForm === NodeUtil_js_1.default.getProperty(m2, "variantForm") && _compareExplicit(mo, m2)) {
                  NodeUtil_js_1.default.appendChildren(mo, NodeUtil_js_1.default.getChildren(m2));
                  _copyExplicit(["stretchy", "rspace"], mo, m2);
                  try {
                    for (var _f = (e_4 = void 0, __values2(m2.getPropertyNames())), _g = _f.next(); !_g.done; _g = _f.next()) {
                      var name_1 = _g.value;
                      mo.setProperty(name_1, m2.getProperty(name_1));
                    }
                  } catch (e_4_1) {
                    e_4 = { error: e_4_1 };
                  } finally {
                    try {
                      if (_g && !_g.done && (_b = _f.return))
                        _b.call(_f);
                    } finally {
                      if (e_4)
                        throw e_4.error;
                    }
                  }
                  children.splice(next, 1);
                  remove.push(m2);
                  m2.parent = null;
                  m2.setProperty("relationsCombined", true);
                } else {
                  if (mo.attributes.getExplicit("rspace") == null) {
                    NodeUtil_js_1.default.setAttribute(mo, "rspace", "0pt");
                  }
                  if (m2.attributes.getExplicit("lspace") == null) {
                    NodeUtil_js_1.default.setAttribute(m2, "lspace", "0pt");
                  }
                  break;
                }
              }
              mo.attributes.setInherited("form", mo.getForms()[0]);
            }
          } catch (e_3_1) {
            e_3 = { error: e_3_1 };
          } finally {
            try {
              if (_e && !_e.done && (_a = _c.return))
                _a.call(_c);
            } finally {
              if (e_3)
                throw e_3.error;
            }
          }
          arg.data.removeFromList("mo", remove);
        };
        var _copyExplicit = function(attrs, node1, node2) {
          var attr1 = node1.attributes;
          var attr2 = node2.attributes;
          attrs.forEach(function(x) {
            var attr = attr2.getExplicit(x);
            if (attr != null) {
              attr1.set(x, attr);
            }
          });
        };
        var _compareExplicit = function(node1, node2) {
          var e_5, _a;
          var filter = function(attr, space) {
            var exp = attr.getExplicitNames();
            return exp.filter(function(x) {
              return x !== space && (x !== "stretchy" || attr.getExplicit("stretchy"));
            });
          };
          var attr1 = node1.attributes;
          var attr2 = node2.attributes;
          var exp1 = filter(attr1, "lspace");
          var exp2 = filter(attr2, "rspace");
          if (exp1.length !== exp2.length) {
            return false;
          }
          try {
            for (var exp1_1 = __values2(exp1), exp1_1_1 = exp1_1.next(); !exp1_1_1.done; exp1_1_1 = exp1_1.next()) {
              var name_2 = exp1_1_1.value;
              if (attr1.getExplicit(name_2) !== attr2.getExplicit(name_2)) {
                return false;
              }
            }
          } catch (e_5_1) {
            e_5 = { error: e_5_1 };
          } finally {
            try {
              if (exp1_1_1 && !exp1_1_1.done && (_a = exp1_1.return))
                _a.call(exp1_1);
            } finally {
              if (e_5)
                throw e_5.error;
            }
          }
          return true;
        };
        var _cleanSubSup = function(options, low, up) {
          var e_6, _a;
          var remove = [];
          try {
            for (var _b = __values2(options.getList("m" + low + up)), _c = _b.next(); !_c.done; _c = _b.next()) {
              var mml = _c.value;
              var children = mml.childNodes;
              if (children[mml[low]] && children[mml[up]]) {
                continue;
              }
              var parent_2 = mml.parent;
              var newNode = children[mml[low]] ? options.nodeFactory.create("node", "m" + low, [children[mml.base], children[mml[low]]]) : options.nodeFactory.create("node", "m" + up, [children[mml.base], children[mml[up]]]);
              NodeUtil_js_1.default.copyAttributes(mml, newNode);
              if (parent_2) {
                parent_2.replaceChild(newNode, mml);
              } else {
                options.root = newNode;
              }
              remove.push(mml);
            }
          } catch (e_6_1) {
            e_6 = { error: e_6_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_6)
                throw e_6.error;
            }
          }
          options.removeFromList("m" + low + up, remove);
        };
        FilterUtil2.cleanSubSup = function(arg) {
          var options = arg.data;
          if (options.error) {
            return;
          }
          _cleanSubSup(options, "sub", "sup");
          _cleanSubSup(options, "under", "over");
        };
        var _moveLimits = function(options, underover, subsup) {
          var e_7, _a;
          var remove = [];
          try {
            for (var _b = __values2(options.getList(underover)), _c = _b.next(); !_c.done; _c = _b.next()) {
              var mml = _c.value;
              if (mml.attributes.get("displaystyle")) {
                continue;
              }
              var base = mml.childNodes[mml.base];
              var mo = base.coreMO();
              if (base.getProperty("movablelimits") && !mo.attributes.getExplicit("movablelimits")) {
                var node = options.nodeFactory.create("node", subsup, mml.childNodes);
                NodeUtil_js_1.default.copyAttributes(mml, node);
                if (mml.parent) {
                  mml.parent.replaceChild(node, mml);
                } else {
                  options.root = node;
                }
                remove.push(mml);
              }
            }
          } catch (e_7_1) {
            e_7 = { error: e_7_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_7)
                throw e_7.error;
            }
          }
          options.removeFromList(underover, remove);
        };
        FilterUtil2.moveLimits = function(arg) {
          var options = arg.data;
          _moveLimits(options, "munderover", "msubsup");
          _moveLimits(options, "munder", "msub");
          _moveLimits(options, "mover", "msup");
        };
        FilterUtil2.setInherited = function(arg) {
          arg.data.root.setInheritedAttributes({}, arg.math["display"], 0, false);
        };
      })(FilterUtil || (FilterUtil = {}));
      exports.default = FilterUtil;
    }
  });

  // node_modules/mathjax-full/js/input/tex/TexError.js
  var require_TexError = __commonJS({
    "node_modules/mathjax-full/js/input/tex/TexError.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      var TexError = function() {
        function TexError2(id, message) {
          var rest = [];
          for (var _i = 2; _i < arguments.length; _i++) {
            rest[_i - 2] = arguments[_i];
          }
          this.id = id;
          this.message = TexError2.processString(message, rest);
        }
        TexError2.processString = function(str, args) {
          var parts = str.split(TexError2.pattern);
          for (var i = 1, m = parts.length; i < m; i += 2) {
            var c = parts[i].charAt(0);
            if (c >= "0" && c <= "9") {
              parts[i] = args[parseInt(parts[i], 10) - 1];
              if (typeof parts[i] === "number") {
                parts[i] = parts[i].toString();
              }
            } else if (c === "{") {
              c = parts[i].substr(1);
              if (c >= "0" && c <= "9") {
                parts[i] = args[parseInt(parts[i].substr(1, parts[i].length - 2), 10) - 1];
                if (typeof parts[i] === "number") {
                  parts[i] = parts[i].toString();
                }
              } else {
                var match = parts[i].match(/^\{([a-z]+):%(\d+)\|(.*)\}$/);
                if (match) {
                  parts[i] = "%" + parts[i];
                }
              }
            }
            if (parts[i] == null) {
              parts[i] = "???";
            }
          }
          return parts.join("");
        };
        TexError2.pattern = /%(\d+|\{\d+\}|\{[a-z]+:\%\d+(?:\|(?:%\{\d+\}|%.|[^\}])*)+\}|.)/g;
        return TexError2;
      }();
      exports.default = TexError;
    }
  });

  // node_modules/mathjax-full/js/util/AsyncLoad.js
  var require_AsyncLoad = __commonJS({
    "node_modules/mathjax-full/js/util/AsyncLoad.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.asyncLoad = void 0;
      var mathjax_js_1 = require_mathjax();
      function asyncLoad(name) {
        if (!mathjax_js_1.mathjax.asyncLoad) {
          return Promise.reject("Can't load '".concat(name, "': No asyncLoad method specified"));
        }
        return new Promise(function(ok, fail) {
          var result = mathjax_js_1.mathjax.asyncLoad(name);
          if (result instanceof Promise) {
            result.then(function(value) {
              return ok(value);
            }).catch(function(err) {
              return fail(err);
            });
          } else {
            ok(result);
          }
        });
      }
      exports.asyncLoad = asyncLoad;
    }
  });

  // node_modules/mathjax-full/js/util/Entities.js
  var require_Entities = __commonJS({
    "node_modules/mathjax-full/js/util/Entities.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.numeric = exports.translate = exports.remove = exports.add = exports.entities = exports.options = void 0;
      var Retries_js_1 = require_Retries();
      var AsyncLoad_js_1 = require_AsyncLoad();
      exports.options = {
        loadMissingEntities: true
      };
      exports.entities = {
        ApplyFunction: "\u2061",
        Backslash: "\u2216",
        Because: "\u2235",
        Breve: "\u02D8",
        Cap: "\u22D2",
        CenterDot: "\xB7",
        CircleDot: "\u2299",
        CircleMinus: "\u2296",
        CirclePlus: "\u2295",
        CircleTimes: "\u2297",
        Congruent: "\u2261",
        ContourIntegral: "\u222E",
        Coproduct: "\u2210",
        Cross: "\u2A2F",
        Cup: "\u22D3",
        CupCap: "\u224D",
        Dagger: "\u2021",
        Del: "\u2207",
        Delta: "\u0394",
        Diamond: "\u22C4",
        DifferentialD: "\u2146",
        DotEqual: "\u2250",
        DoubleDot: "\xA8",
        DoubleRightTee: "\u22A8",
        DoubleVerticalBar: "\u2225",
        DownArrow: "\u2193",
        DownLeftVector: "\u21BD",
        DownRightVector: "\u21C1",
        DownTee: "\u22A4",
        Downarrow: "\u21D3",
        Element: "\u2208",
        EqualTilde: "\u2242",
        Equilibrium: "\u21CC",
        Exists: "\u2203",
        ExponentialE: "\u2147",
        FilledVerySmallSquare: "\u25AA",
        ForAll: "\u2200",
        Gamma: "\u0393",
        Gg: "\u22D9",
        GreaterEqual: "\u2265",
        GreaterEqualLess: "\u22DB",
        GreaterFullEqual: "\u2267",
        GreaterLess: "\u2277",
        GreaterSlantEqual: "\u2A7E",
        GreaterTilde: "\u2273",
        Hacek: "\u02C7",
        Hat: "^",
        HumpDownHump: "\u224E",
        HumpEqual: "\u224F",
        Im: "\u2111",
        ImaginaryI: "\u2148",
        Integral: "\u222B",
        Intersection: "\u22C2",
        InvisibleComma: "\u2063",
        InvisibleTimes: "\u2062",
        Lambda: "\u039B",
        Larr: "\u219E",
        LeftAngleBracket: "\u27E8",
        LeftArrow: "\u2190",
        LeftArrowRightArrow: "\u21C6",
        LeftCeiling: "\u2308",
        LeftDownVector: "\u21C3",
        LeftFloor: "\u230A",
        LeftRightArrow: "\u2194",
        LeftTee: "\u22A3",
        LeftTriangle: "\u22B2",
        LeftTriangleEqual: "\u22B4",
        LeftUpVector: "\u21BF",
        LeftVector: "\u21BC",
        Leftarrow: "\u21D0",
        Leftrightarrow: "\u21D4",
        LessEqualGreater: "\u22DA",
        LessFullEqual: "\u2266",
        LessGreater: "\u2276",
        LessSlantEqual: "\u2A7D",
        LessTilde: "\u2272",
        Ll: "\u22D8",
        Lleftarrow: "\u21DA",
        LongLeftArrow: "\u27F5",
        LongLeftRightArrow: "\u27F7",
        LongRightArrow: "\u27F6",
        Longleftarrow: "\u27F8",
        Longleftrightarrow: "\u27FA",
        Longrightarrow: "\u27F9",
        Lsh: "\u21B0",
        MinusPlus: "\u2213",
        NestedGreaterGreater: "\u226B",
        NestedLessLess: "\u226A",
        NotDoubleVerticalBar: "\u2226",
        NotElement: "\u2209",
        NotEqual: "\u2260",
        NotExists: "\u2204",
        NotGreater: "\u226F",
        NotGreaterEqual: "\u2271",
        NotLeftTriangle: "\u22EA",
        NotLeftTriangleEqual: "\u22EC",
        NotLess: "\u226E",
        NotLessEqual: "\u2270",
        NotPrecedes: "\u2280",
        NotPrecedesSlantEqual: "\u22E0",
        NotRightTriangle: "\u22EB",
        NotRightTriangleEqual: "\u22ED",
        NotSubsetEqual: "\u2288",
        NotSucceeds: "\u2281",
        NotSucceedsSlantEqual: "\u22E1",
        NotSupersetEqual: "\u2289",
        NotTilde: "\u2241",
        NotVerticalBar: "\u2224",
        Omega: "\u03A9",
        OverBar: "\u203E",
        OverBrace: "\u23DE",
        PartialD: "\u2202",
        Phi: "\u03A6",
        Pi: "\u03A0",
        PlusMinus: "\xB1",
        Precedes: "\u227A",
        PrecedesEqual: "\u2AAF",
        PrecedesSlantEqual: "\u227C",
        PrecedesTilde: "\u227E",
        Product: "\u220F",
        Proportional: "\u221D",
        Psi: "\u03A8",
        Rarr: "\u21A0",
        Re: "\u211C",
        ReverseEquilibrium: "\u21CB",
        RightAngleBracket: "\u27E9",
        RightArrow: "\u2192",
        RightArrowLeftArrow: "\u21C4",
        RightCeiling: "\u2309",
        RightDownVector: "\u21C2",
        RightFloor: "\u230B",
        RightTee: "\u22A2",
        RightTeeArrow: "\u21A6",
        RightTriangle: "\u22B3",
        RightTriangleEqual: "\u22B5",
        RightUpVector: "\u21BE",
        RightVector: "\u21C0",
        Rightarrow: "\u21D2",
        Rrightarrow: "\u21DB",
        Rsh: "\u21B1",
        Sigma: "\u03A3",
        SmallCircle: "\u2218",
        Sqrt: "\u221A",
        Square: "\u25A1",
        SquareIntersection: "\u2293",
        SquareSubset: "\u228F",
        SquareSubsetEqual: "\u2291",
        SquareSuperset: "\u2290",
        SquareSupersetEqual: "\u2292",
        SquareUnion: "\u2294",
        Star: "\u22C6",
        Subset: "\u22D0",
        SubsetEqual: "\u2286",
        Succeeds: "\u227B",
        SucceedsEqual: "\u2AB0",
        SucceedsSlantEqual: "\u227D",
        SucceedsTilde: "\u227F",
        SuchThat: "\u220B",
        Sum: "\u2211",
        Superset: "\u2283",
        SupersetEqual: "\u2287",
        Supset: "\u22D1",
        Therefore: "\u2234",
        Theta: "\u0398",
        Tilde: "\u223C",
        TildeEqual: "\u2243",
        TildeFullEqual: "\u2245",
        TildeTilde: "\u2248",
        UnderBar: "_",
        UnderBrace: "\u23DF",
        Union: "\u22C3",
        UnionPlus: "\u228E",
        UpArrow: "\u2191",
        UpDownArrow: "\u2195",
        UpTee: "\u22A5",
        Uparrow: "\u21D1",
        Updownarrow: "\u21D5",
        Upsilon: "\u03A5",
        Vdash: "\u22A9",
        Vee: "\u22C1",
        VerticalBar: "\u2223",
        VerticalTilde: "\u2240",
        Vvdash: "\u22AA",
        Wedge: "\u22C0",
        Xi: "\u039E",
        amp: "&",
        acute: "\xB4",
        aleph: "\u2135",
        alpha: "\u03B1",
        amalg: "\u2A3F",
        and: "\u2227",
        ang: "\u2220",
        angmsd: "\u2221",
        angsph: "\u2222",
        ape: "\u224A",
        backprime: "\u2035",
        backsim: "\u223D",
        backsimeq: "\u22CD",
        beta: "\u03B2",
        beth: "\u2136",
        between: "\u226C",
        bigcirc: "\u25EF",
        bigodot: "\u2A00",
        bigoplus: "\u2A01",
        bigotimes: "\u2A02",
        bigsqcup: "\u2A06",
        bigstar: "\u2605",
        bigtriangledown: "\u25BD",
        bigtriangleup: "\u25B3",
        biguplus: "\u2A04",
        blacklozenge: "\u29EB",
        blacktriangle: "\u25B4",
        blacktriangledown: "\u25BE",
        blacktriangleleft: "\u25C2",
        bowtie: "\u22C8",
        boxdl: "\u2510",
        boxdr: "\u250C",
        boxminus: "\u229F",
        boxplus: "\u229E",
        boxtimes: "\u22A0",
        boxul: "\u2518",
        boxur: "\u2514",
        bsol: "\\",
        bull: "\u2022",
        cap: "\u2229",
        check: "\u2713",
        chi: "\u03C7",
        circ: "\u02C6",
        circeq: "\u2257",
        circlearrowleft: "\u21BA",
        circlearrowright: "\u21BB",
        circledR: "\xAE",
        circledS: "\u24C8",
        circledast: "\u229B",
        circledcirc: "\u229A",
        circleddash: "\u229D",
        clubs: "\u2663",
        colon: ":",
        comp: "\u2201",
        ctdot: "\u22EF",
        cuepr: "\u22DE",
        cuesc: "\u22DF",
        cularr: "\u21B6",
        cup: "\u222A",
        curarr: "\u21B7",
        curlyvee: "\u22CE",
        curlywedge: "\u22CF",
        dagger: "\u2020",
        daleth: "\u2138",
        ddarr: "\u21CA",
        deg: "\xB0",
        delta: "\u03B4",
        digamma: "\u03DD",
        div: "\xF7",
        divideontimes: "\u22C7",
        dot: "\u02D9",
        doteqdot: "\u2251",
        dotplus: "\u2214",
        dotsquare: "\u22A1",
        dtdot: "\u22F1",
        ecir: "\u2256",
        efDot: "\u2252",
        egs: "\u2A96",
        ell: "\u2113",
        els: "\u2A95",
        empty: "\u2205",
        epsi: "\u03B5",
        epsiv: "\u03F5",
        erDot: "\u2253",
        eta: "\u03B7",
        eth: "\xF0",
        flat: "\u266D",
        fork: "\u22D4",
        frown: "\u2322",
        gEl: "\u2A8C",
        gamma: "\u03B3",
        gap: "\u2A86",
        gimel: "\u2137",
        gnE: "\u2269",
        gnap: "\u2A8A",
        gne: "\u2A88",
        gnsim: "\u22E7",
        gt: ">",
        gtdot: "\u22D7",
        harrw: "\u21AD",
        hbar: "\u210F",
        hellip: "\u2026",
        hookleftarrow: "\u21A9",
        hookrightarrow: "\u21AA",
        imath: "\u0131",
        infin: "\u221E",
        intcal: "\u22BA",
        iota: "\u03B9",
        jmath: "\u0237",
        kappa: "\u03BA",
        kappav: "\u03F0",
        lEg: "\u2A8B",
        lambda: "\u03BB",
        lap: "\u2A85",
        larrlp: "\u21AB",
        larrtl: "\u21A2",
        lbrace: "{",
        lbrack: "[",
        le: "\u2264",
        leftleftarrows: "\u21C7",
        leftthreetimes: "\u22CB",
        lessdot: "\u22D6",
        lmoust: "\u23B0",
        lnE: "\u2268",
        lnap: "\u2A89",
        lne: "\u2A87",
        lnsim: "\u22E6",
        longmapsto: "\u27FC",
        looparrowright: "\u21AC",
        lowast: "\u2217",
        loz: "\u25CA",
        lt: "<",
        ltimes: "\u22C9",
        ltri: "\u25C3",
        macr: "\xAF",
        malt: "\u2720",
        mho: "\u2127",
        mu: "\u03BC",
        multimap: "\u22B8",
        nLeftarrow: "\u21CD",
        nLeftrightarrow: "\u21CE",
        nRightarrow: "\u21CF",
        nVDash: "\u22AF",
        nVdash: "\u22AE",
        natur: "\u266E",
        nearr: "\u2197",
        nharr: "\u21AE",
        nlarr: "\u219A",
        not: "\xAC",
        nrarr: "\u219B",
        nu: "\u03BD",
        nvDash: "\u22AD",
        nvdash: "\u22AC",
        nwarr: "\u2196",
        omega: "\u03C9",
        omicron: "\u03BF",
        or: "\u2228",
        osol: "\u2298",
        period: ".",
        phi: "\u03C6",
        phiv: "\u03D5",
        pi: "\u03C0",
        piv: "\u03D6",
        prap: "\u2AB7",
        precnapprox: "\u2AB9",
        precneqq: "\u2AB5",
        precnsim: "\u22E8",
        prime: "\u2032",
        psi: "\u03C8",
        quot: '"',
        rarrtl: "\u21A3",
        rbrace: "}",
        rbrack: "]",
        rho: "\u03C1",
        rhov: "\u03F1",
        rightrightarrows: "\u21C9",
        rightthreetimes: "\u22CC",
        ring: "\u02DA",
        rmoust: "\u23B1",
        rtimes: "\u22CA",
        rtri: "\u25B9",
        scap: "\u2AB8",
        scnE: "\u2AB6",
        scnap: "\u2ABA",
        scnsim: "\u22E9",
        sdot: "\u22C5",
        searr: "\u2198",
        sect: "\xA7",
        sharp: "\u266F",
        sigma: "\u03C3",
        sigmav: "\u03C2",
        simne: "\u2246",
        smile: "\u2323",
        spades: "\u2660",
        sub: "\u2282",
        subE: "\u2AC5",
        subnE: "\u2ACB",
        subne: "\u228A",
        supE: "\u2AC6",
        supnE: "\u2ACC",
        supne: "\u228B",
        swarr: "\u2199",
        tau: "\u03C4",
        theta: "\u03B8",
        thetav: "\u03D1",
        tilde: "\u02DC",
        times: "\xD7",
        triangle: "\u25B5",
        triangleq: "\u225C",
        upsi: "\u03C5",
        upuparrows: "\u21C8",
        veebar: "\u22BB",
        vellip: "\u22EE",
        weierp: "\u2118",
        xi: "\u03BE",
        yen: "\xA5",
        zeta: "\u03B6",
        zigrarr: "\u21DD",
        nbsp: "\xA0",
        rsquo: "\u2019",
        lsquo: "\u2018"
      };
      var loaded = {};
      function add(additions, file) {
        Object.assign(exports.entities, additions);
        loaded[file] = true;
      }
      exports.add = add;
      function remove(entity) {
        delete exports.entities[entity];
      }
      exports.remove = remove;
      function translate(text) {
        return text.replace(/&([a-z][a-z0-9]*|#(?:[0-9]+|x[0-9a-f]+));/ig, replace);
      }
      exports.translate = translate;
      function replace(match, entity) {
        if (entity.charAt(0) === "#") {
          return numeric(entity.slice(1));
        }
        if (exports.entities[entity]) {
          return exports.entities[entity];
        }
        if (exports.options["loadMissingEntities"]) {
          var file = entity.match(/^[a-zA-Z](fr|scr|opf)$/) ? RegExp.$1 : entity.charAt(0).toLowerCase();
          if (!loaded[file]) {
            loaded[file] = true;
            (0, Retries_js_1.retryAfter)((0, AsyncLoad_js_1.asyncLoad)("./util/entities/" + file + ".js"));
          }
        }
        return match;
      }
      function numeric(entity) {
        var n = entity.charAt(0) === "x" ? parseInt(entity.slice(1), 16) : parseInt(entity);
        return String.fromCodePoint(n);
      }
      exports.numeric = numeric;
    }
  });

  // node_modules/mathjax-full/js/input/tex/ParseUtil.js
  var require_ParseUtil = __commonJS({
    "node_modules/mathjax-full/js/input/tex/ParseUtil.js"(exports) {
      "use strict";
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      var __importDefault2 = exports && exports.__importDefault || function(mod) {
        return mod && mod.__esModule ? mod : { "default": mod };
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      var MmlNode_js_1 = require_MmlNode();
      var NodeUtil_js_1 = __importDefault2(require_NodeUtil());
      var TexParser_js_1 = __importDefault2(require_TexParser());
      var TexError_js_1 = __importDefault2(require_TexError());
      var Entities_js_1 = require_Entities();
      var ParseUtil;
      (function(ParseUtil2) {
        var emPerInch = 7.2;
        var pxPerInch = 72;
        var UNIT_CASES = {
          "em": function(m) {
            return m;
          },
          "ex": function(m) {
            return m * 0.43;
          },
          "pt": function(m) {
            return m / 10;
          },
          "pc": function(m) {
            return m * 1.2;
          },
          "px": function(m) {
            return m * emPerInch / pxPerInch;
          },
          "in": function(m) {
            return m * emPerInch;
          },
          "cm": function(m) {
            return m * emPerInch / 2.54;
          },
          "mm": function(m) {
            return m * emPerInch / 25.4;
          },
          "mu": function(m) {
            return m / 18;
          }
        };
        var num = "([-+]?([.,]\\d+|\\d+([.,]\\d*)?))";
        var unit = "(pt|em|ex|mu|px|mm|cm|in|pc)";
        var dimenEnd = RegExp("^\\s*" + num + "\\s*" + unit + "\\s*$");
        var dimenRest = RegExp("^\\s*" + num + "\\s*" + unit + " ?");
        function matchDimen(dim, rest) {
          if (rest === void 0) {
            rest = false;
          }
          var match = dim.match(rest ? dimenRest : dimenEnd);
          return match ? muReplace([match[1].replace(/,/, "."), match[4], match[0].length]) : [null, null, 0];
        }
        ParseUtil2.matchDimen = matchDimen;
        function muReplace(_a) {
          var _b = __read2(_a, 3), value = _b[0], unit2 = _b[1], length = _b[2];
          if (unit2 !== "mu") {
            return [value, unit2, length];
          }
          var em = Em(UNIT_CASES[unit2](parseFloat(value || "1")));
          return [em.slice(0, -2), "em", length];
        }
        function dimen2em(dim) {
          var _a = __read2(matchDimen(dim), 2), value = _a[0], unit2 = _a[1];
          var m = parseFloat(value || "1");
          var func = UNIT_CASES[unit2];
          return func ? func(m) : 0;
        }
        ParseUtil2.dimen2em = dimen2em;
        function Em(m) {
          if (Math.abs(m) < 6e-4) {
            return "0em";
          }
          return m.toFixed(3).replace(/\.?0+$/, "") + "em";
        }
        ParseUtil2.Em = Em;
        function cols() {
          var W = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            W[_i] = arguments[_i];
          }
          return W.map(function(n) {
            return Em(n);
          }).join(" ");
        }
        ParseUtil2.cols = cols;
        function fenced(configuration, open, mml, close, big, color) {
          if (big === void 0) {
            big = "";
          }
          if (color === void 0) {
            color = "";
          }
          var nf = configuration.nodeFactory;
          var mrow = nf.create("node", "mrow", [], { open, close, texClass: MmlNode_js_1.TEXCLASS.INNER });
          var mo;
          if (big) {
            mo = new TexParser_js_1.default("\\" + big + "l" + open, configuration.parser.stack.env, configuration).mml();
          } else {
            var openNode = nf.create("text", open);
            mo = nf.create("node", "mo", [], { fence: true, stretchy: true, symmetric: true, texClass: MmlNode_js_1.TEXCLASS.OPEN }, openNode);
          }
          NodeUtil_js_1.default.appendChildren(mrow, [mo, mml]);
          if (big) {
            mo = new TexParser_js_1.default("\\" + big + "r" + close, configuration.parser.stack.env, configuration).mml();
          } else {
            var closeNode = nf.create("text", close);
            mo = nf.create("node", "mo", [], { fence: true, stretchy: true, symmetric: true, texClass: MmlNode_js_1.TEXCLASS.CLOSE }, closeNode);
          }
          color && mo.attributes.set("mathcolor", color);
          NodeUtil_js_1.default.appendChildren(mrow, [mo]);
          return mrow;
        }
        ParseUtil2.fenced = fenced;
        function fixedFence(configuration, open, mml, close) {
          var mrow = configuration.nodeFactory.create("node", "mrow", [], { open, close, texClass: MmlNode_js_1.TEXCLASS.ORD });
          if (open) {
            NodeUtil_js_1.default.appendChildren(mrow, [mathPalette(configuration, open, "l")]);
          }
          if (NodeUtil_js_1.default.isType(mml, "mrow")) {
            NodeUtil_js_1.default.appendChildren(mrow, NodeUtil_js_1.default.getChildren(mml));
          } else {
            NodeUtil_js_1.default.appendChildren(mrow, [mml]);
          }
          if (close) {
            NodeUtil_js_1.default.appendChildren(mrow, [mathPalette(configuration, close, "r")]);
          }
          return mrow;
        }
        ParseUtil2.fixedFence = fixedFence;
        function mathPalette(configuration, fence, side) {
          if (fence === "{" || fence === "}") {
            fence = "\\" + fence;
          }
          var D = "{\\bigg" + side + " " + fence + "}";
          var T = "{\\big" + side + " " + fence + "}";
          return new TexParser_js_1.default("\\mathchoice" + D + T + T + T, {}, configuration).mml();
        }
        ParseUtil2.mathPalette = mathPalette;
        function fixInitialMO(configuration, nodes) {
          for (var i = 0, m = nodes.length; i < m; i++) {
            var child = nodes[i];
            if (child && (!NodeUtil_js_1.default.isType(child, "mspace") && (!NodeUtil_js_1.default.isType(child, "TeXAtom") || NodeUtil_js_1.default.getChildren(child)[0] && NodeUtil_js_1.default.getChildren(NodeUtil_js_1.default.getChildren(child)[0]).length))) {
              if (NodeUtil_js_1.default.isEmbellished(child) || NodeUtil_js_1.default.isType(child, "TeXAtom") && NodeUtil_js_1.default.getTexClass(child) === MmlNode_js_1.TEXCLASS.REL) {
                var mi = configuration.nodeFactory.create("node", "mi");
                nodes.unshift(mi);
              }
              break;
            }
          }
        }
        ParseUtil2.fixInitialMO = fixInitialMO;
        function internalMath(parser, text, level, font) {
          if (parser.configuration.options.internalMath) {
            return parser.configuration.options.internalMath(parser, text, level, font);
          }
          var mathvariant = font || parser.stack.env.font;
          var def = mathvariant ? { mathvariant } : {};
          var mml = [], i = 0, k = 0, c, node, match = "", braces = 0;
          if (text.match(/\\?[${}\\]|\\\(|\\(eq)?ref\s*\{/)) {
            while (i < text.length) {
              c = text.charAt(i++);
              if (c === "$") {
                if (match === "$" && braces === 0) {
                  node = parser.create("node", "TeXAtom", [new TexParser_js_1.default(text.slice(k, i - 1), {}, parser.configuration).mml()]);
                  mml.push(node);
                  match = "";
                  k = i;
                } else if (match === "") {
                  if (k < i - 1) {
                    mml.push(internalText(parser, text.slice(k, i - 1), def));
                  }
                  match = "$";
                  k = i;
                }
              } else if (c === "{" && match !== "") {
                braces++;
              } else if (c === "}") {
                if (match === "}" && braces === 0) {
                  var atom = new TexParser_js_1.default(text.slice(k, i), {}, parser.configuration).mml();
                  node = parser.create("node", "TeXAtom", [atom], def);
                  mml.push(node);
                  match = "";
                  k = i;
                } else if (match !== "") {
                  if (braces) {
                    braces--;
                  }
                }
              } else if (c === "\\") {
                if (match === "" && text.substr(i).match(/^(eq)?ref\s*\{/)) {
                  var len = RegExp["$&"].length;
                  if (k < i - 1) {
                    mml.push(internalText(parser, text.slice(k, i - 1), def));
                  }
                  match = "}";
                  k = i - 1;
                  i += len;
                } else {
                  c = text.charAt(i++);
                  if (c === "(" && match === "") {
                    if (k < i - 2) {
                      mml.push(internalText(parser, text.slice(k, i - 2), def));
                    }
                    match = ")";
                    k = i;
                  } else if (c === ")" && match === ")" && braces === 0) {
                    node = parser.create("node", "TeXAtom", [new TexParser_js_1.default(text.slice(k, i - 2), {}, parser.configuration).mml()]);
                    mml.push(node);
                    match = "";
                    k = i;
                  } else if (c.match(/[${}\\]/) && match === "") {
                    i--;
                    text = text.substr(0, i - 1) + text.substr(i);
                  }
                }
              }
            }
            if (match !== "") {
              throw new TexError_js_1.default("MathNotTerminated", "Math not terminated in text box");
            }
          }
          if (k < text.length) {
            mml.push(internalText(parser, text.slice(k), def));
          }
          if (level != null) {
            mml = [parser.create("node", "mstyle", mml, { displaystyle: false, scriptlevel: level })];
          } else if (mml.length > 1) {
            mml = [parser.create("node", "mrow", mml)];
          }
          return mml;
        }
        ParseUtil2.internalMath = internalMath;
        function internalText(parser, text, def) {
          text = text.replace(/^\s+/, Entities_js_1.entities.nbsp).replace(/\s+$/, Entities_js_1.entities.nbsp);
          var textNode = parser.create("text", text);
          return parser.create("node", "mtext", [], def, textNode);
        }
        ParseUtil2.internalText = internalText;
        function underOver(parser, base, script, pos, stack) {
          ParseUtil2.checkMovableLimits(base);
          if (NodeUtil_js_1.default.isType(base, "munderover") && NodeUtil_js_1.default.isEmbellished(base)) {
            NodeUtil_js_1.default.setProperties(NodeUtil_js_1.default.getCoreMO(base), { lspace: 0, rspace: 0 });
            var mo = parser.create("node", "mo", [], { rspace: 0 });
            base = parser.create("node", "mrow", [mo, base]);
          }
          var mml = parser.create("node", "munderover", [base]);
          NodeUtil_js_1.default.setChild(mml, pos === "over" ? mml.over : mml.under, script);
          var node = mml;
          if (stack) {
            node = parser.create("node", "TeXAtom", [mml], { texClass: MmlNode_js_1.TEXCLASS.OP, movesupsub: true });
          }
          NodeUtil_js_1.default.setProperty(node, "subsupOK", true);
          return node;
        }
        ParseUtil2.underOver = underOver;
        function checkMovableLimits(base) {
          var symbol = NodeUtil_js_1.default.isType(base, "mo") ? NodeUtil_js_1.default.getForm(base) : null;
          if (NodeUtil_js_1.default.getProperty(base, "movablelimits") || symbol && symbol[3] && symbol[3].movablelimits) {
            NodeUtil_js_1.default.setProperties(base, { movablelimits: false });
          }
        }
        ParseUtil2.checkMovableLimits = checkMovableLimits;
        function trimSpaces(text) {
          if (typeof text !== "string") {
            return text;
          }
          var TEXT = text.trim();
          if (TEXT.match(/\\$/) && text.match(/ $/)) {
            TEXT += " ";
          }
          return TEXT;
        }
        ParseUtil2.trimSpaces = trimSpaces;
        function setArrayAlign(array, align) {
          align = ParseUtil2.trimSpaces(align || "");
          if (align === "t") {
            array.arraydef.align = "baseline 1";
          } else if (align === "b") {
            array.arraydef.align = "baseline -1";
          } else if (align === "c") {
            array.arraydef.align = "axis";
          } else if (align) {
            array.arraydef.align = align;
          }
          return array;
        }
        ParseUtil2.setArrayAlign = setArrayAlign;
        function substituteArgs(parser, args, str) {
          var text = "";
          var newstring = "";
          var i = 0;
          while (i < str.length) {
            var c = str.charAt(i++);
            if (c === "\\") {
              text += c + str.charAt(i++);
            } else if (c === "#") {
              c = str.charAt(i++);
              if (c === "#") {
                text += c;
              } else {
                if (!c.match(/[1-9]/) || parseInt(c, 10) > args.length) {
                  throw new TexError_js_1.default("IllegalMacroParam", "Illegal macro parameter reference");
                }
                newstring = addArgs(parser, addArgs(parser, newstring, text), args[parseInt(c, 10) - 1]);
                text = "";
              }
            } else {
              text += c;
            }
          }
          return addArgs(parser, newstring, text);
        }
        ParseUtil2.substituteArgs = substituteArgs;
        function addArgs(parser, s1, s2) {
          if (s2.match(/^[a-z]/i) && s1.match(/(^|[^\\])(\\\\)*\\[a-z]+$/i)) {
            s1 += " ";
          }
          if (s1.length + s2.length > parser.configuration.options["maxBuffer"]) {
            throw new TexError_js_1.default("MaxBufferSize", "MathJax internal buffer size exceeded; is there a recursive macro call?");
          }
          return s1 + s2;
        }
        ParseUtil2.addArgs = addArgs;
        function checkMaxMacros(parser, isMacro) {
          if (isMacro === void 0) {
            isMacro = true;
          }
          if (++parser.macroCount <= parser.configuration.options["maxMacros"]) {
            return;
          }
          if (isMacro) {
            throw new TexError_js_1.default("MaxMacroSub1", "MathJax maximum macro substitution count exceeded; is here a recursive macro call?");
          } else {
            throw new TexError_js_1.default("MaxMacroSub2", "MathJax maximum substitution count exceeded; is there a recursive latex environment?");
          }
        }
        ParseUtil2.checkMaxMacros = checkMaxMacros;
        function checkEqnEnv(parser) {
          if (parser.stack.global.eqnenv) {
            throw new TexError_js_1.default("ErroneousNestingEq", "Erroneous nesting of equation structures");
          }
          parser.stack.global.eqnenv = true;
        }
        ParseUtil2.checkEqnEnv = checkEqnEnv;
        function copyNode(node, parser) {
          var tree = node.copy();
          var options = parser.configuration;
          tree.walkTree(function(n) {
            var e_1, _a;
            options.addNode(n.kind, n);
            var lists = (n.getProperty("in-lists") || "").split(/,/);
            try {
              for (var lists_1 = __values2(lists), lists_1_1 = lists_1.next(); !lists_1_1.done; lists_1_1 = lists_1.next()) {
                var list = lists_1_1.value;
                list && options.addNode(list, n);
              }
            } catch (e_1_1) {
              e_1 = { error: e_1_1 };
            } finally {
              try {
                if (lists_1_1 && !lists_1_1.done && (_a = lists_1.return))
                  _a.call(lists_1);
              } finally {
                if (e_1)
                  throw e_1.error;
              }
            }
          });
          return tree;
        }
        ParseUtil2.copyNode = copyNode;
        function MmlFilterAttribute(_parser, _name, value) {
          return value;
        }
        ParseUtil2.MmlFilterAttribute = MmlFilterAttribute;
        function getFontDef(parser) {
          var font = parser.stack.env["font"];
          return font ? { mathvariant: font } : {};
        }
        ParseUtil2.getFontDef = getFontDef;
        function keyvalOptions(attrib, allowed, error) {
          var e_2, _a;
          if (allowed === void 0) {
            allowed = null;
          }
          if (error === void 0) {
            error = false;
          }
          var def = readKeyval(attrib);
          if (allowed) {
            try {
              for (var _b = __values2(Object.keys(def)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var key = _c.value;
                if (!allowed.hasOwnProperty(key)) {
                  if (error) {
                    throw new TexError_js_1.default("InvalidOption", "Invalid option: %1", key);
                  }
                  delete def[key];
                }
              }
            } catch (e_2_1) {
              e_2 = { error: e_2_1 };
            } finally {
              try {
                if (_c && !_c.done && (_a = _b.return))
                  _a.call(_b);
              } finally {
                if (e_2)
                  throw e_2.error;
              }
            }
          }
          return def;
        }
        ParseUtil2.keyvalOptions = keyvalOptions;
        function readKeyval(text) {
          var _a, _b;
          var options = {};
          var rest = text;
          var end, key, val;
          while (rest) {
            _a = __read2(readValue(rest, ["=", ","]), 3), key = _a[0], end = _a[1], rest = _a[2];
            if (end === "=") {
              _b = __read2(readValue(rest, [","]), 3), val = _b[0], end = _b[1], rest = _b[2];
              val = val === "false" || val === "true" ? JSON.parse(val) : val;
              options[key] = val;
            } else if (key) {
              options[key] = true;
            }
          }
          return options;
        }
        function removeBraces(text, count) {
          while (count > 0) {
            text = text.trim().slice(1, -1);
            count--;
          }
          return text.trim();
        }
        function readValue(text, end) {
          var length = text.length;
          var braces = 0;
          var value = "";
          var index = 0;
          var start = 0;
          var startCount = true;
          var stopCount = false;
          while (index < length) {
            var c = text[index++];
            switch (c) {
              case " ":
                break;
              case "{":
                if (startCount) {
                  start++;
                } else {
                  stopCount = false;
                  if (start > braces) {
                    start = braces;
                  }
                }
                braces++;
                break;
              case "}":
                if (braces) {
                  braces--;
                }
                if (startCount || stopCount) {
                  start--;
                  stopCount = true;
                }
                startCount = false;
                break;
              default:
                if (!braces && end.indexOf(c) !== -1) {
                  return [stopCount ? "true" : removeBraces(value, start), c, text.slice(index)];
                }
                startCount = false;
                stopCount = false;
            }
            value += c;
          }
          if (braces) {
            throw new TexError_js_1.default("ExtraOpenMissingClose", "Extra open brace or missing close brace");
          }
          return [stopCount ? "true" : removeBraces(value, start), "", text.slice(index)];
        }
      })(ParseUtil || (ParseUtil = {}));
      exports.default = ParseUtil;
    }
  });

  // node_modules/mathjax-full/js/input/tex/Stack.js
  var require_Stack = __commonJS({
    "node_modules/mathjax-full/js/input/tex/Stack.js"(exports) {
      "use strict";
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      var __spreadArray2 = exports && exports.__spreadArray || function(to, from, pack) {
        if (pack || arguments.length === 2)
          for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
              if (!ar)
                ar = Array.prototype.slice.call(from, 0, i);
              ar[i] = from[i];
            }
          }
        return to.concat(ar || Array.prototype.slice.call(from));
      };
      var __importDefault2 = exports && exports.__importDefault || function(mod) {
        return mod && mod.__esModule ? mod : { "default": mod };
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      var NodeUtil_js_1 = __importDefault2(require_NodeUtil());
      var Stack = function() {
        function Stack2(_factory, _env, inner) {
          this._factory = _factory;
          this._env = _env;
          this.global = {};
          this.stack = [];
          this.global = { isInner: inner };
          this.stack = [this._factory.create("start", this.global)];
          if (_env) {
            this.stack[0].env = _env;
          }
          this.env = this.stack[0].env;
        }
        Object.defineProperty(Stack2.prototype, "env", {
          get: function() {
            return this._env;
          },
          set: function(env) {
            this._env = env;
          },
          enumerable: false,
          configurable: true
        });
        Stack2.prototype.Push = function() {
          var e_1, _a;
          var args = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
          }
          try {
            for (var args_1 = __values2(args), args_1_1 = args_1.next(); !args_1_1.done; args_1_1 = args_1.next()) {
              var node = args_1_1.value;
              if (!node) {
                continue;
              }
              var item = NodeUtil_js_1.default.isNode(node) ? this._factory.create("mml", node) : node;
              item.global = this.global;
              var _b = __read2(this.stack.length ? this.Top().checkItem(item) : [null, true], 2), top_1 = _b[0], success = _b[1];
              if (!success) {
                continue;
              }
              if (top_1) {
                this.Pop();
                this.Push.apply(this, __spreadArray2([], __read2(top_1), false));
                continue;
              }
              this.stack.push(item);
              if (item.env) {
                if (item.copyEnv) {
                  Object.assign(item.env, this.env);
                }
                this.env = item.env;
              } else {
                item.env = this.env;
              }
            }
          } catch (e_1_1) {
            e_1 = { error: e_1_1 };
          } finally {
            try {
              if (args_1_1 && !args_1_1.done && (_a = args_1.return))
                _a.call(args_1);
            } finally {
              if (e_1)
                throw e_1.error;
            }
          }
        };
        Stack2.prototype.Pop = function() {
          var item = this.stack.pop();
          if (!item.isOpen) {
            delete item.env;
          }
          this.env = this.stack.length ? this.Top().env : {};
          return item;
        };
        Stack2.prototype.Top = function(n) {
          if (n === void 0) {
            n = 1;
          }
          return this.stack.length < n ? null : this.stack[this.stack.length - n];
        };
        Stack2.prototype.Prev = function(noPop) {
          var top = this.Top();
          return noPop ? top.First : top.Pop();
        };
        Stack2.prototype.toString = function() {
          return "stack[\n  " + this.stack.join("\n  ") + "\n]";
        };
        return Stack2;
      }();
      exports.default = Stack;
    }
  });

  // node_modules/mathjax-full/js/input/tex/TexParser.js
  var require_TexParser = __commonJS({
    "node_modules/mathjax-full/js/input/tex/TexParser.js"(exports) {
      "use strict";
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      var __spreadArray2 = exports && exports.__spreadArray || function(to, from, pack) {
        if (pack || arguments.length === 2)
          for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
              if (!ar)
                ar = Array.prototype.slice.call(from, 0, i);
              ar[i] = from[i];
            }
          }
        return to.concat(ar || Array.prototype.slice.call(from));
      };
      var __importDefault2 = exports && exports.__importDefault || function(mod) {
        return mod && mod.__esModule ? mod : { "default": mod };
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      var ParseUtil_js_1 = __importDefault2(require_ParseUtil());
      var Stack_js_1 = __importDefault2(require_Stack());
      var TexError_js_1 = __importDefault2(require_TexError());
      var MmlNode_js_1 = require_MmlNode();
      var TexParser = function() {
        function TexParser2(_string, env, configuration) {
          var e_1, _a;
          this._string = _string;
          this.configuration = configuration;
          this.macroCount = 0;
          this.i = 0;
          this.currentCS = "";
          var inner = env.hasOwnProperty("isInner");
          var isInner = env["isInner"];
          delete env["isInner"];
          var ENV;
          if (env) {
            ENV = {};
            try {
              for (var _b = __values2(Object.keys(env)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var id = _c.value;
                ENV[id] = env[id];
              }
            } catch (e_1_1) {
              e_1 = { error: e_1_1 };
            } finally {
              try {
                if (_c && !_c.done && (_a = _b.return))
                  _a.call(_b);
              } finally {
                if (e_1)
                  throw e_1.error;
              }
            }
          }
          this.configuration.pushParser(this);
          this.stack = new Stack_js_1.default(this.itemFactory, ENV, inner ? isInner : true);
          this.Parse();
          this.Push(this.itemFactory.create("stop"));
        }
        Object.defineProperty(TexParser2.prototype, "options", {
          get: function() {
            return this.configuration.options;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(TexParser2.prototype, "itemFactory", {
          get: function() {
            return this.configuration.itemFactory;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(TexParser2.prototype, "tags", {
          get: function() {
            return this.configuration.tags;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(TexParser2.prototype, "string", {
          get: function() {
            return this._string;
          },
          set: function(str) {
            this._string = str;
          },
          enumerable: false,
          configurable: true
        });
        TexParser2.prototype.parse = function(kind, input) {
          return this.configuration.handlers.get(kind).parse(input);
        };
        TexParser2.prototype.lookup = function(kind, symbol) {
          return this.configuration.handlers.get(kind).lookup(symbol);
        };
        TexParser2.prototype.contains = function(kind, symbol) {
          return this.configuration.handlers.get(kind).contains(symbol);
        };
        TexParser2.prototype.toString = function() {
          var e_2, _a;
          var str = "";
          try {
            for (var _b = __values2(Array.from(this.configuration.handlers.keys())), _c = _b.next(); !_c.done; _c = _b.next()) {
              var config2 = _c.value;
              str += config2 + ": " + this.configuration.handlers.get(config2) + "\n";
            }
          } catch (e_2_1) {
            e_2 = { error: e_2_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_2)
                throw e_2.error;
            }
          }
          return str;
        };
        TexParser2.prototype.Parse = function() {
          var c;
          while (this.i < this.string.length) {
            c = this.getCodePoint();
            this.i += c.length;
            this.parse("character", [this, c]);
          }
        };
        TexParser2.prototype.Push = function(arg) {
          if (arg instanceof MmlNode_js_1.AbstractMmlNode && arg.isInferred) {
            this.PushAll(arg.childNodes);
          } else {
            this.stack.Push(arg);
          }
        };
        TexParser2.prototype.PushAll = function(args) {
          var e_3, _a;
          try {
            for (var args_1 = __values2(args), args_1_1 = args_1.next(); !args_1_1.done; args_1_1 = args_1.next()) {
              var arg = args_1_1.value;
              this.stack.Push(arg);
            }
          } catch (e_3_1) {
            e_3 = { error: e_3_1 };
          } finally {
            try {
              if (args_1_1 && !args_1_1.done && (_a = args_1.return))
                _a.call(args_1);
            } finally {
              if (e_3)
                throw e_3.error;
            }
          }
        };
        TexParser2.prototype.mml = function() {
          if (!this.stack.Top().isKind("mml")) {
            return null;
          }
          var node = this.stack.Top().First;
          this.configuration.popParser();
          return node;
        };
        TexParser2.prototype.convertDelimiter = function(c) {
          var symbol = this.lookup("delimiter", c);
          return symbol ? symbol.char : null;
        };
        TexParser2.prototype.getCodePoint = function() {
          var code = this.string.codePointAt(this.i);
          return code === void 0 ? "" : String.fromCodePoint(code);
        };
        TexParser2.prototype.nextIsSpace = function() {
          return !!this.string.charAt(this.i).match(/\s/);
        };
        TexParser2.prototype.GetNext = function() {
          while (this.nextIsSpace()) {
            this.i++;
          }
          return this.getCodePoint();
        };
        TexParser2.prototype.GetCS = function() {
          var CS = this.string.slice(this.i).match(/^(([a-z]+) ?|[\uD800-\uDBFF].|.)/i);
          if (CS) {
            this.i += CS[0].length;
            return CS[2] || CS[1];
          } else {
            this.i++;
            return " ";
          }
        };
        TexParser2.prototype.GetArgument = function(_name, noneOK) {
          switch (this.GetNext()) {
            case "":
              if (!noneOK) {
                throw new TexError_js_1.default("MissingArgFor", "Missing argument for %1", this.currentCS);
              }
              return null;
            case "}":
              if (!noneOK) {
                throw new TexError_js_1.default("ExtraCloseMissingOpen", "Extra close brace or missing open brace");
              }
              return null;
            case "\\":
              this.i++;
              return "\\" + this.GetCS();
            case "{":
              var j = ++this.i, parens = 1;
              while (this.i < this.string.length) {
                switch (this.string.charAt(this.i++)) {
                  case "\\":
                    this.i++;
                    break;
                  case "{":
                    parens++;
                    break;
                  case "}":
                    if (--parens === 0) {
                      return this.string.slice(j, this.i - 1);
                    }
                    break;
                }
              }
              throw new TexError_js_1.default("MissingCloseBrace", "Missing close brace");
          }
          var c = this.getCodePoint();
          this.i += c.length;
          return c;
        };
        TexParser2.prototype.GetBrackets = function(_name, def) {
          if (this.GetNext() !== "[") {
            return def;
          }
          var j = ++this.i, parens = 0;
          while (this.i < this.string.length) {
            switch (this.string.charAt(this.i++)) {
              case "{":
                parens++;
                break;
              case "\\":
                this.i++;
                break;
              case "}":
                if (parens-- <= 0) {
                  throw new TexError_js_1.default("ExtraCloseLooking", "Extra close brace while looking for %1", "']'");
                }
                break;
              case "]":
                if (parens === 0) {
                  return this.string.slice(j, this.i - 1);
                }
                break;
            }
          }
          throw new TexError_js_1.default("MissingCloseBracket", "Could not find closing ']' for argument to %1", this.currentCS);
        };
        TexParser2.prototype.GetDelimiter = function(name, braceOK) {
          var c = this.GetNext();
          this.i += c.length;
          if (this.i <= this.string.length) {
            if (c === "\\") {
              c += this.GetCS();
            } else if (c === "{" && braceOK) {
              this.i--;
              c = this.GetArgument(name).trim();
            }
            if (this.contains("delimiter", c)) {
              return this.convertDelimiter(c);
            }
          }
          throw new TexError_js_1.default("MissingOrUnrecognizedDelim", "Missing or unrecognized delimiter for %1", this.currentCS);
        };
        TexParser2.prototype.GetDimen = function(name) {
          if (this.GetNext() === "{") {
            var dimen = this.GetArgument(name);
            var _a = __read2(ParseUtil_js_1.default.matchDimen(dimen), 2), value = _a[0], unit = _a[1];
            if (value) {
              return value + unit;
            }
          } else {
            var dimen = this.string.slice(this.i);
            var _b = __read2(ParseUtil_js_1.default.matchDimen(dimen, true), 3), value = _b[0], unit = _b[1], length_1 = _b[2];
            if (value) {
              this.i += length_1;
              return value + unit;
            }
          }
          throw new TexError_js_1.default("MissingDimOrUnits", "Missing dimension or its units for %1", this.currentCS);
        };
        TexParser2.prototype.GetUpTo = function(_name, token) {
          while (this.nextIsSpace()) {
            this.i++;
          }
          var j = this.i;
          var parens = 0;
          while (this.i < this.string.length) {
            var k = this.i;
            var c = this.GetNext();
            this.i += c.length;
            switch (c) {
              case "\\":
                c += this.GetCS();
                break;
              case "{":
                parens++;
                break;
              case "}":
                if (parens === 0) {
                  throw new TexError_js_1.default("ExtraCloseLooking", "Extra close brace while looking for %1", token);
                }
                parens--;
                break;
            }
            if (parens === 0 && c === token) {
              return this.string.slice(j, k);
            }
          }
          throw new TexError_js_1.default("TokenNotFoundForCommand", "Could not find %1 for %2", token, this.currentCS);
        };
        TexParser2.prototype.ParseArg = function(name) {
          return new TexParser2(this.GetArgument(name), this.stack.env, this.configuration).mml();
        };
        TexParser2.prototype.ParseUpTo = function(name, token) {
          return new TexParser2(this.GetUpTo(name, token), this.stack.env, this.configuration).mml();
        };
        TexParser2.prototype.GetDelimiterArg = function(name) {
          var c = ParseUtil_js_1.default.trimSpaces(this.GetArgument(name));
          if (c === "") {
            return null;
          }
          if (this.contains("delimiter", c)) {
            return c;
          }
          throw new TexError_js_1.default("MissingOrUnrecognizedDelim", "Missing or unrecognized delimiter for %1", this.currentCS);
        };
        TexParser2.prototype.GetStar = function() {
          var star = this.GetNext() === "*";
          if (star) {
            this.i++;
          }
          return star;
        };
        TexParser2.prototype.create = function(kind) {
          var _a;
          var rest = [];
          for (var _i = 1; _i < arguments.length; _i++) {
            rest[_i - 1] = arguments[_i];
          }
          return (_a = this.configuration.nodeFactory).create.apply(_a, __spreadArray2([kind], __read2(rest), false));
        };
        return TexParser2;
      }();
      exports.default = TexParser;
    }
  });

  // node_modules/mathjax-full/js/input/tex/StackItem.js
  var require_StackItem = __commonJS({
    "node_modules/mathjax-full/js/input/tex/StackItem.js"(exports) {
      "use strict";
      var __extends2 = exports && exports.__extends || function() {
        var extendStatics2 = function(d, b) {
          extendStatics2 = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
            d2.__proto__ = b2;
          } || function(d2, b2) {
            for (var p in b2)
              if (Object.prototype.hasOwnProperty.call(b2, p))
                d2[p] = b2[p];
          };
          return extendStatics2(d, b);
        };
        return function(d, b) {
          if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
          extendStatics2(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      var __spreadArray2 = exports && exports.__spreadArray || function(to, from, pack) {
        if (pack || arguments.length === 2)
          for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
              if (!ar)
                ar = Array.prototype.slice.call(from, 0, i);
              ar[i] = from[i];
            }
          }
        return to.concat(ar || Array.prototype.slice.call(from));
      };
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      var __importDefault2 = exports && exports.__importDefault || function(mod) {
        return mod && mod.__esModule ? mod : { "default": mod };
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.BaseItem = exports.MmlStack = void 0;
      var TexError_js_1 = __importDefault2(require_TexError());
      var MmlStack = function() {
        function MmlStack2(_nodes) {
          this._nodes = _nodes;
        }
        Object.defineProperty(MmlStack2.prototype, "nodes", {
          get: function() {
            return this._nodes;
          },
          enumerable: false,
          configurable: true
        });
        MmlStack2.prototype.Push = function() {
          var _a;
          var nodes = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            nodes[_i] = arguments[_i];
          }
          (_a = this._nodes).push.apply(_a, __spreadArray2([], __read2(nodes), false));
        };
        MmlStack2.prototype.Pop = function() {
          return this._nodes.pop();
        };
        Object.defineProperty(MmlStack2.prototype, "First", {
          get: function() {
            return this._nodes[this.Size() - 1];
          },
          set: function(node) {
            this._nodes[this.Size() - 1] = node;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(MmlStack2.prototype, "Last", {
          get: function() {
            return this._nodes[0];
          },
          set: function(node) {
            this._nodes[0] = node;
          },
          enumerable: false,
          configurable: true
        });
        MmlStack2.prototype.Peek = function(n) {
          if (n == null) {
            n = 1;
          }
          return this._nodes.slice(this.Size() - n);
        };
        MmlStack2.prototype.Size = function() {
          return this._nodes.length;
        };
        MmlStack2.prototype.Clear = function() {
          this._nodes = [];
        };
        MmlStack2.prototype.toMml = function(inferred, forceRow) {
          if (inferred === void 0) {
            inferred = true;
          }
          if (this._nodes.length === 1 && !forceRow) {
            return this.First;
          }
          return this.create("node", inferred ? "inferredMrow" : "mrow", this._nodes, {});
        };
        MmlStack2.prototype.create = function(kind) {
          var _a;
          var rest = [];
          for (var _i = 1; _i < arguments.length; _i++) {
            rest[_i - 1] = arguments[_i];
          }
          return (_a = this.factory.configuration.nodeFactory).create.apply(_a, __spreadArray2([kind], __read2(rest), false));
        };
        return MmlStack2;
      }();
      exports.MmlStack = MmlStack;
      var BaseItem = function(_super) {
        __extends2(BaseItem2, _super);
        function BaseItem2(factory) {
          var nodes = [];
          for (var _i = 1; _i < arguments.length; _i++) {
            nodes[_i - 1] = arguments[_i];
          }
          var _this = _super.call(this, nodes) || this;
          _this.factory = factory;
          _this.global = {};
          _this._properties = {};
          if (_this.isOpen) {
            _this._env = {};
          }
          return _this;
        }
        Object.defineProperty(BaseItem2.prototype, "kind", {
          get: function() {
            return "base";
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(BaseItem2.prototype, "env", {
          get: function() {
            return this._env;
          },
          set: function(value) {
            this._env = value;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(BaseItem2.prototype, "copyEnv", {
          get: function() {
            return true;
          },
          enumerable: false,
          configurable: true
        });
        BaseItem2.prototype.getProperty = function(key) {
          return this._properties[key];
        };
        BaseItem2.prototype.setProperty = function(key, value) {
          this._properties[key] = value;
          return this;
        };
        Object.defineProperty(BaseItem2.prototype, "isOpen", {
          get: function() {
            return false;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(BaseItem2.prototype, "isClose", {
          get: function() {
            return false;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(BaseItem2.prototype, "isFinal", {
          get: function() {
            return false;
          },
          enumerable: false,
          configurable: true
        });
        BaseItem2.prototype.isKind = function(kind) {
          return kind === this.kind;
        };
        BaseItem2.prototype.checkItem = function(item) {
          if (item.isKind("over") && this.isOpen) {
            item.setProperty("num", this.toMml(false));
            this.Clear();
          }
          if (item.isKind("cell") && this.isOpen) {
            if (item.getProperty("linebreak")) {
              return BaseItem2.fail;
            }
            throw new TexError_js_1.default("Misplaced", "Misplaced %1", item.getName());
          }
          if (item.isClose && this.getErrors(item.kind)) {
            var _a = __read2(this.getErrors(item.kind), 2), id = _a[0], message = _a[1];
            throw new TexError_js_1.default(id, message, item.getName());
          }
          if (!item.isFinal) {
            return BaseItem2.success;
          }
          this.Push(item.First);
          return BaseItem2.fail;
        };
        BaseItem2.prototype.clearEnv = function() {
          var e_1, _a;
          try {
            for (var _b = __values2(Object.keys(this.env)), _c = _b.next(); !_c.done; _c = _b.next()) {
              var id = _c.value;
              delete this.env[id];
            }
          } catch (e_1_1) {
            e_1 = { error: e_1_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_1)
                throw e_1.error;
            }
          }
        };
        BaseItem2.prototype.setProperties = function(def) {
          Object.assign(this._properties, def);
          return this;
        };
        BaseItem2.prototype.getName = function() {
          return this.getProperty("name");
        };
        BaseItem2.prototype.toString = function() {
          return this.kind + "[" + this.nodes.join("; ") + "]";
        };
        BaseItem2.prototype.getErrors = function(kind) {
          var CLASS = this.constructor;
          return (CLASS.errors || {})[kind] || BaseItem2.errors[kind];
        };
        BaseItem2.fail = [null, false];
        BaseItem2.success = [null, true];
        BaseItem2.errors = {
          end: ["MissingBeginExtraEnd", "Missing \\begin{%1} or extra \\end{%1}"],
          close: ["ExtraCloseMissingOpen", "Extra close brace or missing open brace"],
          right: ["MissingLeftExtraRight", "Missing \\left or extra \\right"],
          middle: ["ExtraMiddle", "Extra \\middle"]
        };
        return BaseItem2;
      }(MmlStack);
      exports.BaseItem = BaseItem;
    }
  });

  // node_modules/mathjax-full/js/core/Tree/Factory.js
  var require_Factory = __commonJS({
    "node_modules/mathjax-full/js/core/Tree/Factory.js"(exports) {
      "use strict";
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      var __spreadArray2 = exports && exports.__spreadArray || function(to, from, pack) {
        if (pack || arguments.length === 2)
          for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
              if (!ar)
                ar = Array.prototype.slice.call(from, 0, i);
              ar[i] = from[i];
            }
          }
        return to.concat(ar || Array.prototype.slice.call(from));
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.AbstractFactory = void 0;
      var AbstractFactory = function() {
        function AbstractFactory2(nodes) {
          var e_1, _a;
          if (nodes === void 0) {
            nodes = null;
          }
          this.defaultKind = "unknown";
          this.nodeMap = /* @__PURE__ */ new Map();
          this.node = {};
          if (nodes === null) {
            nodes = this.constructor.defaultNodes;
          }
          try {
            for (var _b = __values2(Object.keys(nodes)), _c = _b.next(); !_c.done; _c = _b.next()) {
              var kind = _c.value;
              this.setNodeClass(kind, nodes[kind]);
            }
          } catch (e_1_1) {
            e_1 = { error: e_1_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_1)
                throw e_1.error;
            }
          }
        }
        AbstractFactory2.prototype.create = function(kind) {
          var args = [];
          for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
          }
          return (this.node[kind] || this.node[this.defaultKind]).apply(void 0, __spreadArray2([], __read2(args), false));
        };
        AbstractFactory2.prototype.setNodeClass = function(kind, nodeClass) {
          this.nodeMap.set(kind, nodeClass);
          var THIS = this;
          var KIND = this.nodeMap.get(kind);
          this.node[kind] = function() {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
              args[_i] = arguments[_i];
            }
            return new (KIND.bind.apply(KIND, __spreadArray2([void 0, THIS], __read2(args), false)))();
          };
        };
        AbstractFactory2.prototype.getNodeClass = function(kind) {
          return this.nodeMap.get(kind);
        };
        AbstractFactory2.prototype.deleteNodeClass = function(kind) {
          this.nodeMap.delete(kind);
          delete this.node[kind];
        };
        AbstractFactory2.prototype.nodeIsKind = function(node, kind) {
          return node instanceof this.getNodeClass(kind);
        };
        AbstractFactory2.prototype.getKinds = function() {
          return Array.from(this.nodeMap.keys());
        };
        AbstractFactory2.defaultNodes = {};
        return AbstractFactory2;
      }();
      exports.AbstractFactory = AbstractFactory;
    }
  });

  // node_modules/mathjax-full/js/input/tex/StackItemFactory.js
  var require_StackItemFactory = __commonJS({
    "node_modules/mathjax-full/js/input/tex/StackItemFactory.js"(exports) {
      "use strict";
      var __extends2 = exports && exports.__extends || function() {
        var extendStatics2 = function(d, b) {
          extendStatics2 = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
            d2.__proto__ = b2;
          } || function(d2, b2) {
            for (var p in b2)
              if (Object.prototype.hasOwnProperty.call(b2, p))
                d2[p] = b2[p];
          };
          return extendStatics2(d, b);
        };
        return function(d, b) {
          if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
          extendStatics2(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var _a;
      Object.defineProperty(exports, "__esModule", { value: true });
      var StackItem_js_1 = require_StackItem();
      var Factory_js_1 = require_Factory();
      var DummyItem = function(_super) {
        __extends2(DummyItem2, _super);
        function DummyItem2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        return DummyItem2;
      }(StackItem_js_1.BaseItem);
      var StackItemFactory = function(_super) {
        __extends2(StackItemFactory2, _super);
        function StackItemFactory2() {
          var _this = _super !== null && _super.apply(this, arguments) || this;
          _this.defaultKind = "dummy";
          _this.configuration = null;
          return _this;
        }
        StackItemFactory2.DefaultStackItems = (_a = {}, _a[DummyItem.prototype.kind] = DummyItem, _a);
        return StackItemFactory2;
      }(Factory_js_1.AbstractFactory);
      exports.default = StackItemFactory;
    }
  });

  // node_modules/mathjax-full/js/input/tex/NodeFactory.js
  var require_NodeFactory = __commonJS({
    "node_modules/mathjax-full/js/input/tex/NodeFactory.js"(exports) {
      "use strict";
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      var __spreadArray2 = exports && exports.__spreadArray || function(to, from, pack) {
        if (pack || arguments.length === 2)
          for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
              if (!ar)
                ar = Array.prototype.slice.call(from, 0, i);
              ar[i] = from[i];
            }
          }
        return to.concat(ar || Array.prototype.slice.call(from));
      };
      var __importDefault2 = exports && exports.__importDefault || function(mod) {
        return mod && mod.__esModule ? mod : { "default": mod };
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.NodeFactory = void 0;
      var NodeUtil_js_1 = __importDefault2(require_NodeUtil());
      var NodeFactory = function() {
        function NodeFactory2() {
          this.mmlFactory = null;
          this.factory = {
            "node": NodeFactory2.createNode,
            "token": NodeFactory2.createToken,
            "text": NodeFactory2.createText,
            "error": NodeFactory2.createError
          };
        }
        NodeFactory2.createNode = function(factory, kind, children, def, text) {
          if (children === void 0) {
            children = [];
          }
          if (def === void 0) {
            def = {};
          }
          var node = factory.mmlFactory.create(kind);
          node.setChildren(children);
          if (text) {
            node.appendChild(text);
          }
          NodeUtil_js_1.default.setProperties(node, def);
          return node;
        };
        NodeFactory2.createToken = function(factory, kind, def, text) {
          if (def === void 0) {
            def = {};
          }
          if (text === void 0) {
            text = "";
          }
          var textNode = factory.create("text", text);
          return factory.create("node", kind, [], def, textNode);
        };
        NodeFactory2.createText = function(factory, text) {
          if (text == null) {
            return null;
          }
          return factory.mmlFactory.create("text").setText(text);
        };
        NodeFactory2.createError = function(factory, message) {
          var text = factory.create("text", message);
          var mtext = factory.create("node", "mtext", [], {}, text);
          var error = factory.create("node", "merror", [mtext], { "data-mjx-error": message });
          return error;
        };
        NodeFactory2.prototype.setMmlFactory = function(mmlFactory) {
          this.mmlFactory = mmlFactory;
        };
        NodeFactory2.prototype.set = function(kind, func) {
          this.factory[kind] = func;
        };
        NodeFactory2.prototype.setCreators = function(maps) {
          for (var kind in maps) {
            this.set(kind, maps[kind]);
          }
        };
        NodeFactory2.prototype.create = function(kind) {
          var rest = [];
          for (var _i = 1; _i < arguments.length; _i++) {
            rest[_i - 1] = arguments[_i];
          }
          var func = this.factory[kind] || this.factory["node"];
          var node = func.apply(void 0, __spreadArray2([this, rest[0]], __read2(rest.slice(1)), false));
          if (kind === "node") {
            this.configuration.addNode(rest[0], node);
          }
          return node;
        };
        NodeFactory2.prototype.get = function(kind) {
          return this.factory[kind];
        };
        return NodeFactory2;
      }();
      exports.NodeFactory = NodeFactory;
    }
  });

  // node_modules/mathjax-full/js/input/tex/ParseOptions.js
  var require_ParseOptions = __commonJS({
    "node_modules/mathjax-full/js/input/tex/ParseOptions.js"(exports) {
      "use strict";
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      var __spreadArray2 = exports && exports.__spreadArray || function(to, from, pack) {
        if (pack || arguments.length === 2)
          for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
              if (!ar)
                ar = Array.prototype.slice.call(from, 0, i);
              ar[i] = from[i];
            }
          }
        return to.concat(ar || Array.prototype.slice.call(from));
      };
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      var __importDefault2 = exports && exports.__importDefault || function(mod) {
        return mod && mod.__esModule ? mod : { "default": mod };
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      var StackItemFactory_js_1 = __importDefault2(require_StackItemFactory());
      var NodeFactory_js_1 = require_NodeFactory();
      var NodeUtil_js_1 = __importDefault2(require_NodeUtil());
      var Options_js_1 = require_Options();
      var ParseOptions = function() {
        function ParseOptions2(configuration, options) {
          if (options === void 0) {
            options = [];
          }
          this.options = {};
          this.packageData = /* @__PURE__ */ new Map();
          this.parsers = [];
          this.root = null;
          this.nodeLists = {};
          this.error = false;
          this.handlers = configuration.handlers;
          this.nodeFactory = new NodeFactory_js_1.NodeFactory();
          this.nodeFactory.configuration = this;
          this.nodeFactory.setCreators(configuration.nodes);
          this.itemFactory = new StackItemFactory_js_1.default(configuration.items);
          this.itemFactory.configuration = this;
          Options_js_1.defaultOptions.apply(void 0, __spreadArray2([this.options], __read2(options), false));
          (0, Options_js_1.defaultOptions)(this.options, configuration.options);
        }
        ParseOptions2.prototype.pushParser = function(parser) {
          this.parsers.unshift(parser);
        };
        ParseOptions2.prototype.popParser = function() {
          this.parsers.shift();
        };
        Object.defineProperty(ParseOptions2.prototype, "parser", {
          get: function() {
            return this.parsers[0];
          },
          enumerable: false,
          configurable: true
        });
        ParseOptions2.prototype.clear = function() {
          this.parsers = [];
          this.root = null;
          this.nodeLists = {};
          this.error = false;
          this.tags.resetTag();
        };
        ParseOptions2.prototype.addNode = function(property, node) {
          var list = this.nodeLists[property];
          if (!list) {
            list = this.nodeLists[property] = [];
          }
          list.push(node);
          if (node.kind !== property) {
            var inlists = NodeUtil_js_1.default.getProperty(node, "in-lists") || "";
            var lists = (inlists ? inlists.split(/,/) : []).concat(property).join(",");
            NodeUtil_js_1.default.setProperty(node, "in-lists", lists);
          }
        };
        ParseOptions2.prototype.getList = function(property) {
          var e_1, _a;
          var list = this.nodeLists[property] || [];
          var result = [];
          try {
            for (var list_1 = __values2(list), list_1_1 = list_1.next(); !list_1_1.done; list_1_1 = list_1.next()) {
              var node = list_1_1.value;
              if (this.inTree(node)) {
                result.push(node);
              }
            }
          } catch (e_1_1) {
            e_1 = { error: e_1_1 };
          } finally {
            try {
              if (list_1_1 && !list_1_1.done && (_a = list_1.return))
                _a.call(list_1);
            } finally {
              if (e_1)
                throw e_1.error;
            }
          }
          this.nodeLists[property] = result;
          return result;
        };
        ParseOptions2.prototype.removeFromList = function(property, nodes) {
          var e_2, _a;
          var list = this.nodeLists[property] || [];
          try {
            for (var nodes_1 = __values2(nodes), nodes_1_1 = nodes_1.next(); !nodes_1_1.done; nodes_1_1 = nodes_1.next()) {
              var node = nodes_1_1.value;
              var i = list.indexOf(node);
              if (i >= 0) {
                list.splice(i, 1);
              }
            }
          } catch (e_2_1) {
            e_2 = { error: e_2_1 };
          } finally {
            try {
              if (nodes_1_1 && !nodes_1_1.done && (_a = nodes_1.return))
                _a.call(nodes_1);
            } finally {
              if (e_2)
                throw e_2.error;
            }
          }
        };
        ParseOptions2.prototype.inTree = function(node) {
          while (node && node !== this.root) {
            node = node.parent;
          }
          return !!node;
        };
        return ParseOptions2;
      }();
      exports.default = ParseOptions;
    }
  });

  // node_modules/mathjax-full/js/input/tex/Tags.js
  var require_Tags = __commonJS({
    "node_modules/mathjax-full/js/input/tex/Tags.js"(exports) {
      "use strict";
      var __extends2 = exports && exports.__extends || function() {
        var extendStatics2 = function(d, b) {
          extendStatics2 = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
            d2.__proto__ = b2;
          } || function(d2, b2) {
            for (var p in b2)
              if (Object.prototype.hasOwnProperty.call(b2, p))
                d2[p] = b2[p];
          };
          return extendStatics2(d, b);
        };
        return function(d, b) {
          if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
          extendStatics2(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      var __importDefault2 = exports && exports.__importDefault || function(mod) {
        return mod && mod.__esModule ? mod : { "default": mod };
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TagsFactory = exports.AllTags = exports.NoTags = exports.AbstractTags = exports.TagInfo = exports.Label = void 0;
      var TexParser_js_1 = __importDefault2(require_TexParser());
      var Label = function() {
        function Label2(tag, id) {
          if (tag === void 0) {
            tag = "???";
          }
          if (id === void 0) {
            id = "";
          }
          this.tag = tag;
          this.id = id;
        }
        return Label2;
      }();
      exports.Label = Label;
      var TagInfo = function() {
        function TagInfo2(env, taggable, defaultTags2, tag, tagId, tagFormat, noTag, labelId) {
          if (env === void 0) {
            env = "";
          }
          if (taggable === void 0) {
            taggable = false;
          }
          if (defaultTags2 === void 0) {
            defaultTags2 = false;
          }
          if (tag === void 0) {
            tag = null;
          }
          if (tagId === void 0) {
            tagId = "";
          }
          if (tagFormat === void 0) {
            tagFormat = "";
          }
          if (noTag === void 0) {
            noTag = false;
          }
          if (labelId === void 0) {
            labelId = "";
          }
          this.env = env;
          this.taggable = taggable;
          this.defaultTags = defaultTags2;
          this.tag = tag;
          this.tagId = tagId;
          this.tagFormat = tagFormat;
          this.noTag = noTag;
          this.labelId = labelId;
        }
        return TagInfo2;
      }();
      exports.TagInfo = TagInfo;
      var AbstractTags = function() {
        function AbstractTags2() {
          this.counter = 0;
          this.allCounter = 0;
          this.configuration = null;
          this.ids = {};
          this.allIds = {};
          this.labels = {};
          this.allLabels = {};
          this.redo = false;
          this.refUpdate = false;
          this.currentTag = new TagInfo();
          this.history = [];
          this.stack = [];
          this.enTag = function(node, tag) {
            var nf = this.configuration.nodeFactory;
            var cell = nf.create("node", "mtd", [node]);
            var row = nf.create("node", "mlabeledtr", [tag, cell]);
            var table = nf.create("node", "mtable", [row], {
              side: this.configuration.options["tagSide"],
              minlabelspacing: this.configuration.options["tagIndent"],
              displaystyle: true
            });
            return table;
          };
        }
        AbstractTags2.prototype.start = function(env, taggable, defaultTags2) {
          if (this.currentTag) {
            this.stack.push(this.currentTag);
          }
          this.currentTag = new TagInfo(env, taggable, defaultTags2);
        };
        Object.defineProperty(AbstractTags2.prototype, "env", {
          get: function() {
            return this.currentTag.env;
          },
          enumerable: false,
          configurable: true
        });
        AbstractTags2.prototype.end = function() {
          this.history.push(this.currentTag);
          this.currentTag = this.stack.pop();
        };
        AbstractTags2.prototype.tag = function(tag, noFormat) {
          this.currentTag.tag = tag;
          this.currentTag.tagFormat = noFormat ? tag : this.formatTag(tag);
          this.currentTag.noTag = false;
        };
        AbstractTags2.prototype.notag = function() {
          this.tag("", true);
          this.currentTag.noTag = true;
        };
        Object.defineProperty(AbstractTags2.prototype, "noTag", {
          get: function() {
            return this.currentTag.noTag;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(AbstractTags2.prototype, "label", {
          get: function() {
            return this.currentTag.labelId;
          },
          set: function(label) {
            this.currentTag.labelId = label;
          },
          enumerable: false,
          configurable: true
        });
        AbstractTags2.prototype.formatUrl = function(id, base) {
          return base + "#" + encodeURIComponent(id);
        };
        AbstractTags2.prototype.formatTag = function(tag) {
          return "(" + tag + ")";
        };
        AbstractTags2.prototype.formatId = function(id) {
          return "mjx-eqn:" + id.replace(/\s/g, "_");
        };
        AbstractTags2.prototype.formatNumber = function(n) {
          return n.toString();
        };
        AbstractTags2.prototype.autoTag = function() {
          if (this.currentTag.tag == null) {
            this.counter++;
            this.tag(this.formatNumber(this.counter), false);
          }
        };
        AbstractTags2.prototype.clearTag = function() {
          this.label = "";
          this.tag(null, true);
          this.currentTag.tagId = "";
        };
        AbstractTags2.prototype.getTag = function(force) {
          if (force === void 0) {
            force = false;
          }
          if (force) {
            this.autoTag();
            return this.makeTag();
          }
          var ct = this.currentTag;
          if (ct.taggable && !ct.noTag) {
            if (ct.defaultTags) {
              this.autoTag();
            }
            if (ct.tag) {
              return this.makeTag();
            }
          }
          return null;
        };
        AbstractTags2.prototype.resetTag = function() {
          this.history = [];
          this.redo = false;
          this.refUpdate = false;
          this.clearTag();
        };
        AbstractTags2.prototype.reset = function(offset) {
          if (offset === void 0) {
            offset = 0;
          }
          this.resetTag();
          this.counter = this.allCounter = offset;
          this.allLabels = {};
          this.allIds = {};
        };
        AbstractTags2.prototype.startEquation = function(math) {
          this.history = [];
          this.stack = [];
          this.clearTag();
          this.currentTag = new TagInfo("", void 0, void 0);
          this.labels = {};
          this.ids = {};
          this.counter = this.allCounter;
          this.redo = false;
          var recompile = math.inputData.recompile;
          if (recompile) {
            this.refUpdate = true;
            this.counter = recompile.counter;
          }
        };
        AbstractTags2.prototype.finishEquation = function(math) {
          if (this.redo) {
            math.inputData.recompile = {
              state: math.state(),
              counter: this.allCounter
            };
          }
          if (!this.refUpdate) {
            this.allCounter = this.counter;
          }
          Object.assign(this.allIds, this.ids);
          Object.assign(this.allLabels, this.labels);
        };
        AbstractTags2.prototype.finalize = function(node, env) {
          if (!env.display || this.currentTag.env || this.currentTag.tag == null) {
            return node;
          }
          var tag = this.makeTag();
          var table = this.enTag(node, tag);
          return table;
        };
        AbstractTags2.prototype.makeId = function() {
          this.currentTag.tagId = this.formatId(this.configuration.options["useLabelIds"] ? this.label || this.currentTag.tag : this.currentTag.tag);
        };
        AbstractTags2.prototype.makeTag = function() {
          this.makeId();
          if (this.label) {
            this.labels[this.label] = new Label(this.currentTag.tag, this.currentTag.tagId);
          }
          var mml = new TexParser_js_1.default("\\text{" + this.currentTag.tagFormat + "}", {}, this.configuration).mml();
          return this.configuration.nodeFactory.create("node", "mtd", [mml], { id: this.currentTag.tagId });
        };
        return AbstractTags2;
      }();
      exports.AbstractTags = AbstractTags;
      var NoTags = function(_super) {
        __extends2(NoTags2, _super);
        function NoTags2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        NoTags2.prototype.autoTag = function() {
        };
        NoTags2.prototype.getTag = function() {
          return !this.currentTag.tag ? null : _super.prototype.getTag.call(this);
        };
        return NoTags2;
      }(AbstractTags);
      exports.NoTags = NoTags;
      var AllTags = function(_super) {
        __extends2(AllTags2, _super);
        function AllTags2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        AllTags2.prototype.finalize = function(node, env) {
          if (!env.display || this.history.find(function(x) {
            return x.taggable;
          })) {
            return node;
          }
          var tag = this.getTag(true);
          return this.enTag(node, tag);
        };
        return AllTags2;
      }(AbstractTags);
      exports.AllTags = AllTags;
      var TagsFactory;
      (function(TagsFactory2) {
        var tagsMapping = /* @__PURE__ */ new Map([
          ["none", NoTags],
          ["all", AllTags]
        ]);
        var defaultTags2 = "none";
        TagsFactory2.OPTIONS = {
          tags: defaultTags2,
          tagSide: "right",
          tagIndent: "0.8em",
          useLabelIds: true,
          ignoreDuplicateLabels: false
        };
        TagsFactory2.add = function(name, constr) {
          tagsMapping.set(name, constr);
        };
        TagsFactory2.addTags = function(tags) {
          var e_1, _a;
          try {
            for (var _b = __values2(Object.keys(tags)), _c = _b.next(); !_c.done; _c = _b.next()) {
              var key = _c.value;
              TagsFactory2.add(key, tags[key]);
            }
          } catch (e_1_1) {
            e_1 = { error: e_1_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_1)
                throw e_1.error;
            }
          }
        };
        TagsFactory2.create = function(name) {
          var constr = tagsMapping.get(name) || tagsMapping.get(defaultTags2);
          if (!constr) {
            throw Error("Unknown tags class");
          }
          return new constr();
        };
        TagsFactory2.setDefault = function(name) {
          defaultTags2 = name;
        };
        TagsFactory2.getDefault = function() {
          return TagsFactory2.create(defaultTags2);
        };
      })(TagsFactory = exports.TagsFactory || (exports.TagsFactory = {}));
    }
  });

  // node_modules/mathjax-full/js/input/tex/MapHandler.js
  var require_MapHandler = __commonJS({
    "node_modules/mathjax-full/js/input/tex/MapHandler.js"(exports) {
      "use strict";
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.SubHandlers = exports.SubHandler = exports.MapHandler = void 0;
      var PrioritizedList_js_1 = require_PrioritizedList();
      var FunctionList_js_1 = require_FunctionList();
      var MapHandler;
      (function(MapHandler2) {
        var maps = /* @__PURE__ */ new Map();
        MapHandler2.register = function(map) {
          maps.set(map.name, map);
        };
        MapHandler2.getMap = function(name) {
          return maps.get(name);
        };
      })(MapHandler = exports.MapHandler || (exports.MapHandler = {}));
      var SubHandler = function() {
        function SubHandler2() {
          this._configuration = new PrioritizedList_js_1.PrioritizedList();
          this._fallback = new FunctionList_js_1.FunctionList();
        }
        SubHandler2.prototype.add = function(maps, fallback, priority) {
          var e_1, _a;
          if (priority === void 0) {
            priority = PrioritizedList_js_1.PrioritizedList.DEFAULTPRIORITY;
          }
          try {
            for (var _b = __values2(maps.slice().reverse()), _c = _b.next(); !_c.done; _c = _b.next()) {
              var name_1 = _c.value;
              var map = MapHandler.getMap(name_1);
              if (!map) {
                this.warn("Configuration " + name_1 + " not found! Omitted.");
                return;
              }
              this._configuration.add(map, priority);
            }
          } catch (e_1_1) {
            e_1 = { error: e_1_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_1)
                throw e_1.error;
            }
          }
          if (fallback) {
            this._fallback.add(fallback, priority);
          }
        };
        SubHandler2.prototype.parse = function(input) {
          var e_2, _a;
          try {
            for (var _b = __values2(this._configuration), _c = _b.next(); !_c.done; _c = _b.next()) {
              var map = _c.value.item;
              var result = map.parse(input);
              if (result) {
                return result;
              }
            }
          } catch (e_2_1) {
            e_2 = { error: e_2_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_2)
                throw e_2.error;
            }
          }
          var _d = __read2(input, 2), env = _d[0], symbol = _d[1];
          Array.from(this._fallback)[0].item(env, symbol);
        };
        SubHandler2.prototype.lookup = function(symbol) {
          var map = this.applicable(symbol);
          return map ? map.lookup(symbol) : null;
        };
        SubHandler2.prototype.contains = function(symbol) {
          return this.applicable(symbol) ? true : false;
        };
        SubHandler2.prototype.toString = function() {
          var e_3, _a;
          var names = [];
          try {
            for (var _b = __values2(this._configuration), _c = _b.next(); !_c.done; _c = _b.next()) {
              var map = _c.value.item;
              names.push(map.name);
            }
          } catch (e_3_1) {
            e_3 = { error: e_3_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_3)
                throw e_3.error;
            }
          }
          return names.join(", ");
        };
        SubHandler2.prototype.applicable = function(symbol) {
          var e_4, _a;
          try {
            for (var _b = __values2(this._configuration), _c = _b.next(); !_c.done; _c = _b.next()) {
              var map = _c.value.item;
              if (map.contains(symbol)) {
                return map;
              }
            }
          } catch (e_4_1) {
            e_4 = { error: e_4_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_4)
                throw e_4.error;
            }
          }
          return null;
        };
        SubHandler2.prototype.retrieve = function(name) {
          var e_5, _a;
          try {
            for (var _b = __values2(this._configuration), _c = _b.next(); !_c.done; _c = _b.next()) {
              var map = _c.value.item;
              if (map.name === name) {
                return map;
              }
            }
          } catch (e_5_1) {
            e_5 = { error: e_5_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_5)
                throw e_5.error;
            }
          }
          return null;
        };
        SubHandler2.prototype.warn = function(message) {
          console.log("TexParser Warning: " + message);
        };
        return SubHandler2;
      }();
      exports.SubHandler = SubHandler;
      var SubHandlers = function() {
        function SubHandlers2() {
          this.map = /* @__PURE__ */ new Map();
        }
        SubHandlers2.prototype.add = function(handlers, fallbacks, priority) {
          var e_6, _a;
          if (priority === void 0) {
            priority = PrioritizedList_js_1.PrioritizedList.DEFAULTPRIORITY;
          }
          try {
            for (var _b = __values2(Object.keys(handlers)), _c = _b.next(); !_c.done; _c = _b.next()) {
              var key = _c.value;
              var name_2 = key;
              var subHandler = this.get(name_2);
              if (!subHandler) {
                subHandler = new SubHandler();
                this.set(name_2, subHandler);
              }
              subHandler.add(handlers[name_2], fallbacks[name_2], priority);
            }
          } catch (e_6_1) {
            e_6 = { error: e_6_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_6)
                throw e_6.error;
            }
          }
        };
        SubHandlers2.prototype.set = function(name, subHandler) {
          this.map.set(name, subHandler);
        };
        SubHandlers2.prototype.get = function(name) {
          return this.map.get(name);
        };
        SubHandlers2.prototype.retrieve = function(name) {
          var e_7, _a;
          try {
            for (var _b = __values2(this.map.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
              var handler = _c.value;
              var map = handler.retrieve(name);
              if (map) {
                return map;
              }
            }
          } catch (e_7_1) {
            e_7 = { error: e_7_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_7)
                throw e_7.error;
            }
          }
          return null;
        };
        SubHandlers2.prototype.keys = function() {
          return this.map.keys();
        };
        return SubHandlers2;
      }();
      exports.SubHandlers = SubHandlers;
    }
  });

  // node_modules/mathjax-full/js/input/tex/Configuration.js
  var require_Configuration = __commonJS({
    "node_modules/mathjax-full/js/input/tex/Configuration.js"(exports) {
      "use strict";
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.ParserConfiguration = exports.ConfigurationHandler = exports.Configuration = void 0;
      var Options_js_1 = require_Options();
      var MapHandler_js_1 = require_MapHandler();
      var FunctionList_js_1 = require_FunctionList();
      var PrioritizedList_js_1 = require_PrioritizedList();
      var Tags_js_1 = require_Tags();
      var Configuration = function() {
        function Configuration2(name, handler, fallback, items, tags, options, nodes, preprocessors, postprocessors, initMethod, configMethod, priority, parser) {
          if (handler === void 0) {
            handler = {};
          }
          if (fallback === void 0) {
            fallback = {};
          }
          if (items === void 0) {
            items = {};
          }
          if (tags === void 0) {
            tags = {};
          }
          if (options === void 0) {
            options = {};
          }
          if (nodes === void 0) {
            nodes = {};
          }
          if (preprocessors === void 0) {
            preprocessors = [];
          }
          if (postprocessors === void 0) {
            postprocessors = [];
          }
          if (initMethod === void 0) {
            initMethod = null;
          }
          if (configMethod === void 0) {
            configMethod = null;
          }
          this.name = name;
          this.handler = handler;
          this.fallback = fallback;
          this.items = items;
          this.tags = tags;
          this.options = options;
          this.nodes = nodes;
          this.preprocessors = preprocessors;
          this.postprocessors = postprocessors;
          this.initMethod = initMethod;
          this.configMethod = configMethod;
          this.priority = priority;
          this.parser = parser;
          this.handler = Object.assign({ character: [], delimiter: [], macro: [], environment: [] }, handler);
        }
        Configuration2.makeProcessor = function(func, priority) {
          return Array.isArray(func) ? func : [func, priority];
        };
        Configuration2._create = function(name, config2) {
          var _this = this;
          if (config2 === void 0) {
            config2 = {};
          }
          var priority = config2.priority || PrioritizedList_js_1.PrioritizedList.DEFAULTPRIORITY;
          var init = config2.init ? this.makeProcessor(config2.init, priority) : null;
          var conf = config2.config ? this.makeProcessor(config2.config, priority) : null;
          var preprocessors = (config2.preprocessors || []).map(function(pre) {
            return _this.makeProcessor(pre, priority);
          });
          var postprocessors = (config2.postprocessors || []).map(function(post) {
            return _this.makeProcessor(post, priority);
          });
          var parser = config2.parser || "tex";
          return new Configuration2(name, config2.handler || {}, config2.fallback || {}, config2.items || {}, config2.tags || {}, config2.options || {}, config2.nodes || {}, preprocessors, postprocessors, init, conf, priority, parser);
        };
        Configuration2.create = function(name, config2) {
          if (config2 === void 0) {
            config2 = {};
          }
          var configuration = Configuration2._create(name, config2);
          ConfigurationHandler.set(name, configuration);
          return configuration;
        };
        Configuration2.local = function(config2) {
          if (config2 === void 0) {
            config2 = {};
          }
          return Configuration2._create("", config2);
        };
        Object.defineProperty(Configuration2.prototype, "init", {
          get: function() {
            return this.initMethod ? this.initMethod[0] : null;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(Configuration2.prototype, "config", {
          get: function() {
            return this.configMethod ? this.configMethod[0] : null;
          },
          enumerable: false,
          configurable: true
        });
        return Configuration2;
      }();
      exports.Configuration = Configuration;
      var ConfigurationHandler;
      (function(ConfigurationHandler2) {
        var maps = /* @__PURE__ */ new Map();
        ConfigurationHandler2.set = function(name, map) {
          maps.set(name, map);
        };
        ConfigurationHandler2.get = function(name) {
          return maps.get(name);
        };
        ConfigurationHandler2.keys = function() {
          return maps.keys();
        };
      })(ConfigurationHandler = exports.ConfigurationHandler || (exports.ConfigurationHandler = {}));
      var ParserConfiguration = function() {
        function ParserConfiguration2(packages, parsers) {
          var e_1, _a, e_2, _b;
          if (parsers === void 0) {
            parsers = ["tex"];
          }
          this.initMethod = new FunctionList_js_1.FunctionList();
          this.configMethod = new FunctionList_js_1.FunctionList();
          this.configurations = new PrioritizedList_js_1.PrioritizedList();
          this.parsers = [];
          this.handlers = new MapHandler_js_1.SubHandlers();
          this.items = {};
          this.tags = {};
          this.options = {};
          this.nodes = {};
          this.parsers = parsers;
          try {
            for (var _c = __values2(packages.slice().reverse()), _d = _c.next(); !_d.done; _d = _c.next()) {
              var pkg = _d.value;
              this.addPackage(pkg);
            }
          } catch (e_1_1) {
            e_1 = { error: e_1_1 };
          } finally {
            try {
              if (_d && !_d.done && (_a = _c.return))
                _a.call(_c);
            } finally {
              if (e_1)
                throw e_1.error;
            }
          }
          try {
            for (var _e = __values2(this.configurations), _f = _e.next(); !_f.done; _f = _e.next()) {
              var _g = _f.value, config2 = _g.item, priority = _g.priority;
              this.append(config2, priority);
            }
          } catch (e_2_1) {
            e_2 = { error: e_2_1 };
          } finally {
            try {
              if (_f && !_f.done && (_b = _e.return))
                _b.call(_e);
            } finally {
              if (e_2)
                throw e_2.error;
            }
          }
        }
        ParserConfiguration2.prototype.init = function() {
          this.initMethod.execute(this);
        };
        ParserConfiguration2.prototype.config = function(jax) {
          var e_3, _a;
          this.configMethod.execute(this, jax);
          try {
            for (var _b = __values2(this.configurations), _c = _b.next(); !_c.done; _c = _b.next()) {
              var config2 = _c.value;
              this.addFilters(jax, config2.item);
            }
          } catch (e_3_1) {
            e_3 = { error: e_3_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_3)
                throw e_3.error;
            }
          }
        };
        ParserConfiguration2.prototype.addPackage = function(pkg) {
          var name = typeof pkg === "string" ? pkg : pkg[0];
          var conf = this.getPackage(name);
          conf && this.configurations.add(conf, typeof pkg === "string" ? conf.priority : pkg[1]);
        };
        ParserConfiguration2.prototype.add = function(name, jax, options) {
          var e_4, _a;
          if (options === void 0) {
            options = {};
          }
          var config2 = this.getPackage(name);
          this.append(config2);
          this.configurations.add(config2, config2.priority);
          this.init();
          var parser = jax.parseOptions;
          parser.nodeFactory.setCreators(config2.nodes);
          try {
            for (var _b = __values2(Object.keys(config2.items)), _c = _b.next(); !_c.done; _c = _b.next()) {
              var kind = _c.value;
              parser.itemFactory.setNodeClass(kind, config2.items[kind]);
            }
          } catch (e_4_1) {
            e_4 = { error: e_4_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_4)
                throw e_4.error;
            }
          }
          Tags_js_1.TagsFactory.addTags(config2.tags);
          (0, Options_js_1.defaultOptions)(parser.options, config2.options);
          (0, Options_js_1.userOptions)(parser.options, options);
          this.addFilters(jax, config2);
          if (config2.config) {
            config2.config(this, jax);
          }
        };
        ParserConfiguration2.prototype.getPackage = function(name) {
          var config2 = ConfigurationHandler.get(name);
          if (config2 && this.parsers.indexOf(config2.parser) < 0) {
            throw Error("Package ".concat(name, " doesn't target the proper parser"));
          }
          return config2;
        };
        ParserConfiguration2.prototype.append = function(config2, priority) {
          priority = priority || config2.priority;
          if (config2.initMethod) {
            this.initMethod.add(config2.initMethod[0], config2.initMethod[1]);
          }
          if (config2.configMethod) {
            this.configMethod.add(config2.configMethod[0], config2.configMethod[1]);
          }
          this.handlers.add(config2.handler, config2.fallback, priority);
          Object.assign(this.items, config2.items);
          Object.assign(this.tags, config2.tags);
          (0, Options_js_1.defaultOptions)(this.options, config2.options);
          Object.assign(this.nodes, config2.nodes);
        };
        ParserConfiguration2.prototype.addFilters = function(jax, config2) {
          var e_5, _a, e_6, _b;
          try {
            for (var _c = __values2(config2.preprocessors), _d = _c.next(); !_d.done; _d = _c.next()) {
              var _e = __read2(_d.value, 2), pre = _e[0], priority = _e[1];
              jax.preFilters.add(pre, priority);
            }
          } catch (e_5_1) {
            e_5 = { error: e_5_1 };
          } finally {
            try {
              if (_d && !_d.done && (_a = _c.return))
                _a.call(_c);
            } finally {
              if (e_5)
                throw e_5.error;
            }
          }
          try {
            for (var _f = __values2(config2.postprocessors), _g = _f.next(); !_g.done; _g = _f.next()) {
              var _h = __read2(_g.value, 2), post = _h[0], priority = _h[1];
              jax.postFilters.add(post, priority);
            }
          } catch (e_6_1) {
            e_6 = { error: e_6_1 };
          } finally {
            try {
              if (_g && !_g.done && (_b = _f.return))
                _b.call(_f);
            } finally {
              if (e_6)
                throw e_6.error;
            }
          }
        };
        return ParserConfiguration2;
      }();
      exports.ParserConfiguration = ParserConfiguration;
    }
  });

  // node_modules/mathjax-full/js/input/tex/Symbol.js
  var require_Symbol = __commonJS({
    "node_modules/mathjax-full/js/input/tex/Symbol.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.Macro = exports.Symbol = void 0;
      var Symbol2 = function() {
        function Symbol3(_symbol, _char, _attributes) {
          this._symbol = _symbol;
          this._char = _char;
          this._attributes = _attributes;
        }
        Object.defineProperty(Symbol3.prototype, "symbol", {
          get: function() {
            return this._symbol;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(Symbol3.prototype, "char", {
          get: function() {
            return this._char;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(Symbol3.prototype, "attributes", {
          get: function() {
            return this._attributes;
          },
          enumerable: false,
          configurable: true
        });
        return Symbol3;
      }();
      exports.Symbol = Symbol2;
      var Macro = function() {
        function Macro2(_symbol, _func, _args) {
          if (_args === void 0) {
            _args = [];
          }
          this._symbol = _symbol;
          this._func = _func;
          this._args = _args;
        }
        Object.defineProperty(Macro2.prototype, "symbol", {
          get: function() {
            return this._symbol;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(Macro2.prototype, "func", {
          get: function() {
            return this._func;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(Macro2.prototype, "args", {
          get: function() {
            return this._args;
          },
          enumerable: false,
          configurable: true
        });
        return Macro2;
      }();
      exports.Macro = Macro;
    }
  });

  // node_modules/mathjax-full/js/input/tex/SymbolMap.js
  var require_SymbolMap = __commonJS({
    "node_modules/mathjax-full/js/input/tex/SymbolMap.js"(exports) {
      "use strict";
      var __extends2 = exports && exports.__extends || function() {
        var extendStatics2 = function(d, b) {
          extendStatics2 = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
            d2.__proto__ = b2;
          } || function(d2, b2) {
            for (var p in b2)
              if (Object.prototype.hasOwnProperty.call(b2, p))
                d2[p] = b2[p];
          };
          return extendStatics2(d, b);
        };
        return function(d, b) {
          if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
          extendStatics2(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      var __values2 = exports && exports.__values || function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      var __spreadArray2 = exports && exports.__spreadArray || function(to, from, pack) {
        if (pack || arguments.length === 2)
          for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
              if (!ar)
                ar = Array.prototype.slice.call(from, 0, i);
              ar[i] = from[i];
            }
          }
        return to.concat(ar || Array.prototype.slice.call(from));
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.EnvironmentMap = exports.CommandMap = exports.MacroMap = exports.DelimiterMap = exports.CharacterMap = exports.AbstractParseMap = exports.RegExpMap = exports.AbstractSymbolMap = exports.parseResult = void 0;
      var Symbol_js_1 = require_Symbol();
      var MapHandler_js_1 = require_MapHandler();
      function parseResult(result) {
        return result === void 0 ? true : result;
      }
      exports.parseResult = parseResult;
      var AbstractSymbolMap = function() {
        function AbstractSymbolMap2(_name, _parser) {
          this._name = _name;
          this._parser = _parser;
          MapHandler_js_1.MapHandler.register(this);
        }
        Object.defineProperty(AbstractSymbolMap2.prototype, "name", {
          get: function() {
            return this._name;
          },
          enumerable: false,
          configurable: true
        });
        AbstractSymbolMap2.prototype.parserFor = function(symbol) {
          return this.contains(symbol) ? this.parser : null;
        };
        AbstractSymbolMap2.prototype.parse = function(_a) {
          var _b = __read2(_a, 2), env = _b[0], symbol = _b[1];
          var parser = this.parserFor(symbol);
          var mapped = this.lookup(symbol);
          return parser && mapped ? parseResult(parser(env, mapped)) : null;
        };
        Object.defineProperty(AbstractSymbolMap2.prototype, "parser", {
          get: function() {
            return this._parser;
          },
          set: function(parser) {
            this._parser = parser;
          },
          enumerable: false,
          configurable: true
        });
        return AbstractSymbolMap2;
      }();
      exports.AbstractSymbolMap = AbstractSymbolMap;
      var RegExpMap = function(_super) {
        __extends2(RegExpMap2, _super);
        function RegExpMap2(name, parser, _regExp) {
          var _this = _super.call(this, name, parser) || this;
          _this._regExp = _regExp;
          return _this;
        }
        RegExpMap2.prototype.contains = function(symbol) {
          return this._regExp.test(symbol);
        };
        RegExpMap2.prototype.lookup = function(symbol) {
          return this.contains(symbol) ? symbol : null;
        };
        return RegExpMap2;
      }(AbstractSymbolMap);
      exports.RegExpMap = RegExpMap;
      var AbstractParseMap = function(_super) {
        __extends2(AbstractParseMap2, _super);
        function AbstractParseMap2() {
          var _this = _super !== null && _super.apply(this, arguments) || this;
          _this.map = /* @__PURE__ */ new Map();
          return _this;
        }
        AbstractParseMap2.prototype.lookup = function(symbol) {
          return this.map.get(symbol);
        };
        AbstractParseMap2.prototype.contains = function(symbol) {
          return this.map.has(symbol);
        };
        AbstractParseMap2.prototype.add = function(symbol, object) {
          this.map.set(symbol, object);
        };
        AbstractParseMap2.prototype.remove = function(symbol) {
          this.map.delete(symbol);
        };
        return AbstractParseMap2;
      }(AbstractSymbolMap);
      exports.AbstractParseMap = AbstractParseMap;
      var CharacterMap = function(_super) {
        __extends2(CharacterMap2, _super);
        function CharacterMap2(name, parser, json) {
          var e_1, _a;
          var _this = _super.call(this, name, parser) || this;
          try {
            for (var _b = __values2(Object.keys(json)), _c = _b.next(); !_c.done; _c = _b.next()) {
              var key = _c.value;
              var value = json[key];
              var _d = __read2(typeof value === "string" ? [value, null] : value, 2), char = _d[0], attrs = _d[1];
              var character = new Symbol_js_1.Symbol(key, char, attrs);
              _this.add(key, character);
            }
          } catch (e_1_1) {
            e_1 = { error: e_1_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_1)
                throw e_1.error;
            }
          }
          return _this;
        }
        return CharacterMap2;
      }(AbstractParseMap);
      exports.CharacterMap = CharacterMap;
      var DelimiterMap = function(_super) {
        __extends2(DelimiterMap2, _super);
        function DelimiterMap2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        DelimiterMap2.prototype.parse = function(_a) {
          var _b = __read2(_a, 2), env = _b[0], symbol = _b[1];
          return _super.prototype.parse.call(this, [env, "\\" + symbol]);
        };
        return DelimiterMap2;
      }(CharacterMap);
      exports.DelimiterMap = DelimiterMap;
      var MacroMap = function(_super) {
        __extends2(MacroMap2, _super);
        function MacroMap2(name, json, functionMap) {
          var e_2, _a;
          var _this = _super.call(this, name, null) || this;
          try {
            for (var _b = __values2(Object.keys(json)), _c = _b.next(); !_c.done; _c = _b.next()) {
              var key = _c.value;
              var value = json[key];
              var _d = __read2(typeof value === "string" ? [value] : value), func = _d[0], attrs = _d.slice(1);
              var character = new Symbol_js_1.Macro(key, functionMap[func], attrs);
              _this.add(key, character);
            }
          } catch (e_2_1) {
            e_2 = { error: e_2_1 };
          } finally {
            try {
              if (_c && !_c.done && (_a = _b.return))
                _a.call(_b);
            } finally {
              if (e_2)
                throw e_2.error;
            }
          }
          return _this;
        }
        MacroMap2.prototype.parserFor = function(symbol) {
          var macro = this.lookup(symbol);
          return macro ? macro.func : null;
        };
        MacroMap2.prototype.parse = function(_a) {
          var _b = __read2(_a, 2), env = _b[0], symbol = _b[1];
          var macro = this.lookup(symbol);
          var parser = this.parserFor(symbol);
          if (!macro || !parser) {
            return null;
          }
          return parseResult(parser.apply(void 0, __spreadArray2([env, macro.symbol], __read2(macro.args), false)));
        };
        return MacroMap2;
      }(AbstractParseMap);
      exports.MacroMap = MacroMap;
      var CommandMap = function(_super) {
        __extends2(CommandMap2, _super);
        function CommandMap2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        CommandMap2.prototype.parse = function(_a) {
          var _b = __read2(_a, 2), env = _b[0], symbol = _b[1];
          var macro = this.lookup(symbol);
          var parser = this.parserFor(symbol);
          if (!macro || !parser) {
            return null;
          }
          var saveCommand = env.currentCS;
          env.currentCS = "\\" + symbol;
          var result = parser.apply(void 0, __spreadArray2([env, "\\" + macro.symbol], __read2(macro.args), false));
          env.currentCS = saveCommand;
          return parseResult(result);
        };
        return CommandMap2;
      }(MacroMap);
      exports.CommandMap = CommandMap;
      var EnvironmentMap = function(_super) {
        __extends2(EnvironmentMap2, _super);
        function EnvironmentMap2(name, parser, json, functionMap) {
          var _this = _super.call(this, name, json, functionMap) || this;
          _this.parser = parser;
          return _this;
        }
        EnvironmentMap2.prototype.parse = function(_a) {
          var _b = __read2(_a, 2), env = _b[0], symbol = _b[1];
          var macro = this.lookup(symbol);
          var envParser = this.parserFor(symbol);
          if (!macro || !envParser) {
            return null;
          }
          return parseResult(this.parser(env, macro.symbol, envParser, macro.args));
        };
        return EnvironmentMap2;
      }(MacroMap);
      exports.EnvironmentMap = EnvironmentMap;
    }
  });

  // node_modules/mathjax-full/js/input/tex/base/BaseItems.js
  var require_BaseItems = __commonJS({
    "node_modules/mathjax-full/js/input/tex/base/BaseItems.js"(exports) {
      "use strict";
      var __extends2 = exports && exports.__extends || function() {
        var extendStatics2 = function(d, b) {
          extendStatics2 = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
            d2.__proto__ = b2;
          } || function(d2, b2) {
            for (var p in b2)
              if (Object.prototype.hasOwnProperty.call(b2, p))
                d2[p] = b2[p];
          };
          return extendStatics2(d, b);
        };
        return function(d, b) {
          if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
          extendStatics2(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      var __spreadArray2 = exports && exports.__spreadArray || function(to, from, pack) {
        if (pack || arguments.length === 2)
          for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
              if (!ar)
                ar = Array.prototype.slice.call(from, 0, i);
              ar[i] = from[i];
            }
          }
        return to.concat(ar || Array.prototype.slice.call(from));
      };
      var __importDefault2 = exports && exports.__importDefault || function(mod) {
        return mod && mod.__esModule ? mod : { "default": mod };
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.EquationItem = exports.EqnArrayItem = exports.ArrayItem = exports.DotsItem = exports.NonscriptItem = exports.NotItem = exports.FnItem = exports.MmlItem = exports.CellItem = exports.PositionItem = exports.StyleItem = exports.EndItem = exports.BeginItem = exports.RightItem = exports.Middle = exports.LeftItem = exports.OverItem = exports.SubsupItem = exports.PrimeItem = exports.CloseItem = exports.OpenItem = exports.StopItem = exports.StartItem = void 0;
      var MapHandler_js_1 = require_MapHandler();
      var Entities_js_1 = require_Entities();
      var MmlNode_js_1 = require_MmlNode();
      var TexError_js_1 = __importDefault2(require_TexError());
      var ParseUtil_js_1 = __importDefault2(require_ParseUtil());
      var NodeUtil_js_1 = __importDefault2(require_NodeUtil());
      var StackItem_js_1 = require_StackItem();
      var StartItem = function(_super) {
        __extends2(StartItem2, _super);
        function StartItem2(factory, global2) {
          var _this = _super.call(this, factory) || this;
          _this.global = global2;
          return _this;
        }
        Object.defineProperty(StartItem2.prototype, "kind", {
          get: function() {
            return "start";
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(StartItem2.prototype, "isOpen", {
          get: function() {
            return true;
          },
          enumerable: false,
          configurable: true
        });
        StartItem2.prototype.checkItem = function(item) {
          if (item.isKind("stop")) {
            var node = this.toMml();
            if (!this.global.isInner) {
              node = this.factory.configuration.tags.finalize(node, this.env);
            }
            return [[this.factory.create("mml", node)], true];
          }
          return _super.prototype.checkItem.call(this, item);
        };
        return StartItem2;
      }(StackItem_js_1.BaseItem);
      exports.StartItem = StartItem;
      var StopItem = function(_super) {
        __extends2(StopItem2, _super);
        function StopItem2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(StopItem2.prototype, "kind", {
          get: function() {
            return "stop";
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(StopItem2.prototype, "isClose", {
          get: function() {
            return true;
          },
          enumerable: false,
          configurable: true
        });
        return StopItem2;
      }(StackItem_js_1.BaseItem);
      exports.StopItem = StopItem;
      var OpenItem = function(_super) {
        __extends2(OpenItem2, _super);
        function OpenItem2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(OpenItem2.prototype, "kind", {
          get: function() {
            return "open";
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(OpenItem2.prototype, "isOpen", {
          get: function() {
            return true;
          },
          enumerable: false,
          configurable: true
        });
        OpenItem2.prototype.checkItem = function(item) {
          if (item.isKind("close")) {
            var mml = this.toMml();
            var node = this.create("node", "TeXAtom", [mml]);
            return [[this.factory.create("mml", node)], true];
          }
          return _super.prototype.checkItem.call(this, item);
        };
        OpenItem2.errors = Object.assign(Object.create(StackItem_js_1.BaseItem.errors), {
          "stop": [
            "ExtraOpenMissingClose",
            "Extra open brace or missing close brace"
          ]
        });
        return OpenItem2;
      }(StackItem_js_1.BaseItem);
      exports.OpenItem = OpenItem;
      var CloseItem = function(_super) {
        __extends2(CloseItem2, _super);
        function CloseItem2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(CloseItem2.prototype, "kind", {
          get: function() {
            return "close";
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(CloseItem2.prototype, "isClose", {
          get: function() {
            return true;
          },
          enumerable: false,
          configurable: true
        });
        return CloseItem2;
      }(StackItem_js_1.BaseItem);
      exports.CloseItem = CloseItem;
      var PrimeItem = function(_super) {
        __extends2(PrimeItem2, _super);
        function PrimeItem2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(PrimeItem2.prototype, "kind", {
          get: function() {
            return "prime";
          },
          enumerable: false,
          configurable: true
        });
        PrimeItem2.prototype.checkItem = function(item) {
          var _a = __read2(this.Peek(2), 2), top0 = _a[0], top1 = _a[1];
          if (!NodeUtil_js_1.default.isType(top0, "msubsup") || NodeUtil_js_1.default.isType(top0, "msup")) {
            var node = this.create("node", "msup", [top0, top1]);
            return [[node, item], true];
          }
          NodeUtil_js_1.default.setChild(top0, top0.sup, top1);
          return [[top0, item], true];
        };
        return PrimeItem2;
      }(StackItem_js_1.BaseItem);
      exports.PrimeItem = PrimeItem;
      var SubsupItem = function(_super) {
        __extends2(SubsupItem2, _super);
        function SubsupItem2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(SubsupItem2.prototype, "kind", {
          get: function() {
            return "subsup";
          },
          enumerable: false,
          configurable: true
        });
        SubsupItem2.prototype.checkItem = function(item) {
          if (item.isKind("open") || item.isKind("left")) {
            return StackItem_js_1.BaseItem.success;
          }
          var top = this.First;
          var position = this.getProperty("position");
          if (item.isKind("mml")) {
            if (this.getProperty("primes")) {
              if (position !== 2) {
                NodeUtil_js_1.default.setChild(top, 2, this.getProperty("primes"));
              } else {
                NodeUtil_js_1.default.setProperty(this.getProperty("primes"), "variantForm", true);
                var node = this.create("node", "mrow", [this.getProperty("primes"), item.First]);
                item.First = node;
              }
            }
            NodeUtil_js_1.default.setChild(top, position, item.First);
            if (this.getProperty("movesupsub") != null) {
              NodeUtil_js_1.default.setProperty(top, "movesupsub", this.getProperty("movesupsub"));
            }
            var result = this.factory.create("mml", top);
            return [[result], true];
          }
          if (_super.prototype.checkItem.call(this, item)[1]) {
            var error = this.getErrors(["", "sub", "sup"][position]);
            throw new (TexError_js_1.default.bind.apply(TexError_js_1.default, __spreadArray2([void 0, error[0], error[1]], __read2(error.splice(2)), false)))();
          }
          return null;
        };
        SubsupItem2.errors = Object.assign(Object.create(StackItem_js_1.BaseItem.errors), {
          "stop": [
            "MissingScript",
            "Missing superscript or subscript argument"
          ],
          "sup": [
            "MissingOpenForSup",
            "Missing open brace for superscript"
          ],
          "sub": [
            "MissingOpenForSub",
            "Missing open brace for subscript"
          ]
        });
        return SubsupItem2;
      }(StackItem_js_1.BaseItem);
      exports.SubsupItem = SubsupItem;
      var OverItem = function(_super) {
        __extends2(OverItem2, _super);
        function OverItem2(factory) {
          var _this = _super.call(this, factory) || this;
          _this.setProperty("name", "\\over");
          return _this;
        }
        Object.defineProperty(OverItem2.prototype, "kind", {
          get: function() {
            return "over";
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(OverItem2.prototype, "isClose", {
          get: function() {
            return true;
          },
          enumerable: false,
          configurable: true
        });
        OverItem2.prototype.checkItem = function(item) {
          if (item.isKind("over")) {
            throw new TexError_js_1.default("AmbiguousUseOf", "Ambiguous use of %1", item.getName());
          }
          if (item.isClose) {
            var mml = this.create("node", "mfrac", [this.getProperty("num"), this.toMml(false)]);
            if (this.getProperty("thickness") != null) {
              NodeUtil_js_1.default.setAttribute(mml, "linethickness", this.getProperty("thickness"));
            }
            if (this.getProperty("open") || this.getProperty("close")) {
              NodeUtil_js_1.default.setProperty(mml, "withDelims", true);
              mml = ParseUtil_js_1.default.fixedFence(this.factory.configuration, this.getProperty("open"), mml, this.getProperty("close"));
            }
            return [[this.factory.create("mml", mml), item], true];
          }
          return _super.prototype.checkItem.call(this, item);
        };
        OverItem2.prototype.toString = function() {
          return "over[" + this.getProperty("num") + " / " + this.nodes.join("; ") + "]";
        };
        return OverItem2;
      }(StackItem_js_1.BaseItem);
      exports.OverItem = OverItem;
      var LeftItem = function(_super) {
        __extends2(LeftItem2, _super);
        function LeftItem2(factory, delim) {
          var _this = _super.call(this, factory) || this;
          _this.setProperty("delim", delim);
          return _this;
        }
        Object.defineProperty(LeftItem2.prototype, "kind", {
          get: function() {
            return "left";
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(LeftItem2.prototype, "isOpen", {
          get: function() {
            return true;
          },
          enumerable: false,
          configurable: true
        });
        LeftItem2.prototype.checkItem = function(item) {
          if (item.isKind("right")) {
            return [[this.factory.create("mml", ParseUtil_js_1.default.fenced(this.factory.configuration, this.getProperty("delim"), this.toMml(), item.getProperty("delim"), "", item.getProperty("color")))], true];
          }
          if (item.isKind("middle")) {
            var def = { stretchy: true };
            if (item.getProperty("color")) {
              def.mathcolor = item.getProperty("color");
            }
            this.Push(this.create("node", "TeXAtom", [], { texClass: MmlNode_js_1.TEXCLASS.CLOSE }), this.create("token", "mo", def, item.getProperty("delim")), this.create("node", "TeXAtom", [], { texClass: MmlNode_js_1.TEXCLASS.OPEN }));
            this.env = {};
            return [[this], true];
          }
          return _super.prototype.checkItem.call(this, item);
        };
        LeftItem2.errors = Object.assign(Object.create(StackItem_js_1.BaseItem.errors), {
          "stop": [
            "ExtraLeftMissingRight",
            "Extra \\left or missing \\right"
          ]
        });
        return LeftItem2;
      }(StackItem_js_1.BaseItem);
      exports.LeftItem = LeftItem;
      var Middle = function(_super) {
        __extends2(Middle2, _super);
        function Middle2(factory, delim, color) {
          var _this = _super.call(this, factory) || this;
          _this.setProperty("delim", delim);
          color && _this.setProperty("color", color);
          return _this;
        }
        Object.defineProperty(Middle2.prototype, "kind", {
          get: function() {
            return "middle";
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(Middle2.prototype, "isClose", {
          get: function() {
            return true;
          },
          enumerable: false,
          configurable: true
        });
        return Middle2;
      }(StackItem_js_1.BaseItem);
      exports.Middle = Middle;
      var RightItem = function(_super) {
        __extends2(RightItem2, _super);
        function RightItem2(factory, delim, color) {
          var _this = _super.call(this, factory) || this;
          _this.setProperty("delim", delim);
          color && _this.setProperty("color", color);
          return _this;
        }
        Object.defineProperty(RightItem2.prototype, "kind", {
          get: function() {
            return "right";
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(RightItem2.prototype, "isClose", {
          get: function() {
            return true;
          },
          enumerable: false,
          configurable: true
        });
        return RightItem2;
      }(StackItem_js_1.BaseItem);
      exports.RightItem = RightItem;
      var BeginItem = function(_super) {
        __extends2(BeginItem2, _super);
        function BeginItem2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(BeginItem2.prototype, "kind", {
          get: function() {
            return "begin";
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(BeginItem2.prototype, "isOpen", {
          get: function() {
            return true;
          },
          enumerable: false,
          configurable: true
        });
        BeginItem2.prototype.checkItem = function(item) {
          if (item.isKind("end")) {
            if (item.getName() !== this.getName()) {
              throw new TexError_js_1.default("EnvBadEnd", "\\begin{%1} ended with \\end{%2}", this.getName(), item.getName());
            }
            if (!this.getProperty("end")) {
              return [[this.factory.create("mml", this.toMml())], true];
            }
            return StackItem_js_1.BaseItem.fail;
          }
          if (item.isKind("stop")) {
            throw new TexError_js_1.default("EnvMissingEnd", "Missing \\end{%1}", this.getName());
          }
          return _super.prototype.checkItem.call(this, item);
        };
        return BeginItem2;
      }(StackItem_js_1.BaseItem);
      exports.BeginItem = BeginItem;
      var EndItem = function(_super) {
        __extends2(EndItem2, _super);
        function EndItem2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(EndItem2.prototype, "kind", {
          get: function() {
            return "end";
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(EndItem2.prototype, "isClose", {
          get: function() {
            return true;
          },
          enumerable: false,
          configurable: true
        });
        return EndItem2;
      }(StackItem_js_1.BaseItem);
      exports.EndItem = EndItem;
      var StyleItem = function(_super) {
        __extends2(StyleItem2, _super);
        function StyleItem2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(StyleItem2.prototype, "kind", {
          get: function() {
            return "style";
          },
          enumerable: false,
          configurable: true
        });
        StyleItem2.prototype.checkItem = function(item) {
          if (!item.isClose) {
            return _super.prototype.checkItem.call(this, item);
          }
          var mml = this.create("node", "mstyle", this.nodes, this.getProperty("styles"));
          return [[this.factory.create("mml", mml), item], true];
        };
        return StyleItem2;
      }(StackItem_js_1.BaseItem);
      exports.StyleItem = StyleItem;
      var PositionItem = function(_super) {
        __extends2(PositionItem2, _super);
        function PositionItem2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(PositionItem2.prototype, "kind", {
          get: function() {
            return "position";
          },
          enumerable: false,
          configurable: true
        });
        PositionItem2.prototype.checkItem = function(item) {
          if (item.isClose) {
            throw new TexError_js_1.default("MissingBoxFor", "Missing box for %1", this.getName());
          }
          if (item.isFinal) {
            var mml = item.toMml();
            switch (this.getProperty("move")) {
              case "vertical":
                mml = this.create("node", "mpadded", [mml], {
                  height: this.getProperty("dh"),
                  depth: this.getProperty("dd"),
                  voffset: this.getProperty("dh")
                });
                return [[this.factory.create("mml", mml)], true];
              case "horizontal":
                return [[
                  this.factory.create("mml", this.getProperty("left")),
                  item,
                  this.factory.create("mml", this.getProperty("right"))
                ], true];
            }
          }
          return _super.prototype.checkItem.call(this, item);
        };
        return PositionItem2;
      }(StackItem_js_1.BaseItem);
      exports.PositionItem = PositionItem;
      var CellItem = function(_super) {
        __extends2(CellItem2, _super);
        function CellItem2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(CellItem2.prototype, "kind", {
          get: function() {
            return "cell";
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(CellItem2.prototype, "isClose", {
          get: function() {
            return true;
          },
          enumerable: false,
          configurable: true
        });
        return CellItem2;
      }(StackItem_js_1.BaseItem);
      exports.CellItem = CellItem;
      var MmlItem = function(_super) {
        __extends2(MmlItem2, _super);
        function MmlItem2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(MmlItem2.prototype, "isFinal", {
          get: function() {
            return true;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(MmlItem2.prototype, "kind", {
          get: function() {
            return "mml";
          },
          enumerable: false,
          configurable: true
        });
        return MmlItem2;
      }(StackItem_js_1.BaseItem);
      exports.MmlItem = MmlItem;
      var FnItem = function(_super) {
        __extends2(FnItem2, _super);
        function FnItem2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(FnItem2.prototype, "kind", {
          get: function() {
            return "fn";
          },
          enumerable: false,
          configurable: true
        });
        FnItem2.prototype.checkItem = function(item) {
          var top = this.First;
          if (top) {
            if (item.isOpen) {
              return StackItem_js_1.BaseItem.success;
            }
            if (!item.isKind("fn")) {
              var mml = item.First;
              if (!item.isKind("mml") || !mml) {
                return [[top, item], true];
              }
              if (NodeUtil_js_1.default.isType(mml, "mstyle") && mml.childNodes.length && NodeUtil_js_1.default.isType(mml.childNodes[0].childNodes[0], "mspace") || NodeUtil_js_1.default.isType(mml, "mspace")) {
                return [[top, item], true];
              }
              if (NodeUtil_js_1.default.isEmbellished(mml)) {
                mml = NodeUtil_js_1.default.getCoreMO(mml);
              }
              var form = NodeUtil_js_1.default.getForm(mml);
              if (form != null && [0, 0, 1, 1, 0, 1, 1, 0, 0, 0][form[2]]) {
                return [[top, item], true];
              }
            }
            var node = this.create("token", "mo", { texClass: MmlNode_js_1.TEXCLASS.NONE }, Entities_js_1.entities.ApplyFunction);
            return [[top, node, item], true];
          }
          return _super.prototype.checkItem.apply(this, arguments);
        };
        return FnItem2;
      }(StackItem_js_1.BaseItem);
      exports.FnItem = FnItem;
      var NotItem = function(_super) {
        __extends2(NotItem2, _super);
        function NotItem2() {
          var _this = _super !== null && _super.apply(this, arguments) || this;
          _this.remap = MapHandler_js_1.MapHandler.getMap("not_remap");
          return _this;
        }
        Object.defineProperty(NotItem2.prototype, "kind", {
          get: function() {
            return "not";
          },
          enumerable: false,
          configurable: true
        });
        NotItem2.prototype.checkItem = function(item) {
          var mml;
          var c;
          var textNode;
          if (item.isKind("open") || item.isKind("left")) {
            return StackItem_js_1.BaseItem.success;
          }
          if (item.isKind("mml") && (NodeUtil_js_1.default.isType(item.First, "mo") || NodeUtil_js_1.default.isType(item.First, "mi") || NodeUtil_js_1.default.isType(item.First, "mtext"))) {
            mml = item.First;
            c = NodeUtil_js_1.default.getText(mml);
            if (c.length === 1 && !NodeUtil_js_1.default.getProperty(mml, "movesupsub") && NodeUtil_js_1.default.getChildren(mml).length === 1) {
              if (this.remap.contains(c)) {
                textNode = this.create("text", this.remap.lookup(c).char);
                NodeUtil_js_1.default.setChild(mml, 0, textNode);
              } else {
                textNode = this.create("text", "\u0338");
                NodeUtil_js_1.default.appendChildren(mml, [textNode]);
              }
              return [[item], true];
            }
          }
          textNode = this.create("text", "\u29F8");
          var mtextNode = this.create("node", "mtext", [], {}, textNode);
          var paddedNode = this.create("node", "mpadded", [mtextNode], { width: 0 });
          mml = this.create("node", "TeXAtom", [paddedNode], { texClass: MmlNode_js_1.TEXCLASS.REL });
          return [[mml, item], true];
        };
        return NotItem2;
      }(StackItem_js_1.BaseItem);
      exports.NotItem = NotItem;
      var NonscriptItem = function(_super) {
        __extends2(NonscriptItem2, _super);
        function NonscriptItem2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(NonscriptItem2.prototype, "kind", {
          get: function() {
            return "nonscript";
          },
          enumerable: false,
          configurable: true
        });
        NonscriptItem2.prototype.checkItem = function(item) {
          if (item.isKind("mml") && item.Size() === 1) {
            var mml = item.First;
            if (mml.isKind("mstyle") && mml.notParent) {
              mml = NodeUtil_js_1.default.getChildren(NodeUtil_js_1.default.getChildren(mml)[0])[0];
            }
            if (mml.isKind("mspace")) {
              if (mml !== item.First) {
                var mrow = this.create("node", "mrow", [item.Pop()]);
                item.Push(mrow);
              }
              this.factory.configuration.addNode("nonscript", item.First);
            }
          }
          return [[item], true];
        };
        return NonscriptItem2;
      }(StackItem_js_1.BaseItem);
      exports.NonscriptItem = NonscriptItem;
      var DotsItem = function(_super) {
        __extends2(DotsItem2, _super);
        function DotsItem2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(DotsItem2.prototype, "kind", {
          get: function() {
            return "dots";
          },
          enumerable: false,
          configurable: true
        });
        DotsItem2.prototype.checkItem = function(item) {
          if (item.isKind("open") || item.isKind("left")) {
            return StackItem_js_1.BaseItem.success;
          }
          var dots = this.getProperty("ldots");
          var top = item.First;
          if (item.isKind("mml") && NodeUtil_js_1.default.isEmbellished(top)) {
            var tclass = NodeUtil_js_1.default.getTexClass(NodeUtil_js_1.default.getCoreMO(top));
            if (tclass === MmlNode_js_1.TEXCLASS.BIN || tclass === MmlNode_js_1.TEXCLASS.REL) {
              dots = this.getProperty("cdots");
            }
          }
          return [[dots, item], true];
        };
        return DotsItem2;
      }(StackItem_js_1.BaseItem);
      exports.DotsItem = DotsItem;
      var ArrayItem = function(_super) {
        __extends2(ArrayItem2, _super);
        function ArrayItem2() {
          var _this = _super !== null && _super.apply(this, arguments) || this;
          _this.table = [];
          _this.row = [];
          _this.frame = [];
          _this.hfill = [];
          _this.arraydef = {};
          _this.dashed = false;
          return _this;
        }
        Object.defineProperty(ArrayItem2.prototype, "kind", {
          get: function() {
            return "array";
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(ArrayItem2.prototype, "isOpen", {
          get: function() {
            return true;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(ArrayItem2.prototype, "copyEnv", {
          get: function() {
            return false;
          },
          enumerable: false,
          configurable: true
        });
        ArrayItem2.prototype.checkItem = function(item) {
          if (item.isClose && !item.isKind("over")) {
            if (item.getProperty("isEntry")) {
              this.EndEntry();
              this.clearEnv();
              return StackItem_js_1.BaseItem.fail;
            }
            if (item.getProperty("isCR")) {
              this.EndEntry();
              this.EndRow();
              this.clearEnv();
              return StackItem_js_1.BaseItem.fail;
            }
            this.EndTable();
            this.clearEnv();
            var newItem = this.factory.create("mml", this.createMml());
            if (this.getProperty("requireClose")) {
              if (item.isKind("close")) {
                return [[newItem], true];
              }
              throw new TexError_js_1.default("MissingCloseBrace", "Missing close brace");
            }
            return [[newItem, item], true];
          }
          return _super.prototype.checkItem.call(this, item);
        };
        ArrayItem2.prototype.createMml = function() {
          var scriptlevel = this.arraydef["scriptlevel"];
          delete this.arraydef["scriptlevel"];
          var mml = this.create("node", "mtable", this.table, this.arraydef);
          if (scriptlevel) {
            mml.setProperty("scriptlevel", scriptlevel);
          }
          if (this.frame.length === 4) {
            NodeUtil_js_1.default.setAttribute(mml, "frame", this.dashed ? "dashed" : "solid");
          } else if (this.frame.length) {
            if (this.arraydef["rowlines"]) {
              this.arraydef["rowlines"] = this.arraydef["rowlines"].replace(/none( none)+$/, "none");
            }
            NodeUtil_js_1.default.setAttribute(mml, "frame", "");
            mml = this.create("node", "menclose", [mml], { notation: this.frame.join(" ") });
            if ((this.arraydef["columnlines"] || "none") !== "none" || (this.arraydef["rowlines"] || "none") !== "none") {
              NodeUtil_js_1.default.setAttribute(mml, "data-padding", 0);
            }
          }
          if (this.getProperty("open") || this.getProperty("close")) {
            mml = ParseUtil_js_1.default.fenced(this.factory.configuration, this.getProperty("open"), mml, this.getProperty("close"));
          }
          return mml;
        };
        ArrayItem2.prototype.EndEntry = function() {
          var mtd = this.create("node", "mtd", this.nodes);
          if (this.hfill.length) {
            if (this.hfill[0] === 0) {
              NodeUtil_js_1.default.setAttribute(mtd, "columnalign", "right");
            }
            if (this.hfill[this.hfill.length - 1] === this.Size()) {
              NodeUtil_js_1.default.setAttribute(mtd, "columnalign", NodeUtil_js_1.default.getAttribute(mtd, "columnalign") ? "center" : "left");
            }
          }
          this.row.push(mtd);
          this.Clear();
          this.hfill = [];
        };
        ArrayItem2.prototype.EndRow = function() {
          var node;
          if (this.getProperty("isNumbered") && this.row.length === 3) {
            this.row.unshift(this.row.pop());
            node = this.create("node", "mlabeledtr", this.row);
          } else {
            node = this.create("node", "mtr", this.row);
          }
          this.table.push(node);
          this.row = [];
        };
        ArrayItem2.prototype.EndTable = function() {
          if (this.Size() || this.row.length) {
            this.EndEntry();
            this.EndRow();
          }
          this.checkLines();
        };
        ArrayItem2.prototype.checkLines = function() {
          if (this.arraydef["rowlines"]) {
            var lines = this.arraydef["rowlines"].split(/ /);
            if (lines.length === this.table.length) {
              this.frame.push("bottom");
              lines.pop();
              this.arraydef["rowlines"] = lines.join(" ");
            } else if (lines.length < this.table.length - 1) {
              this.arraydef["rowlines"] += " none";
            }
          }
          if (this.getProperty("rowspacing")) {
            var rows = this.arraydef["rowspacing"].split(/ /);
            while (rows.length < this.table.length) {
              rows.push(this.getProperty("rowspacing") + "em");
            }
            this.arraydef["rowspacing"] = rows.join(" ");
          }
        };
        ArrayItem2.prototype.addRowSpacing = function(spacing) {
          if (this.arraydef["rowspacing"]) {
            var rows = this.arraydef["rowspacing"].split(/ /);
            if (!this.getProperty("rowspacing")) {
              var dimem = ParseUtil_js_1.default.dimen2em(rows[0]);
              this.setProperty("rowspacing", dimem);
            }
            var rowspacing = this.getProperty("rowspacing");
            while (rows.length < this.table.length) {
              rows.push(ParseUtil_js_1.default.Em(rowspacing));
            }
            rows[this.table.length - 1] = ParseUtil_js_1.default.Em(Math.max(0, rowspacing + ParseUtil_js_1.default.dimen2em(spacing)));
            this.arraydef["rowspacing"] = rows.join(" ");
          }
        };
        return ArrayItem2;
      }(StackItem_js_1.BaseItem);
      exports.ArrayItem = ArrayItem;
      var EqnArrayItem = function(_super) {
        __extends2(EqnArrayItem2, _super);
        function EqnArrayItem2(factory) {
          var args = [];
          for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
          }
          var _this = _super.call(this, factory) || this;
          _this.maxrow = 0;
          _this.factory.configuration.tags.start(args[0], args[2], args[1]);
          return _this;
        }
        Object.defineProperty(EqnArrayItem2.prototype, "kind", {
          get: function() {
            return "eqnarray";
          },
          enumerable: false,
          configurable: true
        });
        EqnArrayItem2.prototype.EndEntry = function() {
          if (this.row.length) {
            ParseUtil_js_1.default.fixInitialMO(this.factory.configuration, this.nodes);
          }
          var node = this.create("node", "mtd", this.nodes);
          this.row.push(node);
          this.Clear();
        };
        EqnArrayItem2.prototype.EndRow = function() {
          if (this.row.length > this.maxrow) {
            this.maxrow = this.row.length;
          }
          var mtr = "mtr";
          var tag = this.factory.configuration.tags.getTag();
          if (tag) {
            this.row = [tag].concat(this.row);
            mtr = "mlabeledtr";
          }
          this.factory.configuration.tags.clearTag();
          var node = this.create("node", mtr, this.row);
          this.table.push(node);
          this.row = [];
        };
        EqnArrayItem2.prototype.EndTable = function() {
          _super.prototype.EndTable.call(this);
          this.factory.configuration.tags.end();
          this.extendArray("columnalign", this.maxrow);
          this.extendArray("columnwidth", this.maxrow);
          this.extendArray("columnspacing", this.maxrow - 1);
        };
        EqnArrayItem2.prototype.extendArray = function(name, max) {
          if (!this.arraydef[name])
            return;
          var repeat = this.arraydef[name].split(/ /);
          var columns = __spreadArray2([], __read2(repeat), false);
          if (columns.length > 1) {
            while (columns.length < max) {
              columns.push.apply(columns, __spreadArray2([], __read2(repeat), false));
            }
            this.arraydef[name] = columns.slice(0, max).join(" ");
          }
        };
        return EqnArrayItem2;
      }(ArrayItem);
      exports.EqnArrayItem = EqnArrayItem;
      var EquationItem = function(_super) {
        __extends2(EquationItem2, _super);
        function EquationItem2(factory) {
          var args = [];
          for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
          }
          var _this = _super.call(this, factory) || this;
          _this.factory.configuration.tags.start("equation", true, args[0]);
          return _this;
        }
        Object.defineProperty(EquationItem2.prototype, "kind", {
          get: function() {
            return "equation";
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(EquationItem2.prototype, "isOpen", {
          get: function() {
            return true;
          },
          enumerable: false,
          configurable: true
        });
        EquationItem2.prototype.checkItem = function(item) {
          if (item.isKind("end")) {
            var mml = this.toMml();
            var tag = this.factory.configuration.tags.getTag();
            this.factory.configuration.tags.end();
            return [[tag ? this.factory.configuration.tags.enTag(mml, tag) : mml, item], true];
          }
          if (item.isKind("stop")) {
            throw new TexError_js_1.default("EnvMissingEnd", "Missing \\end{%1}", this.getName());
          }
          return _super.prototype.checkItem.call(this, item);
        };
        return EquationItem2;
      }(StackItem_js_1.BaseItem);
      exports.EquationItem = EquationItem;
    }
  });

  // node_modules/mathjax-full/js/input/tex/TexConstants.js
  var require_TexConstants = __commonJS({
    "node_modules/mathjax-full/js/input/tex/TexConstants.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.TexConstant = void 0;
      var TexConstant;
      (function(TexConstant2) {
        TexConstant2.Variant = {
          NORMAL: "normal",
          BOLD: "bold",
          ITALIC: "italic",
          BOLDITALIC: "bold-italic",
          DOUBLESTRUCK: "double-struck",
          FRAKTUR: "fraktur",
          BOLDFRAKTUR: "bold-fraktur",
          SCRIPT: "script",
          BOLDSCRIPT: "bold-script",
          SANSSERIF: "sans-serif",
          BOLDSANSSERIF: "bold-sans-serif",
          SANSSERIFITALIC: "sans-serif-italic",
          SANSSERIFBOLDITALIC: "sans-serif-bold-italic",
          MONOSPACE: "monospace",
          INITIAL: "inital",
          TAILED: "tailed",
          LOOPED: "looped",
          STRETCHED: "stretched",
          CALLIGRAPHIC: "-tex-calligraphic",
          BOLDCALLIGRAPHIC: "-tex-bold-calligraphic",
          OLDSTYLE: "-tex-oldstyle",
          BOLDOLDSTYLE: "-tex-bold-oldstyle",
          MATHITALIC: "-tex-mathit"
        };
        TexConstant2.Form = {
          PREFIX: "prefix",
          INFIX: "infix",
          POSTFIX: "postfix"
        };
        TexConstant2.LineBreak = {
          AUTO: "auto",
          NEWLINE: "newline",
          NOBREAK: "nobreak",
          GOODBREAK: "goodbreak",
          BADBREAK: "badbreak"
        };
        TexConstant2.LineBreakStyle = {
          BEFORE: "before",
          AFTER: "after",
          DUPLICATE: "duplicate",
          INFIXLINBREAKSTYLE: "infixlinebreakstyle"
        };
        TexConstant2.IndentAlign = {
          LEFT: "left",
          CENTER: "center",
          RIGHT: "right",
          AUTO: "auto",
          ID: "id",
          INDENTALIGN: "indentalign"
        };
        TexConstant2.IndentShift = {
          INDENTSHIFT: "indentshift"
        };
        TexConstant2.LineThickness = {
          THIN: "thin",
          MEDIUM: "medium",
          THICK: "thick"
        };
        TexConstant2.Notation = {
          LONGDIV: "longdiv",
          ACTUARIAL: "actuarial",
          PHASORANGLE: "phasorangle",
          RADICAL: "radical",
          BOX: "box",
          ROUNDEDBOX: "roundedbox",
          CIRCLE: "circle",
          LEFT: "left",
          RIGHT: "right",
          TOP: "top",
          BOTTOM: "bottom",
          UPDIAGONALSTRIKE: "updiagonalstrike",
          DOWNDIAGONALSTRIKE: "downdiagonalstrike",
          VERTICALSTRIKE: "verticalstrike",
          HORIZONTALSTRIKE: "horizontalstrike",
          NORTHEASTARROW: "northeastarrow",
          MADRUWB: "madruwb",
          UPDIAGONALARROW: "updiagonalarrow"
        };
        TexConstant2.Align = {
          TOP: "top",
          BOTTOM: "bottom",
          CENTER: "center",
          BASELINE: "baseline",
          AXIS: "axis",
          LEFT: "left",
          RIGHT: "right"
        };
        TexConstant2.Lines = {
          NONE: "none",
          SOLID: "solid",
          DASHED: "dashed"
        };
        TexConstant2.Side = {
          LEFT: "left",
          RIGHT: "right",
          LEFTOVERLAP: "leftoverlap",
          RIGHTOVERLAP: "rightoverlap"
        };
        TexConstant2.Width = {
          AUTO: "auto",
          FIT: "fit"
        };
        TexConstant2.Actiontype = {
          TOGGLE: "toggle",
          STATUSLINE: "statusline",
          TOOLTIP: "tooltip",
          INPUT: "input"
        };
        TexConstant2.Overflow = {
          LINBREAK: "linebreak",
          SCROLL: "scroll",
          ELIDE: "elide",
          TRUNCATE: "truncate",
          SCALE: "scale"
        };
        TexConstant2.Unit = {
          EM: "em",
          EX: "ex",
          PX: "px",
          IN: "in",
          CM: "cm",
          MM: "mm",
          PT: "pt",
          PC: "pc"
        };
      })(TexConstant = exports.TexConstant || (exports.TexConstant = {}));
    }
  });

  // node_modules/mathjax-full/js/util/lengths.js
  var require_lengths = __commonJS({
    "node_modules/mathjax-full/js/util/lengths.js"(exports) {
      "use strict";
      Object.defineProperty(exports, "__esModule", { value: true });
      exports.px = exports.emRounded = exports.em = exports.percent = exports.length2em = exports.MATHSPACE = exports.RELUNITS = exports.UNITS = exports.BIGDIMEN = void 0;
      exports.BIGDIMEN = 1e6;
      exports.UNITS = {
        px: 1,
        "in": 96,
        cm: 96 / 2.54,
        mm: 96 / 25.4
      };
      exports.RELUNITS = {
        em: 1,
        ex: 0.431,
        pt: 1 / 10,
        pc: 12 / 10,
        mu: 1 / 18
      };
      exports.MATHSPACE = {
        veryverythinmathspace: 1 / 18,
        verythinmathspace: 2 / 18,
        thinmathspace: 3 / 18,
        mediummathspace: 4 / 18,
        thickmathspace: 5 / 18,
        verythickmathspace: 6 / 18,
        veryverythickmathspace: 7 / 18,
        negativeveryverythinmathspace: -1 / 18,
        negativeverythinmathspace: -2 / 18,
        negativethinmathspace: -3 / 18,
        negativemediummathspace: -4 / 18,
        negativethickmathspace: -5 / 18,
        negativeverythickmathspace: -6 / 18,
        negativeveryverythickmathspace: -7 / 18,
        thin: 0.04,
        medium: 0.06,
        thick: 0.1,
        normal: 1,
        big: 2,
        small: 1 / Math.sqrt(2),
        infinity: exports.BIGDIMEN
      };
      function length2em(length, size, scale, em2) {
        if (size === void 0) {
          size = 0;
        }
        if (scale === void 0) {
          scale = 1;
        }
        if (em2 === void 0) {
          em2 = 16;
        }
        if (typeof length !== "string") {
          length = String(length);
        }
        if (length === "" || length == null) {
          return size;
        }
        if (exports.MATHSPACE[length]) {
          return exports.MATHSPACE[length];
        }
        var match = length.match(/^\s*([-+]?(?:\.\d+|\d+(?:\.\d*)?))?(pt|em|ex|mu|px|pc|in|mm|cm|%)?/);
        if (!match) {
          return size;
        }
        var m = parseFloat(match[1] || "1"), unit = match[2];
        if (exports.UNITS.hasOwnProperty(unit)) {
          return m * exports.UNITS[unit] / em2 / scale;
        }
        if (exports.RELUNITS.hasOwnProperty(unit)) {
          return m * exports.RELUNITS[unit];
        }
        if (unit === "%") {
          return m / 100 * size;
        }
        return m * size;
      }
      exports.length2em = length2em;
      function percent(m) {
        return (100 * m).toFixed(1).replace(/\.?0+$/, "") + "%";
      }
      exports.percent = percent;
      function em(m) {
        if (Math.abs(m) < 1e-3)
          return "0";
        return m.toFixed(3).replace(/\.?0+$/, "") + "em";
      }
      exports.em = em;
      function emRounded(m, em2) {
        if (em2 === void 0) {
          em2 = 16;
        }
        m = (Math.round(m * em2) + 0.05) / em2;
        if (Math.abs(m) < 1e-3)
          return "0em";
        return m.toFixed(3).replace(/\.?0+$/, "") + "em";
      }
      exports.emRounded = emRounded;
      function px(m, M, em2) {
        if (M === void 0) {
          M = -exports.BIGDIMEN;
        }
        if (em2 === void 0) {
          em2 = 16;
        }
        m *= em2;
        if (M && m < M)
          m = M;
        if (Math.abs(m) < 0.1)
          return "0";
        return m.toFixed(1).replace(/\.0$/, "") + "px";
      }
      exports.px = px;
    }
  });

  // node_modules/mathjax-full/js/input/tex/base/BaseMethods.js
  var require_BaseMethods = __commonJS({
    "node_modules/mathjax-full/js/input/tex/base/BaseMethods.js"(exports) {
      "use strict";
      var __assign2 = exports && exports.__assign || function() {
        __assign2 = Object.assign || function(t) {
          for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s)
              if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
          }
          return t;
        };
        return __assign2.apply(this, arguments);
      };
      var __createBinding2 = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
        if (k2 === void 0)
          k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
          desc = { enumerable: true, get: function() {
            return m[k];
          } };
        }
        Object.defineProperty(o, k2, desc);
      } : function(o, m, k, k2) {
        if (k2 === void 0)
          k2 = k;
        o[k2] = m[k];
      });
      var __setModuleDefault2 = exports && exports.__setModuleDefault || (Object.create ? function(o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
      } : function(o, v) {
        o["default"] = v;
      });
      var __importStar2 = exports && exports.__importStar || function(mod) {
        if (mod && mod.__esModule)
          return mod;
        var result = {};
        if (mod != null) {
          for (var k in mod)
            if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
              __createBinding2(result, mod, k);
        }
        __setModuleDefault2(result, mod);
        return result;
      };
      var __read2 = exports && exports.__read || function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      var __importDefault2 = exports && exports.__importDefault || function(mod) {
        return mod && mod.__esModule ? mod : { "default": mod };
      };
      Object.defineProperty(exports, "__esModule", { value: true });
      var sitem = __importStar2(require_BaseItems());
      var NodeUtil_js_1 = __importDefault2(require_NodeUtil());
      var TexError_js_1 = __importDefault2(require_TexError());
      var TexParser_js_1 = __importDefault2(require_TexParser());
      var TexConstants_js_1 = require_TexConstants();
      var ParseUtil_js_1 = __importDefault2(require_ParseUtil());
      var MmlNode_js_1 = require_MmlNode();
      var Tags_js_1 = require_Tags();
      var lengths_js_1 = require_lengths();
      var Entities_js_1 = require_Entities();
      var Options_js_1 = require_Options();
      var BaseMethods = {};
      var P_HEIGHT = 1.2 / 0.85;
      var MmlTokenAllow = {
        fontfamily: 1,
        fontsize: 1,
        fontweight: 1,
        fontstyle: 1,
        color: 1,
        background: 1,
        id: 1,
        "class": 1,
        href: 1,
        style: 1
      };
      BaseMethods.Open = function(parser, _c) {
        parser.Push(parser.itemFactory.create("open"));
      };
      BaseMethods.Close = function(parser, _c) {
        parser.Push(parser.itemFactory.create("close"));
      };
      BaseMethods.Tilde = function(parser, _c) {
        parser.Push(parser.create("token", "mtext", {}, Entities_js_1.entities.nbsp));
      };
      BaseMethods.Space = function(_parser, _c) {
      };
      BaseMethods.Superscript = function(parser, _c) {
        var _a;
        if (parser.GetNext().match(/\d/)) {
          parser.string = parser.string.substr(0, parser.i + 1) + " " + parser.string.substr(parser.i + 1);
        }
        var primes;
        var base;
        var top = parser.stack.Top();
        if (top.isKind("prime")) {
          _a = __read2(top.Peek(2), 2), base = _a[0], primes = _a[1];
          parser.stack.Pop();
        } else {
          base = parser.stack.Prev();
          if (!base) {
            base = parser.create("token", "mi", {}, "");
          }
        }
        var movesupsub = NodeUtil_js_1.default.getProperty(base, "movesupsub");
        var position = NodeUtil_js_1.default.isType(base, "msubsup") ? base.sup : base.over;
        if (NodeUtil_js_1.default.isType(base, "msubsup") && !NodeUtil_js_1.default.isType(base, "msup") && NodeUtil_js_1.default.getChildAt(base, base.sup) || NodeUtil_js_1.default.isType(base, "munderover") && !NodeUtil_js_1.default.isType(base, "mover") && NodeUtil_js_1.default.getChildAt(base, base.over) && !NodeUtil_js_1.default.getProperty(base, "subsupOK")) {
          throw new TexError_js_1.default("DoubleExponent", "Double exponent: use braces to clarify");
        }
        if (!NodeUtil_js_1.default.isType(base, "msubsup") || NodeUtil_js_1.default.isType(base, "msup")) {
          if (movesupsub) {
            if (!NodeUtil_js_1.default.isType(base, "munderover") || NodeUtil_js_1.default.isType(base, "mover") || NodeUtil_js_1.default.getChildAt(base, base.over)) {
              base = parser.create("node", "munderover", [base], { movesupsub: true });
            }
            position = base.over;
          } else {
            base = parser.create("node", "msubsup", [base]);
            position = base.sup;
          }
        }
        parser.Push(parser.itemFactory.create("subsup", base).setProperties({
          position,
          primes,
          movesupsub
        }));
      };
      BaseMethods.Subscript = function(parser, _c) {
        var _a;
        if (parser.GetNext().match(/\d/)) {
          parser.string = parser.string.substr(0, parser.i + 1) + " " + parser.string.substr(parser.i + 1);
        }
        var primes, base;
        var top = parser.stack.Top();
        if (top.isKind("prime")) {
          _a = __read2(top.Peek(2), 2), base = _a[0], primes = _a[1];
          parser.stack.Pop();
        } else {
          base = parser.stack.Prev();
          if (!base) {
            base = parser.create("token", "mi", {}, "");
          }
        }
        var movesupsub = NodeUtil_js_1.default.getProperty(base, "movesupsub");
        var position = NodeUtil_js_1.default.isType(base, "msubsup") ? base.sub : base.under;
        if (NodeUtil_js_1.default.isType(base, "msubsup") && !NodeUtil_js_1.default.isType(base, "msup") && NodeUtil_js_1.default.getChildAt(base, base.sub) || NodeUtil_js_1.default.isType(base, "munderover") && !NodeUtil_js_1.default.isType(base, "mover") && NodeUtil_js_1.default.getChildAt(base, base.under) && !NodeUtil_js_1.default.getProperty(base, "subsupOK")) {
          throw new TexError_js_1.default("DoubleSubscripts", "Double subscripts: use braces to clarify");
        }
        if (!NodeUtil_js_1.default.isType(base, "msubsup") || NodeUtil_js_1.default.isType(base, "msup")) {
          if (movesupsub) {
            if (!NodeUtil_js_1.default.isType(base, "munderover") || NodeUtil_js_1.default.isType(base, "mover") || NodeUtil_js_1.default.getChildAt(base, base.under)) {
              base = parser.create("node", "munderover", [base], { movesupsub: true });
            }
            position = base.under;
          } else {
            base = parser.create("node", "msubsup", [base]);
            position = base.sub;
          }
        }
        parser.Push(parser.itemFactory.create("subsup", base).setProperties({
          position,
          primes,
          movesupsub
        }));
      };
      BaseMethods.Prime = function(parser, c) {
        var base = parser.stack.Prev();
        if (!base) {
          base = parser.create("node", "mi");
        }
        if (NodeUtil_js_1.default.isType(base, "msubsup") && !NodeUtil_js_1.default.isType(base, "msup") && NodeUtil_js_1.default.getChildAt(base, base.sup)) {
          throw new TexError_js_1.default("DoubleExponentPrime", "Prime causes double exponent: use braces to clarify");
        }
        var sup = "";
        parser.i--;
        do {
          sup += Entities_js_1.entities.prime;
          parser.i++, c = parser.GetNext();
        } while (c === "'" || c === Entities_js_1.entities.rsquo);
        sup = ["", "\u2032", "\u2033", "\u2034", "\u2057"][sup.length] || sup;
        var node = parser.create("token", "mo", { variantForm: true }, sup);
        parser.Push(parser.itemFactory.create("prime", base, node));
      };
      BaseMethods.Comment = function(parser, _c) {
        while (parser.i < parser.string.length && parser.string.charAt(parser.i) !== "\n") {
          parser.i++;
        }
      };
      BaseMethods.Hash = function(_parser, _c) {
        throw new TexError_js_1.default("CantUseHash1", "You can't use 'macro parameter character #' in math mode");
      };
      BaseMethods.MathFont = function(parser, name, variant) {
        var text = parser.GetArgument(name);
        var mml = new TexParser_js_1.default(text, __assign2(__assign2({}, parser.stack.env), { font: variant, multiLetterIdentifiers: /^[a-zA-Z]+/, noAutoOP: true }), parser.configuration).mml();
        parser.Push(parser.create("node", "TeXAtom", [mml]));
      };
      BaseMethods.SetFont = function(parser, _name, font) {
        parser.stack.env["font"] = font;
      };
      BaseMethods.SetStyle = function(parser, _name, texStyle, style, level) {
        parser.stack.env["style"] = texStyle;
        parser.stack.env["level"] = level;
        parser.Push(parser.itemFactory.create("style").setProperty("styles", { displaystyle: style, scriptlevel: level }));
      };
      BaseMethods.SetSize = function(parser, _name, size) {
        parser.stack.env["size"] = size;
        parser.Push(parser.itemFactory.create("style").setProperty("styles", { mathsize: (0, lengths_js_1.em)(size) }));
      };
      BaseMethods.Spacer = function(parser, _name, space) {
        var node = parser.create("node", "mspace", [], { width: (0, lengths_js_1.em)(space) });
        var style = parser.create("node", "mstyle", [node], { scriptlevel: 0 });
        parser.Push(style);
      };
      BaseMethods.LeftRight = function(parser, name) {
        var first = name.substr(1);
        parser.Push(parser.itemFactory.create(first, parser.GetDelimiter(name), parser.stack.env.color));
      };
      BaseMethods.NamedFn = function(parser, name, id) {
        if (!id) {
          id = name.substr(1);
        }
        var mml = parser.create("token", "mi", { texClass: MmlNode_js_1.TEXCLASS.OP }, id);
        parser.Push(parser.itemFactory.create("fn", mml));
      };
      BaseMethods.NamedOp = function(parser, name, id) {
        if (!id) {
          id = name.substr(1);
        }
        id = id.replace(/&thinsp;/, "\u2006");
        var mml = parser.create("token", "mo", {
          movablelimits: true,
          movesupsub: true,
          form: TexConstants_js_1.TexConstant.Form.PREFIX,
          texClass: MmlNode_js_1.TEXCLASS.OP
        }, id);
        parser.Push(mml);
      };
      BaseMethods.Limits = function(parser, _name, limits) {
        var op = parser.stack.Prev(true);
        if (!op || NodeUtil_js_1.default.getTexClass(NodeUtil_js_1.default.getCoreMO(op)) !== MmlNode_js_1.TEXCLASS.OP && NodeUtil_js_1.default.getProperty(op, "movesupsub") == null) {
          throw new TexError_js_1.default("MisplacedLimits", "%1 is allowed only on operators", parser.currentCS);
        }
        var top = parser.stack.Top();
        var node;
        if (NodeUtil_js_1.default.isType(op, "munderover") && !limits) {
          node = parser.create("node", "msubsup");
          NodeUtil_js_1.default.copyChildren(op, node);
          op = top.Last = node;
        } else if (NodeUtil_js_1.default.isType(op, "msubsup") && limits) {
          node = parser.create("node", "munderover");
          NodeUtil_js_1.default.copyChildren(op, node);
          op = top.Last = node;
        }
        NodeUtil_js_1.default.setProperty(op, "movesupsub", limits ? true : false);
        NodeUtil_js_1.default.setProperties(NodeUtil_js_1.default.getCoreMO(op), { "movablelimits": false });
        if (NodeUtil_js_1.default.getAttribute(op, "movablelimits") || NodeUtil_js_1.default.getProperty(op, "movablelimits")) {
          NodeUtil_js_1.default.setProperties(op, { "movablelimits": false });
        }
      };
      BaseMethods.Over = function(parser, name, open, close) {
        var mml = parser.itemFactory.create("over").setProperty("name", parser.currentCS);
        if (open || close) {
          mml.setProperty("open", open);
          mml.setProperty("close", close);
        } else if (name.match(/withdelims$/)) {
          mml.setProperty("open", parser.GetDelimiter(name));
          mml.setProperty("close", parser.GetDelimiter(name));
        }
        if (name.match(/^\\above/)) {
          mml.setProperty("thickness", parser.GetDimen(name));
        } else if (name.match(/^\\atop/) || open || close) {
          mml.setProperty("thickness", 0);
        }
        parser.Push(mml);
      };
      BaseMethods.Frac = function(parser, name) {
        var num = parser.ParseArg(name);
        var den = parser.ParseArg(name);
        var node = parser.create("node", "mfrac", [num, den]);
        parser.Push(node);
      };
      BaseMethods.Sqrt = function(parser, name) {
        var n = parser.GetBrackets(name);
        var arg = parser.GetArgument(name);
        if (arg === "\\frac") {
          arg += "{" + parser.GetArgument(arg) + "}{" + parser.GetArgument(arg) + "}";
        }
        var mml = new TexParser_js_1.default(arg, parser.stack.env, parser.configuration).mml();
        if (!n) {
          mml = parser.create("node", "msqrt", [mml]);
        } else {
          mml = parser.create("node", "mroot", [mml, parseRoot(parser, n)]);
        }
        parser.Push(mml);
      };
      function parseRoot(parser, n) {
        var env = parser.stack.env;
        var inRoot = env["inRoot"];
        env["inRoot"] = true;
        var newParser = new TexParser_js_1.default(n, env, parser.configuration);
        var node = newParser.mml();
        var global2 = newParser.stack.global;
        if (global2["leftRoot"] || global2["upRoot"]) {
          var def = {};
          if (global2["leftRoot"]) {
            def["width"] = global2["leftRoot"];
          }
          if (global2["upRoot"]) {
            def["voffset"] = global2["upRoot"];
            def["height"] = global2["upRoot"];
          }
          node = parser.create("node", "mpadded", [node], def);
        }
        env["inRoot"] = inRoot;
        return node;
      }
      BaseMethods.Root = function(parser, name) {
        var n = parser.GetUpTo(name, "\\of");
        var arg = parser.ParseArg(name);
        var node = parser.create("node", "mroot", [arg, parseRoot(parser, n)]);
        parser.Push(node);
      };
      BaseMethods.MoveRoot = function(parser, name, id) {
        if (!parser.stack.env["inRoot"]) {
          throw new TexError_js_1.default("MisplacedMoveRoot", "%1 can appear only within a root", parser.currentCS);
        }
        if (parser.stack.global[id]) {
          throw new TexError_js_1.default("MultipleMoveRoot", "Multiple use of %1", parser.currentCS);
        }
        var n = parser.GetArgument(name);
        if (!n.match(/-?[0-9]+/)) {
          throw new TexError_js_1.default("IntegerArg", "The argument to %1 must be an integer", parser.currentCS);
        }
        n = parseInt(n, 10) / 15 + "em";
        if (n.substr(0, 1) !== "-") {
          n = "+" + n;
        }
        parser.stack.global[id] = n;
      };
      BaseMethods.Accent = function(parser, name, accent, stretchy) {
        var c = parser.ParseArg(name);
        var def = __assign2(__assign2({}, ParseUtil_js_1.default.getFontDef(parser)), { accent: true, mathaccent: true });
        var entity = NodeUtil_js_1.default.createEntity(accent);
        var moNode = parser.create("token", "mo", def, entity);
        var mml = moNode;
        NodeUtil_js_1.default.setAttribute(mml, "stretchy", stretchy ? true : false);
        var mo = NodeUtil_js_1.default.isEmbellished(c) ? NodeUtil_js_1.default.getCoreMO(c) : c;
        if (NodeUtil_js_1.default.isType(mo, "mo") || NodeUtil_js_1.default.getProperty(mo, "movablelimits")) {
          NodeUtil_js_1.default.setProperties(mo, { "movablelimits": false });
        }
        var muoNode = parser.create("node", "munderover");
        NodeUtil_js_1.default.setChild(muoNode, 0, c);
        NodeUtil_js_1.default.setChild(muoNode, 1, null);
        NodeUtil_js_1.default.setChild(muoNode, 2, mml);
        var texAtom = parser.create("node", "TeXAtom", [muoNode]);
        parser.Push(texAtom);
      };
      BaseMethods.UnderOver = function(parser, name, c, stack) {
        var entity = NodeUtil_js_1.default.createEntity(c);
        var mo = parser.create("token", "mo", { stretchy: true, accent: true }, entity);
        var pos = name.charAt(1) === "o" ? "over" : "under";
        var base = parser.ParseArg(name);
        parser.Push(ParseUtil_js_1.default.underOver(parser, base, mo, pos, stack));
      };
      BaseMethods.Overset = function(parser, name) {
        var top = parser.ParseArg(name);
        var base = parser.ParseArg(name);
        ParseUtil_js_1.default.checkMovableLimits(base);
        if (top.isKind("mo")) {
          NodeUtil_js_1.default.setAttribute(top, "accent", false);
        }
        var node = parser.create("node", "mover", [base, top]);
        parser.Push(node);
      };
      BaseMethods.Underset = function(parser, name) {
        var bot = parser.ParseArg(name);
        var base = parser.ParseArg(name);
        ParseUtil_js_1.default.checkMovableLimits(base);
        if (bot.isKind("mo")) {
          NodeUtil_js_1.default.setAttribute(bot, "accent", false);
        }
        var node = parser.create("node", "munder", [base, bot], { accentunder: false });
        parser.Push(node);
      };
      BaseMethods.Overunderset = function(parser, name) {
        var top = parser.ParseArg(name);
        var bot = parser.ParseArg(name);
        var base = parser.ParseArg(name);
        ParseUtil_js_1.default.checkMovableLimits(base);
        if (top.isKind("mo")) {
          NodeUtil_js_1.default.setAttribute(top, "accent", false);
        }
        if (bot.isKind("mo")) {
          NodeUtil_js_1.default.setAttribute(bot, "accent", false);
        }
        var node = parser.create("node", "munderover", [base, bot, top], { accent: false, accentunder: false });
        parser.Push(node);
      };
      BaseMethods.TeXAtom = function(parser, name, mclass) {
        var def = { texClass: mclass };
        var mml;
        var node;
        var parsed;
        if (mclass === MmlNode_js_1.TEXCLASS.OP) {
          def["movesupsub"] = def["movablelimits"] = true;
          var arg = parser.GetArgument(name);
          var match = arg.match(/^\s*\\rm\s+([a-zA-Z0-9 ]+)$/);
          if (match) {
            def["mathvariant"] = TexConstants_js_1.TexConstant.Variant.NORMAL;
            node = parser.create("token", "mi", def, match[1]);
          } else {
            parsed = new TexParser_js_1.default(arg, parser.stack.env, parser.configuration).mml();
            node = parser.create("node", "TeXAtom", [parsed], def);
          }
          mml = parser.itemFactory.create("fn", node);
        } else {
          parsed = parser.ParseArg(name);
          mml = parser.create("node", "TeXAtom", [parsed], def);
        }
        parser.Push(mml);
      };
      BaseMethods.MmlToken = function(parser, name) {
        var kind = parser.GetArgument(name);
        var attr = parser.GetBrackets(name, "").replace(/^\s+/, "");
        var text = parser.GetArgument(name);
        var def = {};
        var keep = [];
        var node;
        try {
          node = parser.create("node", kind);
        } catch (e) {
          node = null;
        }
        if (!node || !node.isToken) {
          throw new TexError_js_1.default("NotMathMLToken", "%1 is not a token element", kind);
        }
        while (attr !== "") {
          var match = attr.match(/^([a-z]+)\s*=\s*('[^']*'|"[^"]*"|[^ ,]*)\s*,?\s*/i);
          if (!match) {
            throw new TexError_js_1.default("InvalidMathMLAttr", "Invalid MathML attribute: %1", attr);
          }
          if (!node.attributes.hasDefault(match[1]) && !MmlTokenAllow[match[1]]) {
            throw new TexError_js_1.default("UnknownAttrForElement", "%1 is not a recognized attribute for %2", match[1], kind);
          }
          var value = ParseUtil_js_1.default.MmlFilterAttribute(parser, match[1], match[2].replace(/^(['"])(.*)\1$/, "$2"));
          if (value) {
            if (value.toLowerCase() === "true") {
              value = true;
            } else if (value.toLowerCase() === "false") {
              value = false;
            }
            def[match[1]] = value;
            keep.push(match[1]);
          }
          attr = attr.substr(match[0].length);
        }
        if (keep.length) {
          def["mjx-keep-attrs"] = keep.join(" ");
        }
        var textNode = parser.create("text", text);
        node.appendChild(textNode);
        NodeUtil_js_1.default.setProperties(node, def);
        parser.Push(node);
      };
      BaseMethods.Strut = function(parser, _name) {
        var row = parser.create("node", "mrow");
        var padded = parser.create("node", "mpadded", [row], { height: "8.6pt", depth: "3pt", width: 0 });
        parser.Push(padded);
      };
      BaseMethods.Phantom = function(parser, name, v, h) {
        var box = parser.create("node", "mphantom", [parser.ParseArg(name)]);
        if (v || h) {
          box = parser.create("node", "mpadded", [box]);
          if (h) {
            NodeUtil_js_1.default.setAttribute(box, "height", 0);
            NodeUtil_js_1.default.setAttribute(box, "depth", 0);
          }
          if (v) {
            NodeUtil_js_1.default.setAttribute(box, "width", 0);
          }
        }
        var atom = parser.create("node", "TeXAtom", [box]);
        parser.Push(atom);
      };
      BaseMethods.Smash = function(parser, name) {
        var bt = ParseUtil_js_1.default.trimSpaces(parser.GetBrackets(name, ""));
        var smash = parser.create("node", "mpadded", [parser.ParseArg(name)]);
        switch (bt) {
          case "b":
            NodeUtil_js_1.default.setAttribute(smash, "depth", 0);
            break;
          case "t":
            NodeUtil_js_1.default.setAttribute(smash, "height", 0);
            break;
          default:
            NodeUtil_js_1.default.setAttribute(smash, "height", 0);
            NodeUtil_js_1.default.setAttribute(smash, "depth", 0);
        }
        var atom = parser.create("node", "TeXAtom", [smash]);
        parser.Push(atom);
      };
      BaseMethods.Lap = function(parser, name) {
        var mml = parser.create("node", "mpadded", [parser.ParseArg(name)], { width: 0 });
        if (name === "\\llap") {
          NodeUtil_js_1.default.setAttribute(mml, "lspace", "-1width");
        }
        var atom = parser.create("node", "TeXAtom", [mml]);
        parser.Push(atom);
      };
      BaseMethods.RaiseLower = function(parser, name) {
        var h = parser.GetDimen(name);
        var item = parser.itemFactory.create("position").setProperties({ name: parser.currentCS, move: "vertical" });
        if (h.charAt(0) === "-") {
          h = h.slice(1);
          name = name.substr(1) === "raise" ? "\\lower" : "\\raise";
        }
        if (name === "\\lower") {
          item.setProperty("dh", "-" + h);
          item.setProperty("dd", "+" + h);
        } else {
          item.setProperty("dh", "+" + h);
          item.setProperty("dd", "-" + h);
        }
        parser.Push(item);
      };
      BaseMethods.MoveLeftRight = function(parser, name) {
        var h = parser.GetDimen(name);
        var nh = h.charAt(0) === "-" ? h.slice(1) : "-" + h;
        if (name === "\\moveleft") {
          var tmp = h;
          h = nh;
          nh = tmp;
        }
        parser.Push(parser.itemFactory.create("position").setProperties({
          name: parser.currentCS,
          move: "horizontal",
          left: parser.create("node", "mspace", [], { width: h }),
          right: parser.create("node", "mspace", [], { width: nh })
        }));
      };
      BaseMethods.Hskip = function(parser, name) {
        var node = parser.create("node", "mspace", [], { width: parser.GetDimen(name) });
        parser.Push(node);
      };
      BaseMethods.Nonscript = function(parser, _name) {
        parser.Push(parser.itemFactory.create("nonscript"));
      };
      BaseMethods.Rule = function(parser, name, style) {
        var w = parser.GetDimen(name), h = parser.GetDimen(name), d = parser.GetDimen(name);
        var def = { width: w, height: h, depth: d };
        if (style !== "blank") {
          def["mathbackground"] = parser.stack.env["color"] || "black";
        }
        var node = parser.create("node", "mspace", [], def);
        parser.Push(node);
      };
      BaseMethods.rule = function(parser, name) {
        var v = parser.GetBrackets(name), w = parser.GetDimen(name), h = parser.GetDimen(name);
        var mml = parser.create("node", "mspace", [], {
          width: w,
          height: h,
          mathbackground: parser.stack.env["color"] || "black"
        });
        if (v) {
          mml = parser.create("node", "mpadded", [mml], { voffset: v });
          if (v.match(/^\-/)) {
            NodeUtil_js_1.default.setAttribute(mml, "height", v);
            NodeUtil_js_1.default.setAttribute(mml, "depth", "+" + v.substr(1));
          } else {
            NodeUtil_js_1.default.setAttribute(mml, "height", "+" + v);
          }
        }
        parser.Push(mml);
      };
      BaseMethods.MakeBig = function(parser, name, mclass, size) {
        size *= P_HEIGHT;
        var sizeStr = String(size).replace(/(\.\d\d\d).+/, "$1") + "em";
        var delim = parser.GetDelimiter(name, true);
        var mo = parser.create("token", "mo", {
          minsize: sizeStr,
          maxsize: sizeStr,
          fence: true,
          stretchy: true,
          symmetric: true
        }, delim);
        var node = parser.create("node", "TeXAtom", [mo], { texClass: mclass });
        parser.Push(node);
      };
      BaseMethods.BuildRel = function(parser, name) {
        var top = parser.ParseUpTo(name, "\\over");
        var bot = parser.ParseArg(name);
        var node = parser.create("node", "munderover");
        NodeUtil_js_1.default.setChild(node, 0, bot);
        NodeUtil_js_1.default.setChild(node, 1, null);
        NodeUtil_js_1.default.setChild(node, 2, top);
        var atom = parser.create("node", "TeXAtom", [node], { texClass: MmlNode_js_1.TEXCLASS.REL });
        parser.Push(atom);
      };
      BaseMethods.HBox = function(parser, name, style, font) {
        parser.PushAll(ParseUtil_js_1.default.internalMath(parser, parser.GetArgument(name), style, font));
      };
      BaseMethods.FBox = function(parser, name) {
        var internal = ParseUtil_js_1.default.internalMath(parser, parser.GetArgument(name));
        var node = parser.create("node", "menclose", internal, { notation: "box" });
        parser.Push(node);
      };
      BaseMethods.FrameBox = function(parser, name) {
        var width = parser.GetBrackets(name);
        var pos = parser.GetBrackets(name) || "c";
        var mml = ParseUtil_js_1.default.internalMath(parser, parser.GetArgument(name));
        if (width) {
          mml = [parser.create("node", "mpadded", mml, {
            width,
            "data-align": (0, Options_js_1.lookup)(pos, { l: "left", r: "right" }, "center")
          })];
        }
        var node = parser.create("node", "TeXAtom", [parser.create("node", "menclose", mml, { notation: "box" })], { texClass: MmlNode_js_1.TEXCLASS.ORD });
        parser.Push(node);
      };
      BaseMethods.Not = function(parser, _name) {
        parser.Push(parser.itemFactory.create("not"));
      };
      BaseMethods.Dots = function(parser, _name) {
        var ldotsEntity = NodeUtil_js_1.default.createEntity("2026");
        var cdotsEntity = NodeUtil_js_1.default.createEntity("22EF");
        var ldots = parser.create("token", "mo", { stretchy: false }, ldotsEntity);
        var cdots = parser.create("token", "mo", { stretchy: false }, cdotsEntity);
        parser.Push(parser.itemFactory.create("dots").setProperties({
          ldots,
          cdots
        }));
      };
      BaseMethods.Matrix = function(parser, _name, open, close, align, spacing, vspacing, style, cases, numbered) {
        var c = parser.GetNext();
        if (c === "") {
          throw new TexError_js_1.default("MissingArgFor", "Missing argument for %1", parser.currentCS);
        }
        if (c === "{") {
          parser.i++;
        } else {
          parser.string = c + "}" + parser.string.slice(parser.i + 1);
          parser.i = 0;
        }
        var array = parser.itemFactory.create("array").setProperty("requireClose", true);
        array.arraydef = {
          rowspacing: vspacing || "4pt",
          columnspacing: spacing || "1em"
        };
        if (cases) {
          array.setProperty("isCases", true);
        }
        if (numbered) {
          array.setProperty("isNumbered", true);
          array.arraydef.side = numbered;
        }
        if (open || close) {
          array.setProperty("open", open);
          array.setProperty("close", close);
        }
        if (style === "D") {
          array.arraydef.displaystyle = true;
        }
        if (align != null) {
          array.arraydef.columnalign = align;
        }
        parser.Push(array);
      };
      BaseMethods.Entry = function(parser, name) {
        parser.Push(parser.itemFactory.create("cell").setProperties({ isEntry: true, name }));
        var top = parser.stack.Top();
        var env = top.getProperty("casesEnv");
        var cases = top.getProperty("isCases");
        if (!cases && !env)
          return;
        var str = parser.string;
        var braces = 0, close = -1, i = parser.i, m = str.length;
        var end = env ? new RegExp("^\\\\end\\s*\\{".concat(env.replace(/\*/, "\\*"), "\\}")) : null;
        while (i < m) {
          var c = str.charAt(i);
          if (c === "{") {
            braces++;
            i++;
          } else if (c === "}") {
            if (braces === 0) {
              m = 0;
            } else {
              braces--;
              if (braces === 0 && close < 0) {
                close = i - parser.i;
              }
              i++;
            }
          } else if (c === "&" && braces === 0) {
            throw new TexError_js_1.default("ExtraAlignTab", "Extra alignment tab in \\cases text");
          } else if (c === "\\") {
            var rest = str.substr(i);
            if (rest.match(/^((\\cr)[^a-zA-Z]|\\\\)/) || end && rest.match(end)) {
              m = 0;
            } else {
              i += 2;
            }
          } else {
            i++;
          }
        }
        var text = str.substr(parser.i, i - parser.i);
        if (!text.match(/^\s*\\text[^a-zA-Z]/) || close !== text.replace(/\s+$/, "").length - 1) {
          var internal = ParseUtil_js_1.default.internalMath(parser, ParseUtil_js_1.default.trimSpaces(text), 0);
          parser.PushAll(internal);
          parser.i = i;
        }
      };
      BaseMethods.Cr = function(parser, name) {
        parser.Push(parser.itemFactory.create("cell").setProperties({ isCR: true, name }));
      };
      BaseMethods.CrLaTeX = function(parser, name, nobrackets) {
        if (nobrackets === void 0) {
          nobrackets = false;
        }
        var n;
        if (!nobrackets) {
          if (parser.string.charAt(parser.i) === "*") {
            parser.i++;
          }
          if (parser.string.charAt(parser.i) === "[") {
            var dim = parser.GetBrackets(name, "");
            var _a = __read2(ParseUtil_js_1.default.matchDimen(dim), 2), value = _a[0], unit = _a[1];
            if (dim && !value) {
              throw new TexError_js_1.default("BracketMustBeDimension", "Bracket argument to %1 must be a dimension", parser.currentCS);
            }
            n = value + unit;
          }
        }
        parser.Push(parser.itemFactory.create("cell").setProperties({ isCR: true, name, linebreak: true }));
        var top = parser.stack.Top();
        var node;
        if (top instanceof sitem.ArrayItem) {
          if (n) {
            top.addRowSpacing(n);
          }
        } else {
          if (n) {
            node = parser.create("node", "mspace", [], { depth: n });
            parser.Push(node);
          }
          node = parser.create("node", "mspace", [], { linebreak: TexConstants_js_1.TexConstant.LineBreak.NEWLINE });
          parser.Push(node);
        }
      };
      BaseMethods.HLine = function(parser, _name, style) {
        if (style == null) {
          style = "solid";
        }
        var top = parser.stack.Top();
        if (!(top instanceof sitem.ArrayItem) || top.Size()) {
          throw new TexError_js_1.default("Misplaced", "Misplaced %1", parser.currentCS);
        }
        if (!top.table.length) {
          top.frame.push("top");
        } else {
          var lines = top.arraydef["rowlines"] ? top.arraydef["rowlines"].split(/ /) : [];
          while (lines.length < top.table.length) {
            lines.push("none");
          }
          lines[top.table.length - 1] = style;
          top.arraydef["rowlines"] = lines.join(" ");
        }
      };
      BaseMethods.HFill = function(parser, _name) {
        var top = parser.stack.Top();
        if (top instanceof sitem.ArrayItem) {
          top.hfill.push(top.Size());
        } else {
          throw new TexError_js_1.default("UnsupportedHFill", "Unsupported use of %1", parser.currentCS);
        }
      };
      BaseMethods.BeginEnd = function(parser, name) {
        var env = parser.GetArgument(name);
        if (env.match(/\\/i)) {
          throw new TexError_js_1.default("InvalidEnv", "Invalid environment name '%1'", env);
        }
        var macro = parser.configuration.handlers.get("environment").lookup(env);
        if (macro && name === "\\end") {
          if (!macro.args[0]) {
            var mml = parser.itemFactory.create("end").setProperty("name", env);
            parser.Push(mml);
            return;
          }
          parser.stack.env["closing"] = env;
        }
        ParseUtil_js_1.default.checkMaxMacros(parser, false);
        parser.parse("environment", [parser, env]);
      };
      BaseMethods.Array = function(parser, begin, open, close, align, spacing, vspacing, style, raggedHeight) {
        if (!align) {
          align = parser.GetArgument("\\begin{" + begin.getName() + "}");
        }
        var lines = ("c" + align).replace(/[^clr|:]/g, "").replace(/[^|:]([|:])+/g, "$1");
        align = align.replace(/[^clr]/g, "").split("").join(" ");
        align = align.replace(/l/g, "left").replace(/r/g, "right").replace(/c/g, "center");
        var array = parser.itemFactory.create("array");
        array.arraydef = {
          columnalign: align,
          columnspacing: spacing || "1em",
          rowspacing: vspacing || "4pt"
        };
        if (lines.match(/[|:]/)) {
          if (lines.charAt(0).match(/[|:]/)) {
            array.frame.push("left");
            array.dashed = lines.charAt(0) === ":";
          }
          if (lines.charAt(lines.length - 1).match(/[|:]/)) {
            array.frame.push("right");
          }
          lines = lines.substr(1, lines.length - 2);
          array.arraydef.columnlines = lines.split("").join(" ").replace(/[^|: ]/g, "none").replace(/\|/g, "solid").replace(/:/g, "dashed");
        }
        if (open) {
          array.setProperty("open", parser.convertDelimiter(open));
        }
        if (close) {
          array.setProperty("close", parser.convertDelimiter(close));
        }
        if ((style || "").charAt(1) === "'") {
          array.arraydef["data-cramped"] = true;
          style = style.charAt(0);
        }
        if (style === "D") {
          array.arraydef["displaystyle"] = true;
        } else if (style) {
          array.arraydef["displaystyle"] = false;
        }
        if (style === "S") {
          array.arraydef["scriptlevel"] = 1;
        }
        if (raggedHeight) {
          array.arraydef["useHeight"] = false;
        }
        parser.Push(begin);
        return array;
      };
      BaseMethods.AlignedArray = function(parser, begin) {
        var align = parser.GetBrackets("\\begin{" + begin.getName() + "}");
        var item = BaseMethods.Array(parser, begin);
        return ParseUtil_js_1.default.setArrayAlign(item, align);
      };
      BaseMethods.Equation = function(parser, begin, numbered) {
        parser.Push(begin);
        ParseUtil_js_1.default.checkEqnEnv(parser);
        return parser.itemFactory.create("equation", numbered).setProperty("name", begin.getName());
      };
      BaseMethods.EqnArray = function(parser, begin, numbered, taggable, align, spacing) {
        parser.Push(begin);
        if (taggable) {
          ParseUtil_js_1.default.checkEqnEnv(parser);
        }
        align = align.replace(/[^clr]/g, "").split("").join(" ");
        align = align.replace(/l/g, "left").replace(/r/g, "right").replace(/c/g, "center");
        var newItem = parser.itemFactory.create("eqnarray", begin.getName(), numbered, taggable, parser.stack.global);
        newItem.arraydef = {
          displaystyle: true,
          columnalign: align,
          columnspacing: spacing || "1em",
          rowspacing: "3pt",
          side: parser.options["tagSide"],
          minlabelspacing: parser.options["tagIndent"]
        };
        return newItem;
      };
      BaseMethods.HandleNoTag = function(parser, _name) {
        parser.tags.notag();
      };
      BaseMethods.HandleLabel = function(parser, name) {
        var label = parser.GetArgument(name);
        if (label === "") {
          return;
        }
        if (!parser.tags.refUpdate) {
          if (parser.tags.label) {
            throw new TexError_js_1.default("MultipleCommand", "Multiple %1", parser.currentCS);
          }
          parser.tags.label = label;
          if ((parser.tags.allLabels[label] || parser.tags.labels[label]) && !parser.options["ignoreDuplicateLabels"]) {
            throw new TexError_js_1.default("MultipleLabel", "Label '%1' multiply defined", label);
          }
          parser.tags.labels[label] = new Tags_js_1.Label();
        }
      };
      BaseMethods.HandleRef = function(parser, name, eqref) {
        var label = parser.GetArgument(name);
        var ref = parser.tags.allLabels[label] || parser.tags.labels[label];
        if (!ref) {
          if (!parser.tags.refUpdate) {
            parser.tags.redo = true;
          }
          ref = new Tags_js_1.Label();
        }
        var tag = ref.tag;
        if (eqref) {
  