import 'dart:io';

import 'package:drift/drift.dart';
import 'package:drift/native.dart';
import 'package:gpt_client/src/feature/app/database/drift_logger.dart';
import 'package:path/path.dart' as path;
import 'package:path_provider/path_provider.dart';

QueryExecutor openConnection(String name) => LazyDatabase(() async {
      final dbFolder = await getApplicationDocumentsDirectory();
      final file = File(path.join(dbFolder.path, '$name.sqlite'));

      return NativeDatabase(file, logStatements: IDriftLogger.shouldLog);
    });
