# Спецификация

1. Commit'ы должны начинаться с типа, который является существительным: `feat`, `fix`, и т.д., за которым следуют не обязательное указание scope, двоеточие и пробел
2. Scope может следовать после типа. Контекст должен быть существительным, заключенным в круглые скобки, описывающий часть кодовой базы, которую затронул commit. Например, `fix(parser):`
3. Описание должно следовать через пробел сразу же после типа/контекста. Описание - это краткая выжимка об изменениях кода. Например, `fix: array parsing issue when multiple spaces were contained in string`
4. Body commit'а может следовать после короткого описания, добавляя дополнительную информацию об изменениях в коде. Тело должно отделяться от короткого описания одной пустой строкой
5. Footer может быть представлен одной или несколькими строками после тела commit'а. Он должен быть отделен от тела commit'а одной пустой строкой. Подвал должен содержать мета-информацию о commit'е. Например, связанные pull-request'ы, обсуждения, изменения, нарушающие обратную совместимость. По одной мета-информации на строку
6. Изменения, нарушающие обратную совместимость (breaking changes), должны быть указаны в самом начале body или в начале одной из строк footer. Изменения, нарушающие обратную совместимость, должны начинаться с текста, написанного прописными буквами, `BREAKING CHANGE`, за которым должны следовать двоеточие и пробел
7. Описание изменений, нарушающих обратную совместимость, должно следовать после `BREAKING CHANGE:` . В нем должно содержаться то, что изменилось в API. Например, `BREAKING CHANGE: environment variables now take precedence over config files`
8. Единицы информации, которые составляют обычные commit'ы, не должны трактоваться разработчиками как регистрозависимые, за исключением `BREAKING CHANGE`, который всегда должен быть написан прописными буквами.
9. Знак `!` может быть добавлен перед `:` в тип/контекст, чтоб обратить внимание на изменения. Строка `BREAKING CHANGE: description` должна быть добавлена в тело (body) или подвал (footer), если используется `!` в префиксе.
10. Должен использоваться present tense (`add feature` not `added feature`)
11. Должен использоваться imperative mood (`move cursor to...` not `moves cursor to...`)
12. Не использовать теги в названии и в описании, так как падает workflow на отправку уведомлений в телеграм

# Структура

    <Тип>[Опциональный scope]: <Описание>
    
    [Опциональное тело]
    
    [Опциональный футер]

# Типы
- `feat` - используется для коммитов, связанных с добавлением новой функциональности или новых возможностей в проект.
- `fix` - используется для коммитов, связанных с исправлением ошибок или проблем в проекте.
- `chore` - используется для коммитов, связанных с обычными рутинными задачами, такими как обновление зависимостей, настройка среды разработки, изменение конфигурации и т.д.
- `refactor` - используется для коммитов, связанных с переработкой кода без исправления ошибок или добавления новой функциональности. Например, изменение структуры кода, оптимизация алгоритма, переименование переменных и т.п.
- `docs` - используется для коммитов, связанных с изменениями в документации проекта, например, обновление README-файла, добавление документации к коду, комментариев и т.д.
- `style` - используется для коммитов, связанных с изменением внешнего вида кода без влияния на его работу, например, форматирование кода с помощью Prettier, исправление опечаток и т.д.
- `move` - используется для коммитов, связанных с перемещением файлов в другую папку, например, для объединения блоков страницы, если они разбиты на отдельных файлы.
- `delete` - используется для коммитов, связанных с удалением неиспользуемых файлов.
- `test` - используется для коммитов, связанных с добавлением, изменением или исправлением тестов в проекте.

# Примеры

## Commit с описанием и изменениям, нарушающим обратную совместимость, в теле

    feat: allow provided config object to extend other configs
    
    BREAKING CHANGE: `extends` key in config file is now used for extending other config files

## Commit с не обязательным `!`, для того, чтобы привлечь внимание к изменениям, нарушающим обратную совместимость

    chore!: drop Node 6 from testing matrix
    
    BREAKING CHANGE: dropping Node 6 which hits end of life in April

## Commit без тела

    docs: correct spelling of CHANGELOG

## Commit с указанием контекста (scope)

    feat(lang): add polish language

## Commit, исправляющего ошибку (fix), использующее не обязательный номер задачи (issue) в багтрекере

    fix: correct minor typos in code
    
    see the issue for details on the typos fixed
    
    closes issue #12`