/** @file project_html_resources.h
 *  @brief HTML resources to build and serve a web browser based minimal user interface for VISE
 *  @author Abhishek Dutta <adutta _at_ robots.ox.ac.uk>
 *  @date 2 Feb. 2020
 */
#ifndef HTML_RESOURCES_H
#define HTML_RESOURCES_H

namespace vise {

    const char* const VISE_HTML_HEAD = R"HTML_STR(<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
    <meta http-equiv="Pragma" content="no-cache" />
    <meta http-equiv="Expires" content="0" />
    <title>VISE</title>
    <meta name="author" content="VGG Image Search Engine (VISE)">
    <meta name="description" content="Home page of VGG Image Search Engine (VISE). More details are available at the following website: http://www.robots.ox.ac.uk/~vgg/software/vise/">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" href="favicon.ico" type="image/x-icon">
    <link rel="stylesheet" type="text/css" href="vise.css">
  </head>
  <!-- This HTML header was automatically generated using "src/vise/html_resources.h" file -->
)HTML_STR";

  const char* const VISE_WAIT_PAGE_HEAD = R"HTML_STR(<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
    <meta http-equiv="Pragma" content="no-cache" />
    <meta http-equiv="Expires" content="0" />
    <title>VISE</title>
    <meta name="author" content="VGG Image Search Engine (VISE)">
    <meta name="description" content="Home page of VGG Image Search Engine (VISE). More details are available at the following website: http://www.robots.ox.ac.uk/~vgg/software/vise/">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" href="app/favicon.ico" type="image/x-icon">
    <link rel="stylesheet" type="text/css" href="app/vise.css">
    <meta http-equiv="refresh" content="3">
  </head>
  <!-- This HTML header was automatically generated using "src/vise/html_resources.h" file -->
)HTML_STR";

    const char* const PROJECT_HTML_HEAD = R"HTML_STR(<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
    <meta http-equiv="Pragma" content="no-cache" />
    <meta http-equiv="Expires" content="0" />
    <title></title>
    <meta name="author" content="VGG Image Search Engine (VISE)">
    <meta name="description" content="A project created using VGG Image Search Engine (VISE). More details are available at the following website: http://www.robots.ox.ac.uk/~vgg/software/vise/">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" href="app/favicon.ico" type="image/x-icon">
    <link rel="stylesheet" type="text/css" href="app/project.css">
  </head>
  <!-- This HTML header was automatically generated using "src/vise/html_resources.h" file -->
)HTML_STR";

    const char* const HTML_SVG_ASSETS = R"SVG(<svg style="display:none;" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
<!--
  SVG assets automatically generated by "src/vise/project_html_resources.h" file
  SVG assets name prefixed with "micon_" were downloaded from https://material.io/icons
-->
<defs>
  <symbol id="micon_home">
    <path d="M10 19v-5h4v5c0 .55.45 1 1 1h3c.55 0 1-.45 1-1v-7h1.7c.46 0 .68-.57.33-.87L12.67 3.6c-.38-.34-.96-.34-1.34 0l-8.36 7.53c-.34.3-.13.87.33.87H5v7c0 .55.45 1 1 1h3c.55 0 1-.45 1-1z"/>
  </symbol>

  <symbol id="micon_settings">
    <path d="M19.14,12.94c0.04-0.3,0.06-0.61,0.06-0.94c0-0.32-0.02-0.64-0.07-0.94l2.03-1.58c0.18-0.14,0.23-0.41,0.12-0.61 l-1.92-3.32c-0.12-0.22-0.37-0.29-0.59-0.22l-2.39,0.96c-0.5-0.38-1.03-0.7-1.62-0.94L14.4,2.81c-0.04-0.24-0.24-0.41-0.48-0.41 h-3.84c-0.24,0-0.43,0.17-0.47,0.41L9.25,5.35C8.66,5.59,8.12,5.92,7.63,6.29L5.24,5.33c-0.22-0.08-0.47,0-0.59,0.22L2.74,8.87 C2.62,9.08,2.66,9.34,2.86,9.48l2.03,1.58C4.84,11.36,4.8,11.69,4.8,12s0.02,0.64,0.07,0.94l-2.03,1.58 c-0.18,0.14-0.23,0.41-0.12,0.61l1.92,3.32c0.12,0.22,0.37,0.29,0.59,0.22l2.39-0.96c0.5,0.38,1.03,0.7,1.62,0.94l0.36,2.54 c0.05,0.24,0.24,0.41,0.48,0.41h3.84c0.24,0,0.44-0.17,0.47-0.41l0.36-2.54c0.59-0.24,1.13-0.56,1.62-0.94l2.39,0.96 c0.22,0.08,0.47,0,0.59-0.22l1.92-3.32c0.12-0.22,0.07-0.47-0.12-0.61L19.14,12.94z M12,15.6c-1.98,0-3.6-1.62-3.6-3.6 s1.62-3.6,3.6-3.6s3.6,1.62,3.6,3.6S13.98,15.6,12,15.6z"/>
  </symbol>

  <symbol id="micon_download">
    <path d="M16.59 9H15V4c0-.55-.45-1-1-1h-4c-.55 0-1 .45-1 1v5H7.41c-.89 0-1.34 1.08-.71 1.71l4.59 4.59c.39.39 1.02.39 1.41 0l4.59-4.59c.63-.63.19-1.71-.7-1.71zM5 19c0 .55.45 1 1 1h12c.55 0 1-.45 1-1s-.45-1-1-1H6c-.55 0-1 .45-1 1z"/>
  </symbol>

  <symbol id="micon_next">
    <path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"/>
  </symbol>
  <symbol id="micon_prev">
    <path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"/>
  </symbol>
  <symbol id="micon_zoomin">
    <path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"/>
    <path d="M12 10h-2v2H9v-2H7V9h2V7h1v2h2v1z"/>
  </symbol>
  <symbol id="micon_zoomout">
    <path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14zM7 9h5v1H7z"/>
  </symbol>
  <symbol id="micon_help">
    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 17h-2v-2h2v2zm2.07-7.75l-.9.92C13.45 12.9 13 13.5 13 15h-2v-.5c0-1.1.45-2.1 1.17-2.83l1.24-1.26c.37-.36.59-.86.59-1.41 0-1.1-.9-2-2-2s-2 .9-2 2H8c0-2.21 1.79-4 4-4s4 1.79 4 4c0 .88-.36 1.68-.93 2.25z"/>
  </symbol>
  <symbol id="micon_clear">
    <path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"/>
  </symbol>
  <symbol id="micon_image_search">
    <path d="M0 0h24v24H0V0z" fill="none"/><path d="M18 13v7H4V6h5.02c.05-.71.22-1.38.48-2H4c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-5l-2-2zm-1.5 5h-11l2.75-3.53 1.96 2.36 2.75-3.54zm2.8-9.11c.44-.7.7-1.51.7-2.39C20 4.01 17.99 2 15.5 2S11 4.01 11 6.5s2.01 4.5 4.49 4.5c.88 0 1.7-.26 2.39-.7L21 13.42 22.42 12 19.3 8.89zM15.5 9C14.12 9 13 7.88 13 6.5S14.12 4 15.5 4 18 5.12 18 6.5 16.88 9 15.5 9z"/>
  </symbol>
  <symbol id="micon_grid">
    <path d="M3 9h4V5H3v4zm0 5h4v-4H3v4zm5 0h4v-4H8v4zm5 0h4v-4h-4v4zM8 9h4V5H8v4zm5-4v4h4V5h-4zm5 9h4v-4h-4v4zM3 19h4v-4H3v4zm5 0h4v-4H8v4zm5 0h4v-4h-4v4zm5 0h4v-4h-4v4zm0-14v4h4V5h-4z"/>
  </symbol>
  <symbol id="micon_group">
    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zM8 17.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5zM9.5 8c0-1.38 1.12-2.5 2.5-2.5s2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5S9.5 9.38 9.5 8zm6.5 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
  </symbol>

  <!--
  VISE Logo designed by Abhishek Dutta, 28 Feb. 2020
  Font for text "VSE" : Quicksand, font-size=72, created using Inkscape
  -->
  <symbol id="vise_logo" viewBox="0 0 240 80">
    <g transform="translate(0 -275.83)">
      <g transform="matrix(.26458 0 0 .26458 -6.7343 231.43)" aria-label="V  SE">
        <path d="m258.2 193.29q4.7168 0 7.9824 3.2655 3.2655 2.9027 3.2655 6.8938 0 2.5398-1.0885 5.4425l-96.877 231.49q-1.4513 3.2655-4.354 5.4425-2.9027 1.8142-6.1682 1.8142-3.2655 0-6.1682-1.8142-2.5398-1.8142-3.9912-5.0797l-96.514-231.13q-1.0885-2.177-1.0885-5.8054 0-4.7168 3.2655-7.6195t7.2567-2.9027q7.6195 0 10.885 7.9824l87.443 208.99 85.992-209.72q1.8142-3.2655 4.354-5.0797 2.9027-2.177 5.8054-2.177z"/>
        <path d="m606.55 451.27q-26.124 0-46.443-8.708-19.956-8.708-38.823-27.213-4.354-3.6283-4.354-8.708 0-4.354 3.2655-7.9824 3.6283-3.6284 7.9824-3.6284 4.354 0 7.9824 3.6284 28.301 31.204 70.753 31.204 26.124 0 43.177-12.336 17.416-12.336 17.416-32.292 0-15.602-8.708-25.761-8.3452-10.522-22.133-17.053-13.788-6.531-35.195-13.425-23.221-6.8939-39.186-15.239-15.602-8.3452-25.398-22.133-9.7965-14.151-9.7965-35.558 0-19.23 10.159-34.106 10.522-14.876 29.027-23.221 18.867-8.708 43.177-8.708 22.133 0 41.363 7.6195 19.593 7.2567 31.204 21.044 5.4425 6.1682 5.4425 10.522 0 3.9912-3.6283 7.6195-3.6284 3.2655-7.9824 3.2655-3.6283 0-6.1682-2.5398-9.7965-11.611-26.124-18.867t-34.106-7.2567q-26.487 0-43.177 11.974-16.69 11.611-16.69 31.929 0 21.044 15.965 32.292 15.965 11.248 45.717 20.682 25.761 7.6195 42.089 15.602 16.328 7.9824 26.487 22.859 10.522 14.513 10.522 38.46 0 18.505-10.885 33.744-10.522 14.876-29.752 23.584-18.867 8.708-43.177 8.708z"/>
        <path d="m894.12 426.23q4.7168 0 7.6195 3.2655 3.2655 3.2655 3.2655 7.6195 0 4.7168-3.2655 7.6195-2.9027 2.9027-7.6195 2.9027h-133.16q-4.7168 0-7.9824-2.9027-2.9027-3.2655-2.9027-7.9824v-232.21q0-4.7168 2.9027-7.6195 3.2655-3.2655 7.9824-3.2655h133.16q4.7168 0 7.6195 3.2655 3.2655 2.9027 3.2655 7.6195t-3.2655 7.6195q-2.9027 2.9027-7.6195 2.9027h-121.19v91.072h104.86q4.7168 0 7.6195 3.2655 3.2655 2.9027 3.2655 7.6195t-3.2655 7.6195q-2.9027 2.9027-7.6195 2.9027h-104.86v98.691z"/>
      </g>
      <g transform="translate(20 4.25)">
        <g>
          <rect x="72" y="333.58" width="10" height="10" fill="#e69f00"/>
          <rect x="72" y="315.58" width="10" height="10" fill="#56b4e9"/>
          <rect x="72" y="297.58" width="10" height="10" fill="#009e73"/>
          <rect x="72" y="279.58" width="10" height="10" fill="#f0e442"/>
        </g>

        <g fill="#e6e6e6">
          <rect x="56" y="297.58" width="10" height="10"/>
          <rect x="56" y="315.58" width="10" height="10"/>
          <rect x="88" y="297.58" width="10" height="10"/>
          <rect x="88" y="315.58" width="10" height="10"/>
        </g>

        <g>
          <rect x="88" y="279.58" width="10" height="10" fill="#0072b2"/>
          <rect x="56" y="279.58" width="10" height="10" fill="#d55e00"/>
          <rect x="56" y="333.58" width="10" height="10" fill="#cc79a7"/>
          <rect x="88" y="333.58" width="10" height="10" fill="#dd55ff"/>
        </g>
      </g>
    </g>
  </symbol>
</defs>
</svg>
)SVG";

    /*<footer>VGG Image Search Engine (<a href="http://www.robots.ox.ac.uk/~vgg/software/vise/">VISE</a>) is an open source software developed and maintained by the Visual Geometry Group (<a href="http://www.robots.ox.ac.uk/~vgg/">VGG</a>).</footer>*/

    const char* const HTML_TAIL = R"TEXT(
</body>
</html>)TEXT";
    const char* const HTML_EMPTY_TAIL = R"TEXT(
</body>
</html>)TEXT";
}
#endif
