[![pipeline status](https://gitlab.com/vgg/vise/badges/master/pipeline.svg)](https://gitlab.com/vgg/vise/-/commits/master) 

# VGG Image Search Engine (VISE)

VGG Image Search Engine (VISE) is a free and [open
source](https://gitlab.com/vgg/vise) software for visual search of
large collection of images using image region as a search query. VISE
is developed and maintained by Visual Geometry Group
([VGG](https://www.robots.ox.ac.uk/~vgg/)) in Department of
Engineering Science of the Oxford University. VISE is released under a
[license](https://gitlab.com/vgg/vise/-/blob/master/src/LICENSE.txt)
that allows unrestricted use in academic research projects and
commercial industrial applications.

VISE builds on the C++ codebase developed by [Dr. Relja
Arandjelović](http://www.robots.ox.ac.uk/~relja/) during his DPhil /
Postdoc at the Visual Geometry Group in 2014. VISE is developed and
maintained by [Dr. Abhishek
Dutta](http://www.robots.ox.ac.uk/~adutta/). The VISE project has been
made possible by the guidance and support of [Prof. Andrew Zisserman](https://www.robots.ox.ac.uk/~az/).

Development and maintenance of VISE software has been supported by the following two grants:
 * Visual AI: An Open World Interpretable Visual Transformer (UKRI Grant [EP/T028572/1](https://gtr.ukri.org/projects?ref=EP%2FT028572%2F1))
 * Seebibyte: Visual Search for the Era of Big Data (EPSRC Grant [EP/M013774/1](https://gow.epsrc.ukri.org/NGBOViewGrant.aspx?GrantRef=EP/M013774/1))

For more details, visit https://www.robots.ox.ac.uk/~vgg/software/vise/

## Download

The VISE software installers can be downloaded from the
VISE [software
page](https://www.robots.ox.ac.uk/~vgg/software/vise/index.html#download). Source
code is available from VISE [gitlab code
repository](https://gitlab.com/vgg/vise).

## User Guide

See [doc/User-Guide.md](doc/User-Guide.md) for instructions on using
VISE for creating visual search engine. You can also read the
[frequently asked questions](doc/FAQ.md) page to learn more about
VISE.

## Developer Resources

See [doc/Compiling-VISE.md](doc/Compiling-VISE.md) for instructions on
compiling the VISE source code in Windows, Linux and MacOS
platforms. A [Docker
image](doc/Compiling-VISE.md#building-vise-using-docker) of VISE can
also be build using the provided [Dockerfile](Dockerfile). For testing
VISE source code and assessing its image retrieval performance, see
[doc/Testing-VISE.md](doc/Testing-VISE.md). The VISE HTTP server REST
API specification are described in
[doc/HTTP-REST-API.md](doc/HTTP-REST-API.md).

## Contact
Contact [Abhishek Dutta](adutta@robots.ox.ac.uk) for any queries or feedback related to this software application.
