import LocalizedStrings from "react-localization";

const strings = new LocalizedStrings({
  en: {
    title: "Timelite?",
    quote: "Why is it 5 AM? Isn't there something simple I can use to track what I'm doing with all this time?",
    name: "Isaac Bythewood",
    sectionTimer: "Timer",
    sectionNavigation: "Navigation",
    sectionLog: "Log",
    keyReset: "Reset timer",
    keyAddLog: "Add log entry",
    keyTimerPage: "Move to timer page",
    keyLogPage: "Move to log page",
    keyAboutPage: "Move to about page",
    keyNextLogEntry: "Move to next log entry",
    keyPreviousLogEntry: "Move to previous log entry",
    keyEditEntry: "Edit log entry",
    keyDeleteSingleEntry: "Delete single log entry",
    keyClearLog: "Clear all log entries",
  },
  // TODO: None of this is accurate past this line, someone please help me translate...
  jp: {
    title: "タイムライト？",
    quote: "なぜ午前5時ですか。常に行っていることを追跡するために使用できる簡単なものはありますか？",
    name: "アイザックバイザウッド",
    sectionTimer: "タイマー",
    sectionNavigation: "ナビゲーション",
    sectionLog: "ログ",
    keyReset: "タイマーのリセット",
    keyAddLog: "ログエントリを追加する",
    keyTimerPage: "タイマーページに移動",
    keyLogPage: "ログページに移動",
    keyAboutPage: "約ページに移動",
    keyNextLogEntry: "次のログエントリに移動",
    keyPreviousLogEntry: "前のログエントリに移動します",
    keyEditEntry: "ログエントリの編集",
    keyDeleteSingleEntry: "単一のログエントリを削除する",
    keyClearLog: "すべてのログエントリをクリアする",
  },
  pl: {
    title: "Timelite?",
    quote: "Czemu jest piąta rano? Nie ma czegoś prostego, co mógłbym użyć do śledzenia uciekającego czasu?",
    name: "Isaac Bythewood",
    sectionTimer: "Zegar",
    sectionNavigation: "Nawigacja",
    sectionLog: "Dziennik",
    keyReset: "Zerowanie zagara",
    keyAddLog: "Dodaj wpis do dziennika",
    keyTimerPage: "Przejdź na stronę zegara",
    keyLogPage: "Przejdź na stronę dziennika",
    keyAboutPage: "Przejdź na stronę o timelite",
    keyNextLogEntry: "Przejdź do następnego wpisu",
    keyPreviousLogEntry: "Przejdź do poprzedniego wpisu",
    keyEditEntry: "Edytuj wpis dziennika",
    keyDeleteSingleEntry: "Skasuj pojedynczy wpis dziennika",
    keyClearLog: "Wyczyść wszystkie wpisy dziennika",
  },
});

export default strings;
