<?php
/*******************************************************************************
* Ourphp - CMS建站系统
* Copyright (C) 2023 www.ourphp.net
* 开发者：哈尔滨伟成科技有限公司
*******************************************************************************/
include 'ourphp_admin.php';
include 'ourphp_checkadmin.php';

if (!strstr($OP_Adminpower,"63")){
	
	exit;
	
}

function get_access_token(){
	$api = plugsclass::plugs(14);
	if(!$api)
	{
		return false;
	}
	$url = "https://aip.baidubce.com/oauth/2.0/token?grant_type=client_credentials&client_id=".$api[2]."&client_secret=".$api[3];
	$options = [
		'http' => [
			'header'  => "Content-type: application/json",
			'method'  => 'POST',
		]
	];
	$context  = stream_context_create($options);
	$response = file_get_contents($url, false, $context);
	if ($response === false) {
		return false;
	}
	$result = json_decode($response, true);
	return $result['access_token'];
}

if(isset($_POST['ai']))
{
	$token = get_access_token();
	$url2 = "https://aip.baidubce.com/rpc/2.0/ai_custom/v1/wenxinworkshop/chat/completions?access_token=".$token;
	$options = [
		'http' => [
			'header'  => "Content-type: application/json",
			'method'  => 'POST',
			'content' => '{"messages": [{"role": "user", "content": "'.$_POST['content'].'"}]}'
		]
	];
	$context  = stream_context_create($options);
	$response = file_get_contents($url2, false, $context);
	if ($response === false) {
		$array = array("error" => 0,"content" => "请求失败，请开启AI插件并设置key");
		echo json_encode($array);
		exit;
	}
	$result = json_decode($response, true);
	if(!isset($result['result']))
	{
		$array = array("error" => 0,"content" => $result['error_msg']);
		echo json_encode($array);
		exit;	
	}
	$array = array("error" => 1,"content" => $result['result']);
	echo json_encode($array);
	exit;
}

$plusfileclass = new plugsclass();
echo $plusfileclass -> plushtml("AI创作","head","YIQI-UI,jquery,layer");
echo '
	<style type="text/css">
		.footer {
			width:90%; height:40px; padding:5px 5%; background:#fff; left:0; bottom:0; background:#f4f4f4; 
		}
		.run {
			width:78%; float:left; background:#fff; border:0; padding-left:2%; height:40px;
		}
		button {width:20%; border:0; float:right; background:#d74d2e; color:#fff; height:40px;}
		.list {width:90%; height:75%; overflow:hidden; overflow-y:auto; float:left; padding:0 5% 10% 5%; }
		.list li {width:96%; float:left; padding:10px 2%;}
		.list li.me {background:#f4f4f4;}
		.w30 {width:5%;}
		.w60 {width:95%;}
	</style>
	<script>
		$(function(){
			var cache = localStorage.getItem("list");
			if(cache == "" || cache == null)
			{
				
			}else{
				$(".list").html(cache);
				var scrollHeight = $(".list").prop("scrollHeight");
				$(".list").scrollTop(scrollHeight,200);
			}
		})
		function send()
		{
			var load = layer.load(2);
			var content = $("#content").val();
			if(content == "" || content == null)
			{
				layer.msg("问题不能为空，请输入");
				layer.close(load); 
				return;
			}
			$.post("ourphp_baiduai.php",{content:content,ai:"ok"},function(data){
				if(data.error == 0){
					layer.close(load); 
					layer.msg(data.content);
					return;
				}else{
					$(".list").append(\'<li class="me"><div class="f-l w30">我：</div><div class="f-l w60">\'+content+\'</div></li>\');
					$(".list").append(\'<li><div class="f-l w30">AI：</div><div class="f-l w60">\'+data.content+\'</div></li>\');
					var scrollHeight = $(".list").prop("scrollHeight");
					$(".list").scrollTop(scrollHeight,200);
					$(".run").val("");
					var cache = $(".list").html();
					localStorage.setItem("list",cache);
				}
				layer.close(load); 
				return;
			},"json");
		}
	</script>
';
echo '<div class="list"></div><div class="footer pos-f"><input type="text" class="run" placeholder="您要问AI什么？请在这里输入..." id="content"><button onclick="send();">AI创作</button></div>';
echo $plusfileclass -> plushtml("","bottom","context");
?>