import { FunctionComponent } from "react";

export const CoinsIcon: FunctionComponent<{ className?: string }> = ({
  className,
}) => {
  return (
    <svg
      width="260"
      height="967"
      viewBox="0 0 260 967"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      className={className}
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M112.693 211.987C116.761 211.688 120 206.436 120 200C120 193.564 116.761 188.312 112.693 188.013V188H112.327H108.308V189.776C106.116 191.888 104.654 195.677 104.654 200C104.654 204.323 106.116 208.112 108.308 210.224V212H112.327H112.693V211.987Z"
        fill="#DFAA44"
      />
      <ellipse cx="108.674" cy="200" rx="7.67308" ry="12" fill="#F9CC75" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M135.999 528.403C140.067 528.104 143.307 522.852 143.307 516.416C143.307 509.98 140.067 504.728 135.999 504.429V504.416H135.634H131.615V506.192C129.422 508.304 127.961 512.093 127.961 516.416C127.961 520.739 129.422 524.528 131.615 526.64V528.416H135.634H135.999V528.403Z"
        fill="#DFAA44"
      />
      <ellipse cx="131.98" cy="516.416" rx="7.67308" ry="12" fill="#F9CC75" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M64.6928 183.987C68.7608 183.688 72.0005 178.436 72.0005 172C72.0005 165.564 68.7608 160.312 64.6928 160.013V160H64.3274H60.3082V161.776C58.1158 163.888 56.6543 167.677 56.6543 172C56.6543 176.323 58.1158 180.112 60.3082 182.224V184H64.3274H64.6928V183.987Z"
        fill="#DFAA44"
      />
      <ellipse cx="60.6736" cy="172" rx="7.67308" ry="12" fill="#F9CC75" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M43.0926 511.283C44.1077 515.234 49.8516 517.49 56.1854 516.349C62.5192 515.207 67.1137 511.087 66.6857 507.031L66.6988 507.028L66.634 506.669L65.9211 502.713L64.1733 503.028C61.7055 501.245 57.7174 500.479 53.4632 501.246C49.2091 502.013 45.7395 504.123 44.0495 506.655L42.3017 506.97L43.0146 510.926L43.0794 511.285L43.0926 511.283Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="54.1764"
        cy="505.201"
        rx="7.67308"
        ry="12"
        transform="rotate(79.7827 54.1764 505.201)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M226.113 342.014C229.468 344.334 235.286 342.277 239.324 337.266C243.362 332.255 244.136 326.132 241.155 323.347L241.164 323.337L240.879 323.107L237.749 320.586L236.635 321.968C233.603 322.238 230.087 324.271 227.375 327.637C224.663 331.003 223.423 334.87 223.805 337.89L222.691 339.273L225.82 341.795L226.105 342.024L226.113 342.014Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="230.504"
        cy="330.158"
        rx="7.67308"
        ry="12"
        transform="rotate(38.8625 230.504 330.158)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M197.692 633.987C201.76 633.688 205 628.436 205 622C205 615.564 201.76 610.312 197.692 610.013V610H197.327H193.308V611.776C191.115 613.888 189.654 617.677 189.654 622C189.654 626.323 191.115 630.112 193.308 632.224V634H197.327H197.692V633.987Z"
        fill="#DFAA44"
      />
      <ellipse cx="193.673" cy="622" rx="7.67308" ry="12" fill="#F9CC75" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M118.999 406.695C123.067 406.396 126.307 401.144 126.307 394.708C126.307 388.272 123.067 383.02 118.999 382.721V382.708H118.634H114.615V384.484C112.422 386.596 110.961 390.385 110.961 394.708C110.961 399.031 112.422 402.82 114.615 404.932V406.708H118.634H118.999V406.695Z"
        fill="#DFAA44"
      />
      <ellipse cx="114.98" cy="394.708" rx="7.67308" ry="12" fill="#F9CC75" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M16.6923 432.987C20.7603 432.688 24 427.436 24 421C24 414.564 20.7603 409.312 16.6923 409.013V409H16.3269H12.3077V410.776C10.1153 412.888 8.65381 416.677 8.65381 421C8.65381 425.323 10.1153 429.112 12.3077 431.224V433H16.3269H16.6923V432.987Z"
        fill="#DFAA44"
      />
      <ellipse cx="12.6731" cy="421" rx="7.67308" ry="12" fill="#F9CC75" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M118.999 712.302C123.067 712.004 126.307 706.751 126.307 700.315C126.307 693.88 123.067 688.627 118.999 688.329V688.315H118.634H114.615V690.091C112.422 692.204 110.961 695.993 110.961 700.315C110.961 704.638 112.422 708.427 114.615 710.539V712.315H118.634H118.999V712.302Z"
        fill="#DFAA44"
      />
      <ellipse cx="114.98" cy="700.315" rx="7.67308" ry="12" fill="#F9CC75" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M85.9994 327.695C90.0675 327.396 93.3071 322.144 93.3071 315.708C93.3071 309.272 90.0675 304.02 85.9994 303.721V303.708H85.634H81.6148V305.484C79.4224 307.596 77.9609 311.385 77.9609 315.708C77.9609 320.031 79.4224 323.82 81.6148 325.932V327.708H85.634H85.9994V327.695Z"
        fill="#DFAA44"
      />
      <ellipse cx="81.9802" cy="315.708" rx="7.67308" ry="12" fill="#F9CC75" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M61.6923 632.987C65.7603 632.688 69 627.436 69 621C69 614.564 65.7603 609.312 61.6923 609.013V609H61.3269H57.3077V610.776C55.1153 612.888 53.6538 616.677 53.6538 621C53.6538 625.323 55.1153 629.112 57.3077 631.224V633H61.3269H61.6923V632.987Z"
        fill="#DFAA44"
      />
      <ellipse cx="57.6731" cy="621" rx="7.67308" ry="12" fill="#F9CC75" />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M150.363 107.071L146.034 107.769L146.317 109.522C144.488 111.957 143.648 115.93 144.336 120.197C145.023 124.465 147.068 127.973 149.569 129.71L149.851 131.463L153.781 130.83C153.794 130.828 153.807 130.826 153.82 130.824C153.832 130.822 153.845 130.82 153.858 130.818L154.18 130.766L154.178 130.753C158.147 129.812 160.51 124.111 159.487 117.756C158.463 111.402 154.429 106.732 150.365 107.085L150.363 107.071Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="148.304"
        cy="119.558"
        rx="7.67308"
        ry="12"
        transform="rotate(-9.15087 148.304 119.558)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M179.819 475.885L176.581 472.928L175.383 474.239C172.34 474.321 168.706 476.133 165.791 479.324C162.876 482.516 161.4 486.299 161.594 489.337L160.396 490.649L163.335 493.333C163.344 493.342 163.354 493.351 163.363 493.359C163.373 493.368 163.383 493.377 163.393 493.386L163.633 493.606L163.642 493.596C166.847 496.119 172.781 494.426 177.122 489.674C181.462 484.922 182.613 478.858 179.81 475.895L179.819 475.885Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="168.759"
        cy="482.035"
        rx="7.67308"
        ry="12"
        transform="rotate(42.408 168.759 482.035)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M171.68 235.605C175.282 233.691 176.128 227.578 173.533 221.689C170.938 215.8 165.855 212.3 162.012 213.667L162.007 213.655L161.672 213.802L157.995 215.423L158.711 217.048C157.556 219.865 157.747 223.922 159.49 227.878C161.233 231.833 164.098 234.711 166.956 235.76L167.673 237.385L171.351 235.764L171.685 235.617L171.68 235.605Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="163.168"
        cy="226.257"
        rx="7.67308"
        ry="12"
        transform="rotate(-23.7819 163.168 226.257)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M171.68 541.313C175.282 539.399 176.128 533.286 173.533 527.397C170.938 521.508 165.855 518.008 162.012 519.375L162.007 519.363L161.672 519.51L157.995 521.131L158.711 522.756C157.556 525.573 157.747 529.63 159.49 533.586C161.233 537.541 164.098 540.419 166.956 541.468L167.673 543.093L171.351 541.472L171.685 541.325L171.68 541.313Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="163.168"
        cy="531.965"
        rx="7.67308"
        ry="12"
        transform="rotate(-23.7819 163.168 531.965)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M183.693 188.034L179.308 188.055L179.316 189.831C177.134 191.954 175.691 195.75 175.711 200.072C175.731 204.395 177.211 208.177 179.413 210.279L179.421 212.055L183.383 212.036C183.402 212.036 183.421 212.036 183.441 212.036C183.46 212.036 183.479 212.036 183.498 212.036L183.806 212.034L183.806 212.021C187.873 211.704 191.087 206.436 191.057 200C191.027 193.564 187.762 188.327 183.693 188.048L183.693 188.034Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="179.73"
        cy="200.056"
        rx="7.67308"
        ry="12"
        transform="rotate(-0.270475 179.73 200.056)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M116.975 541.215L112.59 541.236L112.599 543.012C110.416 545.135 108.973 548.93 108.993 553.253C109.014 557.576 110.493 561.358 112.695 563.46L112.704 565.235L116.665 565.217C116.684 565.217 116.704 565.217 116.723 565.217C116.742 565.217 116.761 565.216 116.78 565.216L117.088 565.215L117.088 565.202C121.155 564.884 124.37 559.616 124.339 553.181C124.309 546.745 121.044 541.508 116.975 541.229L116.975 541.215Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="113.012"
        cy="553.237"
        rx="7.67308"
        ry="12"
        transform="rotate(-0.270475 113.012 553.237)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M143.046 267.657L147.088 265.956L146.399 264.318C147.6 261.521 147.477 257.462 145.8 253.477C144.123 249.493 141.306 246.568 138.466 245.472L137.777 243.835L134.136 245.368C134.115 245.376 134.094 245.385 134.073 245.394C134.052 245.403 134.031 245.412 134.01 245.421L133.736 245.536L133.741 245.548C130.107 247.401 129.159 253.499 131.656 259.431C134.152 265.363 139.176 268.947 143.041 267.644L143.046 267.657Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="142.096"
        cy="255.038"
        rx="7.67308"
        ry="12"
        transform="rotate(157.174 142.096 255.038)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M147.498 580.371L151.539 578.67L150.85 577.033C152.052 574.236 151.929 570.177 150.252 566.192C148.575 562.208 145.758 559.283 142.918 558.186L142.229 556.55L138.587 558.083C138.566 558.091 138.545 558.1 138.524 558.109C138.503 558.118 138.483 558.127 138.462 558.136L138.188 558.251L138.193 558.263C134.559 560.116 133.611 566.214 136.107 572.146C138.604 578.077 143.628 581.662 147.493 580.359L147.498 580.371Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="146.547"
        cy="567.752"
        rx="7.67308"
        ry="12"
        transform="rotate(157.174 146.547 567.752)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M109.353 361.364L113.394 359.663L112.705 358.025C113.907 355.228 113.784 351.169 112.107 347.184C110.43 343.2 107.613 340.275 104.773 339.179L104.084 337.542L100.442 339.075C100.421 339.084 100.4 339.092 100.379 339.101C100.358 339.11 100.338 339.119 100.317 339.128L100.043 339.243L100.048 339.255C96.4139 341.108 95.4657 347.206 97.9624 353.138C100.459 359.07 105.483 362.654 109.348 361.351L109.353 361.364Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="108.402"
        cy="348.745"
        rx="7.67308"
        ry="12"
        transform="rotate(157.174 108.402 348.745)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M110.042 632.73L111.472 628.585L109.792 628.006C108.51 625.245 105.404 622.628 101.318 621.219C97.2308 619.81 93.1723 619.957 90.4607 621.341L88.7823 620.763L87.4944 624.498C87.4868 624.519 87.4792 624.541 87.4718 624.562C87.4644 624.583 87.4572 624.605 87.4501 624.626L87.3531 624.908L87.3653 624.912C86.3215 628.855 90.2312 633.63 96.3155 635.727C102.4 637.825 108.421 636.475 110.029 632.726L110.042 632.73Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="100.006"
        cy="625.018"
        rx="7.67308"
        ry="12"
        transform="rotate(109.023 100.006 625.018)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M188.353 384.364L192.394 382.663L191.705 381.025C192.907 378.228 192.784 374.169 191.107 370.184C189.43 366.2 186.613 363.275 183.773 362.179L183.084 360.542L179.442 362.075C179.421 362.084 179.4 362.092 179.379 362.101C179.358 362.11 179.338 362.119 179.317 362.128L179.043 362.243L179.048 362.255C175.414 364.108 174.466 370.206 176.962 376.138C179.459 382.07 184.483 385.654 188.348 384.351L188.353 384.364Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="187.402"
        cy="371.745"
        rx="7.67308"
        ry="12"
        transform="rotate(157.174 187.402 371.745)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M135.109 322.279L138.085 325.5L139.39 324.294C142.429 324.471 146.204 322.974 149.379 320.04C152.554 317.107 154.345 313.462 154.409 310.418L155.713 309.213L153.032 306.311C153.017 306.294 153.002 306.278 152.986 306.261C152.971 306.244 152.955 306.228 152.94 306.211L152.738 305.993L152.728 306.002C149.749 303.216 143.692 304.401 138.965 308.768C134.238 313.135 132.578 319.079 135.12 322.27L135.109 322.279Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="146.651"
        cy="317.088"
        rx="7.67308"
        ry="12"
        transform="rotate(-132.734 146.651 317.088)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M188.354 689.975L192.395 688.274L191.706 686.637C192.907 683.839 192.784 679.78 191.107 675.796C189.43 671.812 186.613 668.886 183.773 667.79L183.084 666.154L179.443 667.686C179.422 667.695 179.401 667.703 179.38 667.712C179.359 667.721 179.338 667.73 179.317 667.739L179.043 667.855L179.048 667.866C175.414 669.72 174.466 675.817 176.963 681.749C179.46 687.681 184.483 691.265 188.348 689.962L188.354 689.975Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="187.402"
        cy="677.353"
        rx="7.67308"
        ry="12"
        transform="rotate(157.174 187.402 677.353)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M150.046 449.657L154.087 447.956L153.398 446.318C154.599 443.521 154.477 439.462 152.8 435.477C151.123 431.493 148.306 428.568 145.465 427.472L144.777 425.835L141.135 427.368C141.114 427.376 141.093 427.385 141.072 427.394C141.051 427.403 141.03 427.412 141.01 427.421L140.735 427.536L140.74 427.548C137.107 429.401 136.159 435.499 138.655 441.431C141.152 447.363 146.175 450.947 150.041 449.644L150.046 449.657Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="149.095"
        cy="437.038"
        rx="7.67308"
        ry="12"
        transform="rotate(157.174 149.095 437.038)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M182.047 833.659L186.088 831.958L185.399 830.32C186.6 827.523 186.478 823.464 184.801 819.479C183.124 815.495 180.307 812.57 177.466 811.473L176.778 809.837L173.136 811.37C173.115 811.378 173.094 811.387 173.073 811.396C173.052 811.405 173.031 811.414 173.011 811.423L172.736 811.538L172.741 811.55C169.108 813.403 168.16 819.501 170.656 825.433C173.153 831.365 178.176 834.949 182.042 833.646L182.047 833.659Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="181.096"
        cy="821.037"
        rx="7.67308"
        ry="12"
        transform="rotate(157.174 181.096 821.037)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M144.353 387.364L148.394 385.663L147.705 384.025C148.907 381.228 148.784 377.169 147.107 373.184C145.43 369.2 142.613 366.275 139.773 365.179L139.084 363.542L135.442 365.075C135.421 365.084 135.4 365.092 135.379 365.101C135.358 365.11 135.338 365.119 135.317 365.128L135.043 365.243L135.048 365.255C131.414 367.108 130.466 373.206 132.962 379.138C135.459 385.07 140.483 388.654 144.348 387.351L144.353 387.364Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="143.402"
        cy="374.745"
        rx="7.67308"
        ry="12"
        transform="rotate(157.174 143.402 374.745)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M144.354 692.975L148.395 691.274L147.706 689.637C148.907 686.839 148.784 682.78 147.107 678.796C145.43 674.812 142.613 671.886 139.773 670.79L139.084 669.154L135.443 670.686C135.422 670.695 135.401 670.703 135.38 670.712C135.359 670.721 135.338 670.73 135.317 670.739L135.043 670.855L135.048 670.866C131.414 672.72 130.466 678.817 132.963 684.749C135.46 690.681 140.483 694.265 144.348 692.962L144.354 692.975Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="143.402"
        cy="680.353"
        rx="7.67308"
        ry="12"
        transform="rotate(157.174 143.402 680.353)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M113.046 160.657L117.088 158.956L116.399 157.318C117.6 154.521 117.477 150.462 115.8 146.477C114.123 142.493 111.306 139.568 108.466 138.472L107.777 136.835L104.136 138.368C104.115 138.376 104.094 138.385 104.073 138.394C104.052 138.403 104.031 138.412 104.01 138.421L103.736 138.536L103.741 138.548C100.107 140.401 99.1591 146.499 101.656 152.431C104.152 158.363 109.176 161.947 113.041 160.644L113.046 160.657Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="112.096"
        cy="148.038"
        rx="7.67308"
        ry="12"
        transform="rotate(157.174 112.096 148.038)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M190.046 80.6566L194.088 78.9556L193.399 77.3185C194.6 74.5209 194.477 70.4617 192.8 66.4774C191.123 62.4932 188.306 59.568 185.466 58.4715L184.777 56.8352L181.136 58.368C181.115 58.3765 181.094 58.3851 181.073 58.3939C181.052 58.4027 181.031 58.4117 181.01 58.4207L180.736 58.5362L180.741 58.5481C177.107 60.4012 176.159 66.4991 178.656 72.4308C181.152 78.3626 186.176 81.9469 190.041 80.6438L190.046 80.6566Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="189.096"
        cy="68.0376"
        rx="7.67308"
        ry="12"
        transform="rotate(157.174 189.096 68.0376)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M102.353 522.072L106.394 520.371L105.705 518.733C106.907 515.936 106.784 511.877 105.107 507.892C103.43 503.908 100.613 500.983 97.7725 499.887L97.0838 498.25L93.4422 499.783C93.4212 499.792 93.4002 499.8 93.3793 499.809C93.3584 499.818 93.3375 499.827 93.3168 499.836L93.0425 499.951L93.0476 499.963C89.4139 501.816 88.4657 507.914 90.9624 513.846C93.4591 519.778 98.4826 523.362 102.348 522.059L102.353 522.072Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="101.402"
        cy="509.453"
        rx="7.67308"
        ry="12"
        transform="rotate(157.174 101.402 509.453)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M78.9191 19.0372L81.27 22.7383L82.7694 21.7859C85.728 22.5036 89.7096 21.7058 93.3583 19.3881C97.0069 17.0705 99.4215 13.8055 100.029 10.8223L101.529 9.86996L99.3804 6.48816C99.3781 6.48446 99.3757 6.48076 99.3734 6.47707C99.371 6.47338 99.3687 6.46969 99.3663 6.46601L99.1776 6.16889L99.1663 6.17604C96.7335 2.90187 90.5626 2.9835 85.13 6.43435C79.6973 9.88521 77.0007 15.4363 78.9304 19.03L78.9191 19.0372Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="91.2031"
        cy="15.9952"
        rx="7.67308"
        ry="12"
        transform="rotate(-122.424 91.2031 15.9952)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M109.414 474.745L111.765 478.446L113.265 477.494C116.223 478.212 120.205 477.414 123.853 475.096C127.502 472.778 129.917 469.513 130.524 466.53L132.024 465.578L129.876 462.196C129.873 462.192 129.871 462.189 129.868 462.185C129.866 462.181 129.864 462.178 129.861 462.174L129.673 461.877L129.661 461.884C127.229 458.61 121.058 458.692 115.625 462.142C110.192 465.593 107.496 471.144 109.425 474.738L109.414 474.745Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="121.698"
        cy="471.703"
        rx="7.67308"
        ry="12"
        transform="rotate(-122.424 121.698 471.703)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M214.565 178.894C217.439 175.998 216.436 169.909 212.212 165.054C207.987 160.198 202.096 158.361 198.831 160.806L198.822 160.796L198.546 161.036L195.514 163.674L196.68 165.014C196.412 168.047 197.796 171.865 200.633 175.126C203.47 178.387 207.06 180.287 210.1 180.441L211.266 181.781L214.298 179.143L214.574 178.904L214.565 178.894Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="203.666"
        cy="172.488"
        rx="7.67308"
        ry="12"
        transform="rotate(-41.0209 203.666 172.488)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M201.565 525.894C204.438 522.998 203.435 516.909 199.211 512.054C194.987 507.198 189.095 505.361 185.83 507.806L185.822 507.796L185.546 508.036L182.514 510.674L183.679 512.014C183.412 515.047 184.796 518.865 187.633 522.126C190.47 525.387 194.059 527.287 197.1 527.441L198.266 528.781L201.298 526.143L201.574 525.904L201.565 525.894Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="190.665"
        cy="519.488"
        rx="7.67308"
        ry="12"
        transform="rotate(-41.0209 190.665 519.488)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M60.2479 384.048C64.1166 382.755 65.9605 376.866 64.373 370.629C62.7855 364.392 58.3503 360.101 54.3344 360.815L54.3311 360.802L53.977 360.892L50.082 361.884L50.5201 363.605C48.9165 366.193 48.4348 370.225 49.501 374.414C50.5673 378.604 52.9183 381.915 55.564 383.421L56.002 385.142L59.897 384.151L60.2512 384.061L60.2479 384.048Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="53.396"
        cy="373.423"
        rx="7.67308"
        ry="12"
        transform="rotate(-14.2805 53.396 373.423)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M34.2479 320.048C38.1166 318.755 39.9605 312.866 38.373 306.629C36.7855 300.392 32.3503 296.101 28.3344 296.815L28.3311 296.802L27.977 296.892L24.082 297.884L24.5201 299.605C22.9165 302.193 22.4348 306.225 23.501 310.414C24.5673 314.604 26.9183 317.915 29.564 319.421L30.002 321.142L33.897 320.151L34.2512 320.061L34.2479 320.048Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="27.396"
        cy="309.423"
        rx="7.67308"
        ry="12"
        transform="rotate(-14.2805 27.396 309.423)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M16.3257 597.316C18.4401 600.804 24.5912 601.303 30.324 598.378C36.0569 595.453 39.2634 590.181 37.6803 586.421L37.6922 586.415L37.5262 586.09L35.6996 582.51L34.1176 583.317C31.2396 582.324 27.2004 582.744 23.3498 584.708C19.4993 586.673 16.7885 589.697 15.9031 592.61L14.3212 593.417L16.1477 596.997L16.3138 597.322L16.3257 597.316Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="25.1763"
        cy="588.288"
        rx="7.67308"
        ry="12"
        transform="rotate(62.97 25.1763 588.288)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M5.32569 700.316C7.44014 703.804 13.5912 704.303 19.324 701.378C25.0569 698.453 28.2634 693.181 26.6803 689.421L26.6922 689.415L26.5262 689.09L24.6996 685.51L23.1176 686.317C20.2396 685.324 16.2004 685.744 12.3498 687.708C8.49929 689.673 5.78846 692.697 4.90313 695.61L3.32116 696.417L5.14771 699.997L5.31378 700.322L5.32569 700.316Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="14.1763"
        cy="691.288"
        rx="7.67308"
        ry="12"
        transform="rotate(62.97 14.1763 691.288)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M234.326 252.316C236.44 255.804 242.591 256.303 248.324 253.378C254.057 250.453 257.263 245.181 255.68 241.421L255.692 241.415L255.526 241.09L253.7 237.51L252.118 238.317C249.24 237.324 245.2 237.744 241.35 239.708C237.499 241.673 234.788 244.697 233.903 247.61L232.321 248.417L234.148 251.997L234.314 252.322L234.326 252.316Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="243.176"
        cy="243.288"
        rx="7.67308"
        ry="12"
        transform="rotate(62.97 243.176 243.288)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M84.872 696.209C87.7455 693.314 86.7423 687.225 82.5182 682.369C78.2941 677.513 72.4025 675.677 69.1376 678.122L69.1288 678.112L68.8531 678.352L65.8207 680.99L66.9863 682.329C66.7187 685.362 68.1028 689.18 70.94 692.441C73.7771 695.703 77.3666 697.602 80.4071 697.757L81.5727 699.097L84.6051 696.459L84.8808 696.219L84.872 696.209Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="73.9722"
        cy="689.804"
        rx="7.67308"
        ry="12"
        transform="rotate(-41.0209 73.9722 689.804)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M66.4911 442.458C70.454 441.492 72.7823 435.777 71.7202 429.43C70.658 423.082 66.5961 418.436 62.5346 418.813L62.5325 418.801L62.2426 418.849C62.219 418.853 62.1954 418.857 62.1719 418.861C62.1483 418.865 62.1248 418.869 62.1013 418.873L58.208 419.524L58.501 421.275C56.6872 423.721 55.871 427.699 56.5844 431.962C57.2979 436.226 59.3647 439.722 61.8757 441.443L62.1689 443.195L66.4934 442.472L66.4911 442.458Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="60.5488"
        cy="431.299"
        rx="7.67308"
        ry="12"
        transform="rotate(-9.4993 60.5488 431.299)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M171.533 741.207L167.208 741.93L167.501 743.682C165.687 746.127 164.871 750.105 165.585 754.369C166.298 758.633 168.365 762.129 170.876 763.85L171.169 765.601L175.066 764.949C175.089 764.945 175.111 764.942 175.133 764.938C175.155 764.935 175.177 764.931 175.199 764.927L175.493 764.877L175.491 764.865C179.454 763.899 181.782 758.184 180.72 751.836C179.658 745.489 175.596 740.843 171.535 741.22L171.533 741.207Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="169.549"
        cy="753.706"
        rx="7.67308"
        ry="12"
        transform="rotate(-9.4993 169.549 753.706)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M89.3204 432.285C92.9561 434.134 98.4456 431.315 101.775 425.807C105.104 420.299 105.049 414.128 101.722 411.769L101.729 411.757L101.467 411.599C101.45 411.589 101.433 411.578 101.416 411.568C101.399 411.558 101.382 411.548 101.365 411.537L97.9766 409.489L97.0581 411.009C94.089 411.682 90.8781 414.169 88.6418 417.868C86.4055 421.568 85.6962 425.566 86.4798 428.508L85.5609 430.028L89.3133 432.297L89.3204 432.285Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="92.0814"
        cy="419.947"
        rx="7.67308"
        ry="12"
        transform="rotate(31.1525 92.0814 419.947)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M70.0137 762.577C73.6494 764.426 79.139 761.607 82.4683 756.099C85.7976 750.591 85.7424 744.42 82.4155 742.061L82.4222 742.049L82.1605 741.891C82.1436 741.881 82.1266 741.87 82.1095 741.86C82.0925 741.85 82.0754 741.84 82.0582 741.829L78.6699 739.781L77.7515 741.301C74.7824 741.974 71.5714 744.461 69.3352 748.16C67.0989 751.86 66.3896 755.858 67.1731 758.8L66.2543 760.32L70.0066 762.589L70.0137 762.577Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="72.7748"
        cy="750.239"
        rx="7.67308"
        ry="12"
        transform="rotate(31.1525 72.7748 750.239)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M163.32 419.285C166.956 421.134 172.446 418.315 175.775 412.807C179.104 407.299 179.049 401.128 175.722 398.769L175.729 398.757L175.467 398.599C175.45 398.589 175.433 398.578 175.416 398.568C175.399 398.558 175.382 398.548 175.365 398.537L171.977 396.489L171.058 398.009C168.089 398.682 164.878 401.169 162.642 404.868C160.406 408.568 159.696 412.566 160.48 415.508L159.561 417.028L163.313 419.297L163.32 419.285Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="166.081"
        cy="406.947"
        rx="7.67308"
        ry="12"
        transform="rotate(31.1525 166.081 406.947)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M134.545 790.548C138.608 790.904 142.646 786.237 143.675 779.884C144.704 773.531 142.346 767.828 138.378 766.883L138.38 766.871L138.078 766.822C138.059 766.818 138.039 766.815 138.019 766.812C138 766.809 137.98 766.806 137.96 766.803L134.052 766.17L133.768 767.922C131.266 769.657 129.217 773.163 128.526 777.431C127.835 781.698 128.672 785.672 130.499 788.108L130.215 789.861L134.543 790.562L134.545 790.548Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="132.494"
        cy="778.072"
        rx="7.67308"
        ry="12"
        transform="rotate(9.20039 132.494 778.072)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M89.3204 478.285C92.9561 480.134 98.4456 477.315 101.775 471.807C105.104 466.299 105.049 460.128 101.722 457.769L101.729 457.757L101.467 457.599C101.45 457.589 101.433 457.578 101.416 457.568C101.399 457.558 101.382 457.548 101.365 457.537L97.9766 455.489L97.0581 457.009C94.089 457.682 90.8781 460.169 88.6418 463.868C86.4055 467.568 85.6962 471.566 86.4798 474.508L85.5609 476.028L89.3133 478.297L89.3204 478.285Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="92.0814"
        cy="465.947"
        rx="7.67308"
        ry="12"
        transform="rotate(31.1525 92.0814 465.947)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M104.014 873.577C107.65 875.426 113.139 872.607 116.469 867.099C119.798 861.591 119.743 855.42 116.416 853.061L116.423 853.049L116.161 852.891C116.144 852.881 116.127 852.87 116.11 852.86C116.093 852.85 116.076 852.84 116.059 852.829L112.67 850.781L111.752 852.301C108.783 852.974 105.572 855.461 103.336 859.16C101.099 862.86 100.39 866.858 101.174 869.8L100.255 871.32L104.007 873.589L104.014 873.577Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="106.775"
        cy="861.239"
        rx="7.67308"
        ry="12"
        transform="rotate(31.1525 106.775 861.239)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M212.722 452.734C215.55 449.795 214.454 443.722 210.156 438.931C205.858 434.141 199.939 432.395 196.712 434.89L196.703 434.88L196.431 435.124L193.439 437.808L194.625 439.13C194.404 442.166 195.847 445.962 198.734 449.18C201.62 452.397 205.238 454.242 208.281 454.35L209.467 455.672L212.459 452.988L212.731 452.744L212.722 452.734Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="201.725"
        cy="446.496"
        rx="7.67308"
        ry="12"
        transform="rotate(-41.899 201.725 446.496)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M150.778 962.043C154.503 960.382 155.766 954.341 153.581 948.287C151.395 942.234 146.564 938.393 142.636 939.495L142.632 939.483L142.358 939.582C142.335 939.59 142.312 939.598 142.288 939.606C142.265 939.615 142.242 939.623 142.219 939.632L138.508 940.972L139.111 942.642C137.766 945.373 137.679 949.433 139.146 953.499C140.614 957.564 143.275 960.632 146.055 961.874L146.658 963.545L150.782 962.056L150.778 962.043Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="142.927"
        cy="952.133"
        rx="7.67308"
        ry="12"
        transform="rotate(-19.8524 142.927 952.133)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M195.872 285.602C198.745 282.706 197.742 276.617 193.518 271.762C189.294 266.906 183.403 265.069 180.138 267.514L180.129 267.504L179.853 267.744L176.821 270.382L177.986 271.722C177.719 274.755 179.103 278.573 181.94 281.834C184.777 285.095 188.367 286.995 191.407 287.149L192.573 288.489L195.605 285.851L195.881 285.612L195.872 285.602Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="184.972"
        cy="279.196"
        rx="7.67308"
        ry="12"
        transform="rotate(-41.0209 184.972 279.196)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M220.565 582.894C223.438 579.998 222.435 573.909 218.211 569.054C213.987 564.198 208.095 562.361 204.83 564.806L204.822 564.796L204.546 565.036L201.514 567.674L202.679 569.014C202.412 572.047 203.796 575.865 206.633 579.126C209.47 582.387 213.059 584.287 216.1 584.441L217.266 585.781L220.298 583.143L220.574 582.904L220.565 582.894Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="209.665"
        cy="576.488"
        rx="7.67308"
        ry="12"
        transform="rotate(-41.0209 209.665 576.488)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M238.696 668.673C242.328 670.529 247.823 667.721 251.164 662.22C254.504 656.719 254.462 650.548 251.139 648.182L251.146 648.17L250.834 647.981L247.399 645.895L246.477 647.413C243.506 648.08 240.291 650.56 238.047 654.255C235.803 657.95 235.086 661.947 235.863 664.891L234.942 666.409L238.377 668.495L238.689 668.684L238.696 668.673Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="241.482"
        cy="656.341"
        rx="7.67308"
        ry="12"
        transform="rotate(31.2681 241.482 656.341)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M147.872 348.602C150.745 345.706 149.742 339.617 145.518 334.762C141.294 329.906 135.403 328.069 132.138 330.514L132.129 330.504L131.853 330.744L128.821 333.382L129.986 334.722C129.719 337.755 131.103 341.573 133.94 344.834C136.777 348.095 140.367 349.995 143.407 350.149L144.573 351.489L147.605 348.851L147.881 348.612L147.872 348.602Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="136.972"
        cy="342.196"
        rx="7.67308"
        ry="12"
        transform="rotate(-41.0209 136.972 342.196)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M162.565 632.894C165.438 629.998 164.435 623.909 160.211 619.054C155.987 614.198 150.095 612.361 146.83 614.806L146.822 614.796L146.546 615.036L143.514 617.674L144.679 619.014C144.412 622.047 145.796 625.865 148.633 629.126C151.47 632.387 155.059 634.287 158.1 634.441L159.266 635.781L162.298 633.143L162.574 632.904L162.565 632.894Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="151.665"
        cy="626.488"
        rx="7.67308"
        ry="12"
        transform="rotate(-41.0209 151.665 626.488)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M125.872 298.602C128.745 295.706 127.742 289.617 123.518 284.762C119.294 279.906 113.403 278.069 110.138 280.514L110.129 280.504L109.853 280.744L106.821 283.382L107.986 284.722C107.719 287.755 109.103 291.573 111.94 294.834C114.777 298.095 118.367 299.995 121.407 300.149L122.573 301.489L125.605 298.851L125.881 298.612L125.872 298.602Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="114.972"
        cy="292.196"
        rx="7.67308"
        ry="12"
        transform="rotate(-41.0209 114.972 292.196)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M125.872 604.31C128.745 601.415 127.742 595.325 123.518 590.47C119.294 585.614 113.403 583.777 110.138 586.222L110.129 586.212L109.853 586.452L106.821 589.09L107.986 590.43C107.719 593.463 109.103 597.281 111.94 600.542C114.777 603.803 118.367 605.703 121.407 605.857L122.573 607.197L125.605 604.559L125.881 604.32L125.872 604.31Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="114.972"
        cy="597.904"
        rx="7.67308"
        ry="12"
        transform="rotate(-41.0209 114.972 597.904)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M80.872 258.602C83.7455 255.706 82.7423 249.617 78.5182 244.762C74.2941 239.906 68.4025 238.069 65.1376 240.514L65.1288 240.504L64.8531 240.744L61.8207 243.382L62.9863 244.722C62.7187 247.755 64.1028 251.573 66.94 254.834C69.7771 258.095 73.3666 259.995 76.4071 260.149L77.5727 261.489L80.6051 258.851L80.8808 258.612L80.872 258.602Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="69.9722"
        cy="252.196"
        rx="7.67308"
        ry="12"
        transform="rotate(-41.0209 69.9722 252.196)"
        fill="#F9CC75"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M80.872 564.31C83.7455 561.415 82.7423 555.325 78.5182 550.47C74.2941 545.614 68.4025 543.777 65.1376 546.222L65.1288 546.212L64.8531 546.452L61.8207 549.09L62.9863 550.43C62.7187 553.463 64.1028 557.281 66.94 560.542C69.7771 563.803 73.3666 565.703 76.4071 565.857L77.5727 567.197L80.6051 564.559L80.8808 564.32L80.872 564.31Z"
        fill="#DFAA44"
      />
      <ellipse
        cx="69.9722"
        cy="557.904"
        rx="7.67308"
        ry="12"
        transform="rotate(-41.0209 69.9722 557.904)"
        fill="#F9CC75"
      />
    </svg>
  );
};
