export const EXAMPLE_TRANSACTION_DATA_BY_DATE = [
  {
    _id: "FBD7BA48AE83133F2158E145850E7F13BD7422780CBD143D8EA0E03660A42AEA#14652830",
    hash: "FBD7BA48AE83133F2158E145850E7F13BD7422780CBD143D8EA0E03660A42AEA",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-23T20:58:51.331Z",
    index: 4,
    height: 14652830,
    code: 0,
    info: "",
    gasWanted: 533786,
    gasUsed: 533786,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo19n4q7va8gdm2l7544k94pufhdp5tpu7pmfw4vqyvvzlzjvvc8v3qtyz27t",
      "osmo100jqvejpw0fyzd87gmswvt8vjuckazdzakeu8lr9ccdz7283hueqyjwd3s",
    ],
    messageTypes: [
      "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
    ],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pools: [
              {
                pool_id: "1400",
                token_out_denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
              },
            ],
            token_in_amount: "813400000",
          },
          {
            pools: [
              {
                pool_id: "1399",
                token_out_denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
              },
            ],
            token_in_amount: "348600000",
          },
        ],
        token_in_denom: "uosmo",
        token_out_min_amount: "131251765",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T09:41:57.451Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "2002", usd: 0.0025067057271103755 },
            ],
            txInfo: {
              tokenIn: {
                denom: "uosmo",
                amount: "1160803175",
                usd: 1453.4425408693346,
              },
              tokenOut: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "131911257",
                usd: 1456.0919263007333,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.038420521614265,
        price_date: "2024-04-02T20:59:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2521007627923955,
        price_date: "2024-04-02T20:59:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "FBD7BA48AE83133F2158E145850E7F13BD7422780CBD143D8EA0E03660A42AEA#14652830",
    hash: "FBD7BA48AE83133F2158E145850E7F13BD7422780CBD143D8EA0E03660A42AEA",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-22T20:58:51.331Z",
    index: 4,
    height: 14652830,
    code: 0,
    info: "",
    gasWanted: 533786,
    gasUsed: 533786,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo19n4q7va8gdm2l7544k94pufhdp5tpu7pmfw4vqyvvzlzjvvc8v3qtyz27t",
      "osmo100jqvejpw0fyzd87gmswvt8vjuckazdzakeu8lr9ccdz7283hueqyjwd3s",
    ],
    messageTypes: [
      "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
    ],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pools: [
              {
                pool_id: "1400",
                token_out_denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
              },
            ],
            token_in_amount: "813400000",
          },
          {
            pools: [
              {
                pool_id: "1399",
                token_out_denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
              },
            ],
            token_in_amount: "348600000",
          },
        ],
        token_in_denom: "uosmo",
        token_out_min_amount: "131251765",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T09:41:57.451Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "2002", usd: 0.0025067057271103755 },
            ],
            txInfo: {
              tokenIn: {
                denom: "uosmo",
                amount: "1160803175",
                usd: 1453.4425408693346,
              },
              tokenOut: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "131911257",
                usd: 1456.0919263007333,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.038420521614265,
        price_date: "2024-04-02T20:59:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2521007627923955,
        price_date: "2024-04-02T20:59:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "FBD7BA48AE83133F2158E145850E7F13BD7422780CBD143D8EA0E03660A42AEA#14652830",
    hash: "FBD7BA48AE83133F2158E145850E7F13BD7422780CBD143D8EA0E03660A42AEA",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-01-02T20:58:51.331Z",
    index: 4,
    height: 14652830,
    code: 0,
    info: "",
    gasWanted: 533786,
    gasUsed: 533786,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo19n4q7va8gdm2l7544k94pufhdp5tpu7pmfw4vqyvvzlzjvvc8v3qtyz27t",
      "osmo100jqvejpw0fyzd87gmswvt8vjuckazdzakeu8lr9ccdz7283hueqyjwd3s",
    ],
    messageTypes: [
      "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
    ],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pools: [
              {
                pool_id: "1400",
                token_out_denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
              },
            ],
            token_in_amount: "813400000",
          },
          {
            pools: [
              {
                pool_id: "1399",
                token_out_denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
              },
            ],
            token_in_amount: "348600000",
          },
        ],
        token_in_denom: "uosmo",
        token_out_min_amount: "131251765",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T09:41:57.451Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "2002", usd: 0.0025067057271103755 },
            ],
            txInfo: {
              tokenIn: {
                denom: "uosmo",
                amount: "1160803175",
                usd: 1453.4425408693346,
              },
              tokenOut: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "131911257",
                usd: 1456.0919263007333,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.038420521614265,
        price_date: "2024-04-02T20:59:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2521007627923955,
        price_date: "2024-04-02T20:59:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "FBD7BA48AE83133F2158E145850E7F13BD7422780CBD143D8EA0E03660A42AEA#14652830",
    hash: "FBD7BA48AE83133F2158E145850E7F13BD7422780CBD143D8EA0E03660A42AEA",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2023-01-02T20:58:51.331Z",
    index: 4,
    height: 14652830,
    code: 0,
    info: "",
    gasWanted: 533786,
    gasUsed: 533786,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo19n4q7va8gdm2l7544k94pufhdp5tpu7pmfw4vqyvvzlzjvvc8v3qtyz27t",
      "osmo100jqvejpw0fyzd87gmswvt8vjuckazdzakeu8lr9ccdz7283hueqyjwd3s",
    ],
    messageTypes: [
      "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
    ],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pools: [
              {
                pool_id: "1400",
                token_out_denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
              },
            ],
            token_in_amount: "813400000",
          },
          {
            pools: [
              {
                pool_id: "1399",
                token_out_denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
              },
            ],
            token_in_amount: "348600000",
          },
        ],
        token_in_denom: "uosmo",
        token_out_min_amount: "131251765",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T09:41:57.451Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "2002", usd: 0.0025067057271103755 },
            ],
            txInfo: {
              tokenIn: {
                denom: "uosmo",
                amount: "1160803175",
                usd: 1453.4425408693346,
              },
              tokenOut: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "131911257",
                usd: 1456.0919263007333,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.038420521614265,
        price_date: "2024-04-02T20:59:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2521007627923955,
        price_date: "2024-04-02T20:59:00.000Z",
        exponent: 6,
      },
    ],
  },
];

export const EXAMPLE_TRANSACTION_DATA = [
  {
    _id: "FBD7BA48AE83133F2158E145850E7F13BD7422780CBD143D8EA0E03660A42AEA#14652830",
    hash: "FBD7BA48AE83133F2158E145850E7F13BD7422780CBD143D8EA0E03660A42AEA",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T20:58:51.331Z",
    index: 4,
    height: 14652830,
    code: 0,
    info: "",
    gasWanted: 533786,
    gasUsed: 533786,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo19n4q7va8gdm2l7544k94pufhdp5tpu7pmfw4vqyvvzlzjvvc8v3qtyz27t",
      "osmo100jqvejpw0fyzd87gmswvt8vjuckazdzakeu8lr9ccdz7283hueqyjwd3s",
    ],
    messageTypes: [
      "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
    ],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pools: [
              {
                pool_id: "1400",
                token_out_denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
              },
            ],
            token_in_amount: "813400000",
          },
          {
            pools: [
              {
                pool_id: "1399",
                token_out_denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
              },
            ],
            token_in_amount: "348600000",
          },
        ],
        token_in_denom: "uosmo",
        token_out_min_amount: "131251765",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T09:41:57.451Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "2002", usd: 0.0025067057271103755 },
            ],
            txInfo: {
              tokenIn: {
                denom: "uosmo",
                amount: "1160803175",
                usd: 1453.4425408693346,
              },
              tokenOut: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "131911257",
                usd: 1456.0919263007333,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.038420521614265,
        price_date: "2024-04-02T20:59:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2521007627923955,
        price_date: "2024-04-02T20:59:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "B87135BDE4C31106C4C3E73D96580916F12379FEA64D70A2DDACF0A52093A9EB#14652821",
    hash: "B87135BDE4C31106C4C3E73D96580916F12379FEA64D70A2DDACF0A52093A9EB",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T20:58:12.597Z",
    index: 4,
    height: 14652821,
    code: 0,
    info: "",
    gasWanted: 1656872,
    gasUsed: 1656872,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1glw62sxnarqlte4g4kxh7z5pje0x0llfwe53jfec7uydc9xygv7srmknr9",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4982515",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "14736074",
        amount1: "7145074",
        token_min_amount0: "11788859",
        token_min_amount1: "5716059",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:28:40.204Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4971", usd: 0.006223770300893478 },
            ],
            txInfo: {
              poolId: "1263",
              tokens: [
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "7142694",
                  usd: 7.15232597515187,
                },
                { denom: "uosmo", amount: "14736074", usd: 18.44979676382389 },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2520157515376138,
        price_date: "2024-04-02T20:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001348507321169,
        price_date: "2024-04-02T20:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "F5E1E6E7187F117BA452711466972D5DBA80437A0AD57DF73119468DDF3BFE43#14652811",
    hash: "F5E1E6E7187F117BA452711466972D5DBA80437A0AD57DF73119468DDF3BFE43",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T20:57:26.957Z",
    index: 13,
    height: 14652811,
    code: 0,
    info: "",
    gasWanted: 1805369,
    gasUsed: 1805369,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1yw2qywpktk9ykqvd3pxj6ydnt7su70njjltnj0ky0stxlgkkdf4qn8lus7",
      "osmo12f8hx2y5qghfyy6dkqwe70kyptd966x9lf7cw272cap3gcggst9q654m5p",
      "osmo1hfvn84ea9ch4sth90qusqnyhgexvn3uqr95c7w4y3l39jvrfh3tqpd4fcn",
    ],
    messageTypes: [
      "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
    ],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pools: [
              {
                pool_id: "1079",
                token_out_denom:
                  "ibc/4ABBEF4C8926DDDB320AE5188CFD63267ABBCEFC0583E4AE05D6E5AA2401DDAB",
              },
              {
                pool_id: "1220",
                token_out_denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
              },
            ],
            token_in_amount: "390088",
          },
          {
            pools: [
              {
                pool_id: "1282",
                token_out_denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
              },
            ],
            token_in_amount: "260059",
          },
        ],
        token_in_denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        token_out_min_amount: "7102865",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T09:41:58.427Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "6771", usd: 0.008476638122181458 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "4935227",
                usd: 54.46899803596956,
              },
              tokenOut: {
                denom:
                  "ibc/4ABBEF4C8926DDDB320AE5188CFD63267ABBCEFC0583E4AE05D6E5AA2401DDAB",
                amount: "11429329",
                usd: 11.44578467891,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/4ABBEF4C8926DDDB320AE5188CFD63267ABBCEFC0583E4AE05D6E5AA2401DDAB",
        symbol: "USDT",
        price_usd: 1.0014397764654426,
        price_date: "2024-04-02T20:57:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.0012406654019046,
        price_date: "2024-04-02T20:57:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.036776633773798,
        price_date: "2024-04-02T20:57:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2519034296531468,
        price_date: "2024-04-02T20:57:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "2A2A0F734D23C8CFEB8B22B8BB5DC3F25144D6890FB3782B574E5ECF0AB52029#14652805",
    hash: "2A2A0F734D23C8CFEB8B22B8BB5DC3F25144D6890FB3782B574E5ECF0AB52029",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T20:57:01.538Z",
    index: 8,
    height: 14652805,
    code: 0,
    info: "",
    gasWanted: 515825,
    gasUsed: 515825,
    codespace: "",
    addressIndex: ["osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3"],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgCreatePosition"],
    memo: "",
    messages: [
      {
        pool_id: "1263",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        lower_tick: "224000",
        upper_tick: "319100",
        tokens_provided: [
          {
            denom:
              "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
            amount: "3891254",
          },
          { denom: "uosmo", amount: "8024713" },
        ],
        token_min_amount0: "6821006",
        token_min_amount1: "3307565",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCreatePosition",
      },
    ],
    ingested_at: "2024-04-07T03:49:00.362Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "1548", usd: 0.001938120383380226 },
            ],
            txInfo: {
              poolId: "1263",
              tokens: [
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "3888168",
                  usd: 3.893411223013935,
                },
                { denom: "uosmo", amount: "8024713", usd: 10.04706707756866 },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001348507321169,
        price_date: "2024-04-02T20:55:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2520157515376138,
        price_date: "2024-04-02T20:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "A06A2D77AD396CB85A52A058AEA86C459D7B4537B3B4F196F23CF25978346EAA#14652794",
    hash: "A06A2D77AD396CB85A52A058AEA86C459D7B4537B3B4F196F23CF25978346EAA",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T20:56:16.649Z",
    index: 1,
    height: 14652794,
    code: 0,
    info: "",
    gasWanted: 1066484,
    gasUsed: 1066484,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1glw62sxnarqlte4g4kxh7z5pje0x0llfwe53jfec7uydc9xygv7srmknr9",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
      "osmo15qle4t0azwg8etdn48n8lrvvwwut2wfe6lmkn5hk2faycs5gyalsf7eqgv",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgWithdrawPosition",
    ],
    memo: "",
    messages: [
      {
        position_id: "4953197",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        liquidity_amount: "64243427931583556735537039983",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgWithdrawPosition",
      },
    ],
    ingested_at: "2024-04-06T22:35:00.327Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_withdraw",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "3200", usd: 0.0040064504049203645 },
            ],
            txInfo: {
              poolId: "1263",
              tokens: [
                { denom: "uosmo", amount: "202151", usd: 0.25309623618908017 },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2520157515376138,
        price_date: "2024-04-02T20:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001348507321169,
        price_date: "2024-04-02T20:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "4BB1D1DAA566B4535C9B8787D4F9287C334CC78896331547235E6B6AA8979382#14652786",
    hash: "4BB1D1DAA566B4535C9B8787D4F9287C334CC78896331547235E6B6AA8979382",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T20:55:43.567Z",
    index: 13,
    height: 14652786,
    code: 0,
    info: "",
    gasWanted: 539897,
    gasUsed: 539897,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4981321"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4981321"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-04-02T20:58:24.358Z",
    metadata: [],
  },
  {
    _id: "9800CE8D71D05EB6F2CD3A4EC820BB76EEECBC524943F3C68587508EA59F55BE#14651893",
    hash: "9800CE8D71D05EB6F2CD3A4EC820BB76EEECBC524943F3C68587508EA59F55BE",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T19:51:48.435Z",
    index: 2,
    height: 14651893,
    code: 0,
    info: "",
    gasWanted: 594683,
    gasUsed: 594683,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
    ],
    messageTypes: ["/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn"],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [{ pool_id: "1263", token_out_denom: "uosmo" }],
        token_in: {
          denom:
            "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
          amount: "54078366",
        },
        token_out_min_amount: "42944220",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T17:44:26.320Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "2231", usd: 0.002791739559690384 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                amount: "53997275",
                usd: 54.01400754657252,
              },
              tokenOut: {
                denom: "uosmo",
                amount: "43160004",
                usd: 54.007839786282034,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2513400088258109,
        price_date: "2024-04-02T19:52:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.0003098776109076,
        price_date: "2024-04-02T19:52:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "59F0909697C9AC436787DA1D7FC5B4B7DBA9F4AE279F26E10034EE9CA4445A8F#14651881",
    hash: "59F0909697C9AC436787DA1D7FC5B4B7DBA9F4AE279F26E10034EE9CA4445A8F",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T19:50:56.578Z",
    index: 19,
    height: 14651881,
    code: 0,
    info: "",
    gasWanted: 1718069,
    gasUsed: 1718069,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4981307",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "60299031",
        amount1: "171601604",
        token_min_amount0: "48239224",
        token_min_amount1: "137281283",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:28:39.577Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "5155", usd: 0.006449048916903643 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "60162590",
                  usd: 663.8037010018987,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "171601604",
                  usd: 171.62158862059263,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.251027917925052,
        price_date: "2024-04-02T19:50:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.033496081234182,
        price_date: "2024-04-02T19:50:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.0001164594043808,
        price_date: "2024-04-02T19:50:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "CA43CEB537F960FE0BD89022D727DB96040F6A16037CE14A1707A1F11074F070#14651877",
    hash: "CA43CEB537F960FE0BD89022D727DB96040F6A16037CE14A1707A1F11074F070",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T19:50:39.225Z",
    index: 3,
    height: 14651877,
    code: 0,
    info: "",
    gasWanted: 1393407,
    gasUsed: 1393407,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1hfvn84ea9ch4sth90qusqnyhgexvn3uqr95c7w4y3l39jvrfh3tqpd4fcn",
      "osmo100jqvejpw0fyzd87gmswvt8vjuckazdzakeu8lr9ccdz7283hueqyjwd3s",
      "osmo13vhcd3xllpvz8tql4dzp8yszxeas8zxpzptyvjttdy7m64kuyz5sv6caqq",
    ],
    messageTypes: [
      "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
    ],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pools: [
              {
                pool_id: "1282",
                token_out_denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
              },
            ],
            token_in_amount: "16000000",
          },
          {
            pools: [
              { pool_id: "1399", token_out_denom: "uosmo" },
              {
                pool_id: "1464",
                token_out_denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
              },
            ],
            token_in_amount: "4000000",
          },
        ],
        token_in_denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        token_out_min_amount: "218930495",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T09:33:06.792Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "5226", usd: 0.006535175886022131 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "55153259",
                usd: 608.2795780391166,
              },
              tokenOut: {
                denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                amount: "255252023",
                usd: 255.21230933244453,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 0.999844413896945,
        price_date: "2024-04-02T19:51:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.250512033299298,
        price_date: "2024-04-02T19:51:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.028896371094165,
        price_date: "2024-04-02T19:51:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "37E21F5939A947B67E5FBA934E3CED7BE766DA08410449394DD4410E725426B0#14651869",
    hash: "37E21F5939A947B67E5FBA934E3CED7BE766DA08410449394DD4410E725426B0",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T19:50:06.135Z",
    index: 5,
    height: 14651869,
    code: 0,
    info: "",
    gasWanted: 518733,
    gasUsed: 518733,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15qle4t0azwg8etdn48n8lrvvwwut2wfe6lmkn5hk2faycs5gyalsf7eqgv",
      "osmo1glw62sxnarqlte4g4kxh7z5pje0x0llfwe53jfec7uydc9xygv7srmknr9",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4953197"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4953197"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-04-02T19:52:22.558Z",
    metadata: [],
  },
  {
    _id: "46AEB012B60B3D09977E8AE146110DDC291E7AAA5470A2BC219050EC70C13C84#14651865",
    hash: "46AEB012B60B3D09977E8AE146110DDC291E7AAA5470A2BC219050EC70C13C84",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T19:49:50.809Z",
    index: 25,
    height: 14651865,
    code: 0,
    info: "",
    gasWanted: 1713930,
    gasUsed: 1713930,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4981295",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "220283290",
        amount1: "626891763",
        token_min_amount0: "176226632",
        token_min_amount1: "501513410",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:28:46.295Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "5142", usd: 0.006433018370837816 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "219784843",
                  usd: 2425.004727164262,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "626891763",
                  usd: 627.007428379478,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2510731954177006,
        price_date: "2024-04-02T19:45:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.033539410924083,
        price_date: "2024-04-02T19:45:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.0001845061401422,
        price_date: "2024-04-02T19:45:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "00F0FA4E12D390437E8C50247D8CB673EA0BDF9B374AD56F926FCA8FE0643477#14651860",
    hash: "00F0FA4E12D390437E8C50247D8CB673EA0BDF9B374AD56F926FCA8FE0643477",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T19:49:28.337Z",
    index: 0,
    height: 14651860,
    code: 0,
    info: "",
    gasWanted: 1583748,
    gasUsed: 1583748,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo19n4q7va8gdm2l7544k94pufhdp5tpu7pmfw4vqyvvzlzjvvc8v3qtyz27t",
      "osmo13vhcd3xllpvz8tql4dzp8yszxeas8zxpzptyvjttdy7m64kuyz5sv6caqq",
      "osmo1hfvn84ea9ch4sth90qusqnyhgexvn3uqr95c7w4y3l39jvrfh3tqpd4fcn",
    ],
    messageTypes: [
      "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
    ],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pools: [
              { pool_id: "1400", token_out_denom: "uosmo" },
              {
                pool_id: "1464",
                token_out_denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
              },
            ],
            token_in_amount: "34200000",
          },
          {
            pools: [
              {
                pool_id: "1282",
                token_out_denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
              },
            ],
            token_in_amount: "22800000",
          },
        ],
        token_in_denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        token_out_min_amount: "623557958",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T09:33:08.127Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "5940", usd: 0.007428041527718169 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "357724274",
                usd: 3945.305017736067,
              },
              tokenOut: {
                denom: "uosmo",
                amount: "928015631",
                usd: 1160.4947214544748,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2505120417033955,
        price_date: "2024-04-02T19:49:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 0.9998474886149658,
        price_date: "2024-04-02T19:49:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.028899363245523,
        price_date: "2024-04-02T19:49:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "5771FBD169D5F42163E4CF78FF2DB88F1B27A3501FE5C0F07836A414E77BED15#14651854",
    hash: "5771FBD169D5F42163E4CF78FF2DB88F1B27A3501FE5C0F07836A414E77BED15",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T19:49:03.171Z",
    index: 3,
    height: 14651854,
    code: 0,
    info: "",
    gasWanted: 1713878,
    gasUsed: 1713878,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4981283",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "779995678",
        amount1: "2203328391",
        token_min_amount0: "623996542",
        token_min_amount1: "1762662712",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:28:41.027Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "5142", usd: 0.006433018370837816 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "772474950",
                  usd: 8523.132804776611,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "2203328391",
                  usd: 2203.734918616889,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2510731954177006,
        price_date: "2024-04-02T19:45:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.033539410924083,
        price_date: "2024-04-02T19:45:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.0001845061401422,
        price_date: "2024-04-02T19:45:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "1B79CC5C9F880A83BA661A57D8374F757F4548467C803B75F926445ED6AF7E2F#14651843",
    hash: "1B79CC5C9F880A83BA661A57D8374F757F4548467C803B75F926445ED6AF7E2F",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T19:48:15.173Z",
    index: 14,
    height: 14651843,
    code: 0,
    info: "",
    gasWanted: 1577385,
    gasUsed: 1577385,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4980103",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "388787518",
        amount1: "1098245286",
        token_min_amount0: "311030014",
        token_min_amount1: "878596228",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:28:44.034Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4733", usd: 0.005921329433911977 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "385038824",
                  usd: 4248.341039339862,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "1098245286",
                  usd: 1098.4479189986494,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2510731954177006,
        price_date: "2024-04-02T19:45:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.033539410924083,
        price_date: "2024-04-02T19:45:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.0001845061401422,
        price_date: "2024-04-02T19:45:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "97D062CB28D6D9182439E4A57E6C843B2899CCE9F4E7E300271F77F76E5573F5#14650511",
    hash: "97D062CB28D6D9182439E4A57E6C843B2899CCE9F4E7E300271F77F76E5573F5",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T18:12:31.980Z",
    index: 6,
    height: 14650511,
    code: 0,
    info: "",
    gasWanted: 841227,
    gasUsed: 841227,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo19n4q7va8gdm2l7544k94pufhdp5tpu7pmfw4vqyvvzlzjvvc8v3qtyz27t",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
    ],
    messageTypes: ["/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn"],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          { pool_id: "1400", token_out_denom: "uosmo" },
          {
            pool_id: "1263",
            token_out_denom:
              "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
          },
        ],
        token_in: {
          denom:
            "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
          amount: "100000000",
        },
        token_out_min_amount: "1092765320",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T17:35:27.929Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "3155", usd: 0.003925610225309968 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "99900000",
                usd: 1097.913768156501,
              },
              tokenOut: {
                denom: "uosmo",
                amount: "883154564",
                usd: 1098.8654792290226,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2442504676101325,
        price_date: "2024-04-02T18:13:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 0.999497806012761,
        price_date: "2024-04-02T18:13:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 10.990127809374384,
        price_date: "2024-04-02T18:13:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "D3DE90EDE279EABB6D7FD763B190A47D4E62EAD08B1450356CD46074A6168822#14650501",
    hash: "D3DE90EDE279EABB6D7FD763B190A47D4E62EAD08B1450356CD46074A6168822",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T18:11:47.112Z",
    index: 3,
    height: 14650501,
    code: 0,
    info: "",
    gasWanted: 1469706,
    gasUsed: 1469706,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4980095",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "942971250",
        amount1: "2196707793",
        token_min_amount0: "754377000",
        token_min_amount1: "1757366234",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:28:40.780Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4410", usd: 0.005488522942575262 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "942971249",
                  usd: 10367.051561027254,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "2196707793",
                  usd: 2196.3072777148986,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2445630255272704,
        price_date: "2024-04-02T18:10:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 10.994027200745816,
        price_date: "2024-04-02T18:10:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 0.9998176747556604,
        price_date: "2024-04-02T18:10:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "D6332B32963F9528DC19116CA850EBF4BC8D3196525A601839169AAACC70A774#14650494",
    hash: "D6332B32963F9528DC19116CA850EBF4BC8D3196525A601839169AAACC70A774",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T18:11:16.512Z",
    index: 5,
    height: 14650494,
    code: 0,
    info: "",
    gasWanted: 952671,
    gasUsed: 952671,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo19n4q7va8gdm2l7544k94pufhdp5tpu7pmfw4vqyvvzlzjvvc8v3qtyz27t",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
    ],
    messageTypes: ["/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn"],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          { pool_id: "1400", token_out_denom: "uosmo" },
          {
            pool_id: "1263",
            token_out_denom:
              "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
          },
        ],
        token_in: {
          denom:
            "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
          amount: "200000000",
        },
        token_out_min_amount: "2185736686",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T17:35:37.192Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "3573", usd: 0.0044454841852304165 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "199800000",
                usd: 2195.9832480737605,
              },
              tokenOut: {
                denom: "uosmo",
                amount: "1766464082",
                usd: 2197.8136412842337,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2441881290877181,
        price_date: "2024-04-02T18:11:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 0.999276114870156,
        price_date: "2024-04-02T18:11:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 10.99090714751632,
        price_date: "2024-04-02T18:11:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "37E49125DC56E57F06804D5E3A4730D49CDBEF253523EDEDFA30539EA2975D25#14650483",
    hash: "37E49125DC56E57F06804D5E3A4730D49CDBEF253523EDEDFA30539EA2975D25",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T18:10:28.956Z",
    index: 7,
    height: 14650483,
    code: 0,
    info: "",
    gasWanted: 575373,
    gasUsed: 575373,
    codespace: "",
    addressIndex: ["osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3"],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgCreatePosition"],
    memo: "",
    messages: [
      {
        pool_id: "1251",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        lower_tick: "9083000",
        upper_tick: "9188000",
        tokens_provided: [
          {
            denom:
              "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
            amount: "8463347",
          },
          {
            denom:
              "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
            amount: "19715870",
          },
        ],
        token_min_amount0: "7193844",
        token_min_amount1: "16758489",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCreatePosition",
      },
    ],
    ingested_at: "2024-04-06T21:24:04.718Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "1727", usd: 0.002149360345085596 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "8463347",
                  usd: 93.0462671273505,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "19715870",
                  usd: 19.71227529918488,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 10.994027200745816,
        price_date: "2024-04-02T18:10:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 0.9998176747556604,
        price_date: "2024-04-02T18:10:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2445630255272704,
        price_date: "2024-04-02T18:10:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "D41D8CFA481B23B0A73ACC3082ADD53949A58B5A24BFF3E2BC5D15B4647AB971#14650367",
    hash: "D41D8CFA481B23B0A73ACC3082ADD53949A58B5A24BFF3E2BC5D15B4647AB971",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T18:02:06.833Z",
    index: 15,
    height: 14650367,
    code: 0,
    info: "",
    gasWanted: 1076109,
    gasUsed: 1076109,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1nldrmuq5qa9k49m0dmm4k3399k778jvh962qgg7qqamsdt05qmussf888k",
      "osmo1h4ffzselefzgrf63k9n8c098ql849v3jhwjdvf7rzd42xd7m8tmsah4vv0",
      "osmo1s0qpx3kk2vyrw368m727rgdkzvq3u2vhhlaz82aehlu5wtc3d2tqc6gzlc",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgWithdrawPosition",
    ],
    memo: "",
    messages: [
      {
        position_id: "4956190",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        liquidity_amount: "179077199074737571813408226",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgWithdrawPosition",
      },
    ],
    ingested_at: "2024-04-06T22:35:02.188Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_withdraw",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "3229", usd: 0.004013337145466443 },
            ],
            txInfo: {
              poolId: "1265",
              tokens: [
                { denom: "uosmo", amount: "10227", usd: 0.012711179618050577 },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2429040400949034,
        price_date: "2024-04-02T18:00:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 10.977138195276918,
        price_date: "2024-04-02T18:00:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "9D9923AA49B41E8F9E3CA6E26B0164784B49BDE88E6C3B8D22E149D6764FA7FF#14650360",
    hash: "9D9923AA49B41E8F9E3CA6E26B0164784B49BDE88E6C3B8D22E149D6764FA7FF",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T18:01:38.317Z",
    index: 19,
    height: 14650360,
    code: 0,
    info: "",
    gasWanted: 1000358,
    gasUsed: 1000358,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgWithdrawPosition",
    ],
    memo: "",
    messages: [
      {
        position_id: "4956136",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        liquidity_amount: "584664324007195934677514383342",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgWithdrawPosition",
      },
    ],
    ingested_at: "2024-04-06T22:35:03.995Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_withdraw",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "3002", usd: 0.0037311979283649 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "2960263056",
                  usd: 32495.216660084774,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 10.977138195276918,
        price_date: "2024-04-02T18:00:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2429040400949034,
        price_date: "2024-04-02T18:00:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "3C3EE8523E1737D44283F72E7C855A414010E445877F8BE59AFDFE0E277D4072#14650352",
    hash: "3C3EE8523E1737D44283F72E7C855A414010E445877F8BE59AFDFE0E277D4072",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-02T18:01:03.666Z",
    index: 9,
    height: 14650352,
    code: 0,
    info: "",
    gasWanted: 472023,
    gasUsed: 472023,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4956136"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4956136"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-04-02T18:04:08.850Z",
    metadata: [],
  },
  {
    _id: "F0260D1CA1F8C4F93CCBB28CF391326DFB2DD859A3FFEBD802FAF61FB0E5192B#14634404",
    hash: "F0260D1CA1F8C4F93CCBB28CF391326DFB2DD859A3FFEBD802FAF61FB0E5192B",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-01T22:48:48.039Z",
    index: 2,
    height: 14634404,
    code: 0,
    info: "",
    gasWanted: 549440,
    gasUsed: 549440,
    codespace: "",
    addressIndex: ["osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3"],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgCreatePosition"],
    memo: "",
    messages: [
      {
        pool_id: "1265",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        lower_tick: "-8881700",
        upper_tick: "-8870400",
        tokens_provided: [
          {
            denom:
              "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
            amount: "144596",
          },
          { denom: "uosmo", amount: "1395307" },
        ],
        token_min_amount0: "1186010",
        token_min_amount1: "0",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCreatePosition",
      },
    ],
    ingested_at: "2024-04-07T03:49:10.926Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "1649", usd: 0.0021602205619995376 },
            ],
            txInfo: {
              poolId: "1265",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "144596",
                  usd: 1.6849808225832328,
                },
                { denom: "uosmo", amount: "1395307", usd: 1.8278780301406239 },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.653025136125708,
        price_date: "2024-04-01T22:45:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3100185336564811,
        price_date: "2024-04-01T22:45:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "06A400D8FA6A31E01AD19DA2E2FBD93F437F95AF1685A93F8978691772ACA743#14634364",
    hash: "06A400D8FA6A31E01AD19DA2E2FBD93F437F95AF1685A93F8978691772ACA743",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-01T22:45:57.914Z",
    index: 10,
    height: 14634364,
    code: 0,
    info: "",
    gasWanted: 489516,
    gasUsed: 489516,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1jv65s3grqf6v6jl3dp4t6c9t9rk99cd80yhvld",
    ],
    messageTypes: ["/osmosis.valsetpref.v1beta1.MsgDelegateToValidatorSet"],
    memo: "",
    messages: [
      {
        delegator: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        coin: { denom: "uosmo", amount: "117902896" },
        "@type": "/osmosis.valsetpref.v1beta1.MsgDelegateToValidatorSet",
      },
    ],
    ingested_at: "2024-04-01T22:47:31.654Z",
    metadata: [],
  },
  {
    _id: "5BEE2F7C447B39CD5FB3A18C8ABCBB02024053AA0EF942C3C33A4CE042334D3E#14634356",
    hash: "5BEE2F7C447B39CD5FB3A18C8ABCBB02024053AA0EF942C3C33A4CE042334D3E",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-01T22:45:23.017Z",
    index: 1,
    height: 14634356,
    code: 0,
    info: "",
    gasWanted: 577689,
    gasUsed: 577689,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo13vhcd3xllpvz8tql4dzp8yszxeas8zxpzptyvjttdy7m64kuyz5sv6caqq",
    ],
    messageTypes: ["/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn"],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [{ pool_id: "1464", token_out_denom: "uosmo" }],
        token_in: {
          denom:
            "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
          amount: "137360373",
        },
        token_out_min_amount: "104237154",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T17:50:26.576Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "1734", usd: 0.0022717680679827244 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                amount: "137209290",
                usd: 137.2201563151811,
              },
              tokenOut: {
                denom: "uosmo",
                amount: "104763053",
                usd: 137.25337861002407,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3101315270949967,
        price_date: "2024-04-01T22:45:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.0000791951855525,
        price_date: "2024-04-01T22:45:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "F4D58CD51CB1A18BD8346AC073E2697054677C9CB9B806D1DE46C084DE8D113B#14634351",
    hash: "F4D58CD51CB1A18BD8346AC073E2697054677C9CB9B806D1DE46C084DE8D113B",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-01T22:45:00.553Z",
    index: 11,
    height: 14634351,
    code: 0,
    info: "",
    gasWanted: 1521972,
    gasUsed: 1521972,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4956106",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "3103996",
        amount1: "53144212",
        token_min_amount0: "2483196",
        token_min_amount1: "42515369",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:28:55.878Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4566", usd: 0.005981544624675493 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "2959400",
                  usd: 34.485962587850416,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "53144212",
                  usd: 53.1429640941484,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3100185336564811,
        price_date: "2024-04-01T22:45:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.653025136125708,
        price_date: "2024-04-01T22:45:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 0.9999765184992938,
        price_date: "2024-04-01T22:45:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "9185E989B8F871495D79166EFC093F0CE5294711B5EEB23979D141BFCC3321D4#14634341",
    hash: "9185E989B8F871495D79166EFC093F0CE5294711B5EEB23979D141BFCC3321D4",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-01T22:44:19.241Z",
    index: 7,
    height: 14634341,
    code: 0,
    info: "",
    gasWanted: 518094,
    gasUsed: 518094,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15qle4t0azwg8etdn48n8lrvvwwut2wfe6lmkn5hk2faycs5gyalsf7eqgv",
      "osmo1glw62sxnarqlte4g4kxh7z5pje0x0llfwe53jfec7uydc9xygv7srmknr9",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4953197"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4953197"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-04-01T22:48:48.043Z",
    metadata: [],
  },
  {
    _id: "B1932B873C1F83A33AF708F630A92DE446B7FA6904EF0D9E1E45E6BAABA233AD#14634313",
    hash: "B1932B873C1F83A33AF708F630A92DE446B7FA6904EF0D9E1E45E6BAABA233AD",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-01T22:42:22.153Z",
    index: 14,
    height: 14634313,
    code: 0,
    info: "",
    gasWanted: 1546469,
    gasUsed: 1546469,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4953124",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "2116492",
        amount1: "36236934",
        token_min_amount0: "1693193",
        token_min_amount1: "28989547",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:29:02.146Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4640", usd: 0.006078342436678749 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "2116492",
                  usd: 24.64898347342091,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "36236921",
                  usd: 36.24868954601568,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3099875941117993,
        price_date: "2024-04-01T22:40:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.646150079197517,
        price_date: "2024-04-01T22:40:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.000324766721093,
        price_date: "2024-04-01T22:40:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "CB4A63F1F786B9C9287CD5E0D309E6A99A18072EE34AB23CE04501922E5DE9F9#14631187",
    hash: "CB4A63F1F786B9C9287CD5E0D309E6A99A18072EE34AB23CE04501922E5DE9F9",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-01T18:56:01.908Z",
    index: 0,
    height: 14631187,
    code: 0,
    info: "",
    gasWanted: 236976,
    gasUsed: 236976,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1mw0ac6rwlp5r8wapwk3zs6g29h8fcscxqakdzw9emkne6c8wjp9q0t3v8t",
    ],
    messageTypes: ["/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn"],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pool_id: "1",
            token_out_denom:
              "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
          },
        ],
        token_in: { denom: "uosmo", amount: "18000000" },
        token_out_min_amount: "2021835",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T13:59:36.460Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "889", usd: 0.0011525926121691323 },
            ],
            txInfo: {
              tokenIn: {
                denom: "uosmo",
                amount: "17982000",
                usd: 23.313746177756283,
              },
              tokenOut: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "2031995",
                usd: 23.28119881882682,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.457311075483364,
        price_date: "2024-04-01T18:56:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2965046256120722,
        price_date: "2024-04-01T18:56:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "9722E2CAB8509B3F748BB45889B90EB96CCB0B330FA03DCF72F20E21DCF3EDAC#14631176",
    hash: "9722E2CAB8509B3F748BB45889B90EB96CCB0B330FA03DCF72F20E21DCF3EDAC",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-01T18:55:14.313Z",
    index: 11,
    height: 14631176,
    code: 0,
    info: "",
    gasWanted: 1709148,
    gasUsed: 1709148,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1glw62sxnarqlte4g4kxh7z5pje0x0llfwe53jfec7uydc9xygv7srmknr9",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
      "osmo15qle4t0azwg8etdn48n8lrvvwwut2wfe6lmkn5hk2faycs5gyalsf7eqgv",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4953180",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "1000022642",
        amount1: "424346542",
        token_min_amount0: "800018113",
        token_min_amount1: "339477233",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:29:00.017Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "5128", usd: 0.006646984339331619 },
            ],
            txInfo: {
              poolId: "1263",
              tokens: [
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "424346542",
                  usd: 424.4794339521405,
                },
                {
                  denom: "uosmo",
                  amount: "979581034",
                  usd: 1269.7464493183063,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2962137947214547,
        price_date: "2024-04-01T18:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.0003131684578226,
        price_date: "2024-04-01T18:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "796ADA49EEF11E1F91DFC933E4E15623DDF787D2E9758D21A12A46E56120568C#14631172",
    hash: "796ADA49EEF11E1F91DFC933E4E15623DDF787D2E9758D21A12A46E56120568C",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-01T18:54:58.954Z",
    index: 1,
    height: 14631172,
    code: 0,
    info: "",
    gasWanted: 576356,
    gasUsed: 576356,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo13vhcd3xllpvz8tql4dzp8yszxeas8zxpzptyvjttdy7m64kuyz5sv6caqq",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
    ],
    messageTypes: [
      "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
    ],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pools: [
              {
                pool_id: "1464",
                token_out_denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
              },
            ],
            token_in_amount: "356000000",
          },
          {
            pools: [
              {
                pool_id: "1263",
                token_out_denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
              },
            ],
            token_in_amount: "89000000",
          },
        ],
        token_in_denom: "uosmo",
        token_out_min_amount: "572641990",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T09:34:02.201Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "1730", usd: 0.0022427246788101055 },
            ],
            txInfo: {
              tokenIn: {
                denom: "uosmo",
                amount: "444474981",
                usd: 576.2052075158109,
              },
              tokenOut: {
                denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                amount: "576286967",
                usd: 576.686489570655,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.0006932701822753,
        price_date: "2024-04-01T18:55:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2963726467110437,
        price_date: "2024-04-01T18:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "EAA473C58C17F0A583346452607496494867CEAF0FC9ABB9305D525E641F8809#14631164",
    hash: "EAA473C58C17F0A583346452607496494867CEAF0FC9ABB9305D525E641F8809",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-01T18:54:26.006Z",
    index: 21,
    height: 14631164,
    code: 0,
    info: "",
    gasWanted: 444647,
    gasUsed: 444647,
    codespace: "",
    addressIndex: ["osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3"],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgCreatePosition"],
    memo: "",
    messages: [
      {
        pool_id: "1263",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        lower_tick: "250000",
        upper_tick: "439000",
        tokens_provided: [
          {
            denom:
              "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
            amount: "851707701",
          },
          { denom: "uosmo", amount: "1960815361" },
        ],
        token_min_amount0: "1666693056",
        token_min_amount1: "723951545",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCreatePosition",
      },
    ],
    ingested_at: "2024-04-06T21:24:54.079Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "1334", usd: 0.001728490833596854 },
            ],
            txInfo: {
              poolId: "1263",
              tokens: [
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "851707701",
                  usd: 852.14125144693,
                },
                {
                  denom: "uosmo",
                  amount: "1923676336",
                  usd: 2492.546411981396,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.000509036664129,
        price_date: "2024-04-01T18:50:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.295720265065108,
        price_date: "2024-04-01T18:50:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "A3618E0661A04CD9768ABC6C93F1626A6A55F137F64CF2291F159CCDCC7165DF#14631123",
    hash: "A3618E0661A04CD9768ABC6C93F1626A6A55F137F64CF2291F159CCDCC7165DF",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-01T18:51:26.941Z",
    index: 22,
    height: 14631123,
    code: 0,
    info: "",
    gasWanted: 1079891,
    gasUsed: 1079891,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1glw62sxnarqlte4g4kxh7z5pje0x0llfwe53jfec7uydc9xygv7srmknr9",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
      "osmo15qle4t0azwg8etdn48n8lrvvwwut2wfe6lmkn5hk2faycs5gyalsf7eqgv",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgWithdrawPosition",
    ],
    memo: "",
    messages: [
      {
        position_id: "4880645",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        liquidity_amount: "104529969247548138685343913701",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgWithdrawPosition",
      },
    ],
    ingested_at: "2024-04-06T22:35:28.118Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_withdraw",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "3240", usd: 0.00419813365881095 },
            ],
            txInfo: {
              poolId: "1263",
              tokens: [
                { denom: "uosmo", amount: "3014663", usd: 3.906159941441974 },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.295720265065108,
        price_date: "2024-04-01T18:50:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.000509036664129,
        price_date: "2024-04-01T18:50:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "B951A7A7363001898FF823A9E9E694508996B12CDD748768F851AC210513B59D#14631118",
    hash: "B951A7A7363001898FF823A9E9E694508996B12CDD748768F851AC210513B59D",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-01T18:51:06.021Z",
    index: 5,
    height: 14631118,
    code: 0,
    info: "",
    gasWanted: 1793435,
    gasUsed: 1793435,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4953101",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "1175418538",
        amount1: "1769499268",
        token_min_amount0: "940334830",
        token_min_amount1: "1415599414",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:35:05.737Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "5381", usd: 0.006972270746315347 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "1175418538",
                  usd: 13461.812104226912,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "1437615979",
                  usd: 1438.3477782422485,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.295720265065108,
        price_date: "2024-04-01T18:50:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.452781855161547,
        price_date: "2024-04-01T18:50:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.000509036664129,
        price_date: "2024-04-01T18:50:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "6B89BC996E4FD2573091503CEE88A2F7ADA576C9D60DD1DFAC9539ACC11DE3F8#14631112",
    hash: "6B89BC996E4FD2573091503CEE88A2F7ADA576C9D60DD1DFAC9539ACC11DE3F8",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-01T18:50:39.909Z",
    index: 14,
    height: 14631112,
    code: 0,
    info: "",
    gasWanted: 1401702,
    gasUsed: 1401702,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1hfvn84ea9ch4sth90qusqnyhgexvn3uqr95c7w4y3l39jvrfh3tqpd4fcn",
      "osmo19n4q7va8gdm2l7544k94pufhdp5tpu7pmfw4vqyvvzlzjvvc8v3qtyz27t",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
    ],
    messageTypes: [
      "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
    ],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pools: [
              {
                pool_id: "1282",
                token_out_denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
              },
            ],
            token_in_amount: "100000000",
          },
          {
            pools: [
              { pool_id: "1400", token_out_denom: "uosmo" },
              {
                pool_id: "1263",
                token_out_denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
              },
            ],
            token_in_amount: "100000000",
          },
        ],
        token_in_denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        token_out_min_amount: "2273612332",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T09:34:05.752Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4206", usd: 0.005448888488464019 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "1082557858",
                usd: 12396.293717984428,
              },
              tokenOut: {
                denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                amount: "3169372216",
                usd: 3170.6850363836743,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.0004142209542466,
        price_date: "2024-04-01T18:51:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2955036824688586,
        price_date: "2024-04-01T18:51:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.450929505870743,
        price_date: "2024-04-01T18:51:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "B29986589D02246F4D601EBC2008B8C77A0ABD931538D6712A5D299C13E8115F#14631100",
    hash: "B29986589D02246F4D601EBC2008B8C77A0ABD931538D6712A5D299C13E8115F",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-01T18:49:45.711Z",
    index: 10,
    height: 14631100,
    code: 0,
    info: "",
    gasWanted: 1211765,
    gasUsed: 1211765,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo100jqvejpw0fyzd87gmswvt8vjuckazdzakeu8lr9ccdz7283hueqyjwd3s",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
    ],
    messageTypes: ["/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn"],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          { pool_id: "1399", token_out_denom: "uosmo" },
          {
            pool_id: "1263",
            token_out_denom:
              "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
          },
        ],
        token_in: {
          denom:
            "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
          amount: "200000000",
        },
        token_out_min_amount: "2277789193",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T13:59:37.009Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "3636", usd: 0.0047098660973375235 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "199780020",
                usd: 2286.9609810934476,
              },
              tokenOut: {
                denom: "uosmo",
                amount: "1768104411",
                usd: 2290.3011611446177,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2953427110389228,
        price_date: "2024-04-01T18:50:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.0007676499168927,
        price_date: "2024-04-01T18:50:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.447395896213482,
        price_date: "2024-04-01T18:50:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "77B2BB43340BE7546AEBFE77FEB29E4E866E81766C62A4DB29011A6C10DBD405#14631092",
    hash: "77B2BB43340BE7546AEBFE77FEB29E4E866E81766C62A4DB29011A6C10DBD405",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-01T18:49:07.127Z",
    index: 7,
    height: 14631092,
    code: 0,
    info: "",
    gasWanted: 996423,
    gasUsed: 996423,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgWithdrawPosition",
    ],
    memo: "",
    messages: [
      {
        position_id: "4933498",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        liquidity_amount: "435501523100354272208326161604",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgWithdrawPosition",
      },
    ],
    ingested_at: "2024-04-06T22:35:28.859Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_withdraw",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "2990", usd: 0.0038737548120860773 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "3018909603",
                  usd: 34553.31779960885,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.445628502844855,
        price_date: "2024-04-01T18:45:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2955701712662466,
        price_date: "2024-04-01T18:45:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "F616E1F00093E149DACC7AFE36B1000B060D5159DFFDCE55A4A82DF22B45FBC1#14631086",
    hash: "F616E1F00093E149DACC7AFE36B1000B060D5159DFFDCE55A4A82DF22B45FBC1",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-01T18:48:40.070Z",
    index: 3,
    height: 14631086,
    code: 0,
    info: "",
    gasWanted: 575259,
    gasUsed: 575259,
    codespace: "",
    addressIndex: ["osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3"],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgCreatePosition"],
    memo: "",
    messages: [
      {
        pool_id: "1251",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        lower_tick: "9140000",
        upper_tick: "9180000",
        tokens_provided: [
          {
            denom:
              "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
            amount: "1208020",
          },
          {
            denom:
              "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
            amount: "1818578",
          },
        ],
        token_min_amount0: "1026817",
        token_min_amount1: "1545791",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCreatePosition",
      },
    ],
    ingested_at: "2024-04-06T21:24:54.446Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "1726", usd: 0.002236154115605542 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "1208020",
                  usd: 13.826548144006642,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "1816228",
                  usd: 1.8161139827648083,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 11.445628502844855,
        price_date: "2024-04-01T18:45:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 0.9999372230605454,
        price_date: "2024-04-01T18:45:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2955701712662466,
        price_date: "2024-04-01T18:45:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "61CBEC08590BF4EAAA976B78921F66547EDA8899E6CDE44D0235970B7FE7ABE4#14631060",
    hash: "61CBEC08590BF4EAAA976B78921F66547EDA8899E6CDE44D0235970B7FE7ABE4",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-01T18:46:47.149Z",
    index: 11,
    height: 14631060,
    code: 0,
    info: "",
    gasWanted: 540144,
    gasUsed: 540144,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4933498"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4933498"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-04-01T18:53:33.945Z",
    metadata: [],
  },
  {
    _id: "C5DBCC1AAB25248224B85405ED16D6F02DF41D79523371113A7106608B1EB218#14631056",
    hash: "C5DBCC1AAB25248224B85405ED16D6F02DF41D79523371113A7106608B1EB218",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-04-01T18:46:29.042Z",
    index: 5,
    height: 14631056,
    code: 0,
    info: "",
    gasWanted: 1003895,
    gasUsed: 1003895,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1glw62sxnarqlte4g4kxh7z5pje0x0llfwe53jfec7uydc9xygv7srmknr9",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
      "osmo15qle4t0azwg8etdn48n8lrvvwwut2wfe6lmkn5hk2faycs5gyalsf7eqgv",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgWithdrawPosition",
    ],
    memo: "",
    messages: [
      {
        position_id: "4933473",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        liquidity_amount: "1286685433032199502086967905",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgWithdrawPosition",
      },
    ],
    ingested_at: "2024-04-06T22:35:27.768Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_withdraw",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "3012", usd: 0.0039022573558539345 },
            ],
            txInfo: {
              poolId: "1263",
              tokens: [
                { denom: "uosmo", amount: "11667", usd: 0.0151154171881633 },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.2955701712662466,
        price_date: "2024-04-01T18:45:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 0.9999372230605454,
        price_date: "2024-04-01T18:45:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "3876D3F69675255B923F7C2AAEA94EBC7F5770328D998878F3B418B3098BAD82#14615448",
    hash: "3876D3F69675255B923F7C2AAEA94EBC7F5770328D998878F3B418B3098BAD82",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-31T23:56:47.347Z",
    index: 14,
    height: 14615448,
    code: 0,
    info: "",
    gasWanted: 1478214,
    gasUsed: 1478214,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4933480",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "731725",
        amount1: "210088",
        token_min_amount0: "585380",
        token_min_amount1: "168070",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:37:43.464Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4435", usd: 0.005950340834975488 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "731721",
                  usd: 9.14829703091692,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "210088",
                  usd: 0.21035264666849945,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.502438813313983,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "C4551B69A85A06F2F62EEAB480C0C8AFC983BF094933DB940148DA46C5A93710#14615444",
    hash: "C4551B69A85A06F2F62EEAB480C0C8AFC983BF094933DB940148DA46C5A93710",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-31T23:56:30.111Z",
    index: 0,
    height: 14615444,
    code: 0,
    info: "",
    gasWanted: 659819,
    gasUsed: 659819,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1r0ut8fz8w6nue4nr0c4e8jykgtukcpccydn23sfq0fnas05007nsflmxrw",
      "osmo1qrnsjncq2kul2j43y6m2raz2yyvujz7373nl9lp08875kgell74sx4fz0p",
    ],
    messageTypes: ["/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn"],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pool_id: "1093",
            token_out_denom:
              "ibc/1480B8FD20AD5FCAE81EA87584D269547DD4D436843C1D20F15E00EB64743EF4",
          },
          {
            pool_id: "1301",
            token_out_denom:
              "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
          },
        ],
        token_in: { denom: "uosmo", amount: "400000" },
        token_out_min_amount: "549176",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T14:02:42.909Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "1980", usd: 0.002736842130791357 },
            ],
            txInfo: {
              tokenIn: {
                denom: "uosmo",
                amount: "398801",
                usd: 0.551240090202891,
              },
              tokenOut: {
                denom:
                  "ibc/1480B8FD20AD5FCAE81EA87584D269547DD4D436843C1D20F15E00EB64743EF4",
                amount: "115561",
                usd: 0.5515785588266984,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/1480B8FD20AD5FCAE81EA87584D269547DD4D436843C1D20F15E00EB64743EF4",
        symbol: "AKT",
        price_usd: 4.773051105707794,
        price_date: "2024-03-31T23:57:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.0005648577269777,
        price_date: "2024-03-31T23:57:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3822435003996754,
        price_date: "2024-03-31T23:57:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "79338B4F77E521148D00CBD03DDC525A3619A43BA7CD2680F0A8523236D7194C#14615436",
    hash: "79338B4F77E521148D00CBD03DDC525A3619A43BA7CD2680F0A8523236D7194C",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-31T23:55:55.196Z",
    index: 12,
    height: 14615436,
    code: 0,
    info: "",
    gasWanted: 1194308,
    gasUsed: 1194308,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo12f8hx2y5qghfyy6dkqwe70kyptd966x9lf7cw272cap3gcggst9q654m5p",
      "osmo1yw2qywpktk9ykqvd3pxj6ydnt7su70njjltnj0ky0stxlgkkdf4qn8lus7",
    ],
    messageTypes: ["/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn"],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pool_id: "1220",
            token_out_denom:
              "ibc/4ABBEF4C8926DDDB320AE5188CFD63267ABBCEFC0583E4AE05D6E5AA2401DDAB",
          },
          {
            pool_id: "1079",
            token_out_denom:
              "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
          },
        ],
        token_in: {
          denom:
            "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
          amount: "8987023",
        },
        token_out_min_amount: "728066",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T14:02:48.639Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "3583", usd: 0.00495821130580615 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                amount: "8984327",
                usd: 8.998379285216119,
              },
              tokenOut: {
                denom:
                  "ibc/4ABBEF4C8926DDDB320AE5188CFD63267ABBCEFC0583E4AE05D6E5AA2401DDAB",
                amount: "8982980",
                usd: 9.00250386268002,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/4ABBEF4C8926DDDB320AE5188CFD63267ABBCEFC0583E4AE05D6E5AA2401DDAB",
        symbol: "USDT",
        price_usd: 1.0021734282699084,
        price_date: "2024-03-31T23:56:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.297222834243717,
        price_date: "2024-03-31T23:56:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.0015640887977606,
        price_date: "2024-03-31T23:56:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3838156030717697,
        price_date: "2024-03-31T23:56:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "44D00EC0B5F561230447DFEED5E4AC52E86E2D7E80F8B297943D9C45556D6E91#14615428",
    hash: "44D00EC0B5F561230447DFEED5E4AC52E86E2D7E80F8B297943D9C45556D6E91",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-31T23:55:22.715Z",
    index: 4,
    height: 14615428,
    code: 0,
    info: "",
    gasWanted: 1520820,
    gasUsed: 1520820,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4921620",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "933581",
        amount1: "268044",
        token_min_amount0: "746864",
        token_min_amount1: "214435",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:37:49.358Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4563", usd: 0.006122075587371625 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "933581",
                  usd: 11.672039329772481,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "268044",
                  usd: 0.2683816535147713,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.502438813313983,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "E3109D63DF8BB89B8BD6B75920A587048AE4007D60199A7EEEEF2FCEACCBA792#14615420",
    hash: "E3109D63DF8BB89B8BD6B75920A587048AE4007D60199A7EEEEF2FCEACCBA792",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-31T23:54:49.894Z",
    index: 13,
    height: 14615420,
    code: 0,
    info: "",
    gasWanted: 1504544,
    gasUsed: 1504544,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1glw62sxnarqlte4g4kxh7z5pje0x0llfwe53jfec7uydc9xygv7srmknr9",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
      "osmo15qle4t0azwg8etdn48n8lrvvwwut2wfe6lmkn5hk2faycs5gyalsf7eqgv",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4921615",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "6989061",
        amount1: "3059742",
        token_min_amount0: "5591248",
        token_min_amount1: "2447793",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:37:42.413Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4514", usd: 0.006056333377469979 },
            ],
            txInfo: {
              poolId: "1263",
              tokens: [
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "3059742",
                  usd: 3.063596339737481,
                },
                { denom: "uosmo", amount: "6565423", usd: 8.808681978756995 },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "C3602F007D2BC56406DFE009E0EEE2545FB3C1BB3920AD064BCC1A375E85E308#14615414",
    hash: "C3602F007D2BC56406DFE009E0EEE2545FB3C1BB3920AD064BCC1A375E85E308",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-31T23:54:24.096Z",
    index: 6,
    height: 14615414,
    code: 0,
    info: "",
    gasWanted: 520578,
    gasUsed: 520578,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15qle4t0azwg8etdn48n8lrvvwwut2wfe6lmkn5hk2faycs5gyalsf7eqgv",
      "osmo1glw62sxnarqlte4g4kxh7z5pje0x0llfwe53jfec7uydc9xygv7srmknr9",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4880645"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4880645"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-04-01T00:00:15.979Z",
    metadata: [],
  },
  {
    _id: "4783B21EE7A2FCDE52665CC2199B2237FE0B525F645E51DCF9613BFFCC4BB422#14615409",
    hash: "4783B21EE7A2FCDE52665CC2199B2237FE0B525F645E51DCF9613BFFCC4BB422",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-31T23:54:02.921Z",
    index: 20,
    height: 14615409,
    code: 0,
    info: "",
    gasWanted: 540320,
    gasUsed: 540320,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4921620"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4921620"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-03-31T23:57:51.809Z",
    metadata: [],
  },
  {
    _id: "45CCBED5F0A4809C835F65B1B2E744E0090C0641914E1AE9D08699087759B6D6#14605175",
    hash: "45CCBED5F0A4809C835F65B1B2E744E0090C0641914E1AE9D08699087759B6D6",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-31T11:31:18.669Z",
    index: 3,
    height: 14605175,
    code: 0,
    info: "",
    gasWanted: 489338,
    gasUsed: 489338,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1jv65s3grqf6v6jl3dp4t6c9t9rk99cd80yhvld",
    ],
    messageTypes: ["/osmosis.valsetpref.v1beta1.MsgDelegateToValidatorSet"],
    memo: "",
    messages: [
      {
        delegator: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        coin: { denom: "uosmo", amount: "14419758" },
        "@type": "/osmosis.valsetpref.v1beta1.MsgDelegateToValidatorSet",
      },
    ],
    ingested_at: "2024-03-31T11:32:29.576Z",
    metadata: [],
  },
  {
    _id: "2985DD91C55498E636FEE281A4BAD7E87FAC64D060630E85120C3107A59A1755#14605170",
    hash: "2985DD91C55498E636FEE281A4BAD7E87FAC64D060630E85120C3107A59A1755",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-31T11:30:57.172Z",
    index: 3,
    height: 14605170,
    code: 0,
    info: "",
    gasWanted: 577314,
    gasUsed: 577314,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
    ],
    messageTypes: ["/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn"],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [{ pool_id: "1263", token_out_denom: "uosmo" }],
        token_in: {
          denom:
            "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
          amount: "19713921",
        },
        token_out_min_amount: "14233111",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T17:58:11.103Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "1732", usd: 0.002390405791855672 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                amount: "19684360",
                usd: 19.726306984351634,
              },
              tokenOut: {
                denom: "uosmo",
                amount: "14304636",
                usd: 19.74242768174778,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3801419121568546,
        price_date: "2024-03-31T11:31:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.0021309803494567,
        price_date: "2024-03-31T11:31:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "BECFAE94FE7030C08436F8B07ADF2B0DF9E601D47EBEC1812E6176C63E2E6602#14605161",
    hash: "BECFAE94FE7030C08436F8B07ADF2B0DF9E601D47EBEC1812E6176C63E2E6602",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-31T11:30:19.953Z",
    index: 4,
    height: 14605161,
    code: 0,
    info: "",
    gasWanted: 1525118,
    gasUsed: 1525118,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4913707",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "1847766",
        amount1: "1099907",
        token_min_amount0: "1478212",
        token_min_amount1: "879925",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:37:48.955Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4576", usd: 0.006139517398161857 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "1847764",
                  usd: 23.101556351444298,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "1099907",
                  usd: 1.1012925466433554,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.502438813313983,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "604E9E2AE6A3348BA5D18255CD569FE6F382A0099C6361BD4F48F9F1F70FBAFE#14605156",
    hash: "604E9E2AE6A3348BA5D18255CD569FE6F382A0099C6361BD4F48F9F1F70FBAFE",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-31T11:30:00.606Z",
    index: 1,
    height: 14605156,
    code: 0,
    info: "",
    gasWanted: 1436013,
    gasUsed: 1436013,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1glw62sxnarqlte4g4kxh7z5pje0x0llfwe53jfec7uydc9xygv7srmknr9",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
      "osmo15qle4t0azwg8etdn48n8lrvvwwut2wfe6lmkn5hk2faycs5gyalsf7eqgv",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4908507",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "6712116",
        amount1: "2408645",
        token_min_amount0: "5369692",
        token_min_amount1: "1926916",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:37:49.231Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4309", usd: 0.005781289438085543 },
            ],
            txInfo: {
              poolId: "1263",
              tokens: [
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "1960499",
                  usd: 1.96296862953118,
                },
                { denom: "uosmo", amount: "6712116", usd: 9.005496713391732 },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "023C26BF8BF4EC3956CE8EC6FCF7ECA956FD5EBA71AF9D607C5030A0F47BC9BB#14605151",
    hash: "023C26BF8BF4EC3956CE8EC6FCF7ECA956FD5EBA71AF9D607C5030A0F47BC9BB",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-31T11:29:37.492Z",
    index: 0,
    height: 14605151,
    code: 0,
    info: "",
    gasWanted: 520992,
    gasUsed: 520992,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15qle4t0azwg8etdn48n8lrvvwwut2wfe6lmkn5hk2faycs5gyalsf7eqgv",
      "osmo1glw62sxnarqlte4g4kxh7z5pje0x0llfwe53jfec7uydc9xygv7srmknr9",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4880645"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4880645"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-03-31T11:31:34.837Z",
    metadata: [],
  },
  {
    _id: "0278EF331ABF6C9A8CB8B5ED20E66210A8DE8F7156E579D01F51C5F1F8898D82#14605146",
    hash: "0278EF331ABF6C9A8CB8B5ED20E66210A8DE8F7156E579D01F51C5F1F8898D82",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-31T11:29:18.455Z",
    index: 1,
    height: 14605146,
    code: 0,
    info: "",
    gasWanted: 540392,
    gasUsed: 540392,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4913707"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4913707"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-03-31T11:30:36.210Z",
    metadata: [],
  },
  {
    _id: "3E02A317DB711C8979CD27C80D9303C4C44906E1884314E4A0BD76B9E67B106F#14596835",
    hash: "3E02A317DB711C8979CD27C80D9303C4C44906E1884314E4A0BD76B9E67B106F",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-31T01:30:23.544Z",
    index: 4,
    height: 14596835,
    code: 0,
    info: "",
    gasWanted: 489387,
    gasUsed: 489387,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1jv65s3grqf6v6jl3dp4t6c9t9rk99cd80yhvld",
    ],
    messageTypes: ["/osmosis.valsetpref.v1beta1.MsgDelegateToValidatorSet"],
    memo: "",
    messages: [
      {
        delegator: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        coin: { denom: "uosmo", amount: "13720085" },
        "@type": "/osmosis.valsetpref.v1beta1.MsgDelegateToValidatorSet",
      },
    ],
    ingested_at: "2024-03-31T01:32:22.346Z",
    metadata: [],
  },
  {
    _id: "D40CA9A60019CD61E3D1599BBE049D306221C3DC01C3678F501592C9C78C0CBA#14596831",
    hash: "D40CA9A60019CD61E3D1599BBE049D306221C3DC01C3678F501592C9C78C0CBA",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-31T01:30:07.256Z",
    index: 18,
    height: 14596831,
    code: 0,
    info: "",
    gasWanted: 575429,
    gasUsed: 575429,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo13vhcd3xllpvz8tql4dzp8yszxeas8zxpzptyvjttdy7m64kuyz5sv6caqq",
    ],
    messageTypes: ["/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn"],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [{ pool_id: "1464", token_out_denom: "uosmo" }],
        token_in: {
          denom:
            "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
          amount: "10111388",
        },
        token_out_min_amount: "7317881",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T12:55:36.186Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "2158", usd: 0.0029646030760772683 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                amount: "10100266",
                usd: 10.10408142962534,
              },
              tokenOut: {
                denom: "uosmo",
                amount: "7354645",
                usd: 10.103615936263346,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3737734365510974,
        price_date: "2024-03-31T01:30:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.0003777553606352,
        price_date: "2024-03-31T01:30:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "E25A8EB23442C5669D191BBE01AB312B90ACF91ED0C7062DA55ABB2B0AD4FA9B#14596825",
    hash: "E25A8EB23442C5669D191BBE01AB312B90ACF91ED0C7062DA55ABB2B0AD4FA9B",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-31T01:29:41.649Z",
    index: 4,
    height: 14596825,
    code: 0,
    info: "",
    gasWanted: 1521039,
    gasUsed: 1521039,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4908455",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "2276964",
        amount1: "1839986",
        token_min_amount0: "1821571",
        token_min_amount1: "1471988",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:43:23.835Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4564", usd: 0.00612341726512472 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "2276964",
                  usd: 28.46760309011866,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "1839986",
                  usd: 1.8423038199848902,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.502438813313983,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "C23024387E994E09A92D9A2C2C317C256ACB5C6299CDE92E89D011714CB49A20#14596817",
    hash: "C23024387E994E09A92D9A2C2C317C256ACB5C6299CDE92E89D011714CB49A20",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-31T01:29:08.094Z",
    index: 2,
    height: 14596817,
    code: 0,
    info: "",
    gasWanted: 521150,
    gasUsed: 521150,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15qle4t0azwg8etdn48n8lrvvwwut2wfe6lmkn5hk2faycs5gyalsf7eqgv",
      "osmo1glw62sxnarqlte4g4kxh7z5pje0x0llfwe53jfec7uydc9xygv7srmknr9",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4880645"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4880645"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-03-31T01:31:54.033Z",
    metadata: [],
  },
  {
    _id: "87551F0C795371C5FDBC0106BA78FFA03345E9DCEF52D8A35352BA1B01EECAEE#14596814",
    hash: "87551F0C795371C5FDBC0106BA78FFA03345E9DCEF52D8A35352BA1B01EECAEE",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-31T01:28:53.703Z",
    index: 14,
    height: 14596814,
    code: 0,
    info: "",
    gasWanted: 540419,
    gasUsed: 540419,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4908455"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4908455"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-03-31T01:32:00.800Z",
    metadata: [],
  },
  {
    _id: "D1ED9B21E99B753C99FC67150FE5F9A9DD4447F14F850888770472A2220A81FE#14591470",
    hash: "D1ED9B21E99B753C99FC67150FE5F9A9DD4447F14F850888770472A2220A81FE",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T19:03:54.737Z",
    index: 31,
    height: 14591470,
    code: 0,
    info: "",
    gasWanted: 489521,
    gasUsed: 489521,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1jv65s3grqf6v6jl3dp4t6c9t9rk99cd80yhvld",
    ],
    messageTypes: ["/osmosis.valsetpref.v1beta1.MsgDelegateToValidatorSet"],
    memo: "",
    messages: [
      {
        delegator: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        coin: { denom: "uosmo", amount: "105774945" },
        "@type": "/osmosis.valsetpref.v1beta1.MsgDelegateToValidatorSet",
      },
    ],
    ingested_at: "2024-03-30T19:07:21.477Z",
    metadata: [],
  },
  {
    _id: "43B269860665970830C83425AF64BE36704FC8281E845C3DB58037CFA50570BB#14591464",
    hash: "43B269860665970830C83425AF64BE36704FC8281E845C3DB58037CFA50570BB",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T19:03:28.462Z",
    index: 2,
    height: 14591464,
    code: 0,
    info: "",
    gasWanted: 539727,
    gasUsed: 539727,
    codespace: "",
    addressIndex: ["osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3"],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgCreatePosition"],
    memo: "",
    messages: [
      {
        pool_id: "1263",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        lower_tick: "364200",
        upper_tick: "433500",
        tokens_provided: [
          {
            denom:
              "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
            amount: "5979627",
          },
          { denom: "uosmo", amount: "6171868" },
        ],
        token_min_amount0: "5246087",
        token_min_amount1: "5082682",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCreatePosition",
      },
    ],
    ingested_at: "2024-04-07T03:50:57.387Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "1620", usd: 0.0021735179600135945 },
            ],
            txInfo: {
              poolId: "1263",
              tokens: [
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "5300023",
                  usd: 5.306699409075819,
                },
                { denom: "uosmo", amount: "6171868", usd: 8.280657990637767 },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "61DA389CAE002EC5A9AD6B0006E1347D8BE1BA61C358D4090364A6945E92902C#14591455",
    hash: "61DA389CAE002EC5A9AD6B0006E1347D8BE1BA61C358D4090364A6945E92902C",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T19:02:49.084Z",
    index: 14,
    height: 14591455,
    code: 1,
    info: "",
    gasWanted: 552645,
    gasUsed: 552645,
    codespace: "undefined",
    addressIndex: ["osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3"],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgCreatePosition"],
    memo: "",
    messages: [
      {
        pool_id: "1263",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        lower_tick: "370600",
        upper_tick: "431900",
        tokens_provided: [
          {
            denom:
              "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
            amount: "5979627",
          },
          { denom: "uosmo", amount: "7167903" },
        ],
        token_min_amount0: "6092717",
        token_min_amount1: "5082682",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCreatePosition",
      },
    ],
    ingested_at: "2024-04-07T03:51:03.867Z",
    metadata: [],
    prices: [],
  },
  {
    _id: "C27981F9F76EC0CED59D4A7C71426AF68D512BD37ED4AC6C78DA56C4E379E171#14591424",
    hash: "C27981F9F76EC0CED59D4A7C71426AF68D512BD37ED4AC6C78DA56C4E379E171",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T19:00:35.067Z",
    index: 15,
    height: 14591424,
    code: 0,
    info: "",
    gasWanted: 577458,
    gasUsed: 577458,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1cr0fq7pfhpw08as5dsthzvjnlfdtvsq7kw98lwuqxjzv5jm3j5mqf9k6as",
    ],
    messageTypes: ["/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn"],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [{ pool_id: "1135", token_out_denom: "uosmo" }],
        token_in: {
          denom:
            "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
          amount: "10543084",
        },
        token_out_min_amount: "93627582",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T18:00:06.698Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "2166", usd: 0.0030173257201402425 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "10511475",
                usd: 131.00853432087328,
              },
              tokenOut: {
                denom: "uosmo",
                amount: "94096747",
                usd: 131.0805793650181,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3930404986797058,
        price_date: "2024-03-30T19:01:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.46338257198664,
        price_date: "2024-03-30T19:01:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "DEFD54614BF33B07883F21DE9E803293E6BC265107E7431917F43AF2DF1A81DD#14591418",
    hash: "DEFD54614BF33B07883F21DE9E803293E6BC265107E7431917F43AF2DF1A81DD",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T19:00:07.861Z",
    index: 3,
    height: 14591418,
    code: 0,
    info: "",
    gasWanted: 1525352,
    gasUsed: 1525352,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4901490",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "19317175",
        amount1: "109386278",
        token_min_amount0: "15453740",
        token_min_amount1: "87509022",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:43:40.770Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4577", usd: 0.0061408590759149525 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "19317175",
                  usd: 241.51179848357853,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "103406651",
                  usd: 103.53691177495067,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.502438813313983,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "FAC07656890D98C8473D7041BE4008CEA5D0EB5C4A1226F26627A8E74EA193E4#14591412",
    hash: "FAC07656890D98C8473D7041BE4008CEA5D0EB5C4A1226F26627A8E74EA193E4",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T18:59:41.625Z",
    index: 16,
    height: 14591412,
    code: 0,
    info: "",
    gasWanted: 521213,
    gasUsed: 521213,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15qle4t0azwg8etdn48n8lrvvwwut2wfe6lmkn5hk2faycs5gyalsf7eqgv",
      "osmo1glw62sxnarqlte4g4kxh7z5pje0x0llfwe53jfec7uydc9xygv7srmknr9",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4880645"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4880645"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-03-30T19:06:12.527Z",
    metadata: [],
  },
  {
    _id: "04276F2AD2AA50CCCA172F952A254D8326B15F95B987409B8CB5BFE73CED14CB#14591409",
    hash: "04276F2AD2AA50CCCA172F952A254D8326B15F95B987409B8CB5BFE73CED14CB",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T18:59:28.437Z",
    index: 16,
    height: 14591409,
    code: 0,
    info: "",
    gasWanted: 540549,
    gasUsed: 540549,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4901490"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4901490"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-03-30T19:03:10.188Z",
    metadata: [],
  },
  {
    _id: "E3D7E37DDB1FC87BA53A94A374C4C5C85988A6FFAAC114085EFD1E1128A6F305#14586766",
    hash: "E3D7E37DDB1FC87BA53A94A374C4C5C85988A6FFAAC114085EFD1E1128A6F305",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T13:19:42.048Z",
    index: 10,
    height: 14586766,
    code: 0,
    info: "",
    gasWanted: 1777536,
    gasUsed: 1777536,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4901481",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "43297859",
        amount1: "1445636378",
        token_min_amount0: "34638287",
        token_min_amount1: "1156509102",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:42:28.621Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "5333", usd: 0.00715516745725463 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "43297859",
                  usd: 541.3288328949961,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "1353633880",
                  usd: 1355.3390449628253,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.502438813313983,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "9246E19FCF69426AF4FD92C7164252C90B981178559970875DB3F44CA6B7FB02#14586762",
    hash: "9246E19FCF69426AF4FD92C7164252C90B981178559970875DB3F44CA6B7FB02",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T13:19:24.292Z",
    index: 0,
    height: 14586762,
    code: 0,
    info: "",
    gasWanted: 1465386,
    gasUsed: 1465386,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1h4ffzselefzgrf63k9n8c098ql849v3jhwjdvf7rzd42xd7m8tmsah4vv0",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
      "osmo1hfvn84ea9ch4sth90qusqnyhgexvn3uqr95c7w4y3l39jvrfh3tqpd4fcn",
    ],
    messageTypes: [
      "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
    ],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pools: [
              { pool_id: "1265", token_out_denom: "uosmo" },
              {
                pool_id: "1263",
                token_out_denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
              },
            ],
            token_in_amount: "90000000",
          },
          {
            pools: [
              {
                pool_id: "1282",
                token_out_denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
              },
            ],
            token_in_amount: "10000000",
          },
        ],
        token_in_denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        token_out_min_amount: "1259956378",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T09:36:08.811Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4397", usd: 0.006130760543893826 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "917004983",
                usd: 11644.896083486285,
              },
              tokenOut: {
                denom: "uosmo",
                amount: "2084655952",
                usd: 2906.646908827615,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3943053317930012,
        price_date: "2024-03-30T13:19:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 0.9997617387019078,
        price_date: "2024-03-30T13:19:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.698836210671152,
        price_date: "2024-03-30T13:19:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "58FC90DDFC102E872A713A17D40132AE66A9DABB23631618513A64E742E233B6#14586755",
    hash: "58FC90DDFC102E872A713A17D40132AE66A9DABB23631618513A64E742E233B6",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T13:18:54.659Z",
    index: 0,
    height: 14586755,
    code: 0,
    info: "",
    gasWanted: 1708194,
    gasUsed: 1708194,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4901457",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "118213025",
        amount1: "3875128238",
        token_min_amount0: "94570420",
        token_min_amount1: "3100102590",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:42:24.913Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "5125", usd: 0.0068760984846109085 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "118213025",
                  usd: 1477.9511119992562,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "3695765715",
                  usd: 3700.4212502234745,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.502438813313983,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "3AC4F706B989DC99B5784C1609151C9173933E82A8FC1D681137FD15B6A9C6E5#14586748",
    hash: "3AC4F706B989DC99B5784C1609151C9173933E82A8FC1D681137FD15B6A9C6E5",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T13:18:28.008Z",
    index: 15,
    height: 14586748,
    code: 0,
    info: "",
    gasWanted: 1397999,
    gasUsed: 1397999,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
      "osmo19n4q7va8gdm2l7544k94pufhdp5tpu7pmfw4vqyvvzlzjvvc8v3qtyz27t",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
    ],
    messageTypes: [
      "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
    ],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pools: [
              {
                pool_id: "1251",
                token_out_denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
              },
            ],
            token_in_amount: "150000000",
          },
          {
            pools: [
              { pool_id: "1400", token_out_denom: "uosmo" },
              {
                pool_id: "1263",
                token_out_denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
              },
            ],
            token_in_amount: "150000000",
          },
        ],
        token_in_denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        token_out_min_amount: "3780780155",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T09:36:10.581Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4194", usd: 0.005847716561539847 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "1661523809",
                usd: 21099.423209568235,
              },
              tokenOut: {
                denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                amount: "5163961194",
                usd: 5162.724934407321,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 0.9997605985896802,
        price_date: "2024-03-30T13:18:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3943053317930012,
        price_date: "2024-03-30T13:18:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.698838918394479,
        price_date: "2024-03-30T13:18:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "EB17BF478B06DBB31ED59C9C697CA211155F36EB0B85286F5703E2270CB5A05B#14586742",
    hash: "EB17BF478B06DBB31ED59C9C697CA211155F36EB0B85286F5703E2270CB5A05B",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T13:18:04.109Z",
    index: 5,
    height: 14586742,
    code: 0,
    info: "",
    gasWanted: 1722005,
    gasUsed: 1722005,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4901430",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "115950152",
        amount1: "3800949244",
        token_min_amount0: "92760121",
        token_min_amount1: "3040759395",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:42:20.598Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "5167", usd: 0.00693244895024089 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "115950152",
                  usd: 1449.659680774456,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "3725613119",
                  usd: 3730.306252829925,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.502438813313983,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "9852952416E33FBCDFF65B1776A873A88E26AFBC44ECAB3DDD67CF846BCBC513#14586737",
    hash: "9852952416E33FBCDFF65B1776A873A88E26AFBC44ECAB3DDD67CF846BCBC513",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T13:17:44.757Z",
    index: 10,
    height: 14586737,
    code: 0,
    info: "",
    gasWanted: 1529742,
    gasUsed: 1529742,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
      "osmo19n4q7va8gdm2l7544k94pufhdp5tpu7pmfw4vqyvvzlzjvvc8v3qtyz27t",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
    ],
    messageTypes: [
      "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
    ],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pools: [
              {
                pool_id: "1251",
                token_out_denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
              },
            ],
            token_in_amount: "210000000",
          },
          {
            pools: [
              { pool_id: "1400", token_out_denom: "uosmo" },
              {
                pool_id: "1263",
                token_out_denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
              },
            ],
            token_in_amount: "90000000",
          },
        ],
        token_in_denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        token_out_min_amount: "3782108787",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T09:36:09.702Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4590", usd: 0.0063998614729298756 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "1116563196",
                usd: 14179.056168211724,
              },
              tokenOut: {
                denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                amount: "4619459376",
                usd: 4618.353470910471,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 0.9997605985896802,
        price_date: "2024-03-30T13:18:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3943053317930012,
        price_date: "2024-03-30T13:18:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.698838918394479,
        price_date: "2024-03-30T13:18:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "4DA5246B063CE8D8E203DD768E6A59DBCA54D173CD1DBCBB97273CE8CF197B6B#14586728",
    hash: "4DA5246B063CE8D8E203DD768E6A59DBCA54D173CD1DBCBB97273CE8CF197B6B",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T13:17:09.465Z",
    index: 27,
    height: 14586728,
    code: 0,
    info: "",
    gasWanted: 1717319,
    gasUsed: 1717319,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4901406",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "193337700",
        amount1: "6337781989",
        token_min_amount0: "154670160",
        token_min_amount1: "5070225591",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:43:15.356Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "5152", usd: 0.006912323783944469 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "189821169",
                  usd: 2373.227550894233,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "6337781989",
                  usd: 6345.765657220292,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.502438813313983,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "FB07B8F1BB7C4A60BEFB29775640C406EF26B23E24AFC3334BE36468610E84F7#14586722",
    hash: "FB07B8F1BB7C4A60BEFB29775640C406EF26B23E24AFC3334BE36468610E84F7",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T13:16:42.235Z",
    index: 27,
    height: 14586722,
    code: 0,
    info: "",
    gasWanted: 810554,
    gasUsed: 810554,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo19n4q7va8gdm2l7544k94pufhdp5tpu7pmfw4vqyvvzlzjvvc8v3qtyz27t",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
    ],
    messageTypes: ["/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn"],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          { pool_id: "1400", token_out_denom: "uosmo" },
          {
            pool_id: "1263",
            token_out_denom:
              "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
          },
        ],
        token_in: {
          denom:
            "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
          amount: "500000000",
        },
        token_out_min_amount: "6306148917",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T18:01:53.884Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "2432", usd: 0.0033896345429304323 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "499500000",
                usd: 6338.890995388949,
              },
              tokenOut: {
                denom: "uosmo",
                amount: "4547382390",
                usd: 6337.978794842741,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.393764203507579,
        price_date: "2024-03-30T13:17:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 0.9993263434128135,
        price_date: "2024-03-30T13:17:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.69047246324114,
        price_date: "2024-03-30T13:17:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "46F88A4F65E9A0877AD545E41995530484BEEDD61F1DDFC22599B62AE73FDB5F#14586715",
    hash: "46F88A4F65E9A0877AD545E41995530484BEEDD61F1DDFC22599B62AE73FDB5F",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T13:16:12.161Z",
    index: 0,
    height: 14586715,
    code: 0,
    info: "",
    gasWanted: 1743857,
    gasUsed: 1743857,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4901390",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "351939139",
        amount1: "11536878422",
        token_min_amount0: "281551311",
        token_min_amount1: "9229502737",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:43:17.811Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "5232", usd: 0.007019658004192053 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "345530050",
                  usd: 4319.968308286321,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "11536878422",
                  usd: 11551.411362668985,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.502438813313983,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "CC556177AD715FF50216812FFF210B6416DE9644B25CB4B70358DA4C766D065B#14586710",
    hash: "CC556177AD715FF50216812FFF210B6416DE9644B25CB4B70358DA4C766D065B",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T13:15:48.202Z",
    index: 14,
    height: 14586710,
    code: 0,
    info: "",
    gasWanted: 1713006,
    gasUsed: 1713006,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
      "osmo19n4q7va8gdm2l7544k94pufhdp5tpu7pmfw4vqyvvzlzjvvc8v3qtyz27t",
    ],
    messageTypes: [
      "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
    ],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pools: [
              {
                pool_id: "1251",
                token_out_denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
              },
            ],
            token_in_amount: "13000000000",
          },
          {
            pools: [
              { pool_id: "1263", token_out_denom: "uosmo" },
              {
                pool_id: "1400",
                token_out_denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
              },
            ],
            token_in_amount: "13000000000",
          },
        ],
        token_in_denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        token_out_min_amount: "2029115724",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T09:36:10.210Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "6424", usd: 0.008957959436268833 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                amount: "35233856343",
                usd: 35209.108359321006,
              },
              tokenOut: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "11340887744",
                usd: 144031.4503715675,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.700191874112207,
        price_date: "2024-03-30T13:16:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.394451967040603,
        price_date: "2024-03-30T13:16:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 0.99929760786222,
        price_date: "2024-03-30T13:16:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "7F9B1161B70C16114EAAD6F544D776F3A42A8C33AECDF2E969FE2A73C62B6E52#14586686",
    hash: "7F9B1161B70C16114EAAD6F544D776F3A42A8C33AECDF2E969FE2A73C62B6E52",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T13:14:03.231Z",
    index: 1,
    height: 14586686,
    code: 0,
    info: "",
    gasWanted: 1020353,
    gasUsed: 1020353,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgWithdrawPosition",
    ],
    memo: "",
    messages: [
      {
        position_id: "4880649",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        liquidity_amount: "192734276907140860263602381286",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgWithdrawPosition",
      },
    ],
    ingested_at: "2024-04-06T22:38:26.722Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_withdraw",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "3062", usd: 0.004108217279976313 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "14700899117",
                  usd: 14719.417756690325,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "2779F3B2E3166487B82FB94FC2D69BA93B1C300E12C645F63C51A55BC6A58791#14586680",
    hash: "2779F3B2E3166487B82FB94FC2D69BA93B1C300E12C645F63C51A55BC6A58791",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T13:13:36.680Z",
    index: 12,
    height: 14586680,
    code: 0,
    info: "",
    gasWanted: 1020150,
    gasUsed: 1020150,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgWithdrawPosition",
    ],
    memo: "",
    messages: [
      {
        position_id: "4871823",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        liquidity_amount: "308083735969856449495267473300",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgWithdrawPosition",
      },
    ],
    ingested_at: "2024-04-06T22:38:26.080Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_withdraw",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "3061", usd: 0.004106875602223218 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "23023803941",
                  usd: 23052.80689694784,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "3B343619E270AD5A638681B919DB7EE1A2775F955FA28B099408B884CE284899#14586668",
    hash: "3B343619E270AD5A638681B919DB7EE1A2775F955FA28B099408B884CE284899",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T13:12:44.662Z",
    index: 1,
    height: 14586668,
    code: 0,
    info: "",
    gasWanted: 544644,
    gasUsed: 544644,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4871823"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4871823"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-03-30T13:14:33.756Z",
    metadata: [],
  },
  {
    _id: "40DDB1B3F021E900274FFA6E446FC1BB186020152CEDE71B84C3629E101ACEEE#14586663",
    hash: "40DDB1B3F021E900274FFA6E446FC1BB186020152CEDE71B84C3629E101ACEEE",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-30T13:12:22.672Z",
    index: 7,
    height: 14586663,
    code: 0,
    info: "",
    gasWanted: 544550,
    gasUsed: 544550,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4880649"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4880649"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-03-30T13:13:38.942Z",
    metadata: [],
  },
  {
    _id: "78903267C7F21EA5EF0498316EC484CB6CF22CAD1914A4818D749DB714504BBB#14574049",
    hash: "78903267C7F21EA5EF0498316EC484CB6CF22CAD1914A4818D749DB714504BBB",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T22:03:35.927Z",
    index: 5,
    height: 14574049,
    code: 0,
    info: "",
    gasWanted: 489383,
    gasUsed: 489383,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1jv65s3grqf6v6jl3dp4t6c9t9rk99cd80yhvld",
    ],
    messageTypes: ["/osmosis.valsetpref.v1beta1.MsgDelegateToValidatorSet"],
    memo: "",
    messages: [
      {
        delegator: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        coin: { denom: "uosmo", amount: "28026892" },
        "@type": "/osmosis.valsetpref.v1beta1.MsgDelegateToValidatorSet",
      },
    ],
    ingested_at: "2024-03-29T22:05:59.534Z",
    metadata: [],
  },
  {
    _id: "7C26EA1DA2F72B0074D13420AAE4EE9AEB28D9E034140256204E1ED6DFF1C261#14574044",
    hash: "7C26EA1DA2F72B0074D13420AAE4EE9AEB28D9E034140256204E1ED6DFF1C261",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T22:03:11.619Z",
    index: 12,
    height: 14574044,
    code: 0,
    info: "",
    gasWanted: 613628,
    gasUsed: 613628,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo100jqvejpw0fyzd87gmswvt8vjuckazdzakeu8lr9ccdz7283hueqyjwd3s",
    ],
    messageTypes: ["/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn"],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [{ pool_id: "1399", token_out_denom: "uosmo" }],
        token_in: {
          denom:
            "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
          amount: "3091076",
        },
        token_out_min_amount: "27793016",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T14:09:02.975Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "1841", usd: 0.0025562058339452993 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "3087676",
                usd: 38.76493783332868,
              },
              tokenOut: {
                denom: "uosmo",
                amount: "27932680",
                usd: 38.784182277961534,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3884876881832153,
        price_date: "2024-03-29T22:03:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.55472978166384,
        price_date: "2024-03-29T22:03:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "C59E1601749F2138D4BBA75AE288E4311D25549F32C869134D965FEE54C8C9EA#14574038",
    hash: "C59E1601749F2138D4BBA75AE288E4311D25549F32C869134D965FEE54C8C9EA",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T22:02:44.908Z",
    index: 18,
    height: 14574038,
    code: 0,
    info: "",
    gasWanted: 1492832,
    gasUsed: 1492832,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4871851",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "2282560",
        amount1: "59119781",
        token_min_amount0: "1826048",
        token_min_amount1: "47295824",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:46:35.090Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4479", usd: 0.006009374656111661 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "2282560",
                  usd: 28.537566737717967,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "59119736",
                  usd: 59.19420879794642,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.502438813313983,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "B8584AB52F863FE757C1AEEDD30860475F6657987F74F6EAB9C64E8CEE65E1BF#14574034",
    hash: "B8584AB52F863FE757C1AEEDD30860475F6657987F74F6EAB9C64E8CEE65E1BF",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T22:02:26.884Z",
    index: 1,
    height: 14574034,
    code: 0,
    info: "",
    gasWanted: 1421985,
    gasUsed: 1421985,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1glw62sxnarqlte4g4kxh7z5pje0x0llfwe53jfec7uydc9xygv7srmknr9",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4871872",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "6971664",
        amount1: "12277387",
        token_min_amount0: "5577331",
        token_min_amount1: "9821909",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:46:34.014Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4266", usd: 0.005723597294702465 },
            ],
            txInfo: {
              poolId: "1263",
              tokens: [
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "12277387",
                  usd: 12.292852755147502,
                },
                { denom: "uosmo", amount: "6971429", usd: 9.353411196580007 },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "2DD330B03AEE79420C23BEA0A5CE45188E0E74369FEC8655B87925416DA70468#14574025",
    hash: "2DD330B03AEE79420C23BEA0A5CE45188E0E74369FEC8655B87925416DA70468",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T22:01:47.830Z",
    index: 0,
    height: 14574025,
    code: 0,
    info: "",
    gasWanted: 521186,
    gasUsed: 521186,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15qle4t0azwg8etdn48n8lrvvwwut2wfe6lmkn5hk2faycs5gyalsf7eqgv",
      "osmo1glw62sxnarqlte4g4kxh7z5pje0x0llfwe53jfec7uydc9xygv7srmknr9",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4871872"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4871872"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-03-29T22:03:11.941Z",
    metadata: [],
  },
  {
    _id: "86FB2AF8712275996123914482367D4E3FBB196335E2BBD077219BF914B88BDB#14574020",
    hash: "86FB2AF8712275996123914482367D4E3FBB196335E2BBD077219BF914B88BDB",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T22:01:25.886Z",
    index: 18,
    height: 14574020,
    code: 0,
    info: "",
    gasWanted: 472500,
    gasUsed: 472500,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4871823"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4871823"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-03-29T22:02:12.559Z",
    metadata: [],
  },
  {
    _id: "C4328DCD57651CE42A6BE185544D8E1848D31C3C4CE27D7BDD4259582E26CD5C#14574017",
    hash: "C4328DCD57651CE42A6BE185544D8E1848D31C3C4CE27D7BDD4259582E26CD5C",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T22:01:12.422Z",
    index: 0,
    height: 14574017,
    code: 0,
    info: "",
    gasWanted: 542367,
    gasUsed: 542367,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4871851"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4871851"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-03-29T22:02:17.953Z",
    metadata: [],
  },
  {
    _id: "22D608346D3151329AC264D8CECD60E3D625E30FE942509819F2C1704553E315#14569190",
    hash: "22D608346D3151329AC264D8CECD60E3D625E30FE942509819F2C1704553E315",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T16:10:11.366Z",
    index: 3,
    height: 14569190,
    code: 0,
    info: "",
    gasWanted: 489422,
    gasUsed: 489422,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1jv65s3grqf6v6jl3dp4t6c9t9rk99cd80yhvld",
    ],
    messageTypes: ["/osmosis.valsetpref.v1beta1.MsgDelegateToValidatorSet"],
    memo: "",
    messages: [
      {
        delegator: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        coin: { denom: "uosmo", amount: "196533143" },
        "@type": "/osmosis.valsetpref.v1beta1.MsgDelegateToValidatorSet",
      },
    ],
    ingested_at: "2024-03-29T16:11:49.830Z",
    metadata: [],
  },
  {
    _id: "3F20103A60BD84EF3A722FB708C433B36FCD279A70C59518C0DDD16E06024BDE#14569181",
    hash: "3F20103A60BD84EF3A722FB708C433B36FCD279A70C59518C0DDD16E06024BDE",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T16:09:32.186Z",
    index: 13,
    height: 14569181,
    code: 0,
    info: "",
    gasWanted: 1470588,
    gasUsed: 1470588,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1glw62sxnarqlte4g4kxh7z5pje0x0llfwe53jfec7uydc9xygv7srmknr9",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
      "osmo15qle4t0azwg8etdn48n8lrvvwwut2wfe6lmkn5hk2faycs5gyalsf7eqgv",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4850545",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "3355611",
        amount1: "3972355",
        token_min_amount0: "2684488",
        token_min_amount1: "3177884",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:44:42.919Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4412", usd: 0.005919482246654308 },
            ],
            txInfo: {
              poolId: "1263",
              tokens: [
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "3968590",
                  usd: 3.9735892104362946,
                },
                { denom: "uosmo", amount: "3355611", usd: 4.502148626740233 },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "C19264664F738B08DB44CF4C0D080B88ACC158232BD900772B08A28C457AC1E4#14569176",
    hash: "C19264664F738B08DB44CF4C0D080B88ACC158232BD900772B08A28C457AC1E4",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T16:09:09.515Z",
    index: 3,
    height: 14569176,
    code: 0,
    info: "",
    gasWanted: 577734,
    gasUsed: 577734,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo19n4q7va8gdm2l7544k94pufhdp5tpu7pmfw4vqyvvzlzjvvc8v3qtyz27t",
    ],
    messageTypes: ["/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn"],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [{ pool_id: "1400", token_out_denom: "uosmo" }],
        token_in: {
          denom:
            "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
          amount: "21651713",
        },
        token_out_min_amount: "195437966",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T17:57:49.619Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "2167", usd: 0.002981462922116868 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "21630061",
                usd: 269.93498466726913,
              },
              tokenOut: {
                denom: "uosmo",
                amount: "196420665",
                usd: 270.2450068458876,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3758481412629755,
        price_date: "2024-03-29T16:09:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.479621979210744,
        price_date: "2024-03-29T16:09:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "6C0920E39C547108CA361362DBEB395F9F58F15D0656EB6178D987CD757E15B9#14569164",
    hash: "6C0920E39C547108CA361362DBEB395F9F58F15D0656EB6178D987CD757E15B9",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T16:08:17.696Z",
    index: 2,
    height: 14569164,
    code: 0,
    info: "",
    gasWanted: 1524392,
    gasUsed: 1524392,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4868167",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "4764460",
        amount1: "124898514",
        token_min_amount0: "3811568",
        token_min_amount1: "99918811",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:44:49.396Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "4574", usd: 0.006136834042655667 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "4764460",
                  usd: 59.567369628481934,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "119940743",
                  usd: 120.09183167737471,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.502438813313983,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "A93B2DE1479ACD8D7273D9BBD0AA5DDF74F27C62BEAF086A3183A66C42625023#14569154",
    hash: "A93B2DE1479ACD8D7273D9BBD0AA5DDF74F27C62BEAF086A3183A66C42625023",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T16:07:37.841Z",
    index: 11,
    height: 14569154,
    code: 0,
    info: "",
    gasWanted: 636548,
    gasUsed: 636548,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
    ],
    messageTypes: ["/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn"],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pool_id: "1251",
            token_out_denom:
              "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
          },
        ],
        token_in: {
          denom:
            "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
          amount: "10000000",
        },
        token_out_min_amount: "124274021",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T17:57:56.554Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "1910", usd: 0.002626521586985675 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "9970020",
                usd: 124.2417420963979,
              },
              tokenOut: {
                denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                amount: "124898514",
                usd: 124.77876927426921,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 0.9990412638077439,
        price_date: "2024-03-29T16:08:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.461533888236724,
        price_date: "2024-03-29T16:08:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.375142192139097,
        price_date: "2024-03-29T16:08:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "C2821002C0F9D9ED352FF52DE1953AAE8C297AA42D0748622B8B63753B23F107#14569147",
    hash: "C2821002C0F9D9ED352FF52DE1953AAE8C297AA42D0748622B8B63753B23F107",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T16:07:10.750Z",
    index: 8,
    height: 14569147,
    code: 0,
    info: "",
    gasWanted: 1750050,
    gasUsed: 1750050,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
    ],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition"],
    memo: "",
    messages: [
      {
        position_id: "4871791",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        amount0: "28573663",
        amount1: "671291443",
        token_min_amount0: "22858930",
        token_min_amount1: "537033154",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgAddToPosition",
      },
    ],
    ingested_at: "2024-04-06T21:44:47.490Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "5251", usd: 0.007045149881500854 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "24982211",
                  usd: 312.3385644487995,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "671291443",
                  usd: 672.1370650440108,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.502438813313983,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "0F7028386D2B061685F0DBC703EC8819782048D7BF8EC0D708D9CEA73D3D97F7#14569143",
    hash: "0F7028386D2B061685F0DBC703EC8819782048D7BF8EC0D708D9CEA73D3D97F7",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T16:06:52.824Z",
    index: 2,
    height: 14569143,
    code: 0,
    info: "",
    gasWanted: 1695596,
    gasUsed: 1695596,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
      "osmo1z0j6zm4ndmwl27kekla8un73nfu8rh5dhfg2957yr0kg3uumd9rs9sv5kq",
      "osmo132ymzlfce8ztju4xxfmr4cycuy0szjrerfpej7mjw7nz504qlj4q26xdqd",
    ],
    messageTypes: [
      "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
    ],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [
          {
            pools: [
              {
                pool_id: "1251",
                token_out_denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
              },
            ],
            token_in_amount: "18000000",
          },
          {
            pools: [
              {
                pool_id: "1283",
                token_out_denom:
                  "ibc/C140AFD542AE77BD7DCC83F13FDD8C5E5BB8C4929785E6EC2F4C636F98F17901",
              },
              {
                pool_id: "1594",
                token_out_denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
              },
            ],
            token_in_amount: "2000000",
          },
        ],
        token_in_denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        token_out_min_amount: "248562306",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSplitRouteSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T09:53:55.714Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "5087", usd: 0.006994422458028087 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                amount: "21466937",
                usd: 267.4746169964135,
              },
              tokenOut: {
                denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                amount: "251335948",
                usd: 251.11842797916614,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 0.9991345447296148,
        price_date: "2024-03-29T16:07:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/C140AFD542AE77BD7DCC83F13FDD8C5E5BB8C4929785E6EC2F4C636F98F17901",
        symbol: "stATOM",
        price_usd: 16.323036653092057,
        price_date: "2024-03-29T16:07:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.459840777303882,
        price_date: "2024-03-29T16:07:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3749601843971075,
        price_date: "2024-03-29T16:07:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "74C535E220DE3AAA98C05766D9396CCAEC2CF287FDF6C65DEF05DF85B9BE8399#14569135",
    hash: "74C535E220DE3AAA98C05766D9396CCAEC2CF287FDF6C65DEF05DF85B9BE8399",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T16:06:16.677Z",
    index: 14,
    height: 14569135,
    code: 0,
    info: "",
    gasWanted: 476852,
    gasUsed: 476852,
    codespace: "",
    addressIndex: ["osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3"],
    messageTypes: ["/osmosis.concentratedliquidity.v1beta1.MsgCreatePosition"],
    memo: "",
    messages: [
      {
        pool_id: "1251",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        lower_tick: "9217000",
        upper_tick: "9269700",
        tokens_provided: [
          {
            denom:
              "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
            amount: "638789100",
          },
          {
            denom:
              "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
            amount: "15007304806",
          },
        ],
        token_min_amount0: "542970735",
        token_min_amount1: "12756209085",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCreatePosition",
      },
    ],
    ingested_at: "2024-04-06T21:30:17.818Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_deposit",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "1431", usd: 0.0019199408646786752 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                {
                  denom:
                    "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
                  amount: "557414012",
                  usd: 6969.034578713866,
                },
                {
                  denom:
                    "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                  amount: "15007304806",
                  usd: 15026.209423208331,
                },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.502438813313983,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "CD89B0FC81982CADCCE7AA62CA16C3CF2B8AE620258E2E2329971BB1EA9C1A39#14569121",
    hash: "CD89B0FC81982CADCCE7AA62CA16C3CF2B8AE620258E2E2329971BB1EA9C1A39",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T16:05:17.761Z",
    index: 14,
    height: 14569121,
    code: 0,
    info: "",
    gasWanted: 542111,
    gasUsed: 542111,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4868167"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4868167"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-03-29T16:07:13.024Z",
    metadata: [],
  },
  {
    _id: "7810009EE3CB0C6A68664F63318AD98230B4446F69C15A9AEC8E8219E1E6C83E#14569101",
    hash: "7810009EE3CB0C6A68664F63318AD98230B4446F69C15A9AEC8E8219E1E6C83E",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T16:03:50.062Z",
    index: 42,
    height: 14569101,
    code: 0,
    info: "",
    gasWanted: 1068866,
    gasUsed: 1068866,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
      "osmo1gj26haupvyh6qun4fmc5xnr0tsrg9fwfvycs567u6d5qmezue22sza64gx",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgWithdrawPosition",
    ],
    memo: "",
    messages: [
      {
        position_id: "4868185",
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        liquidity_amount: "157167923480316808941790255201",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgWithdrawPosition",
      },
    ],
    ingested_at: "2024-04-06T22:41:40.175Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "pool_withdraw",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "3207", usd: 0.00430276055417506 },
            ],
            txInfo: {
              poolId: "1251",
              tokens: [
                { denom: "uosmo", amount: "10096", usd: 0.013545578595245217 },
              ],
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3416777530948114,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/27394FB092D2ECCD56123C74F36E4C1F926001CEADA9CA97EA622B25F41E5EB2",
        symbol: "ATOM",
        price_usd: 12.502438813313983,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001259694359028,
        price_date: "2024-03-27T15:55:00.000Z",
        exponent: 6,
      },
    ],
  },
  {
    _id: "BB694897D2BC44F0EC2C511412B4CA9FD15C368C4A02779CCC0484D230E856CF#14569086",
    hash: "BB694897D2BC44F0EC2C511412B4CA9FD15C368C4A02779CCC0484D230E856CF",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T16:02:44.414Z",
    index: 39,
    height: 14569086,
    code: 0,
    info: "",
    gasWanted: 521132,
    gasUsed: 521132,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15qle4t0azwg8etdn48n8lrvvwwut2wfe6lmkn5hk2faycs5gyalsf7eqgv",
      "osmo1glw62sxnarqlte4g4kxh7z5pje0x0llfwe53jfec7uydc9xygv7srmknr9",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4850545"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4850545"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-03-29T16:09:17.710Z",
    metadata: [],
  },
  {
    _id: "CC4EF17C84B9FD6FABA6108498BFAC1B5AE18CB34755FC1AB38C736EF9516A03#14569076",
    hash: "CC4EF17C84B9FD6FABA6108498BFAC1B5AE18CB34755FC1AB38C736EF9516A03",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T16:02:02.552Z",
    index: 15,
    height: 14569076,
    code: 0,
    info: "",
    gasWanted: 470462,
    gasUsed: 470462,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4868167"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4868167"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-03-29T16:06:09.233Z",
    metadata: [],
  },
  {
    _id: "590F3592FF64C4F1CB4E333C2045D52387747F6E4AF4ED971C77303EFD8F1804#14569073",
    hash: "590F3592FF64C4F1CB4E333C2045D52387747F6E4AF4ED971C77303EFD8F1804",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T16:01:47.632Z",
    index: 7,
    height: 14569073,
    code: 0,
    info: "",
    gasWanted: 539946,
    gasUsed: 539946,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo15zn4jn8dwyj709jvzuev74m55cf9w89wcmqemp34kr82yn2mr0kqtnhxqw",
      "osmo1vhw7cjhv5w4ckkr49d8f4tg99m2ar5x377ku9540mfnrdpptw00qe9rd5g",
    ],
    messageTypes: [
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
    ],
    memo: "",
    messages: [
      {
        position_ids: ["4868185"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type":
          "/osmosis.concentratedliquidity.v1beta1.MsgCollectSpreadRewards",
      },
      {
        position_ids: ["4868185"],
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        "@type": "/osmosis.concentratedliquidity.v1beta1.MsgCollectIncentives",
      },
    ],
    ingested_at: "2024-03-29T16:05:57.924Z",
    metadata: [],
  },
  {
    _id: "D0EDEDB6CEC9B497963C9EEFEA23CE056748689CF8FD7C0D6E02D589B2D78C0D#14567554",
    hash: "D0EDEDB6CEC9B497963C9EEFEA23CE056748689CF8FD7C0D6E02D589B2D78C0D",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T14:12:43.279Z",
    index: 10,
    height: 14567554,
    code: 0,
    info: "",
    gasWanted: 485093,
    gasUsed: 485093,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1jv65s3grqf6v6jl3dp4t6c9t9rk99cd80yhvld",
    ],
    messageTypes: ["/osmosis.valsetpref.v1beta1.MsgDelegateToValidatorSet"],
    memo: "",
    messages: [
      {
        delegator: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        coin: { denom: "uosmo", amount: "17679713" },
        "@type": "/osmosis.valsetpref.v1beta1.MsgDelegateToValidatorSet",
      },
    ],
    ingested_at: "2024-03-29T14:14:48.170Z",
    metadata: [],
  },
  {
    _id: "5A7264A4DB36CC64BE3872D98E6FFD1A87EEC1674B951643A76D3174FC167ADF#14567549",
    hash: "5A7264A4DB36CC64BE3872D98E6FFD1A87EEC1674B951643A76D3174FC167ADF",
    chainId: "osmosis-1",
    schemaVersion: 6,
    blockTimestamp: "2024-03-29T14:12:22.999Z",
    index: 7,
    height: 14567549,
    code: 0,
    info: "",
    gasWanted: 586259,
    gasUsed: 586259,
    codespace: "",
    addressIndex: [
      "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
      "osmo1hueh0egxjt6upzn6d80d3653k5vwjjluqz7lm8ffu4t84488p49s6vquyd",
    ],
    messageTypes: ["/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn"],
    memo: "",
    messages: [
      {
        sender: "osmo1pasgjwaqy8sarsgw7a0plrwlauaqx8jxrqymd3",
        routes: [{ pool_id: "1263", token_out_denom: "uosmo" }],
        token_in: {
          denom:
            "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
          amount: "9607703",
        },
        token_out_min_amount: "6883401",
        "@type": "/osmosis.poolmanager.v1beta1.MsgSwapExactAmountIn",
      },
    ],
    ingested_at: "2024-04-05T18:07:24.998Z",
    metadata: [
      {
        type: "osmosis-ui",
        value: [
          {
            txType: "swap",
            txMessageIndex: 0,
            txFee: [
              { denom: "uosmo", amount: "1759", usd: 0.0024445556502093063 },
            ],
            txInfo: {
              tokenIn: {
                denom:
                  "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
                amount: "9593296",
                usd: 9.607198916861353,
              },
              tokenOut: {
                denom: "uosmo",
                amount: "6917971",
                usd: 9.61419277773401,
              },
            },
          },
        ],
      },
    ],
    prices: [
      {
        denom: "uosmo",
        symbol: "OSMO",
        price_usd: 1.3897416999484402,
        price_date: "2024-03-29T14:12:00.000Z",
        exponent: 6,
      },
      {
        denom:
          "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
        symbol: "USDC",
        price_usd: 1.001449232553791,
        price_date: "2024-03-29T14:12:00.000Z",
        exponent: 6,
      },
    ],
  },
];
