/* eslint-disable import/no-extraneous-dependencies */
import { ProtoStore } from "@cosmology/proto-parser";
import * as fs from "fs";
import { join } from "path";
import * as prettier from "prettier";

import { protoDirs } from "./utils";

/**
 * Generate a TypeScript file called package-types.ts containing available proto packages.
 * We need to generate the file in order to not include outdated/erroneous packages on filter.
 */
async function generateAvailablePackages() {
  const packages = new ProtoStore(protoDirs).getPackages();

  const content = `  
        /**
         * This file is auto-generated by scripts/gen-available-pkgs.ts
         * Do not edit this file manually. Instead run 'yarn generate:packages-types'
         */
        export type AvailablePackages = ${packages
          .map((pkg) => `"${pkg}"`)
          .join(" | ")};
      `;

  const prettierConfig = await prettier.resolveConfig("./");
  const formatted = prettier.format(content, {
    ...prettierConfig,
    parser: "typescript",
  });

  try {
    fs.writeFileSync(
      join(__dirname, "/generated/package-types.ts"),
      formatted,
      {
        encoding: "utf8",
        flag: "w",
      }
    );
    console.info("Successfully wrote package-types.ts");
  } catch (e) {
    console.error(`Error writing package-types.ts: ${e}`);
  }
}

generateAvailablePackages().catch((e) => {
  console.error(e);
  process.exit(1);
});
