export const MockTokens = [
  {
    chainId: "acre_9052-1",
    address:
      "ibc/BFAAB7870A9AAABF64A7366DAAA0B8E5065EAA1FCE762F45677DC24BE796EF65",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/BFAAB7870A9AAABF64A7366DAAA0B8E5065EAA1FCE762F45677DC24BE796EF65",
    pathKey: "axlusdc_acre",
  },
  {
    chainId: "acre_9052-1",
    address:
      "ibc/E3AB0DFDE9E782262B770C32DF94AC2A92B93DC4825376D6F6C874D3C877864E",
    name: "Axelar ETH",
    symbol: "axlWETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/E3AB0DFDE9E782262B770C32DF94AC2A92B93DC4825376D6F6C874D3C877864E",
    pathKey: "axleth_acre",
  },
  {
    chainId: "agoric-3",
    address:
      "ibc/295548A78785A1007F232DE286149A6FF512F180AF5657780FC89C009E2C348F",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/295548A78785A1007F232DE286149A6FF512F180AF5657780FC89C009E2C348F",
    pathKey: "axlusdc_agoric",
  },
  {
    chainId: "agoric-3",
    address:
      "ibc/1B38805B1C75352B28169284F96DF56BDEBD9E8FAC005BDCC8CF0378C82AA8E7",
    name: "Axelar ETH",
    symbol: "axlWETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/1B38805B1C75352B28169284F96DF56BDEBD9E8FAC005BDCC8CF0378C82AA8E7",
    pathKey: "axleth_agoric",
  },
  {
    chainId: "agoric-3",
    address:
      "ibc/65CD60D7E37EF830BC6B6A6DF4E3E3884A96C0905A7D271C48DC0440B1989EC7",
    name: "Axelar BUSD",
    symbol: "axlBUSD",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/busd.svg",
    coingeckoId: "weth",
    commonKey: "busd-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/65CD60D7E37EF830BC6B6A6DF4E3E3884A96C0905A7D271C48DC0440B1989EC7",
    pathKey: "axlbusd_agoric",
  },
  {
    chainId: "agoric-3",
    address:
      "ibc/FE98AAD68F02F03565E9FA39A5E627946699B2B07115889ED812D8BA639576A9",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    ibcDenom:
      "ibc/FE98AAD68F02F03565E9FA39A5E627946699B2B07115889ED812D8BA639576A9",
    pathKey: "nusdc_agoric",
  },
  {
    chainId: 42161,
    name: "USD Coin",
    address: "0xff970a61a04b1ca14834a43f5de4533ebddb5cc8",
    symbol: "USDC.e",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
  },
  {
    chainId: 42161,
    name: "USD Coin",
    address: "0xaf88d065e77c8cC2239327C5EDb3A432268e5831",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
  },
  {
    chainId: 42161,
    address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
  },
  {
    chainId: 42161,
    address: "0x82af49447d8a07e3bd95bd0d56f35241523fbab1",
    name: "Wrapped ETH",
    symbol: "WETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
  },
  {
    chainId: 42161,
    address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
    name: "Axelar Wrapped ETH",
    symbol: "axlETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/eth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
  },
  {
    chainId: "archway-1",
    address:
      "ibc/B9E4FD154C92D3A23BEA029906C4C5FF2FE74CB7E3A058290B77197A263CF88B",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/B9E4FD154C92D3A23BEA029906C4C5FF2FE74CB7E3A058290B77197A263CF88B",
    pathKey: "axlusdc_archway",
  },
  {
    chainId: "archway-1",
    address:
      "ibc/43897B9739BD63E3A08A88191999C632E052724AB96BD4C74AE31375C991F48D",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    ibcDenom:
      "ibc/43897B9739BD63E3A08A88191999C632E052724AB96BD4C74AE31375C991F48D",
    pathKey: "nusdc_archway",
  },
  {
    chainId: "archway-1",
    address:
      "ibc/13C5990F84FA5D472E1F8BB1BAAEA8774DA5F24128EC02B119107AD21FB52A61",
    name: "Axelar ETH",
    symbol: "axlWETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    ibcDenom:
      "ibc/13C5990F84FA5D472E1F8BB1BAAEA8774DA5F24128EC02B119107AD21FB52A61",
    pathKey: "axleth_archway",
  },
  {
    chainId: "mantle-1",
    address:
      "ibc/616E26A85AD20A3DDEAEBDDE7262E3BA9356C557BC15CACEA86768D7D51FA703",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/616E26A85AD20A3DDEAEBDDE7262E3BA9356C557BC15CACEA86768D7D51FA703",
    pathKey: "axlusdc_assetmantle",
  },
  {
    chainId: "mantle-1",
    address:
      "ibc/3EFE89848528B4A5665D0102DB818C6B19E04E17455197E92BECC3C41A7F7D78",
    name: "Axelar ETH",
    symbol: "axlWETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/3EFE89848528B4A5665D0102DB818C6B19E04E17455197E92BECC3C41A7F7D78",
    pathKey: "axleth_assetmantle",
  },
  {
    chainId: "mantle-1",
    address:
      "ibc/7ACA93F806B54D0833AAEF0C35A91AF112EA8CA0A34A17B584E6D4F0C22372EE",
    name: "Axelar BUSD",
    symbol: "axlBUSD",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/busd.svg",
    coingeckoId: "weth",
    commonKey: "busd-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/7ACA93F806B54D0833AAEF0C35A91AF112EA8CA0A34A17B584E6D4F0C22372EE",
    pathKey: "axlbusd_assetmantle",
  },
  {
    chainId: 43114,
    address: "0xfaB550568C688d5D8A52C7d794cb93Edc26eC0eC",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
  },
  {
    chainId: 43114,
    address: "0x49D5c2BdFfac6CE2BFdB6640F4F80f226bc10bAB",
    decimals: 18,
    name: "Wrapped Ether",
    symbol: "WETH.e",
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
  },
  {
    chainId: "axelar-dojo-1",
    address: "uusdc",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom: "uusdc",
    pathKey: "axlusdc_axelar",
  },
  {
    chainId: "axelar-dojo-1",
    address: "weth-wei",
    name: "Axelar ETH",
    symbol: "axlWETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
    ibcDenom: "weth-wei",
    pathKey: "axleth_axelar",
  },
  {
    chainId: "axelar-dojo-1",
    address: "busd-wei",
    name: "Axelar BUSD",
    symbol: "axlBUSD",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/busd.svg",
    coingeckoId: "weth",
    commonKey: "busd-wei",
    bridgeOnly: true,
    ibcDenom: "busd-wei",
    pathKey: "axlbusd_axelar",
  },
  {
    chainId: "axelar-dojo-1",
    name: "polygon USD Coin",
    address: "polygon-uusdc",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    ibcDenom: "polygon-uusdc",
    commonKey: "polygon-uusdc",
    pathKey: "axlpusdc_axelar",
  },
  {
    chainId: 8453,
    address: "0x833589fCD6eDb6E08f4c7C32D4f71b54bdA02913",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
  },
  {
    chainId: 8453,
    address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/assets/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
  },
  {
    chainId: 8453,
    address: "0x4200000000000000000000000000000000000006",
    name: "Wrapped WETH",
    symbol: "WETH",
    decimals: 18,
    logoURI:
      "https://assets.coingecko.com/coins/images/279/small/ethereum.png?1595348880",
    coingeckoId: "weth",
  },
  {
    chainId: 56,
    name: "Axelar USDC",
    symbol: "axlUSDC",
    address: "0x4268B8F0B87b6Eae5d897996E6b845ddbD99Adf3",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
  },
  {
    chainId: 56,
    name: "Binance Pegged USD Coin",
    symbol: "USDC",
    address: "0x8AC76a51cc950d9822D68b83fE1Ad97B32Cd580d",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
  },
  {
    name: "Binance-Peg Ethereum Token",
    symbol: "WETH",
    address: "0x2170ed0880ac9a755fd29b2688956bd959f933f8",
    chainId: 56,
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/ApeSwapFinance/apeswap-token-lists/main/assets/ETH.svg",
    coingeckoId: "weth",
  },
  {
    chainId: 81457,
    address: "0x4300000000000000000000000000000000000004",
    name: "Wrapped ETH",
    symbol: "WETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
  },
  {
    chainId: 81457,
    address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/assets/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
  },
  {
    chainId: 81457,
    address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
    name: "Axelar ETH",
    symbol: "axlETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    bridgeOnly: true,
    commonKey: "weth-wei",
  },
  {
    chainId: "carbon-1",
    address:
      "ibc/7C0807A56073C4A27B0DE1C21BA3EB75DF75FD763F4AD37BC159917FC01145F0",
    name: "USDC",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/7C0807A56073C4A27B0DE1C21BA3EB75DF75FD763F4AD37BC159917FC01145F0",
    pathKey: "axlusdc_carbon",
  },
  {
    chainId: 42220,
    address: "0xcebA9300f2b948710d2653dD7B07f33A8B32118C",
    name: "Celo native USDC",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
  },
  {
    chainId: 42220,
    address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
  },
  {
    chainId: 42220,
    address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
    name: "Axelar ETH",
    symbol: "axlETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
  },
  {
    chainId: 42220,
    address: "0x37f750B7cC259A2f741AF45294f6a16572CF5cAd",
    name: "USD Coin | Wormhole",
    symbol: "USDC.wh",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
  },
  {
    address: "0x122013fd7dF1C6F636a5bb8f03108E876548b455",
    chainId: 42220,
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/sushiswap/list/master/logos/token-logos/network/celo/0x122013fd7dF1C6F636a5bb8f03108E876548b455.jpg",
    name: "Wrapped Ether",
    symbol: "WETH",
    coingeckoId: "weth",
  },
  {
    chainId: 42220,
    address: "0xef4229c8c3250C675F21BCefa42f58EfbfF6002a",
    name: "Optics USDC",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
  },
  {
    chainId: "comdex-1",
    address:
      "ibc/E1616E7C19EA474C565737709A628D6F8A23FF9D3E9A7A6871306CF5E0A5341E",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/E1616E7C19EA474C565737709A628D6F8A23FF9D3E9A7A6871306CF5E0A5341E",
    pathKey: "axlusdc_comdex",
  },
  {
    chainId: "comdex-1",
    address:
      "ibc/81C3A46287D7664A8FD19843AC8D0CFD6C284EF1F750C661C48B3544277B1B29",
    name: "Axelar ETH",
    symbol: "axlWETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/81C3A46287D7664A8FD19843AC8D0CFD6C284EF1F750C661C48B3544277B1B29",
    pathKey: "axleth_comdex",
  },
  {
    chainId: "comdex-1",
    address:
      "ibc/F960753B47A20B18DF578FFDD51FB8B32AF5BF77FF8718580421333F7458E690",
    name: "Axelar BUSD",
    symbol: "axlBUSD",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/busd.svg",
    coingeckoId: "weth",
    commonKey: "busd-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/F960753B47A20B18DF578FFDD51FB8B32AF5BF77FF8718580421333F7458E690",
    pathKey: "axlbusd_comdex",
  },
  {
    chainId: "cosmoshub-4",
    address:
      "ibc/F663521BF1836B00F5F177680F74BFB9A8B5654A694D0D2BC249E03CF2509013",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    ibcDenom:
      "ibc/F663521BF1836B00F5F177680F74BFB9A8B5654A694D0D2BC249E03CF2509013",
    pathKey: "nusdc_cosmoshub",
  },
  {
    chainId: "crescent-1",
    address:
      "ibc/BFF0D3805B50D93E2FA5C0B2DDF7E0B30A631076CD80BC12A48C0E95404B4A41",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/BFF0D3805B50D93E2FA5C0B2DDF7E0B30A631076CD80BC12A48C0E95404B4A41",
    pathKey: "axlusdc_crescent",
  },
  {
    chainId: "crescent-1",
    address:
      "ibc/F1806958CA98757B91C3FA1573ECECD24F6FA3804F074A6977658914A49E65A3",
    name: "Axelar ETH",
    symbol: "axlWETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/F1806958CA98757B91C3FA1573ECECD24F6FA3804F074A6977658914A49E65A3",
    pathKey: "axleth_crescent",
  },
  {
    chainId: "crescent-1",
    address:
      "ibc/A7A2B8871CD2E999EB1D9E901B4F744617C80816CE94DE84CA1200109651C903",
    name: "Axelar BUSD",
    symbol: "axlBUSD",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/busd.svg",
    coingeckoId: "weth",
    commonKey: "busd-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/A7A2B8871CD2E999EB1D9E901B4F744617C80816CE94DE84CA1200109651C903",
    pathKey: "axlbusd_crescent",
  },
  {
    chainId: "dydx-mainnet-1",
    address:
      "ibc/8E27BA2D5493AF5636760E354E46004562C46AB7EC0CC4C1CA14E9E20E2545B5",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    ibcDenom:
      "ibc/8E27BA2D5493AF5636760E354E46004562C46AB7EC0CC4C1CA14E9E20E2545B5",
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    pathKey: "nusdc_dydx",
  },
  {
    chainId: "dymension_1100-1",
    address:
      "ibc/B3504E092456BA618CC28AC671A71FB08C6CA0FD0BE7C8A5B5A3E2DD933CC9E4",
    name: "Noble USDC",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    ibcDenom:
      "ibc/B3504E092456BA618CC28AC671A71FB08C6CA0FD0BE7C8A5B5A3E2DD933CC9E4",
    pathKey: "nusdc_dymension",
  },
  {
    chainId: "dymension_1100-1",
    address:
      "ibc/BFAAB7870A9AAABF64A7366DAAA0B8E5065EAA1FCE762F45677DC24BE796EF65",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/BFAAB7870A9AAABF64A7366DAAA0B8E5065EAA1FCE762F45677DC24BE796EF65",
    pathKey: "axlusdc_dymension",
  },
  {
    chainId: "dymension_1100-1",
    address:
      "ibc/E3AB0DFDE9E782262B770C32DF94AC2A92B93DC4825376D6F6C874D3C877864E",
    name: "Axelar ETH",
    symbol: "axlETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    ibcDenom:
      "ibc/E3AB0DFDE9E782262B770C32DF94AC2A92B93DC4825376D6F6C874D3C877864E",
    pathKey: "axleth_dymension",
  },
  {
    name: "USDCoin",
    address: "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48",
    symbol: "USDC",
    decimals: 6,
    chainId: 1,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    commonKey: "uusdc",
  },
  {
    chainId: 1,
    address: "0xEeeeeEeeeEeEeeEeEeEeeEEEeeeeEeeeeeeeEEeE",
    name: "Ethereum",
    symbol: "ETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/eth.svg",
    coingeckoId: "ethereum",
    commonKey: "weth-wei",
  },
  {
    chainId: 1,
    address: "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
    name: "Wrapped ETH",
    symbol: "WETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
  },
  {
    chainId: "evmos_9001-2",
    address: "uusdc",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/63C53CBDF471D4E867366ABE2E631197257118D1B2BEAD1946C8A408F96464C3",
    pathKey: "axlusdc_evmos",
  },
  {
    chainId: "evmos_9001-2",
    address: "weth-wei",
    name: "Axelar ETH",
    symbol: "axlWETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/356EDE917394B2AEF7F915EB24FA683A0CCB8D16DD4ECCEDC2AD0CEC6B66AC81",
    pathKey: "axleth_evmos",
  },
  {
    chainId: "evmos_9001-2",
    address: "busd-wei",
    name: "Axelar BUSD",
    symbol: "axlBUSD",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/busd.svg",
    coingeckoId: "weth",
    commonKey: "busd-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/3A7C0D680D0F50A98115966A22C01594897FAE924FAF324E13C5FFB89F6864BF",
    pathKey: "axlbusd_evmos",
  },
  {
    chainId: 250,
    address: "0x1B6382DBDEa11d97f24495C9A90b7c88469134a4",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/assets/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
  },
  {
    address: "0xfe7eDa5F2c56160d406869A8aA4B2F365d544C7B",
    chainId: 250,
    decimals: 18,
    logoURI: "https://docs.axelar.dev/images/assets/weth.svg",
    name: "Axelar ETH",
    symbol: "axlETH",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
  },
  {
    name: "Wrapped Ether",
    symbol: "wETH",
    address: "0x74b23882a30290451A17c44f4F05243b6b58C76d",
    chainId: 250,
    decimals: 18,
    logoURI: "https://assets.spooky.fi/tokens/wETH.png",
    coingeckoId: "weth",
  },
  {
    chainId: "fetchhub-4",
    address:
      "ibc/8AF69BC1E1D72B447738B50C28B382F62F2AF65DE303021E45C0B7C851B4B2E1",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/8AF69BC1E1D72B447738B50C28B382F62F2AF65DE303021E45C0B7C851B4B2E1",
    pathKey: "axlusdc_fetch",
  },
  {
    chainId: "fetchhub-4",
    address:
      "ibc/74712D58FE426053FE962D71BCA5BE80BF83F1BC3508E5E16EBE70241D4E73BE",
    name: "Axelar ETH",
    symbol: "axlWETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/74712D58FE426053FE962D71BCA5BE80BF83F1BC3508E5E16EBE70241D4E73BE",
    pathKey: "axleth_fetch",
  },
  {
    chainId: "fetchhub-4",
    address:
      "ibc/4DBD7165A95A4CE5DF31575D9745AF85060A68D6E91050CEB6326958EC92CFDF",
    name: "Axelar BUSD",
    symbol: "axlBUSD",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/busd.svg",
    coingeckoId: "weth",
    commonKey: "busd-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/4DBD7165A95A4CE5DF31575D9745AF85060A68D6E91050CEB6326958EC92CFDF",
    pathKey: "axlbusd_fetch",
  },
  {
    chainId: 314,
    address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
    name: "Axelar ETH",
    symbol: "axlETH",
    decimals: 18,
    logoURI: "https://docs.axelar.dev/images/assets/weth.svg",
    coingeckoId: "weth",
    bridgeOnly: true,
    commonKey: "weth-wei",
  },
  {
    chainId: 314,
    address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
  },
  {
    chainId: 252,
    address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
  },
  {
    chainId: 252,
    address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
    name: "Axelar ETH",
    symbol: "axlETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "axlweth",
    bridgeOnly: true,
    commonKey: "weth-wei",
  },
  {
    chainId: 13371,
    address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
  },
  {
    chainId: 13371,
    address: "0x6de8aCC0D406837030CE4dd28e7c08C5a96a30d2",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/trustwallet/assets/master/blockchains/ethereum/assets/0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48/logo.png",
    coingeckoId: "usd-coin",
  },
  {
    chainId: 13371,
    address: "0x52A6c53869Ce09a731CD772f245b97A4401d3348",
    name: "WETH",
    symbol: "Wrapped ETH",
    decimals: 18,
    logoURI: "https://checkout-cdn.immutable.com/v1/blob/img/tokens/eth.svg",
    coingeckoId: "weth",
  },
  {
    chainId: "injective-1",
    address:
      "ibc/7E1AF94AD246BE522892751046F0C959B768642E5671CC3742264068D49553C0",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/7E1AF94AD246BE522892751046F0C959B768642E5671CC3742264068D49553C0",
    pathKey: "axlusdc_injective",
  },
  {
    chainId: "injective-1",
    address:
      "ibc/65A6973F7A4013335AE5FFE623FE019A78A1FEEE9B8982985099978837D764A7",
    name: "Axelar ETH",
    symbol: "axlWETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/65A6973F7A4013335AE5FFE623FE019A78A1FEEE9B8982985099978837D764A7",
    pathKey: "axleth_injective",
  },
  {
    chainId: "injective-1",
    address:
      "ibc/A62F794AAEC56B6828541224D91DA3E21423AB0DC4D21ECB05E4588A07BD934C",
    name: "Axelar BUSD",
    symbol: "axlBUSD",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/busd.svg",
    coingeckoId: "weth",
    commonKey: "busd-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/A62F794AAEC56B6828541224D91DA3E21423AB0DC4D21ECB05E4588A07BD934C",
    pathKey: "axlbusd_injective",
  },
  {
    chainId: "juno-1",
    address:
      "ibc/EAC38D55372F38F1AFD68DF7FE9EF762DCF69F26520643CF3F9D292A738D8034",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/EAC38D55372F38F1AFD68DF7FE9EF762DCF69F26520643CF3F9D292A738D8034",
    pathKey: "axlusdc_juno",
  },
  {
    chainId: "juno-1",
    address:
      "ibc/95A45A81521EAFDBEDAEEB6DA975C02E55B414C95AD3CE50709272366A90CA17",
    name: "Axelar ETH",
    symbol: "axlWETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/95A45A81521EAFDBEDAEEB6DA975C02E55B414C95AD3CE50709272366A90CA17",
    pathKey: "axleth_juno",
  },
  {
    chainId: "juno-1",
    address:
      "ibc/01D29B33757B631D6E02A4AE8A852969273E2476ED83CB3F947D4AA5DB9F151E",
    name: "Axelar BUSD",
    symbol: "axlBUSD",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/busd.svg",
    coingeckoId: "weth",
    commonKey: "busd-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/01D29B33757B631D6E02A4AE8A852969273E2476ED83CB3F947D4AA5DB9F151E",
    pathKey: "axlbusd_juno",
  },
  {
    chainId: "juno-1",
    address:
      "ibc/4A482FA914A4B9B05801ED81C33713899F322B24F76A06F4B8FE872485EA22FF",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    ibcDenom:
      "ibc/4A482FA914A4B9B05801ED81C33713899F322B24F76A06F4B8FE872485EA22FF",
    pathKey: "nusdc_juno",
  },
  {
    chainId: 2222,
    address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/assets/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
  },
  {
    chainId: 2222,
    address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
    name: "Axelar ETH",
    symbol: "axlETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    bridgeOnly: true,
    commonKey: "weth-wei",
  },
  {
    chainId: "kichain-2",
    address:
      "ibc/E1E3674A0E4E1EF9C69646F9AF8D9497173821826074622D831BAB73CCB99A2D",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/E1E3674A0E4E1EF9C69646F9AF8D9497173821826074622D831BAB73CCB99A2D",
    pathKey: "axlusdc_ki",
  },
  {
    chainId: "kichain-2",
    address:
      "ibc/9B68CC79EFF12D25AF712EB805C5062B8F97B2CCE5F3FE55B107EE03095514A3",
    name: "Axelar ETH",
    symbol: "axlWETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/9B68CC79EFF12D25AF712EB805C5062B8F97B2CCE5F3FE55B107EE03095514A3",
    pathKey: "axleth_ki",
  },
  {
    chainId: "kichain-2",
    address:
      "ibc/D51641D8F6C96ADE0858FC97F9F002F8436CB3E2EE9B08DAE04E1D942349C777",
    name: "Axelar BUSD",
    symbol: "axlBUSD",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/busd.svg",
    coingeckoId: "weth",
    commonKey: "busd-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/D51641D8F6C96ADE0858FC97F9F002F8436CB3E2EE9B08DAE04E1D942349C777",
    pathKey: "axlbusd_ki",
  },
  {
    chainId: "kaiyo-1",
    address:
      "ibc/295548A78785A1007F232DE286149A6FF512F180AF5657780FC89C009E2C348F",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/295548A78785A1007F232DE286149A6FF512F180AF5657780FC89C009E2C348F",
    pathKey: "axlusdc_kujira",
  },
  {
    chainId: "kaiyo-1",
    address:
      "ibc/1B38805B1C75352B28169284F96DF56BDEBD9E8FAC005BDCC8CF0378C82AA8E7",
    name: "Axelar ETH",
    symbol: "axlWETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    ibcDenom:
      "ibc/1B38805B1C75352B28169284F96DF56BDEBD9E8FAC005BDCC8CF0378C82AA8E7",
    pathKey: "axleth_kujira",
  },
  {
    chainId: "kaiyo-1",
    address:
      "ibc/65CD60D7E37EF830BC6B6A6DF4E3E3884A96C0905A7D271C48DC0440B1989EC7",
    name: "Axelar BUSD",
    symbol: "axlBUSD",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/busd.svg",
    coingeckoId: "weth",
    commonKey: "busd-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/65CD60D7E37EF830BC6B6A6DF4E3E3884A96C0905A7D271C48DC0440B1989EC7",
    pathKey: "axlbusd_kujira",
  },
  {
    chainId: "kaiyo-1",
    address:
      "ibc/FE98AAD68F02F03565E9FA39A5E627946699B2B07115889ED812D8BA639576A9",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    ibcDenom:
      "ibc/FE98AAD68F02F03565E9FA39A5E627946699B2B07115889ED812D8BA639576A9",
    pathKey: "nusdc_kujira",
  },
  {
    name: "USDCoin",
    address: "0x176211869cA2b568f2A7D4EE941E073a821EE1ff",
    symbol: "USDC",
    decimals: 6,
    chainId: 59144,
    logoURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/assets/usdc.svg",
    coingeckoId: "usd-coin",
  },
  {
    chainId: 59144,
    address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/assets/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
  },
  {
    chainId: 59144,
    address: "0xe5D7C2a44FfDDf6b295A15c148167daaAf5Cf34f",
    name: "Wrapped ETH",
    symbol: "WETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
  },
  {
    address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
    chainId: 59144,
    decimals: 18,
    logoURI: "https://docs.axelar.dev/images/assets/weth.svg",
    name: "Axelar ETH",
    symbol: "axlETH",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
  },
  {
    name: "USDCoin",
    address: "0x09bc4e0d864854c6afb6eb9a9cdf58ac190d0df9",
    symbol: "USDC",
    decimals: 6,
    chainId: 5000,
    logoURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/assets/usdc.svg",
    coingeckoId: "usd-coin",
  },
  {
    chainId: 5000,
    address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/assets/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
  },
  {
    address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
    chainId: 5000,
    decimals: 18,
    logoURI: "https://docs.axelar.dev/images/assets/weth.svg",
    name: "Axelar ETH",
    symbol: "axlETH",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
  },
  {
    chainId: "migaloo-1",
    address:
      "ibc/BC5C0BAFD19A5E4133FDA0F3E04AE1FBEE75A4A226554B2CBB021089FF2E1F8A",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    ibcDenom:
      "ibc/BC5C0BAFD19A5E4133FDA0F3E04AE1FBEE75A4A226554B2CBB021089FF2E1F8A",
    pathKey: "nusdc_migaloo",
  },
  {
    chainId: 1284,
    name: "USD Coin | Wormhole",
    address: "0x931715FEE2d06333043d11F658C8CE934aC61D0c",
    symbol: "USDC.wh",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/stellaswap/assets/main/tokenlist/0x931715FEE2d06333043d11F658C8CE934aC61D0c/logo.png",
    coingeckoId: "usd-coin",
  },
  {
    chainId: 1284,
    address: "0xCa01a1D0993565291051daFF390892518ACfAD3A",
    name: "Axelar USD Coin",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
  },
  {
    name: "Wrapped Ether | Wormhole",
    address: "0xab3f0245B83feB11d15AAffeFD7AD465a59817eD",
    symbol: "WETH.wh",
    decimals: 18,
    chainId: 1284,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
  },
  {
    chainId: "neutron-1",
    address:
      "ibc/F082B65C88E4B6D5EF1DB243CDA1D331D002759E938A0F5CD3FFDC5D53B3E349",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/F082B65C88E4B6D5EF1DB243CDA1D331D002759E938A0F5CD3FFDC5D53B3E349",
    pathKey: "axlusdc_neutron",
  },
  {
    chainId: "neutron-1",
    address:
      "ibc/A585C2D15DCD3B010849B453A2CFCB5E213208A5AB665691792684C26274304D",
    name: "Axelar ETH",
    symbol: "axlETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    ibcDenom:
      "ibc/A585C2D15DCD3B010849B453A2CFCB5E213208A5AB665691792684C26274304D",
    pathKey: "axleth_neutron",
  },
  {
    chainId: "neutron-1",
    address:
      "ibc/B559A80D62249C8AA07A380E2A2BEA6E5CA9A6F079C912C3A9E9B494105E4F81",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    ibcDenom:
      "ibc/B559A80D62249C8AA07A380E2A2BEA6E5CA9A6F079C912C3A9E9B494105E4F81",
    pathKey: "nusdc_neutron",
  },
  {
    chainId: "noble-1",
    address: "uusdc",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    ibcDenom: "uusdc",
    pathKey: "nusdc_noble",
  },
  {
    chainId: "pirin-1",
    address:
      "ibc/A7C4A3FB19E88ABE60416125F9189DA680800F4CDD14E3C10C874E022BEFF04C",
    name: "Axelar ETH",
    symbol: "ETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    ibcDenom:
      "ibc/A7C4A3FB19E88ABE60416125F9189DA680800F4CDD14E3C10C874E022BEFF04C",
    pathKey: "axleth_nolus",
  },
  {
    chainId: "pirin-1",
    address:
      "ibc/F5FABF52B54E65064B57BF6DBD8E5FAD22CEE9F4B8A57ADBB20CCD0173AA72A4",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    ibcDenom:
      "ibc/F5FABF52B54E65064B57BF6DBD8E5FAD22CEE9F4B8A57ADBB20CCD0173AA72A4",
    pathKey: "nusdc_nolus",
  },
  {
    chainId: 10,
    address: "0x7f5c764cbc14f9669b88837ca1490cca17c31607",
    name: "USD Coin (Bridged from Ethereum)",
    symbol: "USDC.e",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
  },
  {
    chainId: 10,
    address: "0x0b2C639c533813f4Aa9D7837CAf62653d097Ff85",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
  },
  {
    chainId: 10,
    address: "0x4200000000000000000000000000000000000006",
    name: "Wrapped Ether",
    symbol: "WETH",
    decimals: 18,
    logoURI: "https://ethereum-optimism.github.io/data/WETH/logo.png",
    coingeckoId: "weth",
  },
  {
    chainId: 10,
    address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
  },
  {
    chainId: "osmosis-1",
    address:
      "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    ibcDenom:
      "ibc/498A0751C798A0D9A389AA3691123DADA57DAA4FE165D5C75894505B876BA6E4",
    pathKey: "nusdc_osmosis",
  },
  {
    chainId: "osmosis-1",
    address:
      "ibc/D189335C6E4A68B513C10AB227BF1C1D38C746766278BA3EEB4FB14124F1D858",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/D189335C6E4A68B513C10AB227BF1C1D38C746766278BA3EEB4FB14124F1D858",
    pathKey: "axlusdc_osmosis",
  },
  {
    chainId: "osmosis-1",
    address:
      "ibc/EA1D43981D5C9A1C4AAEA9C23BB1D4FA126BA9BC7020A25E0AE4AA841EA25DC5",
    name: "Axelar ETH",
    symbol: "axlETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    ibcDenom:
      "ibc/EA1D43981D5C9A1C4AAEA9C23BB1D4FA126BA9BC7020A25E0AE4AA841EA25DC5",
    pathKey: "axleth_osmosis",
  },
  {
    chainId: "osmosis-1",
    address:
      "ibc/6329DD8CF31A334DD5BE3F68C846C9FE313281362B37686A62343BAC1EB1546D",
    name: "Axelar BUSD",
    symbol: "axlBUSD",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/busd.svg",
    coingeckoId: "weth",
    commonKey: "busd-wei",
    ibcDenom:
      "ibc/6329DD8CF31A334DD5BE3F68C846C9FE313281362B37686A62343BAC1EB1546D",
    pathKey: "axlbusd_osmosis",
  },
  {
    chainId: "osmosis-1",
    name: "polygon USD Coin",
    address:
      "ibc/231FD77ECCB2DB916D314019DA30FE013202833386B1908A191D16989AD80B5A",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    ibcDenom:
      "ibc/231FD77ECCB2DB916D314019DA30FE013202833386B1908A191D16989AD80B5A",
    commonKey: "polygon-uusdc",
    pathKey: "axlpusdc_osmosis",
  },
  {
    chainId: "core-1",
    address:
      "ibc/B3792E4A62DF4A934EF2DF5968556DB56F5776ED25BDE11188A4F58A7DD406F0",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    ibcDenom:
      "ibc/B3792E4A62DF4A934EF2DF5968556DB56F5776ED25BDE11188A4F58A7DD406F0",
    pathKey: "nusdc_persistence",
  },
  {
    name: "USD Coin (PoS)",
    address: "0x2791Bca1f2de4661ED88A30C99A7a9449Aa84174",
    symbol: "USDC.e",
    decimals: 6,
    chainId: 137,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    commonKey: "polygon-uusdc",
  },
  {
    chainId: 137,
    address: "0x3c499c542cEF5E3811e1192ce70d8cC03d5c3359",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
  },
  {
    chainId: 137,
    address: "0x750e4C4984a9e0f12978eA6742Bc1c5D248f40ed",
    name: "axlUSDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
  },
  {
    name: "Wrapped Ether",
    address: "0x7ceB23fD6bC0adD59E62ac25578270cFf1b9f619",
    symbol: "WETH",
    decimals: 18,
    chainId: 137,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
  },
  {
    chainId: "regen-1",
    address:
      "ibc/334740505537E9894A64E8561030695016481830D7B36E6A9B6D13C608B55653",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/334740505537E9894A64E8561030695016481830D7B36E6A9B6D13C608B55653",
    pathKey: "axlusdc_regen",
  },
  {
    chainId: "regen-1",
    address:
      "ibc/62B27C470C859CBCB57DC12FCBBD357DD44CAD673362B47503FAA77523ABA028",
    name: "Axelar ETH",
    symbol: "axlWETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/62B27C470C859CBCB57DC12FCBBD357DD44CAD673362B47503FAA77523ABA028",
    pathKey: "axleth_regen",
  },
  {
    chainId: "regen-1",
    address:
      "ibc/C0B2F6309C73078A793F8DB25B72028728F9CE1244A60E0D356DDF92861503CB",
    name: "Axelar BUSD",
    symbol: "axlBUSD",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/busd.svg",
    coingeckoId: "weth",
    commonKey: "busd-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/C0B2F6309C73078A793F8DB25B72028728F9CE1244A60E0D356DDF92861503CB",
    pathKey: "axlbusd_regen",
  },
  {
    chainId: 534352,
    address: "0x5300000000000000000000000000000000000004",
    name: "Wrapped ETH",
    symbol: "WETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
  },
  {
    chainId: 534352,
    name: "USDCoin",
    address: "0x06eFdBFf2a14a7c8E15944D1F4A48F9F95F663A4",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/assets/usdc.svg",
    coingeckoId: "usd-coin",
  },
  {
    chainId: 534352,
    address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/assets/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
  },
  {
    address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
    chainId: 534352,
    decimals: 18,
    logoURI: "https://docs.axelar.dev/images/assets/weth.svg",
    name: "Axelar ETH",
    symbol: "axlETH",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
  },
  {
    chainId: "secret-4",
    address: "secret1vkq022x4q8t8kx9de3r84u669l65xnwf2lg3e6",
    codeHash:
      "638a3e1d50175fbcb8373cf801565283e3eb23d88a9b7b7f99fcc5eb1e6b561e",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    ibcDenom:
      "ibc/FC0FF958BC92354A5EF218C511B6949B29407D9EBEB741E2833137961ABAFD96",
    pathKey: "axlusdc_secret",
    commonKey: "uusdc",
  },
  {
    chainId: "secret-4",
    address: "secret139qfh3nmuzfgwsx2npnmnjl4hrvj3xq5rmq8a0",
    codeHash:
      "638a3e1d50175fbcb8373cf801565283e3eb23d88a9b7b7f99fcc5eb1e6b561e",
    name: "Axelar ETH",
    symbol: "axlETH",
    decimals: 18,
    logoURI: "https://docs.axelar.dev/images/assets/weth.svg",
    coingeckoId: "weth",
    ibcDenom:
      "ibc/63D64CE0A4CAAE106B251E1B3DB351A0384B1D00A65DCC88CC0F43D7C06D28F7",
    pathKey: "axleth_secret",
    commonKey: "weth-wei",
  },
  {
    chainId: "pacific-1",
    address:
      "ibc/CA6FBFAF399474A06263E10D0CE5AEBBE15189D6D4B2DD9ADE61007E68EB9DB0",
    name: "Noble USDC",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    ibcDenom:
      "ibc/CA6FBFAF399474A06263E10D0CE5AEBBE15189D6D4B2DD9ADE61007E68EB9DB0",
    pathKey: "nusdc_sei",
  },
  {
    chainId: "stargaze-1",
    address:
      "ibc/96274e25174ee93314d8b5636d2d2f70963e207c22f643ec41949a3cbeda4c72",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/96274e25174ee93314d8b5636d2d2f70963e207c22f643ec41949a3cbeda4c72",
    pathKey: "axlusdc_stargaze",
  },
  {
    chainId: "stargaze-1",
    address:
      "ibc/4A1C18CA7F50544760CF306189B810CE4C1CB156C7FC870143D401FE7280E591",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    ibcDenom:
      "ibc/4A1C18CA7F50544760CF306189B810CE4C1CB156C7FC870143D401FE7280E591",
    pathKey: "nusdc_stargaze",
  },
  {
    chainId: "columbus-5",
    address:
      "ibc/E1E3674A0E4E1EF9C69646F9AF8D9497173821826074622D831BAB73CCB99A2D",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/E1E3674A0E4E1EF9C69646F9AF8D9497173821826074622D831BAB73CCB99A2D",
    pathKey: "axlusdc_terra",
  },
  {
    chainId: "columbus-5",
    address:
      "ibc/9B68CC79EFF12D25AF712EB805C5062B8F97B2CCE5F3FE55B107EE03095514A3",
    name: "Axelar ETH",
    symbol: "axlWETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    ibcDenom:
      "ibc/9B68CC79EFF12D25AF712EB805C5062B8F97B2CCE5F3FE55B107EE03095514A3",
    pathKey: "axleth_terra",
  },
  {
    chainId: "phoenix-1",
    address:
      "ibc/B3504E092456BA618CC28AC671A71FB08C6CA0FD0BE7C8A5B5A3E2DD933CC9E4",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/B3504E092456BA618CC28AC671A71FB08C6CA0FD0BE7C8A5B5A3E2DD933CC9E4",
    pathKey: "axlusdc_terra2",
  },
  {
    chainId: "phoenix-1",
    address:
      "ibc/BC8A77AFBD872FDC32A348D3FB10CC09277C266CFE52081DE341C7EC6752E674",
    name: "Axelar ETH",
    symbol: "axlWETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/BC8A77AFBD872FDC32A348D3FB10CC09277C266CFE52081DE341C7EC6752E674",
    pathKey: "axleth_terra2",
  },
  {
    chainId: "phoenix-1",
    address:
      "ibc/FDDF98401F29AC63212C1742F9EC86D3AA1E1BE94BF9EB2F72B990C490303F42",
    name: "Axelar BUSD",
    symbol: "axlBUSD",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/busd.svg",
    coingeckoId: "weth",
    commonKey: "busd-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/FDDF98401F29AC63212C1742F9EC86D3AA1E1BE94BF9EB2F72B990C490303F42",
    pathKey: "axlbusd_terra2",
  },
  {
    chainId: "phoenix-1",
    address:
      "ibc/2C962DAB9F57FE0921435426AE75196009FAA1981BF86991203C8411F8980FDB",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "usd-coin",
    ibcDenom:
      "ibc/2C962DAB9F57FE0921435426AE75196009FAA1981BF86991203C8411F8980FDB",
    pathKey: "nusdc_terra2",
  },
  {
    chainId: "umee-1",
    address:
      "ibc/49788C29CD84E08D25CA7BE960BC1F61E88FEFC6333F58557D236D693398466A",
    name: "Axelar USDC",
    symbol: "axlUSDC",
    decimals: 6,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
    coingeckoId: "axlusdc",
    commonKey: "uusdc",
    ibcDenom:
      "ibc/49788C29CD84E08D25CA7BE960BC1F61E88FEFC6333F58557D236D693398466A",
    pathKey: "axlusdc_umee",
  },
  {
    chainId: "umee-1",
    address:
      "ibc/04CE51E6E02243E565AE676DD60336E48D455F8AAD0611FA0299A22FDAC448D6",
    name: "Axelar ETH",
    symbol: "axlWETH",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
    coingeckoId: "weth",
    commonKey: "weth-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/04CE51E6E02243E565AE676DD60336E48D455F8AAD0611FA0299A22FDAC448D6",
    pathKey: "axleth_umee",
  },
  {
    chainId: "umee-1",
    address:
      "ibc/D35E5113823942EE8655934A5476B2C4C1C84C8E83AEF04A89C256FC51437463",
    name: "Axelar BUSD",
    symbol: "axlBUSD",
    decimals: 18,
    logoURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/busd.svg",
    coingeckoId: "weth",
    commonKey: "busd-wei",
    bridgeOnly: true,
    ibcDenom:
      "ibc/D35E5113823942EE8655934A5476B2C4C1C84C8E83AEF04A89C256FC51437463",
    pathKey: "axlbusd_umee",
  },
];

export const MockChains = [
  {
    chainName: "Ethereum",
    chainType: "evm",
    rpc: "https://ethereum.publicnode.com",
    networkName: "Ethereum",
    chainId: 1,
    nativeCurrency: {
      name: "Ethereum",
      symbol: "ETH",
      decimals: 18,
      icon: "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/eth.svg",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/eth.svg",
    blockExplorerUrls: ["https://etherscan.io/"],
    chainNativeContracts: {
      wrappedNativeToken: "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
      ensRegistry: "0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e",
      multicall: "0xcA11bde05977b3631167028862bE2a173976CA11",
      usdcToken: "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48",
    },
    axelarContracts: {
      gateway: "0x4F4495243837681061C4743b74B3eEdf548D56A5",
      forecallable: "",
    },
    estimatedRouteDuration: 960,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "Arbitrum",
    chainType: "evm",
    rpc: "https://arb1.arbitrum.io/rpc",
    networkName: "Arbitrum",
    chainId: 42161,
    nativeCurrency: {
      name: "Arbitrum",
      symbol: "ETH",
      decimals: 18,
      icon: "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/chains/arbitrum.svg",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/arb.svg",
    blockExplorerUrls: ["https://arbiscan.io/"],
    chainNativeContracts: {
      wrappedNativeToken: "0x82af49447d8a07e3bd95bd0d56f35241523fbab1",
      ensRegistry: "",
      multicall: "0xcA11bde05977b3631167028862bE2a173976CA11",
      usdcToken: "0xff970a61a04b1ca14834a43f5de4533ebddb5cc8",
    },
    axelarContracts: {
      gateway: "0xe432150cce91c13a887f7D836923d5597adD8E31",
      forecallable: "0x2d5d7d31F671F86C782533cc367F14109a082712",
    },
    estimatedRouteDuration: 1800,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "optimism",
    chainType: "evm",
    rpc: "https://mainnet.optimism.io",
    networkName: "Optimism",
    chainId: 10,
    nativeCurrency: {
      name: "Optimism",
      symbol: "ETH",
      decimals: 18,
      icon: "https://s2.coinmarketcap.com/static/img/coins/64x64/11840.png",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://s2.coinmarketcap.com/static/img/coins/64x64/11840.png",
    blockExplorerUrls: ["https://optimistic.etherscan.io/"],
    chainNativeContracts: {
      wrappedNativeToken: "0x4200000000000000000000000000000000000006",
      ensRegistry: "",
      multicall: "0xcA11bde05977b3631167028862bE2a173976CA11",
      usdcToken: "0x7F5c764cBc14f9669B88837ca1490cCa17c31607",
    },
    axelarContracts: {
      gateway: "0xe432150cce91c13a887f7D836923d5597adD8E31",
      forecallable: "0x2d5d7d31F671F86C782533cc367F14109a082712",
    },
    estimatedRouteDuration: 1800,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "linea",
    chainType: "evm",
    rpc: "https://rpc.linea.build",
    networkName: "Linea",
    chainId: 59144,
    nativeCurrency: {
      name: "Linea",
      symbol: "ETH",
      decimals: 18,
      icon: "https://raw.githubusercontent.com/axelarnetwork/axelar-satellite/main/public/assets/chains/linea.logo.svg",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-satellite/main/public/assets/chains/linea.logo.svg",
    blockExplorerUrls: ["https://lineascan.build/"],
    chainNativeContracts: {
      wrappedNativeToken: "0xe5D7C2a44FfDDf6b295A15c148167daaAf5Cf34f",
      ensRegistry: "",
      multicall: "0xcA11bde05977b3631167028862bE2a173976CA11",
      usdcToken: "0x176211869cA2b568f2A7D4EE941E073a821EE1ff",
    },
    axelarContracts: {
      gateway: "0xe432150cce91c13a887f7D836923d5597adD8E31",
      forecallable: "0xbE406F0189A0B4cf3A05C286473D23791Dd44Cc6",
    },
    estimatedRouteDuration: 1800,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "base",
    chainType: "evm",
    rpc: "https://developer-access-mainnet.base.org",
    networkName: "Base",
    chainId: 8453,
    nativeCurrency: {
      name: "Base",
      symbol: "ETH",
      decimals: 18,
      icon: "https://raw.githubusercontent.com/axelarnetwork/axelar-satellite/main/public/assets/chains/base.logo.svg",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-satellite/main/public/assets/chains/base.logo.svg",
    blockExplorerUrls: ["https://basescan.org/"],
    chainNativeContracts: {
      wrappedNativeToken: "0x4200000000000000000000000000000000000006",
      ensRegistry: "",
      multicall: "0xcA11bde05977b3631167028862bE2a173976CA11",
      usdcToken: "0xd9aAEc86B65D86f6A7B5B1b0c42FFA531710b6CA",
    },
    axelarContracts: {
      gateway: "0xe432150cce91c13a887f7D836923d5597adD8E31",
      forecallable: "0x2d5d7d31F671F86C782533cc367F14109a082712",
    },
    estimatedRouteDuration: 1800,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "Avalanche",
    chainType: "evm",
    rpc: "https://api.avax.network/ext/bc/C/rpc",
    networkName: "Avalanche",
    chainId: 43114,
    nativeCurrency: {
      name: "Avalanche",
      symbol: "AVAX",
      decimals: 18,
      icon: "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/chains/avalanche.svg",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/chains/avalanche.svg",
    blockExplorerUrls: ["https://avascan.info/blockchain/c/"],
    chainNativeContracts: {
      wrappedNativeToken: "0xB31f66AA3C1e785363F0875A1B74E27b85FD66c7",
      ensRegistry: "0xa7eebb2926d22d34588497769889cbc2be0a5d97",
      multicall: "0xcA11bde05977b3631167028862bE2a173976CA11",
      usdcToken: "0xB97EF9Ef8734C71904D8002F8b6Bc66Dd9c48a6E",
    },
    axelarContracts: {
      gateway: "0x5029C0EFf6C34351a0CEc334542cDb22c7928f78",
      forecallable: "",
    },
    estimatedRouteDuration: 90,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "Polygon",
    chainType: "evm",
    rpc: "https://polygon-rpc.com",
    networkName: "Polygon",
    chainId: 137,
    nativeCurrency: {
      name: "Polygon",
      symbol: "POL",
      decimals: 18,
      icon: "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/chains/polygon.svg",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/chains/polygon.svg",
    blockExplorerUrls: ["https://polygonscan.com/"],
    chainNativeContracts: {
      wrappedNativeToken: "0x0d500B1d8E8eF31E21C99d1Db9A6444d3ADf1270",
      ensRegistry: "",
      multicall: "0xcA11bde05977b3631167028862bE2a173976CA11",
      usdcToken: "0x2791Bca1f2de4661ED88A30C99A7a9449Aa84174",
    },
    axelarContracts: {
      gateway: "0x6f015F16De9fC8791b234eF68D486d2bF203FBA8",
      forecallable: "0x2d5d7d31F671F86C782533cc367F14109a082712",
    },
    estimatedRouteDuration: 360,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "binance",
    chainType: "evm",
    rpc: "https://bsc-dataseed.binance.org",
    networkName: "BNB Chain",
    chainId: 56,
    nativeCurrency: {
      name: "BNB",
      symbol: "BNB",
      decimals: 18,
      icon: "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/bnb.svg",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/bnb.svg",
    blockExplorerUrls: ["https://bscscan.com/"],
    chainNativeContracts: {
      wrappedNativeToken: "0xbb4CdB9CBd36B01bD1cBaEBF2De08d9173bc095c",
      ensRegistry: "",
      multicall: "0xcA11bde05977b3631167028862bE2a173976CA11",
      usdcToken: "0x55d398326f99059fF775485246999027B3197955",
    },
    axelarContracts: {
      gateway: "0x304acf330bbE08d1e512eefaa92F6a57871fD895",
      forecallable: "0x2d5d7d31F671F86C782533cc367F14109a082712",
    },
    estimatedRouteDuration: 150,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "Fantom",
    chainType: "evm",
    rpc: "https://rpc.ankr.com/fantom",
    networkName: "Fantom",
    chainId: 250,
    nativeCurrency: {
      name: "FTM",
      symbol: "FTM",
      decimals: 18,
      icon: "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/chains/fantom.svg",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/chains/fantom.svg",
    blockExplorerUrls: ["https://ftmscan.com/"],
    chainNativeContracts: {
      wrappedNativeToken: "0x21be370D5312f44cB42ce377BC9b8a0cEF1A4C83",
      ensRegistry: "",
      multicall: "0xcA11bde05977b3631167028862bE2a173976CA11",
      usdcToken: "0x21be370D5312f44cB42ce377BC9b8a0cEF1A4C83",
    },
    axelarContracts: {
      gateway: "0x304acf330bbE08d1e512eefaa92F6a57871fD895",
      forecallable: "0x2d5d7d31F671F86C782533cc367F14109a082712",
    },
    estimatedRouteDuration: 70,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "Moonbeam",
    chainType: "evm",
    rpc: "https://rpc.api.moonbeam.network",
    networkName: "Moonbeam",
    chainId: 1284,
    nativeCurrency: {
      name: "Moonbeam",
      symbol: "GLMR",
      decimals: 18,
      icon: "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/glmr.svg",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/glmr.svg",
    blockExplorerUrls: ["https://moonscan.io/"],
    chainNativeContracts: {
      wrappedNativeToken: "0xAcc15dC74880C9944775448304B263D191c6077F",
      ensRegistry: "",
      multicall: "0xcA11bde05977b3631167028862bE2a173976CA11",
      usdcToken: "0x931715fee2d06333043d11f658c8ce934ac61d0c",
    },
    axelarContracts: {
      gateway: "0x4F4495243837681061C4743b74B3eEdf548D56A5",
      forecallable: "",
    },
    estimatedRouteDuration: 120,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "mantle",
    chainType: "evm",
    rpc: "https://rpc.mantle.xyz",
    networkName: "Mantle",
    chainId: 5000,
    nativeCurrency: {
      name: "Mantle",
      symbol: "MNT",
      decimals: 18,
      icon: "https://assets.coingecko.com/coins/images/30980/small/token-logo.png?1689320029",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/wmnt.svg",
    blockExplorerUrls: ["https://mantlescan.info/"],
    chainNativeContracts: {
      wrappedNativeToken: "0x78c1b0C915c4FAA5FffA6CAbf0219DA63d7f4cb8",
      ensRegistry: "",
      multicall: "0xcA11bde05977b3631167028862bE2a173976CA11",
      usdcToken: "0x09bc4e0d864854c6afb6eb9a9cdf58ac190d0df9",
    },
    axelarContracts: {
      gateway: "0xe432150cce91c13a887f7D836923d5597adD8E31",
      forecallable: "0x2d5d7d31F671F86C782533cc367F14109a082712",
    },
    estimatedRouteDuration: 100,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "scroll",
    chainType: "evm",
    rpc: "https://rpc.scroll.io",
    networkName: "Scroll",
    chainId: 534352,
    nativeCurrency: {
      name: "Scroll",
      symbol: "ETH",
      decimals: 18,
      icon: "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/chains/scroll.svg",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/chains/scroll.svg",
    blockExplorerUrls: ["https://scrollscan.com/"],
    chainNativeContracts: {
      wrappedNativeToken: "0x5300000000000000000000000000000000000004",
      ensRegistry: "",
      multicall: "0xcA11bde05977b3631167028862bE2a173976CA11",
      usdcToken: "0x06eFdBFf2a14a7c8E15944D1F4A48F9F95F663A4",
    },
    axelarContracts: {
      gateway: "0xe432150cce91c13a887f7D836923d5597adD8E31",
      forecallable: "0x2d5d7d31F671F86C782533cc367F14109a082712",
    },
    estimatedRouteDuration: 100,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "celo",
    chainType: "evm",
    rpc: "https://forno.celo.org",
    networkName: "Celo",
    chainId: 42220,
    nativeCurrency: {
      name: "CELO",
      symbol: "CELO",
      decimals: 18,
      icon: "https://raw.githubusercontent.com/0xsquid/assets/main/images/chains/celo.svg",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/chains/celo.svg",
    blockExplorerUrls: ["https://celoscan.io/"],
    chainNativeContracts: {
      wrappedNativeToken: "0x471EcE3750Da237f93B8E339c536989b8978a438",
      ensRegistry: "",
      multicall: "0xcA11bde05977b3631167028862bE2a173976CA11",
      usdcToken: "0xcebA9300f2b948710d2653dD7B07f33A8B32118C",
    },
    axelarContracts: {
      gateway: "0xe432150cce91c13a887f7D836923d5597adD8E31",
      forecallable: "0x2d5d7d31F671F86C782533cc367F14109a082712",
    },
    estimatedRouteDuration: 90,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "kava",
    chainType: "evm",
    rpc: "https://evm2.kava.io",
    networkName: "Kava EVM",
    chainId: 2222,
    nativeCurrency: {
      name: "Kava",
      symbol: "KAVA",
      decimals: 18,
      icon: "https://s2.coinmarketcap.com/static/img/coins/64x64/4846.png",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://s2.coinmarketcap.com/static/img/coins/64x64/4846.png",
    blockExplorerUrls: ["https://kavascan.com/"],
    chainNativeContracts: {
      wrappedNativeToken: "0xc86c7C0eFbd6A49B35E8714C5f59D99De09A225b",
      ensRegistry: "",
      multicall: "0xcA11bde05977b3631167028862bE2a173976CA11",
      usdcToken: "0xc86c7C0eFbd6A49B35E8714C5f59D99De09A225b",
    },
    axelarContracts: {
      gateway: "0xe432150cce91c13a887f7D836923d5597adD8E31",
      forecallable: "",
    },
    estimatedRouteDuration: 120,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "filecoin",
    chainType: "evm",
    rpc: "https://api.node.glif.io",
    networkName: "Filecoin",
    chainId: 314,
    nativeCurrency: {
      name: "Filecoin",
      symbol: "FIL",
      decimals: 18,
      icon: "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/chains/filecoin.svg",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/chains/filecoin.svg",
    blockExplorerUrls: ["https://filfox.info/"],
    chainNativeContracts: {
      wrappedNativeToken: "0x60E1773636CF5E4A227d9AC24F20fEca034ee25A",
      ensRegistry: "",
      multicall: "0xcA11bde05977b3631167028862bE2a173976CA11",
      usdcToken: "TODO",
    },
    axelarContracts: {
      gateway: "0xe432150cce91c13a887f7D836923d5597adD8E31",
      forecallable: "0x2d5d7d31F671F86C782533cc367F14109a082712",
    },
    estimatedRouteDuration: 3600,
    estimatedExpressRouteDuration: 120,
  },
  {
    chainName: "blast",
    chainType: "evm",
    rpc: "https://rpc.blast.io",
    networkName: "Blast",
    chainId: 81457,
    nativeCurrency: {
      name: "Blast",
      symbol: "ETH",
      decimals: 18,
      icon: "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/eth.svg",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/blast.svg",
    blockExplorerUrls: ["https://blastscan.io/"],
    chainNativeContracts: {
      wrappedNativeToken: "0x4300000000000000000000000000000000000004",
      ensRegistry: "",
      multicall: "0xcA11bde05977b3631167028862bE2a173976CA11",
      usdcToken: "0x4300000000000000000000000000000000000003",
    },
    axelarContracts: {
      gateway: "0xe432150cce91c13a887f7D836923d5597adD8E31",
      forecallable: "0x2d5d7d31F671F86C782533cc367F14109a082712",
    },
    estimatedRouteDuration: 1800,
    estimatedExpressRouteDuration: 120,
  },
  {
    chainName: "fraxtal",
    chainType: "evm",
    rpc: "https://rpc.frax.com",
    networkName: "Fraxtal",
    chainId: 252,
    nativeCurrency: {
      name: "Frax Ether",
      symbol: "frxETH",
      decimals: 18,
      icon: "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/frxeth.svg",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/main/public/images/chains/fraxtal.svg",
    blockExplorerUrls: ["https://fraxscan.com/"],
    chainNativeContracts: {
      wrappedNativeToken: "0xfc00000000000000000000000000000000000006",
      ensRegistry: "",
      multicall: "0xcA11bde05977b3631167028862bE2a173976CA11",
      usdcToken: "0xfc00000000000000000000000000000000000001",
    },
    axelarContracts: {
      gateway: "0xe432150cce91c13a887f7D836923d5597adD8E31",
      forecallable: "0x2d5d7d31F671F86C782533cc367F14109a082712",
    },
    estimatedRouteDuration: 1800,
    estimatedExpressRouteDuration: 120,
  },
  {
    chainName: "immutable",
    chainType: "evm",
    rpc: "https://rpc.immutable.com",
    networkName: "Immutable zkEVM",
    chainId: 13371,
    nativeCurrency: {
      name: "IMX",
      symbol: "IMX",
      decimals: 18,
      icon: "https://raw.githubusercontent.com/0xsquid/assets/main/images/chains/saga.svg",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/chains/immutable-blk.svg",
    blockExplorerUrls: ["https://explorer.immutable.com/"],
    chainNativeContracts: {
      wrappedNativeToken: "0x3A0C2Ba54D6CBd3121F01b96dFd20e99D1696C9D",
      ensRegistry: "",
      multicall: "0xcA11bde05977b3631167028862bE2a173976CA11",
      usdcToken: "0x6de8aCC0D406837030CE4dd28e7c08C5a96a30d2",
    },
    axelarContracts: {
      gateway: "0xe432150cce91c13a887f7D836923d5597adD8E31",
      forecallable: "",
    },
    estimatedRouteDuration: 960,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "osmosis",
    chainType: "cosmos",
    rpc: "https://osmosis-rpc.stakely.io",
    rpcList: [
      "https://osmosis-rpc.lavenderfive.com",
      "https://osmosis-rpc.stakely.io",
      "https://rpc-osmosis.whispernode.com:443",
      "https://osmosis-rpc.stakely.io",
    ],
    rest: "https://osmosis-1--lcd--full.datahub.figment.io/apikey/6d8baa3d3e97e427db4bd7ffcfb21be4",
    networkName: "Osmosis",
    chainId: "osmosis-1",
    nativeCurrency: {
      name: "Osmosis",
      symbol: "OSMO",
      decimals: 6,
      icon: "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/osmo.svg",
    },
    swapAmountForGas: "100000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/osmo.svg",
    blockExplorerUrls: ["https://www.mintscan.io/osmosis/"],
    bip44: {
      coinType: 118,
    },
    bech32Config: {
      bech32PrefixAccAddr: "osmo",
      bech32PrefixAccPub: "osmopub",
      bech32PrefixValAddr: "osmovaloper",
      bech32PrefixValPub: "osmovaloperpub",
      bech32PrefixConsAddr: "osmovalcons",
      bech32PrefixConsPub: "osmovalconspub",
    },
    feeCurrencies: [
      {
        coinDenom: "OSMO",
        coinMinimalDenom: "uosmo",
        coinDecimals: 6,
        coingeckoId: "osmosis",
      },
    ],
    stakeCurrency: {
      coinDenom: "OSMO",
      coinMinimalDenom: "uosmo",
      coinDecimals: 6,
      coingeckoId: "osmosis",
    },
    currencies: [
      {
        coinDenom: "OSMO",
        coinMinimalDenom: "uosmo",
        coinDecimals: 6,
        coingeckoId: "osmosis",
      },
    ],
    features: ["ibc-transfer", "ibc-go", "ibc-pfm"],
    coinType: 118,
    axelarContracts: {
      gateway: "",
    },
    gasPriceStep: {
      low: 0.1,
      average: 0.2,
      high: 0.25,
    },
    chainToAxelarChannelId: "channel-208",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "cosmoshub",
    chainType: "cosmos",
    rpc: "https://cosmos-rpc.publicnode.com",
    rpcList: [
      "https://cosmos-rpc.quickapi.com:443",
      "https://cosmos-rpc.onivalidator.com",
      "https://rpc-cosmoshub.whispernode.com:443",
    ],
    rest: "https://api.cosmos.network",
    networkName: "Cosmos Hub",
    chainId: "cosmoshub-4",
    nativeCurrency: {
      name: "cosmoshub",
      symbol: "ATOM",
      decimals: 6,
      icon: "https://s2.coinmarketcap.com/static/img/coins/64x64/3794.png",
    },
    swapAmountForGas: "100000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/atom.svg",
    blockExplorerUrls: ["https://www.mintscan.io/cosmos/"],
    currencies: [
      {
        coinDenom: "ATOM",
        coinMinimalDenom: "uatom",
        coinDecimals: 6,
        coingeckoId: "cosmos",
      },
    ],
    stakeCurrency: {
      coinDenom: "ATOM",
      coinMinimalDenom: "uatom",
      coinDecimals: 6,
      coingeckoId: "cosmos",
    },
    bip44: {
      coinType: 118,
    },
    bech32Config: {
      bech32PrefixAccAddr: "cosmos",
      bech32PrefixAccPub: "cosmospub",
      bech32PrefixValAddr: "cosmosvaloper",
      bech32PrefixValPub: "cosmosvaloperpub",
      bech32PrefixConsAddr: "cosmosvalcons",
      bech32PrefixConsPub: "cosmosvalconspub",
    },
    feeCurrencies: [
      {
        coinDenom: "ATOM",
        coinMinimalDenom: "uatom",
        coinDecimals: 6,
        coingeckoId: "cosmos",
      },
    ],
    features: ["ibc-transfer", "ibc-go", "ibc-pfm"],
    coinType: 118,
    gasPriceStep: {
      low: 0.01,
      average: 0.025,
      high: 0.03,
    },
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-293",
  },
  {
    chainName: "dydx",
    chainType: "cosmos",
    rpc: "https://dydx-ops-rpc.kingnodes.com",
    rpcList: [
      "https://dydx-rpc.lavenderfive.com",
      "https://dydx-mainnet-rpc.autostake.com",
      "https://rpc-dydx.ecostake.com",
    ],
    rest: "https://dydx-api.lavenderfive.com:443",
    nativeCurrency: {
      name: "dydx",
      symbol: "DYDX",
      decimals: 6,
      icon: "https://s2.coinmarketcap.com/static/img/coins/64x64/11156.png",
    },
    swapAmountForGas: "1000000",
    chainIconURI:
      "https://s2.coinmarketcap.com/static/img/coins/64x64/11156.png",
    blockExplorerUrls: ["https://www.mintscan.io/dydx/"],
    chainId: "dydx-mainnet-1",
    networkName: "dYdX",
    stakeCurrency: {
      coinDenom: "adydx",
      coinMinimalDenom: "adydx",
      coinDecimals: 6,
      coingeckoId: "dydx",
    },
    bech32Config: {
      bech32PrefixAccAddr: "dydx",
      bech32PrefixAccPub: "dydxpub",
      bech32PrefixValAddr: "dydxvaloper",
      bech32PrefixValPub: "dydxvaloperpub",
      bech32PrefixConsAddr: "dydxvalcons",
      bech32PrefixConsPub: "dydxvalconspub",
    },
    bip44: {
      coinType: 118,
    },
    currencies: [
      {
        coinDenom: "adydx",
        coinMinimalDenom: "adydx",
        coinDecimals: 6,
        coingeckoId: "dydx",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "uusdc",
        coinMinimalDenom: "uusdc",
        coinDecimals: 6,
        coingeckoId: "usdc",
      },
    ],
    coinType: 118,
    gasPriceStep: {
      low: 0.05,
      average: 0.125,
      high: 0.2,
    },
    features: ["stargate", "no-legacy-stdTx", "ibc-transfer"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "kujira",
    chainType: "cosmos",
    rpc: "https://rpc.cosmos.directory/kujira",
    rpcList: [
      "https://rpc.cosmos.directory/kujira",
      "https://kujira-rpc.polkachu.com",
      "https://rpc-kujira.ecostake.com",
    ],
    rest: "https://lcd.kaiyo.kujira.setten.io",
    networkName: "Kujira",
    chainId: "kaiyo-1",
    nativeCurrency: {
      name: "Kuji",
      symbol: "KUJI",
      decimals: 6,
      icon: "https://s2.coinmarketcap.com/static/img/coins/64x64/15185.png",
    },
    swapAmountForGas: "200000",
    chainIconURI: "https://axelarscan.io/logos/chains/kujira.svg",
    blockExplorerUrls: ["https://finder.kujira.network/kaiyo-1/"],
    bip44: {
      coinType: 118,
    },
    bech32Config: {
      bech32PrefixAccAddr: "kujira",
      bech32PrefixAccPub: "kujirapub",
      bech32PrefixValAddr: "kujiravaloper",
      bech32PrefixValPub: "kujiravaloperpub",
      bech32PrefixConsAddr: "kujiravalcons",
      bech32PrefixConsPub: "kujiravalconspub",
    },
    currencies: [
      {
        coinDenom: "KUJI",
        coinMinimalDenom: "ukuji",
        coinDecimals: 6,
        coingeckoId: "kujira",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "KUJI",
        coinMinimalDenom: "ukuji",
        coinDecimals: 6,
        coingeckoId: "kujira",
      },
    ],
    stakeCurrency: {
      coinDenom: "KUJI",
      coinMinimalDenom: "ukuji",
      coinDecimals: 6,
      coingeckoId: "kujira",
    },
    coinType: 118,
    gasPriceStep: {
      low: 0.01,
      average: 0.025,
      high: 0.03,
    },
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-9",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "neutron",
    chainType: "cosmos",
    rpc: "https://rpc-kralum.neutron-1.neutron.org",
    rpcList: [
      "https://rpc-kralum.neutron-1.neutron.org",
      "https://rpc.novel.remedy.tm.p2p.org",
      "https://neutron-rpc.lavenderfive.com",
    ],
    rest: "https://rest-kralum.neutron-1.neutron.org",
    networkName: "Neutron",
    chainId: "neutron-1",
    nativeCurrency: {
      name: "ntrn",
      symbol: "NTRN",
      decimals: 6,
      icon: "https://axelarscan.io/logos/chains/neutron.svg",
    },
    swapAmountForGas: "1000000",
    chainIconURI: "https://axelarscan.io/logos/chains/neutron.svg",
    blockExplorerUrls: ["https://www.mintscan.io/neutron/"],
    stakeCurrency: {
      coinDenom: "NTRN",
      coinMinimalDenom: "untrn",
      coinDecimals: 6,
      coingeckoId: "neutron",
    },
    bip44: {
      coinType: 118,
    },
    bech32Config: {
      bech32PrefixAccAddr: "neutron",
      bech32PrefixAccPub: "neutronpub",
      bech32PrefixValAddr: "neutronvaloper",
      bech32PrefixValPub: "neutronvaloperpub",
      bech32PrefixConsAddr: "neutronvalcons",
      bech32PrefixConsPub: "neutronvalconspub",
    },
    currencies: [
      {
        coinDenom: "NTRN",
        coinMinimalDenom: "untrn",
        coinDecimals: 6,
        coingeckoId: "neutron",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "NTRN",
        coinMinimalDenom: "untrn",
        coinDecimals: 6,
        coingeckoId: "neutron",
      },
    ],
    coinType: 118,
    gasPriceStep: {
      low: 5.665,
      average: 5.665,
      high: 7,
    },
    features: ["ibc-transfer", "ibc-go", "ibc-pfm"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "stargaze",
    chainType: "cosmos",
    rpc: "https://stargaze-rpc.polkachu.com",
    rpcList: [
      "https://rpc.stargaze.bronbro.io",
      "https://stargaze-rpc.polkachu.com",
      "https://rpc.stargaze-apis.com",
      "https://rpc-stargaze-ia.cosmosia.notional.ventures",
    ],
    rest: "https://rest.stargaze-apis.com",
    nativeCurrency: {
      name: "Stargaze",
      symbol: "STARS",
      decimals: 6,
      icon: "https://raw.githubusercontent.com/cosmos/chain-registry/master/stargaze/images/stars.png",
    },
    swapAmountForGas: "1000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/stars.svg",
    blockExplorerUrls: [
      "https://www.mintscan.io/stargaze/",
      "https://ping.pub/stargaze/",
      "https://atomscan.com/stargaze/",
    ],
    chainId: "stargaze-1",
    networkName: "Stargaze",
    stakeCurrency: {
      coinDenom: "STARS",
      coinMinimalDenom: "ustars",
      coinDecimals: 6,
      coingeckoId: "stargaze",
    },
    walletUrl: "https://wallet.keplr.app/chains/stargaze",
    walletUrlForStaking: "https://wallet.keplr.app/chains/stargaze",
    bip44: {
      coinType: 118,
    },
    bech32Config: {
      bech32PrefixAccAddr: "stars",
      bech32PrefixAccPub: "starspub",
      bech32PrefixValAddr: "starsvaloper",
      bech32PrefixValPub: "starsvaloperpub",
      bech32PrefixConsAddr: "starsvalcons",
      bech32PrefixConsPub: "starsvalconspub",
    },
    currencies: [
      {
        coinDenom: "STARS",
        coinMinimalDenom: "ustars",
        coinDecimals: 6,
        coingeckoId: "stargaze",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "STARS",
        coinMinimalDenom: "ustars",
        coinDecimals: 6,
        coingeckoId: "stargaze",
      },
    ],
    coinType: 118,
    gasPriceStep: {
      low: 0.05,
      average: 0.125,
      high: 0.2,
    },
    features: ["ibc-transfer", "ibc-go"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-50",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "axelarnet",
    chainType: "cosmos",
    rpc: "https://rpc-axelar.imperator.co",
    rpcList: [
      "https://rpc-axelar.imperator.co:443",
      "https://axelar-rpc.quickapi.com:443",
      "https://rpc-axelar.cosmos-spaces.cloud",
    ],
    rest: "https://axelar-lcd.quickapi.com",
    chainId: "axelar-dojo-1",
    networkName: "Axelar",
    nativeCurrency: {
      name: "Axelar",
      symbol: "AXL",
      decimals: 6,
      icon: "https://raw.githubusercontent.com/cosmos/chain-registry/master/axelar/images/axl.png",
    },
    swapAmountForGas: "1000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/axl.svg",
    blockExplorerUrls: [
      "https://www.mintscan.io/axelar/",
      "https://axelar.explorers.guru/",
      "https://atomscan.com/axelar/",
    ],
    stakeCurrency: {
      coinDenom: "AXL",
      coinMinimalDenom: "uaxl",
      coinDecimals: 6,
      coingeckoId: "axelar",
    },
    bech32Config: {
      bech32PrefixAccAddr: "axelar",
      bech32PrefixAccPub: "axelarpub",
      bech32PrefixValAddr: "axelarvaloper",
      bech32PrefixValPub: "axelarvaloperpub",
      bech32PrefixConsAddr: "axelarvalcons",
      bech32PrefixConsPub: "axelarvalconspub",
    },
    bip44: {
      coinType: 118,
    },
    currencies: [
      {
        coinDenom: "AXL",
        coinMinimalDenom: "uaxl",
        coinDecimals: 6,
        coingeckoId: "axelar",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "AXL",
        coinMinimalDenom: "uaxl",
        coinDecimals: 6,
        coingeckoId: "axelar",
      },
    ],
    coinType: 118,
    gasPriceStep: {
      low: 0.05,
      average: 0.125,
      high: 0.2,
    },
    features: ["stargate", "no-legacy-stdTx", "ibc-transfer"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-0",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "noble",
    chainType: "cosmos",
    rpc: "https://rpc.mainnet.noble.strange.love",
    rpcList: [
      "https://rpc.mainnet.noble.strange.love",
      "https://noble-rpc.polkachu.com",
    ],
    rest: "https://noble-api.polkachu.com",
    networkName: "Noble",
    chainId: "noble-1",
    nativeCurrency: {
      name: "noble",
      symbol: "Noble",
      decimals: 6,
      icon: "https://raw.githubusercontent.com/cosmos/chain-registry/master/noble/images/stake.png",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/providers/noble.svg",
    blockExplorerUrls: ["https://mintscan.io/noble/"],
    stakeCurrency: {
      coinDenom: "STAKE",
      coinMinimalDenom: "ustake",
      coinDecimals: 6,
      coingeckoId: "stake",
    },
    bip44: {
      coinType: 118,
    },
    bech32Config: {
      bech32PrefixAccAddr: "noble",
      bech32PrefixAccPub: "noblepub",
      bech32PrefixValAddr: "noblevaloper",
      bech32PrefixValPub: "noblevaloperpub",
      bech32PrefixConsAddr: "noblevalcons",
      bech32PrefixConsPub: "noblevalconspub",
    },
    currencies: [
      {
        coinDenom: "USDC",
        coinMinimalDenom: "uusdc",
        coinDecimals: 6,
        coingeckoId: "usd-coin",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "USDC",
        coinMinimalDenom: "uusdc",
        coinDecimals: 6,
        coingeckoId: "usd-coin",
      },
    ],
    coinType: 118,
    gasPriceStep: {
      low: 0,
      average: 0,
      high: 0.025,
    },
    features: ["ibc-transfer", "ibc-go", "ibc-pfm"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "",
    estimatedExpressRouteDuration: 20,
    estimatedRouteDuration: 180,
  },
  {
    chainName: "umee",
    chainType: "cosmos",
    rpc: "https://umee-rpc.polkachu.com",
    rpcList: [
      "https://umee-rpc.polkachu.com",
      "https://rpc-umee-ia.cosmosia.notional.ventures/",
      "http://umee.rpc.m.stavr.tech:10457",
    ],
    rest: "https://umee-api.polkachu.com",
    nativeCurrency: {
      name: "Umee",
      symbol: "UMEE",
      decimals: 6,
      icon: "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/umee.svg",
    },
    swapAmountForGas: "200000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/umee.svg",
    blockExplorerUrls: [
      "https://www.mintscan.io/umee/",
      "https://ping.pub/umee/",
      "https://umee.explorers.guru/",
      "https://atomscan.com/umee/",
    ],
    chainId: "umee-1",
    networkName: "Umee",
    bip44: {
      coinType: 118,
    },
    bech32Config: {
      bech32PrefixAccAddr: "umee",
      bech32PrefixAccPub: "umeepub",
      bech32PrefixValAddr: "umeevaloper",
      bech32PrefixValPub: "umeevaloperpub",
      bech32PrefixConsAddr: "umeevalcons",
      bech32PrefixConsPub: "umeevalconspub",
    },
    currencies: [
      {
        coinDenom: "UMEE",
        coinMinimalDenom: "uumee",
        coinDecimals: 6,
        coingeckoId: "pool:uumee",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "UMEE",
        coinMinimalDenom: "uumee",
        coinDecimals: 6,
        coingeckoId: "pool:uumee",
      },
    ],
    stakeCurrency: {
      coinDenom: "UMEE",
      coinMinimalDenom: "uumee",
      coinDecimals: 6,
      coingeckoId: "pool:uumee",
    },
    coinType: 118,
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-33",
    features: ["stargate", "ibc-transfer", "no-legacy-stdTx", "ibc-go"],
    gasPriceStep: {
      low: 0.05,
      average: 0.125,
      high: 0.2,
    },
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "secret-snip",
    chainType: "cosmos",
    rpc: "https://secret-rpc-sl.norm.io",
    rpcList: ["https://secret-rpc-sl.norm.io", "https://1rpc.io/scrt-rpc"],
    rest: "https://secret-rest-sl.norm.io",
    networkName: "Secret",
    chainId: "secret-4",
    nativeCurrency: {
      name: "Secret",
      symbol: "SCRT",
      decimals: 6,
      icon: "https://s2.coinmarketcap.com/static/img/coins/64x64/5604.png",
    },
    swapAmountForGas: "1000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/scrt.svg",
    blockExplorerUrls: ["https://www.mintscan.io/secret/"],
    bip44: {
      coinType: 529,
    },
    bech32Config: {
      bech32PrefixAccAddr: "secret",
      bech32PrefixAccPub: "secretpub",
      bech32PrefixValAddr: "secretvaloper",
      bech32PrefixValPub: "secretvaloperpub",
      bech32PrefixConsAddr: "secretvalcons",
      bech32PrefixConsPub: "secretvalconspub",
    },
    feeCurrencies: [
      {
        coinDenom: "SCRT",
        coinMinimalDenom: "uscrt",
        coinDecimals: 6,
        coingeckoId: "secret",
      },
    ],
    stakeCurrency: {
      coinDenom: "SCRT",
      coinMinimalDenom: "uscrt",
      coinDecimals: 6,
      coingeckoId: "secret",
    },
    currencies: [
      {
        coinDenom: "SCRT",
        coinMinimalDenom: "uscrt",
        coinDecimals: 6,
        coingeckoId: "secret",
      },
    ],
    gasPriceStep: {
      low: 0.05,
      average: 0.125,
      high: 0.2,
    },
    coinType: 529,
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-20",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "persistence",
    chainType: "cosmos",
    rpc: "https://persistence-rpc.polkachu.com",
    rpcList: [
      "https://persistence-rpc.polkachu.com",
      "https://rpc.core.persistence.one",
      "https://rpc-persistent-ia.cosmosia.notional.ventures/",
    ],
    rest: "https://persistence-api.polkachu.com",
    nativeCurrency: {
      name: "Persistence",
      symbol: "XPRT",
      decimals: 6,
      icon: "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/xprt.svg",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/xprt.svg",
    blockExplorerUrls: [
      "https://www.mintscan.io/persistence/",
      "https://ping.pub/persistence/",
    ],
    chainId: "core-1",
    networkName: "Persistence",
    stakeCurrency: {
      coinDenom: "XPRT",
      coinMinimalDenom: "uxprt",
      coinDecimals: 6,
      coingeckoId: "persistence",
    },
    bech32Config: {
      bech32PrefixAccAddr: "persistence",
      bech32PrefixAccPub: "persistencepub",
      bech32PrefixValAddr: "persistencevaloper",
      bech32PrefixValPub: "persistencevaloperpub",
      bech32PrefixConsAddr: "persistencevalcons",
      bech32PrefixConsPub: "persistencevalconspub",
    },
    bip44: {
      coinType: 118,
    },
    currencies: [
      {
        coinDenom: "XPRT",
        coinMinimalDenom: "uxprt",
        coinDecimals: 6,
        coingeckoId: "persistence",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "XPRT",
        coinMinimalDenom: "uxprt",
        coinDecimals: 6,
        coingeckoId: "persistence",
      },
    ],
    coinType: 118,
    gasPriceStep: {
      low: 0.05,
      average: 0.125,
      high: 0.2,
    },
    features: ["stargate", "no-legacy-stdTx", "ibc-transfer"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-51",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "injective",
    chainType: "cosmos",
    rpc: "https://rpc-injective.keplr.app",
    rpcList: [
      "https://rpc-injective.keplr.app",
      "https://rpc-injective.goldenratiostaking.net",
      "https://injective-rpc.lavenderfive.com:443",
    ],
    rest: "https://lcd.injective.network",
    networkName: "Injective",
    chainId: "injective-1",
    nativeCurrency: {
      name: "Injective",
      symbol: "INJ",
      decimals: 6,
      icon: "https://s2.coinmarketcap.com/static/img/coins/64x64/7226.png",
    },
    swapAmountForGas: "1000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/inj.svg",
    blockExplorerUrls: ["https://www.mintscan.io/injective/"],
    stakeCurrency: {
      coinDenom: "INJ",
      coinMinimalDenom: "inj",
      coinDecimals: 18,
      coingeckoId: "injective-protocol",
    },
    walletUrl: "https://hub.injective.network/",
    walletUrlForStaking: "https://hub.injective.network/",
    bip44: {
      coinType: 60,
    },
    bech32Config: {
      bech32PrefixAccAddr: "inj",
      bech32PrefixAccPub: "injpub",
      bech32PrefixValAddr: "injvaloper",
      bech32PrefixValPub: "injvaloperpub",
      bech32PrefixConsAddr: "injvalcons",
      bech32PrefixConsPub: "injvalconspub",
    },
    currencies: [
      {
        coinDenom: "INJ",
        coinMinimalDenom: "inj",
        coinDecimals: 18,
        coingeckoId: "injective-protocol",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "INJ",
        coinMinimalDenom: "inj",
        coinDecimals: 18,
        coingeckoId: "injective-protocol",
      },
    ],
    gasPriceStep: {
      low: 5000000000,
      average: 25000000000,
      high: 40000000000,
    },
    coinType: 60,
    features: ["ibc-transfer", "ibc-go"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-84",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "crescent",
    chainType: "cosmos",
    rpc: "https://crescent-rpc.polkachu.com",
    rpcList: [
      "https://mainnet.crescent.network:26657",
      "https://crescent-rpc.polkachu.com",
      "https://rpc-crescent.pupmos.network",
    ],
    rest: "https://mainnet.crescent.network:1317",
    networkName: "Crescent",
    chainId: "crescent-1",
    nativeCurrency: {
      name: "Crescent",
      symbol: "CRE",
      decimals: 6,
      icon: "https://static-resources.crescent.network/CRE.png",
    },
    swapAmountForGas: "200000",
    chainIconURI: "https://static-resources.crescent.network/CRE.png",
    blockExplorerUrls: ["https://www.mintscan.io/crescent/"],
    bip44: {
      coinType: 118,
    },
    bech32Config: {
      bech32PrefixAccAddr: "cre",
      bech32PrefixAccPub: "crepub",
      bech32PrefixValAddr: "crevaloper",
      bech32PrefixValPub: "crevaloperpub",
      bech32PrefixConsAddr: "crevalcons",
      bech32PrefixConsPub: "crevalconspub",
    },
    currencies: [
      {
        coinDenom: "CRE",
        coinMinimalDenom: "ucre",
        coinDecimals: 6,
        coingeckoId: "crescent",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "CRE",
        coinMinimalDenom: "ucre",
        coinDecimals: 6,
        coingeckoId: "crescent",
      },
    ],
    stakeCurrency: {
      coinDenom: "CRE",
      coinMinimalDenom: "ucre",
      coinDecimals: 6,
      coingeckoId: "crescent",
    },
    coinType: 118,
    gasPriceStep: {
      low: 1,
      average: 1,
      high: 1,
    },
    features: ["stargate", "ibc-transfer", "no-legacy-stdTx"],
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-4",
  },
  {
    chainName: "terra-2",
    chainType: "cosmos",
    rpc: "https://terra-rpc.polkachu.com",
    rpcList: [
      "https://terra-rpc.polkachu.com",
      "https://terra-rpc.stakely.io:443/",
      "https://phoenix-rpc.terra.dev:443",
    ],
    rest: "https://phoenix-lcd.terra.dev",
    networkName: "Terra",
    chainId: "phoenix-1",
    nativeCurrency: {
      name: "Luna",
      symbol: "LUNA",
      decimals: 6,
      icon: "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/1c761075a4ae672089c2b1cf25739c6368e97bb7/public/images/chains/terra-2.svg",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/axelarnetwork/axelar-docs/1c761075a4ae672089c2b1cf25739c6368e97bb7/public/images/chains/terra-2.svg",
    blockExplorerUrls: ["http://finder.terra.money/mainnet/"],
    stakeCurrency: {
      coinDenom: "LUNA",
      coinMinimalDenom: "uluna",
      coinDecimals: 6,
      coingeckoId: "terra-luna-2",
    },
    bip44: {
      coinType: 330,
    },
    bech32Config: {
      bech32PrefixAccAddr: "terra",
      bech32PrefixAccPub: "terrapub",
      bech32PrefixValAddr: "terravaloper",
      bech32PrefixValPub: "terravaloperpub",
      bech32PrefixConsAddr: "terravalcons",
      bech32PrefixConsPub: "terravalconspub",
    },
    currencies: [
      {
        coinDenom: "LUNA",
        coinMinimalDenom: "uluna",
        coinDecimals: 6,
        coingeckoId: "terra-luna-2",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "LUNA",
        coinMinimalDenom: "uluna",
        coinDecimals: 6,
        coingeckoId: "terra-luna-2",
      },
    ],
    coinType: 330,
    gasPriceStep: {
      low: 5.665,
      average: 5.665,
      high: 7,
    },
    features: ["stargate", "ibc-transfer", "no-legacy-stdTx", "ibc-pfm"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-6",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "juno",
    chainType: "cosmos",
    rpc: "https://juno-rpc.polkachu.com",
    rpcList: [
      "https://rpc-juno.whispernode.com:443",
      "http://juno.rpc.m.stavr.tech:1067",
      "https://juno-rpc.polkachu.com",
    ],
    rest: "https://lcd-juno.itastakers.com",
    networkName: "Juno",
    chainId: "juno-1",
    nativeCurrency: {
      name: "Juno",
      symbol: "JUNO",
      decimals: 6,
      icon: "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/juno.svg",
    },
    swapAmountForGas: "1000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/juno.svg",
    blockExplorerUrls: ["https://www.mintscan.io/juno/"],
    bip44: {
      coinType: 118,
    },
    bech32Config: {
      bech32PrefixAccAddr: "juno",
      bech32PrefixAccPub: "junopub",
      bech32PrefixValAddr: "junovaloper",
      bech32PrefixValPub: "junovaloperpub",
      bech32PrefixConsAddr: "junovalcons",
      bech32PrefixConsPub: "junovalconspub",
    },
    currencies: [
      {
        coinDenom: "JUNO",
        coinMinimalDenom: "ujuno",
        coinDecimals: 6,
        coingeckoId: "juno-network",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "JUNO",
        coinMinimalDenom: "ujuno",
        coinDecimals: 6,
        coingeckoId: "juno-network",
      },
    ],
    stakeCurrency: {
      coinDenom: "JUNO",
      coinMinimalDenom: "ujuno",
      coinDecimals: 6,
      coingeckoId: "juno-network",
    },
    gasPriceStep: {
      low: 5000000000,
      average: 25000000000,
      high: 40000000000,
    },
    coinType: 118,
    features: ["ibc-pfm", "cosmwasm"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-71",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "evmos",
    chainType: "cosmos",
    rpc: "https://evmos-rpc.polkachu.com",
    rpcList: [
      "https://evmos-rpc.polkachu.com",
      "https://evmos-rpc.publicnode.com",
      "https://rpc.evmos.nodestake.top",
    ],
    rest: "https://evmos-rest.publicnode.com",
    nativeCurrency: {
      name: "Evmos",
      symbol: "EVMOS",
      decimals: 6,
      icon: "https://raw.githubusercontent.com/cosmos/chain-registry/master/evmos/images/evmos.png",
    },
    swapAmountForGas: "1000000",
    chainIconURI:
      "https://raw.githubusercontent.com/cosmos/chain-registry/master/evmos/images/evmos.png",
    networkName: "Evmos",
    chainId: "evmos_9001-2",
    blockExplorerUrls: [
      "https://www.mintscan.io/evmos/",
      "https://evmos.bigdipper.live/",
      "https://evm.evmos.org/",
      "https://ping.pub/evmos/",
      "https://evmos.explorers.guru/",
      "https://atomscan.com/evmos/",
      "https://evmos.tcnetwork.io/",
    ],
    stakeCurrency: {
      coinDenom: "EVMOS",
      coinMinimalDenom: "aevmos",
      coinDecimals: 18,
      coingeckoId: "evmos",
    },
    walletUrl: "https://wallet.keplr.app/chains/evmos",
    walletUrlForStaking: "https://wallet.keplr.app/chains/evmos",
    bip44: {
      coinType: 60,
    },
    bech32Config: {
      bech32PrefixAccAddr: "evmos",
      bech32PrefixAccPub: "evmospub",
      bech32PrefixValAddr: "evmosvaloper",
      bech32PrefixValPub: "evmosvaloperpub",
      bech32PrefixConsAddr: "evmosvalcons",
      bech32PrefixConsPub: "evmosvalconspub",
    },
    currencies: [
      {
        coinDenom: "EVMOS",
        coinMinimalDenom: "aevmos",
        coinDecimals: 18,
        coingeckoId: "evmos",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "EVMOS",
        coinMinimalDenom: "aevmos",
        coinDecimals: 18,
        coingeckoId: "evmos",
      },
    ],
    gasPriceStep: {
      low: 25000000000,
      average: 25000000000,
      high: 224000000000000000,
    },
    coinType: 60,
    features: ["ibc-transfer", "ibc-go", "eth-address-gen", "eth-key-sign"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-21",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "dymension",
    chainType: "cosmos",
    rpc: "https://dymension-rpc.polkachu.com",
    rpcList: [
      "https://dymension-rpc.polkachu.com",
      "https://rpc.dymension.nodestake.org",
      "https://dymension-rpc.lavenderfive.com:443",
      "https://dymension-rpc.kynraze.com",
    ],
    rest: "https://api.dymension.nodestake.org",
    nativeCurrency: {
      name: "dymension",
      symbol: "DYM",
      decimals: 18,
      icon: "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/dym.svg",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/dym.svg",
    blockExplorerUrls: ["https://explorer.nodestake.org/dymension/"],
    chainId: "dymension_1100-1",
    networkName: "Dymension",
    stakeCurrency: {
      coinDenom: "DYM",
      coinMinimalDenom: "adym",
      coinDecimals: 18,
      coingeckoId: "",
    },
    bech32Config: {
      bech32PrefixAccAddr: "dym",
      bech32PrefixAccPub: "dympub",
      bech32PrefixValAddr: "dymvaloper",
      bech32PrefixValPub: "dymvaloperpub",
      bech32PrefixConsAddr: "dymvalcons",
      bech32PrefixConsPub: "dymvalconspub",
    },
    bip44: {
      coinType: 60,
    },
    currencies: [
      {
        coinDenom: "DYM",
        coinMinimalDenom: "adym",
        coinDecimals: 18,
        coingeckoId: "",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "DYM",
        coinMinimalDenom: "adym",
        coinDecimals: 18,
        coingeckoId: "",
      },
    ],
    coinType: 60,
    gasPriceStep: {
      low: 0.05,
      average: 0.125,
      high: 0.2,
    },
    features: ["stargate", "no-legacy-stdTx", "ibc-transfer", "ibc-pfm"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-138",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "sei",
    chainType: "cosmos",
    rpc: "https://rpc.sei-apis.com",
    rpcList: [
      "https://rpc.sei-apis.com",
      "https://sei-rpc.lavenderfive.com:443",
      "https://sei-rpc.polkachu.com/",
      "https://rpc-sei.whispernode.com:443",
    ],
    rest: "https://rest.sei-apis.com",
    nativeCurrency: {
      name: "SEI",
      symbol: "SEI",
      decimals: 6,
      icon: "https://docs.axelar.dev/images/chains/sei.svg",
    },
    swapAmountForGas: "1000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/sei.svg",
    networkName: "Sei",
    chainId: "pacific-1",
    blockExplorerUrls: ["https://www.mintscan.io/sei/"],
    stakeCurrency: {
      coinDenom: "SEI",
      coinMinimalDenom: "usei",
      coinDecimals: 6,
      coingeckoId: "sei-network",
    },
    walletUrl: "https://wallet.keplr.app/chains/sei",
    walletUrlForStaking: "https://wallet.keplr.app/chains/sei",
    bip44: {
      coinType: 118,
    },
    bech32Config: {
      bech32PrefixAccAddr: "sei",
      bech32PrefixAccPub: "seipub",
      bech32PrefixValAddr: "seivaloper",
      bech32PrefixValPub: "seivaloperpub",
      bech32PrefixConsAddr: "seivalcons",
      bech32PrefixConsPub: "seivalconspub",
    },
    currencies: [
      {
        coinDenom: "SEI",
        coinMinimalDenom: "usei",
        coinDecimals: 6,
        coingeckoId: "sei-network",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "SEI",
        coinMinimalDenom: "usei",
        coinDecimals: 6,
        coingeckoId: "sei-network",
      },
    ],
    gasPriceStep: {
      low: 25000000000,
      average: 25000000000,
      high: 40000000000,
    },
    coinType: 118,
    features: ["ibc-transfer", "ibc-go"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "carbon",
    chainType: "cosmos",
    rpc: "https://carbon-rpc.lavenderfive.com",
    rpcList: [
      "https://tm-api.carbon.network",
      "https://rpc.carbon.blockhunters.org",
    ],
    rest: "https://api.carbon.network",
    nativeCurrency: {
      name: "swth",
      symbol: "SWTH",
      decimals: 6,
      icon: "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/swth.svg",
    },
    swapAmountForGas: "1000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/swth.svg",
    blockExplorerUrls: ["https://scan.carbon.network/"],
    chainId: "carbon-1",
    networkName: "Carbon",
    stakeCurrency: {
      coinDenom: "SWTH",
      coinMinimalDenom: "uswth",
      coinDecimals: 6,
      coingeckoId: "switcheo",
    },
    bip44: {
      coinType: 118,
    },
    bech32Config: {
      bech32PrefixAccAddr: "swth",
      bech32PrefixAccPub: "swthpub",
      bech32PrefixValAddr: "swthvaloper",
      bech32PrefixValPub: "swthvaloperpub",
      bech32PrefixConsAddr: "swthvalcons",
      bech32PrefixConsPub: "swthvalconspub",
    },
    currencies: [
      {
        coinDenom: "SWTH",
        coinMinimalDenom: "uswth",
        coinDecimals: 6,
        coingeckoId: "switcheo",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "SWTH",
        coinMinimalDenom: "uswth",
        coinDecimals: 6,
        coingeckoId: "switcheo",
      },
    ],
    coinType: 118,
    features: ["ibc-transfer", "ibc-go"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-7",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "regen",
    chainType: "cosmos",
    rpc: "https://rpc-regen.ecostake.com",
    rpcList: [
      "https://rpc-regen.ecostake.com",
      "http://public-rpc.regen.vitwit.com:26657",
      "https://rpc-regen-ia.cosmosia.notional.ventures/",
    ],
    rest: "https://rest-regen.ecostake.com",
    nativeCurrency: {
      name: "Regen Network",
      symbol: "REGEN",
      decimals: 6,
      icon: "https://raw.githubusercontent.com/cosmos/chain-registry/master/regen/images/regen.png",
    },
    swapAmountForGas: "1000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/regen.svg",
    blockExplorerUrls: [
      "https://www.mintscan.io/regen/",
      "https://ping.pub/regen/",
      "https://regen.bigdipper.live/",
      "https://atomscan.com/regen-network/",
    ],
    chainId: "regen-1",
    networkName: "Regen",
    stakeCurrency: {
      coinDenom: "REGEN",
      coinMinimalDenom: "uregen",
      coinDecimals: 6,
      coingeckoId: "regen",
    },
    walletUrl: "https://wallet.keplr.app/chains/regen",
    walletUrlForStaking: "https://wallet.keplr.app/chains/regen",
    bip44: {
      coinType: 118,
    },
    bech32Config: {
      bech32PrefixAccAddr: "regen",
      bech32PrefixAccPub: "regenpub",
      bech32PrefixValAddr: "regenvaloper",
      bech32PrefixValPub: "regenvaloperpub",
      bech32PrefixConsAddr: "regenvalcons",
      bech32PrefixConsPub: "regenvalconspub",
    },
    currencies: [
      {
        coinDenom: "REGEN",
        coinMinimalDenom: "uregen",
        coinDecimals: 6,
        coingeckoId: "regen",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "REGEN",
        coinMinimalDenom: "uregen",
        coinDecimals: 6,
        coingeckoId: "regen",
      },
    ],
    gasPriceStep: {
      low: 0.015,
      average: 0.025,
      high: 0.04,
    },
    coinType: 118,
    features: ["ibc-go", "ibc-transfer"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-48",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "agoric",
    chainType: "cosmos",
    rpc: "https://main.rpc.agoric.net",
    rpcList: [
      "https://rpc.agoric.nodestake.top",
      "https://agoric.rpc.kjnodes.com",
      "https://rpc-agoric-01.stakeflow.io",
    ],
    rest: "https://main.api.agoric.net",
    networkName: "Agoric",
    chainId: "agoric-3",
    nativeCurrency: {
      name: "Agoric",
      symbol: "BLD",
      decimals: 6,
      icon: "https://raw.githubusercontent.com/cosmos/chain-registry/master/agoric/images/bld.png",
    },
    swapAmountForGas: "1000000",
    chainIconURI: "https://axelarscan.io/logos/chains/agoric.svg",
    blockExplorerUrls: [
      "https://agoric.bigdipper.live/",
      "https://agoric.explorers.guru/",
      "https://atomscan.com/agoric/",
    ],
    bip44: {
      coinType: 564,
    },
    bech32Config: {
      bech32PrefixAccAddr: "agoric",
      bech32PrefixAccPub: "agoricpub",
      bech32PrefixValAddr: "agoricvaloper",
      bech32PrefixValPub: "agoricvaloperpub",
      bech32PrefixConsAddr: "agoricvalcons",
      bech32PrefixConsPub: "agoricvalconspub",
    },
    currencies: [
      {
        coinDenom: "BLD",
        coinMinimalDenom: "ubld",
        coinDecimals: 6,
        coingeckoId: "agoric",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "BLD",
        coinMinimalDenom: "ubld",
        coinDecimals: 6,
        coingeckoId: "agoric",
      },
    ],
    stakeCurrency: {
      coinDenom: "BLD",
      coinMinimalDenom: "ubld",
      coinDecimals: 6,
      coingeckoId: "agoric",
    },
    coinType: 564,
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-9",
    features: ["stargate", "ibc-transfer", "no-legacy-stdTx", "ibc-go"],
    gasPriceStep: {
      low: 0.1,
      average: 0.2,
      high: 0.25,
    },
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "comdex",
    chainType: "cosmos",
    rpc: "https://rpc.comdex.one",
    rpcList: [
      "https://rpc.comdex.one",
      "https://comdex-rpc.polkachu.com",
      "https://rpc-comdex.cosmos-spaces.cloud",
    ],
    rest: "https://rest.comdex.one",
    chainId: "comdex-1",
    networkName: "Comdex",
    nativeCurrency: {
      name: "Comdex",
      symbol: "CMDX",
      decimals: 6,
      icon: "https://raw.githubusercontent.com/cosmos/chain-registry/master/comdex/images/cmdx.png",
    },
    swapAmountForGas: "1000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/cmdx.svg",
    blockExplorerUrls: [
      "https://www.mintscan.io/comdex/",
      "https://comdex.aneka.io/",
      "https://ping.pub/comdex/",
      "https://atomscan.com/comdex/",
    ],
    stakeCurrency: {
      coinDenom: "CMDX",
      coinMinimalDenom: "ucmdx",
      coinDecimals: 6,
      coingeckoId: "cmdx",
    },
    bech32Config: {
      bech32PrefixAccAddr: "comdex",
      bech32PrefixAccPub: "comdexpub",
      bech32PrefixValAddr: "comdexvaloper",
      bech32PrefixValPub: "comdexvaloperpub",
      bech32PrefixConsAddr: "comdexvalcons",
      bech32PrefixConsPub: "comdexvalconspub",
    },
    bip44: {
      coinType: 118,
    },
    currencies: [
      {
        coinDenom: "CMDX",
        coinMinimalDenom: "ucmdx",
        coinDecimals: 6,
        coingeckoId: "comdex",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "CMDX",
        coinMinimalDenom: "ucmdx",
        coinDecimals: 6,
        coingeckoId: "comdex",
      },
    ],
    gasPriceStep: {
      low: 0.01,
      average: 0.03,
      high: 0.05,
    },
    coinType: 118,
    features: ["stargate", "no-legacy-stdTx", "ibc-transfer"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-34",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "archway",
    chainType: "cosmos",
    rpc: "https://rpc.mainnet.archway.io",
    rpcList: [
      "https://rpc.mainnet.archway.io",
      "https://rpc-archway.cosmos-spaces.cloud",
      "https://archway-mainnet-archive.allthatnode.com:26657",
    ],
    rest: "https://api.mainnet.archway.io",
    nativeCurrency: {
      name: "Archway",
      symbol: "ARCH",
      decimals: 18,
      icon: "https://s2.coinmarketcap.com/static/img/coins/64x64/27358.png",
    },
    swapAmountForGas: "1000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/arch.svg",
    blockExplorerUrls: [
      "https://mintscan.io/archway/",
      "https://archway.explorers.guru/",
    ],
    chainId: "archway-1",
    networkName: "Archway",
    stakeCurrency: {
      coinDenom: "ARCH",
      coinMinimalDenom: "aarch",
      coinDecimals: 18,
      coingeckoId: "archway",
    },
    bech32Config: {
      bech32PrefixAccAddr: "archway",
      bech32PrefixAccPub: "archwaypub",
      bech32PrefixValAddr: "archwayvaloper",
      bech32PrefixValPub: "archwayvaloperpub",
      bech32PrefixConsAddr: "archwayvalcons",
      bech32PrefixConsPub: "archwayvalconspub",
    },
    bip44: {
      coinType: 118,
    },
    currencies: [
      {
        coinDenom: "ARCH",
        coinMinimalDenom: "aarch",
        coinDecimals: 18,
        coingeckoId: "archway",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "ARCH",
        coinMinimalDenom: "aarch",
        coinDecimals: 18,
        coingeckoId: "archway",
      },
    ],
    coinType: 118,
    gasPriceStep: {
      low: 0.05,
      average: 0.125,
      high: 0.2,
    },
    features: ["stargate", "no-legacy-stdTx", "ibc-transfer"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-13",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "migaloo",
    chainType: "cosmos",
    rpc: "https://migaloo-rpc.lavenderfive.com",
    rpcList: [
      "https://migaloo-rpc.lavenderfive.com",
      "https://rpc-migaloo.cosmos-spaces.cloud",
      "https://migaloo-rpc.kleomedes.network:443",
    ],
    rest: "https://migaloo-api.lavenderfive.com",
    nativeCurrency: {
      name: "Whale",
      symbol: "WHALE",
      decimals: 6,
      icon: "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/whale.svg",
    },
    swapAmountForGas: "1000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/migaloo.svg",
    blockExplorerUrls: [
      "https://atomscan.com/migaloo/",
      "https://explorer.silknodes.io/migaloo/",
    ],
    chainId: "migaloo-1",
    networkName: "Migaloo",
    stakeCurrency: {
      coinDenom: "WHALE",
      coinMinimalDenom: "uwhale",
      coinDecimals: 6,
      coingeckoId: "white-whale",
    },
    bech32Config: {
      bech32PrefixAccAddr: "migaloo",
      bech32PrefixAccPub: "migaloopub",
      bech32PrefixValAddr: "migaloovaloper",
      bech32PrefixValPub: "migaloovaloperpub",
      bech32PrefixConsAddr: "migaloovalcons",
      bech32PrefixConsPub: "migaloovalconspub",
    },
    bip44: {
      coinType: 118,
    },
    currencies: [
      {
        coinDenom: "WHALE",
        coinMinimalDenom: "uwhale",
        coinDecimals: 6,
        coingeckoId: "white-whale",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "WHALE",
        coinMinimalDenom: "uwhale",
        coinDecimals: 6,
        coingeckoId: "white-whale",
      },
    ],
    coinType: 118,
    gasPriceStep: {
      low: 0.05,
      average: 0.125,
      high: 0.2,
    },
    features: ["stargate", "no-legacy-stdTx", "ibc-transfer"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "terra",
    chainType: "cosmos",
    rpc: "https://rpc-terra-ia.cosmosia.notional.ventures/",
    rpcList: [
      "https://rpc-terra-ia.cosmosia.notional.ventures/",
      "https://rpc.terrarebels.net",
      "https://terra-classic-rpc.publicnode.com",
    ],
    rest: "https://api-terra-ia.cosmosia.notional.ventures",
    nativeCurrency: {
      name: "Luna Classic",
      symbol: "LUNC",
      decimals: 6,
      icon: "https://s2.coinmarketcap.com/static/img/coins/64x64/4172.png",
    },
    swapAmountForGas: "2000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/lunc.svg",
    blockExplorerUrls: [
      "https://finder.terra.money/classic/",
      "https://finder.terrarebels.net/classic/",
    ],
    chainId: "columbus-5",
    networkName: "Terra Classic",
    stakeCurrency: {
      coinDenom: "LUNA",
      coinMinimalDenom: "uluna",
      coinDecimals: 6,
      coingeckoId: "terra-luna",
    },
    bech32Config: {
      bech32PrefixAccAddr: "terra",
      bech32PrefixAccPub: "terrapub",
      bech32PrefixValAddr: "terravaloper",
      bech32PrefixValPub: "terravaloperpub",
      bech32PrefixConsAddr: "terravalcons",
      bech32PrefixConsPub: "terravalconspub",
    },
    bip44: {
      coinType: 330,
    },
    currencies: [
      {
        coinDenom: "LUNA",
        coinMinimalDenom: "uluna",
        coinDecimals: 6,
        coingeckoId: "terra-luna",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "LUNA",
        coinMinimalDenom: "uluna",
        coinDecimals: 6,
        coingeckoId: "terra-luna",
      },
    ],
    coinType: 330,
    gasPriceStep: {
      low: 0.05,
      average: 0.125,
      high: 0.2,
    },
    features: ["stargate", "no-legacy-stdTx", "ibc-transfer"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-19",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "assetmantle",
    chainType: "cosmos",
    rpc: "https://rpc.assetmantle.one",
    rpcList: [
      "https://rpc.assetmantle.one",
      "https://rpc-assetmantle.blockpower.capital",
      "https://rpc-assetmantle.ecostake.com",
    ],
    rest: "https://rest.assetmantle.one",
    chainId: "mantle-1",
    networkName: "AssetMantle",
    nativeCurrency: {
      name: "AssetMantle",
      symbol: "MNTL",
      decimals: 6,
      icon: "https://s2.coinmarketcap.com/static/img/coins/64x64/19686.png",
    },
    swapAmountForGas: "1000000",
    chainIconURI:
      "https://s2.coinmarketcap.com/static/img/coins/64x64/19686.png",
    blockExplorerUrls: [
      "https://www.mintscan.io/asset-mantle/",
      "https://explorer.postcapitalist.io/AssetMantle/",
      "https://explorer.assetmantle.one/",
      "https://assetmantle.explorers.guru/",
      "https://atomscan.com/assetmantle/",
    ],
    stakeCurrency: {
      coinDenom: "MNTL",
      coinMinimalDenom: "umntl",
      coinDecimals: 6,
      coingeckoId: "assetmantle",
    },
    bech32Config: {
      bech32PrefixAccAddr: "mantle",
      bech32PrefixAccPub: "mantlepub",
      bech32PrefixValAddr: "mantlevaloper",
      bech32PrefixValPub: "mantlevaloperpub",
      bech32PrefixConsAddr: "mantlevalcons",
      bech32PrefixConsPub: "mantlevalconspub",
    },
    bip44: {
      coinType: 118,
    },
    currencies: [
      {
        coinDenom: "MNTL",
        coinMinimalDenom: "umntl",
        coinDecimals: 6,
        coingeckoId: "assetmantle",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "MNTL",
        coinMinimalDenom: "umntl",
        coinDecimals: 6,
        coingeckoId: "assetmantle",
      },
    ],
    coinType: 118,
    gasPriceStep: {
      low: 0.05,
      average: 0.125,
      high: 0.2,
    },
    features: ["stargate", "no-legacy-stdTx", "ibc-transfer"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "channel-10",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
  {
    chainName: "nolus",
    chainType: "cosmos",
    rpc: "https://pirin-cl.nolus.network:26657",
    rpcList: [
      "https://pirin-cl.nolus.network:26657",
      "https://nolus-rpc.lavenderfive.com:443",
      "https://nolus-rpc.sphincs.plus",
    ],
    rest: "https://pirin-cl.nolus.network:1317",
    nativeCurrency: {
      name: "nolus",
      symbol: "NLS",
      decimals: 18,
      icon: "https://s2.coinmarketcap.com/static/img/coins/64x64/18156.png",
    },
    swapAmountForGas: "1000000",
    chainIconURI:
      "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/nls.svg",
    blockExplorerUrls: ["https://ping.pub/nolus/"],
    chainId: "pirin-1",
    networkName: "Nolus",
    stakeCurrency: {
      coinDenom: "unls",
      coinMinimalDenom: "unls",
      coinDecimals: 6,
      coingeckoId: "nolus",
    },
    bech32Config: {
      bech32PrefixAccAddr: "nolus",
      bech32PrefixAccPub: "noluspub",
      bech32PrefixValAddr: "nolusvaloper",
      bech32PrefixValPub: "nolusvaloperpub",
      bech32PrefixConsAddr: "nolusvalcons",
      bech32PrefixConsPub: "nolusvalconspub",
    },
    bip44: {
      coinType: 118,
    },
    currencies: [
      {
        coinDenom: "unls",
        coinMinimalDenom: "unls",
        coinDecimals: 6,
        coingeckoId: "nolus",
      },
    ],
    feeCurrencies: [
      {
        coinDenom: "unls",
        coinMinimalDenom: "unls",
        coinDecimals: 6,
        coingeckoId: "nolus",
      },
    ],
    coinType: 118,
    gasPriceStep: {
      low: 0.1,
      average: 0.25,
      high: 0.4,
    },
    features: ["stargate", "no-legacy-stdTx", "ibc-transfer"],
    axelarContracts: {
      gateway: "",
    },
    chainToAxelarChannelId: "",
    estimatedRouteDuration: 60,
    estimatedExpressRouteDuration: 20,
  },
];

export const ETHtoAVAX_EthereumToAvalanche_Route = {
  route: {
    estimate: {
      fromAmount: "1000000000000000",
      sendAmount: "1505469",
      toAmount: "54602787339179287",
      toAmountMin: "54056759465787494",
      fromAmountUSD: "3.4995",
      route: {
        fromChain: [
          {
            type: "SWAP",
            dex: {
              chainName: "Ethereum",
              dexName: "Pancakeswap_v3",
              swapRouter: "0x1b81D678ffb9C0263b24A97847620C99d213eB14",
              quoter: "0xB048Bbc1Ee6b733FFfCFb9e9CeF7375518e25997",
              isCrypto: true,
              isStable: false,
            },
            target: "0x1b81D678ffb9C0263b24A97847620C99d213eB14",
            path: [
              "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
              "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48",
            ],
            poolFees: [100],
            swapType: "crypto",
            squidCallType: 0,
            fromToken: {
              chainId: 1,
              address: "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
              name: "Wrapped ETH",
              symbol: "WETH",
              decimals: 18,
              logoURI:
                "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
              coingeckoId: "weth",
              commonKey: "weth-wei",
            },
            toToken: {
              name: "USDCoin",
              address: "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48",
              symbol: "USDC",
              decimals: 6,
              chainId: 1,
              logoURI:
                "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
              coingeckoId: "usd-coin",
              commonKey: "uusdc",
            },
            fromAmount: "1000000000000000",
            toAmount: "3505469",
            toAmountMin: "3498411",
            exchangeRate: "3505.469",
            priceImpact: "-0.0019950652992283",
            isFrom: true,
            dynamicSlippage: 0.201341386156495,
          },
        ],
        toChain: [
          {
            type: "SWAP",
            dex: {
              chainName: "Avalanche",
              dexName: "Curve_v2",
              swapRouter: "0xBff334F8D5912AC5c4f2c590A2396d1C5d990123",
              isStable: true,
              isCrypto: true,
            },
            target: "0xBff334F8D5912AC5c4f2c590A2396d1C5d990123",
            path: [
              "0xfaB550568C688d5D8A52C7d794cb93Edc26eC0eC",
              "0xB97EF9Ef8734C71904D8002F8b6Bc66Dd9c48a6E",
            ],
            swapType: "stable",
            squidCallType: 0,
            fromToken: {
              chainId: 43114,
              address: "0xfaB550568C688d5D8A52C7d794cb93Edc26eC0eC",
              name: "Axelar USDC",
              symbol: "axlUSDC",
              decimals: 6,
              logoURI:
                "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
              coingeckoId: "axlusdc",
              commonKey: "uusdc",
            },
            toToken: {
              chainId: 43114,
              address: "0xB97EF9Ef8734C71904D8002F8b6Bc66Dd9c48a6E",
              decimals: 6,
              name: "USD Coin",
              symbol: "USDC",
              logoURI:
                "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
              coingeckoId: "usd-coin-avalanche-bridged-usdc-e",
              commonKey: "avalanche-uusdc",
            },
            fromAmount: "2000000",
            toAmount: "2000206",
            toAmountMin: "1992178",
            exchangeRate: "1.000103",
            priceImpact: "-0.0002899609648683",
            isFrom: false,
            dynamicSlippage: 0.401341386156495,
          },
          {
            type: "SWAP",
            dex: {
              chainName: "Avalanche",
              dexName: "TraderJoe",
              swapRouter: "0x60aE616a2155Ee3d9A68541Ba4544862310933d4",
              factory: "0x9ad6c38be94206ca50bb0d90783181662f0cfa10",
              isCrypto: true,
            },
            target: "0x60aE616a2155Ee3d9A68541Ba4544862310933d4",
            path: [
              "0xB97EF9Ef8734C71904D8002F8b6Bc66Dd9c48a6E",
              "0xB31f66AA3C1e785363F0875A1B74E27b85FD66c7",
            ],
            swapType: "crypto",
            squidCallType: 1,
            fromToken: {
              chainId: 43114,
              address: "0xB97EF9Ef8734C71904D8002F8b6Bc66Dd9c48a6E",
              decimals: 6,
              name: "USD Coin",
              symbol: "USDC",
              logoURI:
                "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
              coingeckoId: "usd-coin-avalanche-bridged-usdc-e",
              commonKey: "avalanche-uusdc",
            },
            toToken: {
              chainId: 43114,
              address: "0xB31f66AA3C1e785363F0875A1B74E27b85FD66c7",
              name: "Wrapped AVAX",
              symbol: "WAVAX",
              decimals: 18,
              logoURI:
                "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/avax.svg",
              coingeckoId: "wrapped-avax",
              commonKey: "wavax-wei",
            },
            fromAmount: "2000206",
            toAmount: "72539144530944138",
            toAmountMin: "72101963603672917",
            exchangeRate: "0.036265836884272988",
            priceImpact: "0.0005375850513368",
            isFrom: false,
            dynamicSlippage: 0.60268277231299,
          },
          {
            type: "SWAP",
            dex: {
              chainName: "Avalanche",
              dexName: "Curve_v2",
              swapRouter: "0xBff334F8D5912AC5c4f2c590A2396d1C5d990123",
              isStable: true,
              isCrypto: true,
            },
            target: "0xBff334F8D5912AC5c4f2c590A2396d1C5d990123",
            path: [
              "0xfaB550568C688d5D8A52C7d794cb93Edc26eC0eC",
              "0xB97EF9Ef8734C71904D8002F8b6Bc66Dd9c48a6E",
            ],
            swapType: "stable",
            squidCallType: 1,
            fromToken: {
              chainId: 43114,
              address: "0xfaB550568C688d5D8A52C7d794cb93Edc26eC0eC",
              name: "Axelar USDC",
              symbol: "axlUSDC",
              decimals: 6,
              logoURI:
                "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
              coingeckoId: "axlusdc",
              commonKey: "uusdc",
            },
            toToken: {
              chainId: 43114,
              address: "0xB97EF9Ef8734C71904D8002F8b6Bc66Dd9c48a6E",
              decimals: 6,
              name: "USD Coin",
              symbol: "USDC",
              logoURI:
                "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
              coingeckoId: "usd-coin-avalanche-bridged-usdc-e",
              commonKey: "avalanche-uusdc",
            },
            fromAmount: "1505469",
            toAmount: "1505624",
            toAmountMin: "1493539",
            exchangeRate: "1.000102957948652546",
            priceImpact: "-0.0002857562510152",
            isFrom: false,
            dynamicSlippage: 0.8026827723129899,
          },
          {
            type: "SWAP",
            dex: {
              chainName: "Avalanche",
              dexName: "TraderJoe",
              swapRouter: "0x60aE616a2155Ee3d9A68541Ba4544862310933d4",
              factory: "0x9ad6c38be94206ca50bb0d90783181662f0cfa10",
              isCrypto: true,
            },
            target: "0x60aE616a2155Ee3d9A68541Ba4544862310933d4",
            path: [
              "0xB97EF9Ef8734C71904D8002F8b6Bc66Dd9c48a6E",
              "0xB31f66AA3C1e785363F0875A1B74E27b85FD66c7",
            ],
            swapType: "crypto",
            squidCallType: 1,
            fromToken: {
              chainId: 43114,
              address: "0xB97EF9Ef8734C71904D8002F8b6Bc66Dd9c48a6E",
              decimals: 6,
              name: "USD Coin",
              symbol: "USDC",
              logoURI:
                "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/usdc.svg",
              coingeckoId: "usd-coin-avalanche-bridged-usdc-e",
              commonKey: "avalanche-uusdc",
            },
            toToken: {
              chainId: 43114,
              address: "0xB31f66AA3C1e785363F0875A1B74E27b85FD66c7",
              name: "Wrapped AVAX",
              symbol: "WAVAX",
              decimals: 18,
              logoURI:
                "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/avax.svg",
              coingeckoId: "wrapped-avax",
              commonKey: "wavax-wei",
            },
            fromAmount: "1505624",
            toAmount: "54602787339179287",
            toAmountMin: "54056759465787494",
            exchangeRate: "0.036265885333376252",
            priceImpact: "0.0004039914354954",
            isFrom: false,
            dynamicSlippage: 1,
          },
        ],
      },
      feeCosts: [
        {
          name: "Gas Receiver Fee",
          description: "Estimated Gas Receiver fee",
          percentage: "0",
          token: {
            chainId: 1,
            address: "0xEeeeeEeeeEeEeeEeEeEeeEEEeeeeEeeeeeeeEEeE",
            name: "Ethereum",
            symbol: "ETH",
            decimals: 18,
            logoURI:
              "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/eth.svg",
            coingeckoId: "ethereum",
            commonKey: "weth-wei",
          },
          amount: "551234033843310",
          amountUSD: "1.9276",
        },
      ],
      gasCosts: [
        {
          type: "executeCall",
          token: {
            chainId: 1,
            address: "0xEeeeeEeeeEeEeeEeEeEeeEEEeeeeEeeeeeeeEEeE",
            name: "Ethereum",
            symbol: "ETH",
            decimals: 18,
            logoURI:
              "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/eth.svg",
            coingeckoId: "ethereum",
            commonKey: "weth-wei",
          },
          amount: "6259874503623000",
          amountUSD: "21.8903",
          gasPrice: "7585449207",
          maxFeePerGas: "16668898414",
          maxPriorityFeePerGas: "1500000000",
          estimate: "689000",
          limit: "689000",
        },
      ],
      estimatedRouteDuration: 960,
      isExpressSupported: true,
      exchangeRate: "54.602787339179287",
      aggregatePriceImpact: "0.0",
      toAmountUSD: "1.507",
      toAmountMinUSD: "1.492",
    },
    params: {
      collectFees: {
        feeLocation: "NONE",
      },
      receiveGasOnDestination: true,
      enableExpress: false,
      slippage: 1,
      quoteOnly: false,
      toAddress: "0x6c515B41bFBEe0aA754F306098Ba005152c928b9",
      fromAddress: "0x7863Ec05b123885c7609B05c35Df777F3F180258",
      fromAmount: "1000000000000000",
      toToken: {
        chainId: 43114,
        address: "0xB31f66AA3C1e785363F0875A1B74E27b85FD66c7",
        name: "Wrapped AVAX",
        symbol: "WAVAX",
        decimals: 18,
        logoURI:
          "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/avax.svg",
        coingeckoId: "wrapped-avax",
        commonKey: "wavax-wei",
      },
      fromToken: {
        chainId: 1,
        address: "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
        name: "Wrapped ETH",
        symbol: "WETH",
        decimals: 18,
        logoURI:
          "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
        coingeckoId: "weth",
        commonKey: "weth-wei",
      },
      toChain: "43114",
      fromChain: "1",
    },
    transactionRequest: {
      routeType: "CALL_BRIDGE_CALL",
      targetAddress: "0xce16F69375520ab01377ce7B88f5BA8C48F8D666",
      data: "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",
      value: "551234033843310",
      gasLimit: "689000",
      gasPrice: "7585449207",
      maxFeePerGas: "16668898414",
      maxPriorityFeePerGas: "1500000000",
    },
  },
};

export const ETH_OsmosisToEthereum_Route = {
  route: {
    estimate: {
      fromAmount: "1000000000000000000000",
      sendAmount: "1000000000000000000000",
      toAmount: "999995820694001025771",
      toAmountMin: "999995820694001025771",
      fromAmountUSD: "3,496,020.00",
      route: {
        fromChain: [
          {
            type: "Transfer",
            fromChain: "osmosis-1",
            toChain: "axelar-dojo-1",
            fromToken: {
              chainId: "osmosis-1",
              address:
                "ibc/EA1D43981D5C9A1C4AAEA9C23BB1D4FA126BA9BC7020A25E0AE4AA841EA25DC5",
              name: "Axelar ETH",
              symbol: "axlETH",
              decimals: 18,
              logoURI:
                "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
              coingeckoId: "weth",
              commonKey: "weth-wei",
              ibcDenom:
                "ibc/EA1D43981D5C9A1C4AAEA9C23BB1D4FA126BA9BC7020A25E0AE4AA841EA25DC5",
              pathKey: "axleth_osmosis",
            },
            toToken: {
              chainId: "axelar-dojo-1",
              address: "weth-wei",
              name: "Axelar ETH",
              symbol: "axlWETH",
              decimals: 18,
              logoURI:
                "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
              coingeckoId: "weth",
              commonKey: "weth-wei",
              bridgeOnly: true,
              ibcDenom: "weth-wei",
              pathKey: "axleth_axelar",
            },
            fromChannel: "channel-208",
            toChannel: "channel-3",
          },
        ],
        toChain: [
          {
            type: "CUSTOM",
            callType: 1,
            target: "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
            value: "0",
            callData:
              "0xa9059cbb0000000000000000000000006c515b41bfbee0aa754f306098ba005152c928b90000000000000000000000000000000000000000000000000000000000000000",
            payload: {
              tokenAddress: "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
              inputPos: 1,
            },
            estimatedGas: "70000",
          },
        ],
      },
      feeCosts: [
        {
          name: "Gas Receiver Fee",
          description: "Estimated Gas Receiver fee",
          percentage: "0",
          token: {
            chainId: "osmosis-1",
            address:
              "ibc/EA1D43981D5C9A1C4AAEA9C23BB1D4FA126BA9BC7020A25E0AE4AA841EA25DC5",
            name: "Axelar ETH",
            symbol: "axlETH",
            decimals: 18,
            logoURI:
              "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
            coingeckoId: "weth",
            commonKey: "weth-wei",
            ibcDenom:
              "ibc/EA1D43981D5C9A1C4AAEA9C23BB1D4FA126BA9BC7020A25E0AE4AA841EA25DC5",
            pathKey: "axleth_osmosis",
          },
          amount: "4179305998974229",
          amountUSD: "14.6109",
        },
      ],
      gasCosts: [
        {
          type: "executeCall",
          token: {
            chainId: "osmosis-1",
            address:
              "ibc/EA1D43981D5C9A1C4AAEA9C23BB1D4FA126BA9BC7020A25E0AE4AA841EA25DC5",
            name: "Axelar ETH",
            symbol: "axlETH",
            decimals: 18,
            logoURI:
              "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
            coingeckoId: "weth",
            commonKey: "weth-wei",
            ibcDenom:
              "ibc/EA1D43981D5C9A1C4AAEA9C23BB1D4FA126BA9BC7020A25E0AE4AA841EA25DC5",
            pathKey: "axleth_osmosis",
          },
          amount: "20000",
          amountUSD: "0.0000",
          gasPrice: "0.25uosmo",
          maxFeePerGas: "1.5",
          estimate: "500000000000",
          limit: "650000000000",
        },
      ],
      estimatedRouteDuration: 60,
      isExpressSupported: false,
      exchangeRate: "1.0",
      aggregatePriceImpact: "0.0",
      toAmountUSD: "3,496,005.3891",
      toAmountMinUSD: "3,496,005.3891",
    },
    params: {
      collectFees: {
        feeLocation: "NONE",
      },
      receiveGasOnDestination: false,
      enableExpress: false,
      slippage: 1,
      quoteOnly: false,
      toAddress: "0x6c515B41bFBEe0aA754F306098Ba005152c928b9",
      fromAddress: "osmo107vyuer6wzfe7nrrsujppa0pvx35fvplp4t7tx",
      fromAmount: "1000000000000000000000",
      toToken: {
        chainId: 1,
        address: "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
        name: "Wrapped ETH",
        symbol: "WETH",
        decimals: 18,
        logoURI:
          "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
        coingeckoId: "weth",
        commonKey: "weth-wei",
      },
      fromToken: {
        chainId: "osmosis-1",
        address:
          "ibc/EA1D43981D5C9A1C4AAEA9C23BB1D4FA126BA9BC7020A25E0AE4AA841EA25DC5",
        name: "Axelar ETH",
        symbol: "axlETH",
        decimals: 18,
        logoURI:
          "https://raw.githubusercontent.com/0xsquid/assets/main/images/tokens/weth.svg",
        coingeckoId: "weth",
        commonKey: "weth-wei",
        ibcDenom:
          "ibc/EA1D43981D5C9A1C4AAEA9C23BB1D4FA126BA9BC7020A25E0AE4AA841EA25DC5",
        pathKey: "axleth_osmosis",
      },
      toChain: "1",
      fromChain: "osmosis-1",
    },
    transactionRequest: {
      routeType: "CALL_BRIDGE_CALL",
      data: '{"msgTypeUrl":"/ibc.applications.transfer.v1.MsgTransfer","msg":{"sourcePort":"transfer","sourceChannel":"channel-208","token":{"denom":"ibc/EA1D43981D5C9A1C4AAEA9C23BB1D4FA126BA9BC7020A25E0AE4AA841EA25DC5","amount":"1000000000000000000000"},"sender":"osmo107vyuer6wzfe7nrrsujppa0pvx35fvplp4t7tx","receiver":"axelar1dv4u5k73pzqrxlzujxg3qp8kvc3pje7jtdvu72npnt5zhq05ejcsn5qme5","timeoutTimestamp":{"low":-2012515328,"high":400233074,"unsigned":false},"memo":"{\\"destination_chain\\":\\"ethereum\\",\\"destination_address\\":\\"0xce16F69375520ab01377ce7B88f5BA8C48F8D666\\",\\"payload\\":[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,108,81,91,65,191,190,224,170,117,79,48,96,152,186,0,81,82,201,40,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,192,42,170,57,178,35,254,141,10,14,92,79,39,234,217,8,60,117,108,194,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,192,42,170,57,178,35,254,141,10,14,92,79,39,234,217,8,60,117,108,194,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,169,5,156,187,0,0,0,0,0,0,0,0,0,0,0,0,108,81,91,65,191,190,224,170,117,79,48,96,152,186,0,81,82,201,40,185,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,192,42,170,57,178,35,254,141,10,14,92,79,39,234,217,8,60,117,108,194,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],\\"type\\":2,\\"fee\\":{\\"amount\\":\\"4179305998974229\\",\\"recipient\\":\\"axelar1aythygn6z5thymj6tmzfwekzh05ewg3l7d6y89\\"}}"}}',
      value: "4179305998974229",
      gasLimit: "650000000000",
      gasPrice: "0.25uosmo",
      maxFeePerGas: "1.5",
    },
  },
};
