export const MockAxelarAssets = [
  {
    denom: "eth-wei",
    denoms: ["weth-wei", "eth"],
    native_chain: "ethereum",
    name: "Wrapped Ether",
    symbol: "WETH",
    decimals: 18,
    image: "/logos/assets/weth.svg",
    addresses: {
      ethereum: {
        symbol: "WETH",
        address: "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
      },
      binance: {
        symbol: "axlETH",
        address: "0xfe7eDa5F2c56160d406869A8aA4B2F365d544C7B",
      },
      polygon: {
        symbol: "axlETH",
        address: "0x1280830F690D0E65195B3c61b028244C3A49f26D",
      },
      avalanche: {
        symbol: "axlETH",
        address: "0x42A62eb3Fd2a05eD499117F128de8a3192B49EBB",
      },
      fantom: {
        symbol: "axlETH",
        address: "0xfe7eDa5F2c56160d406869A8aA4B2F365d544C7B",
      },
      moonbeam: {
        symbol: "axlETH",
        address: "0x85a8B472d116585E2cc10eB1e0e3E3127E1f5D3f",
      },
      arbitrum: {
        symbol: "axlETH",
        address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
      },
      optimism: {
        symbol: "axlETH",
        address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
      },
      base: {
        symbol: "axlETH",
        address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
      },
      mantle: {
        symbol: "axlETH",
        address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
      },
      celo: {
        symbol: "axlETH",
        address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
      },
      kava: {
        symbol: "axlETH",
        address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
      },
      filecoin: {
        symbol: "axlETH",
        address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
      },
      linea: {
        symbol: "axlETH",
        address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
      },
      scroll: {
        symbol: "axlETH",
        address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
      },
      axelarnet: {
        symbol: "axlETH",
        ibc_denom: "weth-wei",
      },
      osmosis: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/EA1D43981D5C9A1C4AAEA9C23BB1D4FA126BA9BC7020A25E0AE4AA841EA25DC5",
      },
      cosmoshub: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/3C168643B15498A2F8BA843649D7CF207EA2F5A7C8AE77BC175EC2FBF21B1BAA",
      },
      juno: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/95A45A81521EAFDBEDAEEB6DA975C02E55B414C95AD3CE50709272366A90CA17",
      },
      injective: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/65A6973F7A4013335AE5FFE623FE019A78A1FEEE9B8982985099978837D764A7",
      },
      crescent: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/F1806958CA98757B91C3FA1573ECECD24F6FA3804F074A6977658914A49E65A3",
      },
      kujira: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/1B38805B1C75352B28169284F96DF56BDEBD9E8FAC005BDCC8CF0378C82AA8E7",
      },
      "secret-snip": {
        symbol: "axlETH",
        ibc_denom:
          "ibc/63D64CE0A4CAAE106B251E1B3DB351A0384B1D00A65DCC88CC0F43D7C06D28F7",
      },
      secret: {
        ibc_denom:
          "ibc/3665ACBA97B115133C35F060DB67E9671035E9ED48B2FC9140260C122D0C4E03",
        symbol: "axlETH",
      },
      stargaze: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/08CF01F857C36D3C91C3427AA2EACFAFC07971E7AC40B6C433A9982B333F2567",
      },
      assetmantle: {
        ibc_denom:
          "ibc/3EFE89848528B4A5665D0102DB818C6B19E04E17455197E92BECC3C41A7F7D78",
        symbol: "axlETH",
      },
      fetch: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/74712D58FE426053FE962D71BCA5BE80BF83F1BC3508E5E16EBE70241D4E73BE",
      },
      ki: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/9B68CC79EFF12D25AF712EB805C5062B8F97B2CCE5F3FE55B107EE03095514A3",
      },
      evmos: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/356EDE917394B2AEF7F915EB24FA683A0CCB8D16DD4ECCEDC2AD0CEC6B66AC81",
      },
      aura: {
        ibc_denom:
          "ibc/F1806958CA98757B91C3FA1573ECECD24F6FA3804F074A6977658914A49E65A3",
        symbol: "axlETH",
      },
      comdex: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/81C3A46287D7664A8FD19843AC8D0CFD6C284EF1F750C661C48B3544277B1B29",
      },
      persistence: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/43494E635D14726AEA1203EE63F4C3B27642345C3D9AF6091585CB7FDAB349D7",
      },
      regen: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/62B27C470C859CBCB57DC12FCBBD357DD44CAD673362B47503FAA77523ABA028",
      },
      umee: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/04CE51E6E02243E565AE676DD60336E48D455F8AAD0611FA0299A22FDAC448D6",
      },
      agoric: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/1B38805B1C75352B28169284F96DF56BDEBD9E8FAC005BDCC8CF0378C82AA8E7",
      },
      xpla: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/ADD91F7979979B9DBBF383BD556BD15E73D4FEECE4210FF80929ADFEBCCF110B",
      },
      acre: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/E3AB0DFDE9E782262B770C32DF94AC2A92B93DC4825376D6F6C874D3C877864E",
      },
      carbon: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/DC44871FDB10B6FB4D4089247AA918B0F30428C8911AFB6192D98AE8E38E31CB",
      },
      sommelier: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/E3AB0DFDE9E782262B770C32DF94AC2A92B93DC4825376D6F6C874D3C877864E",
      },
      neutron: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/A585C2D15DCD3B010849B453A2CFCB5E213208A5AB665691792684C26274304D",
      },
      rebus: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/1B38805B1C75352B28169284F96DF56BDEBD9E8FAC005BDCC8CF0378C82AA8E7",
      },
      archway: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/13C5990F84FA5D472E1F8BB1BAAEA8774DA5F24128EC02B119107AD21FB52A61",
      },
      provenance: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/1B38805B1C75352B28169284F96DF56BDEBD9E8FAC005BDCC8CF0378C82AA8E7",
      },
      ixo: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/346392E297585AFCCDDA1E9D24AEED98FF67CB2B5ACE3160CD0D82618A658CC2",
      },
      chihuahua: {
        ibc_denom:
          "ibc/E614301CF4F54C23FAEEBF50F33D247AC743E9F247AB094AC57F68DB3A80635C",
        symbol: "axlETH",
      },
      terra: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/9B68CC79EFF12D25AF712EB805C5062B8F97B2CCE5F3FE55B107EE03095514A3",
      },
      "terra-2": {
        symbol: "axlETH",
        ibc_denom:
          "ibc/BC8A77AFBD872FDC32A348D3FB10CC09277C266CFE52081DE341C7EC6752E674",
      },
      bitsong: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/4A3A652BDC946722B2F47996905BF658E8C46CC4DA473D5469003C3A98E00874",
      },
      blast: {
        symbol: "axlETH",
        address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
      },
      c4e: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/ADD91F7979979B9DBBF383BD556BD15E73D4FEECE4210FF80929ADFEBCCF110B",
      },
      dymension: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/E3AB0DFDE9E782262B770C32DF94AC2A92B93DC4825376D6F6C874D3C877864E",
      },
      fraxtal: {
        symbol: "axlETH",
        address: "0xb829b68f57CC546dA7E5806A929e53bE32a4625D",
      },
      nolus: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/E7D47C7C104FB8E2C15AB94F67B8AAE4F62C8732480F61DCC422CB6B482F9727",
      },
      ojo: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/DD0D56BDAB32493B216A4C0530A336620D86FBE1C682888C5513899838FF7389",
      },
      sei: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/A585C2D15DCD3B010849B453A2CFCB5E213208A5AB665691792684C26274304D",
      },
      teritori: {
        symbol: "axlETH",
        ibc_denom:
          "ibc/ED182F6ABD428EFCE49C2985E2B65DD194E0DEFEAFAE60D99F790701046EDA23",
      },
    },
    coingecko_id: "weth",
    id: "eth-wei",
  },
  {
    denom: "uusdc",
    native_chain: "ethereum",
    name: "USD Coin",
    symbol: "USDC",
    decimals: 6,
    image: "/logos/assets/usdc.svg",
    addresses: {
      ethereum: {
        symbol: "USDC",
        address: "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48",
      },
      binance: {
        symbol: "axlUSDC",
        address: "0x4268B8F0B87b6Eae5d897996E6b845ddbD99Adf3",
      },
      polygon: {
        symbol: "axlUSDC",
        address: "0x750e4C4984a9e0f12978eA6742Bc1c5D248f40ed",
      },
      avalanche: {
        symbol: "axlUSDC",
        address: "0xfaB550568C688d5D8A52C7d794cb93Edc26eC0eC",
      },
      fantom: {
        symbol: "axlUSDC",
        address: "0x1B6382DBDEa11d97f24495C9A90b7c88469134a4",
      },
      moonbeam: {
        symbol: "axlUSDC",
        address: "0xCa01a1D0993565291051daFF390892518ACfAD3A",
      },
      aurora: {
        address: "0x4268B8F0B87b6Eae5d897996E6b845ddbD99Adf3",
        symbol: "axlUSDC",
      },
      arbitrum: {
        symbol: "axlUSDC",
        address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
      },
      optimism: {
        symbol: "axlUSDC",
        address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
      },
      base: {
        symbol: "axlUSDC",
        address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
      },
      mantle: {
        symbol: "axlUSDC",
        address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
      },
      celo: {
        symbol: "axlUSDC",
        address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
      },
      kava: {
        symbol: "axlUSDC",
        address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
      },
      filecoin: {
        symbol: "axlUSDC",
        address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
      },
      linea: {
        symbol: "axlUSDC",
        address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
      },
      scroll: {
        symbol: "axlUSDC",
        address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
      },
      axelarnet: {
        symbol: "axlUSDC",
        ibc_denom: "uusdc",
      },
      osmosis: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/D189335C6E4A68B513C10AB227BF1C1D38C746766278BA3EEB4FB14124F1D858",
      },
      cosmoshub: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/932D6003DA334ECBC5B23A071B4287D0A5CC97331197FE9F1C0689BA002A8421",
      },
      juno: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/EAC38D55372F38F1AFD68DF7FE9EF762DCF69F26520643CF3F9D292A738D8034",
      },
      injective: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/7E1AF94AD246BE522892751046F0C959B768642E5671CC3742264068D49553C0",
      },
      crescent: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/BFF0D3805B50D93E2FA5C0B2DDF7E0B30A631076CD80BC12A48C0E95404B4A41",
      },
      kujira: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/295548A78785A1007F232DE286149A6FF512F180AF5657780FC89C009E2C348F",
      },
      "secret-snip": {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/FC0FF958BC92354A5EF218C511B6949B29407D9EBEB741E2833137961ABAFD96",
      },
      secret: {
        ibc_denom:
          "ibc/CD7B6B7D85FDF5F72A78E806BCFB8060B561EEF27677B111E0A610626056451E",
        symbol: "axlUSDC",
      },
      sei: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/F082B65C88E4B6D5EF1DB243CDA1D331D002759E938A0F5CD3FFDC5D53B3E349",
      },
      stargaze: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/96274E25174EE93314D8B5636D2D2F70963E207C22F643EC41949A3CBEDA4C72",
      },
      assetmantle: {
        ibc_denom:
          "ibc/616E26A85AD20A3DDEAEBDDE7262E3BA9356C557BC15CACEA86768D7D51FA703",
        symbol: "axlUSDC",
      },
      fetch: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/8AF69BC1E1D72B447738B50C28B382F62F2AF65DE303021E45C0B7C851B4B2E1",
      },
      ki: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/E1E3674A0E4E1EF9C69646F9AF8D9497173821826074622D831BAB73CCB99A2D",
      },
      evmos: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/63C53CBDF471D4E867366ABE2E631197257118D1B2BEAD1946C8A408F96464C3",
      },
      aura: {
        ibc_denom:
          "ibc/BFF0D3805B50D93E2FA5C0B2DDF7E0B30A631076CD80BC12A48C0E95404B4A41",
        symbol: "axlUSDC",
      },
      comdex: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/E1616E7C19EA474C565737709A628D6F8A23FF9D3E9A7A6871306CF5E0A5341E",
      },
      persistence: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/34C83B3566255FBE18D4D6B6D1716DBC8993CC3FB2E6110A6BB47DFACA4B0A7A",
      },
      regen: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/334740505537E9894A64E8561030695016481830D7B36E6A9B6D13C608B55653",
      },
      umee: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/49788C29CD84E08D25CA7BE960BC1F61E88FEFC6333F58557D236D693398466A",
      },
      agoric: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/295548A78785A1007F232DE286149A6FF512F180AF5657780FC89C009E2C348F",
      },
      xpla: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/8E27BA2D5493AF5636760E354E46004562C46AB7EC0CC4C1CA14E9E20E2545B5",
      },
      acre: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/BFAAB7870A9AAABF64A7366DAAA0B8E5065EAA1FCE762F45677DC24BE796EF65",
      },
      stride: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/5FA12AB6B23F7FC00BFBA3B26E320C91226BF88CC17DA5E088013252C91AEAD1",
      },
      carbon: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/7C0807A56073C4A27B0DE1C21BA3EB75DF75FD763F4AD37BC159917FC01145F0",
      },
      sommelier: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/BFAAB7870A9AAABF64A7366DAAA0B8E5065EAA1FCE762F45677DC24BE796EF65",
      },
      neutron: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/F082B65C88E4B6D5EF1DB243CDA1D331D002759E938A0F5CD3FFDC5D53B3E349",
      },
      rebus: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/295548A78785A1007F232DE286149A6FF512F180AF5657780FC89C009E2C348F",
      },
      archway: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/B9E4FD154C92D3A23BEA029906C4C5FF2FE74CB7E3A058290B77197A263CF88B",
      },
      provenance: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/295548A78785A1007F232DE286149A6FF512F180AF5657780FC89C009E2C348F",
      },
      ixo: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/2658C97FC74B74AB1898982081523C455561BBE3C705E47707021D47F3D94B38",
      },
      migaloo: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/3808384ECC813CAF207992BE997BD18E18560E473D5368F1B4B77C3822262C4D",
      },
      haqq: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/65D0BEC6DAD96C7F5043D1E54E54B6BB5D5B3AEC3FF6CEBB75B9E059F3580EA3",
      },
      chihuahua: {
        ibc_denom:
          "ibc/3816292E7134C03F261BA0E1CF4ED8E46E74DEF348A8BD4DF72E337CCFA482A6",
        symbol: "axlUSDC",
      },
      terra: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/E1E3674A0E4E1EF9C69646F9AF8D9497173821826074622D831BAB73CCB99A2D",
      },
      "terra-2": {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/B3504E092456BA618CC28AC671A71FB08C6CA0FD0BE7C8A5B5A3E2DD933CC9E4",
      },
      bitsong: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/B559A80D62249C8AA07A380E2A2BEA6E5CA9A6F079C912C3A9E9B494105E4F81",
      },
      blast: {
        symbol: "axlUSDC",
        address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
      },
      c4e: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/8E27BA2D5493AF5636760E354E46004562C46AB7EC0CC4C1CA14E9E20E2545B5",
      },
      dymension: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/BFAAB7870A9AAABF64A7366DAAA0B8E5065EAA1FCE762F45677DC24BE796EF65",
      },
      fraxtal: {
        symbol: "axlUSDC",
        address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
      },
      immutable: {
        symbol: "axlUSDC",
        address: "0xEB466342C4d449BC9f53A865D5Cb90586f405215",
      },
      nolus: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/374F4F22F8BA560D182922841988E56D671A901272483A619372813B8F10B0BB",
      },
      teritori: {
        symbol: "axlUSDC",
        ibc_denom:
          "ibc/25BEA899D29934A185A2492310B1FF00FB3204C9BC93585EC84A3A30CD92279B",
      },
    },
    coingecko_id: "usd-coin",
    id: "uusdc",
  },
  {
    denom: "uaxl",
    native_chain: "axelarnet",
    name: "Axelar",
    symbol: "AXL",
    decimals: 6,
    image: "/logos/assets/axl.svg",
    addresses: {
      ethereum: {
        symbol: "AXL",
        address: "0x467719aD09025FcC6cF6F8311755809d45a5E5f3",
      },
      binance: {
        symbol: "AXL",
        address: "0x8b1f4432F943c465A973FeDC6d7aa50Fc96f1f65",
      },
      polygon: {
        symbol: "AXL",
        address: "0x6e4E624106Cb12E168E6533F8ec7c82263358940",
      },
      avalanche: {
        symbol: "AXL",
        address: "0x44c784266cf024a60e8acF2427b9857Ace194C5d",
      },
      fantom: {
        symbol: "AXL",
        address: "0x8b1f4432F943c465A973FeDC6d7aa50Fc96f1f65",
      },
      moonbeam: {
        symbol: "AXL",
        address: "0x467719aD09025FcC6cF6F8311755809d45a5E5f3",
      },
      arbitrum: {
        symbol: "AXL",
        address: "0x23ee2343B892b1BB63503a4FAbc840E0e2C6810f",
      },
      optimism: {
        symbol: "AXL",
        address: "0x23ee2343B892b1BB63503a4FAbc840E0e2C6810f",
      },
      base: {
        symbol: "AXL",
        address: "0x23ee2343B892b1BB63503a4FAbc840E0e2C6810f",
      },
      mantle: {
        symbol: "AXL",
        address: "0x23ee2343B892b1BB63503a4FAbc840E0e2C6810f",
      },
      celo: {
        symbol: "AXL",
        address: "0x23ee2343B892b1BB63503a4FAbc840E0e2C6810f",
      },
      kava: {
        symbol: "AXL",
        address: "0x23ee2343B892b1BB63503a4FAbc840E0e2C6810f",
      },
      filecoin: {
        symbol: "AXL",
        address: "0x23ee2343B892b1BB63503a4FAbc840E0e2C6810f",
      },
      linea: {
        symbol: "AXL",
        address: "0x23ee2343B892b1BB63503a4FAbc840E0e2C6810f",
      },
      scroll: {
        symbol: "AXL",
        address: "0x23ee2343B892b1BB63503a4FAbc840E0e2C6810f",
      },
      axelarnet: { symbol: "AXL", ibc_denom: "uaxl" },
      osmosis: {
        symbol: "AXL",
        ibc_denom:
          "ibc/903A61A498756EA560B85A85132D3AEE21B5DEDD41213725D22ABF276EA6945E",
      },
      juno: {
        symbol: "AXL",
        ibc_denom:
          "ibc/EBE900AED8FF6BB2E186B17B066138F647CDD9647EF4FBE2DE6C8D4013A2C990",
      },
      crescent: {
        symbol: "AXL",
        ibc_denom:
          "ibc/0634D0993744740D675AD01E81156EAC945AEAAE17C074918DC7FF52F41B263E",
      },
      kujira: {
        symbol: "AXL",
        ibc_denom:
          "ibc/C01154C2547F4CB10A985EA78E7CD4BA891C1504360703A37E1D7043F06B5E1F",
      },
      umee: {
        symbol: "AXL",
        ibc_denom:
          "ibc/D1CB2804AA5EB64D503F28E8DF3552F8A4D642802B66EFE50DE432B755F37AE1",
      },
      carbon: {
        ibc_denom:
          "ibc/062588846168EDFECF20F7681F2A0A131A53B9A3C8535BCA8F7D1A268246974B",
      },
      neutron: {
        symbol: "AXL",
        ibc_denom:
          "ibc/C0E66D1C81D8AAF0E6896E05190FDFBC222367148F86AC3EA679C28327A763CD",
      },
      blast: {
        symbol: "AXL",
        address: "0x23ee2343B892b1BB63503a4FAbc840E0e2C6810f",
      },
      fraxtal: {
        symbol: "AXL",
        address: "0x23ee2343B892b1BB63503a4FAbc840E0e2C6810f",
      },
      ojo: {
        symbol: "AXL",
        ibc_denom:
          "ibc/0E1517E2771CA7C03F2ED3F9BAECCAEADF0BFD79B89679E834933BC0F179AD98",
      },
    },
    coingecko_id: "axelar",
    id: "uaxl",
  },
  {
    denom: "avalanche-uusdc",
    native_chain: "avalanche",
    name: "Avalanche USDC",
    symbol: "AvalancheUSDC",
    decimals: 6,
    image: "/logos/assets/usdc.svg",
    addresses: {
      avalanche: {
        symbol: "AvalancheUSDC",
        address: "0xB97EF9Ef8734C71904D8002F8b6Bc66Dd9c48a6E",
      },
      axelarnet: { symbol: "AvalancheUSDC", ibc_denom: "avalanche-uusdc" },
      osmosis: {
        symbol: "AvalancheUSDC",
        ibc_denom:
          "ibc/F17C9CA112815613C5B6771047A093054F837C3020CBA59DFFD9D780A8B2984C",
      },
      sommelier: {
        symbol: "AvalancheUSDC",
        ibc_denom:
          "ibc/4AF49824065A2EB5F05E5AD5823178E595577D26500592615E3E8746EBDA5652",
      },
    },
    coingecko_id: "usd-coin",
    id: "avalanche-uusdc",
  },
];

export const MockAxelarChains = [
  {
    chain_id: "osmosis-1",
    chain_name: "osmosis",
    endpoints: {
      lcd: [
        "https://lcd.osmosis.zone",
        "https://lcd-osmosis.imperator.co",
        "https://api-osmosis-ia.cosmosia.notional.ventures",
        "https://lcd-osmosis.blockapsis.com",
        "https://rest-osmosis.ecostake.com",
        "https://osmosis-api.polkachu.com",
      ],
      timeout: {
        lcd: 3000,
      },
    },
    native_token: {
      name: "Osmosis",
      symbol: "OSMO",
      denom: "uosmo",
      decimals: 6,
    },
    name: "Osmosis",
    short_name: "OSMO",
    image: "/logos/chains/osmosis.svg",
    color: "#d705cc",
    explorer: {
      name: "Mintscan",
      url: "https://www.mintscan.io/osmosis",
      icon: "/logos/explorers/mintscan.png",
      block_path: "/block/{block}",
      address_path: "/account/{address}",
      contract_path: "/account/{address}",
      transaction_path: "/txs/{tx}",
      asset_path: "/assets/ibc/{ibc_denom}",
    },
    prefix_address: "osmo",
    prefix_chain_ids: ["osmosis-"],
    id: "osmosis",
    chain_type: "cosmos",
  },
  {
    chain_id: 1,
    chain_name: "Ethereum",
    maintainer_id: "ethereum",
    endpoints: {
      rpc: [
        "https://mainnet.infura.io/v3/9aa3d95b3bc440fa88ea12eaa4456161",
        "https://1rpc.io/eth",
        "https://rpc.ankr.com/eth",
      ],
    },
    native_token: { name: "Ethereum", symbol: "ETH", decimals: 18 },
    name: "Ethereum",
    short_name: "ETH",
    image: "/logos/chains/ethereum.svg",
    color: "#c0c2c3",
    explorer: {
      name: "Etherscan",
      url: "https://etherscan.io",
      icon: "/logos/explorers/etherscan.png",
      block_path: "/block/{block}",
      address_path: "/address/{address}",
      contract_path: "/token/{address}",
      transaction_path: "/tx/{tx}",
    },
    id: "ethereum",
    chain_type: "evm",
    provider_params: [
      {
        chainId: "0x1",
        chainName: "Ethereum Mainnet",
        rpcUrls: [
          "https://mainnet.infura.io/v3/9aa3d95b3bc440fa88ea12eaa4456161",
          "https://1rpc.io/eth",
          "https://rpc.ankr.com/eth",
        ],
        nativeCurrency: { name: "Ethereum", symbol: "ETH", decimals: 18 },
        blockExplorerUrls: ["https://etherscan.io"],
      },
    ],
    no_inflation: false,
    no_tvl: false,
  },
  {
    chain_id: 43114,
    chain_name: "Avalanche",
    maintainer_id: "avalanche",
    endpoints: {
      rpc: [
        "https://avalanche.blockpi.network/v1/rpc/public",
        "https://1rpc.io/avax/c",
        "https://rpc.ankr.com/avalanche",
      ],
    },
    native_token: { name: "Avalanche", symbol: "AVAX", decimals: 18 },
    name: "Avalanche",
    short_name: "AVAX",
    image: "/logos/chains/avalanche.svg",
    color: "#e84143",
    explorer: {
      name: "Snowtrace",
      url: "https://snowtrace.io",
      icon: "/logos/explorers/snowtrace.png",
      block_path: "/block/{block}",
      address_path: "/address/{address}",
      contract_path: "/token/{address}",
      transaction_path: "/tx/{tx}",
    },
    id: "avalanche",
    chain_type: "evm",
    provider_params: [
      {
        chainId: "0xa86a",
        chainName: "Avalanche Mainnet",
        rpcUrls: [
          "https://avalanche.blockpi.network/v1/rpc/public",
          "https://1rpc.io/avax/c",
          "https://rpc.ankr.com/avalanche",
        ],
        nativeCurrency: { name: "Avalanche", symbol: "AVAX", decimals: 18 },
        blockExplorerUrls: ["https://snowtrace.io"],
      },
    ],
    no_inflation: false,
    no_tvl: false,
  },
];
