# Envers

`Envers` is a command-line tool (CLI) designed to manage and version environment
variables for different deployment stages such as staging, development, and
production. It provides a secure and organized way to handle
environment-specific configurations.

## Features

- Encrypt environment variables: Creates encrypted files that store environment
  variables that can be safely stored in a git repository
- Group-Based Configurations: Allows defining variables for different
  groups/profiles like prod, dev, etc.
- File-Based Variable Definitions: Supports multiple environment files (.env)
  with specific variables for each file.
- CLI-Driven: Provide CLI commands that helps to create drafts for environment
  variables and deploy it to encrypted files
- Spec Management: Each release has a defined spec that applies to all
  groups/profiles within that release.
- Environment File Generation: Enables generating .env files for specific
  versions and groups/profiles using commands.

## Installation

TBD

## Usage

Below are the initial subcommands for `envers`:

- `envers init`: Initialize the `envers` environment.
- `envers deploy <spec version number>`: Deploy a specific version from the spec
  file.
- `envers draft <spec version number>`: Create a new version draft in the spec
  file. Some variants of this command:
  - `envers draft <spec version number> --from <previous spec version number>`
  - `envers draft <spec version number> --from-env .env`
- `envers profile-set --profile <profile_name> --spec <version_number>`: Add new
  content.
- `envers profile load --profile prod --spec <spec version>`: Load a specific
  environment profile to files

`envers init` creates the spec file at `.envers/.specs.yaml`.

`envers deploy` creates the file `.envers/.data.lock`. This file is
auto-generated by `envers` command, and it is encrypted.

The initial version of `./.envers/.specs.yaml` would look like this:

```yaml
version: 0.1 # the envers spec version
releases:
```

As you can see, it doesn't have too much information. If you want to draft a new
version, you can run the following command:

```bash
$ envers draft 1.0
```

After this command, the `.envers/specs.yaml` file should look like this:

```yaml
version: 0.1 # the spec version
releases:
  # placeholder: the version for the environment variables.
  #   if the status is draft, feel free to change the version number
  1.0:
    # status attribute is handled by command line, don't change it manually
    status: draft # options are: draft, cancelled, deployed
    # placeholder: update help with the real help text
    help:
    # placeholder: a list of available profiles (groups) for this version.
    #   at least one profile is required for the deploying
    profiles:
      - base
    # define the spec for that version, this spec should be used for all
    # profiles (groups) inside this version
    spec:
      # define the env file or any other kind of environment file to be used,
      # for now it just has support for .env files
      files:
        # placeholder: change `.env` to the correct dotenv file relative path
        .env:
          type: dotenv # default
          # `vars` is a dictionary for the environment variables
          # this defines the variables and some metadata, but not the real
          # value, because it is just the definition of the spec.
          vars:
            # placeholder: ENV is just a variable name, replace it by your real
            # environment variable
            ENV:
              type: string # options are: string, int, bool, path
              default: dev # in the case that the variable is not defined
```

Now, you can deploy your first version of environment variables:

```bash
$ envers deploy 1.0
```

When a version is deployed, it creates automatically all the new spec into the
`.envers/data.lock`.

All the variables for the each profile and spec version is stored into
`.envers/data.lock`, and this file shouldn't be changed for any reason.

Finally, we can create the environment variables for the `base` profile:

```bash
$ envers profile set --profile base --spec 1.0
```

`envers` will ask you via prompt the value for each variable defined in the spec
for version `1.0`.

## Roadmap

- Detailed spec and content management functionalities.
- Enhancements in versioning and group management.
- Integration with makim and sugar.

## Contributing

https://osl-incubator.github.io/envers

## License

BSD-Clause 3
