# Getting Started with FPGAs

**Brought to you by the [Open Source FPGA Foundation](https://www.chipsalliance.org/)**

<a href="https://www.chipsalliance.org/"><img src="https://user-images.githubusercontent.com/11302288/130822353-15fd731a-2621-4a65-b753-3fe7e7e303aa.png" alt="osfpga-logo" height="90"></a>

<img src="https://user-images.githubusercontent.com/11302288/130853895-9c331820-1c9f-4fcd-bec9-7ab2afcc81cb.png" height="140">

Led by [Steve Hoover](https://www.linkedin.com/in/steve-hoover-a44b607/), founder of [<a href="https://redwoodeda.com"><img src="https://user-images.githubusercontent.com/11302288/130831451-1c3b1541-06f2-4c0e-bbaf-8e0026db00c1.png" alt="redwoodeda-logo" height="50"></a>](https://redwoodeda.com) and member of the [OSFPGA](https://www.chipsalliance.org/) Education and Training Committee.

This free short-course takes you from your browser to your board in under an hour, using the [Makerchip](https://makerchip.com) IDE.

<p float="left" style="font-size: 40px; font-weight: 500; letter-spacing: -.4rem">
  <img src="https://user-images.githubusercontent.com/64545984/130662812-ae1ea3b2-2ff2-40dd-bf99-9929980c9173.gif" alt="EDGE_Artix7_LED" width="600">&nbsp;&nbsp;=>&nbsp;&nbsp;
  <img src="https://user-images.githubusercontent.com/64545984/130665845-18b89d49-a5dc-4308-bdf1-45119d93abef.gif" alt="led_artix" /> 
</p>

You'll develop a simple counter circuit and a 7-segment display controller in Verilog or Transaction-Level Verilog. Then, if you have any of several supported FPGA boards, you’ll be able to run your design on your own FPGA. From there, the sky’s the limit.

Visit [OSFPGA.org](https://www.chipsalliance.org/) for further learning opportunities.

Supported Boards:

1. Zedboard Zynq-7000 ARM/FPGA SoC Development Board ([Product Link](https://www.avnet.com/wps/portal/us/products/avnet-boards/avnet-board-families/zedboard/))
2. EDGE Artix 7 FPGA Development Board ([Product Link](https://allaboutfpga.com/product/edge-artix-7-fpga-development-board/))
3. Basys 3 Artix-7 FPGA Trainer Board ([Product Link](https://store.digilentinc.com/basys-3-artix-7-fpga-beginner-board-recommended-for-introductory-users/)) 
4. Icebreaker FPGA ([Product Link](https://1bitsquared.com/products/icebreaker))
5. Nexys A7 ([Product Link](https://store.digilentinc.com/nexys-a7-fpga-trainer-board-recommended-for-ece-curriculum/))

[Start the course now!](./Course.md) ...well, not quite now... still a work-in-progress.

## Demos:
### 1. LED:
__Counter Demo:__  https://makerchip.com/sandbox/0mZf5hLPG/0y8h64Z#

__Output on Virtual Basys3 board:__ 

<img src="https://user-images.githubusercontent.com/64545984/130662713-a4831559-f909-4b1e-856d-6f736de6e4b5.gif" alt="Basys3_LED" width="600">

__Output on Virtual Edge Artix7 board:__ 

<img src="https://user-images.githubusercontent.com/64545984/130662812-ae1ea3b2-2ff2-40dd-bf99-9929980c9173.gif" alt="EDGE_Artix7_LED" width="600">

### 2. Seven Segment Display:
__Counter Demo:__  https://makerchip.com/sandbox/0mZf5hLPG/0zmh8rV

__Output on Virtual Basys3 board:__


<img src="https://user-images.githubusercontent.com/64545984/130662877-0aa08c7c-c8cc-4a93-b05e-1aab1850bf74.gif" alt="Basys3_7seg" width="600">


__Output on Virtual Edge Artix7 board:__

<img src="https://user-images.githubusercontent.com/64545984/130662897-a4d6751c-9699-4ba7-9616-26b58b2031cf.gif" alt="EDGE_Artix7_7seg" width="600">



## Run on FPGA:
### 1. LED:
__Output on Basys3 board:__

<img src="https://user-images.githubusercontent.com/64545984/130660764-bff7d357-cfb9-41b5-8e39-23cf214b5f4f.gif" alt="Basys3_LED" width="600">

__Output on Edge Artix7 board:__ 

<img src="https://user-images.githubusercontent.com/64545984/130660844-6949ce20-51c2-4435-931f-39f94b5f8d84.gif" alt="EDGE_Artix7_LED" width="600">

### 2. Seven Segment Display:
__Output on Basys3 board:__

<img src="https://user-images.githubusercontent.com/64545984/130660899-e51d4217-4e5b-401f-b543-08a4d829e369.gif" alt="Basys3_7seg" width="600">

__Output on Edge Artix7 board:__

<img src="https://user-images.githubusercontent.com/64545984/130660934-b51a670e-577e-4fc4-a0a6-a28db593af61.gif" alt="EDGE_Artix7_7seg" width="600">


## Credits

Course creators:
  - Steve Hoover, founder Redwood EDA, LLC
  - Mayank Kabra, student at the International Institute of Information Technology, Bangalore
  - Shivani Shah, student at the International Institute of Information Technology, Bangalore

Thanks also to [Bala Dhinesh](https://www.linkedin.com/in/bala-dhinesh/) for providing the [vitual lab environment](https://github.com/BalaDhinesh/Virtual-FPGA-Lab), with support from:

<p>
    <a href="https://redwoodeda.com"><img src="https://user-images.githubusercontent.com/11302288/130831451-1c3b1541-06f2-4c0e-bbaf-8e0026db00c1.png" alt="redwoodeda-logo" height="90"></a><span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
    <a href="https://summerofcode.withgoogle.com/"><img src="https://upload.wikimedia.org/wikipedia/commons/0/08/GSoC_logo.svg" alt="gsoc-logo" height="90"></a><span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
    <a href="https://fossi-foundation.org"><img src="https://www.fossi-foundation.org/assets/fossi_logo_large.png" alt="fossi-logo" height="90"></a><span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
    <a href="https://www.vlsisystemdesign.com/"><img src="https://user-images.githubusercontent.com/11302288/130832099-9648722e-d9f4-4dec-b8c9-69a558cbdc97.png" alt="vsd-logo" height="90"></a>
</p>
