import Cta from "@/demo/cta";
import DemoComponent from "@/demo/demo-component";
import PageHeader from "@/demo/page-header";
import type { Metadata } from "next";

export const metadata: Metadata = {
  title: "Dialog Components - Origin UI",
  description:
    "A collection of beautiful and accessible dialog components built with Tailwind CSS and Next.js.",
};

const directory = "dialogs";
const files = [
  "dialog-01",
  "dialog-02",
  "dialog-03",
  "dialog-04",
  "dialog-05",
  "dialog-06",
  "dialog-07",
  "dialog-08",
  "dialog-09",
  "dialog-10",
  "dialog-11",
  "dialog-12",
  "dialog-13",
  "dialog-14",
  "dialog-15",
  "dialog-16",
  "dialog-17",
  "dialog-18",
  "dialog-19",
  "dialog-20",
  "dialog-21",
];

export default function Page() {
  return (
    <main>
      <div className="px-4 sm:px-6">
        <div className="mx-auto w-full max-w-6xl">
          <PageHeader title="Dialog">
            A growing collection of {files.length} dialog components built with Next.js and
            TailwindCSS.
          </PageHeader>

          <div className="grid max-w-6xl grid-cols-1 overflow-hidden sm:grid-cols-2 lg:grid-cols-3 [&>*]:relative [&>*]:px-1 [&>*]:py-12 [&>*]:before:absolute [&>*]:before:bg-border/70 [&>*]:before:[block-size:100vh] [&>*]:before:[inline-size:1px] [&>*]:before:[inset-block-start:0] [&>*]:before:[inset-inline-start:-1px] [&>*]:after:absolute [&>*]:after:bg-border/70 [&>*]:after:[block-size:1px] [&>*]:after:[inline-size:100vw] [&>*]:after:[inset-block-start:-1px] [&>*]:after:[inset-inline-start:0] sm:[&>*]:px-8 xl:[&>*]:px-12">
            {files.map((componentName) => {
              return (
                <DemoComponent
                  key={componentName}
                  directory={directory}
                  componentName={componentName}
                  className="text-center"
                />
              );
            })}
          </div>

          <Cta />
        </div>
      </div>
    </main>
  );
}
