# Contributing

We welcome contributions to our project! Please follow these steps to contribute:

1. Fork the repository on GitHub.

2. Clone your forked repository to your local machine:

   ```
   git clone https://github.com/your-username/originui.git
   ```

3. Navigate to the project directory:

   ```
   cd originui
   ```

4. Create a new branch for your feature or bug fix:

   ```
   git checkout -b your-branch-name
   ```

5. Install the project dependencies:

   ```
   pnpm install
   ```

6. Make your changes to the codebase.

7. Before building, format your code:

   ```
   pnpm run format
   ```

8. Build the project:

   ```
   pnpm run build
   ```

9. Test the application to ensure your changes work as expected.

10. Commit your changes:

    ```
    git commit -m "Your descriptive commit message"
    ```

11. Push your changes to your fork:

    ```
    git push origin your-branch-name
    ```

12. Open a pull request on the original repository.

Thank you for contributing to our project!
