/*
 * Copyright The OpenZipkin Authors
 * SPDX-License-Identifier: Apache-2.0
 */
package brave.vertx.web;

import brave.Tracing;
import brave.http.HttpTracing;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;

public final class VertxWebTracing {
  public static VertxWebTracing create(Tracing tracing) {
    return new VertxWebTracing(HttpTracing.create(tracing));
  }

  public static VertxWebTracing create(HttpTracing httpTracing) {
    return new VertxWebTracing(httpTracing);
  }

  final HttpTracing httpTracing;

  VertxWebTracing(HttpTracing httpTracing) { // intentionally hidden constructor
    if (httpTracing == null) throw new NullPointerException("httpTracing == null");
    this.httpTracing = httpTracing;
  }

  /**
   * Returns a routing context handler that traces {@link HttpServerRequest} messages.
   *
   * <p>Ensure you install this both as a handler and an failure handler, ordered before routes.
   * <pre>{@code
   * routingContextHandler = vertxWebTracing.routingContextHandler();
   * router.route()
   *       .order(-1) // applies before routes
   *       .handler(routingContextHandler)
   *       .failureHandler(routingContextHandler);
   * }</pre>
   */
  public Handler<RoutingContext> routingContextHandler() {
    return new TracingRoutingContextHandler(httpTracing);
  }
}
