/*
 * Copyright The OpenZipkin Authors
 * SPDX-License-Identifier: Apache-2.0
 */
package brave.jersey.server;

import brave.jersey.server.TracingApplicationEventListener.ContainerRequestWrapper;
import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.internal.monitoring.RequestEventImpl;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.uri.PathTemplate;
import org.jboss.resteasy.core.ServerResponse;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@Measurement(iterations = 5, time = 1)
@Warmup(iterations = 10, time = 1)
@Fork(3)
@BenchmarkMode(Mode.Throughput)
@OutputTimeUnit(TimeUnit.MICROSECONDS)
@State(Scope.Thread)
public class TracingApplicationEventListenerAdapterBenchmarks {
  FakeExtendedUriInfo uriInfo = new FakeExtendedUriInfo(URI.create("/"),
    Arrays.asList(
      new PathTemplate("/"),
      new PathTemplate("/items/{itemId}")
    )
  );
  ContainerRequest request = new ContainerRequest(
    URI.create("/"), null, null, null, new MapPropertiesDelegate()
  ) {
    @Override public ExtendedUriInfo getUriInfo() {
      return uriInfo;
    }
  };
  RequestEvent event = new RequestEventImpl.Builder()
    .setContainerRequest(request)
    .setContainerResponse(new ContainerResponse(request, new ServerResponse()))
    .build(RequestEvent.Type.FINISHED);

  FakeExtendedUriInfo nestedUriInfo = new FakeExtendedUriInfo(URI.create("/"),
    Arrays.asList(
      new PathTemplate("/"),
      new PathTemplate("/items/{itemId}"),
      new PathTemplate("/"),
      new PathTemplate("/nested")
    )
  );
  ContainerRequest nestedRequest = new ContainerRequest(
    URI.create("/"), null, null, null, new MapPropertiesDelegate()
  ) {
    @Override public ExtendedUriInfo getUriInfo() {
      return nestedUriInfo;
    }
  };

  @Benchmark public String parseRoute() {
    return new ContainerRequestWrapper(nestedRequest).route();
  }

  @Benchmark public String parseRoute_nested() {
    return new ContainerRequestWrapper(nestedRequest).route();
  }

  // Convenience main entry-point
  public static void main(String[] args) throws RunnerException {
    Options opt = new OptionsBuilder()
      .include(".*" + TracingApplicationEventListenerAdapterBenchmarks.class.getSimpleName())
      .build();

    new Runner(opt).run();
  }
}
