# Contributing to Zipkin

If you would like to contribute code, fork this GitHub repository and
send a pull request (on a branch other than `master` or `gh-pages`).

When submitting code, please apply [Square Code Style](https://github.com/square/java-code-styles).
* If the settings import correctly, CodeStyle/Java will be named Square and use 2 space tab and indent, with 4 space continuation indent.

You may also want to configure your IDE to perform `null` analysis using Brave's
source retention annotation `brave.internal.Nullable`. For example, in IntelliJ,
search for "Nullable" under "Inspections". Click "Configure Annotations", then
add `brave.internal.Nullable` as a "Nullable Annotation".

## License

By contributing your code, you agree to license your contribution under
the terms of the [APLv2](../LICENSE).

All files are released with the Apache 2.0 license.

If you are adding a new file it should have a header like below. This
can be automatically added by running `./mvnw com.mycila:license-maven-plugin:format`.

```
/*
 * Copyright The OpenZipkin Authors
 * SPDX-License-Identifier: Apache-2.0
 */
 ```
