<?php

declare(strict_types=1);

namespace app\repositories;

use app\models\AdOffer;
use app\models\AdSearch;
use yii\web\NotFoundHttpException;

class AdSearchRepository
{
    public function findAdSearchByIdAndCurrentUser(int $id): AdSearch
    {
        if (
            $model = AdSearch::find()
            ->where(['id' => $id])
            ->userOwner()
            ->one()
        ) {
            return $model;
        }

        throw new NotFoundHttpException('Requested Page Not Found');
    }

    public function findMatchedAdSearchByIdAndAdOrder(int $id, AdOffer $adOffer): AdSearch
    {
        if ($adSearch = $adOffer->getMatchModels()->where(['id' => $id])->one()) {
            return $adSearch;
        }

        throw new NotFoundHttpException('Requested Page Not Found');
    }
}
