---
layout: post
title:  "Semina Verbi: an online encylopedia of the influence of the Gospel on human culture"
date:   2020-10-12 15:56:00 +0200
categories: [bible, evangelization, culture]
author: JohnRDOrazio
comments: true
---

## Open knowledge

Reading up on some of the past posts in this community, I see there have been a number of posts about open access to information, 
in particular (in this context) as regards the Catholic faith. Access to the biblical texts, access to the Catechism and magisterial documents...
When a project is open source, it has a good possibility of surviving over time if it is able to create a community, 
because it remains accessible to the community even when the original people behind the project might not be able to continue developing the project.

Bringing knowledge to the masses was and is the big hope of Wikipedia, which has become a cultural phenomenon in it's own right.
"Jimbo" Wales and others with him made a big wager when they started the wikipedia project: they trusted the community in making knowledge available to the community.
This model has a number of drawbacks, because it is easy for a lot of personal opinion rather than true scientific knowledge to be disseminated through such a platform.
And thus the need for an organized community, with internal politics, so as to handle abuse of the platform.
And yet, with all the limits and drawbacks of this open model and community effort, the project has come quite a ways, 
and you can effectively find a lot of useful information which is readily indexed by search engines. 
Nowadays, almost any question you might have, if you type it into a search engine, you are almost guaranteed to get some result from wikipedia.

Seeing how it is something we do have to take into account, becoming a tool that people are starting to use in their daily lives, 
even though the quality of the contents cannot always be guaranteed, and seeing that the software that this platform is built on (MediaWiki) is also Open Source software
released to the community so as to be able to make other similar wiki style encyclopedias, I've been thinking over the past decade or so that it would be useful,
as Catholics, to not only contribute to Wikipedia in a scientific manner so as to contribute to the quality level of the contents,
but also to use these same platforms to build open knowledge encyclopedias about christianity.

There are some very useful treasure troves of information out there already using this line of reasoning, such as [Cathopedia](https://www.cathopedia.org/wiki/Main_Page), 
which has lots of information about theological topics and about church history and about the Catholic church today. Quite a praiseworthy initiative, with a lot of potential,
which can still use a lot of community contribution to make it the useful tool that it aspires to be.

But other than an encyclopedia about Catholicism in general, over the past few years I've had in mind a project that would bring to light the way in which the Gospel 
(and the Word of God in general) has influenced human culture, human creativity and expression in the arts. More of a cultural project than a theological project,
and yet a Catholic project nonetheless. This dialogue between faith and human expression is present in Saint Paul when he preaches in the Areopagus of Athens, 
it was the great effort of Saint Justin who coined the term "Seeds of the Word" in trying to translate the Gospel message into the language of greek philosophy
thus creating the foundations of Catholic philosophy. Saint Justin considered those elements of truth found in human culture to be a "seed of the Word", 
planted by God as Creator in human culture even if those humans didn't know God or His Word. The approach of Saint Justin is that of a very positive approach to human culture
and expression, and was a big encouragement in expressing the message of the Gospel through the means of human culture and expression.

## Seeds of the Word

Over the centuries, how much artwork, music, philosophy, literature has been inspired by the message of the Gospel. And other than direct inspiration, 
we can still think in the same terms as Saint Justin, of those expressions of humanity that even without knowing God or having any intent of evangelizing,
may yet contain seeds of truth that are reflections of the Gospel message. Wouldn't it be wonderful to bring all of this to light, in a wiki style encylopedia?

Once you start digging, there's a whole universe of information out there along these lines. And yet, it would be very useful to bring it to light, 
to help people see that christianity is not just some niche in society, and christians are not a minority of people who should be ashamed of who they are and what they think.
Christianity, or more specifically the message of the Gospel, helps society to become more human and humane! It brings out the best of beauty that mankind has to offer.

I don't want to get lost in too many words now, I'll get right to the point: I have set out to undertake such a project, 
and after experimenting a few times with the MediaWiki platform in the past few years, I believe I have finally succeeded in running a stable instance.
So the [Semina Verbi wiki](https://seminaverbi.bibleget.io/) is born and is open to community collaboration, in an orderly fashion.
In an orderly fashion means that it is not open to the general public, so as to avoid spam and abuse. It is sufficient to request access, 
and if the necessary Catholic and scientific qualities of the person requesting access can be verified, community collaboration is more than welcome.

As a proof of concept of how I envision the project, I have started creating the following pages, which are obviously open to contributions by approved editors:

**ENGLISH**
* [Main Page](https://en.seminaverbi.bibleget.io/wiki/Main_Page)
* [Daredevil (TV series)](https://en.seminaverbi.bibleget.io/wiki/Daredevil_(TV_series))
* [Fringe (TV series)](https://en.seminaverbi.bibleget.io/wiki/Fringe_(TV_series))
* [Pyotr Ilyich Tchaikovsky](https://en.seminaverbi.bibleget.io/wiki/Pyotr_Ilyich_Tchaikovsky)

**ITALIAN**
* [Pagina Principale](https://it.seminaverbi.bibleget.io/wiki/Pagina_principale)
* [Il Signore degli Anelli](https://it.seminaverbi.bibleget.io/wiki/Il_Signore_degli_Anelli)
* [Daredevil (serie televisiva)](https://it.seminaverbi.bibleget.io/wiki/Daredevil_(serie_televisiva))
* [Dark (serie televisiva)](https://it.seminaverbi.bibleget.io/wiki/Dark_(serie_televisiva))
* [La vita è meravigliosa](https://it.seminaverbi.bibleget.io/wiki/La_vita_%C3%A8_meravigliosa)
* [Matrix (trilogia)](https://it.seminaverbi.bibleget.io/wiki/Matrix_(trilogia))
* [Il Miglio Verde (film)](https://it.seminaverbi.bibleget.io/wiki/Il_Miglio_Verde_(film))
* [Harry Potter](https://it.seminaverbi.bibleget.io/wiki/Harry_Potter)
* [Pinocchio](https://it.seminaverbi.bibleget.io/wiki/Pinocchio)

Anyone who is available to contribute, let me know, let's build this community together!
