---
layout: post
title: 5 Things Every Parish Website Should Have in 2015
author: nobis-media
nid: 487
comments: true
redirect_from: /blog/conoon-kim/5-things-every-parish/
created: 1430428261
---
Every year it's important to assess your website to understand things that work and don't work. With Easter season's arrival, now is the perfect time to renew your website for some "spring cleaning."

In this article, we will go over 5 things every parish website should have this year in 2015. We've prepared this as a checklist that includes a combination of website tools, content suggestions, and general functions. Before we begin, it's important for you to treat this guide as a way to enhance a well-founded Catholic church website. If your parish has a website that looks like it's from the 90's, this guide won't help as there's no substitute for sub-par quality.

And so we begin!

## 1. Mass Times

Some people might find this obvious, but we've personally experienced and went through too many Catholic websites that fail to easily and accurately provide the #1 most sought-after information: mass times.

The bottom line is that the most popular reason someone visits a Catholic church website is to find out what time mass is provided at your parish. So why make that an obstacle for your website visitors? Having correct mass times and other service times listed visibly on the homepage can be one of the most effective thing you can do to improve the usability of your church website. Give the people what they want!

One good example of a parish website doing this right is the Church of the Good Shepherd in Los Angeles. When you arrive on their homepage, you can clearly find their mass times listed under the "Join Us This Weekend" box to the right, along with a link underneath to their full schedule of services. It's a simple thing to feature on your church website that often gets overlooked.

## 2. Mobile-Friendly

Did you know that about 51% of the world's population uses a mobile device? If half the people nowadays are checking websites from their phone or tablet, it's a necessity to make your website mobile-friendly. In addition, this year Google announced they will incorporate mobile-friendliness into their algorithms. If you're website isn't mobile-friendly by April 21, chances are your website won't even show up in the search results for someone using a mobile device. That leaves your parish website in the dust.

If you want to check if your website is mobile-friendly, click here to use a tool created by Google.

## 3. Image Gallery

Show some personality! With websites trending to be more visual and less wordy, maintaining an updated image gallery will significantly enhance the browsing experience. It also gives a nice inside look to the type of community involved at your church. This is important for building your parish "brand," showing the great people of your congregation, and attaching a "face" to your mission.

A church is like a home, and anyone searching for a new home would want to see how it looks before buying. Having photos of the chapel, recreation centers, ministry leaders, youth activities, church-wide functions, and special events are just some of the many areas you can showcase for your parish.

Fortunately, it's easy to install an image gallery into your website. There are tons of image gallery platforms that you can use to integrate into your website. With a platform like Instagram, it's a dual benefit because it allows you to build an image gallery while also gaining the benefits of social media. If you have a website built on a CMS (Content Management System) such as Wordpress, it's as easy as installing a plugin like "Instagram Feed."

## 4. Easy Donations

Let's face it, when it comes to asking for donations it's often met with resistance, inconvenience, and neglect. But it's a necessary aspect of our Catholic Church as we are built on people's charity. So imagine trying to get someone to make a donation to your church using a complicated system that is neither intuitive nor user-friendly.

Having an easy-to-use donation platform will take away one less barrier from receiving donations. To recommend some tools, here are a few that we came across:

  - PayPal Donations: A well-known platform used by many churches around the world, PayPal has a trusting company image that won't scare away your potential donors. It's also very easy-to-use and donors don't have to register for an account to send money.
  - Google Checkout: Through a program called Google Grant, nonprofits can use the Google Checkout system entirely for free since all fees are waived. Yup, that means you pay absolutely nothing to accept donations. The only drawback is that donors must be registered with a Google account to send money.
  - Network for Good: They offer a more robust platform specifically designed for nonprofits. You can create event pages, integrate different payment methods, organize online fundraisers, and even manage monthly recurring donations. With no set-up costs or monthly fees, they are also very affordable as you pay just the transaction price.

## 5. Social Media Integration

Social media has become a huge aspect of our lives today, especially if you own a mobile device. As the smartphone becomes better, social media becomes more accessible.

Good communication is key to building good relationships. When you have social media integrated into your website, it shows that your church is serious about expanding in the digital medium. More importantly, social media integration shows that you care about maintaining open dialogue with your parishioners outside the church every day of the week.

Facebook, Twitter, and Instagram are the most popular platforms used today. If you don't have accounts created for your parish already, it's time to get started now. Once you have your social media profiles setup, the most basic integration you can do is placing the profile links on your website. This will eventually lead your users to following your respective pages, and then joining the conversation. Social media can be used as an important part of online evangelization when used correctly. It has the power to reach an audience that we've never thought imaginable. Now that the future is here, we shouldn't fall behind.

We understand that it can be difficult to make any improvements to your website with the lack of manpower—that's why we're here to help. If you need help getting any of the above-mentioned features onto your website, click here to use our contact form to send us a message at any time and we'll respond within a day. We will provide you with a free consultation, review, and recommendation on how to improve your parish website.

So how ready is your Catholic church website for 2015? Let us know in the comments below. How many things can you check off?
